/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.ifelse.Operand;
import org.jboss.as.cli.handlers.ifelse.Operation;

abstract class BaseOperation
implements Operation,
Comparable<Operation> {
    private BaseOperation parent;
    private final String name;
    private final int priority;
    private final List<Operand> operands;

    BaseOperation(String name, int priority) {
        if (name == null) {
            throw new IllegalArgumentException("name is null.");
        }
        this.name = name;
        this.priority = priority;
        this.operands = new ArrayList<Operand>();
    }

    void setParent(BaseOperation parent) {
        this.parent = parent;
    }

    BaseOperation getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<Operand> getOperands() {
        return this.operands;
    }

    public boolean allowsMoreArguments() {
        return this.operands.size() < 2;
    }

    void addOperand(Operand operand) throws CommandLineException {
        if (operand == null) {
            throw new IllegalArgumentException("operand can't be null.");
        }
        this.operands.add(operand);
    }

    Operand getLastOperand() {
        return this.operands.size() < 2 ? null : this.operands.get(this.operands.size() - 1);
    }

    void replaceLastOperand(Operand operand) throws CommandLineException {
        if (this.operands.size() < 2) {
            this.addOperand(operand);
        } else {
            this.operands.set(this.operands.size() - 1, operand);
        }
    }

    @Override
    public int compareTo(Operation o) {
        if (o == null) {
            throw new IllegalArgumentException("can't compare to null.");
        }
        return this.priority < o.getPriority() ? -1 : (this.priority > o.getPriority() ? 1 : 0);
    }

    public String toString() {
        return '(' + this.name + ' ' + this.operands + ')';
    }
}

