/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.Cursor;
import java.io.IOException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class CommandExecutor {
    private CliGuiContext cliGuiCtx;
    private ModelControllerClient client;
    private CommandContext cmdCtx;

    public CommandExecutor(CliGuiContext cliGuiCtx) {
        this.cliGuiCtx = cliGuiCtx;
        this.cmdCtx = cliGuiCtx.getCommmandContext();
        this.client = this.cmdCtx.getModelControllerClient();
        Runtime.getRuntime().addShutdownHook(new Thread(new ClientCloserShutdownHook()));
    }

    public synchronized ModelNode doCommand(String command) throws CommandFormatException, IOException {
        ModelNode request = this.cmdCtx.buildRequest(command);
        return this.execute(command, request);
    }

    public synchronized Response doCommandFullResponse(String command) throws CommandFormatException, IOException {
        ModelNode request = this.cmdCtx.buildRequest(command);
        ModelNode response = this.execute(command, request);
        return new Response(command, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelNode execute(String command, ModelNode request) throws IOException {
        try {
            if (this.isSlowCommand(command)) {
                this.cliGuiCtx.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            }
            ModelNode modelNode = this.client.execute(request);
            return modelNode;
        }
        finally {
            if (this.isSlowCommand(command)) {
                this.cliGuiCtx.getMainWindow().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private boolean isSlowCommand(String command) {
        return command.startsWith("deploy") || command.startsWith("/subsystem=logging/:read-log-file");
    }

    public static class Response {
        private String command;
        private ModelNode dmrRequest;
        private ModelNode dmrResponse;

        Response(String command, ModelNode dmrRequest, ModelNode dmrResponse) {
            this.command = command;
            this.dmrRequest = dmrRequest;
            this.dmrResponse = dmrResponse;
        }

        public String getCommand() {
            return this.command;
        }

        public ModelNode getDmrRequest() {
            return this.dmrRequest;
        }

        public ModelNode getDmrResponse() {
            return this.dmrResponse;
        }
    }

    private class ClientCloserShutdownHook
    implements Runnable {
        private ClientCloserShutdownHook() {
        }

        @Override
        public void run() {
            try {
                CommandExecutor.this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

