/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.EnterStateCharacterHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.arguments.ArgumentValueCallbackHandler;
import org.jboss.as.cli.parsing.arguments.ArgumentValueInitialState;
import org.jboss.as.cli.parsing.arguments.ArgumentValueState;
import org.jboss.as.cli.parsing.arguments.ListState;
import org.jboss.as.cli.parsing.arguments.NonObjectArgumentValueState;
import org.jboss.dmr.ModelNode;

public interface ArgumentValueConverter {
    public static final ArgumentValueConverter DEFAULT = new ArgumentValueConverter(){

        @Override
        public ModelNode fromString(CommandContext ctx, String value) throws CommandFormatException {
            if (value == null) {
                return new ModelNode();
            }
            if (ctx.isResolveParameterValues()) {
                value = Util.resolveProperties(value);
            }
            ModelNode toSet = null;
            try {
                toSet = ModelNode.fromString((String)value);
            }
            catch (Exception e) {
                ArgumentValueCallbackHandler handler = new ArgumentValueCallbackHandler();
                StateParser.parse(value, handler, ArgumentValueInitialState.INSTANCE);
                toSet = handler.getResult();
            }
            return toSet;
        }
    };
    public static final ArgumentValueConverter NON_OBJECT = new DMRWithFallbackConverter(){
        final DefaultParsingState initialState = new DefaultParsingState("IE"){
            {
                this.setDefaultHandler(new EnterStateCharacterHandler(NonObjectArgumentValueState.INSTANCE));
            }
        };

        @Override
        protected ModelNode fromNonDMRString(CommandContext ctx, String value) throws CommandFormatException {
            ArgumentValueCallbackHandler handler = new ArgumentValueCallbackHandler();
            StateParser.parse(value, handler, this.initialState);
            return handler.getResult();
        }
    };
    public static final ArgumentValueConverter LIST = new DMRWithFallbackConverter(){
        final DefaultParsingState initialState = new DefaultParsingState("IL"){
            {
                this.setDefaultHandler(new EnterStateCharacterHandler(new ListState(new ArgumentValueState())));
            }
        };

        @Override
        protected ModelNode fromNonDMRString(CommandContext ctx, String value) throws CommandFormatException {
            ArgumentValueCallbackHandler handler = new ArgumentValueCallbackHandler();
            StateParser.parse(value, handler, this.initialState);
            return handler.getResult();
        }
    };
    public static final ArgumentValueConverter PROPERTIES = new DMRWithFallbackConverter(){
        final DefaultParsingState initialState = new DefaultParsingState("IPL"){
            {
                this.setDefaultHandler(new EnterStateCharacterHandler(new ListState(new ArgumentValueState())));
            }
        };

        @Override
        protected ModelNode fromNonDMRString(CommandContext ctx, String value) throws CommandFormatException {
            ArgumentValueCallbackHandler handler = new ArgumentValueCallbackHandler();
            StateParser.parse(value, handler, this.initialState);
            return handler.getResult();
        }
    };

    public ModelNode fromString(CommandContext var1, String var2) throws CommandFormatException;

    public static abstract class DMRWithFallbackConverter
    implements ArgumentValueConverter {
        @Override
        public ModelNode fromString(CommandContext ctx, String value) throws CommandFormatException {
            if (value == null) {
                return new ModelNode();
            }
            if (ctx.isResolveParameterValues()) {
                value = Util.resolveProperties(value);
            }
            try {
                return ModelNode.fromString((String)value);
            }
            catch (Exception e) {
                return this.fromNonDMRString(ctx, value);
            }
        }

        protected abstract ModelNode fromNonDMRString(CommandContext var1, String var2) throws CommandFormatException;
    }
}

