/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common;

import org.jetbrains.annotations.NotNull;
import org.wildfly.common.CommonMessages;

public final class Assert {
    private Assert() {
    }

    @NotNull
    public static <T> T checkNotNullParam(String name, T value) throws IllegalArgumentException {
        if (value == null) {
            throw CommonMessages.msg.nullParam(name);
        }
        return value;
    }

    @NotNull
    public static <T> T assertNotNull(T value) {
        assert (value != null) : CommonMessages.msg.unexpectedNullValue();
        return value;
    }

    @NotNull
    public static <T> T assertHoldsLock(@NotNull T monitor) {
        assert (Thread.holdsLock(Assert.checkNotNullParam("monitor", monitor))) : CommonMessages.msg.expectedLockHold(monitor);
        return monitor;
    }

    @NotNull
    public static <T> T assertNotHoldsLock(@NotNull T monitor) {
        assert (!Thread.holdsLock(monitor)) : CommonMessages.msg.expectedLockNotHold(monitor);
        return monitor;
    }

    public static IllegalStateException unreachableCode() {
        return CommonMessages.msg.unreachableCode();
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(@NotNull Object obj) {
        return CommonMessages.msg.impossibleSwitchCase(obj);
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(int val) {
        return CommonMessages.msg.impossibleSwitchCase(val);
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(long val) {
        return CommonMessages.msg.impossibleSwitchCase(val);
    }
}

