/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning.model;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.build.common.model.ConfigFileOverride;
import org.wildfly.build.common.model.ConfigOverride;
import org.wildfly.build.common.model.CopyArtifactsModelParser10;
import org.wildfly.build.common.model.FileFilterModelParser10;
import org.wildfly.build.configassembly.SubsystemConfig;
import org.wildfly.build.configassembly.SubsystemsParser;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.provisioning.model.Attribute;
import org.wildfly.build.provisioning.model.Element;
import org.wildfly.build.provisioning.model.ModuleFilter;
import org.wildfly.build.provisioning.model.ServerProvisioningDescription;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.MapPropertyResolver;
import org.wildfly.build.util.PropertyResolver;
import org.wildfly.build.util.xml.ParsingUtils;

class ServerProvisioningDescriptionModelParser10
implements XMLElementReader<ServerProvisioningDescription> {
    public static final String NAMESPACE_1_0 = "urn:wildfly:server-provisioning:1.0";
    final BuildPropertyReplacer propertyReplacer;
    final CopyArtifactsModelParser10 copyArtifactsModelParser;
    private final FileFilterModelParser10 fileFilterModelParser;

    ServerProvisioningDescriptionModelParser10(PropertyResolver resolver) {
        this.propertyReplacer = new BuildPropertyReplacer(resolver);
        this.fileFilterModelParser = new FileFilterModelParser10(this.propertyReplacer);
        this.copyArtifactsModelParser = new CopyArtifactsModelParser10(this.propertyReplacer, this.fileFilterModelParser);
    }

    public void readElement(XMLExtendedStreamReader reader, ServerProvisioningDescription result) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case COPY_MODULE_ARTIFACTS: {
                    result.setCopyModuleArtifacts(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block13;
                }
                case EXTRACT_SCHEMAS: {
                    result.setExtractSchemas(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block13;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case FEATURE_PACKS: {
                            this.parseFeaturePacks((XMLStreamReader)reader, result);
                            continue block14;
                        }
                        case VERSION_OVERRIDES: {
                            this.parseVersionOverrides((XMLStreamReader)reader, result);
                            continue block14;
                        }
                        case COPY_ARTIFACTS: {
                            this.copyArtifactsModelParser.parseCopyArtifacts((XMLStreamReader)reader, result.getCopyArtifacts());
                            continue block14;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    protected void parseFeaturePacks(XMLStreamReader reader, ServerProvisioningDescription result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case FEATURE_PACK: {
                            this.parseFeaturePack(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseFeaturePack(XMLStreamReader reader, ServerProvisioningDescription result) throws XMLStreamException {
        Artifact artifact = this.parseArtifact(reader, "zip", false);
        ServerProvisioningDescription.FeaturePack.ModuleFilters moduleFilters = null;
        ConfigOverride config = null;
        ServerProvisioningDescription.FeaturePack.ContentFilters contentFilters = null;
        ArrayList<ServerProvisioningDescription.FeaturePack.Subsystem> subsystems = null;
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    result.getFeaturePacks().add(new ServerProvisioningDescription.FeaturePack(artifact, moduleFilters, config, contentFilters, subsystems));
                    result.getVersionOverrides().add(artifact);
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case MODULES: {
                            moduleFilters = this.parseModules(reader);
                            continue block10;
                        }
                        case CONFIG: {
                            if (subsystems != null) {
                                throw new XMLStreamException("server provisioning xml specifies a feature pack filtered by config and subsystems");
                            }
                            config = new ConfigOverride();
                            this.parseConfig(reader, config);
                            continue block10;
                        }
                        case CONTENTS: {
                            contentFilters = this.parseContents(reader);
                            continue block10;
                        }
                        case SUBSYSTEMS: {
                            if (config != null) {
                                throw new XMLStreamException("server provisioning xml specifies a feature pack filtered by config and subsystems");
                            }
                            subsystems = new ArrayList<ServerProvisioningDescription.FeaturePack.Subsystem>();
                            this.parseSubsystems(reader, subsystems);
                            continue block10;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private ServerProvisioningDescription.FeaturePack.ContentFilters parseContents(XMLStreamReader reader) throws XMLStreamException {
        boolean include = true;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case INCLUDE: {
                    include = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        ServerProvisioningDescription.FeaturePack.ContentFilters result = new ServerProvisioningDescription.FeaturePack.ContentFilters(include);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return result;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case FILTER: {
                            this.fileFilterModelParser.parseFilter(reader, result.getFilters());
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private ServerProvisioningDescription.FeaturePack.ModuleFilters parseModules(XMLStreamReader reader) throws XMLStreamException {
        boolean include = true;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case INCLUDE: {
                    include = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        ServerProvisioningDescription.FeaturePack.ModuleFilters result = new ServerProvisioningDescription.FeaturePack.ModuleFilters(include);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return result;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case FILTER: {
                            this.parseModuleFilter(reader, result.getFilters());
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseModuleFilter(XMLStreamReader reader, List<ModuleFilter> result) throws XMLStreamException {
        String pattern = null;
        boolean include = false;
        boolean transitive = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN, Attribute.INCLUDE);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    pattern = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block5;
                }
                case INCLUDE: {
                    include = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block5;
                }
                case TRANSITIVE: {
                    transitive = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block5;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent(reader);
        result.add(new ModuleFilter(pattern, include, transitive));
    }

    public void parseConfig(XMLStreamReader reader, ConfigOverride result) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case STANDALONE: {
                            this.parseConfigFile(reader, result.getStandaloneConfigFiles());
                            continue block8;
                        }
                        case DOMAIN: {
                            this.parseConfigFile(reader, result.getDomainConfigFiles());
                            continue block8;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseConfigFile(XMLStreamReader reader, Map<String, ConfigFileOverride> result) throws XMLStreamException {
        boolean useTemplate = false;
        String outputFile = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.OUTPUT_FILE);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case USE_TEMPLATE: {
                    useTemplate = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block12;
                }
                case OUTPUT_FILE: {
                    outputFile = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        BuildPropertyReplacer subystemsParserPropertyReplacer = new BuildPropertyReplacer(new MapPropertyResolver(properties));
        HashMap<String, Map<String, SubsystemConfig>> subsystems = null;
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    result.put(outputFile, new ConfigFileOverride(properties, useTemplate, subsystems, outputFile));
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case PROPERTY: {
                            this.parseProperty(reader, properties);
                            continue block13;
                        }
                        case SUBSYSTEMS: {
                            if (subsystems == null) {
                                subsystems = new HashMap<String, Map<String, SubsystemConfig>>();
                            }
                            SubsystemsParser.parseSubsystems(reader, subystemsParserPropertyReplacer, subsystems);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseProperty(XMLStreamReader reader, Map<String, String> result) throws XMLStreamException {
        String name = null;
        String value = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                case VALUE: {
                    value = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent(reader);
        result.put(name, value);
    }

    private void parseSubsystems(XMLStreamReader reader, List<ServerProvisioningDescription.FeaturePack.Subsystem> result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case SUBSYSTEM: {
                            result.add(this.parseSubsystem(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private ServerProvisioningDescription.FeaturePack.Subsystem parseSubsystem(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        boolean transitive = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                case TRANSITIVE: {
                    transitive = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent(reader);
        return new ServerProvisioningDescription.FeaturePack.Subsystem(name, transitive);
    }

    protected void parseVersionOverrides(XMLStreamReader reader, ServerProvisioningDescription result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case VERSION_OVERRIDE: {
                            result.getVersionOverrides().add(this.parseArtifact(reader, null, true));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private Artifact parseArtifact(XMLStreamReader reader, String defaultExtension, boolean parseNoContent) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String artifact = null;
        String version = null;
        String groupId = null;
        String classifier = null;
        String extension = defaultExtension;
        EnumSet<Attribute> required = EnumSet.of(Attribute.ARTIFACT_ID, Attribute.VERSION, Attribute.GROUP_ID);
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case GROUP_ID: {
                    groupId = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case ARTIFACT_ID: {
                    artifact = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case VERSION: {
                    version = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case CLASSIFIER: {
                    classifier = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case EXTENSION: {
                    extension = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        if (parseNoContent) {
            ParsingUtils.parseNoContent(reader);
        }
        return new Artifact(groupId, artifact, classifier, extension, version);
    }
}

