/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.util;

import java.io.File;
import org.wildfly.build.util.PropertyResolver;

public class BuildPropertyReplacer {
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private static final int RESOLVED = 3;
    private static final int DEFAULT = 4;
    private final PropertyResolver properties;

    public BuildPropertyReplacer(PropertyResolver properties) {
        this.properties = properties;
    }

    public String replaceProperties(String value) {
        StringBuilder builder = new StringBuilder();
        int len = value.length();
        int state = 0;
        int start = -1;
        int nameStart = -1;
        int expressionStart = -1;
        String resolvedValue = null;
        int i = 0;
        while (i < len) {
            int ch = value.codePointAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case 36: {
                            state = 1;
                            break block0;
                        }
                    }
                    builder.appendCodePoint(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 36: {
                            builder.appendCodePoint(ch);
                            state = 0;
                            break block0;
                        }
                        case 123: {
                            expressionStart = nameStart = (start = i + 1);
                            state = 2;
                            break block0;
                        }
                    }
                    builder.append('$').appendCodePoint(ch);
                    state = 0;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 44: 
                        case 125: {
                            String name = value.substring(nameStart, i).trim();
                            if ("/".equals(name)) {
                                builder.append(File.separator);
                                state = ch == 125 ? 0 : 3;
                                break block0;
                            }
                            String val = this.properties.resolveProperty(name);
                            if (val != null) {
                                builder.append(val);
                                resolvedValue = val;
                                state = ch == 125 ? 0 : 3;
                                break block0;
                            }
                            if (ch == 44) {
                                nameStart = i + 1;
                                break block0;
                            }
                            throw new IllegalStateException("Failed to resolve expression: " + value.substring(start - 2, i + 1));
                        }
                    }
                    break;
                }
                case 3: {
                    if (ch != 125) break;
                    state = 0;
                    break;
                }
                case 4: {
                    if (ch != 125) break;
                    state = 0;
                    String val = this.properties.resolveProperty(value.substring(expressionStart, i));
                    if (val != null) {
                        builder.append(val);
                        break;
                    }
                    builder.append(value.substring(start, i));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected char seen: " + ch);
                }
            }
            i = value.offsetByCodePoints(i, 1);
        }
        switch (state) {
            case 1: {
                builder.append('$');
                break;
            }
            case 4: {
                builder.append(value.substring(start - 2));
                break;
            }
            case 2: {
                if (resolvedValue != null) break;
                throw new IllegalStateException("Incomplete expression: " + builder.toString());
            }
        }
        return builder.toString();
    }
}

