/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.build.AetherArtifactFileResolver;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.pack.model.DelegatingArtifactResolver;
import org.wildfly.build.pack.model.FeaturePackArtifactResolver;
import org.wildfly.build.plugin.MavenProjectArtifactResolver;
import org.wildfly.build.provisioning.ServerProvisioner;
import org.wildfly.build.provisioning.model.ServerProvisioningDescription;
import org.wildfly.build.provisioning.model.ServerProvisioningDescriptionModelParser;
import org.wildfly.build.util.MapPropertyResolver;
import org.wildfly.build.util.PropertiesBasedArtifactResolver;
import org.wildfly.build.util.PropertyResolver;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class ServerProvisioningMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(alias="config-file", defaultValue="server-provisioning.xml", property="wildfly.provision.configFile")
    private String configFile;
    @Parameter(alias="config-dir", defaultValue="${basedir}", property="wildfly.provision.configDir")
    private File configDir;
    @Parameter(alias="server-name", defaultValue="${project.build.finalName}", property="wildfly.provision.serverName")
    private String serverName;
    @Parameter(defaultValue="${project.build.directory}", property="wildfly.provision.buildName")
    private String buildName;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(alias="system-property-version-overrides", defaultValue="false", readonly=true)
    private Boolean systemPropertyVersionOverrides = false;
    @Parameter(alias="allow-maven-version-overrides", defaultValue="false", readonly=true)
    private Boolean allowMavenVersionOverrides = false;
    @Parameter(alias="overlay", defaultValue="false")
    private Boolean overlay = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try (FileInputStream configStream = new FileInputStream(new File(this.configDir, this.configFile));){
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.project.getModel().getProperties());
            properties.putAll((Map<?, ?>)this.project.getProperties());
            properties.putAll((Map<?, ?>)System.getProperties());
            properties.put("project.version", this.project.getVersion());
            ServerProvisioningDescription serverProvisioningDescription = new ServerProvisioningDescriptionModelParser((PropertyResolver)new MapPropertyResolver(properties)).parse((InputStream)configStream);
            AetherArtifactFileResolver aetherArtifactFileResolver = new AetherArtifactFileResolver(this.repoSystem, this.repoSession, this.remoteRepos);
            FeaturePackArtifactResolver overrideArtifactResolver = new FeaturePackArtifactResolver((Collection)serverProvisioningDescription.getVersionOverrides());
            if (this.allowMavenVersionOverrides.booleanValue()) {
                overrideArtifactResolver = new DelegatingArtifactResolver(new ArtifactResolver[]{new MavenProjectArtifactResolver(this.project), overrideArtifactResolver});
            }
            if (this.systemPropertyVersionOverrides.booleanValue()) {
                overrideArtifactResolver = new DelegatingArtifactResolver(new ArtifactResolver[]{new PropertiesBasedArtifactResolver(properties), overrideArtifactResolver});
            }
            ServerProvisioner.build((ServerProvisioningDescription)serverProvisioningDescription, (File)new File(this.buildName, this.serverName), (boolean)this.overlay, (ArtifactFileResolver)aetherArtifactFileResolver, (ArtifactResolver)overrideArtifactResolver);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

