/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet.request.mapper;

import org.apache.wicket.Application;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.core.request.mapper.IPageSource;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.info.PageInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;

public class MapperDelegate {
    protected IRequestHandler processHybrid(PageInfo pageInfo, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, Integer renderCount) {
        PageProvider provider = new PageProvider(pageInfo.getPageId(), pageClass, pageParameters, renderCount);
        Application application = Application.get();
        provider.setPageSource((IPageSource)application.getMapperContext());
        if (provider.isNewPageInstance() && !application.getPageSettings().getRecreateBookmarkablePagesAfterExpiry()) {
            throw new PageExpiredException(String.format("Bookmarkable page id '%d' class '%s' has expired.", pageInfo.getPageId(), pageClass.getName()));
        }
        return new RenderPageRequestHandler((IPageProvider)provider);
    }

    protected Url encodePageParameters(Url url, PageParameters pageParameters, IPageParametersEncoder encoder) {
        Url parametersUrl;
        Args.notNull((Object)url, (String)"url");
        Args.notNull((Object)encoder, (String)"encoder");
        if (pageParameters == null) {
            pageParameters = new PageParameters();
        }
        if ((parametersUrl = encoder.encodePageParameters(pageParameters)) != null) {
            url = new Url(url);
            for (String s : parametersUrl.getSegments()) {
                url.getSegments().add(s);
            }
            for (Url.QueryParameter p : parametersUrl.getQueryParameters()) {
                if (url.getQueryParameters().contains(p)) continue;
                url.getQueryParameters().add(p);
            }
        }
        return url;
    }
}

