/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.wicket.portlet.ResponseState;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketPortlet
extends GenericPortlet {
    private static final Pattern PROTECTED_RESOURCES = Pattern.compile("\\A\\s*[/\\\\]*\\s*(WEB|META)[-]INF(.*)", 10);
    private static final Pattern ABSOLUTE_URI_PATTERN = Pattern.compile("([a-z][a-z0-9]*://|/).*");
    private static final Logger LOG = LoggerFactory.getLogger(WicketPortlet.class);
    public static final String WICKET_URL_PORTLET_PARAMETER = "_wu";
    public static final String WICKET_FILTER_PATH_PARAM = "wicketFilterPath";
    public static final String RESPONSE_BUFFER_FOLDER_PARAM = "responseBufferFolder";
    public static final String CONFIG_PARAM_PREFIX = WicketPortlet.class.getName() + ".";
    public static final String RESPONSE_STATE_ATTR = ResponseState.class.getName();
    public static final String WICKET_PORTLET_PROPERTIES = WicketPortlet.class.getName().replace('.', '/') + ".properties";
    private String wicketFilterPath;
    private org.apache.wicket.util.file.File responseBufferFolder;
    private final HashMap<PageType, String> defaultPages = new HashMap();

    protected String buildWicketFilterPath(String filterPath) {
        if (filterPath == null || filterPath.length() == 0) {
            return "/";
        }
        if (!filterPath.startsWith("/")) {
            filterPath = "/" + filterPath;
        }
        if (filterPath.endsWith("*")) {
            filterPath = filterPath.substring(0, filterPath.length() - 1);
        }
        if (!filterPath.endsWith("/")) {
            filterPath = filterPath + "/";
        }
        return filterPath;
    }

    protected void doCustom(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, PageType.CUSTOM);
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, PageType.EDIT);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, PageType.HELP);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, PageType.VIEW);
    }

    protected String getDefaultPage(PageType pageType) {
        return this.defaultPages.get((Object)pageType);
    }

    protected Properties getWicketPortletProperties(Properties properties) throws PortletException {
        InputStream is;
        if (properties == null) {
            properties = new Properties();
        }
        if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(WICKET_PORTLET_PROPERTIES)) != null) {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                throw new PortletException("Failed to load WicketPortlet.properties from classpath", (Throwable)e);
            }
        }
        return properties;
    }

    protected String getWicketURL(PortletRequest request, PageType pageType, String defaultPage) {
        String wicketURL = null;
        if (request instanceof ActionRequest) {
            wicketURL = request.getParameter(WICKET_URL_PORTLET_PARAMETER);
        } else if (request instanceof ResourceRequest) {
            wicketURL = ((ResourceRequest)request).getResourceID();
        } else {
            String redirectUrlKey = WICKET_URL_PORTLET_PARAMETER + request.getPortletMode().toString();
            wicketURL = request.getParameter(redirectUrlKey);
        }
        if (wicketURL == null) {
            wicketURL = defaultPage;
        }
        return wicketURL;
    }

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.wicketFilterPath = this.buildWicketFilterPath(config.getInitParameter(WICKET_FILTER_PATH_PARAM));
        String responseBufferFolderPath = config.getInitParameter(RESPONSE_BUFFER_FOLDER_PARAM);
        if (responseBufferFolderPath != null && !Strings.isEmpty((CharSequence)responseBufferFolderPath)) {
            this.responseBufferFolder = new org.apache.wicket.util.file.File(responseBufferFolderPath);
        }
        for (PageType p : PageType.values()) {
            this.defaultPages.put(p, config.getInitParameter(p.initParameterName));
        }
        this.validateDefaultPages(this.defaultPages);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, PageType.ACTION);
    }

    protected void processActionResponseState(String wicketURL, PortletRequest request, ActionResponse response, ResponseState responseState) throws PortletException, IOException {
        responseState.flushAndClose();
        String redirectLocationUrl = responseState.getRedirectLocation();
        if (LOG.isDebugEnabled()) {
            LOG.debug("redirectURL after include:" + redirectLocationUrl);
        }
        if (redirectLocationUrl != null && !redirectLocationUrl.isEmpty()) {
            if ((redirectLocationUrl = this.fixWicketUrl(wicketURL, redirectLocationUrl, request.getScheme())).startsWith(this.wicketFilterPath)) {
                String portletMode = request.getPortletMode().toString();
                String redirectUrlKey = WICKET_URL_PORTLET_PARAMETER + portletMode;
                response.setRenderParameter(redirectUrlKey, redirectLocationUrl);
            } else {
                response.sendRedirect(redirectLocationUrl);
            }
        }
    }

    private void processMimeResponseRequest(String wicketURL, PortletRequest request, MimeResponse response, ResponseState responseState) throws PortletException, IOException {
        PortletRequestDispatcher rd = null;
        String previousURL = null;
        while ((rd = this.getPortletContext().getRequestDispatcher(wicketURL)) != null) {
            rd.include(request, (PortletResponse)response);
            String redirectLocation = responseState.getRedirectLocation();
            String ajaxRedirectLocation = responseState.getAjaxRedirectLocation();
            if (ajaxRedirectLocation != null) {
                responseState.clear();
                responseState.setDateHeader("Date", System.currentTimeMillis());
                responseState.setDateHeader("Expires", 0L);
                responseState.setHeader("Pragma", "no-cache");
                responseState.setHeader("Cache-Control", "no-cache, no-store");
                responseState.setHeader("Ajax-Location", ajaxRedirectLocation);
                responseState.setContentType("text/xml;charset=UTF-8");
                responseState.getWriter().write("<ajax-response><redirect><![CDATA[" + ajaxRedirectLocation + "]]></redirect></ajax-response>");
                responseState.flushAndClose();
                break;
            }
            if (redirectLocation != null) {
                boolean validWicketUrl = redirectLocation.startsWith(this.wicketFilterPath);
                if (validWicketUrl) {
                    if (previousURL == null || previousURL != redirectLocation) {
                        previousURL = wicketURL;
                        wicketURL = redirectLocation;
                        response.reset();
                        responseState.clear();
                        continue;
                    }
                    responseState.clear();
                    break;
                }
                responseState.clear();
                if (responseState.isResourceResponse()) {
                    response.setProperty("portlet.http-status-code", Integer.toString(302));
                    response.setProperty("Location", redirectLocation);
                    break;
                }
                response.reset();
                response.setProperty("expiration-cache", "0");
                PrintWriter writer = response.getWriter();
                writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                writer.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
                writer.append("<html><head><meta http-equiv=\"refresh\" content=\"0; url=").append(redirectLocation).append("\"/></head></html>");
                writer.close();
                break;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("ajax redirect url after inclusion:" + redirectLocation);
            }
            responseState.flushAndClose();
            break;
        }
    }

    protected void processRequest(PortletRequest request, PortletResponse response, PageType pageType) throws PortletException, IOException {
        String wicketURL = null;
        wicketURL = this.getWicketURL(request, pageType, this.getDefaultPage(pageType));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Portlet \"" + request.getAttribute("javax.portlet.lifecycle_phase") + "\" for wicket url:" + wicketURL);
        }
        ResponseState responseState = new ResponseState(request, response, (File)this.responseBufferFolder);
        request.setAttribute(RESPONSE_STATE_ATTR, (Object)responseState);
        if (responseState.isActionResponse()) {
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(wicketURL);
            if (rd != null) {
                rd.include(request, response);
                LOG.debug("wicket filter inclusion complete");
                this.processActionResponseState(wicketURL, request, (ActionResponse)response, responseState);
            }
        } else if (responseState.isMimeResponse()) {
            this.processMimeResponseRequest(wicketURL, request, (MimeResponse)response, responseState);
        } else {
            LOG.warn("Unsupported Portlet lifecycle: {}", request.getAttribute("javax.portlet.lifecycle_phase"));
        }
        if (LOG.isDebugEnabled()) {
            wicketURL = this.getWicketURL(request, pageType, this.getDefaultPage(pageType));
            LOG.debug("end of request, wicket url: " + wicketURL);
        }
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        String resourceId = request.getResourceID();
        if (resourceId != null) {
            if (PROTECTED_RESOURCES.matcher(resourceId).matches()) {
                response.setProperty("portlet.http-status-code", "404");
            }
            this.processRequest((PortletRequest)request, (PortletResponse)response, PageType.VIEW);
        }
    }

    protected String fixWicketUrl(String url) {
        if (url == null) {
            return this.wicketFilterPath;
        }
        if (!url.startsWith(this.wicketFilterPath)) {
            if (url.startsWith("..?")) {
                return this.wicketFilterPath + url.substring(2);
            }
            if ((url + "/").equals(this.wicketFilterPath)) {
                return this.wicketFilterPath;
            }
        }
        return url;
    }

    protected String fixWicketUrl(String requestUrl, String url, String scheme) {
        if (url != null && requestUrl != null && !ABSOLUTE_URI_PATTERN.matcher(url).matches()) {
            try {
                if (!requestUrl.startsWith("http")) {
                    return new URL(new URL(scheme + ":" + requestUrl), url).toString().substring(scheme.length() + 1);
                }
                return new URL(new URL(requestUrl), url).getPath();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.fixWicketUrl(url);
    }

    protected void validateDefaultPages(Map<PageType, String> defaultPages) {
        String viewPage = this.fixWicketUrl(defaultPages.get((Object)PageType.VIEW));
        defaultPages.put(PageType.VIEW, viewPage.startsWith(this.wicketFilterPath) ? viewPage : this.wicketFilterPath);
        String defaultPage = defaultPages.get((Object)PageType.ACTION);
        if (defaultPage == null) {
            defaultPages.put(PageType.ACTION, viewPage);
        } else {
            defaultPages.put(PageType.ACTION, (defaultPage = this.fixWicketUrl(defaultPage)).startsWith(this.wicketFilterPath) ? defaultPage : viewPage);
        }
        defaultPage = defaultPages.get((Object)PageType.CUSTOM);
        if (defaultPage == null) {
            defaultPages.put(PageType.CUSTOM, viewPage);
        } else {
            defaultPages.put(PageType.CUSTOM, (defaultPage = this.fixWicketUrl(defaultPage)).startsWith(this.wicketFilterPath) ? defaultPage : viewPage);
        }
        defaultPage = defaultPages.get((Object)PageType.HELP);
        if (defaultPage == null) {
            defaultPages.put(PageType.HELP, viewPage);
        } else {
            defaultPages.put(PageType.HELP, (defaultPage = this.fixWicketUrl(defaultPage)).startsWith(this.wicketFilterPath) ? defaultPage : viewPage);
        }
        defaultPage = defaultPages.get((Object)PageType.EDIT);
        if (defaultPage == null) {
            defaultPages.put(PageType.EDIT, viewPage);
        } else {
            defaultPages.put(PageType.EDIT, (defaultPage = this.fixWicketUrl(defaultPage)).startsWith(this.wicketFilterPath) ? defaultPage : viewPage);
        }
    }

    public static enum PageType {
        ACTION("actionPage"),
        CUSTOM("customPage"),
        EDIT("editPage"),
        HELP("helpPage"),
        VIEW("viewPage");

        public final String initParameterName;

        public static PageType getByInitParameterName(String initParameterName) {
            for (PageType p : PageType.values()) {
                if (!p.initParameterName.equals(initParameterName)) continue;
                return p;
            }
            return null;
        }

        private PageType(String initParameterName) {
            this.initParameterName = initParameterName;
        }
    }
}

