/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Application;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;

public class ThreadPortletContext {
    public static ServletContext getServletContext() {
        Application application = ThreadContext.getApplication();
        return application != null ? ((WebApplication)application).getServletContext() : null;
    }

    public static HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)ThreadContext.getRequestCycle().getRequest().getContainerRequest();
    }

    public static HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)ThreadContext.getRequestCycle().getResponse().getContainerResponse();
    }

    public static PortletConfig getPortletConfig() {
        HttpServletRequest servletRequest = ThreadPortletContext.getHttpServletRequest();
        return servletRequest != null ? (PortletConfig)servletRequest.getAttribute("javax.portlet.config") : null;
    }

    public static PortletRequest getPortletRequest() {
        HttpServletRequest servletRequest = ThreadPortletContext.getHttpServletRequest();
        return servletRequest != null ? (PortletRequest)servletRequest.getAttribute("javax.portlet.request") : null;
    }

    public static PortletResponse getPortletResponse() {
        HttpServletRequest servletRequest = ThreadPortletContext.getHttpServletRequest();
        return servletRequest != null ? (PortletResponse)servletRequest.getAttribute("javax.portlet.response") : null;
    }

    public static PortletMode getPortletMode() {
        PortletRequest portletRequest = ThreadPortletContext.getPortletRequest();
        return portletRequest != null ? portletRequest.getPortletMode() : null;
    }

    public static PortletPreferences getPortletPreferences() {
        PortletRequest portletRequest = ThreadPortletContext.getPortletRequest();
        return portletRequest != null ? portletRequest.getPreferences() : null;
    }

    public static String getNamespace() {
        PortletResponse portletResponse = ThreadPortletContext.getPortletResponse();
        return portletResponse != null ? portletResponse.getNamespace() : "";
    }

    public static String getWindowID() {
        PortletRequest portletRequest = ThreadPortletContext.getPortletRequest();
        return portletRequest != null ? portletRequest.getWindowID() : null;
    }

    public static boolean isAjax() {
        RequestCycle requestCycle = ThreadContext.getRequestCycle();
        return requestCycle != null ? ((WebRequest)requestCycle.getRequest()).isAjax() : false;
    }

    public static boolean isResourceRequest() {
        PortletRequest portletRequest = ThreadPortletContext.getPortletRequest();
        return portletRequest != null && portletRequest.getAttribute("javax.portlet.lifecycle_phase").equals("RESOURCE_PHASE");
    }

    public static boolean isEmbedded() {
        return !ThreadPortletContext.isAjax() && !ThreadPortletContext.isResourceRequest();
    }
}

