/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import org.apache.wicket.portlet.ThreadPortletContext;

public class ResponseState {
    private static final String AJAX_LOCATION_HEADER_NAME = "Ajax-Location";
    private static final int INITIAL_BUFFER_SIZE = 8192;
    private static final int MEMORY_BUFFER_SIZE = 65536;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final AtomicLong index = new AtomicLong();
    private final boolean isActionResponse;
    private final boolean isEventResponse;
    private final boolean isRenderResponse;
    private final boolean isResourceResponse;
    private final boolean isMimeResponse;
    private final boolean isStateAwareResponse;
    private final Locale defaultLocale;
    private final PortletResponse response;
    private boolean flushed;
    private File responseBufferFolder;
    private ByteOutputBuffer byteOutputBuffer;
    private CharOutputBuffer charOutputBuffer;
    private ServletOutputStream outputStream;
    private PrintWriter printWriter;
    private HashMap<String, ArrayList<String>> headers;
    private ArrayList<Cookie> cookies;
    private boolean committed;
    private boolean closed;
    private boolean hasStatus;
    private boolean hasError;
    private Locale locale;
    private boolean setContentTypeAfterEncoding;
    private String characterEncoding;
    private int contentLength = -1;
    private String contentType;
    private int statusCode;
    private String redirectLocation;

    public ResponseState(PortletRequest request, PortletResponse response, File responseBufferFolder) {
        this.responseBufferFolder = responseBufferFolder;
        String lifecyclePhase = (String)request.getAttribute("javax.portlet.lifecycle_phase");
        this.isActionResponse = "ACTION_PHASE".equals(lifecyclePhase);
        this.isEventResponse = "EVENT_PHASE".equals(lifecyclePhase);
        this.isRenderResponse = "RENDER_PHASE".equals(lifecyclePhase);
        this.isResourceResponse = "RESOURCE_PHASE".equals(lifecyclePhase);
        this.isStateAwareResponse = this.isActionResponse || this.isEventResponse;
        this.isMimeResponse = this.isRenderResponse || this.isResourceResponse;
        this.response = response;
        this.defaultLocale = this.isMimeResponse ? ((MimeResponse)response).getLocale() : null;
    }

    private ArrayList<String> getHeaderList(String name, boolean create) {
        ArrayList<String> headerList;
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        if ((headerList = this.headers.get(name)) == null && create) {
            headerList = new ArrayList();
            this.headers.put(name, headerList);
        }
        return headerList;
    }

    private void failIfCommitted() {
        if (this.committed) {
            throw new IllegalStateException("Response has been already committed.");
        }
    }

    public boolean isActionResponse() {
        return this.isActionResponse;
    }

    public boolean isEventResponse() {
        return this.isEventResponse;
    }

    public boolean isRenderResponse() {
        return this.isRenderResponse;
    }

    public boolean isResourceResponse() {
        return this.isResourceResponse;
    }

    public boolean isMimeResponse() {
        return this.isMimeResponse;
    }

    public boolean isStateAwareResponse() {
        return this.isStateAwareResponse;
    }

    public void addCookie(Cookie cookie) {
        this.failIfCommitted();
        if (this.cookies == null) {
            this.cookies = new ArrayList();
        }
        this.cookies.add(cookie);
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, Long.toString(date));
    }

    public void addHeader(String name, String value) {
        if (this.isMimeResponse) {
            this.failIfCommitted();
            this.getHeaderList(name, true).add(value);
        }
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        return this.isMimeResponse && this.getHeaderList(name, false) != null;
    }

    public void sendError(int errorCode, String errorMessage) throws IOException {
        this.failIfCommitted();
        this.committed = true;
        this.closed = true;
        this.hasError = true;
    }

    public void sendError(int errorCode) throws IOException {
        this.sendError(errorCode, null);
    }

    public void sendRedirect(String redirectLocation) throws IOException {
        if (this.isActionResponse || this.isMimeResponse) {
            this.failIfCommitted();
            this.closed = true;
            this.committed = true;
            this.redirectLocation = redirectLocation;
        }
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public String getAjaxRedirectLocation() {
        ArrayList<String> values = this.getHeaderList(AJAX_LOCATION_HEADER_NAME, false);
        return values != null && !values.isEmpty() ? values.get(values.size() - 1) : null;
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, Long.toString(date));
    }

    public void setHeader(String name, String value) {
        if (this.isMimeResponse && !this.committed) {
            ArrayList<String> headerList = this.getHeaderList(name, true);
            headerList.clear();
            headerList.add(value);
            if (AJAX_LOCATION_HEADER_NAME.equalsIgnoreCase(name)) {
                this.redirectLocation = value;
            }
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void setStatus(int statusCode, String message) {
        throw new UnsupportedOperationException("This method is deprecated and no longer supported");
    }

    public void setStatus(int statusCode) {
        if (!this.committed) {
            this.statusCode = statusCode;
            this.hasStatus = true;
            this.resetBuffer();
        }
    }

    public void flushBuffer() throws IOException {
        if (this.isMimeResponse && !this.closed) {
            this.committed = true;
        }
    }

    public int getBufferSize() {
        return this.isMimeResponse ? Integer.MAX_VALUE : 0;
    }

    public String getCharacterEncoding() {
        return this.isMimeResponse ? (this.characterEncoding != null ? this.characterEncoding : "ISO-8859-1") : null;
    }

    public String getContentType() {
        return this.isMimeResponse ? this.contentType : null;
    }

    public Locale getLocale() {
        return this.isMimeResponse ? (this.locale != null ? this.locale : this.defaultLocale) : null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.isStateAwareResponse) {
            return null;
        }
        if (this.outputStream == null) {
            if (this.printWriter != null) {
                throw new IllegalStateException("getWriter() has already been called on this response");
            }
            this.byteOutputBuffer = new ByteOutputBuffer();
            this.outputStream = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    if (!ResponseState.this.closed) {
                        ResponseState.this.byteOutputBuffer.write(b);
                        if (ResponseState.this.contentLength > -1 && ResponseState.this.byteOutputBuffer.size() >= ResponseState.this.contentLength) {
                            ResponseState.this.committed = true;
                            ResponseState.this.closed = true;
                        }
                    }
                }
            };
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.isStateAwareResponse) {
            return null;
        }
        if (this.printWriter == null) {
            if (this.outputStream != null) {
                throw new IllegalStateException("getOutputStream() has already been called on this response");
            }
            this.charOutputBuffer = new CharOutputBuffer();
            this.printWriter = new PrintWriter(this.charOutputBuffer);
        }
        return this.printWriter;
    }

    public boolean isCommitted() {
        return this.isMimeResponse && this.committed;
    }

    public void reset() {
        this.resetBuffer();
        this.headers = null;
        this.cookies = null;
        this.hasStatus = false;
        this.contentLength = -1;
        if (this.printWriter == null) {
            this.contentType = null;
            this.characterEncoding = null;
            this.locale = null;
        }
    }

    public void resetBuffer() {
        this.failIfCommitted();
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.byteOutputBuffer.reset();
        } else if (this.printWriter != null) {
            this.printWriter.flush();
            this.charOutputBuffer.reset();
        }
    }

    public void setBufferSize(int size) {
    }

    public void setCharacterEncoding(String charset) {
        if (this.isResourceResponse && charset != null && this.printWriter == null) {
            this.failIfCommitted();
            this.characterEncoding = charset;
            this.setContentTypeAfterEncoding = false;
        }
    }

    public void setContentLength(int len) {
        if (this.isResourceResponse && this.printWriter == null && len > 0) {
            this.failIfCommitted();
            this.contentLength = len;
            if (this.outputStream != null) {
                try {
                    this.outputStream.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.closed && this.byteOutputBuffer != null && this.byteOutputBuffer.size() >= len) {
                this.committed = true;
                this.closed = true;
            }
        }
    }

    public void setContentType(String type) {
        if (this.isMimeResponse) {
            this.failIfCommitted();
            this.contentType = type;
            this.setContentTypeAfterEncoding = false;
            if (this.printWriter == null) {
                // empty if block
            }
        }
    }

    public void setLocale(Locale locale) {
        if (this.isResourceResponse) {
            this.failIfCommitted();
            this.locale = locale;
        }
    }

    public void clear() {
        if (this.printWriter != null) {
            this.printWriter.close();
            this.charOutputBuffer.reset();
            this.printWriter = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputStream = null;
            this.byteOutputBuffer.reset();
        }
        this.headers = null;
        this.cookies = null;
        this.committed = false;
        this.hasStatus = false;
        this.hasError = false;
        this.locale = null;
        this.setContentTypeAfterEncoding = false;
        this.closed = false;
        this.characterEncoding = null;
        this.contentLength = -1;
        this.contentType = null;
        this.statusCode = 0;
        this.redirectLocation = null;
    }

    public void flushAndClose() throws IOException {
        MimeResponse mimeResponse;
        if (this.flushed) {
            throw new IllegalStateException("Response has been already flushed and closed.");
        }
        this.flushed = true;
        if (this.cookies != null) {
            for (Cookie cookie : this.cookies) {
                this.response.addProperty(cookie);
            }
            this.cookies = null;
        }
        if (this.isMimeResponse) {
            ResourceResponse resourceResponse;
            mimeResponse = (MimeResponse)this.response;
            ResourceResponse resourceResponse2 = resourceResponse = this.isResourceResponse ? (ResourceResponse)this.response : null;
            if (this.locale != null) {
                try {
                    resourceResponse.setLocale(this.locale);
                }
                catch (UnsupportedOperationException usoe) {
                    // empty catch block
                }
            }
            if (this.contentType != null) {
                if (this.characterEncoding != null) {
                    if (this.setContentTypeAfterEncoding) {
                        resourceResponse.setCharacterEncoding(this.characterEncoding);
                        resourceResponse.setContentType(this.contentType);
                    } else {
                        resourceResponse.setContentType(this.contentType);
                        resourceResponse.setCharacterEncoding(this.characterEncoding);
                    }
                } else {
                    mimeResponse.setContentType(this.contentType);
                }
            } else if (this.characterEncoding != null) {
                resourceResponse.setCharacterEncoding(this.characterEncoding);
            }
            if (this.headers != null) {
                for (Map.Entry<String, ArrayList<String>> entry : this.headers.entrySet()) {
                    for (String value : entry.getValue()) {
                        mimeResponse.addProperty(entry.getKey(), value);
                    }
                }
                this.headers = null;
            }
            if (this.isResourceResponse && this.hasStatus) {
                resourceResponse.setProperty("portlet.http-status-code", Integer.toString(this.statusCode));
            }
            if (this.isResourceResponse && this.contentLength > -1) {
                try {
                    resourceResponse.setContentLength(this.contentLength);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
        if (!this.hasError && !this.closed && this.redirectLocation == null && this.isMimeResponse) {
            mimeResponse = (MimeResponse)this.response;
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.byteOutputBuffer.writeToAndClose(mimeResponse.getPortletOutputStream());
            } else if (this.printWriter != null) {
                this.printWriter.flush();
                this.charOutputBuffer.writeToAndClose(mimeResponse.getWriter());
            }
        }
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
        if (this.printWriter != null) {
            this.printWriter.close();
            this.printWriter = null;
        }
    }

    private File getResponseBufferFolder() {
        if (this.responseBufferFolder == null) {
            ServletContext context = ThreadPortletContext.getServletContext();
            if (context != null) {
                this.responseBufferFolder = (File)context.getAttribute("javax.servlet.context.tempdir");
                if (this.responseBufferFolder != null) {
                    this.responseBufferFolder = new File(this.responseBufferFolder, "wicket-response-buffers");
                }
            }
            if (this.responseBufferFolder == null) {
                try {
                    this.responseBufferFolder = File.createTempFile("wicket-response-buffers", null).getParentFile();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot create response buffer folder.", e);
                }
            }
            this.responseBufferFolder.mkdirs();
        }
        return this.responseBufferFolder;
    }

    private File getResponseBufferFile() {
        return new File(this.getResponseBufferFolder(), "response-buffer" + index.getAndIncrement());
    }

    private class ByteOutputBuffer
    extends ByteArrayOutputStream {
        private File file;
        private OutputStream fileOutputStream;

        public ByteOutputBuffer() {
            super(8192);
        }

        private boolean useFile(int pos) {
            return this.fileOutputStream != null || pos > 65536;
        }

        private OutputStream getFileWriter() throws IOException {
            if (this.fileOutputStream == null) {
                this.file = ResponseState.this.getResponseBufferFile();
                this.fileOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));
                this.fileOutputStream.write(this.buf, 0, this.count);
            }
            return this.fileOutputStream;
        }

        @Override
        public void write(int b) {
            if (this.useFile(this.count + 1)) {
                try {
                    this.getFileWriter().write(b);
                    ++this.count;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot write cache file.", e);
                }
            } else {
                super.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (this.useFile(this.count + len)) {
                try {
                    this.getFileWriter().write(b, off, len);
                    this.count += len;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot write cache file.", e);
                }
            } else {
                super.write(b, off, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToAndClose(OutputStream outputStream) throws IOException {
            try {
                InputStream inputStream;
                if (this.fileOutputStream != null) {
                    try {
                        this.fileOutputStream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    inputStream = new BufferedInputStream(new FileInputStream(this.file));
                } else {
                    inputStream = new ByteArrayInputStream(this.buf, 0, this.count);
                }
                try {
                    int count;
                    while ((count = inputStream.read(this.buf)) > 0) {
                        outputStream.write(this.buf, 0, count);
                    }
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            finally {
                this.buf = null;
                this.reset();
            }
        }

        @Override
        public void reset() {
            super.reset();
            if (this.fileOutputStream != null) {
                try {
                    this.fileOutputStream.close();
                    this.fileOutputStream = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.file != null) {
                try {
                    this.file.delete();
                    this.file = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void finalize() throws Throwable {
            this.reset();
        }
    }

    private class CharOutputBuffer
    extends CharArrayWriter {
        private File file;
        private Writer fileWriter;

        public CharOutputBuffer() {
            super(8192);
        }

        private boolean useFile(int pos) {
            return this.fileWriter != null || pos > 65536;
        }

        private Writer getFileWriter() throws IOException {
            if (this.fileWriter == null) {
                this.file = ResponseState.this.getResponseBufferFile();
                this.fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), ResponseState.DEFAULT_CHARSET));
                this.fileWriter.write(this.buf, 0, this.count);
            }
            return this.fileWriter;
        }

        @Override
        public void write(int c) {
            if (this.useFile(this.count + 1)) {
                try {
                    this.getFileWriter().write(c);
                    ++this.count;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot write cache file.", e);
                }
            } else {
                super.write(c);
            }
        }

        @Override
        public void write(char[] c, int off, int len) {
            if (this.useFile(this.count + len)) {
                try {
                    this.getFileWriter().write(c, off, len);
                    this.count += len;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot write cache file.", e);
                }
            } else {
                super.write(c, off, len);
            }
        }

        @Override
        public void write(String str, int off, int len) {
            if (this.useFile(this.count + 1)) {
                try {
                    this.getFileWriter().write(str, off, len);
                    this.count += len;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot write cache file.", e);
                }
            } else {
                super.write(str, off, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToAndClose(Writer writer) throws IOException {
            try {
                Reader reader;
                if (this.fileWriter != null) {
                    try {
                        this.fileWriter.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), ResponseState.DEFAULT_CHARSET));
                } else {
                    reader = new CharArrayReader(this.buf, 0, this.count);
                }
                try {
                    int count;
                    while ((count = reader.read(this.buf)) > 0) {
                        writer.write(this.buf, 0, count);
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            finally {
                this.buf = null;
                this.reset();
            }
        }

        @Override
        public void reset() {
            super.reset();
            if (this.fileWriter != null) {
                try {
                    this.fileWriter.close();
                    this.fileWriter = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.file != null) {
                try {
                    this.file.delete();
                    this.file = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void finalize() throws Throwable {
            this.reset();
        }
    }
}

