/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import javax.portlet.PortletRequest;
import org.apache.wicket.portlet.PortletRequestMapper;
import org.apache.wicket.portlet.ThreadPortletContext;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.UrlRenderer;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.Strings;

public class PortletUrlRenderer
extends UrlRenderer {
    private Request request;

    public PortletUrlRenderer(Request request) {
        super(request);
        this.request = request;
        PortletRequest portletRequest = ThreadPortletContext.getPortletRequest();
        String lifecyclePhase = (String)portletRequest.getAttribute("javax.portlet.lifecycle_phase");
        if (!"RESOURCE_PHASE".equals(lifecyclePhase)) {
            this.setBaseUrl(request.getUrl());
        }
    }

    public String renderContextRelativeUrl(String url) {
        Args.notNull((Object)url, (String)"url");
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        PrependingStringBuffer buffer = new PrependingStringBuffer(url);
        buffer.prepend("/").prepend(ThreadPortletContext.getPortletRequest().getContextPath());
        return buffer.toString();
    }

    public String renderUrl(Url url) {
        Url clientUrl;
        if (url.getQueryParameter(PortletRequestMapper.PORTLET_URL) != null) {
            url.removeQueryParameters(PortletRequestMapper.PORTLET_URL);
            return url.toString();
        }
        CharSequence renderedUrl = super.renderUrl(url);
        Url absoluteUrl = Url.parse((CharSequence)renderedUrl);
        if (!this.shouldRedirectToExternalUrl(absoluteUrl, clientUrl = this.request.getClientUrl())) {
            if (absoluteUrl.getProtocol() != null) {
                renderedUrl = Strings.replaceAll((CharSequence)renderedUrl, (CharSequence)(absoluteUrl.getProtocol() + "://"), (CharSequence)"/");
            }
            if (absoluteUrl.getHost() != null) {
                renderedUrl = Strings.replaceAll((CharSequence)renderedUrl, (CharSequence)("/" + absoluteUrl.getHost()), (CharSequence)"/");
            }
            if (absoluteUrl.getPort() != null) {
                renderedUrl = Strings.replaceAll((CharSequence)renderedUrl, (CharSequence)("/:" + absoluteUrl.getPort()), (CharSequence)"/");
            }
            renderedUrl = Strings.replaceAll((CharSequence)renderedUrl, (CharSequence)"//", (CharSequence)"/");
        }
        return renderedUrl.toString();
    }

    private boolean shouldRedirectToExternalUrl(Url url, Url clientUrl) {
        if (!Strings.isEmpty((CharSequence)url.getProtocol()) && !url.getProtocol().equals(clientUrl.getProtocol())) {
            return true;
        }
        if (!Strings.isEmpty((CharSequence)url.getHost()) && !url.getHost().equals(clientUrl.getHost())) {
            return true;
        }
        return url.getPort() != null && !url.getPort().equals(clientUrl.getPort());
    }
}

