/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import org.apache.wicket.Component;
import org.apache.wicket.IMarkupIdGenerator;
import org.apache.wicket.Session;
import org.apache.wicket.portlet.ThreadPortletContext;
import org.apache.wicket.util.string.Strings;

public class PortletMarkupIdGenerator
implements IMarkupIdGenerator {
    public String generateMarkupId(Component component, boolean createIfDoesNotExist) {
        int generatedMarkupId;
        Object storedMarkupId = component.getMarkupIdImpl();
        if (storedMarkupId instanceof String) {
            return (String)storedMarkupId;
        }
        if (storedMarkupId == null && !createIfDoesNotExist) {
            return null;
        }
        Session session = component.getSession();
        int n = generatedMarkupId = storedMarkupId instanceof Integer ? ((Integer)storedMarkupId).intValue() : session.nextSequenceValue();
        if (generatedMarkupId == 173) {
            generatedMarkupId = session.nextSequenceValue();
        }
        if (storedMarkupId == null) {
            component.setMarkupIdImpl((Object)generatedMarkupId);
        }
        String markupIdPrefix = "id";
        if (component.getApplication().usesDevelopmentConfig()) {
            markupIdPrefix = component.getId();
        }
        String markupIdPostfix = Integer.toHexString(generatedMarkupId).toLowerCase();
        String markupId = markupIdPrefix + markupIdPostfix + "_" + ThreadPortletContext.getNamespace();
        char c = markupId.charAt(0);
        if (!Character.isLetter(c)) {
            markupId = "id" + markupId;
        }
        markupId = Strings.replaceAll((CharSequence)markupId, (CharSequence)"_", (CharSequence)"__").toString();
        markupId = markupId.replace('.', '_');
        markupId = markupId.replace('-', '_');
        markupId = markupId.replace(' ', '_');
        return markupId;
    }
}

