/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.portlet.ThreadPortletContext;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class PortletInvalidMarkupFilter
implements IResponseFilter {
    public AppendingStringBuffer filter(AppendingStringBuffer responseBuffer) {
        if (ThreadPortletContext.isEmbedded()) {
            this.deleteFragment(responseBuffer, "<?xml", "?>");
            this.deleteFragment(responseBuffer, "<!DOCTYPE", ">");
            this.deleteOpenTag(responseBuffer, "html");
            this.deleteOpenTag(responseBuffer, "head");
            this.deleteOpenTag(responseBuffer, "body");
        }
        return responseBuffer;
    }

    private void deleteFragment(AppendingStringBuffer responseBuffer, String prefix, String postfix) {
        int endIndex;
        int startIndex = responseBuffer.indexOf(prefix);
        if (startIndex > -1 && (endIndex = responseBuffer.indexOf(postfix, startIndex)) > -1) {
            responseBuffer.delete(startIndex, endIndex + postfix.length());
        }
    }

    private void deleteOpenTag(AppendingStringBuffer responseBuffer, String tagName) {
        int startIndex = responseBuffer.indexOf("<" + tagName);
        if (startIndex > -1) {
            int endIndex = responseBuffer.indexOf(">", startIndex);
            if (endIndex <= -1) {
                throw new MarkupException("Cannot find end of element tag named: " + tagName);
            }
            responseBuffer.delete(startIndex, endIndex + 1);
            startIndex = responseBuffer.indexOf("</" + tagName + ">");
            if (startIndex > -1) {
                responseBuffer.delete(startIndex, startIndex + tagName.length() + 3);
            }
        }
    }
}

