/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PortletHttpSessionWrapper
implements InvocationHandler {
    private final HttpSession servletSession;
    private final String portletWindowPrefix;
    private final String wicketSessionAttributePrefix;

    public static HttpSession createProxy(HttpServletRequest request, String portletWindowId, String wicketSessionAttributePrefix) {
        String portletWindowNamespace = "javax.portlet.p." + portletWindowId;
        HttpSession servletSession = request.getSession();
        HashSet interfaces = new HashSet();
        interfaces.add(HttpSession.class);
        Class<?> current = servletSession.getClass();
        while (current != null) {
            try {
                Class<?>[] currentInterfaces;
                for (Class<?> currentInterface : currentInterfaces = current.getInterfaces()) {
                    interfaces.add(currentInterface);
                }
                current = current.getSuperclass();
            }
            catch (Exception ex) {
                current = null;
            }
        }
        return (HttpSession)Proxy.newProxyInstance(servletSession.getClass().getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new PortletHttpSessionWrapper(request.getSession(), portletWindowNamespace, wicketSessionAttributePrefix));
    }

    private PortletHttpSessionWrapper(HttpSession servletSession, String portletWindowPrefix, String wicketSessionAttributePrefix) {
        this.servletSession = servletSession;
        this.portletWindowPrefix = portletWindowPrefix;
        this.wicketSessionAttributePrefix = wicketSessionAttributePrefix;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (("getAttribute".equals(m.getName()) || "getValue".equals(m.getName())) && args.length == 1 && args[0] instanceof String) {
            return this.servletSession.getAttribute(this.fixAttributeName((String)args[0]));
        }
        if (("setAttribute".equals(m.getName()) || "putValue".equals(m.getName())) && args.length == 2 && args[0] instanceof String) {
            this.servletSession.setAttribute(this.fixAttributeName((String)args[0]), args[1]);
            return null;
        }
        if (("removeAttribute".equals(m.getName()) || "removeValue".equals(m.getName())) && args.length == 1 && args[0] instanceof String) {
            this.servletSession.removeAttribute(this.portletWindowPrefix + (String)args[0]);
            return null;
        }
        if ("getAttributeNames".equals(m.getName()) && args == null) {
            return new NamespacedNamesEnumeration(this.servletSession.getAttributeNames(), this.portletWindowPrefix);
        }
        if ("getValueNames".equals(m.getName()) && args == null) {
            ArrayList list = new ArrayList();
            NamespacedNamesEnumeration en = new NamespacedNamesEnumeration(this.servletSession.getAttributeNames(), this.portletWindowPrefix);
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
            return list.toArray(new String[list.size()]);
        }
        return m.invoke((Object)this.servletSession, args);
    }

    private String fixAttributeName(String attributeName) {
        if (attributeName.startsWith(this.wicketSessionAttributePrefix)) {
            attributeName = this.portletWindowPrefix + attributeName;
        }
        return attributeName;
    }

    private static class NamespacedNamesEnumeration
    implements Enumeration<String> {
        private final Enumeration<String> namesEnumeration;
        private final String namespace;
        private String nextName;
        private boolean isDone;

        public NamespacedNamesEnumeration(Enumeration<String> namesEnumeration, String namespace) {
            this.namesEnumeration = namesEnumeration;
            this.namespace = namespace;
            this.hasMoreElements();
        }

        @Override
        public boolean hasMoreElements() {
            if (this.isDone) {
                return false;
            }
            if (this.nextName == null) {
                while (this.namesEnumeration.hasMoreElements()) {
                    String name = this.namesEnumeration.nextElement();
                    if (!name.startsWith(this.namespace)) continue;
                    this.nextName = name.substring(this.namespace.length());
                    break;
                }
                this.isDone = this.nextName == null;
            }
            return !this.isDone;
        }

        @Override
        public String nextElement() {
            if (this.isDone) {
                throw new NoSuchElementException();
            }
            String name = this.nextName;
            this.nextName = null;
            return name;
        }
    }
}

