/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import java.io.IOException;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.IMarkupIdGenerator;
import org.apache.wicket.IPageRendererProvider;
import org.apache.wicket.IRequestCycleProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.portlet.PortletHttpSessionWrapper;
import org.apache.wicket.portlet.PortletInvalidMarkupFilter;
import org.apache.wicket.portlet.PortletMarkupIdGenerator;
import org.apache.wicket.portlet.PortletPageRenderer;
import org.apache.wicket.portlet.PortletRequestMapper;
import org.apache.wicket.portlet.PortletServletRequestWrapper;
import org.apache.wicket.portlet.PortletServletResponseWrapper;
import org.apache.wicket.portlet.PortletUrlRenderer;
import org.apache.wicket.portlet.ResponseState;
import org.apache.wicket.portlet.WicketPortlet;
import org.apache.wicket.portlet.ajax.WicketPortletAjaxResourceReference;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.https.HttpsConfig;
import org.apache.wicket.protocol.https.HttpsMapper;
import org.apache.wicket.protocol.https.Scheme;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.UrlRenderer;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.cycle.RequestCycleContext;
import org.apache.wicket.request.handler.render.PageRenderer;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.settings.RequestCycleSettings;
import org.apache.wicket.util.crypt.Base64;

public class PortletFilter
extends WicketFilter {
    public static final String SHARED_RESOURCE_URL_PORTLET_WINDOW_ID_PREFIX = "/ps:";
    private static String NOT_MOUNTED_PATH = "notMountedPath";
    private FilterConfig filterConfig;

    public void init(boolean isServlet, FilterConfig filterConfig) throws ServletException {
        super.init(isServlet, filterConfig);
        this.filterConfig = filterConfig;
        this.getApplication().getRequestCycleSettings().setRenderStrategy(RequestCycleSettings.RenderStrategy.REDIRECT_TO_RENDER);
        this.getApplication().getRequestCycleSettings().addResponseFilter((IResponseFilter)new PortletInvalidMarkupFilter());
        this.getApplication().getMarkupSettings().setMarkupIdGenerator((IMarkupIdGenerator)new PortletMarkupIdGenerator());
        this.getApplication().setRootRequestMapper((IRequestMapper)new HttpsMapper((IRequestMapper)new PortletRequestMapper((Application)this.getApplication()), new HttpsConfig()){

            protected Scheme getDesiredSchemeFor(IRequestHandler handler) {
                Request request = RequestCycle.get().getRequest();
                return super.getSchemeOf(request);
            }
        });
        this.getApplication().setPageRendererProvider(new IPageRendererProvider(){

            public PageRenderer get(RenderPageRequestHandler handler) {
                return new PortletPageRenderer(handler);
            }
        });
        this.getApplication().setRequestCycleProvider(new IRequestCycleProvider(){

            public RequestCycle get(RequestCycleContext context) {
                return new RequestCycle(context){

                    protected UrlRenderer newUrlRenderer() {
                        return new PortletUrlRenderer(this.getRequest());
                    }
                };
            }
        });
        this.getApplication().getJavaScriptLibrarySettings().setWicketAjaxReference((ResourceReference)WicketPortletAjaxResourceReference.get());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object httpServletRequest = (HttpServletRequest)servletRequest;
        Object httpServletResponse = (HttpServletResponse)servletResponse;
        String filterPath = this.getFilterPath((HttpServletRequest)httpServletRequest);
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        if (portletRequest != null) {
            PortletConfig portletConfig = (PortletConfig)httpServletRequest.getAttribute("javax.portlet.config");
            ResponseState responseState = (ResponseState)httpServletRequest.getAttribute(WicketPortlet.RESPONSE_STATE_ATTR);
            if (portletConfig != null) {
                if (responseState == null) {
                    filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                HttpSession proxiedSession = PortletHttpSessionWrapper.createProxy(httpServletRequest, portletRequest.getWindowID(), this.getApplication().getSessionAttributePrefix(null, this.filterConfig.getFilterName()));
                httpServletRequest = new PortletServletRequestWrapper(this.filterConfig.getServletContext(), (HttpServletRequest)httpServletRequest, proxiedSession, filterPath);
                httpServletResponse = new PortletServletResponseWrapper((HttpServletResponse)httpServletResponse, responseState);
            }
        } else {
            int nextSeparator;
            String pathInfo = httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length() + filterPath.length());
            if (pathInfo.startsWith(SHARED_RESOURCE_URL_PORTLET_WINDOW_ID_PREFIX) && (nextSeparator = pathInfo.indexOf(47, 1)) > 0) {
                String windowId = new String(Base64.decodeBase64((String)pathInfo.substring(SHARED_RESOURCE_URL_PORTLET_WINDOW_ID_PREFIX.length(), nextSeparator)));
                HttpSession proxiedSession = PortletHttpSessionWrapper.createProxy(httpServletRequest, windowId, this.getApplication().getSessionAttributePrefix(null, this.filterConfig.getFilterName()));
                pathInfo = pathInfo.substring(nextSeparator);
                httpServletRequest = new PortletServletRequestWrapper(this.filterConfig.getServletContext(), (HttpServletRequest)httpServletRequest, proxiedSession, filterPath, pathInfo);
            }
        }
        super.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, filterChain);
    }

    protected boolean processRequestCycle(RequestCycle requestCycle, WebResponse webResponse, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain chain) throws IOException, ServletException {
        boolean res = true;
        if (requestCycle.processRequestAndDetach()) {
            webResponse.flush();
        } else {
            if (httpServletRequest.getPathInfo() != null && httpServletRequest.getPathInfo().equals(httpServletRequest.getAttribute(NOT_MOUNTED_PATH))) {
                throw new AbortWithHttpErrorCodeException(404, httpServletRequest.getPathInfo() + " is not mounted to any Page");
            }
            if (chain != null) {
                httpServletRequest.setAttribute(NOT_MOUNTED_PATH, (Object)httpServletRequest.getPathInfo());
                chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            res = false;
        }
        return res;
    }
}

