/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.fingerprint;

import org.whispersystems.libsignal.util.ByteUtil;

public class DisplayableFingerprint {
    private final String localFingerprintNumbers;
    private final String remoteFingerprintNumbers;

    DisplayableFingerprint(byte[] localFingerprint, byte[] remoteFingerprint) {
        this.localFingerprintNumbers = this.getDisplayStringFor(localFingerprint);
        this.remoteFingerprintNumbers = this.getDisplayStringFor(remoteFingerprint);
    }

    public String getDisplayText() {
        if (this.localFingerprintNumbers.compareTo(this.remoteFingerprintNumbers) <= 0) {
            return this.localFingerprintNumbers + this.remoteFingerprintNumbers;
        }
        return this.remoteFingerprintNumbers + this.localFingerprintNumbers;
    }

    private String getDisplayStringFor(byte[] fingerprint) {
        return this.getEncodedChunk(fingerprint, 0) + this.getEncodedChunk(fingerprint, 5) + this.getEncodedChunk(fingerprint, 10) + this.getEncodedChunk(fingerprint, 15) + this.getEncodedChunk(fingerprint, 20) + this.getEncodedChunk(fingerprint, 25);
    }

    private String getEncodedChunk(byte[] hash, int offset) {
        long chunk = ByteUtil.byteArray5ToLong(hash, offset) % 100000L;
        return String.format("%05d", chunk);
    }
}

