/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.webjars.WebJarCache;
import org.webjars.WebJarCacheDefault;

@NullMarked
public class WebJarVersionLocator {
    public static final String WEBJARS_PATH_PREFIX = "META-INF/resources/webjars";
    private static final String PROPERTIES_ROOT = "META-INF/maven/";
    private static final String NPM = "org.webjars.npm/";
    private static final String PLAIN = "org.webjars/";
    private static final String POM_PROPERTIES = "/pom.properties";
    private static final ClassLoader LOADER = WebJarVersionLocator.class.getClassLoader();
    private final WebJarCache cache;

    public WebJarVersionLocator() {
        this.cache = new WebJarCacheDefault(new ConcurrentHashMap<String, Optional<String>>());
    }

    WebJarVersionLocator(WebJarCache cache) {
        this.cache = cache;
    }

    public @Nullable String fullPath(String webJarName, String exactPath) {
        String version = this.version(webJarName);
        if (!this.isEmpty(version)) {
            if (!exactPath.startsWith(version)) {
                return String.format("%s/%s/%s/%s", WEBJARS_PATH_PREFIX, webJarName, version, exactPath);
            }
            return String.format("%s/%s/%s", WEBJARS_PATH_PREFIX, webJarName, exactPath);
        }
        return null;
    }

    public @Nullable String path(String webJarName, String exactPath) {
        String version = this.version(webJarName);
        if (!this.isEmpty(version)) {
            return String.format("%s/%s/%s", webJarName, version, exactPath);
        }
        return null;
    }

    public @Nullable String version(String webJarName) {
        String cacheKey = "version-" + webJarName;
        Optional<String> optionalVersion = this.cache.computeIfAbsent(cacheKey, key -> {
            InputStream resource = LOADER.getResourceAsStream("META-INF/maven/org.webjars.npm/" + webJarName + POM_PROPERTIES);
            if (resource == null) {
                resource = LOADER.getResourceAsStream("META-INF/maven/org.webjars/" + webJarName + POM_PROPERTIES);
            }
            if (resource != null) {
                Properties properties = new Properties();
                try {
                    properties.load(resource);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        resource.close();
                    }
                    catch (IOException iOException) {}
                }
                String version = properties.getProperty("version");
                if (version != null) {
                    if (this.hasResourcePath(webJarName, version)) {
                        return Optional.of(version);
                    }
                    if (version.contains("-") && this.hasResourcePath(webJarName, version = version.substring(0, version.indexOf("-")))) {
                        return Optional.of(version);
                    }
                }
            }
            return Optional.empty();
        });
        return optionalVersion.orElse(null);
    }

    private boolean hasResourcePath(String webJarName, String path) {
        return LOADER.getResource("META-INF/resources/webjars/" + webJarName + "/" + path) != null;
    }

    private boolean isEmpty(@Nullable String str) {
        return str == null || str.trim().isEmpty();
    }
}

