
// This is ammo.js, a port of Bullet Physics to JavaScript. zlib licensed.
var AmmoLib = function(Module) {
  Module = Module || {};

var Module;if(!Module)Module=(typeof AmmoLib!=="undefined"?AmmoLib:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){return Module["read"](filename,true)};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){throw"NO_DYNAMIC_EXECUTION was set, cannot eval"}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){DYNAMICTOP=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){abort("NO_DYNAMIC_EXECUTION was set, cannot eval - ccall/cwrap are not functional")}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};cwrap=function cwrap(ident,returnType,argTypes){return(function(){return ccall(ident,returnType,argTypes,arguments)})}}))();Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(typeof _sbrk!=="undefined"&&!_sbrk.called||!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;var startPtr=outPtr;var numCharsToWrite=maxBytesToWrite<str.length*2?maxBytesToWrite/2:str.length;for(var i=0;i<numCharsToWrite;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr>>1]=codeUnit;outPtr+=2}HEAP16[outPtr>>1]=0;return outPtr-startPtr}Module["stringToUTF16"]=stringToUTF16;function lengthBytesUTF16(str){return str.length*2}Module["lengthBytesUTF16"]=lengthBytesUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr>>2]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}HEAP32[outPtr>>2]=0;return outPtr-startPtr}Module["stringToUTF32"]=stringToUTF32;function lengthBytesUTF32(str){var len=0;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;len+=4}return len}Module["lengthBytesUTF32"]=lengthBytesUTF32;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var parsed=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}parsed=parse()}catch(e){parsed+="?"}if(parsed.indexOf("?")>=0&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return parsed}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function enlargeMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value "+TOTAL_MEMORY+", (2) compile with ALLOW_MEMORY_GROWTH which adjusts the size at runtime but prevents some optimizations, or (3) set Module.TOTAL_MEMORY before the program runs.")}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||67108864;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){Module.printErr("increasing TOTAL_MEMORY to "+totalMemory+" to be compliant with the asm.js spec (and given that TOTAL_STACK="+TOTAL_STACK+")");TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer;buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var ASM_CONSTS=[(function($0,$1,$2,$3,$4,$5,$6,$7){{var self=Module["getCache"](Module["ConcreteContactResultCallback"])[$0];if(!self.hasOwnProperty("addSingleResult"))throw"a JSImplementation must implement all functions, you forgot ConcreteContactResultCallback::addSingleResult.";return self["addSingleResult"]($1,$2,$3,$4,$5,$6,$7)}})];function _emscripten_asm_const_8(code,a0,a1,a2,a3,a4,a5,a6,a7){return ASM_CONSTS[code](a0,a1,a2,a3,a4,a5,a6,a7)|0}STATIC_BASE=8;STATICTOP=STATIC_BASE+23024;__ATINIT__.push({func:(function(){__GLOBAL__sub_I_btQuickprof_cpp()})});allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,42,0,0,112,45,0,0,56,0,0,0,0,0,0,0,104,42,0,0,134,45,0,0,104,42,0,0,162,45,0,0,144,42,0,0,183,45,0,0,88,0,0,0,0,0,0,0,104,42,0,0,230,45,0,0,144,42,0,0,14,46,0,0,112,0,0,0,0,0,0,0,104,42,0,0,37,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,42,0,0,53,46,0,0,152,0,0,0,0,0,0,0,104,42,0,0,103,46,0,0,144,42,0,0,186,47,0,0,176,0,0,0,0,0,0,0,104,42,0,0,218,47,0,0,144,42,0,0,7,48,0,0,24,2,0,0,0,0,0,0,144,42,0,0,42,48,0,0,216,0,0,0,0,0,0,0,144,42,0,0,193,49,0,0,184,3,0,0,0,0,0,0,144,42,0,0,211,49,0,0,136,0,0,0,0,0,0,0,144,42,0,0,248,49,0,0,8,1,0,0,0,0,0,0,104,42,0,0,22,50,0,0,144,42,0,0,68,50,0,0,32,1,0,0,0,0,0,0,184,42,0,0,94,50,0,0,0,0,0,0,1,0,0,0,56,1,0,0,2,4,0,0,104,42,0,0,114,50,0,0,144,42,0,0,158,50,0,0,16,1,0,0,0,0,0,0,144,42,0,0,224,50,0,0,32,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,42,0,0,54,51,0,0,32,1,0,0,0,0,0,0,144,42,0,0,98,51,0,0,32,1,0,0,0,0,0,0,144,42,0,0,148,51,0,0,32,1,0,0,0,0,0,0,144,42,0,0,195,51,0,0,168,1,0,0,0,0,0,0,104,42,0,0,51,52,0,0,144,42,0,0,72,52,0,0,64,0,0,0,0,0,0,0,144,42,0,0,100,52,0,0,216,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,42,0,0,119,52,0,0,144,42,0,0,139,52,0,0,248,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,42,0,0,172,52,0,0,216,1,0,0,0,0,0,0,144,42,0,0,205,52,0,0,136,0,0,0,0,0,0,0,104,42,0,0,251,52,0,0,144,42,0,0,42,53,0,0,24,2,0,0,0,0,0,0,144,42,0,0,58,53,0,0,32,2,0,0,0,0,0,0,144,42,0,0,85,53,0,0,32,8,0,0,0,0,0,0,144,42,0,0,109,53,0,0,96,2,0,0,0,0,0,0,104,42,0,0,135,53,0,0,144,42,0,0,155,53,0,0,120,2,0,0,0,0,0,0,104,42,0,0,189,53,0,0,144,42,0,0,216,53,0,0,144,2,0,0,0,0,0,0,104,42,0,0,8,54,0,0,144,42,0,0,41,54,0,0,144,2,0,0,0,0,0,0,144,42,0,0,84,54,0,0,144,2,0,0,0,0,0,0,144,42,0,0,135,54,0,0,144,2,0,0,0,0,0,0,144,42,0,0,184,54,0,0,144,2,0,0,0,0,0,0,144,42,0,0,217,54,0,0,144,2,0,0,0,0,0,0,144,42,0,0,13,55,0,0,144,2,0,0,0,0,0,0,144,42,0,0,66,55,0,0,144,2,0,0,0,0,0,0,144,42,0,0,111,55,0,0,144,2,0,0,0,0,0,0,144,42,0,0,168,55,0,0,144,2,0,0,0,0,0,0,104,42,0,0,218,55,0,0,144,42,0,0,33,56,0,0,64,3,0,0,0,0,0,0,104,42,0,0,67,56,0,0,144,42,0,0,90,56,0,0,240,8,0,0,0,0,0,0,144,42,0,0,126,56,0,0,120,6,0,0,0,0,0,0,104,42,0,0,153,56,0,0,144,42,0,0,217,56,0,0,120,6,0,0,0,0,0,0,144,42,0,0,119,57,0,0,24,6,0,0,0,0,0,0,144,42,0,0,137,57,0,0,240,8,0,0,0,0,0,0,144,42,0,0,166,57,0,0,176,3,0,0,0,0,0,0,104,42,0,0,185,57,0,0,104,42,0,0,233,57,0,0,184,42,0,0,66,59,0,0,0,0,0,0,2,0,0,0,120,6,0,0,2,0,0,0,128,6,0,0,2,4,0,0,144,42,0,0,86,59,0,0,160,3,0,0,0,0,0,0,104,42,0,0,112,59,0,0,144,42,0,0,139,59,0,0,8,4,0,0,0,0,0,0,144,42,0,0,163,59,0,0,240,3,0,0,0,0,0,0,144,42,0,0,189,59,0,0,8,4,0,0,0,0,0,0,144,42,0,0,211,59,0,0,152,0,0,0,0,0,0,0,144,42,0,0,112,60,0,0,64,8,0,0,0,0,0,0,144,42,0,0,33,61,0,0,64,8,0,0,0,0,0,0,144,42,0,0,208,61,0,0,88,0,0,0,0,0,0,0,144,42,0,0,85,62,0,0,120,4,0,0,0,0,0,0,104,42,0,0,211,62,0,0,144,42,0,0,230,62,0,0,48,8,0,0,0,0,0,0,144,42,0,0,123,63,0,0,48,8,0,0,0,0,0,0,144,42,0,0,14,64,0,0,240,8,0,0,0,0,0,0,144,42,0,0,51,64,0,0,144,2,0,0,0,0,0,0,144,42,0,0,91,64,0,0,240,8,0,0,0,0,0,0,144,42,0,0,117,64,0,0,160,3,0,0,0,0,0,0,144,42,0,0,144,64,0,0,176,3,0,0,0,0,0,0,144,42,0,0,29,65,0,0,176,3,0,0,0,0,0,0,144,42,0,0,162,65,0,0,240,8,0,0,0,0,0,0,144,42,0,0,193,65,0,0,120,4,0,0,0,0,0,0,144,42,0,0,218,65,0,0,240,8,0,0,0,0,0,0,144,42,0,0,1,66,0,0,120,4,0,0,0,0,0,0,144,42,0,0,34,66,0,0,64,6,0,0,0,0,0,0,144,42,0,0,106,66,0,0,88,6,0,0,0,0,0,0,144,42,0,0,153,66,0,0,80,5,0,0,0,0,0,0,144,42,0,0,168,66,0,0,80,5,0,0,0,0,0,0,144,42,0,0,183,66,0,0,88,6,0,0,0,0,0,0,144,42,0,0,206,66,0,0,216,5,0,0,0,0,0,0,144,42,0,0,15,67,0,0,176,5,0,0,0,0,0,0,104,42,0,0,125,67,0,0,144,42,0,0,149,67,0,0,176,5,0,0,0,0,0,0,144,42,0,0,6,68,0,0,176,5,0,0,0,0,0,0,144,42,0,0,110,68,0,0,216,6,0,0,0,0,0,0,144,42,0,0,145,68,0,0,120,6,0,0,0,0,0,0,144,42,0,0,169,68,0,0,128,6,0,0,0,0,0,0,144,42,0,0,15,69,0,0,216,6,0,0,0,0,0,0,144,42,0,0,71,69,0,0,88,6,0,0,0,0,0,0,144,42,0,0,97,69,0,0,24,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,42,0,0,134,69,0,0,144,42,0,0,174,69,0,0,64,6,0,0,0,0,0,0,144,42,0,0,190,69,0,0,72,6,0,0,0,0,0,0,144,42,0,0,214,69,0,0,40,6,0,0,0,0,0,0,104,42,0,0,7,70,0,0,104,42,0,0,28,70,0,0,144,42,0,0,62,70,0,0,88,6,0,0,0,0,0,0,144,42,0,0,129,70,0,0,136,6,0,0,0,0,0,0,144,42,0,0,147,70,0,0,136,6,0,0,0,0,0,0,144,42,0,0,165,70,0,0,40,6,0,0,0,0,0,0,144,42,0,0,207,70,0,0,128,6,0,0,0,0,0,0,144,42,0,0,236,70,0,0,64,6,0,0,0,0,0,0,144,42,0,0,253,70,0,0,24,6,0,0,0,0,0,0,144,42,0,0,14,71,0,0,40,8,0,0,0,0,0,0,144,42,0,0,31,71,0,0,128,6,0,0,0,0,0,0,144,42,0,0,122,71,0,0,128,6,0,0,0,0,0,0,144,42,0,0,222,71,0,0,88,6,0,0,0,0,0,0,144,42,0,0,240,71,0,0,40,7,0,0,0,0,0,0,144,42,0,0,3,72,0,0,40,7,0,0,0,0,0,0,144,42,0,0,72,72,0,0,80,9,0,0,0,0,0,0,104,42,0,0,89,72,0,0,144,42,0,0,113,72,0,0,104,7,0,0,0,0,0,0,144,42,0,0,139,72,0,0,144,7,0,0,0,0,0,0,144,42,0,0,157,72,0,0,56,0,0,0,0,0,0,0,144,42,0,0,182,72,0,0,112,7,0,0,0,0,0,0,144,42,0,0,197,72,0,0,144,7,0,0,0,0,0,0,144,42,0,0,228,72,0,0,96,2,0,0,0,0,0,0,144,42,0,0,101,73,0,0,96,2,0,0,0,0,0,0,144,42,0,0,211,73,0,0,104,7,0,0,0,0,0,0,144,42,0,0,230,73,0,0,120,4,0,0,0,0,0,0,144,42,0,0,253,73,0,0,120,4,0,0,0,0,0,0,144,42,0,0,19,74,0,0,120,4,0,0,0,0,0,0,104,42,0,0,40,74,0,0,104,42,0,0,55,74,0,0,144,42,0,0,163,74,0,0,120,6,0,0,0,0,0,0,144,42,0,0,191,74,0,0,120,6,0,0,0,0,0,0,144,42,0,0,222,74,0,0,104,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,42,0,0,2,75,0,0,144,42,0,0,35,75,0,0,176,3,0,0,0,0,0,0,144,42,0,0,206,75,0,0,192,8,0,0,0,0,0,0,144,42,0,0,231,75,0,0,104,8,0,0,0,0,0,0,144,42,0,0,8,76,0,0,192,8,0,0,0,0,0,0,144,42,0,0,26,76,0,0,176,3,0,0,0,0,0,0,104,42,0,0,45,76,0,0,144,42,0,0,60,76,0,0,192,8,0,0,0,0,0,0,144,42,0,0,90,76,0,0,232,8,0,0,0,0,0,0,104,42,0,0,110,76,0,0,144,42,0,0,149,76,0,0,64,3,0,0,0,0,0,0,144,42,0,0,182,76,0,0,64,3,0,0,0,0,0,0,144,42,0,0,201,76,0,0,240,8,0,0,0,0,0,0,144,42,0,0,236,76,0,0,232,8,0,0,0,0,0,0,144,42,0,0,255,76,0,0,232,8,0,0,0,0,0,0,104,42,0,0,24,77,0,0,104,42,0,0,50,77,0,0,144,42,0,0,71,77,0,0,96,9,0,0,0,0,0,0,104,42,0,0,100,77,0,0,144,42,0,0,22,78,0,0,120,9,0,0,0,0,0,0,104,42,0,0,35,78,0,0,104,42,0,0,48,78,0,0,144,42,0,0,61,78,0,0,128,9,0,0,0,0,0,0,144,42,0,0,94,78,0,0,136,9,0,0,0,0,0,0,144,42,0,0,164,78,0,0,136,9,0,0,0,0,0,0,144,42,0,0,128,78,0,0,168,9,0,0,0,0,0,0,144,42,0,0,198,78,0,0,152,9,0,0,0,0,0,0,144,42,0,0,235,78,0,0,152,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,72,0,0,0,3,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,96,0,0,0,5,0,0,0,6,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,0,0,0,7,0,0,0,8,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,160,0,0,0,9,0,0,0,10,0,0,0,3,0,0,0,1,0,0,0,0,0,0,0,184,0,0,0,4,0,0,0,11,0,0,0,12,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,200,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,5,0,0,0,2,0,0,0,17,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,6,0,0,0,18,0,0,0,7,0,0,0,1,0,0,0,2,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,19,0,0,0,13,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,5,0,0,0,20,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,1,0,0,0,2,0,0,0,21,0,0,0,20,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,22,0,0,0,21,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,248,0,0,0,23,0,0,0,24,0,0,0,1,0,0,0,0,0,0,0,232,0,0,0,25,0,0,0,26,0,0,0,7,0,0,0,3,0,0,0,0,0,0,0,16,1,0,0,27,0,0,0,28,0,0,0,29,0,0,0,1,0,0,0,22,0,0,0,23,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,6,0,0,0,3,0,0,0,30,0,0,0,0,0,0,0,64,1,0,0,27,0,0,0,31,0,0,0,29,0,0,0,1,0,0,0,22,0,0,0,24,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,7,0,0,0,4,0,0,0,30,0,0,0,3,0,0,0,0,0,0,0,80,1,0,0,27,0,0,0,32,0,0,0,33,0,0,0,1,0,0,0,25,0,0,0,26,0,0,0,1,0,0,0,2,0,0,0,5,0,0,0,8,0,0,0,5,0,0,0,0,0,0,0,32,1,0,0,27,0,0,0,34,0,0,0,35,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,9,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,1,0,0,27,0,0,0,36,0,0,0,35,0,0,0,1,0,0,0,27,0,0,0,28,0,0,0,1,0,0,0,3,0,0,0,6,0,0,0,10,0,0,0,7,0,0,0,0,0,0,0,120,1,0,0,27,0,0,0,37,0,0,0,38,0,0,0,1,0,0,0,29,0,0,0,30,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,11,0,0,0,8,0,0,0,4,0,0,0,0,0,0,0,136,1,0,0,27,0,0,0,39,0,0,0,40,0,0,0,1,0,0,0,31,0,0,0,32,0,0,0,1,0,0,0,5,0,0,0,8,0,0,0,12,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,152,1,0,0,41,0,0,0,42,0,0,0,5,0,0,0,1,0,0,0,6,0,0,0,43,0,0,0,13,0,0,0,5,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,192,1,0,0,44,0,0,0,45,0,0,0,1,0,0,0,33,0,0,0,7,0,0,0,8,0,0,0,6,0,0,0,0,0,0,0,176,1,0,0,46,0,0,0,47,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,0,0,48,0,0,0,49,0,0,0,2,0,0,0,34,0,0,0,35,0,0,0,3,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,4,0,0,0,14,0,0,0,50,0,0,0,15,0,0,0,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,25,0,0,0,51,0,0,0,2,0,0,0,9,0,0,0,10,215,163,60,0,0,0,0,32,2,0,0,8,0,0,0,52,0,0,0,53,0,0,0,3,0,0,0,16,0,0,0,10,0,0,0,40,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,48,2,0,0,8,0,0,0,54,0,0,0,55,0,0,0,3,0,0,0,16,0,0,0,10,0,0,0,40,0,0,0,8,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,64,2,0,0,56,0,0,0,57,0,0,0,3,0,0,0,11,0,0,0,41,0,0,0,42,0,0,0,12,0,0,0,13,0,0,0,9,0,0,0,17,0,0,0,9,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,10,0,0,0,43,0,0,0,0,0,0,0,80,2,0,0,58,0,0,0,59,0,0,0,11,0,0,0,0,0,0,0,104,2,0,0,60,0,0,0,61,0,0,0,21,0,0,0,22,0,0,0,14,0,0,0,23,0,0,0,0,0,0,0,24,3,0,0,62,0,0,0,63,0,0,0,4,0,0,0,0,0,0,0,8,3,0,0,62,0,0,0,64,0,0,0,5,0,0,0,0,0,0,0,248,2,0,0,62,0,0,0,65,0,0,0,6,0,0,0,0,0,0,0,232,2,0,0,62,0,0,0,66,0,0,0,7,0,0,0,0,0,0,0,216,2,0,0,62,0,0,0,67,0,0,0,8,0,0,0,0,0,0,0,200,2,0,0,62,0,0,0,68,0,0,0,9,0,0,0,0,0,0,0,184,2,0,0,62,0,0,0,69,0,0,0,10,0,0,0,0,0,0,0,168,2,0,0,62,0,0,0,70,0,0,0,11,0,0,0,0,0,0,0,152,2,0,0,62,0,0,0,71,0,0,0,12,0,0,0,0,0,0,0,128,2,0,0,62,0,0,0,72,0,0,0,13,0,0,0,0,0,0,0,40,3,0,0,73,0,0,0,74,0,0,0,9,0,0,0,44,0,0,0,0,0,0,0,48,3,0,0,75,0,0,0,76,0,0,0,1,0,0,0,1,0,0,0,45,0,0,0,0,0,0,0,72,3,0,0,77,0,0,0,78,0,0,0,2,0,0,0,2,0,0,0,46,0,0,0,0,0,0,0,88,3,0,0,79,0,0,0,80,0,0,0,10,0,0,0,0,0,0,0,128,3,0,0,81,0,0,0,82,0,0,0,11,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,47,0,0,0,24,0,0,0,1,0,0,0,25,0,0,0,48,0,0,0,9,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,49,0,0,0,11,0,0,0,12,0,0,0,3,0,0,0,12,0,0,0,13,0,0,0,27,0,0,0,13,0,0,0,12,0,0,0,28,0,0,0,29,0,0,0,14,0,0,0,14,0,0,0,30,0,0,0,15,0,0,0,1,0,0,0,16,0,0,0,0,0,0,0,112,3,0,0,83,0,0,0,84,0,0,0,17,0,0,0,0,0,0,0,104,3,0,0,10,0,0,0,50,0,0,0,15,0,0,0,85,0,0,0,86,0,0,0,0,0,0,0,144,3,0,0,87,0,0,0,88,0,0,0,4,0,0,0,3,0,0,0,51,0,0,0,0,0,0,0,160,3,0,0,89,0,0,0,90,0,0,0,16,0,0,0,17,0,0,0,3,0,0,0,0,0,0,0,184,3,0,0,91,0,0,0,92,0,0,0,15,0,0,0,16,0,0,0,5,0,0,0,2,0,0,0,93,0,0,0,1,0,0,0,2,0,0,0,18,0,0,0,52,0,0,0,18,0,0,0,53,0,0,0,0,0,0,0,144,4,0,0,83,0,0,0,94,0,0,0,19,0,0,0,1,0,0,0,0,0,0,0,128,4,0,0,83,0,0,0,95,0,0,0,19,0,0,0,2,0,0,0,0,0,0,0,104,4,0,0,96,0,0,0,97,0,0,0,18,0,0,0,54,0,0,0,5,0,0,0,13,0,0,0,14,0,0,0,0,0,0,0,72,4,0,0,83,0,0,0,98,0,0,0,20,0,0,0,1,0,0,0,0,0,0,0,56,4,0,0,83,0,0,0,99,0,0,0,20,0,0,0,2,0,0,0,0,0,0,0,40,4,0,0,25,0,0,0,100,0,0,0,15,0,0,0,10,0,0,0,0,0,0,0,24,4,0,0,101,0,0,0,102,0,0,0,16,0,0,0,0,0,0,0,248,3,0,0,101,0,0,0,103,0,0,0,17,0,0,0,0,0,0,0,224,3,0,0,89,0,0,0,104,0,0,0,16,0,0,0,17,0,0,0,4,0,0,0,0,0,0,0,192,3,0,0,105,0,0,0,106,0,0,0,21,0,0,0,22,0,0,0,252,255,255,255,192,3,0,0,107,0,0,0,108,0,0,0,23,0,0,0,0,0,0,0,88,4,0,0,109,0,0,0,110,0,0,0,18,0,0,0,11,0,0,0,0,0,0,0,160,4,0,0,111,0,0,0,112,0,0,0,5,0,0,0,4,0,0,0,55,0,0,0,0,0,0,0,176,4,0,0,113,0,0,0,114,0,0,0,14,0,0,0,0,0,0,0,192,4,0,0,115,0,0,0,116,0,0,0,6,0,0,0,5,0,0,0,56,0,0,0,0,0,0,0,240,4,0,0,89,0,0,0,117,0,0,0,19,0,0,0,20,0,0,0,5,0,0,0,0,0,0,0,224,4,0,0,89,0,0,0,118,0,0,0,21,0,0,0,22,0,0,0,6,0,0,0,0,0,0,0,208,4,0,0,89,0,0,0,119,0,0,0,16,0,0,0,17,0,0,0,7,0,0,0,0,0,0,0,0,5,0,0,120,0,0,0,121,0,0,0,7,0,0,0,6,0,0,0,57,0,0,0,0,0,0,0,16,5,0,0,96,0,0,0,122,0,0,0,18,0,0,0,58,0,0,0,5,0,0,0,13,0,0,0,14,0,0,0,0,0,0,0,32,5,0,0,123,0,0,0,124,0,0,0,8,0,0,0,7,0,0,0,59,0,0,0,0,0,0,0,48,5,0,0,96,0,0,0,125,0,0,0,23,0,0,0,60,0,0,0,5,0,0,0,13,0,0,0,14,0,0,0,0,0,0,0,64,5,0,0,126,0,0,0,127,0,0,0,24,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,61,0,0,0,31,0,0,0,2,0,0,0,32,0,0,0,48,0,0,0,11,0,0,0,3,0,0,0,33,0,0,0,16,0,0,0,49,0,0,0,62,0,0,0,128,0,0,0,0,0,0,0,80,5,0,0,129,0,0,0,130,0,0,0,25,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,63,0,0,0,24,0,0,0,3,0,0,0,34,0,0,0,64,0,0,0,9,0,0,0,2,0,0,0,35,0,0,0,17,0,0,0,49,0,0,0,24,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,112,5,0,0,129,0,0,0,131,0,0,0,25,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,63,0,0,0,24,0,0,0,3,0,0,0,37,0,0,0,65,0,0,0,9,0,0,0,2,0,0,0,35,0,0,0,17,0,0,0,49,0,0,0,24,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,96,5,0,0,129,0,0,0,132,0,0,0,25,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,63,0,0,0,24,0,0,0,3,0,0,0,38,0,0,0,66,0,0,0,9,0,0,0,2,0,0,0,35,0,0,0,17,0,0,0,49,0,0,0,24,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,128,5,0,0,129,0,0,0,133,0,0,0,27,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,47,0,0,0,24,0,0,0,4,0,0,0,39,0,0,0,48,0,0,0,12,0,0,0,4,0,0,0,26,0,0,0,15,0,0,0,49,0,0,0,27,0,0,0,28,0,0,0,3,0,0,0,28,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,144,5,0,0,134,0,0,0,135,0,0,0,29,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,67,0,0,0,40,0,0,0,5,0,0,0,41,0,0,0,48,0,0,0,13,0,0,0,5,0,0,0,42,0,0,0,18,0,0,0,49,0,0,0,30,0,0,0,29,0,0,0,30,0,0,0,68,0,0,0,69,0,0,0,0,0,0,0,200,5,0,0,136,0,0,0,137,0,0,0,31,0,0,0,0,0,0,0,184,5,0,0,136,0,0,0,138,0,0,0,32,0,0,0,0,0,0,0,160,5,0,0,136,0,0,0,139,0,0,0,33,0,0,0,0,0,0,0,216,5,0,0,140,0,0,0,141,0,0,0,29,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,70,0,0,0,40,0,0,0,5,0,0,0,43,0,0,0,48,0,0,0,13,0,0,0,5,0,0,0,44,0,0,0,19,0,0,0,49,0,0,0,31,0,0,0,29,0,0,0,30,0,0,0,0,0,0,0,248,5,0,0,142,0,0,0,143,0,0,0,32,0,0,0,0,0,0,0,232,5,0,0,83,0,0,0,144,0,0,0,33,0,0,0,0,0,0,0,8,6,0,0,145,0,0,0,146,0,0,0,34,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,71,0,0,0,45,0,0,0,6,0,0,0,46,0,0,0,48,0,0,0,13,0,0,0,5,0,0,0,47,0,0,0,20,0,0,0,49,0,0,0,35,0,0,0,0,0,0,0,24,6,0,0,81,0,0,0,147,0,0,0,25,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,47,0,0,0,24,0,0,0,7,0,0,0,1,0,0,0,48,0,0,0,9,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,49,0,0,0,11,0,0,0,34,0,0,0,3,0,0,0,36,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,6,0,0,148,0,0,0,149,0,0,0,37,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,72,0,0,0,24,0,0,0,7,0,0,0,48,0,0,0,48,0,0,0,9,0,0,0,2,0,0,0,49,0,0,0,21,0,0,0,49,0,0,0,35,0,0,0,36,0,0,0,3,0,0,0,38,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,12,0,0,0,50,0,0,0,51,0,0,0,39,0,0,0,37,0,0,0,52,0,0,0,40,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,136,6,0,0,129,0,0,0,150,0,0,0,41,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,24,0,0,0,8,0,0,0,53,0,0,0,74,0,0,0,14,0,0,0,2,0,0,0,54,0,0,0,22,0,0,0,49,0,0,0,11,0,0,0,38,0,0,0,3,0,0,0,42,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,168,6,0,0,129,0,0,0,151,0,0,0,41,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,24,0,0,0,8,0,0,0,55,0,0,0,74,0,0,0,14,0,0,0,2,0,0,0,54,0,0,0,22,0,0,0,49,0,0,0,11,0,0,0,38,0,0,0,3,0,0,0,42,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,152,6,0,0,129,0,0,0,152,0,0,0,41,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,24,0,0,0,8,0,0,0,56,0,0,0,74,0,0,0,14,0,0,0,2,0,0,0,54,0,0,0,22,0,0,0,49,0,0,0,11,0,0,0,38,0,0,0,3,0,0,0,42,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,184,6,0,0,81,0,0,0,153,0,0,0,37,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,75,0,0,0,57,0,0,0,7,0,0,0,58,0,0,0,48,0,0,0,9,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,49,0,0,0,39,0,0,0,40,0,0,0,3,0,0,0,43,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,12,0,0,0,59,0,0,0,60,0,0,0,44,0,0,0,41,0,0,0,61,0,0,0,45,0,0,0,3,0,0,0,0,0,0,0,200,6,0,0,142,0,0,0,154,0,0,0,46,0,0,0,0,0,0,0,232,6,0,0,81,0,0,0,155,0,0,0,47,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,76,0,0,0,24,0,0,0,9,0,0,0,62,0,0,0,48,0,0,0,15,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,49,0,0,0,42,0,0,0,43,0,0,0,3,0,0,0,48,0,0,0,13,0,0,0,63,0,0,0,44,0,0,0,12,0,0,0,64,0,0,0,65,0,0,0,49,0,0,0,45,0,0,0,66,0,0,0,50,0,0,0,4,0,0,0,46,0,0,0,0,0,0,0,248,6,0,0,156,0,0,0,157,0,0,0,15,0,0,0,67,0,0,0,23,0,0,0,77,0,0,0,78,0,0,0,16,0,0,0,0,0,0,0,24,7,0,0,142,0,0,0,158,0,0,0,51,0,0,0,0,0,0,0,8,7,0,0,142,0,0,0,159,0,0,0,52,0,0,0,0,0,0,0,40,7,0,0,129,0,0,0,160,0,0,0,53,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,79,0,0,0,24,0,0,0,10,0,0,0,68,0,0,0,80,0,0,0,16,0,0,0,2,0,0,0,69,0,0,0,24,0,0,0,49,0,0,0,47,0,0,0,48,0,0,0,3,0,0,0,54,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,6,0,0,0,0,0,0,0,56,7,0,0,129,0,0,0,161,0,0,0,53,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,79,0,0,0,24,0,0,0,10,0,0,0,70,0,0,0,80,0,0,0,16,0,0,0,2,0,0,0,69,0,0,0,24,0,0,0,49,0,0,0,47,0,0,0,49,0,0,0,3,0,0,0,55,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,7,0,0,0,0,0,0,0,72,7,0,0,129,0,0,0,162,0,0,0,53,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,79,0,0,0,24,0,0,0,10,0,0,0,71,0,0,0,80,0,0,0,16,0,0,0,2,0,0,0,69,0,0,0,24,0,0,0,49,0,0,0,47,0,0,0,50,0,0,0,3,0,0,0,56,0,0,0,13,0,0,0,36,0,0,0,26,0,0,0,8,0,0,0,0,0,0,0,88,7,0,0,163,0,0,0,164,0,0,0,57,0,0,0,1,0,0,0,2,0,0,0,81,0,0,0,82,0,0,0,72,0,0,0,83,0,0,0,84,0,0,0,73,0,0,0,51,0,0,0,52,0,0,0,74,0,0,0,25,0,0,0,0,0,0,0,160,7,0,0,165,0,0,0,166,0,0,0,1,0,0,0,53,0,0,0,9,0,0,0,58,0,0,0,2,0,0,0,59,0,0,0,85,0,0,0,75,0,0,0,76,0,0,0,54,0,0,0,86,0,0,0,167,0,0,0,0,0,0,0,112,7,0,0,165,0,0,0,168,0,0,0,1,0,0,0,53,0,0,0,9,0,0,0,58,0,0,0,2,0,0,0,59,0,0,0,85,0,0,0,75,0,0,0,76,0,0,0,54,0,0,0,86,0,0,0,167,0,0,0,0,0,0,0,128,7,0,0,169,0,0,0,170,0,0,0,26,0,0,0,17,0,0,0,55,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,56,0,0,0,80,0,0,0,57,0,0,0,87,0,0,0,58,0,0,0,27,0,0,0,81,0,0,0,88,0,0,0,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,7,0,0,171,0,0,0,172,0,0,0,28,0,0,0,18,0,0,0,59,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,60,0,0,0,85,0,0,0,61,0,0,0,90,0,0,0,62,0,0,0,29,0,0,0,86,0,0,0,91,0,0,0,92,0,0,0,0,0,0,0,208,7,0,0,58,0,0,0,173,0,0,0,19,0,0,0,0,0,0,0,192,7,0,0,58,0,0,0,174,0,0,0,20,0,0,0,0,0,0,0,224,7,0,0,175,0,0,0,176,0,0,0,2,0,0,0,63,0,0,0,10,0,0,0,60,0,0,0,3,0,0,0,61,0,0,0,93,0,0,0,87,0,0,0,88,0,0,0,64,0,0,0,94,0,0,0,177,0,0,0,0,0,0,0,16,8,0,0,96,0,0,0,178,0,0,0,65,0,0,0,95,0,0,0,5,0,0,0,13,0,0,0,14,0,0,0,0,0,0,0,0,8,0,0,96,0,0,0,179,0,0,0,18,0,0,0,96,0,0,0,5,0,0,0,13,0,0,0,14,0,0,0,0,0,0,0,240,7,0,0,96,0,0,0,180,0,0,0,18,0,0,0,97,0,0,0,5,0,0,0,13,0,0,0,14,0,0,0,0,0,0,0,40,8,0,0,181,0,0,0,182,0,0,0,15,0,0,0,67,0,0,0,23,0,0,0,77,0,0,0,78,0,0,0,0,0,0,0,0,0,0,0,64,8,0,0,83,0,0,0,183,0,0,0,20,0,0,0,1,0,0,0,0,0,0,0,80,8,0,0,184,0,0,0,185,0,0,0,1],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([112,8,0,0,89,0,0,0,186,0,0,0,66,0,0,0,67,0,0,0,8,0,0,0,0,0,0,0,128,8,0,0,187,0,0,0,188,0,0,0,1,0,0,0,0,0,0,0,144,8,0,0,184,0,0,0,189,0,0,0,2,0,0,0,0,0,0,0,160,8,0,0,187,0,0,0,190,0,0,0,2,0,0,0,0,0,0,0,176,8,0,0,89,0,0,0,191,0,0,0,68,0,0,0,69,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,8,0,0,187,0,0,0,192,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,8,0,0,193,0,0,0,194,0,0,0,11,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,9,0,0,195,0,0,0,196,0,0,0,12,0,0,0,8,0,0,0,98,0,0,0,0,0,0,0,16,9,0,0,197,0,0,0,198,0,0,0,13,0,0,0,9,0,0,0,99,0,0,0,0,0,0,0,32,9,0,0,193,0,0,0,199,0,0,0,14,0,0,0,0,0,0,0,48,9,0,0,193,0,0,0,200,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,9,0,0,201,0,0,0,202,0,0,0,30,0,0,0,31,0,0,0,89,0,0,0,0,0,0,0,72,9,0,0,203,0,0,0,204,0,0,0,0,0,0,0,80,9,0,0,205,0,0,0,206,0,0,0,57,0,0,0,1,0,0,0,2,0,0,0,81,0,0,0,82,0,0,0,72,0,0,0,100,0,0,0,101,0,0,0,73,0,0,0,51,0,0,0,52,0,0,0,74,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,104,9,0,0,207,0,0,0,208,0,0,0,90,0,0,0,0,0,0,0,0,0,0,0,152,9,0,0,209,0,0,0,210,0,0,0,211,0,0,0,212,0,0,0,32,0,0,0,4,0,0,0,16,0,0,0,62,0,0,0,0,0,0,0,200,9,0,0,209,0,0,0,213,0,0,0,211,0,0,0,212,0,0,0,32,0,0,0,5,0,0,0,17,0,0,0,63,0,0,0,0,0,0,0,216,9,0,0,209,0,0,0,214,0,0,0,211,0,0,0,212,0,0,0,32,0,0,0,6,0,0,0,18,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,0,0,0,34,0,0,0,221,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,57,98,116,71,104,111,115,116,80,97,105,114,67,97,108,108,98,97,99,107,0,50,53,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,108,108,98,97,99,107,0,49,56,98,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,52,67,108,111,115,101,115,116,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,50,48,98,116,68,101,102,97,117,108,116,77,111,116,105,111,110,83,116,97,116,101,0,49,51,98,116,77,111,116,105,111,110,83,116,97,116,101,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,55,67,108,111,115,101,115,116,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,123,32,118,97,114,32,115,101,108,102,32,61,32,77,111,100,117,108,101,91,39,103,101,116,67,97,99,104,101,39,93,40,77,111,100,117,108,101,91,39,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,39,93,41,91,36,48,93,59,32,105,102,32,40,33,115,101,108,102,46,104,97,115,79,119,110,80,114,111,112,101,114,116,121,40,39,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,39,41,41,32,116,104,114,111,119,32,39,97,32,74,83,73,109,112,108,101,109,101,110,116,97,116,105,111,110,32,109,117,115,116,32,105,109,112,108,101,109,101,110,116,32,97,108,108,32,102,117,110,99,116,105,111,110,115,44,32,121,111,117,32,102,111,114,103,111,116,32,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,58,58,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,46,39,59,32,114,101,116,117,114,110,32,115,101,108,102,91,39,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,39,93,40,36,49,44,36,50,44,36,51,44,36,52,44,36,53,44,36,54,44,36,55,41,59,32,125,0,50,57,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,49,49,98,116,82,105,103,105,100,66,111,100,121,0,98,116,82,105,103,105,100,66,111,100,121,70,108,111,97,116,68,97,116,97,0,50,51,98,116,68,105,115,99,114,101,116,101,68,121,110,97,109,105,99,115,87,111,114,108,100,0,100,101,98,117,103,68,114,97,119,87,111,114,108,100,0,115,121,110,99,104,114,111,110,105,122,101,77,111,116,105,111,110,83,116,97,116,101,115,0,115,116,101,112,83,105,109,117,108,97,116,105,111,110,0,105,110,116,101,114,110,97,108,83,105,110,103,108,101,83,116,101,112,83,105,109,117,108,97,116,105,111,110,0,117,112,100,97,116,101,65,99,116,105,111,110,115,0,99,114,101,97,116,101,80,114,101,100,105,99,116,105,118,101,67,111,110,116,97,99,116,115,0,114,101,108,101,97,115,101,32,112,114,101,100,105,99,116,105,118,101,32,99,111,110,116,97,99,116,32,109,97,110,105,102,111,108,100,115,0,112,114,101,100,105,99,116,105,118,101,32,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,117,112,100,97,116,101,65,99,116,105,118,97,116,105,111,110,83,116,97,116,101,0,115,111,108,118,101,67,111,110,115,116,114,97,105,110,116,115,0,99,97,108,99,117,108,97,116,101,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,115,0,105,110,116,101,103,114,97,116,101,84,114,97,110,115,102,111,114,109,115,0,67,67,68,32,109,111,116,105,111,110,32,99,108,97,109,112,105,110,103,0,97,112,112,108,121,32,115,112,101,99,117,108,97,116,105,118,101,32,99,111,110,116,97,99,116,32,114,101,115,116,105,116,117,116,105,111,110,0,112,114,101,100,105,99,116,85,110,99,111,110,115,116,114,97,105,110,116,77,111,116,105,111,110,0,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,70,108,111,97,116,68,97,116,97,0,49,53,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,0,51,52,98,116,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,50,55,73,110,112,108,97,99,101,83,111,108,118,101,114,73,115,108,97,110,100,67,97,108,108,98,97,99,107,0,78,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,49,52,73,115,108,97,110,100,67,97,108,108,98,97,99,107,69,0,50,51,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,0,49,55,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,0,49,51,98,116,84,121,112,101,100,79,98,106,101,99,116,0,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,50,57,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,67,111,110,115,116,114,97,105,110,116,0,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,50,51,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,0,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,49,56,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,0,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,50,49,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,0,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,49,55,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,0,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,51,53,98,116,83,101,113,117,101,110,116,105,97,108,73,109,112,117,108,115,101,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,83,101,116,117,112,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,73,116,101,114,97,116,105,111,110,115,0,115,111,108,118,101,71,114,111,117,112,0,49,56,98,116,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,50,53,98,116,68,101,102,97,117,108,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,49,54,98,116,82,97,121,99,97,115,116,86,101,104,105,99,108,101,0,49,55,98,116,65,99,116,105,111,110,73,110,116,101,114,102,97,99,101,0,51,48,98,116,75,105,110,101,109,97,116,105,99,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,0,51,48,98,116,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,73,110,116,101,114,102,97,99,101,0,52,51,98,116,75,105,110,101,109,97,116,105,99,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,0,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,70,108,111,97,116,68,97,116,97,0,49,51,98,116,71,104,111,115,116,79,98,106,101,99,116,0,50,52,98,116,80,97,105,114,67,97,99,104,105,110,103,71,104,111,115,116,79,98,106,101,99,116,0,50,49,98,116,67,111,108,108,105,115,105,111,110,68,105,115,112,97,116,99,104,101,114,0,50,51,98,116,67,111,108,108,105,115,105,111,110,80,97,105,114,67,97,108,108,98,97,99,107,0,49,55,98,116,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,51,49,98,116,68,101,102,97,117,108,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,50,52,98,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,78,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,51,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,67,114,101,97,116,101,70,117,110,99,0,78,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,78,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,0,105,115,108,97,110,100,85,110,105,111,110,70,105,110,100,65,110,100,81,117,105,99,107,83,111,114,116,0,112,114,111,99,101,115,115,73,115,108,97,110,100,115,0,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,52,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,78,49,50,98,116,67,111,110,118,101,120,67,97,115,116,49,48,67,97,115,116,82,101,115,117,108,116,69,0,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,68,97,116,97,0,84,114,105,97,110,103,108,101,0,90,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,50,49,99,97,108,99,117,108,97,116,101,84,105,109,101,79,102,73,109,112,97,99,116,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,51,49,76,111,99,97,108,84,114,105,97,110,103,108,101,83,112,104,101,114,101,67,97,115,116,67,97,108,108,98,97,99,107,0,49,53,98,116,84,114,105,97,110,103,108,101,83,104,97,112,101,0,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,78,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,54,82,101,115,117,108,116,69,0,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,0,1,79,118,101,114,102,108,111,119,32,105,110,32,65,65,66,66,44,32,111,98,106,101,99,116,32,114,101,109,111,118,101,100,32,102,114,111,109,32,115,105,109,117,108,97,116,105,111,110,0,73,102,32,121,111,117,32,99,97,110,32,114,101,112,114,111,100,117,99,101,32,116,104,105,115,44,32,112,108,101,97,115,101,32,101,109,97,105,108,32,98,117,103,115,64,99,111,110,116,105,110,117,111,117,115,112,104,121,115,105,99,115,46,99,111,109,10,0,80,108,101,97,115,101,32,105,110,99,108,117,100,101,32,97,98,111,118,101,32,105,110,102,111,114,109,97,116,105,111,110,44,32,121,111,117,114,32,80,108,97,116,102,111,114,109,44,32,118,101,114,115,105,111,110,32,111,102,32,79,83,46,10,0,84,104,97,110,107,115,46,10,0,117,112,100,97,116,101,65,97,98,98,115,0,99,97,108,99,117,108,97,116,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,0,112,101,114,102,111,114,109,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,105,111,110,0,100,105,115,112,97,116,99,104,65,108,108,67,111,108,108,105,115,105,111,110,80,97,105,114,115,0,99,111,110,118,101,120,83,119,101,101,112,67,111,109,112,111,117,110,100,0,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,49,55,68,101,98,117,103,68,114,97,119,99,97,108,108,98,97,99,107,0,50,51,98,116,66,114,105,100,103,101,100,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,50,52,98,116,66,114,111,97,100,112,104,97,115,101,65,97,98,98,67,97,108,108,98,97,99,107,0,50,49,98,116,83,105,110,103,108,101,83,119,101,101,112,67,97,108,108,98,97,99,107,0,50,51,98,116,66,114,111,97,100,112,104,97,115,101,82,97,121,67,97,108,108,98,97,99,107,0,49,57,98,116,83,105,110,103,108,101,82,97,121,67,97,108,108,98,97,99,107,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,49,52,76,111,99,97,108,73,110,102,111,65,100,100,101,114,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,49,53,76,111,99,97,108,73,110,102,111,65,100,100,101,114,50,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,57,82,97,121,84,101,115,116,101,114,0,78,54,98,116,68,98,118,116,56,73,67,111,108,108,105,100,101,69,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,0,50,52,98,116,80,101,114,116,117,114,98,101,100,67,111,110,116,97,99,116,82,101,115,117,108,116,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,50,49,98,116,87,105,116,104,111,117,116,77,97,114,103,105,110,82,101,115,117,108,116,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,49,51,98,116,68,117,109,109,121,82,101,115,117,108,116,0,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,50,98,116,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,51,48,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,49,53,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,67,104,105,108,100,68,97,116,97,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,68,97,116,97,0,67,111,109,112,111,117,110,100,0,49,49,98,116,67,111,110,101,83,104,97,112,101,0,67,111,110,101,88,0,67,111,110,101,90,0,98,116,67,111,110,101,83,104,97,112,101,68,97,116,97,0,67,111,110,101,0,49,50,98,116,67,111,110,101,83,104,97,112,101,88,0,49,50,98,116,67,111,110,101,83,104,97,112,101,90,0,49,51,98,116,83,112,104,101,114,101,83,104,97,112,101,0,83,80,72,69,82,69,0,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,68,97,116,97,0,66,86,72,84,82,73,65,78,71,76,69,77,69,83,72,0,90,78,75,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,50,49,98,116,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,55,112,101,114,102,111,114,109,67,111,110,118,101,120,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,83,52,95,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,52,112,101,114,102,111,114,109,82,97,121,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,84,82,73,65,78,71,76,69,77,69,83,72,0,50,49,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,90,78,75,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,49,54,70,105,108,116,101,114,101,100,67,97,108,108,98,97,99,107,0,49,56,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,0,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,68,97,116,97,0,83,84,65,84,73,67,80,76,65,78,69,0,50,51,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,83,104,97,112,101,0,51,52,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,65,97,98,98,67,97,99,104,105,110,103,83,104,97,112,101,0,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,0,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,68,97,116,97,0,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,0,50,49,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,0,49,55,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,0,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,68,97,116,97,0,67,111,110,118,101,120,0,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,51,49,98,116,73,110,116,101,114,110,97,108,84,114,105,97,110,103,108,101,73,110,100,101,120,67,97,108,108,98,97,99,107,0,49,52,98,116,67,97,112,115,117,108,101,83,104,97,112,101,0,67,97,112,115,117,108,101,90,0,67,97,112,115,117,108,101,88,0,98,116,67,97,112,115,117,108,101,83,104,97,112,101,68,97,116,97,0,67,97,112,115,117,108,101,83,104,97,112,101,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,90,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,88,0,50,53,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,67,111,110,118,101,120,84,114,105,109,101,115,104,0,50,54,76,111,99,97,108,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,49,52,98,116,67,111,110,99,97,118,101,83,104,97,112,101,0,49,48,98,116,66,111,120,83,104,97,112,101,0,66,111,120,0,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,48,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,57,81,117,97,110,116,105,122,101,100,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,49,53,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,88,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,90,0,67,121,108,105,110,100,101,114,90,0,67,121,108,105,110,100,101,114,88,0,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,68,97,116,97,0,67,121,108,105,110,100,101,114,89,0,49,52,98,116,84,114,105,97,110,103,108,101,77,101,115,104,0,50,49,98,116,66,114,111,97,100,112,104,97,115,101,73,110,116,101,114,102,97,99,101,0,50,48,98,116,65,120,105,115,83,119,101,101,112,51,73,110,116,101,114,110,97,108,73,116,69,0,49,53,98,116,78,117,108,108,80,97,105,114,67,97,99,104,101,0,50,50,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,49,50,98,116,65,120,105,115,83,119,101,101,112,51,0,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,51,55,114,101,109,111,118,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,67,111,110,116,97,105,110,105,110,103,80,114,111,120,121,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,56,82,101,109,111,118,101,80,97,105,114,67,97,108,108,98,97,99,107,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,49,57,99,108,101,97,110,80,114,111,120,121,70,114,111,109,80,97,105,114,115,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,55,67,108,101,97,110,80,97,105,114,67,97,108,108,98,97,99,107,0,49,54,98,116,68,98,118,116,66,114,111,97,100,112,104,97,115,101,0,50,48,66,114,111,97,100,112,104,97,115,101,65,97,98,98,84,101,115,116,101,114,0,49,57,66,114,111,97,100,112,104,97,115,101,82,97,121,84,101,115,116,101,114,0,49,56,98,116,68,98,118,116,84,114,101,101,67,111,108,108,105,100,101,114,0,49,50,98,116,68,105,115,112,97,116,99,104,101,114,0,49,52,98,116,81,117,97,110,116,105,122,101,100,66,118,104,0,98,116,79,112,116,105,109,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,98,116,66,118,104,83,117,98,116,114,101,101,73,110,102,111,68,97,116,97,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,70,108,111,97,116,68,97,116,97,0,50,53,98,116,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,50,56,98,116,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,51,48,98,116,67,111,110,118,101,120,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,90,78,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,49,50,99,97,108,99,80,101,110,68,101,112,116,104,69,82,50,50,98,116,86,111,114,111,110,111,105,83,105,109,112,108,101,120,83,111,108,118,101,114,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,83,52,95,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,55,95,82,57,98,116,86,101,99,116,111,114,51,83,57,95,83,57,95,80,49,50,98,116,73,68,101,98,117,103,68,114,97,119,69,50,48,98,116,73,110,116,101,114,109,101,100,105,97,116,101,82,101,115,117,108,116,0,50,50,98,116,83,117,98,115,105,109,112,108,101,120,67,111,110,118,101,120,67,97,115,116,0,51,48,98,116,71,106,107,69,112,97,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,49,53,98,116,71,106,107,67,111,110,118,101,120,67,97,115,116,0,49,54,98,116,80,111,105,110,116,67,111,108,108,101,99,116,111,114,0,49,50,98,116,67,111,110,118,101,120,67,97,115,116,0,50,55,98,116,67,111,110,116,105,110,117,111,117,115,67,111,110,118,101,120,67,111,108,108,105,115,105,111,110,0,49,55,98,116,71,106,107,80,97,105,114,68,101,116,101,99,116,111,114,0,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,0,51,48,98,116,65,99,116,105,118,97,116,105,110,103,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,0,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,49,54,98,116,66,111,120,66,111,120,68,101,116,101,99,116,111,114,0,50,50,83,112,104,101,114,101,84,114,105,97,110,103,108,101,68,101,116,101,99,116,111,114,0,50,51,98,116,72,97,115,104,101,100,83,105,109,112,108,101,80,97,105,114,67,97,99,104,101,0,49,56,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,0,50,54,98,116,84,114,105,97,110,103,108,101,73,110,100,101,120,86,101,114,116,101,120,65,114,114,97,121,0,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,0,98,116,73,110,116,73,110,100,101,120,68,97,116,97,0,98,116,83,104,111,114,116,73,110,116,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,98,116,67,104,97,114,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,98,116,86,101,99,116,111,114,51,70,108,111,97,116,68,97,116,97,0,98,116,86,101,99,116,111,114,51,68,111,117,98,108,101,68,97,116,97,0,98,116,77,101,115,104,80,97,114,116,68,97,116,97,0,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,68,97,116,97,0,82,111,111,116,0,83,116,57,98,97,100,95,97,108,108,111,99,0,83,116,57,101,120,99,101,112,116,105,111,110,0,83,116,57,116,121,112,101,95,105,110,102,111,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,116,101,114,109,105,110,97,116,105,110,103,0,117,110,99,97],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+10340);allocate([117,103,104,116,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,0,0,0,0,0,0,0,0,17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+20580);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}var _cosf=Math_cos;Module["_i64Subtract"]=_i64Subtract;var _fabsf=Math_abs;function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:return totalMemory/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}function _pthread_cleanup_pop(){assert(_pthread_cleanup_push.level==__ATEXIT__.length,"cannot pop if something else added meanwhile!");__ATEXIT__.pop();_pthread_cleanup_push.level=__ATEXIT__.length}function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}Module["_memset"]=_memset;var _BDtoILow=true;Module["_bitshift64Shl"]=_bitshift64Shl;function _abort(){Module["abort"]()}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}var _acosf=Math_acos;var _sqrtf=Math_sqrt;var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}Module["_i64Add"]=_i64Add;var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}var _llvm_pow_f32=Math_pow;function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function ___cxa_allocate_exception(size){return _malloc(size)}Module["_bitshift64Lshr"]=_bitshift64Lshr;function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}var _asinf=Math_asin;var _BDtoIHigh=true;function _pthread_cleanup_push(routine,arg){__ATEXIT__.push((function(){Runtime.dynCall("vi",routine,[arg])}));_pthread_cleanup_push.level=__ATEXIT__.length}function ___cxa_guard_acquire(variable){if(!HEAP8[variable>>0]){HEAP8[variable>>0]=1;return 1}return 0}function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}function ___cxa_guard_release(){}var _emscripten_asm_const_double=true;function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}var _sinf=Math_sin;function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;var SYSCALLS={varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}Module["_memmove"]=_memmove;var _atan2f=Math_atan2;var _BItoD=true;Module["_llvm_bswap_i32"]=_llvm_bswap_i32;function _llvm_trap(){abort("trap!")}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function _pthread_self(){return 0}function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;assert(offset_high===0);FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.get(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();var ret=0;if(!___syscall146.buffer)___syscall146.buffer=[];var buffer=___syscall146.buffer;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];for(var j=0;j<len;j++){var curr=HEAPU8[ptr+j];if(curr===0||curr===10){Module["print"](UTF8ArrayToString(buffer,0));buffer.length=0}else{buffer.push(curr)}}ret+=len}return ret}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var _UItoF=true;STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vid(index,a1,a2){try{Module["dynCall_vid"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiidii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_iiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidi(index,a1,a2,a3,a4){try{Module["dynCall_viidi"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viddiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidii(index,a1,a2,a3,a4){try{Module["dynCall_vidii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidi(index,a1,a2,a3){try{Module["dynCall_vidi"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_diiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiddddiid(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{Module["dynCall_viiiiddddiid"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiid(index,a1,a2,a3){try{return Module["dynCall_iiid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_di(index,a1){try{return Module["dynCall_di"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiidii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_diiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diii(index,a1,a2,a3){try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_diiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiid(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_diiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_did(index,a1,a2){try{return Module["dynCall_did"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiidddddidi(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{Module["dynCall_viiiidddddidi"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diidii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiii(index,a1,a2,a3,a4){try{return Module["dynCall_diiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiid(index,a1,a2,a3,a4){try{Module["dynCall_viiid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viid(index,a1,a2,a3){try{Module["dynCall_viid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iidid(index,a1,a2,a3,a4){try{return Module["dynCall_iidid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_viiiii":invoke_viiiii,"invoke_vid":invoke_vid,"invoke_vi":invoke_vi,"invoke_viiidii":invoke_viiidii,"invoke_vii":invoke_vii,"invoke_iiiiiiiiiii":invoke_iiiiiiiiiii,"invoke_ii":invoke_ii,"invoke_viidi":invoke_viidi,"invoke_viddiii":invoke_viddiii,"invoke_vidii":invoke_vidii,"invoke_iiiii":invoke_iiiii,"invoke_vidi":invoke_vidi,"invoke_diiiiiiii":invoke_diiiiiiii,"invoke_viiiiddddiid":invoke_viiiiddddiid,"invoke_diiiii":invoke_diiiii,"invoke_iiii":invoke_iiii,"invoke_viiiiii":invoke_viiiiii,"invoke_iiid":invoke_iiid,"invoke_di":invoke_di,"invoke_iiiiiii":invoke_iiiiiii,"invoke_diiidii":invoke_diiidii,"invoke_viidii":invoke_viidii,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiiiiiii":invoke_viiiiiiiii,"invoke_viiiiiiiiii":invoke_viiiiiiiiii,"invoke_iii":invoke_iii,"invoke_diii":invoke_diii,"invoke_diiiiiiiiii":invoke_diiiiiiiiii,"invoke_viiiid":invoke_viiiid,"invoke_diiiiiiiii":invoke_diiiiiiiii,"invoke_did":invoke_did,"invoke_viiiidddddidi":invoke_viiiidddddidi,"invoke_diidii":invoke_diidii,"invoke_diiii":invoke_diiii,"invoke_iiiiiiiiii":invoke_iiiiiiiiii,"invoke_viiid":invoke_viiid,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_viid":invoke_viid,"invoke_iidid":invoke_iidid,"invoke_viiii":invoke_viiii,"_pthread_cleanup_pop":_pthread_cleanup_pop,"_cosf":_cosf,"_pthread_key_create":_pthread_key_create,"_abort":_abort,"___cxa_guard_acquire":___cxa_guard_acquire,"___setErrNo":___setErrNo,"___cxa_allocate_exception":___cxa_allocate_exception,"___cxa_find_matching_catch":___cxa_find_matching_catch,"___cxa_guard_release":___cxa_guard_release,"_acosf":_acosf,"_asinf":_asinf,"_fabsf":_fabsf,"_sbrk":_sbrk,"_llvm_pow_f32":_llvm_pow_f32,"___cxa_begin_catch":___cxa_begin_catch,"_emscripten_memcpy_big":_emscripten_memcpy_big,"___resumeException":___resumeException,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"_sysconf":_sysconf,"_pthread_getspecific":_pthread_getspecific,"_sinf":_sinf,"_pthread_self":_pthread_self,"_pthread_once":_pthread_once,"_llvm_trap":_llvm_trap,"_sqrtf":_sqrtf,"_atan2f":_atan2f,"_pthread_setspecific":_pthread_setspecific,"___cxa_throw":___cxa_throw,"___syscall6":___syscall6,"_pthread_cleanup_push":_pthread_cleanup_push,"_time":_time,"_gettimeofday":_gettimeofday,"_emscripten_asm_const_8":_emscripten_asm_const_8,"___syscall140":___syscall140,"___cxa_pure_virtual":___cxa_pure_virtual,"___syscall146":___syscall146,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=0;var o=0;var p=0;var q=0;var r=global.NaN,s=global.Infinity;var t=0,u=0,v=0,w=0,x=0.0,y=0,z=0,A=0,B=0.0;var C=0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=global.Math.floor;var N=global.Math.abs;var O=global.Math.sqrt;var P=global.Math.pow;var Q=global.Math.cos;var R=global.Math.sin;var S=global.Math.tan;var T=global.Math.acos;var U=global.Math.asin;var V=global.Math.atan;var W=global.Math.atan2;var X=global.Math.exp;var Y=global.Math.log;var Z=global.Math.ceil;var _=global.Math.imul;var $=global.Math.min;var aa=global.Math.clz32;var ba=env.abort;var ca=env.assert;var da=env.invoke_viiiii;var ea=env.invoke_vid;var fa=env.invoke_vi;var ga=env.invoke_viiidii;var ha=env.invoke_vii;var ia=env.invoke_iiiiiiiiiii;var ja=env.invoke_ii;var ka=env.invoke_viidi;var la=env.invoke_viddiii;var ma=env.invoke_vidii;var na=env.invoke_iiiii;var oa=env.invoke_vidi;var pa=env.invoke_diiiiiiii;var qa=env.invoke_viiiiddddiid;var ra=env.invoke_diiiii;var sa=env.invoke_iiii;var ta=env.invoke_viiiiii;var ua=env.invoke_iiid;var va=env.invoke_di;var wa=env.invoke_iiiiiii;var xa=env.invoke_diiidii;var ya=env.invoke_viidii;var za=env.invoke_viiiiiii;var Aa=env.invoke_viiiiiiiii;var Ba=env.invoke_viiiiiiiiii;var Ca=env.invoke_iii;var Da=env.invoke_diii;var Ea=env.invoke_diiiiiiiiii;var Fa=env.invoke_viiiid;var Ga=env.invoke_diiiiiiiii;var Ha=env.invoke_did;var Ia=env.invoke_viiiidddddidi;var Ja=env.invoke_diidii;var Ka=env.invoke_diiii;var La=env.invoke_iiiiiiiiii;var Ma=env.invoke_viiid;var Na=env.invoke_viii;var Oa=env.invoke_v;var Pa=env.invoke_viid;var Qa=env.invoke_iidid;var Ra=env.invoke_viiii;var Sa=env._pthread_cleanup_pop;var Ta=env._cosf;var Ua=env._pthread_key_create;var Va=env._abort;var Wa=env.___cxa_guard_acquire;var Xa=env.___setErrNo;var Ya=env.___cxa_allocate_exception;var Za=env.___cxa_find_matching_catch;var _a=env.___cxa_guard_release;var $a=env._acosf;var ab=env._asinf;var bb=env._fabsf;var cb=env._sbrk;var db=env._llvm_pow_f32;var eb=env.___cxa_begin_catch;var fb=env._emscripten_memcpy_big;var gb=env.___resumeException;var hb=env.__ZSt18uncaught_exceptionv;var ib=env._sysconf;var jb=env._pthread_getspecific;var kb=env._sinf;var lb=env._pthread_self;var mb=env._pthread_once;var nb=env._llvm_trap;var ob=env._sqrtf;var pb=env._atan2f;var qb=env._pthread_setspecific;var rb=env.___cxa_throw;var sb=env.___syscall6;var tb=env._pthread_cleanup_push;var ub=env._time;var vb=env._gettimeofday;var wb=env._emscripten_asm_const_8;var xb=env.___syscall140;var yb=env.___cxa_pure_virtual;var zb=env.___syscall146;var Ab=0.0;
// EMSCRIPTEN_START_FUNCS
function oc(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;return b|0}function pc(){return i|0}function qc(a){a=a|0;i=a}function rc(a,b){a=a|0;b=b|0;i=a;j=b}function sc(a,b){a=a|0;b=b|0;if(!n){n=a;o=b}}function tc(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function uc(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function vc(a){a=a|0;C=a}function wc(){return C|0}function xc(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function yc(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function zc(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ac(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b>>2];c[a+164+4>>2]=c[b+4>>2];c[a+164+8>>2]=c[b+8>>2];c[a+164+12>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;b=a+180|0;c[b>>2]=d;return}b=a+180|0;c[b>>2]=d;return}function Bc(a){a=a|0;return c[a+192>>2]|0}function Cc(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Dc(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function Ec(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function Fc(a){a=a|0;if(c[a+204>>2]&3)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function Gc(a,b){a=a|0;b=b|0;if(!b?(c[a+204>>2]&3|0)!=0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function Hc(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function Ic(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function Jc(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function Kc(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function Lc(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function Mc(a){a=a|0;return a+4|0}function Nc(a){a=a|0;return c[a+204>>2]|0}function Oc(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function Pc(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+20+4>>2]=c[b+16+4>>2];c[a+20+8>>2]=c[b+16+8>>2];c[a+20+12>>2]=c[b+16+12>>2];c[a+36>>2]=c[b+32>>2];c[a+36+4>>2]=c[b+32+4>>2];c[a+36+8>>2]=c[b+32+8>>2];c[a+36+12>>2]=c[b+32+12>>2];c[a+52>>2]=c[b+48>>2];c[a+52+4>>2]=c[b+48+4>>2];c[a+52+8>>2]=c[b+48+8>>2];c[a+52+12>>2]=c[b+48+12>>2];return}function Qc(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function Rc(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function Sc(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function Tc(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+8>>2]&255](a);return}function Uc(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Vc(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Wc(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Xc(a){a=a|0;return c[a+24>>2]|0}function Yc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);return}function Zc(a){a=a|0;a=c[a+68>>2]|0;return Hb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function _c(a){a=a|0;return a+28|0}function $c(a,b){a=a|0;b=b|0;nc[c[(c[a>>2]|0)+36>>2]&127](a,b,1,-1);return}function ad(a,b,d){a=a|0;b=b|0;d=d|0;nc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-1);return}function bd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);return}function cd(a){a=a|0;return c[a+68>>2]|0}function dd(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;gv(a,b,c,d,e,f);return}function ed(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;hv(a,b,c,d);return}function fd(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function gd(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function hd(a){a=a|0;return +(+g[a+16>>2])}function id(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function jd(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function kd(a,b){a=+a;b=+b;var d=0;c[2703]=(c[2703]|0)+1;d=XE(75)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=1065353216;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d>>2]=7720;c[d+4>>2]=10;c[d+52>>2]=1;g[d+28>>2]=a;g[d+32>>2]=b*.5;g[d+36>>2]=a;g[d+40>>2]=0.0;return d|0}function ld(a,b){a=a|0;b=+b;Cb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function md(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function nd(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function od(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function pd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[2703]=(c[2703]|0)+1;e=XE(1331)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}Aq(e,a,b,d);return e|0}function qd(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;c[2703]=(c[2703]|0)+1;g=XE(1331)|0;if(!g)g=0;else{c[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}zq(g,a,b,d,e,f);return g|0}function rd(a,b){a=a|0;b=b|0;c[a+680>>2]=c[b>>2];c[a+680+4>>2]=c[b+4>>2];c[a+680+8>>2]=c[b+8>>2];c[a+680+12>>2]=c[b+12>>2];return}function sd(a,b){a=a|0;b=b|0;c[a+696>>2]=c[b>>2];c[a+696+4>>2]=c[b+4>>2];c[a+696+8>>2]=c[b+8>>2];c[a+696+12>>2]=c[b+12>>2];return}function td(a,b){a=a|0;b=b|0;var c=0.0,d=0;d=0;while(1){if((d|0)==3)break;c=+_E(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+868+(d<<6)>>2]=c;d=d+1|0}return}function ud(a,b){a=a|0;b=b|0;var c=0.0,d=0;d=0;while(1){if((d|0)==3)break;c=+_E(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+868+(d<<6)+4>>2]=c;d=d+1|0}return}function vd(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function wd(a){a=a|0;return +(+g[a+16>>2])}function xd(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function yd(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function zd(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ad(a){a=a|0;return +g[a+4>>2]<1.0|0}function Bd(a){a=a|0;return b[a+8>>1]|0}function Cd(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function Dd(a){a=a|0;return b[a+10>>1]|0}function Ed(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function Fd(a){a=a|0;return +(+g[a+4>>2])}function Gd(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Hd(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Id(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+8>>2]&127](a,b);return}function Jd(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function Kd(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ld(a,b){a=+a;b=+b;var d=0;c[2703]=(c[2703]|0)+1;d=XE(95)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=1065353216;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d>>2]=6604;g[d+56>>2]=a;g[d+60>>2]=b;c[d+4>>2]=11;c[d+64>>2]=0;c[d+68>>2]=1;c[d+72>>2]=2;g[d+28>>2]=a;g[d+32>>2]=b;g[d+36>>2]=a;g[d+52>>2]=a/+O(+(a*a+b*b));return d|0}function Md(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Nd(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Od(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Pd(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Qd(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Rd(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Sd(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return +(+Nb[c[(c[a>>2]|0)+12>>2]&1](a,b,d,e,f,g,h,i))}function Td(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ud(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Vd(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Wd(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Xd(a){a=a|0;return Hb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function Yd(a,b){a=a|0;b=b|0;return _b[c[(c[a>>2]|0)+40>>2]&31](a,b)|0}function Zd(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function _d(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function $d(b){b=b|0;var d=0,e=0;if((a[8]|0)==0?(Wa(8)|0)!=0:0){g[634]=.6000000238418579;g[635]=1.0;g[636]=.30000001192092896;g[637]=.01666666753590107;g[638]=0.0;g[640]=20.0;c[639]=10;g[642]=.20000000298023224;g[643]=.800000011920929;g[644]=0.0;g[641]=1.0;c[645]=1;g[646]=-.03999999910593033;g[647]=.10000000149011612;g[648]=0.0;g[649]=.8500000238418579;c[650]=260;c[651]=2;c[652]=128;g[653]=100.0;g[654]=1000000015047466219876688.0e6;_a(8)}e=2536;b=b+92|0;d=e+84|0;do{c[e>>2]=c[b>>2];e=e+4|0;b=b+4|0}while((e|0)<(d|0));return 2536}function ae(a){a=a|0;return c[a+24>>2]|0}function be(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);return}function ce(a){a=a|0;a=c[a+68>>2]|0;return Hb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function de(a){a=a|0;return a+28|0}function ee(a,b){a=a|0;b=b|0;nc[c[(c[a>>2]|0)+36>>2]&127](a,b,1,-1);return}function fe(a,b,d){a=a|0;b=b|0;d=d|0;nc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-1);return}function ge(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);return}function he(a){a=a|0;return c[a+68>>2]|0}function ie(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;gv(a,b,c,d,e,f);return}function je(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;hv(a,b,c,d);return}function ke(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function le(a){a=a|0;return (c[a+8>>2]|0)!=0|0}function me(a){a=a|0;return b[a+12>>1]|0}function ne(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function oe(a){a=a|0;return b[a+14>>1]|0}function pe(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function qe(a){a=a|0;return c[a+8>>2]|0}function re(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function se(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function te(){var a=0;c[2703]=(c[2703]|0)+1;a=XE(35)|0;if(!a){a=0;return a|0}c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16;return a|0}function ue(a,b,d){a=+a;b=+b;d=+d;var e=0;c[2703]=(c[2703]|0)+1;e=XE(35)|0;c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16;g[e>>2]=a;g[e+4>>2]=b;g[e+8>>2]=d;g[e+12>>2]=0.0;return e|0}function ve(a){a=a|0;var b=0.0,c=0.0,d=0.0;d=+g[a>>2];c=+g[a+4>>2];b=+g[a+8>>2];return +(+O(+(d*d+c*c+b*b)))}function we(a){a=a|0;return +(+g[a>>2])}function xe(a){a=a|0;return +(+g[a+4>>2])}function ye(a){a=a|0;return +(+g[a+8>>2])}function ze(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Ae(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Be(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function Ce(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function De(a,b){a=a|0;b=+b;g[a>>2]=+g[a>>2]*b;g[a+4>>2]=+g[a+4>>2]*b;g[a+8>>2]=+g[a+8>>2]*b;return a|0}function Ee(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function Fe(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ge(){var b=0,d=0;c[2703]=(c[2703]|0)+1;b=XE(303)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b+164>>2]=1065353216;c[b+168>>2]=1065353216;c[b+172>>2]=1065353216;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;d=b+188|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+240>>2]=0;g[b+244>>2]=1.0;d=b+248|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+4>>2]=1065353216;d=b+8|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+24>>2]=1065353216;d=b+28|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+44>>2]=1065353216;d=b+48|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[b>>2]=5128;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[b+236>>2]=4;return b|0}function He(a){a=a|0;return c[a+268>>2]|0}function Ie(a,b){a=a|0;b=b|0;return c[(c[a+276>>2]|0)+(b<<2)>>2]|0}function Je(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b>>2];c[a+164+4>>2]=c[b+4>>2];c[a+164+8>>2]=c[b+8>>2];c[a+164+12>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;b=a+180|0;c[b>>2]=d;return}b=a+180|0;c[b>>2]=d;return}function Ke(a){a=a|0;return c[a+192>>2]|0}function Le(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Me(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function Ne(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function Oe(a){a=a|0;if(c[a+204>>2]&3)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function Pe(a,b){a=a|0;b=b|0;if(!b?(c[a+204>>2]&3|0)!=0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function Qe(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function Re(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function Se(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function Te(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function Ue(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function Ve(a){a=a|0;return a+4|0}function We(a){a=a|0;return c[a+204>>2]|0}function Xe(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function Ye(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+20+4>>2]=c[b+16+4>>2];c[a+20+8>>2]=c[b+16+8>>2];c[a+20+12>>2]=c[b+16+12>>2];c[a+36>>2]=c[b+32>>2];c[a+36+4>>2]=c[b+32+4>>2];c[a+36+8>>2]=c[b+32+8>>2];c[a+36+12>>2]=c[b+32+12>>2];c[a+52>>2]=c[b+48>>2];c[a+52+4>>2]=c[b+48+4>>2];c[a+52+8>>2]=c[b+48+8>>2];c[a+52+12>>2]=c[b+48+12>>2];return}function Ze(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function _e(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function $e(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function af(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+8>>2]&255](a);return}function bf(a){a=a|0;return +(+g[a>>2])}function cf(a){a=a|0;return +(+g[a+4>>2])}function df(a){a=a|0;return +(+g[a+8>>2])}function ef(a){a=a|0;return +(+g[a+12>>2])}function ff(a,b){a=a|0;b=+b;g[a>>2]=b;return}function gf(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function hf(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function jf(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function kf(a){a=a|0;if(!a)return;YE(a);return}function lf(a){a=a|0;var b=0;c[2703]=(c[2703]|0)+1;b=XE(75)|0;if(!b){b=0;mA(b,a);return b|0}c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16;mA(b,a);return b|0}function mf(a,b){a=a|0;b=+b;Cb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function nf(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function of(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function pf(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function qf(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function rf(a,b,d,e){a=a|0;b=+b;d=+d;e=+e;var f=0,h=0.0,j=0.0,k=0.0,l=0.0;f=i;i=i+32|0;k=+Q(+b);h=+Q(+d);j=+Q(+e);l=+R(+b);b=+R(+d);d=+R(+e);g[f+20>>2]=b*(l*j)-k*d;g[f+16>>2]=b*(k*j)+l*d;g[f+12>>2]=b*(l*d)+k*j;g[f+8>>2]=b*(k*d)-l*j;g[f+4>>2]=h*l;g[f>>2]=h*k;g[a>>2]=h*j;c[a+4>>2]=c[f+20>>2];c[a+8>>2]=c[f+16>>2];g[a+12>>2]=0.0;g[a+16>>2]=h*d;c[a+20>>2]=c[f+12>>2];c[a+24>>2]=c[f+8>>2];g[a+28>>2]=0.0;g[a+32>>2]=-b;c[a+36>>2]=c[f+4>>2];c[a+40>>2]=c[f>>2];g[a+44>>2]=0.0;i=f;return}function sf(a,b){a=a|0;b=b|0;Oo(a,b);return}function tf(a){a=a|0;if(!a)return;YE(a);return}function uf(){var a=0,d=0;a=XE(8)|0;a:do if(!a){while(1){a=c[2711]|0;c[2711]=a+0;if(!a)break;kc[a&3]();a=XE(8)|0;if(a)break a}a=Ya(4)|0;c[a>>2]=10832;rb(a|0,2408,207)}while(0);d=a;c[d>>2]=0;c[d+4>>2]=0;b[a+4>>1]=1;b[a+6>>1]=-1;c[a>>2]=2956;return a|0}function vf(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return +(+Nb[c[(c[a>>2]|0)+12>>2]&1](a,b,d,e,f,g,h,i))}function wf(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function xf(a,b){a=a|0;b=b|0;var d=0;c[2703]=(c[2703]|0)+1;d=XE(95)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}Ax(d,a,b,1);return d|0}function yf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[2703]=(c[2703]|0)+1;e=XE(95)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}Ax(e,a,b,d);return e|0}function zf(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Af(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Bf(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Cf(){var a=0;a=XE(196)|0;a:do if(!a){while(1){a=c[2711]|0;c[2711]=a+0;if(!a)break;kc[a&3]();a=XE(196)|0;if(a)break a}a=Ya(4)|0;c[a>>2]=10832;rb(a|0,2408,207)}while(0);aC(a,0);return a|0}function Df(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ef(a){a=a|0;if(!a)return;YE(a);return}function Ff(){var b=0;c[2703]=(c[2703]|0)+1;b=XE(215)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b>>2]=4256;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;a[b+180>>0]=1;c[b+176>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;c[b+192>>2]=0;return b|0}function Gf(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Hf(a){a=a|0;return +(+g[a>>2])}function If(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Jf(a){a=a|0;return c[a+4>>2]|0}function Kf(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function Lf(a){a=a|0;return c[a+8>>2]|0}function Mf(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Nf(a){a=a|0;return +(+g[a+12>>2])}function Of(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function Pf(b){b=b|0;return (a[b+16>>0]&1)!=0|0}function Qf(b,c){b=b|0;c=c|0;a[b+16>>0]=c&1;return}function Rf(b){b=b|0;return (a[b+24>>0]&1)!=0|0}function Sf(b,c){b=b|0;c=c|0;a[b+24>>0]=c&1;return}function Tf(b){b=b|0;return (a[b+25>>0]&1)!=0|0}function Uf(b,c){b=b|0;c=c|0;a[b+25>>0]=c&1;return}function Vf(b){b=b|0;return (a[b+26>>0]&1)!=0|0}function Wf(b,c){b=b|0;c=c|0;a[b+26>>0]=c&1;return}function Xf(a){a=a|0;return +(+g[a+28>>2])}function Yf(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function Zf(b){b=b|0;return (a[b+32>>0]&1)!=0|0}function _f(b,c){b=b|0;c=c|0;a[b+32>>0]=c&1;return}function $f(a){a=a|0;return +(+g[a+36>>2])}function ag(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function bg(a){a=a|0;if(!a)return;YE(a);return}function cg(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function dg(a,b){a=a|0;b=b|0;var d=0;c[2703]=(c[2703]|0)+1;d=XE(135)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}VA(d,a,b,16384,0,0);return d|0}function eg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[2703]=(c[2703]|0)+1;e=XE(135)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}VA(e,a,b,d&65535,0,0);return e|0}function fg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;c[2703]=(c[2703]|0)+1;f=XE(135)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}VA(f,a,b,d&65535,e,0);return f|0}function gg(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;c[2703]=(c[2703]|0)+1;g=XE(135)|0;if(!g)g=0;else{c[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}VA(g,a,b,d&65535,e,f);return g|0}function hg(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function ig(){var b=0,d=0,e=0;c[2703]=(c[2703]|0)+1;b=XE(307)|0;if(!b)d=0;else{c[(b+4+15&-16)+-4>>2]=b;d=b+4+15&-16}c[d+164>>2]=1065353216;c[d+168>>2]=1065353216;c[d+172>>2]=1065353216;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749440.0;b=d+188|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[d+204>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;g[d+232>>2]=0.0;c[d+240>>2]=0;g[d+244>>2]=1.0;b=d+248|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[d+4>>2]=1065353216;b=d+8|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[d+24>>2]=1065353216;b=d+28|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[d+44>>2]=1065353216;b=d+48|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;a[d+280>>0]=1;c[d+276>>2]=0;c[d+268>>2]=0;c[d+272>>2]=0;c[d+236>>2]=4;c[d>>2]=5172;c[2703]=(c[2703]|0)+1;b=XE(95)|0;if(!b){e=0;FB(e);b=d+284|0;c[b>>2]=e;return d|0}c[(b+4+15&-16)+-4>>2]=b;e=b+4+15&-16;FB(e);b=d+284|0;c[b>>2]=e;return d|0}function jg(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b>>2];c[a+164+4>>2]=c[b+4>>2];c[a+164+8>>2]=c[b+8>>2];c[a+164+12>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;b=a+180|0;c[b>>2]=d;return}b=a+180|0;c[b>>2]=d;return}function kg(a){a=a|0;return c[a+192>>2]|0}function lg(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function mg(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function ng(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function og(a){a=a|0;if(c[a+204>>2]&3)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function pg(a,b){a=a|0;b=b|0;if(!b?(c[a+204>>2]&3|0)!=0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function qg(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function rg(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function sg(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function tg(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function ug(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function vg(a){a=a|0;return a+4|0}function wg(a){a=a|0;return c[a+204>>2]|0}function xg(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function yg(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+20+4>>2]=c[b+16+4>>2];c[a+20+8>>2]=c[b+16+8>>2];c[a+20+12>>2]=c[b+16+12>>2];c[a+36>>2]=c[b+32>>2];c[a+36+4>>2]=c[b+32+4>>2];c[a+36+8>>2]=c[b+32+8>>2];c[a+36+12>>2]=c[b+32+12>>2];c[a+52>>2]=c[b+48>>2];c[a+52+4>>2]=c[b+48+4>>2];c[a+52+8>>2]=c[b+48+8>>2];c[a+52+12>>2]=c[b+48+12>>2];return}function zg(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function Ag(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function Bg(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function Cg(a){a=a|0;return c[a+268>>2]|0}function Dg(a,b){a=a|0;b=b|0;return c[(c[a+276>>2]|0)+(b<<2)>>2]|0}function Eg(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+8>>2]&255](a);return}function Fg(b,d,e){b=+b;d=d|0;e=e|0;var f=0;f=XE(140)|0;a:do if(!f){while(1){f=c[2711]|0;c[2711]=f+0;if(!f)break;kc[f&3]();f=XE(140)|0;if(f)break a}f=Ya(4)|0;c[f>>2]=10832;rb(f|0,2408,207)}while(0);g[f>>2]=b;c[f+4>>2]=d;c[f+72>>2]=e;d=f+76|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;g[f+100>>2]=.5;g[f+104>>2]=0.0;g[f+108>>2]=0.0;g[f+112>>2]=.800000011920929;g[f+116>>2]=1.0;a[f+120>>0]=0;g[f+124>>2]=.004999999888241291;g[f+128>>2]=.009999999776482582;g[f+132>>2]=.009999999776482582;g[f+136>>2]=.009999999776482582;To(f+8|0);return f|0}function Gg(b,d,e,f){b=+b;d=d|0;e=e|0;f=f|0;var h=0;h=XE(140)|0;a:do if(!h){while(1){h=c[2711]|0;c[2711]=h+0;if(!h)break;kc[h&3]();h=XE(140)|0;if(h)break a}h=Ya(4)|0;c[h>>2]=10832;rb(h|0,2408,207)}while(0);g[h>>2]=b;c[h+4>>2]=d;c[h+72>>2]=e;d=h+76|0;c[d>>2]=c[f>>2];c[d+4>>2]=c[f+4>>2];c[d+8>>2]=c[f+8>>2];c[d+12>>2]=c[f+12>>2];g[h+92>>2]=0.0;g[h+96>>2]=0.0;g[h+100>>2]=.5;g[h+104>>2]=0.0;g[h+108>>2]=0.0;g[h+112>>2]=.800000011920929;g[h+116>>2]=1.0;a[h+120>>0]=0;g[h+124>>2]=.004999999888241291;g[h+128>>2]=.009999999776482582;g[h+132>>2]=.009999999776482582;g[h+136>>2]=.009999999776482582;To(h+8|0);return h|0}function Hg(a){a=a|0;return +(+g[a+92>>2])}function Ig(a,b){a=a|0;b=+b;g[a+92>>2]=b;return}function Jg(a){a=a|0;return +(+g[a+96>>2])}function Kg(a,b){a=a|0;b=+b;g[a+96>>2]=b;return}function Lg(a){a=a|0;return +(+g[a+100>>2])}function Mg(a,b){a=a|0;b=+b;g[a+100>>2]=b;return}function Ng(a){a=a|0;return +(+g[a+104>>2])}function Og(a,b){a=a|0;b=+b;g[a+104>>2]=b;return}function Pg(a){a=a|0;return +(+g[a+108>>2])}function Qg(a,b){a=a|0;b=+b;g[a+108>>2]=b;return}function Rg(a){a=a|0;return +(+g[a+112>>2])}function Sg(a,b){a=a|0;b=+b;g[a+112>>2]=b;return}function Tg(a){a=a|0;return +(+g[a+116>>2])}function Ug(a,b){a=a|0;b=+b;g[a+116>>2]=b;return}function Vg(b){b=b|0;return (a[b+120>>0]&1)!=0|0}function Wg(b,c){b=b|0;c=c|0;a[b+120>>0]=c&1;return}function Xg(a){a=a|0;return +(+g[a+124>>2])}function Yg(a,b){a=a|0;b=+b;g[a+124>>2]=b;return}function Zg(a){a=a|0;return +(+g[a+128>>2])}function _g(a,b){a=a|0;b=+b;g[a+128>>2]=b;return}function $g(a){a=a|0;return +(+g[a+132>>2])}function ah(a,b){a=a|0;b=+b;g[a+132>>2]=b;return}function bh(a){a=a|0;return +(+g[a+136>>2])}function ch(a,b){a=a|0;b=+b;g[a+136>>2]=b;return}function dh(a){a=a|0;if(!a)return;YE(a);return}function eh(a){a=a|0;return a+48|0}function fh(a){a=a|0;return a+32|0}function gh(a){a=a|0;return +(+g[a+80>>2])}function hh(a){a=a|0;return a|0}function ih(a,b){a=a|0;b=b|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];return}function jh(a){a=a|0;return a+16|0}function kh(a,b){a=a|0;b=b|0;c[a+16>>2]=c[b>>2];c[a+16+4>>2]=c[b+4>>2];c[a+16+8>>2]=c[b+8>>2];c[a+16+12>>2]=c[b+12>>2];return}function lh(a){a=a|0;return a+32|0}function mh(a,b){a=a|0;b=b|0;c[a+32>>2]=c[b>>2];c[a+32+4>>2]=c[b+4>>2];c[a+32+8>>2]=c[b+8>>2];c[a+32+12>>2]=c[b+12>>2];return}function nh(a){a=a|0;return a+48|0}function oh(a,b){a=a|0;b=b|0;c[a+48>>2]=c[b>>2];c[a+48+4>>2]=c[b+4>>2];c[a+48+8>>2]=c[b+8>>2];c[a+48+12>>2]=c[b+12>>2];return}function ph(a){a=a|0;return a+64|0}function qh(a,b){a=a|0;b=b|0;c[a+64>>2]=c[b>>2];c[a+64+4>>2]=c[b+4>>2];c[a+64+8>>2]=c[b+8>>2];c[a+64+12>>2]=c[b+12>>2];return}function rh(a){a=a|0;if(!a)return;YE(a);return}function sh(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function th(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0;c[2703]=(c[2703]|0)+1;f=XE(343)|0;if(!f)i=0;else{c[(f+4+15&-16)+-4>>2]=f;i=f+4+15&-16}a[i+20>>0]=1;c[i+16>>2]=0;c[i+8>>2]=0;c[i+12>>2]=0;c[i+24>>2]=b;g[i+28>>2]=0.0;c[i+32>>2]=0;c[i+36>>2]=1;g[i+40>>2]=1.0;a[i+44>>0]=1;c[i+48>>2]=0;a[i+52>>0]=0;a[i+53>>0]=1;a[i+54>>0]=1;g[i+56>>2]=.03999999910593033;a[i+60>>0]=0;g[i+64>>2]=0.0;c[i+68>>2]=d;c[i+72>>2]=0;a[i+76>>0]=1;c[i+80>>2]=0;c[i+84>>2]=0;c[i+88>>2]=0;g[i+92>>2]=.6000000238418579;g[i+96>>2]=1.0;g[i+100>>2]=.30000001192092896;g[i+104>>2]=.01666666753590107;g[i+108>>2]=0.0;g[i+116>>2]=20.0;c[i+112>>2]=10;g[i+124>>2]=.20000000298023224;g[i+128>>2]=.800000011920929;g[i+132>>2]=0.0;g[i+120>>2]=1.0;c[i+136>>2]=1;g[i+140>>2]=-.03999999910593033;g[i+144>>2]=.10000000149011612;g[i+148>>2]=0.0;g[i+152>>2]=.8500000238418579;c[i+156>>2]=260;c[i+160>>2]=2;c[i+164>>2]=128;g[i+168>>2]=100.0;g[i+172>>2]=1000000015047466219876688.0e6;c[i>>2]=3020;a[i+192>>0]=1;c[i+188>>2]=0;c[i+180>>2]=0;c[i+184>>2]=0;h=i+196|0;c[h>>2]=0;d=i+200|0;c[d>>2]=e;a[i+224>>0]=1;c[i+220>>2]=0;c[i+212>>2]=0;c[i+216>>2]=0;a[i+244>>0]=1;c[i+240>>2]=0;c[i+232>>2]=0;c[i+236>>2]=0;c[i+248>>2]=0;c[i+252>>2]=-1054867456;f=i+256|0;a[i+274>>0]=0;a[i+275>>0]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[i+292>>0]=1;c[i+288>>2]=0;c[i+280>>2]=0;c[i+284>>2]=0;c[i+296>>2]=0;a[i+300>>0]=1;a[i+320>>0]=1;c[i+316>>2]=0;c[i+308>>2]=0;c[i+312>>2]=0;if(!e){c[2703]=(c[2703]|0)+1;f=XE(215)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[f>>2]=4256;a[f+20>>0]=1;c[f+16>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[f+40>>0]=1;c[f+36>>2]=0;c[f+28>>2]=0;c[f+32>>2]=0;a[f+60>>0]=1;c[f+56>>2]=0;c[f+48>>2]=0;c[f+52>>2]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;a[f+160>>0]=1;c[f+156>>2]=0;c[f+148>>2]=0;c[f+152>>2]=0;a[f+180>>0]=1;c[f+176>>2]=0;c[f+168>>2]=0;c[f+172>>2]=0;c[f+192>>2]=0;c[d>>2]=f;a[i+273>>0]=1}else a[i+273>>0]=0;c[2703]=(c[2703]|0)+1;f=XE(87)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[f>>2]=5544;a[f+20>>0]=1;c[f+16>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[f+40>>0]=1;c[f+36>>2]=0;c[f+28>>2]=0;c[f+32>>2]=0;a[f+60>>0]=1;c[f+56>>2]=0;c[f+48>>2]=0;c[f+52>>2]=0;a[f+64>>0]=1;c[i+204>>2]=f;a[i+272>>0]=1;c[2703]=(c[2703]|0)+1;f=XE(107)|0;if(!f){f=0;e=c[d>>2]|0;c[f>>2]=3212;d=f+4|0;c[d>>2]=0;d=f+8|0;c[d>>2]=e;d=f+12|0;c[d>>2]=0;d=f+16|0;c[d>>2]=0;d=f+20|0;c[d>>2]=0;d=f+24|0;c[d>>2]=b;d=f+44|0;a[d>>0]=1;d=f+40|0;c[d>>2]=0;d=f+32|0;c[d>>2]=0;d=f+36|0;c[d>>2]=0;d=f+64|0;a[d>>0]=1;d=f+60|0;c[d>>2]=0;d=f+52|0;c[d>>2]=0;d=f+56|0;c[d>>2]=0;d=f+84|0;a[d>>0]=1;d=f+80|0;c[d>>2]=0;d=f+72|0;c[d>>2]=0;d=f+76|0;c[d>>2]=0;c[h>>2]=f;return i|0}c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16;e=c[d>>2]|0;c[f>>2]=3212;d=f+4|0;c[d>>2]=0;d=f+8|0;c[d>>2]=e;d=f+12|0;c[d>>2]=0;d=f+16|0;c[d>>2]=0;d=f+20|0;c[d>>2]=0;d=f+24|0;c[d>>2]=b;d=f+44|0;a[d>>0]=1;d=f+40|0;c[d>>2]=0;d=f+32|0;c[d>>2]=0;d=f+36|0;c[d>>2]=0;d=f+64|0;a[d>>0]=1;d=f+60|0;c[d>>2]=0;d=f+52|0;c[d>>2]=0;d=f+56|0;c[d>>2]=0;d=f+84|0;a[d>>0]=1;d=f+80|0;c[d>>2]=0;d=f+72|0;c[d>>2]=0;d=f+76|0;c[d>>2]=0;c[h>>2]=f;return i|0}function uh(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+72>>2]&127](a,b);return}function vh(b){b=b|0;var d=0;d=i;i=i+16|0;if((a[16]|0)==0?(Wa(16)|0)!=0:0)_a(16);Fb[c[(c[b>>2]|0)+76>>2]&127](d,b);c[655]=c[d>>2];c[656]=c[d+4>>2];c[657]=c[d+8>>2];c[658]=c[d+12>>2];i=d;return 2620}function wh(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+84>>2]&127](a,b);return}function xh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a>>2]|0)+88>>2]&127](a,b,d,e);return}function yh(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+92>>2]&127](a,b);return}function zh(a,b){a=a|0;b=b|0;jc[c[(c[a>>2]|0)+56>>2]&127](a,b,0);return}function Ah(a,b,d){a=a|0;b=b|0;d=d|0;jc[c[(c[a>>2]|0)+56>>2]&127](a,b,d);return}function Bh(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+60>>2]&127](a,b);return}function Ch(a,b){a=a|0;b=+b;return mc[c[(c[a>>2]|0)+52>>2]&1](a,b,1,.01666666753590107)|0}function Dh(a,b,d){a=a|0;b=+b;d=d|0;return mc[c[(c[a>>2]|0)+52>>2]&1](a,b,d,.01666666753590107)|0}function Eh(a,b,d,e){a=a|0;b=+b;d=d|0;e=+e;return mc[c[(c[a>>2]|0)+52>>2]&1](a,b,d,e)|0}function Fh(a){a=a|0;return c[a+24>>2]|0}function Gh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);return}function Hh(a){a=a|0;a=c[a+68>>2]|0;return Hb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function Ih(a){a=a|0;return a+28|0}function Jh(a,b){a=a|0;b=b|0;nc[c[(c[a>>2]|0)+36>>2]&127](a,b,2,-3);return}function Kh(a,b,d){a=a|0;b=b|0;d=d|0;nc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-3);return}function Lh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);return}function Mh(a){a=a|0;return c[a+68>>2]|0}function Nh(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;gv(a,b,c,d,e,f);return}function Oh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;hv(a,b,c,d);return}function Ph(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function Qh(b){b=b|0;var d=0,e=0;if((a[24]|0)==0?(Wa(24)|0)!=0:0){g[659]=.6000000238418579;g[660]=1.0;g[661]=.30000001192092896;g[662]=.01666666753590107;g[663]=0.0;g[665]=20.0;c[664]=10;g[667]=.20000000298023224;g[668]=.800000011920929;g[669]=0.0;g[666]=1.0;c[670]=1;g[671]=-.03999999910593033;g[672]=.10000000149011612;g[673]=0.0;g[674]=.8500000238418579;c[675]=260;c[676]=2;c[677]=128;g[678]=100.0;g[679]=1000000015047466219876688.0e6;_a(24)}e=2636;b=b+92|0;d=e+84|0;do{c[e>>2]=c[b>>2];e=e+4|0;b=b+4|0}while((e|0)<(d|0));return 2636}function Rh(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Sh(b){b=b|0;var d=0;c[2703]=(c[2703]|0)+1;d=XE(115)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=1065353216;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+52>>2]=0;c[d+56>>2]=1065353216;c[d+60>>2]=1065353216;c[d+64>>2]=1065353216;g[d+68>>2]=0.0;c[d+72>>2]=-1082130432;c[d+76>>2]=-1082130432;c[d+80>>2]=-1082130432;g[d+84>>2]=0.0;a[d+88>>0]=0;c[d>>2]=8020;c[d+92>>2]=b;c[d+4>>2]=3;wy(d);return d|0}function Th(b,d){b=b|0;d=d|0;var e=0;c[2703]=(c[2703]|0)+1;e=XE(115)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e+8>>2]=0;c[e+12>>2]=1065353216;c[e+16>>2]=1065353216;c[e+20>>2]=1065353216;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e+52>>2]=0;c[e+56>>2]=1065353216;c[e+60>>2]=1065353216;c[e+64>>2]=1065353216;g[e+68>>2]=0.0;c[e+72>>2]=-1082130432;c[e+76>>2]=-1082130432;c[e+80>>2]=-1082130432;g[e+84>>2]=0.0;a[e+88>>0]=0;c[e>>2]=8020;c[e+92>>2]=b;c[e+4>>2]=3;if(!d)return e|0;wy(e);return e|0}function Uh(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Vh(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Wh(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Xh(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0;c[2703]=(c[2703]|0)+1;e=XE(379)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e+4>>2]=3;c[e>>2]=3424;c[e+8>>2]=-1;c[e+12>>2]=-1;g[e+16>>2]=3402823466385288598117041.0e14;a[e+20>>0]=1;a[e+21>>0]=0;c[e+24>>2]=-1;c[e+28>>2]=b;er();c[e+32>>2]=3468;g[e+36>>2]=0.0;g[e+40>>2]=.30000001192092896;c[e+44>>2]=0;c[e>>2]=3372;l=e+300|0;c[l>>2]=c[d>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];k=+g[d>>2];j=+g[d+4>>2];i=+g[d+8>>2];h=k*+g[b+20>>2]+j*+g[b+24>>2]+i*+g[b+28>>2]+ +g[b+56>>2];f=k*+g[b+36>>2]+j*+g[b+40>>2]+i*+g[b+44>>2]+ +g[b+60>>2];g[e+316>>2]=k*+g[b+4>>2]+j*+g[b+8>>2]+i*+g[b+12>>2]+ +g[b+52>>2];g[e+320>>2]=h;g[e+324>>2]=f;g[e+328>>2]=0.0;c[e+332>>2]=0;a[e+344>>0]=0;g[e+348>>2]=.30000001192092896;g[e+352>>2]=1.0;g[e+356>>2]=0.0;return e|0}function Yh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;c[2703]=(c[2703]|0)+1;h=XE(379)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h+4>>2]=3;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=3372;b=h+300|0;c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];b=h+316|0;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];c[h+332>>2]=0;a[h+344>>0]=0;g[h+348>>2]=.30000001192092896;g[h+352>>2]=1.0;g[h+356>>2]=0.0;return h|0}function Zh(a,b){a=a|0;b=b|0;c[a+300>>2]=c[b>>2];c[a+300+4>>2]=c[b+4>>2];c[a+300+8>>2]=c[b+8>>2];c[a+300+12>>2]=c[b+12>>2];return}function _h(a,b){a=a|0;b=b|0;c[a+316>>2]=c[b>>2];c[a+316+4>>2]=c[b+4>>2];c[a+316+8>>2]=c[b+8>>2];c[a+316+12>>2]=c[b+12>>2];return}function $h(a){a=a|0;return a+300|0}function ai(a){a=a|0;return a+316|0}function bi(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function ci(a){a=a|0;return +(+g[a+16>>2])}function di(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function ei(a){a=a|0;return a+348|0}function fi(a,b){a=a|0;b=b|0;c[a+348>>2]=c[b>>2];c[a+348+4>>2]=c[b+4>>2];c[a+348+8>>2]=c[b+8>>2];return}function gi(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function hi(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0,J=0;c[2703]=(c[2703]|0)+1;f=XE(1147)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}er();c[f+4>>2]=7;c[f+8>>2]=-1;c[f+12>>2]=-1;g[f+16>>2]=3402823466385288598117041.0e14;a[f+20>>0]=1;a[f+21>>0]=0;c[f+24>>2]=-1;i=f+28|0;c[i>>2]=3468;h=f+32|0;c[h>>2]=b;g[f+36>>2]=0.0;g[f+40>>2]=.30000001192092896;c[f+44>>2]=0;c[f>>2]=4092;a[f+48>>0]=0;J=f+116|0;c[J>>2]=c[d>>2];c[J+4>>2]=c[d+4>>2];c[J+8>>2]=c[d+8>>2];c[J+12>>2]=c[d+12>>2];I=f+132|0;c[I>>2]=c[d+16>>2];c[I+4>>2]=c[d+16+4>>2];c[I+8>>2]=c[d+16+8>>2];c[I+12>>2]=c[d+16+12>>2];H=f+148|0;c[H>>2]=c[d+32>>2];c[H+4>>2]=c[d+32+4>>2];c[H+8>>2]=c[d+32+8>>2];c[H+12>>2]=c[d+32+12>>2];G=f+164|0;c[G>>2]=c[d+48>>2];c[G+4>>2]=c[d+48+4>>2];c[G+8>>2]=c[d+48+8>>2];c[G+12>>2]=c[d+48+12>>2];a[f+180>>0]=e&1;x=+g[J>>2];D=+g[b+4>>2];w=+g[I>>2];C=+g[b+8>>2];v=+g[H>>2];B=+g[b+12>>2];u=+g[f+120>>2];t=+g[f+136>>2];s=+g[f+152>>2];r=+g[f+124>>2];p=+g[f+140>>2];n=+g[f+156>>2];A=+g[b+20>>2];z=+g[b+24>>2];y=+g[b+28>>2];q=+g[b+36>>2];o=+g[b+40>>2];m=+g[b+44>>2];F=+g[G>>2];E=+g[f+168>>2];j=+g[f+172>>2];l=+g[b+52>>2]+(D*F+C*E+B*j);k=A*F+z*E+y*j+ +g[b+56>>2];j=q*F+o*E+m*j+ +g[b+60>>2];g[f+52>>2]=x*D+w*C+v*B;g[f+56>>2]=D*u+C*t+B*s;g[f+60>>2]=D*r+C*p+B*n;g[f+64>>2]=0.0;g[f+68>>2]=x*A+w*z+v*y;g[f+72>>2]=u*A+t*z+s*y;g[f+76>>2]=r*A+p*z+n*y;g[f+80>>2]=0.0;g[f+84>>2]=x*q+w*o+v*m;g[f+88>>2]=u*q+t*o+s*m;g[f+92>>2]=r*q+p*o+n*m;g[f+96>>2]=0.0;g[f+100>>2]=l;g[f+104>>2]=k;g[f+108>>2]=j;g[f+112>>2]=0.0;g[f+184>>2]=1.0;g[f+188>>2]=-1.0;g[f+192>>2]=0.0;g[f+196>>2]=0.0;g[f+200>>2]=1.0;g[f+204>>2]=.699999988079071;g[f+208>>2]=0.0;g[f+212>>2]=0.0;g[f+216>>2]=1.0;g[f+220>>2]=.699999988079071;g[f+224>>2]=0.0;g[f+228>>2]=0.0;g[f+264>>2]=1.0;g[f+268>>2]=.699999988079071;g[f+272>>2]=1.0;g[f+276>>2]=0.0;g[f+280>>2]=1.0;g[f+284>>2]=.699999988079071;g[f+288>>2]=1.0;g[f+292>>2]=0.0;g[f+232>>2]=1.0;g[f+236>>2]=.699999988079071;g[f+240>>2]=1.0;g[f+244>>2]=0.0;g[f+248>>2]=1.0;g[f+252>>2]=.699999988079071;g[f+256>>2]=1.0;g[f+260>>2]=0.0;a[f+1096>>0]=0;b=f+1100|0;g[f+1116>>2]=0.0;g[f+1120>>2]=0.0;g[f+1124>>2]=0.0;c[f+300>>2]=0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;a[b+12>>0]=0;a[f+49>>0]=1;jr(f,(c[i>>2]|0)+4|0,(c[h>>2]|0)+4|0);return f|0}function ii(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0;c[2703]=(c[2703]|0)+1;i=XE(1147)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}c[i+4>>2]=7;c[i+8>>2]=-1;c[i+12>>2]=-1;g[i+16>>2]=3402823466385288598117041.0e14;a[i+20>>0]=1;a[i+21>>0]=0;c[i+24>>2]=-1;j=i+28|0;c[j>>2]=b;b=i+32|0;c[b>>2]=d;g[i+36>>2]=0.0;g[i+40>>2]=.30000001192092896;c[i+44>>2]=0;c[i>>2]=4092;a[i+48>>0]=0;d=i+52|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=i+68|0;c[d>>2]=c[e+16>>2];c[d+4>>2]=c[e+16+4>>2];c[d+8>>2]=c[e+16+8>>2];c[d+12>>2]=c[e+16+12>>2];d=i+84|0;c[d>>2]=c[e+32>>2];c[d+4>>2]=c[e+32+4>>2];c[d+8>>2]=c[e+32+8>>2];c[d+12>>2]=c[e+32+12>>2];d=i+100|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];d=i+116|0;c[d>>2]=c[f>>2];c[d+4>>2]=c[f+4>>2];c[d+8>>2]=c[f+8>>2];c[d+12>>2]=c[f+12>>2];d=i+132|0;c[d>>2]=c[f+16>>2];c[d+4>>2]=c[f+16+4>>2];c[d+8>>2]=c[f+16+8>>2];c[d+12>>2]=c[f+16+12>>2];d=i+148|0;c[d>>2]=c[f+32>>2];c[d+4>>2]=c[f+32+4>>2];c[d+8>>2]=c[f+32+8>>2];c[d+12>>2]=c[f+32+12>>2];d=i+164|0;c[d>>2]=c[f+48>>2];c[d+4>>2]=c[f+48+4>>2];c[d+8>>2]=c[f+48+8>>2];c[d+12>>2]=c[f+48+12>>2];a[i+180>>0]=h&1;g[i+184>>2]=1.0;g[i+188>>2]=-1.0;g[i+192>>2]=0.0;g[i+196>>2]=0.0;g[i+200>>2]=1.0;g[i+204>>2]=.699999988079071;g[i+208>>2]=0.0;g[i+212>>2]=0.0;g[i+216>>2]=1.0;g[i+220>>2]=.699999988079071;g[i+224>>2]=0.0;g[i+228>>2]=0.0;g[i+264>>2]=1.0;g[i+268>>2]=.699999988079071;g[i+272>>2]=1.0;g[i+276>>2]=0.0;g[i+280>>2]=1.0;g[i+284>>2]=.699999988079071;g[i+288>>2]=1.0;g[i+292>>2]=0.0;g[i+232>>2]=1.0;g[i+236>>2]=.699999988079071;g[i+240>>2]=1.0;g[i+244>>2]=0.0;g[i+248>>2]=1.0;g[i+252>>2]=.699999988079071;g[i+256>>2]=1.0;g[i+260>>2]=0.0;a[i+1096>>0]=0;d=i+1100|0;g[i+1116>>2]=0.0;g[i+1120>>2]=0.0;g[i+1124>>2]=0.0;c[i+300>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;a[d+12>>0]=0;a[i+49>>0]=1;jr(i,(c[j>>2]|0)+4|0,(c[b>>2]|0)+4|0);return i|0}function ji(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function ki(a,b){a=a|0;b=+b;g[a+188>>2]=b;return}function li(a,b){a=a|0;b=+b;b=+_E(b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+192>>2]=b;return}function mi(a,b){a=a|0;b=+b;b=+_E(b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+196>>2]=b;return}function ni(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function oi(a){a=a|0;return +(+g[a+16>>2])}function pi(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function qi(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function ri(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0;c[2703]=(c[2703]|0)+1;e=XE(627)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e+4>>2]=5;c[e>>2]=3424;c[e+8>>2]=-1;c[e+12>>2]=-1;g[e+16>>2]=3402823466385288598117041.0e14;a[e+20>>0]=1;a[e+21>>0]=0;c[e+24>>2]=-1;c[e+28>>2]=b;er();c[e+32>>2]=3468;g[e+36>>2]=0.0;g[e+40>>2]=.30000001192092896;c[e+44>>2]=0;c[e>>2]=4144;i=e+300|0;c[i>>2]=c[d>>2];c[i+4>>2]=c[d+4>>2];c[i+8>>2]=c[d+8>>2];c[i+12>>2]=c[d+12>>2];h=e+316|0;c[h>>2]=c[d+16>>2];c[h+4>>2]=c[d+16+4>>2];c[h+8>>2]=c[d+16+8>>2];c[h+12>>2]=c[d+16+12>>2];f=e+332|0;c[f>>2]=c[d+32>>2];c[f+4>>2]=c[d+32+4>>2];c[f+8>>2]=c[d+32+8>>2];c[f+12>>2]=c[d+32+12>>2];b=e+348|0;c[b>>2]=c[d+48>>2];c[b+4>>2]=c[d+48+4>>2];c[b+8>>2]=c[d+48+8>>2];c[b+12>>2]=c[d+48+12>>2];b=e+364|0;a[e+527>>0]=0;c[b>>2]=c[i>>2];c[b+4>>2]=c[i+4>>2];c[b+8>>2]=c[i+8>>2];c[b+12>>2]=c[i+12>>2];b=e+380|0;c[b>>2]=c[h>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];b=e+396|0;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];b=e+412|0;a[e+524>>0]=0;a[e+525>>0]=0;a[e+526>>0]=0;a[e+552>>0]=0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;g[e+572>>2]=-1.0;g[e+444>>2]=999999984306749440.0;g[e+448>>2]=999999984306749440.0;g[e+452>>2]=999999984306749440.0;g[e+428>>2]=1.0;g[e+432>>2]=.30000001192092896;g[e+436>>2]=1.0;g[e+440>>2]=.009999999776482582;g[e+456>>2]=.05000000074505806;c[e+592>>2]=0;g[e+596>>2]=0.0;g[e+600>>2]=.699999988079071;g[e+604>>2]=0.0;return e|0}function si(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;c[2703]=(c[2703]|0)+1;h=XE(627)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h+4>>2]=5;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=4144;b=h+300|0;c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];b=h+316|0;c[b>>2]=c[e+16>>2];c[b+4>>2]=c[e+16+4>>2];c[b+8>>2]=c[e+16+8>>2];c[b+12>>2]=c[e+16+12>>2];b=h+332|0;c[b>>2]=c[e+32>>2];c[b+4>>2]=c[e+32+4>>2];c[b+8>>2]=c[e+32+8>>2];c[b+12>>2]=c[e+32+12>>2];b=h+348|0;c[b>>2]=c[e+48>>2];c[b+4>>2]=c[e+48+4>>2];c[b+8>>2]=c[e+48+8>>2];c[b+12>>2]=c[e+48+12>>2];b=h+364|0;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];b=h+380|0;c[b>>2]=c[f+16>>2];c[b+4>>2]=c[f+16+4>>2];c[b+8>>2]=c[f+16+8>>2];c[b+12>>2]=c[f+16+12>>2];b=h+396|0;c[b>>2]=c[f+32>>2];c[b+4>>2]=c[f+32+4>>2];c[b+8>>2]=c[f+32+8>>2];c[b+12>>2]=c[f+32+12>>2];b=h+412|0;c[b>>2]=c[f+48>>2];c[b+4>>2]=c[f+48+4>>2];c[b+8>>2]=c[f+48+8>>2];c[b+12>>2]=c[f+48+12>>2];b=h+524|0;a[h+552>>0]=0;a[b>>0]=0;a[b+1>>0]=0;a[b+2>>0]=0;a[b+3>>0]=0;g[h+572>>2]=-1.0;g[h+444>>2]=999999984306749440.0;g[h+448>>2]=999999984306749440.0;g[h+452>>2]=999999984306749440.0;g[h+428>>2]=1.0;g[h+432>>2]=.30000001192092896;g[h+436>>2]=1.0;g[h+440>>2]=.009999999776482582;g[h+456>>2]=.05000000074505806;c[h+592>>2]=0;g[h+596>>2]=0.0;g[h+600>>2]=.699999988079071;g[h+604>>2]=0.0;return h|0}function ti(a,b,c){a=a|0;b=b|0;c=+c;switch(b|0){case 3:{g[a+452>>2]=c;return}case 4:{g[a+448>>2]=c;return}case 5:{g[a+444>>2]=c;return}default:return}}function ui(b,c){b=b|0;c=c|0;a[b+524>>0]=c&1;return}function vi(a,b){a=a|0;b=+b;g[a+440>>2]=b;return}function wi(b,c){b=b|0;c=c|0;a[b+552>>0]=c&1;return}function xi(b,c){b=b|0;c=+c;g[b+572>>2]=c;a[b+553>>0]=0;return}function yi(b,c){b=b|0;c=+c;g[b+572>>2]=c;a[b+553>>0]=1;return}function zi(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;c=i;i=i+48|0;Oo(a+364|0,c+16|0);h=-+g[c+16>>2];e=-+g[c+16+4>>2];m=-+g[c+16+8>>2];l=+g[c+16+12>>2];f=+g[b>>2];n=+g[b+12>>2];k=+g[b+8>>2];j=+g[b+4>>2];Oo(a+300|0,c);p=+g[c>>2];q=+g[c+12>>2];d=+g[c+8>>2];o=+g[c+4>>2];g[c+32>>2]=p*(l*n-f*h-j*e-k*m)+(l*f+n*h+k*e-j*m)*q+(f*m+(n*e+l*j)-k*h)*d-(n*m+l*k+j*h-f*e)*o;g[c+32+4>>2]=p*(n*m+l*k+j*h-f*e)+(q*(f*m+(n*e+l*j)-k*h)+(l*n-f*h-j*e-k*m)*o)-(l*f+n*h+k*e-j*m)*d;g[c+32+8>>2]=q*(n*m+l*k+j*h-f*e)+(l*n-f*h-j*e-k*m)*d+(l*f+n*h+k*e-j*m)*o-p*(f*m+(n*e+l*j)-k*h);g[c+32+12>>2]=(l*n-f*h-j*e-k*m)*q-p*(l*f+n*h+k*e-j*m)-(f*m+(n*e+l*j)-k*h)*o-(n*m+l*k+j*h-f*e)*d;xr(a,c+32|0);i=c;return}function Ai(a,b){a=a|0;b=b|0;xr(a,b);return}function Bi(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Ci(a){a=a|0;return +(+g[a+16>>2])}function Di(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Ei(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Fi(){var a=0,b=0;b=i;i=i+32|0;a=XE(92)|0;a:do if(!a){while(1){a=c[2711]|0;c[2711]=a+0;if(!a)break;kc[a&3]();a=XE(92)|0;if(a)break a}a=Ya(4)|0;c[a>>2]=10832;rb(a|0,2408,207)}while(0);c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=4096;c[b+12>>2]=4096;c[b+16>>2]=0;c[b+20>>2]=1;tt(a,b);i=b;return a|0}function Gi(a){a=a|0;var b=0;b=XE(92)|0;a:do if(!b){while(1){b=c[2711]|0;c[2711]=b+0;if(!b)break;kc[b&3]();b=XE(92)|0;if(b)break a}b=Ya(4)|0;c[b>>2]=10832;rb(b|0,2408,207)}while(0);tt(b,a);return b|0}function Hi(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ii(a,b){a=+a;b=+b;var d=0;c[2703]=(c[2703]|0)+1;d=XE(95)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=1065353216;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;g[d+56>>2]=a;g[d+60>>2]=b;c[d+4>>2]=11;g[d+52>>2]=a/+O(+(a*a+b*b));c[d>>2]=6704;c[d+64>>2]=0;c[d+68>>2]=2;c[d+72>>2]=1;g[d+28>>2]=a;g[d+36>>2]=b;g[d+32>>2]=a;return d|0}function Ji(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Ki(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Li(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Mi(a,b){a=+a;b=+b;var d=0;c[2703]=(c[2703]|0)+1;d=XE(95)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=1065353216;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;g[d+56>>2]=a;g[d+60>>2]=b;c[d+4>>2]=11;g[d+52>>2]=a/+O(+(a*a+b*b));c[d>>2]=6804;c[d+64>>2]=1;c[d+68>>2]=0;c[d+72>>2]=2;g[d+32>>2]=a;g[d+28>>2]=b;g[d+36>>2]=a;return d|0}function Ni(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Oi(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Pi(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Qi(){var a=0;c[2703]=(c[2703]|0)+1;a=XE(191)|0;if(!a){a=0;KA(a,1,1);return a|0}c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16;KA(a,1,1);return a|0}function Ri(a){a=a|0;var b=0;c[2703]=(c[2703]|0)+1;b=XE(191)|0;if(!b){b=0;KA(b,a,1);return b|0}c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16;KA(b,a,1);return b|0}function Si(a,b){a=a|0;b=b|0;var d=0;c[2703]=(c[2703]|0)+1;d=XE(191)|0;if(!d){d=0;KA(d,a,b);return d|0}c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16;KA(d,a,b);return d|0}function Ti(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+32>>2]|0;c[f>>2]=(c[f>>2]|0)+1;LA(a,MA(a,b,0)|0);LA(a,MA(a,d,0)|0);LA(a,MA(a,e,0)|0);return}function Ui(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=c[a+32>>2]|0;c[g>>2]=(c[g>>2]|0)+1;LA(a,MA(a,b,f)|0);LA(a,MA(a,d,f)|0);LA(a,MA(a,e,f)|0);return}function Vi(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Wi(){var b=0;c[2703]=(c[2703]|0)+1;b=XE(131)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b+8>>2]=0;c[b+12>>2]=1065353216;c[b+16>>2]=1065353216;c[b+20>>2]=1065353216;g[b+24>>2]=0.0;g[b+44>>2]=.03999999910593033;c[b+52>>2]=0;c[b+56>>2]=1065353216;c[b+60>>2]=1065353216;c[b+64>>2]=1065353216;g[b+68>>2]=0.0;c[b+72>>2]=-1082130432;c[b+76>>2]=-1082130432;c[b+80>>2]=-1082130432;g[b+84>>2]=0.0;a[b+88>>0]=0;c[b>>2]=7584;a[b+108>>0]=1;c[b+104>>2]=0;c[b+100>>2]=0;c[b+4>>2]=4;c[b+96>>2]=0;wy(b);return b|0}function Xi(a,b){a=a|0;b=b|0;Qy(a,b,1);return}function Yi(a,b,c){a=a|0;b=b|0;c=c|0;Qy(a,b,c);return}function Zi(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function _i(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function $i(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function aj(){var b=0,d=0;c[2703]=(c[2703]|0)+1;b=XE(791)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b>>2]=1025;c[b+116>>2]=0;a[b+120>>0]=0;d=b+124|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+300>>2]=0;a[b+304>>0]=0;d=b+308|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+484>>2]=0;a[b+488>>0]=0;d=b+492|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+668>>2]=0;a[b+672>>0]=0;d=b+676|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+740>>2]=0;c[b+744>>2]=0;c[b+748>>2]=0;c[b+768>>2]=0;return b|0}function bj(a){a=a|0;return c[a+740>>2]|0}function cj(a){a=a|0;return c[a+744>>2]|0}function dj(a){a=a|0;return c[a+748>>2]|0}function ej(a,b){a=a|0;b=b|0;return a+4+(b*184|0)|0}function fj(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function gj(a){a=a|0;var b=0,d=0.0,e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0;c[2703]=(c[2703]|0)+1;b=XE(75)|0;if(!b)i=0;else{c[(b+4+15&-16)+-4>>2]=b;i=b+4+15&-16}c[i+8>>2]=0;h=i+12|0;c[h>>2]=1065353216;e=i+16|0;c[e>>2]=1065353216;f=i+20|0;c[f>>2]=1065353216;g[i+24>>2]=0.0;b=i+44|0;g[b>>2]=.03999999910593033;c[i+52>>2]=0;c[i>>2]=8172;c[i+4>>2]=0;k=+g[a>>2];j=+g[a+4>>2];d=+g[a+8>>2];d=+g[a+((k<j?(k<d?0:2):j<d?1:2)<<2)>>2]*.10000000149011612;if(d<.03999999910593033){p=+su(i);k=+Tb[c[(c[i>>2]|0)+48>>2]&15](i);q=+Tb[c[(c[i>>2]|0)+48>>2]&15](i);n=i+28|0;p=p+ +g[n>>2];m=i+32|0;k=k+ +g[m>>2];l=i+36|0;q=q+ +g[l>>2];g[b>>2]=d;o=+Tb[c[(c[i>>2]|0)+48>>2]&15](i);j=+Tb[c[(c[i>>2]|0)+48>>2]&15](i);d=q-+Tb[c[(c[i>>2]|0)+48>>2]&15](i);g[n>>2]=p-o;g[m>>2]=k-j;g[l>>2]=d;g[i+40>>2]=0.0;b=c[i>>2]|0}else b=8172;j=+Tb[c[b+48>>2]&15](i);o=+Tb[c[(c[i>>2]|0)+48>>2]&15](i);d=+Tb[c[(c[i>>2]|0)+48>>2]&15](i);o=+g[a+4>>2]*+g[e>>2]-o;d=+g[a+8>>2]*+g[f>>2]-d;g[i+28>>2]=+g[a>>2]*+g[h>>2]-j;g[i+32>>2]=o;g[i+36>>2]=d;g[i+40>>2]=0.0;return i|0}function hj(a,b){a=a|0;b=+b;Cb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function ij(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function jj(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function kj(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function lj(b){b=b|0;var d=0,e=0,f=0,g=0;d=XE(5260)|0;a:do if(!d){while(1){d=c[2711]|0;c[2711]=d+0;if(!d)break;kc[d&3]();d=XE(5260)|0;if(d)break a}d=Ya(4)|0;c[d>>2]=10832;rb(d|0,2408,207)}while(0);c[d>>2]=5220;c[d+4>>2]=2;a[d+24>>0]=1;c[d+20>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+28>>2]=5856;f=d+5256|0;c[f>>2]=b;c[d+60>>2]=70;c[d+64>>2]=Hb[c[(c[b>>2]|0)+12>>2]&127](b)|0;c[d+68>>2]=Hb[c[(c[b>>2]|0)+8>>2]&127](b)|0;e=0;do{b=0;do{g=c[f>>2]|0;c[d+72+(e*144|0)+(b<<2)>>2]=Qb[c[(c[g>>2]|0)+16>>2]&63](g,e,b)|0;b=b+1|0}while((b|0)<36);e=e+1|0}while((e|0)<36);return d|0}function mj(a){a=a|0;return Hb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function nj(a,b){a=a|0;b=b|0;return _b[c[(c[a>>2]|0)+40>>2]&31](a,b)|0}function oj(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function pj(){var a=0;a=XE(24)|0;a:do if(!a){while(1){a=c[2711]|0;c[2711]=a+0;if(!a)break;kc[a&3]();a=XE(24)|0;if(a)break a}a=Ya(4)|0;c[a>>2]=10832;rb(a|0,2408,207)}while(0);g[a>>2]=5.880000114440918;g[a+4>>2]=.8299999833106995;g[a+8>>2]=.8799999952316284;g[a+12>>2]=500.0;g[a+16>>2]=10.5;g[a+20>>2]=6.0e3;return a|0}function qj(a){a=a|0;return +(+g[a>>2])}function rj(a,b){a=a|0;b=+b;g[a>>2]=b;return}function sj(a){a=a|0;return +(+g[a+4>>2])}function tj(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function uj(a){a=a|0;return +(+g[a+8>>2])}function vj(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function wj(a){a=a|0;return +(+g[a+12>>2])}function xj(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function yj(a){a=a|0;return +(+g[a+16>>2])}function zj(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Aj(a){a=a|0;return +(+g[a+20>>2])}function Bj(a,b){a=a|0;b=+b;g[a+20>>2]=b;return}function Cj(){var a=0;c[2703]=(c[2703]|0)+1;a=XE(111)|0;if(!a){a=0;Mw(a,1);return a|0}c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16;Mw(a,1);return a|0}function Dj(a){a=a|0;var b=0;c[2703]=(c[2703]|0)+1;b=XE(111)|0;if(!b){b=0;Mw(b,a);return b|0}c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16;Mw(b,a);return b|0}function Ej(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0;p=i;i=i+128|0;c[b+68>>2]=(c[b+68>>2]|0)+1;c[p>>2]=c[d>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];c[p+12>>2]=c[d+12>>2];c[p+16>>2]=c[d+16>>2];c[p+16+4>>2]=c[d+16+4>>2];c[p+16+8>>2]=c[d+16+8>>2];c[p+16+12>>2]=c[d+16+12>>2];c[p+32>>2]=c[d+32>>2];c[p+32+4>>2]=c[d+32+4>>2];c[p+32+8>>2]=c[d+32+8>>2];c[p+32+12>>2]=c[d+32+12>>2];c[p+48>>2]=c[d+48>>2];c[p+48+4>>2]=c[d+48+4>>2];c[p+48+8>>2]=c[d+48+8>>2];c[p+48+12>>2]=c[d+48+12>>2];n=c[e+4>>2]|0;o=+Tb[c[(c[e>>2]|0)+48>>2]&15](e);nc[c[(c[e>>2]|0)+8>>2]&127](e,d,p+112|0,p+96|0);f=+g[p+112>>2];if(+g[b+32>>2]>f)g[b+32>>2]=f;f=+g[p+96>>2];if(+g[b+48>>2]<f)g[b+48>>2]=f;f=+g[p+112+4>>2];if(+g[b+36>>2]>f)g[b+36>>2]=f;f=+g[p+96+4>>2];if(+g[b+52>>2]<f)g[b+52>>2]=f;f=+g[p+112+8>>2];if(+g[b+40>>2]>f)g[b+40>>2]=f;f=+g[p+96+8>>2];if(+g[b+56>>2]<f)g[b+56>>2]=f;l=c[b+64>>2]|0;if(!l){l=0;k=b+16|0}else{c[p+64>>2]=c[p+112>>2];c[p+64+4>>2]=c[p+112+4>>2];c[p+64+8>>2]=c[p+112+8>>2];c[p+64+12>>2]=c[p+112+12>>2];c[p+64+16>>2]=c[p+96>>2];c[p+64+16+4>>2]=c[p+96+4>>2];c[p+64+16+8>>2]=c[p+96+8>>2];c[p+64+16+12>>2]=c[p+96+12>>2];k=c[b+16>>2]|0;d=c[l+4>>2]|0;if(!d){c[2703]=(c[2703]|0)+1;d=XE(63)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}j=d;h=j+44|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(h|0))}else c[l+4>>2]=0;c[d+32>>2]=0;c[d+36>>2]=k;c[d+40>>2]=0;c[d>>2]=c[p+64>>2];c[d+4>>2]=c[p+64+4>>2];c[d+8>>2]=c[p+64+8>>2];c[d+12>>2]=c[p+64+12>>2];c[d+16>>2]=c[p+64+16>>2];c[d+20>>2]=c[p+64+20>>2];c[d+24>>2]=c[p+64+24>>2];c[d+28>>2]=c[p+64+28>>2];NC(l,c[l>>2]|0,d);c[l+12>>2]=(c[l+12>>2]|0)+1;l=d;k=b+16|0}d=c[k>>2]|0;if((d|0)==(c[b+20>>2]|0)?(m=(d|0)!=0?d<<1:1,(d|0)<(m|0)):0){if(!m)h=0;else{c[2703]=(c[2703]|0)+1;d=XE((m*80|3)+16|0)|0;if(!d)h=0;else{c[(d+4+15&-16)+-4>>2]=d;h=d+4+15&-16}d=c[k>>2]|0}if((d|0)>0){j=0;do{q=h+(j*80|0)|0;r=c[b+24>>2]|0;s=r+(j*80|0)|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=h+(j*80|0)+16|0;s=r+(j*80|0)+16|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=h+(j*80|0)+32|0;s=r+(j*80|0)+32|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=h+(j*80|0)+48|0;s=r+(j*80|0)+48|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=h+(j*80|0)+64|0;r=r+(j*80|0)+64|0;c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];j=j+1|0}while((j|0)!=(d|0))}d=c[b+24>>2]|0;if(d){if(a[b+28>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+24>>2]=0}a[b+28>>0]=1;c[b+24>>2]=h;c[b+20>>2]=m;d=c[k>>2]|0}b=c[b+24>>2]|0;m=b+(d*80|0)|0;c[m>>2]=c[p>>2];c[m+4>>2]=c[p+4>>2];c[m+8>>2]=c[p+8>>2];c[m+12>>2]=c[p+12>>2];m=b+(d*80|0)+16|0;c[m>>2]=c[p+16>>2];c[m+4>>2]=c[p+16+4>>2];c[m+8>>2]=c[p+16+8>>2];c[m+12>>2]=c[p+16+12>>2];m=b+(d*80|0)+32|0;c[m>>2]=c[p+32>>2];c[m+4>>2]=c[p+32+4>>2];c[m+8>>2]=c[p+32+8>>2];c[m+12>>2]=c[p+32+12>>2];m=b+(d*80|0)+48|0;c[m>>2]=c[p+48>>2];c[m+4>>2]=c[p+48+4>>2];c[m+8>>2]=c[p+48+8>>2];c[m+12>>2]=c[p+48+12>>2];b=b+(d*80|0)+64|0;c[b>>2]=e;c[b+4>>2]=n;g[b+8>>2]=o;c[b+12>>2]=l;c[k>>2]=(c[k>>2]|0)+1;i=p;return}function Fj(a,b){a=a|0;b=+b;Cb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function Gj(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Hj(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Ij(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Jj(a,d){a=a|0;d=d|0;var e=0,f=0;e=XE(80)|0;a:do if(!e){while(1){e=c[2711]|0;c[2711]=e+0;if(!e)break;kc[e&3]();e=XE(80)|0;if(e)break a}e=Ya(4)|0;c[e>>2]=10832;rb(e|0,2408,207)}while(0);g[e+4>>2]=1.0;b[e+8>>1]=1;b[e+10>>1]=-1;c[e>>2]=2932;f=e+12|0;c[f>>2]=c[a>>2];c[f+4>>2]=c[a+4>>2];c[f+8>>2]=c[a+8>>2];c[f+12>>2]=c[a+12>>2];a=e+28|0;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];c[e+76>>2]=0;return e|0}function Kj(a){a=a|0;return +g[a+4>>2]<1.0|0}function Lj(a){a=a|0;return a+12|0}function Mj(a,b){a=a|0;b=b|0;c[a+12>>2]=c[b>>2];c[a+12+4>>2]=c[b+4>>2];c[a+12+8>>2]=c[b+8>>2];c[a+12+12>>2]=c[b+12>>2];return}function Nj(a){a=a|0;return a+28|0}function Oj(a,b){a=a|0;b=b|0;c[a+28>>2]=c[b>>2];c[a+28+4>>2]=c[b+4>>2];c[a+28+8>>2]=c[b+8>>2];c[a+28+12>>2]=c[b+12>>2];return}function Pj(a){a=a|0;return a+44|0}function Qj(a,b){a=a|0;b=b|0;c[a+44>>2]=c[b>>2];c[a+44+4>>2]=c[b+4>>2];c[a+44+8>>2]=c[b+8>>2];c[a+44+12>>2]=c[b+12>>2];return}function Rj(a){a=a|0;return a+60|0}function Sj(a,b){a=a|0;b=b|0;c[a+60>>2]=c[b>>2];c[a+60+4>>2]=c[b+4>>2];c[a+60+8>>2]=c[b+8>>2];c[a+60+12>>2]=c[b+12>>2];return}function Tj(a){a=a|0;return b[a+8>>1]|0}function Uj(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function Vj(a){a=a|0;return b[a+10>>1]|0}function Wj(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function Xj(a){a=a|0;return +(+g[a+4>>2])}function Yj(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Zj(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function _j(){var a=0;c[2703]=(c[2703]|0)+1;a=XE(219)|0;if(!a)a=0;else{c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}Po();Po();Qo(a,2812,2812);return a|0}function $j(a){a=a|0;var b=0;c[2703]=(c[2703]|0)+1;b=XE(219)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}Po();Qo(b,a,2812);return b|0}function ak(a,b){a=a|0;b=b|0;var d=0;c[2703]=(c[2703]|0)+1;d=XE(219)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}Qo(d,a,b);return d|0}function bk(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+8>>2]&127](a,b);return}function ck(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function dk(a){a=a|0;return a+4|0}function ek(a,b){a=a|0;b=b|0;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+20+4>>2]=c[b+16+4>>2];c[a+20+8>>2]=c[b+16+8>>2];c[a+20+12>>2]=c[b+16+12>>2];c[a+36>>2]=c[b+32>>2];c[a+36+4>>2]=c[b+32+4>>2];c[a+36+8>>2]=c[b+32+8>>2];c[a+36+12>>2]=c[b+32+12>>2];c[a+52>>2]=c[b+48>>2];c[a+52+4>>2]=c[b+48+4>>2];c[a+52+8>>2]=c[b+48+8>>2];c[a+52+12>>2]=c[b+48+12>>2];return}function fk(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function gk(a,d){a=a|0;d=d|0;var e=0,f=0;e=XE(84)|0;a:do if(!e){while(1){e=c[2711]|0;c[2711]=e+0;if(!e)break;kc[e&3]();e=XE(84)|0;if(e)break a}e=Ya(4)|0;c[e>>2]=10832;rb(e|0,2408,207)}while(0);g[e+4>>2]=1.0;c[e+8>>2]=0;b[e+12>>1]=1;b[e+14>>1]=-1;c[e+16>>2]=0;c[e>>2]=2772;f=e+20|0;c[f>>2]=c[a>>2];c[f+4>>2]=c[a+4>>2];c[f+8>>2]=c[a+8>>2];c[f+12>>2]=c[a+12>>2];a=e+36|0;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];return e|0}function hk(a){a=a|0;return (c[a+8>>2]|0)!=0|0}function ik(a){a=a|0;return a+20|0}function jk(a,b){a=a|0;b=b|0;c[a+20>>2]=c[b>>2];c[a+20+4>>2]=c[b+4>>2];c[a+20+8>>2]=c[b+8>>2];c[a+20+12>>2]=c[b+12>>2];return}function kk(a){a=a|0;return a+36|0}function lk(a,b){a=a|0;b=b|0;c[a+36>>2]=c[b>>2];c[a+36+4>>2]=c[b+4>>2];c[a+36+8>>2]=c[b+8>>2];c[a+36+12>>2]=c[b+12>>2];return}function mk(a){a=a|0;return a+52|0}function nk(a,b){a=a|0;b=b|0;c[a+52>>2]=c[b>>2];c[a+52+4>>2]=c[b+4>>2];c[a+52+8>>2]=c[b+8>>2];c[a+52+12>>2]=c[b+12>>2];return}function ok(a){a=a|0;return a+68|0}function pk(a,b){a=a|0;b=b|0;c[a+68>>2]=c[b>>2];c[a+68+4>>2]=c[b+4>>2];c[a+68+8>>2]=c[b+8>>2];c[a+68+12>>2]=c[b+12>>2];return}function qk(a){a=a|0;return b[a+12>>1]|0}function rk(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function sk(a){a=a|0;return b[a+14>>1]|0}function tk(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function uk(a){a=a|0;return c[a+8>>2]|0}function vk(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function wk(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function xk(a,b){a=+a;b=+b;var d=0;c[2703]=(c[2703]|0)+1;d=XE(75)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=1065353216;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+4>>2]=10;c[d>>2]=7820;c[d+52>>2]=0;g[d+28>>2]=b*.5;g[d+32>>2]=a;g[d+36>>2]=a;g[d+40>>2]=0.0;return d|0}function yk(a,b){a=a|0;b=+b;Cb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function zk(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Ak(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Bk(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ck(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0;f=XE(16)|0;a:do if(!f){while(1){f=c[2711]|0;c[2711]=f+0;if(!f)break;kc[f&3]();f=XE(16)|0;if(f)break a}f=Ya(4)|0;c[f>>2]=10832;rb(f|0,2408,207)}while(0);g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=e;return f|0}function Dk(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function Ek(a){a=a|0;return +(+g[a>>2])}function Fk(a){a=a|0;return +(+g[a+4>>2])}function Gk(a){a=a|0;return +(+g[a+8>>2])}function Hk(a){a=a|0;return +(+g[a+12>>2])}function Ik(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Jk(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Kk(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function Lk(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function Mk(a){a=a|0;if(!a)return;YE(a);return}function Nk(a,b){a=+a;b=+b;var d=0;c[2703]=(c[2703]|0)+1;d=XE(75)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=1065353216;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+4>>2]=10;c[d>>2]=7920;c[d+52>>2]=2;g[d+28>>2]=a;g[d+32>>2]=a;g[d+36>>2]=b*.5;g[d+40>>2]=0.0;return d|0}function Ok(a,b){a=a|0;b=+b;Cb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function Pk(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Qk(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Rk(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Sk(a){a=a|0;var b=0;b=XE(8)|0;a:do if(!b){while(1){b=c[2711]|0;c[2711]=b+0;if(!b)break;kc[b&3]();b=XE(8)|0;if(b)break a}b=Ya(4)|0;c[b>>2]=10832;rb(b|0,2408,207)}while(0);c[b>>2]=4352;c[b+4>>2]=a;return b|0}function Tk(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Uk(a){a=a|0;return +(+g[a+216>>2])}function Vk(a,b){a=a|0;b=+b;g[a+216>>2]=b;return}function Wk(a){a=a|0;return +(+g[a+228>>2])}function Xk(a,b){a=a|0;b=+b;g[a+228>>2]=b;return}function Yk(a){a=a|0;return +(+g[a+244>>2])}function Zk(a,b){a=a|0;b=+b;g[a+244>>2]=b;return}function _k(a){a=a|0;return +(+g[a+204>>2])}function $k(a,b){a=a|0;b=+b;g[a+204>>2]=b;return}function al(a){a=a|0;return +(+g[a+212>>2])}function bl(a,b){a=a|0;b=+b;g[a+212>>2]=b;return}function cl(a){a=a|0;return +(+g[a+220>>2])}function dl(a,b){a=a|0;b=+b;g[a+220>>2]=b;return}function el(a){a=a|0;return +(+g[a+224>>2])}function fl(a,b){a=a|0;b=+b;g[a+224>>2]=b;return}function gl(a){a=a|0;return +(+g[a+232>>2])}function hl(a,b){a=a|0;b=+b;g[a+232>>2]=b;return}function il(a){a=a|0;return +(+g[a+248>>2])}function jl(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function kl(a){a=a|0;return +(+g[a+208>>2])}function ll(a,b){a=a|0;b=+b;g[a+208>>2]=b;return}function ml(a){a=a|0;return +(+g[a+276>>2])}function nl(a,b){a=a|0;b=+b;g[a+276>>2]=b;return}function ol(b){b=b|0;return (a[b+260>>0]&1)!=0|0}function pl(b,c){b=b|0;c=c|0;a[b+260>>0]=c&1;return}function ql(a){a=a|0;return a+156|0}function rl(a,b){a=a|0;b=b|0;c[a+156>>2]=c[b>>2];c[a+156+4>>2]=c[b+4>>2];c[a+156+8>>2]=c[b+8>>2];c[a+156+12>>2]=c[b+12>>2];return}function sl(a){a=a|0;if(!a)return;YE(a);return}function tl(){var a=0;c[2703]=(c[2703]|0)+1;a=XE(35)|0;if(!a){a=0;return a|0}c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16;return a|0}function ul(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0;c[2703]=(c[2703]|0)+1;f=XE(35)|0;c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16;g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=e;return f|0}function vl(a){a=a|0;return +(+g[a+12>>2])}function wl(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function xl(a){a=a|0;var b=0.0,c=0.0,d=0.0;d=+g[a>>2];c=+g[a+4>>2];b=+g[a+8>>2];return +(+O(+(d*d+c*c+b*b)))}function yl(a){a=a|0;return +(+g[a>>2])}function zl(a){a=a|0;return +(+g[a+4>>2])}function Al(a){a=a|0;return +(+g[a+8>>2])}function Bl(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Cl(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Dl(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function El(a,b){a=a|0;b=+b;g[a>>2]=+g[a>>2]*b;g[a+4>>2]=+g[a+4>>2]*b;g[a+8>>2]=+g[a+8>>2]*b;return a|0}function Fl(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function Gl(b,d,e){b=b|0;d=d|0;e=+e;var f=0,h=0;c[2703]=(c[2703]|0)+1;f=XE(203)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[f>>2]=4988;h=f+60|0;a[f+144>>0]=1;c[f+140>>2]=0;c[f+132>>2]=0;c[f+136>>2]=0;c[f+176>>2]=1;g[f+56>>2]=.019999999552965164;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;a[f+170>>0]=1;c[f+8>>2]=b;g[f+52>>2]=e;g[f+48>>2]=0.0;c[f+12>>2]=d;a[f+171>>0]=1;g[f+172>>2]=0.0;g[f+16>>2]=0.0;g[f+20>>2]=0.0;g[f+44>>2]=29.399999618530273;g[f+24>>2]=55.0;g[f+28>>2]=10.0;a[f+168>>0]=0;a[f+169>>0]=0;a[f+180>>0]=1;g[f+36>>2]=.7853981852531433;g[f+40>>2]=.7071067690849304;g[f+108>>2]=0.0;a[f+181>>0]=0;a[f+182>>0]=0;return f|0}function Hl(b,d,e,f){b=b|0;d=d|0;e=+e;f=f|0;var h=0,i=0;c[2703]=(c[2703]|0)+1;h=XE(203)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h>>2]=4988;i=h+60|0;a[h+144>>0]=1;c[h+140>>2]=0;c[h+132>>2]=0;c[h+136>>2]=0;c[h+176>>2]=f;g[h+56>>2]=.019999999552965164;c[i>>2]=0;c[i+4>>2]=0;c[i+8>>2]=0;c[i+12>>2]=0;a[h+170>>0]=1;c[h+8>>2]=b;g[h+52>>2]=e;g[h+48>>2]=0.0;c[h+12>>2]=d;a[h+171>>0]=1;g[h+172>>2]=0.0;g[h+16>>2]=0.0;g[h+20>>2]=0.0;g[h+44>>2]=29.399999618530273;g[h+24>>2]=55.0;g[h+28>>2]=10.0;a[h+168>>0]=0;a[h+169>>0]=0;a[h+180>>0]=1;g[h+36>>2]=.7853981852531433;g[h+40>>2]=.7071067690849304;g[h+108>>2]=0.0;a[h+181>>0]=0;a[h+182>>0]=0;return h|0}function Il(a,b){a=a|0;b=b|0;c[a+176>>2]=(b|0)<0?0:(b|0)>2?2:b;return}function Jl(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+16>>2]&127](a,b);return}function Kl(a,b,d){a=a|0;b=b|0;d=+d;lc[c[(c[a>>2]|0)+20>>2]&7](a,b,d);return}function Ll(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+28>>2]&127](a,b);return}function Ml(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+32>>2]&127](a,b);return}function Nl(a,b,d){a=a|0;b=b|0;d=+d;lc[c[(c[a>>2]|0)+36>>2]&7](a,b,d);return}function Ol(a,b){a=a|0;b=+b;g[a+24>>2]=b;return}function Pl(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function Ql(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function Rl(a){a=a|0;return Hb[c[(c[a>>2]|0)+40>>2]&127](a)|0}function Sl(a){a=a|0;Db[c[(c[a>>2]|0)+44>>2]&255](a);return}function Tl(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function Ul(a){a=a|0;return +(+g[a+44>>2])}function Vl(a,b){a=a|0;b=+b;g[a+36>>2]=b;g[a+40>>2]=+Q(+b);return}function Wl(a){a=a|0;return +(+g[a+36>>2])}function Xl(a){a=a|0;return c[a+8>>2]|0}function Yl(b,c){b=b|0;c=c|0;a[b+170>>0]=c&1;return}function Zl(a){a=a|0;return Hb[c[(c[a>>2]|0)+48>>2]&127](a)|0}function _l(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function $l(a,b){a=a|0;b=+b;var d=0,e=0,f=0.0,h=0.0,i=0.0,j=0.0;c[2703]=(c[2703]|0)+1;d=XE(103)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=d+4|0;c[e>>2]=35;c[d+8>>2]=0;g[d+12>>2]=0.0;c[d>>2]=7280;j=+g[a>>2];i=+g[a+4>>2];h=+g[a+8>>2];a=c[a+12>>2]|0;f=1.0/+O(+(j*j+i*i+h*h));g[d+48>>2]=j*f;g[d+52>>2]=i*f;g[d+56>>2]=h*f;c[d+60>>2]=a;g[d+64>>2]=b;a=d+68|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[e>>2]=28;return d|0}function am(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function bm(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function cm(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function dm(a){a=a|0;return (c[a+44>>2]|0)!=0|0}function em(a,b){a=a|0;b=b|0;c[a+44>>2]=b&1;return}function fm(a){a=a|0;return ~~+g[a+48>>2]|0}function gm(a,b){a=a|0;b=b|0;g[a+48>>2]=+(b|0);return}function hm(a){a=a|0;if(!a)return;YE(a);return}function im(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+60>>2]&127](a,b);return}function jm(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function km(a){a=+a;var b=0;c[2703]=(c[2703]|0)+1;b=XE(71)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b+8>>2]=0;c[b+12>>2]=1065353216;c[b+16>>2]=1065353216;c[b+20>>2]=1065353216;g[b+24>>2]=0.0;c[b>>2]=6904;c[b+4>>2]=8;g[b+28>>2]=a;g[b+44>>2]=a;return b|0}function lm(a,b){a=a|0;b=+b;Cb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function mm(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function nm(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function om(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function pm(){var a=0;a=XE(24)|0;a:do if(!a){while(1){a=c[2711]|0;c[2711]=a+0;if(!a)break;kc[a&3]();a=XE(24)|0;if(a)break a}a=Ya(4)|0;c[a>>2]=10832;rb(a|0,2408,207)}while(0);c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=4096;c[a+12>>2]=4096;c[a+16>>2]=0;c[a+20>>2]=1;return a|0}function qm(a){a=a|0;if(!a)return;YE(a);return}function rm(a,b){a=a|0;b=b|0;var d=0;c[2703]=(c[2703]|0)+1;d=XE(783)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}Fr(d,a,b,0);return d|0}function sm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[2703]=(c[2703]|0)+1;e=XE(783)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}Fr(e,a,b,d);return e|0}function tm(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;c[2703]=(c[2703]|0)+1;h=XE(783)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h+4>>2]=4;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=4200;b=h+552|0;c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];b=h+568|0;c[b>>2]=c[e+16>>2];c[b+4>>2]=c[e+16+4>>2];c[b+8>>2]=c[e+16+8>>2];c[b+12>>2]=c[e+16+12>>2];b=h+584|0;c[b>>2]=c[e+32>>2];c[b+4>>2]=c[e+32+4>>2];c[b+8>>2]=c[e+32+8>>2];c[b+12>>2]=c[e+32+12>>2];b=h+600|0;c[b>>2]=c[e+48>>2];c[b+4>>2]=c[e+48+4>>2];c[b+8>>2]=c[e+48+8>>2];c[b+12>>2]=c[e+48+12>>2];b=h+616|0;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];b=h+632|0;c[b>>2]=c[f+16>>2];c[b+4>>2]=c[f+16+4>>2];c[b+8>>2]=c[f+16+8>>2];c[b+12>>2]=c[f+16+12>>2];b=h+648|0;c[b>>2]=c[f+32>>2];c[b+4>>2]=c[f+32+4>>2];c[b+8>>2]=c[f+32+8>>2];c[b+12>>2]=c[f+32+12>>2];b=h+664|0;c[b>>2]=c[f+48>>2];c[b+4>>2]=c[f+48+4>>2];c[b+8>>2]=c[f+48+8>>2];c[b+12>>2]=c[f+48+12>>2];g[h+688>>2]=0.0;g[h+692>>2]=-1.0;g[h+696>>2]=.8999999761581421;g[h+700>>2]=.30000001192092896;g[h+704>>2]=1.0;g[h+708>>2]=0.0;g[h+712>>2]=0.0;a[h+716>>0]=0;a[h+736>>0]=0;a[h+737>>0]=0;a[h+738>>0]=0;a[h+739>>0]=1;a[h+740>>0]=0;c[h+748>>2]=0;g[h+732>>2]=1.0;return h|0}function um(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0;c[2703]=(c[2703]|0)+1;i=XE(783)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}c[i+4>>2]=4;c[i+8>>2]=-1;c[i+12>>2]=-1;g[i+16>>2]=3402823466385288598117041.0e14;a[i+20>>0]=1;a[i+21>>0]=0;c[i+24>>2]=-1;c[i+28>>2]=b;c[i+32>>2]=d;g[i+36>>2]=0.0;g[i+40>>2]=.30000001192092896;c[i+44>>2]=0;c[i>>2]=4200;b=i+552|0;c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];b=i+568|0;c[b>>2]=c[e+16>>2];c[b+4>>2]=c[e+16+4>>2];c[b+8>>2]=c[e+16+8>>2];c[b+12>>2]=c[e+16+12>>2];b=i+584|0;c[b>>2]=c[e+32>>2];c[b+4>>2]=c[e+32+4>>2];c[b+8>>2]=c[e+32+8>>2];c[b+12>>2]=c[e+32+12>>2];b=i+600|0;c[b>>2]=c[e+48>>2];c[b+4>>2]=c[e+48+4>>2];c[b+8>>2]=c[e+48+8>>2];c[b+12>>2]=c[e+48+12>>2];b=i+616|0;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];b=i+632|0;c[b>>2]=c[f+16>>2];c[b+4>>2]=c[f+16+4>>2];c[b+8>>2]=c[f+16+8>>2];c[b+12>>2]=c[f+16+12>>2];b=i+648|0;c[b>>2]=c[f+32>>2];c[b+4>>2]=c[f+32+4>>2];c[b+8>>2]=c[f+32+8>>2];c[b+12>>2]=c[f+32+12>>2];b=i+664|0;c[b>>2]=c[f+48>>2];c[b+4>>2]=c[f+48+4>>2];c[b+8>>2]=c[f+48+8>>2];c[b+12>>2]=c[f+48+12>>2];g[i+688>>2]=0.0;g[i+692>>2]=-1.0;g[i+696>>2]=.8999999761581421;g[i+700>>2]=.30000001192092896;g[i+704>>2]=1.0;g[i+708>>2]=0.0;g[i+712>>2]=0.0;a[i+716>>0]=0;a[i+736>>0]=0;a[i+737>>0]=0;a[i+738>>0]=0;a[i+739>>0]=1;a[i+740>>0]=h&1;c[i+748>>2]=0;g[i+732>>2]=h?-1.0:1.0;return i|0}function vm(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;c[2703]=(c[2703]|0)+1;h=XE(783)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}Er(h,a,b,d,e,f,g,0);return h|0}function wm(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0;c[2703]=(c[2703]|0)+1;i=XE(783)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}Er(i,a,b,d,e,f,g,h);return i|0}function xm(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a+692>>2]=(c-b)*.5;b=+_E((c-b)*.5+b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+688>>2]=b;g[a+696>>2]=d;g[a+700>>2]=e;g[a+704>>2]=1.0;return}function ym(a,b,c,d,e,f){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;g[a+692>>2]=(c-b)*.5;b=+_E((c-b)*.5+b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+688>>2]=b;g[a+696>>2]=d;g[a+700>>2]=e;g[a+704>>2]=f;return}function zm(b,c,d,e){b=b|0;c=c|0;d=+d;e=+e;a[b+737>>0]=c&1;g[b+680>>2]=d;g[b+684>>2]=e;return}function Am(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Bm(a){a=a|0;return +(+g[a+16>>2])}function Cm(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Dm(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Em(){var a=0;a=XE(12)|0;a:do if(!a){while(1){a=c[2711]|0;c[2711]=a+0;if(!a)break;kc[a&3]();a=XE(12)|0;if(a)break a}a=Ya(4)|0;c[a>>2]=10832;rb(a|0,2408,207)}while(0);g[a>>2]=.30000001192092896;g[a+4>>2]=1.0;g[a+8>>2]=0.0;return a|0}function Fm(a){a=a|0;return +(+g[a>>2])}function Gm(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Hm(a){a=a|0;return +(+g[a+4>>2])}function Im(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Jm(a){a=a|0;return +(+g[a+8>>2])}function Km(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function Lm(a){a=a|0;if(!a)return;YE(a);return}function Mm(a){a=a|0;return c[a>>2]|0}function Nm(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Om(a){a=a|0;return c[a+4>>2]|0}function Pm(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function Qm(a){a=a|0;if(!a)return;YE(a);return}function Rm(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Sm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;c[2703]=(c[2703]|0)+1;f=XE(1407)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}Aq(f,b,d,e);c[f>>2]=3312;c[f+4>>2]=9;a[f+1309>>0]=0;g[f+1316>>2]=0.0;g[f+1340>>2]=0.0;g[f+1364>>2]=1.0;a[f+1310>>0]=0;g[f+1320>>2]=0.0;g[f+1344>>2]=0.0;g[f+1368>>2]=1.0;a[f+1311>>0]=0;g[f+1324>>2]=0.0;g[f+1348>>2]=0.0;g[f+1372>>2]=1.0;a[f+1312>>0]=0;g[f+1328>>2]=0.0;g[f+1352>>2]=0.0;g[f+1376>>2]=1.0;a[f+1313>>0]=0;g[f+1332>>2]=0.0;g[f+1356>>2]=0.0;g[f+1380>>2]=1.0;a[f+1314>>0]=0;g[f+1336>>2]=0.0;g[f+1360>>2]=0.0;g[f+1384>>2]=1.0;return f|0}function Tm(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0;c[2703]=(c[2703]|0)+1;i=XE(1407)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}zq(i,b,d,e,f,h);c[i>>2]=3312;c[i+4>>2]=9;a[i+1309>>0]=0;g[i+1316>>2]=0.0;g[i+1340>>2]=0.0;g[i+1364>>2]=1.0;a[i+1310>>0]=0;g[i+1320>>2]=0.0;g[i+1344>>2]=0.0;g[i+1368>>2]=1.0;a[i+1311>>0]=0;g[i+1324>>2]=0.0;g[i+1348>>2]=0.0;g[i+1372>>2]=1.0;a[i+1312>>0]=0;g[i+1328>>2]=0.0;g[i+1352>>2]=0.0;g[i+1376>>2]=1.0;a[i+1313>>0]=0;g[i+1332>>2]=0.0;g[i+1356>>2]=0.0;g[i+1380>>2]=1.0;a[i+1314>>0]=0;g[i+1336>>2]=0.0;g[i+1360>>2]=0.0;g[i+1384>>2]=1.0;return i|0}function Um(b,c,d){b=b|0;c=c|0;d=d|0;a[b+1309+c>>0]=d&1;if((c|0)<3){a[b+788+c>>0]=d&1;return}else{a[b+868+(c+-3<<6)+44>>0]=d&1;return}}function Vm(a,b,c){a=a|0;b=b|0;c=+c;g[a+1340+(b<<2)>>2]=c;return}function Wm(a,b,c){a=a|0;b=b|0;c=+c;g[a+1364+(b<<2)>>2]=c;return}function Xm(a,b){a=a|0;b=b|0;c[a+680>>2]=c[b>>2];c[a+680+4>>2]=c[b+4>>2];c[a+680+8>>2]=c[b+8>>2];c[a+680+12>>2]=c[b+12>>2];return}function Ym(a,b){a=a|0;b=b|0;c[a+696>>2]=c[b>>2];c[a+696+4>>2]=c[b+4>>2];c[a+696+8>>2]=c[b+8>>2];c[a+696+12>>2]=c[b+12>>2];return}function Zm(a,b){a=a|0;b=b|0;var c=0.0,d=0;d=0;while(1){if((d|0)==3)break;c=+_E(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+868+(d<<6)>>2]=c;d=d+1|0}return}function _m(a,b){a=a|0;b=b|0;var c=0.0,d=0;d=0;while(1){if((d|0)==3)break;c=+_E(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+868+(d<<6)+4>>2]=c;d=d+1|0}return}function $m(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function an(a){a=a|0;return +(+g[a+16>>2])}function bn(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function cn(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function dn(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var h=0;h=XE(44)|0;a:do if(!h){while(1){h=c[2711]|0;c[2711]=h+0;if(!h)break;kc[h&3]();h=XE(44)|0;if(h)break a}h=Ya(4)|0;c[h>>2]=10832;rb(h|0,2408,207)}while(0);c[h>>2]=a;c[h+4>>2]=b;a=h+8|0;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];a=h+24|0;c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];g[h+40>>2]=f;return h|0}function en(a){a=a|0;return c[a>>2]|0}function fn(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function gn(a){a=a|0;return c[a+4>>2]|0}function hn(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function jn(a){a=a|0;return a+8|0}function kn(a,b){a=a|0;b=b|0;c[a+8>>2]=c[b>>2];c[a+8+4>>2]=c[b+4>>2];c[a+8+8>>2]=c[b+8>>2];c[a+8+12>>2]=c[b+12>>2];return}function ln(a){a=a|0;return a+24|0}function mn(a,b){a=a|0;b=b|0;c[a+24>>2]=c[b>>2];c[a+24+4>>2]=c[b+4>>2];c[a+24+8>>2]=c[b+8>>2];c[a+24+12>>2]=c[b+12>>2];return}function nn(a){a=a|0;return +(+g[a+40>>2])}function on(a,b){a=a|0;b=+b;g[a+40>>2]=b;return}function pn(a){a=a|0;if(!a)return;YE(a);return}function qn(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function rn(b){b=b|0;var d=0,e=0;c[2703]=(c[2703]|0)+1;d=XE(635)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+164>>2]=1065353216;c[d+168>>2]=1065353216;c[d+172>>2]=1065353216;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749440.0;e=d+188|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+204>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;g[d+232>>2]=0.0;c[d+236>>2]=1;c[d+240>>2]=0;g[d+244>>2]=1.0;e=d+248|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+4>>2]=1065353216;e=d+8|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+24>>2]=1065353216;e=d+28|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+44>>2]=1065353216;e=d+48|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[d>>2]=2980;a[d+500>>0]=1;c[d+496>>2]=0;c[d+488>>2]=0;c[d+492>>2]=0;sp(d,b);return d|0}function sn(a){a=a|0;return a+4|0}function tn(a,b){a=a|0;b=b|0;up(a,b);return}function un(a,b,c){a=a|0;b=+b;c=+c;g[a+472>>2]=b;g[a+476>>2]=c;return}function vn(a,b,d){a=a|0;b=+b;d=+d;var e=0;e=i;i=i+32|0;g[e+20>>2]=b;g[e+16>>2]=d;g[e+12>>2]=0.0;g[e+8>>2]=1.0;c[a+444>>2]=c[(b<0.0?e+12|0:b>1.0?e+8|0:e+20|0)>>2];g[e+4>>2]=0.0;g[e>>2]=1.0;c[a+448>>2]=c[(d<0.0?e+4|0:d>1.0?e:e+16|0)>>2];i=e;return}function wn(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0,h=0.0,i=0.0,j=0.0;e=c[a+204>>2]|0;if(b==0.0){c[a+204>>2]=e|1;h=0.0}else{c[a+204>>2]=e&-2;h=1.0/b}g[a+344>>2]=h;j=+g[a+384>>2]*b;i=+g[a+388>>2]*b;g[a+364>>2]=+g[a+380>>2]*b;g[a+368>>2]=j;g[a+372>>2]=i;g[a+376>>2]=0.0;b=+g[d>>2];f=b!=0.0?(g[k>>2]=1.0/b,c[k>>2]|0):0;b=+g[d+4>>2];e=b!=0.0?(g[k>>2]=1.0/b,c[k>>2]|0):0;b=+g[d+8>>2];d=b!=0.0?(g[k>>2]=1.0/b,c[k>>2]|0):0;c[a+396>>2]=f;c[a+400>>2]=e;c[a+404>>2]=d;g[a+408>>2]=0.0;i=h*+g[a+352>>2];b=h*+g[a+356>>2];g[a+560>>2]=+g[a+348>>2]*h;g[a+564>>2]=i;g[a+568>>2]=b;g[a+572>>2]=0.0;return}function xn(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0;c[a+348>>2]=c[b>>2];c[a+348+4>>2]=c[b+4>>2];c[a+348+8>>2]=c[b+8>>2];c[a+348+12>>2]=c[b+12>>2];f=+g[a+344>>2];e=+g[a+352>>2]*f;d=+g[a+356>>2]*f;g[a+560>>2]=+g[a+348>>2]*f;g[a+564>>2]=e;g[a+568>>2]=d;g[a+572>>2]=0.0;return}function yn(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;d=+g[b+4>>2]*+g[a+548>>2];c=+g[b+8>>2]*+g[a+552>>2];g[a+428>>2]=+g[a+428>>2]+ +g[b>>2]*+g[a+544>>2];g[a+432>>2]=+g[a+432>>2]+d;g[a+436>>2]=+g[a+436>>2]+c;return}function zn(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;d=+g[a+348>>2];f=+g[a+352>>2];h=+g[b+4>>2]*f;i=+g[a+356>>2];j=+g[b+8>>2]*i;g[a+412>>2]=+g[a+412>>2]+ +g[b>>2]*d;g[a+416>>2]=+g[a+416>>2]+h;g[a+420>>2]=+g[a+420>>2]+j;d=+g[b>>2]*d;f=+g[b+4>>2]*f;i=+g[b+8>>2]*i;j=+g[c+4>>2];h=+g[c+8>>2];k=+g[c>>2];e=(h*d-k*i)*+g[a+548>>2];d=(k*f-j*d)*+g[a+552>>2];g[a+428>>2]=+g[a+428>>2]+(j*i-h*f)*+g[a+544>>2];g[a+432>>2]=+g[a+432>>2]+e;g[a+436>>2]=+g[a+436>>2]+d;return}function An(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;d=+g[b+4>>2]*+g[a+352>>2];c=+g[b+8>>2]*+g[a+356>>2];g[a+412>>2]=+g[a+412>>2]+ +g[b>>2]*+g[a+348>>2];g[a+416>>2]=+g[a+416>>2]+d;g[a+420>>2]=+g[a+420>>2]+c;return}function Bn(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0;h=+g[b>>2];f=+g[b+4>>2];e=+g[b+8>>2];d=(+g[a+280>>2]*h+ +g[a+284>>2]*f+ +g[a+288>>2]*e)*+g[a+548>>2];c=(+g[a+296>>2]*h+ +g[a+300>>2]*f+ +g[a+304>>2]*e)*+g[a+552>>2];g[a+328>>2]=+g[a+328>>2]+(+g[a+264>>2]*h+ +g[a+268>>2]*f+ +g[a+272>>2]*e)*+g[a+544>>2];g[a+332>>2]=+g[a+332>>2]+d;g[a+336>>2]=+g[a+336>>2]+c;return}function Cn(a,b,c){a=a|0;b=b|0;c=c|0;Ro(a,b,c);return}function Dn(a,b){a=a|0;b=b|0;So(a,b);return}function En(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;n=+g[a+4>>2];h=+g[a+396>>2];m=+g[a+8>>2];e=+g[a+400>>2];l=+g[a+12>>2];c=+g[a+404>>2];k=+g[a+20>>2];j=+g[a+24>>2];i=+g[a+28>>2];f=+g[a+36>>2];d=+g[a+40>>2];b=+g[a+44>>2];g[a+264>>2]=n*h*n+m*e*m+l*c*l;g[a+268>>2]=n*h*k+m*e*j+l*c*i;g[a+272>>2]=n*h*f+m*e*d+l*c*b;g[a+276>>2]=0.0;g[a+280>>2]=h*k*n+e*j*m+c*i*l;g[a+284>>2]=h*k*k+e*j*j+c*i*i;g[a+288>>2]=h*k*f+e*j*d+c*i*b;g[a+292>>2]=0.0;g[a+296>>2]=h*f*n+e*d*m+c*b*l;g[a+300>>2]=h*f*k+e*d*j+c*b*i;g[a+304>>2]=h*f*f+e*d*d+c*b*b;g[a+308>>2]=0.0;return}function Fn(a){a=a|0;return a+312|0}function Gn(a){a=a|0;return a+328|0}function Hn(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+312>>2]=c[b>>2];c[a+312+4>>2]=c[b+4>>2];c[a+312+8>>2]=c[b+8>>2];c[a+312+12>>2]=c[b+12>>2];return}function In(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+328>>2]=c[b>>2];c[a+328+4>>2]=c[b+4>>2];c[a+328+8>>2]=c[b+8>>2];c[a+328+12>>2]=c[b+12>>2];return}function Jn(a){a=a|0;return c[a+480>>2]|0}function Kn(a,b){a=a|0;b=b|0;c[a+480>>2]=b;if(!b)return;Fb[c[(c[b>>2]|0)+8>>2]&127](b,a+4|0);return}function Ln(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+544>>2]=c[b>>2];c[a+544+4>>2]=c[b+4>>2];c[a+544+8>>2]=c[b+8>>2];c[a+544+12>>2]=c[b+12>>2];return}function Mn(a,b){a=a|0;b=b|0;return ((c[b+236>>2]&2|0)==0?0:b)|0}function Nn(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b>>2];c[a+164+4>>2]=c[b+4>>2];c[a+164+8>>2]=c[b+8>>2];c[a+164+12>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;b=a+180|0;c[b>>2]=d;return}b=a+180|0;c[b>>2]=d;return}function On(a){a=a|0;return c[a+192>>2]|0}function Pn(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Qn(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function Rn(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function Sn(a){a=a|0;if(c[a+204>>2]&3)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function Tn(a,b){a=a|0;b=b|0;if(!b?(c[a+204>>2]&3|0)!=0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function Un(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function Vn(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function Wn(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function Xn(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function Yn(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function Zn(a){a=a|0;return a+4|0}function _n(a){a=a|0;return c[a+204>>2]|0}function $n(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function ao(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+20+4>>2]=c[b+16+4>>2];c[a+20+8>>2]=c[b+16+8>>2];c[a+20+12>>2]=c[b+16+12>>2];c[a+36>>2]=c[b+32>>2];c[a+36+4>>2]=c[b+32+4>>2];c[a+36+8>>2]=c[b+32+8>>2];c[a+36+12>>2]=c[b+32+12>>2];c[a+52>>2]=c[b+48>>2];c[a+52+4>>2]=c[b+48+4>>2];c[a+52+8>>2]=c[b+48+8>>2];c[a+52+12>>2]=c[b+48+12>>2];return}function bo(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function co(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function eo(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function fo(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+8>>2]&255](a);return}function go(a){a=a|0;var b=0;c[2703]=(c[2703]|0)+1;b=XE(75)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}mA(b,a);c[b>>2]=8492;c[b+52>>2]=0;return b|0}function ho(a,b){a=a|0;b=+b;Cb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function io(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function jo(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function ko(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function lo(a){a=a|0;var b=0;c[2703]=(c[2703]|0)+1;b=XE(75)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}mA(b,a);c[b>>2]=8596;c[b+52>>2]=2;return b|0}function mo(a,b){a=a|0;b=+b;Cb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function no(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function oo(a,b,d){a=a|0;b=+b;d=d|0;Mb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function po(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function qo(){var a=0,b=0;a=XE(64)|0;if(a)return a|0;while(1){a=c[2711]|0;c[2711]=a+0;if(!a){b=4;break}kc[a&3]();a=XE(64)|0;if(a){b=5;break}}if((b|0)==4){a=Ya(4)|0;c[a>>2]=10832;rb(a|0,2408,207)}else if((b|0)==5)return a|0;return 0}function ro(a,b){a=a|0;b=b|0;var d=0,e=0;d=XE(64)|0;a:do if(!d){while(1){d=c[2711]|0;c[2711]=d+0;if(!d)break;kc[d&3]();d=XE(64)|0;if(d)break a}d=Ya(4)|0;c[d>>2]=10832;rb(d|0,2408,207)}while(0);e=d+48|0;Zo(d,a);c[e>>2]=c[b>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];return d|0}function so(a){a=a|0;To(a);return}function to(a,b){a=a|0;b=b|0;c[a+48>>2]=c[b>>2];c[a+48+4>>2]=c[b+4>>2];c[a+48+8>>2]=c[b+8>>2];c[a+48+12>>2]=c[b+12>>2];return}function uo(a,b){a=a|0;b=b|0;Zo(a,b);return}function vo(a){a=a|0;return a+48|0}function wo(b){b=b|0;var d=0;d=i;i=i+16|0;if((a[32]|0)==0?(Wa(32)|0)!=0:0)_a(32);Oo(b,d);c[680]=c[d>>2];c[681]=c[d+4>>2];c[682]=c[d+8>>2];c[683]=c[d+12>>2];i=d;return 2720}function xo(a){a=a|0;return a|0}function yo(a){a=a|0;if(!a)return;YE(a);return}function zo(b,d,e){b=b|0;d=d|0;e=e|0;b=XE(152)|0;a:do if(!b){while(1){b=c[2711]|0;c[2711]=b+0;if(!b)break;kc[b&3]();b=XE(152)|0;if(b)break a}b=Ya(4)|0;c[b>>2]=10832;rb(b|0,2408,207)}while(0);c[b>>2]=4316;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;c[b+100>>2]=e;g[b+104>>2]=0.0;a[b+148>>0]=1;c[b+144>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+116>>2]=d;c[b+120>>2]=0;c[b+124>>2]=2;c[b+128>>2]=1;g[b+112>>2]=0.0;g[b+108>>2]=0.0;return b|0}function Ao(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+252>>2]=b;return}function Bo(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+232>>2]=b;return}function Co(a,b){a=a|0;b=b|0;return (c[a+144>>2]|0)+(b*284|0)+92|0}function Do(a,b,d){a=a|0;b=b|0;d=d|0;ms(c[a+116>>2]|0,c[a+144>>2]|0,b,d);return}function Eo(b,d,e,f,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;i=i+288|0;c[w+208>>2]=c[d>>2];c[w+208+4>>2]=c[d+4>>2];c[w+208+8>>2]=c[d+8>>2];c[w+208+12>>2]=c[d+12>>2];n=w+208+16|0;c[n>>2]=c[e>>2];c[n+4>>2]=c[e+4>>2];c[n+8>>2]=c[e+8>>2];c[n+12>>2]=c[e+12>>2];o=w+208+32|0;c[o>>2]=c[f>>2];c[o+4>>2]=c[f+4>>2];c[o+8>>2]=c[f+8>>2];c[o+12>>2]=c[f+12>>2];q=c[k>>2]|0;r=c[k+4>>2]|0;s=c[k+8>>2]|0;t=c[k+16>>2]|0;u=c[k+12>>2]|0;p=c[k+20>>2]|0;c[w>>2]=c[w+208>>2];c[w+4>>2]=c[w+208+4>>2];c[w+8>>2]=c[w+208+8>>2];c[w+12>>2]=c[w+208+12>>2];c[w+16>>2]=c[n>>2];c[w+16+4>>2]=c[n+4>>2];c[w+16+8>>2]=c[n+8>>2];c[w+16+12>>2]=c[n+12>>2];c[w+32>>2]=c[o>>2];c[w+32+4>>2]=c[o+4>>2];c[w+32+8>>2]=c[o+8>>2];c[w+32+12>>2]=c[o+12>>2];f=c[b+136>>2]|0;if((f|0)==(c[b+140>>2]|0)?(v=(f|0)!=0?f<<1:1,(f|0)<(v|0)):0){if(!v)e=0;else{c[2703]=(c[2703]|0)+1;f=XE((v*284|3)+16|0)|0;if(!f)e=0;else{c[(f+4+15&-16)+-4>>2]=f;e=f+4+15&-16}f=c[b+136>>2]|0}if((f|0)>0){d=0;do{k=c[b+144>>2]|0;m=e+(d*284|0)|0;n=k+(d*284|0)|0;o=m+92|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));m=e+(d*284|0)+92|0;n=k+(d*284|0)+92|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=e+(d*284|0)+108|0;n=k+(d*284|0)+108|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=e+(d*284|0)+124|0;n=k+(d*284|0)+124|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=e+(d*284|0)+140|0;n=k+(d*284|0)+140|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=e+(d*284|0)+156|0;n=k+(d*284|0)+156|0;o=m+128|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));d=d+1|0}while((d|0)!=(f|0))}f=c[b+144>>2]|0;if(f){if(a[b+148>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[b+144>>2]=0}a[b+148>>0]=1;c[b+144>>2]=e;c[b+140>>2]=v;f=c[b+136>>2]|0}k=c[b+144>>2]|0;m=k+(f*284|0)|0;n=w+48|0;o=m+92|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));m=k+(f*284|0)+92|0;c[m>>2]=c[w+192>>2];c[m+4>>2]=c[w+192+4>>2];c[m+8>>2]=c[w+192+8>>2];c[m+12>>2]=c[w+192+12>>2];m=k+(f*284|0)+108|0;c[m>>2]=c[w+176>>2];c[m+4>>2]=c[w+176+4>>2];c[m+8>>2]=c[w+176+8>>2];c[m+12>>2]=c[w+176+12>>2];m=k+(f*284|0)+124|0;c[m>>2]=c[w+160>>2];c[m+4>>2]=c[w+160+4>>2];c[m+8>>2]=c[w+160+8>>2];c[m+12>>2]=c[w+160+12>>2];m=k+(f*284|0)+140|0;c[m>>2]=c[w+144>>2];c[m+4>>2]=c[w+144+4>>2];c[m+8>>2]=c[w+144+8>>2];c[m+12>>2]=c[w+144+12>>2];k=k+(f*284|0)+156|0;m=k;n=w;o=m+48|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));g[k+48>>2]=h;c[k+52>>2]=u;g[k+56>>2]=j;c[k+60>>2]=q;c[k+64>>2]=r;c[k+68>>2]=s;c[k+72>>2]=t;g[k+76>>2]=0.0;g[k+80>>2]=0.0;g[k+84>>2]=0.0;g[k+88>>2]=.10000000149011612;c[k+92>>2]=p;g[k+96>>2]=0.0;g[k+100>>2]=0.0;a[k+104>>0]=l&1;m=k+105|0;n=w+256|0;o=m+23|0;do{a[m>>0]=a[n>>0]|0;m=m+1|0;n=n+1|0}while((m|0)<(o|0));r=c[b+136>>2]|0;c[b+136>>2]=r+1;r=(c[b+144>>2]|0)+(r*284|0)|0;ls(c[b+116>>2]|0,r,0);ms(c[b+116>>2]|0,c[b+144>>2]|0,(c[b+136>>2]|0)+-1|0,0);i=w;return r|0}function Fo(a){a=a|0;return c[a+136>>2]|0}function Go(a){a=a|0;return c[a+116>>2]|0}function Ho(a,b){a=a|0;b=b|0;return (c[a+144>>2]|0)+(b*284|0)|0}function Io(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+256>>2]=b;return}function Jo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function Ko(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function Lo(){var a=0,b=0;a=XE(4)|0;if(a){c[a>>2]=2744;return a|0}while(1){a=c[2711]|0;c[2711]=a+0;if(!a){b=4;break}kc[a&3]();a=XE(4)|0;if(a){b=5;break}}if((b|0)==4){a=Ya(4)|0;c[a>>2]=10832;rb(a|0,2408,207)}else if((b|0)==5){c[a>>2]=2744;return a|0}return 0}function Mo(a){a=a|0;if(!a)return;Db[c[(c[a>>2]|0)+4>>2]&255](a);return}function No(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;eb(a|0)|0;if(mb(10972,3)|0)sE(20241,b);a=jb(c[2742]|0)|0;if(((a|0)!=0?(d=c[a>>2]|0,(d|0)!=0):0)?((c[d+48>>2]&-256|0)==1126902528?(c[d+48+4>>2]|0)==1129074247:0):0)wE(c[d+12>>2]|0);a=c[2705]|0;c[2705]=a+0;wE(a)}function Oo(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0,j=0,l=0,m=0,n=0.0;h=i;i=i+16|0;d=+g[a>>2];e=+g[a+20>>2];f=+g[a+40>>2];if(d+e+f>0.0){d=+O(+(d+e+f+1.0));g[h+12>>2]=d*.5;n=(+g[a+36>>2]-+g[a+24>>2])*(.5/d);g[h>>2]=n;f=(+g[a+8>>2]-+g[a+32>>2])*(.5/d);g[h+4>>2]=f;e=(+g[a+16>>2]-+g[a+4>>2])*(.5/d);g[h+8>>2]=e;j=(g[k>>2]=n,c[k>>2]|0);m=(g[k>>2]=f,c[k>>2]|0);l=(g[k>>2]=e,c[k>>2]|0);a=(g[k>>2]=d*.5,c[k>>2]|0);c[b>>2]=j;j=b+4|0;c[j>>2]=m;j=b+8|0;c[j>>2]=l;b=b+12|0;c[b>>2]=a;i=h;return}else{j=d<e?(e<f?2:1):d<f?2:0;d=+O(+(+g[a+(j<<4)+(j<<2)>>2]-+g[a+((((j+1|0)>>>0)%3|0)<<4)+((((j+1|0)>>>0)%3|0)<<2)>>2]-+g[a+((((j+2|0)>>>0)%3|0)<<4)+((((j+2|0)>>>0)%3|0)<<2)>>2]+1.0));g[h+(j<<2)>>2]=d*.5;g[h+12>>2]=(+g[a+((((j+2|0)>>>0)%3|0)<<4)+((((j+1|0)>>>0)%3|0)<<2)>>2]-+g[a+((((j+1|0)>>>0)%3|0)<<4)+((((j+2|0)>>>0)%3|0)<<2)>>2])*(.5/d);g[h+((((j+1|0)>>>0)%3|0)<<2)>>2]=(+g[a+((((j+1|0)>>>0)%3|0)<<4)+(j<<2)>>2]+ +g[a+(j<<4)+((((j+1|0)>>>0)%3|0)<<2)>>2])*(.5/d);g[h+((((j+2|0)>>>0)%3|0)<<2)>>2]=(+g[a+((((j+2|0)>>>0)%3|0)<<4)+(j<<2)>>2]+ +g[a+(j<<4)+((((j+2|0)>>>0)%3|0)<<2)>>2])*(.5/d);j=c[h>>2]|0;m=c[h+4>>2]|0;l=c[h+8>>2]|0;a=c[h+12>>2]|0;c[b>>2]=j;j=b+4|0;c[j>>2]=m;j=b+8|0;c[j>>2]=l;b=b+12|0;c[b>>2]=a;i=h;return}}function Po(){var b=0;b=i;i=i+48|0;if(a[120]|0){i=b;return}if(!(Wa(120)|0)){i=b;return}if((a[128]|0)==0?(Wa(128)|0)!=0:0){g[b+32>>2]=1.0;g[b+28>>2]=0.0;g[b+24>>2]=0.0;g[b+20>>2]=0.0;g[b+16>>2]=1.0;g[b+12>>2]=0.0;g[b+8>>2]=0.0;g[b+4>>2]=0.0;g[b>>2]=1.0;c[719]=c[b+32>>2];c[720]=c[b+28>>2];c[721]=c[b+24>>2];g[722]=0.0;c[723]=c[b+20>>2];c[724]=c[b+16>>2];c[725]=c[b+12>>2];g[726]=0.0;c[727]=c[b+8>>2];c[728]=c[b+4>>2];c[729]=c[b>>2];g[730]=0.0;_a(128)};c[703]=c[719];c[704]=c[720];c[705]=c[721];c[706]=c[722];c[707]=c[723];c[708]=c[724];c[709]=c[725];c[710]=c[726];c[711]=c[727];c[712]=c[728];c[713]=c[729];c[714]=c[730];c[715]=0;c[716]=0;c[717]=0;c[718]=0;_a(120);i=b;return}function Qo(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=2796;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+20+4>>2]=c[b+16+4>>2];c[a+20+8>>2]=c[b+16+8>>2];c[a+20+12>>2]=c[b+16+12>>2];c[a+36>>2]=c[b+32>>2];c[a+36+4>>2]=c[b+32+4>>2];c[a+36+8>>2]=c[b+32+8>>2];c[a+36+12>>2]=c[b+32+12>>2];c[a+52>>2]=c[b+48>>2];c[a+52+4>>2]=c[b+48+4>>2];c[a+52+8>>2]=c[b+48+8>>2];c[a+52+12>>2]=c[b+48+12>>2];c[a+68>>2]=c[d>>2];c[a+68+4>>2]=c[d+4>>2];c[a+68+8>>2]=c[d+8>>2];c[a+68+12>>2]=c[d+12>>2];c[a+84>>2]=c[d+16>>2];c[a+84+4>>2]=c[d+16+4>>2];c[a+84+8>>2]=c[d+16+8>>2];c[a+84+12>>2]=c[d+16+12>>2];c[a+100>>2]=c[d+32>>2];c[a+100+4>>2]=c[d+32+4>>2];c[a+100+8>>2]=c[d+32+8>>2];c[a+100+12>>2]=c[d+32+12>>2];c[a+116>>2]=c[d+48>>2];c[a+116+4>>2]=c[d+48+4>>2];c[a+116+8>>2]=c[d+48+8>>2];c[a+116+12>>2]=c[d+48+12>>2];c[a+132>>2]=c[b>>2];c[a+132+4>>2]=c[b+4>>2];c[a+132+8>>2]=c[b+8>>2];c[a+132+12>>2]=c[b+12>>2];c[a+148>>2]=c[b+16>>2];c[a+148+4>>2]=c[b+16+4>>2];c[a+148+8>>2]=c[b+16+8>>2];c[a+148+12>>2]=c[b+16+12>>2];c[a+164>>2]=c[b+32>>2];c[a+164+4>>2]=c[b+32+4>>2];c[a+164+8>>2]=c[b+32+8>>2];c[a+164+12>>2]=c[b+32+12>>2];c[a+180>>2]=c[b+48>>2];c[a+180+4>>2]=c[b+48+4>>2];c[a+180+8>>2]=c[b+48+8>>2];c[a+180+12>>2]=c[b+48+12>>2];c[a+196>>2]=0;return}function Ro(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;if(!(+g[a+344>>2]!=0.0))return;So(a,b);f=+g[b>>2]*+g[a+348>>2];i=+g[b+4>>2]*+g[a+352>>2];k=+g[b+8>>2]*+g[a+356>>2];h=+g[c+4>>2];l=+g[c+8>>2];j=+g[c>>2];e=(+g[a+280>>2]*(h*k-l*i)+ +g[a+284>>2]*(l*f-j*k)+ +g[a+288>>2]*(j*i-h*f))*+g[a+548>>2];d=(+g[a+296>>2]*(h*k-l*i)+ +g[a+300>>2]*(l*f-j*k)+ +g[a+304>>2]*(j*i-h*f))*+g[a+552>>2];g[a+328>>2]=+g[a+328>>2]+(+g[a+264>>2]*(h*k-l*i)+ +g[a+268>>2]*(l*f-j*k)+ +g[a+272>>2]*(j*i-h*f))*+g[a+544>>2];g[a+332>>2]=+g[a+332>>2]+e;g[a+336>>2]=+g[a+336>>2]+d;return}function So(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;e=+g[a+344>>2];d=+g[b+4>>2]*+g[a+352>>2]*e;c=+g[b+8>>2]*+g[a+356>>2]*e;g[a+312>>2]=+g[a+312>>2]+ +g[b>>2]*+g[a+348>>2]*e;g[a+316>>2]=+g[a+316>>2]+d;g[a+320>>2]=+g[a+320>>2]+c;return}function To(a){a=a|0;var b=0;b=i;i=i+32|0;g[b+20>>2]=0.0;g[b+16>>2]=0.0;g[b+12>>2]=1.0;g[b+8>>2]=0.0;g[b+4>>2]=0.0;g[b>>2]=1.0;c[a>>2]=1065353216;c[a+4>>2]=c[b+20>>2];c[a+8>>2]=c[b+16>>2];g[a+12>>2]=0.0;c[a+16>>2]=0;c[a+20>>2]=c[b+12>>2];c[a+24>>2]=c[b+8>>2];g[a+28>>2]=0.0;c[a+32>>2]=0;c[a+36>>2]=c[b+4>>2];c[a+40>>2]=c[b>>2];g[a+44>>2]=0.0;c[a+48>>2]=0;c[a+48+4>>2]=0;c[a+48+8>>2]=0;c[a+48+12>>2]=0;i=b;return}function Uo(a){a=a|0;return}function Vo(a){a=a|0;YE(a);return}function Wo(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=c[b>>2]|0;a=c[d>>2]|0;e=(c[e+236>>2]|0)==4?e:0;a=(c[a+236>>2]|0)==4?a:0;if(e)jc[c[(c[e>>2]|0)+28>>2]&127](e,d,b);if(!a)return 0;jc[c[(c[a>>2]|0)+28>>2]&127](a,b,d);return 0}function Xo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[b>>2]|0;a=c[d>>2]|0;f=(c[f+236>>2]|0)==4?f:0;a=(c[a+236>>2]|0)==4?a:0;if(f)nc[c[(c[f>>2]|0)+32>>2]&127](f,d,e,b);if(!a)return 0;nc[c[(c[a>>2]|0)+32>>2]&127](a,b,e,d);return 0}function Yo(a,b,c){a=a|0;b=b|0;c=c|0;return}function Zo(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;d=i;i=i+32|0;j=+g[b>>2];l=+g[b+4>>2];k=+g[b+8>>2];f=+g[b+12>>2];m=j*(2.0/(j*j+l*l+k*k+f*f));e=l*(2.0/(j*j+l*l+k*k+f*f));h=k*(2.0/(j*j+l*l+k*k+f*f));g[d+20>>2]=j*e-f*h;g[d+16>>2]=j*h+f*e;g[d+12>>2]=1.0-(j*m+k*h);g[d+8>>2]=l*h-f*m;g[d+4>>2]=l*h+f*m;g[d>>2]=1.0-(j*m+l*e);g[a>>2]=1.0-(l*e+k*h);c[a+4>>2]=c[d+20>>2];c[a+8>>2]=c[d+16>>2];g[a+12>>2]=0.0;g[a+16>>2]=j*e+f*h;c[a+20>>2]=c[d+12>>2];c[a+24>>2]=c[d+8>>2];g[a+28>>2]=0.0;g[a+32>>2]=j*h-f*e;c[a+36>>2]=c[d+4>>2];c[a+40>>2]=c[d>>2];g[a+44>>2]=0.0;i=d;return}function _o(a){a=a|0;return}function $o(a){a=a|0;return}function ap(a){a=a|0;return}function bp(a){a=a|0;YE(a);return}function cp(a,c){a=a|0;c=c|0;if(!((b[c+4>>1]&b[a+14>>1])<<16>>16)){c=0;return c|0}c=(b[a+12>>1]&b[c+6>>1])<<16>>16!=0;return c|0}function dp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;c[a+4>>2]=c[b+24>>2];e=c[b>>2]|0;c[a+8>>2]=e;if(d){c[a+52>>2]=c[b+8>>2];c[a+52+4>>2]=c[b+8+4>>2];c[a+52+8>>2]=c[b+8+8>>2];c[a+52+12>>2]=c[b+8+12>>2]}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=+g[e+20>>2]*k+ +g[e+24>>2]*j+ +g[e+28>>2]*i;f=+g[e+36>>2]*k+ +g[e+40>>2]*j+ +g[e+44>>2]*i;g[a+52>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+56>>2]=h;g[a+60>>2]=f;g[a+64>>2]=0.0}f=+g[b+24>>2];g[a+68>>2]=(1.0-f)*+g[a+20>>2]+ +g[a+36>>2]*f;g[a+72>>2]=(1.0-f)*+g[a+24>>2]+f*+g[a+40>>2];g[a+76>>2]=(1.0-f)*+g[a+28>>2]+f*+g[a+44>>2];return +(+g[b+24>>2])}function ep(a){a=a|0;return}function fp(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function gp(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,l=0,m=0,n=0.0,o=0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;d=i;i=i+176|0;q=c[a+68>>2]|0;c[d+128>>2]=q;o=c[a+84>>2]|0;c[d+128+4>>2]=o;m=c[a+100>>2]|0;c[d+128+8>>2]=m;g[d+128+12>>2]=0.0;l=d+128+16|0;t=c[a+72>>2]|0;c[l>>2]=t;s=c[a+88>>2]|0;c[d+128+20>>2]=s;r=c[a+104>>2]|0;c[d+128+24>>2]=r;g[d+128+28>>2]=0.0;j=d+128+32|0;w=c[a+76>>2]|0;c[j>>2]=w;v=c[a+92>>2]|0;c[d+128+36>>2]=v;u=c[a+108>>2]|0;c[d+128+40>>2]=u;g[d+128+44>>2]=0.0;p=-+g[a+116>>2];n=-+g[a+120>>2];h=-+g[a+124>>2];e=(c[k>>2]=w,+g[k>>2])*p;e=e+(c[k>>2]=v,+g[k>>2])*n;e=e+(c[k>>2]=u,+g[k>>2])*h;f=(c[k>>2]=t,+g[k>>2])*p;f=f+(c[k>>2]=s,+g[k>>2])*n;f=f+(c[k>>2]=r,+g[k>>2])*h;p=(c[k>>2]=q,+g[k>>2])*p;n=p+(c[k>>2]=o,+g[k>>2])*n;h=n+(c[k>>2]=m,+g[k>>2])*h;c[d>>2]=c[d+128>>2];c[d+4>>2]=c[d+128+4>>2];c[d+8>>2]=c[d+128+8>>2];c[d+12>>2]=c[d+128+12>>2];c[d+16>>2]=c[l>>2];c[d+16+4>>2]=c[l+4>>2];c[d+16+8>>2]=c[l+8>>2];c[d+16+12>>2]=c[l+12>>2];c[d+32>>2]=c[j>>2];c[d+32+4>>2]=c[j+4>>2];c[d+32+8>>2]=c[j+8>>2];c[d+32+12>>2]=c[j+12>>2];g[d+48>>2]=h;g[d+52>>2]=f;g[d+56>>2]=e;g[d+60>>2]=0.0;ip(d+64|0,d,a+4|0);c[b>>2]=c[d+64>>2];c[b+4>>2]=c[d+64+4>>2];c[b+8>>2]=c[d+64+8>>2];c[b+12>>2]=c[d+64+12>>2];c[b+16>>2]=c[d+64+16>>2];c[b+16+4>>2]=c[d+64+16+4>>2];c[b+16+8>>2]=c[d+64+16+8>>2];c[b+16+12>>2]=c[d+64+16+12>>2];c[b+32>>2]=c[d+64+32>>2];c[b+32+4>>2]=c[d+64+32+4>>2];c[b+32+8>>2]=c[d+64+32+8>>2];c[b+32+12>>2]=c[d+64+32+12>>2];c[b+48>>2]=c[d+64+48>>2];c[b+48+4>>2]=c[d+64+48+4>>2];c[b+48+8>>2]=c[d+64+48+8>>2];c[b+48+12>>2]=c[d+64+48+12>>2];i=d;return}function hp(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+64|0;ip(d,b,a+68|0);c[a+4>>2]=c[d>>2];c[a+4+4>>2]=c[d+4>>2];c[a+4+8>>2]=c[d+8>>2];c[a+4+12>>2]=c[d+12>>2];c[a+20>>2]=c[d+16>>2];c[a+20+4>>2]=c[d+16+4>>2];c[a+20+8>>2]=c[d+16+8>>2];c[a+20+12>>2]=c[d+16+12>>2];c[a+36>>2]=c[d+32>>2];c[a+36+4>>2]=c[d+32+4>>2];c[a+36+8>>2]=c[d+32+8>>2];c[a+36+12>>2]=c[d+32+12>>2];c[a+52>>2]=c[d+48>>2];c[a+52+4>>2]=c[d+48+4>>2];c[a+52+8>>2]=c[d+48+8>>2];c[a+52+12>>2]=c[d+48+12>>2];i=d;return}function ip(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;e=i;i=i+96|0;w=+g[d>>2];n=+g[b>>2];v=+g[d+16>>2];o=+g[b+4>>2];u=+g[d+32>>2];j=+g[b+8>>2];g[e+80>>2]=w*n+v*o+u*j;t=+g[d+4>>2];s=+g[d+20>>2];r=+g[d+36>>2];g[e+76>>2]=t*n+s*o+r*j;k=+g[d+8>>2];l=+g[d+24>>2];m=+g[d+40>>2];g[e+72>>2]=k*n+l*o+m*j;o=+g[b+16>>2];n=+g[b+20>>2];h=+g[b+24>>2];g[e+68>>2]=w*o+v*n+u*h;g[e+64>>2]=t*o+s*n+r*h;g[e+60>>2]=k*o+l*n+m*h;q=+g[b+32>>2];p=+g[b+36>>2];f=+g[b+40>>2];g[e+56>>2]=w*q+v*p+u*f;g[e+52>>2]=t*q+s*p+r*f;g[e+48>>2]=k*q+l*p+m*f;c[e>>2]=c[e+80>>2];c[e+4>>2]=c[e+76>>2];c[e+8>>2]=c[e+72>>2];g[e+12>>2]=0.0;c[e+16>>2]=c[e+68>>2];c[e+20>>2]=c[e+64>>2];c[e+24>>2]=c[e+60>>2];g[e+28>>2]=0.0;c[e+32>>2]=c[e+56>>2];c[e+36>>2]=c[e+52>>2];c[e+40>>2]=c[e+48>>2];g[e+44>>2]=0.0;m=+g[d+48>>2];l=+g[d+52>>2];k=+g[d+56>>2];f=m*q+l*p+k*f+ +g[b+56>>2];h=m*o+l*n+k*h+ +g[b+52>>2];j=m*+g[b>>2]+l*+g[b+4>>2]+k*j+ +g[b+48>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[a+16>>2]=c[e+16>>2];c[a+16+4>>2]=c[e+16+4>>2];c[a+16+8>>2]=c[e+16+8>>2];c[a+16+12>>2]=c[e+16+12>>2];c[a+32>>2]=c[e+32>>2];c[a+32+4>>2]=c[e+32+4>>2];c[a+32+8>>2]=c[e+32+8>>2];c[a+32+12>>2]=c[e+32+12>>2];g[a+48>>2]=j;g[a+52>>2]=h;g[a+56>>2]=f;g[a+60>>2]=0.0;i=e;return}function jp(a){a=a|0;return}function kp(a){a=a|0;return}function lp(a){a=a|0;YE(a);return}function mp(a,c){a=a|0;c=c|0;if(!((b[c+4>>1]&b[a+10>>1])<<16>>16)){c=0;return c|0}c=(b[a+8>>1]&b[c+6>>1])<<16>>16!=0;return c|0}function np(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;c[a+4>>2]=c[b+40>>2];e=c[b>>2]|0;c[a+76>>2]=e;if(d){c[a+44>>2]=c[b+8>>2];c[a+44+4>>2]=c[b+8+4>>2];c[a+44+8>>2]=c[b+8+8>>2];c[a+44+12>>2]=c[b+8+12>>2];e=a+60|0;d=b+24|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];f=+g[b+40>>2];return +f}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=+g[e+20>>2]*k+ +g[e+24>>2]*j+ +g[e+28>>2]*i;f=+g[e+36>>2]*k+ +g[e+40>>2]*j+ +g[e+44>>2]*i;g[a+44>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+48>>2]=h;g[a+52>>2]=f;g[a+56>>2]=0.0;e=a+60|0;d=b+24|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];f=+g[b+40>>2];return +f}return 0.0}function op(a){a=a|0;return}function pp(a){a=a|0;YE(a);return}function qp(a,c){a=a|0;c=c|0;if(!((b[c+4>>1]&b[a+6>>1])<<16>>16)){c=0;return c|0}c=(b[a+4>>1]&b[c+6>>1])<<16>>16!=0;return c|0}function rp(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return +(+wb(0,a|0,b|0,c|0,d|0,e|0,f|0,g|0,h|0))}function sp(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0,j=0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;n=i;i=i+32|0;c[b+236>>2]=2;c[b+312>>2]=0;c[b+312+4>>2]=0;c[b+312+8>>2]=0;c[b+312+12>>2]=0;c[b+312+16>>2]=0;c[b+312+20>>2]=0;c[b+312+24>>2]=0;c[b+312+28>>2]=0;c[b+544>>2]=1065353216;c[b+548>>2]=1065353216;c[b+552>>2]=1065353216;g[b+556>>2]=0.0;c[b+348>>2]=1065353216;c[b+352>>2]=1065353216;c[b+356>>2]=1065353216;e=b+360|0;h=e+36|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));c[b+412>>2]=0;c[b+412+4>>2]=0;c[b+412+8>>2]=0;c[b+412+12>>2]=0;c[b+412+16>>2]=0;c[b+412+20>>2]=0;c[b+412+24>>2]=0;c[b+412+28>>2]=0;m=+g[d+92>>2];f=+g[d+96>>2];g[n+20>>2]=m;g[n+16>>2]=f;g[n+12>>2]=0.0;g[n+8>>2]=1.0;c[b+444>>2]=c[(m<0.0?n+12|0:m>1.0?n+8|0:n+20|0)>>2];g[n+4>>2]=0.0;g[n>>2]=1.0;c[b+448>>2]=c[(f<0.0?n+4|0:f>1.0?n:n+16|0)>>2];c[b+472>>2]=c[d+112>>2];c[b+476>>2]=c[d+116>>2];e=c[d+4>>2]|0;c[b+480>>2]=e;c[b+608>>2]=0;c[b+612>>2]=0;a[b+452>>0]=a[d+120>>0]|0;c[b+456>>2]=c[d+124>>2];c[b+460>>2]=c[d+128>>2];c[b+464>>2]=c[d+132>>2];c[b+468>>2]=c[d+136>>2];if(!e){c[b+4>>2]=c[d+8>>2];c[b+4+4>>2]=c[d+8+4>>2];c[b+4+8>>2]=c[d+8+8>>2];c[b+4+12>>2]=c[d+8+12>>2];c[b+20>>2]=c[d+24>>2];c[b+20+4>>2]=c[d+24+4>>2];c[b+20+8>>2]=c[d+24+8>>2];c[b+20+12>>2]=c[d+24+12>>2];c[b+36>>2]=c[d+40>>2];c[b+36+4>>2]=c[d+40+4>>2];c[b+36+8>>2]=c[d+40+8>>2];c[b+36+12>>2]=c[d+40+12>>2];c[b+52>>2]=c[d+56>>2];c[b+52+4>>2]=c[d+56+4>>2];c[b+52+8>>2]=c[d+56+8>>2];c[b+52+12>>2]=c[d+56+12>>2];h=b+20|0;e=b+36|0;j=b+52|0;l=b+4|0}else{Fb[c[(c[e>>2]|0)+8>>2]&127](e,b+4|0);h=b+20|0;e=b+36|0;j=b+52|0;l=b+4|0}c[b+68>>2]=c[l>>2];c[b+68+4>>2]=c[l+4>>2];c[b+68+8>>2]=c[l+8>>2];c[b+68+12>>2]=c[l+12>>2];c[b+84>>2]=c[h>>2];c[b+84+4>>2]=c[h+4>>2];c[b+84+8>>2]=c[h+8>>2];c[b+84+12>>2]=c[h+12>>2];c[b+100>>2]=c[e>>2];c[b+100+4>>2]=c[e+4>>2];c[b+100+8>>2]=c[e+8>>2];c[b+100+12>>2]=c[e+12>>2];c[b+116>>2]=c[j>>2];c[b+116+4>>2]=c[j+4>>2];c[b+116+8>>2]=c[j+8>>2];c[b+116+12>>2]=c[j+12>>2];c[b+132>>2]=0;c[b+132+4>>2]=0;c[b+132+8>>2]=0;c[b+132+12>>2]=0;c[b+132+16>>2]=0;c[b+132+20>>2]=0;c[b+132+24>>2]=0;c[b+132+28>>2]=0;c[b+224>>2]=c[d+100>>2];c[b+232>>2]=c[d+104>>2];c[b+228>>2]=c[d+108>>2];Fb[c[(c[b>>2]|0)+12>>2]&127](b,c[d+72>>2]|0);e=c[752]|0;c[752]=e+1;c[b+508>>2]=e;f=+g[d>>2];e=c[b+204>>2]|0;if(f==0.0){c[b+204>>2]=e|1;m=0.0}else{c[b+204>>2]=e&-2;m=1.0/f}g[b+344>>2]=m;p=f*+g[b+384>>2];o=f*+g[b+388>>2];g[b+364>>2]=f*+g[b+380>>2];g[b+368>>2]=p;g[b+372>>2]=o;g[b+376>>2]=0.0;f=+g[d+76>>2];j=f!=0.0?(g[k>>2]=1.0/f,c[k>>2]|0):0;f=+g[d+80>>2];l=f!=0.0?(g[k>>2]=1.0/f,c[k>>2]|0):0;f=+g[d+84>>2];e=f!=0.0?(g[k>>2]=1.0/f,c[k>>2]|0):0;c[b+396>>2]=j;c[b+400>>2]=l;c[b+404>>2]=e;g[b+408>>2]=0.0;r=m*+g[b+352>>2];x=m*+g[b+356>>2];g[b+560>>2]=m*+g[b+348>>2];g[b+564>>2]=r;g[b+568>>2]=x;g[b+572>>2]=0.0;x=+g[b+4>>2];r=(c[k>>2]=j,+g[k>>2]);w=+g[b+8>>2];p=(c[k>>2]=l,+g[k>>2]);v=+g[b+12>>2];m=(c[k>>2]=e,+g[k>>2]);u=+g[b+20>>2];t=+g[b+24>>2];s=+g[b+28>>2];q=+g[b+36>>2];f=+g[b+40>>2];o=+g[b+44>>2];g[b+264>>2]=x*(x*r)+w*(w*p)+v*(v*m);g[b+268>>2]=x*r*u+w*p*t+v*m*s;g[b+272>>2]=x*r*q+w*p*f+v*m*o;g[b+276>>2]=0.0;g[b+280>>2]=x*(r*u)+w*(p*t)+v*(m*s);g[b+284>>2]=u*(r*u)+t*(p*t)+s*(m*s);g[b+288>>2]=r*u*q+p*t*f+m*s*o;g[b+292>>2]=0.0;g[b+296>>2]=x*(r*q)+w*(p*f)+v*(m*o);g[b+300>>2]=u*(r*q)+t*(p*f)+s*(m*o);g[b+304>>2]=q*(r*q)+f*(p*f)+o*(m*o);g[b+308>>2]=0.0;c[b+504>>2]=0;c[b+512>>2]=0;c[b+512+4>>2]=0;c[b+512+8>>2]=0;c[b+512+12>>2]=0;c[b+512+16>>2]=0;c[b+512+20>>2]=0;c[b+512+24>>2]=0;c[b+512+28>>2]=0;o=+g[b+344>>2];m=o*+g[b+352>>2];f=o*+g[b+356>>2];g[b+560>>2]=+g[b+348>>2]*o;g[b+564>>2]=m;g[b+568>>2]=f;e=b+572|0;h=e+36|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));i=n;return}function tp(b,d,e,f,h){b=b|0;d=+d;e=e|0;f=f|0;h=h|0;var j=0;j=i;i=i+144|0;c[b+164>>2]=1065353216;c[b+168>>2]=1065353216;c[b+172>>2]=1065353216;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;c[b+188>>2]=0;c[b+188+4>>2]=0;c[b+188+8>>2]=0;c[b+188+12>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+236>>2]=1;c[b+240>>2]=0;g[b+244>>2]=1.0;c[b+248>>2]=0;c[b+248+4>>2]=0;c[b+248+8>>2]=0;c[b+248+12>>2]=0;c[b+4>>2]=1065353216;c[b+8>>2]=0;c[b+8+4>>2]=0;c[b+8+8>>2]=0;c[b+8+12>>2]=0;c[b+24>>2]=1065353216;c[b+28>>2]=0;c[b+28+4>>2]=0;c[b+28+8>>2]=0;c[b+28+12>>2]=0;c[b+44>>2]=1065353216;c[b+48>>2]=0;c[b+48+4>>2]=0;c[b+48+8>>2]=0;c[b+48+12>>2]=0;c[b+48+16>>2]=0;c[b>>2]=2980;a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;g[j>>2]=d;c[j+4>>2]=e;c[j+72>>2]=f;c[j+76>>2]=c[h>>2];c[j+76+4>>2]=c[h+4>>2];c[j+76+8>>2]=c[h+8>>2];c[j+76+12>>2]=c[h+12>>2];g[j+92>>2]=0.0;g[j+96>>2]=0.0;g[j+100>>2]=.5;g[j+104>>2]=0.0;g[j+108>>2]=0.0;g[j+112>>2]=.800000011920929;g[j+116>>2]=1.0;a[j+120>>0]=0;g[j+124>>2]=.004999999888241291;g[j+128>>2]=.009999999776482582;g[j+132>>2]=.009999999776482582;g[j+136>>2]=.009999999776482582;c[j+8>>2]=1065353216;c[j+12>>2]=0;c[j+12+4>>2]=0;c[j+12+8>>2]=0;c[j+12+12>>2]=0;c[j+28>>2]=1065353216;c[j+32>>2]=0;c[j+32+4>>2]=0;c[j+32+8>>2]=0;c[j+32+12>>2]=0;c[j+48>>2]=1065353216;c[j+52>>2]=0;c[j+52+4>>2]=0;c[j+52+8>>2]=0;c[j+52+12>>2]=0;c[j+52+16>>2]=0;sp(b,j);i=j;return}function up(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;if(!(c[a+204>>2]&2)){c[a+68>>2]=c[b>>2];c[a+68+4>>2]=c[b+4>>2];c[a+68+8>>2]=c[b+8>>2];c[a+68+12>>2]=c[b+12>>2];c[a+84>>2]=c[b+16>>2];c[a+84+4>>2]=c[b+16+4>>2];c[a+84+8>>2]=c[b+16+8>>2];c[a+84+12>>2]=c[b+16+12>>2];c[a+100>>2]=c[b+32>>2];c[a+100+4>>2]=c[b+32+4>>2];c[a+100+8>>2]=c[b+32+8>>2];c[a+100+12>>2]=c[b+32+12>>2];c[a+116>>2]=c[b+48>>2];c[a+116+4>>2]=c[b+48+4>>2];c[a+116+8>>2]=c[b+48+8>>2];c[a+116+12>>2]=c[b+48+12>>2];e=b;f=a+20|0;h=b+16|0;i=a+36|0;j=b+32|0;k=a+52|0;b=b+48|0;d=a+4|0}else{c[a+68>>2]=c[a+4>>2];c[a+68+4>>2]=c[a+4+4>>2];c[a+68+8>>2]=c[a+4+8>>2];c[a+68+12>>2]=c[a+4+12>>2];c[a+84>>2]=c[a+20>>2];c[a+84+4>>2]=c[a+20+4>>2];c[a+84+8>>2]=c[a+20+8>>2];c[a+84+12>>2]=c[a+20+12>>2];c[a+100>>2]=c[a+36>>2];c[a+100+4>>2]=c[a+36+4>>2];c[a+100+8>>2]=c[a+36+8>>2];c[a+100+12>>2]=c[a+36+12>>2];c[a+116>>2]=c[a+52>>2];c[a+116+4>>2]=c[a+52+4>>2];c[a+116+8>>2]=c[a+52+8>>2];c[a+116+12>>2]=c[a+52+12>>2];e=b;f=a+20|0;h=b+16|0;i=a+36|0;j=b+32|0;k=a+52|0;b=b+48|0;d=a+4|0}c[a+132>>2]=c[a+312>>2];c[a+132+4>>2]=c[a+312+4>>2];c[a+132+8>>2]=c[a+312+8>>2];c[a+132+12>>2]=c[a+312+12>>2];c[a+148>>2]=c[a+328>>2];c[a+148+4>>2]=c[a+328+4>>2];c[a+148+8>>2]=c[a+328+8>>2];c[a+148+12>>2]=c[a+328+12>>2];c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];c[i>>2]=c[j>>2];c[i+4>>2]=c[j+4>>2];c[i+8>>2]=c[j+8>>2];c[i+12>>2]=c[j+12>>2];c[k>>2]=c[b>>2];c[k+4>>2]=c[b+4>>2];c[k+8>>2]=c[b+8>>2];c[k+12>>2]=c[b+12>>2];w=+g[a+4>>2];q=+g[a+396>>2];v=+g[a+8>>2];o=+g[a+400>>2];u=+g[a+12>>2];m=+g[a+404>>2];t=+g[a+20>>2];s=+g[a+24>>2];r=+g[a+28>>2];p=+g[a+36>>2];n=+g[a+40>>2];l=+g[a+44>>2];g[a+264>>2]=w*(w*q)+v*(v*o)+u*(u*m);g[a+268>>2]=w*q*t+v*o*s+u*m*r;g[a+272>>2]=w*q*p+v*o*n+u*m*l;g[a+276>>2]=0.0;g[a+280>>2]=w*(q*t)+v*(o*s)+u*(m*r);g[a+284>>2]=t*(q*t)+s*(o*s)+r*(m*r);g[a+288>>2]=q*t*p+o*s*n+m*r*l;g[a+292>>2]=0.0;g[a+296>>2]=w*(q*p)+v*(o*n)+u*(m*l);g[a+300>>2]=t*(q*p)+s*(o*n)+r*(m*l);g[a+304>>2]=p*(q*p)+n*(o*n)+l*(m*l);g[a+308>>2]=0.0;return}function vp(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;if((d|0)==0?1:(c[d+236>>2]&2|0)==0){e=1;return e|0}g=c[b+488>>2]|0;if((g|0)<=0){e=1;return e|0}b=c[b+496>>2]|0;f=0;while(1){e=c[b+(f<<2)>>2]|0;if(a[e+20>>0]|0){if((c[e+28>>2]|0)==(d|0)){e=0;b=8;break}if((c[e+32>>2]|0)==(d|0)){e=0;b=8;break}}f=f+1|0;if((f|0)>=(g|0)){e=1;b=8;break}}if((b|0)==8)return e|0;return 0}function wp(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+488>>2]|0;a:do if((e|0)>0){f=c[b+496>>2]|0;g=0;while(1){if((c[f+(g<<2)>>2]|0)==(d|0))break;g=g+1|0;if((g|0)>=(e|0))break a}if((g|0)!=(e|0)){e=b+256|0;c[e>>2]=1;return}}while(0);if((e|0)==(c[b+492>>2]|0)?(h=(e|0)!=0?e<<1:1,(e|0)<(h|0)):0){if(!h)f=0;else{c[2703]=(c[2703]|0)+1;e=XE((h<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+4+15&-16)+-4>>2]=e;f=e+4+15&-16}e=c[b+488>>2]|0}if((e|0)>0){g=0;do{c[f+(g<<2)>>2]=c[(c[b+496>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=c[b+496>>2]|0;if(g){if(a[b+500>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0);e=c[b+488>>2]|0}c[b+496>>2]=0}a[b+500>>0]=1;c[b+496>>2]=f;c[b+492>>2]=h}c[(c[b+496>>2]|0)+(e<<2)>>2]=d;c[b+488>>2]=e+1;e=b+256|0;c[e>>2]=1;return}function xp(a){a=a|0;return 488}
function KA(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0;c[b+4>>2]=1065353216;c[b+8>>2]=1065353216;c[b+12>>2]=1065353216;g[b+16>>2]=0.0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[b+48>>2]=0;c[b>>2]=8700;a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;a[b+164>>0]=d&1;a[b+165>>0]=e&1;g[b+168>>2]=0.0;c[2703]=(c[2703]|0)+1;d=XE(51)|0;if(!d)f=0;else{c[(d+4+15&-16)+-4>>2]=d;f=d+4+15&-16}e=c[b+24>>2]|0;if((e|0)>0){d=0;do{h=f+(d<<5)|0;i=(c[b+32>>2]|0)+(d<<5)|0;c[h>>2]=c[i>>2];c[h+4>>2]=c[i+4>>2];c[h+8>>2]=c[i+8>>2];c[h+12>>2]=c[i+12>>2];c[h+16>>2]=c[i+16>>2];c[h+20>>2]=c[i+20>>2];c[h+24>>2]=c[i+24>>2];c[h+28>>2]=c[i+28>>2];d=d+1|0}while((d|0)!=(e|0))}d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=f;c[b+28>>2]=1;d=c[b+24>>2]|0;c[f+(d<<5)>>2]=0;c[f+(d<<5)+4>>2]=0;c[f+(d<<5)+8>>2]=12;c[f+(d<<5)+12>>2]=0;c[f+(d<<5)+16>>2]=0;c[f+(d<<5)+20>>2]=16;c[f+(d<<5)+24>>2]=2;c[f+(d<<5)+28>>2]=0;c[b+24>>2]=(c[b+24>>2]|0)+1;if(!(a[b+164>>0]|0)){d=c[b+32>>2]|0;c[d>>2]=(c[b+148>>2]|0)/3|0;c[d+4>>2]=0;c[d+24>>2]=3;c[d+8>>2]=6}else{d=c[b+32>>2]|0;c[d>>2]=(c[b+128>>2]|0)/3|0;c[d+4>>2]=0;c[d+24>>2]=2;c[d+8>>2]=12}if(!(a[b+165>>0]|0)){e=12;b=(c[b+108>>2]|0)/3|0;f=d+12|0;c[f>>2]=b;f=d+16|0;c[f>>2]=0;d=d+20|0;c[d>>2]=e;return}else{e=16;b=c[b+88>>2]|0;f=d+12|0;c[f>>2]=b;f=d+16|0;c[f>>2]=0;d=d+20|0;c[d>>2]=e;return}}function LA(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;if(!(a[d+164>>0]|0)){f=c[d+148>>2]|0;if((f|0)==(c[d+152>>2]|0)?(k=(f|0)!=0?f<<1:1,(f|0)<(k|0)):0){if(!k)g=0;else{c[2703]=(c[2703]|0)+1;f=XE((k<<1)+19|0)|0;if(!f)g=0;else{c[(f+4+15&-16)+-4>>2]=f;g=f+4+15&-16}f=c[d+148>>2]|0}i=c[d+156>>2]|0;if((f|0)<=0)if(!i)f=d+160|0;else h=27;else{h=0;do{b[g+(h<<1)>>1]=b[i+(h<<1)>>1]|0;h=h+1|0}while((h|0)!=(f|0));h=27}if((h|0)==27){if(a[d+160>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[i+-4>>2]|0)}c[d+156>>2]=0;f=d+160|0}a[f>>0]=1;c[d+156>>2]=g;c[d+152>>2]=k;f=c[d+148>>2]|0}g=c[d+156>>2]|0;b[g+(f<<1)>>1]=e;c[d+148>>2]=f+1;c[(c[d+32>>2]|0)+4>>2]=g;return}else{f=c[d+128>>2]|0;if((f|0)==(c[d+132>>2]|0)?(j=(f|0)!=0?f<<1:1,(f|0)<(j|0)):0){if(!j)g=0;else{c[2703]=(c[2703]|0)+1;f=XE((j<<2|3)+16|0)|0;if(!f)g=0;else{c[(f+4+15&-16)+-4>>2]=f;g=f+4+15&-16}f=c[d+128>>2]|0}i=c[d+136>>2]|0;if((f|0)<=0)if(!i)f=d+140|0;else h=12;else{h=0;do{c[g+(h<<2)>>2]=c[i+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0));h=12}if((h|0)==12){if(a[d+140>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[i+-4>>2]|0)}c[d+136>>2]=0;f=d+140|0}a[f>>0]=1;c[d+136>>2]=g;c[d+132>>2]=j;f=c[d+128>>2]|0}g=c[d+136>>2]|0;c[g+(f<<2)>>2]=e;c[d+128>>2]=(c[d+128>>2]|0)+1;c[(c[d+32>>2]|0)+4>>2]=g;return}}function MA(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0;if(a[b+165>>0]|0){h=c[b+88>>2]|0;a:do if((h|0)>0&e){j=c[b+96>>2]|0;k=+g[d>>2];l=+g[d+4>>2];m=+g[d+8>>2];n=+g[b+168>>2];f=0;while(1){t=+g[j+(f<<4)>>2]-k;s=+g[j+(f<<4)+4>>2]-l;r=+g[j+(f<<4)+8>>2]-m;if(t*t+s*s+r*r<=n)break;f=f+1|0;if((f|0)>=(h|0))break a}return f|0}while(0);f=(c[b+32>>2]|0)+12|0;c[f>>2]=(c[f>>2]|0)+1;if((h|0)==(c[b+92>>2]|0)?(p=(h|0)!=0?h<<1:1,(h|0)<(p|0)):0){if(!p)e=0;else{c[2703]=(c[2703]|0)+1;f=XE((p<<4|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}h=c[b+88>>2]|0;e=f}if((h|0)>0){f=0;do{q=e+(f<<4)|0;i=(c[b+96>>2]|0)+(f<<4)|0;c[q>>2]=c[i>>2];c[q+4>>2]=c[i+4>>2];c[q+8>>2]=c[i+8>>2];c[q+12>>2]=c[i+12>>2];f=f+1|0}while((f|0)!=(h|0))}f=c[b+96>>2]|0;if(f){if(a[b+100>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=e;c[b+92>>2]=p;f=c[b+88>>2]|0}else f=h;f=(c[b+96>>2]|0)+(f<<4)|0;c[f>>2]=c[d>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];f=c[b+88>>2]|0;c[b+88>>2]=f+1;c[(c[b+32>>2]|0)+16>>2]=c[b+96>>2];return f|0}i=c[b+108>>2]|0;b:do if((i|0)>0&e){e=c[b+116>>2]|0;n=+g[d>>2];m=+g[d+4>>2];l=+g[d+8>>2];k=+g[b+168>>2];j=0;while(1){s=+g[e+(j<<2)>>2]-n;r=+g[e+(j+1<<2)>>2]-m;t=+g[e+(j+2<<2)>>2]-l;if(s*s+r*r+t*t<=k)break;j=j+3|0;if((j|0)>=(i|0))break b}f=(j|0)/3|0;return f|0}while(0);f=c[b+112>>2]|0;if((i|0)==(f|0)){o=(i|0)!=0?i<<1:1;if((i|0)<(o|0)){if(!o)j=0;else{c[2703]=(c[2703]|0)+1;f=XE((o<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}i=c[b+108>>2]|0;j=f}h=c[b+116>>2]|0;if((i|0)<=0)if(!h)f=b+120|0;else q=35;else{e=0;do{c[j+(e<<2)>>2]=c[h+(e<<2)>>2];e=e+1|0}while((e|0)!=(i|0));q=35}if((q|0)==35){if(a[b+120>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[b+116>>2]=0;f=b+120|0}a[f>>0]=1;c[b+116>>2]=j;c[b+112>>2]=o;e=c[b+108>>2]|0;f=o}else{e=i;f=i}}else e=i;i=c[b+116>>2]|0;c[i+(e<<2)>>2]=c[d>>2];e=e+1|0;c[b+108>>2]=e;if((e|0)==(f|0)){h=(f|0)!=0?f<<1:1;if((f|0)<(h|0)){if(!h)j=0;else{c[2703]=(c[2703]|0)+1;f=XE((h<<2|3)+16|0)|0;if(!f)e=0;else{c[(f+4+15&-16)+-4>>2]=f;e=f+4+15&-16}f=c[b+108>>2]|0;i=c[b+116>>2]|0;j=e}if((f|0)<=0)if(!i)f=b+120|0;else q=49;else{e=0;do{c[j+(e<<2)>>2]=c[i+(e<<2)>>2];e=e+1|0}while((e|0)!=(f|0));q=49}if((q|0)==49){if(a[b+120>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[i+-4>>2]|0)}c[b+116>>2]=0;f=b+120|0}a[f>>0]=1;c[b+116>>2]=j;c[b+112>>2]=h;p=j;e=c[b+108>>2]|0;f=j}else{p=i;e=f;h=f;f=i}}else{p=i;h=f;f=i}c[p+(e<<2)>>2]=c[d+4>>2];e=e+1|0;c[b+108>>2]=e;if((e|0)==(h|0)){o=(h|0)!=0?h<<1:1;if((h|0)<(o|0)){if(!o){i=p;e=0}else{c[2703]=(c[2703]|0)+1;f=XE((o<<2|3)+16|0)|0;if(!f)e=0;else{c[(f+4+15&-16)+-4>>2]=f;e=f+4+15&-16}h=c[b+108>>2]|0;i=c[b+116>>2]|0}if((h|0)<=0)if(!i)f=b+120|0;else q=63;else{f=0;do{c[e+(f<<2)>>2]=c[i+(f<<2)>>2];f=f+1|0}while((f|0)!=(h|0));q=63}if((q|0)==63){if(a[b+120>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[i+-4>>2]|0)}c[b+116>>2]=0;f=b+120|0}a[f>>0]=1;c[b+116>>2]=e;c[b+112>>2]=o;i=e;h=c[b+108>>2]|0;f=e}else i=p}else{i=p;h=e}c[i+(h<<2)>>2]=c[d+8>>2];q=h+1|0;c[b+108>>2]=q;h=c[b+32>>2]|0;c[h+12>>2]=(c[h+12>>2]|0)+1;c[h+16>>2]=f;f=((q|0)/3|0)+-1|0;return f|0}function NA(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if(a[b+165>>0]|0){if((c[b+92>>2]|0)>=(d|0))return;if((d|0)!=0?(c[2703]=(c[2703]|0)+1,f=XE((d<<4|3)+16|0)|0,(f|0)!=0):0){c[(f+4+15&-16)+-4>>2]=f;g=f+4+15&-16}else g=0;e=c[b+88>>2]|0;if((e|0)>0){f=0;do{h=g+(f<<4)|0;i=(c[b+96>>2]|0)+(f<<4)|0;c[h>>2]=c[i>>2];c[h+4>>2]=c[i+4>>2];c[h+8>>2]=c[i+8>>2];c[h+12>>2]=c[i+12>>2];f=f+1|0}while((f|0)!=(e|0))}e=c[b+96>>2]|0;if(e){if(a[b+100>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=g;c[b+92>>2]=d;return}if((c[b+112>>2]|0)>=(d|0))return;if((d|0)!=0?(c[2703]=(c[2703]|0)+1,e=XE((d<<2|3)+16|0)|0,(e|0)!=0):0){c[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}else h=0;g=c[b+108>>2]|0;e=c[b+116>>2]|0;if((g|0)<=0)if(!e)f=b+120|0;else i=21;else{f=0;do{c[h+(f<<2)>>2]=c[e+(f<<2)>>2];f=f+1|0}while((f|0)!=(g|0));i=21}if((i|0)==21){if(a[b+120>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[b+116>>2]=0;f=b+120|0}a[f>>0]=1;c[b+116>>2]=h;c[b+112>>2]=d;return}function OA(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if(!(a[d+164>>0]|0)){if((c[d+152>>2]|0)>=(e|0))return;if((e|0)!=0?(c[2703]=(c[2703]|0)+1,f=XE((e<<1)+19|0)|0,(f|0)!=0):0){c[(f+4+15&-16)+-4>>2]=f;i=f+4+15&-16}else i=0;f=c[d+148>>2]|0;h=c[d+156>>2]|0;if((f|0)<=0)if(!h)g=d+160|0;else j=22;else{g=0;do{b[i+(g<<1)>>1]=b[h+(g<<1)>>1]|0;g=g+1|0}while((g|0)!=(f|0));j=22}if((j|0)==22){if(a[d+160>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[d+156>>2]=0;g=d+160|0}a[g>>0]=1;c[d+156>>2]=i;c[d+152>>2]=e;return}else{if((c[d+132>>2]|0)>=(e|0))return;if((e|0)!=0?(c[2703]=(c[2703]|0)+1,g=XE((e<<2|3)+16|0)|0,(g|0)!=0):0){c[(g+4+15&-16)+-4>>2]=g;i=g+4+15&-16}else i=0;h=c[d+128>>2]|0;f=c[d+136>>2]|0;if((h|0)<=0)if(!f)g=d+140|0;else j=10;else{g=0;do{c[i+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(h|0));j=10}if((j|0)==10){if(a[d+140>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[d+136>>2]=0;g=d+140|0}a[g>>0]=1;c[d+136>>2]=i;c[d+132>>2]=e;return}}function PA(b){b=b|0;var d=0;c[b>>2]=8700;d=c[b+156>>2]|0;if(d){if(a[b+160>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;d=c[b+136>>2]|0;if(d){if(a[b+140>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d){if(a[b+120>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;c[b>>2]=10704;d=c[b+32>>2]|0;if(!d){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;d=b+28|0;c[d>>2]=0;return}if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+32>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;d=b+28|0;c[d>>2]=0;return}function QA(a){a=a|0;PA(a);if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function RA(a,b){a=a|0;b=b|0;return}function SA(a,b){a=a|0;b=b|0;return}function TA(a){a=a|0;return c[a+24>>2]|0}function UA(a){a=a|0;return 28}function VA(d,f,h,i,j,k){d=d|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0.0,m=0.0,n=0.0;c[d>>2]=8832;b[d+4>>1]=-2;b[d+6>>1]=-1;c[d+92>>2]=j;c[d+96>>2]=0;a[d+100>>0]=0;c[d+104>>2]=0;c[d+108>>2]=0;if(!j){c[2703]=(c[2703]|0)+1;j=XE(95)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}FB(j);c[d+92>>2]=j;a[d+100>>0]=1}if(!k){c[2703]=(c[2703]|0)+1;k=XE(43)|0;if(!k)j=0;else{c[(k+4+15&-16)+-4>>2]=k;j=k+4+15&-16};c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;c[j>>2]=8896;a[j+20>>0]=1;c[j+16>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[d+112>>2]=j;c[2703]=(c[2703]|0)+1;k=XE(215)|0;if(!k)j=0;else{c[(k+4+15&-16)+-4>>2]=k;j=k+4+15&-16}aC(j,c[d+112>>2]|0);c[d+108>>2]=j;a[j+193>>0]=1};c[d+8>>2]=c[f>>2];c[d+8+4>>2]=c[f+4>>2];c[d+8+8>>2]=c[f+8>>2];c[d+8+12>>2]=c[f+12>>2];c[d+24>>2]=c[h>>2];c[d+24+4>>2]=c[h+4>>2];c[d+24+8>>2]=c[h+8>>2];c[d+24+12>>2]=c[h+12>>2];n=+(e[d+6>>1]|0);m=n/(+g[d+28>>2]-+g[d+12>>2]);l=n/(+g[d+32>>2]-+g[d+16>>2]);g[d+40>>2]=n/(+g[d+24>>2]-+g[d+8>>2]);g[d+44>>2]=m;g[d+48>>2]=l;g[d+52>>2]=0.0;f=(i&65535)+1&65535;c[2703]=(c[2703]|0)+1;k=XE(f<<6|19)|0;if(!k)h=0;else{c[(k+4+15&-16)+-4>>2]=k;h=k+4+15&-16}if(f){k=h+(f<<6)|0;j=h;do{c[j>>2]=0;c[j+8>>2]=0;j=j+64|0}while((j|0)!=(k|0))}c[d+60>>2]=h;b[d+58>>1]=(i&65535)+1;b[d+56>>1]=0;b[d+64>>1]=1;if(f>>>0>1){k=1;j=1;do{b[h+(k<<6)+48>>1]=k+1;j=j+1<<16>>16;k=j&65535}while(k>>>0<f>>>0)}b[h+(f+-1<<6)+48>>1]=0;c[2703]=(c[2703]|0)+1;k=XE((f<<3|3)+16|0)|0;if(!k)k=0;else{c[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}c[d+80>>2]=k;c[d+68>>2]=k;c[2703]=(c[2703]|0)+1;k=XE((f<<3|3)+16|0)|0;if(!k)k=0;else{c[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}c[d+84>>2]=k;c[d+72>>2]=k;c[2703]=(c[2703]|0)+1;k=XE((f<<3|3)+16|0)|0;if(!k){h=0;k=d+88|0;c[k>>2]=h;k=d+76|0;c[k>>2]=h;h=c[d+60>>2]|0;c[h>>2]=0;j=h+48|0;b[j>>1]=0;j=h+54|0;b[j>>1]=1;j=c[d+68>>2]|0;b[j>>1]=0;f=j+2|0;b[f>>1]=0;f=b[d+6>>1]|0;i=j+4|0;b[i>>1]=f;j=j+6|0;b[j>>1]=0;j=h+50|0;b[j>>1]=0;j=h+56|0;b[j>>1]=1;j=c[d+72>>2]|0;b[j>>1]=0;i=j+2|0;b[i>>1]=0;i=b[d+6>>1]|0;f=j+4|0;b[f>>1]=i;j=j+6|0;b[j>>1]=0;j=h+52|0;b[j>>1]=0;h=h+58|0;b[h>>1]=1;k=c[k>>2]|0;b[k>>1]=0;h=k+2|0;b[h>>1]=0;h=b[d+6>>1]|0;j=k+4|0;b[j>>1]=h;k=k+6|0;b[k>>1]=0;c[d>>2]=8768;return}c[(k+4+15&-16)+-4>>2]=k;h=k+4+15&-16;k=d+88|0;c[k>>2]=h;k=d+76|0;c[k>>2]=h;h=c[d+60>>2]|0;c[h>>2]=0;j=h+48|0;b[j>>1]=0;j=h+54|0;b[j>>1]=1;j=c[d+68>>2]|0;b[j>>1]=0;f=j+2|0;b[f>>1]=0;f=b[d+6>>1]|0;i=j+4|0;b[i>>1]=f;j=j+6|0;b[j>>1]=0;j=h+50|0;b[j>>1]=0;j=h+56|0;b[j>>1]=1;j=c[d+72>>2]|0;b[j>>1]=0;i=j+2|0;b[i>>1]=0;i=b[d+6>>1]|0;f=j+4|0;b[f>>1]=i;j=j+6|0;b[j>>1]=0;j=h+52|0;b[j>>1]=0;h=h+58|0;b[h>>1]=1;k=c[k>>2]|0;b[k>>1]=0;h=k+2|0;b[h>>1]=0;h=b[d+6>>1]|0;j=k+4|0;b[j>>1]=h;k=k+6|0;b[k>>1]=0;c[d>>2]=8768;return}function WA(b){b=b|0;var d=0;c[b>>2]=8896;d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;return}function XA(b){b=b|0;var d=0;c[b>>2]=8896;d=c[b+16>>2]|0;if(!d){YE(b);return}if(!(a[b+20>>0]|0)){YE(b);return}c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);YE(b);return}function YA(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function ZA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return 0}function _A(a,b,c){a=a|0;b=b|0;c=c|0;return}function $A(a){a=a|0;return c[a+16>>2]|0}function aB(a){a=a|0;return c[a+16>>2]|0}function bB(a){a=a|0;return a+4|0}function cB(a,b,c){a=a|0;b=b|0;c=c|0;return}function dB(a){a=a|0;return 0}function eB(a,b,c){a=a|0;b=b|0;c=c|0;return}function fB(a,b){a=a|0;b=b|0;return}function gB(a,b,c){a=a|0;b=b|0;c=c|0;return}function hB(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function iB(a){a=a|0;return 1}function jB(a,b){a=a|0;b=b|0;return}function kB(a,b){a=a|0;b=b|0;return}function lB(b){b=b|0;var d=0;c[b>>2]=8832;if(c[b+108>>2]|0){d=c[b+112>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+112>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+108>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+108>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}}d=c[b+88>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+84>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+80>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+60>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}if(!(a[b+100>>0]|0))return;d=c[b+92>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+92>>2]|0;if(!d)return;c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);return}function mB(a){a=a|0;lB(a);if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function nB(a){a=a|0;lB(a);if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function oB(a,d,f,h,j,k,l,m,n){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;i=i+16|0;pB(a,w+6|0,+g[d>>2],+g[d+4>>2],+g[d+8>>2],0);pB(a,w,+g[f>>2],+g[f+4>>2],+g[f+8>>2],1);v=b[a+64>>1]|0;u=c[a+60>>2]|0;b[a+64>>1]=b[u+((v&65535)<<6)+48>>1]|0;o=(b[a+56>>1]|0)+1<<16>>16;b[a+56>>1]=o;c[u+((v&65535)<<6)+12>>2]=v&65535;c[u+((v&65535)<<6)>>2]=j;b[u+((v&65535)<<6)+4>>1]=k;b[u+((v&65535)<<6)+6>>1]=l;c[u+((v&65535)<<6)+8>>2]=n;r=(o&65535)<<1&65534;b[u+54>>1]=(e[u+54>>1]|0)+2;p=c[a+68>>2]|0;n=e[p+(r+-1<<2)>>1]|e[p+(r+-1<<2)+2>>1]<<16;b[p+((r|1)<<2)>>1]=n;b[p+((r|1)<<2)+2>>1]=n>>>16;p=c[a+68>>2]|0;b[p+(r+-1<<2)>>1]=b[w+6>>1]|0;b[p+(r+-1<<2)+2>>1]=v;b[p+(r<<2)>>1]=b[w>>1]|0;b[p+(r<<2)+2>>1]=v;b[u+((v&65535)<<6)+48>>1]=r+-1;b[u+((v&65535)<<6)+54>>1]=(o&65535)<<1;p=(c[a+60>>2]|0)+56|0;b[p>>1]=(e[p>>1]|0)+2;p=c[a+72>>2]|0;n=e[p+(r+-1<<2)>>1]|e[p+(r+-1<<2)+2>>1]<<16;b[p+((r|1)<<2)>>1]=n;b[p+((r|1)<<2)+2>>1]=n>>>16;p=c[a+72>>2]|0;b[p+(r+-1<<2)>>1]=b[w+6+2>>1]|0;b[p+(r+-1<<2)+2>>1]=v;b[p+(r<<2)>>1]=b[w+2>>1]|0;b[p+(r<<2)+2>>1]=v;b[u+((v&65535)<<6)+50>>1]=r+-1;b[u+((v&65535)<<6)+56>>1]=(o&65535)<<1;p=(c[a+60>>2]|0)+58|0;b[p>>1]=(e[p>>1]|0)+2;p=c[a+76>>2]|0;n=e[p+(r+-1<<2)>>1]|e[p+(r+-1<<2)+2>>1]<<16;b[p+((r|1)<<2)>>1]=n;b[p+((r|1)<<2)+2>>1]=n>>>16;p=c[a+76>>2]|0;b[p+(r+-1<<2)>>1]=b[w+6+4>>1]|0;b[p+(r+-1<<2)+2>>1]=v;b[p+(r<<2)>>1]=b[w+4>>1]|0;b[p+(r<<2)+2>>1]=v;b[u+((v&65535)<<6)+52>>1]=r+-1;b[u+((v&65535)<<6)+58>>1]=(o&65535)<<1;o=c[a+68>>2]|0;r=e[u+((v&65535)<<6)+48>>1]|0;p=c[a+60>>2]|0;n=b[o+(r+-1<<2)>>1]|0;if((e[o+(r<<2)>>1]|0)<(n&65535)){t=p+((e[o+(r<<2)+2>>1]|0)<<6)+48|0;s=o+(r<<2)|0;q=o+(r+-1<<2)|0;while(1){o=e[q+2>>1]|0;if(!(n&1)){r=p+(o<<6)+48|0;b[r>>1]=(b[r>>1]|0)+1<<16>>16}else{r=p+(o<<6)+54|0;b[r>>1]=(b[r>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;o=e[s>>1]|e[s+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[s>>1]=n;b[s+2>>1]=n>>>16;b[q>>1]=o;b[q+2>>1]=o>>>16;o=s+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[o>>1]|0)>=(n&65535))break;p=c[a+60>>2]|0;s=o}o=c[a+68>>2]|0}p=e[u+((v&65535)<<6)+54>>1]|0;r=o+(p<<2)|0;q=o+(p+-1<<2)|0;n=b[q>>1]|0;a:do if((e[r>>1]|0)<(n&65535)){s=c[a+60>>2]|0;o=s+((e[o+(p<<2)+2>>1]|0)<<6)+54|0;while(1){p=e[q+2>>1]|0;if(!(n&1)){t=s+(p<<6)+48|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}else{t=s+(p<<6)+54|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}b[o>>1]=(b[o>>1]|0)+-1<<16>>16;p=e[r>>1]|e[r+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[q>>1]=p;b[q+2>>1]=p>>>16;p=r+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[p>>1]|0)>=(n&65535))break a;s=c[a+60>>2]|0;r=p}}while(0);o=c[a+72>>2]|0;r=e[u+((v&65535)<<6)+50>>1]|0;p=c[a+60>>2]|0;n=b[o+(r+-1<<2)>>1]|0;if((e[o+(r<<2)>>1]|0)<(n&65535)){t=p+((e[o+(r<<2)+2>>1]|0)<<6)+50|0;s=o+(r<<2)|0;q=o+(r+-1<<2)|0;while(1){o=e[q+2>>1]|0;if(!(n&1)){r=p+(o<<6)+50|0;b[r>>1]=(b[r>>1]|0)+1<<16>>16}else{r=p+(o<<6)+56|0;b[r>>1]=(b[r>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;o=e[s>>1]|e[s+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[s>>1]=n;b[s+2>>1]=n>>>16;b[q>>1]=o;b[q+2>>1]=o>>>16;o=s+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[o>>1]|0)>=(n&65535))break;p=c[a+60>>2]|0;s=o}o=c[a+72>>2]|0}p=e[u+((v&65535)<<6)+56>>1]|0;r=o+(p<<2)|0;q=o+(p+-1<<2)|0;n=b[q>>1]|0;b:do if((e[r>>1]|0)<(n&65535)){s=c[a+60>>2]|0;o=s+((e[o+(p<<2)+2>>1]|0)<<6)+56|0;while(1){p=e[q+2>>1]|0;if(!(n&1)){t=s+(p<<6)+50|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}else{t=s+(p<<6)+56|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}b[o>>1]=(b[o>>1]|0)+-1<<16>>16;p=e[r>>1]|e[r+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[q>>1]=p;b[q+2>>1]=p>>>16;p=r+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[p>>1]|0)>=(n&65535))break b;s=c[a+60>>2]|0;r=p}}while(0);qB(a,2,b[u+((v&65535)<<6)+52>>1]|0);rB(a,2,b[u+((v&65535)<<6)+58>>1]|0,m);n=c[a+60>>2]|0;o=c[a+108>>2]|0;if(!o){v=n+((v&65535)<<6)|0;i=w;return v|0}c[n+((v&65535)<<6)+60>>2]=hc[c[(c[o>>2]|0)+8>>2]&3](o,d,f,h,j,k,l,m,0)|0;v=n+((v&65535)<<6)|0;i=w;return v|0}function pB(a,c,d,e,f,h){a=a|0;c=c|0;d=+d;e=+e;f=+f;h=h|0;var i=0,j=0;d=(d-+g[a+8>>2])*+g[a+40>>2];e=(e-+g[a+12>>2])*+g[a+44>>2];f=(f-+g[a+16>>2])*+g[a+48>>2];do if(!(d<=0.0)){j=b[a+6>>1]|0;i=b[a+4>>1]|0;if(!(d>=+(j&65535|0))){j=i&(~~d&65535)&65535|h;break}else{j=i&j&65535|h;break}}else j=h;while(0);b[c>>1]=j;do if(!(e<=0.0)){i=b[a+6>>1]|0;j=b[a+4>>1]|0;if(!(e>=+(i&65535|0))){i=j&(~~e&65535)&65535|h;break}else{i=j&i&65535|h;break}}else i=h;while(0);b[c+2>>1]=i;if(f<=0.0){j=h;j=j&65535;i=c+4|0;b[i>>1]=j;return}j=b[a+6>>1]|0;i=b[a+4>>1]|0;if(!(f>=+(j&65535|0))){j=i&(~~f&65535)&65535|h;j=j&65535;i=c+4|0;b[i>>1]=j;return}else{j=i&j&65535|h;j=j&65535;i=c+4|0;b[i>>1]=j;return}}function qB(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;h=c[a+68+(d<<2)>>2]|0;m=c[a+60>>2]|0;o=e[h+((f&65535)<<2)+2>>1]|0;g=b[h+((f&65535)+-1<<2)>>1]|0;if((e[h+((f&65535)<<2)>>1]|0)>=(g&65535))return;k=m;j=h+((f&65535)<<2)|0;i=h+((f&65535)+-1<<2)|0;while(1){h=e[i+2>>1]|0;if(!(g&1)){k=k+(h<<6)+48+(d<<1)|0;b[k>>1]=(b[k>>1]|0)+1<<16>>16}else{if(((((e[m+(o<<6)+54+((1<<d&3)<<1)>>1]|0)>=(e[k+(h<<6)+48+((1<<d&3)<<1)>>1]|0)?(e[k+(h<<6)+54+((1<<d&3)<<1)>>1]|0)>=(e[m+(o<<6)+48+((1<<d&3)<<1)>>1]|0):0)?(e[m+(o<<6)+54+((1<<(1<<d&3)&3)<<1)>>1]|0)>=(e[k+(h<<6)+48+((1<<(1<<d&3)&3)<<1)>>1]|0):0)?(e[k+(h<<6)+54+((1<<(1<<d&3)&3)<<1)>>1]|0)>=(e[m+(o<<6)+48+((1<<(1<<d&3)&3)<<1)>>1]|0):0)?(n=c[a+92>>2]|0,l=k+(h<<6)|0,Qb[c[(c[n>>2]|0)+8>>2]&63](n,m+(o<<6)|0,l)|0,n=c[a+96>>2]|0,(n|0)!=0):0)Qb[c[(c[n>>2]|0)+8>>2]&63](n,m+(o<<6)|0,l)|0;k=k+(h<<6)+54+(d<<1)|0;b[k>>1]=(b[k>>1]|0)+1<<16>>16}b[m+(o<<6)+48+(d<<1)>>1]=(b[m+(o<<6)+48+(d<<1)>>1]|0)+-1<<16>>16;f=e[j>>1]|e[j+2>>1]<<16;h=e[i>>1]|e[i+2>>1]<<16;b[j>>1]=h;b[j+2>>1]=h>>>16;b[i>>1]=f;b[i+2>>1]=f>>>16;f=j+-4|0;h=i+-4|0;g=b[h>>1]|0;if((e[f>>1]|0)>=(g&65535))break;k=c[a+60>>2]|0;j=f;i=h}return}function rB(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;i=c[a+68+(d<<2)>>2]|0;h=b[i+((f&65535)+-1<<2)>>1]|0;if((e[i+((f&65535)<<2)>>1]|0)>=(h&65535))return;l=c[a+60>>2]|0;p=l+((e[i+((f&65535)<<2)+2>>1]|0)<<6)+54+(d<<1)|0;k=i+((f&65535)<<2)|0;j=i+((f&65535)+-1<<2)|0;while(1){i=e[j+2>>1]|0;if(!(h&1)){h=e[k+2>>1]|0;if(((((e[l+(h<<6)+54+((1<<d&3)<<1)>>1]|0)>=(e[l+(i<<6)+48+((1<<d&3)<<1)>>1]|0)?(e[l+(i<<6)+54+((1<<d&3)<<1)>>1]|0)>=(e[l+(h<<6)+48+((1<<d&3)<<1)>>1]|0):0)?(e[l+(h<<6)+54+((1<<(1<<d&3)&3)<<1)>>1]|0)>=(e[l+(i<<6)+48+((1<<(1<<d&3)&3)<<1)>>1]|0):0)?(e[l+(i<<6)+54+((1<<(1<<d&3)&3)<<1)>>1]|0)>=(e[l+(h<<6)+48+((1<<(1<<d&3)&3)<<1)>>1]|0):0)?(o=c[a+92>>2]|0,m=l+(h<<6)|0,n=l+(i<<6)|0,Lb[c[(c[o>>2]|0)+12>>2]&31](o,m,n,g)|0,o=c[a+96>>2]|0,(o|0)!=0):0)Lb[c[(c[o>>2]|0)+12>>2]&31](o,m,n,g)|0;l=l+(i<<6)+48+(d<<1)|0;b[l>>1]=(b[l>>1]|0)+1<<16>>16}else{l=l+(i<<6)+54+(d<<1)|0;b[l>>1]=(b[l>>1]|0)+1<<16>>16}b[p>>1]=(b[p>>1]|0)+-1<<16>>16;f=e[k>>1]|e[k+2>>1]<<16;i=e[j>>1]|e[j+2>>1]<<16;b[k>>1]=i;b[k+2>>1]=i>>>16;b[j>>1]=f;b[j+2>>1]=f>>>16;f=k+-4|0;i=j+-4|0;h=b[i>>1]|0;if((e[f>>1]|0)>=(h&65535))break;l=c[a+60>>2]|0;k=f;j=i}return}function sB(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=c[a+108>>2]|0;if(g)jc[c[(c[g>>2]|0)+12>>2]&127](g,c[d+60>>2]|0,f);p=c[d+12>>2]|0;q=c[a+60>>2]|0;n=c[a+92>>2]|0;if(!(Hb[c[(c[n>>2]|0)+56>>2]&127](n)|0)){n=c[a+92>>2]|0;jc[c[(c[n>>2]|0)+16>>2]&127](n,q+((p&65535)<<6)|0,f)}o=e[a+56>>1]|0;f=c[a+60>>2]|0;b[f+54>>1]=(e[f+54>>1]|0)+65534;b[f+56>>1]=(e[f+56>>1]|0)+65534;b[f+58>>1]=(e[f+58>>1]|0)+65534;f=b[a+6>>1]|0;n=0;do{l=a+68+(n<<2)|0;m=c[l>>2]|0;h=e[q+((p&65535)<<6)+54+(n<<1)>>1]|0;b[m+(h<<2)>>1]=f;d=b[m+(h+1<<2)+2>>1]|0;if(!(d<<16>>16))g=m;else{k=(c[a+60>>2]|0)+((e[m+(h<<2)+2>>1]|0)<<6)+54+(n<<1)|0;j=m+(h<<2)|0;g=m+(h+1<<2)|0;while(1){i=b[g>>1]|0;if((e[j>>1]|0)<(i&65535))break;f=c[a+60>>2]|0;h=d&65535;if(!(i&1)){i=f+(h<<6)+48+(n<<1)|0;b[i>>1]=(b[i>>1]|0)+-1<<16>>16}else{i=f+(h<<6)+54+(n<<1)|0;b[i>>1]=(b[i>>1]|0)+-1<<16>>16}b[k>>1]=(b[k>>1]|0)+1<<16>>16;d=e[j>>1]|e[j+2>>1]<<16;i=e[g>>1]|e[g+2>>1]<<16;b[j>>1]=i;b[j+2>>1]=i>>>16;b[g>>1]=d;b[g+2>>1]=d>>>16;d=b[g+6>>1]|0;if(!(d<<16>>16))break;else{j=j+4|0;g=g+4|0}}f=b[a+6>>1]|0;g=c[l>>2]|0}h=e[q+((p&65535)<<6)+48+(n<<1)>>1]|0;b[m+(h<<2)>>1]=f;d=b[g+(h+1<<2)+2>>1]|0;if(d<<16>>16){k=(c[a+60>>2]|0)+((e[g+(h<<2)+2>>1]|0)<<6)+48+(n<<1)|0;j=g+(h<<2)|0;i=g+(h+1<<2)|0;while(1){g=b[i>>1]|0;if((e[j>>1]|0)<(g&65535))break;h=c[a+60>>2]|0;f=d&65535;if(!(g&1)){l=h+(f<<6)+48+(n<<1)|0;b[l>>1]=(b[l>>1]|0)+-1<<16>>16}else{l=h+(f<<6)+54+(n<<1)|0;b[l>>1]=(b[l>>1]|0)+-1<<16>>16}b[k>>1]=(b[k>>1]|0)+1<<16>>16;d=e[j>>1]|e[j+2>>1]<<16;l=e[i>>1]|e[i+2>>1]<<16;b[j>>1]=l;b[j+2>>1]=l>>>16;b[i>>1]=d;b[i+2>>1]=d>>>16;d=b[i+6>>1]|0;if(!(d<<16>>16))break;else{j=j+4|0;i=i+4|0}}f=b[a+6>>1]|0}b[m+((o<<1)+-1<<2)+2>>1]=0;b[m+((o<<1)+-1<<2)>>1]=f;n=n+1|0}while((n|0)!=3);b[(c[a+60>>2]|0)+((p&65535)<<6)+48>>1]=b[a+64>>1]|0;b[a+64>>1]=p;b[a+56>>1]=(b[a+56>>1]|0)+-1<<16>>16;return}function tB(a,d,f,h,j){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;J=i;i=i+16|0;c[d+16>>2]=c[f>>2];c[d+16+4>>2]=c[f+4>>2];c[d+16+8>>2]=c[f+8>>2];c[d+16+12>>2]=c[f+12>>2];c[d+32>>2]=c[h>>2];c[d+32+4>>2]=c[h+4>>2];c[d+32+8>>2]=c[h+8>>2];c[d+32+12>>2]=c[h+12>>2];v=c[a+60>>2]|0;G=c[d+12>>2]&65535;pB(a,J+6|0,+g[f>>2],+g[f+4>>2],+g[f+8>>2],0);pB(a,J,+g[h>>2],+g[h+4>>2],+g[h+8>>2],1);F=0;do{u=b[v+(G<<6)+48+(F<<1)>>1]|0;z=b[v+(G<<6)+54+(F<<1)>>1]|0;n=b[J+6+(F<<1)>>1]|0;k=a+68+(F<<2)|0;l=c[k>>2]|0;t=(n&65535)-(e[l+((u&65535)<<2)>>1]|0)|0;m=b[J+(F<<1)>>1]|0;I=(m&65535)-(e[l+((z&65535)<<2)>>1]|0)|0;b[l+((u&65535)<<2)>>1]=n;b[l+((z&65535)<<2)>>1]=m;if((t|0)<0)qB(a,F,u);a:do if((I|0)>0?(E=c[k>>2]|0,w=c[a+60>>2]|0,H=e[E+((z&65535)<<2)+2>>1]|0,x=b[E+((z&65535)+1<<2)+2>>1]|0,x<<16>>16!=0):0){m=1<<F&3;l=w+(H<<6)+54+(F<<1)|0;n=x;r=E+((z&65535)<<2)|0;s=E+((z&65535)+1<<2)|0;while(1){q=b[s>>1]|0;if((e[r>>1]|0)<(q&65535))break a;o=c[a+60>>2]|0;p=n&65535;if(!(q&1)){if(((((e[w+(H<<6)+54+(m<<1)>>1]|0)>=(e[o+(p<<6)+48+(m<<1)>>1]|0)?(e[o+(p<<6)+54+(m<<1)>>1]|0)>=(e[w+(H<<6)+48+(m<<1)>>1]|0):0)?(e[w+(H<<6)+54+((1<<m&3)<<1)>>1]|0)>=(e[o+(p<<6)+48+((1<<m&3)<<1)>>1]|0):0)?(e[o+(p<<6)+54+((1<<m&3)<<1)>>1]|0)>=(e[w+(H<<6)+48+((1<<m&3)<<1)>>1]|0):0)?(A=c[a+92>>2]|0,y=o+((e[r+2>>1]|0)<<6)|0,Qb[c[(c[A>>2]|0)+8>>2]&63](A,y,o+(p<<6)|0)|0,A=c[a+96>>2]|0,(A|0)!=0):0)Qb[c[(c[A>>2]|0)+8>>2]&63](A,y,o+(p<<6)|0)|0;n=o+(p<<6)+48+(F<<1)|0;b[n>>1]=(b[n>>1]|0)+-1<<16>>16}else{n=o+(p<<6)+54+(F<<1)|0;b[n>>1]=(b[n>>1]|0)+-1<<16>>16}b[l>>1]=(b[l>>1]|0)+1<<16>>16;n=e[r>>1]|e[r+2>>1]<<16;o=e[s>>1]|e[s+2>>1]<<16;b[r>>1]=o;b[r+2>>1]=o>>>16;b[s>>1]=n;b[s+2>>1]=n>>>16;n=b[s+6>>1]|0;if(!(n<<16>>16))break;else{r=r+4|0;s=s+4|0}}}while(0);b:do if((t|0)>0?(B=c[k>>2]|0,C=b[B+((u&65535)+1<<2)+2>>1]|0,C<<16>>16!=0):0){p=(c[a+60>>2]|0)+((e[B+((u&65535)<<2)+2>>1]|0)<<6)+48+(F<<1)|0;o=1<<F&3;l=C;q=B+((u&65535)<<2)|0;n=B+((u&65535)+1<<2)|0;while(1){k=b[n>>1]|0;if((e[q>>1]|0)<(k&65535))break b;m=c[a+60>>2]|0;l=l&65535;if(!(k&1)){u=m+(l<<6)+48+(F<<1)|0;b[u>>1]=(b[u>>1]|0)+-1<<16>>16}else{k=e[q+2>>1]|0;if(((((e[m+(k<<6)+54+(o<<1)>>1]|0)>=(e[m+(l<<6)+48+(o<<1)>>1]|0)?(e[m+(l<<6)+54+(o<<1)>>1]|0)>=(e[m+(k<<6)+48+(o<<1)>>1]|0):0)?(e[m+(k<<6)+54+((1<<o&3)<<1)>>1]|0)>=(e[m+(l<<6)+48+((1<<o&3)<<1)>>1]|0):0)?(e[m+(l<<6)+54+((1<<o&3)<<1)>>1]|0)>=(e[m+(k<<6)+48+((1<<o&3)<<1)>>1]|0):0)?(D=c[a+92>>2]|0,Lb[c[(c[D>>2]|0)+12>>2]&31](D,m+(k<<6)|0,m+(l<<6)|0,j)|0,D=c[a+96>>2]|0,(D|0)!=0):0)Lb[c[(c[D>>2]|0)+12>>2]&31](D,m+(k<<6)|0,m+(l<<6)|0,j)|0;u=m+(l<<6)+54+(F<<1)|0;b[u>>1]=(b[u>>1]|0)+-1<<16>>16}b[p>>1]=(b[p>>1]|0)+1<<16>>16;l=e[q>>1]|e[q+2>>1]<<16;u=e[n>>1]|e[n+2>>1]<<16;b[q>>1]=u;b[q+2>>1]=u>>>16;b[n>>1]=l;b[n+2>>1]=l>>>16;l=b[n+6>>1]|0;if(!(l<<16>>16))break;else{q=q+4|0;n=n+4|0}}}while(0);if((I|0)<0)rB(a,F,z,j);F=F+1|0}while((F|0)!=3);k=c[a+108>>2]|0;if(!k){i=J;return}Bb[c[(c[k>>2]|0)+16>>2]&31](k,c[d+60>>2]|0,f,h,j);i=J;return}function uB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[d>>2]=c[b+16>>2];c[d+4>>2]=c[b+16+4>>2];c[d+8>>2]=c[b+16+8>>2];c[d+12>>2]=c[b+16+12>>2];c[e>>2]=c[b+32>>2];c[e+4>>2]=c[b+32+4>>2];c[e+8>>2]=c[b+32+8>>2];c[e+12>>2]=c[b+32+12>>2];return}function vB(a,d,f,g,h,i){a=a|0;d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0;j=c[a+108>>2]|0;if(j){Rb[c[(c[j>>2]|0)+24>>2]&7](j,d,f,g,h,i);return}i=b[a+56>>1]|0;if((i&65535)<<1>>>0<=1)return;h=1;d=1;do{j=c[a+68>>2]|0;if(b[j+(h<<2)>>1]&1){_b[c[(c[g>>2]|0)+8>>2]&31](g,(c[a+60>>2]|0)+((e[j+(h<<2)+2>>1]|0)<<6)|0)|0;i=b[a+56>>1]|0}d=d+1<<16>>16;h=d&65535}while(h>>>0<((i&65535)<<1|1)>>>0);return}function wB(a,d,f,h){a=a|0;d=d|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;i=c[a+108>>2]|0;if(i){nc[c[(c[i>>2]|0)+28>>2]&127](i,d,f,h);return}i=b[a+56>>1]|0;if((i&65535)<<1>>>0<=1)return;k=1;m=1;do{j=c[a+68>>2]|0;if(b[j+(k<<2)>>1]&1){l=c[a+60>>2]|0;k=e[j+(k<<2)+2>>1]|0;if(!(+g[d>>2]>+g[l+(k<<6)+32>>2])?!(+g[f>>2]<+g[l+(k<<6)+16>>2]):0)j=1;else j=0;if(!(!(+g[d+8>>2]>+g[l+(k<<6)+40>>2])?!(+g[f+8>>2]<+g[l+(k<<6)+24>>2]):0))j=0;if(!(+g[d+4>>2]>+g[l+(k<<6)+36>>2])?!(+g[f+4>>2]<+g[l+(k<<6)+20>>2]|j^1):0){_b[c[(c[h>>2]|0)+8>>2]&31](h,l+(k<<6)|0)|0;i=b[a+56>>1]|0}}m=m+1<<16>>16;k=m&65535}while(k>>>0<((i&65535)<<1|1)>>>0);return}function xB(a,b){a=a|0;b=b|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=i;i=i+32|0;m=c[a+92>>2]|0;if(!(Hb[c[(c[m>>2]|0)+56>>2]&127](m)|0)){i=p;return}o=c[a+92>>2]|0;o=Hb[c[(c[o>>2]|0)+28>>2]&127](o)|0;d=c[o+4>>2]|0;if((d|0)>1){yB(o,0,d+-1|0);d=c[o+4>>2]|0}d=d-(c[a+104>>2]|0)|0;c[p+16>>2]=0;c[p+16+4>>2]=0;c[p+16+8>>2]=0;c[p+16+12>>2]=0;zB(o,d,p+16|0);c[a+104>>2]=0;d=c[o+4>>2]|0;if((d|0)>0){m=0;f=0;l=0;h=0;while(1){k=c[o+12>>2]|0;j=k+(l<<4)|0;q=m;m=c[j>>2]|0;k=k+(l<<4)+4|0;g=c[k>>2]|0;if(!((m|0)==(q|0)&(g|0)==(h|0))){h=m+54|0;q=m+48|0;if(!((((((e[h>>1]|0)>=(e[g+48>>1]|0)?(e[g+54>>1]|0)>=(e[q>>1]|0):0)?(e[h+2>>1]|0)>=(e[g+48+2>>1]|0):0)?(e[g+54+2>>1]|0)>=(e[q+2>>1]|0):0)?(e[h+4>>1]|0)>=(e[g+52>>1]|0):0)?(e[g+54+4>>1]|0)>=(e[m+52>>1]|0):0))n=13}else{g=h;n=13}if((n|0)==13){n=0;f=c[a+92>>2]|0;jc[c[(c[f>>2]|0)+32>>2]&127](f,j,b);c[j>>2]=0;c[k>>2]=0;f=(c[a+104>>2]|0)+1|0;c[a+104>>2]=f;c[2241]=(c[2241]|0)+-1;d=c[o+4>>2]|0}l=l+1|0;if((l|0)>=(d|0))break;else h=g}if((d|0)>1){yB(o,0,d+-1|0);f=c[a+104>>2]|0;d=c[o+4>>2]|0}}else f=0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;zB(o,d-f|0,p);c[a+104>>2]=0;i=p;return}function yB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;while(1){p=(b+d|0)/2|0;q=c[a+12>>2]|0;n=c[q+(p<<4)>>2]|0;o=c[q+(p<<4)+4>>2]|0;p=c[q+(p<<4)+8>>2]|0;e=b;f=d;while(1){a:do if(!n)while(1){k=c[q+(e<<4)>>2]|0;if(!k)g=-1;else g=c[k+12>>2]|0;j=c[q+(e<<4)+4>>2]|0;if(!j)h=-1;else h=c[j+12>>2]|0;if(!o)i=-1;else i=c[o+12>>2]|0;do if((g|0)<=-1){g=(h|0)>(i|0);if(g|(k|0)==(n|0)^1)if((k|0)==(n|0)&g)break;else break a;if((j|0)!=(o|0))break a;if((c[q+(e<<4)+8>>2]|0)>>>0<=p>>>0)break a}while(0);e=e+1|0}else{m=c[n+12>>2]|0;while(1){h=c[q+(e<<4)>>2]|0;if(!h)k=-1;else k=c[h+12>>2]|0;l=c[q+(e<<4)+4>>2]|0;if(!l)j=-1;else j=c[l+12>>2]|0;if(!o)i=-1;else i=c[o+12>>2]|0;do if((k|0)<=(m|0)){g=(j|0)>(i|0);if(g|(h|0)==(n|0)^1)if((h|0)==(n|0)&g)break;else break a;if((l|0)!=(o|0))break a;if((c[q+(e<<4)+8>>2]|0)>>>0<=p>>>0)break a}while(0);e=e+1|0}}while(0);b:while(1){if(!n)k=-1;else k=c[n+12>>2]|0;l=c[q+(f<<4)>>2]|0;if(!l)j=-1;else j=c[l+12>>2]|0;if(!o)i=-1;else i=c[o+12>>2]|0;m=c[q+(f<<4)+4>>2]|0;if(!m)h=-1;else h=c[m+12>>2]|0;do if((k|0)<=(j|0)){g=(i|0)>(h|0);if(g|(n|0)==(l|0)^1)if((n|0)==(l|0)&g)break;else break b;if((o|0)!=(m|0))break b;if(p>>>0<=(c[q+(f<<4)+8>>2]|0)>>>0)break b}while(0);f=f+-1|0}if((e|0)<=(f|0)){m=q+(e<<4)|0;i=c[m>>2]|0;j=c[q+(e<<4)+4>>2]|0;k=c[q+(e<<4)+8>>2]|0;l=c[q+(e<<4)+12>>2]|0;h=q+(f<<4)|0;c[m>>2]=c[h>>2];c[m+4>>2]=c[h+4>>2];c[m+8>>2]=c[h+8>>2];c[m+12>>2]=c[h+12>>2];m=c[a+12>>2]|0;c[m+(f<<4)>>2]=i;c[m+(f<<4)+4>>2]=j;c[m+(f<<4)+8>>2]=k;c[m+(f<<4)+12>>2]=l;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;q=c[a+12>>2]|0}if((f|0)>(b|0))yB(a,b,f);if((e|0)<(d|0))b=e;else break}return}function zB(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;i=c[b+4>>2]|0;if(!((i|0)<=(d|0)&(i|0)<(d|0))){c[b+4>>2]=d;return}if((c[b+8>>2]|0)<(d|0)){if(!d){h=i;g=0}else{c[2703]=(c[2703]|0)+1;f=XE((d<<4|3)+16|0)|0;if(!f)g=0;else{c[(f+4+15&-16)+-4>>2]=f;g=f+4+15&-16}h=c[b+4>>2]|0}if((h|0)>0){f=0;do{j=c[b+12>>2]|0;c[g+(f<<4)>>2]=c[j+(f<<4)>>2];c[g+(f<<4)+4>>2]=c[j+(f<<4)+4>>2];c[g+(f<<4)+8>>2]=c[j+(f<<4)+8>>2];c[g+(f<<4)+12>>2]=c[j+(f<<4)+12>>2];f=f+1|0}while((f|0)!=(h|0))}f=c[b+12>>2]|0;if(f){if(a[b+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=g;c[b+8>>2]=d;g=b+12|0}else g=b+12|0;f=i;do{h=c[g>>2]|0;c[h+(f<<4)>>2]=c[e>>2];c[h+(f<<4)+4>>2]=c[e+4>>2];c[h+(f<<4)+8>>2]=c[e+8>>2];c[h+(f<<4)+12>>2]=c[e+12>>2];f=f+1|0}while((f|0)!=(d|0));c[b+4>>2]=d;return}function AB(a){a=a|0;return c[a+92>>2]|0}function BB(a){a=a|0;return c[a+92>>2]|0}function CB(a,b,d){a=a|0;b=b|0;d=d|0;c[b>>2]=c[a+8>>2];c[b+4>>2]=c[a+8+4>>2];c[b+8>>2]=c[a+8+8>>2];c[b+12>>2]=c[a+8+12>>2];c[d>>2]=c[a+24>>2];c[d+4>>2]=c[a+24+4>>2];c[d+8>>2]=c[a+24+8>>2];c[d+12>>2]=c[a+24+12>>2];return}function DB(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;if(b[a+56>>1]|0)return;b[a+64>>1]=1;d=b[a+58>>1]|0;g=c[a+60>>2]|0;if((d&65535)>1){e=1;d=1;while(1){b[g+(e<<6)+48>>1]=e+1;f=d+1<<16>>16;d=b[a+58>>1]|0;if((f&65535)<(d&65535)){e=f&65535;d=f}else break}}b[g+((d&65535)+-1<<6)+48>>1]=0;return}function EB(a){a=a|0;return}function FB(b){b=b|0;var d=0,e=0,f=0,g=0;c[b>>2]=8988;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+24>>2]=0;a[b+28>>0]=0;a[b+48>>0]=1;c[b+44>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;a[b+68>>0]=1;c[b+64>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;c[b+72>>2]=0;c[2703]=(c[2703]|0)+1;d=XE(51)|0;if(!d)f=0;else{c[(d+4+15&-16)+-4>>2]=d;f=d+4+15&-16}d=c[b+8>>2]|0;if((d|0)>0){e=0;do{g=c[b+16>>2]|0;c[f+(e<<4)>>2]=c[g+(e<<4)>>2];c[f+(e<<4)+4>>2]=c[g+(e<<4)+4>>2];c[f+(e<<4)+8>>2]=c[g+(e<<4)+8>>2];c[f+(e<<4)+12>>2]=c[g+(e<<4)+12>>2];e=e+1|0}while((e|0)!=(d|0))}d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=2;GB(b);return}if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=2;GB(b);return}function GB(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;i=c[b+12>>2]|0;j=c[b+36>>2]|0;if((i|0)<=(j|0))return;if((i|0)>=(j|0)){do if((c[b+40>>2]|0)<(i|0)){if(!i){e=j;d=0}else{c[2703]=(c[2703]|0)+1;d=XE((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+36>>2]|0}g=c[b+44>>2]|0;if((e|0)<=0){if(!g){a[b+48>>0]=1;c[b+44>>2]=d;c[b+40>>2]=i;break}}else{f=0;do{c[d+(f<<2)>>2]=c[g+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}if(a[b+48>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0)}a[b+48>>0]=1;c[b+44>>2]=d;c[b+40>>2]=i}else d=c[b+44>>2]|0;while(0);qF(d+(j<<2)|0,0,i-j<<2|0)|0}c[b+36>>2]=i;h=c[b+56>>2]|0;if((i|0)>(h|0)){do if((c[b+60>>2]|0)<(i|0)){if(!i){e=h;d=0}else{c[2703]=(c[2703]|0)+1;d=XE((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+56>>2]|0}g=c[b+64>>2]|0;if((e|0)<=0){if(!g){a[b+68>>0]=1;c[b+64>>2]=d;c[b+60>>2]=i;break}}else{f=0;do{c[d+(f<<2)>>2]=c[g+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}if(a[b+68>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0)}a[b+68>>0]=1;c[b+64>>2]=d;c[b+60>>2]=i}else d=c[b+64>>2]|0;while(0);qF(d+(h<<2)|0,0,i-h<<2|0)|0}c[b+56>>2]=i;if((i|0)>0){qF(c[b+44>>2]|0,-1,i<<2|0)|0;qF(c[b+64>>2]|0,-1,i<<2|0)|0}if((j|0)<=0)return;d=c[b+16>>2]|0;e=c[b+44>>2]|0;f=c[b+64>>2]|0;g=0;do{h=c[(c[d+(g<<4)+4>>2]|0)+12>>2]<<16|c[(c[d+(g<<4)>>2]|0)+12>>2];h=(h+~(h<<15)>>10^h+~(h<<15))*9|0;h=e+((((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11))&(c[b+12>>2]|0)+-1)<<2)|0;c[f+(g<<2)>>2]=c[h>>2];c[h>>2]=g;g=g+1|0}while((g|0)!=(j|0));return}function HB(b){b=b|0;var d=0;c[b>>2]=8988;d=c[b+64>>2]|0;if(d){if(a[b+68>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+64>>2]=0}a[b+68>>0]=1;c[b+64>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;d=c[b+44>>2]|0;if(d){if(a[b+48>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+44>>2]=0}a[b+48>>0]=1;c[b+44>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;return}if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;return}function IB(a){a=a|0;HB(a);YE(a);return}function JB(a,b,d){a=a|0;b=b|0;d=d|0;a=c[b+8>>2]|0;if(!((d|0)!=0&(a|0)!=0))return;Db[c[c[a>>2]>>2]&255](a);Fb[c[(c[d>>2]|0)+60>>2]&127](d,c[b+8>>2]|0);c[b+8>>2]=0;return}function KB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e>>2]=9064;c[e+4>>2]=b;c[e+8>>2]=a;c[e+12>>2]=d;jc[c[(c[a>>2]|0)+48>>2]&127](a,e,d);i=e;return}function LB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e>>2]=9084;c[e+4>>2]=b;jc[c[(c[a>>2]|0)+48>>2]&127](a,e,d);i=e;return}function MB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;c[2244]=(c[2244]|0)+1;e=(c[b+12>>2]|0)>(c[d+12>>2]|0);f=c[(e?d:b)+12>>2]|0;e=c[(e?b:d)+12>>2]|0;b=((e<<16|f)+~((e<<16|f)<<15)>>10^(e<<16|f)+~((e<<16|f)<<15))*9|0;b=((b>>6^b)+~((b>>6^b)<<11)>>16^(b>>6^b)+~((b>>6^b)<<11))&(c[a+12>>2]|0)+-1;if((b|0)>=(c[a+36>>2]|0)){b=0;return b|0}d=c[(c[a+44>>2]|0)+(b<<2)>>2]|0;if((d|0)==-1){b=0;return b|0}b=c[a+16>>2]|0;while(1){if((c[(c[b+(d<<4)>>2]|0)+12>>2]|0)==(f|0)?(c[(c[b+(d<<4)+4>>2]|0)+12>>2]|0)==(e|0):0)break;d=c[(c[a+64>>2]|0)+(d<<2)>>2]|0;if((d|0)==-1){b=0;g=8;break}}if((g|0)==8)return b|0;b=b+(d<<4)|0;return b|0}function NB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;c[2242]=(c[2242]|0)+1;j=(c[b+12>>2]|0)>(c[d+12>>2]|0);m=j?d:b;h=c[m+12>>2]|0;j=j?b:d;f=c[j+12>>2]|0;i=((f<<16|h)+~((f<<16|h)<<15)>>10^(f<<16|h)+~((f<<16|h)<<15))*9|0;i=((i>>6^i)+~((i>>6^i)<<11)>>16^(i>>6^i)+~((i>>6^i)<<11))&(c[a+12>>2]|0)+-1;d=c[(c[a+44>>2]|0)+(i<<2)>>2]|0;if((d|0)==-1){m=0;return m|0}g=c[a+16>>2]|0;b=d;while(1){if((c[(c[g+(b<<4)>>2]|0)+12>>2]|0)==(h|0)?(c[(c[g+(b<<4)+4>>2]|0)+12>>2]|0)==(f|0):0)break;d=c[(c[a+64>>2]|0)+(b<<2)>>2]|0;if((d|0)==-1){b=0;p=24;break}else b=d}if((p|0)==24)return b|0;d=g+(b<<4)|0;if(!d){m=0;return m|0}jc[c[(c[a>>2]|0)+32>>2]&127](a,d,e);o=c[g+(b<<4)+12>>2]|0;n=d-(c[a+16>>2]|0)>>4;k=(c[a+44>>2]|0)+(i<<2)|0;d=c[k>>2]|0;b=c[a+64>>2]|0;if((d|0)!=(n|0)){h=d;while(1){g=b+(h<<2)|0;f=c[g>>2]|0;if((f|0)==(n|0))break;else h=f}d=c[b+(n<<2)>>2]|0;if((h|0)==-1)p=12;else c[g>>2]=d}else{d=c[b+(n<<2)>>2]|0;p=12}if((p|0)==12)c[k>>2]=d;l=(c[a+8>>2]|0)+-1|0;d=c[a+72>>2]|0;if(d)Lb[c[(c[d>>2]|0)+12>>2]&31](d,m,j,e)|0;if((l|0)==(n|0)){c[a+8>>2]=(c[a+8>>2]|0)+-1;m=o;return m|0}i=c[a+16>>2]|0;j=c[(c[i+(l<<4)+4>>2]|0)+12>>2]<<16|c[(c[i+(l<<4)>>2]|0)+12>>2];j=(j+~(j<<15)>>10^j+~(j<<15))*9|0;j=((j>>6^j)+~((j>>6^j)<<11)>>16^(j>>6^j)+~((j>>6^j)<<11))&(c[a+12>>2]|0)+-1;k=(c[a+44>>2]|0)+(j<<2)|0;d=c[k>>2]|0;b=c[a+64>>2]|0;if((d|0)!=(l|0)){h=d;while(1){g=b+(h<<2)|0;f=c[g>>2]|0;if((f|0)==(l|0))break;else h=f}d=c[b+(l<<2)>>2]|0;if((h|0)==-1)p=22;else c[g>>2]=d}else{d=c[b+(l<<2)>>2]|0;p=22}if((p|0)==22)c[k>>2]=d;c[i+(n<<4)>>2]=c[i+(l<<4)>>2];c[i+(n<<4)+4>>2]=c[i+(l<<4)+4>>2];c[i+(n<<4)+8>>2]=c[i+(l<<4)+8>>2];c[i+(n<<4)+12>>2]=c[i+(l<<4)+12>>2];m=(c[a+44>>2]|0)+(j<<2)|0;c[(c[a+64>>2]|0)+(n<<2)>>2]=c[m>>2];c[m>>2]=n;c[a+8>>2]=(c[a+8>>2]|0)+-1;m=o;return m|0}function OB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;if((c[a+8>>2]|0)<=0)return;g=0;a:while(1){while(1){e=c[a+16>>2]|0;f=e+(g<<4)|0;if(!(_b[c[(c[b>>2]|0)+8>>2]&31](b,f)|0))break;Lb[c[(c[a>>2]|0)+12>>2]&31](a,c[f>>2]|0,c[e+(g<<4)+4>>2]|0,d)|0;c[2241]=(c[2241]|0)+-1;if((g|0)>=(c[a+8>>2]|0)){e=7;break a}}g=g+1|0;if((g|0)>=(c[a+8>>2]|0)){e=7;break}}if((e|0)==7)return}function PB(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+32|0;a[t+16>>0]=1;c[t+12>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;f=c[b+8>>2]|0;if((f|0)>0){j=0;n=0;g=0;l=0;h=0;m=0;k=0;r=0;while(1){p=c[b+16>>2]|0;q=p+(r<<4)|0;if((j|0)==(n|0)){e=(n|0)!=0?n<<1:1;if((n|0)<(e|0)){if(e){c[2703]=(c[2703]|0)+1;h=XE((e<<4|3)+16|0)|0;if(!h){g=j;l=0}else{c[(h+4+15&-16)+-4>>2]=h;g=j;l=h+4+15&-16}}else{g=n;l=0}if((g|0)>0){h=0;do{o=c[t+12>>2]|0;c[l+(h<<4)>>2]=c[o+(h<<4)>>2];c[l+(h<<4)+4>>2]=c[o+(h<<4)+4>>2];c[l+(h<<4)+8>>2]=c[o+(h<<4)+8>>2];c[l+(h<<4)+12>>2]=c[o+(h<<4)+12>>2];h=h+1|0}while((h|0)!=(g|0))}h=c[t+12>>2]|0;if(h){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0);c[t+12>>2]=0;g=j}a[t+16>>0]=1;c[t+12>>2]=l;c[t+8>>2]=e;o=g;k=l;f=c[b+8>>2]|0;m=l;g=l;h=l}else{o=n;e=n}}else{o=j;e=n}c[k+(o<<4)>>2]=c[q>>2];c[k+(o<<4)+4>>2]=c[p+(r<<4)+4>>2];c[k+(o<<4)+8>>2]=c[p+(r<<4)+8>>2];c[k+(o<<4)+12>>2]=c[p+(r<<4)+12>>2];j=o+1|0;r=r+1|0;if((r|0)>=(f|0))break;else n=e}c[t+4>>2]=j;if((o|0)>-1){f=0;do{Lb[c[(c[b>>2]|0)+12>>2]&31](b,c[m+(f<<4)>>2]|0,c[m+(f<<4)+4>>2]|0,d)|0;f=f+1|0}while((f|0)<(j|0))}}else{j=0;h=0;g=0}if((c[b+56>>2]|0)>0){e=c[b+64>>2]|0;f=0;do{c[e+(f<<2)>>2]=-1;f=f+1|0}while((f|0)<(c[b+56>>2]|0))}if((j|0)<=1){if((j|0)>0)s=23}else{yB(t,0,j+-1|0);s=23}if((s|0)==23){e=0;do{Qb[c[(c[b>>2]|0)+8>>2]&63](b,c[h+(e<<4)>>2]|0,c[h+(e<<4)+4>>2]|0)|0;e=e+1|0}while((e|0)<(j|0))}if(!g){i=t;return}c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0);c[t+12>>2]=0;i=t;return}function QB(a){a=a|0;YE(a);return}function RB(a,b){a=a|0;b=b|0;var d=0;d=c[a+4>>2]|0;if((c[b>>2]|0)!=(d|0)?(c[b+4>>2]|0)!=(d|0):0)return 0;d=c[a+8>>2]|0;jc[c[(c[d>>2]|0)+32>>2]&127](d,b,c[a+12>>2]|0);return 0}function SB(a){a=a|0;YE(a);return}function TB(a,b){a=a|0;b=b|0;a=c[a+4>>2]|0;return ((c[b>>2]|0)==(a|0)?1:(c[b+4>>2]|0)==(a|0))|0}function UB(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[2243]=(c[2243]|0)+1;g=c[d+24>>2]|0;if(!g){if(!((b[f+6>>1]&b[e+4>>1])<<16>>16)){g=0;return g|0}if(!((b[e+6>>1]&b[f+4>>1])<<16>>16)){g=0;return g|0}}else if(!(Qb[c[(c[g>>2]|0)+8>>2]&63](g,e,f)|0)){g=0;return g|0}l=(c[e+12>>2]|0)>(c[f+12>>2]|0);m=l?f:e;g=c[m+12>>2]|0;l=l?e:f;h=c[l+12>>2]|0;k=((h<<16|g)+~((h<<16|g)<<15)>>10^(h<<16|g)+~((h<<16|g)<<15))*9|0;k=(k>>6^k)+~((k>>6^k)<<11)>>16^(k>>6^k)+~((k>>6^k)<<11);j=c[d+12>>2]|0;f=c[(c[d+44>>2]|0)+((k&j+-1)<<2)>>2]|0;a:do if((f|0)!=-1){e=c[d+16>>2]|0;while(1){if((c[(c[e+(f<<4)>>2]|0)+12>>2]|0)==(g|0)?(c[(c[e+(f<<4)+4>>2]|0)+12>>2]|0)==(h|0):0)break;f=c[(c[d+64>>2]|0)+(f<<2)>>2]|0;if((f|0)==-1)break a}g=e+(f<<4)|0;if(g)return g|0}while(0);i=c[d+8>>2]|0;if((i|0)==(j|0)){f=(j|0)!=0?j<<1:1;if((j|0)<(f|0)){if(!f){e=j;g=0}else{c[2703]=(c[2703]|0)+1;e=XE((f<<4|3)+16|0)|0;if(!e)g=0;else{c[(e+4+15&-16)+-4>>2]=e;g=e+4+15&-16}e=c[d+8>>2]|0}if((e|0)>0){h=0;do{n=c[d+16>>2]|0;c[g+(h<<4)>>2]=c[n+(h<<4)>>2];c[g+(h<<4)+4>>2]=c[n+(h<<4)+4>>2];c[g+(h<<4)+8>>2]=c[n+(h<<4)+8>>2];c[g+(h<<4)+12>>2]=c[n+(h<<4)+12>>2];h=h+1|0}while((h|0)!=(e|0))}h=c[d+16>>2]|0;if(h){if(a[d+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0);e=c[d+8>>2]|0}c[d+16>>2]=0}a[d+20>>0]=1;c[d+16>>2]=g;c[d+12>>2]=f}else{e=j;f=j}}else{e=i;f=j}c[d+8>>2]=e+1;h=c[d+16>>2]|0;e=c[d+72>>2]|0;if(e){Qb[c[(c[e>>2]|0)+8>>2]&63](e,m,l)|0;f=c[d+12>>2]|0}if((j|0)<(f|0)){GB(d);g=(c[d+12>>2]|0)+-1&k}else g=k&j+-1;k=(c[m+12>>2]|0)<(c[l+12>>2]|0);c[h+(i<<4)>>2]=k?m:l;c[h+(i<<4)+4>>2]=k?l:m;c[h+(i<<4)+8>>2]=0;c[h+(i<<4)+8+4>>2]=0;m=(c[d+44>>2]|0)+(g<<2)|0;c[(c[d+64>>2]|0)+(i<<2)>>2]=c[m>>2];c[m>>2]=i;d=h+(i<<4)|0;return d|0}function VB(a){a=a|0;return c[a+16>>2]|0}function WB(a){a=a|0;return c[a+16>>2]|0}function XB(a){a=a|0;return a+4|0}function YB(a){a=a|0;return c[a+8>>2]|0}function ZB(a,b){a=a|0;b=b|0;c[a+24>>2]=b;return}function _B(a){a=a|0;return 0}function $B(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function aC(b,d){b=b|0;d=d|0;var e=0;c[b>>2]=9104;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=-1;c[b+16>>2]=0;c[b+20>>2]=0;a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;c[b+64>>2]=0;c[b+68>>2]=0;c[b+72>>2]=-1;c[b+76>>2]=0;c[b+80>>2]=0;a[b+193>>0]=0;a[b+194>>0]=1;a[b+192>>0]=(d|0)!=0^1;g[b+140>>2]=0.0;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;c[b+168>>2]=0;c[b+172>>2]=0;g[b+176>>2]=0.0;if(d){e=d;d=b+136|0;c[d>>2]=e;d=b+188|0;c[d>>2]=0;d=b+180|0;c[d>>2]=0;d=b+184|0;c[d>>2]=0;d=b+124|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;return}c[2703]=(c[2703]|0)+1;d=XE(95)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}FB(d);e=d;d=b+136|0;c[d>>2]=e;d=b+188|0;c[d>>2]=0;d=b+180|0;c[d>>2]=0;d=b+184|0;c[d>>2]=0;d=b+124|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;return}function bC(b){b=b|0;var d=0;c[b>>2]=9104;if((a[b+192>>0]|0)!=0?(d=c[b+136>>2]|0,Db[c[c[d>>2]>>2]&255](d),d=c[b+136>>2]|0,(d|0)!=0):0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}JC(b+64|0);JC(b+4|0);return}function cC(a){a=a|0;bC(a);YE(a);return}function dC(d,e,f,g,h,j,k,l,m){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0;o=i;i=i+48|0;c[2703]=(c[2703]|0)+1;l=XE(83)|0;if(!l)n=0;else{c[(l+4+15&-16)+-4>>2]=l;n=l+4+15&-16}c[n>>2]=h;b[n+4>>1]=j;b[n+6>>1]=k;h=n+16|0;c[h>>2]=c[e>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];h=n+32|0;c[h>>2]=c[f>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];c[n+8>>2]=0;h=n+56|0;c[h>>2]=0;k=n+52|0;c[k>>2]=0;c[o+16>>2]=c[e>>2];c[o+16+4>>2]=c[e+4>>2];c[o+16+8>>2]=c[e+8>>2];c[o+16+12>>2]=c[e+12>>2];c[o+16+16>>2]=c[f>>2];c[o+16+16+4>>2]=c[f+4>>2];c[o+16+16+8>>2]=c[f+8>>2];c[o+16+16+12>>2]=c[f+12>>2];c[n+60>>2]=c[d+144>>2];m=(c[d+188>>2]|0)+1|0;c[d+188>>2]=m;c[n+12>>2]=m;m=c[d+8>>2]|0;if(!m){c[2703]=(c[2703]|0)+1;m=XE(63)|0;if(!m)m=0;else{c[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}l=m;g=l+44|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(g|0))}else c[d+8>>2]=0;c[m+32>>2]=0;c[m+36>>2]=n;c[m+40>>2]=0;c[m>>2]=c[o+16>>2];c[m+4>>2]=c[o+16+4>>2];c[m+8>>2]=c[o+16+8>>2];c[m+12>>2]=c[o+16+12>>2];c[m+16>>2]=c[o+16+16>>2];c[m+20>>2]=c[o+16+20>>2];c[m+24>>2]=c[o+16+24>>2];c[m+28>>2]=c[o+16+28>>2];NC(d+4|0,c[d+4>>2]|0,m);c[d+16>>2]=(c[d+16>>2]|0)+1;c[n+48>>2]=m;l=d+124+(c[d+144>>2]<<2)|0;c[k>>2]=0;c[h>>2]=c[l>>2];m=c[l>>2]|0;if(m)c[m+52>>2]=n;c[l>>2]=n;if(a[d+193>>0]|0){i=o;return n|0}c[o>>2]=9168;c[o+4>>2]=d;c[o+8>>2]=n;zw(c[d+4>>2]|0,o+16|0,o);zw(c[d+64>>2]|0,o+16|0,o);i=o;return n|0}function eC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if((c[d+60>>2]|0)==2){g=c[d+48>>2]|0;MC(b+64|0,g)|0;f=c[b+68>>2]|0;if(f){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[b+68>>2]=g;c[b+76>>2]=(c[b+76>>2]|0)+-1}else{g=c[d+48>>2]|0;MC(b+4|0,g)|0;f=c[b+8>>2]|0;if(f){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[b+8>>2]=g;c[b+16>>2]=(c[b+16>>2]|0)+-1}f=c[d+52>>2]|0;g=c[d+56>>2]|0;if(!f)c[b+124+(c[d+60>>2]<<2)>>2]=g;else c[f+56>>2]=g;f=c[d+56>>2]|0;if(f)c[f+52>>2]=c[d+52>>2];f=c[b+136>>2]|0;jc[c[(c[f>>2]|0)+16>>2]&127](f,d,e);c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);a[b+194>>0]=1;return}function fC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[d>>2]=c[b+16>>2];c[d+4>>2]=c[b+16+4>>2];c[d+8>>2]=c[b+16+8>>2];c[d+12>>2]=c[b+16+12>>2];c[e>>2]=c[b+32>>2];c[e+4>>2]=c[b+32+4>>2];c[e+8>>2]=c[b+32+8>>2];c[e+12>>2]=c[b+32+12>>2];return}function gC(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;d=i;i=i+16|0;c[d>>2]=9204;c[d+4>>2]=e;pC(a+4|0,c[a+4>>2]|0,b,e+4|0,e+20|0,+g[e+32>>2],f,h,d);pC(a+64|0,c[a+64>>2]|0,b,e+4|0,e+20|0,+g[e+32>>2],f,h,d);i=d;return}function hC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+48|0;c[f+32>>2]=9240;c[f+32+4>>2]=e;c[f>>2]=c[b>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];c[f+16>>2]=c[d>>2];c[f+16+4>>2]=c[d+4>>2];c[f+16+8>>2]=c[d+8>>2];c[f+16+12>>2]=c[d+12>>2];zw(c[a+4>>2]|0,f,f+32|0);zw(c[a+64>>2]|0,f,f+32|0);i=f;return}function iC(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0.0,C=0,D=0,E=0,F=0.0,G=0.0,H=0.0;E=i;i=i+16|0;w=+g[e>>2];y=+g[e+4>>2];B=+g[e+8>>2];D=c[e+12>>2]|0;v=+g[f>>2];x=+g[f+4>>2];z=+g[f+8>>2];C=c[f+12>>2]|0;do if((c[d+60>>2]|0)==2){k=c[d+48>>2]|0;MC(b+64|0,k)|0;h=c[b+68>>2]|0;if(h){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[b+68>>2]=k;c[b+76>>2]=(c[b+76>>2]|0)+-1;k=c[b+8>>2]|0;if(!k){c[2703]=(c[2703]|0)+1;k=XE(63)|0;if(!k)k=0;else{c[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}h=k;j=h+44|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(j|0))}else c[b+8>>2]=0;c[k+32>>2]=0;c[k+36>>2]=d;c[k+40>>2]=0;g[k>>2]=w;g[k+4>>2]=y;g[k+8>>2]=B;c[k+12>>2]=D;g[k+16>>2]=v;g[k+20>>2]=x;g[k+24>>2]=z;c[k+28>>2]=C;NC(b+4|0,c[b+4>>2]|0,k);c[b+16>>2]=(c[b+16>>2]|0)+1;c[d+48>>2]=k;k=1}else{c[b+168>>2]=(c[b+168>>2]|0)+1;A=c[d+48>>2]|0;n=+g[A>>2];if(((((n<=v?(o=+g[A+16>>2],o>=w):0)?(m=+g[A+4>>2],m<=x):0)?(p=+g[A+20>>2],p>=y):0)?(q=+g[A+8>>2],q<=z):0)?(r=+g[A+24>>2],r>=B):0){H=+g[d+16>>2];G=+g[d+20>>2];F=+g[d+24>>2];u=+g[b+140>>2];s=(+g[d+32>>2]-H)*.5*u;t=u*((+g[d+36>>2]-G)*.5);u=u*((+g[d+40>>2]-F)*.5);s=w-H<0.0?-s:s;t=y-G<0.0?-t:t;u=B-F<0.0?-u:u;if(!(!(n<=w)|!(m<=y)|!(q<=B)|!(o>=v)|!(p>=x)|!(r>=z))){k=0;break}q=s>0.0?s+(v+.05000000074505806):v+.05000000074505806;r=s>0.0?w+-.05000000074505806:s+(w+-.05000000074505806);s=t>0.0?t+(x+.05000000074505806):x+.05000000074505806;o=t>0.0?y+-.05000000074505806:t+(y+-.05000000074505806);n=u>0.0?u+(z+.05000000074505806):z+.05000000074505806;m=u>0.0?B+-.05000000074505806:u+(B+-.05000000074505806);k=MC(b+4|0,A)|0;a:do if(k){j=c[b+12>>2]|0;if((j|0)<=-1){k=c[b+4>>2]|0;break}if((j|0)>0){l=0;h=k;while(1){k=c[h+32>>2]|0;l=l+1|0;if(!k){k=h;break a}if((l|0)>=(j|0))break;else h=k}}}else k=0;while(0);g[A>>2]=r;g[A+4>>2]=o;g[A+8>>2]=m;c[A+12>>2]=D;g[A+16>>2]=q;g[A+20>>2]=s;g[A+24>>2]=n;c[A+28>>2]=C;NC(b+4|0,k,A);c[b+172>>2]=(c[b+172>>2]|0)+1;k=1;break}k=MC(b+4|0,A)|0;b:do if(k){j=c[b+12>>2]|0;if((j|0)<=-1){k=c[b+4>>2]|0;break}if((j|0)>0){l=0;h=k;while(1){k=c[h+32>>2]|0;l=l+1|0;if(!k){k=h;break b}if((l|0)>=(j|0))break;else h=k}}}else k=0;while(0);g[A>>2]=w;g[A+4>>2]=y;g[A+8>>2]=B;c[A+12>>2]=D;g[A+16>>2]=v;g[A+20>>2]=x;g[A+24>>2]=z;c[A+28>>2]=C;NC(b+4|0,k,A);c[b+172>>2]=(c[b+172>>2]|0)+1;k=1}while(0);h=c[d+52>>2]|0;j=c[d+56>>2]|0;if(!h)c[b+124+(c[d+60>>2]<<2)>>2]=j;else c[h+56>>2]=j;h=c[d+56>>2]|0;if(h)c[h+52>>2]=c[d+52>>2];c[d+16>>2]=c[e>>2];c[d+16+4>>2]=c[e+4>>2];c[d+16+8>>2]=c[e+8>>2];c[d+16+12>>2]=c[e+12>>2];c[d+32>>2]=c[f>>2];c[d+32+4>>2]=c[f+4>>2];c[d+32+8>>2]=c[f+8>>2];c[d+32+12>>2]=c[f+12>>2];j=c[b+144>>2]|0;c[d+60>>2]=j;c[d+52>>2]=0;c[d+56>>2]=c[b+124+(j<<2)>>2];h=c[b+124+(j<<2)>>2]|0;if(h)c[h+52>>2]=d;c[b+124+(j<<2)>>2]=d;if(!k){i=E;return}a[b+194>>0]=1;if(a[b+193>>0]|0){i=E;return}c[E>>2]=9168;c[E+4>>2]=b;qC(b+64|0,c[b+64>>2]|0,c[d+48>>2]|0,E);qC(b+4|0,c[b+4>>2]|0,c[d+48>>2]|0,E);i=E;return}function jC(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+48|0;KC(b+4|0,((_(c[b+152>>2]|0,c[b+16>>2]|0)|0)/100|0)+1|0);if(c[b+164>>2]|0){p=((_(c[b+148>>2]|0,c[b+76>>2]|0)|0)/100|0)+1|0;KC(b+64|0,p);p=(c[b+164>>2]|0)-p|0;c[b+164>>2]=(p|0)<0?0:p}f=((c[b+144>>2]|0)+1|0)%2|0;c[b+144>>2]=f;f=c[b+124+(f<<2)>>2]|0;if(f){do{m=f+56|0;o=f;f=c[m>>2]|0;k=c[o+52>>2]|0;l=f;if(!k)c[b+124+(c[o+60>>2]<<2)>>2]=l;else c[k+56>>2]=l;e=c[m>>2]|0;if(e)c[e+52>>2]=c[o+52>>2];c[o+52>>2]=0;c[m>>2]=c[b+132>>2];e=c[b+132>>2]|0;if(e)c[e+52>>2]=o;c[b+132>>2]=o;e=c[o+48>>2]|0;MC(b+4|0,e)|0;k=c[b+8>>2]|0;if(k){c[2704]=(c[2704]|0)+1;YE(c[k+-4>>2]|0)}c[b+8>>2]=e;c[b+16>>2]=(c[b+16>>2]|0)+-1;c[r+16>>2]=c[o+16>>2];c[r+16+4>>2]=c[o+16+4>>2];c[r+16+8>>2]=c[o+16+8>>2];c[r+16+12>>2]=c[o+16+12>>2];c[r+16+16>>2]=c[o+32>>2];c[r+16+16+4>>2]=c[o+32+4>>2];c[r+16+16+8>>2]=c[o+32+8>>2];c[r+16+16+12>>2]=c[o+32+12>>2];e=c[b+68>>2]|0;if(!e){c[2703]=(c[2703]|0)+1;e=XE(63)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}l=e;k=l+44|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(k|0))}else c[b+68>>2]=0;c[e+32>>2]=0;c[e+36>>2]=o;c[e+40>>2]=0;c[e>>2]=c[r+16>>2];c[e+4>>2]=c[r+16+4>>2];c[e+8>>2]=c[r+16+8>>2];c[e+12>>2]=c[r+16+12>>2];c[e+16>>2]=c[r+16+16>>2];c[e+20>>2]=c[r+16+20>>2];c[e+24>>2]=c[r+16+24>>2];c[e+28>>2]=c[r+16+28>>2];NC(b+64|0,c[b+64>>2]|0,e);l=(c[b+76>>2]|0)+1|0;c[b+76>>2]=l;c[o+48>>2]=e;c[o+60>>2]=2}while((f|0)!=0);c[b+164>>2]=l;a[b+194>>0]=1}c[r>>2]=9168;c[r+4>>2]=b;if((a[b+193>>0]|0)!=0?(qC(b+4|0,c[b+4>>2]|0,c[b+64>>2]|0,r),(a[b+193>>0]|0)!=0):0){p=c[b+4>>2]|0;qC(b+4|0,p,p,r)}do if((a[b+194>>0]|0)!=0?(n=c[b+136>>2]|0,n=Hb[c[(c[n>>2]|0)+28>>2]&127](n)|0,j=c[n+4>>2]|0,(j|0)>0):0){f=(_(c[b+156>>2]|0,j)|0)/100|0;p=c[b+160>>2]|0;f=(p|0)>(f|0)?p:f;f=(j|0)<(f|0)?j:f;if((f|0)>0){e=0;do{l=((c[b+184>>2]|0)+e|0)%(j|0)|0;o=c[n+12>>2]|0;k=c[o+(l<<4)>>2]|0;l=c[o+(l<<4)+4>>2]|0;o=c[k+48>>2]|0;p=c[l+48>>2]|0;if(!(((((+g[o>>2]<=+g[p+16>>2]?+g[o+16>>2]>=+g[p>>2]:0)?+g[o+4>>2]<=+g[p+20>>2]:0)?+g[o+20>>2]>=+g[p+4>>2]:0)?+g[o+8>>2]<=+g[p+24>>2]:0)?+g[o+24>>2]>=+g[p+8>>2]:0)){j=c[b+136>>2]|0;Lb[c[(c[j>>2]|0)+12>>2]&31](j,k,l,d)|0;j=c[n+4>>2]|0;e=e+-1|0;f=f+-1|0}e=e+1|0}while((e|0)<(f|0));if((j|0)<=0){c[b+184>>2]=0;break}}c[b+184>>2]=((c[b+184>>2]|0)+f|0)%(j|0)|0}while(0);c[b+180>>2]=(c[b+180>>2]|0)+1;c[b+160>>2]=1;a[b+194>>0]=0;e=c[b+168>>2]|0;f=c[b+172>>2]|0;if(!e)h=0.0;else h=+(f>>>0)/+(e>>>0);g[b+176>>2]=h;c[b+172>>2]=f>>>1;c[b+168>>2]=e>>>1;p=c[b+136>>2]|0;if(!(Hb[c[(c[p>>2]|0)+56>>2]&127](p)|0)){i=r;return}p=c[b+136>>2]|0;p=Hb[c[(c[p>>2]|0)+28>>2]&127](p)|0;e=c[p+4>>2]|0;if((e|0)>1){yB(p,0,e+-1|0);l=0;k=0;j=0;m=0;q=44}else{l=0;k=0;j=0;n=0}while(1){if((q|0)==44){q=0;e=c[p+4>>2]|0;n=m}if((k|0)>=(e|0))break;e=c[p+12>>2]|0;f=e+(k<<4)|0;o=c[f>>2]|0;e=e+(k<<4)+4|0;m=c[e>>2]|0;if(!((o|0)==(l|0)&(m|0)==(n|0))){l=c[o+48>>2]|0;n=c[m+48>>2]|0;if(!(((((+g[l>>2]<=+g[n+16>>2]?+g[l+16>>2]>=+g[n>>2]:0)?+g[l+4>>2]<=+g[n+20>>2]:0)?+g[l+20>>2]>=+g[n+4>>2]:0)?+g[l+8>>2]<=+g[n+24>>2]:0)?+g[l+24>>2]>=+g[n+8>>2]:0))q=53}else{m=n;q=53}if((q|0)==53){n=c[b+136>>2]|0;jc[c[(c[n>>2]|0)+32>>2]&127](n,f,d);c[f>>2]=0;c[e>>2]=0;j=j+1|0}l=o;k=k+1|0;q=44}if((e|0)>1){yB(p,0,e+-1|0);m=c[p+4>>2]|0}else m=e;n=m-j|0;if((j|0)<0){if((c[p+8>>2]|0)<(n|0)){if((m|0)!=(j|0)){c[2703]=(c[2703]|0)+1;e=XE((n<<4|3)+16|0)|0;if(!e)j=0;else{c[(e+4+15&-16)+-4>>2]=e;j=e+4+15&-16}f=c[p+4>>2]|0;if((f|0)>0){e=0;do{d=c[p+12>>2]|0;c[j+(e<<4)>>2]=c[d+(e<<4)>>2];c[j+(e<<4)+4>>2]=c[d+(e<<4)+4>>2];c[j+(e<<4)+8>>2]=c[d+(e<<4)+8>>2];c[j+(e<<4)+12>>2]=c[d+(e<<4)+12>>2];e=e+1|0}while((e|0)!=(f|0));f=p+12|0}else f=p+12|0}else{f=p+12|0;j=0}e=c[f>>2]|0;if(e){if(a[p+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[f>>2]=0}a[p+16>>0]=1;c[f>>2]=j;c[p+8>>2]=n}else f=p+12|0;e=m;do{d=(c[f>>2]|0)+(e<<4)|0;e=e+1|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0}while((e|0)!=(n|0))}c[p+4>>2]=n;i=r;return}function kC(a){a=a|0;return c[a+136>>2]|0}function lC(a){a=a|0;return c[a+136>>2]|0}function mC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;n=c[a+4>>2]|0;a=c[a+64>>2]|0;do if(!n)if(!a){h=0.0;j=0.0;f=0.0;m=0.0;l=0.0;k=0.0;i=0.0;e=0.0}else{h=+g[a+16>>2];j=+g[a+20>>2];f=+g[a+24>>2];m=+g[a+28>>2];l=+g[a+4>>2];k=+g[a+8>>2];i=+g[a+12>>2];e=+g[a>>2]}else{e=+g[n>>2];if(!a){h=+g[n+16>>2];j=+g[n+20>>2];f=+g[n+24>>2];m=+g[n+28>>2];l=+g[n+4>>2];k=+g[n+8>>2];i=+g[n+12>>2];break}i=+g[a>>2];e=e<i?e:i;i=+g[n+16>>2];h=+g[a+16>>2];h=i>h?i:h;i=+g[n+4>>2];l=+g[a+4>>2];l=i<l?i:l;i=+g[n+20>>2];j=+g[a+20>>2];j=i>j?i:j;i=+g[n+8>>2];k=+g[a+8>>2];k=i<k?i:k;i=+g[n+24>>2];f=+g[a+24>>2];if(i>f){f=i;m=0.0;i=0.0}else{m=0.0;i=0.0}}while(0);g[b>>2]=e;g[b+4>>2]=l;g[b+8>>2]=k;g[b+12>>2]=i;g[d>>2]=h;g[d+4>>2]=j;g[d+8>>2]=f;g[d+12>>2]=m;return}function nC(b,d){b=b|0;d=d|0;if((c[b+16>>2]|0)!=(0-(c[b+76>>2]|0)|0))return;d=c[b+4>>2]|0;if(d)LC(b+4|0,d);d=c[b+8>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+8>>2]=0;c[b+12>>2]=-1;d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;c[b+20>>2]=0;d=c[b+64>>2]|0;if(d)LC(b+64|0,d);d=c[b+68>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+68>>2]=0;c[b+72>>2]=-1;d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;c[b+80>>2]=0;a[b+193>>0]=0;a[b+194>>0]=1;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;c[b+124>>2]=0;c[b+124+4>>2]=0;c[b+124+8>>2]=0;c[b+168>>2]=0;c[b+168+4>>2]=0;c[b+168+8>>2]=0;c[b+168+12>>2]=0;c[b+168+16>>2]=0;c[b+168+20>>2]=0;return}function oC(a){a=a|0;return}function pC(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=+j;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0;C=i;i=i+32|0;if(!d){i=C;return}q=c[b+44>>2]|0;if((q|0)<128){if((c[b+48>>2]|0)<128){c[2703]=(c[2703]|0)+1;n=XE(531)|0;if(!n)p=0;else{c[(n+4+15&-16)+-4>>2]=n;p=n+4+15&-16}o=c[b+44>>2]|0;if((o|0)>0){n=0;do{c[p+(n<<2)>>2]=c[(c[b+52>>2]|0)+(n<<2)>>2];n=n+1|0}while((n|0)!=(o|0))}n=c[b+52>>2]|0;if(n){if(a[b+56>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=p;c[b+48>>2]=128;o=b+52|0}else o=b+52|0;n=q;do{c[(c[o>>2]|0)+(n<<2)>>2]=0;n=n+1|0}while((n|0)!=128);x=b+48|0}else x=b+48|0;c[b+44>>2]=128;c[c[b+52>>2]>>2]=d;n=1;o=126;do{w=n+-1|0;q=c[b+52>>2]|0;v=c[q+(w<<2)>>2]|0;s=+g[v+4>>2]-+g[l+4>>2];u=+g[v+8>>2]-+g[l+8>>2];g[C>>2]=+g[v>>2]-+g[l>>2];g[C+4>>2]=s;g[C+8>>2]=u;g[C+12>>2]=0.0;u=+g[v+20>>2]-+g[k+4>>2];s=+g[v+24>>2]-+g[k+8>>2];g[C+16>>2]=+g[v+16>>2]-+g[k>>2];g[C+20>>2]=u;g[C+24>>2]=s;g[C+28>>2]=0.0;d=c[h>>2]|0;s=+g[e>>2];u=+g[f>>2];r=(+g[C+(d<<4)>>2]-s)*u;s=u*(+g[C+(1-d<<4)>>2]-s);d=c[h+4>>2]|0;u=+g[e+4>>2];D=+g[f+4>>2];t=(+g[C+(d<<4)+4>>2]-u)*D;u=D*(+g[C+(1-d<<4)+4>>2]-u);do if((!(t>s|r>u)?(y=t>r?t:r,B=u<s?u:s,d=c[h+8>>2]|0,A=+g[e+8>>2],r=+g[f+8>>2],z=(+g[C+(d<<4)+8>>2]-A)*r,A=r*(+g[C+(1-d<<4)+8>>2]-A),!(z>B|y>A)):0)?((A<B?A:B)>0.0?(z>y?z:y)<j:0):0){if(!(c[v+40>>2]|0)){Fb[c[(c[m>>2]|0)+12>>2]&127](m,v);n=w;break}if((w|0)>(o|0)){d=c[b+44>>2]|0;if((d|0)<(d<<1|0)){if((c[x>>2]|0)<(d<<1|0)){if(d){c[2703]=(c[2703]|0)+1;o=XE((d<<3|3)+16|0)|0;if(!o)o=0;else{c[(o+4+15&-16)+-4>>2]=o;o=o+4+15&-16}p=c[b+44>>2]|0;if((p|0)>0){q=0;do{c[o+(q<<2)>>2]=c[(c[b+52>>2]|0)+(q<<2)>>2];q=q+1|0}while((q|0)!=(p|0))}}else o=0;p=c[b+52>>2]|0;if(p){if(a[b+56>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[p+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=o;c[x>>2]=d<<1;q=d}else{o=q;q=d}do{c[o+(q<<2)>>2]=0;q=q+1|0;o=c[b+52>>2]|0}while((q|0)!=(d<<1|0))}else o=q;c[b+44>>2]=d<<1;q=o;o=(d<<1)+-2|0}c[q+(w<<2)>>2]=c[v+36>>2];c[(c[b+52>>2]|0)+(n<<2)>>2]=c[v+40>>2];n=n+1|0}else n=w;while(0)}while((n|0)!=0);i=C;return}function qC(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if(!((d|0)!=0&(e|0)!=0))return;if((c[b+24>>2]|0)<128?(c[b+28>>2]|0)<128:0){c[2703]=(c[2703]|0)+1;h=XE(1043)|0;if(!h)j=0;else{c[(h+4+15&-16)+-4>>2]=h;j=h+4+15&-16}h=c[b+24>>2]|0;if((h|0)>0){i=0;do{m=(c[b+32>>2]|0)+(i<<3)|0;n=c[m+4>>2]|0;o=j+(i<<3)|0;c[o>>2]=c[m>>2];c[o+4>>2]=n;i=i+1|0}while((i|0)!=(h|0))}h=c[b+32>>2]|0;if(h){if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=j;c[b+28>>2]=128;o=b+28|0}else o=b+28|0;c[b+24>>2]=128;h=c[b+32>>2]|0;c[h>>2]=d;c[h+4>>2]=e;h=1;e=124;do{l=h+-1|0;j=c[b+32>>2]|0;m=c[j+(l<<3)>>2]|0;n=c[j+(l<<3)+4>>2]|0;if((l|0)>(e|0)){k=c[b+24>>2]|0;if((k|0)<(k<<1|0)?(c[o>>2]|0)<(k<<1|0):0){if(k){c[2703]=(c[2703]|0)+1;j=XE((k<<4|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}e=c[b+24>>2]|0;if((e|0)>0){d=0;do{q=(c[b+32>>2]|0)+(d<<3)|0;p=c[q+4>>2]|0;i=j+(d<<3)|0;c[i>>2]=c[q>>2];c[i+4>>2]=p;d=d+1|0}while((d|0)!=(e|0))}}else j=0;i=c[b+32>>2]|0;if(i){if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[i+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=j;c[o>>2]=k<<1}c[b+24>>2]=k<<1;e=(k<<1)+-4|0}do if((m|0)==(n|0))if(!(c[m+40>>2]|0))h=l;else{n=c[m+36>>2]|0;c[j+(l<<3)>>2]=n;c[j+(l<<3)+4>>2]=n;n=h+1|0;l=c[b+32>>2]|0;k=c[m+40>>2]|0;c[l+(h<<3)>>2]=k;c[l+(h<<3)+4>>2]=k;l=c[b+32>>2]|0;k=c[m+40>>2]|0;c[l+(n<<3)>>2]=c[m+36>>2];c[l+(n<<3)+4>>2]=k;h=h+2|0}else if(((((+g[m>>2]<=+g[n+16>>2]?+g[m+16>>2]>=+g[n>>2]:0)?+g[m+4>>2]<=+g[n+20>>2]:0)?+g[m+20>>2]>=+g[n+4>>2]:0)?+g[m+8>>2]<=+g[n+24>>2]:0)?+g[m+24>>2]>=+g[n+8>>2]:0){k=(c[n+40>>2]|0)!=0;if(!(c[m+40>>2]|0))if(k){k=c[n+36>>2]|0;c[j+(l<<3)>>2]=m;c[j+(l<<3)+4>>2]=k;l=c[b+32>>2]|0;n=c[n+40>>2]|0;c[l+(h<<3)>>2]=m;c[l+(h<<3)+4>>2]=n;h=h+1|0;break}else{jc[c[(c[f>>2]|0)+8>>2]&127](f,m,n);h=l;break}else{i=j+(l<<3)|0;d=c[m+36>>2]|0;if(k){k=c[n+36>>2]|0;c[i>>2]=d;c[j+(l<<3)+4>>2]=k;k=h+1|0;l=c[b+32>>2]|0;d=c[n+36>>2]|0;c[l+(h<<3)>>2]=c[m+40>>2];c[l+(h<<3)+4>>2]=d;l=h+2|0;d=c[b+32>>2]|0;j=c[n+40>>2]|0;c[d+(k<<3)>>2]=c[m+36>>2];c[d+(k<<3)+4>>2]=j;k=c[b+32>>2]|0;n=c[n+40>>2]|0;c[k+(l<<3)>>2]=c[m+40>>2];c[k+(l<<3)+4>>2]=n;h=h+3|0;break}else{c[i>>2]=d;c[j+(l<<3)+4>>2]=n;l=c[b+32>>2]|0;c[l+(h<<3)>>2]=c[m+40>>2];c[l+(h<<3)+4>>2]=n;h=h+1|0;break}}}else h=l;while(0)}while((h|0)!=0);return}function rC(a){a=a|0;YE(a);return}function sC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if((b|0)==(d|0))return;e=c[(c[a+4>>2]|0)+136>>2]|0;Qb[c[(c[e>>2]|0)+8>>2]&63](e,c[b+36>>2]|0,c[d+36>>2]|0)|0;b=(c[a+4>>2]|0)+160|0;c[b>>2]=(c[b>>2]|0)+1;return}function tC(a,b){a=a|0;b=b|0;jc[c[(c[a>>2]|0)+8>>2]&127](a,b,c[(c[a+8>>2]|0)+48>>2]|0);return}function uC(a){a=a|0;YE(a);return}function vC(a,b){a=a|0;b=b|0;a=c[a+4>>2]|0;_b[c[(c[a>>2]|0)+8>>2]&31](a,c[b+36>>2]|0)|0;return}function wC(a){a=a|0;YE(a);return}function xC(a,b){a=a|0;b=b|0;a=c[a+4>>2]|0;_b[c[(c[a>>2]|0)+8>>2]&31](a,c[b+36>>2]|0)|0;return}function yC(d,f,h){d=d|0;f=f|0;h=h|0;var j=0,k=0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0,L=0.0,M=0.0,N=0.0;K=i;i=i+128|0;H=c[d+56>>2]|0;if((h-f|0)==1){if(!(a[d+60>>0]|0)){q=(c[d+96>>2]|0)+(H<<6)|0;r=(c[d+76>>2]|0)+(f<<6)|0;s=q+64|0;do{c[q>>2]=c[r>>2];q=q+4|0;r=r+4|0}while((q|0)<(s|0))}else{A=(c[d+136>>2]|0)+(H<<4)|0;x=(c[d+116>>2]|0)+(f<<4)|0;c[A>>2]=c[x>>2];c[A+4>>2]=c[x+4>>2];c[A+8>>2]=c[x+8>>2];c[A+12>>2]=c[x+12>>2]}c[d+56>>2]=(c[d+56>>2]|0)+1;i=K;return}if((h|0)>(f|0)){x=(a[d+60>>0]|0)==0;p=0.0;z=0.0;s=f;y=0.0;do{if(x){A=c[d+76>>2]|0;n=+g[A+(s<<6)>>2];m=+g[A+(s<<6)+4>>2];l=+g[A+(s<<6)+8>>2];u=+g[A+(s<<6)+16>>2];t=+g[A+(s<<6)+20>>2];v=+g[A+(s<<6)+24>>2]}else{A=c[d+116>>2]|0;E=+g[d+36>>2];D=+g[d+40>>2];C=+g[d+44>>2];u=+g[d+4>>2];t=+g[d+8>>2];v=+g[d+12>>2];n=+(e[A+(s<<4)>>1]|0)/E+u;m=+(e[A+(s<<4)+2>>1]|0)/D+t;l=+(e[A+(s<<4)+4>>1]|0)/C+v;u=+(e[A+(s<<4)+6>>1]|0)/E+u;t=+(e[A+(s<<4)+8>>1]|0)/D+t;v=+(e[A+(s<<4)+10>>1]|0)/C+v}p=p+(u+n)*.5;y=y+(t+m)*.5;z=z+(v+l)*.5;s=s+1|0}while((s|0)!=(h|0));C=1.0/+(h-f|0);E=p*C;D=y*C;C=z*C;if(x){s=c[d+76>>2]|0;m=0.0;p=0.0;r=f;l=0.0;do{u=(+g[s+(r<<6)+16>>2]+ +g[s+(r<<6)>>2])*.5-E;v=(+g[s+(r<<6)+20>>2]+ +g[s+(r<<6)+4>>2])*.5-D;z=(+g[s+(r<<6)+24>>2]+ +g[s+(r<<6)+8>>2])*.5-C;l=l+u*u;m=m+v*v;p=p+z*z;r=r+1|0}while((r|0)!=(h|0));n=+(h-f|0)}else{x=c[d+116>>2]|0;z=+g[d+36>>2];v=+g[d+40>>2];u=+g[d+44>>2];t=+g[d+4>>2];y=+g[d+8>>2];n=+g[d+12>>2];m=0.0;p=0.0;w=f;l=0.0;do{N=(+(e[x+(w<<4)+6>>1]|0)/z+t+(+(e[x+(w<<4)>>1]|0)/z+t))*.5-E;M=(+(e[x+(w<<4)+8>>1]|0)/v+y+(+(e[x+(w<<4)+2>>1]|0)/v+y))*.5-D;L=(+(e[x+(w<<4)+10>>1]|0)/u+n+(+(e[x+(w<<4)+4>>1]|0)/u+n))*.5-C;l=l+N*N;m=m+M*M;p=p+L*L;w=w+1|0}while((w|0)!=(h|0));n=+(h-f|0)}}else{p=0.0;m=0.0;n=+(h-f|0);l=0.0}C=1.0/(n+-1.0);z=l*C;v=m*C;C=p*C;A=z<v?(v<C?2:1):z<C?2:0;c[K+16>>2]=0;c[K+16+4>>2]=0;c[K+16+8>>2]=0;c[K+16+12>>2]=0;if((h|0)>(f|0)){w=(a[d+60>>0]|0)==0;m=0.0;l=0.0;n=0.0;x=f;do{if(w){s=c[d+76>>2]|0;v=+g[s+(x<<6)+16>>2];u=+g[s+(x<<6)+20>>2];t=+g[s+(x<<6)+24>>2];p=+g[s+(x<<6)>>2];y=+g[s+(x<<6)+4>>2];z=+g[s+(x<<6)+8>>2]}else{s=c[d+116>>2]|0;D=+g[d+36>>2];N=+g[d+40>>2];C=+g[d+44>>2];p=+g[d+4>>2];y=+g[d+8>>2];z=+g[d+12>>2];v=+(e[s+(x<<4)+6>>1]|0)/D+p;u=+(e[s+(x<<4)+8>>1]|0)/N+y;t=+(e[s+(x<<4)+10>>1]|0)/C+z;p=+(e[s+(x<<4)>>1]|0)/D+p;y=+(e[s+(x<<4)+2>>1]|0)/N+y;z=+(e[s+(x<<4)+4>>1]|0)/C+z}n=n+(v+p)*.5;m=(u+y)*.5+m;l=(t+z)*.5+l;x=x+1|0}while((x|0)!=(h|0));g[K+16>>2]=n;g[K+16+4>>2]=m;g[K+16+8>>2]=l;k=K+16|0}else{n=0.0;m=0.0;l=0.0;k=K+16|0}g[k>>2]=1.0/+(h-f|0)*n;g[K+16+4>>2]=1.0/+(h-f|0)*m;g[K+16+8>>2]=1.0/+(h-f|0)*l;z=+g[K+16+(A<<2)>>2];if((h|0)>(f|0)){x=f;j=f;do{s=(a[d+60>>0]|0)==0;if(s){w=c[d+76>>2]|0;p=+g[w+(x<<6)+16>>2];n=+g[w+(x<<6)+20>>2];m=+g[w+(x<<6)+24>>2];l=+g[w+(x<<6)>>2];t=+g[w+(x<<6)+4>>2];u=+g[w+(x<<6)+8>>2]}else{w=c[d+116>>2]|0;N=+g[d+36>>2];v=+g[d+40>>2];C=+g[d+44>>2];l=+g[d+4>>2];t=+g[d+8>>2];u=+g[d+12>>2];p=+(e[w+(x<<4)+6>>1]|0)/N+l;n=+(e[w+(x<<4)+8>>1]|0)/v+t;m=+(e[w+(x<<4)+10>>1]|0)/C+u;l=+(e[w+(x<<4)>>1]|0)/N+l;t=+(e[w+(x<<4)+2>>1]|0)/v+t;u=+(e[w+(x<<4)+4>>1]|0)/C+u}g[K>>2]=(p+l)*.5;g[K+4>>2]=(n+t)*.5;g[K+8>>2]=(m+u)*.5;g[K+12>>2]=0.0;if(+g[K+(A<<2)>>2]>z){if(s){o=c[d+76>>2]|0;k=o+(x<<6)|0;q=K+32|0;r=k;s=q+64|0;do{c[q>>2]=c[r>>2];q=q+4|0;r=r+4|0}while((q|0)<(s|0));q=k;r=o+(j<<6)|0;s=q+64|0;do{c[q>>2]=c[r>>2];q=q+4|0;r=r+4|0}while((q|0)<(s|0));q=(c[d+76>>2]|0)+(j<<6)|0;r=K+32|0;s=q+64|0;do{c[q>>2]=c[r>>2];q=q+4|0;r=r+4|0}while((q|0)<(s|0))}else{s=c[d+116>>2]|0;w=s+(x<<4)|0;c[K+96>>2]=c[w>>2];c[K+96+4>>2]=c[w+4>>2];c[K+96+8>>2]=c[w+8>>2];c[K+96+12>>2]=c[w+12>>2];s=s+(j<<4)|0;c[w>>2]=c[s>>2];c[w+4>>2]=c[s+4>>2];c[w+8>>2]=c[s+8>>2];c[w+12>>2]=c[s+12>>2];w=(c[d+116>>2]|0)+(j<<4)|0;c[w>>2]=c[K+96>>2];c[w+4>>2]=c[K+96+4>>2];c[w+8>>2]=c[K+96+8>>2];c[w+12>>2]=c[K+96+12>>2]}j=j+1|0}x=x+1|0}while((x|0)!=(h|0))}else j=f;if(!((j|0)>(((h-f|0)/3|0)+f|0)?(j|0)<(h+-1-((h-f|0)/3|0)|0):0))j=(h-f>>1)+f|0;G=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){A=(c[d+96>>2]|0)+(G<<6)|0;c[A>>2]=c[d+20>>2];c[A+4>>2]=c[d+20+4>>2];c[A+8>>2]=c[d+20+8>>2];c[A+12>>2]=c[d+20+12>>2]}else{A=c[d+136>>2]|0;z=(+g[d+24>>2]-+g[d+8>>2])*+g[d+40>>2];C=(+g[d+28>>2]-+g[d+12>>2])*+g[d+44>>2];b[A+(G<<4)>>1]=~~((+g[d+20>>2]-+g[d+4>>2])*+g[d+36>>2])&65534;b[A+(G<<4)+2>>1]=~~z&65534;b[A+(G<<4)+4>>1]=~~C&65534}k=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){A=(c[d+96>>2]|0)+(k<<6)+16|0;c[A>>2]=c[d+4>>2];c[A+4>>2]=c[d+4+4>>2];c[A+8>>2]=c[d+4+8>>2];c[A+12>>2]=c[d+4+12>>2]}else{A=c[d+136>>2]|0;v=+g[d+4>>2];z=+g[d+8>>2];C=+g[d+12>>2];z=(z-z)*+g[d+40>>2];C=(C-C)*+g[d+44>>2];b[A+(k<<4)+6>>1]=~~((v-v)*+g[d+36>>2]+1.0)&65535|1;b[A+(k<<4)+8>>1]=~~(z+1.0)&65535|1;b[A+(k<<4)+10>>1]=~~(C+1.0)&65535|1}F=c[d+56>>2]|0;if((h|0)>(f|0)){A=a[d+60>>0]|0;B=f;do{if(!(A<<24>>24)){x=c[d+76>>2]|0;z=+g[x+(B<<6)>>2];v=+g[x+(B<<6)+4>>2];u=+g[x+(B<<6)+8>>2];t=+g[x+(B<<6)+12>>2];p=+g[x+(B<<6)+16>>2];y=+g[x+(B<<6)+20>>2];n=+g[x+(B<<6)+24>>2];m=+g[x+(B<<6)+28>>2];x=c[d+96>>2]|0;if(z<+g[x+(F<<6)>>2])g[x+(F<<6)>>2]=z;if(v<+g[x+(F<<6)+4>>2])g[x+(F<<6)+4>>2]=v;if(u<+g[x+(F<<6)+8>>2])g[x+(F<<6)+8>>2]=u;if(t<+g[x+(F<<6)+12>>2])g[x+(F<<6)+12>>2]=t;if(+g[x+(F<<6)+16>>2]<p)g[x+(F<<6)+16>>2]=p;if(+g[x+(F<<6)+20>>2]<y)g[x+(F<<6)+20>>2]=y;if(+g[x+(F<<6)+24>>2]<n)g[x+(F<<6)+24>>2]=n;if(+g[x+(F<<6)+28>>2]<m)g[x+(F<<6)+28>>2]=m}else{x=c[d+116>>2]|0;D=+g[d+36>>2];u=+g[d+40>>2];y=+g[d+44>>2];l=+g[d+4>>2];v=+g[d+8>>2];p=+g[d+12>>2];m=+g[d+4>>2];z=+g[d+8>>2];N=+g[d+12>>2];n=+g[d+36>>2];C=+g[d+40>>2];t=+g[d+44>>2];o=~~((+(e[x+(B<<4)>>1]|0)/D+l-m)*n)&65534;r=~~((+(e[x+(B<<4)+4>>1]|0)/y+p-N)*t)&65534;w=~~((+(e[x+(B<<4)+2>>1]|0)/u+v-z)*C)&65534;k=(~~((+(e[x+(B<<4)+6>>1]|0)/D+l-m)*n+1.0)&65535|1)&65535;q=(~~((+(e[x+(B<<4)+10>>1]|0)/y+p-N)*t+1.0)&65535|1)&65535;x=(~~((+(e[x+(B<<4)+8>>1]|0)/u+v-z)*C+1.0)&65535|1)&65535;s=c[d+136>>2]|0;if((e[s+(F<<4)>>1]|0)>(o&65535))b[s+(F<<4)>>1]=o;if((e[s+(F<<4)+6>>1]|0)<(k&65535))b[s+(F<<4)+6>>1]=k;if((e[s+(F<<4)+2>>1]|0)>(w&65535))b[s+(F<<4)+2>>1]=w;if((e[s+(F<<4)+8>>1]|0)<(x&65535))b[s+(F<<4)+8>>1]=x;if((e[s+(F<<4)+4>>1]|0)>(r&65535))b[s+(F<<4)+4>>1]=r;if((e[s+(F<<4)+10>>1]|0)<(q&65535))b[s+(F<<4)+10>>1]=q}B=B+1|0}while((B|0)!=(h|0))}c[d+56>>2]=F+1;yC(d,f,j);B=c[d+56>>2]|0;yC(d,j,h);w=(c[d+56>>2]|0)-H|0;j=a[d+60>>0]|0;if(j<<24>>24!=0&(w<<4|0)>2048){A=c[d+136>>2]|0;s=c[A+(F+1<<4)+12>>2]|0;s=(s|0)>-1?1:0-s|0;x=c[A+(B<<4)+12>>2]|0;x=(x|0)>-1?1:0-x|0;if((s<<4|0)<2049){r=c[d+152>>2]|0;if((r|0)==(c[d+156>>2]|0)?(I=(r|0)!=0?r<<1:1,(r|0)<(I|0)):0){if(!I){j=r;q=0}else{c[2703]=(c[2703]|0)+1;k=XE(I<<5|19)|0;if(!k)k=0;else{c[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}j=c[d+152>>2]|0;q=k}if((j|0)>0){o=0;do{k=q+(o<<5)|0;f=(c[d+160>>2]|0)+(o<<5)|0;c[k>>2]=c[f>>2];c[k+4>>2]=c[f+4>>2];c[k+8>>2]=c[f+8>>2];c[k+12>>2]=c[f+12>>2];c[k+16>>2]=c[f+16>>2];c[k+20>>2]=c[f+20>>2];c[k+24>>2]=c[f+24>>2];c[k+28>>2]=c[f+28>>2];o=o+1|0}while((o|0)!=(j|0))}k=c[d+160>>2]|0;if(k){if(a[d+164>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[k+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=q;c[d+156>>2]=I;k=c[d+152>>2]|0}else k=r;c[d+152>>2]=k+1;q=(c[d+160>>2]|0)+(r<<5)|0;c[q>>2]=c[K+96>>2];c[q+4>>2]=c[K+96+4>>2];c[q+8>>2]=c[K+96+8>>2];c[q+12>>2]=c[K+96+12>>2];c[q+16>>2]=c[K+96+16>>2];c[q+20>>2]=c[K+96+20>>2];c[q+24>>2]=c[K+96+24>>2];c[q+28>>2]=c[K+96+28>>2];q=c[d+160>>2]|0;b[q+(r<<5)>>1]=b[A+(F+1<<4)>>1]|0;b[q+(r<<5)+2>>1]=b[A+(F+1<<4)+2>>1]|0;b[q+(r<<5)+4>>1]=b[A+(F+1<<4)+4>>1]|0;b[q+(r<<5)+6>>1]=b[A+(F+1<<4)+6>>1]|0;b[q+(r<<5)+8>>1]=b[A+(F+1<<4)+8>>1]|0;b[q+(r<<5)+10>>1]=b[A+(F+1<<4)+10>>1]|0;c[q+(r<<5)+12>>2]=F+1;c[q+(r<<5)+16>>2]=s;r=d+152|0}else r=d+152|0;if((x<<4|0)<2049){s=c[r>>2]|0;if((s|0)==(c[d+156>>2]|0)?(J=(s|0)!=0?s<<1:1,(s|0)<(J|0)):0){if(!J){j=s;o=0}else{c[2703]=(c[2703]|0)+1;k=XE(J<<5|19)|0;if(!k)k=0;else{c[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}j=c[r>>2]|0;o=k}if((j|0)>0){k=0;do{q=o+(k<<5)|0;f=(c[d+160>>2]|0)+(k<<5)|0;c[q>>2]=c[f>>2];c[q+4>>2]=c[f+4>>2];c[q+8>>2]=c[f+8>>2];c[q+12>>2]=c[f+12>>2];c[q+16>>2]=c[f+16>>2];c[q+20>>2]=c[f+20>>2];c[q+24>>2]=c[f+24>>2];c[q+28>>2]=c[f+28>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[d+160>>2]|0;if(k){if(a[d+164>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[k+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=o;c[d+156>>2]=J;j=c[r>>2]|0}else j=s;c[r>>2]=j+1;q=(c[d+160>>2]|0)+(s<<5)|0;c[q>>2]=c[K+32>>2];c[q+4>>2]=c[K+32+4>>2];c[q+8>>2]=c[K+32+8>>2];c[q+12>>2]=c[K+32+12>>2];c[q+16>>2]=c[K+32+16>>2];c[q+20>>2]=c[K+32+20>>2];c[q+24>>2]=c[K+32+24>>2];c[q+28>>2]=c[K+32+28>>2];q=c[d+160>>2]|0;b[q+(s<<5)>>1]=b[A+(B<<4)>>1]|0;b[q+(s<<5)+2>>1]=b[A+(B<<4)+2>>1]|0;b[q+(s<<5)+4>>1]=b[A+(B<<4)+4>>1]|0;b[q+(s<<5)+6>>1]=b[A+(B<<4)+6>>1]|0;b[q+(s<<5)+8>>1]=b[A+(B<<4)+8>>1]|0;b[q+(s<<5)+10>>1]=b[A+(B<<4)+10>>1]|0;c[q+(s<<5)+12>>2]=B;c[q+(s<<5)+16>>2]=x}c[d+168>>2]=c[r>>2];j=a[d+60>>0]|0}if(!(j<<24>>24)){c[(c[d+96>>2]|0)+(G<<6)+32>>2]=w;i=K;return}else{c[(c[d+136>>2]|0)+(G<<4)+12>>2]=0-w;i=K;return}}function zC(b){b=b|0;var d=0;c[b>>2]=9276;d=c[b+160>>2]|0;if(d){if(a[b+164>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+160>>2]=0}a[b+164>>0]=1;c[b+160>>2]=0;c[b+152>>2]=0;c[b+156>>2]=0;d=c[b+136>>2]|0;if(d){if(a[b+140>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d){if(a[b+120>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;d=c[b+76>>2]|0;if(!d){a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;d=b+72|0;c[d>>2]=0;return}if(a[b+80>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+76>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;d=b+72|0;c[d>>2]=0;return}function AC(a){a=a|0;zC(a);if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function BC(a,b,d,f){a=a|0;b=b|0;d=d|0;f=f|0;var g=0,h=0;while(1){g=c[a+12>>2]|0;if(!(((e[f>>1]|0)>=(e[a>>1]|0)?(e[d>>1]|0)<=(e[a+6>>1]|0):0)&(e[d+4>>1]|0)<=(e[a+10>>1]|0)&(e[f+4>>1]|0)>=(e[a+4>>1]|0)&(e[d+2>>1]|0)<=(e[a+8>>1]|0)&(e[f+2>>1]|0)>=(e[a+2>>1]|0))){h=6;break}if((g|0)>-1)break;BC(a+16|0,b,d,f);g=c[a+28>>2]|0;a=(g|0)>-1?a+32|0:a+(1-g<<4)|0}if((h|0)==6)return;jc[c[(c[b>>2]|0)+8>>2]&127](b,g>>21,g&2097151);return}function CC(a,b,d,e,f,h,j,k){a=a|0;b=b|0;d=d|0;e=+e;f=+f;h=+h;j=j|0;k=k|0;var l=0,m=0,n=0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0;V=i;i=i+32|0;R=+g[d>>2];T=+g[d+4>>2];S=+g[d+8>>2];s=+g[j>>2];t=+g[j+4>>2];u=+g[j+8>>2];o=+g[k>>2];p=+g[k+4>>2];r=+g[k+8>>2];J=1.0/+O(+((e-R)*(e-R)+(f-T)*(f-T)+(h-S)*(h-S)));G=(e-R)*J==0.0?999999984306749440.0:1.0/((e-R)*J);H=(f-T)*J==0.0?999999984306749440.0:1.0/((f-T)*J);I=(h-S)*J==0.0?999999984306749440.0:1.0/((h-S)*J);B=(R>e?e:R)+s;F=(T>f?f:T)+t;D=(S>h?h:S)+u;A=(R<e?e:R)+o;E=(T<f?f:T)+p;C=(S<h?h:S)+r;m=c[a+56>>2]|0;a:do if((m|0)>0){x=0;y=c[a+96>>2]|0;l=0;while(1){l=l+1|0;c[V>>2]=c[y>>2];c[V+4>>2]=c[y+4>>2];c[V+8>>2]=c[y+8>>2];c[V+12>>2]=c[y+12>>2];v=y+16|0;c[V+16>>2]=c[v>>2];c[V+16+4>>2]=c[v+4>>2];c[V+16+8>>2]=c[v+8>>2];c[V+16+12>>2]=c[v+12>>2];g[V>>2]=+g[V>>2]-o;g[V+4>>2]=+g[V+4>>2]-p;g[V+8>>2]=+g[V+8>>2]-r;g[V+16>>2]=+g[V+16>>2]-s;g[V+20>>2]=+g[V+20>>2]-t;g[V+24>>2]=+g[V+24>>2]-u;if(!(B>+g[v>>2])?!(A<+g[y>>2]):0)n=1;else n=0;if(!(!(D>+g[y+24>>2])?!(C<+g[y+8>>2]):0))n=0;if(((!(F>+g[y+20>>2])?!(E<+g[y+4>>2]|n^1):0)?(L=+g[d>>2],K=G*(+g[V+((G<0.0&1)<<4)>>2]-L),L=G*(+g[V+((G<0.0^1)<<4)>>2]-L),N=+g[d+4>>2],M=H*(+g[V+((H<0.0&1)<<4)+4>>2]-N),N=H*(+g[V+((H<0.0^1)<<4)+4>>2]-N),!(M>L|K>N)):0)?(z=M>K?M:K,U=N<L?N:L,Q=+g[d+8>>2],P=I*(+g[V+((I<0.0&1)<<4)+8>>2]-Q),Q=I*(+g[V+((I<0.0^1)<<4)+8>>2]-Q),!(P>U|z>Q)):0){q=(Q<U?Q:U)>0.0?(P>z?P:z)<(h-S)*((h-S)*J)+((e-R)*((e-R)*J)+(f-T)*((f-T)*J)):0;n=c[y+32>>2]|0;if(q&(n|0)==-1){jc[c[(c[b>>2]|0)+8>>2]&127](b,c[y+36>>2]|0,c[y+40>>2]|0);m=c[a+56>>2]|0;w=17}else{v=n;n=(n|0)==-1;w=16}}else{n=c[y+32>>2]|0;v=n;n=(n|0)==-1;q=0;w=16}if((w|0)==16){w=0;if(n|q)w=17;else{q=v+x|0;v=y+(v<<6)|0}}if((w|0)==17){q=x+1|0;v=y+64|0}if((q|0)>=(m|0))break a;o=+g[k>>2];p=+g[k+4>>2];r=+g[k+8>>2];s=+g[j>>2];t=+g[j+4>>2];u=+g[j+8>>2];x=q;y=v}}else l=0;while(0);if((c[2326]|0)>=(l|0)){i=V;return}c[2326]=l;i=V;return}function DC(a,d,f,h,j,k,l,m,n){a=a|0;d=d|0;f=f|0;h=+h;j=+j;k=+k;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0,J=0,K=0,L=0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0;V=i;i=i+32|0;z=+g[f>>2];A=+g[f+4>>2];B=+g[f+8>>2];M=1.0/+O(+((h-z)*(h-z)+(j-A)*(j-A)+(k-B)*(k-B)));D=(h-z)*M==0.0?999999984306749440.0:1.0/((h-z)*M);E=(j-A)*M==0.0?999999984306749440.0:1.0/((j-A)*M);F=(k-B)*M==0.0?999999984306749440.0:1.0/((k-B)*M);ia=(z>h?h:z)+ +g[l>>2];ga=(A>j?j:A)+ +g[l+4>>2];ha=(B>k?k:B)+ +g[l+8>>2];ea=(z<h?h:z)+ +g[m>>2];Y=(A<j?j:A)+ +g[m+4>>2];aa=(B<k?k:B)+ +g[m+8>>2];da=+g[a+4>>2];ia=ia<da?da:ia;X=+g[a+8>>2];ga=ga<X?X:ga;$=+g[a+12>>2];ha=ha<$?$:ha;fa=+g[a+20>>2];Z=+g[a+24>>2];ba=+g[a+28>>2];ca=+g[a+36>>2];W=+g[a+40>>2];_=+g[a+44>>2];I=~~(((fa<ia?fa:ia)-da)*ca)&65534;H=~~(((ba<ha?ba:ha)-$)*_)&65534;L=~~(((Z<ga?Z:ga)-X)*W)&65534;ea=ea<da?da:ea;Y=Y<X?X:Y;aa=aa<$?$:aa;J=(~~(((fa<ea?fa:ea)-da)*ca+1.0)&65535|1)&65535;G=(~~(((ba<aa?ba:aa)-$)*_+1.0)&65535|1)&65535;K=(~~(((Z<Y?Z:Y)-X)*W+1.0)&65535|1)&65535;if((n|0)>0){p=0;q=c[a+136>>2]|0;o=0;do{o=o+1|0;u=q+6|0;s=b[q>>1]|0;v=q+10|0;r=b[q+4>>1]|0;w=q+8|0;t=b[q+2>>1]|0;y=q+12|0;x=(c[y>>2]|0)>-1;if((((J&65535)>=(s&65535)?(I&65535)<=(e[u>>1]|0):0)&(H&65535)<=(e[v>>1]|0)&(G&65535)>=(r&65535)&(L&65535)<=(e[w>>1]|0)&(K&65535)>=(t&65535)?(_=+g[a+36>>2],X=+g[a+40>>2],Z=+g[a+44>>2],W=+g[a+4>>2],Y=+g[a+8>>2],Q=+g[a+12>>2],g[V+12>>2]=0.0,R=+(e[u>>1]|0)/_+W,N=+(e[w>>1]|0)/X+Y,P=+(e[v>>1]|0)/Z+Q,g[V+28>>2]=0.0,g[V>>2]=+(s&65535)/_+W-+g[m>>2],g[V+4>>2]=+(t&65535)/X+Y-+g[m+4>>2],g[V+8>>2]=+(r&65535)/Z+Q-+g[m+8>>2],g[V+16>>2]=R-+g[l>>2],g[V+20>>2]=N-+g[l+4>>2],g[V+24>>2]=P-+g[l+8>>2],P=+g[f>>2],N=D*(+g[V+((D<0.0&1)<<4)>>2]-P),P=D*(+g[V+((D<0.0^1)<<4)>>2]-P),R=+g[f+4>>2],Q=E*(+g[V+((E<0.0&1)<<4)+4>>2]-R),R=E*(+g[V+((E<0.0^1)<<4)+4>>2]-R),!(Q>P|N>R)):0)?(C=Q>N?Q:N,U=R<P?R:P,T=+g[f+8>>2],S=F*(+g[V+((F<0.0&1)<<4)+8>>2]-T),T=F*(+g[V+((F<0.0^1)<<4)+8>>2]-T),!(S>U|C>T)):0){r=(T<U?T:U)>0.0?(S>C?S:C)<(k-B)*((k-B)*M)+((h-z)*((h-z)*M)+(j-A)*((j-A)*M)):0;if(x&r){s=c[y>>2]|0;jc[c[(c[d>>2]|0)+8>>2]&127](d,s>>21,s&2097151);s=9}else s=8}else{r=0;s=8}if((s|0)==8){s=0;if(x|r)s=9;else{y=c[y>>2]|0;p=p-y|0;q=q+(0-y<<4)|0}}if((s|0)==9){p=p+1|0;q=q+16|0}}while((p|0)<(n|0))}else o=0;if((c[2326]|0)>=(o|0)){i=V;return}c[2326]=o;i=V;return}function EC(d,f,h,i){d=d|0;f=f|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0;c[d+168>>2]=c[d+152>>2];c[f>>2]=9276;c[f+52>>2]=282;a[f+60>>0]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;c[f+144>>2]=0;a[f+164>>0]=1;c[f+160>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+168>>2]=0;c[f+4>>2]=-8388609;c[f+8>>2]=-8388609;c[f+12>>2]=-8388609;g[f+16>>2]=0.0;c[f+20>>2]=2139095039;c[f+24>>2]=2139095039;c[f+28>>2]=2139095039;g[f+32>>2]=0.0;h=c[d+56>>2]|0;if(i){c[f+56>>2]=wF(h|0)|0;a[f+4>>0]=a[d+4+3>>0]|0;a[f+5>>0]=a[d+4+2>>0]|0;a[f+6>>0]=a[d+4+1>>0]|0;a[f+7>>0]=a[d+4>>0]|0;a[f+8>>0]=a[d+8+3>>0]|0;a[f+9>>0]=a[d+8+2>>0]|0;a[f+10>>0]=a[d+8+1>>0]|0;a[f+11>>0]=a[d+8>>0]|0;a[f+12>>0]=a[d+12+3>>0]|0;a[f+13>>0]=a[d+12+2>>0]|0;a[f+14>>0]=a[d+12+1>>0]|0;a[f+15>>0]=a[d+12>>0]|0;a[f+16>>0]=a[d+16+3>>0]|0;a[f+17>>0]=a[d+16+2>>0]|0;a[f+18>>0]=a[d+16+1>>0]|0;a[f+19>>0]=a[d+16>>0]|0;a[f+20>>0]=a[d+20+3>>0]|0;a[f+21>>0]=a[d+20+2>>0]|0;a[f+22>>0]=a[d+20+1>>0]|0;a[f+23>>0]=a[d+20>>0]|0;a[f+24>>0]=a[d+24+3>>0]|0;a[f+25>>0]=a[d+24+2>>0]|0;a[f+26>>0]=a[d+24+1>>0]|0;a[f+27>>0]=a[d+24>>0]|0;a[f+28>>0]=a[d+28+3>>0]|0;a[f+29>>0]=a[d+28+2>>0]|0;a[f+30>>0]=a[d+28+1>>0]|0;a[f+31>>0]=a[d+28>>0]|0;a[f+32>>0]=a[d+32+3>>0]|0;a[f+33>>0]=a[d+32+2>>0]|0;a[f+34>>0]=a[d+32+1>>0]|0;a[f+35>>0]=a[d+32>>0]|0;a[f+36>>0]=a[d+36+3>>0]|0;a[f+37>>0]=a[d+36+2>>0]|0;a[f+38>>0]=a[d+36+1>>0]|0;a[f+39>>0]=a[d+36>>0]|0;a[f+40>>0]=a[d+40+3>>0]|0;a[f+41>>0]=a[d+40+2>>0]|0;a[f+42>>0]=a[d+40+1>>0]|0;a[f+43>>0]=a[d+40>>0]|0;a[f+44>>0]=a[d+44+3>>0]|0;a[f+45>>0]=a[d+44+2>>0]|0;a[f+46>>0]=a[d+44+1>>0]|0;a[f+47>>0]=a[d+44>>0]|0;a[f+48>>0]=a[d+48+3>>0]|0;a[f+49>>0]=a[d+48+2>>0]|0;a[f+50>>0]=a[d+48+1>>0]|0;a[f+51>>0]=a[d+48>>0]|0;c[f+144>>2]=wF(c[d+144>>2]|0)|0;h=wF(c[d+168>>2]|0)|0}else{c[f+56>>2]=h;c[f+4>>2]=c[d+4>>2];c[f+4+4>>2]=c[d+4+4>>2];c[f+4+8>>2]=c[d+4+8>>2];c[f+4+12>>2]=c[d+4+12>>2];c[f+20>>2]=c[d+20>>2];c[f+20+4>>2]=c[d+20+4>>2];c[f+20+8>>2]=c[d+20+8>>2];c[f+20+12>>2]=c[d+20+12>>2];c[f+36>>2]=c[d+36>>2];c[f+36+4>>2]=c[d+36+4>>2];c[f+36+8>>2]=c[d+36+8>>2];c[f+36+12>>2]=c[d+36+12>>2];c[f+144>>2]=c[d+144>>2];h=c[d+168>>2]|0}c[f+168>>2]=h;a[f+60>>0]=a[d+60>>0]|0;l=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){h=c[f+96>>2]|0;if(h){if(a[f+100>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[f+96>>2]=0};c[f+88>>2]=0;c[f+88+4>>2]=0;c[f+88+8>>2]=0;a[f+88+12>>0]=0;c[f+96>>2]=f+172;c[f+88>>2]=l;c[f+92>>2]=l;if(i)if((l|0)>0){k=c[d+96>>2]|0;h=f+172|0;j=0;do{m=k+(j<<6)|0;o=h+(j<<6)|0;a[o>>0]=a[m+3>>0]|0;a[o+1>>0]=a[m+2>>0]|0;a[o+2>>0]=a[m+1>>0]|0;a[o+3>>0]=a[m>>0]|0;o=k+(j<<6)+4|0;m=h+(j<<6)+4|0;a[m>>0]=a[o+3>>0]|0;a[m+1>>0]=a[o+2>>0]|0;a[m+2>>0]=a[o+1>>0]|0;a[m+3>>0]=a[o>>0]|0;m=k+(j<<6)+8|0;o=h+(j<<6)+8|0;a[o>>0]=a[m+3>>0]|0;a[o+1>>0]=a[m+2>>0]|0;a[o+2>>0]=a[m+1>>0]|0;a[o+3>>0]=a[m>>0]|0;o=k+(j<<6)+12|0;h=h+(j<<6)+12|0;a[h>>0]=a[o+3>>0]|0;a[h+1>>0]=a[o+2>>0]|0;a[h+2>>0]=a[o+1>>0]|0;a[h+3>>0]=a[o>>0]|0;h=c[d+96>>2]|0;o=h+(j<<6)+16|0;m=c[f+96>>2]|0;n=m+(j<<6)+16|0;a[n>>0]=a[o+3>>0]|0;a[n+1>>0]=a[o+2>>0]|0;a[n+2>>0]=a[o+1>>0]|0;a[n+3>>0]=a[o>>0]|0;n=h+(j<<6)+20|0;o=m+(j<<6)+20|0;a[o>>0]=a[n+3>>0]|0;a[o+1>>0]=a[n+2>>0]|0;a[o+2>>0]=a[n+1>>0]|0;a[o+3>>0]=a[n>>0]|0;o=h+(j<<6)+24|0;n=m+(j<<6)+24|0;a[n>>0]=a[o+3>>0]|0;a[n+1>>0]=a[o+2>>0]|0;a[n+2>>0]=a[o+1>>0]|0;a[n+3>>0]=a[o>>0]|0;h=h+(j<<6)+28|0;m=m+(j<<6)+28|0;a[m>>0]=a[h+3>>0]|0;a[m+1>>0]=a[h+2>>0]|0;a[m+2>>0]=a[h+1>>0]|0;a[m+3>>0]=a[h>>0]|0;k=c[d+96>>2]|0;m=wF(c[k+(j<<6)+32>>2]|0)|0;h=c[f+96>>2]|0;c[h+(j<<6)+32>>2]=m;c[h+(j<<6)+36>>2]=wF(c[k+(j<<6)+36>>2]|0)|0;c[h+(j<<6)+40>>2]=wF(c[k+(j<<6)+40>>2]|0)|0;j=j+1|0}while((j|0)!=(l|0))}else h=f+172|0;else if((l|0)>0){h=f+172|0;k=c[d+96>>2]|0;j=0;do{h=h+(j<<6)|0;m=k+(j<<6)|0;c[h>>2]=c[m>>2];c[h+4>>2]=c[m+4>>2];c[h+8>>2]=c[m+8>>2];c[h+12>>2]=c[m+12>>2];h=(c[f+96>>2]|0)+(j<<6)+16|0;m=(c[d+96>>2]|0)+(j<<6)+16|0;c[h>>2]=c[m>>2];c[h+4>>2]=c[m+4>>2];c[h+8>>2]=c[m+8>>2];c[h+12>>2]=c[m+12>>2];k=c[d+96>>2]|0;h=c[f+96>>2]|0;c[h+(j<<6)+32>>2]=c[k+(j<<6)+32>>2];c[h+(j<<6)+36>>2]=c[k+(j<<6)+36>>2];c[h+(j<<6)+40>>2]=c[k+(j<<6)+40>>2];j=j+1|0}while((j|0)!=(l|0))}else h=f+172|0;if(h){if(a[f+100>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[f+96>>2]=0};c[f+88>>2]=0;c[f+88+4>>2]=0;c[f+88+8>>2]=0;a[f+88+12>>0]=0;h=l<<6}else{h=c[f+136>>2]|0;if(h){if(a[f+140>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[f+136>>2]=0};c[f+128>>2]=0;c[f+128+4>>2]=0;c[f+128+8>>2]=0;a[f+128+12>>0]=0;c[f+136>>2]=f+172;c[f+128>>2]=l;c[f+132>>2]=l;if(i){if((l|0)>0){j=c[d+136>>2]|0;h=0;do{k=e[j+(h<<4)>>1]|0;b[f+172+(h<<4)>>1]=k>>>8|k<<8;k=e[j+(h<<4)+2>>1]|0;b[f+172+(h<<4)+2>>1]=k>>>8|k<<8;k=e[j+(h<<4)+4>>1]|0;b[f+172+(h<<4)+4>>1]=k>>>8|k<<8;k=e[j+(h<<4)+6>>1]|0;b[f+172+(h<<4)+6>>1]=k>>>8|k<<8;k=e[j+(h<<4)+8>>1]|0;b[f+172+(h<<4)+8>>1]=k>>>8|k<<8;k=e[j+(h<<4)+10>>1]|0;b[f+172+(h<<4)+10>>1]=k>>>8|k<<8;c[f+172+(h<<4)+12>>2]=wF(c[j+(h<<4)+12>>2]|0)|0;h=h+1|0}while((h|0)!=(l|0))}}else if((l|0)>0){j=c[d+136>>2]|0;h=0;do{b[f+172+(h<<4)>>1]=b[j+(h<<4)>>1]|0;b[f+172+(h<<4)+2>>1]=b[j+(h<<4)+2>>1]|0;b[f+172+(h<<4)+4>>1]=b[j+(h<<4)+4>>1]|0;b[f+172+(h<<4)+6>>1]=b[j+(h<<4)+6>>1]|0;b[f+172+(h<<4)+8>>1]=b[j+(h<<4)+8>>1]|0;b[f+172+(h<<4)+10>>1]=b[j+(h<<4)+10>>1]|0;c[f+172+(h<<4)+12>>2]=c[j+(h<<4)+12>>2];h=h+1|0}while((h|0)!=(l|0))}c[f+128>>2]=0;c[f+128+4>>2]=0;c[f+128+8>>2]=0;a[f+128+12>>0]=0;h=l<<4}l=f+(h+172)|0;j=c[d+168>>2]|0;h=c[f+160>>2]|0;if(h){if(a[f+164>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[f+160>>2]=0};c[f+152>>2]=0;c[f+152+4>>2]=0;c[f+152+8>>2]=0;a[f+152+12>>0]=0;c[f+160>>2]=l;c[f+152>>2]=j;c[f+156>>2]=j;k=c[d+168>>2]|0;if(i){if((k|0)<=0){c[f>>2]=0;c[f+152>>2]=0;c[f+152+4>>2]=0;c[f+152+8>>2]=0;a[f+152+12>>0]=0;return 1}h=c[d+160>>2]|0;j=0;do{i=e[h+(j<<5)>>1]|0;b[l+(j<<5)>>1]=i>>>8|i<<8;i=e[h+(j<<5)+2>>1]|0;b[l+(j<<5)+2>>1]=i>>>8|i<<8;i=e[h+(j<<5)+4>>1]|0;b[l+(j<<5)+4>>1]=i>>>8|i<<8;i=e[h+(j<<5)+6>>1]|0;b[l+(j<<5)+6>>1]=i>>>8|i<<8;i=e[h+(j<<5)+8>>1]|0;b[l+(j<<5)+8>>1]=i>>>8|i<<8;i=e[h+(j<<5)+10>>1]|0;b[l+(j<<5)+10>>1]=i>>>8|i<<8;c[l+(j<<5)+12>>2]=wF(c[h+(j<<5)+12>>2]|0)|0;c[l+(j<<5)+16>>2]=wF(c[h+(j<<5)+16>>2]|0)|0;j=j+1|0}while((j|0)!=(k|0));c[f>>2]=0;c[f+152>>2]=0;c[f+152+4>>2]=0;c[f+152+8>>2]=0;a[f+152+12>>0]=0;return 1}else{if((k|0)<=0){c[f>>2]=0;c[f+152>>2]=0;c[f+152+4>>2]=0;c[f+152+8>>2]=0;a[f+152+12>>0]=0;return 1}h=c[d+160>>2]|0;j=0;do{b[l+(j<<5)>>1]=b[h+(j<<5)>>1]|0;b[l+(j<<5)+2>>1]=b[h+(j<<5)+2>>1]|0;b[l+(j<<5)+4>>1]=b[h+(j<<5)+4>>1]|0;b[l+(j<<5)+6>>1]=b[h+(j<<5)+6>>1]|0;b[l+(j<<5)+8>>1]=b[h+(j<<5)+8>>1]|0;b[l+(j<<5)+10>>1]=b[h+(j<<5)+10>>1]|0;c[l+(j<<5)+12>>2]=c[h+(j<<5)+12>>2];c[l+(j<<5)+16>>2]=c[h+(j<<5)+16>>2];c[l+(j<<5)+20>>2]=0;c[l+(j<<5)+24>>2]=0;c[l+(j<<5)+28>>2]=0;j=j+1|0}while((j|0)<(c[d+168>>2]|0));c[f>>2]=0;c[f+152>>2]=0;c[f+152+4>>2]=0;c[f+152+8>>2]=0;a[f+152+12>>0]=0;return 1}return 0}function FC(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+112|0;c[d+20>>2]=c[e+16>>2];c[d+24>>2]=c[e+20>>2];c[d+28>>2]=c[e+24>>2];c[d+32>>2]=c[e+28>>2];c[d+4>>2]=c[e>>2];c[d+8>>2]=c[e+4>>2];c[d+12>>2]=c[e+8>>2];c[d+16>>2]=c[e+12>>2];c[d+36>>2]=c[e+32>>2];c[d+40>>2]=c[e+36>>2];c[d+44>>2]=c[e+40>>2];c[d+48>>2]=c[e+44>>2];c[d+56>>2]=c[e+48>>2];a[d+60>>0]=(c[e+52>>2]|0)!=0&1;n=c[e+56>>2]|0;f=o+48|0;l=f+64|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(l|0));m=c[d+88>>2]|0;if((m|0)<(n|0)){if((c[d+92>>2]|0)<(n|0)){if(!n){g=m;j=0}else{c[2703]=(c[2703]|0)+1;g=XE(n<<6|19)|0;if(!g)h=0;else{c[(g+4+15&-16)+-4>>2]=g;h=g+4+15&-16}g=c[d+88>>2]|0;j=h}if((g|0)>0){h=0;do{f=j+(h<<6)|0;k=(c[d+96>>2]|0)+(h<<6)|0;l=f+64|0;do{c[f>>2]=c[k>>2];f=f+4|0;k=k+4|0}while((f|0)<(l|0));h=h+1|0}while((h|0)!=(g|0))}h=c[d+96>>2]|0;if(h){if(a[d+100>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=j;c[d+92>>2]=n;g=d+96|0}else g=d+96|0;h=m;do{f=(c[g>>2]|0)+(h<<6)|0;k=o+48|0;l=f+64|0;do{c[f>>2]=c[k>>2];f=f+4|0;k=k+4|0}while((f|0)<(l|0));h=h+1|0}while((h|0)!=(n|0))}c[d+88>>2]=n;if((n|0)>0){h=c[d+96>>2]|0;g=0;f=c[e+64>>2]|0;while(1){c[h+(g<<6)+16>>2]=c[f+16>>2];c[h+(g<<6)+20>>2]=c[f+20>>2];c[h+(g<<6)+24>>2]=c[f+24>>2];c[h+(g<<6)+28>>2]=c[f+28>>2];c[h+(g<<6)>>2]=c[f>>2];c[h+(g<<6)+4>>2]=c[f+4>>2];c[h+(g<<6)+8>>2]=c[f+8>>2];c[h+(g<<6)+12>>2]=c[f+12>>2];c[h+(g<<6)+32>>2]=c[f+32>>2];c[h+(g<<6)+36>>2]=c[f+36>>2];c[h+(g<<6)+40>>2]=c[f+40>>2];g=g+1|0;if((g|0)==(n|0))break;else f=f+48|0}}m=c[e+60>>2]|0;c[o+32>>2]=0;c[o+32+4>>2]=0;c[o+32+8>>2]=0;c[o+32+12>>2]=0;j=c[d+128>>2]|0;if((j|0)<(m|0)){if((c[d+132>>2]|0)<(m|0)){if(!m){g=j;f=0}else{c[2703]=(c[2703]|0)+1;g=XE((m<<4|3)+16|0)|0;if(!g)h=0;else{c[(g+4+15&-16)+-4>>2]=g;h=g+4+15&-16}g=c[d+128>>2]|0;f=h}if((g|0)>0){h=0;do{n=f+(h<<4)|0;l=(c[d+136>>2]|0)+(h<<4)|0;c[n>>2]=c[l>>2];c[n+4>>2]=c[l+4>>2];c[n+8>>2]=c[l+8>>2];c[n+12>>2]=c[l+12>>2];h=h+1|0}while((h|0)!=(g|0))}h=c[d+136>>2]|0;if(h){if(a[d+140>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=f;c[d+132>>2]=m;h=d+136|0}else h=d+136|0;g=j;do{n=(c[h>>2]|0)+(g<<4)|0;c[n>>2]=c[o+32>>2];c[n+4>>2]=c[o+32+4>>2];c[n+8>>2]=c[o+32+8>>2];c[n+12>>2]=c[o+32+12>>2];g=g+1|0}while((g|0)!=(m|0))}c[d+128>>2]=m;if((m|0)>0){h=c[d+136>>2]|0;g=0;f=c[e+68>>2]|0;while(1){c[h+(g<<4)+12>>2]=c[f+12>>2];b[h+(g<<4)+6>>1]=b[f+6>>1]|0;b[h+(g<<4)+8>>1]=b[f+8>>1]|0;b[h+(g<<4)+10>>1]=b[f+10>>1]|0;b[h+(g<<4)>>1]=b[f>>1]|0;b[h+(g<<4)+2>>1]=b[f+2>>1]|0;b[h+(g<<4)+4>>1]=b[f+4>>1]|0;g=g+1|0;if((g|0)==(m|0))break;else f=f+16|0}}c[d+144>>2]=c[e+76>>2];m=c[e+80>>2]|0;j=c[d+152>>2]|0;if((j|0)<(m|0)){if((c[d+156>>2]|0)<(m|0)){if(!m){g=j;f=0}else{c[2703]=(c[2703]|0)+1;g=XE(m<<5|19)|0;if(!g)h=0;else{c[(g+4+15&-16)+-4>>2]=g;h=g+4+15&-16}g=c[d+152>>2]|0;f=h}if((g|0)>0){h=0;do{n=f+(h<<5)|0;l=(c[d+160>>2]|0)+(h<<5)|0;c[n>>2]=c[l>>2];c[n+4>>2]=c[l+4>>2];c[n+8>>2]=c[l+8>>2];c[n+12>>2]=c[l+12>>2];c[n+16>>2]=c[l+16>>2];c[n+20>>2]=c[l+20>>2];c[n+24>>2]=c[l+24>>2];c[n+28>>2]=c[l+28>>2];h=h+1|0}while((h|0)!=(g|0))}h=c[d+160>>2]|0;if(h){if(a[d+164>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=f;c[d+156>>2]=m;h=d+160|0}else h=d+160|0;g=j;do{n=(c[h>>2]|0)+(g<<5)|0;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];c[n+16>>2]=c[o+16>>2];c[n+20>>2]=c[o+20>>2];c[n+24>>2]=c[o+24>>2];c[n+28>>2]=c[o+28>>2];g=g+1|0}while((g|0)!=(m|0))}c[d+152>>2]=m;if((m|0)<=0){i=o;return}g=c[d+160>>2]|0;h=0;f=c[e+72>>2]|0;while(1){b[g+(h<<5)+6>>1]=b[f+14>>1]|0;b[g+(h<<5)+8>>1]=b[f+16>>1]|0;b[g+(h<<5)+10>>1]=b[f+18>>1]|0;b[g+(h<<5)>>1]=b[f+8>>1]|0;b[g+(h<<5)+2>>1]=b[f+10>>1]|0;b[g+(h<<5)+4>>1]=b[f+12>>1]|0;c[g+(h<<5)+12>>2]=c[f>>2];c[g+(h<<5)+16>>2]=c[f+4>>2];h=h+1|0;if((h|0)==(m|0))break;else f=f+20|0}i=o;return}function GC(d,e){d=d|0;e=e|0;var f=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+112|0;g[d+20>>2]=+h[e+32>>3];g[d+24>>2]=+h[e+40>>3];g[d+28>>2]=+h[e+48>>3];g[d+32>>2]=+h[e+56>>3];g[d+4>>2]=+h[e>>3];g[d+8>>2]=+h[e+8>>3];g[d+12>>2]=+h[e+16>>3];g[d+16>>2]=+h[e+24>>3];g[d+36>>2]=+h[e+64>>3];g[d+40>>2]=+h[e+72>>3];g[d+44>>2]=+h[e+80>>3];g[d+48>>2]=+h[e+88>>3];c[d+56>>2]=c[e+96>>2];a[d+60>>0]=(c[e+100>>2]|0)!=0&1;p=c[e+104>>2]|0;f=q+48|0;n=f+64|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(n|0));o=c[d+88>>2]|0;if((o|0)<(p|0)){if((c[d+92>>2]|0)<(p|0)){if(!p){j=o;l=0}else{c[2703]=(c[2703]|0)+1;j=XE(p<<6|19)|0;if(!j)k=0;else{c[(j+4+15&-16)+-4>>2]=j;k=j+4+15&-16}j=c[d+88>>2]|0;l=k}if((j|0)>0){k=0;do{f=l+(k<<6)|0;m=(c[d+96>>2]|0)+(k<<6)|0;n=f+64|0;do{c[f>>2]=c[m>>2];f=f+4|0;m=m+4|0}while((f|0)<(n|0));k=k+1|0}while((k|0)!=(j|0))}k=c[d+96>>2]|0;if(k){if(a[d+100>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[k+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=l;c[d+92>>2]=p;j=d+96|0}else j=d+96|0;k=o;do{f=(c[j>>2]|0)+(k<<6)|0;m=q+48|0;n=f+64|0;do{c[f>>2]=c[m>>2];f=f+4|0;m=m+4|0}while((f|0)<(n|0));k=k+1|0}while((k|0)!=(p|0))}c[d+88>>2]=p;if((p|0)>0){k=c[d+96>>2]|0;j=0;f=c[e+112>>2]|0;while(1){g[k+(j<<6)+16>>2]=+h[f+32>>3];g[k+(j<<6)+20>>2]=+h[f+40>>3];g[k+(j<<6)+24>>2]=+h[f+48>>3];g[k+(j<<6)+28>>2]=+h[f+56>>3];g[k+(j<<6)>>2]=+h[f>>3];g[k+(j<<6)+4>>2]=+h[f+8>>3];g[k+(j<<6)+8>>2]=+h[f+16>>3];g[k+(j<<6)+12>>2]=+h[f+24>>3];c[k+(j<<6)+32>>2]=c[f+64>>2];c[k+(j<<6)+36>>2]=c[f+68>>2];c[k+(j<<6)+40>>2]=c[f+72>>2];j=j+1|0;if((j|0)==(p|0))break;else f=f+80|0}}o=c[e+108>>2]|0;c[q+32>>2]=0;c[q+32+4>>2]=0;c[q+32+8>>2]=0;c[q+32+12>>2]=0;l=c[d+128>>2]|0;if((l|0)<(o|0)){if((c[d+132>>2]|0)<(o|0)){if(!o){j=l;f=0}else{c[2703]=(c[2703]|0)+1;j=XE((o<<4|3)+16|0)|0;if(!j)k=0;else{c[(j+4+15&-16)+-4>>2]=j;k=j+4+15&-16}j=c[d+128>>2]|0;f=k}if((j|0)>0){k=0;do{p=f+(k<<4)|0;n=(c[d+136>>2]|0)+(k<<4)|0;c[p>>2]=c[n>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];c[p+12>>2]=c[n+12>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[d+136>>2]|0;if(k){if(a[d+140>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[k+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=f;c[d+132>>2]=o;k=d+136|0}else k=d+136|0;j=l;do{p=(c[k>>2]|0)+(j<<4)|0;c[p>>2]=c[q+32>>2];c[p+4>>2]=c[q+32+4>>2];c[p+8>>2]=c[q+32+8>>2];c[p+12>>2]=c[q+32+12>>2];j=j+1|0}while((j|0)!=(o|0))}c[d+128>>2]=o;if((o|0)>0){k=c[d+136>>2]|0;j=0;f=c[e+116>>2]|0;while(1){c[k+(j<<4)+12>>2]=c[f+12>>2];b[k+(j<<4)+6>>1]=b[f+6>>1]|0;b[k+(j<<4)+8>>1]=b[f+8>>1]|0;b[k+(j<<4)+10>>1]=b[f+10>>1]|0;b[k+(j<<4)>>1]=b[f>>1]|0;b[k+(j<<4)+2>>1]=b[f+2>>1]|0;b[k+(j<<4)+4>>1]=b[f+4>>1]|0;j=j+1|0;if((j|0)==(o|0))break;else f=f+16|0}}c[d+144>>2]=c[e+120>>2];o=c[e+124>>2]|0;l=c[d+152>>2]|0;if((l|0)<(o|0)){if((c[d+156>>2]|0)<(o|0)){if(!o){j=l;f=0}else{c[2703]=(c[2703]|0)+1;j=XE(o<<5|19)|0;if(!j)k=0;else{c[(j+4+15&-16)+-4>>2]=j;k=j+4+15&-16}j=c[d+152>>2]|0;f=k}if((j|0)>0){k=0;do{p=f+(k<<5)|0;n=(c[d+160>>2]|0)+(k<<5)|0;c[p>>2]=c[n>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];c[p+12>>2]=c[n+12>>2];c[p+16>>2]=c[n+16>>2];c[p+20>>2]=c[n+20>>2];c[p+24>>2]=c[n+24>>2];c[p+28>>2]=c[n+28>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[d+160>>2]|0;if(k){if(a[d+164>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[k+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=f;c[d+156>>2]=o;k=d+160|0}else k=d+160|0;j=l;do{p=(c[k>>2]|0)+(j<<5)|0;c[p>>2]=c[q>>2];c[p+4>>2]=c[q+4>>2];c[p+8>>2]=c[q+8>>2];c[p+12>>2]=c[q+12>>2];c[p+16>>2]=c[q+16>>2];c[p+20>>2]=c[q+20>>2];c[p+24>>2]=c[q+24>>2];c[p+28>>2]=c[q+28>>2];j=j+1|0}while((j|0)!=(o|0))}c[d+152>>2]=o;if((o|0)<=0){i=q;return}j=c[d+160>>2]|0;k=0;f=c[e+128>>2]|0;while(1){b[j+(k<<5)+6>>1]=b[f+14>>1]|0;b[j+(k<<5)+8>>1]=b[f+16>>1]|0;b[j+(k<<5)+10>>1]=b[f+18>>1]|0;b[j+(k<<5)>>1]=b[f+8>>1]|0;b[j+(k<<5)+2>>1]=b[f+10>>1]|0;b[j+(k<<5)+4>>1]=b[f+12>>1]|0;c[j+(k<<5)+12>>2]=c[f>>2];c[j+(k<<5)+16>>2]=c[f+4>>2];k=k+1|0;if((k|0)==(o|0))break;else f=f+20|0}i=q;return}
function sy(d,f){d=d|0;f=f|0;var h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0,G=0,H=0.0,I=0.0,J=0,K=0,L=0,M=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0.0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0.0,ha=0.0;fa=i;i=i+336|0;h=c[d+52>>2]|0;if((h|0)!=0?(Db[c[c[h>>2]>>2]&255](h),j=c[d+52>>2]|0,(j|0)!=0):0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0)}c[2703]=(c[2703]|0)+1;h=XE(151)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h>>2]=10688;a[h+20>>0]=1;c[h+16>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;a[h+40>>0]=1;c[h+36>>2]=0;c[h+28>>2]=0;c[h+32>>2]=0;a[h+60>>0]=1;c[h+56>>2]=0;c[h+48>>2]=0;c[h+52>>2]=0;c[d+52>>2]=h;j=0;K=0;ea=0;l=0;while(1){if((j|0)>=(Hb[c[(c[d>>2]|0)+96>>2]&127](d)|0))break;do if((K|0)==(l|0)){p=(l|0)!=0?l<<1:1;if((l|0)<(p|0)){if((p|0)!=0?(c[2703]=(c[2703]|0)+1,w=XE((p<<4|3)+16|0)|0,(w|0)!=0):0){c[(w+4+15&-16)+-4>>2]=w;n=w+4+15&-16}else n=0;if((l|0)<=0){if(!ea){m=l;o=n;break}}else{o=0;do{P=n+(o<<4)|0;M=ea+(o<<4)|0;c[P>>2]=c[M>>2];c[P+4>>2]=c[M+4>>2];c[P+8>>2]=c[M+8>>2];c[P+12>>2]=c[M+12>>2];o=o+1|0}while((o|0)!=(l|0))}c[2704]=(c[2704]|0)+1;YE(c[ea+-4>>2]|0);m=l;o=n}else{m=l;o=ea;p=l}}else{m=K;o=ea;p=l}while(0);ea=o+(K<<4)|0;c[ea>>2]=c[fa+168>>2];c[ea+4>>2]=c[fa+168+4>>2];c[ea+8>>2]=c[fa+168+8>>2];c[ea+12>>2]=c[fa+168+12>>2];jc[c[(c[d>>2]|0)+108>>2]&127](d,j,ea);j=j+1|0;K=m+1|0;ea=o;l=p}a[fa+184+16>>0]=1;da=fa+184+12|0;c[da>>2]=0;c[fa+184+4>>2]=0;c[fa+184+8>>2]=0;a[fa+184+36>>0]=1;ca=fa+184+32|0;c[ca>>2]=0;c[fa+184+24>>2]=0;c[fa+184+28>>2]=0;a[fa+184+56>>0]=1;ba=fa+184+52|0;c[ba>>2]=0;c[fa+184+44>>2]=0;c[fa+184+48>>2]=0;if(f){if((K|0)>0){J=0;o=0;n=0;m=0;while(1){p=J;J=J+1|0;if((J|0)<(K|0)){f=ea+(p<<4)|0;y=ea+(p<<4)+4|0;l=ea+(p<<4)+8|0;w=J;p=n;do{n=w;w=w+1|0;if((w|0)<(K|0)){G=ea+(n<<4)|0;j=ea+(n<<4)+4|0;F=ea+(n<<4)+8|0;h=w;do{D=+g[f>>2];t=+g[G>>2]-D;q=+g[y>>2];I=+g[j>>2]-q;s=+g[l>>2];r=+g[F>>2]-s;D=+g[ea+(h<<4)>>2]-D;q=+g[ea+(h<<4)+4>>2]-q;s=+g[ea+(h<<4)+8>>2]-s;x=1.0;z=0;while(1){E=(I*s-r*q)*x;u=(r*D-t*s)*x;v=(t*q-I*D)*x;a:do if(v*v+(E*E+u*u)>9.999999747378752e-05){x=1.0/+O(+(v*v+(E*E+u*u)));if((o|0)>0){C=0;do{if(E*x*+g[m+(C<<4)>>2]+u*x*+g[m+(C<<4)+4>>2]+v*x*+g[m+(C<<4)+8>>2]>.9990000128746033)break a;C=C+1|0}while((C|0)<(o|0))}H=E*x*+g[f>>2]+u*x*+g[y>>2]+v*x*+g[l>>2];C=0;do{if(E*x*+g[ea+(C<<4)>>2]+u*x*+g[ea+(C<<4)+4>>2]+v*x*+g[ea+(C<<4)+8>>2]-H+-.009999999776482582>0.0)break a;C=C+1|0}while((C|0)<(K|0));do if((o|0)==(p|0)){B=(p|0)!=0?p<<1:1;if((p|0)<(B|0)){do if(!B)A=0;else{c[2703]=(c[2703]|0)+1;C=XE((B<<4|3)+16|0)|0;if(!C){A=0;break}c[(C+4+15&-16)+-4>>2]=C;A=C+4+15&-16}while(0);if((p|0)<=0){if(!m){C=p;p=B;m=A;break}}else{C=0;do{P=A+(C<<4)|0;M=m+(C<<4)|0;c[P>>2]=c[M>>2];c[P+4>>2]=c[M+4>>2];c[P+8>>2]=c[M+8>>2];c[P+12>>2]=c[M+12>>2];C=C+1|0}while((C|0)!=(p|0))}c[2704]=(c[2704]|0)+1;YE(c[m+-4>>2]|0);C=p;p=B;m=A}else C=p}else C=o;while(0);g[m+(C<<4)>>2]=E*x;g[m+(C<<4)+4>>2]=u*x;g[m+(C<<4)+8>>2]=v*x;g[m+(C<<4)+12>>2]=-H;o=o+1|0}while(0);z=z+1|0;if((z|0)==2)break;else x=-1.0}h=h+1|0}while((h|0)!=(K|0))}}while((w|0)!=(K|0))}else p=n;if((J|0)==(K|0))break;else n=p}if((o|0)>0){w=0;j=0;h=0;while(1){P=m+(w<<4)|0;c[fa+120>>2]=c[P>>2];c[fa+120+4>>2]=c[P+4>>2];c[fa+120+8>>2]=c[P+8>>2];v=+g[m+(w<<4)+12>>2];v=v-+Tb[c[(c[d>>2]|0)+48>>2]&15](d);do if((w|0)==(j|0)){l=(j|0)!=0?j<<1:1;if((j|0)<(l|0)){if((l|0)!=0?(c[2703]=(c[2703]|0)+1,L=XE((l<<4|3)+16|0)|0,(L|0)!=0):0){c[(L+4+15&-16)+-4>>2]=L;n=L+4+15&-16}else n=0;if((j|0)<=0){if(!h){p=j;break}}else{p=0;do{P=n+(p<<4)|0;M=h+(p<<4)|0;c[P>>2]=c[M>>2];c[P+4>>2]=c[M+4>>2];c[P+8>>2]=c[M+8>>2];c[P+12>>2]=c[M+12>>2];p=p+1|0}while((p|0)!=(j|0))}c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0);p=j}else{p=j;l=j;n=h}}else{p=w;l=j;n=h}while(0);P=n+(p<<4)|0;c[P>>2]=c[fa+120>>2];c[P+4>>2]=c[fa+120+4>>2];c[P+8>>2]=c[fa+120+8>>2];g[n+(p<<4)+12>>2]=v;w=w+1|0;if((w|0)<(o|0)){j=l;h=n}else break}if((w|0)>0){j=0;p=0;o=0;l=0;do{h=j;j=j+1|0;if((j|0)<(w|0)){G=j;do{z=G;G=G+1|0;if((G|0)<(w|0)){F=G;C=o;A=l;while(1){t=+g[n+(z<<4)+4>>2];x=+g[n+(F<<4)+8>>2];v=+g[n+(z<<4)+8>>2];s=+g[n+(F<<4)+4>>2];r=+g[n+(F<<4)>>2];q=+g[n+(z<<4)>>2];u=+g[n+(h<<4)+8>>2];D=+g[n+(h<<4)+4>>2];E=+g[n+(h<<4)>>2];b:do if((((s*q-t*r)*(s*q-t*r)+((t*x-v*s)*(t*x-v*s)+(v*r-x*q)*(v*r-x*q))>9.999999747378752e-05?(r*D-s*E)*(r*D-s*E)+((s*u-x*D)*(s*u-x*D)+(x*E-r*u)*(x*E-r*u))>9.999999747378752e-05:0)?(t*E-q*D)*(t*E-q*D)+((v*D-t*u)*(v*D-t*u)+(q*u-v*E)*(q*u-v*E))>9.999999747378752e-05:0)?(V=u*(s*q-t*r)+(D*(v*r-x*q)+(t*x-v*s)*E),+N(+V)>9.999999974752427e-07):0){ga=+g[n+(h<<4)+12>>2];I=+g[n+(z<<4)+12>>2];ha=+g[n+(F<<4)+12>>2];H=-1.0/V*((v*D-t*u)*ha+((t*x-v*s)*ga+(s*u-x*D)*I));v=-1.0/V*((q*u-v*E)*ha+((v*r-x*q)*ga+(x*E-r*u)*I));x=-1.0/V*((t*E-q*D)*ha+((s*q-t*r)*ga+(r*D-s*E)*I));o=0;do{if(+g[n+(o<<4)+12>>2]+(H*+g[n+(o<<4)>>2]+v*+g[n+(o<<4)+4>>2]+x*+g[n+(o<<4)+8>>2])+-.009999999776482582>0.0){o=C;l=A;break b}o=o+1|0}while((o|0)<(w|0));do if((p|0)==(A|0)){l=(A|0)!=0?A<<1:1;if((A|0)>=(l|0)){B=A;o=C;l=A;break}do if(!l)o=0;else{c[2703]=(c[2703]|0)+1;o=XE((l<<4|3)+16|0)|0;if(!o){o=0;break}c[(o+4+15&-16)+-4>>2]=o;o=o+4+15&-16}while(0);if((A|0)<=0){if(!C){B=A;break}}else{y=0;do{P=o+(y<<4)|0;M=C+(y<<4)|0;c[P>>2]=c[M>>2];c[P+4>>2]=c[M+4>>2];c[P+8>>2]=c[M+8>>2];c[P+12>>2]=c[M+12>>2];y=y+1|0}while((y|0)!=(A|0))}c[2704]=(c[2704]|0)+1;YE(c[C+-4>>2]|0);B=A}else{B=p;o=C;l=A}while(0);g[o+(B<<4)>>2]=H;g[o+(B<<4)+4>>2]=v;g[o+(B<<4)+8>>2]=x;g[o+(B<<4)+12>>2]=0.0;p=p+1|0}else{o=C;l=A}while(0);F=F+1|0;if((F|0)==(w|0))break;else{C=o;A=l}}}}while((G|0)!=(w|0))}}while((j|0)!=(w|0))}else{p=0;o=0}}else{n=0;p=0;o=0}}else{m=0;n=0;p=0;o=0}oE(fa+184|0,o,p);if(o){c[2704]=(c[2704]|0)+1;YE(c[o+-4>>2]|0)}if(n){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}if(m){c[2704]=(c[2704]|0)+1;YE(c[m+-4>>2]|0)}}else oE(fa+184|0,ea,K);J=c[fa+184+44>>2]|0;if((J|0)>0){c[2703]=(c[2703]|0)+1;j=XE((J<<4|3)+16|0)|0;if(!j)h=0;else{c[(j+4+15&-16)+-4>>2]=j;h=j+4+15&-16}j=0;do{P=h+(j<<4)|0;c[P>>2]=c[fa+104>>2];c[P+4>>2]=c[fa+104+4>>2];c[P+8>>2]=c[fa+104+8>>2];c[P+12>>2]=c[fa+104+12>>2];j=j+1|0}while((j|0)!=(J|0));Y=h}else Y=0;a[fa+80+16>>0]=1;Z=fa+80+12|0;c[Z>>2]=0;_=fa+80+4|0;c[_>>2]=0;c[fa+80+8>>2]=0;n=fa+312|0;l=n+19|0;do{a[n>>0]=0;n=n+1|0}while((n|0)<(l|0));if((J|0)<0)nb();if((J|0)>0){zy(fa+80|0,J);p=c[Z>>2]|0;o=0;do{n=p+(o*36|0)|0;a[n+16>>0]=1;c[n+4>>2]=0;c[n+4+4>>2]=0;c[n+4+8>>2]=0;n=n+20|0;m=fa+312+3|0;l=n+16|0;do{a[n>>0]=a[m>>0]|0;n=n+1|0;m=m+1|0}while((n|0)<(l|0));o=o+1|0}while((o|0)!=(J|0))}c[_>>2]=J;l=c[fa+184+4>>2]|0;w=c[d+52>>2]|0;m=c[w+8>>2]|0;if((m|0)<(l|0)){if((c[w+12>>2]|0)<(l|0)){if(!l){o=m;n=0}else{c[2703]=(c[2703]|0)+1;p=XE((l<<4|3)+16|0)|0;if(!p)p=0;else{c[(p+4+15&-16)+-4>>2]=p;p=p+4+15&-16}o=c[w+8>>2]|0;n=p}if((o|0)>0){p=0;do{P=n+(p<<4)|0;M=(c[w+16>>2]|0)+(p<<4)|0;c[P>>2]=c[M>>2];c[P+4>>2]=c[M+4>>2];c[P+8>>2]=c[M+8>>2];c[P+12>>2]=c[M+12>>2];p=p+1|0}while((p|0)!=(o|0))}p=c[w+16>>2]|0;if(p){if(a[w+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[p+-4>>2]|0)}c[w+16>>2]=0}a[w+20>>0]=1;c[w+16>>2]=n;c[w+12>>2]=l;o=w+16|0}else o=w+16|0;p=m;do{P=(c[o>>2]|0)+(p<<4)|0;c[P>>2]=c[fa+64>>2];c[P+4>>2]=c[fa+64+4>>2];c[P+8>>2]=c[fa+64+8>>2];c[P+12>>2]=c[fa+64+12>>2];p=p+1|0}while((p|0)!=(l|0))}c[w+8>>2]=l;if((l|0)>0){p=0;do{P=(c[(c[d+52>>2]|0)+16>>2]|0)+(p<<4)|0;M=(c[da>>2]|0)+(p<<4)|0;c[P>>2]=c[M>>2];c[P+4>>2]=c[M+4>>2];c[P+8>>2]=c[M+8>>2];c[P+12>>2]=c[M+12>>2];p=p+1|0}while((p|0)!=(l|0))}if((J|0)>0){w=c[Z>>2]|0;f=0;do{B=(c[ca>>2]|0)+((c[(c[ba>>2]|0)+(f<<2)>>2]|0)*12|0)|0;j=w+(f*36|0)+4|0;F=w+(f*36|0)+8|0;l=w+(f*36|0)+12|0;h=w+(f*36|0)+16|0;p=c[j>>2]|0;z=B;o=0;do{G=z+4|0;C=c[z+((c[G>>2]|0)*12|0)+8>>2]|0;if((p|0)==(c[F>>2]|0)?(W=(p|0)!=0?p<<1:1,(p|0)<(W|0)):0){if(!W)n=0;else{c[2703]=(c[2703]|0)+1;p=XE((W<<2|3)+16|0)|0;if(!p)n=0;else{c[(p+4+15&-16)+-4>>2]=p;n=p+4+15&-16}p=c[j>>2]|0}A=c[l>>2]|0;if((p|0)<=0){if(A)$=131}else{y=0;do{c[n+(y<<2)>>2]=c[A+(y<<2)>>2];y=y+1|0}while((y|0)!=(p|0));$=131}if(($|0)==131){$=0;if(a[h>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[A+-4>>2]|0)}c[l>>2]=0;p=c[j>>2]|0}a[h>>0]=1;c[l>>2]=n;c[F>>2]=W}c[(c[l>>2]|0)+(p<<2)>>2]=C;p=(c[j>>2]|0)+1|0;c[j>>2]=p;M=c[z+8>>2]|0;P=c[da>>2]|0;u=+g[P+(M<<4)>>2]-+g[P+(C<<4)>>2];t=+g[P+(M<<4)+4>>2]-+g[P+(C<<4)+4>>2];v=+g[P+(M<<4)+8>>2]-+g[P+(C<<4)+8>>2];x=1.0/+O(+(u*u+t*t+v*v));if((o|0)<2){g[fa+264+(o<<4)>>2]=u*x;g[fa+264+(o<<4)+4>>2]=t*x;g[fa+264+(o<<4)+8>>2]=v*x;g[fa+264+(o<<4)+12>>2]=0.0;o=o+1|0}P=c[G>>2]|0;z=z+(((c[z+(P*12|0)>>2]|0)+P|0)*12|0)|0}while((z|0)!=(B|0));p=Y+(f<<4)|0;if((o|0)==2){u=+g[fa+264+4>>2];E=+g[fa+264+24>>2];v=+g[fa+264+8>>2];x=+g[fa+264+20>>2];D=+g[fa+264+16>>2];t=+g[fa+264>>2];M=Y+(f<<4)+4|0;P=Y+(f<<4)+8|0;g[Y+(f<<4)+12>>2]=0.0;H=1.0/+O(+((u*E-v*x)*(u*E-v*x)+(v*D-E*t)*(v*D-E*t)+(x*t-u*D)*(x*t-u*D)));g[p>>2]=(u*E-v*x)*H;g[M>>2]=(v*D-E*t)*H;g[P>>2]=(x*t-u*D)*H;g[w+(f*36|0)+20>>2]=(u*E-v*x)*H;c[w+(f*36|0)+24>>2]=c[M>>2];c[w+(f*36|0)+28>>2]=c[P>>2];g[w+(f*36|0)+32>>2]=1000000015047466219876688.0e6}else{c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0}n=c[j>>2]|0;if((n|0)>0){m=c[(c[d+52>>2]|0)+16>>2]|0;x=+g[p>>2];v=+g[Y+(f<<4)+4>>2];u=+g[Y+(f<<4)+8>>2];p=c[l>>2]|0;q=1000000015047466219876688.0e6;o=0;do{P=c[p+(o<<2)>>2]|0;H=+g[m+(P<<4)>>2]*x+ +g[m+(P<<4)+4>>2]*v+ +g[m+(P<<4)+8>>2]*u;q=q>H?H:q;o=o+1|0}while((o|0)!=(n|0))}else q=1000000015047466219876688.0e6;g[w+(f*36|0)+32>>2]=-q;f=f+1|0}while((f|0)!=(J|0))}if((c[_>>2]|0)>0){p=0;w=0;m=0;while(1){do if((w|0)==(p|0)){p=(w|0)!=0?w<<1:1;if((w|0)<(p|0)){if((p|0)!=0?(c[2703]=(c[2703]|0)+1,X=XE((p<<2|3)+16|0)|0,(X|0)!=0):0){c[(X+4+15&-16)+-4>>2]=X;n=X+4+15&-16}else n=0;if((w|0)<=0){if(!m)break}else{o=0;do{c[n+(o<<2)>>2]=c[m+(o<<2)>>2];o=o+1|0}while((o|0)!=(w|0))}c[2704]=(c[2704]|0)+1;YE(c[m+-4>>2]|0)}else{p=w;n=m}}else n=m;while(0);c[n+(w<<2)>>2]=w;w=w+1|0;if((w|0)>=(c[_>>2]|0))break;else m=n}if(w){S=fa+40+16|0;T=fa+40+12|0;R=fa+40+4|0;U=c[Z>>2]|0;while(1){C=w+-1|0;o=c[n+(C<<2)>>2]|0;c[2703]=(c[2703]|0)+1;p=XE(23)|0;if(!p)p=0;else{c[(p+4+15&-16)+-4>>2]=p;p=p+4+15&-16}c[p>>2]=o;q=+g[U+(o*36|0)+20>>2];r=+g[U+(o*36|0)+24>>2];I=+g[U+(o*36|0)+28>>2];c:do if((w|0)>1){m=1;B=1;A=p;p=C;h=C;while(1){F=B;C=A;d:while(1){do{P=p;p=p+-1|0;if((P|0)<=0){W=F;A=C;w=h;break c}z=c[n+(p<<2)>>2]|0}while(!(q*+g[U+(z*36|0)+20>>2]+r*+g[U+(z*36|0)+24>>2]+I*+g[U+(z*36|0)+28>>2]>.9990000128746033));do if((F|0)==(m|0)){A=(m|0)!=0?m<<1:1;if((m|0)>=(A|0)){A=C;break}do if(!A)B=0;else{c[2703]=(c[2703]|0)+1;o=XE((A<<2|3)+16|0)|0;if(!o){B=0;break}c[(o+4+15&-16)+-4>>2]=o;B=o+4+15&-16}while(0);if((m|0)<=0){if(!C){m=A;A=B;break}}else{y=0;do{c[B+(y<<2)>>2]=c[C+(y<<2)>>2];y=y+1|0}while((y|0)!=(m|0))}c[2704]=(c[2704]|0)+1;YE(c[C+-4>>2]|0);m=A;A=B}else A=C;while(0);c[A+(F<<2)>>2]=z;F=F+1|0;o=0;while(1){y=n+(o<<2)|0;if((c[y>>2]|0)==(z|0))break;o=o+1|0;if((o|0)>=(h|0)){C=A;continue d}}if((o|0)<(h|0))break;else C=A}w=h+-1|0;P=n+(w<<2)|0;c[y>>2]=c[P>>2];c[P>>2]=z;if((h|0)>1){B=F;h=w}else{B=F;$=161;break}}}else{m=1;B=1;A=p;p=C;w=C;$=161}while(0);e:do if(($|0)==161){$=0;C=B;while(1){do{P=p;p=p+-1|0;if((P|0)<=0){W=C;break e}B=c[n+(p<<2)>>2]|0}while(!(q*+g[U+(B*36|0)+20>>2]+r*+g[U+(B*36|0)+24>>2]+I*+g[U+(B*36|0)+28>>2]>.9990000128746033));do if((C|0)==(m|0)?(Q=(m|0)!=0?m<<1:1,(m|0)<(Q|0)):0){do if(!Q)o=0;else{c[2703]=(c[2703]|0)+1;o=XE((Q<<2|3)+16|0)|0;if(!o){o=0;break}c[(o+4+15&-16)+-4>>2]=o;o=o+4+15&-16}while(0);if((m|0)<=0){if(!A){m=Q;break}}else{l=0;do{c[o+(l<<2)>>2]=c[A+(l<<2)>>2];l=l+1|0}while((l|0)!=(m|0))}c[2704]=(c[2704]|0)+1;YE(c[A+-4>>2]|0);m=Q}else o=A;while(0);c[o+(C<<2)>>2]=B;C=C+1|0;A=o}}while(0);if((W|0)>1){a[S>>0]=1;c[T>>2]=0;c[R>>2]=0;c[fa+40+8>>2]=0;x=0.0;v=0.0;p=0;H=0.0;l=0;do{j=c[A+(l<<2)>>2]|0;H=+g[U+(j*36|0)+20>>2]+H;x=+g[U+(j*36|0)+24>>2]+x;v=+g[U+(j*36|0)+28>>2]+v;o=c[U+(j*36|0)+4>>2]|0;if((o|0)>0){G=0;do{F=c[(c[U+(j*36|0)+12>>2]|0)+(G<<2)>>2]|0;P=(c[(c[d+52>>2]|0)+16>>2]|0)+(F<<4)|0;c[fa+24>>2]=c[P>>2];c[fa+24+4>>2]=c[P+4>>2];c[fa+24+8>>2]=c[P+8>>2];c[fa+24+12>>2]=c[P+12>>2];f:do if((p|0)>0){B=c[T>>2]|0;z=0;while(1){if((c[B+(z*24|0)+20>>2]|0)==(F|0))break f;z=z+1|0;if((z|0)>=(p|0)){$=200;break}}}else $=200;while(0);if(($|0)==200){$=0;c[fa>>2]=c[fa+24>>2];c[fa+4>>2]=c[fa+24+4>>2];c[fa+8>>2]=c[fa+24+8>>2];c[fa+12>>2]=c[fa+24+12>>2];do if((p|0)==(c[fa+40+8>>2]|0)){C=(p|0)!=0?p<<1:1;if((p|0)>=(C|0))break;if(!C)B=0;else{c[2703]=(c[2703]|0)+1;p=XE((C*24|3)+16|0)|0;if(!p)B=0;else{c[(p+4+15&-16)+-4>>2]=p;B=p+4+15&-16}p=c[R>>2]|0}h=c[T>>2]|0;if((p|0)<=0){if(h)$=209}else{z=0;do{P=B+(z*24|0)|0;M=h+(z*24|0)|0;c[P>>2]=c[M>>2];c[P+4>>2]=c[M+4>>2];c[P+8>>2]=c[M+8>>2];c[P+12>>2]=c[M+12>>2];c[P+16>>2]=c[M+16>>2];c[P+20>>2]=c[M+20>>2];z=z+1|0}while((z|0)!=(p|0));$=209}if(($|0)==209){$=0;if(a[S>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0);p=c[R>>2]|0}c[T>>2]=0}a[S>>0]=1;c[T>>2]=B;c[fa+40+8>>2]=C}while(0);o=c[T>>2]|0;P=o+(p*24|0)|0;c[P>>2]=c[fa>>2];c[P+4>>2]=c[fa+4>>2];c[P+8>>2]=c[fa+8>>2];c[P+12>>2]=c[fa+12>>2];c[P+16>>2]=c[fa+16>>2];c[o+(p*24|0)+20>>2]=F;p=(c[R>>2]|0)+1|0;c[R>>2]=p;o=c[U+(j*36|0)+4>>2]|0}G=G+1|0}while((G|0)<(o|0))}l=l+1|0}while((l|0)!=(W|0));a[fa+132+16>>0]=1;c[fa+132+12>>2]=0;c[fa+132+4>>2]=0;c[fa+132+8>>2]=0;P=U+20+((c[A>>2]|0)*9<<2)|0;c[fa+132+20>>2]=c[P>>2];c[fa+132+20+4>>2]=c[P+4>>2];c[fa+132+20+8>>2]=c[P+8>>2];c[fa+132+20+12>>2]=c[P+12>>2];I=1.0/+O(+(H*H+x*x+v*v));r=H*I;q=x*I;I=v*I;if(+N(+I)>.7071067690849304){t=1.0/+O(+(I*I+q*q));v=0.0;u=-(I*t);t=q*t}else{u=1.0/+O(+(r*r+q*q));v=-(q*u);u=r*u;t=0.0}do if((p|0)<2){if((p|0)>0){m=0;l=0;C=0}else{p=0;o=0;$=291;break}while(1){h=c[T>>2]|0;do if((m|0)==(l|0)){z=(l|0)!=0?l<<1:1;if((l|0)>=(z|0)){B=l;o=C;break}do if(!z)o=0;else{c[2703]=(c[2703]|0)+1;p=XE((z*24|3)+16|0)|0;if(!p){l=m;o=0;break}c[(p+4+15&-16)+-4>>2]=p;l=m;o=p+4+15&-16}while(0);if((l|0)<=0){if(C)$=231}else{p=0;do{P=o+(p*24|0)|0;M=C+(p*24|0)|0;c[P>>2]=c[M>>2];c[P+4>>2]=c[M+4>>2];c[P+8>>2]=c[M+8>>2];c[P+12>>2]=c[M+12>>2];c[P+16>>2]=c[M+16>>2];c[P+20>>2]=c[M+20>>2];p=p+1|0}while((p|0)!=(l|0));$=231}if(($|0)==231){$=0;c[2704]=(c[2704]|0)+1;YE(c[C+-4>>2]|0)}B=m;p=c[R>>2]|0;l=z}else{B=m;o=C}while(0);P=o+(B*24|0)|0;c[P>>2]=c[h>>2];c[P+4>>2]=c[h+4>>2];c[P+8>>2]=c[h+8>>2];c[P+12>>2]=c[h+12>>2];c[P+16>>2]=c[h+16>>2];c[P+20>>2]=c[h+20>>2];m=m+1|0;if((m|0)<(p|0))C=o;else{$=261;break}}}else{B=c[T>>2]|0;y=p;z=0;do{if(v*+g[B+(z*24|0)>>2]+u*+g[B+(z*24|0)+4>>2]+t*+g[B+(z*24|0)+8>>2]<v*+g[B>>2]+u*+g[B+4>>2]+t*+g[B+8>>2]){c[fa+264>>2]=c[B>>2];c[fa+264+4>>2]=c[B+4>>2];c[fa+264+8>>2]=c[B+8>>2];c[fa+264+12>>2]=c[B+12>>2];c[fa+264+16>>2]=c[B+16>>2];c[fa+264+20>>2]=c[B+20>>2];y=B+(z*24|0)|0;c[B>>2]=c[y>>2];c[B+4>>2]=c[y+4>>2];c[B+8>>2]=c[y+8>>2];c[B+12>>2]=c[y+12>>2];c[B+16>>2]=c[y+16>>2];c[B+20>>2]=c[y+20>>2];y=B+(z*24|0)|0;c[y>>2]=c[fa+264>>2];c[y+4>>2]=c[fa+264+4>>2];c[y+8>>2]=c[fa+264+8>>2];c[y+12>>2]=c[fa+264+12>>2];c[y+16>>2]=c[fa+264+16>>2];c[y+20>>2]=c[fa+264+20>>2];y=p}z=z+1|0}while((z|0)<(y|0));g[B+16>>2]=-1000000015047466219876688.0e6;if((y|0)>1){x=+g[B+4>>2];p=1;do{D=+g[B+(p*24|0)>>2]-+g[B>>2];E=+g[B+(p*24|0)+4>>2]-x;H=+g[B+(p*24|0)+8>>2]-+g[B+8>>2];g[B+(p*24|0)+16>>2]=((v*E-u*D)*I+(r*(u*H-t*E)+q*(t*D-v*H)))/+O(+(D*D+E*E+H*H));p=p+1|0}while((p|0)!=(y|0))};c[fa+248>>2]=c[B>>2];c[fa+248+4>>2]=c[B+4>>2];c[fa+248+8>>2]=c[B+8>>2];c[fa+248+12>>2]=c[B+12>>2];By(fa+40|0,fa+248|0,1,y+-1|0);o=c[T>>2]|0;c[2703]=(c[2703]|0)+1;p=XE(43)|0;if(!p)l=0;else{c[(p+4+15&-16)+-4>>2]=p;l=p+4+15&-16}m=c[T>>2]|0;c[l>>2]=c[o>>2];c[l+4>>2]=c[o+4>>2];c[l+8>>2]=c[o+8>>2];c[l+12>>2]=c[o+12>>2];c[l+16>>2]=c[o+16>>2];c[l+20>>2]=c[o+20>>2];c[2703]=(c[2703]|0)+1;p=XE(67)|0;if(!p)o=0;else{c[(p+4+15&-16)+-4>>2]=p;o=p+4+15&-16}p=0;while(1){P=o+(p*24|0)|0;M=l+(p*24|0)|0;c[P>>2]=c[M>>2];c[P+4>>2]=c[M+4>>2];c[P+8>>2]=c[M+8>>2];c[P+12>>2]=c[M+12>>2];c[P+16>>2]=c[M+16>>2];c[P+20>>2]=c[M+20>>2];if(!p)break;else p=p+1|0}c[2704]=(c[2704]|0)+1;YE(c[l+-4>>2]|0);p=o+24|0;c[p>>2]=c[m+24>>2];c[p+4>>2]=c[m+24+4>>2];c[p+8>>2]=c[m+24+8>>2];c[p+12>>2]=c[m+24+12>>2];c[p+16>>2]=c[m+24+16>>2];c[p+20>>2]=c[m+24+20>>2];p=c[R>>2]|0;if((p|0)==2){m=2;$=262;break}else{C=2;m=2;F=2;h=o;G=2}while(1){g:do if((C|0)>1){P=c[T>>2]|0;z=P+(G*24|0)|0;x=+g[z>>2];v=+g[P+(G*24|0)+4>>2];E=+g[P+(G*24|0)+8>>2];while(1){P=C+-2|0;B=C+-1|0;D=+g[h+(P*24|0)>>2];u=D-+g[h+(B*24|0)>>2];s=+g[h+(P*24|0)+4>>2];V=s-+g[h+(B*24|0)+4>>2];H=+g[h+(P*24|0)+8>>2];t=H-+g[h+(B*24|0)+8>>2];if((u*(s-v)-V*(D-x))*I+(r*(V*(H-E)-t*(s-v))+q*(t*(D-x)-u*(H-E)))>0.0)break;if((B|0)>1){C=B;m=B}else{C=B;m=B;B=F;o=h;break g}}do if((C|0)==(F|0)){B=F<<1;if((F|0)>=(B|0)){C=F;B=F;o=h;break}c[2703]=(c[2703]|0)+1;p=XE((F*48|3)+16|0)|0;if(!p)o=0;else{c[(p+4+15&-16)+-4>>2]=p;o=p+4+15&-16}if((m|0)>0){p=0;do{P=o+(p*24|0)|0;M=h+(p*24|0)|0;c[P>>2]=c[M>>2];c[P+4>>2]=c[M+4>>2];c[P+8>>2]=c[M+8>>2];c[P+12>>2]=c[M+12>>2];c[P+16>>2]=c[M+16>>2];c[P+20>>2]=c[M+20>>2];p=p+1|0}while((p|0)!=(m|0))}c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0);p=c[R>>2]|0;C=m}else{B=F;o=h}while(0);C=o+(C*24|0)|0;c[C>>2]=c[z>>2];c[C+4>>2]=c[z+4>>2];c[C+8>>2]=c[z+8>>2];c[C+12>>2]=c[z+12>>2];c[C+16>>2]=c[z+16>>2];c[C+20>>2]=c[z+20>>2];m=m+1|0;C=m}else{B=F;o=h}while(0);G=G+1|0;if((G|0)==(p|0)){$=261;break}else{F=B;h=o}}}while(0);if(($|0)==261)if((m|0)>0)$=262;else{F=p;p=0;$=263}if(($|0)==262){$=0;y=0;z=0;C=0;p=0;G=0;while(1){f=o+(G*24|0)+20|0;do if((y|0)==(z|0)){l=(z|0)!=0?z<<1:1;if((z|0)>=(l|0)){F=C;l=z;break}do if(!l)B=0;else{c[2703]=(c[2703]|0)+1;p=XE((l<<2|3)+16|0)|0;if(!p){B=0;break}c[(p+4+15&-16)+-4>>2]=p;B=p+4+15&-16}while(0);if((z|0)<=0){if(C)$=273}else{p=0;do{c[B+(p<<2)>>2]=c[C+(p<<2)>>2];p=p+1|0}while((p|0)!=(z|0));$=273}if(($|0)==273){$=0;c[2704]=(c[2704]|0)+1;YE(c[C+-4>>2]|0);c[fa+132+12>>2]=0}a[fa+132+16>>0]=1;c[fa+132+12>>2]=B;c[fa+132+8>>2]=l;F=B;p=B}else{F=C;l=z}while(0);c[F+(y<<2)>>2]=c[f>>2];y=(c[fa+132+4>>2]|0)+1|0;c[fa+132+4>>2]=y;h=c[R>>2]|0;h:do if((h|0)>0){j=c[T>>2]|0;B=c[f>>2]|0;C=0;while(1){z=j+(C*24|0)+20|0;C=C+1|0;if((c[z>>2]|0)==(B|0))break;if((C|0)>=(h|0))break h}c[z>>2]=-1}while(0);G=G+1|0;if((G|0)==(m|0)){F=h;$=263;break}else{z=l;C=F}}}i:do if(($|0)==263){$=0;if((F|0)<=0){$=291;break}j=c[T>>2]|0;l=c[_>>2]|0;f=0;while(1){m=c[j+(f*24|0)+20>>2]|0;if(!((m|0)==-1|(l|0)<1)){C=0;do{y=0;while(1){if((c[A+(y<<2)>>2]|0)==(C|0))break;y=y+1|0;if((y|0)>=(W|0)){$=287;break}}do if(($|0)==287){$=0;B=c[U+(C*36|0)+4>>2]|0;if((B|0)<=0)break;z=c[U+(C*36|0)+12>>2]|0;h=0;do{if((c[z+(h<<2)>>2]|0)==(m|0)){m=1;break i}h=h+1|0}while((h|0)<(B|0))}while(0);C=C+1|0}while((C|0)<(l|0))}f=f+1|0;if((f|0)>=(F|0)){$=291;break}}}while(0);if(($|0)==291){$=0;Ay((c[d+52>>2]|0)+24|0,fa+132|0);m=0}if(o){c[2704]=(c[2704]|0)+1;YE(c[o+-4>>2]|0)}if(p){c[2704]=(c[2704]|0)+1;YE(c[p+-4>>2]|0);c[fa+132+12>>2]=0}p=c[T>>2]|0;if(p){if(a[S>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[p+-4>>2]|0)}c[T>>2]=0}a[S>>0]=1;c[T>>2]=0;c[R>>2]=0;c[fa+40+8>>2]=0;if(m&(W|0)>0){h=0;$=302}}else if((W|0)>0){h=0;$=302}if(($|0)==302)while(1){$=0;j=c[A+(h<<2)>>2]|0;a[fa+264+16>>0]=1;c[fa+264+12>>2]=0;c[fa+264+4>>2]=0;c[fa+264+8>>2]=0;l=c[U+(j*36|0)+4>>2]|0;if((l|0)>0){c[2703]=(c[2703]|0)+1;p=XE((l<<2|3)+16|0)|0;if(!p)p=0;else{c[(p+4+15&-16)+-4>>2]=p;p=p+4+15&-16}a[fa+264+16>>0]=1;c[fa+264+12>>2]=p;c[fa+264+8>>2]=l;qF(p|0,0,l<<2|0)|0;c[fa+264+4>>2]=l;o=c[U+(j*36|0)+12>>2]|0;m=0;do{c[p+(m<<2)>>2]=c[o+(m<<2)>>2];m=m+1|0}while((m|0)!=(l|0))}else{c[fa+264+4>>2]=l;p=0}c[fa+264+20>>2]=c[U+(j*36|0)+20>>2];c[fa+264+20+4>>2]=c[U+(j*36|0)+20+4>>2];c[fa+264+20+8>>2]=c[U+(j*36|0)+20+8>>2];c[fa+264+20+12>>2]=c[U+(j*36|0)+20+12>>2];Ay((c[d+52>>2]|0)+24|0,fa+264|0);if(p){c[2704]=(c[2704]|0)+1;YE(c[p+-4>>2]|0);c[fa+264+12>>2]=0}h=h+1|0;if((h|0)>=(W|0))break;else $=302}if(A){c[2704]=(c[2704]|0)+1;YE(c[A+-4>>2]|0)}if(!w)break}}}else n=0;X=c[d+52>>2]|0;c[X+64>>2]=0;c[X+64+4>>2]=0;c[X+64+8>>2]=0;c[X+64+12>>2]=0;j=c[X+28>>2]|0;if((j|0)>0){z=0;p=0;o=0;G=0;w=0;h=0;m=0;f=0;F=0;l=0;C=0;B=0;W=0;while(1){A=c[X+36>>2]|0;U=c[A+(W*36|0)+4>>2]|0;if((U|0)>0){T=W&65535;S=W|-65536;L=p;Q=G;P=m;y=F;J=l;K=B;B=0;while(1){R=B+1|0;l=c[A+(W*36|0)+12>>2]|0;F=c[l+(B<<2)>>2]&65535;l=c[l+(((R|0)==(U|0)?0:R)<<2)>>2]&65535;d=F<<16>>16<l<<16>>16?F:l;M=F<<16>>16<l<<16>>16?l:F;A=F<<16>>16<l<<16>>16?F:l;F=F<<16>>16<l<<16>>16?l:F;l=y+-1|0;j:do if((((A&65535)<<16)+(F<<16>>16)&l)>>>0<Q>>>0?(aa=c[o+((((A&65535)<<16)+(F<<16>>16)&l)<<2)>>2]|0,(aa|0)!=-1):0){B=aa;while(1){if(F<<16>>16==(b[L+(B<<2)>>1]|0)?A<<16>>16==(b[L+(B<<2)+2>>1]|0):0)break;B=c[P+(B<<2)>>2]|0;if((B|0)==-1){j=0;break j}}j=J+(B<<2)|0}else j=0;while(0);B=c[X+16>>2]|0;u=+g[B+(A<<16>>16<<4)>>2]-+g[B+(F<<16>>16<<4)>>2];D=+g[B+(A<<16>>16<<4)+4>>2]-+g[B+(F<<16>>16<<4)+4>>2];E=+g[B+(A<<16>>16<<4)+8>>2]-+g[B+(F<<16>>16<<4)+8>>2];H=1.0/+O(+(u*u+D*D+E*E));B=c[X+48>>2]|0;k:do if((B|0)>0){A=c[X+56>>2]|0;F=0;while(1){x=+g[A+(F<<4)>>2];v=+g[A+(F<<4)+8>>2];do if(!(+N(+(x-u*H))>1.0e-06)){if(+N(+(+g[A+(F<<4)+4>>2]-D*H))>1.0e-06)break;if(!(+N(+(v-E*H))>1.0e-06))break k}while(0);do if(!(+N(+(u*H+x))>1.0e-06)){if(+N(+(D*H+ +g[A+(F<<4)+4>>2]))>1.0e-06)break;if(!(+N(+(E*H+v))>1.0e-06))break k}while(0);F=F+1|0;if((F|0)>=(B|0)){$=336;break}}}else $=336;while(0);if(($|0)==336){$=0;do if((B|0)==(c[X+52>>2]|0)){G=(B|0)!=0?B<<1:1;if((B|0)>=(G|0))break;if(!G)A=0;else{c[2703]=(c[2703]|0)+1;B=XE((G<<4|3)+16|0)|0;if(!B)A=0;else{c[(B+4+15&-16)+-4>>2]=B;A=B+4+15&-16}B=c[X+48>>2]|0}if((B|0)>0){F=0;do{m=A+(F<<4)|0;p=(c[X+56>>2]|0)+(F<<4)|0;c[m>>2]=c[p>>2];c[m+4>>2]=c[p+4>>2];c[m+8>>2]=c[p+8>>2];c[m+12>>2]=c[p+12>>2];F=F+1|0}while((F|0)!=(B|0))}B=c[X+56>>2]|0;if(B){if(a[X+60>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[B+-4>>2]|0)}c[X+56>>2]=0}a[X+60>>0]=1;c[X+56>>2]=A;c[X+52>>2]=G;B=c[X+48>>2]|0}while(0);A=c[X+56>>2]|0;g[A+(B<<4)>>2]=u*H;g[A+(B<<4)+4>>2]=D*H;g[A+(B<<4)+8>>2]=E*H;g[A+(B<<4)+12>>2]=0.0;c[X+48>>2]=(c[X+48>>2]|0)+1}l:do if(!j){B=((d&65535)<<16)+(M<<16>>16)&l;m:do if(B>>>0<Q>>>0){A=c[o+(B<<2)>>2]|0;if((A|0)==-1)break;while(1){if(M<<16>>16==(b[L+(A<<2)>>1]|0)?d<<16>>16==(b[L+(A<<2)+2>>1]|0):0)break;A=c[P+(A<<2)>>2]|0;if((A|0)==-1)break m}p=J+(A<<2)|0;b[p>>1]=S;b[p+2>>1]=S>>>16;p=L;G=Q;m=P;F=y;l=J;B=K;break l}while(0);do if((f|0)==(y|0)){F=(y|0)!=0?y<<1:1;if((y|0)>=(F|0)){A=y;F=y;l=J;break}do if(!F)l=0;else{c[2703]=(c[2703]|0)+1;A=XE((F<<2|3)+16|0)|0;if(!A){l=0;break}c[(A+4+15&-16)+-4>>2]=A;l=A+4+15&-16}while(0);if((y|0)<=0){if(!J){A=y;break}}else{A=0;do{G=l+(A<<2)|0;j=J+(A<<2)|0;j=e[j>>1]|e[j+2>>1]<<16;b[G>>1]=j;b[G+2>>1]=j>>>16;A=A+1|0}while((A|0)!=(y|0))}c[2704]=(c[2704]|0)+1;YE(c[J+-4>>2]|0);A=y}else{A=f;F=y;l=J}while(0);J=l+(A<<2)|0;b[J>>1]=S;b[J+2>>1]=S>>>16;J=f+1|0;do if((K|0)==(z|0)){z=(K|0)!=0?K<<1:1;if((K|0)>=(z|0)){z=K;p=L;break}do if(!z)p=0;else{c[2703]=(c[2703]|0)+1;A=XE((z<<2|3)+16|0)|0;if(!A){p=0;break}c[(A+4+15&-16)+-4>>2]=A;p=A+4+15&-16}while(0);if((K|0)<=0){if(!L)break}else{A=0;do{G=p+(A<<2)|0;j=L+(A<<2)|0;j=e[j>>1]|e[j+2>>1]<<16;b[G>>1]=j;b[G+2>>1]=j>>>16;A=A+1|0}while((A|0)!=(K|0))}c[2704]=(c[2704]|0)+1;YE(c[L+-4>>2]|0)}else p=L;while(0);j=p+(K<<2)|0;b[j>>1]=(d&65535)<<16|M&65535;b[j+2>>1]=((d&65535)<<16|M&65535)>>>16;j=K+1|0;if((y|0)<(F|0)){do if((F|0)>(Q|0)){if((F|0)>=(Q|0)){do if((C|0)<(F|0)){do if(!F)B=0;else{c[2703]=(c[2703]|0)+1;B=XE((F<<2|3)+16|0)|0;if(!B){B=0;break}c[(B+4+15&-16)+-4>>2]=B;B=B+4+15&-16}while(0);if((Q|0)<=0){if(!o){o=B;C=F;break}}else{C=0;do{c[B+(C<<2)>>2]=c[o+(C<<2)>>2];C=C+1|0}while((C|0)!=(Q|0))}c[2704]=(c[2704]|0)+1;YE(c[o+-4>>2]|0);o=B;C=F}while(0);qF(o+(Q<<2)|0,0,F-Q<<2|0)|0}if((F|0)>(w|0)){do if((h|0)<(F|0)){do if(!F)m=0;else{c[2703]=(c[2703]|0)+1;B=XE((F<<2|3)+16|0)|0;if(!B){m=0;break}c[(B+4+15&-16)+-4>>2]=B;m=B+4+15&-16}while(0);if((w|0)<=0){if(!P){B=F;break}}else{B=0;do{c[m+(B<<2)>>2]=c[P+(B<<2)>>2];B=B+1|0}while((B|0)!=(w|0))}c[2704]=(c[2704]|0)+1;YE(c[P+-4>>2]|0);B=F}else{B=h;m=P}while(0);qF(m+(w<<2)|0,0,F-w<<2|0)|0;h=B}else m=P;if((F|0)>0){P=F<<2;qF(o|0,-1,P|0)|0;qF(m|0,-1,P|0)|0}if((Q|0)<=0){B=F;A=F;break}A=F+-1|0;B=0;do{P=o+(((e[p+(B<<2)+2>>1]<<16)+(b[p+(B<<2)>>1]|0)&A)<<2)|0;c[m+(B<<2)>>2]=c[P>>2];c[P>>2]=B;B=B+1|0}while((B|0)!=(Q|0));B=F;A=F}else{B=Q;A=w;m=P}while(0);G=B;B=((d&65535)<<16)+(M<<16>>16)&F+-1}else{G=Q;A=w;m=P}w=o+(B<<2)|0;c[m+(f<<2)>>2]=c[w>>2];c[w>>2]=f;w=A;f=J;B=j}else{b[j+2>>1]=T;p=L;G=Q;m=P;F=y;l=J;B=K}while(0);if((R|0)>=(U|0))break;A=c[X+36>>2]|0;L=p;Q=G;P=m;y=F;J=l;K=B;B=R}j=c[X+28>>2]|0;A=f}else A=f;W=W+1|0;if((W|0)>=(j|0))break;else f=A}if((j|0)>0){z=c[X+36>>2]|0;A=c[X+16>>2]|0;r=0.0;B=0;do{f=c[z+(B*36|0)+4>>2]|0;h=c[z+(B*36|0)+12>>2]|0;y=c[h>>2]|0;if((f+-2|0)>=1){x=+g[X+64>>2];v=+g[X+68>>2];u=+g[X+72>>2];w=1;do{M=c[h+(w<<2)>>2]|0;w=w+1|0;P=c[h+(((w|0)%(f|0)|0)<<2)>>2]|0;ha=+g[A+(y<<4)>>2];ga=+g[A+(M<<4)>>2];I=+g[A+(y<<4)+4>>2];q=+g[A+(M<<4)+4>>2];t=+g[A+(y<<4)+8>>2];D=+g[A+(M<<4)+8>>2];V=+g[A+(P<<4)>>2];s=+g[A+(P<<4)+4>>2];E=+g[A+(P<<4)+8>>2];H=+O(+(((ha-ga)*(I-s)-(I-q)*(ha-V))*((ha-ga)*(I-s)-(I-q)*(ha-V))+(((I-q)*(t-E)-(t-D)*(I-s))*((I-q)*(t-E)-(t-D)*(I-s))+((t-D)*(ha-V)-(ha-ga)*(t-E))*((t-D)*(ha-V)-(ha-ga)*(t-E)))))*.5;x=x+(ha+ga+V)*.3333333432674408*H;g[X+64>>2]=x;v=(I+q+s)*.3333333432674408*H+v;g[X+68>>2]=v;u=H*((t+D+E)*.3333333432674408)+u;g[X+72>>2]=u;r=r+H}while((w|0)!=(f+-1|0))}B=B+1|0}while((B|0)!=(j|0));w=X+64|0;A=1;F=p;B=o;C=m}else $=317}else{p=0;o=0;m=0;l=0;$=317}if(($|0)==317){r=0.0;w=X+64|0;A=0;F=p;B=o;C=m}t=1.0/r;v=t*+g[w>>2];g[w>>2]=v;u=t*+g[X+68>>2];g[X+68>>2]=u;t=t*+g[X+72>>2];g[X+72>>2]=t;g[X+96>>2]=3402823466385288598117041.0e14;if(A){p=c[X+36>>2]|0;r=3402823466385288598117041.0e14;o=0;while(1){s=+N(+(+g[p+(o*36|0)+32>>2]+(+g[p+(o*36|0)+20>>2]*v+ +g[p+(o*36|0)+24>>2]*u+ +g[p+(o*36|0)+28>>2]*t)));if(s<r)g[X+96>>2]=s;else s=r;o=o+1|0;if((o|0)>=(j|0))break;else r=s}}else s=3402823466385288598117041.0e14;A=c[X+8>>2]|0;if((A|0)>0){z=c[X+16>>2]|0;x=-3402823466385288598117041.0e14;v=-3402823466385288598117041.0e14;u=-3402823466385288598117041.0e14;t=3402823466385288598117041.0e14;q=3402823466385288598117041.0e14;r=3402823466385288598117041.0e14;h=0;do{H=+g[z+(h<<4)>>2];t=H<t?H:t;x=H>x?H:x;H=+g[z+(h<<4)+4>>2];q=H<q?H:q;v=H>v?H:v;H=+g[z+(h<<4)+8>>2];r=H<r?H:r;u=H>u?H:u;h=h+1|0}while((h|0)!=(A|0))}else{x=-3402823466385288598117041.0e14;v=-3402823466385288598117041.0e14;u=-3402823466385288598117041.0e14;t=3402823466385288598117041.0e14;q=3402823466385288598117041.0e14;r=3402823466385288598117041.0e14}g[X+100>>2]=x+t;g[X+104>>2]=v+q;g[X+108>>2]=r+u;g[X+112>>2]=0.0;H=x-t;q=v-q;r=u-r;g[X+116>>2]=H;g[X+120>>2]=q;g[X+124>>2]=r;g[X+128>>2]=0.0;s=s/1.7320507764816284;w=H<q?(q<r?2:1):H<r?2:0;r=(+g[X+116+(w<<2)>>2]*.5-s)*.0009765625;g[X+88>>2]=s;g[X+84>>2]=s;g[X+80>>2]=s;q=+g[X+116+(w<<2)>>2]*.5;g[X+80+(w<<2)>>2]=q;p=0;while(1){if(WD(X)|0){$=425;break}q=q-r;g[X+80+(w<<2)>>2]=q;p=p+1|0;if((p|0)>=1024){$=424;break}}n:do if(($|0)==424){g[X+88>>2]=s;g[X+84>>2]=s;g[X+80>>2]=s}else if(($|0)==425){r=(+g[X+96>>2]-s)*.0009765625;o=c[X+80+((1<<(1<<w&3)&3)<<2)>>2]|0;m=0;while(1){p=c[X+80+((1<<w&3)<<2)>>2]|0;g[X+80+((1<<w&3)<<2)>>2]=r+(c[k>>2]=p,+g[k>>2]);s=r+ +g[X+80+((1<<(1<<w&3)&3)<<2)>>2];g[X+80+((1<<(1<<w&3)&3)<<2)>>2]=s;m=m+1|0;if(!(WD(X)|0))break;if((m|0)>=1024)break n;else o=(g[k>>2]=s,c[k>>2]|0)}c[X+80+((1<<w&3)<<2)>>2]=p;c[X+80+((1<<(1<<w&3)&3)<<2)>>2]=o}while(0);if(F){c[2704]=(c[2704]|0)+1;YE(c[F+-4>>2]|0)}if(l){c[2704]=(c[2704]|0)+1;YE(c[l+-4>>2]|0)}if(C){c[2704]=(c[2704]|0)+1;YE(c[C+-4>>2]|0)}if(B){c[2704]=(c[2704]|0)+1;YE(c[B+-4>>2]|0)}if(n){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}p=c[_>>2]|0;h=c[Z>>2]|0;if((p|0)<=0){if(h)$=446}else{m=0;do{o=h+(m*36|0)+4|0;n=h+(m*36|0)+12|0;l=c[n>>2]|0;j=h+(m*36|0)+16|0;if(l){if(a[j>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[l+-4>>2]|0)}c[n>>2]=0}a[j>>0]=1;c[n>>2]=0;c[o>>2]=0;c[h+(m*36|0)+8>>2]=0;m=m+1|0}while((m|0)!=(p|0));$=446}if(($|0)==446){if(a[fa+80+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[Z>>2]=0}a[fa+80+16>>0]=1;c[Z>>2]=0;c[_>>2]=0;c[fa+80+8>>2]=0;if(Y){c[2704]=(c[2704]|0)+1;YE(c[Y+-4>>2]|0)}h=c[ba>>2]|0;if(h){if(a[fa+184+56>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[ba>>2]=0}a[fa+184+56>>0]=1;c[ba>>2]=0;c[fa+184+44>>2]=0;c[fa+184+48>>2]=0;h=c[ca>>2]|0;if(h){if(a[fa+184+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[ca>>2]=0}a[fa+184+36>>0]=1;c[ca>>2]=0;c[fa+184+24>>2]=0;c[fa+184+28>>2]=0;h=c[da>>2]|0;if(h){if(a[fa+184+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[da>>2]=0}if(!ea){i=fa;return 1}c[2704]=(c[2704]|0)+1;YE(c[ea+-4>>2]|0);i=fa;return 1}function ty(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0,p=0,q=0.0,r=0;p=i;i=i+2048|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];if(e*e+h*h+f*f<9.999999747378752e-05){n=1.0;m=0.0;e=0.0}else{q=1.0/+O(+(e*e+h*h+f*f));n=e*q;m=f*q;e=h*q}if((Hb[c[(c[b>>2]|0)+96>>2]&127](b)|0)<=0){i=p;return}l=0;f=-999999984306749440.0;do{if(((Hb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-l|0)<128){d=(Hb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-l|0;if((d|0)>0)o=7;else{h=-3402823466385288598117041.0e14;j=-1}}else{d=128;o=7}if((o|0)==7){o=0;j=0;do{jc[c[(c[b>>2]|0)+108>>2]&127](b,j,p+(j<<4)|0);j=j+1|0}while((j|0)!=(d|0));k=0;h=-3402823466385288598117041.0e14;j=-1;do{q=n*+g[p+(k<<4)>>2]+e*+g[p+(k<<4)+4>>2]+m*+g[p+(k<<4)+8>>2];r=q>h;j=r?k:j;h=r?q:h;k=k+1|0}while((k|0)!=(d|0))}if(h>f){d=p+(j<<4)|0;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];f=h}l=l+128|0}while((l|0)<(Hb[c[(c[b>>2]|0)+96>>2]&127](b)|0));i=p;return}function uy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0;w=i;i=i+2048|0;if((e|0)>0)f=0;else{i=w;return}do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));t=0;do{if((Hb[c[(c[a>>2]|0)+96>>2]&127](a)|0)>0){q=b+(t<<4)|0;s=b+(t<<4)+4|0;o=b+(t<<4)+8|0;r=d+(t<<4)+12|0;p=d+(t<<4)|0;u=0;do{if(((Hb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-u|0)<128){f=(Hb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-u|0;if((f|0)>0)v=8;else{j=-3402823466385288598117041.0e14;h=-1}}else{f=128;v=8}if((v|0)==8){v=0;h=0;do{jc[c[(c[a>>2]|0)+108>>2]&127](a,h,w+(h<<4)|0);h=h+1|0}while((h|0)!=(f|0));k=+g[q>>2];l=+g[s>>2];m=+g[o>>2];n=0;j=-3402823466385288598117041.0e14;h=-1;do{x=k*+g[w+(n<<4)>>2]+l*+g[w+(n<<4)+4>>2]+m*+g[w+(n<<4)+8>>2];y=x>j;h=y?n:h;j=y?x:j;n=n+1|0}while((n|0)!=(f|0))}if(j>+g[r>>2]){n=w+(h<<4)|0;c[p>>2]=c[n>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];c[p+12>>2]=c[n+12>>2];g[r>>2]=j}u=u+128|0}while((u|0)<(Hb[c[(c[a>>2]|0)+96>>2]&127](a)|0))}t=t+1|0}while((t|0)!=(e|0));i=w;return}function vy(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+96|0;j=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);c[e+32>>2]=1065353216;c[e+32+4>>2]=0;c[e+32+4+4>>2]=0;c[e+32+4+8>>2]=0;c[e+32+4+12>>2]=0;c[e+32+20>>2]=1065353216;c[e+32+24>>2]=0;c[e+32+24+4>>2]=0;c[e+32+24+8>>2]=0;c[e+32+24+12>>2]=0;c[e+32+40>>2]=1065353216;k=e+32+44|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;nc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);h=(j+(+g[e>>2]-+g[e+16>>2])*.5)*2.0;f=(j+(+g[e+4>>2]-+g[e+16+4>>2])*.5)*2.0;j=(j+(+g[e+8>>2]-+g[e+16+8>>2])*.5)*2.0;g[d>>2]=b*.0833333283662796*(f*f+j*j);g[d+4>>2]=b*.0833333283662796*(h*h+j*j);g[d+8>>2]=b*.0833333283662796*(h*h+f*f);g[d+12>>2]=0.0;i=e;return}function wy(b){b=b|0;var d=0,e=0,f=0,h=0.0;e=i;i=i+96|0;a[b+88>>0]=1;if((a[1592]|0)==0?(Wa(1592)|0)!=0:0){c[1870]=1065353216;c[1871]=0;c[1872]=0;c[1873]=0;c[1874]=0;c[1875]=1065353216;c[1876]=0;c[1877]=0;c[1878]=0;c[1879]=0;c[1880]=1065353216;g[1881]=0.0;c[1882]=-1082130432;c[1883]=0;c[1884]=0;c[1885]=0;c[1886]=0;c[1887]=-1082130432;c[1888]=0;c[1889]=0;c[1890]=0;c[1891]=0;c[1892]=-1082130432;g[1893]=0.0;_a(1592)}d=e;f=d+96|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));nc[c[(c[b>>2]|0)+76>>2]&127](b,7480,e,6);h=+g[b+44>>2];g[b+72>>2]=+g[e>>2]+h;g[b+56>>2]=+g[e+48>>2]-h;g[b+76>>2]=+g[e+20>>2]+h;g[b+60>>2]=+g[e+68>>2]-h;g[b+80>>2]=+g[e+40>>2]+h;g[b+64>>2]=+g[e+88>>2]-h;i=e;return}function xy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;o=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);u=+g[a+72>>2];t=+g[a+56>>2];r=+g[a+76>>2];q=+g[a+60>>2];n=+g[a+80>>2];m=+g[a+64>>2];E=+g[b>>2];y=+N(+E);D=+g[b+4>>2];x=+N(+D);k=+g[b+8>>2];l=+N(+k);C=+g[b+16>>2];w=+N(+C);B=+g[b+20>>2];v=+N(+B);i=+g[b+24>>2];j=+N(+i);A=+g[b+32>>2];s=+N(+A);z=+g[b+36>>2];p=+N(+z);f=+g[b+40>>2];h=+N(+f);k=(u+t)*.5*E+(r+q)*.5*D+(n+m)*.5*k+ +g[b+48>>2];i=(u+t)*.5*C+(r+q)*.5*B+(n+m)*.5*i+ +g[b+52>>2];f=(u+t)*.5*A+(r+q)*.5*z+(n+m)*.5*f+ +g[b+56>>2];l=(o+(u-t)*.5)*y+(o+(r-q)*.5)*x+(o+(n-m)*.5)*l;j=(o+(u-t)*.5)*w+(o+(r-q)*.5)*v+(o+(n-m)*.5)*j;h=(o+(u-t)*.5)*s+(o+(r-q)*.5)*p+(o+(n-m)*.5)*h;g[d>>2]=k-l;g[d+4>>2]=i-j;g[d+8>>2]=f-h;g[d+12>>2]=0.0;g[e>>2]=l+k;g[e+4>>2]=j+i;g[e+8>>2]=h+f;g[e+12>>2]=0.0;return}function yy(a){a=a|0;var b=0;c[a>>2]=7356;b=c[a+52>>2]|0;if(!b)return;Db[c[c[b>>2]>>2]&255](b);b=c[a+52>>2]|0;if(!b)return;c[2704]=(c[2704]|0)+1;YE(c[b+-4>>2]|0);return}function zy(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((c[b+8>>2]|0)>=(d|0))return;if((d|0)!=0?(c[2703]=(c[2703]|0)+1,e=XE((d*36|3)+16|0)|0,(e|0)!=0):0){c[(e+4+15&-16)+-4>>2]=e;o=e+4+15&-16}else o=0;g=c[b+4>>2]|0;if((g|0)>0){m=0;do{f=o+(m*36|0)|0;e=c[b+12>>2]|0;a[f+16>>0]=1;c[f+12>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;l=c[e+(m*36|0)+4>>2]|0;if((l|0)>0){c[2703]=(c[2703]|0)+1;h=XE((l<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}i=c[f+4>>2]|0;j=c[f+12>>2]|0;if((i|0)<=0)if(!j){a[f+16>>0]=1;c[f+12>>2]=h;c[f+8>>2]=l;qF(h|0,0,l<<2|0)|0}else n=13;else{k=0;do{c[h+(k<<2)>>2]=c[j+(k<<2)>>2];k=k+1|0}while((k|0)!=(i|0));n=13}if((n|0)==13){n=0;if(a[f+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0)}a[f+16>>0]=1;c[f+12>>2]=h;c[f+8>>2]=l;qF(h|0,0,l<<2|0)|0}k=c[f+12>>2]|0;c[f+4>>2]=l;j=c[e+(m*36|0)+12>>2]|0;i=0;do{c[k+(i<<2)>>2]=c[j+(i<<2)>>2];i=i+1|0}while((i|0)!=(l|0))}else c[f+4>>2]=l;l=e+(m*36|0)+20|0;c[f+20>>2]=c[l>>2];c[f+20+4>>2]=c[l+4>>2];c[f+20+8>>2]=c[l+8>>2];c[f+20+12>>2]=c[l+12>>2];m=m+1|0}while((m|0)!=(g|0));f=c[b+4>>2]|0;if((f|0)>0){i=0;do{g=c[b+12>>2]|0;k=g+(i*36|0)+4|0;j=g+(i*36|0)+12|0;h=c[j>>2]|0;e=g+(i*36|0)+16|0;if(h){if(a[e>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[j>>2]=0}a[e>>0]=1;c[j>>2]=0;c[k>>2]=0;c[g+(i*36|0)+8>>2]=0;i=i+1|0}while((i|0)!=(f|0));f=b+12|0}else f=b+12|0}else f=b+12|0;e=c[f>>2]|0;if(e){if(a[b+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[f>>2]=0}a[b+16>>0]=1;c[f>>2]=o;c[b+8>>2]=d;return}function Ay(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=c[b+4>>2]|0;if((e|0)==(c[b+8>>2]|0)){zy(b,(e|0)!=0?e<<1:1);e=c[b+4>>2]|0}i=(c[b+12>>2]|0)+(e*36|0)|0;a[i+16>>0]=1;c[i+12>>2]=0;c[i+4>>2]=0;c[i+8>>2]=0;j=c[d+4>>2]|0;if((j|0)<=0){c[i+4>>2]=j;e=i+20|0;f=d+20|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=c[b+4>>2]|0;e=e+1|0;c[b+4>>2]=e;return}c[2703]=(c[2703]|0)+1;e=XE((j<<2|3)+16|0)|0;if(!e)h=0;else{c[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}e=c[i+4>>2]|0;f=c[i+12>>2]|0;if((e|0)<=0)if(!f){a[i+16>>0]=1;c[i+12>>2]=h;c[i+8>>2]=j;qF(h|0,0,j<<2|0)|0}else g=10;else{g=0;do{c[h+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0));g=10}if((g|0)==10){if(a[i+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}a[i+16>>0]=1;c[i+12>>2]=h;c[i+8>>2]=j;qF(h|0,0,j<<2|0)|0}e=c[i+12>>2]|0;c[i+4>>2]=j;f=c[d+12>>2]|0;g=0;do{c[e+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(j|0));e=i+20|0;f=d+20|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=c[b+4>>2]|0;e=e+1|0;c[b+4>>2]=e;return}function By(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0;w=i;i=i+32|0;q=c[a+12>>2]|0;r=+g[q+(((e+d|0)/2|0)*24|0)>>2];s=+g[q+(((e+d|0)/2|0)*24|0)+4>>2];t=+g[q+(((e+d|0)/2|0)*24|0)+8>>2];u=+g[q+(((e+d|0)/2|0)*24|0)+16>>2];v=c[q+(((e+d|0)/2|0)*24|0)+20>>2]|0;f=d;h=e;while(1){m=+g[b>>2];n=+g[b+4>>2];o=+g[b+8>>2];p=(r-m)*(r-m)+(s-n)*(s-n)+(t-o)*(t-o);a:while(1){j=+g[q+(f*24|0)+16>>2];do if(j!=u){if(!(j<u))break a}else{j=+g[q+(f*24|0)>>2]-m;l=+g[q+(f*24|0)+4>>2]-n;k=+g[q+(f*24|0)+8>>2]-o;if(j*j+l*l+k*k!=p)if(j*j+l*l+k*k<p)break;else break a;else if((c[q+(f*24|0)+20>>2]|0)<(v|0))break;else break a}while(0);f=f+1|0}b:while(1){j=+g[q+(h*24|0)+16>>2];do if(u!=j){if(!(u<j))break b}else{j=+g[q+(h*24|0)>>2]-m;l=+g[q+(h*24|0)+4>>2]-n;k=+g[q+(h*24|0)+8>>2]-o;if(p!=j*j+l*l+k*k)if(p<j*j+l*l+k*k)break;else break b;else if((v|0)<(c[q+(h*24|0)+20>>2]|0))break;else break b}while(0);h=h+-1|0}if((f|0)<=(h|0)){x=q+(f*24|0)|0;c[w>>2]=c[x>>2];c[w+4>>2]=c[x+4>>2];c[w+8>>2]=c[x+8>>2];c[w+12>>2]=c[x+12>>2];c[w+16>>2]=c[x+16>>2];c[w+20>>2]=c[x+20>>2];q=q+(h*24|0)|0;c[x>>2]=c[q>>2];c[x+4>>2]=c[q+4>>2];c[x+8>>2]=c[q+8>>2];c[x+12>>2]=c[q+12>>2];c[x+16>>2]=c[q+16>>2];c[x+20>>2]=c[q+20>>2];q=(c[a+12>>2]|0)+(h*24|0)|0;c[q>>2]=c[w>>2];c[q+4>>2]=c[w+4>>2];c[q+8>>2]=c[w+8>>2];c[q+12>>2]=c[w+12>>2];c[q+16>>2]=c[w+16>>2];c[q+20>>2]=c[w+20>>2];f=f+1|0;h=h+-1|0}if((f|0)>(h|0))break;q=c[a+12>>2]|0}if((h|0)>(d|0))By(a,b,d,h);if((f|0)>=(e|0)){i=w;return}By(a,b,f,e);i=w;return}function Cy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;e=i;i=i+96|0;c[e+32>>2]=1065353216;c[e+32+4>>2]=0;c[e+32+4+4>>2]=0;c[e+32+4+8>>2]=0;c[e+32+4+12>>2]=0;c[e+32+20>>2]=1065353216;c[e+32+24>>2]=0;c[e+32+24+4>>2]=0;c[e+32+24+8>>2]=0;c[e+32+24+12>>2]=0;c[e+32+40>>2]=1065353216;n=e+32+44|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;nc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);l=+g[e>>2];m=+g[e+16>>2];j=+g[e+4>>2];k=+g[e+16+4>>2];f=+g[e+8>>2];h=+g[e+16+8>>2];g[d>>2]=+O(+((l-m)*(l-m)+(j-k)*(j-k)+(f-h)*(f-h)))*.5;g[b>>2]=(m+l)*.5;g[b+4>>2]=(k+j)*.5;g[b+8>>2]=(h+f)*.5;g[b+12>>2]=0.0;i=e;return}function Dy(a,b){a=a|0;b=+b;return +(+Tb[c[(c[a>>2]|0)+16>>2]&15](a)*b)}function Ey(a){a=a|0;var b=0,d=0.0,e=0.0,f=0.0;b=i;i=i+32|0;jc[c[(c[a>>2]|0)+12>>2]&127](a,b+8|0,b);f=+g[b+8>>2];e=+g[b+8+4>>2];d=+g[b+8+8>>2];d=+O(+(f*f+e*e+d*d));i=b;return +(d+ +g[b>>2])}function Fy(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,l=0,m=0,n=0.0,o=0,p=0.0,q=0.0;nc[c[(c[a>>2]|0)+8>>2]&127](a,b,f,h);l=c[h>>2]|0;o=c[h+4>>2]|0;i=c[h+8>>2]|0;m=c[f>>2]|0;j=c[f+4>>2]|0;b=c[f+8>>2]|0;n=+g[d>>2];p=+g[d+4>>2];q=+g[d+8>>2];if(n>0.0)l=(g[k>>2]=(c[k>>2]=l,+g[k>>2])+n,c[k>>2]|0);else m=(g[k>>2]=(c[k>>2]=m,+g[k>>2])+n,c[k>>2]|0);if(p>0.0)d=(g[k>>2]=(c[k>>2]=o,+g[k>>2])+p,c[k>>2]|0);else{d=o;j=(g[k>>2]=(c[k>>2]=j,+g[k>>2])+p,c[k>>2]|0)}if(q>0.0)i=(g[k>>2]=(c[k>>2]=i,+g[k>>2])+q,c[k>>2]|0);else b=(g[k>>2]=(c[k>>2]=b,+g[k>>2])+q,c[k>>2]|0);q=+g[e>>2];p=+g[e+4>>2];n=+g[e+8>>2];n=+O(+(q*q+p*p+n*n));n=n*+Tb[c[(c[a>>2]|0)+16>>2]&15](a);c[f>>2]=m;c[f+4>>2]=j;c[f+8>>2]=b;g[f+12>>2]=0.0;c[h>>2]=l;c[h+4>>2]=d;c[h+8>>2]=i;g[h+12>>2]=0.0;g[f>>2]=+g[f>>2]-n;g[f+4>>2]=+g[f+4>>2]-n;g[f+8>>2]=+g[f+8>>2]-n;g[h>>2]=n+ +g[h>>2];g[h+4>>2]=n+ +g[h+4>>2];g[h+8>>2]=n+ +g[h+8>>2];return}function Gy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=_b[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=_b[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Fb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];return 17817}function Hy(a,b){a=a|0;b=b|0;var d=0,e=0;e=Hb[c[(c[a>>2]|0)+52>>2]&127](a)|0;e=Qb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;d=Qb[c[(c[a>>2]|0)+56>>2]&63](a,c[e+8>>2]|0,b)|0;Bb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1346455635,a);return}function Iy(a){a=a|0;return}function Jy(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0;k=i;i=i+64|0;n=+g[d>>2];o=+g[d+4>>2];m=+g[d+8>>2];p=n*+g[b+4>>2]+o*+g[b+20>>2]+m*+g[b+36>>2];q=n*+g[b+8>>2]+o*+g[b+24>>2]+m*+g[b+40>>2];g[k+48>>2]=+g[b>>2]*n+ +g[b+16>>2]*o+ +g[b+32>>2]*m;g[k+48+4>>2]=p;g[k+48+8>>2]=q;g[k+48+12>>2]=0.0;jc[c[(c[a>>2]|0)+64>>2]&127](k+32|0,a,k+48|0);q=+g[k+32>>2];p=+g[k+32+4>>2];m=+g[k+32+8>>2];o=q*+g[b>>2]+p*+g[b+4>>2]+m*+g[b+8>>2]+ +g[b+48>>2];n=q*+g[b+16>>2]+p*+g[b+20>>2]+m*+g[b+24>>2]+ +g[b+52>>2];m=q*+g[b+32>>2]+p*+g[b+36>>2]+m*+g[b+40>>2]+ +g[b+56>>2];r=c[(c[a>>2]|0)+64>>2]|0;p=-+g[k+48+4>>2];q=-+g[k+48+8>>2];g[k>>2]=-+g[k+48>>2];g[k+4>>2]=p;g[k+8>>2]=q;g[k+12>>2]=0.0;jc[r&127](k+16|0,a,k);q=+g[k+16>>2];p=+g[k+16+4>>2];j=+g[k+16+8>>2];l=q*+g[b>>2]+p*+g[b+4>>2]+j*+g[b+8>>2]+ +g[b+48>>2];h=q*+g[b+16>>2]+p*+g[b+20>>2]+j*+g[b+24>>2]+ +g[b+52>>2];j=q*+g[b+32>>2]+p*+g[b+36>>2]+j*+g[b+40>>2]+ +g[b+56>>2];g[e>>2]=o*+g[d>>2]+n*+g[d+4>>2]+m*+g[d+8>>2];j=l*+g[d>>2]+h*+g[d+4>>2]+j*+g[d+8>>2];g[f>>2]=j;h=+g[e>>2];if(!(h>j)){i=k;return}g[e>>2]=j;g[f>>2]=h;i=k;return}function Ky(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0;y=i;i=i+80|0;switch(c[b+4>>2]|0){case 8:{c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;i=y;return}case 0:{r=+g[b+28>>2];s=+g[b+28+4>>2];s=+g[d+4>>2]>=0.0?s:-s;t=+g[b+28+8>>2];t=+g[d+8>>2]>=0.0?t:-t;g[a>>2]=+g[d>>2]>=0.0?r:-r;g[a+4>>2]=s;g[a+8>>2]=t;g[a+12>>2]=0.0;i=y;return}case 1:{n=+g[d>>2];o=+g[d+4>>2];t=+g[d+8>>2];s=n*+g[b+56>>2]+o*+g[b+56+4>>2]+t*+g[b+56+8>>2];r=n*+g[b+56+16>>2]+o*+g[b+56+20>>2]+t*+g[b+56+24>>2];t=n*+g[b+56+32>>2]+o*+g[b+56+36>>2]+t*+g[b+56+40>>2];d=s<r?(r<t?2:1):s<t?2:0;h=c[b+56+(d<<4)+4>>2]|0;f=c[b+56+(d<<4)+8>>2]|0;c[a>>2]=c[b+56+(d<<4)>>2];c[a+4>>2]=h;c[a+8>>2]=f;g[a+12>>2]=0.0;i=y;return}case 13:{c[y+64>>2]=c[b+28>>2];c[y+64+4>>2]=c[b+28+4>>2];c[y+64+8>>2]=c[b+28+8>>2];c[y+64+12>>2]=c[b+28+12>>2];c[y+48>>2]=c[d>>2];f=c[d+4>>2]|0;c[y+48+4>>2]=f;h=c[d+8>>2]|0;c[y+48+8>>2]=h;g[y+48+12>>2]=0.0;b=c[b+52>>2]|0;e=(c[k>>2]=h,+g[k>>2]);switch(b|0){case 2:{e=(c[k>>2]=f,+g[k>>2]);h=0;f=2;d=1;break}case 1:{h=0;f=1;d=2;break}default:{h=1;f=0;d=2}}o=+g[y+64+(h<<2)>>2];j=+g[y+64+(b<<2)>>2];l=+g[y+48+(h<<2)>>2];n=+O(+(l*l+e*e));m=+g[y+48+(f<<2)>>2];if(n!=0.0){g[y+32+(h<<2)>>2]=l*(o/n);g[y+32+(f<<2)>>2]=m<0.0?-j:j;g[y+32+(d<<2)>>2]=o/n*e;c[a>>2]=c[y+32>>2];c[a+4>>2]=c[y+32+4>>2];c[a+8>>2]=c[y+32+8>>2];g[a+12>>2]=0.0;i=y;return}else{g[y+32+(h<<2)>>2]=o;g[y+32+(f<<2)>>2]=m<0.0?-j:j;g[y+32+(d<<2)>>2]=0.0;c[a>>2]=c[y+32>>2];c[a+4>>2]=c[y+32+4>>2];c[a+8>>2]=c[y+32+8>>2];g[a+12>>2]=0.0;i=y;return}}case 10:{e=+g[d>>2];m=+g[d+4>>2];l=+g[d+8>>2];p=c[b+52>>2]|0;u=+g[b+28+(p<<2)>>2];o=+g[b+28+(((p+2|0)%3|0)<<2)>>2];if(e*e+m*m+l*l<9.999999747378752e-05){x=1.0;w=0.0;v=0.0}else{v=1.0/+O(+(e*e+m*m+l*l));x=e*v;w=m*v;v=l*v}c[y+16>>2]=0;c[y+16+4>>2]=0;c[y+16+8>>2]=0;c[y+16+12>>2]=0;g[y+16+(p<<2)>>2]=u;q=o*x;s=o*w;t=o*v;e=+g[b+44>>2];l=x*e;j=w*e;e=v*e;o=+g[y+16>>2]+q-l;m=s+ +g[y+16+4>>2]-j;n=t+ +g[y+16+8>>2]-e;r=v*n+(x*o+w*m);if(r>-999999984306749440.0){b=(g[k>>2]=o,c[k>>2]|0);h=(g[k>>2]=m,c[k>>2]|0);f=(g[k>>2]=n,c[k>>2]|0)}else{f=0;h=0;b=0;r=-999999984306749440.0}c[y>>2]=0;c[y+4>>2]=0;c[y+8>>2]=0;c[y+12>>2]=0;g[y+(p<<2)>>2]=-u;m=q+ +g[y>>2]-l;n=s+ +g[y+4>>2]-j;o=t+ +g[y+8>>2]-e;if(v*o+(x*m+w*n)>r){b=(g[k>>2]=m,c[k>>2]|0);h=(g[k>>2]=n,c[k>>2]|0);f=(g[k>>2]=o,c[k>>2]|0)}c[a>>2]=b;c[a+4>>2]=h;c[a+8>>2]=f;g[a+12>>2]=0.0;i=y;return}case 5:{p=c[b+92>>2]|0;f=c[b+96>>2]|0;q=+g[b+12>>2];r=+g[b+16>>2];e=+g[b+20>>2];l=+g[d>>2]*q;j=+g[d+4>>2]*r;m=+g[d+8>>2]*e;if((f|0)>0){b=0;n=-3402823466385288598117041.0e14;h=-1;while(1){o=l*+g[p+(b<<4)>>2]+j*+g[p+(b<<4)+4>>2]+m*+g[p+(b<<4)+8>>2];d=o>n;h=d?b:h;b=b+1|0;if((b|0)==(f|0))break;else n=d?o:n}}else h=-1;s=r*+g[p+(h<<4)+4>>2];t=e*+g[p+(h<<4)+8>>2];g[a>>2]=q*+g[p+(h<<4)>>2];g[a+4>>2]=s;g[a+8>>2]=t;g[a+12>>2]=0.0;i=y;return}case 4:{p=c[b+104>>2]|0;f=c[b+96>>2]|0;r=+g[b+12>>2];q=+g[b+16>>2];e=+g[b+20>>2];l=+g[d>>2]*r;j=+g[d+4>>2]*q;m=+g[d+8>>2]*e;if((f|0)>0){b=0;n=-3402823466385288598117041.0e14;h=-1;while(1){o=l*+g[p+(b<<4)>>2]+j*+g[p+(b<<4)+4>>2]+m*+g[p+(b<<4)+8>>2];d=o>n;h=d?b:h;b=b+1|0;if((b|0)==(f|0))break;else n=d?o:n}}else h=-1;s=q*+g[p+(h<<4)+4>>2];t=e*+g[p+(h<<4)+8>>2];g[a>>2]=r*+g[p+(h<<4)>>2];g[a+4>>2]=s;g[a+8>>2]=t;g[a+12>>2]=0.0;i=y;return}default:{jc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);i=y;return}}}function Ly(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0.0;j=i;i=i+32|0;c[j+16>>2]=c[d>>2];c[j+16+4>>2]=c[d+4>>2];c[j+16+8>>2]=c[d+8>>2];c[j+16+12>>2]=c[d+12>>2];e=+g[j+16>>2];h=+g[j+16+4>>2];f=+g[j+16+8>>2];if(e*e+h*h+f*f<1.4210854715202004e-14){c[j+16>>2]=-1082130432;c[j+16+4>>2]=-1082130432;c[j+16+8>>2]=-1082130432;g[j+16+12>>2]=0.0;e=-1.0;h=-1.0;f=-1.0}k=1.0/+O(+(e*e+h*h+f*f));g[j+16>>2]=e*k;g[j+16+4>>2]=h*k;g[j+16+8>>2]=f*k;Ky(j,b,j+16|0);switch(c[b+4>>2]|0){case 8:{e=+g[b+28>>2]*+g[b+12>>2];break}case 0:{e=+g[b+44>>2];break}case 1:{e=+g[b+44>>2];break}case 13:{e=+g[b+44>>2];break}case 11:{e=+g[b+44>>2];break}case 10:{e=+g[b+44>>2];break}case 4:case 5:{e=+g[b+44>>2];break}default:e=+Tb[c[(c[b>>2]|0)+48>>2]&15](b)}h=e*+g[j+16+4>>2]+ +g[j+4>>2];f=e*+g[j+16+8>>2]+ +g[j+8>>2];g[a>>2]=e*+g[j+16>>2]+ +g[j>>2];g[a+4>>2]=h;g[a+8>>2]=f;g[a+12>>2]=0.0;i=j;return}function My(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;e=+N(+(+g[b>>2]));d=+N(+(+g[b+4>>2]));c=+N(+(+g[b+8>>2]));g[a+12>>2]=e;g[a+16>>2]=d;g[a+20>>2]=c;g[a+24>>2]=0.0;return}function Ny(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;j=i;i=i+96|0;f=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);h=0;do{q=j+80+(h<<2)|0;c[j+80>>2]=0;c[j+80+4>>2]=0;c[j+80+8>>2]=0;c[j+80+12>>2]=0;g[q>>2]=1.0;k=c[(c[a>>2]|0)+64>>2]|0;l=+g[j+80>>2];m=+g[j+80+4>>2];n=+g[j+80+8>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[j+48>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[j+48+4>>2]=o;g[j+48+8>>2]=p;g[j+48+12>>2]=0.0;jc[k&127](j+64|0,a,j+48|0);p=+g[j+64>>2];o=+g[j+64+4>>2];n=+g[j+64+8>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[j+32>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[j+32+4>>2]=m;g[j+32+8>>2]=l;g[j+32+12>>2]=0.0;k=j+32+(h<<2)|0;g[e+(h<<2)>>2]=f+ +g[k>>2];g[q>>2]=-1.0;q=c[(c[a>>2]|0)+64>>2]|0;l=+g[j+80>>2];m=+g[j+80+4>>2];n=+g[j+80+8>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[j>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[j+4>>2]=o;g[j+8>>2]=p;g[j+12>>2]=0.0;jc[q&127](j+16|0,a,j);p=+g[j+16>>2];o=+g[j+16+4>>2];n=+g[j+16+8>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[j+32>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[j+32+4>>2]=m;g[j+32+8>>2]=l;g[j+32+12>>2]=0.0;g[d+(h<<2)>>2]=+g[k>>2]-f;h=h+1|0}while((h|0)!=3);i=j;return}function Oy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;jc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Tb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;h=+g[d>>2];f=+g[d+4>>2];e=+g[d+8>>2];j=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:h;i=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:f;e=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:e;f=1.0/+O(+(e*e+(j*j+i*i)));h=+Tb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+h*(f*j);g[a+4>>2]=h*(f*i)+ +g[a+4>>2];g[a+8>>2]=h*(f*e)+ +g[a+8>>2];return}function Py(a,b){a=a|0;b=b|0;c[a+12>>2]=c[b>>2];c[a+12+4>>2]=c[b+4>>2];c[a+12+8>>2]=c[b+8>>2];c[a+12+12>>2]=c[b+12>>2];wy(a);return}function Qy(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;f=c[b+96>>2]|0;if((f|0)==(c[b+100>>2]|0)?(i=(f|0)!=0?f<<1:1,(f|0)<(i|0)):0){if(!i)g=0;else{c[2703]=(c[2703]|0)+1;f=XE((i<<4|3)+16|0)|0;if(!f)g=0;else{c[(f+4+15&-16)+-4>>2]=f;g=f+4+15&-16}f=c[b+96>>2]|0}if((f|0)>0){h=0;do{j=g+(h<<4)|0;k=(c[b+104>>2]|0)+(h<<4)|0;c[j>>2]=c[k>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[b+104>>2]|0;if(f){if(a[b+108>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=g;c[b+100>>2]=i;f=c[b+96>>2]|0}f=(c[b+104>>2]|0)+(f<<4)|0;c[f>>2]=c[d>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];c[b+96>>2]=(c[b+96>>2]|0)+1;if(!e)return;wy(b);return}function Ry(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,i=0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;k=c[b+96>>2]|0;if((k|0)<=0){c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;return}l=+g[b+12>>2];o=+g[d>>2]*l;m=+g[b+16>>2];p=+g[d+4>>2]*m;n=+g[b+20>>2];j=+g[d+8>>2]*n;b=c[b+104>>2]|0;f=0;h=-3402823466385288598117041.0e14;i=-1;while(1){e=o*+g[b+(f<<4)>>2]+p*+g[b+(f<<4)+4>>2]+j*+g[b+(f<<4)+8>>2];d=e>h;i=d?f:i;f=f+1|0;if((f|0)==(k|0))break;else h=d?e:h}p=+g[b+(i<<4)+4>>2]*m;e=+g[b+(i<<4)+8>>2]*n;g[a>>2]=+g[b+(i<<4)>>2]*l;g[a+4>>2]=p;g[a+8>>2]=e;g[a+12>>2]=0.0;return}function Sy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0.0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0.0,t=0;if((e|0)>0)f=0;else return;do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));m=0;do{h=+g[a+12>>2];o=+g[b+(m<<4)>>2]*h;i=+g[a+16>>2];q=+g[b+(m<<4)+4>>2]*i;j=+g[a+20>>2];p=+g[b+(m<<4)+8>>2]*j;f=c[a+96>>2]|0;if((f|0)>0){k=c[a+104>>2]|0;l=0;n=-3402823466385288598117041.0e14;r=-1;do{s=o*+g[k+(l<<4)>>2]+q*+g[k+(l<<4)+4>>2]+p*+g[k+(l<<4)+8>>2];t=s>n;r=t?l:r;n=t?s:n;l=l+1|0}while((l|0)!=(f|0));o=+g[k+(r<<4)+4>>2]*i;i=+g[k+(r<<4)+8>>2]*j;g[d+(m<<4)>>2]=+g[k+(r<<4)>>2]*h;g[d+(m<<4)+4>>2]=o;g[d+(m<<4)+8>>2]=i;g[d+(m<<4)+12>>2]=n}else g[d+(m<<4)+12>>2]=-999999984306749440.0;m=m+1|0}while((m|0)!=(e|0));return}function Ty(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;jc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Tb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;h=+g[d>>2];f=+g[d+4>>2];e=+g[d+8>>2];j=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:h;i=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:f;e=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:e;f=1.0/+O(+(e*e+(j*j+i*i)));h=+Tb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+h*(f*j);g[a+4>>2]=h*(f*i)+ +g[a+4>>2];g[a+8>>2]=h*(f*e)+ +g[a+8>>2];return}function Uy(a){a=a|0;return c[a+96>>2]|0}function Vy(a){a=a|0;return c[a+96>>2]|0}function Wy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0,j=0;i=c[a+96>>2]|0;j=c[a+104>>2]|0;f=+g[j+(((b|0)%(i|0)|0)<<4)+4>>2]*+g[a+16>>2];h=+g[j+(((b|0)%(i|0)|0)<<4)+8>>2]*+g[a+20>>2];g[d>>2]=+g[j+(((b|0)%(i|0)|0)<<4)>>2]*+g[a+12>>2];g[d+4>>2]=f;g[d+8>>2]=h;g[d+12>>2]=0.0;d=c[a+104>>2]|0;h=+g[d+(((b+1|0)%(i|0)|0)<<4)+4>>2]*+g[a+16>>2];f=+g[d+(((b+1|0)%(i|0)|0)<<4)+8>>2]*+g[a+20>>2];g[e>>2]=+g[d+(((b+1|0)%(i|0)|0)<<4)>>2]*+g[a+12>>2];g[e+4>>2]=h;g[e+8>>2]=f;g[e+12>>2]=0.0;return}function Xy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0;h=c[a+104>>2]|0;f=+g[h+(b<<4)+4>>2]*+g[a+16>>2];e=+g[h+(b<<4)+8>>2]*+g[a+20>>2];g[d>>2]=+g[h+(b<<4)>>2]*+g[a+12>>2];g[d+4>>2]=f;g[d+8>>2]=e;g[d+12>>2]=0.0;return}function Yy(a){a=a|0;return 0}function Zy(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function _y(a,b,c){a=a|0;b=b|0;c=+c;return 0}function $y(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=_b[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=_b[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Fb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+28>>2]=c[a+28>>2];c[b+32>>2]=c[a+32>>2];c[b+36>>2]=c[a+36>>2];c[b+40>>2]=c[a+40>>2];c[b+12>>2]=c[a+12>>2];c[b+16>>2]=c[a+16>>2];c[b+20>>2]=c[a+20>>2];c[b+24>>2]=c[a+24>>2];c[b+44>>2]=c[a+44>>2];f=c[a+96>>2]|0;c[b+60>>2]=f;if(!f){c[b+52>>2]=0;c[b+56>>2]=0;return 17898}c[b+52>>2]=_b[c[(c[d>>2]|0)+28>>2]&31](d,c[a+104>>2]|0)|0;c[b+56>>2]=0;g=Qb[c[(c[d>>2]|0)+16>>2]&63](d,16,f)|0;if((f|0)>0){e=c[a+104>>2]|0;b=0;a=c[g+8>>2]|0;while(1){c[a>>2]=c[e+(b<<4)>>2];c[a+4>>2]=c[e+(b<<4)+4>>2];c[a+8>>2]=c[e+(b<<4)+8>>2];c[a+12>>2]=c[e+(b<<4)+12>>2];b=b+1|0;if((b|0)==(f|0))break;else a=a+16|0}}else e=c[a+104>>2]|0;Bb[c[(c[d>>2]|0)+20>>2]&31](d,g,19903,1497453121,e);return 17898}function az(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0;r=i;i=i+16|0;g[e>>2]=3402823466385288598117041.0e14;g[f>>2]=-3402823466385288598117041.0e14;n=c[a+96>>2]|0;if((n|0)>0){q=0;do{t=c[a+104>>2]|0;s=+g[t+(q<<4)>>2]*+g[a+12>>2];l=+g[t+(q<<4)+4>>2]*+g[a+16>>2];o=+g[t+(q<<4)+8>>2]*+g[a+20>>2];m=s*+g[b>>2]+l*+g[b+4>>2]+o*+g[b+8>>2]+ +g[b+48>>2];p=s*+g[b+16>>2]+l*+g[b+20>>2]+o*+g[b+24>>2]+ +g[b+52>>2];o=s*+g[b+32>>2]+l*+g[b+36>>2]+o*+g[b+40>>2]+ +g[b+56>>2];l=m*+g[d>>2]+p*+g[d+4>>2]+o*+g[d+8>>2];if(l<+g[e>>2]){g[e>>2]=l;g[h>>2]=m;g[h+4>>2]=p;g[h+8>>2]=o;g[h+12>>2]=0.0}if(l>+g[f>>2]){g[f>>2]=l;g[j>>2]=m;g[j+4>>2]=p;g[j+8>>2]=o;g[j+12>>2]=0.0}q=q+1|0}while((q|0)!=(n|0));l=+g[f>>2];m=l;n=(g[k>>2]=l,c[k>>2]|0)}else{m=-3402823466385288598117041.0e14;n=-8388609}l=+g[e>>2];if(!(l>m)){i=r;return}c[e>>2]=n;g[f>>2]=l;c[r>>2]=c[h>>2];c[r+4>>2]=c[h+4>>2];c[r+8>>2]=c[h+8>>2];c[r+12>>2]=c[h+12>>2];c[h>>2]=c[j>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j>>2]=c[r>>2];c[j+4>>2]=c[r+4>>2];c[j+8>>2]=c[r+8>>2];c[j+12>>2]=c[r+12>>2];i=r;return}function bz(b){b=b|0;var d=0;c[b>>2]=7584;d=c[b+104>>2]|0;if(d){if(a[b+108>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=0;c[b+96>>2]=0;c[b+100>>2]=0;c[b>>2]=7356;d=c[b+52>>2]|0;if(!d)return;Db[c[c[d>>2]>>2]&255](d);d=c[b+52>>2]|0;if(!d)return;c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);return}function cz(b){b=b|0;var d=0,e=0;c[b>>2]=7584;d=c[b+104>>2]|0;if(d){if(a[b+108>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=0;c[b+96>>2]=0;c[b+100>>2]=0;c[b>>2]=7356;d=c[b+52>>2]|0;if((d|0)!=0?(Db[c[c[d>>2]>>2]&255](d),e=c[b+52>>2]|0,(e|0)!=0):0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[2704]=(c[2704]|0)+1;YE(c[b+-4>>2]|0);return}function dz(a){a=a|0;return 17920}function ez(a){a=a|0;return 68}function fz(a){a=a|0;return}function gz(a){a=a|0;return}function hz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;q=i;i=i+32|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];f=+g[d+4>>2];h=+g[d+8>>2];if(e*e+f*f+h*h<9.999999747378752e-05){p=1.0;o=0.0;n=0.0}else{n=1.0/+O(+(e*e+f*f+h*h));p=e*n;o=f*n;n=h*n}d=c[b+52>>2]|0;m=+g[b+28+(((d+2|0)%3|0)<<2)>>2];c[q+16>>2]=0;c[q+16+4>>2]=0;c[q+16+8>>2]=0;c[q+16+12>>2]=0;c[q+16+(d<<2)>>2]=c[b+28+(d<<2)>>2];k=p*m;l=o*m;m=n*m;j=k+ +g[q+16>>2];e=l+ +g[q+16+4>>2];h=m+ +g[q+16+8>>2];f=+Tb[c[(c[b>>2]|0)+48>>2]&15](b);j=j-p*f;e=e-o*f;f=h-n*f;h=n*f+(p*j+o*e);if(h>-999999984306749440.0){g[a>>2]=j;g[a+4>>2]=e;g[a+8>>2]=f;g[a+12>>2]=0.0;j=h}else j=-999999984306749440.0;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;d=c[b+52>>2]|0;g[q+(d<<2)>>2]=-+g[b+28+(d<<2)>>2];h=k+ +g[q>>2];e=l+ +g[q+4>>2];k=m+ +g[q+8>>2];f=+Tb[c[(c[b>>2]|0)+48>>2]&15](b);h=h-p*f;e=e-o*f;f=k-n*f;if(!(n*f+(p*h+o*e)>j)){i=q;return}g[a>>2]=h;g[a+4>>2]=e;g[a+8>>2]=f;g[a+12>>2]=0.0;i=q;return}function iz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0,y=0;x=i;i=i+32|0;f=c[a+52>>2]|0;w=+g[a+28+(((f+2|0)%3|0)<<2)>>2];if((e|0)<=0){i=x;return}h=0;while(1){c[x+16>>2]=0;c[x+16+4>>2]=0;c[x+16+8>>2]=0;c[x+16+12>>2]=0;c[x+16+(f<<2)>>2]=c[a+28+(f<<2)>>2];f=b+(h<<4)|0;u=b+(h<<4)+4|0;v=b+(h<<4)+8|0;p=w*+g[f>>2]+ +g[x+16>>2];k=w*+g[u>>2]+ +g[x+16+4>>2];l=w*+g[v>>2]+ +g[x+16+8>>2];j=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);o=+g[f>>2];n=+g[u>>2];m=+g[v>>2];if(o*(p-j*o)+n*(k-j*n)+m*(l-j*m)>-999999984306749440.0){g[d+(h<<4)>>2]=p-j*o;g[d+(h<<4)+4>>2]=k-j*n;g[d+(h<<4)+8>>2]=l-j*m;g[d+(h<<4)+12>>2]=0.0;q=+g[f>>2];s=+g[u>>2];t=+g[v>>2];r=o*(p-j*o)+n*(k-j*n)+m*(l-j*m)}else{q=o;s=n;t=m;r=-999999984306749440.0};c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;y=c[a+52>>2]|0;g[x+(y<<2)>>2]=-+g[a+28+(y<<2)>>2];p=w*q+ +g[x>>2];o=w*s+ +g[x+4>>2];m=w*t+ +g[x+8>>2];n=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);l=+g[f>>2];k=+g[u>>2];j=+g[v>>2];if(l*(p-n*l)+k*(o-n*k)+j*(m-n*j)>r){g[d+(h<<4)>>2]=p-n*l;g[d+(h<<4)+4>>2]=o-n*k;g[d+(h<<4)+8>>2]=m-n*j;g[d+(h<<4)+12>>2]=0.0}h=h+1|0;if((h|0)==(e|0))break;f=c[a+52>>2]|0}i=x;return}function jz(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0;e=i;i=i+16|0;k=c[a+52>>2]|0;l=c[a+28+(((k+2|0)%3|0)<<2)>>2]|0;c[e>>2]=l;c[e+4>>2]=l;c[e+8>>2]=l;g[e+12>>2]=0.0;g[e+(k<<2)>>2]=+g[a+28+(k<<2)>>2]+ +g[e+(k<<2)>>2];h=(+g[e>>2]+.03999999910593033)*2.0;f=(+g[e+4>>2]+.03999999910593033)*2.0;j=(+g[e+8>>2]+.03999999910593033)*2.0;g[d>>2]=b*.0833333283662796*(f*f+j*j);g[d+4>>2]=b*.0833333283662796*(h*h+j*j);g[d+8>>2]=b*.0833333283662796*(h*h+f*f);i=e;return}function kz(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function lz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0;f=i;i=i+16|0;y=c[a+52>>2]|0;z=c[a+28+(((y+2|0)%3|0)<<2)>>2]|0;c[f>>2]=z;c[f+4>>2]=z;c[f+8>>2]=z;g[f+12>>2]=0.0;g[f+(y<<2)>>2]=(c[k>>2]=z,+g[k>>2])+ +g[a+28+(y<<2)>>2];l=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);o=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);l=l+ +g[f>>2];g[f>>2]=l;h=h+ +g[f+4>>2];g[f+4>>2]=h;o=o+ +g[f+8>>2];v=+N(+(+g[b>>2]));u=+N(+(+g[b+4>>2]));w=+N(+(+g[b+8>>2]));r=+N(+(+g[b+16>>2]));q=+N(+(+g[b+20>>2]));s=+N(+(+g[b+24>>2]));m=+N(+(+g[b+32>>2]));j=+N(+(+g[b+36>>2]));n=+N(+(+g[b+40>>2]));x=+g[b+48>>2];t=+g[b+52>>2];p=+g[b+56>>2];g[d>>2]=x-(o*w+(v*l+u*h));g[d+4>>2]=t-(o*s+(r*l+q*h));g[d+8>>2]=p-(o*n+(m*l+j*h));g[d+12>>2]=0.0;g[e>>2]=x+(o*w+(v*l+u*h));g[e+4>>2]=t+(o*s+(r*l+q*h));g[e+8>>2]=p+(o*n+(m*l+j*h));g[e+12>>2]=0.0;i=f;return}function mz(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;k=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);m=(k+ +g[a+28>>2])/+g[a+12>>2];j=(h+ +g[a+32>>2])/+g[a+16>>2];f=(d+ +g[a+36>>2])/+g[a+20>>2];l=+N(+(+g[b>>2]));i=+N(+(+g[b+4>>2]));e=+N(+(+g[b+8>>2]));g[a+12>>2]=l;g[a+16>>2]=i;g[a+20>>2]=e;g[a+24>>2]=0.0;g[a+28>>2]=m*l-k;g[a+32>>2]=j*i-h;g[a+36>>2]=f*e-d;g[a+40>>2]=0.0;return}function nz(a){a=a|0;return 18036}function oz(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[a+(c[b+52>>2]<<2)>>2]=1.0;return}function pz(a,b){a=a|0;b=+b;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;h=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);h=h+ +g[a+28>>2];e=e+ +g[a+32>>2];i=i+ +g[a+36>>2];g[a+44>>2]=b;f=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);b=i-+Tb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=h-f;g[a+32>>2]=e-d;g[a+36>>2]=b;g[a+40>>2]=0.0;return}function qz(a){a=a|0;return 60}function rz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=_b[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=_b[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Fb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+28>>2]=c[a+28>>2];c[b+32>>2]=c[a+32>>2];c[b+36>>2]=c[a+36>>2];c[b+40>>2]=c[a+40>>2];c[b+12>>2]=c[a+12>>2];c[b+16>>2]=c[a+16>>2];c[b+20>>2]=c[a+20>>2];c[b+24>>2]=c[a+24>>2];c[b+44>>2]=c[a+44>>2];c[b+52>>2]=c[a+52>>2];return 18017}function sz(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function tz(a){a=a|0;return 18008}function uz(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function vz(a){a=a|0;return 17999}function wz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0,j=0.0,l=0,m=0,n=0,o=0.0;m=i;i=i+80|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];f=+g[d+4>>2];j=+g[d+8>>2];if(e*e+f*f+j*j<9.999999747378752e-05){l=1065353216;h=0;e=0.0;d=0}else{o=1.0/+O(+(e*e+f*f+j*j));l=(g[k>>2]=e*o,c[k>>2]|0);n=(g[k>>2]=f*o,c[k>>2]|0);h=(g[k>>2]=j*o,c[k>>2]|0);e=+g[d+12>>2];d=n}c[m+32>>2]=8152;n=m+32+4|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[m+32+20>>2]=-999999984306749440.0;c[m+32+24>>2]=l;c[m+32+28>>2]=d;c[m+32+32>>2]=h;g[m+32+36>>2]=e;c[m+16>>2]=1566444395;c[m+16+4>>2]=1566444395;c[m+16+8>>2]=1566444395;g[m+16+12>>2]=0.0;d=c[b+92>>2]|0;h=c[(c[d>>2]|0)+8>>2]|0;g[m>>2]=-999999984306749440.0;g[m+4>>2]=-999999984306749440.0;g[m+8>>2]=-999999984306749440.0;g[m+12>>2]=0.0;nc[h&127](d,m+32|0,m,m+16|0);c[a>>2]=c[n>>2];c[a+4>>2]=c[n+4>>2];c[a+8>>2]=c[n+8>>2];c[a+12>>2]=c[n+12>>2];i=m;return}function xz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0;j=i;i=i+80|0;if((e|0)>0)f=0;else{i=j;return}do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));h=j+32+4|0;f=0;do{k=b+(f<<4)|0;c[j+32>>2]=8152;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;g[j+32+20>>2]=-999999984306749440.0;c[j+32+24>>2]=c[k>>2];c[j+32+24+4>>2]=c[k+4>>2];c[j+32+24+8>>2]=c[k+8>>2];c[j+32+24+12>>2]=c[k+12>>2];c[j+16>>2]=1566444395;c[j+16+4>>2]=1566444395;c[j+16+8>>2]=1566444395;g[j+16+12>>2]=0.0;k=c[a+92>>2]|0;l=c[(c[k>>2]|0)+8>>2]|0;g[j>>2]=-999999984306749440.0;g[j+4>>2]=-999999984306749440.0;g[j+8>>2]=-999999984306749440.0;g[j+12>>2]=0.0;nc[l&127](k,j+32|0,j,j+16|0);k=d+(f<<4)|0;c[k>>2]=c[h>>2];c[k+4>>2]=c[h+4>>2];c[k+8>>2]=c[h+8>>2];c[k+12>>2]=c[h+12>>2];f=f+1|0}while((f|0)<(e|0));i=j;return}function yz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;jc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Tb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;h=+g[d>>2];f=+g[d+4>>2];e=+g[d+8>>2];j=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:h;i=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:f;e=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:e;f=1.0/+O(+(e*e+(j*j+i*i)));h=+Tb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+h*(f*j);g[a+4>>2]=h*(f*i)+ +g[a+4>>2];g[a+8>>2]=h*(f*e)+ +g[a+8>>2];return}function zz(a){a=a|0;return 0}function Az(a){a=a|0;return 0}function Bz(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function Cz(a,b,c){a=a|0;b=b|0;c=c|0;return}function Dz(a){a=a|0;return 0}function Ez(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function Fz(a,b,c){a=a|0;b=b|0;c=+c;return 0}function Gz(a,b){a=a|0;b=b|0;var d=0;d=(c[a+92>>2]|0)+4|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];wy(a);return}function Hz(a){a=a|0;return (c[a+92>>2]|0)+4|0}function Iz(a){a=a|0;YE(a);return}function Jz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;i=+g[a+24>>2];j=+g[a+28>>2];k=+g[a+32>>2];h=i*+g[b>>2]+j*+g[b+4>>2]+k*+g[b+8>>2];f=+g[a+20>>2];if(h>f){g[a+20>>2]=h;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];f=h}h=i*+g[b+16>>2]+j*+g[b+20>>2]+k*+g[b+24>>2];if(h>f){g[a+20>>2]=h;c[a+4>>2]=c[b+16>>2];c[a+4+4>>2]=c[b+16+4>>2];c[a+4+8>>2]=c[b+16+8>>2];c[a+4+12>>2]=c[b+16+12>>2]}else h=f;f=i*+g[b+32>>2]+j*+g[b+36>>2]+k*+g[b+40>>2];if(!(f>h))return;g[a+20>>2]=f;c[a+4>>2]=c[b+32>>2];c[a+4+4>>2]=c[b+32+4>>2];c[a+4+8>>2]=c[b+32+8>>2];c[a+4+12>>2]=c[b+32+12>>2];return}function Kz(a){a=a|0;var b=0,d=0;c[a>>2]=7356;b=c[a+52>>2]|0;if((b|0)!=0?(Db[c[c[b>>2]>>2]&255](b),d=c[a+52>>2]|0,(d|0)!=0):0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function Lz(a){a=a|0;return 18113}function Mz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;i=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);m=i+ +g[a+28>>2];k=i+ +g[a+32>>2];i=i+ +g[a+36>>2];u=+N(+(+g[b>>2]));t=+N(+(+g[b+4>>2]));s=+N(+(+g[b+8>>2]));q=+N(+(+g[b+16>>2]));p=+N(+(+g[b+20>>2]));o=+N(+(+g[b+24>>2]));l=+N(+(+g[b+32>>2]));j=+N(+(+g[b+36>>2]));h=+N(+(+g[b+40>>2]));r=+g[b+48>>2];n=+g[b+52>>2];f=+g[b+56>>2];g[d>>2]=r-(m*u+k*t+i*s);g[d+4>>2]=n-(m*q+k*p+i*o);g[d+8>>2]=f-(m*l+k*j+i*h);g[d+12>>2]=0.0;g[e>>2]=m*u+k*t+i*s+r;g[e+4>>2]=m*q+k*p+i*o+n;g[e+8>>2]=m*l+k*j+i*h+f;g[e+12>>2]=0.0;return}function Nz(a,b,d){a=a|0;b=+b;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;i=+g[a+28>>2];f=+g[a+32>>2];j=+g[a+36>>2];h=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);j=(j+ +Tb[c[(c[a>>2]|0)+48>>2]&15](a))*2.0;g[d>>2]=b/12.0*((f+e)*2.0*((f+e)*2.0)+j*j);g[d+4>>2]=b/12.0*((i+h)*2.0*((i+h)*2.0)+j*j);g[d+8>>2]=b/12.0*((i+h)*2.0*((i+h)*2.0)+(f+e)*2.0*((f+e)*2.0));g[d+12>>2]=0.0;return}function Oz(a,b){a=a|0;b=+b;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;h=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);h=h+ +g[a+28>>2];e=e+ +g[a+32>>2];i=i+ +g[a+36>>2];g[a+44>>2]=b;f=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);b=i-+Tb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=h-f;g[a+32>>2]=e-d;g[a+36>>2]=b;g[a+40>>2]=0.0;return}function Pz(a){a=a|0;var b=0,d=0;c[a>>2]=7356;b=c[a+52>>2]|0;if((b|0)!=0?(Db[c[c[b>>2]>>2]&255](b),d=c[a+52>>2]|0,(d|0)!=0):0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function Qz(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;k=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);m=(k+ +g[a+28>>2])/+g[a+12>>2];j=(h+ +g[a+32>>2])/+g[a+16>>2];f=(d+ +g[a+36>>2])/+g[a+20>>2];l=+N(+(+g[b>>2]));i=+N(+(+g[b+4>>2]));e=+N(+(+g[b+8>>2]));g[a+12>>2]=l;g[a+16>>2]=i;g[a+20>>2]=e;g[a+24>>2]=0.0;g[a+28>>2]=m*l-k;g[a+32>>2]=j*i-h;g[a+36>>2]=f*e-d;g[a+40>>2]=0.0;return}function Rz(a){a=a|0;return 18186}function Sz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;i=+g[b+28>>2];j=+g[b+32>>2];e=+g[b+36>>2];h=+Tb[c[(c[b>>2]|0)+48>>2]&15](b);f=+Tb[c[(c[b>>2]|0)+48>>2]&15](b);e=e+ +Tb[c[(c[b>>2]|0)+48>>2]&15](b);f=+g[d+4>>2]>=0.0?j+f:-(j+f);e=+g[d+8>>2]>=0.0?e:-e;g[a>>2]=+g[d>>2]>=0.0?i+h:-(i+h);g[a+4>>2]=f;g[a+8>>2]=e;g[a+12>>2]=0.0;return}function Tz(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0;f=+g[b+28>>2];e=+g[b+32>>2];e=+g[c+4>>2]>=0.0?e:-e;d=+g[b+36>>2];d=+g[c+8>>2]>=0.0?d:-d;g[a>>2]=+g[c>>2]>=0.0?f:-f;g[a+4>>2]=e;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function Uz(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0;if((d|0)<=0)return;e=0;do{i=+g[a+28>>2];h=+g[a+32>>2];h=+g[b+(e<<4)+4>>2]>=0.0?h:-h;f=+g[a+36>>2];f=+g[b+(e<<4)+8>>2]>=0.0?f:-f;g[c+(e<<4)>>2]=+g[b+(e<<4)>>2]>=0.0?i:-i;g[c+(e<<4)+4>>2]=h;g[c+(e<<4)+8>>2]=f;g[c+(e<<4)+12>>2]=0.0;e=e+1|0}while((e|0)!=(d|0));return}function Vz(a){a=a|0;return 6}function Wz(a,b,d){a=a|0;b=b|0;d=d|0;switch(b|0){case 0:{c[d>>2]=1065353216;c[d+4>>2]=0;c[d+8>>2]=0;g[d+12>>2]=0.0;return}case 1:{c[d>>2]=-1082130432;c[d+4>>2]=0;c[d+8>>2]=0;g[d+12>>2]=0.0;return}case 2:{c[d>>2]=0;c[d+4>>2]=1065353216;c[d+8>>2]=0;g[d+12>>2]=0.0;return}case 3:{c[d>>2]=0;c[d+4>>2]=-1082130432;c[d+8>>2]=0;g[d+12>>2]=0.0;return}case 4:{c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=1065353216;g[d+12>>2]=0.0;return}case 5:{c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=-1082130432;g[d+12>>2]=0.0;return}default:return}}function Xz(a){a=a|0;return 8}function Yz(a){a=a|0;return 12}function Zz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;do switch(b|0){case 0:{f=0;b=1;break}case 1:{f=0;b=2;break}case 2:{f=1;b=3;break}case 3:{f=2;break}case 4:{f=0;break}case 5:{f=1;break}case 6:{f=2;break}case 7:{f=3;break}case 8:{f=4;b=5;break}case 9:{f=4;b=6;break}case 10:{f=5;b=7;break}case 11:{f=6;b=7;break}default:{f=0;b=0}}while(0);jc[c[(c[a>>2]|0)+108>>2]&127](a,f,d);jc[c[(c[a>>2]|0)+108>>2]&127](a,b,e);return}function _z(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;j=+g[a+28>>2];h=+g[a+32>>2];e=+g[a+36>>2];i=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);e=e+ +Tb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=+(b&1^1|0)*(j+i)-+(b&1|0)*(j+i);g[d+4>>2]=+(b>>>1&1^1|0)*(h+f)-+(b>>>1&1|0)*(h+f);g[d+8>>2]=+(b>>>2&1^1|0)*e-+(b>>>2&1|0)*e;g[d+12>>2]=0.0;return}function $z(a){a=a|0;return 6}function aA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,l=0.0,m=0,n=0,o=0;f=i;i=i+48|0;jc[c[(c[a>>2]|0)+124>>2]&127](a,f+32|0,e);o=c[f+32>>2]|0;n=c[f+32+4>>2]|0;m=c[f+32+8>>2]|0;c[b>>2]=o;c[b+4>>2]=n;c[b+8>>2]=m;g[b+12>>2]=0.0;e=c[(c[a>>2]|0)+64>>2]|0;l=-(c[k>>2]=o,+g[k>>2]);j=-(c[k>>2]=n,+g[k>>2]);h=-(c[k>>2]=m,+g[k>>2]);g[f>>2]=l;g[f+4>>2]=j;g[f+8>>2]=h;g[f+12>>2]=0.0;jc[e&127](f+16|0,a,f);c[d>>2]=c[f+16>>2];c[d+4>>2]=c[f+16+4>>2];c[d+8>>2]=c[f+16+8>>2];c[d+12>>2]=c[f+16+12>>2];i=f;return}function bA(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0,e=0.0,f=0.0,h=0.0;e=+g[a+28>>2];f=+g[a+32>>2];h=+g[a+36>>2];d=+g[b>>2];if(!(d<=e+c)){a=0;return a|0}if(!(d>=-e-c)){a=0;return a|0}d=+g[b+4>>2];if(!(d<=f+c)){a=0;return a|0}if(!(d>=-f-c)){a=0;return a|0}d=+g[b+8>>2];if(!(d<=h+c)){a=0;return a|0}a=d>=-h-c;return a|0}function cA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0;f=+g[a+28>>2];h=+g[a+32>>2];e=+g[a+36>>2];switch(d|0){case 0:{c[b>>2]=1065353216;c[b+4>>2]=0;c[b+8>>2]=0;g[b+12>>2]=-f;return}case 1:{c[b>>2]=-1082130432;c[b+4>>2]=0;c[b+8>>2]=0;g[b+12>>2]=-f;return}case 2:{c[b>>2]=0;c[b+4>>2]=1065353216;c[b+8>>2]=0;g[b+12>>2]=-h;return}case 3:{c[b>>2]=0;c[b+4>>2]=-1082130432;c[b+8>>2]=0;g[b+12>>2]=-h;return}case 4:{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=1065353216;g[b+12>>2]=-e;return}case 5:{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=-1082130432;g[b+12>>2]=-e;return}default:return}}function dA(a){a=a|0;zC(a);return}function eA(a){a=a|0;zC(a);if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function fA(d,e,f,h,j){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0.0,n=0.0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0;z=i;i=i+176|0;a[d+60>>0]=f&1;if(f){s=+g[h>>2]+-1.0;w=+g[h+4>>2]+-1.0;v=+g[h+8>>2]+-1.0;g[d+4>>2]=s;g[d+8>>2]=w;g[d+12>>2]=v;g[d+16>>2]=0.0;q=+g[j>>2]+1.0;n=+g[j+4>>2]+1.0;y=+g[j+8>>2]+1.0;g[d+20>>2]=q;g[d+24>>2]=n;g[d+28>>2]=y;g[d+32>>2]=0.0;g[d+36>>2]=65533.0/(q-s);g[d+40>>2]=65533.0/(n-w);g[d+44>>2]=65533.0/(y-v);g[d+48>>2]=0.0;a[d+60>>0]=1;m=s+ +(~~((s-s)*(65533.0/(q-s)))&65534)/(65533.0/(q-s))+-1.0;r=w+ +(~~((w-w)*(65533.0/(n-w)))&65534)/(65533.0/(n-w))+-1.0;t=v+ +(~~((v-v)*(65533.0/(y-v)))&65534)/(65533.0/(y-v))+-1.0;if(m<s){g[d+4>>2]=m;x=m}else x=s;if(r<w)g[d+8>>2]=r;else r=w;if(t<v){g[d+12>>2]=t;u=t}else u=v;s=x+ +((~~((q-x)*(65533.0/(q-s))+1.0)&65535|1)&65535)/(65533.0/(q-s))+1.0;t=r+ +((~~((n-r)*(65533.0/(n-w))+1.0)&65535|1)&65535)/(65533.0/(n-w))+1.0;m=u+ +((~~((y-u)*(65533.0/(y-v))+1.0)&65535|1)&65535)/(65533.0/(y-v))+1.0;if(q<s){g[d+20>>2]=s;q=s}if(n<t){g[d+24>>2]=t;n=t}if(y<m)g[d+28>>2]=m;else m=y;g[d+36>>2]=65533.0/(q-x);g[d+40>>2]=65533.0/(n-r);g[d+44>>2]=65533.0/(m-u);g[d+48>>2]=0.0;c[z+152>>2]=8348;c[z+152+4>>2]=d+104;c[z+152+8>>2]=d;nc[c[(c[e>>2]|0)+8>>2]&127](e,z+152|0,d+4|0,d+20|0);k=c[d+108>>2]|0;c[z+136>>2]=0;c[z+136+4>>2]=0;c[z+136+8>>2]=0;c[z+136+12>>2]=0;j=c[d+128>>2]|0;if((j|0)<(k<<1|0)){if((c[d+132>>2]|0)<(k<<1|0)){if(!k){h=j;f=0}else{c[2703]=(c[2703]|0)+1;l=XE(k<<5|19)|0;if(!l)f=0;else{c[(l+4+15&-16)+-4>>2]=l;f=l+4+15&-16}h=c[d+128>>2]|0}if((h|0)>0){l=0;do{o=f+(l<<4)|0;p=(c[d+136>>2]|0)+(l<<4)|0;c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];l=l+1|0}while((l|0)!=(h|0))}l=c[d+136>>2]|0;if(l){if(a[d+140>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[l+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=f;c[d+132>>2]=k<<1;f=d+136|0}else f=d+136|0;l=j;do{h=(c[f>>2]|0)+(l<<4)|0;c[h>>2]=c[z+136>>2];c[h+4>>2]=c[z+136+4>>2];c[h+8>>2]=c[z+136+8>>2];c[h+12>>2]=c[z+136+12>>2];l=l+1|0}while((l|0)!=(k<<1|0))}c[d+128>>2]=k<<1}else{c[z+128>>2]=8368;c[z+128+4>>2]=d+64;c[z+112>>2]=-581039253;c[z+112+4>>2]=-581039253;c[z+112+8>>2]=-581039253;g[z+112+12>>2]=0.0;c[z+96>>2]=1566444395;c[z+96+4>>2]=1566444395;c[z+96+8>>2]=1566444395;g[z+96+12>>2]=0.0;nc[c[(c[e>>2]|0)+8>>2]&127](e,z+128|0,z+112|0,z+96|0);k=c[d+68>>2]|0;o=z+32|0;e=o+64|0;do{c[o>>2]=0;o=o+4|0}while((o|0)<(e|0));h=c[d+88>>2]|0;if((h|0)<(k<<1|0)){if((c[d+92>>2]|0)<(k<<1|0)){if(!k){j=h;f=0}else{c[2703]=(c[2703]|0)+1;l=XE(k<<7|19)|0;if(!l)f=0;else{c[(l+4+15&-16)+-4>>2]=l;f=l+4+15&-16}j=c[d+88>>2]|0}if((j|0)>0){l=0;do{o=f+(l<<6)|0;p=(c[d+96>>2]|0)+(l<<6)|0;e=o+64|0;do{c[o>>2]=c[p>>2];o=o+4|0;p=p+4|0}while((o|0)<(e|0));l=l+1|0}while((l|0)!=(j|0))}l=c[d+96>>2]|0;if(l){if(a[d+100>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[l+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=f;c[d+92>>2]=k<<1;f=d+96|0}else f=d+96|0;do{o=(c[f>>2]|0)+(h<<6)|0;p=z+32|0;e=o+64|0;do{c[o>>2]=c[p>>2];o=o+4|0;p=p+4|0}while((o|0)<(e|0));h=h+1|0}while((h|0)!=(k<<1|0))}c[d+88>>2]=k<<1}c[d+56>>2]=0;yC(d,0,k);if((a[d+60>>0]|0)!=0?(c[d+152>>2]|0)==0:0){if(!(c[d+156>>2]|0)){c[2703]=(c[2703]|0)+1;k=XE(51)|0;if(!k)h=0;else{c[(k+4+15&-16)+-4>>2]=k;h=k+4+15&-16}k=c[d+152>>2]|0;if((k|0)>0){l=0;do{f=h+(l<<5)|0;j=(c[d+160>>2]|0)+(l<<5)|0;c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];c[f+16>>2]=c[j+16>>2];c[f+20>>2]=c[j+20>>2];c[f+24>>2]=c[j+24>>2];c[f+28>>2]=c[j+28>>2];l=l+1|0}while((l|0)!=(k|0))}k=c[d+160>>2]|0;if(k){if(a[d+164>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[k+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=h;c[d+156>>2]=1;f=(c[d+152>>2]|0)+1|0;k=h;l=d+160|0}else{f=1;k=c[d+160>>2]|0;l=d+160|0}c[d+152>>2]=f;c[k>>2]=c[z>>2];c[k+4>>2]=c[z+4>>2];c[k+8>>2]=c[z+8>>2];c[k+12>>2]=c[z+12>>2];c[k+16>>2]=c[z+16>>2];c[k+20>>2]=c[z+20>>2];c[k+24>>2]=c[z+24>>2];c[k+28>>2]=c[z+28>>2];k=c[l>>2]|0;l=c[d+136>>2]|0;b[k>>1]=b[l>>1]|0;b[k+2>>1]=b[l+2>>1]|0;b[k+4>>1]=b[l+4>>1]|0;b[k+6>>1]=b[l+6>>1]|0;b[k+8>>1]=b[l+8>>1]|0;b[k+10>>1]=b[l+10>>1]|0;c[k+12>>2]=0;l=c[l+12>>2]|0;c[k+16>>2]=(l|0)>-1?1:0-l|0}c[d+168>>2]=c[d+152>>2];k=c[d+116>>2]|0;if(k){if(a[d+120>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[k+-4>>2]|0)}c[d+116>>2]=0}a[d+120>>0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;k=c[d+76>>2]|0;if(!k){a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;k=d+72|0;c[k>>2]=0;i=z;return}if(a[d+80>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[k+-4>>2]|0)}c[d+76>>2]=0;a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;k=d+72|0;c[k>>2]=0;i=z;return}function gA(a){a=a|0;YE(a);return}function hA(d,e,f,h){d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0;i=+g[e>>2];l=(g[k>>2]=i,c[k>>2]|0);r=i<999999984306749440.0?l:1566444395;j=+g[e+4>>2];o=(g[k>>2]=j,c[k>>2]|0);u=j<999999984306749440.0?o:1566444395;w=+g[e+8>>2];q=(g[k>>2]=w,c[k>>2]|0);z=w<999999984306749440.0?q:1566444395;l=i>-999999984306749440.0?l:-581039253;o=j>-999999984306749440.0?o:-581039253;q=w>-999999984306749440.0?q:-581039253;w=+g[e+16>>2];t=w<(c[k>>2]=r,+g[k>>2]);m=(g[k>>2]=w,c[k>>2]|0);r=t?m:r;j=+g[e+20>>2];t=j<(c[k>>2]=u,+g[k>>2]);n=(g[k>>2]=j,c[k>>2]|0);u=t?n:u;i=+g[e+24>>2];t=i<(c[k>>2]=z,+g[k>>2]);p=(g[k>>2]=i,c[k>>2]|0);z=t?p:z;v=(c[k>>2]=l,+g[k>>2])<w?m:l;t=(c[k>>2]=o,+g[k>>2])<j?n:o;s=(c[k>>2]=q,+g[k>>2])<i?p:q;w=+g[e+32>>2];q=w<(c[k>>2]=r,+g[k>>2]);o=(g[k>>2]=w,c[k>>2]|0);q=q?o:r;i=+g[e+36>>2];m=i<(c[k>>2]=u,+g[k>>2]);n=(g[k>>2]=i,c[k>>2]|0);m=m?n:u;j=+g[e+40>>2];l=j<(c[k>>2]=z,+g[k>>2]);p=(g[k>>2]=j,c[k>>2]|0);l=l?p:z;o=(c[k>>2]=v,+g[k>>2])<w?o:v;n=(c[k>>2]=t,+g[k>>2])<i?n:t;p=(c[k>>2]=s,+g[k>>2])<j?p:s;i=(c[k>>2]=o,+g[k>>2]);j=(c[k>>2]=q,+g[k>>2]);if(i-j<2.0000000949949026e-03){o=(g[k>>2]=i+1.0000000474974513e-03,c[k>>2]|0);q=(g[k>>2]=j+-1.0000000474974513e-03,c[k>>2]|0)}i=(c[k>>2]=n,+g[k>>2]);j=(c[k>>2]=m,+g[k>>2]);if(i-j<2.0000000949949026e-03){n=(g[k>>2]=i+1.0000000474974513e-03,c[k>>2]|0);m=(g[k>>2]=j+-1.0000000474974513e-03,c[k>>2]|0)}i=(c[k>>2]=p,+g[k>>2]);j=(c[k>>2]=l,+g[k>>2]);if(i-j<2.0000000949949026e-03){p=(g[k>>2]=i+1.0000000474974513e-03,c[k>>2]|0);l=(g[k>>2]=j+-1.0000000474974513e-03,c[k>>2]|0)}u=c[d+8>>2]|0;i=+g[u+4>>2];A=(c[k>>2]=q,+g[k>>2])-i;j=+g[u+8>>2];y=(c[k>>2]=m,+g[k>>2])-j;C=+g[u+12>>2];w=+g[u+36>>2];x=+g[u+40>>2];B=+g[u+44>>2];u=~~(((c[k>>2]=l,+g[k>>2])-C)*B)&65534;i=(c[k>>2]=o,+g[k>>2])-i;j=(c[k>>2]=n,+g[k>>2])-j;s=(~~(((c[k>>2]=p,+g[k>>2])-C)*B+1.0)&65535|1)&65535;q=c[d+4>>2]|0;l=c[q+4>>2]|0;if((l|0)!=(c[q+8>>2]|0)){t=l;r=q+12|0;r=c[r>>2]|0;p=r+(t<<4)|0;b[p>>1]=~~(A*w)&65534;p=r+(t<<4)+2|0;b[p>>1]=~~(y*x)&65534;p=r+(t<<4)+4|0;b[p>>1]=u;u=r+(t<<4)+6|0;b[u>>1]=~~(i*w+1.0)&65535|1;u=r+(t<<4)+8|0;b[u>>1]=~~(j*x+1.0)&65535|1;u=r+(t<<4)+10|0;b[u>>1]=s;u=r+(t<<4)+12|0;c[u>>2]=f<<21|h;u=c[q+4>>2]|0;u=u+1|0;c[q+4>>2]=u;return}r=(l|0)!=0?l<<1:1;if((l|0)>=(r|0)){t=l;r=q+12|0;r=c[r>>2]|0;p=r+(t<<4)|0;b[p>>1]=~~(A*w)&65534;p=r+(t<<4)+2|0;b[p>>1]=~~(y*x)&65534;p=r+(t<<4)+4|0;b[p>>1]=u;u=r+(t<<4)+6|0;b[u>>1]=~~(i*w+1.0)&65535|1;u=r+(t<<4)+8|0;b[u>>1]=~~(j*x+1.0)&65535|1;u=r+(t<<4)+10|0;b[u>>1]=s;u=r+(t<<4)+12|0;c[u>>2]=f<<21|h;u=c[q+4>>2]|0;u=u+1|0;c[q+4>>2]=u;return}if(!r)m=0;else{c[2703]=(c[2703]|0)+1;l=XE((r<<4|3)+16|0)|0;if(!l)m=0;else{c[(l+4+15&-16)+-4>>2]=l;m=l+4+15&-16}l=c[q+4>>2]|0}if((l|0)>0){n=0;do{t=m+(n<<4)|0;p=(c[q+12>>2]|0)+(n<<4)|0;c[t>>2]=c[p>>2];c[t+4>>2]=c[p+4>>2];c[t+8>>2]=c[p+8>>2];c[t+12>>2]=c[p+12>>2];n=n+1|0}while((n|0)!=(l|0))}l=c[q+12>>2]|0;if(l){if(a[q+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[l+-4>>2]|0)}c[q+12>>2]=0}a[q+16>>0]=1;c[q+12>>2]=m;c[q+8>>2]=r;t=c[q+4>>2]|0;r=q+12|0;r=c[r>>2]|0;p=r+(t<<4)|0;b[p>>1]=~~(A*w)&65534;p=r+(t<<4)+2|0;b[p>>1]=~~(y*x)&65534;p=r+(t<<4)+4|0;b[p>>1]=u;u=r+(t<<4)+6|0;b[u>>1]=~~(i*w+1.0)&65535|1;u=r+(t<<4)+8|0;b[u>>1]=~~(j*x+1.0)&65535|1;u=r+(t<<4)+10|0;b[u>>1]=s;u=r+(t<<4)+12|0;c[u>>2]=f<<21|h;u=c[q+4>>2]|0;u=u+1|0;c[q+4>>2]=u;return}function iA(a){a=a|0;YE(a);return}function jA(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0,D=0.0;C=i;i=i+32|0;q=+g[d>>2];n=(g[k>>2]=q,c[k>>2]|0);t=q<999999984306749440.0?n:1566444395;p=+g[d+4>>2];l=(g[k>>2]=p,c[k>>2]|0);u=p<999999984306749440.0?l:1566444395;D=+g[d+8>>2];h=(g[k>>2]=D,c[k>>2]|0);w=D<999999984306749440.0?h:1566444395;s=+g[d+12>>2];y=s<0.0?s:0.0;n=q>-999999984306749440.0?n:-581039253;l=p>-999999984306749440.0?l:-581039253;h=D>-999999984306749440.0?h:-581039253;s=s>0.0?s:0.0;D=+g[d+16>>2];v=D<(c[k>>2]=t,+g[k>>2]);o=(g[k>>2]=D,c[k>>2]|0);t=v?o:t;p=+g[d+20>>2];v=p<(c[k>>2]=u,+g[k>>2]);m=(g[k>>2]=p,c[k>>2]|0);u=v?m:u;q=+g[d+24>>2];v=q<(c[k>>2]=w,+g[k>>2]);j=(g[k>>2]=q,c[k>>2]|0);w=v?j:w;r=+g[d+28>>2];y=r<y?r:y;x=(c[k>>2]=n,+g[k>>2])<D?o:n;v=(c[k>>2]=l,+g[k>>2])<p?m:l;l=(c[k>>2]=h,+g[k>>2])<q?j:h;p=s<r?r:s;D=+g[d+32>>2];A=D<(c[k>>2]=t,+g[k>>2]);o=(g[k>>2]=D,c[k>>2]|0);A=A?o:t;s=+g[d+36>>2];z=s<(c[k>>2]=u,+g[k>>2]);n=(g[k>>2]=s,c[k>>2]|0);z=z?n:u;q=+g[d+40>>2];t=q<(c[k>>2]=w,+g[k>>2]);m=(g[k>>2]=q,c[k>>2]|0);w=t?m:w;r=+g[d+44>>2];y=r<y?r:y;d=(c[k>>2]=x,+g[k>>2])<D?o:x;v=(c[k>>2]=v,+g[k>>2])<s?n:v;u=(c[k>>2]=l,+g[k>>2])<q?m:l;s=p<r?r:p;t=c[b+4>>2]|0;h=c[t+4>>2]|0;if((h|0)==(c[t+8>>2]|0)?(B=(h|0)!=0?h<<1:1,(h|0)<(B|0)):0){if(!B)j=0;else{c[2703]=(c[2703]|0)+1;h=XE(B<<6|19)|0;if(!h)j=0;else{c[(h+4+15&-16)+-4>>2]=h;j=h+4+15&-16}h=c[t+4>>2]|0}if((h|0)>0){l=0;do{m=j+(l<<6)|0;n=(c[t+12>>2]|0)+(l<<6)|0;o=m+64|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));l=l+1|0}while((l|0)!=(h|0))}h=c[t+12>>2]|0;if(h){if(a[t+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[t+12>>2]=0}a[t+16>>0]=1;c[t+12>>2]=j;c[t+8>>2]=B;h=c[t+4>>2]|0}o=c[t+12>>2]|0;c[o+(h<<6)>>2]=A;c[o+(h<<6)+4>>2]=z;c[o+(h<<6)+8>>2]=w;g[o+(h<<6)+12>>2]=y;c[o+(h<<6)+16>>2]=d;c[o+(h<<6)+20>>2]=v;c[o+(h<<6)+24>>2]=u;g[o+(h<<6)+28>>2]=s;c[o+(h<<6)+32>>2]=-1;c[o+(h<<6)+36>>2]=e;c[o+(h<<6)+40>>2]=f;o=o+(h<<6)+44|0;c[o>>2]=c[C>>2];c[o+4>>2]=c[C+4>>2];c[o+8>>2]=c[C+8>>2];c[o+12>>2]=c[C+12>>2];c[o+16>>2]=c[C+16>>2];c[t+4>>2]=(c[t+4>>2]|0)+1;i=C;return}function kA(a){a=a|0;return 84}function lA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;EC(a,b,c,d)|0;return 1}function mA(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;c[a+4>>2]=35;c[a+8>>2]=0;c[a+12>>2]=1065353216;c[a+16>>2]=1065353216;c[a+20>>2]=1065353216;g[a+24>>2]=0.0;g[a+44>>2]=.03999999910593033;c[a>>2]=8388;c[a+52>>2]=1;h=+g[b>>2];f=+g[b+4>>2];d=+g[b+8>>2];d=+g[b+((h<f?(h<d?0:2):f<d?1:2)<<2)>>2]*.10000000149011612;if(d<.03999999910593033){j=+su(a);h=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);k=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);j=j+ +g[a+28>>2];h=h+ +g[a+32>>2];k=k+ +g[a+36>>2];g[a+44>>2]=d;i=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);d=k-+Tb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=j-i;g[a+32>>2]=h-f;g[a+36>>2]=d;g[a+40>>2]=0.0;e=c[a>>2]|0}else e=8388;h=+Tb[c[e+48>>2]&15](a);f=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);f=+g[b+4>>2]*+g[a+16>>2]-f;d=+g[b+8>>2]*+g[a+20>>2]-d;g[a+28>>2]=+g[b>>2]*+g[a+12>>2]-h;g[a+32>>2]=f;g[a+36>>2]=d;g[a+40>>2]=0.0;c[a+4>>2]=13;return}function nA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;i=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);m=i+ +g[a+28>>2];k=i+ +g[a+32>>2];i=i+ +g[a+36>>2];u=+N(+(+g[b>>2]));t=+N(+(+g[b+4>>2]));s=+N(+(+g[b+8>>2]));q=+N(+(+g[b+16>>2]));p=+N(+(+g[b+20>>2]));o=+N(+(+g[b+24>>2]));l=+N(+(+g[b+32>>2]));j=+N(+(+g[b+36>>2]));h=+N(+(+g[b+40>>2]));r=+g[b+48>>2];n=+g[b+52>>2];f=+g[b+56>>2];g[d>>2]=r-(m*u+k*t+i*s);g[d+4>>2]=n-(m*q+k*p+i*o);g[d+8>>2]=f-(m*l+k*j+i*h);g[d+12>>2]=0.0;g[e>>2]=m*u+k*t+i*s+r;g[e+4>>2]=m*q+k*p+i*o+n;g[e+8>>2]=m*l+k*j+i*h+f;g[e+12>>2]=0.0;return}function oA(a,b,d){a=a|0;b=+b;d=d|0;var e=0.0,f=0.0,h=0,j=0,k=0,l=0.0;k=i;i=i+16|0;c[k>>2]=c[a+28>>2];c[k+4>>2]=c[a+28+4>>2];c[k+8>>2]=c[a+28+8>>2];c[k+12>>2]=c[a+28+12>>2];l=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);g[k>>2]=l+ +g[k>>2];g[k+4>>2]=f+ +g[k+4>>2];g[k+8>>2]=e+ +g[k+8>>2];j=c[a+52>>2]|0;switch(j|0){case 0:{h=0;a=1;break}case 2:{h=2;a=0;break}default:{h=1;a=0}}f=+g[k+(a<<2)>>2];e=+g[k+(h<<2)>>2];e=b*.25*(f*f)+b/12.0*(e*(e*4.0));switch(j|0){case 0:{g[d>>2]=b*.5*(f*f);g[d+4>>2]=e;g[d+8>>2]=e;g[d+12>>2]=0.0;i=k;return}case 2:{g[d>>2]=e;g[d+4>>2]=e;g[d+8>>2]=b*.5*(f*f);g[d+12>>2]=0.0;i=k;return}default:{g[d>>2]=e;g[d+4>>2]=b*.5*(f*f);g[d+8>>2]=e;g[d+12>>2]=0.0;i=k;return}}}function pA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;j=+g[b+32>>2];d=+g[b+28>>2];e=+g[c+4>>2];h=+g[c+8>>2];i=+O(+(e*e+h*h));if(i!=0.0){f=+g[c>>2]<0.0?-d:d;e=e*(j/i);d=h*(j/i)}else{f=+g[c>>2]<0.0?-d:d;e=j;d=0.0}g[a+4>>2]=e;g[a>>2]=f;g[a+8>>2]=d;return}function qA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;k=+g[b+28>>2];e=+g[b+36>>2];h=+g[c>>2];i=+g[c+4>>2];j=+O(+(h*h+i*i));d=+g[c+8>>2];if(j!=0.0){f=d<0.0?-e:e;e=h*(k/j);d=i*(k/j)}else{f=d<0.0?-e:e;e=k;d=0.0}g[a>>2]=e;g[a+8>>2]=f;g[a+4>>2]=d;return}function rA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;k=+g[b+28>>2];e=+g[b+32>>2];h=+g[c>>2];i=+g[c+8>>2];j=+O(+(h*h+i*i));d=+g[c+4>>2];if(j!=0.0){f=d<0.0?-e:e;e=h*(k/j);d=i*(k/j)}else{f=d<0.0?-e:e;e=k;d=0.0}g[a>>2]=e;g[a+4>>2]=f;g[a+8>>2]=d;return}function sA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0;if((d|0)<=0)return;m=0;do{j=+g[a+28>>2];e=+g[a+32>>2];h=+g[b+(m<<4)>>2];k=+g[b+(m<<4)+8>>2];l=+O(+(h*h+k*k));f=+g[b+(m<<4)+4>>2];if(l!=0.0){i=f<0.0?-e:e;f=h*(j/l);e=k*(j/l)}else{i=f<0.0?-e:e;f=j;e=0.0}g[c+(m<<4)>>2]=f;g[c+(m<<4)+4>>2]=i;g[c+(m<<4)+8>>2]=e;m=m+1|0}while((m|0)!=(d|0));return}function tA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0;if((d|0)<=0)return;m=0;do{j=+g[a+28>>2];e=+g[a+36>>2];h=+g[b+(m<<4)>>2];k=+g[b+(m<<4)+4>>2];l=+O(+(h*h+k*k));f=+g[b+(m<<4)+8>>2];if(l!=0.0){i=f<0.0?-e:e;f=h*(j/l);e=k*(j/l)}else{i=f<0.0?-e:e;f=j;e=0.0}g[c+(m<<4)>>2]=f;g[c+(m<<4)+4>>2]=e;g[c+(m<<4)+8>>2]=i;m=m+1|0}while((m|0)!=(d|0));return}function uA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0;if((d|0)<=0)return;m=0;do{j=+g[a+32>>2];e=+g[a+28>>2];f=b+(m<<4)|0;h=+g[b+(m<<4)+4>>2];k=+g[b+(m<<4)+8>>2];l=+O(+(h*h+k*k));if(l!=0.0){i=+g[f>>2]<0.0?-e:e;h=h*(j/l);e=k*(j/l)}else{i=+g[f>>2]<0.0?-e:e;h=j;e=0.0}g[c+(m<<4)>>2]=i;g[c+(m<<4)+4>>2]=h;g[c+(m<<4)+8>>2]=e;m=m+1|0}while((m|0)!=(d|0));return}function vA(a,b){a=a|0;b=+b;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;h=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);h=h+ +g[a+28>>2];e=e+ +g[a+32>>2];i=i+ +g[a+36>>2];g[a+44>>2]=b;f=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);b=i-+Tb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=h-f;g[a+32>>2]=e-d;g[a+36>>2]=b;g[a+40>>2]=0.0;return}function wA(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function xA(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;k=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);m=(k+ +g[a+28>>2])/+g[a+12>>2];j=(h+ +g[a+32>>2])/+g[a+16>>2];f=(d+ +g[a+36>>2])/+g[a+20>>2];l=+N(+(+g[b>>2]));i=+N(+(+g[b+4>>2]));e=+N(+(+g[b+8>>2]));g[a+12>>2]=l;g[a+16>>2]=i;g[a+20>>2]=e;g[a+24>>2]=0.0;g[a+28>>2]=m*l-k;g[a+32>>2]=j*i-h;g[a+36>>2]=f*e-d;g[a+40>>2]=0.0;return}function yA(a){a=a|0;return 18494}function zA(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[a+(c[b+52>>2]<<2)>>2]=1.0;return}function AA(a){a=a|0;return 60}function BA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=_b[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=_b[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Fb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+28>>2]=c[a+28>>2];c[b+32>>2]=c[a+32>>2];c[b+36>>2]=c[a+36>>2];c[b+40>>2]=c[a+40>>2];c[b+12>>2]=c[a+12>>2];c[b+16>>2]=c[a+16>>2];c[b+20>>2]=c[a+20>>2];c[b+24>>2]=c[a+24>>2];c[b+44>>2]=c[a+44>>2];c[b+52>>2]=c[a+52>>2];return 18474}function CA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;i=i+16|0;jc[c[(c[b>>2]|0)+68>>2]&127](e,b,d);c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];if(!(+Tb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}j=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];l=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:j;k=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:h;f=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:f;h=1.0/+O(+(f*f+(l*l+k*k)));j=+Tb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+j*(h*l);g[a+4>>2]=j*(h*k)+ +g[a+4>>2];g[a+8>>2]=j*(h*f)+ +g[a+8>>2];i=e;return}function DA(a){a=a|0;var b=0.0,d=0.0;d=+g[a+28>>2];b=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);+Tb[c[(c[a>>2]|0)+48>>2]&15](a);+Tb[c[(c[a>>2]|0)+48>>2]&15](a);return +(d+b)}function EA(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function FA(a){a=a|0;return 18464}function GA(a){a=a|0;var b=0.0,d=0.0;d=+g[a+32>>2];+Tb[c[(c[a>>2]|0)+48>>2]&15](a);b=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);+Tb[c[(c[a>>2]|0)+48>>2]&15](a);return +(d+b)}function HA(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function IA(a){a=a|0;return 18454}function JA(a){a=a|0;var b=0.0,d=0.0;d=+g[a+28>>2];b=+Tb[c[(c[a>>2]|0)+48>>2]&15](a);+Tb[c[(c[a>>2]|0)+48>>2]&15](a);+Tb[c[(c[a>>2]|0)+48>>2]&15](a);return +(d+b)}
function Ds(d,e,f){d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0,m=0.0,n=0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0,u=0;t=i;i=i+528|0;if((a[d+171>>0]|0)==0?+g[d+172>>2]<=0.0:0){i=t;return}a[d+168>>0]=(Hb[c[(c[d>>2]|0)+48>>2]&127](d)|0)&1;j=+g[d+16>>2]-+g[d+44>>2]*f;g[d+16>>2]=j;if(j>0.0?(k=+g[d+28>>2],j>k):0)g[d+16>>2]=k;else k=j;if(k<0.0?(j=+N(+k),m=+N(+(+g[d+24>>2])),j>m):0){g[d+16>>2]=-m;k=-m}g[d+20>>2]=k*f;h=c[d+8>>2]|0;c[t>>2]=c[h+4>>2];c[t+4>>2]=c[h+4+4>>2];c[t+8>>2]=c[h+4+8>>2];c[t+12>>2]=c[h+4+12>>2];c[t+16>>2]=c[h+20>>2];c[t+16+4>>2]=c[h+20+4>>2];c[t+16+8>>2]=c[h+20+8>>2];c[t+16+12>>2]=c[h+20+12>>2];c[t+32>>2]=c[h+36>>2];c[t+32+4>>2]=c[h+36+4>>2];c[t+32+8>>2]=c[h+36+8>>2];c[t+32+12>>2]=c[h+36+12>>2];c[t+48>>2]=c[h+52>>2];c[t+48+4>>2]=c[h+52+4>>2];c[t+48+8>>2]=c[h+52+8>>2];c[t+48+12>>2]=c[h+52+12>>2];h=c[d+176>>2]|0;if((a[496]|0)==0?(Wa(496)|0)!=0:0){c[1261]=1065353216;c[1262]=0;c[1263]=0;c[1264]=0;c[1265]=0;c[1266]=1065353216;c[1267]=0;c[1268]=0;c[1269]=0;c[1270]=0;c[1271]=1065353216;g[1272]=0.0;_a(496)}m=+g[d+20>>2];m=+g[d+52>>2]+(m>0.0?m:0.0);k=+g[5044+(h<<4)+4>>2]*m+ +g[d+96>>2];j=m*+g[5044+(h<<4)+8>>2]+ +g[d+100>>2];g[d+112>>2]=+g[d+92>>2]+ +g[5044+(h<<4)>>2]*m;g[d+116>>2]=k;g[d+120>>2]=j;g[d+124>>2]=0.0;c[t+456>>2]=1065353216;c[t+456+4>>2]=0;c[t+456+4+4>>2]=0;c[t+456+4+8>>2]=0;c[t+456+4+12>>2]=0;c[t+456+20>>2]=1065353216;c[t+456+24>>2]=0;c[t+456+24+4>>2]=0;c[t+456+24+8>>2]=0;c[t+456+24+12>>2]=0;c[t+456+40>>2]=1065353216;h=t+456+44|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[t+392>>2]=1065353216;c[t+392+4>>2]=0;c[t+392+4+4>>2]=0;c[t+392+4+8>>2]=0;c[t+392+4+12>>2]=0;c[t+392+20>>2]=1065353216;c[t+392+24>>2]=0;c[t+392+24+4>>2]=0;c[t+392+24+8>>2]=0;c[t+392+24+12>>2]=0;c[t+392+40>>2]=1065353216;h=t+392+44|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;h=c[d+176>>2]|0;if((a[496]|0)==0?(Wa(496)|0)!=0:0){c[1261]=1065353216;c[1262]=0;c[1263]=0;c[1264]=0;c[1265]=0;c[1266]=1065353216;c[1267]=0;c[1268]=0;c[1269]=0;c[1270]=0;c[1271]=1065353216;g[1272]=0.0;_a(496)}l=c[d+12>>2]|0;m=+Tb[c[(c[l>>2]|0)+48>>2]&15](l);m=m+ +g[d+56>>2];k=m*+g[5044+(h<<4)+4>>2]+ +g[d+96>>2];j=m*+g[5044+(h<<4)+8>>2]+ +g[d+100>>2];g[t+456+48>>2]=+g[5044+(h<<4)>>2]*m+ +g[d+92>>2];g[t+456+52>>2]=k;g[t+456+56>>2]=j;g[t+456+60>>2]=0.0;c[t+392+48>>2]=c[d+112>>2];c[t+392+48+4>>2]=c[d+112+4>>2];c[t+392+48+8>>2]=c[d+112+8>>2];c[t+392+48+12>>2]=c[d+112+12>>2];h=c[d+8>>2]|0;l=c[d+176>>2]|0;if((a[496]|0)==0?(Wa(496)|0)!=0:0){c[1261]=1065353216;c[1262]=0;c[1263]=0;c[1264]=0;c[1265]=0;c[1266]=1065353216;c[1267]=0;c[1268]=0;c[1269]=0;c[1270]=0;c[1271]=1065353216;g[1272]=0.0;_a(496)}m=-+g[5044+(l<<4)>>2];k=-+g[5044+(l<<4)+4>>2];j=-+g[5044+(l<<4)+8>>2];g[t+288+4>>2]=1.0;l=t+288+12|0;c[t+288+76>>2]=0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;c[l+20>>2]=0;c[l+24>>2]=0;c[l+28>>2]=0;c[t+288>>2]=5100;c[t+288+80>>2]=h;g[t+288+84>>2]=m;g[t+288+88>>2]=k;g[t+288+92>>2]=j;g[t+288+96>>2]=0.0;g[t+288+100>>2]=.707099974155426;h=c[d+8>>2]|0;l=c[h+188>>2]|0;b[t+288+8>>1]=b[l+4>>1]|0;b[t+288+10>>1]=b[l+6>>1]|0;if(!(a[d+170>>0]|0))gv(e,c[d+12>>2]|0,t+456|0,t+392|0,t+288|0,0.0);else _s(h,c[d+12>>2]|0,t+456|0,t+392|0,t+288|0,+g[e+56>>2]);if(+g[t+288+4>>2]<1.0){h=c[d+176>>2]|0;if((a[496]|0)==0?(Wa(496)|0)!=0:0){c[1261]=1065353216;c[1262]=0;c[1263]=0;c[1264]=0;c[1265]=0;c[1266]=1065353216;c[1267]=0;c[1268]=0;c[1269]=0;c[1270]=0;c[1271]=1065353216;g[1272]=0.0;_a(496)}do if(+g[t+288+44>>2]*+g[5044+(h<<4)>>2]+ +g[t+288+48>>2]*+g[5044+(h<<4)+4>>2]+ +g[t+288+52>>2]*+g[5044+(h<<4)+8>>2]>0.0){k=+g[t+288+4>>2];g[d+108>>2]=+g[d+52>>2]*k;if(!(a[d+180>>0]|0)){c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2];break}else{g[d+92>>2]=(1.0-k)*+g[d+92>>2]+k*+g[d+112>>2];g[d+96>>2]=(1.0-k)*+g[d+96>>2]+k*+g[d+116>>2];g[d+100>>2]=(1.0-k)*+g[d+100>>2]+k*+g[d+120>>2];break}}while(0);g[d+16>>2]=0.0;g[d+20>>2]=0.0}else{c[d+108>>2]=c[d+52>>2];c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2]}if(!(a[d+171>>0]|0)){k=+g[d+172>>2];j=k>f?f:k;g[d+172>>2]=k-f;xs(d,e,+g[d+60>>2]*j,j*+g[d+64>>2],j*+g[d+68>>2])}else xs(d,e,+g[d+60>>2],+g[d+64>>2],+g[d+68>>2]);c[t+272>>2]=c[d+112>>2];c[t+272+4>>2]=c[d+112+4>>2];c[t+272+8>>2]=c[d+112+8>>2];c[t+272+12>>2]=c[d+112+12>>2];k=+g[d+16>>2];k=(k<0.0?-k:0.0)*f;do if(k>0.0?(o=+g[d+24>>2],k>o):0){if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0)break;k=o}while(0);l=c[d+176>>2]|0;if((a[496]|0)==0?(Wa(496)|0)!=0:0){c[1261]=1065353216;c[1262]=0;c[1263]=0;c[1264]=0;c[1265]=0;c[1266]=1065353216;c[1267]=0;c[1268]=0;c[1269]=0;c[1270]=0;c[1271]=1065353216;g[1272]=0.0;_a(496)}o=k+ +g[d+108>>2];q=+g[5044+(l<<4)>>2]*o;r=o*+g[5044+(l<<4)+4>>2];o=o*+g[5044+(l<<4)+8>>2];g[d+112>>2]=+g[d+112>>2]-q;g[d+116>>2]=+g[d+116>>2]-r;g[d+120>>2]=+g[d+120>>2]-o;l=c[d+8>>2]|0;h=c[d+176>>2]|0;if((a[496]|0)==0?(Wa(496)|0)!=0:0){c[1261]=1065353216;c[1262]=0;c[1263]=0;c[1264]=0;c[1265]=0;c[1266]=1065353216;c[1267]=0;c[1268]=0;c[1269]=0;c[1270]=0;c[1271]=1065353216;g[1272]=0.0;_a(496)}n=c[d+40>>2]|0;p=t+168+4|0;g[p>>2]=1.0;u=t+168+12|0;c[t+168+76>>2]=0;c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;c[u+12>>2]=0;c[u+16>>2]=0;c[u+20>>2]=0;c[u+24>>2]=0;c[u+28>>2]=0;c[t+168>>2]=5100;c[t+168+80>>2]=l;c[t+168+84>>2]=c[5044+(h<<4)>>2];c[t+168+84+4>>2]=c[5044+(h<<4)+4>>2];c[t+168+84+8>>2]=c[5044+(h<<4)+8>>2];c[t+168+84+12>>2]=c[5044+(h<<4)+12>>2];c[t+168+100>>2]=n;l=c[d+8>>2]|0;h=c[l+188>>2]|0;b[t+168+8>>1]=b[h+4>>1]|0;b[t+168+10>>1]=b[h+6>>1]|0;h=c[d+176>>2]|0;if((a[496]|0)==0?(Wa(496)|0)!=0:0){c[1261]=1065353216;c[1262]=0;c[1263]=0;c[1264]=0;c[1265]=0;c[1266]=1065353216;c[1267]=0;c[1268]=0;c[1269]=0;c[1270]=0;c[1271]=1065353216;g[1272]=0.0;_a(496)}n=c[d+40>>2]|0;g[t+64+4>>2]=1.0;u=t+64+12|0;c[t+64+76>>2]=0;c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;c[u+12>>2]=0;c[u+16>>2]=0;c[u+20>>2]=0;c[u+24>>2]=0;c[u+28>>2]=0;c[t+64>>2]=5100;c[t+64+80>>2]=l;c[t+64+84>>2]=c[5044+(h<<4)>>2];c[t+64+84+4>>2]=c[5044+(h<<4)+4>>2];c[t+64+84+8>>2]=c[5044+(h<<4)+8>>2];c[t+64+84+12>>2]=c[5044+(h<<4)+12>>2];c[t+64+100>>2]=n;l=c[(c[d+8>>2]|0)+188>>2]|0;b[t+64+8>>1]=b[l+4>>1]|0;b[t+64+10>>1]=b[l+6>>1]|0;m=+g[d+112>>2];k=+g[d+116>>2];j=+g[d+120>>2];l=0;while(1){c[t+456>>2]=1065353216;c[t+456+4>>2]=0;c[t+456+4+4>>2]=0;c[t+456+4+8>>2]=0;c[t+456+4+12>>2]=0;c[t+456+20>>2]=1065353216;c[t+456+24>>2]=0;c[t+456+24+4>>2]=0;c[t+456+24+8>>2]=0;c[t+456+24+12>>2]=0;c[t+456+40>>2]=1065353216;c[t+456+44>>2]=0;c[t+392>>2]=1065353216;c[t+392+4>>2]=0;c[t+392+4+4>>2]=0;c[t+392+4+8>>2]=0;c[t+392+4+12>>2]=0;c[t+392+20>>2]=1065353216;c[t+392+24>>2]=0;c[t+392+24+4>>2]=0;c[t+392+24+8>>2]=0;c[t+392+24+12>>2]=0;c[t+392+40>>2]=1065353216;c[t+392+44>>2]=0;c[t+288>>2]=1065353216;c[t+288+4>>2]=0;c[t+288+4+4>>2]=0;c[t+288+4+8>>2]=0;c[t+288+4+12>>2]=0;c[t+288+20>>2]=1065353216;c[t+288+24>>2]=0;c[t+288+24+4>>2]=0;c[t+288+24+8>>2]=0;c[t+288+24+12>>2]=0;c[t+288+40>>2]=1065353216;c[t+288+44>>2]=0;c[t+288+44+4>>2]=0;c[t+288+44+8>>2]=0;c[t+456+48>>2]=c[d+92>>2];c[t+456+48+4>>2]=c[d+92+4>>2];c[t+456+48+8>>2]=c[d+92+8>>2];c[t+456+48+12>>2]=c[d+92+12>>2];c[t+392+48>>2]=c[d+112>>2];c[t+392+48+4>>2]=c[d+112+4>>2];c[t+392+48+8>>2]=c[d+112+8>>2];c[t+392+48+12>>2]=c[d+112+12>>2];g[t+288+48>>2]=m-q;g[t+288+52>>2]=k-r;g[t+288+56>>2]=j-o;g[t+288+60>>2]=0.0;if(!(a[d+170>>0]|0)){gv(e,c[d+12>>2]|0,t+456|0,t+392|0,t+168|0,+g[e+56>>2]);if(!(+g[p>>2]<1.0))gv(e,c[d+12>>2]|0,t+456|0,t+288|0,t+64|0,+g[e+56>>2])}else{_s(c[d+8>>2]|0,c[d+12>>2]|0,t+456|0,t+392|0,t+168|0,+g[e+56>>2]);if(!(+g[p>>2]<1.0))_s(c[d+8>>2]|0,c[d+12>>2]|0,t+456|0,t+288|0,t+64|0,+g[e+56>>2])}k=+g[d+16>>2];k=(k<0.0?-k:0.0)*f;n=(a[d+182>>0]|0)==0;if(!n?+g[p>>2]<1.0:0)h=1;else h=+g[t+64+4>>2]<1.0;if(!(k>0.0))break;m=+g[d+52>>2];if(l|(!(k<m)|h^1))break;if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0){l=0;break};c[d+112>>2]=c[t+272>>2];c[d+112+4>>2]=c[t+272+4>>2];c[d+112+8>>2]=c[t+272+8>>2];c[d+112+12>>2]=c[t+272+12>>2];l=c[d+176>>2]|0;do if(!(a[496]|0)){if(!(Wa(496)|0))break;c[1261]=1065353216;c[1262]=0;c[1263]=0;c[1264]=0;c[1265]=0;c[1266]=1065353216;c[1267]=0;c[1268]=0;c[1269]=0;c[1270]=0;c[1271]=1065353216;g[1272]=0.0;_a(496)}while(0);m=m+ +g[d+108>>2];k=m*+g[5044+(l<<4)+4>>2];j=m*+g[5044+(l<<4)+8>>2];m=+g[d+112>>2]-+g[5044+(l<<4)>>2]*m;g[d+112>>2]=m;k=+g[d+116>>2]-k;g[d+116>>2]=k;j=+g[d+120>>2]-j;g[d+120>>2]=j;l=1}m=+g[p>>2];if(l|m<1.0){j=+g[d+96>>2];k=(j-+g[t+168+64>>2])*.5;do if(!n)if(!(a[d+181>>0]|0)){g[d+92>>2]=(1.0-k)*+g[d+92>>2]+k*+g[d+112>>2];g[d+96>>2]=(1.0-k)*j+k*+g[d+116>>2];g[d+100>>2]=(1.0-k)*+g[d+100>>2]+k*+g[d+120>>2];h=d+181|0;break}else{g[d+92>>2]=(1.0-m)*+g[d+92>>2]+m*+g[d+112>>2];g[d+96>>2]=(1.0-m)*j+m*+g[d+116>>2];g[d+100>>2]=(1.0-m)*+g[d+100>>2]+m*+g[d+120>>2];h=d+181|0;break}else{g[d+92>>2]=(1.0-m)*+g[d+92>>2]+m*+g[d+112>>2];g[d+96>>2]=(1.0-m)*j+m*+g[d+116>>2];g[d+100>>2]=(1.0-m)*+g[d+100>>2]+m*+g[d+120>>2];h=d+181|0}while(0);a[h>>0]=0;g[d+16>>2]=0.0;g[d+20>>2]=0.0;a[d+169>>0]=0}else{a[d+181>>0]=1;do if(!n?(s=+g[d+24>>2],k>s):0){if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0)break;g[d+112>>2]=q+ +g[d+112>>2];g[d+116>>2]=r+ +g[d+116>>2];g[d+120>>2]=o+ +g[d+120>>2];h=c[d+176>>2]|0;do if(!(a[496]|0)){if(!(Wa(496)|0))break;c[1261]=1065353216;c[1262]=0;c[1263]=0;c[1264]=0;c[1265]=0;c[1266]=1065353216;c[1267]=0;c[1268]=0;c[1269]=0;c[1270]=0;c[1271]=1065353216;g[1272]=0.0;_a(496)}while(0);k=s+ +g[d+108>>2];s=k*+g[5044+(h<<4)+4>>2];j=k*+g[5044+(h<<4)+8>>2];g[d+112>>2]=+g[d+112>>2]-+g[5044+(h<<4)>>2]*k;g[d+116>>2]=+g[d+116>>2]-s;g[d+120>>2]=+g[d+120>>2]-j}while(0);c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2]};c[t+48>>2]=c[d+92>>2];c[t+48+4>>2]=c[d+92+4>>2];c[t+48+8>>2]=c[d+92+8>>2];c[t+48+12>>2]=c[d+92+12>>2];h=c[d+8>>2]|0;c[h+260>>2]=(c[h+260>>2]|0)+1;c[h+4>>2]=c[t>>2];c[h+4+4>>2]=c[t+4>>2];c[h+4+8>>2]=c[t+8>>2];c[h+4+12>>2]=c[t+12>>2];c[h+20>>2]=c[t+16>>2];c[h+20+4>>2]=c[t+16+4>>2];c[h+20+8>>2]=c[t+16+8>>2];c[h+20+12>>2]=c[t+16+12>>2];c[h+36>>2]=c[t+32>>2];c[h+36+4>>2]=c[t+32+4>>2];c[h+36+8>>2]=c[t+32+8>>2];c[h+36+12>>2]=c[t+32+12>>2];c[h+52>>2]=c[t+48>>2];c[h+52+4>>2]=c[t+48+4>>2];c[h+52+8>>2]=c[t+48+8>>2];c[h+52+12>>2]=c[t+48+12>>2];i=t;return}function Es(a){a=a|0;return Hb[c[(c[a>>2]|0)+48>>2]&127](a)|0}function Fs(b){b=b|0;if(!(Hb[c[(c[b>>2]|0)+40>>2]&127](b)|0))return;c[b+16>>2]=c[b+28>>2];a[b+169>>0]=1;return}function Gs(a){a=a|0;if(!(+g[a+16>>2]==0.0)){a=0;return a|0}a=+g[a+20>>2]==0.0;return a|0}function Hs(a,b){a=a|0;b=b|0;return}function Is(b,c){b=b|0;c=c|0;a[b+180>>0]=c&1;return}function Js(a){a=a|0;YE(a);return}function Ks(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0.0;i=c[b>>2]|0;if((i|0)==(c[a+80>>2]|0)){e=1.0;return +e}if(c[i+204>>2]&4){e=1.0;return +e}f=+g[b+8>>2];h=+g[b+12>>2];e=+g[b+16>>2];if(d){j=f;k=h}else{j=+g[i+4>>2]*f+ +g[i+8>>2]*h+ +g[i+12>>2]*e;k=f*+g[i+20>>2]+h*+g[i+24>>2]+e*+g[i+28>>2];e=f*+g[i+36>>2]+h*+g[i+40>>2]+e*+g[i+44>>2]}if(j*+g[a+84>>2]+k*+g[a+88>>2]+e*+g[a+92>>2]<+g[a+100>>2]){e=1.0;return +e}c[a+4>>2]=c[b+40>>2];c[a+76>>2]=i;if(d){c[a+44>>2]=c[b+8>>2];c[a+44+4>>2]=c[b+8+4>>2];c[a+44+8>>2]=c[b+8+8>>2];c[a+44+12>>2]=c[b+8+12>>2]}else{k=+g[b+8>>2];j=+g[b+12>>2];h=+g[b+16>>2];f=k*+g[i+20>>2]+j*+g[i+24>>2]+h*+g[i+28>>2];e=k*+g[i+36>>2]+j*+g[i+40>>2]+h*+g[i+44>>2];g[a+44>>2]=+g[i+4>>2]*k+ +g[i+8>>2]*j+ +g[i+12>>2]*h;g[a+48>>2]=f;g[a+52>>2]=e;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+60+4>>2]=c[b+24+4>>2];c[a+60+8>>2]=c[b+24+8>>2];c[a+60+12>>2]=c[b+24+12>>2];e=+g[b+40>>2];return +e}function Ls(a,b,d){a=a|0;b=b|0;d=+d;Fb[c[(c[a>>2]|0)+32>>2]&127](a,b);lc[c[(c[a>>2]|0)+36>>2]&7](a,b,d);return}function Ms(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0,h=0,i=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;d=c[a+748>>2]|0;if((d|0)!=4){c[a+748>>2]=d+1;f=(d|0)<0;d=f?0:d;f=a+4+(d*184|0)|0;uF(f|0,b|0,184)|0;return d|0}y=+g[b+80>>2];q=+g[a+84>>2];p=q<y?q:y;o=+g[a+268>>2];n=o<p?o:p;m=+g[a+452>>2];w=+g[a+636>>2]<(m<n?m:n);d=w?3:m<n?2:o<p?1:(q<y^1)<<31>>31;y=+g[b>>2];if(d){i=+g[a+188>>2];j=+g[b+4>>2];o=+g[a+192>>2];p=+g[b+8>>2];n=+g[a+196>>2];s=+g[a+556>>2];u=+g[a+372>>2];v=+g[a+560>>2];r=+g[a+376>>2];t=+g[a+564>>2];m=+g[a+380>>2];h=(g[k>>2]=((y-i)*(v-r)-(j-o)*(s-u))*((y-i)*(v-r)-(j-o)*(s-u))+(((j-o)*(t-m)-(p-n)*(v-r))*((j-o)*(t-m)-(p-n)*(v-r))+((p-n)*(s-u)-(y-i)*(t-m))*((p-n)*(s-u)-(y-i)*(t-m))),c[k>>2]|0);if((d|0)==1){e=+g[a+4>>2];l=+g[a+8>>2];q=+g[a+12>>2];f=0;x=7}else x=6}else{i=+g[a+188>>2];o=+g[a+192>>2];n=+g[a+196>>2];j=+g[b+4>>2];p=+g[b+8>>2];u=+g[a+372>>2];s=+g[a+556>>2];r=+g[a+376>>2];v=+g[a+560>>2];m=+g[a+380>>2];t=+g[a+564>>2];h=0;x=6}if((x|0)==6){e=+g[a+4>>2];l=+g[a+8>>2];D=j-l;q=+g[a+12>>2];B=p-q;A=s-u;C=v-r;z=t-m;f=(g[k>>2]=((y-e)*C-D*A)*((y-e)*C-D*A)+((D*z-B*C)*(D*z-B*C)+(B*A-(y-e)*z)*(B*A-(y-e)*z)),c[k>>2]|0);if((d|0)==2){t=u;d=0;x=8}else x=7}if((x|0)==7){z=y-e;C=j-l;A=p-q;s=s-i;v=v-o;B=t-n;d=(g[k>>2]=(z*v-C*s)*(z*v-C*s)+((C*B-A*v)*(C*B-A*v)+(A*s-z*B)*(A*s-z*B)),c[k>>2]|0);if(w)e=0.0;else{t=u;x=8}}if((x|0)==8){B=y-e;l=j-l;p=p-q;q=t-i;o=r-o;e=m-n;e=(B*o-l*q)*(B*o-l*q)+((l*e-p*o)*(l*e-p*o)+(p*q-B*e)*(p*q-B*e))}q=+N(+(c[k>>2]=h,+g[k>>2]));o=+N(+(c[k>>2]=f,+g[k>>2]));m=+N(+(c[k>>2]=d,+g[k>>2]));l=+N(+e);p=q>-999999984306749440.0?q:-999999984306749440.0;n=o>p?o:p;d=l>(m>n?m:n)?3:m>n?2:o>p?1:(q>-999999984306749440.0^1)<<31>>31;f=(d|0)<0;d=f?0:d;f=a+4+(d*184|0)|0;uF(f|0,b|0,184)|0;return d|0}function Ns(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;f=c[b+748>>2]|0;if((f|0)<=0)return;do{j=f;f=f+-1|0;q=+g[b+4+(f*184|0)>>2];r=+g[b+4+(f*184|0)+4>>2];i=+g[b+4+(f*184|0)+8>>2];p=q*+g[d>>2]+r*+g[d+4>>2]+i*+g[d+8>>2]+ +g[d+48>>2];n=q*+g[d+16>>2]+r*+g[d+20>>2]+i*+g[d+24>>2]+ +g[d+52>>2];i=q*+g[d+32>>2]+r*+g[d+36>>2]+i*+g[d+40>>2]+ +g[d+56>>2];g[b+4+(f*184|0)+48>>2]=p;g[b+4+(f*184|0)+52>>2]=n;g[b+4+(f*184|0)+56>>2]=i;g[b+4+(f*184|0)+60>>2]=0.0;r=+g[b+4+(f*184|0)+16>>2];q=+g[b+4+(f*184|0)+20>>2];h=+g[b+4+(f*184|0)+24>>2];o=r*+g[e>>2]+q*+g[e+4>>2]+h*+g[e+8>>2]+ +g[e+48>>2];m=r*+g[e+16>>2]+q*+g[e+20>>2]+h*+g[e+24>>2]+ +g[e+52>>2];h=r*+g[e+32>>2]+q*+g[e+36>>2]+h*+g[e+40>>2]+ +g[e+56>>2];g[b+4+(f*184|0)+32>>2]=o;g[b+4+(f*184|0)+36>>2]=m;g[b+4+(f*184|0)+40>>2]=h;g[b+4+(f*184|0)+44>>2]=0.0;g[b+4+(f*184|0)+80>>2]=(p-o)*+g[b+4+(f*184|0)+64>>2]+(n-m)*+g[b+4+(f*184|0)+68>>2]+(i-h)*+g[b+4+(f*184|0)+72>>2];k=b+4+(f*184|0)+148|0;c[k>>2]=(c[k>>2]|0)+1}while((j|0)>1);f=c[b+748>>2]|0;if((f|0)<=0)return;j=f;k=f;while(1){l=k;k=k+-1|0;d=b+4+(k*184|0)|0;h=+g[b+4+(k*184|0)+80>>2];i=+g[b+752>>2];if(h<=i){m=+g[b+4+(k*184|0)+32>>2]-(+g[b+4+(k*184|0)+48>>2]-+g[b+4+(k*184|0)+64>>2]*h);r=+g[b+4+(k*184|0)+36>>2]-(+g[b+4+(k*184|0)+52>>2]-h*+g[b+4+(k*184|0)+68>>2]);h=+g[b+4+(k*184|0)+40>>2]-(+g[b+4+(k*184|0)+56>>2]-h*+g[b+4+(k*184|0)+72>>2]);if(m*m+r*r+h*h>i*i){e=j+-1|0;if((e|0)==(k|0))f=j;else{uF(d|0,b+4+(e*184|0)|0,184)|0;c[b+4+(e*184|0)+112>>2]=0;g[b+4+(e*184|0)+120>>2]=0.0;a[b+4+(e*184|0)+116>>0]=0;g[b+4+(e*184|0)+124>>2]=0.0;g[b+4+(e*184|0)+128>>2]=0.0;c[b+4+(e*184|0)+148>>2]=0;f=c[b+748>>2]|0}f=f+-1|0;c[b+748>>2]=f}else f=j}else{e=j+-1|0;if((e|0)==(k|0))f=j;else{uF(d|0,b+4+(e*184|0)|0,184)|0;c[b+4+(e*184|0)+112>>2]=0;g[b+4+(e*184|0)+120>>2]=0.0;a[b+4+(e*184|0)+116>>0]=0;g[b+4+(e*184|0)+124>>2]=0.0;g[b+4+(e*184|0)+128>>2]=0.0;c[b+4+(e*184|0)+148>>2]=0;f=c[b+748>>2]|0}f=f+-1|0;c[b+748>>2]=f}if((l|0)<=1)break;else j=f}return}function Os(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;c[b+16>>2]=c[a+4>>2];c[b+20>>2]=c[a+8>>2];c[b+24>>2]=c[a+12>>2];c[b+28>>2]=c[a+16>>2];c[b+32>>2]=c[a+20>>2];c[b+36>>2]=c[a+24>>2];c[b+40>>2]=c[a+28>>2];c[b+44>>2]=c[a+32>>2];c[b+48>>2]=c[a+36>>2];c[b+52>>2]=c[a+40>>2];c[b+56>>2]=c[a+44>>2];c[b+60>>2]=c[a+48>>2];c[b+64>>2]=c[a+52>>2];c[b+68>>2]=c[a+56>>2];c[b+72>>2]=c[a+60>>2];c[b+76>>2]=c[a+64>>2];c[b+80>>2]=c[a+68>>2];c[b+84>>2]=c[a+72>>2];c[b+88>>2]=c[a+76>>2];c[b+92>>2]=c[a+80>>2];c[b+96>>2]=c[a+84>>2];c[b+100>>2]=c[a+88>>2];c[b+104>>2]=c[a+92>>2];c[b+108>>2]=c[a+96>>2];c[b+112>>2]=c[a+100>>2];c[b+116>>2]=c[a+104>>2];c[b+120>>2]=c[a+108>>2];c[b+124>>2]=c[a+112>>2];c[b+128>>2]=c[a+116>>2];c[b+132>>2]=c[a+120>>2];c[b+136>>2]=c[a+124>>2];c[b+140>>2]=c[a+128>>2];c[b+144>>2]=c[a+132>>2];c[b+148>>2]=c[a+136>>2];c[b+152>>2]=c[a+140>>2];c[b+156>>2]=c[a+144>>2];c[b+160>>2]=c[a+148>>2];c[b+164>>2]=c[a+152>>2];c[b+168>>2]=c[a+156>>2];c[b+172>>2]=c[a+160>>2];c[b+176>>2]=c[a+164>>2];c[b+180>>2]=c[a+168>>2];c[b+184>>2]=c[a+172>>2];c[b+188>>2]=c[a+176>>2];c[b+224>>2]=c[a+180>>2];c[b+192>>2]=c[a+184>>2];c[b>>2]=0;c[b+4>>2]=_b[c[(c[d>>2]|0)+28>>2]&31](d,c[a+192>>2]|0)|0;c[b+8>>2]=0;c[b+228>>2]=c[a+204>>2];c[b+232>>2]=c[a+208>>2];c[b+236>>2]=c[a+212>>2];c[b+240>>2]=c[a+216>>2];c[b+196>>2]=c[a+220>>2];c[b+200>>2]=c[a+224>>2];c[b+204>>2]=c[a+232>>2];c[b+208>>2]=c[a+228>>2];c[b+244>>2]=c[a+236>>2];e=_b[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=_b[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b+12>>2]=f;if(!f){e=a+244|0;e=c[e>>2]|0;d=b+212|0;c[d>>2]=e;d=a+248|0;d=c[d>>2]|0;e=b+216|0;c[e>>2]=d;e=a+252|0;e=c[e>>2]|0;d=b+220|0;c[d>>2]=e;d=a+256|0;d=c[d>>2]|0;e=b+248|0;c[e>>2]=d;return 13583}Fb[c[(c[d>>2]|0)+48>>2]&127](d,e);e=a+244|0;e=c[e>>2]|0;d=b+212|0;c[d>>2]=e;d=a+248|0;d=c[d>>2]|0;e=b+216|0;c[e>>2]=d;e=a+252|0;e=c[e>>2]|0;d=b+220|0;c[d>>2]=e;d=a+256|0;d=c[d>>2]|0;e=b+248|0;c[e>>2]=d;return 13583}function Ps(a,b){a=a|0;b=b|0;var d=0,e=0;e=Hb[c[(c[a>>2]|0)+16>>2]&127](a)|0;e=Qb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;d=Qb[c[(c[a>>2]|0)+20>>2]&63](a,c[e+8>>2]|0,b)|0;Bb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1245859651,a);return}function Qs(a,b){a=a|0;b=b|0;return 1}function Rs(a){a=a|0;return 256}function Ss(b){b=b|0;var d=0;c[b>>2]=5128;d=c[b+276>>2]|0;if(d){if(a[b+280>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;return}function Ts(b){b=b|0;var d=0;c[b>>2]=5128;d=c[b+276>>2]|0;if(d){if(a[b+280>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[2704]=(c[2704]|0)+1;YE(c[b+-4>>2]|0);return}function Us(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=c[d>>2]|0;d=c[b+268>>2]|0;a:do if((d|0)>0){e=c[b+276>>2]|0;f=0;while(1){if((c[e+(f<<2)>>2]|0)==(g|0))break;f=f+1|0;if((f|0)>=(d|0))break a}if((f|0)!=(d|0))return}while(0);if((d|0)==(c[b+272>>2]|0)?(h=(d|0)!=0?d<<1:1,(d|0)<(h|0)):0){if(!h)e=0;else{c[2703]=(c[2703]|0)+1;d=XE((h<<2|3)+16|0)|0;if(!d)e=0;else{c[(d+4+15&-16)+-4>>2]=d;e=d+4+15&-16}d=c[b+268>>2]|0}if((d|0)>0){f=0;do{c[e+(f<<2)>>2]=c[(c[b+276>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(d|0))}f=c[b+276>>2]|0;if(f){if(a[b+280>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0);d=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=e;c[b+272>>2]=h}c[(c[b+276>>2]|0)+(d<<2)>>2]=g;c[b+268>>2]=d+1;return}function Vs(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=c[a+268>>2]|0;if((f|0)<=0)return;g=c[a+276>>2]|0;b=c[b>>2]|0;e=0;while(1){d=g+(e<<2)|0;if((c[d>>2]|0)==(b|0))break;e=e+1|0;if((e|0)>=(f|0)){h=7;break}}if((h|0)==7)return;if((e|0)>=(f|0))return;c[d>>2]=c[g+(f+-1<<2)>>2];c[a+268>>2]=f+-1;return}function Ws(b){b=b|0;var d=0;c[b>>2]=5172;d=c[b+284>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+284>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b>>2]=5128;d=c[b+276>>2]|0;if(!d){a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;d=b+272|0;c[d>>2]=0;return}if(a[b+280>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+276>>2]=0;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;d=b+272|0;c[d>>2]=0;return}function Xs(a){a=a|0;Ws(a);if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function Ys(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if(!e)e=c[b+188>>2]|0;i=c[d>>2]|0;f=c[b+268>>2]|0;a:do if((f|0)>0){g=c[b+276>>2]|0;h=0;while(1){if((c[g+(h<<2)>>2]|0)==(i|0))break;h=h+1|0;if((h|0)>=(f|0))break a}if((h|0)!=(f|0))return}while(0);if((f|0)==(c[b+272>>2]|0)?(j=(f|0)!=0?f<<1:1,(f|0)<(j|0)):0){if(!j)g=0;else{c[2703]=(c[2703]|0)+1;f=XE((j<<2|3)+16|0)|0;if(!f)g=0;else{c[(f+4+15&-16)+-4>>2]=f;g=f+4+15&-16}f=c[b+268>>2]|0}if((f|0)>0){h=0;do{c[g+(h<<2)>>2]=c[(c[b+276>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}h=c[b+276>>2]|0;if(h){if(a[b+280>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0);f=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=g;c[b+272>>2]=j}c[(c[b+276>>2]|0)+(f<<2)>>2]=i;c[b+268>>2]=f+1;f=c[b+284>>2]|0;Qb[c[(c[f>>2]|0)+8>>2]&63](f,e,d)|0;return}function Zs(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;if(!e)e=c[a+188>>2]|0;h=c[a+268>>2]|0;if((h|0)<=0)return;i=c[a+276>>2]|0;j=c[b>>2]|0;f=0;while(1){g=i+(f<<2)|0;if((c[g>>2]|0)==(j|0))break;f=f+1|0;if((f|0)>=(h|0)){k=9;break}}if((k|0)==9)return;if((f|0)>=(h|0))return;c[g>>2]=c[i+(h+-1<<2)>>2];c[a+268>>2]=h+-1;f=c[a+284>>2]|0;Lb[c[(c[f>>2]|0)+12>>2]&31](f,e,b,d)|0;return}function _s(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;C=i;i=i+320|0;c[C+176>>2]=c[d>>2];c[C+176+4>>2]=c[d+4>>2];c[C+176+8>>2]=c[d+8>>2];c[C+176+12>>2]=c[d+12>>2];c[C+176+16>>2]=c[d+16>>2];c[C+176+16+4>>2]=c[d+16+4>>2];c[C+176+16+8>>2]=c[d+16+8>>2];c[C+176+16+12>>2]=c[d+16+12>>2];c[C+176+32>>2]=c[d+32>>2];c[C+176+32+4>>2]=c[d+32+4>>2];c[C+176+32+8>>2]=c[d+32+8>>2];c[C+176+32+12>>2]=c[d+32+12>>2];c[C+176+48>>2]=c[d+48>>2];c[C+176+48+4>>2]=c[d+48+4>>2];c[C+176+48+8>>2]=c[d+48+8>>2];c[C+176+48+12>>2]=c[d+48+12>>2];c[C+96>>2]=c[e>>2];c[C+96+4>>2]=c[e+4>>2];c[C+96+8>>2]=c[e+8>>2];c[C+96+12>>2]=c[e+12>>2];c[C+96+16>>2]=c[e+16>>2];c[C+96+16+4>>2]=c[e+16+4>>2];c[C+96+16+8>>2]=c[e+16+8>>2];c[C+96+16+12>>2]=c[e+16+12>>2];c[C+96+32>>2]=c[e+32>>2];c[C+96+32+4>>2]=c[e+32+4>>2];c[C+96+32+8>>2]=c[e+32+8>>2];c[C+96+32+12>>2]=c[e+32+12>>2];c[C+96+48>>2]=c[e+48>>2];c[C+96+48+4>>2]=c[e+48+4>>2];c[C+96+48+8>>2]=c[e+48+8>>2];c[C+96+48+12>>2]=c[e+48+12>>2];D=+g[C+96+52>>2]-+g[C+176+52>>2];I=+g[C+96+56>>2]-+g[C+176+56>>2];g[C+64>>2]=+g[C+96+48>>2]-+g[C+176+48>>2];g[C+64+4>>2]=D;g[C+64+8>>2]=I;g[C+64+12>>2]=0.0;Bp(C+176|0,C+96|0,C+248|0,C+240|0);I=+g[C+240>>2];D=I*+g[C+248+4>>2];F=I*+g[C+248+8>>2];g[C+48>>2]=+g[C+248>>2]*I;g[C+48+4>>2]=D;g[C+48+8>>2]=F;g[C+48+12>>2]=0.0;c[C+248+4>>2]=0;c[C+248+4+4>>2]=0;c[C+248+24>>2]=0;c[C+248+24+4>>2]=0;t=C+248+44|0;c[t>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;c[t+12>>2]=0;c[t+16>>2]=0;Oo(C+176|0,C+32|0);F=+g[C+32>>2];D=+g[C+32+4>>2];I=+g[C+32+8>>2];G=+g[C+32+12>>2];E=F*(2.0/(F*F+D*D+I*I+G*G));j=D*(2.0/(F*F+D*D+I*I+G*G));H=I*(2.0/(F*F+D*D+I*I+G*G));g[C+248>>2]=1.0-(D*j+I*H);g[C+248+4>>2]=F*j-G*H;g[C+248+8>>2]=F*H+G*j;g[C+248+12>>2]=0.0;g[C+248+16>>2]=F*j+G*H;g[C+248+20>>2]=1.0-(F*E+I*H);g[C+248+24>>2]=D*H-G*E;g[C+248+28>>2]=0.0;g[C+248+32>>2]=F*H-G*j;g[C+248+36>>2]=D*H+G*E;g[C+248+40>>2]=1.0-(F*E+D*j);g[t>>2]=0.0;Fy(b,C+248|0,C+64|0,C+48|0,C+160|0,C+80|0);if((c[a+268>>2]|0)<=0){i=C;return}t=0;do{m=c[(c[a+276>>2]|0)+(t<<2)>>2]|0;if(_b[c[(c[f>>2]|0)+8>>2]&31](f,c[m+188>>2]|0)|0?(v=c[m+192>>2]|0,nc[c[(c[v>>2]|0)+8>>2]&127](v,m+4|0,C+16|0,C),n=+g[C+16>>2]+ +g[C+160>>2],r=+g[C+16+4>>2]+ +g[C+160+4>>2],p=+g[C+16+8>>2]+ +g[C+160+8>>2],g[C+16>>2]=n,g[C+16+4>>2]=r,g[C+16+8>>2]=p,g[C+16+12>>2]=0.0,o=+g[C>>2]+ +g[C+80>>2],s=+g[C+4>>2]+ +g[C+80+4>>2],q=+g[C+8>>2]+ +g[C+80+8>>2],g[C>>2]=o,g[C+4>>2]=s,g[C+8>>2]=q,g[C+12>>2]=0.0,x=+g[d+48>>2]-(o+n)*.5,B=+g[d+52>>2]-(s+r)*.5,z=+g[d+56>>2]-(q+p)*.5,w=+g[e+48>>2]-(o+n)*.5,A=+g[e+52>>2]-(s+r)*.5,y=+g[e+56>>2]-(q+p)*.5,v=x<-((o-n)*.5)|(x>(o-n)*.5?8:0)|(B<-((s-r)*.5)?2:0)|(B>(s-r)*.5?16:0)|(z<-((q-p)*.5)?4:0)|(z>(q-p)*.5?32:0),u=w<-((o-n)*.5)|(w>(o-n)*.5?8:0)|(A<-((s-r)*.5)?2:0)|(A>(s-r)*.5?16:0)|(y<-((q-p)*.5)?4:0)|(y>(q-p)*.5?32:0),(v&u|0)==0):0){if(x<-((o-n)*.5))if(!((-x-(o-n)*.5)/(w-x)>=0.0)){j=0.0;l=1065353216}else{j=(-x-(o-n)*.5)/(w-x);l=1065353216}else if(w<-((o-n)*.5)?(-x-(o-n)*.5)/(w-x)<1.0:0){j=0.0;l=(g[k>>2]=(-x-(o-n)*.5)/(w-x),c[k>>2]|0)}else{j=0.0;l=1065353216}if(B<-((s-r)*.5)){if(j<=(-B-(s-r)*.5)/(A-B))j=(-B-(s-r)*.5)/(A-B)}else if(A<-((s-r)*.5)?(-B-(s-r)*.5)/(A-B)<(c[k>>2]=l,+g[k>>2]):0)l=(g[k>>2]=(-B-(s-r)*.5)/(A-B),c[k>>2]|0);if(z<-((q-p)*.5)){if(j<=(-z-(q-p)*.5)/(y-z))j=(-z-(q-p)*.5)/(y-z)}else if(y<-((q-p)*.5)?(-z-(q-p)*.5)/(y-z)<(c[k>>2]=l,+g[k>>2]):0)l=(g[k>>2]=(-z-(q-p)*.5)/(y-z),c[k>>2]|0);if(x>(o-n)*.5){if(j<=((o-n)*.5-x)/(w-x))j=((o-n)*.5-x)/(w-x)}else if(w>(o-n)*.5?((o-n)*.5-x)/(w-x)<(c[k>>2]=l,+g[k>>2]):0)l=(g[k>>2]=((o-n)*.5-x)/(w-x),c[k>>2]|0);if(B>(s-r)*.5){if(j<=((s-r)*.5-B)/(A-B))j=((s-r)*.5-B)/(A-B)}else if(A>(s-r)*.5?((s-r)*.5-B)/(A-B)<(c[k>>2]=l,+g[k>>2]):0)l=(g[k>>2]=((s-r)*.5-B)/(A-B),c[k>>2]|0);if(!(v&32)){if((u&32|0)!=0?((q-p)*.5-z)/(y-z)<(c[k>>2]=l,+g[k>>2]):0)l=(g[k>>2]=((q-p)*.5-z)/(y-z),c[k>>2]|0)}else if(j<=((q-p)*.5-z)/(y-z))j=((q-p)*.5-z)/(y-z);if(j<=(c[k>>2]=l,+g[k>>2])){l=c[m+192>>2]|0;c[C+248>>2]=0;c[C+248+4>>2]=l;c[C+248+8>>2]=m;c[C+248+12>>2]=m+4;c[C+248+16>>2]=-1;c[C+248+20>>2]=-1;ev(b,C+176|0,C+96|0,C+248|0,f,h)}}t=t+1|0}while((t|0)<(c[a+268>>2]|0));i=C;return}function $s(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0,j=0,k=0;k=i;i=i+80|0;h=c[c[a>>2]>>2]|0;j=c[c[a+4>>2]>>2]|0;if(!(Qb[c[(c[b>>2]|0)+24>>2]&63](b,h,j)|0)){i=k;return}f=c[h+192>>2]|0;c[k+56>>2]=0;c[k+56+4>>2]=f;c[k+56+8>>2]=h;c[k+56+12>>2]=h+4;c[k+56+16>>2]=-1;c[k+56+20>>2]=-1;f=c[j+192>>2]|0;c[k+32>>2]=0;c[k+32+4>>2]=f;c[k+32+8>>2]=j;c[k+32+12>>2]=j+4;c[k+32+16>>2]=-1;c[k+32+20>>2]=-1;f=c[a+8>>2]|0;if(!f){f=Lb[c[(c[b>>2]|0)+8>>2]&31](b,k+56|0,k+32|0,0)|0;c[a+8>>2]=f;if(!f){i=k;return}}c[k>>2]=5856;c[k+4>>2]=0;c[k+8>>2]=k+56;c[k+12>>2]=k+32;if((c[d+8>>2]|0)==1){Bb[c[(c[f>>2]|0)+8>>2]&31](f,k+56|0,k+32|0,d,k);i=k;return}e=+Pb[c[(c[f>>2]|0)+12>>2]&15](f,h,j,d,k);if(!(+g[d+12>>2]>e)){i=k;return}g[d+12>>2]=e;i=k;return}function at(b){b=b|0;var d=0;c[b>>2]=5220;d=c[b+20>>2]|0;if(d){if(a[b+24>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;return}function bt(b){b=b|0;var d=0;c[b>>2]=5220;d=c[b+20>>2]|0;if(!d){YE(b);return}if(!(a[b+24>>0]|0)){YE(b);return}c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);YE(b);return}function ct(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0,m=0,n=0,o=0.0;n=i;i=i+16|0;c[1302]=(c[1302]|0)+1;if(!(c[b+4>>2]&2))f=5116;else{f=c[d+192>>2]|0;o=+dc[c[(c[f>>2]|0)+20>>2]&1](f,.019999999552965164);g[n+4>>2]=o;f=c[e+192>>2]|0;k=+dc[c[(c[f>>2]|0)+20>>2]&1](f,.019999999552965164);g[n>>2]=k;f=o<k?n+4|0:n}f=c[f>>2]|0;o=+g[d+184>>2];k=+g[e+184>>2];k=o<k?o:k;j=c[b+68>>2]|0;h=c[j+8>>2]|0;if(!h){if(c[b+4>>2]&4){f=0;i=n;return f|0}c[2703]=(c[2703]|0)+1;j=XE(791)|0;if(!j)l=0;else{c[(j+4+15&-16)+-4>>2]=j;l=j+4+15&-16}}else{l=c[j+12>>2]|0;c[j+12>>2]=c[l>>2];c[j+8>>2]=h+-1}c[l>>2]=1025;c[l+116>>2]=0;a[l+120>>0]=0;h=l+124|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[h+20>>2]=0;c[h+24>>2]=0;c[h+28>>2]=0;c[l+300>>2]=0;a[l+304>>0]=0;h=l+308|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[h+20>>2]=0;c[h+24>>2]=0;c[h+28>>2]=0;c[l+484>>2]=0;a[l+488>>0]=0;h=l+492|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[h+20>>2]=0;c[h+24>>2]=0;c[h+28>>2]=0;c[l+668>>2]=0;a[l+672>>0]=0;h=l+676|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[h+20>>2]=0;c[h+24>>2]=0;c[h+28>>2]=0;c[l+740>>2]=d;c[l+744>>2]=e;c[l+748>>2]=0;c[l+752>>2]=f;g[l+756>>2]=k;e=l;f=c[b+12>>2]|0;c[l+768>>2]=f;if((f|0)==(c[b+16>>2]|0)?(m=(f|0)!=0?f<<1:1,(f|0)<(m|0)):0){if(!m)h=0;else{c[2703]=(c[2703]|0)+1;f=XE((m<<2|3)+16|0)|0;if(!f)h=0;else{c[(f+4+15&-16)+-4>>2]=f;h=f+4+15&-16}f=c[b+12>>2]|0}if((f|0)>0){j=0;do{c[h+(j<<2)>>2]=c[(c[b+20>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(f|0))}j=c[b+20>>2]|0;if(j){if(a[b+24>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0);f=c[b+12>>2]|0}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=h;c[b+16>>2]=m}c[(c[b+20>>2]|0)+(f<<2)>>2]=e;c[b+12>>2]=f+1;f=l;i=n;return f|0}function dt(a,b){a=a|0;b=b|0;c[b+748>>2]=0;return}function et(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;c[1302]=(c[1302]|0)+-1;Fb[c[(c[a>>2]|0)+20>>2]&127](a,b);e=c[b+768>>2]|0;d=(c[a+12>>2]|0)+-1|0;g=c[a+20>>2]|0;f=c[g+(e<<2)>>2]|0;c[g+(e<<2)>>2]=c[g+(d<<2)>>2];c[(c[a+20>>2]|0)+(d<<2)>>2]=f;c[(c[(c[a+20>>2]|0)+(e<<2)>>2]|0)+768>>2]=e;c[a+12>>2]=d;a=c[a+68>>2]|0;if(!b)return;d=c[a+16>>2]|0;if(d>>>0<=b>>>0?(d+(_(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){c[b>>2]=c[a+12>>2];c[a+12>>2]=b;c[a+8>>2]=(c[a+8>>2]|0)+1;return}c[2704]=(c[2704]|0)+1;YE(c[b+-4>>2]|0);return}function ft(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;c[f>>2]=a;c[f+4>>2]=e;e=c[a+72+((c[(c[b+4>>2]|0)+4>>2]|0)*144|0)+(c[(c[d+4>>2]|0)+4>>2]<<2)>>2]|0;b=Lb[c[(c[e>>2]|0)+8>>2]&31](e,f,b,d)|0;i=f;return b|0}function gt(a,b,d){a=a|0;b=b|0;d=d|0;b=c[b+204>>2]|0;if(b&4){a=0;return a|0}a=c[d+204>>2]|0;if(a&4){a=0;return a|0}if(!(b&3)){a=1;return a|0}a=(a&3|0)==0;return a|0}function ht(a,b,d){a=a|0;b=b|0;d=d|0;a:do switch(c[b+216>>2]|0){case 2:case 5:{switch(c[d+216>>2]|0){case 2:case 5:{b=0;break}default:break a}return b|0}default:{}}while(0);if(!(c[b+256>>2]|0)){b=1;return b|0}b=_b[c[c[b>>2]>>2]&31](b,d)|0;return b|0}function it(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;c[f>>2]=5292;c[f+4>>2]=d;c[f+8>>2]=a;jc[c[(c[b>>2]|0)+48>>2]&127](b,f,e);i=f;return}function jt(a,b){a=a|0;b=b|0;var d=0;a=c[a+64>>2]|0;d=c[a+8>>2]|0;if(d){b=c[a+12>>2]|0;c[a+12>>2]=c[b>>2];c[a+8>>2]=d+-1;a=b;return a|0}c[2703]=(c[2703]|0)+1;a=XE(b+19|0)|0;if(!a){a=0;return a|0}c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16;return a|0}function kt(a,b){a=a|0;b=b|0;var d=0;a=c[a+64>>2]|0;if(!b)return;d=c[a+16>>2]|0;if(d>>>0<=b>>>0?(d+(_(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){c[b>>2]=c[a+12>>2];c[a+12>>2]=b;c[a+8>>2]=(c[a+8>>2]|0)+1;return}c[2704]=(c[2704]|0)+1;YE(c[b+-4>>2]|0);return}function lt(a){a=a|0;return}function mt(a){a=a|0;YE(a);return}function nt(a,b){a=a|0;b=b|0;var d=0;d=c[a+8>>2]|0;jc[c[d+60>>2]&127](b,d,c[a+4>>2]|0);return 0}function ot(a){a=a|0;return c[a+12>>2]|0}function pt(a,b){a=a|0;b=b|0;return c[(c[a+20>>2]|0)+(b<<2)>>2]|0}function qt(a){a=a|0;if(!(c[a+12>>2]|0)){a=0;return a|0}a=c[a+20>>2]|0;return a|0}function rt(a){a=a|0;return c[a+68>>2]|0}function st(a){a=a|0;return c[a+68>>2]|0}function tt(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0;c[b>>2]=5312;c[2703]=(c[2703]|0)+1;e=XE(379)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g[e+308>>2]=9.999999747378752e-05;f=e+332|0;a[f>>0]=a[f>>0]&-16;c[b+24>>2]=e;f=(c[d+20>>2]|0)==0;c[2703]=(c[2703]|0)+1;e=XE(23)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}if(f){c[e>>2]=9340;c[b+28>>2]=e;f=b+28|0}else{c[e>>2]=10400;c[b+28>>2]=e;f=b+28|0}c[2703]=(c[2703]|0)+1;e=XE(43)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=c[b+24>>2]|0;f=c[f>>2]|0;a[e+4>>0]=0;c[e>>2]=6264;c[e+16>>2]=0;c[e+20>>2]=3;c[e+12>>2]=h;c[e+8>>2]=f;c[b+32>>2]=e;c[2703]=(c[2703]|0)+1;e=XE(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5344;c[b+36>>2]=e;c[2703]=(c[2703]|0)+1;e=XE(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5364;c[b+40>>2]=e;c[2703]=(c[2703]|0)+1;e=XE(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5384;c[b+44>>2]=e;c[2703]=(c[2703]|0)+1;e=XE(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5404;c[b+48>>2]=e;c[2703]=(c[2703]|0)+1;e=XE(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5424;c[b+52>>2]=e;c[2703]=(c[2703]|0)+1;e=XE(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5444;c[b+56>>2]=e;c[2703]=(c[2703]|0)+1;e=XE(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5464;c[b+60>>2]=e;c[2703]=(c[2703]|0)+1;e=XE(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5484;c[b+76>>2]=e;c[2703]=(c[2703]|0)+1;e=XE(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e>>2]=5484;c[b+80>>2]=e;a[e+4>>0]=1;c[2703]=(c[2703]|0)+1;e=XE(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5504;c[b+72>>2]=e;c[2703]=(c[2703]|0)+1;e=XE(35)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5524;c[e+8>>2]=1;c[e+12>>2]=0;c[b+88>>2]=e;c[2703]=(c[2703]|0)+1;e=XE(35)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e>>2]=5524;c[e+8>>2]=1;c[e+12>>2]=0;c[b+84>>2]=e;a[e+4>>0]=1;l=c[d+16>>2]|0;l=(l|0)>80?l:80;e=c[d>>2]|0;if(!e){a[b+12>>0]=1;c[2703]=(c[2703]|0)+1;e=XE(39)|0;if(!e)k=0;else{c[(e+4+15&-16)+-4>>2]=e;k=e+4+15&-16}f=c[d+8>>2]|0;c[k>>2]=772;i=k+4|0;c[i>>2]=f;c[2703]=(c[2703]|0)+1;f=XE((f*772|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[k+16>>2]=f;c[k+12>>2]=f;j=c[i>>2]|0;c[k+8>>2]=j;if(j+-1|0){i=c[k>>2]|0;h=j+-1|0;e=f;do{m=e;e=e+i|0;c[m>>2]=e;h=h+-1|0}while((h|0)!=0);f=f+(_(i,j+-1|0)|0)|0}c[f>>2]=0;c[b+8>>2]=k}else{a[b+12>>0]=0;c[b+8>>2]=e}e=c[d+4>>2]|0;if(e){a[b+20>>0]=0;c[b+16>>2]=e;return}a[b+20>>0]=1;c[2703]=(c[2703]|0)+1;e=XE(39)|0;if(!e)k=0;else{c[(e+4+15&-16)+-4>>2]=e;k=e+4+15&-16}e=c[d+12>>2]|0;c[k>>2]=l;f=k+4|0;c[f>>2]=e;e=_(e,l)|0;c[2703]=(c[2703]|0)+1;e=XE(e+19|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[k+16>>2]=e;c[k+12>>2]=e;f=c[f>>2]|0;c[k+8>>2]=f;if(f+-1|0){h=c[k>>2]|0;i=f+-1|0;j=e;do{l=j;j=j+h|0;c[l>>2]=j;i=i+-1|0}while((i|0)!=0);e=e+(_(h,f+-1|0)|0)|0}c[e>>2]=0;c[b+16>>2]=k;return}function ut(b){b=b|0;var d=0,e=0;c[b>>2]=5312;if(a[b+20>>0]|0){d=c[b+16>>2]|0;e=c[d+16>>2]|0;if(e){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0);d=c[b+16>>2]|0}if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}}if(a[b+12>>0]|0){d=c[b+8>>2]|0;e=c[d+16>>2]|0;if(e){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0);d=c[b+8>>2]|0}if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}}d=c[b+32>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+32>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+36>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+36>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+40>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+40>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+44>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+44>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+48>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+48>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+52>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+52>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+56>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+56>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+60>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+60>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+76>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+76>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+80>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+80>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+72>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+72>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+88>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+88>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+84>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+84>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+24>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+28>>2]|0;Db[c[c[d>>2]>>2]&255](d);d=c[b+28>>2]|0;if(!d)return;c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);return}function vt(a){a=a|0;ut(a);YE(a);return}function wt(a,b,d){a=a|0;b=b|0;d=d|0;do if(!((b|0)==8&(d|0)==8)){if((b|0)==8&(d|0)==1){b=a+76|0;break}if((b|0)==1&(d|0)==8){b=a+80|0;break}if(!(d|b)){b=a+72|0;break}if((b|0)<20&(d|0)==28){b=a+88|0;break}if((b|0)==28&(d|0)<20){b=a+84|0;break}if((b|0)<20){if((d|0)<20){b=a+32|0;break}if((d+-21|0)>>>0<9){b=a+36|0;break}}else{if((d|0)<20&(b+-21|0)>>>0<9){b=a+40|0;break}if((b|0)==31)if((d|0)==31){b=a+48|0;break}else{b=a+44|0;break}}if((d|0)==31){b=a+52|0;break}else{b=a+56|0;break}}else b=a+60|0;while(0);return c[b>>2]|0}function xt(a){a=a|0;return}function yt(a){a=a|0;YE(a);return}function zt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=_b[c[(c[b>>2]|0)+56>>2]&31](b,80)|0;d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=5596;a[b+8>>0]=0;c[b+12>>2]=5624;c[b+60>>2]=d;c[b+64>>2]=0;c[b+16>>2]=e;c[b+20>>2]=f;e=Qb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;c[b+76>>2]=e;f=c[b+60>>2]|0;Fb[c[(c[f>>2]|0)+20>>2]&127](f,e);return b|0}function At(a){a=a|0;YE(a);return}function Bt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=_b[c[(c[b>>2]|0)+56>>2]&31](b,80)|0;d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=5596;a[b+8>>0]=1;c[b+12>>2]=5624;c[b+60>>2]=d;c[b+64>>2]=0;c[b+16>>2]=f;c[b+20>>2]=e;e=Qb[c[(c[d>>2]|0)+12>>2]&63](d,c[f+8>>2]|0,c[e+8>>2]|0)|0;c[b+76>>2]=e;f=c[b+60>>2]|0;Fb[c[(c[f>>2]|0)+20>>2]&127](f,e);return b|0}function Ct(a){a=a|0;YE(a);return}function Dt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=c[b>>2]|0;a=_b[c[(c[a>>2]|0)+56>>2]&31](a,44)|0;tw(a,b,d,e,0);return a|0}function Et(a){a=a|0;YE(a);return}function Ft(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=c[d>>2]|0;l=_b[c[(c[l>>2]|0)+56>>2]&31](l,48)|0;c[l+4>>2]=c[d>>2];c[l>>2]=6460;a[l+28>>0]=1;c[l+24>>2]=0;c[l+16>>2]=0;c[l+20>>2]=0;c[l+32>>2]=c[d+4>>2];a[l+36>>0]=0;c[2703]=(c[2703]|0)+1;b=XE(87)|0;if(!b)k=0;else{c[(b+4+15&-16)+-4>>2]=b;k=b+4+15&-16}c[k>>2]=10660;h=k+20|0;a[h>>0]=1;j=k+16|0;c[j>>2]=0;b=k+8|0;c[b>>2]=0;i=k+12|0;c[i>>2]=0;a[k+24>>0]=0;a[k+44>>0]=1;c[k+40>>2]=0;c[k+32>>2]=0;c[k+36>>2]=0;a[k+64>>0]=1;c[k+60>>2]=0;c[k+52>>2]=0;c[k+56>>2]=0;c[2703]=(c[2703]|0)+1;d=XE(43)|0;if(!d)g=0;else{c[(d+4+15&-16)+-4>>2]=d;g=d+4+15&-16}d=c[b>>2]|0;if((d|0)>0){b=0;do{m=g+(b*12|0)|0;n=(c[j>>2]|0)+(b*12|0)|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];b=b+1|0}while((b|0)!=(d|0))}d=c[j>>2]|0;if(!d){a[h>>0]=1;c[j>>2]=g;c[i>>2]=2;ND(k);j=l+8|0;c[j>>2]=k;k=e+4|0;k=c[k>>2]|0;k=k+68|0;k=c[k>>2]|0;e=l+40|0;c[e>>2]=k;e=f+4|0;e=c[e>>2]|0;e=e+68|0;e=c[e>>2]|0;f=l+44|0;c[f>>2]=e;return l|0}if(a[h>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[j>>2]=0;a[h>>0]=1;c[j>>2]=g;c[i>>2]=2;ND(k);j=l+8|0;c[j>>2]=k;k=e+4|0;k=c[k>>2]|0;k=k+68|0;k=c[k>>2]|0;e=l+40|0;c[e>>2]=k;e=f+4|0;e=c[e>>2]|0;e=e+68|0;e=c[e>>2]|0;f=l+44|0;c[f>>2]=e;return l|0}function Gt(a){a=a|0;YE(a);return}function Ht(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=c[b>>2]|0;a=_b[c[(c[a>>2]|0)+56>>2]&31](a,44)|0;tw(a,b,d,e,1);return a|0}function It(a){a=a|0;YE(a);return}function Jt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;d=c[b>>2]|0;d=_b[c[(c[d>>2]|0)+56>>2]&31](d,8)|0;c[d+4>>2]=c[b>>2];c[d>>2]=10552;return d|0}function Kt(a){a=a|0;YE(a);return}function Lt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=_b[c[(c[b>>2]|0)+56>>2]&31](b,16)|0;d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=10580;a[b+8>>0]=0;c[b+12>>2]=0;c[b+12>>2]=Qb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[b+8>>0]=1;return b|0}function Mt(a){a=a|0;YE(a);return}function Nt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=c[d>>2]|0;g=_b[c[(c[g>>2]|0)+56>>2]&31](g,20)|0;h=c[d+4>>2]|0;b=a[b+4>>0]|0;d=c[d>>2]|0;c[g+4>>2]=d;c[g>>2]=6236;a[g+8>>0]=0;c[g+12>>2]=h;a[g+16>>0]=b;if(h)return g|0;c[g+12>>2]=Qb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[g+8>>0]=1;return g|0}function Ot(a){a=a|0;YE(a);return}function Pt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=_b[c[(c[b>>2]|0)+56>>2]&31](b,16)|0;d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=5828;a[b+8>>0]=0;c[b+12>>2]=0;if(!(Qb[c[(c[d>>2]|0)+24>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0))return b|0;d=c[b+4>>2]|0;c[b+12>>2]=Qb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[b+8>>0]=1;return b|0}function Qt(a){a=a|0;YE(a);return}function Rt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;i=c[d>>2]|0;i=_b[c[(c[i>>2]|0)+56>>2]&31](i,28)|0;j=(a[b+4>>0]|0)==0;h=c[b+8>>2]|0;g=c[b+12>>2]|0;b=c[d>>2]|0;c[i+4>>2]=b;c[i>>2]=5568;a[i+8>>0]=0;c[i+12>>2]=0;if(j){a[i+16>>0]=0;c[i+20>>2]=h;c[i+24>>2]=g;if(!(Qb[c[(c[b>>2]|0)+24>>2]&63](b,c[e+8>>2]|0,c[f+8>>2]|0)|0))return i|0;b=c[i+4>>2]|0;c[i+12>>2]=Qb[c[(c[b>>2]|0)+12>>2]&63](b,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[i+8>>0]=1;return i|0}else{a[i+16>>0]=1;c[i+20>>2]=h;c[i+24>>2]=g;if(!(Qb[c[(c[b>>2]|0)+24>>2]&63](b,c[f+8>>2]|0,c[e+8>>2]|0)|0))return i|0;b=c[i+4>>2]|0;c[i+12>>2]=Qb[c[(c[b>>2]|0)+12>>2]&63](b,c[f+8>>2]|0,c[e+8>>2]|0)|0;a[i+8>>0]=1;return i|0}return 0}function St(a){a=a|0;return c[a+8>>2]|0}function Tt(a){a=a|0;return c[a+16>>2]|0}function Ut(a){a=a|0;return c[a+24>>2]|0}function Vt(b){b=b|0;var d=0;c[b>>2]=5544;d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){d=b+12|0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[d>>2]=0;return}if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+16>>2]=0;d=b+12|0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[d>>2]=0;return}function Wt(a){a=a|0;Vt(a);YE(a);return}function Xt(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0,l=0,m=0;e=c[d+8>>2]|0;if((e|0)>0){h=c[d+16>>2]|0;j=0;f=0;do{i=c[h+(j<<2)>>2]|0;if(!(c[i+204>>2]&3)){c[i+208>>2]=f;f=f+1|0}c[i+212>>2]=-1;g[i+244>>2]=1.0;j=j+1|0}while((j|0)!=(e|0));i=f}else i=0;f=c[b+8>>2]|0;if((f|0)<(i|0)){if((c[b+12>>2]|0)<(i|0)){if(!i){h=f;j=0}else{c[2703]=(c[2703]|0)+1;e=XE((i<<3|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=c[b+8>>2]|0;j=e}if((h|0)>0){e=0;do{m=(c[b+16>>2]|0)+(e<<3)|0;l=c[m+4>>2]|0;k=j+(e<<3)|0;c[k>>2]=c[m>>2];c[k+4>>2]=l;e=e+1|0}while((e|0)!=(h|0))}e=c[b+16>>2]|0;if(e){if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=j;c[b+12>>2]=i;e=b+16|0}else e=b+16|0;do{h=(c[e>>2]|0)+(f<<3)|0;c[h>>2]=0;c[h+4>>2]=0;f=f+1|0}while((f|0)!=(i|0))}c[b+8>>2]=i;if((i|0)>0){e=c[b+16>>2]|0;f=0;do{c[e+(f<<3)>>2]=f;c[e+(f<<3)+4>>2]=1;f=f+1|0}while((f|0)!=(i|0))}e=c[d+68>>2]|0;e=Hb[c[(c[e>>2]|0)+36>>2]&127](e)|0;d=Hb[c[(c[e>>2]|0)+36>>2]&127](e)|0;if(!d)return;k=Hb[c[(c[e>>2]|0)+20>>2]&127](e)|0;if((d|0)<=0)return;l=0;do{f=c[c[k+(l<<4)>>2]>>2]|0;e=c[c[k+(l<<4)+4>>2]>>2]|0;if(((f|0)!=0?((e|0)!=0?(c[f+204>>2]&7|0)==0:0):0)?(c[e+204>>2]&7|0)==0:0){j=c[f+208>>2]|0;f=c[e+208>>2]|0;e=c[b+16>>2]|0;i=c[e+(j<<3)>>2]|0;if((i|0)!=(j|0)){h=e+(j<<3)|0;do{j=e+(i<<3)|0;c[h>>2]=c[j>>2];j=c[j>>2]|0;h=e+(j<<3)|0;i=c[h>>2]|0}while((j|0)!=(i|0))}i=c[e+(f<<3)>>2]|0;if((i|0)!=(f|0)){h=e+(f<<3)|0;do{f=e+(i<<3)|0;c[h>>2]=c[f>>2];f=c[f>>2]|0;h=e+(f<<3)|0;i=c[h>>2]|0}while((f|0)!=(i|0))}if((j|0)!=(f|0)){c[e+(j<<3)>>2]=f;f=e+(f<<3)+4|0;c[f>>2]=(c[f>>2]|0)+(c[e+(j<<3)+4>>2]|0)}}l=l+1|0}while((l|0)!=(d|0));return}function Yt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;k=c[b+8>>2]|0;if((k|0)<=0)return;i=c[b+16>>2]|0;j=0;b=0;do{g=c[i+(j<<2)>>2]|0;if(!(c[g+204>>2]&3)){h=c[a+16>>2]|0;e=h+(b<<3)|0;d=c[e>>2]|0;if((d|0)==(b|0))d=b;else{f=d;do{d=h+(f<<3)|0;c[e>>2]=c[d>>2];d=c[d>>2]|0;e=h+(d<<3)|0;f=c[e>>2]|0}while((d|0)!=(f|0))}c[g+208>>2]=d;c[h+(b<<3)+4>>2]=j;c[g+212>>2]=-1;b=b+1|0}else{c[g+208>>2]=-1;c[g+212>>2]=-2}j=j+1|0}while((j|0)!=(k|0));return}function Zt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;while(1){l=c[a+12>>2]|0;k=c[l+(((b+d|0)/2|0)<<2)>>2]|0;e=b;f=d;while(1){j=c[(c[k+740>>2]|0)+208>>2]|0;if((j|0)>-1)while(1){h=c[l+(e<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((g|0)<(j|0))e=e+1|0;else break}else{i=c[(c[k+744>>2]|0)+208>>2]|0;while(1){g=c[l+(e<<2)>>2]|0;h=c[(c[g+740>>2]|0)+208>>2]|0;if((h|0)<=-1)h=c[(c[g+744>>2]|0)+208>>2]|0;if((h|0)<(i|0))e=e+1|0;else break}}if((j|0)>-1)while(1){h=c[l+(f<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((j|0)<(g|0))f=f+-1|0;else break}else{i=c[(c[k+744>>2]|0)+208>>2]|0;while(1){h=c[l+(f<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((i|0)<(g|0))f=f+-1|0;else break}}if((e|0)<=(f|0)){i=l+(e<<2)|0;j=c[i>>2]|0;c[i>>2]=c[l+(f<<2)>>2];c[(c[a+12>>2]|0)+(f<<2)>>2]=j;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;l=c[a+12>>2]|0}if((f|0)>(b|0))Zt(a,b,f);if((e|0)<(d|0))b=e;else break}return}function _t(b){b=b|0;var d=0;c[b>>2]=5568;if(!(a[b+8>>0]|0))return;d=c[b+12>>2]|0;if(!d)return;b=c[b+4>>2]|0;Fb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function $t(b){b=b|0;var d=0,e=0;c[b>>2]=5568;if(!(a[b+8>>0]|0)){YE(b);return}d=c[b+12>>2]|0;if(!d){YE(b);return}e=c[b+4>>2]|0;Fb[c[(c[e>>2]|0)+16>>2]&127](e,d);YE(b);return}function au(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0,L=0.0,M=0.0,P=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0;J=i;i=i+128|0;if(!(c[b+12>>2]|0)){i=J;return}l=(a[b+16>>0]|0)!=0;K=l?e:d;l=l?d:e;k=c[K+4>>2]|0;j=c[l+4>>2]|0;K=c[K+12>>2]|0;$=+g[K>>2];_=+g[K+16>>2];Z=+g[K+32>>2];Y=+g[K+4>>2];X=+g[K+20>>2];B=+g[K+36>>2];o=+g[K+8>>2];D=+g[K+24>>2];v=+g[K+40>>2];S=+g[K+48>>2];P=+g[K+52>>2];M=+g[K+56>>2];f=c[l+12>>2]|0;W=+g[f>>2];V=+g[f+16>>2];C=+g[f+32>>2];U=+g[f+4>>2];T=+g[f+20>>2];E=+g[f+36>>2];u=+g[f+8>>2];s=+g[f+24>>2];q=+g[f+40>>2];L=-+g[f+48>>2];I=-+g[f+52>>2];F=-+g[f+56>>2];G=+g[K>>2];H=+g[K+16>>2];A=+g[K+32>>2];y=+g[K+4>>2];x=+g[K+20>>2];w=+g[K+36>>2];t=+g[K+8>>2];r=+g[K+24>>2];p=+g[K+40>>2];K=c[(c[k>>2]|0)+64>>2]|0;m=-+g[j+48>>2];n=-+g[j+52>>2];z=-+g[j+56>>2];g[J+32>>2]=($*W+_*V+Z*C)*m+($*U+_*T+Z*E)*n+($*u+_*s+Z*q)*z;g[J+32+4>>2]=(Y*W+X*V+B*C)*m+(Y*U+X*T+B*E)*n+(Y*u+X*s+B*q)*z;g[J+32+8>>2]=(o*W+D*V+v*C)*m+(o*U+D*T+v*E)*n+(o*u+D*s+v*q)*z;g[J+32+12>>2]=0.0;jc[K&127](J+48|0,k,J+32|0);z=+g[J+48>>2];v=+g[J+48+4>>2];D=+g[J+48+8>>2];o=+g[j+48>>2];n=+g[j+52>>2];m=+g[j+56>>2];B=m*(S*u+P*s+M*q+(u*L+s*I+q*F)+((u*G+s*H+q*A)*z+(u*y+s*x+q*w)*v+(u*t+s*r+q*p)*D))+(o*(S*W+P*V+M*C+(W*L+V*I+C*F)+((W*G+V*H+C*A)*z+(W*y+V*x+C*w)*v+(W*t+V*r+C*p)*D))+n*(S*U+P*T+M*E+(U*L+T*I+E*F)+((U*G+T*H+E*A)*z+(U*y+T*x+E*w)*v+(U*t+T*r+E*p)*D)))-+g[j+64>>2];C=S*W+P*V+M*C+(W*L+V*I+C*F)+((W*G+V*H+C*A)*z+(W*y+V*x+C*w)*v+(W*t+V*r+C*p)*D)-o*B;E=S*U+P*T+M*E+(U*L+T*I+E*F)+((U*G+T*H+E*A)*z+(U*y+T*x+E*w)*v+(U*t+T*r+E*p)*D)-n*B;D=S*u+P*s+M*q+(u*L+s*I+q*F)+((u*G+s*H+q*A)*z+(u*y+s*x+q*w)*v+(u*t+s*r+q*p)*D)-m*B;K=c[l+12>>2]|0;p=+g[K>>2];q=+g[K+4>>2];r=+g[K+8>>2];s=+g[K+16>>2];t=+g[K+20>>2];u=+g[K+24>>2];v=+g[K+32>>2];w=+g[K+36>>2];x=+g[K+40>>2];y=+g[K+48>>2];z=+g[K+52>>2];A=+g[K+56>>2];K=c[b+12>>2]|0;f=B<+g[K+752>>2];c[h+4>>2]=K;if(f){f=c[l+12>>2]|0;G=o*+g[f+16>>2]+n*+g[f+20>>2]+m*+g[f+24>>2];H=o*+g[f+32>>2]+n*+g[f+36>>2]+m*+g[f+40>>2];g[J+16>>2]=+g[f>>2]*o+ +g[f+4>>2]*n+ +g[f+8>>2]*m;g[J+16+4>>2]=G;g[J+16+8>>2]=H;g[J+16+12>>2]=0.0;g[J>>2]=r*D+(p*C+q*E)+y;g[J+4>>2]=C*s+E*t+D*u+z;g[J+8>>2]=C*v+E*w+D*x+A;g[J+12>>2]=0.0;ic[c[(c[h>>2]|0)+16>>2]&15](h,J+16|0,J,B)}if((c[k+4>>2]|0)<7?(c[(c[h+4>>2]|0)+748>>2]|0)<(c[b+24>>2]|0):0){m=+g[j+56>>2];if(+N(+m)>.7071067690849304){H=+g[j+52>>2];o=1.0/+O(+(m*m+H*H));n=0.0;m=-(m*o);o=H*o}else{o=+g[j+48>>2];n=+g[j+52>>2];m=1.0/+O(+(o*o+n*n));n=-(n*m);m=o*m;o=0.0}F=.019999999552965164/+Tb[c[(c[k>>2]|0)+16>>2]&15](k);G=+O(+(o*o+(m*m+n*n)));F=F>.39269909262657166?.19634954631328583:F*.5;G=+R(+F)/G;I=n*G;H=m*G;G=o*G;F=+Q(+F);l=c[b+20>>2]|0;if((l|0)>0){k=0;do{y=+g[j+48>>2];L=+g[j+52>>2];p=+g[j+56>>2];n=+(k|0)*(6.2831854820251465/+(l|0))*.5;M=+R(+n)/+O(+(y*y+L*L+p*p));n=+Q(+n);o=G*-(L*M)+(I*n+F*-(y*M))-H*-(p*M);w=I*-(p*M)+(F*-(L*M)+H*n)-G*-(y*M);ca=H*-(y*M)+(G*n+F*-(p*M))-I*-(L*M);r=F*n-I*-(y*M)-H*-(L*M)-G*-(p*M);ha=p*M*w+(y*M*r+n*o)-L*M*ca;ga=y*M*ca+(n*w+L*M*r)-p*M*o;ia=L*M*o+(p*M*r+n*ca)-y*M*w;ca=n*r-y*M*o-L*M*w-p*M*ca;l=(a[b+16>>0]|0)!=0;aa=l?e:d;l=l?d:e;f=c[aa+4>>2]|0;K=c[l+4>>2]|0;aa=c[aa+12>>2]|0;M=+g[aa>>2];p=+g[aa+4>>2];w=+g[aa+8>>2];L=+g[aa+16>>2];o=+g[aa+20>>2];y=+g[aa+24>>2];r=+g[aa+32>>2];n=+g[aa+36>>2];A=+g[aa+40>>2];W=+g[aa+48>>2];V=+g[aa+52>>2];U=+g[aa+56>>2];aa=c[l+12>>2]|0;_=+g[aa>>2];Z=+g[aa+16>>2];s=+g[aa+32>>2];Y=+g[aa+4>>2];X=+g[aa+20>>2];v=+g[aa+36>>2];x=+g[aa+8>>2];z=+g[aa+24>>2];B=+g[aa+40>>2];T=-+g[aa+48>>2];S=-+g[aa+52>>2];P=-+g[aa+56>>2];fa=ha*(2.0/(ha*ha+ga*ga+ia*ia+ca*ca));u=ga*(2.0/(ha*ha+ga*ga+ia*ia+ca*ca));ba=ia*(2.0/(ha*ha+ga*ga+ia*ia+ca*ca));na=w*(ha*ba-ca*u)+(p*(ha*u+ca*ba)+M*(1.0-(ga*u+ia*ba)));ka=w*(ga*ba+ca*fa)+(M*(ha*u-ca*ba)+p*(1.0-(ha*fa+ia*ba)));t=M*(ha*ba+ca*u)+p*(ga*ba-ca*fa)+w*(1.0-(ha*fa+ga*u));ma=y*(ha*ba-ca*u)+(o*(ha*u+ca*ba)+L*(1.0-(ga*u+ia*ba)));ja=y*(ga*ba+ca*fa)+(L*(ha*u-ca*ba)+o*(1.0-(ha*fa+ia*ba)));D=L*(ha*ba+ca*u)+o*(ga*ba-ca*fa)+y*(1.0-(ha*fa+ga*u));la=A*(ha*ba-ca*u)+(n*(ha*u+ca*ba)+r*(1.0-(ga*u+ia*ba)));ia=A*(ga*ba+ca*fa)+(r*(ha*u-ca*ba)+n*(1.0-(ha*fa+ia*ba)));u=r*(ha*ba+ca*u)+n*(ga*ba-ca*fa)+A*(1.0-(ha*fa+ga*u));ga=+g[aa>>2];fa=+g[aa+16>>2];ha=+g[aa+32>>2];ca=+g[aa+4>>2];ba=+g[aa+20>>2];da=+g[aa+36>>2];C=+g[aa+8>>2];E=+g[aa+24>>2];m=+g[aa+40>>2];aa=c[(c[f>>2]|0)+64>>2]|0;ea=-+g[K+48>>2];$=-+g[K+52>>2];q=-+g[K+56>>2];g[J+96>>2]=(ha*la+(ga*na+fa*ma))*ea+(da*la+(ca*na+ba*ma))*$+(na*C+ma*E+la*m)*q;g[J+96+4>>2]=(ha*ia+(ga*ka+fa*ja))*ea+(da*ia+(ca*ka+ba*ja))*$+(C*ka+ja*E+ia*m)*q;g[J+96+8>>2]=(ha*u+(ga*t+fa*D))*ea+(da*u+(ca*t+ba*D))*$+(t*C+D*E+u*m)*q;g[J+96+12>>2]=0.0;jc[aa&127](J+112|0,f,J+96|0);q=+g[J+112>>2];m=+g[J+112+4>>2];u=+g[J+112+8>>2];E=+g[K+48>>2];D=+g[K+52>>2];C=+g[K+56>>2];t=C*(W*x+V*z+U*B+(x*T+z*S+B*P)+((M*x+L*z+r*B)*q+(p*x+o*z+n*B)*m+(w*x+y*z+A*B)*u))+(E*(W*_+V*Z+U*s+(_*T+Z*S+s*P)+((M*_+L*Z+r*s)*q+(p*_+o*Z+n*s)*m+(w*_+y*Z+A*s)*u))+D*(W*Y+V*X+U*v+(Y*T+X*S+v*P)+((M*Y+L*X+r*v)*q+(p*Y+o*X+n*v)*m+(w*Y+y*X+A*v)*u)))-+g[K+64>>2];s=W*_+V*Z+U*s+(_*T+Z*S+s*P)+((M*_+L*Z+r*s)*q+(p*_+o*Z+n*s)*m+(w*_+y*Z+A*s)*u)-E*t;v=W*Y+V*X+U*v+(Y*T+X*S+v*P)+((M*Y+L*X+r*v)*q+(p*Y+o*X+n*v)*m+(w*Y+y*X+A*v)*u)-D*t;u=W*x+V*z+U*B+(x*T+z*S+B*P)+((M*x+L*z+r*B)*q+(p*x+o*z+n*B)*m+(w*x+y*z+A*B)*u)-C*t;K=c[l+12>>2]|0;B=+g[K>>2];A=+g[K+4>>2];z=+g[K+8>>2];y=+g[K+16>>2];x=+g[K+20>>2];w=+g[K+24>>2];m=+g[K+32>>2];n=+g[K+36>>2];o=+g[K+40>>2];p=+g[K+48>>2];q=+g[K+52>>2];r=+g[K+56>>2];K=c[b+12>>2]|0;f=t<+g[K+752>>2];c[h+4>>2]=K;if(f){K=c[l+12>>2]|0;da=E*+g[K+16>>2]+D*+g[K+20>>2]+C*+g[K+24>>2];ea=E*+g[K+32>>2]+D*+g[K+36>>2]+C*+g[K+40>>2];g[J+80>>2]=+g[K>>2]*E+ +g[K+4>>2]*D+ +g[K+8>>2]*C;g[J+80+4>>2]=da;g[J+80+8>>2]=ea;g[J+80+12>>2]=0.0;g[J+64>>2]=z*u+(B*s+A*v)+p;g[J+64+4>>2]=s*y+v*x+u*w+q;g[J+64+8>>2]=s*m+v*n+u*o+r;g[J+64+12>>2]=0.0;ic[c[(c[h>>2]|0)+16>>2]&15](h,J+80|0,J+64|0,t)}k=k+1|0;l=c[b+20>>2]|0}while((k|0)<(l|0))}}if(!(a[b+8>>0]|0)){i=J;return}if(!(c[(c[b+12>>2]|0)+748>>2]|0)){i=J;return}j=c[h+4>>2]|0;if(!(c[j+748>>2]|0)){i=J;return}k=c[j+740>>2]|0;l=c[(c[h+8>>2]|0)+8>>2]|0;f=c[(c[h+12>>2]|0)+8>>2]|0;if((k|0)==(l|0)){Ns(j,k+4|0,f+4|0);i=J;return}else{Ns(j,f+4|0,l+4|0);i=J;return}}function bu(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function cu(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+12>>2]|0;if(!e)return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=(f|0)!=0?f<<1:1,(f|0)<(h|0)):0){if(!h){e=f;f=0}else{c[2703]=(c[2703]|0)+1;e=XE((h<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+4+15&-16)+-4>>2]=e;f=e+4+15&-16}e=c[d+4>>2]|0}if((e|0)>0){g=0;do{c[f+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0);e=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=f;c[d+8>>2]=h;f=e;e=c[b+12>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function du(a){a=a|0;var b=0;c[a>>2]=5596;c[a+12>>2]=5624;b=c[a+60>>2]|0;Fb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+76>>2]|0);b=c[a+60>>2]|0;Fb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+76>>2]|0);return}function eu(a){a=a|0;var b=0;c[a>>2]=5596;c[a+12>>2]=5624;b=c[a+60>>2]|0;Fb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+76>>2]|0);b=c[a+60>>2]|0;Fb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+76>>2]|0);YE(a);return}function fu(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+76>>2]|0;if(!e)return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=(f|0)!=0?f<<1:1,(f|0)<(h|0)):0){if(!h){e=f;f=0}else{c[2703]=(c[2703]|0)+1;e=XE((h<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+4+15&-16)+-4>>2]=e;f=e+4+15&-16}e=c[d+4>>2]|0}if((e|0)>0){g=0;do{c[f+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0);e=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=f;c[d+8>>2]=h;f=e;e=c[b+76>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function gu(a){a=a|0;var b=0;c[a>>2]=5624;b=c[a+48>>2]|0;Fb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+64>>2]|0);b=c[a+48>>2]|0;Fb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+64>>2]|0);return}function hu(a){a=a|0;var b=0;c[a>>2]=5624;b=c[a+48>>2]|0;Fb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+64>>2]|0);b=c[a+48>>2]|0;Fb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+64>>2]|0);YE(a);return}function iu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0;o=i;i=i+128|0;j=+g[b>>2];k=+g[b+16>>2];p=j<k?j:k;l=+g[b+32>>2];if((p<l?p:l)>+g[a+28>>2]){i=o;return}f=j>k?b:b+16|0;if(+g[(+g[f>>2]>l?f:b+32|0)>>2]<+g[a+12>>2]){i=o;return}l=+g[b+8>>2];k=+g[b+24>>2];p=l<k?l:k;j=+g[b+40>>2];if((p<j?p:j)>+g[a+36>>2]){i=o;return}f=l>k?b+8|0:b+24|0;if(+g[(+g[f>>2]>j?f:b+40|0)>>2]<+g[a+20>>2]){i=o;return}k=+g[b+4>>2];j=+g[b+20>>2];p=k<j?k:j;l=+g[b+36>>2];if((p<l?p:l)>+g[a+32>>2]){i=o;return}f=k>j?b+4|0:b+20|0;if(+g[(+g[f>>2]>l?f:b+36|0)>>2]<+g[a+16>>2]){i=o;return}m=c[a+48>>2]|0;h=c[a+4>>2]|0;if((c[(c[h+4>>2]|0)+4>>2]|0)>=20){i=o;return}c[o+24+8>>2]=0;c[o+24+12>>2]=1065353216;c[o+24+16>>2]=1065353216;c[o+24+20>>2]=1065353216;g[o+24+24>>2]=0.0;c[o+24+52>>2]=0;c[o+24>>2]=5644;c[o+24+4>>2]=1;c[o+24+56>>2]=c[b>>2];c[o+24+56+4>>2]=c[b+4>>2];c[o+24+56+8>>2]=c[b+8>>2];c[o+24+56+12>>2]=c[b+12>>2];c[o+24+72>>2]=c[b+16>>2];c[o+24+72+4>>2]=c[b+16+4>>2];c[o+24+72+8>>2]=c[b+16+8>>2];c[o+24+72+12>>2]=c[b+16+12>>2];c[o+24+88>>2]=c[b+32>>2];c[o+24+88+4>>2]=c[b+32+4>>2];c[o+24+88+8>>2]=c[b+32+8>>2];c[o+24+88+12>>2]=c[b+32+12>>2];c[o+24+44>>2]=c[a+56>>2];q=c[a+8>>2]|0;f=c[q+8>>2]|0;b=c[q+12>>2]|0;c[o>>2]=q;c[o+4>>2]=o+24;c[o+8>>2]=f;c[o+12>>2]=b;c[o+16>>2]=d;c[o+20>>2]=e;b=Lb[c[(c[m>>2]|0)+8>>2]&31](m,h,o,c[a+64>>2]|0)|0;f=c[a+44>>2]|0;h=c[f+8>>2]|0;if((c[h+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0)){c[f+8>>2]=o;jc[c[(c[f>>2]|0)+8>>2]&127](f,d,e)}else{h=c[f+12>>2]|0;c[f+12>>2]=o;jc[c[(c[f>>2]|0)+12>>2]&127](f,d,e)}Bb[c[(c[b>>2]|0)+8>>2]&31](b,c[a+4>>2]|0,o,c[a+52>>2]|0,c[a+44>>2]|0);f=c[a+44>>2]|0;if((c[(c[f+8>>2]|0)+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0))c[f+8>>2]=h;else c[f+12>>2]=h;Db[c[c[b>>2]>>2]&255](b);Fb[c[(c[m>>2]|0)+60>>2]&127](m,b);c[o+24>>2]=7356;f=c[o+24+52>>2]|0;if((f|0)!=0?(Db[c[c[f>>2]>>2]&255](f),n=c[o+24+52>>2]|0,(n|0)!=0):0){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}i=o;return}function ju(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;l=i;i=i+64|0;j=(a[b+8>>0]|0)!=0;k=j?e:d;d=j?d:e;j=c[d+4>>2]|0;if(((c[j+4>>2]|0)+-21|0)>>>0>=9){i=l;return}if((c[(c[k+4>>2]|0)+4>>2]|0)>=20){i=l;return}m=+Tb[c[(c[j>>2]|0)+48>>2]&15](j);c[h+4>>2]=c[b+76>>2];c[b+16>>2]=k;c[b+20>>2]=d;c[b+64>>2]=f;g[b+68>>2]=m;c[b+56>>2]=h;e=c[d+12>>2]|0;B=+g[e>>2];A=+g[e+16>>2];z=+g[e+32>>2];y=+g[e+4>>2];x=+g[e+20>>2];w=+g[e+36>>2];s=+g[e+8>>2];q=+g[e+24>>2];o=+g[e+40>>2];v=-+g[e+48>>2];u=-+g[e+52>>2];t=-+g[e+56>>2];e=c[k+12>>2]|0;K=+g[e>>2];J=+g[e+16>>2];I=+g[e+32>>2];H=+g[e+4>>2];G=+g[e+20>>2];F=+g[e+36>>2];E=+g[e+8>>2];D=+g[e+24>>2];C=+g[e+40>>2];r=+g[e+48>>2];p=+g[e+52>>2];n=+g[e+56>>2];g[l>>2]=B*K+A*J+z*I;g[l+4>>2]=B*H+A*G+z*F;g[l+8>>2]=B*E+A*D+z*C;g[l+12>>2]=0.0;g[l+16>>2]=y*K+x*J+w*I;g[l+20>>2]=y*H+x*G+w*F;g[l+24>>2]=y*E+x*D+w*C;g[l+28>>2]=0.0;g[l+32>>2]=s*K+q*J+o*I;g[l+36>>2]=s*H+q*G+o*F;g[l+40>>2]=s*E+q*D+o*C;g[l+44>>2]=0.0;g[l+48>>2]=B*v+A*u+z*t+(B*r+A*p+z*n);g[l+52>>2]=y*v+x*u+w*t+(y*r+x*p+w*n);g[l+56>>2]=s*v+q*u+o*t+(s*r+q*p+o*n);g[l+60>>2]=0.0;e=c[(c[b+16>>2]|0)+4>>2]|0;nc[c[(c[e>>2]|0)+8>>2]&127](e,l,b+24|0,b+40|0);g[b+40>>2]=+g[b+40>>2]+m;g[b+44>>2]=+g[b+44>>2]+m;g[b+48>>2]=+g[b+48>>2]+m;g[b+24>>2]=+g[b+24>>2]-m;g[b+28>>2]=+g[b+28>>2]-m;g[b+32>>2]=+g[b+32>>2]-m;e=c[b+76>>2]|0;d=c[d+8>>2]|0;c[e+740>>2]=c[k+8>>2];c[e+744>>2]=d;nc[c[(c[j>>2]|0)+64>>2]&127](j,b+12|0,b+24|0,b+40|0);k=c[h+4>>2]|0;do if(c[k+748>>2]|0){e=c[k+740>>2]|0;d=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((e|0)==(d|0)){Ns(k,e+4|0,j+4|0);break}else{Ns(k,j+4|0,d+4|0);break}}while(0);c[b+16>>2]=0;c[b+20>>2]=0;i=l;return}function ku(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0;h=i;i=i+240|0;f=(a[b+8>>0]|0)!=0;b=f?e:d;e=f?d:e;B=+g[b+116>>2]-+g[b+52>>2];C=+g[b+120>>2]-+g[b+56>>2];D=+g[b+124>>2]-+g[b+60>>2];E=+g[b+252>>2];if(B*B+C*C+D*D<E*E){E=1.0;i=h;return +E}P=+g[e+4>>2];p=+g[e+20>>2];q=+g[e+36>>2];r=+g[e+8>>2];s=+g[e+24>>2];t=+g[e+40>>2];u=+g[e+12>>2];v=+g[e+28>>2];w=+g[e+44>>2];n=-+g[e+52>>2];m=-+g[e+56>>2];l=-+g[e+60>>2];x=+g[b+4>>2];y=+g[b+20>>2];z=+g[b+36>>2];A=+g[b+8>>2];B=+g[b+24>>2];C=+g[b+40>>2];D=+g[b+12>>2];E=+g[b+28>>2];F=+g[b+44>>2];H=+g[b+52>>2];G=+g[b+56>>2];T=+g[b+60>>2];R=P*n+p*m+q*l+(P*H+p*G+q*T);V=r*n+s*m+t*l+(r*H+s*G+t*T);T=u*n+v*m+w*l+(u*H+v*G+w*T);G=+g[b+68>>2];H=+g[b+84>>2];I=+g[b+100>>2];J=+g[b+72>>2];K=+g[b+88>>2];L=+g[b+104>>2];M=+g[b+76>>2];N=+g[b+92>>2];O=+g[b+108>>2];k=+g[b+116>>2];j=+g[b+120>>2];S=+g[b+124>>2];Q=P*n+p*m+q*l+(P*k+p*j+q*S);U=r*n+s*m+t*l+(r*k+s*j+t*S);S=u*n+v*m+w*l+(u*k+v*j+w*S);e=c[e+192>>2]|0;if(((c[e+4>>2]|0)+-21|0)>>>0>=9){E=1.0;i=h;return +E}g[h+16>>2]=R;g[h+16+4>>2]=V;g[h+16+8>>2]=T;g[h+16+12>>2]=0.0;if(Q<R){g[h+16>>2]=Q;j=Q}else j=R;if(U<V){g[h+16+4>>2]=U;k=U}else k=V;if(S<T){g[h+16+8>>2]=S;l=S}else l=T;g[h>>2]=R;g[h+4>>2]=V;g[h+8>>2]=T;g[h+12>>2]=0.0;if(R<Q){g[h>>2]=Q;m=Q}else m=R;if(V<U){g[h+4>>2]=U;n=U}else n=V;if(T<S){g[h+8>>2]=S;o=S}else o=T;X=+g[b+248>>2];g[h+16>>2]=j-X;g[h+16+4>>2]=k-X;g[h+16+8>>2]=l-X;g[h>>2]=X+m;g[h+4>>2]=X+n;g[h+8>>2]=X+o;c[h+32>>2]=5780;g[h+32+4>>2]=P*x+p*y+q*z;g[h+32+8>>2]=P*A+p*B+q*C;g[h+32+12>>2]=P*D+p*E+q*F;g[h+32+16>>2]=0.0;g[h+32+20>>2]=r*x+s*y+t*z;g[h+32+24>>2]=r*A+s*B+t*C;g[h+32+28>>2]=r*D+s*E+t*F;g[h+32+32>>2]=0.0;g[h+32+36>>2]=u*x+v*y+w*z;g[h+32+40>>2]=u*A+v*B+w*C;g[h+32+44>>2]=u*D+v*E+w*F;g[h+32+48>>2]=0.0;g[h+32+52>>2]=R;g[h+32+56>>2]=V;g[h+32+60>>2]=T;g[h+32+64>>2]=0.0;g[h+32+68>>2]=P*G+p*H+q*I;g[h+32+72>>2]=P*J+p*K+q*L;g[h+32+76>>2]=P*M+p*N+q*O;g[h+32+80>>2]=0.0;g[h+32+84>>2]=r*G+s*H+t*I;g[h+32+88>>2]=r*J+s*K+t*L;g[h+32+92>>2]=r*M+s*N+t*O;g[h+32+96>>2]=0.0;g[h+32+100>>2]=u*G+v*H+w*I;g[h+32+104>>2]=u*J+v*K+w*L;g[h+32+108>>2]=u*M+v*N+w*O;g[h+32+112>>2]=0.0;g[h+32+116>>2]=Q;g[h+32+120>>2]=U;g[h+32+124>>2]=S;g[h+32+128>>2]=0.0;g[h+32+196>>2]=X;c[h+32+200>>2]=c[b+244>>2];if((e|0)!=0?(nc[c[(c[e>>2]|0)+64>>2]&127](e,h+32|0,h+16|0,h),W=+g[h+32+200>>2],W<+g[b+244>>2]):0){g[b+244>>2]=W;E=W;i=h;return +E}E=1.0;i=h;return +E}function lu(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function mu(a){a=a|0;var b=0,d=0;c[a>>2]=7356;b=c[a+52>>2]|0;if((b|0)!=0?(Db[c[c[b>>2]>>2]&255](b),d=c[a+52>>2]|0,(d|0)!=0):0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function nu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a>>2]|0)+80>>2]&127](a,b,d,e);return}function ou(a){a=a|0;return a+12|0}function pu(a,b,d){a=a|0;b=+b;d=d|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;return}function qu(a){a=a|0;return 14544}function ru(a,b){a=a|0;b=b|0;c[a>>2]=1065353216;c[a+4>>2]=1065353216;c[a+8>>2]=1065353216;g[a+12>>2]=0.0;return}function su(a){a=a|0;return +(+g[a+44>>2])}function tu(a){a=a|0;return 52}function uu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=_b[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=_b[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Fb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+28>>2]=c[a+28>>2];c[b+32>>2]=c[a+32>>2];c[b+36>>2]=c[a+36>>2];c[b+40>>2]=c[a+40>>2];c[b+12>>2]=c[a+12>>2];c[b+16>>2]=c[a+16>>2];c[b+20>>2]=c[a+20>>2];c[b+24>>2]=c[a+24>>2];c[b+44>>2]=c[a+44>>2];return 14518}function vu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;j=+g[d>>2];i=+g[d+4>>2];e=+g[d+8>>2];f=j*+g[b+56>>2]+i*+g[b+60>>2]+e*+g[b+64>>2];h=j*+g[b+72>>2]+i*+g[b+76>>2]+e*+g[b+80>>2];e=j*+g[b+88>>2]+i*+g[b+92>>2]+e*+g[b+96>>2];d=b+56+((f<h?(h<e?2:1):f<e?2:0)<<4)|0;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];return}function wu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;if((e|0)<=0)return;f=0;do{n=+g[b+(f<<4)>>2];m=+g[b+(f<<4)+4>>2];j=+g[b+(f<<4)+8>>2];k=n*+g[a+56>>2]+m*+g[a+60>>2]+j*+g[a+64>>2];l=n*+g[a+72>>2]+m*+g[a+76>>2]+j*+g[a+80>>2];j=n*+g[a+88>>2]+m*+g[a+92>>2]+j*+g[a+96>>2];h=d+(f<<4)|0;i=a+56+((k<l?(l<j?2:1):k<j?2:0)<<4)|0;c[h>>2]=c[i>>2];c[h+4>>2]=c[i+4>>2];c[h+8>>2]=c[i+8>>2];c[h+12>>2]=c[i+12>>2];f=f+1|0}while((f|0)!=(e|0));return}function xu(a){a=a|0;return 2}function yu(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;h=+g[a+56>>2];f=+g[a+72>>2]-h;k=+g[a+60>>2];j=+g[a+76>>2]-k;e=+g[a+64>>2];i=+g[a+80>>2]-e;h=+g[a+88>>2]-h;k=+g[a+92>>2]-k;e=+g[a+96>>2]-e;g[c+12>>2]=0.0;d=1.0/+O(+((f*k-j*h)*(f*k-j*h)+((j*e-i*k)*(j*e-i*k)+(i*h-f*e)*(i*h-f*e))));g[c>>2]=d*(j*e-i*k);g[c+4>>2]=d*(i*h-f*e);g[c+8>>2]=(f*k-j*h)*d;if(!b)return;g[c>>2]=-(d*(j*e-i*k));g[c+4>>2]=-(d*(i*h-f*e));g[c+8>>2]=-((f*k-j*h)*d);return}function zu(a){a=a|0;return 3}function Au(a){a=a|0;return 3}function Bu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;jc[c[(c[a>>2]|0)+108>>2]&127](a,b,d);jc[c[(c[a>>2]|0)+108>>2]&127](a,(b+1|0)%3|0,e);return}function Cu(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[a+56+(b<<4)>>2];c[d+4>>2]=c[a+56+(b<<4)+4>>2];c[d+8>>2]=c[a+56+(b<<4)+8>>2];c[d+12>>2]=c[a+56+(b<<4)+12>>2];return}function Du(a){a=a|0;return 1}function Eu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a>>2]|0)+124>>2]&127](a,e,b,d);return}function Fu(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;k=i;i=i+32|0;n=+g[a+56>>2];r=+g[a+72>>2]-n;m=+g[a+60>>2];p=+g[a+76>>2]-m;l=+g[a+64>>2];s=+g[a+80>>2]-l;o=+g[a+88>>2]-n;q=+g[a+92>>2]-m;h=+g[a+96>>2]-l;j=1.0/+O(+((r*q-p*o)*(r*q-p*o)+((p*h-s*q)*(p*h-s*q)+(s*o-r*h)*(s*o-r*h))));f=j*(p*h-s*q);h=j*(s*o-r*h);j=(r*q-p*o)*j;l=+g[b>>2]*f+ +g[b+4>>2]*h+j*+g[b+8>>2]-(f*n+h*m+j*l);if(!(l>=-d)|!(l<=d)){b=0;i=k;return b|0}e=0;while(1){nc[c[(c[a>>2]|0)+104>>2]&127](a,e,k+16|0,k);q=+g[k+16>>2];p=+g[k>>2]-q;m=+g[k+16+4>>2];l=+g[k+4>>2]-m;r=+g[k+16+8>>2];o=+g[k+8>>2]-r;n=1.0/+O(+((h*p-f*l)*(h*p-f*l)+((j*l-h*o)*(j*l-h*o)+(f*o-j*p)*(f*o-j*p))));e=e+1|0;if(+g[b>>2]*(n*(j*l-h*o))+ +g[b+4>>2]*(n*(f*o-j*p))+(h*p-f*l)*n*+g[b+8>>2]-(r*((h*p-f*l)*n)+(q*(n*(j*l-h*o))+m*(n*(f*o-j*p))))<-d){b=0;e=5;break}if((e|0)>=3){b=1;e=5;break}}if((e|0)==5){i=k;return b|0}return 0}function Gu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;h=+g[a+56>>2];k=+g[a+72>>2]-h;j=+g[a+60>>2];i=+g[a+76>>2]-j;l=+g[a+64>>2];m=+g[a+80>>2]-l;h=+g[a+88>>2]-h;j=+g[a+92>>2]-j;l=+g[a+96>>2]-l;g[d+12>>2]=0.0;f=1.0/+O(+((k*j-i*h)*(k*j-i*h)+((i*l-m*j)*(i*l-m*j)+(m*h-k*l)*(m*h-k*l))));g[d>>2]=f*(i*l-m*j);g[d+4>>2]=f*(m*h-k*l);g[d+8>>2]=(k*j-i*h)*f;c[e>>2]=c[a+56>>2];c[e+4>>2]=c[a+56+4>>2];c[e+8>>2]=c[a+56+8>>2];c[e+12>>2]=c[a+56+12>>2];return}function Hu(a){a=a|0;YE(a);return}function Iu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0;f=i;i=i+784|0;c[f+712>>2]=1065353216;c[f+712+4>>2]=0;c[f+712+4+4>>2]=0;c[f+712+4+8>>2]=0;c[f+712+4+12>>2]=0;c[f+712+20>>2]=1065353216;c[f+712+24>>2]=0;c[f+712+24+4>>2]=0;c[f+712+24+8>>2]=0;c[f+712+24+12>>2]=0;c[f+712+40>>2]=1065353216;e=f+712+44|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[f+536>>2]=5800;c[f+536+168>>2]=0;g[f+536+172>>2]=0.0;c[f+536+164>>2]=c[b+200>>2];e=c[b+196>>2]|0;c[f+480+8>>2]=0;c[f+480+12>>2]=1065353216;c[f+480+16>>2]=1065353216;c[f+480+20>>2]=1065353216;g[f+480+24>>2]=0.0;c[f+480>>2]=6904;c[f+480+4>>2]=8;c[f+480+28>>2]=e;c[f+480+44>>2]=e;c[f+376+8>>2]=0;c[f+376+12>>2]=1065353216;c[f+376+16>>2]=1065353216;c[f+376+20>>2]=1065353216;g[f+376+24>>2]=0.0;g[f+376+44>>2]=.03999999910593033;c[f+376+52>>2]=0;c[f+376>>2]=5644;c[f+376+4>>2]=1;c[f+376+56>>2]=c[d>>2];c[f+376+56+4>>2]=c[d+4>>2];c[f+376+56+8>>2]=c[d+8>>2];c[f+376+56+12>>2]=c[d+12>>2];c[f+376+72>>2]=c[d+16>>2];c[f+376+72+4>>2]=c[d+16+4>>2];c[f+376+72+8>>2]=c[d+16+8>>2];c[f+376+72+12>>2]=c[d+16+12>>2];c[f+376+88>>2]=c[d+32>>2];c[f+376+88+4>>2]=c[d+32+4>>2];c[f+376+88+8>>2]=c[d+32+8>>2];c[f+376+88+12>>2]=c[d+32+12>>2];g[f+16+308>>2]=9.999999747378752e-05;a[f+16+332>>0]=0;c[f>>2]=10380;c[f+4>>2]=f+16;c[f+8>>2]=f+480;c[f+12>>2]=f+376;if(ZC(f,b+4|0,b+68|0,f+712|0,f+712|0,f+536|0)|0?(h=+g[f+536+164>>2],+g[b+200>>2]>h):0)g[b+200>>2]=h;c[f+376>>2]=7356;e=c[f+376+52>>2]|0;if(!e){i=f;return}Db[c[c[e>>2]>>2]&255](e);e=c[f+376+52>>2]|0;if(!e){i=f;return}c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0);i=f;return}function Ju(a,b){a=a|0;b=+b;return}function Ku(a,b){a=a|0;b=b|0;return}function Lu(a,b,c){a=a|0;b=b|0;c=c|0;return}function Mu(a){a=a|0;YE(a);return}function Nu(a){a=a|0;return}function Ou(b){b=b|0;var d=0;c[b>>2]=5828;if(!(a[b+8>>0]|0))return;d=c[b+12>>2]|0;if(!d)return;b=c[b+4>>2]|0;Fb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function Pu(b){b=b|0;var d=0,e=0;c[b>>2]=5828;if(!(a[b+8>>0]|0)){YE(b);return}d=c[b+12>>2]|0;if(!d){YE(b);return}e=c[b+4>>2]|0;Fb[c[(c[e>>2]|0)+16>>2]&127](e,d);YE(b);return}function Qu(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;l=i;i=i+144|0;j=c[b+12>>2]|0;if(!j){i=l;return}n=c[d+4>>2]|0;m=c[e+4>>2]|0;c[h+4>>2]=j;g[l+12+128>>2]=999999984306749440.0;d=c[d+12>>2]|0;c[l+12>>2]=c[d>>2];c[l+12+4>>2]=c[d+4>>2];c[l+12+8>>2]=c[d+8>>2];c[l+12+12>>2]=c[d+12>>2];c[l+12+16>>2]=c[d+16>>2];c[l+12+16+4>>2]=c[d+16+4>>2];c[l+12+16+8>>2]=c[d+16+8>>2];c[l+12+16+12>>2]=c[d+16+12>>2];c[l+12+32>>2]=c[d+32>>2];c[l+12+32+4>>2]=c[d+32+4>>2];c[l+12+32+8>>2]=c[d+32+8>>2];c[l+12+32+12>>2]=c[d+32+12>>2];c[l+12+48>>2]=c[d+48>>2];c[l+12+48+4>>2]=c[d+48+4>>2];c[l+12+48+8>>2]=c[d+48+8>>2];c[l+12+48+12>>2]=c[d+48+12>>2];e=c[e+12>>2]|0;c[l+12+64>>2]=c[e>>2];c[l+12+64+4>>2]=c[e+4>>2];c[l+12+64+8>>2]=c[e+8>>2];c[l+12+64+12>>2]=c[e+12>>2];c[l+12+80>>2]=c[e+16>>2];c[l+12+80+4>>2]=c[e+16+4>>2];c[l+12+80+8>>2]=c[e+16+8>>2];c[l+12+80+12>>2]=c[e+16+12>>2];c[l+12+96>>2]=c[e+32>>2];c[l+12+96+4>>2]=c[e+32+4>>2];c[l+12+96+8>>2]=c[e+32+8>>2];c[l+12+96+12>>2]=c[e+32+12>>2];c[l+12+112>>2]=c[e+48>>2];c[l+12+112+4>>2]=c[e+48+4>>2];c[l+12+112+8>>2]=c[e+48+8>>2];c[l+12+112+12>>2]=c[e+48+12>>2];c[l>>2]=10608;c[l+4>>2]=n;c[l+8>>2]=m;JD(l,l+12|0,h,c[f+20>>2]|0,0);do if((a[b+8>>0]|0)!=0?(k=c[h+4>>2]|0,(c[k+748>>2]|0)!=0):0){d=c[k+740>>2]|0;j=c[(c[h+8>>2]|0)+8>>2]|0;e=c[(c[h+12>>2]|0)+8>>2]|0;if((d|0)==(j|0)){Ns(k,d+4|0,e+4|0);break}else{Ns(k,e+4|0,j+4|0);break}}while(0);i=l;return}function Ru(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function Su(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+12>>2]|0;if(!e)return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=(f|0)!=0?f<<1:1,(f|0)<(h|0)):0){if(!h){e=f;f=0}else{c[2703]=(c[2703]|0)+1;e=XE((h<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+4+15&-16)+-4>>2]=e;f=e+4+15&-16}e=c[d+4>>2]|0}if((e|0)>0){g=0;do{c[f+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0);e=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=f;c[d+8>>2]=h;f=e;e=c[b+12>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function Tu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0,A=0,B=0.0,C=0.0,D=0,E=0;A=i;i=i+192|0;x=c[b+4>>2]|0;if(+g[x+752>>2]<f){i=A;return}y=c[x+740>>2]|0;w=(c[b+8>>2]|0)+8|0;z=c[w>>2]|0;k=+g[e>>2];j=+g[d>>2]*f+k;n=+g[e+4>>2];r=+g[d+4>>2]*f+n;o=+g[e+8>>2];h=+g[d+8>>2]*f+o;v=(c[b+12>>2]|0)+8|0;q=c[v>>2]|0;l=+g[q+52>>2];if((y|0)!=(z|0)){m=r-+g[q+56>>2];u=h-+g[q+60>>2];B=k-+g[z+52>>2];k=n-+g[z+56>>2];o=o-+g[z+60>>2];s=(j-l)*+g[q+4>>2]+m*+g[q+20>>2]+u*+g[q+36>>2];t=(j-l)*+g[q+8>>2]+m*+g[q+24>>2]+u*+g[q+40>>2];u=(j-l)*+g[q+12>>2]+m*+g[q+28>>2]+u*+g[q+44>>2];n=B*+g[z+4>>2]+k*+g[z+20>>2]+o*+g[z+36>>2];m=B*+g[z+8>>2]+k*+g[z+24>>2]+o*+g[z+40>>2];o=B*+g[z+12>>2]+k*+g[z+28>>2]+o*+g[z+44>>2]}else{C=j-+g[y+52>>2];m=r-+g[y+56>>2];u=h-+g[y+60>>2];B=n-+g[q+56>>2];o=o-+g[q+60>>2];s=C*+g[y+4>>2]+m*+g[y+20>>2]+u*+g[y+36>>2];t=C*+g[y+8>>2]+m*+g[y+24>>2]+u*+g[y+40>>2];u=C*+g[y+12>>2]+m*+g[y+28>>2]+u*+g[y+44>>2];n=(k-l)*+g[q+4>>2]+B*+g[q+20>>2]+o*+g[q+36>>2];m=(k-l)*+g[q+8>>2]+B*+g[q+24>>2]+o*+g[q+40>>2];o=(k-l)*+g[q+12>>2]+B*+g[q+28>>2]+o*+g[q+44>>2]}g[A>>2]=s;g[A+4>>2]=t;g[A+8>>2]=u;g[A+12>>2]=0.0;g[A+16>>2]=n;g[A+20>>2]=m;g[A+24>>2]=o;g[A+28>>2]=0.0;c[A+64>>2]=c[d>>2];c[A+64+4>>2]=c[d+4>>2];c[A+64+8>>2]=c[d+8>>2];c[A+64+12>>2]=c[d+12>>2];g[A+80>>2]=f;g[A+84>>2]=0.0;g[A+88>>2]=0.0;g[A+92>>2]=0.0;c[A+112>>2]=0;a[A+116>>0]=0;c[A+120>>2]=0;c[A+120+4>>2]=0;c[A+120+8>>2]=0;c[A+120+12>>2]=0;c[A+120+16>>2]=0;c[A+120+20>>2]=0;c[A+120+24>>2]=0;c[A+120+28>>2]=0;g[A+48>>2]=j;g[A+52>>2]=r;g[A+56>>2]=h;g[A+60>>2]=0.0;c[A+32>>2]=c[e>>2];c[A+32+4>>2]=c[e+4>>2];c[A+32+8>>2]=c[e+8>>2];c[A+32+12>>2]=c[e+12>>2];k=+g[x+752>>2];d=c[x+748>>2]|0;if((d|0)>0){q=0;p=-1;o=k*k;while(1){n=+g[x+4+(q*184|0)>>2]-s;l=+g[x+4+(q*184|0)+4>>2]-t;m=+g[x+4+(q*184|0)+8>>2]-u;e=n*n+l*l+m*m<o;p=e?q:p;q=q+1|0;if((q|0)==(d|0))break;else o=e?n*n+l*l+m*m:o}}else p=-1;q=c[w>>2]|0;w=c[v>>2]|0;h=+g[q+224>>2]*+g[w+224>>2];h=h<-10.0?-10.0:h;g[A+84>>2]=h>10.0?10.0:h;g[A+92>>2]=+g[q+228>>2]*+g[w+228>>2];h=+g[q+232>>2]*+g[w+232>>2];h=h<-10.0?-10.0:h;g[A+88>>2]=h>10.0?10.0:h;h=+g[A+72>>2];w=+N(+h)>.7071067690849304;j=+g[A+68>>2];if(w){s=1.0/+O(+(h*h+j*j));f=+g[A+64>>2];k=s*j;l=f*-(s*h);m=0.0;n=-(s*h);o=(h*h+j*j)*s;h=-(f*(s*j))}else{o=+g[A+64>>2];s=1.0/+O(+(o*o+j*j));k=0.0;l=(o*o+j*j)*s;m=-(j*s);n=s*o;o=-(h*(s*o));h=h*-(j*s)}g[A+152>>2]=m;g[A+156>>2]=n;g[A+160>>2]=k;g[A+168>>2]=o;g[A+172>>2]=h;g[A+176>>2]=l;q=c[b+20>>2]|0;d=c[b+16>>2]|0;w=c[b+28>>2]|0;v=c[b+24>>2]|0;c[A+96>>2]=(y|0)!=(z|0)?q:d;c[A+100>>2]=(y|0)!=(z|0)?d:q;c[A+104>>2]=(y|0)!=(z|0)?w:v;c[A+108>>2]=(y|0)!=(z|0)?v:w;if((p|0)>-1){w=x+4+(p*184|0)+148|0;v=c[w>>2]|0;y=x+4+(p*184|0)+120|0;e=c[y>>2]|0;z=x+4+(p*184|0)+124|0;d=c[z>>2]|0;b=x+4+(p*184|0)+128|0;q=c[b>>2]|0;D=x+4+(p*184|0)+112|0;E=c[D>>2]|0;uF(x+4+(p*184|0)|0,A|0,184)|0;c[D>>2]=E;c[y>>2]=e;c[z>>2]=d;c[b>>2]=q;c[w>>2]=v}else Ms(x,A)|0;i=A;return}function Uu(a){a=a|0;return}function Vu(a){a=a|0;YE(a);return}function Wu(a,b,d){a=a|0;b=b|0;d=d|0;c[a+16>>2]=b;c[a+24>>2]=d;return}function Xu(a,b,d){a=a|0;b=b|0;d=d|0;c[a+20>>2]=b;c[a+28>>2]=d;return}function Yu(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=5884;e=c[b+8>>2]|0;d=c[b+16>>2]|0;if((e|0)>0){h=0;do{g=(c[d+(h<<2)>>2]|0)+188|0;f=c[g>>2]|0;if(f){e=c[b+68>>2]|0;e=Hb[c[(c[e>>2]|0)+36>>2]&127](e)|0;jc[c[(c[e>>2]|0)+40>>2]&127](e,f,c[b+24>>2]|0);e=c[b+68>>2]|0;jc[c[(c[e>>2]|0)+12>>2]&127](e,f,c[b+24>>2]|0);c[g>>2]=0;e=c[b+8>>2]|0;d=c[b+16>>2]|0}h=h+1|0}while((h|0)<(e|0))}if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;return}if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;return}function Zu(a){a=a|0;Yu(a);YE(a);return}function _u(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;l=i;i=i+96|0;g=c[b+8>>2]|0;if((g|0)==(c[b+12>>2]|0)?(k=(g|0)!=0?g<<1:1,(g|0)<(k|0)):0){if(!k)h=0;else{c[2703]=(c[2703]|0)+1;g=XE((k<<2|3)+16|0)|0;if(!g)h=0;else{c[(g+4+15&-16)+-4>>2]=g;h=g+4+15&-16}g=c[b+8>>2]|0}if((g|0)>0){j=0;do{c[h+(j<<2)>>2]=c[(c[b+16>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(g|0))}j=c[b+16>>2]|0;if(j){if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0);g=c[b+8>>2]|0}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=h;c[b+12>>2]=k}c[(c[b+16>>2]|0)+(g<<2)>>2]=d;c[b+8>>2]=g+1;c[l+32>>2]=c[d+4>>2];c[l+32+4>>2]=c[d+4+4>>2];c[l+32+8>>2]=c[d+4+8>>2];c[l+32+12>>2]=c[d+4+12>>2];c[l+32+16>>2]=c[d+20>>2];c[l+32+16+4>>2]=c[d+20+4>>2];c[l+32+16+8>>2]=c[d+20+8>>2];c[l+32+16+12>>2]=c[d+20+12>>2];c[l+32+32>>2]=c[d+36>>2];c[l+32+32+4>>2]=c[d+36+4>>2];c[l+32+32+8>>2]=c[d+36+8>>2];c[l+32+32+12>>2]=c[d+36+12>>2];c[l+32+48>>2]=c[d+52>>2];c[l+32+48+4>>2]=c[d+52+4>>2];c[l+32+48+8>>2]=c[d+52+8>>2];c[l+32+48+12>>2]=c[d+52+12>>2];g=c[d+192>>2]|0;nc[c[(c[g>>2]|0)+8>>2]&127](g,l+32|0,l+16|0,l);g=c[b+68>>2]|0;c[d+188>>2]=hc[c[(c[g>>2]|0)+8>>2]&3](g,l+16|0,l,c[(c[d+192>>2]|0)+4>>2]|0,d,e,f,c[b+24>>2]|0,0)|0;i=l;return}function $u(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+64|0;iE(15036);d=c[b+8>>2]|0;if((d|0)>0){q=0;do{p=c[(c[b+16>>2]|0)+(q<<2)>>2]|0;if(!(a[b+76>>0]|0))switch(c[p+216>>2]|0){case 2:case 5:break;default:s=5}else s=5;if((s|0)==5){s=0;d=c[p+192>>2]|0;nc[c[(c[d>>2]|0)+8>>2]&127](d,p+4|0,t+48|0,t+32|0);e=+g[t+48>>2]+-.019999999552965164;g[t+48>>2]=e;f=+g[t+48+4>>2]+-.019999999552965164;g[t+48+4>>2]=f;h=+g[t+48+8>>2]+-.019999999552965164;g[t+48+8>>2]=h;j=+g[t+32>>2]+.019999999552965164;g[t+32>>2]=j;k=+g[t+32+4>>2]+.019999999552965164;g[t+32+4>>2]=k;l=+g[t+32+8>>2]+.019999999552965164;g[t+32+8>>2]=l;if(((a[b+44>>0]|0)!=0?(c[p+236>>2]|0)==2:0)?(c[p+204>>2]&3|0)==0:0){d=c[p+192>>2]|0;nc[c[(c[d>>2]|0)+8>>2]&127](d,p+68|0,t+16|0,t);e=+g[t+16>>2]+-.019999999552965164;g[t+16>>2]=e;m=+g[t+16+4>>2]+-.019999999552965164;g[t+16+4>>2]=m;l=+g[t+16+8>>2]+-.019999999552965164;g[t+16+8>>2]=l;k=+g[t>>2]+.019999999552965164;g[t>>2]=k;n=+g[t+4>>2]+.019999999552965164;g[t+4>>2]=n;o=+g[t+8>>2]+.019999999552965164;g[t+8>>2]=o;f=+g[t+48>>2];if(e<f)g[t+48>>2]=e;else e=f;f=+g[t+48+4>>2];if(m<f){g[t+48+4>>2]=m;f=m}h=+g[t+48+8>>2];if(l<h){g[t+48+8>>2]=l;h=l}j=+g[t+16+12>>2];if(j<+g[t+48+12>>2])g[t+48+12>>2]=j;j=+g[t+32>>2];if(j<k){g[t+32>>2]=k;j=k}k=+g[t+32+4>>2];if(k<n){g[t+32+4>>2]=n;k=n}l=+g[t+32+8>>2];if(l<o){g[t+32+8>>2]=o;l=o}m=+g[t+12>>2];if(+g[t+32+12>>2]<m)g[t+32+12>>2]=m}d=c[b+68>>2]|0;if((c[p+204>>2]&1|0)==0?(j=j-e,f=k-f,e=l-h,!(j*j+f*f+e*e<999999995904.0)):0){if((c[p+216>>2]&-2|0)!=4)c[p+216>>2]=5;if((a[14844]|0)!=0?(r=c[b+72>>2]|0,(r|0)!=0):0){a[14844]=0;Fb[c[(c[r>>2]|0)+36>>2]&127](r,14845);d=c[b+72>>2]|0;Fb[c[(c[d>>2]|0)+36>>2]&127](d,14894);d=c[b+72>>2]|0;Fb[c[(c[d>>2]|0)+36>>2]&127](d,14962);d=c[b+72>>2]|0;Fb[c[(c[d>>2]|0)+36>>2]&127](d,15027)}}else Bb[c[(c[d>>2]|0)+16>>2]&31](d,c[p+188>>2]|0,t+48|0,t+32|0,c[b+24>>2]|0);d=c[b+8>>2]|0}q=q+1|0}while((q|0)<(d|0))}d=c[2700]|0;q=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=q;if(q){i=t;return}do if(c[d+4>>2]|0){vb(t+48|0,0)|0;q=c[2702]|0;g[d+8>>2]=+(((c[t+48+4>>2]|0)-(c[q+4>>2]|0)+(((c[t+48>>2]|0)-(c[q>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[2700]|0;break}else{i=t;return}}while(0);c[2700]=c[d+20>>2];i=t;return}function av(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;iE(15048);d=c[a+68>>2]|0;Fb[c[(c[d>>2]|0)+32>>2]&127](d,c[a+24>>2]|0);a=c[2700]|0;d=(c[a+16>>2]|0)+-1|0;c[a+16>>2]=d;if(d){i=b;return}do if(c[a+4>>2]|0){vb(b|0,0)|0;d=c[2702]|0;g[a+8>>2]=+(((c[b+4>>2]|0)-(c[d+4>>2]|0)+(((c[b>>2]|0)-(c[d>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3+ +g[a+8>>2];if(!(c[a+16>>2]|0)){a=c[2700]|0;break}else{i=b;return}}while(0);c[2700]=c[a+20>>2];i=b;return}function bv(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;i=i+16|0;iE(15074);Db[c[(c[a>>2]|0)+8>>2]&255](a);Db[c[(c[a>>2]|0)+12>>2]&255](a);b=c[a+24>>2]|0;iE(15108);if(b){f=c[(c[b>>2]|0)+32>>2]|0;e=c[a+68>>2]|0;e=Hb[c[(c[e>>2]|0)+36>>2]&127](e)|0;nc[f&127](b,e,a+28|0,c[a+24>>2]|0)}a=c[2700]|0;b=(c[a+16>>2]|0)+-1|0;c[a+16>>2]=b;do if(!b){if(c[a+4>>2]|0){vb(d|0,0)|0;b=c[2702]|0;g[a+8>>2]=+(((c[d+4>>2]|0)-(c[b+4>>2]|0)+(((c[d>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3+ +g[a+8>>2];b=c[2700]|0;if(c[a+16>>2]|0)break}else b=a;b=c[b+20>>2]|0;c[2700]=b}else b=a;while(0);a=b+16|0;e=(c[a>>2]|0)+-1|0;c[a>>2]=e;if(e){i=d;return}do if(c[b+4>>2]|0){vb(d|0,0)|0;f=c[2702]|0;e=b+8|0;g[e>>2]=+(((c[d+4>>2]|0)-(c[f+4>>2]|0)+(((c[d>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[e>>2];if(!(c[a>>2]|0)){b=c[2700]|0;break}else{i=d;return}}while(0);c[2700]=c[b+20>>2];i=d;return}function cv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=c[b+188>>2]|0;if(d){e=c[a+68>>2]|0;e=Hb[c[(c[e>>2]|0)+36>>2]&127](e)|0;jc[c[(c[e>>2]|0)+40>>2]&127](e,d,c[a+24>>2]|0);e=c[a+68>>2]|0;jc[c[(c[e>>2]|0)+12>>2]&127](e,d,c[a+24>>2]|0);c[b+188>>2]=0}f=c[a+8>>2]|0;if((f|0)<=0)return;g=c[a+16>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0)){h=9;break}}if((h|0)==9)return;if((d|0)>=(f|0))return;c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+16>>2]|0)+(f+-1<<2)>>2]=b;c[a+8>>2]=f+-1;return}function dv(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0,Q=0;Q=i;i=i+896|0;c[Q+264+8>>2]=0;c[Q+264+12>>2]=1065353216;c[Q+264+16>>2]=1065353216;c[Q+264+20>>2]=1065353216;g[Q+264+24>>2]=0.0;c[Q+264>>2]=6904;c[Q+264+4>>2]=8;g[Q+264+28>>2]=0.0;g[Q+264+44>>2]=0.0;v=c[e+4>>2]|0;w=c[e+12>>2]|0;j=c[v+4>>2]|0;if((j|0)<20){c[Q+712>>2]=5800;c[Q+712+168>>2]=0;g[Q+712+172>>2]=0.0;c[Q+712+164>>2]=c[f+4>>2];g[Q+352+308>>2]=9.999999747378752e-05;a[Q+352+332>>0]=0;c[Q+320>>2]=10380;c[Q+320+4>>2]=Q+352;c[Q+320+8>>2]=Q+264;c[Q+320+12>>2]=v;c[Q+248>>2]=10420;c[Q+248+4>>2]=Q+352;c[Q+248+8>>2]=Q+264;c[Q+248+12>>2]=v;x=(c[f+16>>2]&4|0)==0?Q+248|0:Q+320|0;if((Ub[c[(c[x>>2]|0)+8>>2]&3](x,b,d,w,w,Q+712|0)|0?(h=Q+712+132|0,r=+g[h>>2],q=+g[Q+712+136>>2],p=+g[Q+712+140>>2],r*r+q*q+p*p>9.999999747378752e-05):0)?(o=+g[Q+712+164>>2],o<+g[f+4>>2]):0){C=1.0/+O(+(r*r+q*q+p*p));g[h>>2]=r*C;g[Q+712+136>>2]=q*C;g[Q+712+140>>2]=p*C;c[Q+216>>2]=c[e+8>>2];c[Q+216+4>>2]=0;c[Q+216+8>>2]=c[h>>2];c[Q+216+8+4>>2]=c[h+4>>2];c[Q+216+8+8>>2]=c[h+8>>2];c[Q+216+8+12>>2]=c[h+12>>2];g[Q+216+24>>2]=o;+$b[c[(c[f>>2]|0)+12>>2]&15](f,Q+216|0,1)}i=Q;return}if((j+-21|0)>>>0<9){G=+g[w>>2];F=+g[w+16>>2];n=+g[w+32>>2];E=+g[w+4>>2];D=+g[w+20>>2];l=+g[w+36>>2];B=+g[w+8>>2];C=+g[w+24>>2];m=+g[w+40>>2];y=-+g[w+48>>2];z=-+g[w+52>>2];A=-+g[w+56>>2];q=+g[b+48>>2];r=+g[b+52>>2];k=+g[b+56>>2];g[Q+80>>2]=G*y+F*z+n*A+(G*q+F*r+n*k);g[Q+80+4>>2]=E*y+D*z+l*A+(E*q+D*r+l*k);g[Q+80+8>>2]=B*y+C*z+m*A+(B*q+C*r+m*k);g[Q+80+12>>2]=0.0;t=+g[d+48>>2];u=+g[d+52>>2];s=+g[d+56>>2];n=G*y+F*z+n*A+(G*t+F*u+n*s);l=E*y+D*z+l*A+(E*t+D*u+l*s);m=B*y+C*z+m*A+(B*t+C*u+m*s);g[Q+64>>2]=n;g[Q+64+4>>2]=l;g[Q+64+8>>2]=m;g[Q+64+12>>2]=0.0;switch(c[v+4>>2]|0){case 21:{j=c[e+8>>2]|0;x=c[f+16>>2]|0;c[Q+96+4>>2]=c[Q+80>>2];c[Q+96+4+4>>2]=c[Q+80+4>>2];c[Q+96+4+8>>2]=c[Q+80+8>>2];c[Q+96+4+12>>2]=c[Q+80+12>>2];c[Q+96+20>>2]=c[Q+64>>2];c[Q+96+20+4>>2]=c[Q+64+4>>2];c[Q+96+20+8>>2]=c[Q+64+8>>2];c[Q+96+20+12>>2]=c[Q+64+12>>2];c[Q+96+36>>2]=x;g[Q+96+40>>2]=1.0;c[Q+96>>2]=5944;c[Q+96+44>>2]=f;c[Q+96+48>>2]=j;c[Q+96+52>>2]=v;c[Q+96+56>>2]=c[w>>2];c[Q+96+56+4>>2]=c[w+4>>2];c[Q+96+56+8>>2]=c[w+8>>2];c[Q+96+56+12>>2]=c[w+12>>2];c[Q+96+72>>2]=c[w+16>>2];c[Q+96+72+4>>2]=c[w+16+4>>2];c[Q+96+72+8>>2]=c[w+16+8>>2];c[Q+96+72+12>>2]=c[w+16+12>>2];c[Q+96+88>>2]=c[w+32>>2];c[Q+96+88+4>>2]=c[w+32+4>>2];c[Q+96+88+8>>2]=c[w+32+8>>2];c[Q+96+88+12>>2]=c[w+32+12>>2];c[Q+96+104>>2]=c[w+48>>2];c[Q+96+104+4>>2]=c[w+48+4>>2];c[Q+96+104+8>>2]=c[w+48+8>>2];c[Q+96+104+12>>2]=c[w+48+12>>2];c[Q+96+40>>2]=c[f+4>>2];j=c[v+48>>2]|0;c[Q+336>>2]=7096;c[Q+336+4>>2]=j;c[Q+336+8>>2]=Q+96;j=c[v+52>>2]|0;c[Q+712>>2]=0;c[Q+712+4>>2]=0;c[Q+712+8>>2]=0;c[Q+712+12>>2]=0;c[Q+352>>2]=0;c[Q+352+4>>2]=0;c[Q+352+8>>2]=0;c[Q+352+12>>2]=0;if(!(a[j+60>>0]|0))CC(j,Q+336|0,Q+80|0,n,l,m,Q+712|0,Q+352|0);else DC(j,Q+336|0,Q+80|0,n,l,m,Q+712|0,Q+352|0,c[j+56>>2]|0);i=Q;return}case 25:{x=c[e+8>>2]|0;d=c[f+16>>2]|0;c[Q+712+4>>2]=c[Q+80>>2];c[Q+712+4+4>>2]=c[Q+80+4>>2];c[Q+712+4+8>>2]=c[Q+80+8>>2];c[Q+712+4+12>>2]=c[Q+80+12>>2];c[Q+712+20>>2]=c[Q+64>>2];c[Q+712+20+4>>2]=c[Q+64+4>>2];c[Q+712+20+8>>2]=c[Q+64+8>>2];c[Q+712+20+12>>2]=c[Q+64+12>>2];c[Q+712+36>>2]=d;g[Q+712+40>>2]=1.0;c[Q+712>>2]=5944;c[Q+712+44>>2]=f;c[Q+712+48>>2]=x;c[Q+712+52>>2]=v;c[Q+712+56>>2]=c[w>>2];c[Q+712+56+4>>2]=c[w+4>>2];c[Q+712+56+8>>2]=c[w+8>>2];c[Q+712+56+12>>2]=c[w+12>>2];c[Q+712+72>>2]=c[w+16>>2];c[Q+712+72+4>>2]=c[w+16+4>>2];c[Q+712+72+8>>2]=c[w+16+8>>2];c[Q+712+72+12>>2]=c[w+16+12>>2];c[Q+712+88>>2]=c[w+32>>2];c[Q+712+88+4>>2]=c[w+32+4>>2];c[Q+712+88+8>>2]=c[w+32+8>>2];c[Q+712+88+12>>2]=c[w+32+12>>2];c[Q+712+104>>2]=c[w+48>>2];c[Q+712+104+4>>2]=c[w+48+4>>2];c[Q+712+104+8>>2]=c[w+48+8>>2];c[Q+712+104+12>>2]=c[w+48+12>>2];c[Q+712+40>>2]=c[f+4>>2];nc[c[(c[v>>2]|0)+144>>2]&127](v,Q+712|0,Q+80|0,Q+64|0);i=Q;return}default:{H=+g[w>>2];G=+g[w+16>>2];l=+g[w+32>>2];F=+g[w+4>>2];E=+g[w+20>>2];n=+g[w+36>>2];A=+g[w+8>>2];B=+g[w+24>>2];C=+g[w+40>>2];D=-+g[w+48>>2];y=-+g[w+52>>2];z=-+g[w+56>>2];o=H*D+G*y+l*z+(H*q+G*r+l*k);p=F*D+E*y+n*z+(F*q+E*r+n*k);m=A*D+B*y+C*z+(A*q+B*r+C*k);l=H*D+G*y+l*z+(H*t+G*u+l*s);n=F*D+E*y+n*z+(F*t+E*u+n*s);k=A*D+B*y+C*z+(A*t+B*u+C*s);x=c[e+8>>2]|0;d=c[f+16>>2]|0;g[Q+712+4>>2]=o;g[Q+712+8>>2]=p;g[Q+712+12>>2]=m;g[Q+712+16>>2]=0.0;g[Q+712+20>>2]=l;g[Q+712+24>>2]=n;g[Q+712+28>>2]=k;g[Q+712+32>>2]=0.0;c[Q+712+36>>2]=d;g[Q+712+40>>2]=1.0;c[Q+712>>2]=5968;c[Q+712+44>>2]=f;c[Q+712+48>>2]=x;c[Q+712+52>>2]=v;c[Q+712+56>>2]=c[w>>2];c[Q+712+56+4>>2]=c[w+4>>2];c[Q+712+56+8>>2]=c[w+8>>2];c[Q+712+56+12>>2]=c[w+12>>2];c[Q+712+72>>2]=c[w+16>>2];c[Q+712+72+4>>2]=c[w+16+4>>2];c[Q+712+72+8>>2]=c[w+16+8>>2];c[Q+712+72+12>>2]=c[w+16+12>>2];c[Q+712+88>>2]=c[w+32>>2];c[Q+712+88+4>>2]=c[w+32+4>>2];c[Q+712+88+8>>2]=c[w+32+8>>2];c[Q+712+88+12>>2]=c[w+32+12>>2];c[Q+712+104>>2]=c[w+48>>2];c[Q+712+104+4>>2]=c[w+48+4>>2];c[Q+712+104+8>>2]=c[w+48+8>>2];c[Q+712+104+12>>2]=c[w+48+12>>2];c[Q+712+40>>2]=c[f+4>>2];g[Q+48>>2]=o;g[Q+48+4>>2]=p;g[Q+48+8>>2]=m;g[Q+48+12>>2]=0.0;if(l<o)g[Q+48>>2]=l;if(n<p)g[Q+48+4>>2]=n;if(k<m)g[Q+48+8>>2]=k;g[Q+32>>2]=o;g[Q+32+4>>2]=p;g[Q+32+8>>2]=m;g[Q+32+12>>2]=0.0;if(o<l)g[Q+32>>2]=l;if(p<n)g[Q+32+4>>2]=n;if(m<k)g[Q+32+8>>2]=k;nc[c[(c[v>>2]|0)+64>>2]&127](v,Q+712|0,Q+48|0,Q+32|0);i=Q;return}}}if((j|0)!=31){i=Q;return}j=c[v+64>>2]|0;x=c[e+8>>2]|0;c[Q>>2]=5992;c[Q+4>>2]=x;c[Q+8>>2]=v;c[Q+12>>2]=w;c[Q+16>>2]=b;c[Q+20>>2]=d;c[Q+24>>2]=f;if(!j){h=c[v+16>>2]|0;if((h|0)>0)j=0;else{i=Q;return}do{mv(Q,j);j=j+1|0}while((j|0)<(h|0));i=Q;return}k=+g[w+48>>2];I=+g[b+48>>2]-k;l=+g[w+52>>2];J=+g[b+52>>2]-l;u=+g[w+56>>2];H=+g[b+56>>2]-u;z=+g[w>>2];A=+g[w+16>>2];B=+g[w+32>>2];C=+g[w+4>>2];D=+g[w+20>>2];E=+g[w+36>>2];F=+g[w+8>>2];G=+g[w+24>>2];y=+g[w+40>>2];k=+g[d+48>>2]-k;l=+g[d+52>>2]-l;u=+g[d+56>>2]-u;j=c[j>>2]|0;if(j){s=k*z+l*A+u*B-(I*z+J*A+H*B);t=k*C+l*D+u*E-(I*C+J*D+H*E);r=k*F+l*G+u*y-(I*F+J*G+H*y);q=1.0/+O(+(s*s+t*t+r*r));n=s*q==0.0?999999984306749440.0:1.0/(s*q);o=t*q==0.0?999999984306749440.0:1.0/(t*q);p=r*q==0.0?999999984306749440.0:1.0/(r*q);c[2703]=(c[2703]|0)+1;b=XE(531)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}qF(b|0,0,512)|0;c[b>>2]=j;j=128;v=1;e=128;f=126;do{x=v+-1|0;w=c[b+(x<<2)>>2]|0;c[Q+712>>2]=c[w>>2];c[Q+712+4>>2]=c[w+4>>2];c[Q+712+8>>2]=c[w+8>>2];c[Q+712+12>>2]=c[w+12>>2];c[Q+712+16>>2]=c[w+16>>2];c[Q+712+16+4>>2]=c[w+16+4>>2];c[Q+712+16+8>>2]=c[w+16+8>>2];c[Q+712+16+12>>2]=c[w+16+12>>2];u=n*(+g[Q+712+((n<0.0&1)<<4)>>2]-(I*z+J*A+H*B));k=n*(+g[Q+712+((n<0.0^1)<<4)>>2]-(I*z+J*A+H*B));l=o*(+g[Q+712+((o<0.0&1)<<4)+4>>2]-(I*C+J*D+H*E));m=o*(+g[Q+712+((o<0.0^1)<<4)+4>>2]-(I*C+J*D+H*E));do if((!(l>k|u>m)?(K=l>u?l:u,N=m<k?m:k,L=p*(+g[Q+712+((p<0.0&1)<<4)+8>>2]-(I*F+J*G+H*y)),M=p*(+g[Q+712+((p<0.0^1)<<4)+8>>2]-(I*F+J*G+H*y)),!(L>N|K>M)):0)?((M<N?M:N)>0.0?(L>K?L:K)<s*q*s+t*q*t+r*q*r:0):0){if(!(c[w+40>>2]|0)){Fb[c[(c[Q>>2]|0)+12>>2]&127](Q,w);v=x;break}if((x|0)>(f|0)){d=e<<1;if((e|0)<(d|0)){do if((j|0)<(d|0)){do if(!e){h=0;P=45}else{c[2703]=(c[2703]|0)+1;j=XE((e<<3|3)+16|0)|0;if(!j)h=0;else{c[(j+4+15&-16)+-4>>2]=j;h=j+4+15&-16}if((e|0)>0)j=0;else{P=45;break}do{c[h+(j<<2)>>2]=c[b+(j<<2)>>2];j=j+1|0}while((j|0)!=(e|0))}while(0);if((P|0)==45){P=0;if(!b){j=d;b=h;break}}c[2704]=(c[2704]|0)+1;YE(c[b+-4>>2]|0);j=d;b=h}while(0);qF(b+(e<<2)|0,0,e<<2|0)|0}e=d;f=d+-2|0}c[b+(x<<2)>>2]=c[w+36>>2];c[b+(v<<2)>>2]=c[w+40>>2];v=v+1|0}else v=x;while(0)}while((v|0)!=0);if(b){c[2704]=(c[2704]|0)+1;YE(c[b+-4>>2]|0)}}i=Q;return}
function vD(a,b,c,d,e,f,h,i,j,k){a=+a;b=+b;c=+c;d=+d;e=+e;f=+f;h=+h;i=+i;j=+j;k=k|0;if(!(((h-d)*b-(i-e)*a)*f+(((i-e)*c-(j-f)*b)*d+((j-f)*a-(h-d)*c)*e)<0.0)){k=0;return k|0}if((h-d)*d+(i-e)*e+(j-f)*f>0.0){g[k>>2]=+O(+(d*d+e*e+f*f));k=1;return k|0}if((h-d)*h+(i-e)*i+(j-f)*j<0.0){g[k>>2]=+O(+(h*h+i*i+j*j));k=1;return k|0}else{d=((h*h+i*i+j*j)*(d*d+e*e+f*f)-(h*d+i*e+j*f)*(h*d+i*e+j*f))/((h-d)*(h-d)+(i-e)*(i-e)+(j-f)*(j-f));g[k>>2]=+O(+(d>0.0?d:0.0));k=1;return k|0}return 0}function wD(b,e,f,h,i,j){b=b|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;var k=0,l=0;if((d[h+55>>0]|0|0)==(e|0)){k=0;return k|0}k=c[10520+(i<<2)>>2]|0;if(+g[h>>2]*+g[f+16>>2]+ +g[h+4>>2]*+g[f+20>>2]+ +g[h+8>>2]*+g[f+24>>2]-+g[h+16>>2]<-9.999999747378752e-06){l=uD(b,c[h+20+(k<<2)>>2]|0,c[h+20+(i<<2)>>2]|0,f,0)|0;if(!l){k=0;return k|0}a[l+52>>0]=i;c[l+32>>2]=h;a[h+52+i>>0]=0;c[h+32+(i<<2)>>2]=l;k=c[j>>2]|0;if(!k)c[j+4>>2]=l;else{a[k+53>>0]=2;c[k+36>>2]=l;a[l+54>>0]=1;c[l+40>>2]=k}c[j>>2]=l;c[j+8>>2]=(c[j+8>>2]|0)+1;k=1;return k|0}l=c[10532+(i<<2)>>2]|0;a[h+55>>0]=e;if(!(wD(b,e,f,c[h+32+(k<<2)>>2]|0,d[h+52+k>>0]|0,j)|0)){k=0;return k|0}if(!(wD(b,e,f,c[h+32+(l<<2)>>2]|0,d[h+52+l>>0]|0,j)|0)){k=0;return k|0}k=c[h+48>>2]|0;if(k)c[k+44>>2]=c[h+44>>2];k=c[h+44>>2]|0;if(k)c[k+48>>2]=c[h+48>>2];if((c[b+9280>>2]|0)==(h|0))c[b+9280>>2]=c[h+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+-1;c[h+44>>2]=0;c[h+48>>2]=c[b+9288>>2];k=c[b+9288>>2]|0;if(k)c[k+44>>2]=h;c[b+9288>>2]=h;c[b+9292>>2]=(c[b+9292>>2]|0)+1;k=1;return k|0}function xD(b,d){b=b|0;d=d|0;var e=0,f=0;e=c[b>>2]|0;do if((e|0)>3)if(!(a[d>>0]&8)){c[b>>2]=e+-1;f=b+4+(e+-1<<4)|0;c[b+52>>2]=c[f>>2];c[b+52+4>>2]=c[f+4>>2];c[b+52+8>>2]=c[f+8>>2];c[b+52+12>>2]=c[f+12>>2];f=b+84+(e+-1<<4)|0;c[b+132>>2]=c[f>>2];c[b+132+4>>2]=c[f+4>>2];c[b+132+8>>2]=c[f+8>>2];c[b+132+12>>2]=c[f+12>>2];f=b+164+(e+-1<<4)|0;c[b+212>>2]=c[f>>2];c[b+212+4>>2]=c[f+4>>2];c[b+212+8>>2]=c[f+8>>2];c[b+212+12>>2]=c[f+12>>2];e=e+-1|0;f=6}else f=6;else{if((e|0)>2){e=3;f=6;break}if((e|0)>1){e=2;f=10;break}if((e|0)>0){e=1;break}else return}while(0);if((f|0)==6)if(!(a[d>>0]&4)){e=e+-1|0;c[b>>2]=e;c[b+36>>2]=c[b+4+(e<<4)>>2];c[b+36+4>>2]=c[b+4+(e<<4)+4>>2];c[b+36+8>>2]=c[b+4+(e<<4)+8>>2];c[b+36+12>>2]=c[b+4+(e<<4)+12>>2];c[b+116>>2]=c[b+84+(e<<4)>>2];c[b+116+4>>2]=c[b+84+(e<<4)+4>>2];c[b+116+8>>2]=c[b+84+(e<<4)+8>>2];c[b+116+12>>2]=c[b+84+(e<<4)+12>>2];c[b+196>>2]=c[b+164+(e<<4)>>2];c[b+196+4>>2]=c[b+164+(e<<4)+4>>2];c[b+196+8>>2]=c[b+164+(e<<4)+8>>2];c[b+196+12>>2]=c[b+164+(e<<4)+12>>2];f=10}else f=10;if((f|0)==10)if(!(a[d>>0]&2)){e=e+-1|0;c[b>>2]=e;c[b+20>>2]=c[b+4+(e<<4)>>2];c[b+20+4>>2]=c[b+4+(e<<4)+4>>2];c[b+20+8>>2]=c[b+4+(e<<4)+8>>2];c[b+20+12>>2]=c[b+4+(e<<4)+12>>2];c[b+100>>2]=c[b+84+(e<<4)>>2];c[b+100+4>>2]=c[b+84+(e<<4)+4>>2];c[b+100+8>>2]=c[b+84+(e<<4)+8>>2];c[b+100+12>>2]=c[b+84+(e<<4)+12>>2];c[b+180>>2]=c[b+164+(e<<4)>>2];c[b+180+4>>2]=c[b+164+(e<<4)+4>>2];c[b+180+8>>2]=c[b+164+(e<<4)+8>>2];c[b+180+12>>2]=c[b+164+(e<<4)+12>>2]}if(a[d>>0]&1)return;e=e+-1|0;c[b>>2]=e;c[b+4>>2]=c[b+4+(e<<4)>>2];c[b+4+4>>2]=c[b+4+(e<<4)+4>>2];c[b+4+8>>2]=c[b+4+(e<<4)+8>>2];c[b+4+12>>2]=c[b+4+(e<<4)+12>>2];c[b+84>>2]=c[b+84+(e<<4)>>2];c[b+84+4>>2]=c[b+84+(e<<4)+4>>2];c[b+84+8>>2]=c[b+84+(e<<4)+8>>2];c[b+84+12>>2]=c[b+84+(e<<4)+12>>2];c[b+164>>2]=c[b+164+(e<<4)>>2];c[b+164+4>>2]=c[b+164+(e<<4)+4>>2];c[b+164+8>>2]=c[b+164+(e<<4)+8>>2];c[b+164+12>>2]=c[b+164+(e<<4)+12>>2];return}function yD(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0.0,z=0.0,A=0.0,B=0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0;F=i;i=i+80|0;if(!(a[b+356>>0]|0)){d=a[b+312>>0]|0;d=d<<24>>24!=0;i=F;return d|0}c[b+336>>2]=0;c[b+336+4>>2]=0;c[b+336+8>>2]=0;c[b+336+12>>2]=0;a[b+336+16>>0]=0;m=a[b+332>>0]|0;a[b+332>>0]=m&-16;a[b+356>>0]=0;switch(c[b>>2]|0){case 0:{a[b+312>>0]=0;d=0;d=d<<24>>24!=0;i=F;return d|0}case 1:{c[b+244>>2]=c[b+84>>2];c[b+244+4>>2]=c[b+84+4>>2];c[b+244+8>>2]=c[b+84+8>>2];c[b+244+12>>2]=c[b+84+12>>2];c[b+260>>2]=c[b+164>>2];c[b+260+4>>2]=c[b+164+4>>2];c[b+260+8>>2]=c[b+164+8>>2];c[b+260+12>>2]=c[b+164+12>>2];o=+g[b+248>>2]-+g[b+264>>2];p=+g[b+252>>2]-+g[b+268>>2];g[b+276>>2]=+g[b+244>>2]-+g[b+260>>2];g[b+280>>2]=o;g[b+284>>2]=p;g[b+288>>2]=0.0;c[b+336>>2]=0;c[b+336+4>>2]=0;c[b+336+8>>2]=0;c[b+336+12>>2]=0;a[b+336+16>>0]=0;a[b+332>>0]=m&-16;g[b+336>>2]=1.0;g[b+340>>2]=0.0;g[b+344>>2]=0.0;g[b+348>>2]=0.0;a[b+312>>0]=1;d=1;d=d<<24>>24!=0;i=F;return d|0}case 2:{h=+g[b+4>>2];e=+g[b+8>>2];f=+g[b+12>>2];j=+g[b+20>>2]-h;l=+g[b+24>>2]-e;k=+g[b+28>>2]-f;do if((0.0-h)*j+(0.0-e)*l+(0.0-f)*k>0.0)if((0.0-h)*j+(0.0-e)*l+(0.0-f)*k<j*j+l*l+k*k){a[b+332>>0]=m&-16|3;e=((0.0-h)*j+(0.0-e)*l+(0.0-f)*k)/(j*j+l*l+k*k);break}else{a[b+332>>0]=m&-16|2;e=1.0;break}else{a[b+332>>0]=m&-16|1;e=0.0}while(0);g[b+336>>2]=1.0-e;g[b+340>>2]=e;g[b+344>>2]=0.0;g[b+348>>2]=0.0;j=+g[b+84>>2];l=+g[b+88>>2];o=+g[b+92>>2];j=j+e*(+g[b+100>>2]-j);l=l+e*(+g[b+104>>2]-l);o=o+e*(+g[b+108>>2]-o);g[b+244>>2]=j;g[b+248>>2]=l;g[b+252>>2]=o;g[b+256>>2]=0.0;k=+g[b+164>>2];n=+g[b+168>>2];p=+g[b+172>>2];k=k+e*(+g[b+180>>2]-k);n=n+e*(+g[b+184>>2]-n);p=p+e*(+g[b+188>>2]-p);g[b+260>>2]=k;g[b+264>>2]=n;g[b+268>>2]=p;g[b+272>>2]=0.0;g[b+276>>2]=j-k;g[b+280>>2]=l-n;g[b+284>>2]=o-p;g[b+288>>2]=0.0;xD(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)d=+g[b+348>>2]>=0.0&1;else d=0;a[b+312>>0]=d;d=d<<24>>24!=0;i=F;return d|0}case 3:{c[F+16>>2]=0;c[F+16+4>>2]=0;c[F+16+8>>2]=0;c[F+16+12>>2]=0;zD(F+16|0,b+4|0,b+20|0,b+36|0,b+316|0);f=+g[b+336>>2];h=+g[b+340>>2];p=+g[b+344>>2];j=+g[b+84>>2]*f+ +g[b+100>>2]*h+ +g[b+116>>2]*p;l=f*+g[b+88>>2]+h*+g[b+104>>2]+p*+g[b+120>>2];o=f*+g[b+92>>2]+h*+g[b+108>>2]+p*+g[b+124>>2];g[b+244>>2]=j;g[b+248>>2]=l;g[b+252>>2]=o;g[b+256>>2]=0.0;k=+g[b+164>>2]*f+ +g[b+180>>2]*h+ +g[b+196>>2]*p;n=f*+g[b+168>>2]+h*+g[b+184>>2]+p*+g[b+200>>2];p=f*+g[b+172>>2]+h*+g[b+188>>2]+p*+g[b+204>>2];g[b+260>>2]=k;g[b+264>>2]=n;g[b+268>>2]=p;g[b+272>>2]=0.0;g[b+276>>2]=j-k;g[b+280>>2]=l-n;g[b+284>>2]=o-p;g[b+288>>2]=0.0;xD(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)d=+g[b+348>>2]>=0.0&1;else d=0;a[b+312>>0]=d;d=d<<24>>24!=0;i=F;return d|0}case 4:{c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;c[F+12>>2]=0;B=F+32+16|0;a[B>>0]=0;c[b+316>>2]=c[F>>2];c[b+316+4>>2]=c[F+4>>2];c[b+316+8>>2]=c[F+8>>2];c[b+316+12>>2]=c[F+12>>2];a[b+332>>0]=m|15;H=+g[b+20>>2];Q=+g[b+4>>2];N=+g[b+24>>2];G=+g[b+8>>2];J=+g[b+28>>2];R=+g[b+12>>2];M=+g[b+36>>2];O=+g[b+40>>2];K=+g[b+44>>2];I=+g[b+52>>2];P=+g[b+56>>2];L=+g[b+60>>2];S=((N-G)*(K-R)-(J-R)*(O-G))*(I-Q)+((J-R)*(M-Q)-(H-Q)*(K-R))*(P-G)+((H-Q)*(O-G)-(N-G)*(M-Q))*(L-R);d=S*S<9.99999905104687e-09?-1:((0.0-Q)*((N-G)*(K-R)-(J-R)*(O-G))+(0.0-G)*((J-R)*(M-Q)-(H-Q)*(K-R))+((H-Q)*(O-G)-(N-G)*(M-Q))*(0.0-R))*S<0.0&1;S=(J-R)*((M-Q)*(P-G)-(O-G)*(I-Q))+((H-Q)*((O-G)*(L-R)-(K-R)*(P-G))+(N-G)*((K-R)*(I-Q)-(M-Q)*(L-R)));m=S*S<9.99999905104687e-09?-1:((0.0-R)*((M-Q)*(P-G)-(O-G)*(I-Q))+((0.0-Q)*((O-G)*(L-R)-(K-R)*(P-G))+(0.0-G)*((K-R)*(I-Q)-(M-Q)*(L-R))))*S<0.0&1;S=(K-R)*((N-G)*(I-Q)-(H-Q)*(P-G))+((M-Q)*((J-R)*(P-G)-(N-G)*(L-R))+(O-G)*((H-Q)*(L-R)-(J-R)*(I-Q)));q=S*S<9.99999905104687e-09?-1:((0.0-R)*((N-G)*(I-Q)-(H-Q)*(P-G))+((0.0-Q)*((J-R)*(P-G)-(N-G)*(L-R))+(0.0-G)*((H-Q)*(L-R)-(J-R)*(I-Q))))*S<0.0&1;G=(R-J)*((O-N)*(I-H)-(M-H)*(P-N))+((Q-H)*((K-J)*(P-N)-(O-N)*(L-J))+(G-N)*((M-H)*(L-J)-(K-J)*(I-H)));x=G*G<9.99999905104687e-09?-1:((0.0-J)*((O-N)*(I-H)-(M-H)*(P-N))+((0.0-H)*((K-J)*(P-N)-(O-N)*(L-J))+(0.0-N)*((M-H)*(L-J)-(K-J)*(I-H))))*G<0.0&1;do if((m|d|q|x|0)<0){a[b+352>>0]=1;d=b+312|0}else{if(!(m|d|q|x)){if(a[b+352>>0]|0){d=b+312|0;break}a[b+312>>0]=1;c[b+276>>2]=0;c[b+276+4>>2]=0;c[b+276+8>>2]=0;c[b+276+12>>2]=0;d=1;d=d<<24>>24!=0;i=F;return d|0}if((d|0)!=0?(zD(F,b+4|0,b+20|0,b+36|0,F+32|0),l=+g[F+32>>2],k=+g[F+32+4>>2],j=+g[F+32+8>>2],h=l-+g[F>>2],e=k-+g[F+4>>2],f=j-+g[F+8>>2],h*h+e*e+f*f<3402823466385288598117041.0e14):0){T=c[F+32+12>>2]|0;g[b+316>>2]=l;g[b+320>>2]=k;g[b+324>>2]=j;c[b+328>>2]=T;T=a[B>>0]|0;a[b+332>>0]=T&1|a[b+332>>0]&-16|T&2|T&4;T=c[F+32+24>>2]|0;d=c[F+32+28>>2]|0;c[b+336>>2]=c[F+32+20>>2];c[b+340>>2]=T;c[b+344>>2]=d;g[b+348>>2]=0.0;e=h*h+e*e+f*f}else e=3402823466385288598117041.0e14;if((m|0)!=0?(zD(F,b+4|0,b+36|0,b+52|0,F+32|0),n=+g[F+32>>2],o=+g[F+32+4>>2],p=+g[F+32+8>>2],r=n-+g[F>>2],t=o-+g[F+4>>2],s=p-+g[F+8>>2],r*r+t*t+s*s<e):0){m=c[F+32+12>>2]|0;g[b+316>>2]=n;g[b+320>>2]=o;g[b+324>>2]=p;c[b+328>>2]=m;m=a[B>>0]|0;a[b+332>>0]=m<<1&4|(m&1|a[b+332>>0]&-16)|m<<1&8;m=c[F+32+24>>2]|0;d=c[F+32+28>>2]|0;c[b+336>>2]=c[F+32+20>>2];g[b+340>>2]=0.0;c[b+344>>2]=m;c[b+348>>2]=d;e=r*r+t*t+s*s}if((q|0)!=0?(zD(F,b+4|0,b+52|0,b+20|0,F+32|0),u=+g[F+32>>2],v=+g[F+32+4>>2],w=+g[F+32+8>>2],y=u-+g[F>>2],A=v-+g[F+4>>2],z=w-+g[F+8>>2],y*y+A*A+z*z<e):0){q=c[F+32+12>>2]|0;g[b+316>>2]=u;g[b+320>>2]=v;g[b+324>>2]=w;c[b+328>>2]=q;q=a[B>>0]|0;a[b+332>>0]=(q&255)>>>1&2|(q&1|a[b+332>>0]&-16)|q<<2&8;q=c[F+32+28>>2]|0;d=c[F+32+24>>2]|0;c[b+336>>2]=c[F+32+20>>2];c[b+340>>2]=q;g[b+344>>2]=0.0;c[b+348>>2]=d;e=y*y+A*A+z*z}if((x|0)!=0?(zD(F,b+20|0,b+52|0,b+36|0,F+32|0),C=+g[F+32>>2],D=+g[F+32+4>>2],E=+g[F+32+8>>2],y=C-+g[F>>2],z=D-+g[F+4>>2],A=E-+g[F+8>>2],y*y+z*z+A*A<e):0){q=c[F+32+12>>2]|0;g[b+316>>2]=C;g[b+320>>2]=D;g[b+324>>2]=E;c[b+328>>2]=q;B=a[B>>0]|0;a[b+332>>0]=B<<1&2|a[b+332>>0]&-16|B&4|B<<2&8;B=c[F+32+20>>2]|0;q=c[F+32+28>>2]|0;d=c[F+32+24>>2]|0;g[b+336>>2]=0.0;c[b+340>>2]=B;c[b+344>>2]=q;c[b+348>>2]=d}s=+g[b+336>>2];t=+g[b+340>>2];u=+g[b+344>>2];C=+g[b+348>>2];v=+g[b+84>>2]*s+ +g[b+100>>2]*t+ +g[b+116>>2]*u+ +g[b+132>>2]*C;y=s*+g[b+88>>2]+t*+g[b+104>>2]+u*+g[b+120>>2]+C*+g[b+136>>2];A=s*+g[b+92>>2]+t*+g[b+108>>2]+u*+g[b+124>>2]+C*+g[b+140>>2];g[b+244>>2]=v;g[b+248>>2]=y;g[b+252>>2]=A;g[b+256>>2]=0.0;w=+g[b+164>>2]*s+ +g[b+180>>2]*t+ +g[b+196>>2]*u+ +g[b+212>>2]*C;z=s*+g[b+168>>2]+t*+g[b+184>>2]+u*+g[b+200>>2]+C*+g[b+216>>2];C=s*+g[b+172>>2]+t*+g[b+188>>2]+u*+g[b+204>>2]+C*+g[b+220>>2];g[b+260>>2]=w;g[b+264>>2]=z;g[b+268>>2]=C;g[b+272>>2]=0.0;g[b+276>>2]=v-w;g[b+280>>2]=y-z;g[b+284>>2]=A-C;g[b+288>>2]=0.0;xD(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)d=+g[b+348>>2]>=0.0&1;else d=0;a[b+312>>0]=d;d=d<<24>>24!=0;i=F;return d|0}while(0);a[d>>0]=0;d=0;d=d<<24>>24!=0;i=F;return d|0}default:{a[b+312>>0]=0;d=0;d=d<<24>>24!=0;i=F;return d|0}}return 0}function zD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0;z=a[h+16>>0]&-16;a[h+16>>0]=z;q=+g[e>>2];r=+g[d>>2];s=+g[e+4>>2];t=+g[d+4>>2];u=+g[e+8>>2];v=+g[d+8>>2];w=+g[f>>2];x=+g[f+4>>2];y=+g[f+8>>2];m=+g[b>>2];n=+g[b+4>>2];i=+g[b+8>>2];p=(q-r)*(m-r)+(s-t)*(n-t)+(u-v)*(i-v);o=(w-r)*(m-r)+(x-t)*(n-t)+(y-v)*(i-v);if(p<=0.0&o<=0.0){c[h>>2]=c[d>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];a[h+16>>0]=z|1;g[h+20>>2]=1.0;g[h+24>>2]=0.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}l=(q-r)*(m-q)+(s-t)*(n-s)+(u-v)*(i-u);k=(w-r)*(m-q)+(x-t)*(n-s)+(y-v)*(i-u);if(!(!(l>=0.0)|!(k<=l))){c[h>>2]=c[e>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];a[h+16>>0]=z|2;g[h+20>>2]=0.0;g[h+24>>2]=1.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}if(l<=0.0&(p>=0.0?p*k-l*o<=0.0:0)){g[h>>2]=r+(q-r)*(p/(p-l));g[h+4>>2]=t+(s-t)*(p/(p-l));g[h+8>>2]=v+(u-v)*(p/(p-l));g[h+12>>2]=0.0;a[h+16>>0]=z|3;g[h+20>>2]=1.0-p/(p-l);g[h+24>>2]=p/(p-l);g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}j=(q-r)*(m-w)+(s-t)*(n-x)+(u-v)*(i-y);i=(w-r)*(m-w)+(x-t)*(n-x)+(y-v)*(i-y);if(!(!(i>=0.0)|!(j<=i))){c[h>>2]=c[f>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];a[h+16>>0]=z|4;g[h+20>>2]=0.0;g[h+24>>2]=0.0;g[h+28>>2]=1.0;g[h+32>>2]=0.0;return}if(i<=0.0&(o>=0.0?j*o-p*i<=0.0:0)){g[h>>2]=r+(w-r)*(o/(o-i));g[h+4>>2]=t+(x-t)*(o/(o-i));g[h+8>>2]=v+(y-v)*(o/(o-i));g[h+12>>2]=0.0;a[h+16>>0]=z|5;g[h+20>>2]=1.0-o/(o-i);g[h+24>>2]=0.0;g[h+28>>2]=o/(o-i);g[h+32>>2]=0.0;return}if((l*i-j*k<=0.0?k-l>=0.0:0)?j-i>=0.0:0){p=(k-l)/(k-l+(j-i));g[h>>2]=q+(w-q)*p;g[h+4>>2]=s+(x-s)*p;g[h+8>>2]=u+(y-u)*p;g[h+12>>2]=0.0;a[h+16>>0]=z|6;g[h+20>>2]=0.0;g[h+24>>2]=1.0-p;g[h+28>>2]=p;g[h+32>>2]=0.0;return}m=1.0/(p*k-l*o+(l*i-j*k+(j*o-p*i)));n=(j*o-p*i)*m;p=(p*k-l*o)*m;g[h>>2]=(w-r)*p+(r+(q-r)*n);g[h+4>>2]=(x-t)*p+(t+(s-t)*n);g[h+8>>2]=(y-v)*p+((u-v)*n+v);g[h+12>>2]=0.0;a[h+16>>0]=z|7;g[h+20>>2]=1.0-n-p;g[h+24>>2]=n;g[h+28>>2]=p;g[h+32>>2]=0.0;return}function AD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return}function BD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function CD(a){a=a|0;YE(a);return}function DD(a,b){a=a|0;b=b|0;return}function ED(b){b=b|0;var d=0;c[b>>2]=10580;if(!(a[b+8>>0]|0))return;d=c[b+12>>2]|0;if(!d)return;b=c[b+4>>2]|0;Fb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function FD(b){b=b|0;var d=0,e=0;c[b>>2]=10580;if(!(a[b+8>>0]|0)){YE(b);return}d=c[b+12>>2]|0;if(!d){YE(b);return}e=c[b+4>>2]|0;Fb[c[(c[e>>2]|0)+16>>2]&127](e,d);YE(b);return}function GD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0;q=i;i=i+32|0;p=c[a+12>>2]|0;if(!p){i=q;return}c[f+4>>2]=p;e=c[b+4>>2]|0;r=c[d+4>>2]|0;b=c[b+12>>2]|0;a=c[d+12>>2]|0;j=+g[b+48>>2]-+g[a+48>>2];h=+g[b+52>>2]-+g[a+52>>2];l=+g[b+56>>2]-+g[a+56>>2];n=+O(+(j*j+h*h+l*l));o=+g[r+28>>2]*+g[r+12>>2];m=+g[e+28>>2]*+g[e+12>>2]+o;if(n>m){if(!(c[p+748>>2]|0)){i=q;return}d=c[p+740>>2]|0;b=c[(c[f+8>>2]|0)+8>>2]|0;e=c[(c[f+12>>2]|0)+8>>2]|0;if((d|0)==(b|0)){Ns(p,d+4|0,e+4|0);i=q;return}else{Ns(p,e+4|0,b+4|0);i=q;return}}c[q+16>>2]=1065353216;c[q+16+4>>2]=0;c[q+16+8>>2]=0;g[q+16+12>>2]=0.0;if(n>1.1920928955078125e-07){g[q+16>>2]=j*(1.0/n);g[q+16+4>>2]=h*(1.0/n);g[q+16+8>>2]=l*(1.0/n);g[q+16+12>>2]=0.0;k=j*(1.0/n);j=h*(1.0/n);h=l*(1.0/n)}else{k=1.0;j=0.0;h=0.0}j=o*j+ +g[a+52>>2];h=o*h+ +g[a+56>>2];g[q>>2]=o*k+ +g[a+48>>2];g[q+4>>2]=j;g[q+8>>2]=h;g[q+12>>2]=0.0;ic[c[(c[f>>2]|0)+16>>2]&15](f,q+16|0,q,n-m);b=c[f+4>>2]|0;if(!(c[b+748>>2]|0)){i=q;return}d=c[b+740>>2]|0;a=c[(c[f+8>>2]|0)+8>>2]|0;e=c[(c[f+12>>2]|0)+8>>2]|0;if((d|0)==(a|0)){Ns(b,d+4|0,e+4|0);i=q;return}else{Ns(b,e+4|0,a+4|0);i=q;return}}function HD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function ID(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+12>>2]|0;if(!e)return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=(f|0)!=0?f<<1:1,(f|0)<(h|0)):0){if(!h){e=f;f=0}else{c[2703]=(c[2703]|0)+1;e=XE((h<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+4+15&-16)+-4>>2]=e;f=e+4+15&-16}e=c[d+4>>2]|0}if((e|0)>0){g=0;do{c[f+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0);e=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=f;c[d+8>>2]=h;f=e;e=c[b+12>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function JD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,P=0,Q=0,R=0,S=0.0,T=0.0,U=0.0,V=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0,ha=0,ia=0,ja=0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0,qa=0.0,ra=0.0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0,xa=0.0,ya=0.0,za=0.0,Aa=0,Ba=0,Ca=0,Da=0.0,Ea=0.0,Fa=0.0,Ga=0;Ga=i;i=i+656|0;c[Ga+48>>2]=c[b>>2];c[Ga>>2]=c[b+64>>2];ja=Ga+48+4|0;c[ja>>2]=c[b+4>>2];c[Ga+4>>2]=c[b+68>>2];c[Ga+48+8>>2]=c[b+8>>2];c[Ga+8>>2]=c[b+72>>2];c[Ga+48+16>>2]=c[b+16>>2];c[Ga+16>>2]=c[b+80>>2];c[Ga+48+20>>2]=c[b+20>>2];c[Ga+20>>2]=c[b+84>>2];c[Ga+48+24>>2]=c[b+24>>2];c[Ga+24>>2]=c[b+88>>2];c[Ga+48+32>>2]=c[b+32>>2];c[Ga+32>>2]=c[b+96>>2];c[Ga+48+36>>2]=c[b+36>>2];c[Ga+36>>2]=c[b+100>>2];c[Ga+48+40>>2]=c[b+40>>2];c[Ga+40>>2]=c[b+104>>2];R=c[a+4>>2]|0;na=+g[R+28>>2];oa=+g[R+32>>2];ma=+g[R+36>>2];ka=+Tb[c[(c[R>>2]|0)+48>>2]&15](R);la=+Tb[c[(c[R>>2]|0)+48>>2]&15](R);ma=(ma+ +Tb[c[(c[R>>2]|0)+48>>2]&15](R))*2.0;R=c[a+8>>2]|0;ta=+g[R+28>>2];ua=+g[R+32>>2];xa=+g[R+36>>2];ra=+Tb[c[(c[R>>2]|0)+48>>2]&15](R);sa=+Tb[c[(c[R>>2]|0)+48>>2]&15](R);xa=(xa+ +Tb[c[(c[R>>2]|0)+48>>2]&15](R))*2.0;o=+g[b+112>>2]-+g[b+48>>2];u=+g[b+116>>2]-+g[b+52>>2];m=+g[b+120>>2]-+g[b+56>>2];V=+g[Ga+48>>2];h=+g[Ga+48+16>>2];U=+g[Ga+48+32>>2];fa=+g[ja>>2];T=+g[Ga+48+20>>2];ea=+g[Ga+48+36>>2];Da=+g[Ga+48+8>>2];q=+g[Ga+48+24>>2];s=+g[Ga+48+40>>2];g[Ga+548>>2]=(na+ka)*2.0*.5;g[Ga+548+4>>2]=(oa+la)*2.0*.5;g[Ga+548+8>>2]=ma*.5;g[Ga+536>>2]=(ta+ra)*2.0*.5;g[Ga+536+4>>2]=(ua+sa)*2.0*.5;g[Ga+536+8>>2]=xa*.5;ya=+g[Ga>>2];pa=+g[Ga+16>>2];va=+g[Ga+32>>2];za=+g[Ga+4>>2];qa=+g[Ga+20>>2];wa=+g[Ga+36>>2];r=+g[Ga+8>>2];Ea=+g[Ga+24>>2];Fa=+g[Ga+40>>2];_=+N(+(V*ya+h*pa+U*va));Y=+N(+(V*za+h*qa+U*wa));S=+N(+(V*r+h*Ea+U*Fa));Z=+N(+(ya*fa+pa*T+va*ea));X=+N(+(za*fa+qa*T+wa*ea));j=+N(+(r*fa+Ea*T+Fa*ea));t=+N(+(ya*Da+pa*q+va*s));da=+N(+(za*Da+qa*q+wa*s));p=+N(+(r*Da+Ea*q+Fa*s));C=+N(+(o*V+u*h+m*U))-(xa*.5*S+((na+ka)*2.0*.5+_*((ta+ra)*2.0*.5)+Y*((ua+sa)*2.0*.5)));if(C>0.0){i=Ga;return}if(C>-3402823466385288598117041.0e14){f=1;l=o*V+u*h+m*U<0.0&1;n=Ga+48|0}else{f=0;l=0;n=0;C=-3402823466385288598117041.0e14}B=+N(+(o*fa+u*T+m*ea))-((oa+la)*2.0*.5+Z*((ta+ra)*2.0*.5)+X*((ua+sa)*2.0*.5)+j*(xa*.5));if(B>0.0){i=Ga;return}if(B>C){f=2;l=o*fa+u*T+m*ea<0.0&1;n=ja;C=B}B=+N(+(o*Da+u*q+m*s))-(ma*.5+t*((ta+ra)*2.0*.5)+da*((ua+sa)*2.0*.5)+p*(xa*.5));if(B>0.0){i=Ga;return}if(B>C){f=3;l=o*Da+u*q+m*s<0.0&1;n=Ga+48+8|0;C=B}z=+N(+(o*ya+u*pa+m*va))-((ta+ra)*2.0*.5+(_*((na+ka)*2.0*.5)+Z*((oa+la)*2.0*.5)+t*(ma*.5)));if(z>0.0){i=Ga;return}if(z>C){f=4;l=o*ya+u*pa+m*va<0.0&1;n=Ga}else z=C;C=+N(+(o*za+u*qa+m*wa))-((ua+sa)*2.0*.5+(Y*((na+ka)*2.0*.5)+X*((oa+la)*2.0*.5)+da*(ma*.5)));if(C>0.0){i=Ga;return}if(C>z){f=5;l=o*za+u*qa+m*wa<0.0&1;n=Ga+4|0;z=C}C=+N(+(o*r+u*Ea+m*Fa))-(xa*.5+(S*((na+ka)*2.0*.5)+j*((oa+la)*2.0*.5)+p*(ma*.5)));if(C>0.0){i=Ga;return}if(C>z){f=6;l=o*r+u*Ea+m*Fa<0.0&1;D=Ga+8|0;z=C}else D=n;E=(o*Da+u*q+m*s)*(ya*fa+pa*T+va*ea)-(o*fa+u*T+m*ea)*(ya*Da+pa*q+va*s);B=+N(+E)-((t+9.999999747378752e-06)*((oa+la)*2.0*.5)+(Z+9.999999747378752e-06)*(ma*.5)+(S+9.999999747378752e-06)*((ua+sa)*2.0*.5)+(Y+9.999999747378752e-06)*(xa*.5));if(B>1.1920928955078125e-07){i=Ga;return}A=(ya*Da+pa*q+va*s)*(ya*Da+pa*q+va*s)+0.0;$=(ya*fa+pa*T+va*ea)*(ya*fa+pa*T+va*ea);C=+O(+($+A));if(C>1.1920928955078125e-07?B/C*1.0499999523162842>z:0){a=(g[k>>2]=0.0/C,c[k>>2]|0);v=(g[k>>2]=-(ya*Da+pa*q+va*s)/C,c[k>>2]|0);n=(g[k>>2]=(ya*fa+pa*T+va*ea)/C,c[k>>2]|0);f=7;l=E<0.0&1;D=0;z=B/C}else{n=0;v=0;a=0}E=(o*Da+u*q+m*s)*(za*fa+qa*T+wa*ea)-(o*fa+u*T+m*ea)*(za*Da+qa*q+wa*s);B=+N(+E)-((da+9.999999747378752e-06)*((oa+la)*2.0*.5)+(X+9.999999747378752e-06)*(ma*.5)+(S+9.999999747378752e-06)*((ta+ra)*2.0*.5)+(_+9.999999747378752e-06)*(xa*.5));if(B>1.1920928955078125e-07){i=Ga;return}y=(za*Da+qa*q+wa*s)*(za*Da+qa*q+wa*s)+0.0;ca=(za*fa+qa*T+wa*ea)*(za*fa+qa*T+wa*ea);C=+O(+(ca+y));if(C>1.1920928955078125e-07?B/C*1.0499999523162842>z:0){a=(g[k>>2]=0.0/C,c[k>>2]|0);v=(g[k>>2]=-(za*Da+qa*q+wa*s)/C,c[k>>2]|0);n=(g[k>>2]=(za*fa+qa*T+wa*ea)/C,c[k>>2]|0);f=8;l=E<0.0&1;D=0;z=B/C}E=(o*Da+u*q+m*s)*(r*fa+Ea*T+Fa*ea)-(o*fa+u*T+m*ea)*(r*Da+Ea*q+Fa*s);B=+N(+E)-((p+9.999999747378752e-06)*((oa+la)*2.0*.5)+(j+9.999999747378752e-06)*(ma*.5)+(Y+9.999999747378752e-06)*((ta+ra)*2.0*.5)+(_+9.999999747378752e-06)*((ua+sa)*2.0*.5));if(B>1.1920928955078125e-07){i=Ga;return}x=(r*Da+Ea*q+Fa*s)*(r*Da+Ea*q+Fa*s)+0.0;ba=(r*fa+Ea*T+Fa*ea)*(r*fa+Ea*T+Fa*ea);C=+O(+(ba+x));if(C>1.1920928955078125e-07?B/C*1.0499999523162842>z:0){a=(g[k>>2]=0.0/C,c[k>>2]|0);v=(g[k>>2]=-(r*Da+Ea*q+Fa*s)/C,c[k>>2]|0);n=(g[k>>2]=(r*fa+Ea*T+Fa*ea)/C,c[k>>2]|0);f=9;l=E<0.0&1;D=0;z=B/C}E=(o*V+u*h+m*U)*(ya*Da+pa*q+va*s)-(o*Da+u*q+m*s)*(V*ya+h*pa+U*va);B=+N(+E)-((t+9.999999747378752e-06)*((na+ka)*2.0*.5)+(_+9.999999747378752e-06)*(ma*.5)+(j+9.999999747378752e-06)*((ua+sa)*2.0*.5)+(X+9.999999747378752e-06)*(xa*.5));if(B>1.1920928955078125e-07){i=Ga;return}w=(V*ya+h*pa+U*va)*(V*ya+h*pa+U*va);C=+O(+(w+A));do if(C>1.1920928955078125e-07){if(!(B/C*1.0499999523162842>z))break;a=(g[k>>2]=(ya*Da+pa*q+va*s)/C,c[k>>2]|0);v=(g[k>>2]=0.0/C,c[k>>2]|0);n=(g[k>>2]=-(V*ya+h*pa+U*va)/C,c[k>>2]|0);f=10;l=E<0.0&1;D=0;z=B/C}while(0);E=(o*V+u*h+m*U)*(za*Da+qa*q+wa*s)-(o*Da+u*q+m*s)*(V*za+h*qa+U*wa);B=+N(+E)-((da+9.999999747378752e-06)*((na+ka)*2.0*.5)+(Y+9.999999747378752e-06)*(ma*.5)+(j+9.999999747378752e-06)*((ta+ra)*2.0*.5)+(Z+9.999999747378752e-06)*(xa*.5));if(B>1.1920928955078125e-07){i=Ga;return}A=(V*za+h*qa+U*wa)*(V*za+h*qa+U*wa);C=+O(+(A+y));do if(C>1.1920928955078125e-07){if(!(B/C*1.0499999523162842>z))break;a=(g[k>>2]=(za*Da+qa*q+wa*s)/C,c[k>>2]|0);v=(g[k>>2]=0.0/C,c[k>>2]|0);n=(g[k>>2]=-(V*za+h*qa+U*wa)/C,c[k>>2]|0);f=11;l=E<0.0&1;D=0;z=B/C}while(0);E=(o*V+u*h+m*U)*(r*Da+Ea*q+Fa*s)-(o*Da+u*q+m*s)*(V*r+h*Ea+U*Fa);B=+N(+E)-((p+9.999999747378752e-06)*((na+ka)*2.0*.5)+(S+9.999999747378752e-06)*(ma*.5)+(X+9.999999747378752e-06)*((ta+ra)*2.0*.5)+(Z+9.999999747378752e-06)*((ua+sa)*2.0*.5));if(B>1.1920928955078125e-07){i=Ga;return}y=(V*r+h*Ea+U*Fa)*(V*r+h*Ea+U*Fa);C=+O(+(y+x));do if(C>1.1920928955078125e-07){if(!(B/C*1.0499999523162842>z))break;a=(g[k>>2]=(r*Da+Ea*q+Fa*s)/C,c[k>>2]|0);v=(g[k>>2]=0.0/C,c[k>>2]|0);n=(g[k>>2]=-(V*r+h*Ea+U*Fa)/C,c[k>>2]|0);f=12;l=E<0.0&1;D=0;z=B/C}while(0);C=(o*fa+u*T+m*ea)*(V*ya+h*pa+U*va)-(o*V+u*h+m*U)*(ya*fa+pa*T+va*ea);B=+N(+C)-((Z+9.999999747378752e-06)*((na+ka)*2.0*.5)+(_+9.999999747378752e-06)*((oa+la)*2.0*.5)+(p+9.999999747378752e-06)*((ua+sa)*2.0*.5)+(da+9.999999747378752e-06)*(xa*.5));if(B>1.1920928955078125e-07){i=Ga;return}E=+O(+(w+$+0.0));do if(E>1.1920928955078125e-07){if(!(B/E*1.0499999523162842>z))break;a=(g[k>>2]=-(ya*fa+pa*T+va*ea)/E,c[k>>2]|0);v=(g[k>>2]=(V*ya+h*pa+U*va)/E,c[k>>2]|0);n=(g[k>>2]=0.0/E,c[k>>2]|0);f=13;l=C<0.0&1;D=0;z=B/E}while(0);B=(o*fa+u*T+m*ea)*(V*za+h*qa+U*wa)-(o*V+u*h+m*U)*(za*fa+qa*T+wa*ea);E=+N(+B)-((X+9.999999747378752e-06)*((na+ka)*2.0*.5)+(Y+9.999999747378752e-06)*((oa+la)*2.0*.5)+(p+9.999999747378752e-06)*((ta+ra)*2.0*.5)+(t+9.999999747378752e-06)*(xa*.5));if(E>1.1920928955078125e-07){i=Ga;return}C=+O(+(A+ca+0.0));do if(C>1.1920928955078125e-07){if(!(E/C*1.0499999523162842>z))break;a=(g[k>>2]=-(za*fa+qa*T+wa*ea)/C,c[k>>2]|0);v=(g[k>>2]=(V*za+h*qa+U*wa)/C,c[k>>2]|0);n=(g[k>>2]=0.0/C,c[k>>2]|0);f=14;l=B<0.0&1;D=0;z=E/C}while(0);A=(o*fa+u*T+m*ea)*(V*r+h*Ea+U*Fa)-(o*V+u*h+m*U)*(r*fa+Ea*T+Fa*ea);C=+N(+A)-((j+9.999999747378752e-06)*((na+ka)*2.0*.5)+(S+9.999999747378752e-06)*((oa+la)*2.0*.5)+(da+9.999999747378752e-06)*((ta+ra)*2.0*.5)+(t+9.999999747378752e-06)*((ua+sa)*2.0*.5));if(C>1.1920928955078125e-07){i=Ga;return}B=+O(+(y+ba+0.0));do if(B>1.1920928955078125e-07){if(!(C/B*1.0499999523162842>z)){Ca=55;break}a=(g[k>>2]=-(r*fa+Ea*T+Fa*ea)/B,c[k>>2]|0);v=(g[k>>2]=(V*r+h*Ea+U*Fa)/B,c[k>>2]|0);n=(g[k>>2]=0.0/B,c[k>>2]|0);f=15;l=A<0.0&1;z=C/B;Ca=58}else Ca=55;while(0);do if((Ca|0)==55){if(!f){i=Ga;return}if(!D){Ca=58;break}n=c[D>>2]|0;v=c[D+16>>2]|0;a=c[D+32>>2]|0;y=(c[k>>2]=n,+g[k>>2]);x=(c[k>>2]=v,+g[k>>2]);w=(c[k>>2]=a,+g[k>>2]);E=z}while(0);if((Ca|0)==58){fa=(c[k>>2]=a,+g[k>>2]);w=(c[k>>2]=v,+g[k>>2]);E=(c[k>>2]=n,+g[k>>2]);y=fa*+g[Ga+48>>2]+w*+g[ja>>2]+E*Da;n=(g[k>>2]=y,c[k>>2]|0);x=fa*+g[Ga+48+16>>2]+w*+g[Ga+48+20>>2]+E*q;v=(g[k>>2]=x,c[k>>2]|0);E=fa*+g[Ga+48+32>>2]+w*+g[Ga+48+36>>2]+E*s;w=E;a=(g[k>>2]=E,c[k>>2]|0);E=z}if(!l){Aa=v;Ba=a}else{n=(g[k>>2]=-y,c[k>>2]|0);Aa=(g[k>>2]=-x,c[k>>2]|0);Ba=(g[k>>2]=-w,c[k>>2]|0)}if((f|0)>6){C=(c[k>>2]=n,+g[k>>2]);B=(c[k>>2]=Aa,+g[k>>2]);A=(c[k>>2]=Ba,+g[k>>2]);m=+g[Ga+48>>2];h=+g[Ga+48+16>>2];u=+g[Ga+48+32>>2];t=(C*m+B*h+A*u>0.0?1.0:-1.0)*((na+ka)*2.0*.5);z=+g[ja>>2];y=+g[Ga+48+20>>2];j=+g[Ga+48+36>>2];w=(C*z+B*y+A*j>0.0?1.0:-1.0)*((oa+la)*2.0*.5);x=(C*Da+B*q+A*s>0.0?1.0:-1.0)*(ma*.5);z=+g[b+48>>2]+t*m+w*z+x*Da;y=+g[b+52>>2]+t*h+w*y+x*q;x=+g[b+56>>2]+t*u+w*j+x*s;c[Ga+520>>2]=c[b+112>>2];c[Ga+520+4>>2]=c[b+112+4>>2];c[Ga+520+8>>2]=c[b+112+8>>2];j=(C*ya+B*pa+A*va>0.0?-1.0:1.0)*((ta+ra)*2.0*.5);s=(C*za+B*qa+A*wa>0.0?-1.0:1.0)*((ua+sa)*2.0*.5);w=+g[Ga+520+4>>2]+j*pa+s*qa;u=+g[Ga+520+8>>2]+j*va+s*wa;t=(C*r+B*Ea+A*Fa>0.0?-1.0:1.0)*(xa*.5);s=+g[Ga+520>>2]+j*ya+s*za+t*r;g[Ga+520>>2]=s;g[Ga+520+4>>2]=w+t*Ea;g[Ga+520+8>>2]=u+t*Fa;R=f+-7|0;j=+g[Ga+48+(((R|0)/3|0)<<2)>>2];h=+g[Ga+48+(((R|0)/3|0)+4<<2)>>2];m=+g[Ga+48+(((R|0)/3|0)+8<<2)>>2];p=+g[Ga+(((R|0)%3|0)<<2)>>2];q=+g[Ga+(((R|0)%3|0)+4<<2)>>2];r=+g[Ga+(((R|0)%3|0)+8<<2)>>2];o=1.0-(j*p+h*q+m*r)*(j*p+h*q+m*r);if(!(o<=9.999999747378752e-05))j=(((s-z)*j+(w+t*Ea-y)*h+(u+t*Fa-x)*m)*(j*p+h*q+m*r)-((s-z)*p+(w+t*Ea-y)*q+(u+t*Fa-x)*r))*(1.0/o);else j=0.0;g[Ga+520>>2]=s+j*p;g[Ga+520+4>>2]=w+t*Ea+j*q;g[Ga+520+8>>2]=u+t*Fa+j*r;R=c[(c[d>>2]|0)+16>>2]|0;g[Ga+504>>2]=-C;g[Ga+504+4>>2]=-B;g[Ga+504+8>>2]=-A;g[Ga+504+12>>2]=0.0;ic[R&15](d,Ga+504|0,Ga+520|0,E);i=Ga;return}ia=(f|0)<4;fa=(c[k>>2]=n,+g[k>>2]);if(ia){F=Ga;G=Ga+536|0;a=b+112|0;ja=b+48|0;e=Ga+48|0;aa=Ga+548|0;v=Ga;q=Ea;s=Fa;da=fa;n=Ba;l=Aa}else{l=(g[k>>2]=-(c[k>>2]=Aa,+g[k>>2]),c[k>>2]|0);F=Ga+48|0;G=Ga+548|0;a=b+48|0;ja=b+112|0;e=Ga;aa=Ga+536|0;v=Ga+48|0;r=Da;da=-fa;n=(g[k>>2]=-(c[k>>2]=Ba,+g[k>>2]),c[k>>2]|0)}ca=(c[k>>2]=l,+g[k>>2]);ba=(c[k>>2]=n,+g[k>>2]);o=da*+g[v>>2]+ca*+g[F+16>>2]+ba*+g[F+32>>2];g[Ga+488>>2]=o;p=da*+g[F+4>>2]+ca*+g[F+20>>2]+ba*+g[F+36>>2];g[Ga+488+4>>2]=p;w=da*r+ca*q+ba*s;g[Ga+488+8>>2]=w;r=+N(+o);s=+N(+p);w=+N(+w);n=s>r?(s>w?1:2):r>w?0:2;D=s>r?0:r>w&1;v=(s>r?s>w:r>w)?2:1;w=+g[G+(n<<2)>>2];r=+g[a>>2]-+g[ja>>2];s=w*+g[F+(n<<2)>>2];q=+g[a+4>>2];ha=ja+4|0;p=+g[ha>>2];o=+g[a+8>>2];ga=ja+8|0;m=+g[ga>>2];if(+g[Ga+488+(n<<2)>>2]<0.0){$=r+s;_=q-p+w*+g[F+((n|4)<<2)>>2];Z=o-m+w*+g[F+((n|8)<<2)>>2]}else{$=r-s;_=q-p-w*+g[F+((n|4)<<2)>>2];Z=o-m-w*+g[F+((n|8)<<2)>>2]}K=(ia?-1:-4)+f|0;switch(K|0){case 0:{n=1;l=2;break}case 1:{n=0;l=2;break}default:{n=0;l=1}}U=+g[e+(n<<2)>>2];S=+g[e+((n|4)<<2)>>2];T=+g[e+((n|8)<<2)>>2];Y=$*U+_*S+Z*T;X=+g[e+(l<<2)>>2];V=+g[e+((l|4)<<2)>>2];u=+g[e+((l|8)<<2)>>2];s=$*X+_*V+Z*u;b=F+(D<<2)|0;p=+g[b>>2];M=F+((D|4)<<2)|0;m=+g[M>>2];Q=F+((D|8)<<2)|0;o=+g[Q>>2];L=F+(v<<2)|0;r=+g[L>>2];P=F+((v|4)<<2)|0;q=+g[P>>2];R=F+((v|8)<<2)|0;E=+g[R>>2];na=+g[G+(D<<2)>>2];qa=+g[G+(v<<2)>>2];ma=(U*r+S*q+T*E)*qa;qa=(X*r+V*q+u*E)*qa;g[Ga+456>>2]=Y-(U*p+S*m+T*o)*na-ma;g[Ga+456+4>>2]=s-(X*p+V*m+u*o)*na-qa;g[Ga+456+8>>2]=Y-(U*p+S*m+T*o)*na+ma;g[Ga+456+12>>2]=s-(X*p+V*m+u*o)*na+qa;g[Ga+456+16>>2]=Y+(U*p+S*m+T*o)*na+ma;g[Ga+456+20>>2]=s+(X*p+V*m+u*o)*na+qa;g[Ga+456+24>>2]=Y+(U*p+S*m+T*o)*na-ma;g[Ga+456+28>>2]=s+(X*p+V*m+u*o)*na-qa;c[Ga+448>>2]=c[aa+(n<<2)>>2];c[Ga+448+4>>2]=c[aa+(l<<2)>>2];J=0;l=4;e=Ga+456|0;I=Ga+384|0;a:while(1){G=Ga+448+(J<<2)|0;H=1-J|0;do if((l|0)>0){f=l;l=0;F=e;n=I;while(1){v=F+(J<<2)|0;C=+g[v>>2];B=+g[G>>2];if(B>-C){c[n>>2]=c[F>>2];c[n+4>>2]=c[F+4>>2];l=l+1|0;if(l&8){n=I;break a}C=+g[v>>2];B=+g[G>>2];n=n+8|0}D=(f|0)>1;a=F;F=F+8|0;v=D?F:e;A=+g[v+(J<<2)>>2];if(B>-C^B>-A){qa=+g[a+(H<<2)>>2];g[n+(H<<2)>>2]=qa+(-B-C)*((+g[v+(H<<2)>>2]-qa)/(A-C));g[n+(J<<2)>>2]=-+g[G>>2];l=l+1|0;if(!(l&8))n=n+8|0;else{n=I;break a}}if(!D)break;else f=f+-1|0}n=(I|0)==(Ga+384|0)?Ga+592|0:Ga+384|0;if((l|0)<=0){l=0;break}e=l;l=0;F=I;v=n;while(1){a=F+(J<<2)|0;B=+g[a>>2];C=+g[G>>2];if(B<C){c[v>>2]=c[F>>2];c[v+4>>2]=c[F+4>>2];l=l+1|0;if(l&8)break a;C=+g[G>>2];B=+g[a>>2];v=v+8|0}D=(e|0)>1;f=F;F=F+8|0;a=D?F:I;A=+g[a+(J<<2)>>2];if(B<C^A<C){qa=+g[f+(H<<2)>>2];g[v+(H<<2)>>2]=qa+(C-B)*((+g[a+(H<<2)>>2]-qa)/(A-B));c[v+(J<<2)>>2]=c[G>>2];l=l+1|0;if(!(l&8))v=v+8|0;else break a}if(!D)break;else e=e+-1|0}}else{n=(I|0)==(Ga+384|0)?Ga+592|0:Ga+384|0;l=0}while(0);J=J+1|0;if((J|0)>=2)break;else{e=n;I=(n|0)==(Ga+384|0)?Ga+592|0:Ga+384|0}}if((n|0)!=(Ga+384|0))uF(Ga+384|0,n|0,l<<3|0)|0;if((l|0)>=1){j=1.0/((U*p+S*m+T*o)*(X*r+V*q+u*E)-(X*p+V*m+u*o)*(U*r+S*q+T*E));t=+g[aa+(K<<2)>>2];C=+g[b>>2];B=+g[L>>2];A=+g[M>>2];h=+g[P>>2];w=+g[Q>>2];x=+g[R>>2];n=0;v=0;while(1){R=v<<1;z=+g[Ga+384+(R<<2)>>2];y=+g[Ga+384+((R|1)<<2)>>2];la=(X*r+V*q+u*E)*j*(z-Y)-(U*r+S*q+T*E)*j*(y-s);qa=(U*p+S*m+T*o)*j*(y-s)-(X*p+V*m+u*o)*j*(z-Y);R=n*3|0;ma=$+la*C+qa*B;g[Ga+288+(R<<2)>>2]=ma;na=_+la*A+qa*h;g[Ga+288+(R+1<<2)>>2]=na;qa=Z+la*w+qa*x;g[Ga+288+(R+2<<2)>>2]=qa;qa=t-(da*ma+ca*na+ba*qa);g[Ga+256+(n<<2)>>2]=qa;if(!(qa>=0.0))F=n;else{F=n<<1;g[Ga+384+(F<<2)>>2]=z;g[Ga+384+((F|1)<<2)>>2]=y;F=n+1|0}v=v+1|0;if((v|0)==(l|0))break;else n=F}b:do if((F|0)>=1){D=(F|0)<4?F:4;D=(D|0)<1?1:D;if((F|0)<=(D|0))if(ia){j=-(c[k>>2]=Aa,+g[k>>2]);h=-(c[k>>2]=Ba,+g[k>>2]);f=0;while(1){R=f*3|0;g[Ga+240>>2]=+g[Ga+288+(R<<2)>>2]+ +g[ja>>2];g[Ga+240+4>>2]=+g[Ga+288+(R+1<<2)>>2]+ +g[ha>>2];g[Ga+240+8>>2]=+g[Ga+288+(R+2<<2)>>2]+ +g[ga>>2];R=c[(c[d>>2]|0)+16>>2]|0;g[Ga+224>>2]=-fa;g[Ga+224+4>>2]=j;g[Ga+224+8>>2]=h;g[Ga+224+12>>2]=0.0;ic[R&15](d,Ga+224|0,Ga+240|0,-+g[Ga+256+(f<<2)>>2]);f=f+1|0;if((f|0)==(F|0))break b}}else{j=(c[k>>2]=Aa,+g[k>>2]);h=(c[k>>2]=Ba,+g[k>>2]);f=0;while(1){R=f*3|0;qa=+g[Ga+256+(f<<2)>>2];g[Ga+208>>2]=+g[Ga+288+(R<<2)>>2]+ +g[ja>>2]-fa*qa;g[Ga+208+4>>2]=+g[Ga+288+(R+1<<2)>>2]+ +g[ha>>2]-j*qa;g[Ga+208+8>>2]=+g[Ga+288+(R+2<<2)>>2]+ +g[ga>>2]-h*qa;R=c[(c[d>>2]|0)+16>>2]|0;g[Ga+192>>2]=-fa;g[Ga+192+4>>2]=-j;g[Ga+192+8>>2]=-h;g[Ga+192+12>>2]=0.0;ic[R&15](d,Ga+192|0,Ga+208|0,-qa);f=f+1|0;if((f|0)==(F|0))break b}}c:do if((F|0)>1){f=1;e=0;h=+g[Ga+256>>2];while(1){j=+g[Ga+256+(f<<2)>>2];a=j>h;e=a?f:e;f=f+1|0;if((f|0)==(F|0))break;else h=a?j:h}switch(F|0){case 1:{a=Ga+160|0;f=1;Ca=111;break c}case 2:{n=Ga+160|0;f=2;s=(+g[Ga+384>>2]+ +g[Ga+384+8>>2])*.5;j=(+g[Ga+384+4>>2]+ +g[Ga+384+12>>2])*.5;Ca=115;break c}default:{}}a=F+-1|0;m=0.0;s=0.0;h=0.0;f=0;do{R=f<<1;$=+g[Ga+384+(R<<2)>>2];ba=+g[Ga+384+(R+3<<2)>>2];ca=+g[Ga+384+(R+2<<2)>>2];qa=+g[Ga+384+((R|1)<<2)>>2];m=m+($*ba-ca*qa);s=s+($+ca)*($*ba-ca*qa);h=h+(ba+qa)*($*ba-ca*qa);f=f+1|0}while((f|0)!=(a|0));R=F<<1;q=+g[Ga+384+(R+-2<<2)>>2];p=+g[Ga+384+4>>2];o=+g[Ga+384>>2];j=+g[Ga+384+(R+-1<<2)>>2];r=m+(q*p-o*j);R=+N(+r)>1.1920928955078125e-07;r=R?1.0/(r*3.0):999999984306749440.0;if((F|0)>0){n=Ga+160|0;f=F;s=r*(s+(q+o)*(q*p-o*j));j=r*(h+(p+j)*(q*p-o*j));Ca=115}else{a=Ga+160|0;l=0;f=F;v=e}}else{a=Ga+160|0;f=F;e=0;Ca=111}while(0);if((Ca|0)==111){n=a;s=+g[Ga+384>>2];j=+g[Ga+384+4>>2];Ca=115}if((Ca|0)==115){a=0;do{R=a<<1;g[Ga+592+(a<<2)>>2]=+W(+(+g[Ga+384+((R|1)<<2)>>2]-j),+(+g[Ga+384+(R<<2)>>2]-s));a=a+1|0}while((a|0)!=(f|0));a=0;do{c[Ga+560+(a<<2)>>2]=1;a=a+1|0}while((a|0)!=(f|0));a=n;l=1;v=e}e=Ga+560+(v<<2)|0;c[e>>2]=0;c[a>>2]=v;d:do if((D|0)>1){r=+g[Ga+592+(v<<2)>>2];if(l){e=Ga+160+4|0;n=1}else{a=Ga+160+4|0;f=1;while(1){c[a>>2]=v;c[e>>2]=0;f=f+1|0;if((f|0)==(D|0))break d;else a=a+4|0}}while(1){m=+(n|0)*(6.2831854820251465/+(D|0))+r;m=m>3.1415927410125732?m+-6.2831854820251465:m;c[e>>2]=v;a=v;l=0;h=1.0e9;while(1){do if(!(c[Ga+560+(l<<2)>>2]|0))j=h;else{j=+N(+(+g[Ga+592+(l<<2)>>2]-m));j=j>3.1415927410125732?6.2831854820251465-j:j;if(!(j<h)){j=h;break}c[e>>2]=l;a=l}while(0);l=l+1|0;if((l|0)==(f|0))break;else h=j}c[Ga+560+(a<<2)>>2]=0;n=n+1|0;if((n|0)==(D|0))break;else e=e+4|0}}while(0);if((D|0)<=0)break;h=(c[k>>2]=Ba,+g[k>>2]);j=(c[k>>2]=Aa,+g[k>>2]);if(ia){f=0;do{R=c[Ga+160+(f<<2)>>2]|0;g[Ga+144>>2]=+g[Ga+288+(R*3<<2)>>2]+ +g[ja>>2];g[Ga+144+4>>2]=+g[Ga+288+((R*3|0)+1<<2)>>2]+ +g[ha>>2];g[Ga+144+8>>2]=+g[Ga+288+((R*3|0)+2<<2)>>2]+ +g[ga>>2];Q=c[(c[d>>2]|0)+16>>2]|0;g[Ga+128>>2]=-fa;g[Ga+128+4>>2]=-j;g[Ga+128+8>>2]=-h;g[Ga+128+12>>2]=0.0;ic[Q&15](d,Ga+128|0,Ga+144|0,-+g[Ga+256+(R<<2)>>2]);f=f+1|0}while((f|0)<(D|0))}else{f=0;do{Q=c[Ga+160+(f<<2)>>2]|0;$=+g[Ga+288+(Q*3<<2)>>2]+ +g[ja>>2];g[Ga+144>>2]=$;ba=+g[Ga+288+((Q*3|0)+1<<2)>>2]+ +g[ha>>2];g[Ga+144+4>>2]=ba;ca=+g[Ga+288+((Q*3|0)+2<<2)>>2]+ +g[ga>>2];g[Ga+144+8>>2]=ca;R=c[(c[d>>2]|0)+16>>2]|0;g[Ga+112>>2]=-fa;g[Ga+112+4>>2]=-j;g[Ga+112+8>>2]=-h;g[Ga+112+12>>2]=0.0;qa=+g[Ga+256+(Q<<2)>>2];g[Ga+96>>2]=$-fa*qa;g[Ga+96+4>>2]=ba-qa*j;g[Ga+96+8>>2]=ca-qa*h;g[Ga+96+12>>2]=0.0;ic[R&15](d,Ga+112|0,Ga+96|0,-qa);f=f+1|0}while((f|0)<(D|0))}}while(0)}i=Ga;return}function KD(a){a=a|0;YE(a);return}function LD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0;E=i;i=i+96|0;A=+g[b+48>>2]-+g[b+112>>2];h=+g[b+52>>2]-+g[b+116>>2];D=+g[b+56>>2]-+g[b+120>>2];B=A*+g[b+64>>2]+h*+g[b+80>>2]+D*+g[b+96>>2];C=A*+g[b+68>>2]+h*+g[b+84>>2]+D*+g[b+100>>2];D=A*+g[b+72>>2]+h*+g[b+88>>2]+D*+g[b+104>>2];e=c[a+8>>2]|0;z=c[a+4>>2]|0;h=+g[z+28>>2]*+g[z+12>>2];A=h+ +g[a+12>>2];t=+g[e+72>>2];n=+g[e+56>>2];o=+g[e+76>>2];p=+g[e+60>>2];u=+g[e+80>>2];v=+g[e+64>>2];w=+g[e+88>>2];x=+g[e+92>>2];y=+g[e+96>>2];m=(o-p)*(y-v)-(u-v)*(x-p);s=(u-v)*(w-n)-(t-n)*(y-v);r=(t-n)*(x-p)-(o-p)*(w-n);l=1.0/+O(+(r*r+(m*m+s*s)));q=(B-n)*(l*m)+l*s*(C-p)+l*r*(D-v);if(q<0.0){q=-q;j=-(l*r);k=-(l*s);l=-(l*m)}else{j=l*r;k=l*s;l=l*m}do if(q<A){m=(D-v)*((t-n)*k-(o-p)*l)+((B-n)*((o-p)*j-(u-v)*k)+(C-p)*((u-v)*l-(t-n)*j));r=(D-u)*((w-t)*k-(x-o)*l)+((B-t)*((x-o)*j-(y-u)*k)+(C-o)*((y-u)*l-(w-t)*j));p=(D-y)*((n-w)*k-(p-x)*l)+((B-w)*((p-x)*j-(v-y)*k)+(C-x)*((v-y)*l-(n-w)*j));if(!(p>0.0&(m>0.0&r>0.0))?!(p<=0.0&(m<=0.0&r<=0.0)):0){if((Hb[c[(c[e>>2]|0)+100>>2]&127](e)|0)<=0)break;o=0.0;q=0.0;p=0.0;e=0;z=0;do{F=c[a+8>>2]|0;nc[c[(c[F>>2]|0)+104>>2]&127](F,z,E+80|0,E+64|0);s=+g[E+80>>2];y=+g[E+80+4>>2];w=+g[E+80+8>>2];r=+g[E+64>>2]-s;x=+g[E+64+4>>2]-y;u=+g[E+64+8>>2]-w;do if((B-s)*r+(C-y)*x+(D-w)*u>0.0)if((B-s)*r+(C-y)*x+(D-w)*u<r*r+x*x+u*u){t=((B-s)*r+(C-y)*x+(D-w)*u)/(r*r+x*x+u*u);v=t;m=D-w-u*t;n=B-s-r*t;t=C-y-x*t;break}else{v=1.0;m=D-w-u;n=B-s-r;t=C-y-x;break}else{v=0.0;m=D-w;n=B-s;t=C-y}while(0);if(m*m+(t*t+n*n)<A*A){o=s+r*v;q=y+x*v;p=w+u*v;e=1}z=z+1|0;F=c[a+8>>2]|0}while((z|0)<(Hb[c[(c[F>>2]|0)+100>>2]&127](F)|0));if(!(e&1))break;else{s=o;r=q;q=p;m=A*A}}else{s=B-l*q;r=C-k*q;q=D-j*q;m=A*A}n=B-s;p=C-r;o=D-q;if(n*n+p*p+o*o<m){if(n*n+p*p+o*o>1.1920928955078125e-07){j=+O(+(n*n+p*p+o*o));h=h-j;l=n*(1.0/j);k=p*(1.0/j);j=o*(1.0/j)}h=-h;if(f){u=+g[b+64>>2];t=+g[b+68>>2];m=+g[b+72>>2];n=u*l+t*k+m*j;B=+g[b+80>>2];A=+g[b+84>>2];y=+g[b+88>>2];o=l*B+k*A+j*y;x=+g[b+96>>2];w=+g[b+100>>2];v=+g[b+104>>2];p=l*x+k*w+j*v;g[E+48>>2]=-n;g[E+48+4>>2]=-o;g[E+48+8>>2]=-p;g[E+48+12>>2]=0.0;o=s*B+r*A+q*y+ +g[b+116>>2]+o*h;p=s*x+r*w+q*v+ +g[b+120>>2]+p*h;g[E+32>>2]=s*u+r*t+q*m+ +g[b+112>>2]+n*h;g[E+32+4>>2]=o;g[E+32+8>>2]=p;g[E+32+12>>2]=0.0;ic[c[(c[d>>2]|0)+16>>2]&15](d,E+48|0,E+32|0,h);i=E;return}else{e=c[(c[d>>2]|0)+16>>2]|0;t=+g[b+64>>2];m=+g[b+68>>2];n=+g[b+72>>2];x=+g[b+80>>2];w=+g[b+84>>2];o=+g[b+88>>2];v=+g[b+96>>2];u=+g[b+100>>2];p=+g[b+104>>2];g[E+16>>2]=t*l+m*k+n*j;g[E+16+4>>2]=l*x+k*w+j*o;g[E+16+8>>2]=l*v+k*u+j*p;g[E+16+12>>2]=0.0;o=s*x+r*w+q*o+ +g[b+116>>2];p=s*v+r*u+q*p+ +g[b+120>>2];g[E>>2]=s*t+r*m+q*n+ +g[b+112>>2];g[E+4>>2]=o;g[E+8>>2]=p;g[E+12>>2]=0.0;ic[e&15](d,E+16|0,E,h);i=E;return}}}while(0);i=E;return}function MD(a){a=a|0;YE(a);return}function ND(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;i=c[b+12>>2]|0;j=c[b+32>>2]|0;if((i|0)<=(j|0))return;if((i|0)>=(j|0)){do if((c[b+36>>2]|0)<(i|0)){if(!i){e=j;d=0}else{c[2703]=(c[2703]|0)+1;d=XE((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+32>>2]|0}g=c[b+40>>2]|0;if((e|0)<=0){if(!g){a[b+44>>0]=1;c[b+40>>2]=d;c[b+36>>2]=i;break}}else{f=0;do{c[d+(f<<2)>>2]=c[g+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}if(a[b+44>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0)}a[b+44>>0]=1;c[b+40>>2]=d;c[b+36>>2]=i}else d=c[b+40>>2]|0;while(0);qF(d+(j<<2)|0,0,i-j<<2|0)|0}c[b+32>>2]=i;h=c[b+52>>2]|0;if((i|0)>(h|0)){do if((c[b+56>>2]|0)<(i|0)){if(!i){e=h;d=0}else{c[2703]=(c[2703]|0)+1;d=XE((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+52>>2]|0}g=c[b+60>>2]|0;if((e|0)<=0){if(!g){a[b+64>>0]=1;c[b+60>>2]=d;c[b+56>>2]=i;break}}else{f=0;do{c[d+(f<<2)>>2]=c[g+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}if(a[b+64>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0)}a[b+64>>0]=1;c[b+60>>2]=d;c[b+56>>2]=i}else d=c[b+60>>2]|0;while(0);qF(d+(h<<2)|0,0,i-h<<2|0)|0}c[b+52>>2]=i;if((i|0)>0){qF(c[b+40>>2]|0,-1,i<<2|0)|0;qF(c[b+60>>2]|0,-1,i<<2|0)|0}if((j|0)<=0)return;d=c[b+16>>2]|0;e=c[b+40>>2]|0;f=c[b+60>>2]|0;g=0;do{h=c[d+(g*12|0)+4>>2]<<16|c[d+(g*12|0)>>2];h=(h+~(h<<15)>>10^h+~(h<<15))*9|0;h=e+((((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11))&(c[b+12>>2]|0)+-1)<<2)|0;c[f+(g<<2)>>2]=c[h>>2];c[h>>2]=g;g=g+1|0}while((g|0)!=(j|0));return}function OD(b){b=b|0;var d=0;c[b>>2]=10660;d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;d=c[b+40>>2]|0;if(d){if(a[b+44>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;return}if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;return}function PD(a){a=a|0;OD(a);YE(a);return}function QD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;d=c[b+40>>2]|0;if(d){if(a[b+44>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;if((c[b+12>>2]|0)>=2){ND(b);return}c[2703]=(c[2703]|0)+1;d=XE(43)|0;if(!d)f=0;else{c[(d+4+15&-16)+-4>>2]=d;f=d+4+15&-16}d=c[b+8>>2]|0;if((d|0)>0){e=0;do{g=f+(e*12|0)|0;h=(c[b+16>>2]|0)+(e*12|0)|0;c[g>>2]=c[h>>2];c[g+4>>2]=c[h+4>>2];c[g+8>>2]=c[h+8>>2];e=e+1|0}while((e|0)!=(d|0))}d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=2;ND(b);return}function RD(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;c[2660]=(c[2660]|0)+1;h=((d<<16|b)+~((d<<16|b)<<15)>>10^(d<<16|b)+~((d<<16|b)<<15))*9|0;m=c[a+40>>2]|0;h=m+(((c[a+12>>2]|0)+-1&((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11)))<<2)|0;f=c[h>>2]|0;if((f|0)==-1){l=0;return l|0}n=c[a+16>>2]|0;e=f;while(1){l=n+(e*12|0)|0;if((c[l>>2]|0)==(b|0)?(c[n+(e*12|0)+4>>2]|0)==(d|0):0)break;e=c[(c[a+60>>2]|0)+(e<<2)>>2]|0;if((e|0)==-1){e=0;o=21;break}}if((o|0)==21)return e|0;if(!l){l=0;return l|0}k=c[n+(e*12|0)+8>>2]|0;j=(e*12|0)/12|0;i=c[a+60>>2]|0;if((f|0)!=(j|0)){while(1){b=i+(f<<2)|0;d=c[b>>2]|0;if((d|0)==(j|0))break;else f=d}e=c[i+(j<<2)>>2]|0;if((f|0)==-1)o=11;else c[b>>2]=e}else{e=c[i+(f<<2)>>2]|0;o=11}if((o|0)==11)c[h>>2]=e;h=(c[a+8>>2]|0)+-1|0;if((h|0)==(j|0)){c[a+8>>2]=j;l=k;return l|0}g=c[n+(h*12|0)+4>>2]<<16|c[n+(h*12|0)>>2];g=(g+~(g<<15)>>10^g+~(g<<15))*9|0;g=((g>>6^g)+~((g>>6^g)<<11)>>16^(g>>6^g)+~((g>>6^g)<<11))&(c[a+12>>2]|0)+-1;e=c[m+(g<<2)>>2]|0;if((e|0)!=(h|0)){b=e;while(1){d=i+(b<<2)|0;f=c[d>>2]|0;if((f|0)==(h|0))break;else b=f}e=c[i+(h<<2)>>2]|0;if((b|0)==-1)o=19;else c[d>>2]=e}else{e=c[i+(h<<2)>>2]|0;o=19}if((o|0)==19)c[m+(g<<2)>>2]=e;c[l>>2]=c[n+(h*12|0)>>2];c[l+4>>2]=c[n+(h*12|0)+4>>2];c[l+8>>2]=c[n+(h*12|0)+8>>2];l=(c[a+40>>2]|0)+(g<<2)|0;c[(c[a+60>>2]|0)+(j<<2)>>2]=c[l>>2];c[l>>2]=j;c[a+8>>2]=(c[a+8>>2]|0)+-1;l=k;return l|0}function SD(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[2661]=(c[2661]|0)+1;l=((e<<16|d)+~((e<<16|d)<<15)>>10^(e<<16|d)+~((e<<16|d)<<15))*9|0;l=(l>>6^l)+~((l>>6^l)<<11)>>16^(l>>6^l)+~((l>>6^l)<<11);k=c[b+12>>2]|0;f=c[(c[b+40>>2]|0)+((k+-1&l)<<2)>>2]|0;a:do if((f|0)!=-1){h=c[b+16>>2]|0;while(1){g=h+(f*12|0)|0;if((c[g>>2]|0)==(d|0)?(c[h+(f*12|0)+4>>2]|0)==(e|0):0)break;f=c[(c[b+60>>2]|0)+(f<<2)>>2]|0;if((f|0)==-1)break a}if(g){f=g;return f|0}}while(0);j=c[b+8>>2]|0;if((j|0)==(k|0)){f=(k|0)!=0?k<<1:1;if((k|0)<(f|0)){if(!f){i=k;h=0}else{c[2703]=(c[2703]|0)+1;g=XE((f*12|3)+16|0)|0;if(!g)h=0;else{c[(g+4+15&-16)+-4>>2]=g;h=g+4+15&-16}i=c[b+8>>2]|0}if((i|0)>0){g=0;do{m=h+(g*12|0)|0;n=(c[b+16>>2]|0)+(g*12|0)|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];g=g+1|0}while((g|0)!=(i|0))}g=c[b+16>>2]|0;if(g){if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=h;c[b+12>>2]=f;g=c[b+8>>2]|0}else{g=k;f=k}}else{g=j;f=k}c[b+8>>2]=g+1;g=c[b+16>>2]|0;if((k|0)<(f|0)){ND(b);f=(c[b+12>>2]|0)+-1&l}else f=k+-1&l;c[g+(j*12|0)>>2]=d;c[g+(j*12|0)+4>>2]=e;c[g+(j*12|0)+8>>2]=0;e=(c[b+40>>2]|0)+(f<<2)|0;c[(c[b+60>>2]|0)+(j<<2)>>2]=c[e>>2];c[e>>2]=j;b=g+(j*12|0)|0;return b|0}function TD(a){a=a|0;return c[a+16>>2]|0}function UD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;c[b>>2]=10688;d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;e=c[b+28>>2]|0;if((e|0)>0){h=0;do{f=c[b+36>>2]|0;j=f+(h*36|0)+4|0;i=f+(h*36|0)+12|0;g=c[i>>2]|0;d=f+(h*36|0)+16|0;if(g){if(a[d>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0)}c[i>>2]=0}a[d>>0]=1;c[i>>2]=0;c[j>>2]=0;c[f+(h*36|0)+8>>2]=0;h=h+1|0}while((h|0)!=(e|0))}d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;return}if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;return}function VD(a){a=a|0;UD(a);if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function WD(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,i=0,j=0;b=c[a+28>>2]|0;if((b|0)<=0){b=1;return b|0}i=c[a+36>>2]|0;e=0.0;f=0.0;h=0.0;j=0;a:while(1){switch(j|0){case 0:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+84>>2]+ +g[a+68>>2];break}case 1:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+72>>2]-+g[a+88>>2];h=+g[a+84>>2]+ +g[a+68>>2];break}case 2:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+68>>2]-+g[a+84>>2];break}case 3:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+72>>2]-+g[a+88>>2];h=+g[a+68>>2]-+g[a+84>>2];break}case 4:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+84>>2]+ +g[a+68>>2];break}case 5:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+72>>2]-+g[a+88>>2];h=+g[a+84>>2]+ +g[a+68>>2];break}case 6:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+68>>2]-+g[a+84>>2];break}case 7:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+72>>2]-+g[a+88>>2];h=+g[a+68>>2]-+g[a+84>>2];break}default:{}}d=0;do{if(+g[i+(d*36|0)+32>>2]+(e*+g[i+(d*36|0)+20>>2]+h*+g[i+(d*36|0)+24>>2]+f*+g[i+(d*36|0)+28>>2])>0.0){b=0;d=16;break a}d=d+1|0}while((d|0)<(b|0));j=j+1|0;if((j|0)>=8){b=1;d=16;break}}if((d|0)==16)return b|0;return 0}function XD(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0;r=i;i=i+16|0;g[e>>2]=3402823466385288598117041.0e14;g[f>>2]=-3402823466385288598117041.0e14;n=c[a+8>>2]|0;if((n|0)>0){q=0;do{t=c[a+16>>2]|0;s=+g[t+(q<<4)>>2];l=+g[t+(q<<4)+4>>2];o=+g[t+(q<<4)+8>>2];m=s*+g[b>>2]+l*+g[b+4>>2]+o*+g[b+8>>2]+ +g[b+48>>2];p=s*+g[b+16>>2]+l*+g[b+20>>2]+o*+g[b+24>>2]+ +g[b+52>>2];o=s*+g[b+32>>2]+l*+g[b+36>>2]+o*+g[b+40>>2]+ +g[b+56>>2];l=m*+g[d>>2]+p*+g[d+4>>2]+o*+g[d+8>>2];if(l<+g[e>>2]){g[e>>2]=l;g[h>>2]=m;g[h+4>>2]=p;g[h+8>>2]=o;g[h+12>>2]=0.0}if(l>+g[f>>2]){g[f>>2]=l;g[j>>2]=m;g[j+4>>2]=p;g[j+8>>2]=o;g[j+12>>2]=0.0}q=q+1|0}while((q|0)!=(n|0));l=+g[f>>2];m=l;n=(g[k>>2]=l,c[k>>2]|0)}else{m=-3402823466385288598117041.0e14;n=-8388609}l=+g[e>>2];if(!(l>m)){i=r;return}c[e>>2]=n;g[f>>2]=l;c[r>>2]=c[h>>2];c[r+4>>2]=c[h+4>>2];c[r+8>>2]=c[h+8>>2];c[r+12>>2]=c[h+12>>2];c[h>>2]=c[j>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j>>2]=c[r>>2];c[j+4>>2]=c[r+4>>2];c[j+8>>2]=c[r+8>>2];c[j+12>>2]=c[r+12>>2];i=r;return}function YD(b){b=b|0;var d=0;c[b>>2]=10704;d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}function ZD(b){b=b|0;var d=0;c[b>>2]=10704;d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[2704]=(c[2704]|0)+1;YE(c[b+-4>>2]|0);return}function _D(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function $D(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function aE(a){a=a|0;return (c[a+48>>2]|0)==1|0}function bE(a,b,d){a=a|0;b=b|0;d=d|0;c[a+52>>2]=c[b>>2];c[a+52+4>>2]=c[b+4>>2];c[a+52+8>>2]=c[b+8>>2];c[a+52+12>>2]=c[b+12>>2];c[a+68>>2]=c[d>>2];c[a+68+4>>2]=c[d+4>>2];c[a+68+8>>2]=c[d+8>>2];c[a+68+12>>2]=c[d+12>>2];c[a+48>>2]=1;return}function cE(a,b,d){a=a|0;b=b|0;d=d|0;c[b>>2]=c[a+52>>2];c[b+4>>2]=c[a+52+4>>2];c[b+8>>2]=c[a+52+8>>2];c[b+12>>2]=c[a+52+12>>2];c[d>>2]=c[a+68>>2];c[d+4>>2]=c[a+68+4>>2];c[d+8>>2]=c[a+68+8>>2];c[d+12>>2]=c[a+68+12>>2];return}function dE(a,b){a=a|0;b=b|0;return}function eE(a,b){a=a|0;b=b|0;return}function fE(a,b,f,j){a=a|0;b=b|0;f=f|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0.0,B=0.0,C=0,D=0,E=0,F=0,G=0;z=i;i=i+80|0;u=Hb[c[(c[a>>2]|0)+28>>2]&127](a)|0;v=+g[a+4>>2];w=+g[a+8>>2];x=+g[a+12>>2];if((u|0)<=0){i=z;return}l=z+32+4|0;o=z+32+8|0;r=z+32+12|0;j=z+32+16|0;n=z+32+20|0;q=z+32+24|0;t=z+32+28|0;k=z+32+32|0;m=z+32+36|0;p=z+32+40|0;s=z+32+44|0;y=0;do{Zb[c[(c[a>>2]|0)+16>>2]&3](a,z+28|0,z+4|0,z+16|0,z+8|0,z+24|0,z+20|0,z,z+12|0,y);a:do switch(c[z+16>>2]|0){case 0:{switch(c[z+12>>2]|0){case 2:{if((c[z>>2]|0)>0)f=0;else break a;do{E=c[z+24>>2]|0;C=_(c[z+20>>2]|0,f)|0;D=c[z+28>>2]|0;F=c[z+8>>2]|0;G=_(F,c[E+C>>2]|0)|0;B=w*+g[D+(G+4)>>2];A=x*+g[D+(G+8)>>2];g[z+32>>2]=v*+g[D+G>>2];g[l>>2]=B;g[o>>2]=A;g[r>>2]=0.0;G=_(F,c[E+(C+4)>>2]|0)|0;A=w*+g[D+(G+4)>>2];B=x*+g[D+(G+8)>>2];g[j>>2]=v*+g[D+G>>2];g[n>>2]=A;g[q>>2]=B;g[t>>2]=0.0;C=_(F,c[E+(C+8)>>2]|0)|0;B=w*+g[D+(C+4)>>2];A=x*+g[D+(C+8)>>2];g[k>>2]=v*+g[D+C>>2];g[m>>2]=B;g[p>>2]=A;g[s>>2]=0.0;nc[c[(c[b>>2]|0)+8>>2]&127](b,z+32|0,y,f);f=f+1|0}while((f|0)<(c[z>>2]|0));break}case 3:{if((c[z>>2]|0)>0)f=0;else break a;do{D=c[z+24>>2]|0;E=_(c[z+20>>2]|0,f)|0;F=c[z+28>>2]|0;G=c[z+8>>2]|0;C=_(e[D+E>>1]|0,G)|0;B=w*+g[F+(C+4)>>2];A=x*+g[F+(C+8)>>2];g[z+32>>2]=v*+g[F+C>>2];g[l>>2]=B;g[o>>2]=A;g[r>>2]=0.0;C=_(e[D+(E+2)>>1]|0,G)|0;A=w*+g[F+(C+4)>>2];B=x*+g[F+(C+8)>>2];g[j>>2]=v*+g[F+C>>2];g[n>>2]=A;g[q>>2]=B;g[t>>2]=0.0;G=_(e[D+(E+4)>>1]|0,G)|0;B=w*+g[F+(G+4)>>2];A=x*+g[F+(G+8)>>2];g[k>>2]=v*+g[F+G>>2];g[m>>2]=B;g[p>>2]=A;g[s>>2]=0.0;nc[c[(c[b>>2]|0)+8>>2]&127](b,z+32|0,y,f);f=f+1|0}while((f|0)<(c[z>>2]|0));break}case 5:{if((c[z>>2]|0)>0)f=0;else break a;do{D=c[z+24>>2]|0;E=_(c[z+20>>2]|0,f)|0;F=c[z+28>>2]|0;G=c[z+8>>2]|0;C=_(d[D+E>>0]|0,G)|0;B=w*+g[F+(C+4)>>2];A=x*+g[F+(C+8)>>2];g[z+32>>2]=v*+g[F+C>>2];g[l>>2]=B;g[o>>2]=A;g[r>>2]=0.0;C=_(d[D+(E+1)>>0]|0,G)|0;A=w*+g[F+(C+4)>>2];B=x*+g[F+(C+8)>>2];g[j>>2]=v*+g[F+C>>2];g[n>>2]=A;g[q>>2]=B;g[t>>2]=0.0;G=_(d[D+(E+2)>>0]|0,G)|0;B=w*+g[F+(G+4)>>2];A=x*+g[F+(G+8)>>2];g[k>>2]=v*+g[F+G>>2];g[m>>2]=B;g[p>>2]=A;g[s>>2]=0.0;nc[c[(c[b>>2]|0)+8>>2]&127](b,z+32|0,y,f);f=f+1|0}while((f|0)<(c[z>>2]|0));break}default:break a}break}case 1:{switch(c[z+12>>2]|0){case 2:{if((c[z>>2]|0)>0)f=0;else break a;do{E=c[z+24>>2]|0;G=_(c[z+20>>2]|0,f)|0;F=c[z+28>>2]|0;D=c[z+8>>2]|0;C=_(D,c[E+G>>2]|0)|0;B=w*+h[F+(C+8)>>3];A=x*+h[F+(C+16)>>3];g[z+32>>2]=v*+h[F+C>>3];g[l>>2]=B;g[o>>2]=A;g[r>>2]=0.0;C=_(D,c[E+(G+4)>>2]|0)|0;A=w*+h[F+(C+8)>>3];B=x*+h[F+(C+16)>>3];g[j>>2]=v*+h[F+C>>3];g[n>>2]=A;g[q>>2]=B;g[t>>2]=0.0;G=_(D,c[E+(G+8)>>2]|0)|0;B=w*+h[F+(G+8)>>3];A=x*+h[F+(G+16)>>3];g[k>>2]=v*+h[F+G>>3];g[m>>2]=B;g[p>>2]=A;g[s>>2]=0.0;nc[c[(c[b>>2]|0)+8>>2]&127](b,z+32|0,y,f);f=f+1|0}while((f|0)<(c[z>>2]|0));break}case 3:{if((c[z>>2]|0)>0)f=0;else break a;do{D=c[z+24>>2]|0;E=_(c[z+20>>2]|0,f)|0;F=c[z+28>>2]|0;G=c[z+8>>2]|0;C=_(e[D+E>>1]|0,G)|0;B=w*+h[F+(C+8)>>3];A=x*+h[F+(C+16)>>3];g[z+32>>2]=v*+h[F+C>>3];g[l>>2]=B;g[o>>2]=A;g[r>>2]=0.0;C=_(e[D+(E+2)>>1]|0,G)|0;A=w*+h[F+(C+8)>>3];B=x*+h[F+(C+16)>>3];g[j>>2]=v*+h[F+C>>3];g[n>>2]=A;g[q>>2]=B;g[t>>2]=0.0;G=_(e[D+(E+4)>>1]|0,G)|0;B=w*+h[F+(G+8)>>3];A=x*+h[F+(G+16)>>3];g[k>>2]=v*+h[F+G>>3];g[m>>2]=B;g[p>>2]=A;g[s>>2]=0.0;nc[c[(c[b>>2]|0)+8>>2]&127](b,z+32|0,y,f);f=f+1|0}while((f|0)<(c[z>>2]|0));break}case 5:{if((c[z>>2]|0)>0)f=0;else break a;do{D=c[z+24>>2]|0;E=_(c[z+20>>2]|0,f)|0;F=c[z+28>>2]|0;G=c[z+8>>2]|0;C=_(d[D+E>>0]|0,G)|0;B=w*+h[F+(C+8)>>3];A=x*+h[F+(C+16)>>3];g[z+32>>2]=v*+h[F+C>>3];g[l>>2]=B;g[o>>2]=A;g[r>>2]=0.0;C=_(d[D+(E+1)>>0]|0,G)|0;A=w*+h[F+(C+8)>>3];B=x*+h[F+(C+16)>>3];g[j>>2]=v*+h[F+C>>3];g[n>>2]=A;g[q>>2]=B;g[t>>2]=0.0;G=_(d[D+(E+2)>>0]|0,G)|0;B=w*+h[F+(G+8)>>3];A=x*+h[F+(G+16)>>3];g[k>>2]=v*+h[F+G>>3];g[m>>2]=B;g[p>>2]=A;g[s>>2]=0.0;nc[c[(c[b>>2]|0)+8>>2]&127](b,z+32|0,y,f);f=f+1|0}while((f|0)<(c[z>>2]|0));break}default:break a}break}default:{}}while(0);Fb[c[(c[a>>2]|0)+24>>2]&127](a,y);y=y+1|0}while((y|0)!=(u|0));i=z;return}function gE(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+32|0;g=Hb[c[(c[d>>2]|0)+28>>2]&127](d)|0;c[e+20>>2]=g;c[e>>2]=0;if(!g){r=d+4|0;q=e+4|0;r=c[r>>2]|0;c[q>>2]=r;q=d+8|0;q=c[q>>2]|0;r=e+8|0;c[r>>2]=q;r=d+12|0;r=c[r>>2]|0;q=e+12|0;c[q>>2]=r;q=d+16|0;q=c[q>>2]|0;r=e+16|0;c[r>>2]=q;i=t;return 19957}s=Qb[c[(c[f>>2]|0)+16>>2]&63](f,32,g)|0;g=c[s+8>>2]|0;c[e>>2]=_b[c[(c[f>>2]|0)+28>>2]&31](f,g)|0;r=Hb[c[(c[d>>2]|0)+28>>2]&127](d)|0;a:do if((r|0)>0){q=0;while(1){Zb[c[(c[d>>2]|0)+16>>2]&3](d,t+28|0,t+4|0,t+16|0,t+8|0,t+24|0,t+20|0,t,t+12|0,q);c[g+24>>2]=c[t>>2];c[g+28>>2]=c[t+4>>2];o=g+12|0;n=g+16|0;p=g+4|0;c[g>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;c[g+20>>2]=0;switch(c[t+12>>2]|0){case 2:{j=c[t>>2]|0;if(j){l=Qb[c[(c[f>>2]|0)+16>>2]&63](f,4,j*3|0)|0;j=c[l+8>>2]|0;c[g+8>>2]=_b[c[(c[f>>2]|0)+28>>2]&31](f,j)|0;if((c[t>>2]|0)>0){k=c[t+24>>2]|0;m=0;do{n=_(c[t+20>>2]|0,m)|0;o=m*3|0;c[j+(o<<2)>>2]=c[k+n>>2];c[j+(o+1<<2)>>2]=c[k+(n+4)>>2];c[j+(o+2<<2)>>2]=c[k+(n+8)>>2];m=m+1|0}while((m|0)<(c[t>>2]|0))}Bb[c[(c[f>>2]|0)+20>>2]&31](f,l,19838,1497453121,c[l+8>>2]|0)}break}case 3:{j=c[t>>2]|0;if(j){j=Qb[c[(c[f>>2]|0)+16>>2]&63](f,8,j)|0;k=c[j+8>>2]|0;c[o>>2]=_b[c[(c[f>>2]|0)+28>>2]&31](f,k)|0;o=c[t>>2]|0;if((o|0)>0){n=c[t+24>>2]|0;m=c[t+20>>2]|0;l=0;do{u=_(m,l)|0;b[k+(l<<3)>>1]=b[n+u>>1]|0;b[k+(l<<3)+2>>1]=b[n+(u+2)>>1]|0;b[k+(l<<3)+4>>1]=b[n+(u+4)>>1]|0;l=l+1|0}while((l|0)!=(o|0))}Bb[c[(c[f>>2]|0)+20>>2]&31](f,j,19853,1497453121,c[j+8>>2]|0)}break}case 5:{j=c[t>>2]|0;if(j){l=Qb[c[(c[f>>2]|0)+16>>2]&63](f,4,j)|0;k=c[l+8>>2]|0;c[n>>2]=_b[c[(c[f>>2]|0)+28>>2]&31](f,k)|0;if((c[t>>2]|0)>0){j=0;do{n=c[t+24>>2]|0;o=_(c[t+20>>2]|0,j)|0;a[k+(j<<2)>>0]=a[n+o>>0]|0;a[k+(j<<2)+1>>0]=a[n+(o+1)>>0]|0;a[k+(j<<2)+2>>0]=a[n+(o+2)>>0]|0;j=j+1|0}while((j|0)<(c[t>>2]|0))}Bb[c[(c[f>>2]|0)+20>>2]&31](f,l,19880,1497453121,c[l+8>>2]|0)}break}default:{}}switch(c[t+16>>2]|0){case 0:{j=c[t+4>>2]|0;if(j){n=Qb[c[(c[f>>2]|0)+16>>2]&63](f,16,j)|0;m=c[n+8>>2]|0;c[g>>2]=_b[c[(c[f>>2]|0)+28>>2]&31](f,m)|0;l=c[t+4>>2]|0;if((l|0)>0){k=c[t+28>>2]|0;j=c[t+8>>2]|0;o=0;do{p=_(j,o)|0;c[m+(o<<4)>>2]=c[k+p>>2];c[m+(o<<4)+4>>2]=c[k+(p+4)>>2];c[m+(o<<4)+8>>2]=c[k+(p+8)>>2];o=o+1|0}while((o|0)!=(l|0))}Bb[c[(c[f>>2]|0)+20>>2]&31](f,n,19903,1497453121,c[n+8>>2]|0)}break}case 1:{j=c[t+4>>2]|0;if(j){j=Qb[c[(c[f>>2]|0)+16>>2]&63](f,32,j)|0;n=c[j+8>>2]|0;c[p>>2]=_b[c[(c[f>>2]|0)+28>>2]&31](f,n)|0;m=c[t+4>>2]|0;if((m|0)>0){l=c[t+28>>2]|0;k=c[t+8>>2]|0;o=0;do{p=_(k,o)|0;h[n+(o<<5)>>3]=+h[l+p>>3];h[n+(o<<5)+8>>3]=+h[l+(p+8)>>3];h[n+(o<<5)+16>>3]=+h[l+(p+16)>>3];o=o+1|0}while((o|0)!=(m|0))}Bb[c[(c[f>>2]|0)+20>>2]&31](f,j,19922,1497453121,c[j+8>>2]|0)}break}default:{}}Fb[c[(c[d>>2]|0)+24>>2]&127](d,q);q=q+1|0;if((q|0)==(r|0)){g=f;break a}else g=g+32|0}}else g=f;while(0);Bb[c[(c[g>>2]|0)+20>>2]&31](f,s,19942,1497453121,c[s+8>>2]|0);r=d+4|0;q=e+4|0;r=c[r>>2]|0;c[q>>2]=r;q=d+8|0;q=c[q>>2]|0;r=e+8|0;c[r>>2]=q;r=d+12|0;r=c[r>>2]|0;q=e+12|0;c[q>>2]=r;q=d+16|0;q=c[q>>2]|0;r=e+16|0;c[r>>2]=q;i=t;return 19957}function hE(a){a=a|0;var b=0;do{c[a+4>>2]=0;g[a+8>>2]=0.0;b=c[a+24>>2]|0;if(b)hE(b);a=c[a+28>>2]|0}while((a|0)!=0);return}function iE(a){a=a|0;var b=0,d=0,e=0,f=0;f=i;i=i+16|0;e=c[2700]|0;if((c[e>>2]|0)==(a|0))b=e;else{b=c[e+24>>2]|0;a:do if(!b)d=5;else while(1){if((c[b>>2]|0)==(a|0))break a;b=c[b+28>>2]|0;if(!b){d=5;break}}while(0);if((d|0)==5){b=XE(36)|0;b:do if(!b){while(1){b=c[2711]|0;c[2711]=b+0;if(!b)break;kc[b&3]();b=XE(36)|0;if(b)break b}b=Ya(4)|0;c[b>>2]=10832;rb(b|0,2408,207)}while(0);c[b>>2]=a;d=b+4|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+20>>2]=e;c[b+24>>2]=0;d=b+28|0;c[d>>2]=0;c[b+32>>2]=0;hE(b);c[d>>2]=c[e+24>>2];c[e+24>>2]=b}c[2700]=b}e=b+4|0;c[e>>2]=(c[e>>2]|0)+1;e=b+16|0;d=c[e>>2]|0;c[e>>2]=d+1;if(d){i=f;return}vb(f|0,0)|0;d=c[2702]|0;c[b+12>>2]=(c[f+4>>2]|0)-(c[d+4>>2]|0)+(((c[f>>2]|0)-(c[d>>2]|0)|0)*1e6|0);i=f;return}function jE(){var a=0;a=XE(8)|0;a:do if(!a){while(1){a=c[2711]|0;c[2711]=a+0;if(!a)break;kc[a&3]();a=XE(8)|0;if(a)break a}a=Ya(4)|0;c[a>>2]=10832;rb(a|0,2408,207)}while(0);c[2702]=a;vb(a|0,0)|0;c[2691]=19985;c[2692]=0;c[2693]=0;c[2694]=0;c[2695]=0;c[2696]=0;c[2697]=0;c[2698]=0;c[2699]=0;hE(10764);return}function kE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=c[a+56>>2]|0;if(!e){e=c[a+52>>2]|0;if(!e){c[2703]=(c[2703]|0)+1;e=XE(31)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[a+60>>2]|0;c[e+4>>2]=f;g=e+8|0;c[g>>2]=0;c[2703]=(c[2703]|0)+1;f=XE((f*24|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[e>>2]=f;c[g>>2]=c[a+48>>2];c[a+48>>2]=e}else c[a+52>>2]=c[e+8>>2];h=c[e+4>>2]|0;f=c[e>>2]|0;if((h|0)>0){g=0;e=f;do{g=g+1|0;i=e;e=e+24|0;c[i>>2]=(g|0)<(h|0)?e:0}while((g|0)!=(h|0))}}else f=e;c[a+56>>2]=c[f>>2];c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;e=c[a+56>>2]|0;if(!e){e=c[a+52>>2]|0;if(!e){c[2703]=(c[2703]|0)+1;e=XE(31)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=c[a+60>>2]|0;c[e+4>>2]=g;h=e+8|0;c[h>>2]=0;c[2703]=(c[2703]|0)+1;g=XE((g*24|3)+16|0)|0;if(!g)g=0;else{c[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}c[e>>2]=g;c[h>>2]=c[a+48>>2];c[a+48>>2]=e}else c[a+52>>2]=c[e+8>>2];i=c[e+4>>2]|0;e=c[e>>2]|0;if((i|0)>0){h=0;g=e;do{h=h+1|0;j=g;g=g+24|0;c[j>>2]=(h|0)<(i|0)?g:0}while((h|0)!=(i|0))}}c[a+56>>2]=c[e>>2];c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[f+8>>2]=e;c[e+8>>2]=f;g=c[a+100>>2]|0;c[f+20>>2]=g;c[e+20>>2]=g;c[f+12>>2]=d;c[e+12>>2]=b;c[f+16>>2]=0;c[e+16>>2]=0;e=c[a+116>>2]|0;c[a+116>>2]=e+1;if((e|0)<(c[a+120>>2]|0))return f|0;c[a+120>>2]=e+1;return f|0}function lE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0;Q=i;i=i+144|0;a:do switch(d-b|0){case 0:{c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;i=Q;return}case 2:{d=c[(c[a+92>>2]|0)+(b<<2)>>2]|0;h=c[d+88>>2]|0;j=c[d+200>>2]|0;k=c[d+92>>2]|0;g=c[d+204>>2]|0;if((h|0)==(j|0)){if((k|0)==(g|0))if((c[d+96>>2]|0)==(c[d+208>>2]|0))break a;else f=k;else f=g;if((k|0)==(f|0)){z=(c[d+96>>2]|0)>(c[d+208>>2]|0);f=z?d+112|0:d;c[f>>2]=f;c[f+4>>2]=f;c[e>>2]=f;c[e+4>>2]=f;c[e+8>>2]=f;c[e+12>>2]=f;d=z?d:d+112|0}else{g=0;P=9}}else{f=g;g=(k|0)==(g|0);P=9}do if((P|0)==9){c[d>>2]=d+112;c[d+4>>2]=d+112;c[d+112>>2]=d;c[d+116>>2]=d;z=(k|0)<(f|0);c[e>>2]=(h|0)<(j|0)|(h|0)==(j|0)&z?d:d+112|0;c[e+4>>2]=(h|0)<(j|0)|(h|0)==(j|0)&z?d+112|0:d;if(z|(h|0)<(j|0)&g){c[e+8>>2]=d;c[e+12>>2]=d+112;f=d;d=d+112|0;break}else{c[e+8>>2]=d+112;c[e+12>>2]=d;f=d;d=d+112|0;break}}while(0);z=kE(a,f,d)|0;c[z>>2]=z;c[z+4>>2]=z;c[f+8>>2]=z;z=c[z+8>>2]|0;c[z>>2]=z;c[z+4>>2]=z;c[d+8>>2]=z;i=Q;return}case 1:{d=c[(c[a+92>>2]|0)+(b<<2)>>2]|0;break}default:{f=((d-b|0)/2|0)+b|0;h=c[a+92>>2]|0;g=c[h+(f+-1<<2)>>2]|0;m=c[g+88>>2]|0;l=c[g+92>>2]|0;g=c[g+96>>2]|0;b:do if((f|0)<(d|0)){k=f;do{j=c[h+(k<<2)>>2]|0;if((c[j+88>>2]|0)!=(m|0))break b;if((c[j+92>>2]|0)!=(l|0))break b;if((c[j+96>>2]|0)!=(g|0))break b;k=k+1|0}while((k|0)<(d|0))}else k=f;while(0);lE(a,b,f,e);c[Q+96>>2]=0;c[Q+96+4>>2]=0;c[Q+96+8>>2]=0;c[Q+96+12>>2]=0;lE(a,k,d,Q+96|0);f=c[Q+96+4>>2]|0;do if(f){H=c[e+4>>2]|0;if(!H){c[e>>2]=c[Q+96>>2];c[e+4>>2]=c[Q+96+4>>2];c[e+8>>2]=c[Q+96+8>>2];c[e+12>>2]=c[Q+96+12>>2];break}c[a+100>>2]=(c[a+100>>2]|0)+-1;m=c[e+12>>2]|0;l=c[Q+96+8>>2]|0;g=c[m+88>>2]|0;c:do if((g|0)==(c[l+88>>2]|0)?(c[m+92>>2]|0)==(c[l+92>>2]|0):0){d=c[l+4>>2]|0;if((d|0)==(l|0)){f=c[l+8>>2]|0;if(!f)f=l;else{f=c[f+12>>2]|0;g=c[f+88>>2]|0}L=f;k=m;j=m;h=f;o=g+1|0;d=c[f+96>>2]|0;break}h=c[l>>2]|0;c[d>>2]=h;c[h+4>>2]=d;d:do if((l|0)==(c[Q+96>>2]|0)){k=c[h+88>>2]|0;j=c[d+88>>2]|0;do if((k|0)>=(j|0)){if((k|0)==(j|0)?(c[h+92>>2]|0)<(c[d+92>>2]|0):0)break;c[Q+96>>2]=d;break d}while(0);c[Q+96>>2]=h}while(0);if((l|0)==(f|0)){k=c[h+88>>2]|0;j=c[d+88>>2]|0;do if((k|0)<=(j|0)){if((k|0)==(j|0)?(c[h+92>>2]|0)>(c[d+92>>2]|0):0)break;c[Q+96+4>>2]=d;h=d;P=39;break c}while(0);c[Q+96+4>>2]=h;P=39}else{h=f;P=39}}else{h=f;P=39}while(0);if((P|0)==39){G=c[e>>2]|0;F=c[Q+96>>2]|0;n=0;b=1;o=H;k=0;d=h;M=0;e:while(1)while(1){f=c[d+88>>2]|0;z=c[o+88>>2]|0;q=_(f-z|0,b)|0;f:do if((q|0)<=0){if((q|0)<0){E=(n|0)!=0;u=c[o+92>>2]|0;p=c[d+92>>2]|0;while(1){s=c[(E?d+4|0:d)>>2]|0;z=(s|0)==(d|0);r=d+88|0;while(1){v=o+88|0;t=p-u|0;if(!z?(I=c[s+88>>2]|0,K=_(I-f|0,b)|0,J=c[s+92>>2]|0,L=J-p|0,(L|0)>-1):0){if(!K)break;if((K|0)<0?(_(L,q)|0)<=(_(K,t)|0):0)break}w=c[(E?o+4|0:o)>>2]|0;if((w|0)==(o|0)){p=o;f=d;break f}g=c[w+88>>2]|0;x=_(g-(c[v>>2]|0)|0,b)|0;y=c[w+92>>2]|0;u=y-u|0;f=c[r>>2]|0;v=q;q=_(f-g|0,b)|0;if(!((u|0)>0&(q|0)<0)){p=o;f=d;break f}if(!x){u=y;o=w;continue}if((x|0)>=0){p=o;f=d;break f}if((_(u,v)|0)>=(_(x,t)|0)){p=o;f=d;break f}else{u=y;o=w}}f=I;p=J;q=_(I-(c[v>>2]|0)|0,b)|0;d=s}}f=c[o+92>>2]|0;u=(n|0)!=0;g:do if(u){p=o;while(1){g=c[p>>2]|0;if((g|0)==(o|0))break g;if((c[g+88>>2]|0)!=(z|0))break g;y=f;f=c[g+92>>2]|0;if((f|0)>(y|0))break;else p=g}}else{p=o;while(1){g=c[p+4>>2]|0;if((g|0)==(o|0))break g;if((c[g+88>>2]|0)!=(z|0))break g;y=f;f=c[g+92>>2]|0;if((f|0)>(y|0))break;else p=g}}while(0);g=c[d+92>>2]|0;if(u){f=d;while(1){o=c[f+4>>2]|0;if((o|0)==(d|0))break f;if((c[o+88>>2]|0)!=(z|0))break f;y=g;g=c[o+92>>2]|0;if((g|0)<(y|0))break;else f=o}}else{f=d;while(1){o=c[f>>2]|0;if((o|0)==(d|0))break f;if((c[o+88>>2]|0)!=(z|0))break f;y=g;g=c[o+92>>2]|0;if((g|0)<(y|0))break;else f=o}}}else{A=(n|0)!=0;B=c[d+92>>2]|0;D=q;while(1){E=d+88|0;u=o+88|0;q=c[o+92>>2]|0;v=B-q|0;r=c[(A?o:o+4|0)>>2]|0;h:do if((r|0)==(o|0))t=D;else{y=c[o+88>>2]|0;x=r;t=D;z=u;while(1){u=y;y=c[x+88>>2]|0;u=_(y-u|0,b)|0;s=q;q=c[x+92>>2]|0;s=q-s|0;if((s|0)>=1){u=z;break h}if(u){if((u|0)>=0){u=z;break h}if((_(s,t)|0)>(_(u,v)|0)){u=z;break h}}t=_((c[E>>2]|0)-y|0,b)|0;u=x+88|0;v=B-q|0;r=c[(A?x:x+4|0)>>2]|0;if((r|0)==(x|0)){o=x;break}else{o=x;x=r;z=u}}}while(0);s=c[(A?d:d+4|0)>>2]|0;if((s|0)==(d|0)){p=o;f=d;break f}D=c[s+88>>2]|0;q=_(D-(c[E>>2]|0)|0,b)|0;p=B;B=c[s+92>>2]|0;p=B-p|0;D=_(D-(c[u>>2]|0)|0,b)|0;if(!((p|0)<0&(D|0)>0)){p=o;f=d;break f}if(!q){d=s;continue}if((q|0)>=0){p=o;f=d;break f}if((_(p,t)|0)>=(_(q,v)|0)){p=o;f=d;break}else d=s}}while(0);if(!n){n=1;b=-1;o=G;k=p;d=F;M=f;continue e}n=n+1|0;if((n|0)==2)break e;else{o=p;d=f}}c[p+4>>2]=f;c[f>>2]=p;c[k>>2]=M;c[M+4>>2]=k;if((c[F+88>>2]|0)<(c[G+88>>2]|0))c[e>>2]=F;if((c[h+88>>2]|0)>=(c[H+88>>2]|0))c[e+4>>2]=h;c[e+12>>2]=c[Q+96+12>>2];j=k;h=M;b=c[M+88>>2]|0;v=c[k+88>>2]|0;n=c[M+92>>2]|0;A=c[k+92>>2]|0;B=c[M+96>>2]|0;f=c[k+96>>2]|0;D=((n-A|0)<0)<<31>>31;E=0-(b-v)|0;z=pF(0,0,E|0,((E|0)<0)<<31>>31|0)|0;z=CF(B-f|0,((B-f|0)<0)<<31>>31|0,z|0,C|0)|0;y=C;x=CF(B-f|0,((B-f|0)<0)<<31>>31|0,n-A|0,D|0)|0;w=C;q=CF(b-v|0,((b-v|0)<0)<<31>>31|0,E|0,((E|0)<0)<<31>>31|0)|0;m=C;l=CF(n-A|0,D|0,n-A|0,D|0)|0;l=pF(q|0,m|0,l|0,C|0)|0;m=C;q=c[k+8>>2]|0;c[Q+140>>2]=0;if(!q)p=0;else{o=pF(0,0,n-A|0,D|0)|0;d=C;p=0;g=q;do{s=c[g+12>>2]|0;u=c[s+88>>2]|0;t=c[s+92>>2]|0;s=c[s+96>>2]|0;G=CF(t-A|0,((t-A|0)<0)<<31>>31|0,E|0,((E|0)<0)<<31>>31|0)|0;r=C;F=CF(u-v|0,((u-v|0)<0)<<31>>31|0,o|0,d|0)|0;i:do if((G|0)==(F|0)&(r|0)==(C|0)?(F=CF(u-v|0,((u-v|0)<0)<<31>>31|0,z|0,y|0)|0,G=C,r=CF(t-A|0,((t-A|0)<0)<<31>>31|0,x|0,w|0)|0,G=sF(r|0,C|0,F|0,G|0)|0,F=C,r=CF(s-f|0,((s-f|0)<0)<<31>>31|0,l|0,m|0)|0,r=sF(G|0,F|0,r|0,C|0)|0,F=C,(F|0)>0|(F|0)==0&r>>>0>0):0){do if(p){r=(c[p+4>>2]|0)==(g|0);if((c[p>>2]|0)!=(g|0))if(r)break;else break i;if(!r)break i;F=c[p+12>>2]|0;G=c[(c[g+8>>2]|0)+12>>2]|0;r=c[G+88>>2]|0;I=c[G+92>>2]|0;G=c[G+96>>2]|0;H=(c[F+96>>2]|0)-G|0;t=(_(s-G|0,(c[F+92>>2]|0)-I|0)|0)-(_(H,t-I|0)|0)|0;u=(_(H,u-r|0)|0)-(_(s-G|0,(c[F+88>>2]|0)-r|0)|0)|0;s=CF(t|0,((t|0)<0)<<31>>31|0,n-A|0,D|0)|0;t=C;u=CF(u|0,((u|0)<0)<<31>>31|0,E|0,((E|0)<0)<<31>>31|0)|0;u=sF(s|0,t|0,u|0,C|0)|0;t=C;if((t|0)>0|(t|0)==0&u>>>0>0)break i}while(0);c[Q+140>>2]=g;p=g}while(0);g=c[g>>2]|0}while((g|0)!=(q|0))}t=c[M+8>>2]|0;c[Q+136>>2]=0;if(!t)g=0;else{s=pF(0,0,n-A|0,D|0)|0;r=C;g=0;f=t;do{d=c[f+12>>2]|0;q=c[d+88>>2]|0;o=c[d+92>>2]|0;d=c[d+96>>2]|0;F=CF(o-n|0,((o-n|0)<0)<<31>>31|0,E|0,((E|0)<0)<<31>>31|0)|0;v=C;u=CF(q-b|0,((q-b|0)<0)<<31>>31|0,s|0,r|0)|0;do if((F|0)==(u|0)&(v|0)==(C|0)?(u=CF(q-b|0,((q-b|0)<0)<<31>>31|0,z|0,y|0)|0,F=C,v=CF(o-n|0,((o-n|0)<0)<<31>>31|0,x|0,w|0)|0,F=sF(v|0,C|0,u|0,F|0)|0,u=C,v=CF(d-B|0,((d-B|0)<0)<<31>>31|0,l|0,m|0)|0,v=sF(F|0,u|0,v|0,C|0)|0,u=C,(u|0)>0|(u|0)==0&v>>>0>0):0){if(g){if((c[g>>2]|0)!=(f|0))break;if((c[g+4>>2]|0)==(f|0)?(F=c[g+12>>2]|0,G=c[(c[f+8>>2]|0)+12>>2]|0,v=c[G+88>>2]|0,u=c[G+92>>2]|0,G=c[G+96>>2]|0,H=(c[F+96>>2]|0)-G|0,u=(_(d-G|0,(c[F+92>>2]|0)-u|0)|0)-(_(H,o-u|0)|0)|0,v=(_(H,q-v|0)|0)-(_(d-G|0,(c[F+88>>2]|0)-v|0)|0)|0,q=CF(u|0,((u|0)<0)<<31>>31|0,n-A|0,D|0)|0,u=C,v=CF(v|0,((v|0)<0)<<31>>31|0,E|0,((E|0)<0)<<31>>31|0)|0,v=sF(q|0,u|0,v|0,C|0)|0,u=C,!((u|0)>0|(u|0)==0&v>>>0>0)):0)break}c[Q+136>>2]=f;g=f}while(0);f=c[f>>2]|0}while((f|0)!=(t|0))}if((p|0)!=0|(g|0)!=0){nE(a,k,M,Q+140|0,Q+136|0);f=c[Q+140>>2]|0;if(f){j=c[f+12>>2]|0;k=j}f=c[Q+136>>2]|0;if(!f)g=M;else{h=c[f+12>>2]|0;g=h}}else g=M;L=g;o=c[g+88>>2]|0;d=(c[g+96>>2]|0)+1|0}t=c[L+92>>2]|0;A=L;n=k;y=t;g=0;l=0;D=1;f=0;m=0;B=0;F=0;s=d;d=0;b=0;while(1){E=n+88|0;w=(c[A+88>>2]|0)-(c[E>>2]|0)|0;z=n+92|0;G=y-(c[z>>2]|0)|0;v=n+96|0;r=(c[A+96>>2]|0)-(c[v>>2]|0)|0;c[Q+120>>2]=w;c[Q+120+4>>2]=G;c[Q+120+8>>2]=r;c[Q+120+12>>2]=-1;E=o-(c[E>>2]|0)|0;z=t-(c[z>>2]|0)|0;v=s-(c[v>>2]|0)|0;u=(_(r,z)|0)-(_(G,v)|0)|0;v=(_(w,v)|0)-(_(r,E)|0)|0;z=(_(G,E)|0)-(_(w,z)|0)|0;c[Q+72>>2]=u;c[Q+72+4>>2]=((u|0)<0)<<31>>31;c[Q+72+8>>2]=v;c[Q+72+8+4>>2]=((v|0)<0)<<31>>31;c[Q+72+16>>2]=z;c[Q+72+16+4>>2]=((z|0)<0)<<31>>31;E=CF(z|0,((z|0)<0)<<31>>31|0,G|0,((G|0)<0)<<31>>31|0)|0;y=C;x=CF(r|0,((r|0)<0)<<31>>31|0,v|0,((v|0)<0)<<31>>31|0)|0;x=pF(E|0,y|0,x|0,C|0)|0;y=C;r=CF(u|0,((u|0)<0)<<31>>31|0,r|0,((r|0)<0)<<31>>31|0)|0;E=C;z=CF(w|0,((w|0)<0)<<31>>31|0,z|0,((z|0)<0)<<31>>31|0)|0;z=pF(r|0,E|0,z|0,C|0)|0;E=C;v=CF(w|0,((w|0)<0)<<31>>31|0,v|0,((v|0)<0)<<31>>31|0)|0;w=C;G=CF(u|0,((u|0)<0)<<31>>31|0,G|0,((G|0)<0)<<31>>31|0)|0;G=pF(v|0,w|0,G|0,C|0)|0;c[Q+48>>2]=x;c[Q+48+4>>2]=y;c[Q+48+8>>2]=z;c[Q+48+8+4>>2]=E;c[Q+48+16>>2]=G;c[Q+48+16+4>>2]=C;c[Q+24>>2]=0;c[Q+24+4>>2]=0;c[Q+24+8>>2]=0;c[Q+24+12>>2]=0;c[Q+24+16>>2]=0;G=mE(a,0,n,Q+120|0,Q+72|0,Q+48|0,Q+24|0)|0;c[Q>>2]=0;c[Q+4>>2]=0;c[Q+8>>2]=0;c[Q+12>>2]=0;c[Q+16>>2]=0;E=mE(a,1,A,Q+120|0,Q+72|0,Q+48|0,Q)|0;if(!((G|0)!=0|(E|0)!=0)){P=119;break}p=(G|0)!=0?-1:1;do if((G|0)!=0&(E|0)!=0){z=c[Q+24+16>>2]|0;p=c[Q+16>>2]|0;if((z|0)!=(p|0)){p=z-p|0;break}if(!z)p=0;else{H=c[Q+24>>2]|0;x=c[Q+24+4>>2]|0;r=c[Q+8>>2]|0;J=c[Q+8+4>>2]|0;u=CF(r|0,0,H|0,0)|0;v=C;H=CF(J|0,0,H|0,0)|0;I=C;r=CF(r|0,0,x|0,0)|0;q=C;x=CF(J|0,0,x|0,0)|0;J=C;r=sF(H|0,0,r|0,0)|0;H=C;J=sF(I|0,0,x|0,J|0)|0;q=sF(J|0,C|0,q|0,0)|0;H=sF(q|0,C|0,H|0,0)|0;q=C;v=sF(0,r|0,u|0,v|0)|0;u=C;r=sF(H|0,q|0,(u>>>0<r>>>0|(u|0)==(r|0)&v>>>0<0)&1|0,0)|0;q=C;H=c[Q+24+8>>2]|0;J=c[Q+24+8+4>>2]|0;x=c[Q>>2]|0;I=c[Q+4>>2]|0;w=CF(x|0,0,H|0,0)|0;p=C;H=CF(I|0,0,H|0,0)|0;K=C;x=CF(x|0,0,J|0,0)|0;y=C;J=CF(I|0,0,J|0,0)|0;I=C;x=sF(H|0,0,x|0,0)|0;H=C;I=sF(K|0,0,J|0,I|0)|0;y=sF(I|0,C|0,y|0,0)|0;H=sF(y|0,C|0,H|0,0)|0;y=C;p=sF(0,x|0,w|0,p|0)|0;w=C;x=sF(H|0,y|0,(w>>>0<x>>>0|(w|0)==(x|0)&p>>>0<0)&1|0,0)|0;y=C;if(!(q>>>0<y>>>0|(q|0)==(y|0)&r>>>0<x>>>0))if(!(q>>>0>y>>>0|(q|0)==(y|0)&r>>>0>x>>>0))if(u>>>0<w>>>0|(u|0)==(w|0)&v>>>0<p>>>0)p=-1;else p=(u>>>0>w>>>0|(u|0)==(w|0)&v>>>0>p>>>0)&1;else p=1;else p=-1;p=_(p,z)|0}}while(0);do if(!D){if((p|0)>-1)if((c[Q+16>>2]|0)<0&((c[Q+8>>2]|0)==0?(c[Q+8+4>>2]|0)==0:0)){q=B;z=F;P=139;break}else{P=134;break}if((c[Q+24+16>>2]|0)<0&((c[Q+24+8>>2]|0)==0?(c[Q+24+8+4>>2]|0)==0:0)){c[Q+116>>2]=G;c[Q+112>>2]=E;v=m;q=B}else P=134}else P=134;while(0);if((P|0)==134){q=kE(a,n,A)|0;if(!B)f=q;else c[B+4>>2]=q;c[q>>2]=B;n=c[q+8>>2]|0;if(!F)m=n;else c[F>>2]=n;c[n+4>>2]=F;z=n;P=139}if((P|0)==139){P=0;c[Q+116>>2]=G;c[Q+112>>2]=E;if(!p){nE(a,j,h,Q+116|0,Q+112|0);v=c[Q+112>>2]|0}else v=E;if((p|0)>-1&(v|0)!=0){u=(b|0)!=0;if(u?(N=c[b>>2]|0,(N|0)!=(E|0)):0){s=N;do{t=s;s=c[s>>2]|0;r=c[t+8>>2]|0;n=c[r+12>>2]|0;if((s|0)==(t|0))o=0;else{c[s+4>>2]=c[t+4>>2];c[c[t+4>>2]>>2]=s;o=s}c[n+8>>2]=o;o=c[r>>2]|0;n=c[t+12>>2]|0;if((o|0)==(r|0))o=0;else{c[o+4>>2]=c[r+4>>2];c[c[r+4>>2]>>2]=o}c[n+8>>2]=o;c[t>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;c[t+12>>2]=0;c[t+16>>2]=0;c[t>>2]=c[a+56>>2];c[a+56>>2]=t;c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[r+12>>2]=0;c[r+16>>2]=0;c[r>>2]=c[a+56>>2];c[a+56>>2]=r;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((s|0)!=(E|0))}if(!z){r=v;l=u?l:E}else{if(u){c[b>>2]=m;n=E+4|0}else{b=c[E+4>>2]|0;c[b>>2]=m;l=m;n=E+4|0}c[m+4>>2]=b;c[z>>2]=E;c[n>>2]=z;r=c[Q+112>>2]|0;m=0}s=h;h=c[r+12>>2]|0;v=m;F=0;o=c[s+88>>2]|0;t=c[s+92>>2]|0;s=c[s+96>>2]|0;b=c[r+8>>2]|0}else{v=m;F=z}}y=c[Q+116>>2]|0;if((p|0)<1&(y|0)!=0){u=(d|0)!=0;if(u?(O=c[d+4>>2]|0,(O|0)!=(G|0)):0){t=O;do{p=t+4|0;s=t;t=c[p>>2]|0;o=c[s>>2]|0;r=c[s+8>>2]|0;m=c[r+12>>2]|0;if((o|0)==(s|0))o=0;else{c[o+4>>2]=t;c[c[p>>2]>>2]=o}c[m+8>>2]=o;o=c[r>>2]|0;p=c[s+12>>2]|0;if((o|0)==(r|0))o=0;else{c[o+4>>2]=c[r+4>>2];c[c[r+4>>2]>>2]=o}c[p+8>>2]=o;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[s+16>>2]=0;c[s>>2]=c[a+56>>2];c[a+56>>2]=s;c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[r+12>>2]=0;c[r+16>>2]=0;c[r>>2]=c[a+56>>2];c[a+56>>2]=r;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((t|0)!=(G|0))}if(!q){p=y;g=u?g:G}else{if(u){c[d+4>>2]=f;m=G}else{d=c[G>>2]|0;c[d+4>>2]=f;g=f;m=G}c[f>>2]=d;c[m>>2]=q;c[q+4>>2]=G;p=c[Q+116>>2]|0;f=0}s=j;j=c[p+12>>2]|0;q=0;z=c[s+88>>2]|0;t=c[s+92>>2]|0;s=c[s+96>>2]|0;E=c[p+8>>2]|0}else{z=o;E=d}n=j;o=h;if((n|0)==(k|0)&(o|0)==(L|0))break;A=o;y=c[o+92>>2]|0;D=0;m=v;B=q;o=z;d=E}if((P|0)==119){z=kE(a,n,A)|0;c[z>>2]=z;c[z+4>>2]=z;c[n+8>>2]=z;z=c[z+8>>2]|0;c[z>>2]=z;c[z+4>>2]=z;c[h+8>>2]=z;break}if(E){o=E+4|0;k=c[o>>2]|0;if((k|0)!=(g|0))do{h=k+4|0;n=k;k=c[h>>2]|0;j=c[n>>2]|0;m=c[n+8>>2]|0;d=c[m+12>>2]|0;if((j|0)==(n|0))j=0;else{c[j+4>>2]=k;c[c[h>>2]>>2]=j}c[d+8>>2]=j;j=c[m>>2]|0;h=c[n+12>>2]|0;if((j|0)==(m|0))j=0;else{c[j+4>>2]=c[m+4>>2];c[c[m+4>>2]>>2]=j}c[h+8>>2]=j;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n>>2]=c[a+56>>2];c[a+56>>2]=n;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[m+16>>2]=0;c[m>>2]=c[a+56>>2];c[a+56>>2]=m;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((k|0)!=(g|0));if(q){c[f>>2]=E;c[o>>2]=f;c[g>>2]=q;c[q+4>>2]=g}}else{c[f>>2]=q;c[q+4>>2]=f;c[j+8>>2]=q}if(!b){c[F>>2]=v;c[v+4>>2]=F;c[L+8>>2]=F;break}f=c[b>>2]|0;if((f|0)!=(l|0))do{h=f;f=c[f>>2]|0;j=c[h+8>>2]|0;d=c[j+12>>2]|0;if((f|0)==(h|0))g=0;else{c[f+4>>2]=c[h+4>>2];c[c[h+4>>2]>>2]=f;g=f}c[d+8>>2]=g;g=c[j>>2]|0;k=c[h+12>>2]|0;if((g|0)==(j|0))g=0;else{c[g+4>>2]=c[j+4>>2];c[c[j+4>>2]>>2]=g}c[k+8>>2]=g;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[h>>2]=c[a+56>>2];c[a+56>>2]=h;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j>>2]=c[a+56>>2];c[a+56>>2]=j;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((f|0)!=(l|0));if(F){c[b>>2]=v;c[v+4>>2]=b;c[F>>2]=l;c[l+4>>2]=F}}while(0);i=Q;return}}while(0);c[d+8>>2]=0;c[d>>2]=d;c[d+4>>2]=d;c[e>>2]=d;c[e+4>>2]=d;c[e+8>>2]=d;c[e+12>>2]=d;i=Q;return}function mE(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0;i=c[d+8>>2]|0;if(!i){b=0;return b|0}D=i;i=0;do{a:do if((c[D+20>>2]|0)>(c[a+100>>2]|0)){w=c[D+12>>2]|0;x=c[w+88>>2]|0;z=x-(c[d+88>>2]|0)|0;y=c[w+92>>2]|0;A=y-(c[d+92>>2]|0)|0;w=c[w+96>>2]|0;B=w-(c[d+96>>2]|0)|0;k=CF(z|0,((z|0)<0)<<31>>31|0,c[g>>2]|0,c[g+4>>2]|0)|0;u=C;j=CF(A|0,((A|0)<0)<<31>>31|0,c[g+8>>2]|0,c[g+8+4>>2]|0)|0;u=sF(j|0,C|0,k|0,u|0)|0;k=C;j=CF(B|0,((B|0)<0)<<31>>31|0,c[g+16>>2]|0,c[g+16+4>>2]|0)|0;j=sF(u|0,k|0,j|0,C|0)|0;k=C;u=CF(c[f>>2]|0,c[f+4>>2]|0,z|0,((z|0)<0)<<31>>31|0)|0;v=C;l=CF(c[f+8>>2]|0,c[f+8+4>>2]|0,A|0,((A|0)<0)<<31>>31|0)|0;v=sF(l|0,C|0,u|0,v|0)|0;u=C;l=CF(c[f+16>>2]|0,c[f+16+4>>2]|0,B|0,((B|0)<0)<<31>>31|0)|0;l=sF(v|0,u|0,l|0,C|0)|0;u=C;if((k|0)>0|(k|0)==0&j>>>0>0){v=k;n=1;o=1}else{j=pF(0,0,j|0,k|0)|0;j=(k|0)<0?j:0;v=(k|0)<0?C:0;n=(k|0)<0?-1:0;o=(k|0)<0?-1:0}if(!((u|0)>0|(u|0)==0&l>>>0>0)){p=0-n|0;k=pF(0,0,l|0,u|0)|0;k=(u|0)<0?k:0;m=(u|0)<0?C:0;if((((u|0)<0?p:n)|0)==0&((k|0)==0&(m|0)==0))break;else{l=k;o=(u|0)<0?p:o}}else m=u;if(!i){c[h>>2]=j;c[h+4>>2]=v;c[h+8>>2]=l;c[h+8+4>>2]=m;c[h+16>>2]=o;i=D;break}k=c[h+16>>2]|0;if((o|0)==(k|0)){if(o){k=c[h+8>>2]|0;s=c[h+8+4>>2]|0;n=CF(k|0,0,j|0,0)|0;p=C;t=CF(s|0,0,j|0,0)|0;r=C;k=CF(k|0,0,v|0,0)|0;q=C;s=CF(s|0,0,v|0,0)|0;G=C;k=sF(t|0,0,k|0,0)|0;t=C;G=sF(r|0,0,s|0,G|0)|0;q=sF(G|0,C|0,q|0,0)|0;t=sF(q|0,C|0,t|0,0)|0;q=C;p=sF(0,k|0,n|0,p|0)|0;n=C;k=sF(t|0,q|0,(n>>>0<k>>>0|(n|0)==(k|0)&p>>>0<0)&1|0,0)|0;q=C;t=c[h>>2]|0;G=c[h+4>>2]|0;s=CF(t|0,0,l|0,0)|0;r=C;E=CF(G|0,0,l|0,0)|0;H=C;t=CF(t|0,0,m|0,0)|0;u=C;G=CF(G|0,0,m|0,0)|0;F=C;t=sF(E|0,0,t|0,0)|0;E=C;F=sF(H|0,0,G|0,F|0)|0;u=sF(F|0,C|0,u|0,0)|0;E=sF(u|0,C|0,E|0,0)|0;u=C;r=sF(0,t|0,s|0,r|0)|0;s=C;t=sF(E|0,u|0,(s>>>0<t>>>0|(s|0)==(t|0)&r>>>0<0)&1|0,0)|0;u=C;if(!(q>>>0<u>>>0|(q|0)==(u|0)&k>>>0<t>>>0))if(!(q>>>0>u>>>0|(q|0)==(u|0)&k>>>0>t>>>0))if(n>>>0<s>>>0|(n|0)==(s|0)&p>>>0<r>>>0)k=-1;else k=(n>>>0>s>>>0|(n|0)==(s|0)&p>>>0>r>>>0)&1;else k=1;else k=-1;k=_(k,o)|0;t=18}}else{k=o-k|0;t=18}do if((t|0)==18){t=0;if((k|0)>=0)if(!k)break;else break a;else{c[h>>2]=j;c[h+4>>2]=v;c[h+8>>2]=l;c[h+8+4>>2]=m;c[h+16>>2]=o;i=D;break a}}while(0);j=(c[i+4>>2]|0)==(D|0);if((c[i>>2]|0)==(D|0))if(j){s=c[e+8>>2]|0;v=_(s,A)|0;j=c[e+4>>2]|0;v=v-(_(j,B)|0)|0;m=c[e>>2]|0;B=(_(m,B)|0)-(_(z,s)|0)|0;A=(_(z,j)|0)-(_(m,A)|0)|0;m=c[i+12>>2]|0;j=c[(c[D+8>>2]|0)+12>>2]|0;s=c[j+88>>2]|0;k=(c[m+88>>2]|0)-s|0;l=c[j+92>>2]|0;u=(c[m+92>>2]|0)-l|0;j=c[j+96>>2]|0;m=(c[m+96>>2]|0)-j|0;z=(_(w-j|0,u)|0)-(_(y-l|0,m)|0)|0;j=(_(x-s|0,m)|0)-(_(w-j|0,k)|0)|0;x=(_(y-l|0,k)|0)-(_(x-s|0,u)|0)|0;y=CF(z|0,((z|0)<0)<<31>>31|0,v|0,((v|0)<0)<<31>>31|0)|0;z=C;B=CF(j|0,((j|0)<0)<<31>>31|0,B|0,((B|0)<0)<<31>>31|0)|0;j=C;A=CF(x|0,((x|0)<0)<<31>>31|0,A|0,((A|0)<0)<<31>>31|0)|0;A=sF(y|0,z|0,A|0,C|0)|0;j=sF(A|0,C|0,B|0,j|0)|0;B=C;j=(B|0)>0|(B|0)==0&j>>>0>0?2:1}else j=2;else j=j&1;i=(j|0)==2^b?i:D}while(0);D=c[D>>2]|0}while((D|0)!=(c[d+8>>2]|0));return i|0}function nE(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0;S=c[e>>2]|0;ea=c[f>>2]|0;if(S)g=c[S+12>>2]|0;else g=b;i=c[g+88>>2]|0;l=c[g+92>>2]|0;m=c[g+96>>2]|0;if(!ea)g=d;else g=c[ea+12>>2]|0;A=c[g+88>>2]|0;n=c[g+92>>2]|0;H=c[g+96>>2]|0;U=c[b+88>>2]|0;ca=(c[d+88>>2]|0)-U|0;F=c[b+92>>2]|0;da=(c[d+92>>2]|0)-F|0;b=c[b+96>>2]|0;ba=(c[d+96>>2]|0)-b|0;aa=c[((S|0)!=0?S:ea)+12>>2]|0;V=(c[aa+88>>2]|0)-U|0;R=(c[aa+92>>2]|0)-F|0;aa=(c[aa+96>>2]|0)-b|0;$=(_(R,ba)|0)-(_(aa,da)|0)|0;aa=(_(aa,ca)|0)-(_(V,ba)|0)|0;R=(_(V,da)|0)-(_(R,ca)|0)|0;U=CF($|0,(($|0)<0)<<31>>31|0,U|0,((U|0)<0)<<31>>31|0)|0;V=C;F=CF(aa|0,((aa|0)<0)<<31>>31|0,F|0,((F|0)<0)<<31>>31|0)|0;G=C;b=CF(R|0,((R|0)<0)<<31>>31|0,b|0,((b|0)<0)<<31>>31|0)|0;b=sF(U|0,V|0,b|0,C|0)|0;G=sF(b|0,C|0,F|0,G|0)|0;F=C;b=CF(R|0,((R|0)<0)<<31>>31|0,da|0,((da|0)<0)<<31>>31|0)|0;V=C;U=CF(aa|0,((aa|0)<0)<<31>>31|0,ba|0,((ba|0)<0)<<31>>31|0)|0;U=pF(b|0,V|0,U|0,C|0)|0;V=C;b=CF($|0,(($|0)<0)<<31>>31|0,ba|0,((ba|0)<0)<<31>>31|0)|0;X=C;W=CF(R|0,((R|0)<0)<<31>>31|0,ca|0,((ca|0)<0)<<31>>31|0)|0;W=pF(b|0,X|0,W|0,C|0)|0;X=C;b=CF(aa|0,((aa|0)<0)<<31>>31|0,ca|0,((ca|0)<0)<<31>>31|0)|0;Z=C;Y=CF($|0,(($|0)<0)<<31>>31|0,da|0,((da|0)<0)<<31>>31|0)|0;Y=pF(b|0,Z|0,Y|0,C|0)|0;Z=C;b=CF(U|0,V|0,i|0,((i|0)<0)<<31>>31|0)|0;Q=C;d=CF(W|0,X|0,l|0,((l|0)<0)<<31>>31|0)|0;Q=sF(d|0,C|0,b|0,Q|0)|0;b=C;d=CF(Y|0,Z|0,m|0,((m|0)<0)<<31>>31|0)|0;d=sF(Q|0,b|0,d|0,C|0)|0;b=C;if((S|0)!=0?(c[S+12>>2]|0)!=0:0){p=S;q=i;o=l;while(1){p=c[(c[p+8>>2]|0)+4>>2]|0;l=p+12|0;i=c[l>>2]|0;h=c[i+88>>2]|0;P=CF(h|0,((h|0)<0)<<31>>31|0,$|0,(($|0)<0)<<31>>31|0)|0;O=C;g=c[i+92>>2]|0;Q=CF(g|0,((g|0)<0)<<31>>31|0,aa|0,((aa|0)<0)<<31>>31|0)|0;O=sF(Q|0,C|0,P|0,O|0)|0;P=C;i=c[i+96>>2]|0;Q=CF(i|0,((i|0)<0)<<31>>31|0,R|0,((R|0)<0)<<31>>31|0)|0;Q=sF(O|0,P|0,Q|0,C|0)|0;P=C;if((P|0)<(F|0)|(P|0)==(F|0)&Q>>>0<G>>>0){i=q;g=o;h=m;break}if((c[p+20>>2]|0)==(c[a+100>>2]|0)){i=q;g=o;h=m;break}k=CF(h|0,((h|0)<0)<<31>>31|0,U|0,V|0)|0;Q=C;j=CF(g|0,((g|0)<0)<<31>>31|0,W|0,X|0)|0;Q=sF(j|0,C|0,k|0,Q|0)|0;k=C;j=CF(i|0,((i|0)<0)<<31>>31|0,Y|0,Z|0)|0;j=sF(Q|0,k|0,j|0,C|0)|0;k=C;if(!((k|0)>(b|0)|(k|0)==(b|0)&j>>>0>d>>>0)){i=q;g=o;h=m;break}c[e>>2]=p;Q=c[l>>2]|0;i=c[Q+88>>2]|0;g=c[Q+92>>2]|0;h=c[Q+96>>2]|0;if(!Q){d=j;b=k;break}else{b=k;d=j;q=i;o=g;m=h}}q=c[f>>2]|0;I=g;m=h}else{q=ea;I=l}g=CF(U|0,V|0,A|0,((A|0)<0)<<31>>31|0)|0;Q=C;h=CF(W|0,X|0,n|0,((n|0)<0)<<31>>31|0)|0;Q=sF(h|0,C|0,g|0,Q|0)|0;g=C;h=CF(Y|0,Z|0,H|0,((H|0)<0)<<31>>31|0)|0;h=sF(Q|0,g|0,h|0,C|0)|0;g=C;a:do if(q)if(!(c[q+12>>2]|0)){Q=q;k=A}else{r=q;o=A;q=H;while(1){p=c[c[r+8>>2]>>2]|0;l=c[p+12>>2]|0;j=c[l+88>>2]|0;P=CF(j|0,((j|0)<0)<<31>>31|0,$|0,(($|0)<0)<<31>>31|0)|0;O=C;k=c[l+92>>2]|0;Q=CF(k|0,((k|0)<0)<<31>>31|0,aa|0,((aa|0)<0)<<31>>31|0)|0;O=sF(Q|0,C|0,P|0,O|0)|0;P=C;l=c[l+96>>2]|0;Q=CF(l|0,((l|0)<0)<<31>>31|0,R|0,((R|0)<0)<<31>>31|0)|0;Q=sF(O|0,P|0,Q|0,C|0)|0;P=C;if((P|0)<(F|0)|(P|0)==(F|0)&Q>>>0<G>>>0){Q=r;k=o;H=q;break a}if((c[p+20>>2]|0)==(c[a+100>>2]|0)){Q=r;k=o;H=q;break a}j=CF(j|0,((j|0)<0)<<31>>31|0,U|0,V|0)|0;Q=C;P=CF(k|0,((k|0)<0)<<31>>31|0,W|0,X|0)|0;Q=sF(P|0,C|0,j|0,Q|0)|0;j=C;l=CF(l|0,((l|0)<0)<<31>>31|0,Y|0,Z|0)|0;l=sF(Q|0,j|0,l|0,C|0)|0;j=C;if(!((j|0)>(g|0)|(j|0)==(g|0)&l>>>0>h>>>0)){Q=r;k=o;H=q;break a}c[f>>2]=p;Q=c[p+12>>2]|0;k=c[Q+88>>2]|0;n=c[Q+92>>2]|0;q=c[Q+96>>2]|0;if(!Q){h=l;g=j;Q=p;H=q;break}else{r=p;g=j;h=l;o=k}}}else{Q=0;k=A}while(0);h=pF(h|0,g|0,d|0,b|0)|0;P=C;if((P|0)>0|(P|0)==0&h>>>0>0){K=pF(0,0,R|0,((R|0)<0)<<31>>31|0)|0;L=C;b=h;g=P;M=i;N=I;O=m;q=k;p=n;o=H;b:while(1){J=b;c:while(1){A=(_(p-N|0,da)|0)+(_(o-O|0,ba)|0)+(_(q-M|0,ca)|0)|0;E=c[e>>2]|0;do if(((E|0)!=0?(c[E+12>>2]|0)!=0:0)?(T=c[(c[E>>2]|0)+8>>2]|0,(c[T+20>>2]|0)>(c[a+100>>2]|0)):0){B=c[T+12>>2]|0;G=c[B+88>>2]|0;D=G-M|0;F=c[B+92>>2]|0;l=F-N|0;B=c[B+96>>2]|0;r=B-O|0;b=CF(D|0,((D|0)<0)<<31>>31|0,U|0,V|0)|0;j=C;s=CF(l|0,((l|0)<0)<<31>>31|0,W|0,X|0)|0;j=sF(s|0,C|0,b|0,j|0)|0;b=C;s=CF(r|0,((r|0)<0)<<31>>31|0,Y|0,Z|0)|0;s=sF(j|0,b|0,s|0,C|0)|0;b=C;r=(_(l,da)|0)+(_(D,ca)|0)+(_(r,ba)|0)|0;if((s|0)==0&(b|0)==0)if((r|0)<0)break c;else break;if((b|0)<0){if((r|0)>0){x=1;d=r;t=((r|0)<0)<<31>>31}else{d=pF(0,0,r|0,((r|0)<0)<<31>>31|0)|0;x=r>>31;d=(r|0)<0?d:0;t=(r|0)<0?C:0}D=0-x|0;j=pF(0,0,s|0,b|0)|0;l=C;if((A|0)>0){w=1;y=A;z=((A|0)<0)<<31>>31}else{y=pF(0,0,A|0,((A|0)<0)<<31>>31|0)|0;w=A>>31;y=(A|0)<0?y:0;z=(A|0)<0?C:0}if(!((g|0)>0|(g|0)==0&J>>>0>0))if((g|0)<0){v=pF(0,0,J|0,g|0)|0;u=C;w=0-w|0}else{v=0;u=0}else{v=J;u=g}if((w|0)==(D|0)){if(!x)break c;r=CF(v|0,0,d|0,0)|0;s=C;x=CF(u|0,0,d|0,0)|0;fa=C;b=CF(v|0,0,t|0,0)|0;d=C;ga=CF(u|0,0,t|0,0)|0;w=C;b=sF(x|0,0,b|0,0)|0;v=C;w=sF(fa|0,0,ga|0,w|0)|0;d=sF(w|0,C|0,d|0,0)|0;v=sF(d|0,C|0,v|0,0)|0;d=C;s=sF(0,b|0,r|0,s|0)|0;r=C;b=sF(v|0,d|0,(r>>>0<b>>>0|(r|0)==(b|0)&s>>>0<0)&1|0,0)|0;d=C;v=CF(y|0,0,j|0,0)|0;w=C;ga=CF(z|0,0,j|0,0)|0;fa=C;u=CF(y|0,0,l|0,0)|0;t=C;x=CF(z|0,0,l|0,0)|0;j=C;u=sF(ga|0,0,u|0,0)|0;l=C;j=sF(fa|0,0,x|0,j|0)|0;t=sF(j|0,C|0,t|0,0)|0;l=sF(t|0,C|0,l|0,0)|0;t=C;w=sF(0,u|0,v|0,w|0)|0;v=C;u=sF(l|0,t|0,(v>>>0<u>>>0|(v|0)==(u|0)&w>>>0<0)&1|0,0)|0;t=C;do if(d>>>0<t>>>0|(d|0)==(t|0)&b>>>0<u>>>0)b=-1;else{if(d>>>0>t>>>0|(d|0)==(t|0)&b>>>0>u>>>0){b=1;break}if(r>>>0<v>>>0|(r|0)==(v|0)&s>>>0<w>>>0){b=-1;break}b=(r>>>0>v>>>0|(r|0)==(v|0)&s>>>0>w>>>0)&1}while(0);b=_(b,D)|0}else b=D-w|0;if((b|0)>-1)break c}}while(0);l=c[f>>2]|0;if(!l){d=121;break b}if(!(c[l+12>>2]|0)){d=121;break b}G=c[c[l+8>>2]>>2]|0;if((c[G+20>>2]|0)<=(c[a+100>>2]|0)){d=121;break b}b=c[G+12>>2]|0;j=c[b+88>>2]|0;r=j-q|0;d=c[b+92>>2]|0;p=d-p|0;b=c[b+96>>2]|0;q=b-o|0;F=CF(r|0,((r|0)<0)<<31>>31|0,$|0,(($|0)<0)<<31>>31|0)|0;D=C;E=CF(p|0,((p|0)<0)<<31>>31|0,aa|0,((aa|0)<0)<<31>>31|0)|0;D=sF(E|0,C|0,F|0,D|0)|0;F=C;E=CF(q|0,((q|0)<0)<<31>>31|0,K|0,L|0)|0;if(!((D|0)==(E|0)&(F|0)==(C|0))){d=121;break b}v=CF(r|0,((r|0)<0)<<31>>31|0,U|0,V|0)|0;x=C;w=CF(p|0,((p|0)<0)<<31>>31|0,W|0,X|0)|0;x=sF(w|0,C|0,v|0,x|0)|0;v=C;w=CF(q|0,((q|0)<0)<<31>>31|0,Y|0,Z|0)|0;w=sF(x|0,v|0,w|0,C|0)|0;v=C;r=(_(p,da)|0)+(_(r,ca)|0)+(_(q,ba)|0)|0;x=j-M|0;E=d-N|0;y=b-O|0;x=CF(x|0,((x|0)<0)<<31>>31|0,U|0,V|0)|0;F=C;E=CF(E|0,((E|0)<0)<<31>>31|0,W|0,X|0)|0;F=sF(E|0,C|0,x|0,F|0)|0;x=C;y=CF(y|0,((y|0)<0)<<31>>31|0,Y|0,Z|0)|0;y=sF(F|0,x|0,y|0,C|0)|0;x=C;if(!((x|0)>0|(x|0)==0&y>>>0>0)){d=121;break b}if((w|0)==0&(v|0)==0){if((r|0)>=0){d=121;break b}}else{if((v|0)>=0){d=121;break b}if((r|0)>0){t=1;s=r;u=((r|0)<0)<<31>>31}else{s=pF(0,0,r|0,((r|0)<0)<<31>>31|0)|0;t=r>>31;s=(r|0)<0?s:0;u=(r|0)<0?C:0}z=0-t|0;v=pF(0,0,w|0,v|0)|0;p=C;if((A|0)>0){r=1;o=A;w=((A|0)<0)<<31>>31}else{o=pF(0,0,A|0,((A|0)<0)<<31>>31|0)|0;r=A>>31;o=(A|0)<0?o:0;w=(A|0)<0?C:0}do if((g|0)>0|(g|0)==0&J>>>0>0)q=J;else{if((g|0)>=0){q=0;g=0;break}q=pF(0,0,J|0,g|0)|0;g=C;r=0-r|0}while(0);if((r|0)==(z|0)){if(!t){d=121;break b}b=CF(q|0,0,s|0,0)|0;r=C;F=CF(g|0,0,s|0,0)|0;D=C;d=CF(q|0,0,u|0,0)|0;j=C;J=CF(g|0,0,u|0,0)|0;q=C;d=sF(F|0,0,d|0,0)|0;F=C;q=sF(D|0,0,J|0,q|0)|0;j=sF(q|0,C|0,j|0,0)|0;F=sF(j|0,C|0,F|0,0)|0;j=C;r=sF(0,d|0,b|0,r|0)|0;b=C;d=sF(F|0,j|0,(b>>>0<d>>>0|(b|0)==(d|0)&r>>>0<0)&1|0,0)|0;j=C;F=CF(o|0,0,v|0,0)|0;q=C;J=CF(w|0,0,v|0,0)|0;D=C;o=CF(o|0,0,p|0,0)|0;g=C;E=CF(w|0,0,p|0,0)|0;p=C;o=sF(J|0,0,o|0,0)|0;J=C;p=sF(D|0,0,E|0,p|0)|0;g=sF(p|0,C|0,g|0,0)|0;J=sF(g|0,C|0,J|0,0)|0;g=C;q=sF(0,o|0,F|0,q|0)|0;p=C;o=sF(J|0,g|0,(p>>>0<o>>>0|(p|0)==(o|0)&q>>>0<0)&1|0,0)|0;g=C;do if(j>>>0<g>>>0|(j|0)==(g|0)&d>>>0<o>>>0)l=-1;else{if(j>>>0>g>>>0|(j|0)==(g|0)&d>>>0>o>>>0){l=1;break}if(b>>>0<p>>>0|(b|0)==(p|0)&r>>>0<q>>>0){l=-1;break}l=(b>>>0>p>>>0|(b|0)==(p|0)&r>>>0>q>>>0)&1}while(0);l=_(l,z)|0}else l=z-r|0;if((l|0)<=0){d=121;break b}}c[f>>2]=G;o=c[G+12>>2]|0;g=x;J=y;q=c[o+88>>2]|0;p=c[o+92>>2]|0;o=c[o+96>>2]|0}g=q-G|0;N=p-F|0;b=o-B|0;g=CF(g|0,((g|0)<0)<<31>>31|0,U|0,V|0)|0;M=C;N=CF(N|0,((N|0)<0)<<31>>31|0,W|0,X|0)|0;M=sF(N|0,C|0,g|0,M|0)|0;g=C;b=CF(b|0,((b|0)<0)<<31>>31|0,Y|0,Z|0)|0;b=sF(M|0,g|0,b|0,C|0)|0;c[e>>2]=(E|0)==(S|0)?0:T;g=C;M=G;N=F;O=B}if((d|0)==121)return}if((P|0)>=0)return;O=pF(0,0,R|0,((R|0)<0)<<31>>31|0)|0;N=C;l=Q;d=P;q=k;o=H;while(1){k=(_(n-I|0,da)|0)+(_(o-m|0,ba)|0)+(_(q-i|0,ca)|0)|0;d:do if(!l){G=k;p=((k|0)<0)<<31>>31;l=d;t=k;A=q;D=o}else{F=l;G=k;p=((k|0)<0)<<31>>31;y=k;A=q;B=n;D=o;while(1){if(!(c[F+12>>2]|0)){l=d;t=y;n=B;break d}z=c[(c[F+4>>2]|0)+8>>2]|0;if((c[z+20>>2]|0)<=(c[a+100>>2]|0)){l=d;t=y;n=B;break d}H=c[z+12>>2]|0;E=c[H+88>>2]|0;T=E-A|0;n=c[H+92>>2]|0;S=n-B|0;H=c[H+96>>2]|0;l=H-D|0;j=CF(T|0,((T|0)<0)<<31>>31|0,U|0,V|0)|0;R=C;k=CF(S|0,((S|0)<0)<<31>>31|0,W|0,X|0)|0;R=sF(k|0,C|0,j|0,R|0)|0;j=C;k=CF(l|0,((l|0)<0)<<31>>31|0,Y|0,Z|0)|0;k=sF(R|0,j|0,k|0,C|0)|0;j=C;l=(_(S,da)|0)+(_(T,ca)|0)+(_(l,ba)|0)|0;do if((k|0)==0&(j|0)==0){if((l|0)<=0){l=d;t=y;n=B;break d}}else{if((j|0)>=0){l=d;t=y;n=B;break d}if((l|0)>0){b=1;s=l;r=((l|0)<0)<<31>>31}else{s=pF(0,0,l|0,((l|0)<0)<<31>>31|0)|0;b=l>>31;s=(l|0)<0?s:0;r=(l|0)<0?C:0}x=0-b|0;t=pF(0,0,k|0,j|0)|0;u=C;if((y|0)>0){q=1;v=G;w=p}else{w=(y|0)<0;v=pF(0,0,G|0,p|0)|0;q=y>>31;v=w?v:0;w=w?C:0}if(!((d|0)>0|(d|0)==0&h>>>0>0))if((d|0)<0){o=pF(0,0,h|0,d|0)|0;g=C;q=0-q|0}else{o=0;g=0}else{o=h;g=d}if((q|0)==(x|0)){if(!b)break;k=CF(o|0,0,s|0,0)|0;j=C;b=CF(g|0,0,s|0,0)|0;Q=C;l=CF(o|0,0,r|0,0)|0;q=C;T=CF(g|0,0,r|0,0)|0;r=C;l=sF(b|0,0,l|0,0)|0;o=C;r=sF(Q|0,0,T|0,r|0)|0;r=sF(r|0,C|0,q|0,0)|0;o=sF(r|0,C|0,o|0,0)|0;r=C;j=sF(0,l|0,k|0,j|0)|0;k=C;l=sF(o|0,r|0,(k>>>0<l>>>0|(k|0)==(l|0)&j>>>0<0)&1|0,0)|0;r=C;o=CF(v|0,0,t|0,0)|0;q=C;T=CF(w|0,0,t|0,0)|0;Q=C;g=CF(v|0,0,u|0,0)|0;b=C;R=CF(w|0,0,u|0,0)|0;S=C;g=sF(T|0,0,g|0,0)|0;T=C;S=sF(Q|0,0,R|0,S|0)|0;b=sF(S|0,C|0,b|0,0)|0;T=sF(b|0,C|0,T|0,0)|0;b=C;q=sF(0,g|0,o|0,q|0)|0;o=C;g=sF(T|0,b|0,(o>>>0<g>>>0|(o|0)==(g|0)&q>>>0<0)&1|0,0)|0;b=C;do if(r>>>0<b>>>0|(r|0)==(b|0)&l>>>0<g>>>0)l=-1;else{if(r>>>0>b>>>0|(r|0)==(b|0)&l>>>0>g>>>0){l=1;break}if(k>>>0<o>>>0|(k|0)==(o|0)&j>>>0<q>>>0){l=-1;break}l=(k>>>0>o>>>0|(k|0)==(o|0)&j>>>0>q>>>0)&1}while(0);b=_(l,x)|0}else b=x-q|0;if((b|0)>=1){l=d;t=y;n=B;break d}}while(0);k=E-i|0;S=n-I|0;T=H-m|0;d=CF(k|0,((k|0)<0)<<31>>31|0,U|0,V|0)|0;R=C;h=CF(S|0,((S|0)<0)<<31>>31|0,W|0,X|0)|0;R=sF(h|0,C|0,d|0,R|0)|0;d=C;h=CF(T|0,((T|0)<0)<<31>>31|0,Y|0,Z|0)|0;h=sF(R|0,d|0,h|0,C|0)|0;d=C;F=(F|0)==(ea|0)?0:z;c[f>>2]=F;k=(_(S,da)|0)+(_(T,ba)|0)+(_(k,ca)|0)|0;if(!F){G=k;p=((k|0)<0)<<31>>31;l=d;t=k;A=E;D=H;break}else{G=k;p=((k|0)<0)<<31>>31;y=k;A=E;B=n;D=H}}}while(0);d=c[e>>2]|0;if(!d){d=121;break}if(!(c[d+12>>2]|0)){d=121;break}z=c[(c[d+8>>2]|0)+4>>2]|0;if((c[z+20>>2]|0)<=(c[a+100>>2]|0)){d=121;break}j=c[z+12>>2]|0;g=c[j+88>>2]|0;d=g-i|0;b=c[j+92>>2]|0;k=b-I|0;j=c[j+96>>2]|0;i=j-m|0;T=CF(d|0,((d|0)<0)<<31>>31|0,$|0,(($|0)<0)<<31>>31|0)|0;R=C;S=CF(k|0,((k|0)<0)<<31>>31|0,aa|0,((aa|0)<0)<<31>>31|0)|0;R=sF(S|0,C|0,T|0,R|0)|0;T=C;S=CF(i|0,((i|0)<0)<<31>>31|0,O|0,N|0)|0;if(!((R|0)==(S|0)&(T|0)==(C|0))){d=121;break}m=CF(d|0,((d|0)<0)<<31>>31|0,U|0,V|0)|0;u=C;o=CF(k|0,((k|0)<0)<<31>>31|0,W|0,X|0)|0;u=sF(o|0,C|0,m|0,u|0)|0;m=C;o=CF(i|0,((i|0)<0)<<31>>31|0,Y|0,Z|0)|0;o=sF(u|0,m|0,o|0,C|0)|0;m=C;k=(_(k,da)|0)+(_(d,ca)|0)+(_(i,ba)|0)|0;u=A-g|0;S=n-b|0;v=D-j|0;u=CF(u|0,((u|0)<0)<<31>>31|0,U|0,V|0)|0;T=C;S=CF(S|0,((S|0)<0)<<31>>31|0,W|0,X|0)|0;T=sF(S|0,C|0,u|0,T|0)|0;u=C;v=CF(v|0,((v|0)<0)<<31>>31|0,Y|0,Z|0)|0;v=sF(T|0,u|0,v|0,C|0)|0;u=C;if((u|0)>=0){d=121;break}if((o|0)==0&(m|0)==0){if((k|0)<=0){d=121;break}}else{if((m|0)>=0){d=121;break}if((k|0)>0){g=1;b=k;q=((k|0)<0)<<31>>31}else{b=pF(0,0,k|0,((k|0)<0)<<31>>31|0)|0;g=k>>31;b=(k|0)<0?b:0;q=(k|0)<0?C:0}w=0-g|0;d=pF(0,0,o|0,m|0)|0;m=C;if((t|0)>0){i=1;o=G}else{T=(t|0)<0;o=pF(0,0,G|0,p|0)|0;i=t>>31;o=T?o:0;p=T?C:0}do if(!((l|0)>0|(l|0)==0&h>>>0>0)){if((l|0)>=0){h=0;l=0;break}h=pF(0,0,h|0,l|0)|0;l=C;i=0-i|0}while(0);if((i|0)==(w|0)){if(!g){d=121;break}T=CF(h|0,0,b|0,0)|0;k=C;S=CF(l|0,0,b|0,0)|0;Q=C;j=CF(h|0,0,q|0,0)|0;i=C;b=CF(l|0,0,q|0,0)|0;l=C;j=sF(S|0,0,j|0,0)|0;S=C;l=sF(Q|0,0,b|0,l|0)|0;i=sF(l|0,C|0,i|0,0)|0;S=sF(i|0,C|0,S|0,0)|0;i=C;l=sF(0,j|0,T|0,k|0)|0;k=C;j=sF(S|0,i|0,(k>>>0<j>>>0|(k|0)==(j|0)&l>>>0<0)&1|0,0)|0;i=C;S=CF(o|0,0,d|0,0)|0;b=C;T=CF(p|0,0,d|0,0)|0;Q=C;g=CF(o|0,0,m|0,0)|0;h=C;R=CF(p|0,0,m|0,0)|0;d=C;g=sF(T|0,0,g|0,0)|0;T=C;d=sF(Q|0,0,R|0,d|0)|0;h=sF(d|0,C|0,h|0,0)|0;T=sF(h|0,C|0,T|0,0)|0;h=C;d=sF(0,g|0,S|0,b|0)|0;b=C;g=sF(T|0,h|0,(b>>>0<g>>>0|(b|0)==(g|0)&d>>>0<0)&1|0,0)|0;h=C;do if(i>>>0<h>>>0|(i|0)==(h|0)&j>>>0<g>>>0)d=-1;else{if(i>>>0>h>>>0|(i|0)==(h|0)&j>>>0>g>>>0){d=1;break}if(k>>>0<b>>>0|(k|0)==(b|0)&l>>>0<d>>>0){d=-1;break}d=(k>>>0>b>>>0|(k|0)==(b|0)&l>>>0>d>>>0)&1}while(0);d=_(d,w)|0}else d=w-i|0;if((d|0)>=0){d=121;break}}c[e>>2]=z;m=c[z+12>>2]|0;l=c[f>>2]|0;h=v;d=u;i=c[m+88>>2]|0;I=c[m+92>>2]|0;m=c[m+96>>2]|0;q=A;o=D}if((d|0)==121)return}
function HC(a,e,f){a=a|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;c[e+16>>2]=c[a+20>>2];c[e+20>>2]=c[a+24>>2];c[e+24>>2]=c[a+28>>2];c[e+28>>2]=c[a+32>>2];c[e>>2]=c[a+4>>2];c[e+4>>2]=c[a+8>>2];c[e+8>>2]=c[a+12>>2];c[e+12>>2]=c[a+16>>2];c[e+32>>2]=c[a+36>>2];c[e+36>>2]=c[a+40>>2];c[e+40>>2]=c[a+44>>2];c[e+44>>2]=c[a+48>>2];c[e+48>>2]=c[a+56>>2];c[e+52>>2]=d[a+60>>0];g=c[a+88>>2]|0;c[e+56>>2]=g;if(g){g=_b[c[(c[f>>2]|0)+28>>2]&31](f,c[a+96>>2]|0)|0;c[e+64>>2]=g;if(g){j=c[a+88>>2]|0;h=Qb[c[(c[f>>2]|0)+16>>2]&63](f,48,j)|0;if((j|0)>0){g=c[a+96>>2]|0;k=0;i=c[h+8>>2]|0;while(1){c[i+16>>2]=c[g+(k<<6)+16>>2];c[i+20>>2]=c[g+(k<<6)+20>>2];c[i+24>>2]=c[g+(k<<6)+24>>2];c[i+28>>2]=c[g+(k<<6)+28>>2];c[i>>2]=c[g+(k<<6)>>2];c[i+4>>2]=c[g+(k<<6)+4>>2];c[i+8>>2]=c[g+(k<<6)+8>>2];c[i+12>>2]=c[g+(k<<6)+12>>2];c[i+32>>2]=c[g+(k<<6)+32>>2];c[i+36>>2]=c[g+(k<<6)+36>>2];c[i+40>>2]=c[g+(k<<6)+40>>2];k=k+1|0;if((k|0)==(j|0))break;else i=i+48|0}}else g=c[a+96>>2]|0;Bb[c[(c[f>>2]|0)+20>>2]&31](f,h,19016,1497453121,g)}}else c[e+64>>2]=0;g=c[a+128>>2]|0;c[e+60>>2]=g;if(g){g=_b[c[(c[f>>2]|0)+28>>2]&31](f,c[a+136>>2]|0)|0;c[e+68>>2]=g;if(g){j=c[a+128>>2]|0;h=Qb[c[(c[f>>2]|0)+16>>2]&63](f,16,j)|0;if((j|0)>0){g=c[a+136>>2]|0;k=0;i=c[h+8>>2]|0;while(1){c[i+12>>2]=c[g+(k<<4)+12>>2];b[i+6>>1]=b[g+(k<<4)+6>>1]|0;b[i+8>>1]=b[g+(k<<4)+8>>1]|0;b[i+10>>1]=b[g+(k<<4)+10>>1]|0;b[i>>1]=b[g+(k<<4)>>1]|0;b[i+2>>1]=b[g+(k<<4)+2>>1]|0;b[i+4>>1]=b[g+(k<<4)+4>>1]|0;k=k+1|0;if((k|0)==(j|0))break;else i=i+16|0}}else g=c[a+136>>2]|0;Bb[c[(c[f>>2]|0)+20>>2]&31](f,h,19039,1497453121,g)}}else c[e+68>>2]=0;c[e+76>>2]=c[a+144>>2];g=c[a+152>>2]|0;c[e+80>>2]=g;if(!g){c[e+72>>2]=0;return 19083}g=_b[c[(c[f>>2]|0)+28>>2]&31](f,c[a+160>>2]|0)|0;c[e+72>>2]=g;if(!g)return 19083;j=c[a+152>>2]|0;k=Qb[c[(c[f>>2]|0)+16>>2]&63](f,20,j)|0;if((j|0)>0){g=c[a+160>>2]|0;h=0;i=c[k+8>>2]|0;while(1){b[i+14>>1]=b[g+(h<<5)+6>>1]|0;b[i+16>>1]=b[g+(h<<5)+8>>1]|0;b[i+18>>1]=b[g+(h<<5)+10>>1]|0;b[i+8>>1]=b[g+(h<<5)>>1]|0;b[i+10>>1]=b[g+(h<<5)+2>>1]|0;b[i+12>>1]=b[g+(h<<5)+4>>1]|0;c[i>>2]=c[g+(h<<5)+12>>2];c[i+4>>2]=c[g+(h<<5)+16>>2];h=h+1|0;if((h|0)==(j|0))break;else i=i+20|0}}else g=c[a+160>>2]|0;Bb[c[(c[f>>2]|0)+20>>2]&31](f,k,19062,1497453121,g);return 19083}function IC(a){a=a|0;return}function JC(b){b=b|0;var d=0;d=c[b>>2]|0;if(d)LC(b,d);d=c[b+4>>2]|0;if(d){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+4>>2]=0;c[b+8>>2]=-1;d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[b+16>>2]=0;d=c[b+52>>2]|0;if(!d){a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}if(!(a[b+56>>0]|0)){a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);d=c[b+32>>2]|0;a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;if(!d){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+32>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}function KC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;if((b|0)<0)b=c[a+12>>2]|0;d=c[a>>2]|0;if(!((b|0)>0&(d|0)!=0)){i=n;return}while(1){e=d+40|0;if(c[e>>2]|0){m=0;while(1){l=(c[a+16>>2]|0)>>>m&1;k=d+32|0;f=c[k>>2]|0;if(f>>>0>d>>>0){j=(c[f+40>>2]|0)==(d|0)&1;g=c[f+36+((j^1)<<2)>>2]|0;h=c[f+32>>2]|0;if(!h)c[a>>2]=d;else c[h+36+(((c[h+40>>2]|0)==(f|0)&1)<<2)>>2]=d;c[g+32>>2]=d;c[f+32>>2]=d;c[k>>2]=h;k=d+36|0;c[f+36>>2]=c[k>>2];c[f+40>>2]=c[e>>2];c[(c[k>>2]|0)+32>>2]=f;c[(c[e>>2]|0)+32>>2]=f;c[d+36+(j<<2)>>2]=f;c[d+36+((j^1)<<2)>>2]=g;c[n>>2]=c[f>>2];c[n+4>>2]=c[f+4>>2];c[n+8>>2]=c[f+8>>2];c[n+12>>2]=c[f+12>>2];c[n+16>>2]=c[f+16>>2];c[n+20>>2]=c[f+20>>2];c[n+24>>2]=c[f+24>>2];c[n+28>>2]=c[f+28>>2];c[f>>2]=c[d>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];c[f+16>>2]=c[d+16>>2];c[f+20>>2]=c[d+20>>2];c[f+24>>2]=c[d+24>>2];c[f+28>>2]=c[d+28>>2];c[d>>2]=c[n>>2];c[d+4>>2]=c[n+4>>2];c[d+8>>2]=c[n+8>>2];c[d+12>>2]=c[n+12>>2];c[d+16>>2]=c[n+16>>2];c[d+20>>2]=c[n+20>>2];c[d+24>>2]=c[n+24>>2];c[d+28>>2]=c[n+28>>2];d=f}d=c[d+36+(l<<2)>>2]|0;e=d+40|0;if(!(c[e>>2]|0))break;else m=m+1&31}}if(!(MC(a,d)|0))e=0;else e=c[a>>2]|0;NC(a,e,d);c[a+16>>2]=(c[a+16>>2]|0)+1;b=b+-1|0;if(!b)break;d=c[a>>2]|0}i=n;return}function LC(a,b){a=a|0;b=b|0;var d=0;if(c[b+40>>2]|0){LC(a,c[b+36>>2]|0);LC(a,c[b+40>>2]|0)}if((c[a>>2]|0)==(b|0))c[a>>2]=0;d=c[a+4>>2]|0;if(!d){c[a+4>>2]=b;return}c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);c[a+4>>2]=b;return}function MC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0;if((c[a>>2]|0)==(b|0)){c[a>>2]=0;d=0;return d|0}e=c[b+32>>2]|0;d=c[e+32>>2]|0;b=c[e+36+(((c[e+40>>2]|0)!=(b|0)&1)<<2)>>2]|0;if(!d){c[a>>2]=b;c[b+32>>2]=0;d=c[a+4>>2]|0;if(!d)d=b;else{c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);d=c[a>>2]|0}c[a+4>>2]=e;return d|0}c[d+36+(((c[d+40>>2]|0)==(e|0)&1)<<2)>>2]=b;c[b+32>>2]=d;b=c[a+4>>2]|0;if(b){c[2704]=(c[2704]|0)+1;YE(c[b+-4>>2]|0)}c[a+4>>2]=e;do{s=+g[d>>2];x=d+4|0;q=+g[x>>2];v=d+8|0;o=+g[v>>2];y=d+16|0;m=+g[y>>2];w=d+20|0;i=+g[w>>2];b=d+24|0;k=+g[b>>2];u=c[d+36>>2]|0;e=c[d+40>>2]|0;t=+g[u>>2];r=+g[e>>2];r=t<r?t:r;g[d>>2]=r;t=+g[u+16>>2];l=+g[e+16>>2];l=t>l?t:l;g[y>>2]=l;t=+g[u+4>>2];p=+g[e+4>>2];p=t<p?t:p;g[x>>2]=p;t=+g[u+20>>2];h=+g[e+20>>2];h=t>h?t:h;g[w>>2]=h;t=+g[u+8>>2];n=+g[e+8>>2];n=t<n?t:n;g[v>>2]=n;t=+g[u+24>>2];j=+g[e+24>>2];j=t>j?t:j;g[b>>2]=j;if(!(s!=r|q!=p|o!=n|m!=l)?!(k!=j|i!=h):0){f=14;break}d=c[d+32>>2]|0}while((d|0)!=0);if((f|0)==14)return d|0;d=c[a>>2]|0;return d|0}function NC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0.0;if(!(c[a>>2]|0)){c[a>>2]=d;c[d+32>>2]=0;return}e=c[b+40>>2]|0;if(e){j=+g[d>>2]+ +g[d+16>>2];k=+g[d+4>>2]+ +g[d+20>>2];i=+g[d+8>>2]+ +g[d+24>>2];do{p=c[b+36>>2]|0;l=+N(+(j-(+g[p>>2]+ +g[p+16>>2])))+ +N(+(k-(+g[p+4>>2]+ +g[p+20>>2])))+ +N(+(i-(+g[p+8>>2]+ +g[p+24>>2])));b=c[b+36+((!(l<+N(+(j-(+g[e>>2]+ +g[e+16>>2])))+ +N(+(k-(+g[e+4>>2]+ +g[e+20>>2])))+ +N(+(i-(+g[e+8>>2]+ +g[e+24>>2]))))&1)<<2)>>2]|0;e=c[b+40>>2]|0}while((e|0)!=0)}o=b+32|0;p=c[o>>2]|0;e=c[a+4>>2]|0;if(!e){c[2703]=(c[2703]|0)+1;e=XE(63)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=e;h=f+44|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(h|0))}else c[a+4>>2]=0;c[e+32>>2]=p;c[e+36>>2]=0;h=e+40|0;c[h>>2]=0;q=+g[d>>2];n=+g[b>>2];n=q<n?q:n;g[e>>2]=n;q=+g[d+16>>2];k=+g[b+16>>2];k=q>k?q:k;g[e+16>>2]=k;q=+g[d+4>>2];m=+g[b+4>>2];m=q<m?q:m;g[e+4>>2]=m;q=+g[d+20>>2];j=+g[b+20>>2];j=q>j?q:j;g[e+20>>2]=j;q=+g[d+8>>2];l=+g[b+8>>2];l=q<l?q:l;g[e+8>>2]=l;q=+g[d+24>>2];i=+g[b+24>>2];i=q>i?q:i;g[e+24>>2]=i;if(!p){c[e+36>>2]=b;c[o>>2]=e;c[h>>2]=d;c[d+32>>2]=e;c[a>>2]=e;return}c[p+36+(((c[(c[o>>2]|0)+40>>2]|0)==(b|0)&1)<<2)>>2]=e;c[e+36>>2]=b;c[o>>2]=e;c[h>>2]=d;c[d+32>>2]=e;e=p;while(1){b=e+4|0;if(((((+g[e>>2]<=n?+g[b>>2]<=m:0)?+g[e+8>>2]<=l:0)?+g[e+16>>2]>=k:0)?+g[e+20>>2]>=j:0)?+g[e+24>>2]>=i:0){e=21;break}d=c[e+36>>2]|0;p=c[e+40>>2]|0;q=+g[d>>2];n=+g[p>>2];n=q<n?q:n;g[e>>2]=n;q=+g[d+16>>2];k=+g[p+16>>2];k=q>k?q:k;g[e+16>>2]=k;q=+g[d+4>>2];m=+g[p+4>>2];m=q<m?q:m;g[b>>2]=m;q=+g[d+20>>2];j=+g[p+20>>2];j=q>j?q:j;g[e+20>>2]=j;q=+g[d+8>>2];l=+g[p+8>>2];l=q<l?q:l;g[e+8>>2]=l;q=+g[d+24>>2];i=+g[p+24>>2];i=q>i?q:i;g[e+24>>2]=i;e=c[e+32>>2]|0;if(!e){e=21;break}}if((e|0)==21)return}function OC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0;H=i;i=i+32|0;k=+g[b+16>>2];j=+g[b>>2];l=+g[b+20>>2];h=+g[b+4>>2];o=+g[b+24>>2];f=+g[b+8>>2];t=+g[b+32>>2];x=+g[b+36>>2];y=+g[b+40>>2];E=(l-h)*(y-f)-(o-f)*(x-h);F=(o-f)*(t-j)-(k-j)*(y-f);G=(k-j)*(x-h)-(l-h)*(t-j);g[H+16>>2]=E;g[H+16+4>>2]=F;g[H+16+8>>2]=G;g[H+16+12>>2]=0.0;p=+g[a+4>>2];r=+g[a+8>>2];v=+g[a+12>>2];D=E*p+F*r+G*v-(j*E+h*F+f*G);n=+g[a+20>>2];s=+g[a+24>>2];w=+g[a+28>>2];if(D*(E*n+F*s+G*w-(j*E+h*F+f*G))>=0.0){i=H;return}B=c[a+36>>2]|0;if(D<=0.0&(B&1|0)!=0){i=H;return}C=D/(D-(E*n+F*s+G*w-(j*E+h*F+f*G)));if(!(C<+g[a+40>>2])){i=H;return}A=(E*E+F*F+G*G)*-9.999999747378752e-05;z=j-(n*C+p*(1.0-C));u=h-(s*C+r*(1.0-C));q=f-(w*C+v*(1.0-C));m=k-(n*C+p*(1.0-C));l=l-(s*C+r*(1.0-C));k=o-(w*C+v*(1.0-C));if(!(G*(z*l-u*m)+(E*(u*k-q*l)+F*(q*m-z*k))>=A)){i=H;return}j=t-(n*C+p*(1.0-C));h=x-(s*C+r*(1.0-C));f=y-(w*C+v*(1.0-C));if(!(G*(m*h-l*j)+(E*(l*f-k*h)+F*(k*j-m*f))>=A)){i=H;return}if(!(G*(u*j-z*h)+(E*(q*h-u*f)+F*(z*f-q*j))>=A)){i=H;return}f=1.0/+O(+(E*E+F*F+G*G));g[H+16>>2]=E*f;g[H+16+4>>2]=F*f;g[H+16+8>>2]=G*f;b=c[(c[a>>2]|0)+12>>2]|0;if(D<=0.0&(B&2|0)==0){g[H>>2]=-(E*f);g[H+4>>2]=-(F*f);g[H+8>>2]=-(G*f);g[H+12>>2]=0.0;g[a+40>>2]=+fc[b&3](a,H,C,d,e);i=H;return}else{g[a+40>>2]=+fc[b&3](a,H+16|0,C,d,e);i=H;return}}function PC(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0;m=i;i=i+672|0;c[m+568+8>>2]=0;c[m+568+12>>2]=1065353216;c[m+568+16>>2]=1065353216;c[m+568+20>>2]=1065353216;g[m+568+24>>2]=0.0;c[m+568+52>>2]=0;c[m+568>>2]=5644;c[m+568+4>>2]=1;c[m+568+56>>2]=c[d>>2];c[m+568+56+4>>2]=c[d+4>>2];c[m+568+56+8>>2]=c[d+8>>2];c[m+568+56+12>>2]=c[d+12>>2];c[m+568+72>>2]=c[d+16>>2];c[m+568+72+4>>2]=c[d+16+4>>2];c[m+568+72+8>>2]=c[d+16+8>>2];c[m+568+72+12>>2]=c[d+16+12>>2];c[m+568+88>>2]=c[d+32>>2];c[m+568+88+4>>2]=c[d+32+4>>2];c[m+568+88+8>>2]=c[d+32+8>>2];c[m+568+88+12>>2]=c[d+32+12>>2];c[m+568+44>>2]=c[b+204>>2];g[m+208+308>>2]=9.999999747378752e-05;a[m+208+332>>0]=0;c[m+24>>2]=10400;d=c[b+4>>2]|0;c[m>>2]=10480;c[m+4>>2]=m+208;c[m+8>>2]=m+24;c[m+12>>2]=d;c[m+16>>2]=m+568;c[m+20>>2]=0;c[m+32>>2]=5800;c[m+32+168>>2]=0;g[m+32+164>>2]=1.0;c[m+32+172>>2]=c[b+208>>2];if((lD(m,b+8|0,b+72|0,b+136|0,b+136|0,m+32|0)|0?(k=+g[m+32+132>>2],l=+g[m+32+136>>2],h=+g[m+32+140>>2],k*k+l*l+h*h>9.999999747378752e-05):0)?(j=+g[m+32+164>>2],j<+g[b+200>>2]):0){n=1.0/+O(+(k*k+l*l+h*h));g[m+32+132>>2]=k*n;g[m+32+136>>2]=l*n;g[m+32+140>>2]=h*n;+Vb[c[(c[b>>2]|0)+12>>2]&3](b,m+32+132|0,m+32+148|0,j,e,f)}c[m+568>>2]=7356;e=c[m+568+52>>2]|0;if(!e){i=m;return}Db[c[c[e>>2]>>2]&255](e);e=c[m+568+52>>2]|0;if(!e){i=m;return}c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0);i=m;return}function QC(a){a=a|0;YE(a);return}function RC(b,d,e,f,h,j,l,m,n,o){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0.0,q=0,r=0,s=0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;A=i;i=i+4272|0;if(((c[e+4>>2]|0)+-17|0)>>>0<2)u=((c[f+4>>2]|0)+-17|0)>>>0<2;else u=0;b=0;do{SC();y=+g[9352+(b<<4)>>2];x=+g[9352+(b<<4)+4>>2];v=+g[9352+(b<<4)+8>>2];p=+g[h+4>>2]*-y+ +g[h+20>>2]*-x+ +g[h+36>>2]*-v;t=+g[h+8>>2]*-y+ +g[h+24>>2]*-x+ +g[h+40>>2]*-v;g[A+1288+(b<<4)>>2]=+g[h>>2]*-y+ +g[h+16>>2]*-x+ +g[h+32>>2]*-v;g[A+1288+(b<<4)+4>>2]=p;g[A+1288+(b<<4)+8>>2]=t;g[A+1288+(b<<4)+12>>2]=0.0;t=y*+g[j+4>>2]+x*+g[j+20>>2]+v*+g[j+36>>2];p=y*+g[j+8>>2]+x*+g[j+24>>2]+v*+g[j+40>>2];g[A+296+(b<<4)>>2]=y*+g[j>>2]+x*+g[j+16>>2]+v*+g[j+32>>2];g[A+296+(b<<4)+4>>2]=t;g[A+296+(b<<4)+8>>2]=p;g[A+296+(b<<4)+12>>2]=0.0;b=b+1|0}while((b|0)!=42);b=Hb[c[(c[e>>2]|0)+84>>2]&127](e)|0;if((b|0)>0){q=0;r=42;while(1){jc[c[(c[e>>2]|0)+88>>2]&127](e,q,A+200|0);t=+g[A+200>>2];p=+g[A+200+4>>2];v=+g[A+200+8>>2];x=t*+g[h+16>>2]+p*+g[h+20>>2]+v*+g[h+24>>2];y=t*+g[h+32>>2]+p*+g[h+36>>2]+v*+g[h+40>>2];g[A+200>>2]=+g[h>>2]*t+ +g[h+4>>2]*p+ +g[h+8>>2]*v;g[A+200+4>>2]=x;g[A+200+8>>2]=y;g[A+200+12>>2]=0.0;SC();s=9352+(r<<4)|0;c[s>>2]=c[A+200>>2];c[s+4>>2]=c[A+200+4>>2];c[s+8>>2]=c[A+200+8>>2];c[s+12>>2]=c[A+200+12>>2];y=+g[A+200>>2];x=+g[A+200+4>>2];v=+g[A+200+8>>2];p=+g[h+4>>2]*-y+ +g[h+20>>2]*-x+ +g[h+36>>2]*-v;t=+g[h+8>>2]*-y+ +g[h+24>>2]*-x+ +g[h+40>>2]*-v;g[A+1288+(r<<4)>>2]=+g[h>>2]*-y+ +g[h+16>>2]*-x+ +g[h+32>>2]*-v;g[A+1288+(r<<4)+4>>2]=p;g[A+1288+(r<<4)+8>>2]=t;g[A+1288+(r<<4)+12>>2]=0.0;t=y*+g[j+4>>2]+x*+g[j+20>>2]+v*+g[j+36>>2];p=y*+g[j+8>>2]+x*+g[j+24>>2]+v*+g[j+40>>2];g[A+296+(r<<4)>>2]=+g[j>>2]*y+ +g[j+16>>2]*x+ +g[j+32>>2]*v;g[A+296+(r<<4)+4>>2]=t;g[A+296+(r<<4)+8>>2]=p;g[A+296+(r<<4)+12>>2]=0.0;q=q+1|0;if((q|0)==(b|0))break;else r=r+1|0}b=b+42|0}else b=42;r=Hb[c[(c[f>>2]|0)+84>>2]&127](f)|0;if((r|0)>0){q=0;s=b;while(1){jc[c[(c[f>>2]|0)+88>>2]&127](f,q,A+48|0);t=+g[A+48>>2];p=+g[A+48+4>>2];v=+g[A+48+8>>2];x=t*+g[j+16>>2]+p*+g[j+20>>2]+v*+g[j+24>>2];y=t*+g[j+32>>2]+p*+g[j+36>>2]+v*+g[j+40>>2];g[A+48>>2]=+g[j>>2]*t+ +g[j+4>>2]*p+ +g[j+8>>2]*v;g[A+48+4>>2]=x;g[A+48+8>>2]=y;g[A+48+12>>2]=0.0;SC();B=9352+(s<<4)|0;c[B>>2]=c[A+48>>2];c[B+4>>2]=c[A+48+4>>2];c[B+8>>2]=c[A+48+8>>2];c[B+12>>2]=c[A+48+12>>2];y=+g[A+48>>2];x=+g[A+48+4>>2];v=+g[A+48+8>>2];p=+g[h+4>>2]*-y+ +g[h+20>>2]*-x+ +g[h+36>>2]*-v;t=+g[h+8>>2]*-y+ +g[h+24>>2]*-x+ +g[h+40>>2]*-v;g[A+1288+(s<<4)>>2]=+g[h>>2]*-y+ +g[h+16>>2]*-x+ +g[h+32>>2]*-v;g[A+1288+(s<<4)+4>>2]=p;g[A+1288+(s<<4)+8>>2]=t;g[A+1288+(s<<4)+12>>2]=0.0;t=y*+g[j+4>>2]+x*+g[j+20>>2]+v*+g[j+36>>2];p=y*+g[j+8>>2]+x*+g[j+24>>2]+v*+g[j+40>>2];g[A+296+(s<<4)>>2]=+g[j>>2]*y+ +g[j+16>>2]*x+ +g[j+32>>2]*v;g[A+296+(s<<4)+4>>2]=t;g[A+296+(s<<4)+8>>2]=p;g[A+296+(s<<4)+12>>2]=0.0;q=q+1|0;if((q|0)==(r|0))break;else s=s+1|0}b=r+b|0}nc[c[(c[e>>2]|0)+76>>2]&127](e,A+1288|0,A+3272|0,b);nc[c[(c[f>>2]|0)+76>>2]&127](f,A+296|0,A+2280|0,b);if((b|0)>0)if(u){r=0;u=0;s=0;w=0.0;x=999999984306749440.0;while(1){SC();p=+g[9352+(r<<4)>>2];t=+g[9352+(r<<4)+4>>2];v=+g[9352+(r<<4)+12>>2];if(p*p+t*t+0.0>.01?(C=+g[A+3272+(r<<4)>>2],y=+g[A+3272+(r<<4)+4>>2],z=+g[A+3272+(r<<4)+8>>2],F=+g[A+2280+(r<<4)>>2],E=+g[A+2280+(r<<4)+4>>2],D=+g[A+2280+(r<<4)+8>>2],z=p*(F*+g[j>>2]+E*+g[j+4>>2]+D*+g[j+8>>2]+ +g[j+48>>2]-(C*+g[h>>2]+y*+g[h+4>>2]+z*+g[h+8>>2]+ +g[h+48>>2]))+t*(F*+g[j+16>>2]+E*+g[j+20>>2]+D*+g[j+24>>2]+ +g[j+52>>2]-(C*+g[h+16>>2]+y*+g[h+20>>2]+z*+g[h+24>>2]+ +g[h+52>>2]))+0.0,z<x):0){u=(g[k>>2]=p,c[k>>2]|0);s=(g[k>>2]=t,c[k>>2]|0);p=z}else{v=w;p=x}r=r+1|0;if((r|0)==(b|0)){q=s;r=0;break}else{w=v;x=p}}}else{q=0;u=0;s=0;r=0;x=0.0;p=999999984306749440.0;while(1){SC();t=+g[9352+(q<<4)>>2];v=+g[9352+(q<<4)+4>>2];z=+g[9352+(q<<4)+8>>2];y=+g[9352+(q<<4)+12>>2];if(t*t+v*v+z*z>.01?(D=+g[A+3272+(q<<4)>>2],E=+g[A+3272+(q<<4)+4>>2],w=+g[A+3272+(q<<4)+8>>2],G=+g[A+2280+(q<<4)>>2],F=+g[A+2280+(q<<4)+4>>2],C=+g[A+2280+(q<<4)+8>>2],w=t*(G*+g[j>>2]+F*+g[j+4>>2]+C*+g[j+8>>2]+ +g[j+48>>2]-(D*+g[h>>2]+E*+g[h+4>>2]+w*+g[h+8>>2]+ +g[h+48>>2]))+v*(G*+g[j+16>>2]+F*+g[j+20>>2]+C*+g[j+24>>2]+ +g[j+52>>2]-(D*+g[h+16>>2]+E*+g[h+20>>2]+w*+g[h+24>>2]+ +g[h+52>>2]))+z*(G*+g[j+32>>2]+F*+g[j+36>>2]+C*+g[j+40>>2]+ +g[j+56>>2]-(D*+g[h+32>>2]+E*+g[h+36>>2]+w*+g[h+40>>2]+ +g[h+56>>2])),w<p):0){u=(g[k>>2]=t,c[k>>2]|0);s=(g[k>>2]=v,c[k>>2]|0);r=(g[k>>2]=z,c[k>>2]|0);v=y;p=w}else v=x;q=q+1|0;if((q|0)==(b|0)){q=s;break}else x=v}}else{u=0;q=0;r=0;v=0.0;p=999999984306749440.0}switch(c[e+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+Tb[c[(c[e>>2]|0)+48>>2]&15](e)}x=(c[k>>2]=u,+g[k>>2]);y=(c[k>>2]=q,+g[k>>2]);z=(c[k>>2]=r,+g[k>>2]);switch(c[f+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+Tb[c[(c[f>>2]|0)+48>>2]&15](f)}if(p<0.0){h=0;i=A;return h|0}switch(c[e+4>>2]|0){case 8:{w=+g[e+28>>2]*+g[e+12>>2];break}case 0:{w=+g[e+44>>2];break}case 1:{w=+g[e+44>>2];break}case 13:{w=+g[e+44>>2];break}case 11:{w=+g[e+44>>2];break}case 10:{w=+g[e+44>>2];break}case 4:case 5:{w=+g[e+44>>2];break}default:w=+Tb[c[(c[e>>2]|0)+48>>2]&15](e)}s=c[f+4>>2]|0;switch(s|0){case 8:{s=8;t=+g[f+28>>2]*+g[f+12>>2];break}case 0:{s=0;t=+g[f+44>>2];break}case 1:{s=1;t=+g[f+44>>2];break}case 13:{s=13;t=+g[f+44>>2];break}case 11:{s=11;t=+g[f+44>>2];break}case 10:{s=10;t=+g[f+44>>2];break}case 4:case 5:{t=+g[f+44>>2];break}default:{t=+Tb[c[(c[f>>2]|0)+48>>2]&15](f);s=c[f+4>>2]|0}}p=p+(w+t+.5);c[A+216>>2]=10508;c[A+216+4>>2]=0;c[A+216+8>>2]=1065353216;c[A+216+12>>2]=0;g[A+216+16>>2]=0.0;c[A+216+20>>2]=0;c[A+216+24>>2]=d;c[A+216+28>>2]=e;c[A+216+32>>2]=f;c[A+216+36>>2]=c[e+4>>2];c[A+216+40>>2]=s;g[A+216+44>>2]=+Tb[c[(c[e>>2]|0)+48>>2]&15](e);g[A+216+48>>2]=+Tb[c[(c[f>>2]|0)+48>>2]&15](f);a[A+216+52>>0]=0;c[A+216+60>>2]=-1;c[A+216+72>>2]=1;c[A+216+76>>2]=1;w=+g[h+48>>2]+x*p;D=y*p+ +g[h+52>>2];E=z*p+ +g[h+56>>2];c[A+64>>2]=c[h>>2];c[A+64+4>>2]=c[h+4>>2];c[A+64+8>>2]=c[h+8>>2];c[A+64+12>>2]=c[h+12>>2];c[A+64+16>>2]=c[h+16>>2];c[A+64+16+4>>2]=c[h+16+4>>2];c[A+64+16+8>>2]=c[h+16+8>>2];c[A+64+16+12>>2]=c[h+16+12>>2];c[A+64+32>>2]=c[h+32>>2];c[A+64+32+4>>2]=c[h+32+4>>2];c[A+64+32+8>>2]=c[h+32+8>>2];c[A+64+32+12>>2]=c[h+32+12>>2];g[A+64+48>>2]=w;g[A+64+52>>2]=D;g[A+64+56>>2]=E;g[A+64+60>>2]=0.0;c[A+64+64>>2]=c[j>>2];c[A+64+64+4>>2]=c[j+4>>2];c[A+64+64+8>>2]=c[j+8>>2];c[A+64+64+12>>2]=c[j+12>>2];c[A+64+80>>2]=c[j+16>>2];c[A+64+80+4>>2]=c[j+16+4>>2];c[A+64+80+8>>2]=c[j+16+8>>2];c[A+64+80+12>>2]=c[j+16+12>>2];c[A+64+96>>2]=c[j+32>>2];c[A+64+96+4>>2]=c[j+32+4>>2];c[A+64+96+8>>2]=c[j+32+8>>2];c[A+64+96+12>>2]=c[j+32+12>>2];c[A+64+112>>2]=c[j+48>>2];c[A+64+112+4>>2]=c[j+48+4>>2];c[A+64+112+8>>2]=c[j+48+8>>2];c[A+64+112+12>>2]=c[j+48+12>>2];g[A+64+128>>2]=999999984306749440.0;c[A>>2]=10352;a[A+40>>0]=0;g[A+216+4>>2]=-x;g[A+216+8>>2]=-y;g[A+216+12>>2]=-z;g[A+216+16>>2]=0.0;nD(A+216|0,A+64|0,A,o,0);p=p-+g[A+36>>2];b=a[A+40>>0]|0;if(b<<24>>24){D=+g[A+24>>2]-y*p;E=+g[A+28>>2]-z*p;g[m>>2]=+g[A+20>>2]-x*p;g[m+4>>2]=D;g[m+8>>2]=E;g[m+12>>2]=0.0;c[n>>2]=c[A+20>>2];c[n+4>>2]=c[A+20+4>>2];c[n+8>>2]=c[A+20+8>>2];c[n+12>>2]=c[A+20+12>>2];c[l>>2]=u;c[l+4>>2]=q;c[l+8>>2]=r;g[l+12>>2]=v}h=b<<24>>24!=0;i=A;return h|0}function SC(){if(a[2144]|0)return;if(!(Wa(2144)|0))return;c[2338]=0;c[2339]=-2147483648;c[2340]=-1082130432;g[2341]=0.0;c[2342]=1060716128;c[2343]=-1090087446;c[2344]=-1092290076;g[2345]=0.0;c[2346]=-1098022214;c[2347]=-1084636126;c[2348]=-1092290076;g[2349]=0.0;c[2350]=-1083901670;c[2351]=-2147483648;c[2352]=-1092290177;g[2353]=0.0;c[2354]=-1098022214;c[2355]=1062847522;c[2356]=-1092290043;g[2357]=0.0;c[2358]=1060716128;c[2359]=1057396202;c[2360]=-1092290076;g[2361]=0.0;c[2362]=1049461434;c[2363]=-1084636126;c[2364]=1055193605;g[2365]=0.0;c[2366]=-1086767520;c[2367]=-1090087446;c[2368]=1055193572;g[2369]=0.0;c[2370]=-1086767520;c[2371]=1057396202;c[2372]=1055193572;g[2373]=0.0;c[2374]=1049461434;c[2375]=1062847522;c[2376]=1055193572;g[2377]=0.0;c[2378]=1063581978;c[2379]=0;c[2380]=1055193471;g[2381]=0.0;c[2382]=-2147483648;c[2383]=0;c[2384]=1065353216;g[2385]=0.0;c[2386]=1054458864;c[2387]=-1096927567;c[2388]=-1084636042;g[2389]=0.0;c[2390]=-1104782626;c[2391]=-1090519208;c[2392]=-1084636042;g[2393]=0.0;c[2394]=1049007812;c[2395]=-1085334679;c[2396]=-1090087228;g[2397]=0.0;c[2398]=1054458864;c[2399]=1050556081;c[2400]=-1084636042;g[2401]=0.0;c[2402]=1062847505;c[2403]=-2147483648;c[2404]=-1090087262;g[2405]=0.0;c[2406]=-1090087362;c[2407]=-2147483648;c[2408]=-1084636076;g[2409]=0.0;c[2410]=-1087361736;c[2411]=-1090519141;c[2412]=-1090087262;g[2413]=0.0;c[2414]=-1104782626;c[2415]=1056964440;c[2416]=-1084636042;g[2417]=0.0;c[2418]=-1087361736;c[2419]=1056964507;c[2420]=-1090087262;g[2421]=0.0;c[2422]=1049007812;c[2423]=1062148969;c[2424]=-1090087228;g[2425]=0.0;c[2426]=1064532105;c[2427]=1050556148;c[2428]=0;g[2429]=0.0;c[2430]=1064532105;c[2431]=-1096927500;c[2432]=0;g[2433]=0.0;c[2434]=1058437413;c[2435]=-1085334595;c[2436]=0;g[2437]=0.0;c[2438]=0;c[2439]=-1082130432;c[2440]=0;g[2441]=0.0;c[2442]=-1089046235;c[2443]=-1085334595;c[2444]=0;g[2445]=0.0;c[2446]=-1082951543;c[2447]=-1096927500;c[2448]=-2147483648;g[2449]=0.0;c[2450]=-1082951543;c[2451]=1050556148;c[2452]=-2147483648;g[2453]=0.0;c[2454]=-1089046235;c[2455]=1062149053;c[2456]=-2147483648;g[2457]=0.0;c[2458]=-2147483648;c[2459]=1065353216;c[2460]=-2147483648;g[2461]=0.0;c[2462]=1058437413;c[2463]=1062149053;c[2464]=-2147483648;g[2465]=0.0;c[2466]=1060121912;c[2467]=-1090519141;c[2468]=1057396386;g[2469]=0.0;c[2470]=-1098475836;c[2471]=-1085334679;c[2472]=1057396420;g[2473]=0.0;c[2474]=-1084636143;c[2475]=0;c[2476]=1057396386;g[2477]=0.0;c[2478]=-1098475836;c[2479]=1062148969;c[2480]=1057396420;g[2481]=0.0;c[2482]=1060121912;c[2483]=1056964507;c[2484]=1057396386;g[2485]=0.0;c[2486]=1057396286;c[2487]=0;c[2488]=1062847572;g[2489]=0.0;c[2490]=1042701022;c[2491]=-1090519208;c[2492]=1062847606;g[2493]=0.0;c[2494]=-1093024784;c[2495]=-1096927567;c[2496]=1062847606;g[2497]=0.0;c[2498]=-1093024784;c[2499]=1050556081;c[2500]=1062847606;g[2501]=0.0;c[2502]=1042701022;c[2503]=1056964440;c[2504]=1062847606;g[2505]=0.0;_a(2144);return}function TC(a){a=a|0;YE(a);return}function UC(a,b,c){a=a|0;b=b|0;c=c|0;return}function VC(a,b,c){a=a|0;b=b|0;c=c|0;return}function WC(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;c[b+4>>2]=c[d>>2];c[b+4+4>>2]=c[d+4>>2];c[b+4+8>>2]=c[d+8>>2];c[b+4+12>>2]=c[d+12>>2];c[b+20>>2]=c[e>>2];c[b+20+4>>2]=c[e+4>>2];c[b+20+8>>2]=c[e+8>>2];c[b+20+12>>2]=c[e+12>>2];g[b+36>>2]=f;a[b+40>>0]=1;return}function XC(a){a=a|0;return}function YC(a){a=a|0;YE(a);return}function ZC(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0.0,z=0.0,A=0,B=0,C=0.0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0,ha=0.0;ga=i;i=i+128|0;x=c[b+4>>2]|0;a[x+312>>0]=0;c[x>>2]=0;a[x+356>>0]=1;c[x+292>>2]=1566444395;c[x+296>>2]=1566444395;c[x+300>>2]=1566444395;g[x+304>>2]=0.0;c[x+336>>2]=0;c[x+336+4>>2]=0;c[x+336+8>>2]=0;c[x+336+12>>2]=0;a[x+336+16>>0]=0;a[x+332>>0]=a[x+332>>0]&-16;n=+g[d+48>>2];m=+g[d+52>>2];t=+g[d+56>>2];o=+g[f+48>>2];u=+g[f+52>>2];v=+g[f+56>>2];M=+g[d>>2];T=+g[d+4>>2];U=+g[d+8>>2];V=+g[d+16>>2];N=+g[d+20>>2];P=+g[d+24>>2];Q=+g[d+32>>2];R=+g[d+36>>2];S=+g[d+40>>2];W=+g[f>>2];aa=+g[f+4>>2];ba=+g[f+8>>2];ca=+g[f+16>>2];X=+g[f+20>>2];Y=+g[f+24>>2];Z=+g[f+32>>2];_=+g[f+36>>2];$=+g[f+40>>2];da=+g[e+48>>2]-n-(+g[h+48>>2]-o);fa=+g[e+52>>2]-m-(+g[h+52>>2]-u);ea=+g[e+56>>2]-t-(+g[h+56>>2]-v);x=c[b+8>>2]|0;D=c[(c[x>>2]|0)+64>>2]|0;g[ga+96>>2]=M*-da+V*-fa+Q*-ea;g[ga+96+4>>2]=T*-da+N*-fa+R*-ea;g[ga+96+8>>2]=U*-da+P*-fa+S*-ea;g[ga+96+12>>2]=0.0;jc[D&127](ga+112|0,x,ga+96|0);H=+g[ga+112>>2];I=+g[ga+112+4>>2];G=+g[ga+112+8>>2];w=H*+g[d>>2]+I*+g[d+4>>2]+G*+g[d+8>>2]+ +g[d+48>>2];z=H*+g[d+16>>2]+I*+g[d+20>>2]+G*+g[d+24>>2]+ +g[d+52>>2];G=H*+g[d+32>>2]+I*+g[d+36>>2]+G*+g[d+40>>2]+ +g[d+56>>2];x=c[b+12>>2]|0;D=c[(c[x>>2]|0)+64>>2]|0;I=da*+g[f+4>>2]+fa*+g[f+20>>2]+ea*+g[f+36>>2];H=da*+g[f+8>>2]+fa*+g[f+24>>2]+ea*+g[f+40>>2];g[ga+64>>2]=da*+g[f>>2]+fa*+g[f+16>>2]+ea*+g[f+32>>2];g[ga+64+4>>2]=I;g[ga+64+8>>2]=H;g[ga+64+12>>2]=0.0;jc[D&127](ga+80|0,x,ga+64|0);H=+g[ga+80>>2];I=+g[ga+80+4>>2];y=+g[ga+80+8>>2];w=w-(H*+g[f>>2]+I*+g[f+4>>2]+y*+g[f+8>>2]+ +g[f+48>>2]);z=z-(H*+g[f+16>>2]+I*+g[f+20>>2]+y*+g[f+24>>2]+ +g[f+52>>2]);y=G-(H*+g[f+32>>2]+I*+g[f+36>>2]+y*+g[f+40>>2]+ +g[f+56>>2]);a:do if(w*w+z*z+y*y>9.999999747378752e-05){E=o;o=0.0;L=32;x=0;B=0;p=0;D=0;s=0;while(1){if(!L){r=x;s=B;q=p;l=D;break a}L=L+-1|0;r=c[b+8>>2]|0;q=c[(c[r>>2]|0)+64>>2]|0;I=-w;ha=-z;C=-y;g[ga+32>>2]=M*I+V*ha+Q*C;g[ga+32+4>>2]=T*I+N*ha+R*C;g[ga+32+8>>2]=U*I+P*ha+S*C;g[ga+32+12>>2]=0.0;jc[q&127](ga+48|0,r,ga+32|0);C=+g[ga+48>>2];ha=+g[ga+48+4>>2];I=+g[ga+48+8>>2];G=n+(M*C+T*ha+U*I);K=m+(V*C+N*ha+P*I);I=t+(Q*C+R*ha+S*I);r=c[b+12>>2]|0;q=c[(c[r>>2]|0)+64>>2]|0;g[ga>>2]=W*w+ca*z+Z*y;g[ga+4>>2]=aa*w+X*z+_*y;g[ga+8>>2]=ba*w+Y*z+$*y;g[ga+12>>2]=0.0;jc[q&127](ga+16|0,r,ga);ha=+g[ga+16>>2];C=+g[ga+16+4>>2];H=+g[ga+16+8>>2];F=E+(W*ha+aa*C+ba*H);J=u+(ca*ha+X*C+Y*H);H=v+(Z*ha+_*C+$*H);C=w*(G-F)+z*(K-J)+y*(I-H);r=(g[k>>2]=w,c[k>>2]|0);q=(g[k>>2]=z,c[k>>2]|0);l=(g[k>>2]=y,c[k>>2]|0);if(o>1.0){l=0;p=24;break}if(C>0.0){v=da*w+fa*z+ea*y;if(v>=-1.4210854715202004e-14){l=0;p=24;break}o=o-C/v;C=(1.0-o)*+g[f+48>>2]+o*+g[h+48>>2];n=+g[d+48>>2]*(1.0-o)+o*+g[e+48>>2];m=(1.0-o)*+g[d+52>>2]+o*+g[e+52>>2];t=(1.0-o)*+g[d+56>>2]+o*+g[e+56>>2];u=(1.0-o)*+g[f+52>>2]+o*+g[h+52>>2];v=(1.0-o)*+g[f+56>>2]+o*+g[h+56>>2]}else{C=E;r=x;s=B;q=p;l=D}A=c[b+4>>2]|0;B=c[A>>2]|0;if((B|0)>0){w=+g[A+308>>2];x=0;p=0;do{z=G-F-+g[A+4+(p<<4)>>2];y=K-J-+g[A+4+(p<<4)+4>>2];E=I-H-+g[A+4+(p<<4)+8>>2];x=x|z*z+y*y+E*E<=w;p=p+1|0}while((p|0)!=(B|0))}else x=0;if((+g[A+304>>2]==0.0?I-H==+g[A+300>>2]:0)?K-J==+g[A+296>>2]:0)p=G-F==+g[A+292>>2];else p=0;if(!(x|p)){g[A+292>>2]=G-F;g[A+296>>2]=K-J;g[A+300>>2]=I-H;g[A+304>>2]=0.0;a[A+356>>0]=1;g[A+4+(B<<4)>>2]=G-F;g[A+4+(B<<4)+4>>2]=K-J;g[A+4+(B<<4)+8>>2]=I-H;g[A+4+(B<<4)+12>>2]=0.0;x=c[A>>2]|0;g[A+84+(x<<4)>>2]=G;g[A+84+(x<<4)+4>>2]=K;g[A+84+(x<<4)+8>>2]=I;g[A+84+(x<<4)+12>>2]=0.0;x=c[A>>2]|0;g[A+164+(x<<4)>>2]=F;g[A+164+(x<<4)+4>>2]=J;g[A+164+(x<<4)+8>>2]=H;g[A+164+(x<<4)+12>>2]=0.0;c[A>>2]=(c[A>>2]|0)+1;A=c[b+4>>2]|0}x=yD(A)|0;w=+g[A+276>>2];z=+g[A+280>>2];y=+g[A+284>>2];if(!x)break a;if(!(w*w+z*z+y*y>9.999999747378752e-05))break a;else{E=C;x=r;B=s;p=q;D=l;s=c[A+288>>2]|0}}if((p|0)==24){i=ga;return l|0}}else{o=0.0;r=0;s=0;q=0;l=0}while(0);g[j+164>>2]=o;o=(c[k>>2]=r,+g[k>>2]);n=(c[k>>2]=q,+g[k>>2]);m=(c[k>>2]=l,+g[k>>2]);if(!(m*m+(n*n+o*o)>=1.4210854715202004e-14)){c[j+132>>2]=0;c[j+132+4>>2]=0;c[j+132+8>>2]=0;c[j+132+12>>2]=0;o=0.0;n=0.0;m=0.0}else{N=1.0/+O(+(m*m+(n*n+o*o)));g[j+132>>2]=o*N;g[j+136>>2]=n*N;g[j+140>>2]=m*N;c[j+144>>2]=s;o=o*N;n=n*N;m=m*N}if(da*o+fa*n+ea*m>=-+g[j+172>>2]){x=0;i=ga;return x|0}x=c[b+4>>2]|0;yD(x)|0;vF(j+148|0,x+260|0,16)|0;x=1;i=ga;return x|0}function _C(a){a=a|0;YE(a);return}function $C(b,e,f,h,j,l,m,n,o,p){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0,_=0.0,$=0.0;N=i;i=i+10240|0;W=+g[l+52>>2]-+g[j+52>>2];w=+g[l+56>>2]-+g[j+56>>2];g[N+16>>2]=+g[l+48>>2]-+g[j+48>>2];g[N+16+4>>2]=W;g[N+16+8>>2]=w;g[N+16+12>>2]=0.0;c[N+10088>>2]=f;c[N+10088+4>>2]=h;w=+g[l>>2];W=+g[j>>2];v=+g[l+16>>2];t=+g[j+16>>2];u=+g[l+32>>2];X=+g[j+32>>2];s=+g[j+4>>2];Y=+g[j+20>>2];P=+g[j+36>>2];q=+g[j+8>>2];A=+g[j+24>>2];x=+g[j+40>>2];V=+g[l+4>>2];U=+g[l+20>>2];T=+g[l+36>>2];S=+g[l+8>>2];R=+g[l+24>>2];Q=+g[l+40>>2];g[N+10088+8>>2]=w*W+v*t+u*X;g[N+10088+12>>2]=w*s+v*Y+u*P;g[N+10088+16>>2]=w*q+v*A+u*x;g[N+10088+20>>2]=0.0;g[N+10088+24>>2]=W*V+t*U+X*T;g[N+10088+28>>2]=s*V+Y*U+P*T;g[N+10088+32>>2]=q*V+A*U+x*T;g[N+10088+36>>2]=0.0;g[N+10088+40>>2]=W*S+t*R+X*Q;g[N+10088+44>>2]=s*S+Y*R+P*Q;g[N+10088+48>>2]=q*S+A*R+x*Q;g[N+10088+52>>2]=0.0;x=+g[l+48>>2]-+g[j+48>>2];A=+g[l+52>>2]-+g[j+52>>2];q=+g[l+56>>2]-+g[j+56>>2];P=+g[j>>2];Y=+g[l>>2];s=+g[j+16>>2];X=+g[l+16>>2];t=+g[j+32>>2];W=+g[l+32>>2];u=+g[j+4>>2];v=+g[j+20>>2];w=+g[j+36>>2];y=+g[j+8>>2];r=+g[j+24>>2];B=+g[j+40>>2];g[N+10088+56>>2]=P*Y+s*X+t*W;g[N+10088+60>>2]=P*V+s*U+t*T;g[N+10088+64>>2]=P*S+s*R+t*Q;g[N+10088+68>>2]=0.0;g[N+10088+72>>2]=Y*u+X*v+W*w;g[N+10088+76>>2]=V*u+U*v+T*w;g[N+10088+80>>2]=S*u+R*v+Q*w;g[N+10088+84>>2]=0.0;g[N+10088+88>>2]=Y*y+X*r+W*B;g[N+10088+92>>2]=V*y+U*r+T*B;g[N+10088+96>>2]=S*y+R*r+Q*B;g[N+10088+100>>2]=0.0;g[N+10088+104>>2]=x*P+A*s+q*t;g[N+10088+108>>2]=x*u+A*v+q*w;g[N+10088+112>>2]=x*y+A*r+q*B;g[N+10088+116>>2]=0.0;c[N+10088+120>>2]=71;c[N+10088+124>>2]=0;c[N+9708+364>>2]=0;c[N+9708+128>>2]=0;c[N+9708+128+4>>2]=0;c[N+9708+128+8>>2]=0;c[N+9708+128+12>>2]=0;c[N+9708+376>>2]=2;c[N+9708+368>>2]=0;g[N+9708+144>>2]=0.0;B=+g[N+16>>2];q=+g[N+16+4>>2];r=+g[N+16+8>>2];g[N+9328>>2]=-B;g[N+9328+4>>2]=-q;g[N+9328+8>>2]=-r;g[N+9328+12>>2]=0.0;a:do if((qD(N+9708|0,N+10088|0,N+9328|0)|0)==1){K=N+32+9280|0;J=N+32+9288|0;I=N+32+9292|0;c[K>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;c[N+32>>2]=9;M=N+32+40|0;c[N+32+9276>>2]=0;c[M>>2]=0;c[M+4>>2]=0;c[M+8>>2]=0;c[M+12>>2]=0;c[M+16>>2]=0;e=0;do{p=128-e+-1|0;c[N+32+2108+(p*56|0)+44>>2]=0;b=c[J>>2]|0;c[N+32+2108+(p*56|0)+48>>2]=b;if(b)c[b+44>>2]=N+32+2108+(p*56|0);c[J>>2]=N+32+2108+(p*56|0);c[I>>2]=(c[I>>2]|0)+1;e=e+1|0}while((e|0)!=128);F=c[N+9708+372>>2]|0;do if((c[F+32>>2]|0)>>>0>1?tD(N+9708|0)|0:0){H=N+32+9280|0;b=c[H>>2]|0;if(b){C=c[N+32+9284>>2]|0;D=c[I>>2]|0;do{e=b+44|0;p=b+48|0;z=c[p>>2]|0;if(z)c[z+44>>2]=c[e>>2];z=c[e>>2]|0;if(z)c[z+48>>2]=c[p>>2];if((c[H>>2]|0)==(b|0))c[H>>2]=c[p>>2];C=C+-1|0;c[b+44>>2]=0;c[p>>2]=c[J>>2];z=c[J>>2]|0;if(z)c[z+44>>2]=b;c[J>>2]=b;D=D+1|0;b=c[H>>2]|0}while((b|0)!=0);c[N+32+9284>>2]=C;c[I>>2]=D}c[N+32>>2]=0;c[N+32+9276>>2]=0;z=c[F>>2]|0;b=c[F+12>>2]|0;A=+g[b+16>>2];t=+g[z+16>>2]-A;v=+g[b+20>>2];w=+g[z+20>>2]-v;P=+g[b+24>>2];y=+g[z+24>>2]-P;b=c[F+4>>2]|0;x=+g[b+16>>2]-A;R=+g[b+20>>2]-v;u=+g[b+24>>2]-P;e=c[F+8>>2]|0;A=+g[e+16>>2]-A;v=+g[e+20>>2]-v;P=+g[e+24>>2]-P;if(t*R*P+(w*u*A+y*x*v-t*u*v-w*x*P)-y*R*A<0.0){c[F>>2]=b;c[F+4>>2]=z;p=c[F+16>>2]|0;c[F+16>>2]=c[F+20>>2];c[F+20>>2]=p;p=b;b=z}else p=z;D=uD(N+32|0,p,b,e,1)|0;C=uD(N+32|0,c[F+4>>2]|0,c[F>>2]|0,c[F+12>>2]|0,1)|0;p=uD(N+32|0,c[F+8>>2]|0,c[F+4>>2]|0,c[F+12>>2]|0,1)|0;E=uD(N+32|0,c[F>>2]|0,c[F+8>>2]|0,c[F+12>>2]|0,1)|0;if((c[N+32+9284>>2]|0)==4){b=c[K>>2]|0;B=+g[b+16>>2];e=c[b+48>>2]|0;if(e){q=B*B;while(1){B=+g[e+16>>2];z=B*B<q;b=z?e:b;e=c[e+48>>2]|0;if(!e)break;else q=z?B*B:q}}r=+g[b>>2];q=+g[b+4>>2];B=+g[b+8>>2];y=+g[b+12>>2];G=c[b+16>>2]|0;Z=c[b+20>>2]|0;z=c[b+24>>2]|0;e=c[b+28>>2]|0;a[D+52>>0]=0;c[D+32>>2]=C;a[C+52>>0]=0;c[C+32>>2]=D;a[D+53>>0]=0;c[D+36>>2]=p;a[p+52>>0]=1;c[p+32>>2]=D;a[D+54>>0]=0;c[D+40>>2]=E;a[E+52>>0]=2;c[E+32>>2]=D;a[C+53>>0]=2;c[C+36>>2]=E;a[E+54>>0]=1;c[E+40>>2]=C;a[C+54>>0]=1;c[C+40>>2]=p;a[p+53>>0]=2;c[p+36>>2]=C;a[p+54>>0]=1;c[p+40>>2]=E;a[E+53>>0]=2;c[E+36>>2]=p;c[N+32>>2]=0;F=b;E=Z;p=z;D=e;b=G;G=0;while(1){C=c[N+32+9276>>2]|0;if(C>>>0>=64){L=45;break}c[N+10216>>2]=0;c[N+10216+4>>2]=0;c[N+10216+8>>2]=0;c[N+32+9276>>2]=C+1;G=G+1|0;a[F+55>>0]=G;z=F+4|0;e=F+8|0;rD(N+9708|0,+g[F>>2],+g[z>>2],+g[e>>2],N+32+60+(C<<5)|0);if(+g[F>>2]*+g[N+32+60+(C<<5)+16>>2]+ +g[z>>2]*+g[N+32+60+(C<<5)+20>>2]+ +g[e>>2]*+g[N+32+60+(C<<5)+24>>2]-+g[F+16>>2]>9.999999747378752e-05)e=0;else{L=44;break}do{z=wD(N+32|0,G,N+32+60+(C<<5)|0,c[F+32+(e<<2)>>2]|0,d[F+52+e>>0]|0,N+10216|0)|0;e=e+1|0}while(z&e>>>0<3);if(!(z&(c[N+10216+8>>2]|0)>>>0>2)){L=43;break}p=c[N+10216>>2]|0;e=c[N+10216+4>>2]|0;a[p+53>>0]=2;c[p+36>>2]=e;a[e+54>>0]=1;c[e+40>>2]=p;e=F+44|0;p=F+48|0;b=c[p>>2]|0;if(b)c[b+44>>2]=c[e>>2];b=c[e>>2]|0;if(b)c[b+48>>2]=c[p>>2];if((c[H>>2]|0)==(F|0))c[H>>2]=c[p>>2];c[N+32+9284>>2]=(c[N+32+9284>>2]|0)+-1;c[F+44>>2]=0;c[p>>2]=c[J>>2];b=c[J>>2]|0;if(b)c[b+44>>2]=F;c[J>>2]=F;c[I>>2]=(c[I>>2]|0)+1;e=c[K>>2]|0;v=+g[e+16>>2];b=c[e+48>>2]|0;if(b){B=v*v;while(1){y=+g[b+16>>2];p=y*y<B;e=p?b:e;b=c[b+48>>2]|0;if(!b)break;else B=p?y*y:B}}r=+g[e>>2];q=+g[e+4>>2];B=+g[e+8>>2];y=+g[e+12>>2];b=c[e+16>>2]|0;C=c[e+20>>2]|0;z=c[e+24>>2]|0;D=c[e+28>>2]|0;if(G>>>0>=255)break;else{F=e;E=C;p=z}}if((L|0)==43){c[N+32>>2]=4;C=E;z=p}else if((L|0)==44){c[N+32>>2]=7;C=E;z=p}else if((L|0)==45){c[N+32>>2]=6;C=E;z=p}t=(c[k>>2]=b,+g[k>>2]);x=t*r;v=t*q;t=t*B;g[N+32+40>>2]=r;g[N+32+44>>2]=q;g[N+32+48>>2]=B;g[N+32+52>>2]=y;c[N+32+56>>2]=b;c[N+32+36>>2]=3;c[N+32+4>>2]=C;c[N+32+8>>2]=z;c[N+32+12>>2]=D;J=z;P=+g[J+16>>2]-x;y=+g[J+20>>2]-v;w=+g[J+24>>2]-t;I=D;s=+g[I+16>>2]-x;u=+g[I+20>>2]-v;R=+g[I+24>>2]-t;R=+O(+((P*u-y*s)*(P*u-y*s)+((y*R-w*u)*(y*R-w*u)+(w*s-P*R)*(w*s-P*R))));g[N+32+20>>2]=R;P=+g[I+16>>2]-x;s=+g[I+20>>2]-v;w=+g[I+24>>2]-t;I=C;u=+g[I+16>>2]-x;y=+g[I+20>>2]-v;A=+g[I+24>>2]-t;A=+O(+((P*y-s*u)*(P*y-s*u)+((s*A-w*y)*(s*A-w*y)+(w*u-P*A)*(w*u-P*A))));g[N+32+24>>2]=A;P=+g[I+16>>2]-x;u=+g[I+20>>2]-v;w=+g[I+24>>2]-t;x=+g[J+16>>2]-x;v=+g[J+20>>2]-v;y=+g[J+24>>2]-t;y=+O(+((P*v-u*x)*(P*v-u*x)+((u*y-w*v)*(u*y-w*v)+(w*x-P*y)*(w*x-P*y))));g[N+32+20>>2]=R/(y+(R+A));g[N+32+24>>2]=A/(y+(R+A));g[N+32+28>>2]=y/(y+(R+A));if((c[N+32>>2]|0)!=9)if(!(c[N+32+36>>2]|0)){u=0.0;t=0.0;v=0.0;break}else{z=N+32+36|0;L=52;break}else{y=0.0;x=0.0;w=0.0;s=0.0;r=0.0;q=0.0;A=0.0;B=0.0;v=0.0;b=0;break a}}else L=46}else L=46;while(0);if((L|0)==46){c[N+32>>2]=8;g[N+32+40>>2]=B;g[N+32+44>>2]=q;g[N+32+48>>2]=r;g[N+32+52>>2]=0.0;s=+O(+(B*B+q*q+r*r));if(s>0.0){g[N+32+40>>2]=1.0/s*B;g[N+32+44>>2]=1.0/s*q;g[N+32+48>>2]=1.0/s*r}else{c[M>>2]=1065353216;c[N+32+44>>2]=0;c[N+32+48>>2]=0}g[N+32+52>>2]=0.0;g[N+32+56>>2]=0.0;c[N+32+36>>2]=1;c[N+32+4>>2]=c[F>>2];g[N+32+20>>2]=1.0;z=N+32+36|0;L=52}if((L|0)==52){p=0;u=0.0;t=0.0;v=0.0;do{b=c[N+10088+120>>2]|0;J=c[N+10088+124>>2]|0;e=(c[N+10088>>2]|0)+(J>>1)|0;if(J&1)b=c[(c[e>>2]|0)+b>>2]|0;jc[b&127](N,e,c[N+32+4+(p<<2)>>2]|0);A=+g[N+32+20+(p<<2)>>2];u=u+ +g[N>>2]*A;v=v+A*+g[N+4>>2];t=t+A*+g[N+8>>2];p=p+1|0}while(p>>>0<(c[z>>2]|0)>>>0)}Y=+g[j>>2];X=+g[j+4>>2];W=+g[j+8>>2];Q=+g[j+16>>2];S=+g[j+20>>2];P=+g[j+24>>2];V=+g[j+32>>2];U=+g[j+36>>2];T=+g[j+40>>2];A=+g[j+48>>2];R=+g[j+52>>2];B=+g[j+56>>2];s=+g[M>>2];w=+g[N+32+56>>2];r=+g[N+32+44>>2];q=+g[N+32+48>>2];$=u-s*w;_=v-w*r;w=t-w*q;y=$*Y+_*X+w*W+A;x=$*Q+_*S+w*P+R;w=$*V+_*U+w*T+B;s=-s;r=-r;q=-q;A=u*Y+v*X+t*W+A;B=u*V+v*U+t*T+B;v=u*Q+v*S+t*P+R;b=1}else{y=0.0;x=0.0;w=0.0;s=0.0;r=0.0;q=0.0;A=0.0;B=0.0;v=0.0;b=0}while(0);if(b){g[n>>2]=A;g[n+4>>2]=v;g[n+8>>2]=B;g[n+12>>2]=0.0;g[o>>2]=y;g[o+4>>2]=x;g[o+8>>2]=w;g[o+12>>2]=0.0;g[m>>2]=s;g[m+4>>2]=r;g[m+8>>2]=q;g[m+12>>2]=0.0;n=1;i=N;return n|0}c[N+9708>>2]=f;c[N+9708+4>>2]=h;R=+g[l>>2];r=+g[j>>2];y=+g[l+16>>2];q=+g[j+16>>2];P=+g[l+32>>2];B=+g[j+32>>2];S=+g[j+4>>2];Q=+g[j+20>>2];T=+g[j+36>>2];V=+g[j+8>>2];X=+g[j+24>>2];_=+g[j+40>>2];x=+g[l+4>>2];w=+g[l+20>>2];v=+g[l+36>>2];u=+g[l+8>>2];t=+g[l+24>>2];s=+g[l+40>>2];g[N+9708+8>>2]=R*r+y*q+P*B;g[N+9708+12>>2]=R*S+y*Q+P*T;g[N+9708+16>>2]=R*V+y*X+P*_;g[N+9708+20>>2]=0.0;g[N+9708+24>>2]=r*x+q*w+B*v;g[N+9708+28>>2]=S*x+Q*w+T*v;g[N+9708+32>>2]=V*x+X*w+_*v;g[N+9708+36>>2]=0.0;g[N+9708+40>>2]=r*u+q*t+B*s;g[N+9708+44>>2]=S*u+Q*t+T*s;g[N+9708+48>>2]=V*u+X*t+_*s;g[N+9708+52>>2]=0.0;U=+g[l+48>>2]-+g[j+48>>2];W=+g[l+52>>2]-+g[j+52>>2];Y=+g[l+56>>2]-+g[j+56>>2];g[N+9708+56>>2]=R*r+y*q+P*B;g[N+9708+60>>2]=r*x+q*w+B*v;g[N+9708+64>>2]=r*u+q*t+B*s;g[N+9708+68>>2]=0.0;g[N+9708+72>>2]=R*S+y*Q+P*T;g[N+9708+76>>2]=S*x+Q*w+T*v;g[N+9708+80>>2]=S*u+Q*t+T*s;g[N+9708+84>>2]=0.0;g[N+9708+88>>2]=R*V+y*X+P*_;g[N+9708+92>>2]=V*x+X*w+_*v;g[N+9708+96>>2]=V*u+X*t+_*s;g[N+9708+100>>2]=0.0;g[N+9708+104>>2]=U*r+W*q+Y*B;g[N+9708+108>>2]=U*S+W*Q+Y*T;g[N+9708+112>>2]=U*V+W*X+Y*_;g[N+9708+116>>2]=0.0;c[N+9708+120>>2]=72;c[N+9708+124>>2]=0;c[N+9328+364>>2]=0;c[N+9328+128>>2]=0;c[N+9328+128+4>>2]=0;c[N+9328+128+8>>2]=0;c[N+9328+128+12>>2]=0;c[N+9328+376>>2]=2;c[N+9328+368>>2]=0;g[N+9328+144>>2]=0.0;if(qD(N+9328|0,N+9708|0,N+16|0)|0){n=0;i=N;return n|0}p=c[N+9328+372>>2]|0;if(!(c[p+32>>2]|0)){v=0.0;u=0.0;t=0.0;s=0.0;r=0.0;q=0.0}else{D=0;v=0.0;u=0.0;t=0.0;s=0.0;r=0.0;q=0.0;do{B=+g[p+16+(D<<2)>>2];b=c[N+9708+120>>2]|0;l=c[N+9708+124>>2]|0;e=(c[N+9708>>2]|0)+(l>>1)|0;if(l&1)b=c[(c[e>>2]|0)+b>>2]|0;jc[b&127](N+32|0,e,c[p+(D<<2)>>2]|0);v=v+B*+g[N+32>>2];t=t+B*+g[N+32+4>>2];u=u+B*+g[N+32+8>>2];b=c[(c[N+9328+372>>2]|0)+(D<<2)>>2]|0;w=-+g[b>>2];x=-+g[b+4>>2];y=-+g[b+8>>2];b=c[N+9708+120>>2]|0;l=c[N+9708+124>>2]|0;e=(c[N+9708+4>>2]|0)+(l>>1)|0;if(l&1)b=c[(c[e>>2]|0)+b>>2]|0;Y=+g[N+9708+24>>2]*w+ +g[N+9708+28>>2]*x+ +g[N+9708+32>>2]*y;X=+g[N+9708+40>>2]*w+ +g[N+9708+44>>2]*x+ +g[N+9708+48>>2]*y;g[N+10088>>2]=+g[N+9708+8>>2]*w+ +g[N+9708+12>>2]*x+ +g[N+9708+16>>2]*y;g[N+10088+4>>2]=Y;g[N+10088+8>>2]=X;g[N+10088+12>>2]=0.0;jc[b&127](N+10216|0,e,N+10088|0);X=+g[N+10216>>2];Y=+g[N+10216+4>>2];_=+g[N+10216+8>>2];s=s+B*(X*+g[N+9708+56>>2]+Y*+g[N+9708+60>>2]+_*+g[N+9708+64>>2]+ +g[N+9708+104>>2]);q=q+B*(X*+g[N+9708+72>>2]+Y*+g[N+9708+76>>2]+_*+g[N+9708+80>>2]+ +g[N+9708+108>>2]);r=r+B*(X*+g[N+9708+88>>2]+Y*+g[N+9708+92>>2]+_*+g[N+9708+96>>2]+ +g[N+9708+112>>2]);D=D+1|0;p=c[N+9328+372>>2]|0}while(D>>>0<(c[p+32>>2]|0)>>>0)}A=+g[j>>2];R=+g[j+4>>2];y=+g[j+8>>2];x=+g[j+16>>2];w=+g[j+20>>2];B=+g[j+24>>2];Q=+g[j+32>>2];T=+g[j+36>>2];U=+g[j+40>>2];P=+g[j+48>>2];S=+g[j+52>>2];V=+g[j+56>>2];W=v-s;X=t-q;_=u-r;Y=+O(+(W*W+X*X+_*_));Y=Y>9.999999747378752e-05?1.0/Y:1.0;g[n>>2]=v*A+t*R+u*y+P;g[n+4>>2]=v*x+t*w+u*B+S;g[n+8>>2]=v*Q+t*T+u*U+V;g[n+12>>2]=0.0;g[o>>2]=s*A+q*R+r*y+P;g[o+4>>2]=s*x+q*w+r*B+S;g[o+8>>2]=s*Q+q*T+r*U+V;g[o+12>>2]=0.0;g[m>>2]=Y*W;g[m+4>>2]=Y*X;g[m+8>>2]=Y*_;g[m+12>>2]=0.0;n=0;i=N;return n|0}function aD(a){a=a|0;YE(a);return}function bD(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0.0,m=0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0;u=i;i=i+288|0;q=c[b+4>>2]|0;a[q+312>>0]=0;c[q>>2]=0;a[q+356>>0]=1;c[q+292>>2]=1566444395;c[q+296>>2]=1566444395;c[q+300>>2]=1566444395;g[q+304>>2]=0.0;c[q+336>>2]=0;c[q+336+4>>2]=0;c[q+336+8>>2]=0;c[q+336+12>>2]=0;a[q+336+16>>0]=0;a[q+332>>0]=a[q+332>>0]&-16;r=+g[e+48>>2]-+g[d+48>>2]-(+g[h+48>>2]-+g[f+48>>2]);t=+g[e+52>>2]-+g[d+52>>2]-(+g[h+52>>2]-+g[f+52>>2]);s=+g[e+56>>2]-+g[d+56>>2]-(+g[h+56>>2]-+g[f+56>>2]);c[u+232>>2]=10440;g[u+232+36>>2]=999999984306749440.0;a[u+232+40>>0]=0;q=c[b+8>>2]|0;p=c[b+12>>2]|0;o=c[b+4>>2]|0;c[u+136>>2]=10508;c[u+136+4>>2]=0;c[u+136+8>>2]=1065353216;c[u+136+12>>2]=0;g[u+136+16>>2]=0.0;c[u+136+20>>2]=0;c[u+136+24>>2]=o;c[u+136+28>>2]=q;c[u+136+32>>2]=p;c[u+136+36>>2]=c[q+4>>2];c[u+136+40>>2]=c[p+4>>2];g[u+136+44>>2]=+Tb[c[(c[q>>2]|0)+48>>2]&15](q);g[u+136+48>>2]=+Tb[c[(c[p>>2]|0)+48>>2]&15](p);a[u+136+52>>0]=0;c[u+136+60>>2]=-1;c[u+136+72>>2]=1;c[u+136+76>>2]=1;g[u+128>>2]=999999984306749440.0;c[u>>2]=c[d>>2];c[u+4>>2]=c[d+4>>2];c[u+8>>2]=c[d+8>>2];c[u+12>>2]=c[d+12>>2];c[u+16>>2]=c[d+16>>2];c[u+16+4>>2]=c[d+16+4>>2];c[u+16+8>>2]=c[d+16+8>>2];c[u+16+12>>2]=c[d+16+12>>2];c[u+32>>2]=c[d+32>>2];c[u+32+4>>2]=c[d+32+4>>2];c[u+32+8>>2]=c[d+32+8>>2];c[u+32+12>>2]=c[d+32+12>>2];c[u+48>>2]=c[d+48>>2];c[u+48+4>>2]=c[d+48+4>>2];c[u+48+8>>2]=c[d+48+8>>2];c[u+48+12>>2]=c[d+48+12>>2];c[u+64>>2]=c[f>>2];c[u+64+4>>2]=c[f+4>>2];c[u+64+8>>2]=c[f+8>>2];c[u+64+12>>2]=c[f+12>>2];c[u+80>>2]=c[f+16>>2];c[u+80+4>>2]=c[f+16+4>>2];c[u+80+8>>2]=c[f+16+8>>2];c[u+80+12>>2]=c[f+16+12>>2];c[u+96>>2]=c[f+32>>2];c[u+96+4>>2]=c[f+32+4>>2];c[u+96+8>>2]=c[f+32+8>>2];c[u+96+12>>2]=c[f+32+12>>2];c[u+112>>2]=c[f+48>>2];c[u+112+4>>2]=c[f+48+4>>2];c[u+112+8>>2]=c[f+48+8>>2];c[u+112+12>>2]=c[f+48+12>>2];nD(u+136|0,u,u+232|0,0,0);p=(a[u+232+40>>0]|0)==0;q=u+232+20|0;c[u+216>>2]=c[q>>2];c[u+216+4>>2]=c[q+4>>2];c[u+216+8>>2]=c[q+8>>2];c[u+216+12>>2]=c[q+12>>2];if(p){h=0;i=u;return h|0}n=+g[u+232+36>>2];l=+g[u+232+16>>2];o=c[u+232+4>>2]|0;b=c[u+232+8>>2]|0;m=c[u+232+12>>2]|0;do if(n>1.0000000474974513e-03){l=0.0;p=0;while(1){if((p|0)>31){b=0;p=13;break}w=r*(c[k>>2]=o,+g[k>>2]);w=w+t*(c[k>>2]=b,+g[k>>2]);v=l;l=l-n/(w+s*(c[k>>2]=m,+g[k>>2]));if(!(!(l<=v)&(!(l<0.0)&!(l>1.0)))){b=0;p=13;break}Cb[c[c[j>>2]>>2]&31](j,l);n=1.0-l;g[u+48>>2]=n*+g[d+48>>2]+l*+g[e+48>>2];g[u+52>>2]=n*+g[d+52>>2]+l*+g[e+52>>2];g[u+56>>2]=n*+g[d+56>>2]+l*+g[e+56>>2];g[u+112>>2]=n*+g[f+48>>2]+l*+g[h+48>>2];g[u+116>>2]=n*+g[f+52>>2]+l*+g[h+52>>2];g[u+120>>2]=n*+g[f+56>>2]+l*+g[h+56>>2];nD(u+136|0,u,u+232|0,0,0);if(!(a[u+232+40>>0]|0)){b=0;p=13;break}n=+g[u+232+36>>2];if(n<0.0){p=8;break};c[u+216>>2]=c[q>>2];c[u+216+4>>2]=c[q+4>>2];c[u+216+8>>2]=c[q+8>>2];c[u+216+12>>2]=c[q+12>>2];o=c[u+232+4>>2]|0;b=c[u+232+8>>2]|0;m=c[u+232+12>>2]|0;if(!(n>1.0000000474974513e-03)){p=10;break}else p=p+1|0}if((p|0)==8){g[j+164>>2]=l;f=c[u+232+8>>2]|0;e=c[u+232+12>>2]|0;h=c[u+232+16>>2]|0;c[j+132>>2]=c[u+232+4>>2];c[j+136>>2]=f;c[j+140>>2]=e;c[j+144>>2]=h;c[j+148>>2]=c[q>>2];c[j+148+4>>2]=c[q+4>>2];c[j+148+8>>2]=c[q+8>>2];c[j+148+12>>2]=c[q+12>>2];h=1;i=u;return h|0}else if((p|0)==10){n=l;l=+g[u+232+16>>2];break}else if((p|0)==13){i=u;return b|0}}else n=0.0;while(0);r=r*(c[k>>2]=o,+g[k>>2]);r=r+t*(c[k>>2]=b,+g[k>>2]);if(r+s*(c[k>>2]=m,+g[k>>2])>=-+g[j+172>>2]){h=0;i=u;return h|0}g[j+164>>2]=n;c[j+132>>2]=o;c[j+136>>2]=b;c[j+140>>2]=m;g[j+144>>2]=l;c[j+148>>2]=c[u+216>>2];c[j+148+4>>2]=c[u+216+4>>2];c[j+148+8>>2]=c[u+216+8>>2];c[j+148+12>>2]=c[u+216+12>>2];h=1;i=u;return h|0}function cD(a){a=a|0;YE(a);return}function dD(a,b,c){a=a|0;b=b|0;c=c|0;return}function eD(a,b,c){a=a|0;b=b|0;c=c|0;return}function fD(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;if(!(+g[b+36>>2]>f))return;a[b+40>>0]=1;c[b+4>>2]=c[d>>2];c[b+4+4>>2]=c[d+4>>2];c[b+4+8>>2]=c[d+8>>2];c[b+4+12>>2]=c[d+12>>2];c[b+20>>2]=c[e>>2];c[b+20+4>>2]=c[e+4>>2];c[b+20+8>>2]=c[e+8>>2];c[b+20+12>>2]=c[e+12>>2];g[b+36>>2]=f;return}function gD(a){a=a|0;YE(a);return}function hD(a){a=a|0;return}function iD(a,b,c,d,e,f,h,i,j,k,l){a=a|0;b=b|0;c=+c;d=+d;e=+e;f=+f;h=+h;i=+i;j=j|0;k=k|0;l=+l;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;x=+g[a>>2]*f+ +g[a+16>>2]*h+ +g[a+32>>2]*i;v=+g[a+4>>2]*f+ +g[a+20>>2]*h+ +g[a+36>>2]*i;t=+g[a+8>>2]*f+ +g[a+24>>2]*h+ +g[a+40>>2]*i;s=+g[b>>2]*f+ +g[b+16>>2]*h+ +g[b+32>>2]*i;q=+g[b+4>>2]*f+ +g[b+20>>2]*h+ +g[b+36>>2]*i;o=+g[b+8>>2]*f+ +g[b+24>>2]*h+ +g[b+40>>2]*i;w=+g[j+80>>2];u=+g[j+84>>2];p=+g[j+88>>2];r=+g[k+80>>2];m=+g[k+84>>2];n=+g[k+88>>2];p=x*(x<0.0?-w:w)+v*(v<0.0?-u:u)+t*(t<0.0?-p:p);n=s*(s<0.0?-r:r)+q*(q<0.0?-m:m)+o*(o<0.0?-n:n);o=+g[j+96>>2];m=+g[k+96>>2];m=(p>o?p:o)+(n>m?n:m);return !((c*f+d*h+e*i+m<m-(c*f+d*h+e*i)?c*f+d*h+e*i+m:m-(c*f+d*h+e*i))>l)|0}function jD(b,d,e,f,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;var l=0,m=0,n=0.0,o=0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0,I=0,J=0,K=0.0,L=0.0,M=0.0,N=0.0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0;$=i;i=i+64|0;a[$+32+16>>0]=1;_=$+32+12|0;c[_>>2]=0;c[$+32+4>>2]=0;c[$+32+8>>2]=0;q=c[f+4>>2]|0;if((q|0)>0){c[2703]=(c[2703]|0)+1;m=XE((q<<4|3)+16|0)|0;if(!m)l=0;else{c[(m+4+15&-16)+-4>>2]=m;l=m+4+15&-16}o=c[$+32+4>>2]|0;if((o|0)>0){m=0;do{T=l+(m<<4)|0;Q=(c[_>>2]|0)+(m<<4)|0;c[T>>2]=c[Q>>2];c[T+4>>2]=c[Q+4>>2];c[T+8>>2]=c[Q+8>>2];c[T+12>>2]=c[Q+12>>2];m=m+1|0}while((m|0)!=(o|0))}m=c[_>>2]|0;if(m){if(a[$+32+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[m+-4>>2]|0)}c[_>>2]=0}a[$+32+16>>0]=1;c[_>>2]=l;c[$+32+8>>2]=q}else l=0;u=c[d+28>>2]|0;if((u|0)>0){Y=c[d+36>>2]|0;t=+g[e>>2];s=+g[e+4>>2];E=+g[e+8>>2];F=+g[e+16>>2];G=+g[e+20>>2];w=+g[e+24>>2];n=+g[e+32>>2];p=+g[e+36>>2];r=+g[e+40>>2];x=+g[b>>2];y=+g[b+4>>2];z=+g[b+8>>2];Z=-1;D=3402823466385288598117041.0e14;o=0;while(1){A=+g[Y+(o*36|0)+20>>2];B=+g[Y+(o*36|0)+24>>2];C=+g[Y+(o*36|0)+28>>2];q=(A*t+B*s+C*E)*x+(A*F+B*G+C*w)*y+(A*n+B*p+C*r)*z<D;Z=q?o:Z;o=o+1|0;if((o|0)==(u|0))break;else D=q?(A*t+B*s+C*E)*x+(A*F+B*G+C*w)*y+(A*n+B*p+C*r)*z:D}if((Z|0)>=0){Q=c[Y+(Z*36|0)+4>>2]|0;if((Q|0)>0){R=Y+(Z*36|0)+12|0;S=Y+(Z*36|0)+20|0;T=Y+(Z*36|0)+24|0;q=Y+(Z*36|0)+28|0;D=E;B=F;C=G;O=f;f=$+32|0;P=0;while(1){J=c[R>>2]|0;o=c[J+(P<<2)>>2]|0;I=c[d+16>>2]|0;P=P+1|0;J=c[J+(((P|0)==(Q|0)?0:P)<<2)>>2]|0;E=+g[I+(o<<4)>>2];F=E-+g[I+(J<<4)>>2];x=+g[I+(o<<4)+4>>2];G=x-+g[I+(J<<4)+4>>2];A=+g[I+(o<<4)+8>>2];z=A-+g[I+(J<<4)+8>>2];N=F*t+G*s+z*D;L=F*B+G*C+z*w;z=F*n+G*p+z*r;G=+g[S>>2];F=+g[T>>2];y=+g[q>>2];M=t*G+s*F+D*y;K=B*G+C*F+w*y;y=n*G+p*F+r*y;B=(E*t+x*s+A*D+ +g[e+48>>2])*-(L*y-z*K)+(E*B+x*C+A*w+ +g[e+52>>2])*-(z*M-N*y)+(E*n+x*p+A*r+ +g[e+56>>2])*-(N*K-L*M);J=O;I=f;o=c[J+4>>2]|0;if((o|0)>=2){m=c[J+12>>2]|0;C=+g[m+(o+-1<<4)>>2];E=+g[m+(o+-1<<4)+4>>2];F=+g[m+(o+-1<<4)+8>>2];D=C*-(L*y-z*K)+E*-(z*M-N*y)+F*-(N*K-L*M)-B;H=0;while(1){x=+g[m+(H<<4)>>2];A=+g[m+(H<<4)+4>>2];p=+g[m+(H<<4)+8>>2];l=c[m+(H<<4)+12>>2]|0;n=x*-(L*y-z*K)+A*-(z*M-N*y)+p*-(N*K-L*M)-B;do if(D<0.0)if(n<0.0){u=c[I+4>>2]|0;if((u|0)==(c[I+8>>2]|0)?(V=(u|0)!=0?u<<1:1,(u|0)<(V|0)):0){if(!V)m=0;else{c[2703]=(c[2703]|0)+1;u=XE((V<<4|3)+16|0)|0;if(!u)m=0;else{c[(u+4+15&-16)+-4>>2]=u;m=u+4+15&-16}u=c[I+4>>2]|0}if((u|0)>0){v=0;do{aa=m+(v<<4)|0;ba=(c[I+12>>2]|0)+(v<<4)|0;c[aa>>2]=c[ba>>2];c[aa+4>>2]=c[ba+4>>2];c[aa+8>>2]=c[ba+8>>2];c[aa+12>>2]=c[ba+12>>2];v=v+1|0}while((v|0)!=(u|0))}u=c[I+12>>2]|0;if(u){if(a[I+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[u+-4>>2]|0)}c[I+12>>2]=0}a[I+16>>0]=1;c[I+12>>2]=m;c[I+8>>2]=V;u=c[I+4>>2]|0}v=c[I+12>>2]|0;g[v+(u<<4)>>2]=x;g[v+(u<<4)+4>>2]=A;g[v+(u<<4)+8>>2]=p;c[v+(u<<4)+12>>2]=l;c[I+4>>2]=(c[I+4>>2]|0)+1;break}else{w=D/(D-n);D=C+(x-C)*w;G=E+(A-E)*w;F=F+(p-F)*w;u=c[I+4>>2]|0;if((u|0)==(c[I+8>>2]|0)?(X=(u|0)!=0?u<<1:1,(u|0)<(X|0)):0){if(!X)m=0;else{c[2703]=(c[2703]|0)+1;u=XE((X<<4|3)+16|0)|0;if(!u)m=0;else{c[(u+4+15&-16)+-4>>2]=u;m=u+4+15&-16}u=c[I+4>>2]|0}if((u|0)>0){v=0;do{l=m+(v<<4)|0;aa=(c[I+12>>2]|0)+(v<<4)|0;c[l>>2]=c[aa>>2];c[l+4>>2]=c[aa+4>>2];c[l+8>>2]=c[aa+8>>2];c[l+12>>2]=c[aa+12>>2];v=v+1|0}while((v|0)!=(u|0))}u=c[I+12>>2]|0;if(u){if(a[I+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[u+-4>>2]|0)}c[I+12>>2]=0}a[I+16>>0]=1;c[I+12>>2]=m;c[I+8>>2]=X;u=c[I+4>>2]|0}v=c[I+12>>2]|0;g[v+(u<<4)>>2]=D;g[v+(u<<4)+4>>2]=G;g[v+(u<<4)+8>>2]=F;g[v+(u<<4)+12>>2]=0.0;c[I+4>>2]=(c[I+4>>2]|0)+1;break}else if(n<0.0){G=D/(D-n);D=C+(x-C)*G;E=E+(A-E)*G;G=F+(p-F)*G;u=c[I+4>>2]|0;if((u|0)==(c[I+8>>2]|0)?(W=(u|0)!=0?u<<1:1,(u|0)<(W|0)):0){if(!W)m=0;else{c[2703]=(c[2703]|0)+1;u=XE((W<<4|3)+16|0)|0;if(!u)m=0;else{c[(u+4+15&-16)+-4>>2]=u;m=u+4+15&-16}u=c[I+4>>2]|0}if((u|0)>0){v=0;do{aa=m+(v<<4)|0;ba=(c[I+12>>2]|0)+(v<<4)|0;c[aa>>2]=c[ba>>2];c[aa+4>>2]=c[ba+4>>2];c[aa+8>>2]=c[ba+8>>2];c[aa+12>>2]=c[ba+12>>2];v=v+1|0}while((v|0)!=(u|0))}u=c[I+12>>2]|0;if(u){if(a[I+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[u+-4>>2]|0)}c[I+12>>2]=0}a[I+16>>0]=1;c[I+12>>2]=m;c[I+8>>2]=W;u=c[I+4>>2]|0}v=c[I+12>>2]|0;g[v+(u<<4)>>2]=D;g[v+(u<<4)+4>>2]=E;g[v+(u<<4)+8>>2]=G;g[v+(u<<4)+12>>2]=0.0;u=(c[I+4>>2]|0)+1|0;c[I+4>>2]=u;if((u|0)==(c[I+8>>2]|0)?(U=(u|0)!=0?u<<1:1,(u|0)<(U|0)):0){if(!U)m=0;else{c[2703]=(c[2703]|0)+1;u=XE((U<<4|3)+16|0)|0;if(!u)m=0;else{c[(u+4+15&-16)+-4>>2]=u;m=u+4+15&-16}u=c[I+4>>2]|0}if((u|0)>0){v=0;do{aa=m+(v<<4)|0;ba=(c[I+12>>2]|0)+(v<<4)|0;c[aa>>2]=c[ba>>2];c[aa+4>>2]=c[ba+4>>2];c[aa+8>>2]=c[ba+8>>2];c[aa+12>>2]=c[ba+12>>2];v=v+1|0}while((v|0)!=(u|0))}u=c[I+12>>2]|0;if(u){if(a[I+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[u+-4>>2]|0)}c[I+12>>2]=0}a[I+16>>0]=1;c[I+12>>2]=m;c[I+8>>2]=U;u=c[I+4>>2]|0}v=c[I+12>>2]|0;g[v+(u<<4)>>2]=x;g[v+(u<<4)+4>>2]=A;g[v+(u<<4)+8>>2]=p;c[v+(u<<4)+12>>2]=l;c[I+4>>2]=(c[I+4>>2]|0)+1}while(0);u=H+1|0;if((u|0)==(o|0))break;m=c[J+12>>2]|0;D=n;C=x;E=A;F=p;H=u}o=c[J+4>>2]|0}if((o|0)<0){if((c[J+8>>2]|0)<0){m=c[J+12>>2]|0;if(m){if(a[J+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[m+-4>>2]|0)}c[J+12>>2]=0}a[J+16>>0]=1;c[J+12>>2]=0;c[J+8>>2]=0}do{v=(c[J+12>>2]|0)+(o<<4)|0;c[v>>2]=c[$+16>>2];c[v+4>>2]=c[$+16+4>>2];c[v+8>>2]=c[$+16+8>>2];c[v+12>>2]=c[$+16+12>>2];o=o+1|0}while((o|0)!=0)}c[J+4>>2]=0;t=+g[e>>2];s=+g[e+4>>2];D=+g[e+8>>2];B=+g[e+16>>2];C=+g[e+20>>2];w=+g[e+24>>2];n=+g[e+32>>2];p=+g[e+36>>2];r=+g[e+40>>2];if((P|0)>=(Q|0)){u=e+56|0;v=e+48|0;l=e+52|0;m=S;o=T;break}else{v=f;f=O;O=v}}}else{D=E;B=F;C=G;u=e+56|0;v=e+48|0;l=e+52|0;m=Y+(Z*36|0)+20|0;o=Y+(Z*36|0)+24|0;q=Y+(Z*36|0)+28|0}A=+g[m>>2];y=+g[o>>2];z=+g[q>>2];t=A*t+y*s+z*D;s=A*B+y*C+z*w;r=A*n+y*p+z*r;p=+g[Y+(Z*36|0)+32>>2]-(t*+g[v>>2]+s*+g[l>>2]+r*+g[u>>2]);l=c[f+4>>2]|0;if((l|0)>0){o=0;do{e=c[f+12>>2]|0;m=e+(o<<4)|0;n=p+(t*+g[m>>2]+s*+g[e+(o<<4)+4>>2]+r*+g[e+(o<<4)+8>>2]);n=n<=h?h:n;if(n<=j){c[$>>2]=c[m>>2];c[$+4>>2]=c[m+4>>2];c[$+8>>2]=c[m+8>>2];c[$+12>>2]=c[m+12>>2];ic[c[(c[k>>2]|0)+16>>2]&15](k,b,$,n);l=c[f+4>>2]|0}o=o+1|0}while((o|0)<(l|0))}l=c[_>>2]|0}}if(!l){i=$;return}if(a[$+32+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[l+-4>>2]|0)}c[_>>2]=0;i=$;return}function kD(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0,M=0,N=0,O=0;h=i;i=i+288|0;if(!(c[b+16>>2]|0)){K=c[b+12>>2]|0;b=c[b+20>>2]|0;n=+g[d>>2];q=+g[d+4>>2];u=+g[d+8>>2];k=+g[d+16>>2];r=+g[d+20>>2];j=+g[d+24>>2];m=+g[d+32>>2];s=+g[d+36>>2];l=+g[d+40>>2];F=+g[d+48>>2];E=+g[d+52>>2];D=+g[d+56>>2];J=+g[e>>2];I=+g[e+16>>2];y=+g[e+32>>2];H=+g[e+4>>2];G=+g[e+20>>2];w=+g[e+36>>2];v=+g[e+8>>2];z=+g[e+24>>2];x=+g[e+40>>2];C=-+g[e+48>>2];B=-+g[e+52>>2];p=-+g[e+56>>2];d=c[(c[K>>2]|0)+64>>2]|0;A=-+g[b+48>>2];t=-+g[b+52>>2];o=-+g[b+56>>2];g[h+32>>2]=(n*J+k*I+m*y)*A+(n*H+k*G+m*w)*t+(n*v+k*z+m*x)*o;g[h+32+4>>2]=(q*J+r*I+s*y)*A+(q*H+r*G+s*w)*t+(q*v+r*z+s*x)*o;g[h+32+8>>2]=(u*J+j*I+l*y)*A+(u*H+j*G+l*w)*t+(u*v+j*z+l*x)*o;g[h+32+12>>2]=0.0;jc[d&127](h+48|0,K,h+32|0);o=+g[h+48>>2];t=+g[h+48+4>>2];A=+g[h+48+8>>2];y=F*J+E*I+D*y+(J*C+I*B+y*p)+((n*J+k*I+m*y)*o+(q*J+r*I+s*y)*t+(u*J+j*I+l*y)*A);w=F*H+E*G+D*w+(H*C+G*B+w*p)+((n*H+k*G+m*w)*o+(q*H+r*G+s*w)*t+(u*H+j*G+l*w)*A);A=F*v+E*z+D*x+(v*C+z*B+x*p)+((n*v+k*z+m*x)*o+(q*v+r*z+s*x)*t+(u*v+j*z+l*x)*A);x=+g[b+48>>2];l=+g[b+52>>2];z=+g[b+56>>2];j=z*A+(x*y+l*w)-+g[b+64>>2];v=+g[e>>2];u=+g[e+4>>2];t=+g[e+8>>2];s=+g[e+16>>2];r=+g[e+20>>2];q=+g[e+24>>2];o=+g[e+32>>2];m=+g[e+36>>2];k=+g[e+40>>2];n=s*(y-x*j)+(w-l*j)*r+(A-z*j)*q+ +g[e+52>>2];p=(y-x*j)*o+(w-l*j)*m+(A-z*j)*k+ +g[e+56>>2];g[h+16>>2]=t*(A-z*j)+(v*(y-x*j)+u*(w-l*j))+ +g[e+48>>2];g[h+16+4>>2]=n;g[h+16+8>>2]=p;g[h+16+12>>2]=0.0;p=+g[b+48>>2];n=+g[b+52>>2];l=+g[b+56>>2];g[h>>2]=v*p+u*n+t*l;g[h+4>>2]=p*s+n*r+l*q;g[h+8>>2]=p*o+n*m+l*k;g[h+12>>2]=0.0;ic[c[(c[f>>2]|0)+16>>2]&15](f,h,h+16|0,j);i=h;return}else{N=c[b+4>>2]|0;a[N+312>>0]=0;c[N>>2]=0;a[N+356>>0]=1;c[N+292>>2]=1566444395;c[N+296>>2]=1566444395;c[N+300>>2]=1566444395;g[N+304>>2]=0.0;c[N+336>>2]=0;c[N+336+4>>2]=0;c[N+336+8>>2]=0;c[N+336+12>>2]=0;a[N+336+16>>0]=0;a[N+332>>0]=a[N+332>>0]&-16;N=c[b+12>>2]|0;M=c[b+16>>2]|0;L=c[N+4>>2]|0;K=c[M+4>>2]|0;D=+Tb[c[(c[N>>2]|0)+48>>2]&15](N);O=c[b+16>>2]|0;E=+Tb[c[(c[O>>2]|0)+48>>2]&15](O);O=c[b+4>>2]|0;b=c[b+8>>2]|0;c[h+200>>2]=10508;c[h+200+4>>2]=0;c[h+200+8>>2]=1065353216;c[h+200+12>>2]=0;g[h+200+16>>2]=0.0;c[h+200+20>>2]=b;c[h+200+24>>2]=O;c[h+200+28>>2]=N;c[h+200+32>>2]=M;c[h+200+36>>2]=L;c[h+200+40>>2]=K;g[h+200+44>>2]=D;g[h+200+48>>2]=E;a[h+200+52>>0]=0;c[h+200+60>>2]=-1;c[h+200+72>>2]=1;c[h+200+76>>2]=1;g[h+64+128>>2]=999999984306749440.0;c[h+64>>2]=c[d>>2];c[h+64+4>>2]=c[d+4>>2];c[h+64+8>>2]=c[d+8>>2];c[h+64+12>>2]=c[d+12>>2];c[h+64+16>>2]=c[d+16>>2];c[h+64+16+4>>2]=c[d+16+4>>2];c[h+64+16+8>>2]=c[d+16+8>>2];c[h+64+16+12>>2]=c[d+16+12>>2];c[h+64+32>>2]=c[d+32>>2];c[h+64+32+4>>2]=c[d+32+4>>2];c[h+64+32+8>>2]=c[d+32+8>>2];c[h+64+32+12>>2]=c[d+32+12>>2];c[h+64+48>>2]=c[d+48>>2];c[h+64+48+4>>2]=c[d+48+4>>2];c[h+64+48+8>>2]=c[d+48+8>>2];c[h+64+48+12>>2]=c[d+48+12>>2];c[h+64+64>>2]=c[e>>2];c[h+64+64+4>>2]=c[e+4>>2];c[h+64+64+8>>2]=c[e+8>>2];c[h+64+64+12>>2]=c[e+12>>2];c[h+64+80>>2]=c[e+16>>2];c[h+64+80+4>>2]=c[e+16+4>>2];c[h+64+80+8>>2]=c[e+16+8>>2];c[h+64+80+12>>2]=c[e+16+12>>2];c[h+64+96>>2]=c[e+32>>2];c[h+64+96+4>>2]=c[e+32+4>>2];c[h+64+96+8>>2]=c[e+32+8>>2];c[h+64+96+12>>2]=c[e+32+12>>2];c[h+64+112>>2]=c[e+48>>2];c[h+64+112+4>>2]=c[e+48+4>>2];c[h+64+112+8>>2]=c[e+48+8>>2];c[h+64+112+12>>2]=c[e+48+12>>2];nD(h+200|0,h+64|0,f,0,0);i=h;return}}function lD(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0,m=0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0;D=i;i=i+304|0;A=+g[e+48>>2]-+g[d+48>>2];C=+g[e+52>>2]-+g[d+52>>2];B=+g[e+56>>2]-+g[d+56>>2];Bp(d,e,D+256|0,D+192|0);v=+g[D+192>>2];t=+g[D+256>>2]*v;u=v*+g[D+256+4>>2];v=v*+g[D+256+8>>2];g[D+176>>2]=t;g[D+176+4>>2]=u;g[D+176+8>>2]=v;g[D+176+12>>2]=0.0;x=+g[h+48>>2]-+g[f+48>>2];z=+g[h+52>>2]-+g[f+52>>2];y=+g[h+56>>2]-+g[f+56>>2];Bp(f,h,D+256|0,D+192|0);s=+g[D+192>>2];n=+g[D+256>>2]*s;r=s*+g[D+256+4>>2];s=s*+g[D+256+8>>2];g[D+160>>2]=n;g[D+160+4>>2]=r;g[D+160+8>>2]=s;g[D+160+12>>2]=0.0;h=c[b+12>>2]|0;p=+Tb[c[(c[h>>2]|0)+16>>2]&15](h);h=c[b+16>>2]|0;if(!h)q=0.0;else q=+Tb[c[(c[h>>2]|0)+16>>2]&15](h);t=p*+O(+(t*t+u*u+v*v))+q*+O(+(n*n+r*r+s*s));if(t+ +O(+((x-A)*(x-A)+(z-C)*(z-C)+(y-B)*(y-B)))==0.0){f=0;i=D;return f|0}c[D+256>>2]=10440;g[D+256+36>>2]=999999984306749440.0;a[D+256+40>>0]=0;kD(b,d,f,D+256|0);w=(a[D+256+40>>0]|0)==0;c[D+144>>2]=c[D+256+20>>2];c[D+144+4>>2]=c[D+256+20+4>>2];c[D+144+8>>2]=c[D+256+20+8>>2];c[D+144+12>>2]=c[D+256+20+12>>2];a:do if(!w?(o=c[D+256+4>>2]|0,m=c[D+256+8>>2]|0,l=c[D+256+12>>2]|0,v=(x-A)*(c[k>>2]=o,+g[k>>2]),v=v+(z-C)*(c[k>>2]=m,+g[k>>2]),!(t+(v+(y-B)*(c[k>>2]=l,+g[k>>2]))<=1.1920928955078125e-07)):0){n=+g[D+256+16>>2];p=+g[D+256+36>>2]+ +g[j+172>>2];b:do if(p>1.0000000474974513e-03){v=p;u=0.0;w=0;while(1){e=c[j+168>>2]|0;if(e){h=c[(c[e>>2]|0)+20>>2]|0;c[D+128>>2]=1065353216;c[D+128+4>>2]=1065353216;c[D+128+8>>2]=1065353216;g[D+128+12>>2]=0.0;Ib[h&7](e,D+144|0,.20000000298023224,D+128|0)}p=(x-A)*(c[k>>2]=o,+g[k>>2]);p=(z-C)*(c[k>>2]=m,+g[k>>2])+p;p=t+((y-B)*(c[k>>2]=l,+g[k>>2])+p);if(p<=1.1920928955078125e-07){l=0;break a}p=u+v/p;if(!(!(p<=u)&(!(p<0.0)&!(p>1.0)))){l=0;break a}Ap(d,A,C,B,D+176|0,p,D+192|0);Ap(f,x,z,y,D+160|0,p,D+64|0);e=c[j+168>>2]|0;if(e){h=c[(c[e>>2]|0)+20>>2]|0;c[D>>2]=1065353216;c[D+4>>2]=0;c[D+8>>2]=0;g[D+12>>2]=0.0;Ib[h&7](e,D+192+48|0,.20000000298023224,D)}Cb[c[c[j>>2]>>2]&31](j,p);c[D+16>>2]=10440;g[D+16+36>>2]=999999984306749440.0;a[D+16+40>>0]=0;kD(b,D+192|0,D+64|0,D+16|0);if(!(a[D+16+40>>0]|0)){l=15;break}n=+g[D+16+36>>2];q=+g[j+172>>2];c[D+144>>2]=c[D+16+20>>2];c[D+144+4>>2]=c[D+16+20+4>>2];c[D+144+8>>2]=c[D+16+20+8>>2];c[D+144+12>>2]=c[D+16+20+12>>2];h=w+1|0;if((w|0)>63){l=16;break}l=c[D+16+12>>2]|0;m=c[D+16+8>>2]|0;o=c[D+16+4>>2]|0;v=n+q;if(!(v>1.0000000474974513e-03)){n=+g[D+16+16>>2];break b}else{u=p;w=h}}if((l|0)==15)jc[c[(c[j>>2]|0)+8>>2]&127](j,-1,w);else if((l|0)==16)jc[c[(c[j>>2]|0)+8>>2]&127](j,-2,h);l=0;break a}else p=0.0;while(0);g[j+164>>2]=p;c[j+132>>2]=o;c[j+136>>2]=m;c[j+140>>2]=l;g[j+144>>2]=n;c[j+148>>2]=c[D+144>>2];c[j+148+4>>2]=c[D+144+4>>2];c[j+148+8>>2]=c[D+144+8>>2];c[j+148+12>>2]=c[D+144+12>>2];l=1}else l=0;while(0);f=l;i=D;return f|0}function mD(a){a=a|0;YE(a);return}function nD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0,N=0,P=0.0,Q=0.0,R=0.0,S=0;N=i;i=i+288|0;g[b+56>>2]=0.0;L=N+272+4|0;M=N+272+8|0;c[N+272>>2]=0;c[N+272+4>>2]=0;c[N+272+8>>2]=0;c[N+272+12>>2]=0;c[N+208>>2]=c[d>>2];c[N+208+4>>2]=c[d+4>>2];c[N+208+8>>2]=c[d+8>>2];c[N+208+12>>2]=c[d+12>>2];c[N+208+16>>2]=c[d+16>>2];c[N+208+16+4>>2]=c[d+16+4>>2];c[N+208+16+8>>2]=c[d+16+8>>2];c[N+208+16+12>>2]=c[d+16+12>>2];c[N+208+32>>2]=c[d+32>>2];c[N+208+32+4>>2]=c[d+32+4>>2];c[N+208+32+8>>2]=c[d+32+8>>2];c[N+208+32+12>>2]=c[d+32+12>>2];u=N+208+48|0;c[u>>2]=c[d+48>>2];c[u+4>>2]=c[d+48+4>>2];c[u+8>>2]=c[d+48+8>>2];c[u+12>>2]=c[d+48+12>>2];c[N+144>>2]=c[d+64>>2];c[N+144+4>>2]=c[d+64+4>>2];c[N+144+8>>2]=c[d+64+8>>2];c[N+144+12>>2]=c[d+64+12>>2];c[N+144+16>>2]=c[d+80>>2];c[N+144+16+4>>2]=c[d+80+4>>2];c[N+144+16+8>>2]=c[d+80+8>>2];c[N+144+16+12>>2]=c[d+80+12>>2];c[N+144+32>>2]=c[d+96>>2];c[N+144+32+4>>2]=c[d+96+4>>2];c[N+144+32+8>>2]=c[d+96+8>>2];c[N+144+32+12>>2]=c[d+96+12>>2];v=N+144+48|0;c[v>>2]=c[d+112>>2];c[v+4>>2]=c[d+112+4>>2];c[v+8>>2]=c[d+112+8>>2];c[v+12>>2]=c[d+112+12>>2];F=+g[u>>2];G=+g[v>>2];H=+g[N+208+52>>2];I=+g[N+144+52>>2];J=+g[N+208+56>>2];K=+g[N+144+56>>2];g[u>>2]=F-(F+G)*.5;g[N+208+52>>2]=H-(H+I)*.5;g[N+208+56>>2]=J-(J+K)*.5;g[v>>2]=G-(F+G)*.5;g[N+144+52>>2]=I-(H+I)*.5;g[N+144+56>>2]=K-(J+K)*.5;if(((c[(c[b+28>>2]|0)+4>>2]|0)+-17|0)>>>0<2)h=((c[(c[b+32>>2]|0)+4>>2]|0)+-17|0)>>>0<2;else h=0;D=+g[b+44>>2];E=+g[b+48>>2];c[2624]=(c[2624]|0)+1;v=(a[b+52>>0]|0)==0;c[b+64>>2]=0;c[b+4>>2]=0;c[b+8>>2]=1065353216;c[b+12>>2]=0;g[b+16>>2]=0.0;c[b+68>>2]=0;c[b+60>>2]=-1;E=v?E:0.0;D=(v?D:0.0)+E;v=c[b+24>>2]|0;a[v+312>>0]=0;c[v>>2]=0;a[v+356>>0]=1;c[v+292>>2]=1566444395;c[v+296>>2]=1566444395;c[v+300>>2]=1566444395;g[v+304>>2]=0.0;c[v+336>>2]=0;c[v+336+4>>2]=0;c[v+336+8>>2]=0;c[v+336+12>>2]=0;a[v+336+16>>0]=0;a[v+332>>0]=a[v+332>>0]&-16;k=+g[b+4>>2];j=+g[b+8>>2];l=+g[b+12>>2];a:do if(h){m=j;j=999999984306749440.0;while(1){p=-k;r=-m;n=-l;t=+g[d+4>>2]*p+ +g[d+20>>2]*r+ +g[d+36>>2]*n;B=+g[d+8>>2]*p+ +g[d+24>>2]*r+ +g[d+40>>2]*n;g[N+128>>2]=+g[d>>2]*p+ +g[d+16>>2]*r+ +g[d+32>>2]*n;g[N+128+4>>2]=t;g[N+128+8>>2]=B;g[N+128+12>>2]=0.0;B=k*+g[d+68>>2]+m*+g[d+84>>2]+l*+g[d+100>>2];t=k*+g[d+72>>2]+m*+g[d+88>>2]+l*+g[d+104>>2];g[N+112>>2]=+g[d+64>>2]*k+ +g[d+80>>2]*m+ +g[d+96>>2]*l;g[N+112+4>>2]=B;g[N+112+8>>2]=t;g[N+112+12>>2]=0.0;Ky(N+96|0,c[b+28>>2]|0,N+128|0);Ky(N+80|0,c[b+32>>2]|0,N+112|0);t=+g[N+96>>2];B=+g[N+96+4>>2];n=+g[N+96+8>>2];r=t*+g[N+208>>2]+B*+g[N+208+4>>2]+n*+g[N+208+8>>2]+ +g[N+208+48>>2];n=t*+g[N+208+16>>2]+B*+g[N+208+20>>2]+n*+g[N+208+24>>2]+ +g[N+208+52>>2];B=+g[N+80>>2];t=+g[N+80+4>>2];p=+g[N+80+8>>2];s=B*+g[N+144>>2]+t*+g[N+144+4>>2]+p*+g[N+144+8>>2]+ +g[N+144+48>>2];p=B*+g[N+144+16>>2]+t*+g[N+144+20>>2]+p*+g[N+144+24>>2]+ +g[N+144+52>>2];t=+g[b+4>>2]*(r-s)+ +g[b+8>>2]*(n-p)+ +g[b+12>>2]*0.0;if(t>0.0?t*t>j*+g[d+128>>2]:0){S=22;break a}u=c[b+24>>2]|0;v=c[u>>2]|0;if((v|0)>0){q=+g[u+308>>2];o=0;h=0;do{z=r-s-+g[u+4+(h<<4)>>2];A=n-p-+g[u+4+(h<<4)+4>>2];B=0.0-+g[u+4+(h<<4)+8>>2];o=o|z*z+A*A+B*B<=q;h=h+1|0}while((h|0)!=(v|0))}else o=0;if((+g[u+304>>2]==0.0?+g[u+300>>2]==0.0:0)?n-p==+g[u+296>>2]:0)h=r-s==+g[u+292>>2];else h=0;if(o|h){S=31;break a}k=j-t;if(k<=j*9.999999974752427e-07){S=33;break a}g[u+292>>2]=r-s;g[u+296>>2]=n-p;g[u+300>>2]=0.0;g[u+304>>2]=0.0;a[u+356>>0]=1;g[u+4+(v<<4)>>2]=r-s;g[u+4+(v<<4)+4>>2]=n-p;g[u+4+(v<<4)+8>>2]=0.0;g[u+4+(v<<4)+12>>2]=0.0;v=c[u>>2]|0;g[u+84+(v<<4)>>2]=r;g[u+84+(v<<4)+4>>2]=n;g[u+84+(v<<4)+8>>2]=0.0;g[u+84+(v<<4)+12>>2]=0.0;v=c[u>>2]|0;g[u+164+(v<<4)>>2]=s;g[u+164+(v<<4)+4>>2]=p;g[u+164+(v<<4)+8>>2]=0.0;g[u+164+(v<<4)+12>>2]=0.0;c[u>>2]=(c[u>>2]|0)+1;u=c[b+24>>2]|0;v=yD(u)|0;k=+g[u+276>>2];m=+g[u+280>>2];l=+g[u+284>>2];n=+g[u+288>>2];if(!v){S=35;break a}q=j;j=k*k+m*m+l*l;if(j<9.999999974752427e-07){v=b+4|0;j=q;S=37;break a}if(q-j<=q*1.1920928955078125e-07){S=39;break a}g[b+4>>2]=k;g[b+8>>2]=m;g[b+12>>2]=l;g[b+16>>2]=n;v=c[b+64>>2]|0;c[b+64>>2]=v+1;if((v|0)>1e3){B=0.0;u=0;n=0.0;l=0.0;p=0.0;break a}if((c[c[b+24>>2]>>2]|0)==4){S=42;break}}}else{m=j;j=999999984306749440.0;while(1){x=-k;y=-m;w=-l;A=+g[d+4>>2]*x+ +g[d+20>>2]*y+ +g[d+36>>2]*w;B=+g[d+8>>2]*x+ +g[d+24>>2]*y+ +g[d+40>>2]*w;g[N+128>>2]=+g[d>>2]*x+ +g[d+16>>2]*y+ +g[d+32>>2]*w;g[N+128+4>>2]=A;g[N+128+8>>2]=B;g[N+128+12>>2]=0.0;B=k*+g[d+68>>2]+m*+g[d+84>>2]+l*+g[d+100>>2];A=k*+g[d+72>>2]+m*+g[d+88>>2]+l*+g[d+104>>2];g[N+112>>2]=+g[d+64>>2]*k+ +g[d+80>>2]*m+ +g[d+96>>2]*l;g[N+112+4>>2]=B;g[N+112+8>>2]=A;g[N+112+12>>2]=0.0;Ky(N+96|0,c[b+28>>2]|0,N+128|0);Ky(N+80|0,c[b+32>>2]|0,N+112|0);A=+g[N+96>>2];B=+g[N+96+4>>2];w=+g[N+96+8>>2];y=A*+g[N+208>>2]+B*+g[N+208+4>>2]+w*+g[N+208+8>>2]+ +g[N+208+48>>2];m=A*+g[N+208+16>>2]+B*+g[N+208+20>>2]+w*+g[N+208+24>>2]+ +g[N+208+52>>2];w=A*+g[N+208+32>>2]+B*+g[N+208+36>>2]+w*+g[N+208+40>>2]+ +g[N+208+56>>2];B=+g[N+80>>2];A=+g[N+80+4>>2];x=+g[N+80+8>>2];z=B*+g[N+144>>2]+A*+g[N+144+4>>2]+x*+g[N+144+8>>2]+ +g[N+144+48>>2];l=B*+g[N+144+16>>2]+A*+g[N+144+20>>2]+x*+g[N+144+24>>2]+ +g[N+144+52>>2];x=B*+g[N+144+32>>2]+A*+g[N+144+36>>2]+x*+g[N+144+40>>2]+ +g[N+144+56>>2];A=+g[b+4>>2]*(y-z)+ +g[b+8>>2]*(m-l)+ +g[b+12>>2]*(w-x);if(A>0.0?A*A>j*+g[d+128>>2]:0){S=22;break a}v=c[b+24>>2]|0;u=c[v>>2]|0;if((u|0)>0){r=+g[v+308>>2];h=0;o=0;do{n=y-z-+g[v+4+(o<<4)>>2];k=m-l-+g[v+4+(o<<4)+4>>2];B=w-x-+g[v+4+(o<<4)+8>>2];h=h|n*n+k*k+B*B<=r;o=o+1|0}while((o|0)!=(u|0))}else h=0;if((+g[v+304>>2]==0.0?w-x==+g[v+300>>2]:0)?m-l==+g[v+296>>2]:0)o=y-z==+g[v+292>>2];else o=0;if(h|o){S=31;break a}k=j-A;if(k<=j*9.999999974752427e-07){S=33;break a}g[v+292>>2]=y-z;g[v+296>>2]=m-l;g[v+300>>2]=w-x;g[v+304>>2]=0.0;a[v+356>>0]=1;g[v+4+(u<<4)>>2]=y-z;g[v+4+(u<<4)+4>>2]=m-l;g[v+4+(u<<4)+8>>2]=w-x;g[v+4+(u<<4)+12>>2]=0.0;u=c[v>>2]|0;g[v+84+(u<<4)>>2]=y;g[v+84+(u<<4)+4>>2]=m;g[v+84+(u<<4)+8>>2]=w;g[v+84+(u<<4)+12>>2]=0.0;u=c[v>>2]|0;g[v+164+(u<<4)>>2]=z;g[v+164+(u<<4)+4>>2]=l;g[v+164+(u<<4)+8>>2]=x;g[v+164+(u<<4)+12>>2]=0.0;c[v>>2]=(c[v>>2]|0)+1;u=c[b+24>>2]|0;v=yD(u)|0;k=+g[u+276>>2];m=+g[u+280>>2];l=+g[u+284>>2];n=+g[u+288>>2];if(!v){S=35;break a}q=j;j=k*k+m*m+l*l;if(j<9.999999974752427e-07){v=b+4|0;j=q;S=37;break a}if(q-j<=q*1.1920928955078125e-07){S=39;break a}g[b+4>>2]=k;g[b+8>>2]=m;g[b+12>>2]=l;g[b+16>>2]=n;v=c[b+64>>2]|0;c[b+64>>2]=v+1;if((v|0)>1e3){B=0.0;u=0;n=0.0;l=0.0;p=0.0;break a}if((c[c[b+24>>2]>>2]|0)==4){S=42;break}}}while(0);if((S|0)==22){c[b+68>>2]=10;S=43}else if((S|0)==31){c[b+68>>2]=1;S=43}else if((S|0)==33){c[b+68>>2]=!(k<=0.0)?11:2;S=43}else if((S|0)==35){c[b+68>>2]=3;S=43}else if((S|0)==37){g[v>>2]=k;g[b+8>>2]=m;g[b+12>>2]=l;g[b+16>>2]=n;c[b+68>>2]=6;S=43}else if((S|0)==39){c[b+68>>2]=12;S=43}else if((S|0)==42){c[b+68>>2]=13;B=0.0;u=0;n=0.0;l=0.0;p=0.0}do if((S|0)==43){v=c[b+24>>2]|0;yD(v)|0;n=+g[v+260>>2];l=+g[v+264>>2];p=+g[v+268>>2];c[N+272>>2]=c[b+4>>2];c[N+272+4>>2]=c[b+4+4>>2];c[N+272+8>>2]=c[b+4+8>>2];c[N+272+12>>2]=c[b+4+12>>2];m=+g[b+4>>2];k=+g[b+8>>2];q=+g[b+12>>2];if(m*m+k*k+q*q<.0001)c[b+68>>2]=5;if(m*m+k*k+q*q>1.4210854715202004e-14){B=1.0/+O(+(m*m+k*k+q*q));g[N+272>>2]=B*+g[N+272>>2];g[L>>2]=B*+g[L>>2];g[M>>2]=B*+g[M>>2];A=E/+O(+j);c[b+60>>2]=1;B=1.0/B-D;u=1;n=A*m+n;l=A*k+l;p=A*q+p;break}else{c[b+60>>2]=2;B=0.0;u=0;break}}while(0);if(((c[b+72>>2]|0)!=0?(c[b+20>>2]|0)!=0:0)?(c[b+68>>2]|0)!=0:0)h=D+B<.01;else h=0;v=u^1;do if(h|v?(C=c[b+20>>2]|0,(C|0)!=0):0){c[2623]=(c[2623]|0)+1;c[b+4>>2]=0;c[b+4+4>>2]=0;c[b+4+8>>2]=0;c[b+4+12>>2]=0;if(!(Gb[c[(c[C>>2]|0)+8>>2]&3](C,c[b+24>>2]|0,c[b+28>>2]|0,c[b+32>>2]|0,N+208|0,N+144|0,b+4|0,N+64|0,N+48|0,f)|0)){q=+g[b+4>>2];j=+g[b+8>>2];s=+g[b+12>>2];if(!(q*q+j*j+s*s>0.0)){S=66;break}k=+g[N+48>>2];z=+g[N+64>>2]-k;r=+g[N+48+4>>2];A=+g[N+64+4>>2]-r;t=+g[N+48+8>>2];m=+g[N+64+8>>2]-t;m=+O(+(z*z+A*A+m*m))-D;if(m<B|v){c[N+272>>2]=c[b+4>>2];c[N+272+4>>2]=c[b+4+4>>2];c[N+272+8>>2]=c[b+4+8>>2];c[N+272+12>>2]=c[b+4+12>>2];A=+g[N+272>>2];B=+g[L>>2];D=+g[M>>2];n=1.0/+O(+(A*A+B*B+D*D));g[N+272>>2]=A*n;g[L>>2]=B*n;g[M>>2]=D*n;c[b+60>>2]=6;n=E*q+k;k=E*j+r;j=E*s+t;break}c[b+60>>2]=5;if(u){m=B;k=l;j=p;break}i=N;return}A=+g[N+48>>2];q=+g[N+64>>2];k=+g[N+48+4>>2];m=+g[N+64+4>>2];j=+g[N+48+8>>2];s=+g[N+64+8>>2];if(!((A-q)*(A-q)+(k-m)*(k-m)+(j-s)*(j-s)<=1.4210854715202004e-14)){r=(A-q)*(A-q)+(k-m)*(k-m)+(j-s)*(j-s);w=A-q;x=j-s;y=0.0;z=k-m}else{w=+g[b+4>>2];z=+g[b+8>>2];x=+g[b+12>>2];r=w*w+z*z+x*x;y=+g[b+16>>2]}if(!(r>1.4210854715202004e-14)){c[b+60>>2]=9;if(u){m=B;k=l;j=p;break}i=N;return}t=1.0/+O(+r);m=-+O(+((q-A)*(q-A)+(m-k)*(m-k)+(s-j)*(s-j)));if(B>m|v){g[N+272>>2]=w*t;g[L>>2]=z*t;g[M>>2]=x*t;g[N+272+12>>2]=y;c[b+60>>2]=3;n=A;break}c[b+60>>2]=8;if(u){m=B;k=l;j=p}else{i=N;return}}else S=66;while(0);if((S|0)==66)if(u){m=B;k=l;j=p}else{i=N;return}if(!(m<0.0)?!(m*m<+g[d+128>>2]):0){i=N;return}if((c[b+76>>2]|0)!=0?(d=c[b+28>>2]|0,nc[c[(c[d>>2]|0)+8>>2]&127](d,N+208|0,N+32|0,N+16|0),B=(+g[N+16>>2]+ +g[N+32>>2])*.5,D=(+g[N+16+4>>2]+ +g[N+32+4>>2])*.5,E=(+g[N+16+8>>2]+ +g[N+32+8>>2])*.5,d=c[b+32>>2]|0,nc[c[(c[d>>2]|0)+8>>2]&127](d,N+144|0,N+32|0,N+16|0),P=+g[N+272>>2],Q=+g[L>>2],R=+g[M>>2],(B-(+g[N+32>>2]+ +g[N+16>>2])*.5)*P+(D-(+g[N+32+4>>2]+ +g[N+16+4>>2])*.5)*Q+(E-(+g[N+32+8>>2]+ +g[N+16+8>>2])*.5)*R<0.0):0){g[N+272>>2]=-P;g[L>>2]=-Q;g[M>>2]=-R};c[b+4>>2]=c[N+272>>2];c[b+4+4>>2]=c[N+272+4>>2];c[b+4+8>>2]=c[N+272+8>>2];c[b+4+12>>2]=c[N+272+12>>2];g[b+56>>2]=m;d=c[(c[e>>2]|0)+16>>2]|0;g[N>>2]=(F+G)*.5+n;g[N+4>>2]=(H+I)*.5+k;g[N+8>>2]=(J+K)*.5+j;g[N+12>>2]=0.0;ic[d&15](e,N+272|0,N,m);i=N;return}function oD(a){a=a|0;return}function pD(a){a=a|0;YE(a);return}function qD(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,j=0.0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0,v=0.0,w=0,x=0,y=0.0,z=0,A=0,B=0.0,C=0.0,D=0.0,E=0.0,F=0;A=i;i=i+176|0;c[a+348>>2]=a+220;c[a+352>>2]=a+252;c[a+356>>2]=a+284;c[a+360>>2]=a+316;c[a+364>>2]=4;c[a+368>>2]=0;c[a+376>>2]=0;w=c[b+4>>2]|0;c[a>>2]=c[b>>2];c[a+4>>2]=w;c[a+8>>2]=c[b+8>>2];c[a+8+4>>2]=c[b+8+4>>2];c[a+8+8>>2]=c[b+8+8>>2];c[a+8+12>>2]=c[b+8+12>>2];c[a+24>>2]=c[b+24>>2];c[a+24+4>>2]=c[b+24+4>>2];c[a+24+8>>2]=c[b+24+8>>2];c[a+24+12>>2]=c[b+24+12>>2];c[a+40>>2]=c[b+40>>2];c[a+40+4>>2]=c[b+40+4>>2];c[a+40+8>>2]=c[b+40+8>>2];c[a+40+12>>2]=c[b+40+12>>2];c[a+56>>2]=c[b+56>>2];c[a+56+4>>2]=c[b+56+4>>2];c[a+56+8>>2]=c[b+56+8>>2];c[a+56+12>>2]=c[b+56+12>>2];c[a+72>>2]=c[b+72>>2];c[a+72+4>>2]=c[b+72+4>>2];c[a+72+8>>2]=c[b+72+8>>2];c[a+72+12>>2]=c[b+72+12>>2];c[a+88>>2]=c[b+88>>2];c[a+88+4>>2]=c[b+88+4>>2];c[a+88+8>>2]=c[b+88+8>>2];c[a+88+12>>2]=c[b+88+12>>2];c[a+104>>2]=c[b+104>>2];c[a+104+4>>2]=c[b+104+4>>2];c[a+104+8>>2]=c[b+104+8>>2];c[a+104+12>>2]=c[b+104+12>>2];w=c[b+120+4>>2]|0;c[a+120>>2]=c[b+120>>2];c[a+120+4>>2]=w;g[a+144>>2]=0.0;c[a+180>>2]=0;c[a+128>>2]=c[d>>2];c[a+128+4>>2]=c[d+4>>2];c[a+128+8>>2]=c[d+8>>2];c[a+128+12>>2]=c[d+12>>2];e=+g[a+128>>2];h=+g[a+132>>2];j=+g[a+136>>2];if(e*e+h*h+j*j>0.0){b=(g[k>>2]=-e,c[k>>2]|0);d=(g[k>>2]=-h,c[k>>2]|0);f=(g[k>>2]=-j,c[k>>2]|0)}else{b=1065353216;d=0;f=0}g[a+164>>2]=0.0;c[a+364>>2]=3;c[a+148>>2]=a+316;c[a+180>>2]=1;t=(c[k>>2]=b,+g[k>>2]);v=(c[k>>2]=d,+g[k>>2]);rD(a,t,v,(c[k>>2]=f,+g[k>>2]),a+316|0);g[a+164>>2]=1.0;w=(c[a+148>>2]|0)+16|0;c[a+128>>2]=c[w>>2];c[a+128+4>>2]=c[w+4>>2];c[a+128+8>>2]=c[w+8>>2];c[a+128+12>>2]=c[w+12>>2];c[A+24+48>>2]=c[w>>2];c[A+24+48+4>>2]=c[w+4>>2];c[A+24+48+8>>2]=c[w+8>>2];c[A+24+48+12>>2]=c[w+12>>2];c[A+24+32>>2]=c[w>>2];c[A+24+32+4>>2]=c[w+4>>2];c[A+24+32+8>>2]=c[w+8>>2];c[A+24+32+12>>2]=c[w+12>>2];c[A+24+16>>2]=c[w>>2];c[A+24+16+4>>2]=c[w+4>>2];c[A+24+16+8>>2]=c[w+8>>2];c[A+24+16+12>>2]=c[w+12>>2];c[A+24>>2]=c[w>>2];c[A+24+4>>2]=c[w+4>>2];c[A+24+8>>2]=c[w+8>>2];c[A+24+12>>2]=c[w+12>>2];v=0.0;w=0;x=0;e=e*e+h*h+j*j;a:do{u=c[a+368>>2]|0;j=+g[a+128>>2];h=+g[a+132>>2];l=+g[a+136>>2];q=+O(+(j*j+h*h+l*l));if(q<9.999999747378752e-05){z=5;break}g[a+148+(u*36|0)+16+(c[a+148+(u*36|0)+32>>2]<<2)>>2]=0.0;n=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=n;c[a+148+(u*36|0)+(c[a+148+(u*36|0)+32>>2]<<2)>>2]=c[a+348+(n<<2)>>2];n=c[a+148+(u*36|0)+32>>2]|0;c[a+148+(u*36|0)+32>>2]=n+1;rD(a,-j,-h,-l,c[a+148+(u*36|0)+(n<<2)>>2]|0);n=c[a+148+(u*36|0)+32>>2]|0;m=c[a+148+(u*36|0)+(n+-1<<2)>>2]|0;l=+g[m+16>>2];j=+g[m+20>>2];h=+g[m+24>>2];p=l-+g[A+24>>2];r=j-+g[A+24+4>>2];t=h-+g[A+24+8>>2];if(p*p+r*r+t*t<9.999999747378752e-05){z=8;break}p=l-+g[A+24+16>>2];r=j-+g[A+24+20>>2];t=h-+g[A+24+24>>2];if(p*p+r*r+t*t<9.999999747378752e-05){z=8;break}p=l-+g[A+24+32>>2];r=j-+g[A+24+36>>2];t=h-+g[A+24+40>>2];if(p*p+r*r+t*t<9.999999747378752e-05){z=8;break}p=l-+g[A+24+48>>2];r=j-+g[A+24+52>>2];t=h-+g[A+24+56>>2];if(p*p+r*r+t*t<9.999999747378752e-05){z=8;break}w=w+1&3;s=A+24+(w<<4)|0;c[s>>2]=c[m+16>>2];c[s+4>>2]=c[m+16+4>>2];c[s+8>>2]=c[m+16+8>>2];c[s+12>>2]=c[m+16+12>>2];t=(+g[a+128>>2]*l+ +g[a+132>>2]*j+ +g[a+136>>2]*h)/q;v=t>v?t:v;if(q-v-q*9.999999747378752e-05<=0.0){z=9;break}c[A>>2]=0;b:do switch(n|0){case 2:{s=c[a+148+(u*36|0)>>2]|0;n=c[a+148+(u*36|0)+4>>2]|0;l=+g[n+16>>2];j=+g[s+16>>2];h=+g[n+20>>2];e=+g[s+20>>2];o=+g[n+24>>2];p=+g[s+24>>2];if(!((l-j)*(l-j)+(h-e)*(h-e)+(o-p)*(o-p)>0.0)){z=36;break a}q=-(j*(l-j)+e*(h-e)+p*(o-p))/((l-j)*(l-j)+(h-e)*(h-e)+(o-p)*(o-p));if(q>=1.0){g[A+8>>2]=0.0;g[A+8+4>>2]=1.0;c[A>>2]=2;e=l*l+h*h+o*o;break b}if(!(q<=0.0)){g[A+8+4>>2]=q;g[A+8>>2]=1.0-q;c[A>>2]=3;e=((l-j)*q+j)*((l-j)*q+j)+((h-e)*q+e)*((h-e)*q+e)+((o-p)*q+p)*((o-p)*q+p);break b}else{g[A+8>>2]=1.0;g[A+8+4>>2]=0.0;c[A>>2]=1;e=j*j+e*e+p*p;break b}}case 3:{e=+sD((c[a+148+(u*36|0)>>2]|0)+16|0,(c[a+148+(u*36|0)+4>>2]|0)+16|0,(c[a+148+(u*36|0)+8>>2]|0)+16|0,A+8|0,A);break}case 4:{f=c[a+148+(u*36|0)>>2]|0;b=c[a+148+(u*36|0)+4>>2]|0;d=c[a+148+(u*36|0)+8>>2]|0;s=c[a+148+(u*36|0)+12>>2]|0;c[A+152>>2]=f+16;c[A+152+4>>2]=b+16;c[A+152+8>>2]=d+16;c[A+152+12>>2]=s+16;o=+g[f+16>>2];l=+g[s+16>>2];q=+g[f+20>>2];j=+g[s+20>>2];p=+g[f+24>>2];h=+g[s+24>>2];g[A+104>>2]=o-l;g[A+104+4>>2]=q-j;g[A+104+8>>2]=p-h;g[A+104+12>>2]=0.0;B=+g[b+16>>2];D=+g[b+20>>2];r=+g[b+24>>2];g[A+104+16>>2]=B-l;g[A+104+20>>2]=D-j;g[A+104+24>>2]=r-h;g[A+104+28>>2]=0.0;e=+g[d+16>>2];E=+g[d+20>>2];C=+g[d+24>>2];g[A+104+32>>2]=e-l;g[A+104+36>>2]=E-j;g[A+104+40>>2]=C-h;g[A+104+44>>2]=0.0;t=(q-j)*(r-h)*(e-l)+(p-h)*(B-l)*(E-j)-(E-j)*((r-h)*(o-l))-(q-j)*(B-l)*(C-h)+(C-h)*((o-l)*(D-j))-(e-l)*((p-h)*(D-j));if(!(t!=t|0.0!=0.0|t==0.0|!(t*(p*((B-e)*(q-D)-(D-E)*(o-B))+(o*((D-E)*(p-r)-(r-C)*(q-D))+q*((r-C)*(o-B)-(B-e)*(p-r))))<=0.0))){c[A+92>>2]=0;c[A+92+4>>2]=0;c[A+92+8>>2]=0;c[A+88>>2]=0;r=q-j;p=p-h;q=o-l;n=0;e=-1.0;while(1){m=c[10520+(n<<2)>>2]|0;B=+g[A+104+(m<<4)+8>>2];D=+g[A+104+(m<<4)+4>>2];o=+g[A+104+(m<<4)>>2];if(t*((r*B-p*D)*l+j*(p*o-B*q)+(D*q-r*o)*h)>0.0?(y=+sD(c[A+152+(n<<2)>>2]|0,c[A+152+(m<<2)>>2]|0,s+16|0,A+92|0,A+88|0),e<0.0|y<e):0){F=c[A+88>>2]|0;c[A>>2]=((F&2|0)!=0?1<<m:0)+(F<<1&8)+((F&1|0)!=0?1<<n:0);c[A+8+(n<<2)>>2]=c[A+92>>2];c[A+8+(m<<2)>>2]=c[A+92+4>>2];g[A+8+(c[10520+(m<<2)>>2]<<2)>>2]=0.0;c[A+8+12>>2]=c[A+92+8>>2];e=y}n=n+1|0;if((n|0)==3)break;r=+g[A+104+(n<<4)+4>>2];p=+g[A+104+(n<<4)+8>>2];q=+g[A+104+(n<<4)>>2];l=+g[s+16>>2];j=+g[s+20>>2];h=+g[s+24>>2]}if(e<0.0){c[A>>2]=15;e=+g[d+20>>2];E=+g[b+24>>2];q=+g[s+16>>2];h=+g[d+24>>2];C=+g[b+16>>2];D=+g[s+20>>2];l=+g[d+16>>2];o=+g[s+24>>2];B=+g[b+20>>2];g[A+8>>2]=(e*E*q+h*C*D-D*(E*l)-e*C*o+o*(l*B)-q*(h*B))/t;j=+g[f+20>>2];r=+g[f+24>>2];p=+g[f+16>>2];g[A+8+4>>2]=(j*h*q+r*l*D-D*(h*p)-j*l*o+o*(p*e)-q*(r*e))/t;g[A+8+8>>2]=(B*r*q+E*p*D-D*(r*C)-B*p*o+o*(C*j)-q*(E*j))/t;g[A+8+12>>2]=1.0-((B*r*q+E*p*D-D*(r*C)-B*p*o+o*(C*j)-q*(E*j))/t+((e*E*q+h*C*D-D*(E*l)-e*C*o+o*(l*B)-q*(h*B))/t+(j*h*q+r*l*D-D*(h*p)-j*l*o+o*(p*e)-q*(r*e))/t));e=0.0}}else e=-1.0;break}default:{}}while(0);if(!(e>=0.0)){z=36;break}c[a+148+((1-u|0)*36|0)+32>>2]=0;c[a+128>>2]=0;c[a+128+4>>2]=0;c[a+128+8>>2]=0;c[a+128+12>>2]=0;c[a+368>>2]=1-u;f=c[a+148+(u*36|0)+32>>2]|0;b=c[A>>2]|0;if(f){n=0;do{m=a+148+(u*36|0)+(n<<2)|0;d=c[m>>2]|0;if(!(b&1<<n)){s=c[a+364>>2]|0;c[a+364>>2]=s+1;c[a+348+(s<<2)>>2]=d}else{c[a+148+((1-u|0)*36|0)+(c[a+148+((1-u|0)*36|0)+32>>2]<<2)>>2]=d;d=c[A+8+(n<<2)>>2]|0;s=c[a+148+((1-u|0)*36|0)+32>>2]|0;c[a+148+((1-u|0)*36|0)+32>>2]=s+1;c[a+148+((1-u|0)*36|0)+16+(s<<2)>>2]=d;s=c[m>>2]|0;q=(c[k>>2]=d,+g[k>>2]);r=q*+g[s+20>>2];t=q*+g[s+24>>2];g[a+128>>2]=+g[s+16>>2]*q+ +g[a+128>>2];g[a+132>>2]=r+ +g[a+132>>2];g[a+136>>2]=t+ +g[a+136>>2]}n=n+1|0}while((n|0)!=(f|0))}if((b|0)==15)c[a+376>>2]=1;x=x+1|0;if(x>>>0>=128){z=38;break}}while((c[a+376>>2]|0)==0);if((z|0)==5)c[a+376>>2]=1;else if((z|0)==8){z=c[a+368>>2]|0;w=(c[a+148+(z*36|0)+32>>2]|0)+-1|0;c[a+148+(z*36|0)+32>>2]=w;w=c[a+148+(z*36|0)+(w<<2)>>2]|0;z=c[a+364>>2]|0;c[a+364>>2]=z+1;c[a+348+(z<<2)>>2]=w}else if((z|0)==9){z=c[a+368>>2]|0;w=(c[a+148+(z*36|0)+32>>2]|0)+-1|0;c[a+148+(z*36|0)+32>>2]=w;w=c[a+148+(z*36|0)+(w<<2)>>2]|0;z=c[a+364>>2]|0;c[a+364>>2]=z+1;c[a+348+(z<<2)>>2]=w}else if((z|0)==36){z=c[a+368>>2]|0;w=(c[a+148+(z*36|0)+32>>2]|0)+-1|0;c[a+148+(z*36|0)+32>>2]=w;w=c[a+148+(z*36|0)+(w<<2)>>2]|0;z=c[a+364>>2]|0;c[a+364>>2]=z+1;c[a+348+(z<<2)>>2]=w}else if((z|0)==38)c[a+376>>2]=2;c[a+372>>2]=a+148+((c[a+368>>2]|0)*36|0);d=c[a+376>>2]|0;switch(d|0){case 0:{q=+g[a+128>>2];r=+g[a+132>>2];t=+g[a+136>>2];g[a+144>>2]=+O(+(q*q+r*r+t*t));i=A;return d|0}case 1:{g[a+144>>2]=0.0;i=A;return d|0}default:{i=A;return d|0}}return 0}function rD(a,b,d,e,f){a=a|0;b=+b;d=+d;e=+e;f=f|0;var h=0,j=0,k=0,l=0,m=0.0,n=0.0;k=i;i=i+48|0;m=1.0/+O(+(b*b+d*d+e*e));g[f>>2]=m*b;g[f+4>>2]=m*d;g[f+8>>2]=m*e;g[f+12>>2]=0.0;h=c[a+120>>2]|0;l=c[a+120+4>>2]|0;j=(c[a>>2]|0)+(l>>1)|0;if(l&1)h=c[(c[j>>2]|0)+h>>2]|0;jc[h&127](k,j,f);e=-+g[f>>2];d=-+g[f+4>>2];b=-+g[f+8>>2];j=c[a+120>>2]|0;l=c[a+120+4>>2]|0;h=(c[a+4>>2]|0)+(l>>1)|0;if(l&1)j=c[(c[h>>2]|0)+j>>2]|0;m=+g[a+24>>2]*e+ +g[a+28>>2]*d+ +g[a+32>>2]*b;n=+g[a+40>>2]*e+ +g[a+44>>2]*d+ +g[a+48>>2]*b;g[k+16>>2]=+g[a+8>>2]*e+ +g[a+12>>2]*d+ +g[a+16>>2]*b;g[k+16+4>>2]=m;g[k+16+8>>2]=n;g[k+16+12>>2]=0.0;jc[j&127](k+32|0,h,k+16|0);n=+g[k+32>>2];m=+g[k+32+4>>2];e=+g[k+32+8>>2];d=+g[k+4>>2]-(n*+g[a+72>>2]+m*+g[a+76>>2]+e*+g[a+80>>2]+ +g[a+108>>2]);b=+g[k+8>>2]-(n*+g[a+88>>2]+m*+g[a+92>>2]+e*+g[a+96>>2]+ +g[a+112>>2]);g[f+16>>2]=+g[k>>2]-(n*+g[a+56>>2]+m*+g[a+60>>2]+e*+g[a+64>>2]+ +g[a+104>>2]);g[f+20>>2]=d;g[f+24>>2]=b;g[f+28>>2]=0.0;i=k;return}function sD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0;L=i;i=i+64|0;c[L>>2]=a;c[L+4>>2]=b;c[L+8>>2]=d;z=+g[a>>2];A=+g[b>>2];B=+g[a+4>>2];C=+g[b+4>>2];D=+g[a+8>>2];E=+g[b+8>>2];g[L+16>>2]=z-A;g[L+16+4>>2]=B-C;g[L+16+8>>2]=D-E;g[L+16+12>>2]=0.0;F=+g[d>>2];G=+g[d+4>>2];H=+g[d+8>>2];g[L+16+16>>2]=A-F;g[L+16+20>>2]=C-G;g[L+16+24>>2]=E-H;g[L+16+28>>2]=0.0;g[L+16+32>>2]=F-z;g[L+16+36>>2]=G-B;g[L+16+40>>2]=H-D;g[L+16+44>>2]=0.0;I=(B-C)*(E-H)-(D-E)*(C-G);J=(D-E)*(A-F)-(E-H)*(z-A);K=(C-G)*(z-A)-(B-C)*(A-F);if(K*K+(I*I+J*J)>0.0){o=B-C;p=D-E;q=z-A;w=z;x=B;y=D;l=0;n=0;j=0;m=0;v=-1.0}else{H=-1.0;i=L;return +H}while(1){if(w*(K*o-J*p)+x*(I*p-K*q)+(J*q-I*o)*y>0.0){u=c[10520+(m<<2)>>2]|0;M=c[L+(u<<2)>>2]|0;r=+g[M>>2];q=r-w;s=+g[M+4>>2];o=s-x;t=+g[M+8>>2];p=t-y;do if(q*q+o*o+p*p>0.0){h=-(w*q+x*o+y*p)/(q*q+o*o+p*p);if(h>=1.0){l=2;n=0;j=1065353216;h=r*r+s*s+t*t;break}if(!(h<=0.0)){j=(g[k>>2]=h,c[k>>2]|0);q=w+q*h;o=x+o*h;y=y+p*h;l=3;n=(g[k>>2]=1.0-h,c[k>>2]|0);h=y*y+(q*q+o*o);break}else{l=1;n=1065353216;j=0;h=w*w+x*x+y*y;break}}else h=-1.0;while(0);if(v<0.0|h<v){c[f>>2]=((l&1|0)!=0?1<<m:0)+((l&2|0)!=0?1<<u:0);c[e+(m<<2)>>2]=n;c[e+(u<<2)>>2]=j;g[e+(c[10520+(u<<2)>>2]<<2)>>2]=0.0}else h=v}else h=v;m=m+1|0;if((m|0)==3)break;u=c[L+(m<<2)>>2]|0;o=+g[L+16+(m<<4)+4>>2];p=+g[L+16+(m<<4)+8>>2];q=+g[L+16+(m<<4)>>2];w=+g[u>>2];x=+g[u+4>>2];y=+g[u+8>>2];v=h}if(!(h<0.0)){H=h;i=L;return +H}h=+O(+(K*K+(I*I+J*J)));y=(I*+g[a>>2]+J*+g[a+4>>2]+K*+g[a+8>>2])/(K*K+(I*I+J*J));c[f>>2]=7;p=+g[b>>2]-I*y;q=+g[b+4>>2]-J*y;o=+g[b+8>>2]-K*y;E=+O(+((q*(A-F)-p*(C-G))*(q*(A-F)-p*(C-G))+(((C-G)*o-q*(E-H))*((C-G)*o-q*(E-H))+(p*(E-H)-o*(A-F))*(p*(E-H)-o*(A-F)))))/h;g[e>>2]=E;A=+g[d>>2]-I*y;o=+g[d+4>>2]-J*y;C=+g[d+8>>2]-K*y;H=+O(+((o*(F-z)-A*(G-B))*(o*(F-z)-A*(G-B))+(((G-B)*C-o*(H-D))*((G-B)*C-o*(H-D))+(A*(H-D)-C*(F-z))*(A*(H-D)-C*(F-z)))))/h;g[e+4>>2]=H;g[e+8>>2]=1.0-(H+E);H=K*y*(K*y)+(I*y*(I*y)+J*y*(J*y));i=L;return +H}function tD(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0.0;n=i;i=i+32|0;d=c[a+372>>2]|0;a:do switch(c[d+32>>2]|0){case 1:{j=d;b=1;d=0;while(1){c[n+16>>2]=0;c[n+16+4>>2]=0;c[n+16+8>>2]=0;c[n+16+12>>2]=0;g[n+16+(d<<2)>>2]=1.0;o=j+32|0;g[j+16+(b<<2)>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[j+(c[o>>2]<<2)>>2]=c[a+348+(b<<2)>>2];b=c[o>>2]|0;c[o>>2]=b+1;e=+g[n+16>>2];f=+g[n+16+4>>2];h=+g[n+16+8>>2];rD(a,e,f,h,c[j+(b<<2)>>2]|0);if(tD(a)|0){b=1;d=19;break}o=c[a+372>>2]|0;b=(c[o+32>>2]|0)+-1|0;c[o+32>>2]=b;b=c[o+(b<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+348+(o<<2)>>2]=b;o=c[a+372>>2]|0;g[o+16+(c[o+32>>2]<<2)>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[o+(c[o+32>>2]<<2)>>2]=c[a+348+(b<<2)>>2];b=c[o+32>>2]|0;c[o+32>>2]=b+1;rD(a,-e,-f,-h,c[o+(b<<2)>>2]|0);if(tD(a)|0){b=1;d=19;break}b=c[a+372>>2]|0;o=(c[b+32>>2]|0)+-1|0;c[b+32>>2]=o;o=c[b+(o<<2)>>2]|0;b=c[a+364>>2]|0;c[a+364>>2]=b+1;c[a+348+(b<<2)>>2]=o;d=d+1|0;if(d>>>0>=3)break a;b=c[a+372>>2]|0;j=b;b=c[b+32>>2]|0}if((d|0)==19){i=n;return b|0}break}case 2:{b=c[d+4>>2]|0;j=c[d>>2]|0;k=+g[b+16>>2]-+g[j+16>>2];m=+g[b+20>>2]-+g[j+20>>2];l=+g[b+24>>2]-+g[j+24>>2];j=0;while(1){c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[n+(j<<2)>>2]=1.0;h=+g[n+8>>2];f=+g[n+4>>2];e=+g[n>>2];if((m*h-l*f)*(m*h-l*f)+(l*e-k*h)*(l*e-k*h)+(k*f-m*e)*(k*f-m*e)>0.0){o=c[a+372>>2]|0;g[o+16+(c[o+32>>2]<<2)>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[o+(c[o+32>>2]<<2)>>2]=c[a+348+(b<<2)>>2];b=c[o+32>>2]|0;c[o+32>>2]=b+1;rD(a,m*h-l*f,l*e-k*h,k*f-m*e,c[o+(b<<2)>>2]|0);if(tD(a)|0){b=1;d=19;break}o=c[a+372>>2]|0;b=(c[o+32>>2]|0)+-1|0;c[o+32>>2]=b;b=c[o+(b<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+348+(o<<2)>>2]=b;o=c[a+372>>2]|0;g[o+16+(c[o+32>>2]<<2)>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[o+(c[o+32>>2]<<2)>>2]=c[a+348+(b<<2)>>2];b=c[o+32>>2]|0;c[o+32>>2]=b+1;rD(a,-(m*h-l*f),-(l*e-k*h),-(k*f-m*e),c[o+(b<<2)>>2]|0);if(tD(a)|0){b=1;d=19;break}b=c[a+372>>2]|0;o=(c[b+32>>2]|0)+-1|0;c[b+32>>2]=o;o=c[b+(o<<2)>>2]|0;b=c[a+364>>2]|0;c[a+364>>2]=b+1;c[a+348+(b<<2)>>2]=o}j=j+1|0;if(j>>>0>=3)break a}if((d|0)==19){i=n;return b|0}break}case 3:{b=c[d+4>>2]|0;o=c[d>>2]|0;h=+g[o+16>>2];f=+g[b+16>>2]-h;e=+g[o+20>>2];m=+g[b+20>>2]-e;l=+g[o+24>>2];k=+g[b+24>>2]-l;b=c[d+8>>2]|0;h=+g[b+16>>2]-h;e=+g[b+20>>2]-e;l=+g[b+24>>2]-l;if((m*l-k*e)*(m*l-k*e)+(k*h-f*l)*(k*h-f*l)+(f*e-m*h)*(f*e-m*h)>0.0){g[d+28>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[d+12>>2]=c[a+348+(b<<2)>>2];b=c[d+32>>2]|0;c[d+32>>2]=b+1;rD(a,m*l-k*e,k*h-f*l,f*e-m*h,c[d+(b<<2)>>2]|0);if(tD(a)|0){b=1;i=n;return b|0}o=c[a+372>>2]|0;b=(c[o+32>>2]|0)+-1|0;c[o+32>>2]=b;b=c[o+(b<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+348+(o<<2)>>2]=b;o=c[a+372>>2]|0;g[o+16+(c[o+32>>2]<<2)>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[o+(c[o+32>>2]<<2)>>2]=c[a+348+(b<<2)>>2];b=c[o+32>>2]|0;c[o+32>>2]=b+1;rD(a,-(m*l-k*e),-(k*h-f*l),-(f*e-m*h),c[o+(b<<2)>>2]|0);if(tD(a)|0){b=1;i=n;return b|0}else{b=c[a+372>>2]|0;o=(c[b+32>>2]|0)+-1|0;c[b+32>>2]=o;o=c[b+(o<<2)>>2]|0;b=c[a+364>>2]|0;c[a+364>>2]=b+1;c[a+348+(b<<2)>>2]=o;break a}}break}case 4:{b=c[d>>2]|0;o=c[d+12>>2]|0;e=+g[o+16>>2];r=+g[b+16>>2]-e;p=+g[o+20>>2];m=+g[b+20>>2]-p;k=+g[o+24>>2];h=+g[b+24>>2]-k;b=c[d+4>>2]|0;l=+g[b+16>>2]-e;f=+g[b+20>>2]-p;q=+g[b+24>>2]-k;b=c[d+8>>2]|0;e=+g[b+16>>2]-e;p=+g[b+20>>2]-p;k=+g[b+24>>2]-k;if(!((0.0!=0.0?1:r*f*k+(m*q*e+h*l*p-r*q*p-m*l*k)-h*f*e!=r*f*k+(m*q*e+h*l*p-r*q*p-m*l*k)-h*f*e)|r*f*k+(m*q*e+h*l*p-r*q*p-m*l*k)-h*f*e==0.0)){b=1;i=n;return b|0}break}default:{}}while(0);b=0;i=n;return b|0}function uD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;q=c[b+9288>>2]|0;if(!q){c[b>>2]=5;i=0;return i|0}i=c[q+48>>2]|0;if(i)c[i+44>>2]=c[q+44>>2];i=c[q+44>>2]|0;if(i)c[i+48>>2]=c[q+48>>2];if((c[b+9288>>2]|0)==(q|0))c[b+9288>>2]=c[q+48>>2];c[b+9292>>2]=(c[b+9292>>2]|0)+-1;c[q+44>>2]=0;c[q+48>>2]=c[b+9280>>2];i=c[b+9280>>2]|0;if(i)c[i+44>>2]=q;c[b+9280>>2]=q;c[b+9284>>2]=(c[b+9284>>2]|0)+1;a[q+55>>0]=0;c[q+20>>2]=d;c[q+24>>2]=e;c[q+28>>2]=f;l=+g[d+16>>2];k=+g[e+16>>2]-l;p=+g[d+20>>2];o=+g[e+20>>2]-p;n=+g[d+24>>2];m=+g[e+24>>2]-n;l=+g[f+16>>2]-l;p=+g[f+20>>2]-p;n=+g[f+24>>2]-n;g[q>>2]=o*n-m*p;g[q+4>>2]=m*l-k*n;g[q+8>>2]=k*p-o*l;g[q+12>>2]=0.0;j=+O(+((o*n-m*p)*(o*n-m*p)+(m*l-k*n)*(m*l-k*n)+(k*p-o*l)*(k*p-o*l)));do if(j>9.999999747378752e-05){if((!(vD(o*n-m*p,m*l-k*n,k*p-o*l,+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],q+16|0)|0)?!(vD(+g[q>>2],+g[q+4>>2],+g[q+8>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],q+16|0)|0):0)?!(vD(+g[q>>2],+g[q+4>>2],+g[q+8>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],q+16|0)|0):0)g[q+16>>2]=(+g[d+16>>2]*+g[q>>2]+ +g[d+20>>2]*+g[q+4>>2]+ +g[d+24>>2]*+g[q+8>>2])/j;g[q>>2]=1.0/j*+g[q>>2];g[q+4>>2]=1.0/j*+g[q+4>>2];g[q+8>>2]=1.0/j*+g[q+8>>2];if(h){i=q;return i|0}if(!(+g[q+16>>2]>=-9.999999747378752e-06)){c[b>>2]=3;break}else{i=q;return i|0}}else c[b>>2]=2;while(0);i=c[q+48>>2]|0;if(i)c[i+44>>2]=c[q+44>>2];i=c[q+44>>2]|0;if(i)c[i+48>>2]=c[q+48>>2];if((c[b+9280>>2]|0)==(q|0))c[b+9280>>2]=c[q+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+-1;c[q+44>>2]=0;c[q+48>>2]=c[b+9288>>2];i=c[b+9288>>2]|0;if(i)c[i+44>>2]=q;c[b+9288>>2]=q;c[b+9292>>2]=(c[b+9292>>2]|0)+1;i=0;return i|0}
function ev(d,e,f,h,j,k){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=+k;var l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0;F=i;i=i+976|0;E=c[h+4>>2]|0;D=c[h+12>>2]|0;l=c[E+4>>2]|0;if((l|0)<20){c[F+800>>2]=5800;c[F+800+168>>2]=0;g[F+800+172>>2]=k;c[F+800+164>>2]=c[j+4>>2];g[F+408+308>>2]=9.999999747378752e-05;a[F+408+332>>0]=0;c[F+792>>2]=10400;c[F+768>>2]=10480;c[F+768+4>>2]=F+408;c[F+768+8>>2]=F+792;c[F+768+12>>2]=d;c[F+768+16>>2]=E;c[F+768+20>>2]=0;if((lD(F+768|0,e,f,D,D,F+800|0)|0?(v=F+800+132|0,n=+g[v>>2],m=+g[F+800+136>>2],t=+g[F+800+140>>2],n*n+m*m+t*t>9.999999747378752e-05):0)?(s=+g[F+800+164>>2],s<+g[j+4>>2]):0){u=1.0/+O(+(n*n+m*m+t*t));g[v>>2]=n*u;g[F+800+136>>2]=m*u;g[F+800+140>>2]=t*u;c[F+184>>2]=c[h+8>>2];c[F+184+4>>2]=0;c[F+184+8>>2]=c[v>>2];c[F+184+8+4>>2]=c[v+4>>2];c[F+184+8+8>>2]=c[v+8>>2];c[F+184+8+12>>2]=c[v+12>>2];c[F+184+24>>2]=c[F+800+148>>2];c[F+184+24+4>>2]=c[F+800+148+4>>2];c[F+184+24+8>>2]=c[F+800+148+8>>2];c[F+184+24+12>>2]=c[F+800+148+12>>2];g[F+184+40>>2]=s;+$b[c[(c[j>>2]|0)+12>>2]&15](j,F+184|0,1)}i=F;return}if((l+-21|0)>>>0>=9){if((l|0)!=31){i=F;return}iE(15134);if((c[E+16>>2]|0)>0){l=0;do{w=c[E+24>>2]|0;C=+g[w+(l*80|0)>>2];z=+g[w+(l*80|0)+4>>2];x=+g[w+(l*80|0)+8>>2];B=+g[w+(l*80|0)+16>>2];y=+g[w+(l*80|0)+20>>2];o=+g[w+(l*80|0)+24>>2];A=+g[w+(l*80|0)+32>>2];m=+g[w+(l*80|0)+36>>2];q=+g[w+(l*80|0)+40>>2];N=+g[w+(l*80|0)+48>>2];M=+g[w+(l*80|0)+52>>2];u=+g[w+(l*80|0)+56>>2];w=c[w+(l*80|0)+64>>2]|0;L=+g[D>>2];K=+g[D+4>>2];J=+g[D+8>>2];I=+g[D+16>>2];H=+g[D+20>>2];G=+g[D+24>>2];n=+g[D+32>>2];p=+g[D+36>>2];r=+g[D+40>>2];s=N*L+M*K+u*J+ +g[D+48>>2];t=N*I+M*H+u*G+ +g[D+52>>2];u=N*n+M*p+u*r+ +g[D+56>>2];g[F+800>>2]=C*L+B*K+A*J;g[F+800+4>>2]=z*L+y*K+m*J;g[F+800+8>>2]=x*L+o*K+q*J;g[F+800+12>>2]=0.0;g[F+800+16>>2]=C*I+B*H+A*G;g[F+800+20>>2]=z*I+y*H+m*G;g[F+800+24>>2]=x*I+o*H+q*G;g[F+800+28>>2]=0.0;g[F+800+32>>2]=C*n+B*p+A*r;g[F+800+36>>2]=z*n+y*p+m*r;g[F+800+40>>2]=x*n+o*p+q*r;g[F+800+44>>2]=0.0;g[F+800+48>>2]=s;g[F+800+52>>2]=t;g[F+800+56>>2]=u;g[F+800+60>>2]=0.0;b[F+24+8>>1]=1;b[F+24+10>>1]=-1;c[F+24>>2]=6076;c[F+24+12>>2]=j;c[F+24+16>>2]=l;c[F+24+4>>2]=c[j+4>>2];v=c[h+8>>2]|0;c[F>>2]=h;c[F+4>>2]=w;c[F+8>>2]=v;c[F+12>>2]=F+800;c[F+16>>2]=-1;c[F+20>>2]=l;ev(d,e,f,F,F+24|0,k);l=l+1|0}while((l|0)<(c[E+16>>2]|0))}l=c[2700]|0;E=(c[l+16>>2]|0)+-1|0;c[l+16>>2]=E;if(E){i=F;return}do if(c[l+4>>2]|0){vb(F+800|0,0)|0;E=c[2702]|0;g[l+8>>2]=+(((c[F+800+4>>2]|0)-(c[E+4>>2]|0)+(((c[F+800>>2]|0)-(c[E>>2]|0)|0)*1e6|0)-(c[l+12>>2]|0)|0)>>>0)/1.0e3+ +g[l+8>>2];if(!(c[l+16>>2]|0)){l=c[2700]|0;break}else{i=F;return}}while(0);c[2700]=c[l+20>>2];i=F;return}switch(l|0){case 21:{u=+g[D>>2];t=+g[D+16>>2];s=+g[D+32>>2];r=+g[D+4>>2];q=+g[D+20>>2];p=+g[D+36>>2];o=+g[D+8>>2];n=+g[D+24>>2];m=+g[D+40>>2];A=-+g[D+48>>2];B=-+g[D+52>>2];C=-+g[D+56>>2];z=+g[e+48>>2];y=+g[e+52>>2];x=+g[e+56>>2];g[F+168>>2]=u*A+t*B+s*C+(u*z+t*y+s*x);g[F+168+4>>2]=r*A+q*B+p*C+(r*z+q*y+p*x);g[F+168+8>>2]=o*A+n*B+m*C+(o*z+n*y+m*x);g[F+168+12>>2]=0.0;x=+g[f+48>>2];y=+g[f+52>>2];z=+g[f+56>>2];P=+g[f>>2];N=+g[f+16>>2];M=+g[f+32>>2];L=+g[f+4>>2];K=+g[f+20>>2];J=+g[f+36>>2];I=+g[f+8>>2];H=+g[f+24>>2];G=+g[f+40>>2];g[F+408>>2]=u*P+t*N+s*M;g[F+408+4>>2]=u*L+t*K+s*J;g[F+408+8>>2]=u*I+t*H+s*G;g[F+408+12>>2]=0.0;g[F+408+16>>2]=r*P+q*N+p*M;g[F+408+20>>2]=r*L+q*K+p*J;g[F+408+24>>2]=r*I+q*H+p*G;g[F+408+28>>2]=0.0;g[F+408+32>>2]=o*P+n*N+m*M;g[F+408+36>>2]=o*L+n*K+m*J;g[F+408+40>>2]=o*I+n*H+m*G;l=F+408+44|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;l=c[h+8>>2]|0;G=+Tb[c[(c[E>>2]|0)+48>>2]&15](E);c[F+184>>2]=9316;c[F+184+4>>2]=d;c[F+184+8>>2]=c[e>>2];c[F+184+8+4>>2]=c[e+4>>2];c[F+184+8+8>>2]=c[e+8>>2];c[F+184+8+12>>2]=c[e+12>>2];c[F+184+24>>2]=c[e+16>>2];c[F+184+24+4>>2]=c[e+16+4>>2];c[F+184+24+8>>2]=c[e+16+8>>2];c[F+184+24+12>>2]=c[e+16+12>>2];c[F+184+40>>2]=c[e+32>>2];c[F+184+40+4>>2]=c[e+32+4>>2];c[F+184+40+8>>2]=c[e+32+8>>2];c[F+184+40+12>>2]=c[e+32+12>>2];c[F+184+56>>2]=c[e+48>>2];c[F+184+56+4>>2]=c[e+48+4>>2];c[F+184+56+8>>2]=c[e+48+8>>2];c[F+184+56+12>>2]=c[e+48+12>>2];c[F+184+72>>2]=c[f>>2];c[F+184+72+4>>2]=c[f+4>>2];c[F+184+72+8>>2]=c[f+8>>2];c[F+184+72+12>>2]=c[f+12>>2];c[F+184+88>>2]=c[f+16>>2];c[F+184+88+4>>2]=c[f+16+4>>2];c[F+184+88+8>>2]=c[f+16+8>>2];c[F+184+88+12>>2]=c[f+16+12>>2];c[F+184+104>>2]=c[f+32>>2];c[F+184+104+4>>2]=c[f+32+4>>2];c[F+184+104+8>>2]=c[f+32+8>>2];c[F+184+104+12>>2]=c[f+32+12>>2];c[F+184+120>>2]=c[f+48>>2];c[F+184+120+4>>2]=c[f+48+4>>2];c[F+184+120+8>>2]=c[f+48+8>>2];c[F+184+120+12>>2]=c[f+48+12>>2];c[F+184+136>>2]=c[D>>2];c[F+184+136+4>>2]=c[D+4>>2];c[F+184+136+8>>2]=c[D+8>>2];c[F+184+136+12>>2]=c[D+12>>2];c[F+184+152>>2]=c[D+16>>2];c[F+184+152+4>>2]=c[D+16+4>>2];c[F+184+152+8>>2]=c[D+16+8>>2];c[F+184+152+12>>2]=c[D+16+12>>2];c[F+184+168>>2]=c[D+32>>2];c[F+184+168+4>>2]=c[D+32+4>>2];c[F+184+168+8>>2]=c[D+32+8>>2];c[F+184+168+12>>2]=c[D+32+12>>2];c[F+184+184>>2]=c[D+48>>2];c[F+184+184+4>>2]=c[D+48+4>>2];c[F+184+184+8>>2]=c[D+48+8>>2];c[F+184+184+12>>2]=c[D+48+12>>2];g[F+184+204>>2]=G;c[F+184>>2]=6028;c[F+184+212>>2]=j;c[F+184+216>>2]=l;c[F+184+220>>2]=E;c[F+184+200>>2]=c[j+4>>2];g[F+184+208>>2]=k;nc[c[(c[d>>2]|0)+8>>2]&127](d,F+408|0,F+152|0,F+136|0);l=c[E+48>>2]|0;c[F+800>>2]=7116;c[F+800+4>>2]=l;c[F+800+8>>2]=F+184;l=c[E+52>>2]|0;if(!(a[l+60>>0]|0))CC(l,F+800|0,F+168|0,u*A+t*B+s*C+(u*x+t*y+s*z),r*A+q*B+p*C+(r*x+q*y+p*z),o*A+n*B+m*C+(o*x+n*y+m*z),F+152|0,F+136|0);else DC(l,F+800|0,F+168|0,u*A+t*B+s*C+(u*x+t*y+s*z),r*A+q*B+p*C+(r*x+q*y+p*z),o*A+n*B+m*C+(o*x+n*y+m*z),F+152|0,F+136|0,c[l+56>>2]|0);i=F;return}case 28:{c[F+800>>2]=5800;c[F+800+168>>2]=0;g[F+800+172>>2]=k;c[F+800+164>>2]=c[j+4>>2];c[F+112>>2]=10480;c[F+112+4>>2]=0;c[F+112+8>>2]=0;c[F+112+12>>2]=d;c[F+112+16>>2]=0;c[F+112+20>>2]=E;if((lD(F+112|0,e,f,D,D,F+800|0)|0?(w=F+800+132|0,r=+g[w>>2],q=+g[F+800+136>>2],p=+g[F+800+140>>2],r*r+q*q+p*p>9.999999747378752e-05):0)?(o=+g[F+800+164>>2],o<+g[j+4>>2]):0){k=1.0/+O(+(r*r+q*q+p*p));g[w>>2]=r*k;g[F+800+136>>2]=q*k;g[F+800+140>>2]=p*k;c[F+408>>2]=c[h+8>>2];c[F+408+4>>2]=0;c[F+408+8>>2]=c[w>>2];c[F+408+8+4>>2]=c[w+4>>2];c[F+408+8+8>>2]=c[w+8>>2];c[F+408+8+12>>2]=c[w+12>>2];c[F+408+24>>2]=c[F+800+148>>2];c[F+408+24+4>>2]=c[F+800+148+4>>2];c[F+408+24+8>>2]=c[F+800+148+8>>2];c[F+408+24+12>>2]=c[F+800+148+12>>2];g[F+408+40>>2]=o;+$b[c[(c[j>>2]|0)+12>>2]&15](j,F+408|0,1)}i=F;return}default:{P=+g[D>>2];N=+g[D+16>>2];M=+g[D+32>>2];L=+g[D+4>>2];K=+g[D+20>>2];J=+g[D+36>>2];x=+g[D+8>>2];z=+g[D+24>>2];B=+g[D+40>>2];p=-+g[D+48>>2];H=-+g[D+52>>2];q=-+g[D+56>>2];r=+g[e+48>>2];I=+g[e+52>>2];m=+g[e+56>>2];o=P*p+N*H+M*q+(P*r+N*I+M*m);t=L*p+K*H+J*q+(L*r+K*I+J*m);m=x*p+z*H+B*q+(x*r+z*I+B*m);I=+g[f+48>>2];r=+g[f+52>>2];u=+g[f+56>>2];s=P*p+N*H+M*q+(P*I+N*r+M*u);n=L*p+K*H+J*q+(L*I+K*r+J*u);u=x*p+z*H+B*q+(x*I+z*r+B*u);r=+g[f>>2];I=+g[f+16>>2];q=+g[f+32>>2];H=+g[f+4>>2];p=+g[f+20>>2];G=+g[f+36>>2];y=+g[f+8>>2];A=+g[f+24>>2];C=+g[f+40>>2];g[F+800>>2]=P*r+N*I+M*q;g[F+800+4>>2]=P*H+N*p+M*G;g[F+800+8>>2]=P*y+N*A+M*C;g[F+800+12>>2]=0.0;g[F+800+16>>2]=L*r+K*I+J*q;g[F+800+20>>2]=L*H+K*p+J*G;g[F+800+24>>2]=L*y+K*A+J*C;g[F+800+28>>2]=0.0;g[F+800+32>>2]=x*r+z*I+B*q;g[F+800+36>>2]=x*H+z*p+B*G;g[F+800+40>>2]=x*y+z*A+B*C;l=F+800+44|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;l=c[h+8>>2]|0;C=+Tb[c[(c[E>>2]|0)+48>>2]&15](E);c[F+408>>2]=9316;c[F+408+4>>2]=d;c[F+408+8>>2]=c[e>>2];c[F+408+8+4>>2]=c[e+4>>2];c[F+408+8+8>>2]=c[e+8>>2];c[F+408+8+12>>2]=c[e+12>>2];c[F+408+24>>2]=c[e+16>>2];c[F+408+24+4>>2]=c[e+16+4>>2];c[F+408+24+8>>2]=c[e+16+8>>2];c[F+408+24+12>>2]=c[e+16+12>>2];c[F+408+40>>2]=c[e+32>>2];c[F+408+40+4>>2]=c[e+32+4>>2];c[F+408+40+8>>2]=c[e+32+8>>2];c[F+408+40+12>>2]=c[e+32+12>>2];c[F+408+56>>2]=c[e+48>>2];c[F+408+56+4>>2]=c[e+48+4>>2];c[F+408+56+8>>2]=c[e+48+8>>2];c[F+408+56+12>>2]=c[e+48+12>>2];c[F+408+72>>2]=c[f>>2];c[F+408+72+4>>2]=c[f+4>>2];c[F+408+72+8>>2]=c[f+8>>2];c[F+408+72+12>>2]=c[f+12>>2];c[F+408+88>>2]=c[f+16>>2];c[F+408+88+4>>2]=c[f+16+4>>2];c[F+408+88+8>>2]=c[f+16+8>>2];c[F+408+88+12>>2]=c[f+16+12>>2];c[F+408+104>>2]=c[f+32>>2];c[F+408+104+4>>2]=c[f+32+4>>2];c[F+408+104+8>>2]=c[f+32+8>>2];c[F+408+104+12>>2]=c[f+32+12>>2];c[F+408+120>>2]=c[f+48>>2];c[F+408+120+4>>2]=c[f+48+4>>2];c[F+408+120+8>>2]=c[f+48+8>>2];c[F+408+120+12>>2]=c[f+48+12>>2];c[F+408+136>>2]=c[D>>2];c[F+408+136+4>>2]=c[D+4>>2];c[F+408+136+8>>2]=c[D+8>>2];c[F+408+136+12>>2]=c[D+12>>2];c[F+408+152>>2]=c[D+16>>2];c[F+408+152+4>>2]=c[D+16+4>>2];c[F+408+152+8>>2]=c[D+16+8>>2];c[F+408+152+12>>2]=c[D+16+12>>2];c[F+408+168>>2]=c[D+32>>2];c[F+408+168+4>>2]=c[D+32+4>>2];c[F+408+168+8>>2]=c[D+32+8>>2];c[F+408+168+12>>2]=c[D+32+12>>2];c[F+408+184>>2]=c[D+48>>2];c[F+408+184+4>>2]=c[D+48+4>>2];c[F+408+184+8>>2]=c[D+48+8>>2];c[F+408+184+12>>2]=c[D+48+12>>2];g[F+408+204>>2]=C;c[F+408>>2]=6052;c[F+408+212>>2]=j;c[F+408+216>>2]=l;c[F+408+220>>2]=E;c[F+408+200>>2]=c[j+4>>2];g[F+408+208>>2]=k;nc[c[(c[d>>2]|0)+8>>2]&127](d,F+800|0,F+96|0,F+80|0);g[F+64>>2]=o;g[F+64+4>>2]=t;g[F+64+8>>2]=m;g[F+64+12>>2]=0.0;if(s<o){g[F+64>>2]=s;r=s}else r=o;if(n<t){g[F+64+4>>2]=n;p=n}else p=t;if(u<m){g[F+64+8>>2]=u;q=u}else q=m;g[F+48>>2]=o;g[F+48+4>>2]=t;g[F+48+8>>2]=m;g[F+48+12>>2]=0.0;if(o<s){g[F+48>>2]=s;o=s}if(t<n)g[F+48+4>>2]=n;else n=t;if(m<u){g[F+48+8>>2]=u;m=u}g[F+64>>2]=+g[F+96>>2]+r;g[F+64+4>>2]=+g[F+96+4>>2]+p;g[F+64+8>>2]=+g[F+96+8>>2]+q;g[F+48>>2]=+g[F+80>>2]+o;g[F+48+4>>2]=+g[F+80+4>>2]+n;g[F+48+8>>2]=+g[F+80+8>>2]+m;nc[c[(c[E>>2]|0)+64>>2]&127](E,F+408|0,F+64|0,F+48|0);i=F;return}}}function fv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0;f=i;i=i+256|0;c[f+32>>2]=6100;l=f+32+36|0;c[l>>2]=c[b>>2];c[l+4>>2]=c[b+4>>2];c[l+8>>2]=c[b+8>>2];c[l+12>>2]=c[b+12>>2];m=f+32+52|0;c[m>>2]=c[d>>2];c[m+4>>2]=c[d+4>>2];c[m+8>>2]=c[d+8>>2];c[m+12>>2]=c[d+12>>2];c[f+32+212>>2]=a;c[f+32+216>>2]=e;c[f+32+68>>2]=1065353216;c[f+32+72>>2]=0;c[f+32+72+4>>2]=0;c[f+32+72+8>>2]=0;c[f+32+72+12>>2]=0;c[f+32+88>>2]=1065353216;c[f+32+92>>2]=0;c[f+32+92+4>>2]=0;c[f+32+92+8>>2]=0;c[f+32+92+12>>2]=0;c[f+32+108>>2]=1065353216;c[f+32+112>>2]=0;c[f+32+116>>2]=c[l>>2];c[f+32+116+4>>2]=c[l+4>>2];c[f+32+116+8>>2]=c[l+8>>2];c[f+32+116+12>>2]=c[l+12>>2];c[f+32+132>>2]=1065353216;c[f+32+136>>2]=0;c[f+32+136+4>>2]=0;c[f+32+136+8>>2]=0;c[f+32+136+12>>2]=0;c[f+32+152>>2]=1065353216;c[f+32+156>>2]=0;c[f+32+156+4>>2]=0;c[f+32+156+8>>2]=0;c[f+32+156+12>>2]=0;c[f+32+172>>2]=1065353216;c[f+32+176>>2]=0;c[f+32+180>>2]=c[d>>2];c[f+32+180+4>>2]=c[d+4>>2];c[f+32+180+8>>2]=c[d+8>>2];c[f+32+180+12>>2]=c[d+12>>2];n=+g[d>>2]-+g[b>>2];k=+g[d+4>>2]-+g[b+4>>2];j=+g[d+8>>2]-+g[b+8>>2];h=1.0/+O(+(n*n+k*k+j*j));q=n*h==0.0?999999984306749440.0:1.0/(n*h);g[f+32+4>>2]=q;p=k*h==0.0?999999984306749440.0:1.0/(k*h);g[f+32+8>>2]=p;o=j*h==0.0?999999984306749440.0:1.0/(j*h);g[f+32+12>>2]=o;c[f+32+20>>2]=q<0.0&1;c[f+32+24>>2]=p<0.0&1;c[f+32+28>>2]=o<0.0&1;g[f+32+32>>2]=n*h*(+g[m>>2]-+g[l>>2])+k*h*(+g[f+32+56>>2]-+g[f+32+40>>2])+j*h*(+g[f+32+60>>2]-+g[f+32+44>>2]);e=c[a+68>>2]|0;a=c[(c[e>>2]|0)+24>>2]|0;c[f+16>>2]=0;c[f+16+4>>2]=0;c[f+16+8>>2]=0;c[f+16+12>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;Rb[a&7](e,b,d,f+32|0,f+16|0,f);i=f;return}function gv(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0;j=i;i=i+416|0;iE(15154);c[j+144>>2]=c[d>>2];c[j+144+4>>2]=c[d+4>>2];c[j+144+8>>2]=c[d+8>>2];c[j+144+12>>2]=c[d+12>>2];c[j+144+16>>2]=c[d+16>>2];c[j+144+16+4>>2]=c[d+16+4>>2];c[j+144+16+8>>2]=c[d+16+8>>2];c[j+144+16+12>>2]=c[d+16+12>>2];c[j+144+32>>2]=c[d+32>>2];c[j+144+32+4>>2]=c[d+32+4>>2];c[j+144+32+8>>2]=c[d+32+8>>2];c[j+144+32+12>>2]=c[d+32+12>>2];l=j+144+48|0;c[l>>2]=c[d+48>>2];c[l+4>>2]=c[d+48+4>>2];c[l+8>>2]=c[d+48+8>>2];c[l+12>>2]=c[d+48+12>>2];c[j+64>>2]=c[e>>2];c[j+64+4>>2]=c[e+4>>2];c[j+64+8>>2]=c[e+8>>2];c[j+64+12>>2]=c[e+12>>2];c[j+64+16>>2]=c[e+16>>2];c[j+64+16+4>>2]=c[e+16+4>>2];c[j+64+16+8>>2]=c[e+16+8>>2];c[j+64+16+12>>2]=c[e+16+12>>2];c[j+64+32>>2]=c[e+32>>2];c[j+64+32+4>>2]=c[e+32+4>>2];c[j+64+32+8>>2]=c[e+32+8>>2];c[j+64+32+12>>2]=c[e+32+12>>2];k=j+64+48|0;c[k>>2]=c[e+48>>2];c[k+4>>2]=c[e+48+4>>2];c[k+8>>2]=c[e+48+8>>2];c[k+12>>2]=c[e+48+12>>2];Bp(j+144|0,j+64|0,j+212|0,j+208|0);t=+g[j+208>>2];m=t*+g[j+212+4>>2];r=t*+g[j+212+8>>2];g[j+32>>2]=+g[j+212>>2]*t;g[j+32+4>>2]=m;g[j+32+8>>2]=r;g[j+32+12>>2]=0.0;c[j+16>>2]=0;c[j+16+4>>2]=0;c[j+16+8>>2]=0;c[j+16+12>>2]=0;c[j+212+4>>2]=0;c[j+212+4+4>>2]=0;c[j+212+24>>2]=0;c[j+212+24+4>>2]=0;s=j+212+44|0;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[s+16>>2]=0;Oo(j+144|0,j);r=+g[j>>2];m=+g[j+4>>2];t=+g[j+8>>2];q=+g[j+12>>2];o=r*(2.0/(r*r+m*m+t*t+q*q));n=m*(2.0/(r*r+m*m+t*t+q*q));p=t*(2.0/(r*r+m*m+t*t+q*q));g[j+212>>2]=1.0-(m*n+t*p);g[j+212+4>>2]=r*n-q*p;g[j+212+8>>2]=r*p+q*n;g[j+212+12>>2]=0.0;g[j+212+16>>2]=r*n+q*p;g[j+212+20>>2]=1.0-(r*o+t*p);g[j+212+24>>2]=m*p-q*o;g[j+212+28>>2]=0.0;g[j+212+32>>2]=r*p-q*n;g[j+212+36>>2]=m*p+q*o;g[j+212+40>>2]=1.0-(r*o+m*n);g[s>>2]=0.0;Fy(b,j+212|0,j+16|0,j+32|0,j+128|0,j+48|0);c[j+212>>2]=6120;c[j+212+36>>2]=c[d>>2];c[j+212+36+4>>2]=c[d+4>>2];c[j+212+36+8>>2]=c[d+8>>2];c[j+212+36+12>>2]=c[d+12>>2];c[j+212+52>>2]=c[d+16>>2];c[j+212+52+4>>2]=c[d+16+4>>2];c[j+212+52+8>>2]=c[d+16+8>>2];c[j+212+52+12>>2]=c[d+16+12>>2];c[j+212+68>>2]=c[d+32>>2];c[j+212+68+4>>2]=c[d+32+4>>2];c[j+212+68+8>>2]=c[d+32+8>>2];c[j+212+68+12>>2]=c[d+32+12>>2];s=j+212+84|0;c[s>>2]=c[d+48>>2];c[s+4>>2]=c[d+48+4>>2];c[s+8>>2]=c[d+48+8>>2];c[s+12>>2]=c[d+48+12>>2];c[j+212+100>>2]=c[e>>2];c[j+212+100+4>>2]=c[e+4>>2];c[j+212+100+8>>2]=c[e+8>>2];c[j+212+100+12>>2]=c[e+12>>2];c[j+212+116>>2]=c[e+16>>2];c[j+212+116+4>>2]=c[e+16+4>>2];c[j+212+116+8>>2]=c[e+16+8>>2];c[j+212+116+12>>2]=c[e+16+12>>2];c[j+212+132>>2]=c[e+32>>2];c[j+212+132+4>>2]=c[e+32+4>>2];c[j+212+132+8>>2]=c[e+32+8>>2];c[j+212+132+12>>2]=c[e+32+12>>2];d=j+212+148|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];c[j+212+180>>2]=a;c[j+212+184>>2]=f;g[j+212+188>>2]=h;c[j+212+192>>2]=b;n=+g[d>>2]-+g[s>>2];m=+g[j+212+152>>2]-+g[j+212+88>>2];o=+g[j+212+156>>2]-+g[j+212+92>>2];h=1.0/+O(+(n*n+m*m+o*o));r=n*h==0.0?999999984306749440.0:1.0/(n*h);g[j+212+4>>2]=r;q=m*h==0.0?999999984306749440.0:1.0/(m*h);g[j+212+8>>2]=q;p=o*h==0.0?999999984306749440.0:1.0/(o*h);g[j+212+12>>2]=p;c[j+212+20>>2]=r<0.0&1;c[j+212+24>>2]=q<0.0&1;c[j+212+28>>2]=p<0.0&1;g[j+212+32>>2]=o*(o*h)+(n*(n*h)+m*(m*h));b=c[a+68>>2]|0;Rb[c[(c[b>>2]|0)+24>>2]&7](b,l,k,j+212|0,j+128|0,j+48|0);b=c[2700]|0;d=(c[b+16>>2]|0)+-1|0;c[b+16>>2]=d;if(d){i=j;return}do if(c[b+4>>2]|0){vb(j+212|0,0)|0;d=c[2702]|0;g[b+8>>2]=+(((c[j+212+4>>2]|0)-(c[d+4>>2]|0)+(((c[j+212>>2]|0)-(c[d>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];if(!(c[b+16>>2]|0)){b=c[2700]|0;break}else{i=j;return}}while(0);c[2700]=c[b+20>>2];i=j;return}function hv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+96|0;g=c[b+192>>2]|0;c[f+24>>2]=0;c[f+24+4>>2]=g;c[f+24+8>>2]=b;c[f+24+12>>2]=b+4;c[f+24+16>>2]=-1;c[f+24+20>>2]=-1;b=c[d+192>>2]|0;c[f>>2]=0;c[f+4>>2]=b;c[f+8>>2]=d;c[f+12>>2]=d+4;c[f+16>>2]=-1;c[f+20>>2]=-1;b=c[a+24>>2]|0;b=Lb[c[(c[b>>2]|0)+8>>2]&31](b,f+24|0,f,0)|0;if(!b){i=f;return}c[f+48+4>>2]=0;c[f+48+8>>2]=f+24;c[f+48+12>>2]=f;c[f+48>>2]=6140;c[f+48+32>>2]=e;Bb[c[(c[b>>2]|0)+8>>2]&31](b,f+24|0,f,a+28|0,f+48|0);Db[c[c[b>>2]>>2]&255](b);d=c[a+24>>2]|0;Fb[c[(c[d>>2]|0)+60>>2]&127](d,b);i=f;return}function iv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0;t=i;i=i+480|0;f=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;lc[c[(c[f>>2]|0)+56>>2]&7](f,b,1.0);f=c[d+4>>2]|0;switch(f|0){case 31:{f=c[d+16>>2]|0;if((f|0)<=0){i=t;return}do{r=f;f=f+-1|0;q=c[d+24>>2]|0;I=+g[q+(f*80|0)>>2];F=+g[q+(f*80|0)+4>>2];C=+g[q+(f*80|0)+8>>2];H=+g[q+(f*80|0)+16>>2];E=+g[q+(f*80|0)+20>>2];A=+g[q+(f*80|0)+24>>2];G=+g[q+(f*80|0)+32>>2];D=+g[q+(f*80|0)+36>>2];y=+g[q+(f*80|0)+40>>2];Q=+g[q+(f*80|0)+48>>2];P=+g[q+(f*80|0)+52>>2];u=+g[q+(f*80|0)+56>>2];q=c[q+(f*80|0)+64>>2]|0;p=c[(c[a>>2]|0)+28>>2]|0;O=+g[b>>2];N=+g[b+4>>2];M=+g[b+8>>2];L=+g[b+16>>2];K=+g[b+20>>2];J=+g[b+24>>2];B=+g[b+32>>2];z=+g[b+36>>2];x=+g[b+40>>2];w=Q*O+P*N+u*M+ +g[b+48>>2];v=Q*L+P*K+u*J+ +g[b+52>>2];u=Q*B+P*z+u*x+ +g[b+56>>2];g[t+320>>2]=I*O+H*N+G*M;g[t+320+4>>2]=F*O+E*N+D*M;g[t+320+8>>2]=C*O+A*N+y*M;g[t+320+12>>2]=0.0;g[t+320+16>>2]=I*L+H*K+G*J;g[t+320+20>>2]=F*L+E*K+D*J;g[t+320+24>>2]=C*L+A*K+y*J;g[t+320+28>>2]=0.0;g[t+320+32>>2]=I*B+H*z+G*x;g[t+320+36>>2]=F*B+E*z+D*x;g[t+320+40>>2]=C*B+A*z+y*x;g[t+320+44>>2]=0.0;g[t+320+48>>2]=w;g[t+320+52>>2]=v;g[t+320+56>>2]=u;g[t+320+60>>2]=0.0;nc[p&127](a,t+320|0,q,e)}while((r|0)>1);i=t;return}case 0:{c[t+304>>2]=c[d+28>>2];c[t+304+4>>2]=c[d+28+4>>2];c[t+304+8>>2]=c[d+28+8>>2];c[t+304+12>>2]=c[d+28+12>>2];N=+Tb[c[(c[d>>2]|0)+48>>2]&15](d);O=+Tb[c[(c[d>>2]|0)+48>>2]&15](d);P=+Tb[c[(c[d>>2]|0)+48>>2]&15](d);N=N+ +g[t+304>>2];g[t+304>>2]=N;O=O+ +g[t+304+4>>2];g[t+304+4>>2]=O;P=P+ +g[t+304+8>>2];g[t+304+8>>2]=P;r=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;q=c[(c[r>>2]|0)+72>>2]|0;g[t+288>>2]=-N;g[t+288+4>>2]=-O;g[t+288+8>>2]=-P;g[t+288+12>>2]=0.0;Bb[q&31](r,t+288|0,t+304|0,b,e);i=t;return}case 8:{P=+Tb[c[(c[d>>2]|0)+48>>2]&15](d);r=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Kb[c[(c[r>>2]|0)+16>>2]&0](r,P,b,e);i=t;return}case 9:{f=c[d+92>>2]|0;if((f|0)<=0){i=t;return}do{r=f;f=f+-1|0;q=c[d+100>>2]|0;w=+g[q+(f<<4)>>2];v=+g[q+(f<<4)+4>>2];O=+g[q+(f<<4)+8>>2];q=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;p=c[(c[q>>2]|0)+16>>2]|0;P=+g[(c[d+120>>2]|0)+(f<<2)>>2];E=+g[b>>2];F=+g[b+4>>2];u=+g[b+8>>2];H=+g[b+16>>2];I=+g[b+20>>2];G=+g[b+24>>2];K=+g[b+32>>2];L=+g[b+36>>2];J=+g[b+40>>2];M=w*E+v*F+O*u+ +g[b+48>>2];N=w*H+v*I+O*G+ +g[b+52>>2];O=w*K+v*L+O*J+ +g[b+56>>2];g[t+224>>2]=E+F*0.0+u*0.0;g[t+224+4>>2]=E*0.0+F+u*0.0;g[t+224+8>>2]=u+(E*0.0+F*0.0);g[t+224+12>>2]=0.0;g[t+224+16>>2]=H+I*0.0+G*0.0;g[t+224+20>>2]=H*0.0+I+G*0.0;g[t+224+24>>2]=G+(H*0.0+I*0.0);g[t+224+28>>2]=0.0;g[t+224+32>>2]=K+L*0.0+J*0.0;g[t+224+36>>2]=K*0.0+L+J*0.0;g[t+224+40>>2]=J+(K*0.0+L*0.0);g[t+224+44>>2]=0.0;g[t+224+48>>2]=M;g[t+224+52>>2]=N;g[t+224+56>>2]=O;g[t+224+60>>2]=0.0;Kb[p&0](q,P,t+224|0,e)}while((r|0)>1);i=t;return}case 10:{r=c[d+52>>2]|0;O=+g[d+28+(((r+2|0)%3|0)<<2)>>2];P=+g[d+28+(r<<2)>>2];q=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Jb[c[(c[q>>2]|0)+76>>2]&0](q,O,P,r,b,e);i=t;return}case 11:{O=+g[d+56>>2];P=+g[d+60>>2];r=c[d+68>>2]|0;q=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Jb[c[(c[q>>2]|0)+84>>2]&0](q,O,P,r,b,e);i=t;return}case 13:{r=c[d+52>>2]|0;O=+Tb[c[(c[d>>2]|0)+92>>2]&15](d);c[t+208>>2]=c[d+28>>2];c[t+208+4>>2]=c[d+28+4>>2];c[t+208+8>>2]=c[d+28+8>>2];c[t+208+12>>2]=c[d+28+12>>2];M=+Tb[c[(c[d>>2]|0)+48>>2]&15](d);N=+Tb[c[(c[d>>2]|0)+48>>2]&15](d);P=+Tb[c[(c[d>>2]|0)+48>>2]&15](d);g[t+208>>2]=M+ +g[t+208>>2];g[t+208+4>>2]=N+ +g[t+208+4>>2];g[t+208+8>>2]=P+ +g[t+208+8>>2];P=+g[t+208+(r<<2)>>2];q=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Jb[c[(c[q>>2]|0)+80>>2]&0](q,O,P,r,b,e);i=t;return}case 28:{P=+g[d+64>>2];r=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Wb[c[(c[r>>2]|0)+88>>2]&0](r,d+48|0,P,b,e);i=t;return}default:{a:do if((f|0)<7){q=c[d+52>>2]|0;if(!q){if((Hb[c[(c[d>>2]|0)+100>>2]&127](d)|0)<=0)break;f=0;while(1){nc[c[(c[d>>2]|0)+104>>2]&127](d,f,t+112|0,t+96|0);N=+g[t+112>>2];w=+g[b>>2];L=+g[t+112+4>>2];v=+g[b+4>>2];J=+g[t+112+8>>2];u=+g[b+8>>2];F=+g[b+16>>2];G=+g[b+20>>2];H=+g[b+24>>2];K=+g[b+32>>2];M=+g[b+36>>2];O=+g[b+40>>2];E=+g[b+48>>2];I=+g[b+52>>2];P=+g[b+56>>2];g[t+80>>2]=N*w+L*v+J*u+E;g[t+80+4>>2]=N*F+L*G+J*H+I;g[t+80+8>>2]=N*K+L*M+J*O+P;g[t+80+12>>2]=0.0;J=+g[t+96>>2];L=+g[t+96+4>>2];N=+g[t+96+8>>2];g[t+64>>2]=J*w+L*v+N*u+E;g[t+64+4>>2]=J*F+L*G+N*H+I;g[t+64+8>>2]=J*K+L*M+N*O+P;g[t+64+12>>2]=0.0;r=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;nc[c[(c[r>>2]|0)+8>>2]&127](r,t+80|0,t+64|0,e);f=f+1|0;if((f|0)>=(Hb[c[(c[d>>2]|0)+100>>2]&127](d)|0))break a}}if((c[q+28>>2]|0)>0){s=0;do{f=c[q+36>>2]|0;r=c[f+(s*36|0)+4>>2]|0;b:do if((r|0)>0){o=c[f+(s*36|0)+12>>2]|0;m=o;j=0;h=0;f=0;o=c[o+(r+-1<<2)>>2]|0;l=0;while(1){p=c[m+(l<<2)>>2]|0;n=c[q+16>>2]|0;j=(g[k>>2]=(c[k>>2]=j,+g[k>>2])+ +g[n+(p<<4)>>2],c[k>>2]|0);f=(g[k>>2]=(c[k>>2]=f,+g[k>>2])+ +g[n+(p<<4)+4>>2],c[k>>2]|0);h=(g[k>>2]=(c[k>>2]=h,+g[k>>2])+ +g[n+(p<<4)+8>>2],c[k>>2]|0);n=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;m=c[(c[n>>2]|0)+8>>2]|0;R=c[q+16>>2]|0;N=+g[R+(o<<4)>>2];w=+g[b>>2];L=+g[R+(o<<4)+4>>2];v=+g[b+4>>2];J=+g[R+(o<<4)+8>>2];u=+g[b+8>>2];F=+g[b+16>>2];G=+g[b+20>>2];H=+g[b+24>>2];K=+g[b+32>>2];M=+g[b+36>>2];O=+g[b+40>>2];E=+g[b+48>>2];I=+g[b+52>>2];P=+g[b+56>>2];g[t+192>>2]=N*w+L*v+J*u+E;g[t+192+4>>2]=N*F+L*G+J*H+I;g[t+192+8>>2]=N*K+L*M+J*O+P;g[t+192+12>>2]=0.0;J=+g[R+(p<<4)>>2];L=+g[R+(p<<4)+4>>2];N=+g[R+(p<<4)+8>>2];g[t+176>>2]=J*w+L*v+N*u+E;g[t+176+4>>2]=J*F+L*G+N*H+I;g[t+176+8>>2]=J*K+L*M+N*O+P;g[t+176+12>>2]=0.0;nc[m&127](n,t+192|0,t+176|0,e);n=l+1|0;l=c[q+36>>2]|0;if((n|0)>=(c[l+(s*36|0)+4>>2]|0))break b;m=c[l+(s*36|0)+12>>2]|0;o=p;l=n}}else{j=0;h=0;f=0}while(0);p=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;if((Hb[c[(c[p>>2]|0)+48>>2]&127](p)|0)&16384){M=(c[k>>2]=h,+g[k>>2])*(1.0/+(r|0));J=(c[k>>2]=f,+g[k>>2])*(1.0/+(r|0));G=1.0/+(r|0)*(c[k>>2]=j,+g[k>>2]);c[t+160>>2]=1065353216;c[t+160+4>>2]=1065353216;c[t+160+8>>2]=0;g[t+160+12>>2]=0.0;r=c[q+36>>2]|0;H=+g[r+(s*36|0)+20>>2];K=+g[r+(s*36|0)+24>>2];N=+g[r+(s*36|0)+28>>2];r=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;p=c[(c[r>>2]|0)+8>>2]|0;z=+g[b>>2];y=+g[b+4>>2];x=+g[b+8>>2];v=+g[b+16>>2];u=+g[b+20>>2];E=+g[b+24>>2];I=+g[b+32>>2];L=+g[b+36>>2];O=+g[b+40>>2];w=+g[b+48>>2];F=+g[b+52>>2];P=+g[b+56>>2];g[t+144>>2]=G*z+J*y+M*x+w;g[t+144+4>>2]=G*v+J*u+M*E+F;g[t+144+8>>2]=G*I+J*L+M*O+P;g[t+144+12>>2]=0.0;g[t+128>>2]=(G+H)*z+(J+K)*y+(M+N)*x+w;g[t+128+4>>2]=(G+H)*v+(J+K)*u+(M+N)*E+F;g[t+128+8>>2]=(G+H)*I+(J+K)*L+(M+N)*O+P;g[t+128+12>>2]=0.0;nc[p&127](r,t+144|0,t+128|0,t+160|0)}s=s+1|0}while((s|0)<(c[q+28>>2]|0))}}while(0);f=c[d+4>>2]|0;if((f+-21|0)>>>0<9){c[t+48>>2]=1566444395;c[t+48+4>>2]=1566444395;c[t+48+8>>2]=1566444395;g[t+48+12>>2]=0.0;c[t+32>>2]=-581039253;c[t+32+4>>2]=-581039253;c[t+32+8>>2]=-581039253;g[t+32+12>>2]=0.0;f=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;c[t+384>>2]=6168;c[t+384+4>>2]=6192;c[t+384+8>>2]=f;c[t+384+12>>2]=c[e>>2];c[t+384+12+4>>2]=c[e+4>>2];c[t+384+12+8>>2]=c[e+8>>2];c[t+384+12+12>>2]=c[e+12>>2];c[t+384+28>>2]=c[b>>2];c[t+384+28+4>>2]=c[b+4>>2];c[t+384+28+8>>2]=c[b+8>>2];c[t+384+28+12>>2]=c[b+12>>2];c[t+384+44>>2]=c[b+16>>2];c[t+384+44+4>>2]=c[b+16+4>>2];c[t+384+44+8>>2]=c[b+16+8>>2];c[t+384+44+12>>2]=c[b+16+12>>2];c[t+384+60>>2]=c[b+32>>2];c[t+384+60+4>>2]=c[b+32+4>>2];c[t+384+60+8>>2]=c[b+32+8>>2];c[t+384+60+12>>2]=c[b+32+12>>2];c[t+384+76>>2]=c[b+48>>2];c[t+384+76+4>>2]=c[b+48+4>>2];c[t+384+76+8>>2]=c[b+48+8>>2];c[t+384+76+12>>2]=c[b+48+12>>2];nc[c[(c[d>>2]|0)+64>>2]&127](d,t+384|0,t+32|0,t+48|0);f=c[d+4>>2]|0}if((f|0)!=3){i=t;return}c[t+16>>2]=1566444395;c[t+16+4>>2]=1566444395;c[t+16+8>>2]=1566444395;g[t+16+12>>2]=0.0;c[t>>2]=-581039253;c[t+4>>2]=-581039253;c[t+8>>2]=-581039253;g[t+12>>2]=0.0;r=Hb[c[(c[a>>2]|0)+20>>2]&127](a)|0;c[t+384>>2]=6168;c[t+384+4>>2]=6192;c[t+384+8>>2]=r;c[t+384+12>>2]=c[e>>2];c[t+384+12+4>>2]=c[e+4>>2];c[t+384+12+8>>2]=c[e+8>>2];c[t+384+12+12>>2]=c[e+12>>2];c[t+384+28>>2]=c[b>>2];c[t+384+28+4>>2]=c[b+4>>2];c[t+384+28+8>>2]=c[b+8>>2];c[t+384+28+12>>2]=c[b+12>>2];c[t+384+44>>2]=c[b+16>>2];c[t+384+44+4>>2]=c[b+16+4>>2];c[t+384+44+8>>2]=c[b+16+8>>2];c[t+384+44+12>>2]=c[b+16+12>>2];c[t+384+60>>2]=c[b+32>>2];c[t+384+60+4>>2]=c[b+32+4>>2];c[t+384+60+8>>2]=c[b+32+8>>2];c[t+384+60+12>>2]=c[b+32+12>>2];c[t+384+76>>2]=c[b+48>>2];c[t+384+76+4>>2]=c[b+48+4>>2];c[t+384+76+8>>2]=c[b+48+8>>2];c[t+384+76+12>>2]=c[b+48+12>>2];r=c[d+92>>2]|0;nc[c[(c[r>>2]|0)+8>>2]&127](r,t+384+4|0,t,t+16|0);i=t;return}}}function jv(b){b=b|0;var d=0.0,e=0,f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0;r=i;i=i+112|0;if(((Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(e=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Hb[c[(c[e>>2]|0)+48>>2]&127](e)|0)&8|0)!=0):0)?(f=c[b+24>>2]|0,f=Hb[c[(c[f>>2]|0)+36>>2]&127](f)|0,c[r+96>>2]=1065353216,c[r+96+4>>2]=1065353216,c[r+96+8>>2]=0,g[r+96+12>>2]=0.0,(f|0)>0):0){j=0;do{h=c[b+24>>2]|0;h=_b[c[(c[h>>2]|0)+40>>2]&31](h,j)|0;e=c[h+748>>2]|0;if((e|0)>0){k=0;do{q=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;Eb[c[(c[q>>2]|0)+32>>2]&0](q,h+4+(k*184|0)+32|0,h+4+(k*184|0)+64|0,+g[h+4+(k*184|0)+80>>2],c[h+4+(k*184|0)+148>>2]|0,r+96|0);k=k+1|0}while((k|0)!=(e|0))}j=j+1|0}while((j|0)!=(f|0))}if(!(Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0)){i=r;return}e=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;if(!((Hb[c[(c[e>>2]|0)+48>>2]&127](e)|0)&3)){i=r;return}if((c[b+8>>2]|0)<=0){i=r;return}h=r+80+4|0;f=r+80+8|0;e=r+80+12|0;q=0;do{k=c[(c[b+16>>2]|0)+(q<<2)>>2]|0;if(!(c[k+204>>2]&32)){if((Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(j=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Hb[c[(c[j>>2]|0)+48>>2]&127](j)|0)&1|0)!=0):0){c[r+80>>2]=1065353216;c[h>>2]=1065353216;c[f>>2]=1065353216;g[e>>2]=0.0;switch(c[k+216>>2]|0){case 1:{c[r+80>>2]=1065353216;c[h>>2]=1065353216;c[f>>2]=1065353216;g[e>>2]=0.0;break}case 2:{c[r+80>>2]=0;c[h>>2]=1065353216;c[f>>2]=0;g[e>>2]=0.0;break}case 3:{c[r+80>>2]=0;c[h>>2]=1065353216;c[f>>2]=1065353216;g[e>>2]=0.0;break}case 4:{c[r+80>>2]=1065353216;c[h>>2]=0;c[f>>2]=0;g[e>>2]=0.0;break}case 5:{c[r+80>>2]=1065353216;c[h>>2]=1065353216;c[f>>2]=0;g[e>>2]=0.0;break}default:{c[r+80>>2]=1065353216;c[h>>2]=0;c[f>>2]=0;g[e>>2]=0.0}}nc[c[(c[b>>2]|0)+28>>2]&127](b,k+4|0,c[k+192>>2]|0,r+80|0)}j=c[b+72>>2]|0;if((j|0)!=0?((Hb[c[(c[j>>2]|0)+48>>2]&127](j)|0)&2|0)!=0:0){c[r+32>>2]=1065353216;c[r+32+4>>2]=0;c[r+32+8>>2]=0;g[r+32+12>>2]=0.0;j=c[k+192>>2]|0;nc[c[(c[j>>2]|0)+8>>2]&127](j,k+4|0,r+64|0,r+48|0);g[r+64>>2]=+g[r+64>>2]+-.019999999552965164;g[r+64+4>>2]=+g[r+64+4>>2]+-.019999999552965164;g[r+64+8>>2]=+g[r+64+8>>2]+-.019999999552965164;g[r+48>>2]=+g[r+48>>2]+.019999999552965164;g[r+48+4>>2]=+g[r+48+4>>2]+.019999999552965164;g[r+48+8>>2]=+g[r+48+8>>2]+.019999999552965164;do if(((a[b+44>>0]|0)!=0?(c[k+236>>2]|0)==2:0)?(c[k+204>>2]&3|0)==0:0){j=c[k+192>>2]|0;nc[c[(c[j>>2]|0)+8>>2]&127](j,k+68|0,r+16|0,r);d=+g[r+16>>2]+-.019999999552965164;g[r+16>>2]=d;m=+g[r+16+4>>2]+-.019999999552965164;g[r+16+4>>2]=m;l=+g[r+16+8>>2]+-.019999999552965164;g[r+16+8>>2]=l;n=+g[r>>2]+.019999999552965164;g[r>>2]=n;p=+g[r+4>>2]+.019999999552965164;g[r+4>>2]=p;o=+g[r+8>>2]+.019999999552965164;g[r+8>>2]=o;if(d<+g[r+64>>2])g[r+64>>2]=d;if(m<+g[r+64+4>>2])g[r+64+4>>2]=m;if(l<+g[r+64+8>>2])g[r+64+8>>2]=l;d=+g[r+16+12>>2];if(d<+g[r+64+12>>2])g[r+64+12>>2]=d;if(+g[r+48>>2]<n)g[r+48>>2]=n;if(+g[r+48+4>>2]<p)g[r+48+4>>2]=p;if(+g[r+48+8>>2]<o)g[r+48+8>>2]=o;d=+g[r+12>>2];if(!(+g[r+48+12>>2]<d))break;g[r+48+12>>2]=d}while(0);j=c[b+72>>2]|0;nc[c[(c[j>>2]|0)+52>>2]&127](j,r+64|0,r+48|0,r+32|0)}}q=q+1|0}while((q|0)<(c[b+8>>2]|0));i=r;return}function kv(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+80|0;e=c[b+8>>2]|0;if((e|0)>0){g=0;do{f=c[(c[b+16>>2]|0)+(g<<2)>>2]|0;if((c[f+236>>2]|0)==1){Fb[c[(c[f>>2]|0)+24>>2]&127](f,d);e=c[b+8>>2]|0}g=g+1|0}while((g|0)<(e|0))}a[x+16>>0]=1;c[x+12>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;a[x+36>>0]=1;c[x+32>>2]=0;c[x+24>>2]=0;c[x+28>>2]=0;a[x+56>>0]=1;c[x+52>>2]=0;c[x+44>>2]=0;c[x+48>>2]=0;a[x+76>>0]=1;c[x+72>>2]=0;c[x+64>>2]=0;c[x+68>>2]=0;if((e|0)<=0){ov(x);i=x;return}o=0;g=0;h=0;m=0;r=0;while(1){q=c[(c[(c[b+16>>2]|0)+(r<<2)>>2]|0)+192>>2]|0;p=(q+~(q<<15)>>10^q+~(q<<15))*9|0;p=(p>>6^p)+~((p>>6^p)<<11)>>16^(p>>6^p)+~((p>>6^p)<<11);f=p&o+-1;l=f>>>0<g>>>0;a:do if(l){j=c[h+(f<<2)>>2]|0;if((j|0)!=-1){k=c[x+72>>2]|0;while(1){if((q|0)==(c[k+(j<<3)>>2]|0)){n=13;break}g=c[m+(j<<2)>>2]|0;if((g|0)==-1)break;else j=g}if((n|0)==13?(n=0,((c[x+52>>2]|0)+(j<<2)|0)!=0):0){g=o;f=m;break}if(!l){n=20;break}}g=c[h+(f<<2)>>2]|0;if((g|0)!=-1){j=c[x+72>>2]|0;while(1){if((q|0)==(c[j+(g<<3)>>2]|0))break;g=c[m+(g<<2)>>2]|0;if((g|0)==-1){n=20;break a}}c[(c[x+52>>2]|0)+(g<<2)>>2]=q;g=o;f=m;n=82}else n=20}else n=20;while(0);if((n|0)==20){n=c[x+44>>2]|0;if((n|0)==(o|0)){g=(o|0)!=0?o<<1:1;if((o|0)<(g|0)){if((g|0)!=0?(c[2703]=(c[2703]|0)+1,s=XE((g<<2|3)+16|0)|0,(s|0)!=0):0){c[(s+4+15&-16)+-4>>2]=s;j=s+4+15&-16}else j=0;if((o|0)>0){h=0;do{c[j+(h<<2)>>2]=c[(c[x+52>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(o|0))}h=c[x+52>>2]|0;if(h){if(a[x+56>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[x+52>>2]=0}a[x+56>>0]=1;c[x+52>>2]=j;c[x+48>>2]=g;e=o}else{g=o;e=o}}else{g=o;e=n}c[(c[x+52>>2]|0)+(e<<2)>>2]=q;c[x+44>>2]=e+1;h=c[x+64>>2]|0;if((h|0)==(c[x+68>>2]|0)?(w=(h|0)!=0?h<<1:1,(h|0)<(w|0)):0){if((w|0)!=0?(c[2703]=(c[2703]|0)+1,u=XE((w<<3|3)+16|0)|0,(u|0)!=0):0){c[(u+4+15&-16)+-4>>2]=u;j=u+4+15&-16}else j=0;if((h|0)>0){g=0;do{k=(c[x+72>>2]|0)+(g<<3)|0;l=c[k+4>>2]|0;m=j+(g<<3)|0;c[m>>2]=c[k>>2];c[m+4>>2]=l;g=g+1|0}while((g|0)!=(h|0))}g=c[x+72>>2]|0;if(g){if(a[x+76>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0)}c[x+72>>2]=0}a[x+76>>0]=1;c[x+72>>2]=j;c[x+68>>2]=w;h=c[x+64>>2]|0;g=c[x+48>>2]|0}m=(c[x+72>>2]|0)+(h<<3)|0;c[m>>2]=q;c[m+4>>2]=0;c[x+64>>2]=h+1;if((o|0)<(g|0)){l=c[x+4>>2]|0;do if((g|0)>(l|0)){if((g|0)>=(l|0)){do if((c[x+8>>2]|0)<(g|0)){if((g|0)!=0?(c[2703]=(c[2703]|0)+1,t=XE((g<<2|3)+16|0)|0,(t|0)!=0):0){c[(t+4+15&-16)+-4>>2]=t;f=t+4+15&-16}else f=0;h=c[x+12>>2]|0;if((l|0)<=0){if(!h){a[x+16>>0]=1;c[x+12>>2]=f;c[x+8>>2]=g;break}}else{e=0;do{c[f+(e<<2)>>2]=c[h+(e<<2)>>2];e=e+1|0}while((e|0)!=(l|0))}if(a[x+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}a[x+16>>0]=1;c[x+12>>2]=f;c[x+8>>2]=g}else f=c[x+12>>2]|0;while(0);qF(f+(l<<2)|0,0,g-l<<2|0)|0}c[x+4>>2]=g;j=c[x+24>>2]|0;if((g|0)>(j|0)){do if((c[x+28>>2]|0)<(g|0)){if((g|0)!=0?(c[2703]=(c[2703]|0)+1,v=XE((g<<2|3)+16|0)|0,(v|0)!=0):0){c[(v+4+15&-16)+-4>>2]=v;f=v+4+15&-16}else f=0;h=c[x+32>>2]|0;if((j|0)<=0){if(!h){a[x+36>>0]=1;c[x+32>>2]=f;c[x+28>>2]=g;break}}else{e=0;do{c[f+(e<<2)>>2]=c[h+(e<<2)>>2];e=e+1|0}while((e|0)!=(j|0))}if(a[x+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}a[x+36>>0]=1;c[x+32>>2]=f;c[x+28>>2]=g}else f=c[x+32>>2]|0;while(0);qF(f+(j<<2)|0,0,g-j<<2|0)|0}c[x+24>>2]=g;if((g|0)>0){o=g<<2;qF(c[x+12>>2]|0,-1,o|0)|0;qF(c[x+32>>2]|0,-1,o|0)|0}if((l|0)<=0){g=c[x+48>>2]|0;break}h=c[x+72>>2]|0;f=c[x+12>>2]|0;e=c[x+32>>2]|0;g=c[x+48>>2]|0;j=0;do{o=c[h+(j<<3)>>2]|0;o=(o+~(o<<15)>>10^o+~(o<<15))*9|0;o=f+((((o>>6^o)+~((o>>6^o)<<11)>>16^(o>>6^o)+~((o>>6^o)<<11))&g+-1)<<2)|0;c[e+(j<<2)>>2]=c[o>>2];c[o>>2]=j;j=j+1|0}while((j|0)!=(l|0))}while(0);e=g;f=p&g+-1}else e=g;h=c[x+12>>2]|0;g=h+(f<<2)|0;f=c[x+32>>2]|0;c[f+(n<<2)>>2]=c[g>>2];c[g>>2]=n;g=e;n=82}if((n|0)==82){n=0;Fb[c[(c[q>>2]|0)+60>>2]&127](q,d);e=c[b+8>>2]|0}j=r+1|0;if((j|0)>=(e|0))break;o=g;g=c[x+4>>2]|0;m=f;r=j}ov(x);i=x;return}function lv(a,b){a=a|0;b=b|0;Db[c[(c[b>>2]|0)+32>>2]&255](b);kv(a,b);Db[c[(c[b>>2]|0)+36>>2]&255](b);return}function mv(a,d){a=a|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0;e=i;i=i+128|0;G=c[(c[a+8>>2]|0)+24>>2]|0;h=c[G+(d*80|0)+64>>2]|0;f=c[a+12>>2]|0;x=+g[G+(d*80|0)>>2];D=+g[f>>2];w=+g[G+(d*80|0)+16>>2];C=+g[f+4>>2];v=+g[G+(d*80|0)+32>>2];B=+g[f+8>>2];u=+g[G+(d*80|0)+4>>2];t=+g[G+(d*80|0)+20>>2];s=+g[G+(d*80|0)+36>>2];r=+g[G+(d*80|0)+8>>2];p=+g[G+(d*80|0)+24>>2];n=+g[G+(d*80|0)+40>>2];A=+g[f+16>>2];z=+g[f+20>>2];y=+g[f+24>>2];q=+g[f+32>>2];o=+g[f+36>>2];m=+g[f+40>>2];F=+g[G+(d*80|0)+48>>2];E=+g[G+(d*80|0)+52>>2];j=+g[G+(d*80|0)+56>>2];l=+g[f+48>>2]+(D*F+C*E+B*j);k=A*F+z*E+y*j+ +g[f+52>>2];j=q*F+o*E+m*j+ +g[f+56>>2];g[e+56>>2]=x*D+w*C+v*B;g[e+56+4>>2]=D*u+C*t+B*s;g[e+56+8>>2]=D*r+C*p+B*n;g[e+56+12>>2]=0.0;g[e+56+16>>2]=x*A+w*z+v*y;g[e+56+20>>2]=u*A+t*z+s*y;g[e+56+24>>2]=r*A+p*z+n*y;g[e+56+28>>2]=0.0;g[e+56+32>>2]=x*q+w*o+v*m;g[e+56+36>>2]=u*q+t*o+s*m;g[e+56+40>>2]=r*q+p*o+n*m;g[e+56+44>>2]=0.0;g[e+56+48>>2]=l;g[e+56+52>>2]=k;g[e+56+56>>2]=j;g[e+56+60>>2]=0.0;f=c[a+4>>2]|0;c[e+32>>2]=0;c[e+32+4>>2]=h;c[e+32+8>>2]=f;c[e+32+12>>2]=e+56;c[e+32+16>>2]=-1;c[e+32+20>>2]=d;f=c[a+24>>2]|0;g[e+4>>2]=1.0;c[e+8>>2]=0;b[e+12>>1]=1;b[e+14>>1]=-1;c[e+16>>2]=0;c[e>>2]=6212;c[e+20>>2]=f;c[e+24>>2]=d;c[e+4>>2]=c[f+4>>2];c[e+16>>2]=c[f+16>>2];dv(c[a+16>>2]|0,c[a+20>>2]|0,e+32|0,e);i=e;return}function nv(a){a=a|0;return}function ov(b){b=b|0;var d=0;d=c[b+72>>2]|0;if(d){if(a[b+76>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+72>>2]=0}a[b+76>>0]=1;c[b+72>>2]=0;c[b+64>>2]=0;c[b+68>>2]=0;d=c[b+52>>2]|0;if(d){if(a[b+56>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;d=c[b+12>>2]|0;if(!d){a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;d=b+8|0;c[d>>2]=0;return}if(a[b+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+12>>2]=0;a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;d=b+8|0;c[d>>2]=0;return}function pv(a){a=a|0;YE(a);return}function qv(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;h=i;i=i+48|0;c[h+32>>2]=e;c[h+32+4>>2]=f;n=+g[b>>2];m=+g[b+4>>2];j=+g[b+8>>2];l=+g[a+56>>2]*n+ +g[a+60>>2]*m+ +g[a+64>>2]*j;k=n*+g[a+72>>2]+m*+g[a+76>>2]+j*+g[a+80>>2];j=n*+g[a+88>>2]+m*+g[a+92>>2]+j*+g[a+96>>2];c[h>>2]=c[a+48>>2];c[h+4>>2]=h+32;g[h+8>>2]=l;g[h+12>>2]=k;g[h+16>>2]=j;g[h+20>>2]=0.0;g[h+24>>2]=d;b=c[a+44>>2]|0;d=+$b[c[(c[b>>2]|0)+12>>2]&15](b,h,1);i=h;return +d}function rv(a){a=a|0;YE(a);return}function sv(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;h=i;i=i+48|0;c[h+32>>2]=e;c[h+32+4>>2]=f;n=+g[b>>2];m=+g[b+4>>2];j=+g[b+8>>2];l=+g[a+56>>2]*n+ +g[a+60>>2]*m+ +g[a+64>>2]*j;k=n*+g[a+72>>2]+m*+g[a+76>>2]+j*+g[a+80>>2];j=n*+g[a+88>>2]+m*+g[a+92>>2]+j*+g[a+96>>2];c[h>>2]=c[a+48>>2];c[h+4>>2]=h+32;g[h+8>>2]=l;g[h+12>>2]=k;g[h+16>>2]=j;g[h+20>>2]=0.0;g[h+24>>2]=d;b=c[a+44>>2]|0;d=+$b[c[(c[b>>2]|0)+12>>2]&15](b,h,1);i=h;return +d}function tv(a){a=a|0;return}function uv(a){a=a|0;YE(a);return}function vv(a,b,c){a=a|0;b=b|0;c=c|0;return}function wv(a,b){a=a|0;b=b|0;mv(a,c[b+36>>2]|0);return}function xv(a,b,d){a=a|0;b=b|0;d=+d;Fb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function yv(a,b){a=a|0;b=b|0;return 1}function zv(a,b){a=a|0;b=b|0;return 1}function Av(a){a=a|0;YE(a);return}function Bv(a,b){a=a|0;b=b|0;a=c[a+20>>2]|0;return _b[c[(c[a>>2]|0)+8>>2]&31](a,b)|0}function Cv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,g=0;e=i;i=i+16|0;c[e>>2]=-1;c[e+4>>2]=c[a+24>>2];if(!(c[b+4>>2]|0))c[b+4>>2]=e;g=c[a+20>>2]|0;f=+$b[c[(c[g>>2]|0)+12>>2]&15](g,b,d);c[a+4>>2]=c[(c[a+20>>2]|0)+4>>2];i=e;return +f}function Dv(a){a=a|0;YE(a);return}function Ev(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=h|0;var j=0;j=i;i=i+64|0;c[j>>2]=f;c[j+4>>2]=h;f=c[a+212>>2]|0;if(!(+g[f+4>>2]>=e)){i=j;return +e}c[j+8>>2]=c[a+216>>2];c[j+8+4>>2]=j;c[j+8+8>>2]=c[b>>2];c[j+8+8+4>>2]=c[b+4>>2];c[j+8+8+8>>2]=c[b+8>>2];c[j+8+8+12>>2]=c[b+12>>2];c[j+8+24>>2]=c[d>>2];c[j+8+24+4>>2]=c[d+4>>2];c[j+8+24+8>>2]=c[d+8>>2];c[j+8+24+12>>2]=c[d+12>>2];g[j+8+40>>2]=e;e=+$b[c[(c[f>>2]|0)+12>>2]&15](f,j+8|0,1);i=j;return +e}function Fv(a){a=a|0;YE(a);return}function Gv(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=h|0;var j=0;j=i;i=i+64|0;c[j>>2]=f;c[j+4>>2]=h;f=c[a+212>>2]|0;if(!(+g[f+4>>2]>=e)){i=j;return +e}c[j+8>>2]=c[a+216>>2];c[j+8+4>>2]=j;c[j+8+8>>2]=c[b>>2];c[j+8+8+4>>2]=c[b+4>>2];c[j+8+8+8>>2]=c[b+8>>2];c[j+8+8+12>>2]=c[b+12>>2];c[j+8+24>>2]=c[d>>2];c[j+8+24+4>>2]=c[d+4>>2];c[j+8+24+8>>2]=c[d+8>>2];c[j+8+24+12>>2]=c[d+12>>2];g[j+8+40>>2]=e;e=+$b[c[(c[f>>2]|0)+12>>2]&15](f,j+8|0,0);i=j;return +e}function Hv(a){a=a|0;YE(a);return}function Iv(a,b){a=a|0;b=b|0;a=c[a+12>>2]|0;return _b[c[(c[a>>2]|0)+8>>2]&31](a,b)|0}function Jv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,g=0;e=i;i=i+16|0;c[e>>2]=-1;c[e+4>>2]=c[a+16>>2];if(!(c[b+4>>2]|0))c[b+4>>2]=e;g=c[a+12>>2]|0;f=+$b[c[(c[g>>2]|0)+12>>2]&15](g,b,d);c[a+4>>2]=c[(c[a+12>>2]|0)+4>>2];i=e;return +f}function Kv(a){a=a|0;return}function Lv(a){a=a|0;YE(a);return}function Mv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=i;i=i+32|0;d=c[a+216>>2]|0;if(+g[d+4>>2]==0.0){b=0;i=e;return b|0}b=c[b>>2]|0;if(!(_b[c[(c[d>>2]|0)+8>>2]&31](d,c[b+188>>2]|0)|0)){b=1;i=e;return b|0}f=c[b+192>>2]|0;d=c[a+216>>2]|0;c[e>>2]=0;c[e+4>>2]=f;c[e+8>>2]=b;c[e+12>>2]=b+4;c[e+16>>2]=-1;c[e+20>>2]=-1;dv(a+68|0,a+132|0,e,d);b=1;i=e;return b|0}function Nv(a){a=a|0;YE(a);return}function Ov(a,b){a=a|0;b=b|0;var d=0,e=0,f=0.0,h=0,j=0;e=i;i=i+32|0;d=c[a+184>>2]|0;if(+g[d+4>>2]==0.0){b=0;i=e;return b|0}b=c[b>>2]|0;if(!(_b[c[(c[d>>2]|0)+8>>2]&31](d,c[b+188>>2]|0)|0)){b=1;i=e;return b|0}h=c[a+192>>2]|0;j=c[b+192>>2]|0;d=c[a+184>>2]|0;f=+g[a+188>>2];c[e>>2]=0;c[e+4>>2]=j;c[e+8>>2]=b;c[e+12>>2]=b+4;c[e+16>>2]=-1;c[e+20>>2]=-1;ev(h,a+36|0,a+100|0,e,d,f);b=1;i=e;return b|0}function Pv(a){a=a|0;YE(a);return}function Qv(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0,A=0;w=i;i=i+192|0;r=c[(c[b+4>>2]|0)+740>>2]|0;s=c[(c[b+8>>2]|0)+8>>2]|0;q=+g[e>>2];t=+g[d>>2]*f+q;h=+g[e+4>>2];v=+g[d+4>>2]*f+h;j=+g[e+8>>2];u=+g[d+8>>2]*f+j;o=c[(c[b+12>>2]|0)+8>>2]|0;p=+g[o+52>>2];if((r|0)!=(s|0)){n=v-+g[o+56>>2];m=u-+g[o+60>>2];x=q-+g[s+52>>2];q=h-+g[s+56>>2];j=j-+g[s+60>>2];h=x*+g[s+4>>2]+q*+g[s+20>>2]+j*+g[s+36>>2];k=(t-p)*+g[o+4>>2]+n*+g[o+20>>2]+m*+g[o+36>>2];l=(t-p)*+g[o+8>>2]+n*+g[o+24>>2]+m*+g[o+40>>2];m=(t-p)*+g[o+12>>2]+n*+g[o+28>>2]+m*+g[o+44>>2];n=x*+g[s+8>>2]+q*+g[s+24>>2]+j*+g[s+40>>2];j=x*+g[s+12>>2]+q*+g[s+28>>2]+j*+g[s+44>>2]}else{y=t-+g[r+52>>2];n=v-+g[r+56>>2];m=u-+g[r+60>>2];x=h-+g[o+56>>2];j=j-+g[o+60>>2];h=(q-p)*+g[o+4>>2]+x*+g[o+20>>2]+j*+g[o+36>>2];k=y*+g[r+4>>2]+n*+g[r+20>>2]+m*+g[r+36>>2];l=y*+g[r+8>>2]+n*+g[r+24>>2]+m*+g[r+40>>2];m=y*+g[r+12>>2]+n*+g[r+28>>2]+m*+g[r+44>>2];n=(q-p)*+g[o+8>>2]+x*+g[o+24>>2]+j*+g[o+40>>2];j=(q-p)*+g[o+12>>2]+x*+g[o+28>>2]+j*+g[o+44>>2]}g[w>>2]=k;g[w+4>>2]=l;g[w+8>>2]=m;g[w+12>>2]=0.0;g[w+16>>2]=h;g[w+20>>2]=n;g[w+24>>2]=j;g[w+28>>2]=0.0;c[w+64>>2]=c[d>>2];c[w+64+4>>2]=c[d+4>>2];c[w+64+8>>2]=c[d+8>>2];c[w+64+12>>2]=c[d+12>>2];g[w+80>>2]=f;g[w+84>>2]=0.0;g[w+88>>2]=0.0;g[w+92>>2]=0.0;c[w+112>>2]=0;a[w+116>>0]=0;c[w+120>>2]=0;c[w+120+4>>2]=0;c[w+120+8>>2]=0;c[w+120+12>>2]=0;c[w+120+16>>2]=0;c[w+120+20>>2]=0;c[w+120+24>>2]=0;c[w+120+28>>2]=0;g[w+48>>2]=t;g[w+52>>2]=v;g[w+56>>2]=u;g[w+60>>2]=0.0;c[w+32>>2]=c[e>>2];c[w+32+4>>2]=c[e+4>>2];c[w+32+8>>2]=c[e+8>>2];c[w+32+12>>2]=c[e+12>>2];d=c[b+20>>2]|0;e=c[b+16>>2]|0;o=c[b+28>>2]|0;A=c[b+24>>2]|0;z=(r|0)!=(s|0)?d:e;d=(r|0)!=(s|0)?e:d;e=(r|0)!=(s|0)?o:A;o=(r|0)!=(s|0)?A:o;c[w+96>>2]=z;c[w+100>>2]=d;c[w+104>>2]=e;c[w+108>>2]=o;A=c[b+32>>2]|0;+Nb[c[(c[A>>2]|0)+12>>2]&1](A,w,c[((r|0)!=(s|0)?b+12|0:b+8|0)>>2]|0,z,e,c[((r|0)!=(s|0)?b+8|0:b+12|0)>>2]|0,d,o);i=w;return}function Rv(a){a=a|0;return}function Sv(a){a=a|0;YE(a+-4|0);return}function Tv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a+-4>>2]|0)+8>>2]&127](a+-4|0,b,d,e);return}function Uv(a){a=a|0;YE(a);return}function Vv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0;e=i;i=i+96|0;l=+g[b>>2];m=+g[a+28>>2];x=+g[b+4>>2];y=+g[a+32>>2];z=+g[b+8>>2];A=+g[a+36>>2];B=+g[a+44>>2];C=+g[a+48>>2];D=+g[a+52>>2];E=+g[a+60>>2];n=+g[a+64>>2];o=+g[a+68>>2];p=+g[a+76>>2];q=+g[a+80>>2];r=+g[a+84>>2];g[e+80>>2]=l*m+x*y+z*A+p;g[e+80+4>>2]=l*B+x*C+z*D+q;g[e+80+8>>2]=l*E+x*n+z*o+r;g[e+80+12>>2]=0.0;s=+g[b+16>>2];t=+g[b+20>>2];u=+g[b+24>>2];g[e+64>>2]=s*m+t*y+u*A+p;g[e+64+4>>2]=s*B+t*C+u*D+q;g[e+64+8>>2]=s*E+t*n+u*o+r;g[e+64+12>>2]=0.0;v=+g[b+32>>2];w=+g[b+36>>2];f=+g[b+40>>2];g[e+48>>2]=v*m+w*y+f*A+p;g[e+48+4>>2]=v*B+w*C+f*D+q;g[e+48+8>>2]=v*E+w*n+f*o+r;g[e+48+12>>2]=0.0;h=(l*m+x*y+z*A+p+(s*m+t*y+u*A+p)+(v*m+w*y+f*A+p))*.3333333432674408;j=(l*B+x*C+z*D+q+(s*B+t*C+u*D+q)+(v*B+w*C+f*D+q))*.3333333432674408;k=(l*E+x*n+z*o+r+(s*E+t*n+u*o+r)+(v*E+w*n+f*o+r))*.3333333432674408;g[e+32>>2]=h;g[e+32+4>>2]=j;g[e+32+8>>2]=k;g[e+32+12>>2]=0.0;d=c[a+8>>2]|0;if(!((Hb[c[(c[d>>2]|0)+48>>2]&127](d)|0)&16384)){b=c[a+8>>2]|0;F=c[b>>2]|0;F=F+8|0;F=c[F>>2]|0;d=a+12|0;nc[F&127](b,e+80|0,e+64|0,d);b=c[a+8>>2]|0;F=c[b>>2]|0;F=F+8|0;F=c[F>>2]|0;nc[F&127](b,e+64|0,e+48|0,d);b=c[a+8>>2]|0;a=c[b>>2]|0;a=a+8|0;a=c[a>>2]|0;nc[a&127](b,e+48|0,e+80|0,d);i=e;return}H=s*m+t*y+u*A+p-(l*m+x*y+z*A+p);G=s*B+t*C+u*D+q-(l*B+x*C+z*D+q);u=s*E+t*n+u*o+r-(l*E+x*n+z*o+r);A=v*m+w*y+f*A+p-(l*m+x*y+z*A+p);C=v*B+w*C+f*D+q-(l*B+x*C+z*D+q);z=v*E+w*n+f*o+r-(l*E+x*n+z*o+r);B=1.0/+O(+((H*C-G*A)*(H*C-G*A)+((G*z-u*C)*(G*z-u*C)+(u*A-H*z)*(u*A-H*z))));c[e+16>>2]=1065353216;c[e+16+4>>2]=1065353216;c[e+16+8>>2]=0;g[e+16+12>>2]=0.0;b=c[a+8>>2]|0;F=c[(c[b>>2]|0)+8>>2]|0;g[e>>2]=B*(G*z-u*C)+h;g[e+4>>2]=B*(u*A-H*z)+j;g[e+8>>2]=B*(H*C-G*A)+k;g[e+12>>2]=0.0;nc[F&127](b,e+32|0,e,e+16|0);b=c[a+8>>2]|0;F=c[b>>2]|0;F=F+8|0;F=c[F>>2]|0;d=a+12|0;nc[F&127](b,e+80|0,e+64|0,d);b=c[a+8>>2]|0;F=c[b>>2]|0;F=F+8|0;F=c[F>>2]|0;nc[F&127](b,e+64|0,e+48|0,d);b=c[a+8>>2]|0;a=c[b>>2]|0;a=a+8|0;a=c[a>>2]|0;nc[a&127](b,e+48|0,e+80|0,d);i=e;return}function Wv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;nc[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e);return}function Xv(b){b=b|0;var d=0;c[b>>2]=6236;if(!(a[b+8>>0]|0))return;d=c[b+12>>2]|0;if(!d)return;b=c[b+4>>2]|0;Fb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function Yv(b){b=b|0;var d=0,e=0;c[b>>2]=6236;if(!(a[b+8>>0]|0)){YE(b);return}d=c[b+12>>2]|0;if(!d){YE(b);return}e=c[b+4>>2]|0;Fb[c[(c[e>>2]|0)+16>>2]&127](e,d);YE(b);return}function Zv(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=i;i=i+160|0;j=c[b+12>>2]|0;if(!j){i=l;return}m=(a[b+16>>0]|0)!=0;n=m?e:d;e=m?d:e;p=c[n+4>>2]|0;o=c[e+4>>2]|0;c[h+4>>2]=j;d=c[j+752>>2]|0;c[l>>2]=10628;c[l+4>>2]=p;c[l+8>>2]=o;c[l+12>>2]=d;g[l+16+128>>2]=999999984306749440.0;d=c[n+12>>2]|0;c[l+16>>2]=c[d>>2];c[l+16+4>>2]=c[d+4>>2];c[l+16+8>>2]=c[d+8>>2];c[l+16+12>>2]=c[d+12>>2];c[l+16+16>>2]=c[d+16>>2];c[l+16+16+4>>2]=c[d+16+4>>2];c[l+16+16+8>>2]=c[d+16+8>>2];c[l+16+16+12>>2]=c[d+16+12>>2];c[l+16+32>>2]=c[d+32>>2];c[l+16+32+4>>2]=c[d+32+4>>2];c[l+16+32+8>>2]=c[d+32+8>>2];c[l+16+32+12>>2]=c[d+32+12>>2];c[l+16+48>>2]=c[d+48>>2];c[l+16+48+4>>2]=c[d+48+4>>2];c[l+16+48+8>>2]=c[d+48+8>>2];c[l+16+48+12>>2]=c[d+48+12>>2];e=c[e+12>>2]|0;c[l+16+64>>2]=c[e>>2];c[l+16+64+4>>2]=c[e+4>>2];c[l+16+64+8>>2]=c[e+8>>2];c[l+16+64+12>>2]=c[e+12>>2];c[l+16+80>>2]=c[e+16>>2];c[l+16+80+4>>2]=c[e+16+4>>2];c[l+16+80+8>>2]=c[e+16+8>>2];c[l+16+80+12>>2]=c[e+16+12>>2];c[l+16+96>>2]=c[e+32>>2];c[l+16+96+4>>2]=c[e+32+4>>2];c[l+16+96+8>>2]=c[e+32+8>>2];c[l+16+96+12>>2]=c[e+32+12>>2];c[l+16+112>>2]=c[e+48>>2];c[l+16+112+4>>2]=c[e+48+4>>2];c[l+16+112+8>>2]=c[e+48+8>>2];c[l+16+112+12>>2]=c[e+48+12>>2];LD(l,l+16|0,h,c[f+20>>2]|0,m);do if((a[b+8>>0]|0)!=0?(k=c[h+4>>2]|0,(c[k+748>>2]|0)!=0):0){j=c[k+740>>2]|0;d=c[(c[h+8>>2]|0)+8>>2]|0;e=c[(c[h+12>>2]|0)+8>>2]|0;if((j|0)==(d|0)){Ns(k,j+4|0,e+4|0);break}else{Ns(k,e+4|0,d+4|0);break}}while(0);i=l;return}function _v(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function $v(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+12>>2]|0;if(!e)return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=(f|0)!=0?f<<1:1,(f|0)<(h|0)):0){if(!h){e=f;f=0}else{c[2703]=(c[2703]|0)+1;e=XE((h<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+4+15&-16)+-4>>2]=e;f=e+4+15&-16}e=c[d+4>>2]|0}if((e|0)>0){g=0;do{c[f+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0);e=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=f;c[d+8>>2]=h;f=e;e=c[b+12>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function aw(a){a=a|0;return}function bw(a){a=a|0;YE(a);return}function cw(b){b=b|0;var d=0;c[b>>2]=6284;if(!(a[b+16>>0]|0))return;d=c[b+20>>2]|0;if(!d)return;b=c[b+4>>2]|0;Fb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function dw(b){b=b|0;var d=0,e=0;c[b>>2]=6284;if(!(a[b+16>>0]|0)){YE(b);return}d=c[b+20>>2]|0;if(!d){YE(b);return}e=c[b+4>>2]|0;Fb[c[(c[e>>2]|0)+16>>2]&127](e,d);YE(b);return}function ew(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0,E=0,F=0,G=0,H=0.0,I=0,J=0.0,K=0.0,L=0.0,M=0.0,P=0.0,S=0.0,T=0.0,U=0.0,V=0,W=0,X=0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0,na=0.0,oa=0.0,pa=0.0,qa=0.0,ra=0,sa=0,ta=0,ua=0,va=0;va=i;i=i+784|0;l=c[b+20>>2]|0;if(!l){l=c[b+4>>2]|0;l=Qb[c[(c[l>>2]|0)+12>>2]&63](l,c[d+8>>2]|0,c[e+8>>2]|0)|0;c[b+20>>2]=l;a[b+16>>0]=1}c[h+4>>2]=l;ra=c[d+4>>2]|0;sa=c[e+4>>2]|0;k=c[ra+4>>2]|0;m=c[sa+4>>2]|0;if((k|0)==10&(m|0)==10){z=+g[l+752>>2];ta=c[ra+52>>2]|0;v=+g[ra+28+(ta<<2)>>2];H=+g[ra+28+(((ta+2|0)%3|0)<<2)>>2];ua=c[sa+52>>2]|0;r=+g[sa+28+(ua<<2)>>2];J=+g[sa+28+(((ua+2|0)%3|0)<<2)>>2];d=c[d+12>>2]|0;F=c[e+12>>2]|0;B=+g[d+(ta<<2)>>2];D=+g[d+16+(ta<<2)>>2];A=+g[d+32+(ta<<2)>>2];s=+g[F+(ua<<2)>>2];u=+g[F+16+(ua<<2)>>2];o=+g[F+32+(ua<<2)>>2];n=+g[F+48>>2]-+g[d+48>>2];x=+g[F+52>>2]-+g[d+52>>2];y=+g[F+56>>2]-+g[d+56>>2];q=1.0-(B*s+D*u+A*o)*(B*s+D*u+A*o);if(!(q==0.0)){q=(B*n+D*x+A*y-(B*s+D*u+A*o)*(s*n+u*x+o*y))/q;if(!(q<-v)){if(q>v)q=v}else q=-v}else q=0.0;p=(B*s+D*u+A*o)*q-(s*n+u*x+o*y);if(p<-r){q=(B*s+D*u+A*o)*-r+(B*n+D*x+A*y);if(!(q<-v))if(q>v){q=v;r=-r}else r=-r;else{q=-v;r=-r}}else if(p>r){q=r*(B*s+D*u+A*o)+(B*n+D*x+A*y);if(!(q<-v)){if(q>v)q=v}else q=-v}else r=p;v=s*r;u=u*r;s=o*r;o=v+(n-B*q);n=u+(x-D*q);p=s+(y-A*q);r=+O(+(p*p+(o*o+n*n)));if(!(r-H-J>z)){do if(p*p+(o*o+n*n)<=1.4210854715202004e-14)if(+N(+A)>.7071067690849304){p=1.0/+O(+(D*D+A*A));g[va+392>>2]=0.0;g[va+392+4>>2]=-(A*p);g[va+392+8>>2]=D*p;o=0.0;q=-(A*p);p=D*p;break}else{q=1.0/+O(+(B*B+D*D));g[va+392>>2]=-(D*q);g[va+392+4>>2]=B*q;g[va+392+8>>2]=0.0;o=-(D*q);q=B*q;p=0.0;break}else{g[va+392>>2]=o*-(1.0/r);g[va+392+4>>2]=n*-(1.0/r);g[va+392+8>>2]=p*-(1.0/r);g[va+392+12>>2]=0.0;o=o*-(1.0/r);q=n*-(1.0/r);p=p*-(1.0/r)}while(0);B=J*q+(u+ +g[F+52>>2]);D=J*p+(s+ +g[F+56>>2]);g[va+376>>2]=J*o+(v+ +g[F+48>>2]);g[va+376+4>>2]=B;g[va+376+8>>2]=D;g[va+376+12>>2]=0.0}if(r-H-J<z){ic[c[(c[h>>2]|0)+16>>2]&15](h,va+392|0,va+376|0,r-H-J);l=c[h+4>>2]|0}if(!(c[l+748>>2]|0)){i=va;return}k=c[l+740>>2]|0;m=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((k|0)==(m|0)){Ns(l,k+4|0,j+4|0);i=va;return}else{Ns(l,j+4|0,m+4|0);i=va;return}}g[va+120+128>>2]=999999984306749440.0;E=c[b+8>>2]|0;F=c[b+12>>2]|0;c[va+40>>2]=10508;c[va+40+4>>2]=0;c[va+40+8>>2]=1065353216;c[va+40+12>>2]=0;g[va+40+16>>2]=0.0;c[va+40+20>>2]=F;c[va+40+24>>2]=E;c[va+40+28>>2]=ra;c[va+40+32>>2]=sa;c[va+40+36>>2]=k;c[va+40+40>>2]=m;g[va+40+44>>2]=+Tb[c[(c[ra>>2]|0)+48>>2]&15](ra);g[va+40+48>>2]=+Tb[c[(c[sa>>2]|0)+48>>2]&15](sa);a[va+40+52>>0]=0;c[va+40+60>>2]=-1;c[va+40+72>>2]=1;c[va+40+76>>2]=1;c[va+40+28>>2]=ra;c[va+40+32>>2]=sa;H=+Tb[c[(c[ra>>2]|0)+48>>2]&15](ra);J=+Tb[c[(c[sa>>2]|0)+48>>2]&15](sa);J=H+J+ +g[(c[b+20>>2]|0)+752>>2];g[va+120+128>>2]=J*J;E=c[d+12>>2]|0;c[va+120>>2]=c[E>>2];c[va+120+4>>2]=c[E+4>>2];c[va+120+8>>2]=c[E+8>>2];c[va+120+12>>2]=c[E+12>>2];F=va+120+16|0;c[F>>2]=c[E+16>>2];c[F+4>>2]=c[E+16+4>>2];c[F+8>>2]=c[E+16+8>>2];c[F+12>>2]=c[E+16+12>>2];G=va+120+32|0;c[G>>2]=c[E+32>>2];c[G+4>>2]=c[E+32+4>>2];c[G+8>>2]=c[E+32+8>>2];c[G+12>>2]=c[E+32+12>>2];l=va+120+48|0;c[l>>2]=c[E+48>>2];c[l+4>>2]=c[E+48+4>>2];c[l+8>>2]=c[E+48+8>>2];c[l+12>>2]=c[E+48+12>>2];E=va+120+64|0;t=c[e+12>>2]|0;c[E>>2]=c[t>>2];c[E+4>>2]=c[t+4>>2];c[E+8>>2]=c[t+8>>2];c[E+12>>2]=c[t+12>>2];k=va+120+80|0;c[k>>2]=c[t+16>>2];c[k+4>>2]=c[t+16+4>>2];c[k+8>>2]=c[t+16+8>>2];c[k+12>>2]=c[t+16+12>>2];I=va+120+96|0;c[I>>2]=c[t+32>>2];c[I+4>>2]=c[t+32+4>>2];c[I+8>>2]=c[t+32+8>>2];c[I+12>>2]=c[t+32+12>>2];w=va+120+112|0;c[w>>2]=c[t+48>>2];c[w+4>>2]=c[t+48+4>>2];c[w+8>>2]=c[t+48+8>>2];c[w+12>>2]=c[t+48+12>>2];t=c[ra+4>>2]|0;if((t|0)<7?(j=c[sa+4>>2]|0,(j|0)<7):0){c[va+372>>2]=6312;if(!t){t=j;u=0.0}else{u=+Tb[c[(c[ra>>2]|0)+48>>2]&15](ra);t=c[sa+4>>2]|0}if(!t)s=0.0;else s=+Tb[c[(c[sa>>2]|0)+48>>2]&15](sa);c[va>>2]=6340;c[va+4>>2]=h;g[va+24>>2]=u;g[va+28>>2]=s;a[va+36>>0]=0;W=c[ra+52>>2]|0;a:do if(W){ma=c[sa+52>>2]|0;do if(ma){qa=+g[(c[b+20>>2]|0)+752>>2];if(!(a[f+24>>0]|0)){nD(va+40|0,va+120|0,va,c[f+20>>2]|0,0);n=+g[va+32>>2];if(n<0.0&(a[va+36>>0]|0)!=0){r=+g[va+8>>2];s=+g[va+16>>2];m=c[va+20>>2]|0;q=+g[va+12>>2];ta=104}}else{I=c[d+12>>2]|0;G=c[e+12>>2]|0;c[2617]=(c[2617]|0)+1;z=+g[W+64>>2];B=+g[W+68>>2];s=+g[I+4>>2];D=+g[W+72>>2];u=+g[I+8>>2];v=+g[I+16>>2];r=+g[I+20>>2];q=+g[I+24>>2];x=+g[I+32>>2];p=+g[I+36>>2];A=+g[I+40>>2];H=+g[ma+64>>2];J=+g[ma+68>>2];oa=+g[ma+72>>2];na=z*+g[I>>2]+B*s+D*u+ +g[I+48>>2]-(H*+g[G>>2]+J*+g[G+4>>2]+oa*+g[G+8>>2]+ +g[G+48>>2]);pa=z*v+B*r+D*q+ +g[I+52>>2]-(H*+g[G+16>>2]+J*+g[G+20>>2]+oa*+g[G+24>>2]+ +g[G+52>>2]);oa=z*x+B*p+D*A+ +g[I+56>>2]-(H*+g[G+32>>2]+J*+g[G+36>>2]+oa*+g[G+40>>2]+ +g[G+56>>2]);F=c[W+28>>2]|0;b:do if((F|0)>0){z=s;B=r;D=q;H=0.0;J=3402823466385288598117041.0e14;C=0;K=0.0;n=0.0;m=0;y=0.0;while(1){w=c[W+36>>2]|0;L=+g[w+(C*36|0)+20>>2];ja=+g[w+(C*36|0)+24>>2];s=+g[w+(C*36|0)+28>>2];r=L*+g[I>>2]+ja*z+s*u;q=L*v+ja*B+s*D;s=L*x+ja*p+s*A;g[va+320>>2]=r;g[va+320+4>>2]=q;g[va+320+8>>2]=s;g[va+320+12>>2]=0.0;if(na*r+pa*q+oa*s<0.0){g[va+320>>2]=-r;g[va+320+4>>2]=-q;g[va+320+8>>2]=-s;r=-r;q=-q;s=-s}c[2615]=(c[2615]|0)+1;do if(iD(I,G,na,pa,oa,r,q,s,W,ma,J)|0){c[2616]=(c[2616]|0)+1;XD(W,I,va+320|0,va+720|0,va+480|0,va+456|0,va+440|0);XD(ma,G,va+320|0,va+476|0,va+472|0,va+424|0,va+408|0);x=+g[va+480>>2];v=+g[va+476>>2];do if(x<v){v=H;t=0}else{u=+g[va+472>>2];p=+g[va+720>>2];if(u<p){v=H;t=0;break}v=x-v<u-p?x-v:u-p;t=1}while(0);if(!t){t=0;r=K;s=n;q=y;break b}if(!(v<J)){H=v;r=K;s=n;q=y;break}H=v;J=v;m=0}else{r=K;s=n;q=y}while(0);C=C+1|0;if((C|0)>=(F|0)){v=J;ta=51;break b}z=+g[I+4>>2];u=+g[I+8>>2];v=+g[I+16>>2];B=+g[I+20>>2];D=+g[I+24>>2];x=+g[I+32>>2];p=+g[I+36>>2];A=+g[I+40>>2];K=r;n=s;y=q}}else{v=3402823466385288598117041.0e14;r=0.0;s=0.0;m=0;q=0.0;ta=51}while(0);c:do if((ta|0)==51){k=c[ma+28>>2]|0;if((k|0)>0){u=0.0;F=0;J=r;H=s;D=q;while(1){w=c[ma+36>>2]|0;A=+g[w+(F*36|0)+20>>2];B=+g[w+(F*36|0)+24>>2];s=+g[w+(F*36|0)+28>>2];r=A*+g[G>>2]+B*+g[G+4>>2]+s*+g[G+8>>2];q=A*+g[G+16>>2]+B*+g[G+20>>2]+s*+g[G+24>>2];s=A*+g[G+32>>2]+B*+g[G+36>>2]+s*+g[G+40>>2];g[va+304>>2]=r;g[va+304+4>>2]=q;g[va+304+8>>2]=s;g[va+304+12>>2]=0.0;if(na*r+pa*q+oa*s<0.0){g[va+304>>2]=-r;g[va+304+4>>2]=-q;g[va+304+8>>2]=-s;r=-r;q=-q;s=-s}c[2615]=(c[2615]|0)+1;do if(iD(I,G,na,pa,oa,r,q,s,W,ma,v)|0){c[2616]=(c[2616]|0)+1;XD(W,I,va+304|0,va+720|0,va+480|0,va+456|0,va+440|0);XD(ma,G,va+304|0,va+476|0,va+472|0,va+424|0,va+408|0);x=+g[va+480>>2];p=+g[va+476>>2];do if(x<p)t=0;else{o=+g[va+472>>2];y=+g[va+720>>2];if(o<y){t=0;break}u=x-p<o-y?x-p:o-y;t=1}while(0);if(!t){t=0;r=J;s=H;q=D;break c}if(!(u<v)){B=u;r=J;s=H;q=D;break}B=u;v=u;m=0}else{B=u;r=J;s=H;q=D}while(0);F=F+1|0;if((F|0)>=(k|0))break;else{u=B;J=r;H=s;D=q}}}l=c[W+48>>2]|0;if((l|0)>0){F=c[ma+48>>2]|0;u=0.0;j=0;k=-1;X=-1;A=0.0;o=0.0;H=0.0;y=0.0;D=0.0;z=0.0;p=0.0;U=0.0;n=0.0;T=0.0;J=0.0;S=0.0;L=0.0;M=0.0;P=0.0;da=0.0;x=0.0;K=0.0;while(1){w=c[W+56>>2]|0;Y=+g[w+(j<<4)>>2];B=+g[w+(j<<4)+4>>2];ja=+g[w+(j<<4)+8>>2];la=Y*+g[I>>2]+B*+g[I+4>>2]+ja*+g[I+8>>2];ka=Y*+g[I+16>>2]+B*+g[I+20>>2]+ja*+g[I+24>>2];ja=Y*+g[I+32>>2]+B*+g[I+36>>2]+ja*+g[I+40>>2];if((F|0)>0){B=u;f=0;ga=r;ha=s;ia=q;$=o;ba=y;fa=p;aa=K;while(1){w=c[ma+56>>2]|0;o=+g[w+(f<<4)>>2];y=+g[w+(f<<4)+4>>2];K=+g[w+(f<<4)+8>>2];Y=o*+g[G>>2]+y*+g[G+4>>2]+K*+g[G+8>>2];Z=o*+g[G+16>>2]+y*+g[G+20>>2]+K*+g[G+24>>2];K=o*+g[G+32>>2]+y*+g[G+36>>2]+K*+g[G+40>>2];g[va+288>>2]=ka*K-ja*Z;g[va+288+4>>2]=ja*Y-la*K;g[va+288+8>>2]=la*Z-ka*Y;g[va+288+12>>2]=0.0;do if(!(+N(+(ka*K-ja*Z))>1.0e-06)){if(+N(+(ja*Y-la*K))>1.0e-06){ta=69;break}if(!(+N(+(la*Z-ka*Y))>1.0e-06)){r=ga;s=ha;q=ia;_=A;ca=z;p=fa;ea=n;Y=da;K=aa}else ta=69}else ta=69;while(0);do if((ta|0)==69){ta=0;s=1.0/+O(+((ka*K-ja*Z)*(ka*K-ja*Z)+(ja*Y-la*K)*(ja*Y-la*K)+(la*Z-ka*Y)*(la*Z-ka*Y)));r=(ka*K-ja*Z)*s;g[va+288>>2]=r;q=(ja*Y-la*K)*s;g[va+288+4>>2]=q;s=(la*Z-ka*Y)*s;g[va+288+8>>2]=s;if(na*r+pa*q+oa*s<0.0){g[va+288>>2]=-r;g[va+288+4>>2]=-q;g[va+288+8>>2]=-s;r=-r;q=-q;s=-s}c[2615]=(c[2615]|0)+1;if(!(iD(I,G,na,pa,oa,r,q,s,W,ma,v)|0)){r=ga;s=ha;q=ia;_=A;ca=z;p=fa;ea=n;Y=da;K=aa;break}c[2616]=(c[2616]|0)+1;XD(W,I,va+288|0,va+720|0,va+480|0,va+456|0,va+440|0);XD(ma,G,va+288|0,va+476|0,va+472|0,va+424|0,va+408|0);u=+g[va+480>>2];p=+g[va+476>>2];do if(!(u<p)){o=+g[va+472>>2];y=+g[va+720>>2];if(o<y){u=B;V=0;p=$;o=ba;y=fa;break}if(u-p<o-y){u=u-p;V=1;A=+g[va+440>>2];p=+g[va+440+4>>2];o=+g[va+440+8>>2];z=+g[va+424>>2];y=+g[va+424+4>>2];n=+g[va+424+8>>2];break}else{u=o-y;V=1;A=+g[va+456>>2];p=+g[va+456+4>>2];o=+g[va+456+8>>2];z=+g[va+408>>2];y=+g[va+408+4>>2];n=+g[va+408+8>>2];break}}else{u=B;V=0;p=$;o=ba;y=fa}while(0);if(!V){t=0;r=ga;s=ha;q=ia;break c}if(!(u<v)){B=u;r=ga;s=ha;q=ia;_=A;$=p;ba=o;ca=z;p=y;ea=n;Y=da;K=aa;break}B=u;v=u;k=j;X=f;m=0;_=A;$=p;H=p;ba=o;D=o;ca=z;p=y;U=y;ea=n;T=n;J=A;S=z;L=la;M=ka;P=ja;x=Z}while(0);f=f+1|0;F=c[ma+48>>2]|0;if((f|0)>=(F|0))break;else{ga=r;ha=s;ia=q;A=_;z=ca;fa=p;n=ea;da=Y;aa=K}}l=c[W+48>>2]|0;u=B;A=_;o=$;y=ba;z=ca;n=ea;B=Y}else B=da;j=j+1|0;if((j|0)>=(l|0)){F=X;v=B;break}else da=B}}else{k=-1;F=-1;H=0.0;D=0.0;U=0.0;T=0.0;J=0.0;S=0.0;L=0.0;M=0.0;P=0.0;v=0.0;x=0.0;K=0.0}do if((F|k|0)>-1){o=S-J;u=U-H;p=T-D;n=P*K+(M*x+L*v);y=P*p+(M*u+L*o);A=K*p+(x*u+v*o);do if(1.0-n*n==0.0)z=0.0;else{if((y-n*A)/(1.0-n*n)<-1000000015047466219876688.0e6){z=-1000000015047466219876688.0e6;break}if(!((y-n*A)/(1.0-n*n)>1000000015047466219876688.0e6)){z=(y-n*A)/(1.0-n*n);break}z=1000000015047466219876688.0e6}while(0);B=n*z-A;do if(B<-1000000015047466219876688.0e6){if(y-n*1000000015047466219876688.0e6<-1000000015047466219876688.0e6){z=-1000000015047466219876688.0e6;B=-1000000015047466219876688.0e6;break}if(!(y-n*1000000015047466219876688.0e6>1000000015047466219876688.0e6)){z=y-n*1000000015047466219876688.0e6;B=-1000000015047466219876688.0e6;break}z=1000000015047466219876688.0e6;B=-1000000015047466219876688.0e6}else{if(!(B>1000000015047466219876688.0e6))break;if(n*1000000015047466219876688.0e6+y<-1000000015047466219876688.0e6){z=-1000000015047466219876688.0e6;B=1000000015047466219876688.0e6;break}if(!(n*1000000015047466219876688.0e6+y>1000000015047466219876688.0e6)){z=n*1000000015047466219876688.0e6+y;B=1000000015047466219876688.0e6;break}z=1000000015047466219876688.0e6;B=1000000015047466219876688.0e6}while(0);H=v*B;J=x*B;D=K*B;x=H+(o-L*z);v=J+(u-M*z);u=D+(p-P*z);g[va+272>>2]=x;g[va+272+4>>2]=v;g[va+272+8>>2]=u;g[va+272+12>>2]=0.0;if(!(x*x+v*v+u*u>1.1920928955078125e-07))break;p=+O(+(x*x+v*v+u*u));g[va+272>>2]=x*(1.0/p);g[va+272+4>>2]=1.0/p*v;g[va+272+8>>2]=1.0/p*u;if(x*(1.0/p)*na+1.0/p*v*pa+1.0/p*u*oa<0.0){g[va+272>>2]=-(x*(1.0/p));g[va+272+4>>2]=-(1.0/p*v);g[va+272+8>>2]=-(1.0/p*u)}g[va+256>>2]=S+H;g[va+256+4>>2]=U+J;g[va+256+8>>2]=T+D;g[va+256+12>>2]=0.0;ic[c[(c[h>>2]|0)+16>>2]&15](h,va+272|0,va+256|0,-p)}while(0);if(na*r+pa*q+oa*s<0.0){t=1;r=-r;s=-s;m=0;q=-q}else t=1}while(0);if(t){n=-1000000015047466219876688.0e6;ta=104}}if((ta|0)==104){X=c[ra+52>>2]|0;W=c[sa+52>>2]|0;f=c[d+12>>2]|0;V=c[e+12>>2]|0;U=n-qa;D=1.0/+O(+(r*r+q*q+s*s));J=r*D;H=q*D;D=s*D;g[va+720>>2]=J;g[va+720+4>>2]=H;g[va+720+8>>2]=D;c[va+720+12>>2]=m;m=c[W+28>>2]|0;k=c[W+36>>2]|0;if((m|0)>0){x=+g[V>>2];v=+g[V+4>>2];u=+g[V+8>>2];s=+g[V+16>>2];r=+g[V+20>>2];q=+g[V+24>>2];p=+g[V+32>>2];o=+g[V+36>>2];y=+g[V+40>>2];t=-1;B=-3402823466385288598117041.0e14;l=0;while(1){n=+g[k+(l*36|0)+20>>2];z=+g[k+(l*36|0)+24>>2];A=+g[k+(l*36|0)+28>>2];w=(n*x+z*v+A*u)*J+(n*s+z*r+A*q)*H+(n*p+z*o+A*y)*D>B;t=w?l:t;l=l+1|0;if((l|0)==(m|0)){F=t;break}else B=w?(n*x+z*v+A*u)*J+(n*s+z*r+A*q)*H+(n*p+z*o+A*y)*D:B}}else F=-1;a[va+480+16>>0]=1;I=va+480+12|0;c[I>>2]=0;G=va+480+4|0;c[G>>2]=0;c[va+480+8>>2]=0;E=c[k+(F*36|0)+4>>2]|0;d:do if((E|0)>0){C=k+(F*36|0)+12|0;m=0;k=0;l=0;while(1){d=c[(c[C>>2]|0)+(l<<2)>>2]|0;e=c[W+16>>2]|0;H=+g[e+(d<<4)>>2];J=+g[e+(d<<4)+4>>2];v=+g[e+(d<<4)+8>>2];x=H*+g[V>>2]+J*+g[V+4>>2]+v*+g[V+8>>2]+ +g[V+48>>2];u=H*+g[V+16>>2]+J*+g[V+20>>2]+v*+g[V+24>>2]+ +g[V+52>>2];v=H*+g[V+32>>2]+J*+g[V+36>>2]+v*+g[V+40>>2]+ +g[V+56>>2];if((m|0)==(k|0)){w=(k|0)!=0?k<<1:1;if((k|0)<(w|0)){if(!w){m=k;k=0}else{c[2703]=(c[2703]|0)+1;m=XE((w<<4|3)+16|0)|0;if(!m)k=0;else{c[(m+4+15&-16)+-4>>2]=m;k=m+4+15&-16}m=c[G>>2]|0}t=c[I>>2]|0;if((m|0)<=0){if(t)ta=118}else{j=0;do{d=k+(j<<4)|0;e=t+(j<<4)|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];j=j+1|0}while((j|0)!=(m|0));ta=118}if((ta|0)==118){ta=0;if(a[va+480+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[t+-4>>2]|0);m=c[G>>2]|0}c[I>>2]=0}a[va+480+16>>0]=1;c[I>>2]=k;c[va+480+8>>2]=w}else m=k}d=c[I>>2]|0;g[d+(m<<4)>>2]=x;g[d+(m<<4)+4>>2]=u;g[d+(m<<4)+8>>2]=v;g[d+(m<<4)+12>>2]=0.0;m=(c[G>>2]|0)+1|0;c[G>>2]=m;l=l+1|0;if((l|0)>=(E|0))break d;k=c[va+480+8>>2]|0}}while(0);if((F|0)>-1)jD(va+720|0,X,f,va+480|0,U,qa,h);j=c[I>>2]|0;if(j){if(a[va+480+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0)}c[I>>2]=0}}if((a[b+16>>0]|0)!=0?(ua=c[h+4>>2]|0,(c[ua+748>>2]|0)!=0):0){k=c[ua+740>>2]|0;l=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((k|0)==(l|0)){Ns(ua,k+4|0,j+4|0);break}else{Ns(ua,j+4|0,l+4|0);break}}}else{if((c[sa+4>>2]|0)!=1)break a;I=va+352+16|0;a[I>>0]=1;G=va+352+12|0;c[G>>2]=0;w=va+352+4|0;c[w>>2]=0;F=va+352+8|0;c[F>>2]=0;m=c[e+12>>2]|0;H=+g[sa+56>>2];J=+g[sa+56+4>>2];q=+g[sa+56+8>>2];r=H*+g[m>>2]+J*+g[m+4>>2]+q*+g[m+8>>2]+ +g[m+48>>2];p=H*+g[m+16>>2]+J*+g[m+20>>2]+q*+g[m+24>>2]+ +g[m+52>>2];q=H*+g[m+32>>2]+J*+g[m+36>>2]+q*+g[m+40>>2]+ +g[m+56>>2];c[2703]=(c[2703]|0)+1;m=XE(35)|0;if(!m)k=0;else{c[(m+4+15&-16)+-4>>2]=m;k=m+4+15&-16}m=c[w>>2]|0;if((m|0)>0){l=0;do{ua=k+(l<<4)|0;ta=(c[G>>2]|0)+(l<<4)|0;c[ua>>2]=c[ta>>2];c[ua+4>>2]=c[ta+4>>2];c[ua+8>>2]=c[ta+8>>2];c[ua+12>>2]=c[ta+12>>2];l=l+1|0}while((l|0)!=(m|0))}m=c[G>>2]|0;if(m){if(a[I>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[m+-4>>2]|0)}c[G>>2]=0}a[I>>0]=1;c[G>>2]=k;c[F>>2]=1;m=c[w>>2]|0;g[k+(m<<4)>>2]=r;g[k+(m<<4)+4>>2]=p;g[k+(m<<4)+8>>2]=q;g[k+(m<<4)+12>>2]=0.0;m=(c[w>>2]|0)+1|0;c[w>>2]=m;ua=c[e+12>>2]|0;H=+g[sa+56+16>>2];J=+g[sa+56+20>>2];r=+g[sa+56+24>>2];s=H*+g[ua>>2]+J*+g[ua+4>>2]+r*+g[ua+8>>2]+ +g[ua+48>>2];q=H*+g[ua+16>>2]+J*+g[ua+20>>2]+r*+g[ua+24>>2]+ +g[ua+52>>2];r=H*+g[ua+32>>2]+J*+g[ua+36>>2]+r*+g[ua+40>>2]+ +g[ua+56>>2];if((m|0)==(c[F>>2]|0)?(C=(m|0)!=0?m<<1:1,(m|0)<(C|0)):0){if(!C)l=0;else{c[2703]=(c[2703]|0)+1;m=XE((C<<4|3)+16|0)|0;if(!m)l=0;else{c[(m+4+15&-16)+-4>>2]=m;l=m+4+15&-16}m=c[w>>2]|0}if((m|0)>0){k=0;do{ua=l+(k<<4)|0;ta=(c[G>>2]|0)+(k<<4)|0;c[ua>>2]=c[ta>>2];c[ua+4>>2]=c[ta+4>>2];c[ua+8>>2]=c[ta+8>>2];c[ua+12>>2]=c[ta+12>>2];k=k+1|0}while((k|0)!=(m|0))}m=c[G>>2]|0;if(m){if(a[I>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[m+-4>>2]|0)}c[G>>2]=0}a[I>>0]=1;c[G>>2]=l;c[F>>2]=C;m=c[w>>2]|0}ua=c[G>>2]|0;g[ua+(m<<4)>>2]=s;g[ua+(m<<4)+4>>2]=q;g[ua+(m<<4)+8>>2]=r;g[ua+(m<<4)+12>>2]=0.0;m=(c[w>>2]|0)+1|0;c[w>>2]=m;ua=c[e+12>>2]|0;H=+g[sa+56+32>>2];J=+g[sa+56+36>>2];q=+g[sa+56+40>>2];r=H*+g[ua>>2]+J*+g[ua+4>>2]+q*+g[ua+8>>2]+ +g[ua+48>>2];p=H*+g[ua+16>>2]+J*+g[ua+20>>2]+q*+g[ua+24>>2]+ +g[ua+52>>2];q=H*+g[ua+32>>2]+J*+g[ua+36>>2]+q*+g[ua+40>>2]+ +g[ua+56>>2];if((m|0)==(c[F>>2]|0)?(X=(m|0)!=0?m<<1:1,(m|0)<(X|0)):0){if(!X)l=0;else{c[2703]=(c[2703]|0)+1;m=XE((X<<4|3)+16|0)|0;if(!m)l=0;else{c[(m+4+15&-16)+-4>>2]=m;l=m+4+15&-16}m=c[w>>2]|0}if((m|0)>0){k=0;do{ua=l+(k<<4)|0;e=(c[G>>2]|0)+(k<<4)|0;c[ua>>2]=c[e>>2];c[ua+4>>2]=c[e+4>>2];c[ua+8>>2]=c[e+8>>2];c[ua+12>>2]=c[e+12>>2];k=k+1|0}while((k|0)!=(m|0))}m=c[G>>2]|0;if(m){if(a[I>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[m+-4>>2]|0)}c[G>>2]=0}a[I>>0]=1;c[G>>2]=l;c[F>>2]=X;m=c[w>>2]|0}ua=c[G>>2]|0;g[ua+(m<<4)>>2]=r;g[ua+(m<<4)+4>>2]=p;g[ua+(m<<4)+8>>2]=q;g[ua+(m<<4)+12>>2]=0.0;c[w>>2]=(c[w>>2]|0)+1;q=+g[(c[b+20>>2]|0)+752>>2];nD(va+40|0,va+120|0,va+372|0,c[f+20>>2]|0,0);n=+g[va+40+4>>2];o=+g[va+40+8>>2];p=+g[va+40+12>>2];if(n*n+o*o+p*p>1.1920928955078125e-07){H=1.0/(n*n+o*o+p*p);g[va+336>>2]=n*H;g[va+336+4>>2]=o*H;g[va+336+8>>2]=p*H;g[va+336+12>>2]=0.0;H=+g[va+40+56>>2];J=+Tb[c[(c[ra>>2]|0)+48>>2]&15](ra);J=H-J-+Tb[c[(c[sa>>2]|0)+48>>2]&15](sa);jD(va+336|0,c[ra+52>>2]|0,c[d+12>>2]|0,va+352|0,J-q,q,h)}do if(a[b+16>>0]|0){l=c[h+4>>2]|0;if(!(c[l+748>>2]|0))break;k=c[l+740>>2]|0;j=c[(c[h+8>>2]|0)+8>>2]|0;m=c[(c[h+12>>2]|0)+8>>2]|0;if((k|0)==(j|0)){Ns(l,k+4|0,m+4|0);break}else{Ns(l,m+4|0,j+4|0);break}}while(0);l=c[G>>2]|0;if(l){if(a[I>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[l+-4>>2]|0)}c[G>>2]=0}a[I>>0]=1;c[G>>2]=0;c[w>>2]=0;c[F>>2]=0}while(0);i=va;return}while(0)}nD(va+40|0,va+120|0,h,c[f+20>>2]|0,0);if(((c[b+28>>2]|0)!=0?(c[(c[h+4>>2]|0)+748>>2]|0)<(c[b+32>>2]|0):0)?(K=+g[va+40+4>>2],n=+g[va+40+8>>2],y=+g[va+40+12>>2],K*K+n*n+y*y>1.1920928955078125e-07):0){D=1.0/(K*K+n*n+y*y);if(+N(+(y*D))>.7071067690849304){s=1.0/+O(+(y*D*(y*D)+n*D*(n*D)));v=0.0;x=n*D*s;s=-(y*D*s)}else{s=1.0/+O(+(K*D*(K*D)+n*D*(n*D)));v=-(n*D*s);x=0.0;s=K*D*s}H=+Tb[c[(c[ra>>2]|0)+16>>2]&15](ra);J=+Tb[c[(c[sa>>2]|0)+16>>2]&15](sa);u=.019999999552965164/(H<J?H:J);if(H<J){c[va+720>>2]=c[va+120>>2];c[va+720+4>>2]=c[va+120+4>>2];c[va+720+8>>2]=c[va+120+8>>2];c[va+720+12>>2]=c[va+120+12>>2];c[va+720+16>>2]=c[F>>2];c[va+720+16+4>>2]=c[F+4>>2];c[va+720+16+8>>2]=c[F+8>>2];c[va+720+16+12>>2]=c[F+12>>2];c[va+720+32>>2]=c[G>>2];c[va+720+32+4>>2]=c[G+4>>2];c[va+720+32+8>>2]=c[G+8>>2];c[va+720+32+12>>2]=c[G+12>>2];c[va+720+48>>2]=c[l>>2];c[va+720+48+4>>2]=c[l+4>>2];c[va+720+48+8>>2]=c[l+8>>2];c[va+720+48+12>>2]=c[l+12>>2]}else{c[va+720>>2]=c[E>>2];c[va+720+4>>2]=c[E+4>>2];c[va+720+8>>2]=c[E+8>>2];c[va+720+12>>2]=c[E+12>>2];c[va+720+16>>2]=c[k>>2];c[va+720+16+4>>2]=c[k+4>>2];c[va+720+16+8>>2]=c[k+8>>2];c[va+720+16+12>>2]=c[k+12>>2];c[va+720+32>>2]=c[I>>2];c[va+720+32+4>>2]=c[I+4>>2];c[va+720+32+8>>2]=c[I+8>>2];c[va+720+32+12>>2]=c[I+12>>2];c[va+720+48>>2]=c[w>>2];c[va+720+48+4>>2]=c[w+4>>2];c[va+720+48+8>>2]=c[w+8>>2];c[va+720+48+12>>2]=c[w+12>>2]}t=c[b+28>>2]|0;if((t|0)>0?(B=x*x+(s*s+v*v),z=u>.39269909262657166?.19634954631328583:u*.5,B>1.1920928955078125e-07):0){p=+R(+z)/+O(+B);A=v*p;B=s*p;p=x*p;q=+Q(+z);x=+O(+(y*D*(y*D)+(K*D*(K*D)+n*D*(n*D))));m=0;do{v=+(m|0)*(6.2831854820251465/+(t|0))*.5;u=+R(+v)/x;s=K*D*u;r=n*D*u;u=y*D*u;v=+Q(+v);if(H<J){ka=u*(A*-u+(q*-r+B*v)-p*-s)+(s*(q*v-A*-s-B*-r-p*-u)+v*(p*-r+(A*v+q*-s)-B*-u))-r*(B*-s+(p*v+q*-u)-A*-r);L=s*(B*-s+(p*v+q*-u)-A*-r)+(v*(A*-u+(q*-r+B*v)-p*-s)+r*(q*v-A*-s-B*-r-p*-u))-u*(p*-r+(A*v+q*-s)-B*-u);qa=r*(p*-r+(A*v+q*-s)-B*-u)+(u*(q*v-A*-s-B*-r-p*-u)+v*(B*-s+(p*v+q*-u)-A*-r))-s*(A*-u+(q*-r+B*v)-p*-s);la=v*(q*v-A*-s-B*-r-p*-u)-s*(p*-r+(A*v+q*-s)-B*-u)-r*(A*-u+(q*-r+B*v)-p*-s)-u*(B*-s+(p*v+q*-u)-A*-r);o=ka*(2.0/(la*la+(qa*qa+(ka*ka+L*L))));ja=L*(2.0/(la*la+(qa*qa+(ka*ka+L*L))));P=qa*(2.0/(la*la+(qa*qa+(ka*ka+L*L))));ua=c[d+12>>2]|0;u=+g[ua>>2];oa=+g[ua+16>>2];s=+g[ua+32>>2];T=+g[ua+4>>2];na=+g[ua+20>>2];r=+g[ua+36>>2];S=+g[ua+8>>2];M=+g[ua+24>>2];z=+g[ua+40>>2];g[va+120>>2]=(ka*P+la*ja)*s+(oa*(ka*ja-la*P)+u*(1.0-(L*ja+qa*P)));g[va+120+4>>2]=(1.0-(L*ja+qa*P))*T+(ka*ja-la*P)*na+(ka*P+la*ja)*r;g[va+120+8>>2]=(1.0-(L*ja+qa*P))*S+(ka*ja-la*P)*M+(ka*P+la*ja)*z;g[va+120+12>>2]=0.0;g[va+120+16>>2]=(L*P-la*o)*s+(u*(ka*ja+la*P)+oa*(1.0-(ka*o+qa*P)));g[va+120+20>>2]=(ka*ja+la*P)*T+(1.0-(ka*o+qa*P))*na+(L*P-la*o)*r;g[va+120+24>>2]=(ka*ja+la*P)*S+(1.0-(ka*o+qa*P))*M+(L*P-la*o)*z;g[va+120+28>>2]=0.0;g[va+120+32>>2]=u*(ka*P-la*ja)+oa*(L*P+la*o)+s*(1.0-(ka*o+L*ja));g[va+120+36>>2]=(ka*P-la*ja)*T+(L*P+la*o)*na+(1.0-(ka*o+L*ja))*r;g[va+120+40>>2]=(ka*P-la*ja)*S+(L*P+la*o)*M+(1.0-(ka*o+L*ja))*z;g[va+120+44>>2]=0.0;ua=c[e+12>>2]|0;c[E>>2]=c[ua>>2];c[E+4>>2]=c[ua+4>>2];c[E+8>>2]=c[ua+8>>2];c[E+12>>2]=c[ua+12>>2];c[k>>2]=c[ua+16>>2];c[k+4>>2]=c[ua+16+4>>2];c[k+8>>2]=c[ua+16+8>>2];c[k+12>>2]=c[ua+16+12>>2];c[I>>2]=c[ua+32>>2];c[I+4>>2]=c[ua+32+4>>2];c[I+8>>2]=c[ua+32+8>>2];c[I+12>>2]=c[ua+32+12>>2];c[w>>2]=c[ua+48>>2];c[w+4>>2]=c[ua+48+4>>2];c[w+8>>2]=c[ua+48+8>>2];c[w+12>>2]=c[ua+48+12>>2]}else{ua=c[d+12>>2]|0;c[va+120>>2]=c[ua>>2];c[va+120+4>>2]=c[ua+4>>2];c[va+120+8>>2]=c[ua+8>>2];c[va+120+12>>2]=c[ua+12>>2];c[F>>2]=c[ua+16>>2];c[F+4>>2]=c[ua+16+4>>2];c[F+8>>2]=c[ua+16+8>>2];c[F+12>>2]=c[ua+16+12>>2];c[G>>2]=c[ua+32>>2];c[G+4>>2]=c[ua+32+4>>2];c[G+8>>2]=c[ua+32+8>>2];c[G+12>>2]=c[ua+32+12>>2];c[l>>2]=c[ua+48>>2];c[l+4>>2]=c[ua+48+4>>2];c[l+8>>2]=c[ua+48+8>>2];c[l+12>>2]=c[ua+48+12>>2];ka=u*(A*-u+(q*-r+B*v)-p*-s)+(s*(q*v-A*-s-B*-r-p*-u)+v*(p*-r+(A*v+q*-s)-B*-u))-r*(B*-s+(p*v+q*-u)-A*-r);L=s*(B*-s+(p*v+q*-u)-A*-r)+(v*(A*-u+(q*-r+B*v)-p*-s)+r*(q*v-A*-s-B*-r-p*-u))-u*(p*-r+(A*v+q*-s)-B*-u);qa=r*(p*-r+(A*v+q*-s)-B*-u)+(u*(q*v-A*-s-B*-r-p*-u)+v*(B*-s+(p*v+q*-u)-A*-r))-s*(A*-u+(q*-r+B*v)-p*-s);la=v*(q*v-A*-s-B*-r-p*-u)-s*(p*-r+(A*v+q*-s)-B*-u)-r*(A*-u+(q*-r+B*v)-p*-s)-u*(B*-s+(p*v+q*-u)-A*-r);o=ka*(2.0/(la*la+(qa*qa+(ka*ka+L*L))));ja=L*(2.0/(la*la+(qa*qa+(ka*ka+L*L))));P=qa*(2.0/(la*la+(qa*qa+(ka*ka+L*L))));ua=c[e+12>>2]|0;u=+g[ua>>2];oa=+g[ua+16>>2];s=+g[ua+32>>2];T=+g[ua+4>>2];na=+g[ua+20>>2];r=+g[ua+36>>2];S=+g[ua+8>>2];M=+g[ua+24>>2];z=+g[ua+40>>2];g[va+120+64>>2]=(ka*P+la*ja)*s+(oa*(ka*ja-la*P)+u*(1.0-(L*ja+qa*P)));g[va+120+68>>2]=(1.0-(L*ja+qa*P))*T+(ka*ja-la*P)*na+(ka*P+la*ja)*r;g[va+120+72>>2]=(1.0-(L*ja+qa*P))*S+(ka*ja-la*P)*M+(ka*P+la*ja)*z;g[va+120+76>>2]=0.0;g[va+120+80>>2]=(L*P-la*o)*s+(u*(ka*ja+la*P)+oa*(1.0-(ka*o+qa*P)));g[va+120+84>>2]=(ka*ja+la*P)*T+(1.0-(ka*o+qa*P))*na+(L*P-la*o)*r;g[va+120+88>>2]=(ka*ja+la*P)*S+(1.0-(ka*o+qa*P))*M+(L*P-la*o)*z;g[va+120+92>>2]=0.0;g[va+120+96>>2]=u*(ka*P-la*ja)+oa*(L*P+la*o)+s*(1.0-(ka*o+L*ja));g[va+120+100>>2]=(ka*P-la*ja)*T+(L*P+la*o)*na+(1.0-(ka*o+L*ja))*r;g[va+120+104>>2]=(ka*P-la*ja)*S+(L*P+la*o)*M+(1.0-(ka*o+L*ja))*z;g[va+120+108>>2]=0.0}t=c[f+20>>2]|0;c[va+480>>2]=6368;c[va+480+32>>2]=h;c[va+480+36>>2]=c[va+120>>2];c[va+480+36+4>>2]=c[va+120+4>>2];c[va+480+36+8>>2]=c[va+120+8>>2];c[va+480+36+12>>2]=c[va+120+12>>2];c[va+480+52>>2]=c[F>>2];c[va+480+52+4>>2]=c[F+4>>2];c[va+480+52+8>>2]=c[F+8>>2];c[va+480+52+12>>2]=c[F+12>>2];c[va+480+68>>2]=c[G>>2];c[va+480+68+4>>2]=c[G+4>>2];c[va+480+68+8>>2]=c[G+8>>2];c[va+480+68+12>>2]=c[G+12>>2];c[va+480+84>>2]=c[l>>2];c[va+480+84+4>>2]=c[l+4>>2];c[va+480+84+8>>2]=c[l+8>>2];c[va+480+84+12>>2]=c[l+12>>2];c[va+480+100>>2]=c[E>>2];c[va+480+100+4>>2]=c[E+4>>2];c[va+480+100+8>>2]=c[E+8>>2];c[va+480+100+12>>2]=c[E+12>>2];c[va+480+116>>2]=c[k>>2];c[va+480+116+4>>2]=c[k+4>>2];c[va+480+116+8>>2]=c[k+8>>2];c[va+480+116+12>>2]=c[k+12>>2];c[va+480+132>>2]=c[I>>2];c[va+480+132+4>>2]=c[I+4>>2];c[va+480+132+8>>2]=c[I+8>>2];c[va+480+132+12>>2]=c[I+12>>2];c[va+480+148>>2]=c[w>>2];c[va+480+148+4>>2]=c[w+4>>2];c[va+480+148+8>>2]=c[w+8>>2];c[va+480+148+12>>2]=c[w+12>>2];c[va+480+164>>2]=c[va+720>>2];c[va+480+164+4>>2]=c[va+720+4>>2];c[va+480+164+8>>2]=c[va+720+8>>2];c[va+480+164+12>>2]=c[va+720+12>>2];c[va+480+180>>2]=c[va+720+16>>2];c[va+480+180+4>>2]=c[va+720+16+4>>2];c[va+480+180+8>>2]=c[va+720+16+8>>2];c[va+480+180+12>>2]=c[va+720+16+12>>2];c[va+480+196>>2]=c[va+720+32>>2];c[va+480+196+4>>2]=c[va+720+32+4>>2];c[va+480+196+8>>2]=c[va+720+32+8>>2];c[va+480+196+12>>2]=c[va+720+32+12>>2];c[va+480+212>>2]=c[va+720+48>>2];c[va+480+212+4>>2]=c[va+720+48+4>>2];c[va+480+212+8>>2]=c[va+720+48+8>>2];c[va+480+212+12>>2]=c[va+720+48+12>>2];a[va+480+228>>0]=H<J&1;c[va+480+232>>2]=t;nD(va+40|0,va+120|0,va+480|0,t,0);t=c[b+28>>2]|0;m=m+1|0}while((m|0)<(t|0))}}if(!(a[b+16>>0]|0)){i=va;return}l=c[h+4>>2]|0;if(!(c[l+748>>2]|0)){i=va;return}k=c[l+740>>2]|0;m=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((k|0)==(m|0)){Ns(l,k+4|0,j+4|0);i=va;return}else{Ns(l,j+4|0,m+4|0);i=va;return}}function fw(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;b=i;i=i+624|0;p=+g[d+116>>2]-+g[d+52>>2];o=+g[d+120>>2]-+g[d+56>>2];n=+g[d+124>>2]-+g[d+60>>2];k=+g[e+116>>2]-+g[e+52>>2];l=+g[e+120>>2]-+g[e+56>>2];j=+g[e+124>>2]-+g[e+60>>2];m=+g[d+252>>2];if(p*p+o*o+n*n<m*m?(p=+g[e+252>>2],k*k+l*l+j*j<p*p):0){j=1.0;i=b;return +j}f=c[d+192>>2]|0;h=c[e+248>>2]|0;c[b+568+8>>2]=0;c[b+568+12>>2]=1065353216;c[b+568+16>>2]=1065353216;c[b+568+20>>2]=1065353216;g[b+568+24>>2]=0.0;c[b+568>>2]=6904;c[b+568+4>>2]=8;c[b+568+28>>2]=h;c[b+568+44>>2]=h;c[b+392>>2]=5800;g[b+392+164>>2]=999999984306749440.0;c[b+392+168>>2]=0;g[b+392+172>>2]=0.0;g[b+32+308>>2]=9.999999747378752e-05;a[b+32+332>>0]=0;c[b+16>>2]=10420;c[b+16+4>>2]=b+32;c[b+16+8>>2]=f;c[b+16+12>>2]=b+568;if(bD(b+16|0,d+4|0,d+68|0,e+4|0,e+68|0,b+392|0)|0){j=+g[b+392+164>>2];if(+g[d+244>>2]>j)g[d+244>>2]=j;if(+g[e+244>>2]>j)g[e+244>>2]=j;if(j<1.0)k=j;else k=1.0}else k=1.0;f=c[e+192>>2]|0;h=c[d+248>>2]|0;c[b+568+8>>2]=0;c[b+568+12>>2]=1065353216;c[b+568+16>>2]=1065353216;c[b+568+20>>2]=1065353216;g[b+568+24>>2]=0.0;c[b+568>>2]=6904;c[b+568+4>>2]=8;c[b+568+28>>2]=h;c[b+568+44>>2]=h;c[b+392>>2]=5800;g[b+392+164>>2]=999999984306749440.0;c[b+392+168>>2]=0;g[b+392+172>>2]=0.0;g[b+32+308>>2]=9.999999747378752e-05;a[b+32+332>>0]=0;c[b>>2]=10420;c[b+4>>2]=b+32;c[b+8>>2]=b+568;c[b+12>>2]=f;if(bD(b,d+4|0,d+68|0,e+4|0,e+68|0,b+392|0)|0){j=+g[b+392+164>>2];if(+g[d+244>>2]>j)g[d+244>>2]=j;if(+g[e+244>>2]>j)g[e+244>>2]=j;if(!(k>j))j=k}else j=k;i=b;return +j}function gw(a){a=a|0;YE(a);return}function hw(a,b,c){a=a|0;b=b|0;c=c|0;return}function iw(a,b,c){a=a|0;b=b|0;c=c|0;return}function jw(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return}function kw(a){a=a|0;YE(a);return}function lw(a,b,c){a=a|0;b=b|0;c=c|0;return}function mw(a,b,c){a=a|0;b=b|0;c=c|0;return}function nw(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0;h=i;i=i+16|0;g[b+32>>2]=f;c[b+8>>2]=c[d>>2];c[b+8+4>>2]=c[d+4>>2];c[b+8+8>>2]=c[d+8>>2];c[b+8+12>>2]=c[d+12>>2];j=+g[b+28>>2];l=+g[e+4>>2]-j*+g[d+4>>2];k=+g[e+8>>2]-j*+g[d+8>>2];g[h>>2]=+g[e>>2]-+g[d>>2]*j;g[h+4>>2]=l;g[h+8>>2]=k;g[h+12>>2]=0.0;f=+g[b+24>>2]+j+f;g[b+32>>2]=f;if(!(f<0.0)){e=b+4|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;ic[b&15](e,d,h,f);i=h;return}a[b+36>>0]=1;e=b+4|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;ic[b&15](e,d,h,f);i=h;return}function ow(a){a=a|0;YE(a);return}function pw(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;o=i;i=i+16|0;j=+g[d>>2];k=+g[d+4>>2];l=+g[d+8>>2];m=+g[e>>2];n=+g[e+4>>2];h=+g[e+8>>2];if(!(a[b+228>>0]|0)){z=+g[b+100>>2];w=+g[b+116>>2];C=+g[b+132>>2];y=+g[b+104>>2];u=+g[b+120>>2];B=+g[b+136>>2];x=+g[b+108>>2];s=+g[b+124>>2];A=+g[b+140>>2];F=-+g[b+148>>2];E=-+g[b+152>>2];D=-+g[b+156>>2];J=+g[b+164>>2];I=+g[b+168>>2];r=+g[b+172>>2];H=+g[b+180>>2];G=+g[b+184>>2];q=+g[b+188>>2];v=+g[b+196>>2];t=+g[b+200>>2];p=+g[b+204>>2];r=h*(C*J+B*I+A*r)+(m*(z*J+y*I+x*r)+n*(w*J+u*I+s*r))+(J*(z*F+w*E+C*D)+(y*F+u*E+B*D)*I+(x*F+s*E+A*D)*r+ +g[b+212>>2]);q=h*(C*H+B*G+A*q)+(m*(z*H+y*G+x*q)+n*(w*H+u*G+s*q))+((z*F+w*E+C*D)*H+(y*F+u*E+B*D)*G+(x*F+s*E+A*D)*q+ +g[b+216>>2]);p=(z*F+w*E+C*D)*v+(y*F+u*E+B*D)*t+(x*F+s*E+A*D)*p+ +g[b+220>>2]+(h*(C*v+B*t+A*p)+(m*(z*v+y*t+x*p)+n*(w*v+u*t+s*p)));g[o>>2]=r;g[o+4>>2]=q;g[o+8>>2]=p;h=(j*f+m-r)*+g[d>>2]+(k*f+n-q)*+g[d+4>>2]+(l*f+h-p)*+g[d+8>>2];e=o+12|0;g[e>>2]=0.0;e=b+32|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;ic[b&15](e,d,o,h);i=o;return}else{B=+g[b+36>>2];u=+g[b+52>>2];r=+g[b+68>>2];s=+g[b+40>>2];w=+g[b+56>>2];D=+g[b+72>>2];t=+g[b+44>>2];y=+g[b+60>>2];p=+g[b+76>>2];F=-+g[b+84>>2];E=-+g[b+88>>2];q=-+g[b+92>>2];J=+g[b+164>>2];I=+g[b+168>>2];z=+g[b+172>>2];H=+g[b+180>>2];G=+g[b+184>>2];A=+g[b+188>>2];v=+g[b+196>>2];x=+g[b+200>>2];C=+g[b+204>>2];z=(l*f+h)*(r*J+D*I+p*z)+((j*f+m)*(B*J+s*I+t*z)+(k*f+n)*(u*J+w*I+y*z))+(J*(B*F+u*E+r*q)+(s*F+w*E+D*q)*I+(t*F+y*E+p*q)*z+ +g[b+212>>2]);A=(l*f+h)*(r*H+D*G+p*A)+((j*f+m)*(B*H+s*G+t*A)+(k*f+n)*(u*H+w*G+y*A))+((B*F+u*E+r*q)*H+(s*F+w*E+D*q)*G+(t*F+y*E+p*q)*A+ +g[b+216>>2]);C=(B*F+u*E+r*q)*v+(s*F+w*E+D*q)*x+(t*F+y*E+p*q)*C+ +g[b+220>>2]+((l*f+h)*(r*v+D*x+p*C)+((j*f+m)*(B*v+s*x+t*C)+(k*f+n)*(u*v+w*x+y*C)));g[o>>2]=z+j*(j*(z-m)+k*(A-n)+l*(C-h));g[o+4>>2]=A+k*(j*(z-m)+k*(A-n)+l*(C-h));g[o+8>>2]=C+l*(j*(z-m)+k*(A-n)+l*(C-h));C=j*(z-m)+k*(A-n)+l*(C-h);e=o+12|0;g[e>>2]=0.0;e=b+32|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;ic[b&15](e,d,o,C);i=o;return}}function qw(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;e=c[d>>2]|0;e=_b[c[(c[e>>2]|0)+56>>2]&31](e,36)|0;h=c[d+4>>2]|0;j=c[b+12>>2]|0;i=c[b+8>>2]|0;g=c[b+16>>2]|0;f=c[b+20>>2]|0;c[e+4>>2]=c[d>>2];c[e>>2]=6284;c[e+8>>2]=j;c[e+12>>2]=i;a[e+16>>0]=0;c[e+20>>2]=h;a[e+24>>0]=0;c[e+28>>2]=g;c[e+32>>2]=f;return e|0}function rw(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+20>>2]|0;if(!e)return;if(!(a[b+16>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=(f|0)!=0?f<<1:1,(f|0)<(h|0)):0){if(!h){e=f;f=0}else{c[2703]=(c[2703]|0)+1;e=XE((h<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+4+15&-16)+-4>>2]=e;f=e+4+15&-16}e=c[d+4>>2]|0}if((e|0)>0){g=0;do{c[f+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0);e=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=f;c[d+8>>2]=h;f=e;e=c[b+20>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function sw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;while(1){k=c[a+12>>2]|0;j=c[k+(((b+d|0)/2|0)<<3)>>2]|0;e=b;f=d;while(1){while(1){i=e+1|0;if((c[k+(e<<3)>>2]|0)<(j|0))e=i;else break}while(1){g=k+(f<<3)|0;h=f+-1|0;if((j|0)<(c[g>>2]|0))f=h;else break}if((e|0)<=(f|0)){e=k+(e<<3)|0;l=c[e>>2]|0;k=c[e+4>>2]|0;m=c[g+4>>2]|0;c[e>>2]=c[g>>2];c[e+4>>2]=m;e=(c[a+12>>2]|0)+(f<<3)|0;c[e>>2]=l;c[e+4>>2]=k;e=i;f=h}if((e|0)>(f|0))break;k=c[a+12>>2]|0}if((f|0)>(b|0))sw(a,b,f);if((e|0)<(d|0))b=e;else break}return}function tw(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;c[b+4>>2]=c[d>>2];c[b>>2]=6396;a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;a[b+28>>0]=g&1;c[b+32>>2]=c[d+4>>2];a[b+36>>0]=0;c[b+40>>2]=c[(c[(g?f:e)+4>>2]|0)+68>>2];uw(b,e,f);return}function uw(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;k=(a[b+28>>0]|0)!=0;l=k?e:d;k=k?d:e;h=c[l+4>>2]|0;j=c[h+16>>2]|0;g=c[b+12>>2]|0;if((g|0)<(j|0)){if((c[b+16>>2]|0)<(j|0)){if(!j){d=g;f=0}else{c[2703]=(c[2703]|0)+1;e=XE((j<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}d=c[b+12>>2]|0;f=e}if((d|0)>0){e=0;do{c[f+(e<<2)>>2]=c[(c[b+20>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(d|0))}e=c[b+20>>2]|0;if(e){if(a[b+24>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=f;c[b+16>>2]=j;d=b+20|0}else d=b+20|0;e=g;do{c[(c[d>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=(j|0))}c[b+12>>2]=j;if((j|0)<=0){i=m;return}e=0;do{if(!(c[h+64>>2]|0)){g=c[(c[h+24>>2]|0)+(e*80|0)+64>>2]|0;f=c[l+8>>2]|0;d=c[l+12>>2]|0;c[m>>2]=l;c[m+4>>2]=g;c[m+8>>2]=f;c[m+12>>2]=d;c[m+16>>2]=-1;c[m+20>>2]=e;d=c[b+4>>2]|0;d=Lb[c[(c[d>>2]|0)+8>>2]&31](d,m,k,c[b+32>>2]|0)|0;c[(c[b+20>>2]|0)+(e<<2)>>2]=d}else c[(c[b+20>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=(j|0));i=m;return}function vw(b){b=b|0;var d=0,e=0,f=0;c[b>>2]=6396;d=c[b+12>>2]|0;if((d|0)>0){f=0;do{e=c[(c[b+20>>2]|0)+(f<<2)>>2]|0;if(e){Db[c[c[e>>2]>>2]&255](e);e=c[b+4>>2]|0;Fb[c[(c[e>>2]|0)+60>>2]&127](e,c[(c[b+20>>2]|0)+(f<<2)>>2]|0)}f=f+1|0}while((f|0)!=(d|0))}d=c[b+20>>2]|0;if(!d){a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;d=b+16|0;c[d>>2]=0;return}if(a[b+24>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+20>>2]=0;a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;d=b+16|0;c[d>>2]=0;return}function ww(a){a=a|0;vw(a);YE(a);return}
function yp(a,b,e){a=a|0;b=b|0;e=e|0;Os(a,b,e)|0;c[b+256>>2]=c[a+264>>2];c[b+260>>2]=c[a+268>>2];c[b+264>>2]=c[a+272>>2];c[b+268>>2]=c[a+276>>2];c[b+272>>2]=c[a+280>>2];c[b+276>>2]=c[a+284>>2];c[b+280>>2]=c[a+288>>2];c[b+284>>2]=c[a+292>>2];c[b+288>>2]=c[a+296>>2];c[b+292>>2]=c[a+300>>2];c[b+296>>2]=c[a+304>>2];c[b+300>>2]=c[a+308>>2];c[b+304>>2]=c[a+312>>2];c[b+308>>2]=c[a+316>>2];c[b+312>>2]=c[a+320>>2];c[b+316>>2]=c[a+324>>2];c[b+320>>2]=c[a+328>>2];c[b+324>>2]=c[a+332>>2];c[b+328>>2]=c[a+336>>2];c[b+332>>2]=c[a+340>>2];c[b+448>>2]=c[a+344>>2];c[b+336>>2]=c[a+544>>2];c[b+340>>2]=c[a+548>>2];c[b+344>>2]=c[a+552>>2];c[b+348>>2]=c[a+556>>2];c[b+352>>2]=c[a+348>>2];c[b+356>>2]=c[a+352>>2];c[b+360>>2]=c[a+356>>2];c[b+364>>2]=c[a+360>>2];c[b+368>>2]=c[a+364>>2];c[b+372>>2]=c[a+368>>2];c[b+376>>2]=c[a+372>>2];c[b+380>>2]=c[a+376>>2];c[b+384>>2]=c[a+380>>2];c[b+388>>2]=c[a+384>>2];c[b+392>>2]=c[a+388>>2];c[b+396>>2]=c[a+392>>2];c[b+400>>2]=c[a+396>>2];c[b+404>>2]=c[a+400>>2];c[b+408>>2]=c[a+404>>2];c[b+412>>2]=c[a+408>>2];c[b+416>>2]=c[a+412>>2];c[b+420>>2]=c[a+416>>2];c[b+424>>2]=c[a+420>>2];c[b+428>>2]=c[a+424>>2];c[b+432>>2]=c[a+428>>2];c[b+436>>2]=c[a+432>>2];c[b+440>>2]=c[a+436>>2];c[b+444>>2]=c[a+440>>2];c[b+452>>2]=c[a+444>>2];c[b+456>>2]=c[a+448>>2];c[b+484>>2]=d[a+452>>0];c[b+460>>2]=c[a+456>>2];c[b+464>>2]=c[a+460>>2];c[b+468>>2]=c[a+464>>2];c[b+472>>2]=c[a+468>>2];c[b+476>>2]=c[a+472>>2];c[b+480>>2]=c[a+476>>2];return 12309}function zp(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[(c[b>>2]|0)+16>>2]|0;e=Hb[c[(c[a>>2]|0)+16>>2]&127](a)|0;e=Qb[d&63](b,e,1)|0;d=Qb[c[(c[a>>2]|0)+20>>2]&63](a,c[e+8>>2]|0,b)|0;Bb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1497645650,a);return}function Ap(a,b,c,d,e,f,h){a=a|0;b=+b;c=+c;d=+d;e=e|0;f=+f;h=h|0;var j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;l=i;i=i+16|0;k=c*f+ +g[a+52>>2];j=d*f+ +g[a+56>>2];g[h+48>>2]=b*f+ +g[a+48>>2];g[h+52>>2]=k;g[h+56>>2]=j;g[h+60>>2]=0.0;j=+g[e>>2];k=+g[e+4>>2];d=+g[e+8>>2];c=+O(+(j*j+k*k+d*d));c=c*f>.7853981852531433?.7853981852531433/f:c;if(c<1.0000000474974513e-03)b=f*.5-c*(f*f*f*.02083333395421505*c);else b=+R(+(c*.5*f))/c;o=j*b;k=k*b;d=d*b;q=+Q(+(c*f*.5));Oo(a,l);n=+g[l>>2];p=+g[l+12>>2];f=+g[l+8>>2];b=+g[l+4>>2];r=1.0/+O(+((q*p-o*n-k*b-d*f)*(q*p-o*n-k*b-d*f)+((d*p+q*f+o*b-k*n)*(d*p+q*f+o*b-k*n)+((q*n+o*p+k*f-d*b)*(q*n+o*p+k*f-d*b)+(d*n+(k*p+q*b)-o*f)*(d*n+(k*p+q*b)-o*f)))));j=(q*n+o*p+k*f-d*b)*r;c=r*(d*n+(k*p+q*b)-o*f);m=r*(d*p+q*f+o*b-k*n);f=r*(q*p-o*n-k*b-d*f);d=j*(2.0/(f*f+(m*m+(j*j+c*c))));b=2.0/(f*f+(m*m+(j*j+c*c)))*c;k=2.0/(f*f+(m*m+(j*j+c*c)))*m;g[h>>2]=1.0-(m*k+c*b);g[h+4>>2]=j*b-f*k;g[h+8>>2]=j*k+f*b;g[h+12>>2]=0.0;g[h+16>>2]=f*k+j*b;g[h+20>>2]=1.0-(j*d+m*k);g[h+24>>2]=c*k-f*d;g[h+28>>2]=0.0;g[h+32>>2]=j*k-f*b;g[h+36>>2]=f*d+c*k;g[h+40>>2]=1.0-(j*d+c*b);g[h+44>>2]=0.0;i=l;return}function Bp(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0;l=i;i=i+64|0;k=+g[a+20>>2];u=+g[a+40>>2];p=+g[a+24>>2];s=+g[a+36>>2];t=+g[a+32>>2];j=+g[a+16>>2];m=+g[a>>2];h=+g[a+4>>2];q=+g[a+8>>2];n=1.0/((k*u-p*s)*m+h*(p*t-u*j)+(s*j-k*t)*q);A=+g[b>>2];z=+g[b+4>>2];y=+g[b+8>>2];x=+g[b+16>>2];w=+g[b+20>>2];v=+g[b+24>>2];r=+g[b+32>>2];o=+g[b+36>>2];f=+g[b+40>>2];g[l+16>>2]=(k*u-p*s)*n*A+(p*t-u*j)*n*z+(s*j-k*t)*n*y;g[l+16+4>>2]=A*(n*(s*q-u*h))+z*(n*(u*m-t*q))+n*(t*h-s*m)*y;g[l+16+8>>2]=A*(n*(p*h-k*q))+z*(n*(j*q-p*m))+n*(k*m-j*h)*y;g[l+16+12>>2]=0.0;g[l+16+16>>2]=(k*u-p*s)*n*x+(p*t-u*j)*n*w+(s*j-k*t)*n*v;g[l+16+20>>2]=n*(s*q-u*h)*x+n*(u*m-t*q)*w+n*(t*h-s*m)*v;g[l+16+24>>2]=n*(p*h-k*q)*x+n*(j*q-p*m)*w+n*(k*m-j*h)*v;g[l+16+28>>2]=0.0;g[l+16+32>>2]=(k*u-p*s)*n*r+(p*t-u*j)*n*o+(s*j-k*t)*n*f;g[l+16+36>>2]=n*(s*q-u*h)*r+n*(u*m-t*q)*o+n*(t*h-s*m)*f;g[l+16+40>>2]=n*(p*h-k*q)*r+n*(j*q-p*m)*o+n*(k*m-j*h)*f;g[l+16+44>>2]=0.0;Oo(l+16|0,l);f=+g[l>>2];h=+g[l+4>>2];j=+g[l+8>>2];m=+g[l+12>>2];k=1.0/+O(+(f*f+h*h+j*j+m*m));g[l>>2]=f*k;g[l+4>>2]=h*k;g[l+8>>2]=j*k;g[l+12>>2]=m*k;m=m*k<-1.0?-1.0:m*k;g[e>>2]=+T(+(m>1.0?1.0:m))*2.0;g[d>>2]=f*k;g[d+4>>2]=h*k;g[d+8>>2]=j*k;g[d+12>>2]=0.0;if(f*k*(f*k)+h*k*(h*k)+j*k*(j*k)<1.4210854715202004e-14){c[d>>2]=1065353216;c[d+4>>2]=0;c[d+8>>2]=0;g[d+12>>2]=0.0;i=l;return}else{p=1.0/+O(+(f*k*(f*k)+h*k*(h*k)+j*k*(j*k)));g[d>>2]=f*k*p;g[d+4>>2]=p*(h*k);g[d+8>>2]=p*(j*k);i=l;return}}function Cp(b){b=b|0;var d=0;c[b>>2]=2980;d=c[b+496>>2]|0;if(d){if(a[b+500>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+496>>2]=0}a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;return}function Dp(b){b=b|0;var d=0;c[b>>2]=2980;d=c[b+496>>2]|0;if(d){if(a[b+500>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+496>>2]=0}a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;c[2704]=(c[2704]|0)+1;YE(c[b+-4>>2]|0);return}function Ep(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+192>>2]=b;c[a+200>>2]=b;return}function Fp(b){b=b|0;var d=0,e=0,f=0;c[b>>2]=3020;if((a[b+272>>0]|0)!=0?(d=c[b+204>>2]|0,Db[c[c[d>>2]>>2]&255](d),d=c[b+204>>2]|0,(d|0)!=0):0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}d=c[b+196>>2]|0;if((d|0)!=0?(Db[c[c[d>>2]>>2]&255](d),f=c[b+196>>2]|0,(f|0)!=0):0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}if((a[b+273>>0]|0)!=0?(e=c[b+200>>2]|0,Db[c[c[e>>2]>>2]&255](e),e=c[b+200>>2]|0,(e|0)!=0):0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}d=c[b+316>>2]|0;if(d){if(a[b+320>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+316>>2]=0}a[b+320>>0]=1;c[b+316>>2]=0;c[b+308>>2]=0;c[b+312>>2]=0;d=c[b+288>>2]|0;if(d){if(a[b+292>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+288>>2]=0}a[b+292>>0]=1;c[b+288>>2]=0;c[b+280>>2]=0;c[b+284>>2]=0;d=c[b+240>>2]|0;if(d){if(a[b+244>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=0;c[b+232>>2]=0;c[b+236>>2]=0;d=c[b+220>>2]|0;if(d){if(a[b+224>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=0;c[b+212>>2]=0;c[b+216>>2]=0;d=c[b+188>>2]|0;if(!d){a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;d=b+184|0;c[d>>2]=0;Yu(b);return}if(a[b+192>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+188>>2]=0;a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;d=b+184|0;c[d>>2]=0;Yu(b);return}function Gp(a){a=a|0;Fp(a);if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function Hp(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0;h=i;i=i+32|0;d=c[a+8>>2]|0;if((d|0)<=0){i=h;return}f=0;do{e=c[(c[a+16>>2]|0)+(f<<2)>>2]|0;if((!((e|0)==0?1:(c[e+236>>2]&2|0)==0)?(c[e+216>>2]|0)!=2:0)?!((c[e+204>>2]&2|0)==0|b!=0.0^1):0){d=c[e+480>>2]|0;if(!d)d=e+4|0;else{Fb[c[(c[d>>2]|0)+8>>2]&127](d,e+4|0);d=e+4|0}k=(+g[e+56>>2]-+g[e+120>>2])*(1.0/b);l=1.0/b*(+g[e+60>>2]-+g[e+124>>2]);g[e+312>>2]=(+g[e+52>>2]-+g[e+116>>2])*(1.0/b);g[e+316>>2]=k;g[e+320>>2]=l;g[e+324>>2]=0.0;Bp(e+68|0,d,h+8|0,h);l=+g[h>>2];k=1.0/b*(l*+g[h+8+4>>2]);j=1.0/b*(l*+g[h+8+8>>2]);g[e+328>>2]=1.0/b*(+g[h+8>>2]*l);g[e+332>>2]=k;g[e+336>>2]=j;g[e+340>>2]=0.0;c[e+132>>2]=c[e+312>>2];c[e+132+4>>2]=c[e+312+4>>2];c[e+132+8>>2]=c[e+312+8>>2];c[e+132+12>>2]=c[e+312+12>>2];c[e+148>>2]=c[e+328>>2];c[e+148+4>>2]=c[e+328+4>>2];c[e+148+8>>2]=c[e+328+8>>2];c[e+148+12>>2]=c[e+328+12>>2];c[e+68>>2]=c[d>>2];c[e+68+4>>2]=c[d+4>>2];c[e+68+8>>2]=c[d+8>>2];c[e+68+12>>2]=c[d+12>>2];c[e+84>>2]=c[e+20>>2];c[e+84+4>>2]=c[e+20+4>>2];c[e+84+8>>2]=c[e+20+8>>2];c[e+84+12>>2]=c[e+20+12>>2];c[e+100>>2]=c[e+36>>2];c[e+100+4>>2]=c[e+36+4>>2];c[e+100+8>>2]=c[e+36+8>>2];c[e+100+12>>2]=c[e+36+12>>2];c[e+116>>2]=c[e+52>>2];c[e+116+4>>2]=c[e+52+4>>2];c[e+116+8>>2]=c[e+52+8>>2];c[e+116+12>>2]=c[e+52+12>>2];d=c[a+8>>2]|0}f=f+1|0}while((f|0)<(d|0));i=h;return}function Ip(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0,ja=0,ka=0;Y=i;i=i+496|0;iE(12356);jv(b);a:do if((Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(S=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Hb[c[(c[S>>2]|0)+48>>2]&127](S)|0)&6144|0)!=0):0){F=Y+432+44|0;O=Y+432+4|0;P=Y+432+8|0;S=Y+432+16|0;T=Y+432+20|0;U=Y+432+24|0;L=Y+432+32|0;M=Y+432+36|0;N=Y+432+40|0;V=Y+432+48|0;W=Y+432+52|0;X=Y+432+56|0;K=Y+432+48|0;E=Y+432+16|0;C=Y+432+32|0;J=Y+432+48|0;D=Y+432+16|0;B=Y+432+32|0;I=Y+432+48|0;d=Hb[c[(c[b>>2]|0)+104>>2]&127](b)|0;b:while(1){H=d+-1|0;if((d|0)<=0)break a;p=_b[c[(c[b>>2]|0)+108>>2]&31](b,H)|0;d=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;d=(Hb[c[(c[d>>2]|0)+48>>2]&127](d)|0)>>>11;o=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;o=(Hb[c[(c[o>>2]|0)+48>>2]&127](o)|0)>>>12;A=+g[p+40>>2];c:do if(!(A<=0.0))switch(c[p+4>>2]|0){case 3:{c[Y+432>>2]=1065353216;c[Y+432+4>>2]=0;c[Y+432+4+4>>2]=0;c[Y+432+4+8>>2]=0;c[Y+432+4+12>>2]=0;c[Y+432+20>>2]=1065353216;c[Y+432+24>>2]=0;c[Y+432+24+4>>2]=0;c[Y+432+24+8>>2]=0;c[Y+432+24+12>>2]=0;c[Y+432+40>>2]=1065353216;c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;c[F+12>>2]=0;c[F+16>>2]=0;r=+g[p+300>>2];q=+g[p+304>>2];v=+g[p+308>>2];l=c[p+28>>2]|0;j=r*+g[l+20>>2]+q*+g[l+24>>2]+v*+g[l+28>>2]+ +g[l+56>>2];u=r*+g[l+36>>2]+q*+g[l+40>>2]+v*+g[l+44>>2]+ +g[l+60>>2];g[Y+432+48>>2]=r*+g[l+4>>2]+q*+g[l+8>>2]+v*+g[l+12>>2]+ +g[l+52>>2];g[Y+432+52>>2]=j;g[Y+432+56>>2]=u;g[Y+432+60>>2]=0.0;l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;lc[c[(c[l>>2]|0)+56>>2]&7](l,Y+432|0,A);u=+g[p+316>>2];j=+g[p+320>>2];v=+g[p+324>>2];l=c[p+32>>2]|0;q=u*+g[l+20>>2]+j*+g[l+24>>2]+v*+g[l+28>>2]+ +g[l+56>>2];r=u*+g[l+36>>2]+j*+g[l+40>>2]+v*+g[l+44>>2]+ +g[l+60>>2];g[Y+432+48>>2]=u*+g[l+4>>2]+j*+g[l+8>>2]+v*+g[l+12>>2]+ +g[l+52>>2];g[Y+432+52>>2]=q;g[Y+432+56>>2]=r;g[Y+432+60>>2]=0.0;if(d&1){l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;lc[c[(c[l>>2]|0)+56>>2]&7](l,Y+432|0,A)}break c}case 4:{l=c[p+28>>2]|0;Z=+g[p+552>>2];da=+g[l+4>>2];z=+g[p+552+16>>2];ca=+g[l+8>>2];y=+g[p+552+32>>2];ba=+g[l+12>>2];x=+g[p+552+4>>2];w=+g[p+552+20>>2];e=+g[p+552+36>>2];s=+g[p+552+8>>2];t=+g[p+552+24>>2];u=+g[p+552+40>>2];aa=+g[l+20>>2];$=+g[l+24>>2];_=+g[l+28>>2];f=+g[l+36>>2];h=+g[l+40>>2];j=+g[l+44>>2];fa=+g[p+552+48>>2];ea=+g[p+552+52>>2];r=+g[p+552+56>>2];v=+g[l+52>>2]+(da*fa+ca*ea+ba*r);q=aa*fa+$*ea+_*r+ +g[l+56>>2];r=f*fa+h*ea+j*r+ +g[l+60>>2];g[Y+432>>2]=Z*da+z*ca+y*ba;g[Y+432+4>>2]=da*x+ca*w+ba*e;g[Y+432+8>>2]=da*s+ca*t+ba*u;g[Y+432+12>>2]=0.0;g[Y+432+16>>2]=Z*aa+z*$+y*_;g[Y+432+20>>2]=x*aa+w*$+e*_;g[Y+432+24>>2]=s*aa+t*$+u*_;g[Y+432+28>>2]=0.0;g[Y+432+32>>2]=Z*f+z*h+y*j;g[Y+432+36>>2]=x*f+w*h+e*j;g[Y+432+40>>2]=s*f+t*h+u*j;g[Y+432+44>>2]=0.0;g[Y+432+48>>2]=v;g[Y+432+52>>2]=q;g[Y+432+56>>2]=r;g[Y+432+60>>2]=0.0;if(!(d&1)){l=c[p+32>>2]|0;h=+g[p+616>>2];q=+g[l+4>>2];t=+g[p+616+16>>2];v=+g[l+8>>2];ca=+g[p+616+32>>2];ea=+g[l+12>>2];f=+g[p+616+4>>2];s=+g[p+616+20>>2];ba=+g[p+616+36>>2];e=+g[p+616+8>>2];w=+g[p+616+24>>2];y=+g[p+616+40>>2];j=+g[l+20>>2];u=+g[l+24>>2];da=+g[l+28>>2];aa=+g[l+36>>2];x=+g[l+40>>2];z=+g[l+44>>2];fa=+g[p+616+48>>2];r=+g[p+616+52>>2];$=+g[p+616+56>>2];Z=+g[l+52>>2]+(q*fa+v*r+ea*$);_=j*fa+u*r+da*$+ +g[l+56>>2];$=aa*fa+x*r+z*$+ +g[l+60>>2];g[Y+432>>2]=h*q+t*v+ca*ea;g[Y+432+4>>2]=q*f+v*s+ea*ba;g[Y+432+8>>2]=q*e+v*w+ea*y;g[Y+432+12>>2]=0.0;g[Y+432+16>>2]=h*j+t*u+ca*da;g[Y+432+20>>2]=f*j+s*u+ba*da;g[Y+432+24>>2]=e*j+w*u+y*da;g[Y+432+28>>2]=0.0;g[Y+432+32>>2]=h*aa+t*x+ca*z;g[Y+432+36>>2]=f*aa+s*x+ba*z;g[Y+432+40>>2]=e*aa+w*x+y*z;g[Y+432+44>>2]=0.0;g[Y+432+48>>2]=Z;g[Y+432+52>>2]=_;g[Y+432+56>>2]=$;g[Y+432+60>>2]=0.0}else{l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;lc[c[(c[l>>2]|0)+56>>2]&7](l,Y+432|0,A);l=c[p+32>>2]|0;h=+g[p+616>>2];q=+g[l+4>>2];t=+g[p+616+16>>2];v=+g[l+8>>2];ca=+g[p+616+32>>2];ea=+g[l+12>>2];f=+g[p+616+4>>2];s=+g[p+616+20>>2];ba=+g[p+616+36>>2];e=+g[p+616+8>>2];w=+g[p+616+24>>2];y=+g[p+616+40>>2];j=+g[l+20>>2];u=+g[l+24>>2];da=+g[l+28>>2];aa=+g[l+36>>2];x=+g[l+40>>2];z=+g[l+44>>2];fa=+g[p+616+48>>2];r=+g[p+616+52>>2];$=+g[p+616+56>>2];Z=+g[l+52>>2]+(q*fa+v*r+ea*$);_=j*fa+u*r+da*$+ +g[l+56>>2];$=aa*fa+x*r+z*$+ +g[l+60>>2];g[Y+432>>2]=h*q+t*v+ca*ea;g[Y+432+4>>2]=q*f+v*s+ea*ba;g[Y+432+8>>2]=q*e+v*w+ea*y;g[Y+432+12>>2]=0.0;g[Y+432+16>>2]=h*j+t*u+ca*da;g[Y+432+20>>2]=f*j+s*u+ba*da;g[Y+432+24>>2]=e*j+w*u+y*da;g[Y+432+28>>2]=0.0;g[Y+432+32>>2]=h*aa+t*x+ca*z;g[Y+432+36>>2]=f*aa+s*x+ba*z;g[Y+432+40>>2]=e*aa+w*x+y*z;g[Y+432+44>>2]=0.0;g[Y+432+48>>2]=Z;g[Y+432+52>>2]=_;g[Y+432+56>>2]=$;g[Y+432+60>>2]=0.0;l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;lc[c[(c[l>>2]|0)+56>>2]&7](l,Y+432|0,A)}h=+g[p+688>>2];f=+g[p+688+4>>2];e=+_E(h-f,6.2831854820251465);if(!(e<-3.1415927410125732))if(e>3.1415927410125732)j=e+-6.2831854820251465;else j=e;else j=e+6.2831854820251465;e=+_E(h+f,6.2831854820251465);if(!(e<-3.1415927410125732)){if(e>3.1415927410125732)e=e+-6.2831854820251465}else e=e+6.2831854820251465;if(!(j==e)?(G=j>e,(o&1|0)!=0):0){c[Y+416>>2]=c[Y+432+8>>2];c[Y+416+4>>2]=c[Y+432+24>>2];c[Y+416+8>>2]=c[Y+432+40>>2];g[Y+416+12>>2]=0.0;c[Y+400>>2]=c[Y+432>>2];c[Y+400+4>>2]=c[Y+432+16>>2];c[Y+400+8>>2]=c[Y+432+32>>2];g[Y+400+12>>2]=0.0;l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;m=c[(c[l>>2]|0)+60>>2]|0;c[Y+384>>2]=0;c[Y+384+4>>2]=0;c[Y+384+8>>2]=0;c[Y+384+12>>2]=0;Ob[m&0](l,Y+432+48|0,Y+416|0,Y+400|0,A,A,G?0.0:j,G?6.2831854820251465:e,Y+384|0,G^1,10.0)}d=H;continue b}case 5:{l=c[p+28>>2]|0;h=+g[p+300>>2];q=+g[l+4>>2];t=+g[p+300+16>>2];v=+g[l+8>>2];ca=+g[p+300+32>>2];ea=+g[l+12>>2];f=+g[p+300+4>>2];s=+g[p+300+20>>2];ba=+g[p+300+36>>2];e=+g[p+300+8>>2];w=+g[p+300+24>>2];y=+g[p+300+40>>2];j=+g[l+20>>2];u=+g[l+24>>2];da=+g[l+28>>2];aa=+g[l+36>>2];x=+g[l+40>>2];z=+g[l+44>>2];fa=+g[p+300+48>>2];r=+g[p+300+52>>2];$=+g[p+300+56>>2];Z=+g[l+52>>2]+(q*fa+v*r+ea*$);_=j*fa+u*r+da*$+ +g[l+56>>2];$=aa*fa+x*r+z*$+ +g[l+60>>2];g[Y+432>>2]=h*q+t*v+ca*ea;g[O>>2]=q*f+v*s+ea*ba;g[P>>2]=q*e+v*w+ea*y;g[Y+432+12>>2]=0.0;g[S>>2]=h*j+t*u+ca*da;g[T>>2]=f*j+s*u+ba*da;g[U>>2]=e*j+w*u+y*da;g[Y+432+28>>2]=0.0;g[L>>2]=h*aa+t*x+ca*z;g[M>>2]=f*aa+s*x+ba*z;g[N>>2]=e*aa+w*x+y*z;g[Y+432+44>>2]=0.0;g[V>>2]=Z;g[W>>2]=_;g[X>>2]=$;g[Y+432+60>>2]=0.0;if(!(d&1)){l=c[p+32>>2]|0;h=+g[p+364>>2];q=+g[l+4>>2];t=+g[p+364+16>>2];v=+g[l+8>>2];ca=+g[p+364+32>>2];ea=+g[l+12>>2];f=+g[p+364+4>>2];s=+g[p+364+20>>2];ba=+g[p+364+36>>2];e=+g[p+364+8>>2];w=+g[p+364+24>>2];y=+g[p+364+40>>2];j=+g[l+20>>2];u=+g[l+24>>2];da=+g[l+28>>2];aa=+g[l+36>>2];x=+g[l+40>>2];z=+g[l+44>>2];fa=+g[p+364+48>>2];r=+g[p+364+52>>2];$=+g[p+364+56>>2];Z=+g[l+52>>2]+(q*fa+v*r+ea*$);_=j*fa+u*r+da*$+ +g[l+56>>2];$=aa*fa+x*r+z*$+ +g[l+60>>2];g[Y+432>>2]=h*q+t*v+ca*ea;g[O>>2]=q*f+v*s+ea*ba;g[P>>2]=q*e+v*w+ea*y;g[Y+432+12>>2]=0.0;g[S>>2]=h*j+t*u+ca*da;g[T>>2]=f*j+s*u+ba*da;g[U>>2]=e*j+w*u+y*da;g[Y+432+28>>2]=0.0;g[L>>2]=h*aa+t*x+ca*z;g[M>>2]=f*aa+s*x+ba*z;g[N>>2]=e*aa+w*x+y*z;g[Y+432+44>>2]=0.0;g[V>>2]=Z;g[W>>2]=_;g[X>>2]=$;g[Y+432+60>>2]=0.0}else{l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;lc[c[(c[l>>2]|0)+56>>2]&7](l,Y+432|0,A);l=c[p+32>>2]|0;h=+g[p+364>>2];q=+g[l+4>>2];t=+g[p+364+16>>2];v=+g[l+8>>2];ca=+g[p+364+32>>2];ea=+g[l+12>>2];f=+g[p+364+4>>2];s=+g[p+364+20>>2];ba=+g[p+364+36>>2];e=+g[p+364+8>>2];w=+g[p+364+24>>2];y=+g[p+364+40>>2];j=+g[l+20>>2];u=+g[l+24>>2];da=+g[l+28>>2];aa=+g[l+36>>2];x=+g[l+40>>2];z=+g[l+44>>2];fa=+g[p+364+48>>2];r=+g[p+364+52>>2];$=+g[p+364+56>>2];Z=+g[l+52>>2]+(q*fa+v*r+ea*$);_=j*fa+u*r+da*$+ +g[l+56>>2];$=aa*fa+x*r+z*$+ +g[l+60>>2];g[Y+432>>2]=h*q+t*v+ca*ea;g[O>>2]=q*f+v*s+ea*ba;g[P>>2]=q*e+v*w+ea*y;g[Y+432+12>>2]=0.0;g[S>>2]=h*j+t*u+ca*da;g[T>>2]=f*j+s*u+ba*da;g[U>>2]=e*j+w*u+y*da;g[Y+432+28>>2]=0.0;g[L>>2]=h*aa+t*x+ca*z;g[M>>2]=f*aa+s*x+ba*z;g[N>>2]=e*aa+w*x+y*z;g[Y+432+44>>2]=0.0;g[V>>2]=Z;g[W>>2]=_;g[X>>2]=$;g[Y+432+60>>2]=0.0;l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;lc[c[(c[l>>2]|0)+56>>2]&7](l,Y+432|0,A)}if(o&1){wr(Y+368|0,p,6.0868353843688965,A);y=+g[Y+368>>2];z=+g[Y+368+4>>2];Z=+g[Y+368+8>>2];_=y*+g[S>>2]+z*+g[T>>2]+Z*+g[U>>2]+ +g[W>>2];$=y*+g[L>>2]+z*+g[M>>2]+Z*+g[N>>2]+ +g[X>>2];g[Y+368>>2]=y*+g[Y+432>>2]+z*+g[O>>2]+Z*+g[P>>2]+ +g[V>>2];g[Y+368+4>>2]=_;g[Y+368+8>>2]=$;g[Y+368+12>>2]=0.0;d=0;do{wr(Y+352|0,p,+(d|0)*6.283185005187988*.03125,A);y=+g[Y+352>>2];z=+g[Y+352+4>>2];Z=+g[Y+352+8>>2];_=y*+g[S>>2]+z*+g[T>>2]+Z*+g[U>>2]+ +g[W>>2];$=y*+g[L>>2]+z*+g[M>>2]+Z*+g[N>>2]+ +g[X>>2];g[Y+352>>2]=y*+g[Y+432>>2]+z*+g[O>>2]+Z*+g[P>>2]+ +g[V>>2];g[Y+352+4>>2]=_;g[Y+352+8>>2]=$;g[Y+352+12>>2]=0.0;l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;m=c[(c[l>>2]|0)+8>>2]|0;c[Y+336>>2]=0;c[Y+336+4>>2]=0;c[Y+336+8>>2]=0;c[Y+336+12>>2]=0;nc[m&127](l,Y+368|0,Y+352|0,Y+336|0);if(!(d&3)){l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;m=c[(c[l>>2]|0)+8>>2]|0;c[Y+320>>2]=0;c[Y+320+4>>2]=0;c[Y+320+8>>2]=0;c[Y+320+12>>2]=0;nc[m&127](l,K,Y+352|0,Y+320|0)};c[Y+368>>2]=c[Y+352>>2];c[Y+368+4>>2]=c[Y+352+4>>2];c[Y+368+8>>2]=c[Y+352+8>>2];c[Y+368+12>>2]=c[Y+352+12>>2];d=d+1|0}while((d|0)!=32);y=+g[p+452>>2];z=+g[p+512>>2];d=c[p+32>>2]|0;if(+g[d+344>>2]>0.0){ba=+g[p+364>>2];aa=+g[d+4>>2];Z=+g[p+364+16>>2];_=+g[d+8>>2];$=+g[p+364+32>>2];v=+g[d+12>>2];da=+g[p+364+4>>2];ca=+g[p+364+20>>2];u=+g[p+364+36>>2];fa=+g[p+364+8>>2];ea=+g[p+364+24>>2];t=+g[p+364+40>>2];ha=+g[d+20>>2];ga=+g[d+24>>2];s=+g[d+28>>2];r=+g[d+36>>2];q=+g[d+40>>2];e=+g[d+44>>2];f=+g[p+364+48>>2];h=+g[p+364+52>>2];j=+g[p+364+56>>2];w=r*f+q*h+e*j+ +g[d+60>>2];x=ha*f+ga*h+s*j+ +g[d+56>>2];j=+g[d+52>>2]+(aa*f+_*h+v*j);h=fa*r+ea*q+t*e;f=da*r+ca*q+u*e;e=ba*r+Z*q+$*e;q=fa*ha+ea*ga+t*s;r=da*ha+ca*ga+u*s;s=ba*ha+Z*ga+$*s;t=aa*fa+_*ea+v*t;u=aa*da+_*ca+v*u;v=ba*aa+Z*_+$*v}else{l=c[p+28>>2]|0;ba=+g[p+300>>2];aa=+g[l+4>>2];Z=+g[p+300+16>>2];_=+g[l+8>>2];$=+g[p+300+32>>2];v=+g[l+12>>2];da=+g[p+300+4>>2];ca=+g[p+300+20>>2];u=+g[p+300+36>>2];fa=+g[p+300+8>>2];ea=+g[p+300+24>>2];t=+g[p+300+40>>2];ha=+g[l+20>>2];ga=+g[l+24>>2];s=+g[l+28>>2];r=+g[l+36>>2];q=+g[l+40>>2];e=+g[l+44>>2];f=+g[p+300+48>>2];h=+g[p+300+52>>2];j=+g[p+300+56>>2];w=r*f+q*h+e*j+ +g[l+60>>2];x=ha*f+ga*h+s*j+ +g[l+56>>2];j=+g[l+52>>2]+(aa*f+_*h+v*j);h=fa*r+ea*q+t*e;f=da*r+ca*q+u*e;e=ba*r+Z*q+$*e;q=fa*ha+ea*ga+t*s;r=da*ha+ca*ga+u*s;s=ba*ha+Z*ga+$*s;t=aa*fa+_*ea+v*t;u=aa*da+_*ca+v*u;v=ba*aa+Z*_+$*v}g[Y+432>>2]=v;g[O>>2]=u;g[P>>2]=t;g[Y+432+12>>2]=0.0;g[S>>2]=s;g[T>>2]=r;g[U>>2]=q;g[Y+432+28>>2]=0.0;g[L>>2]=e;g[M>>2]=f;g[N>>2]=h;g[Y+432+44>>2]=0.0;g[V>>2]=j;g[W>>2]=x;g[X>>2]=w;g[Y+432+60>>2]=0.0;c[Y+304>>2]=c[K>>2];c[Y+304+4>>2]=c[K+4>>2];c[Y+304+8>>2]=c[K+8>>2];c[Y+304+12>>2]=c[K+12>>2];g[Y+288>>2]=v;g[Y+288+4>>2]=s;g[Y+288+8>>2]=e;g[Y+288+12>>2]=0.0;g[Y+272>>2]=u;g[Y+272+4>>2]=r;g[Y+272+8>>2]=f;g[Y+272+12>>2]=0.0;l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;m=c[(c[l>>2]|0)+60>>2]|0;c[Y+256>>2]=0;c[Y+256+4>>2]=0;c[Y+256+8>>2]=0;c[Y+256+12>>2]=0;Ob[m&0](l,Y+304|0,Y+288|0,Y+272|0,A,A,-z-y,y-z,Y+256|0,1,10.0)}break c}case 6:case 9:{c[Y+432>>2]=c[p+1064>>2];c[Y+432+4>>2]=c[p+1064+4>>2];c[Y+432+8>>2]=c[p+1064+8>>2];c[Y+432+12>>2]=c[p+1064+12>>2];m=p+1064+16|0;c[E>>2]=c[m>>2];c[E+4>>2]=c[m+4>>2];c[E+8>>2]=c[m+8>>2];c[E+12>>2]=c[m+12>>2];l=p+1064+32|0;c[C>>2]=c[l>>2];c[C+4>>2]=c[l+4>>2];c[C+8>>2]=c[l+8>>2];c[C+12>>2]=c[l+12>>2];n=p+1064+48|0;c[J>>2]=c[n>>2];c[J+4>>2]=c[n+4>>2];c[J+8>>2]=c[n+8>>2];c[J+12>>2]=c[n+12>>2];if(!(d&1)){c[Y+432>>2]=c[p+1128>>2];c[Y+432+4>>2]=c[p+1128+4>>2];c[Y+432+8>>2]=c[p+1128+8>>2];c[Y+432+12>>2]=c[p+1128+12>>2];c[E>>2]=c[p+1128+16>>2];c[E+4>>2]=c[p+1128+16+4>>2];c[E+8>>2]=c[p+1128+16+8>>2];c[E+12>>2]=c[p+1128+16+12>>2];c[C>>2]=c[p+1128+32>>2];c[C+4>>2]=c[p+1128+32+4>>2];c[C+8>>2]=c[p+1128+32+8>>2];c[C+12>>2]=c[p+1128+32+12>>2];c[J>>2]=c[p+1128+48>>2];c[J+4>>2]=c[p+1128+48+4>>2];c[J+8>>2]=c[p+1128+48+8>>2];c[J+12>>2]=c[p+1128+48+12>>2]}else{d=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;lc[c[(c[d>>2]|0)+56>>2]&7](d,Y+432|0,A);c[Y+432>>2]=c[p+1128>>2];c[Y+432+4>>2]=c[p+1128+4>>2];c[Y+432+8>>2]=c[p+1128+8>>2];c[Y+432+12>>2]=c[p+1128+12>>2];c[E>>2]=c[p+1128+16>>2];c[E+4>>2]=c[p+1128+16+4>>2];c[E+8>>2]=c[p+1128+16+8>>2];c[E+12>>2]=c[p+1128+16+12>>2];c[C>>2]=c[p+1128+32>>2];c[C+4>>2]=c[p+1128+32+4>>2];c[C+8>>2]=c[p+1128+32+8>>2];c[C+12>>2]=c[p+1128+32+12>>2];c[J>>2]=c[p+1128+48>>2];c[J+4>>2]=c[p+1128+48+4>>2];c[J+8>>2]=c[p+1128+48+8>>2];c[J+12>>2]=c[p+1128+48+12>>2];d=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;lc[c[(c[d>>2]|0)+56>>2]&7](d,Y+432|0,A)}if(o&1){c[Y+432>>2]=c[p+1064>>2];c[Y+432+4>>2]=c[p+1064+4>>2];c[Y+432+8>>2]=c[p+1064+8>>2];c[Y+432+12>>2]=c[p+1064+12>>2];c[E>>2]=c[m>>2];c[E+4>>2]=c[m+4>>2];c[E+8>>2]=c[m+8>>2];c[E+12>>2]=c[m+12>>2];c[C>>2]=c[l>>2];c[C+4>>2]=c[l+4>>2];c[C+8>>2]=c[l+8>>2];c[C+12>>2]=c[l+12>>2];c[J>>2]=c[n>>2];c[J+4>>2]=c[n+4>>2];c[J+8>>2]=c[n+8>>2];c[J+12>>2]=c[n+12>>2];d=p+1128+48|0;c[Y+240>>2]=c[Y+432+8>>2];c[Y+240+4>>2]=c[Y+432+24>>2];c[Y+240+8>>2]=c[Y+432+40>>2];g[Y+240+12>>2]=0.0;c[Y+224>>2]=c[Y+432>>2];c[Y+224+4>>2]=c[Y+432+16>>2];c[Y+224+8>>2]=c[Y+432+32>>2];g[Y+224+12>>2]=0.0;y=+g[p+932>>2];j=+g[p+932+4>>2];_=+g[p+996>>2];Z=+g[p+996+4>>2];ja=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;ia=c[(c[ja>>2]|0)+64>>2]|0;c[Y+208>>2]=0;c[Y+208+4>>2]=0;c[Y+208+8>>2]=0;c[Y+208+12>>2]=0;ec[ia&0](ja,d,Y+240|0,Y+224|0,A*.8999999761581421,y,j,_,Z,Y+208|0,10.0,1);ja=c[Y+432+4>>2]|0;ia=c[Y+432+20>>2]|0;o=c[Y+432+36>>2]|0;c[Y+224>>2]=ja;c[Y+224+4>>2]=ia;c[Y+224+8>>2]=o;g[Y+224+12>>2]=0.0;Z=+g[p+1196>>2];_=+g[p+1200>>2];j=+Q(+Z);Z=+R(+Z);y=+Q(+_);_=+R(+_);z=(c[k>>2]=ja,+g[k>>2]);$=(c[k>>2]=ia,+g[k>>2]);h=(c[k>>2]=o,+g[k>>2]);g[Y+192>>2]=j*y*z+j*_*$-Z*h;g[Y+192+4>>2]=y*$-_*z;g[Y+192+8>>2]=Z*y*z+Z*_*$+j*h;c[Y+432>>2]=c[p+1128>>2];c[Y+432+4>>2]=c[p+1128+4>>2];c[Y+432+8>>2]=c[p+1128+8>>2];c[Y+432+12>>2]=c[p+1128+12>>2];c[E>>2]=c[p+1128+16>>2];c[E+4>>2]=c[p+1128+16+4>>2];c[E+8>>2]=c[p+1128+16+8>>2];c[E+12>>2]=c[p+1128+16+12>>2];c[C>>2]=c[p+1128+32>>2];c[C+4>>2]=c[p+1128+32+4>>2];c[C+8>>2]=c[p+1128+32+8>>2];c[C+12>>2]=c[p+1128+32+12>>2];c[J>>2]=c[d>>2];c[J+4>>2]=c[d+4>>2];c[J+8>>2]=c[d+8>>2];c[J+12>>2]=c[d+12>>2];h=-+g[Y+432+16>>2];j=-+g[Y+432+32>>2];g[Y+176>>2]=-+g[Y+432>>2];g[Y+176+4>>2]=h;g[Y+176+8>>2]=j;g[Y+176+12>>2]=0.0;j=+g[p+868>>2];h=+g[p+868+4>>2];if(!(j>h)){if(j<h){o=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;ia=c[(c[o>>2]|0)+60>>2]|0;c[Y+144>>2]=0;c[Y+144+4>>2]=0;c[Y+144+8>>2]=0;c[Y+144+12>>2]=0;Ob[ia&0](o,d,Y+176|0,Y+192|0,A,A,j,h,Y+144|0,1,10.0)}}else{o=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;ia=c[(c[o>>2]|0)+60>>2]|0;c[Y+160>>2]=0;c[Y+160+4>>2]=0;c[Y+160+8>>2]=0;c[Y+160+12>>2]=0;Ob[ia&0](o,d,Y+176|0,Y+192|0,A,A,-3.1415927410125732,3.1415927410125732,Y+160|0,0,10.0)};c[Y+432>>2]=c[p+1064>>2];c[Y+432+4>>2]=c[p+1064+4>>2];c[Y+432+8>>2]=c[p+1064+8>>2];c[Y+432+12>>2]=c[p+1064+12>>2];c[E>>2]=c[m>>2];c[E+4>>2]=c[m+4>>2];c[E+8>>2]=c[m+8>>2];c[E+12>>2]=c[m+12>>2];c[C>>2]=c[l>>2];c[C+4>>2]=c[l+4>>2];c[C+8>>2]=c[l+8>>2];c[C+12>>2]=c[l+12>>2];c[J>>2]=c[n>>2];c[J+4>>2]=c[n+4>>2];c[J+8>>2]=c[n+8>>2];c[J+12>>2]=c[n+12>>2];c[Y+128>>2]=c[p+680>>2];c[Y+128+4>>2]=c[p+680+4>>2];c[Y+128+8>>2]=c[p+680+8>>2];c[Y+128+12>>2]=c[p+680+12>>2];c[Y+112>>2]=c[p+680+16>>2];c[Y+112+4>>2]=c[p+680+16+4>>2];c[Y+112+8>>2]=c[p+680+16+8>>2];c[Y+112+12>>2]=c[p+680+16+12>>2];l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;m=c[(c[l>>2]|0)+72>>2]|0;c[Y+96>>2]=0;c[Y+96+4>>2]=0;c[Y+96+8>>2]=0;c[Y+96+12>>2]=0;Bb[m&31](l,Y+128|0,Y+112|0,Y+432|0,Y+96|0)}break c}case 7:{c[Y+432>>2]=c[p+824>>2];c[Y+432+4>>2]=c[p+824+4>>2];c[Y+432+8>>2]=c[p+824+8>>2];c[Y+432+12>>2]=c[p+824+12>>2];c[D>>2]=c[p+824+16>>2];c[D+4>>2]=c[p+824+16+4>>2];c[D+8>>2]=c[p+824+16+8>>2];c[D+12>>2]=c[p+824+16+12>>2];c[B>>2]=c[p+824+32>>2];c[B+4>>2]=c[p+824+32+4>>2];c[B+8>>2]=c[p+824+32+8>>2];c[B+12>>2]=c[p+824+32+12>>2];c[I>>2]=c[p+824+48>>2];c[I+4>>2]=c[p+824+48+4>>2];c[I+8>>2]=c[p+824+48+8>>2];c[I+12>>2]=c[p+824+48+12>>2];if(!(d&1)){c[Y+432>>2]=c[p+888>>2];c[Y+432+4>>2]=c[p+888+4>>2];c[Y+432+8>>2]=c[p+888+8>>2];c[Y+432+12>>2]=c[p+888+12>>2];c[D>>2]=c[p+888+16>>2];c[D+4>>2]=c[p+888+16+4>>2];c[D+8>>2]=c[p+888+16+8>>2];c[D+12>>2]=c[p+888+16+12>>2];c[B>>2]=c[p+888+32>>2];c[B+4>>2]=c[p+888+32+4>>2];c[B+8>>2]=c[p+888+32+8>>2];c[B+12>>2]=c[p+888+32+12>>2];c[I>>2]=c[p+888+48>>2];c[I+4>>2]=c[p+888+48+4>>2];c[I+8>>2]=c[p+888+48+8>>2];c[I+12>>2]=c[p+888+48+12>>2]}else{l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;lc[c[(c[l>>2]|0)+56>>2]&7](l,Y+432|0,A);c[Y+432>>2]=c[p+888>>2];c[Y+432+4>>2]=c[p+888+4>>2];c[Y+432+8>>2]=c[p+888+8>>2];c[Y+432+12>>2]=c[p+888+12>>2];c[D>>2]=c[p+888+16>>2];c[D+4>>2]=c[p+888+16+4>>2];c[D+8>>2]=c[p+888+16+8>>2];c[D+12>>2]=c[p+888+16+12>>2];c[B>>2]=c[p+888+32>>2];c[B+4>>2]=c[p+888+32+4>>2];c[B+8>>2]=c[p+888+32+8>>2];c[B+12>>2]=c[p+888+32+12>>2];c[I>>2]=c[p+888+48>>2];c[I+4>>2]=c[p+888+48+4>>2];c[I+8>>2]=c[p+888+48+8>>2];c[I+12>>2]=c[p+888+48+12>>2];l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;lc[c[(c[l>>2]|0)+56>>2]&7](l,Y+432|0,A)}if(o&1){d=(a[p+180>>0]|0)!=0?p+824|0:p+888|0;ja=c[d>>2]|0;n=c[d+4>>2]|0;ia=c[d+16>>2]|0;m=c[d+20>>2]|0;o=c[d+32>>2]|0;l=c[d+36>>2]|0;ca=+g[d+48>>2];e=+g[d+52>>2];y=+g[d+56>>2];_=+g[p+184>>2];ba=(c[k>>2]=ja,+g[k>>2]);s=(c[k>>2]=n,+g[k>>2])*0.0;f=+g[d+8>>2]*0.0;x=(c[k>>2]=ia,+g[k>>2]);w=(c[k>>2]=m,+g[k>>2])*0.0;aa=+g[d+24>>2]*0.0;$=(c[k>>2]=o,+g[k>>2]);Z=(c[k>>2]=l,+g[k>>2])*0.0;z=+g[d+40>>2]*0.0;g[Y+80>>2]=ca+(f+(s+ba*_));g[Y+80+4>>2]=e+(aa+(w+x*_));g[Y+80+8>>2]=y+(z+(Z+$*_));g[Y+80+12>>2]=0.0;_=+g[p+188>>2];g[Y+64>>2]=ca+(f+(s+ba*_));g[Y+64+4>>2]=e+(aa+(w+x*_));g[Y+64+8>>2]=y+(z+(Z+$*_));g[Y+64+12>>2]=0.0;d=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;ka=c[(c[d>>2]|0)+8>>2]|0;c[Y+48>>2]=0;c[Y+48+4>>2]=0;c[Y+48+8>>2]=0;c[Y+48+12>>2]=0;nc[ka&127](d,Y+80|0,Y+64|0,Y+48|0);c[Y+32>>2]=ja;c[Y+32+4>>2]=ia;c[Y+32+8>>2]=o;g[Y+32+12>>2]=0.0;c[Y+16>>2]=n;c[Y+16+4>>2]=m;c[Y+16+8>>2]=l;g[Y+16+12>>2]=0.0;_=+g[p+192>>2];$=+g[p+196>>2];l=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;m=c[(c[l>>2]|0)+60>>2]|0;c[Y>>2]=0;c[Y+4>>2]=0;c[Y+8>>2]=0;c[Y+12>>2]=0;Ob[m&0](l,p+888+48|0,Y+32|0,Y+16|0,A,A,_,$,Y,1,10.0)}break c}default:break c}while(0);d=H}}while(0);if(((((Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(S=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Hb[c[(c[S>>2]|0)+48>>2]&127](S)|0)&16387|0)!=0):0)?(Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0:0)?(S=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0,(Hb[c[(c[S>>2]|0)+48>>2]&127](S)|0)!=0):0)?(c[b+280>>2]|0)>0:0){d=0;do{S=c[(c[b+288>>2]|0)+(d<<2)>>2]|0;Fb[c[(c[S>>2]|0)+12>>2]&127](S,c[b+72>>2]|0);d=d+1|0}while((d|0)<(c[b+280>>2]|0))}d=c[2700]|0;S=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=S;if(S){i=Y;return}do if(c[d+4>>2]|0){vb(Y+432|0,0)|0;S=c[2702]|0;g[d+8>>2]=+(((c[Y+432+4>>2]|0)-(c[S+4>>2]|0)+(((c[Y+432>>2]|0)-(c[S>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[2700]|0;break}else{i=Y;return}}while(0);c[2700]=c[d+20>>2];i=Y;return}function Jp(a){a=a|0;var b=0,d=0;if((c[a+232>>2]|0)<=0)return;b=0;do{d=(c[(c[a+240>>2]|0)+(b<<2)>>2]|0)+412|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;b=b+1|0}while((b|0)<(c[a+232>>2]|0));return}function Kp(a){a=a|0;var b=0,d=0,e=0,f=0.0,h=0.0;e=c[a+232>>2]|0;if((e|0)<=0)return;a=c[a+240>>2]|0;d=0;do{b=c[a+(d<<2)>>2]|0;switch(c[b+216>>2]|0){case 2:case 5:break;default:if(!(c[b+204>>2]&3)){h=+g[b+368>>2]*+g[b+352>>2];f=+g[b+372>>2]*+g[b+356>>2];g[b+412>>2]=+g[b+364>>2]*+g[b+348>>2]+ +g[b+412>>2];g[b+416>>2]=h+ +g[b+416>>2];g[b+420>>2]=f+ +g[b+420>>2]}}d=d+1|0}while((d|0)!=(e|0));return}function Lp(b){b=b|0;var d=0,e=0.0,f=0,h=0,j=0.0,k=0.0,l=0;l=i;i=i+64|0;iE(12371);a:do if(!(a[b+274>>0]|0)){d=c[b+232>>2]|0;if((d|0)>0){h=0;while(1){f=c[(c[b+240>>2]|0)+(h<<2)>>2]|0;switch(c[f+216>>2]|0){case 2:case 5:break;default:if((c[f+480>>2]|0)!=0?(c[f+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(k=+g[b+268>>2],k!=0.0):0)e=+g[b+264>>2]-k;else e=+g[b+264>>2]*+g[f+244>>2];Ap(f+68|0,+g[f+132>>2],+g[f+136>>2],+g[f+140>>2],f+148|0,e,l);d=c[f+480>>2]|0;Fb[c[(c[d>>2]|0)+12>>2]&127](d,l);d=c[b+232>>2]|0}}h=h+1|0;if((h|0)>=(d|0))break a}}}else{d=c[b+8>>2]|0;if((d|0)>0){h=0;do{f=c[(c[b+16>>2]|0)+(h<<2)>>2]|0;if((!((f|0)==0?1:(c[f+236>>2]&2|0)==0)?(c[f+480>>2]|0)!=0:0)?(c[f+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(j=+g[b+268>>2],j!=0.0):0)e=+g[b+264>>2]-j;else e=+g[b+264>>2]*+g[f+244>>2];Ap(f+68|0,+g[f+132>>2],+g[f+136>>2],+g[f+140>>2],f+148|0,e,l);d=c[f+480>>2]|0;Fb[c[(c[d>>2]|0)+12>>2]&127](d,l);d=c[b+8>>2]|0}h=h+1|0}while((h|0)<(d|0))}}while(0);d=c[2700]|0;f=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=f;if(f){i=l;return}do if(c[d+4>>2]|0){vb(l|0,0)|0;f=c[2702]|0;g[d+8>>2]=+(((c[l+4>>2]|0)-(c[f+4>>2]|0)+(((c[l>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[2700]|0;break}else{i=l;return}}while(0);c[2700]=c[d+20>>2];i=l;return}function Mp(b,d,e,f){b=b|0;d=+d;e=e|0;f=+f;var h=0,j=0.0,k=0,l=0;l=i;i=i+16|0;vb(c[2702]|0,0)|0;hE(10764);c[2692]=(c[2692]|0)+1;h=c[2695]|0;c[2695]=h+1;if(!h){vb(l|0,0)|0;h=c[2702]|0;c[2694]=(c[l+4>>2]|0)-(c[h+4>>2]|0)+(((c[l>>2]|0)-(c[h>>2]|0)|0)*1e6|0)}c[2701]=0;vb(l|0,0)|0;iE(12395);if(e){g[b+268>>2]=f;j=+g[b+264>>2]+d;g[b+264>>2]=j;if(!(j>=f)){d=f;k=0}else{g[b+264>>2]=j-+(~~(j/f)|0)*f;d=f;k=~~(j/f)}}else{g[b+264>>2]=(a[b+300>>0]|0)!=0?0.0:d;g[b+268>>2]=0.0;k=!(+N(+d)<1.1920928955078125e-07)&1;e=k}if(Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0){h=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;a[12294]=(Hb[c[(c[h>>2]|0)+48>>2]&127](h)|0)>>>4&1}if(k){h=(k|0)>(e|0)?e:k;Cb[c[(c[b>>2]|0)+164>>2]&31](b,d*+(h|0));Db[c[(c[b>>2]|0)+168>>2]&255](b);if((h|0)>0){e=0;do{Cb[c[(c[b>>2]|0)+160>>2]&31](b,d);Db[c[(c[b>>2]|0)+80>>2]&255](b);e=e+1|0}while((e|0)<(h|0));h=b}else h=b}else{Db[c[(c[b>>2]|0)+80>>2]&255](b);h=b}Db[c[(c[h>>2]|0)+120>>2]&255](b);c[2701]=(c[2701]|0)+1;h=c[2700]|0;e=(c[h+16>>2]|0)+-1|0;c[h+16>>2]=e;if(e){i=l;return k|0}do if(c[h+4>>2]|0){vb(l|0,0)|0;e=c[2702]|0;g[h+8>>2]=+(((c[l+4>>2]|0)-(c[e+4>>2]|0)+(((c[l>>2]|0)-(c[e>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0)/1.0e3+ +g[h+8>>2];if(!(c[h+16>>2]|0)){h=c[2700]|0;break}else{i=l;return k|0}}while(0);c[2700]=c[h+20>>2];i=l;return k|0}function Np(d,e){d=d|0;e=+e;var f=0,h=0,j=0,k=0,l=0.0,m=0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0.0,z=0.0,A=0.0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0;B=i;i=i+464|0;iE(12410);f=c[d+84>>2]|0;if(f)Cb[f&31](d,e);Cb[c[(c[d>>2]|0)+140>>2]&31](d,e);g[d+28>>2]=e;c[d+32>>2]=0;c[d+48>>2]=Hb[c[(c[d>>2]|0)+20>>2]&127](d)|0;iE(12453);iE(12478);f=c[d+316>>2]|0;if((c[d+308>>2]|0)>0){h=0;do{r=c[d+24>>2]|0;Fb[c[(c[r>>2]|0)+16>>2]&127](r,c[f+(h<<2)>>2]|0);h=h+1|0;f=c[d+316>>2]|0}while((h|0)<(c[d+308>>2]|0))}if(f){if(a[d+320>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=0;c[d+308>>2]=0;c[d+312>>2]=0;f=c[2700]|0;r=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=r;do if(!r){if(c[f+4>>2]|0){vb(B+368|0,0)|0;r=c[2702]|0;g[f+8>>2]=+(((c[B+368+4>>2]|0)-(c[r+4>>2]|0)+(((c[B+368>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[2700]|0}c[2700]=c[f+20>>2]}while(0);a:do if((c[d+232>>2]|0)>0){s=B+304+48|0;r=B+368+44|0;q=0;while(1){k=c[(c[d+240>>2]|0)+(q<<2)>>2]|0;g[k+244>>2]=1.0;b:do switch(c[k+216>>2]|0){case 2:case 5:break;default:if(((c[k+204>>2]&3|0)==0?(Ap(k+4|0,+g[k+312>>2],+g[k+316>>2],+g[k+320>>2],k+328|0,e,B+304|0),t=+g[s>>2],y=t-+g[k+52>>2],u=+g[B+304+52>>2],A=u-+g[k+56>>2],v=+g[B+304+56>>2],z=v-+g[k+60>>2],(a[d+44>>0]|0)!=0):0)?(p=+g[k+252>>2],p*p!=0.0?p*p<y*y+A*A+z*z:0):0){iE(12515);if((c[(c[k+192>>2]|0)+4>>2]|0)<20?(c[800]=(c[800]|0)+1,j=c[d+68>>2]|0,j=Hb[c[(c[j>>2]|0)+36>>2]&127](j)|0,m=c[d+24>>2]|0,g[B+368+4>>2]=1.0,b[B+368+8>>1]=1,b[B+368+10>>1]=-1,c[B+368>>2]=2932,c[B+368+12>>2]=c[k+52>>2],c[B+368+12+4>>2]=c[k+52+4>>2],c[B+368+12+8>>2]=c[k+52+8>>2],c[B+368+12+12>>2]=c[k+52+12>>2],c[B+368+28>>2]=c[s>>2],c[B+368+28+4>>2]=c[s+4>>2],c[B+368+28+8>>2]=c[s+8>>2],c[B+368+28+12>>2]=c[s+12>>2],c[B+368+76>>2]=0,c[B+368>>2]=3232,c[B+368+80>>2]=k,c[B+368+88>>2]=j,c[B+368+92>>2]=m,m=c[k+248>>2]|0,c[B+248+8>>2]=0,c[B+248+12>>2]=1065353216,c[B+248+16>>2]=1065353216,c[B+248+20>>2]=1065353216,g[B+248+24>>2]=0.0,c[B+248>>2]=6904,c[B+248+4>>2]=8,c[B+248+28>>2]=m,c[B+248+44>>2]=m,c[B+368+84>>2]=c[d+56>>2],m=c[k+188>>2]|0,b[B+368+8>>1]=b[m+4>>1]|0,b[B+368+10>>1]=b[m+6>>1]|0,c[B+184+48>>2]=c[s>>2],c[B+184+48+4>>2]=c[s+4>>2],c[B+184+48+8>>2]=c[s+8>>2],c[B+184+48+12>>2]=c[s+12>>2],c[B+184>>2]=c[k+4>>2],c[B+184+4>>2]=c[k+4+4>>2],c[B+184+8>>2]=c[k+4+8>>2],c[B+184+12>>2]=c[k+4+12>>2],c[B+184+16>>2]=c[k+20>>2],c[B+184+16+4>>2]=c[k+20+4>>2],c[B+184+16+8>>2]=c[k+20+8>>2],c[B+184+16+12>>2]=c[k+20+12>>2],c[B+184+32>>2]=c[k+36>>2],c[B+184+32+4>>2]=c[k+36+4>>2],c[B+184+32+8>>2]=c[k+36+8>>2],c[B+184+32+12>>2]=c[k+36+12>>2],gv(d,B+248|0,k+4|0,B+184|0,B+368|0,0.0),w=+g[B+368+4>>2],w<1.0):0){n=w*(t-+g[k+52>>2]);o=w*(u-+g[k+56>>2]);p=w*(v-+g[k+60>>2]);l=-(o*+g[B+368+48>>2])-n*+g[r>>2]-p*+g[B+368+52>>2];m=c[d+24>>2]|0;m=Qb[c[(c[m>>2]|0)+12>>2]&63](m,k,c[B+368+76>>2]|0)|0;h=c[d+308>>2]|0;if((h|0)==(c[d+312>>2]|0)?(x=(h|0)!=0?h<<1:1,(h|0)<(x|0)):0){if(!x)f=0;else{c[2703]=(c[2703]|0)+1;h=XE((x<<2|3)+16|0)|0;if(!h)f=0;else{c[(h+4+15&-16)+-4>>2]=h;f=h+4+15&-16}h=c[d+308>>2]|0}if((h|0)>0){j=0;do{c[f+(j<<2)>>2]=c[(c[d+316>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[d+316>>2]|0;if(j){if(a[d+320>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0);h=c[d+308>>2]|0}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=f;c[d+312>>2]=x}c[(c[d+316>>2]|0)+(h<<2)>>2]=m;c[d+308>>2]=h+1;n=n+ +g[k+52>>2];o=o+ +g[k+56>>2];p=p+ +g[k+60>>2];j=c[B+368+76>>2]|0;N=+g[j+4>>2];M=+g[j+20>>2];L=+g[j+36>>2];K=+g[j+8>>2];J=+g[j+24>>2];I=+g[j+40>>2];H=+g[j+12>>2];F=+g[j+28>>2];D=+g[j+44>>2];G=-+g[j+52>>2];E=-+g[j+56>>2];C=-+g[j+60>>2];c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;c[B+12>>2]=0;g[B+16>>2]=n*N+o*M+p*L+(N*G+M*E+L*C);g[B+20>>2]=n*K+o*J+p*I+(K*G+J*E+I*C);g[B+24>>2]=n*H+o*F+p*D+(H*G+F*E+D*C);g[B+28>>2]=0.0;c[B+64>>2]=c[r>>2];c[B+64+4>>2]=c[r+4>>2];c[B+64+8>>2]=c[r+8>>2];c[B+64+12>>2]=c[r+12>>2];g[B+80>>2]=l;g[B+84>>2]=0.0;g[B+88>>2]=0.0;g[B+92>>2]=0.0;c[B+112>>2]=0;a[B+116>>0]=0;c[B+120>>2]=0;c[B+120+4>>2]=0;c[B+120+8>>2]=0;c[B+120+12>>2]=0;c[B+120+16>>2]=0;c[B+120+20>>2]=0;c[B+120+24>>2]=0;c[B+120+28>>2]=0;j=Ms(m,B)|0;g[m+4+(j*184|0)+92>>2]=0.0;l=+g[k+224>>2]*+g[(c[B+368+76>>2]|0)+224>>2];l=l<-10.0?-10.0:l;g[m+4+(j*184|0)+84>>2]=l>10.0?10.0:l;c[m+4+(j*184|0)+48>>2]=c[k+52>>2];c[m+4+(j*184|0)+48+4>>2]=c[k+52+4>>2];c[m+4+(j*184|0)+48+8>>2]=c[k+52+8>>2];c[m+4+(j*184|0)+48+12>>2]=c[k+52+12>>2];g[m+4+(j*184|0)+32>>2]=n;g[m+4+(j*184|0)+36>>2]=o;g[m+4+(j*184|0)+40>>2]=p;g[m+4+(j*184|0)+44>>2]=0.0}h=c[2700]|0;m=(c[h+16>>2]|0)+-1|0;c[h+16>>2]=m;if(!m){if(c[h+4>>2]|0){vb(B+368|0,0)|0;m=c[2702]|0;g[h+8>>2]=+(((c[B+368+4>>2]|0)-(c[m+4>>2]|0)+(((c[B+368>>2]|0)-(c[m>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0)/1.0e3+ +g[h+8>>2];if(c[h+16>>2]|0)break b;h=c[2700]|0}c[2700]=c[h+20>>2]}}}while(0);q=q+1|0;if((q|0)>=(c[d+232>>2]|0))break a}}while(0);f=c[2700]|0;r=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=r;do if(!r){if(c[f+4>>2]|0){vb(B+368|0,0)|0;r=c[2702]|0;g[f+8>>2]=+(((c[B+368+4>>2]|0)-(c[r+4>>2]|0)+(((c[B+368>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[2700]|0}c[2700]=c[f+20>>2]}while(0);Db[c[(c[d>>2]|0)+44>>2]&255](d);Db[c[(c[d>>2]|0)+148>>2]&255](d);g[d+104>>2]=e;Fb[c[(c[d>>2]|0)+152>>2]&127](d,d+92|0);Cb[c[(c[d>>2]|0)+144>>2]&31](d,e);iE(12439);if((c[d+280>>2]|0)>0){f=0;do{r=c[(c[d+288>>2]|0)+(f<<2)>>2]|0;lc[c[(c[r>>2]|0)+8>>2]&7](r,d,e);f=f+1|0}while((f|0)<(c[d+280>>2]|0))}f=c[2700]|0;r=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=r;do if(!r){if(c[f+4>>2]|0){vb(B+368|0,0)|0;r=c[2702]|0;g[f+8>>2]=+(((c[B+368+4>>2]|0)-(c[r+4>>2]|0)+(((c[B+368>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[2700]|0}c[2700]=c[f+20>>2]}while(0);Cb[c[(c[d>>2]|0)+156>>2]&31](d,e);f=c[d+80>>2]|0;if(f)Cb[f&31](d,e);f=c[2700]|0;r=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=r;if(r){i=B;return}do if(c[f+4>>2]|0){vb(B+368|0,0)|0;r=c[2702]|0;g[f+8>>2]=+(((c[B+368+4>>2]|0)-(c[r+4>>2]|0)+(((c[B+368>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(!(c[f+16>>2]|0)){f=c[2700]|0;break}else{i=B;return}}while(0);c[2700]=c[f+20>>2];i=B;return}function Op(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0,h=0,i=0.0,j=0.0;c[a+248>>2]=c[b>>2];c[a+248+4>>2]=c[b+4>>2];c[a+248+8>>2]=c[b+8>>2];c[a+248+12>>2]=c[b+12>>2];d=c[a+232>>2]|0;if((d|0)<=0)return;h=0;do{f=c[(c[a+240>>2]|0)+(h<<2)>>2]|0;switch(c[f+216>>2]|0){case 2:case 5:break;default:if(!(c[f+504>>2]&1)){e=+g[f+344>>2];if(e!=0.0){j=1.0/e*+g[b+4>>2];i=1.0/e*+g[b+8>>2];g[f+364>>2]=1.0/e*+g[b>>2];g[f+368>>2]=j;g[f+372>>2]=i;g[f+376>>2]=0.0}c[f+380>>2]=c[b>>2];c[f+380+4>>2]=c[b+4>>2];c[f+380+8>>2]=c[b+8>>2];c[f+380+12>>2]=c[b+12>>2];d=c[a+232>>2]|0}}h=h+1|0}while((h|0)<(d|0));return}function Pp(a,b){a=a|0;b=b|0;c[a>>2]=c[b+248>>2];c[a+4>>2]=c[b+248+4>>2];c[a+8>>2]=c[b+248+8>>2];c[a+12>>2]=c[b+248+12>>2];return}function Qp(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;_u(a,b,c,d);return}function Rp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;if(!((b|0)==0?1:(c[b+236>>2]&2|0)==0)){Fb[c[(c[a>>2]|0)+92>>2]&127](a,b);return}d=c[b+188>>2]|0;if(d){e=c[a+68>>2]|0;e=Hb[c[(c[e>>2]|0)+36>>2]&127](e)|0;jc[c[(c[e>>2]|0)+40>>2]&127](e,d,c[a+24>>2]|0);e=c[a+68>>2]|0;jc[c[(c[e>>2]|0)+12>>2]&127](e,d,c[a+24>>2]|0);c[b+188>>2]=0}f=c[a+8>>2]|0;if((f|0)<=0)return;g=c[a+16>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0)){h=11;break}}if((h|0)==11)return;if((d|0)>=(f|0))return;c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+16>>2]|0)+(f+-1<<2)>>2]=b;c[a+8>>2]=f+-1;return}function Sp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;f=c[a+232>>2]|0;a:do if((f|0)>0){g=c[a+240>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0))break a}if((d|0)<(f|0)){c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+240>>2]|0)+(f+-1<<2)>>2]=b;c[a+232>>2]=f+-1}}while(0);d=c[b+188>>2]|0;if(d){e=c[a+68>>2]|0;e=Hb[c[(c[e>>2]|0)+36>>2]&127](e)|0;jc[c[(c[e>>2]|0)+40>>2]&127](e,d,c[a+24>>2]|0);e=c[a+68>>2]|0;jc[c[(c[e>>2]|0)+12>>2]&127](e,d,c[a+24>>2]|0);c[b+188>>2]=0}g=c[a+8>>2]|0;if((g|0)<=0)return;f=c[a+16>>2]|0;d=0;while(1){e=f+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(g|0)){h=15;break}}if((h|0)==15)return;if((d|0)>=(g|0))return;c[e>>2]=c[f+(g+-1<<2)>>2];c[(c[a+16>>2]|0)+(g+-1<<2)>>2]=b;c[a+8>>2]=g+-1;return}function Tp(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0,j=0,k=0.0,l=0.0;e=c[d+204>>2]|0;if((e&3|0)==0?(c[d+504>>2]&1|0)==0:0){h=+g[d+344>>2];if(h!=0.0){l=1.0/h*+g[b+252>>2];k=1.0/h*+g[b+256>>2];g[d+364>>2]=1.0/h*+g[b+248>>2];g[d+368>>2]=l;g[d+372>>2]=k;g[d+376>>2]=0.0}c[d+380>>2]=c[b+248>>2];c[d+380+4>>2]=c[b+248+4>>2];c[d+380+8>>2]=c[b+248+8>>2];c[d+380+12>>2]=c[b+248+12>>2]}if(!(c[d+192>>2]|0))return;if(e&1){if((c[d+216>>2]&-2|0)!=4)c[d+216>>2]=2}else{f=c[b+232>>2]|0;if((f|0)==(c[b+236>>2]|0)?(j=(f|0)!=0?f<<1:1,(f|0)<(j|0)):0){if(!j)e=0;else{c[2703]=(c[2703]|0)+1;f=XE((j<<2|3)+16|0)|0;if(!f)e=0;else{c[(f+4+15&-16)+-4>>2]=f;e=f+4+15&-16}f=c[b+232>>2]|0}if((f|0)>0){i=0;do{c[e+(i<<2)>>2]=c[(c[b+240>>2]|0)+(i<<2)>>2];i=i+1|0}while((i|0)!=(f|0))}i=c[b+240>>2]|0;if(i){if(a[b+244>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[i+-4>>2]|0);f=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=e;c[b+236>>2]=j;e=c[d+204>>2]|0}c[(c[b+240>>2]|0)+(f<<2)>>2]=d;c[b+232>>2]=f+1}e=(e&3|0)==0;nc[c[(c[b>>2]|0)+36>>2]&127](b,d,e?1:2,e?-1:-3);return}function Up(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0,k=0,l=0,m=0.0,n=0.0;h=c[d+204>>2]|0;if((h&3|0)==0?(c[d+504>>2]&1|0)==0:0){i=+g[d+344>>2];if(i!=0.0){n=1.0/i*+g[b+252>>2];m=1.0/i*+g[b+256>>2];g[d+364>>2]=1.0/i*+g[b+248>>2];g[d+368>>2]=n;g[d+372>>2]=m;g[d+376>>2]=0.0}c[d+380>>2]=c[b+248>>2];c[d+380+4>>2]=c[b+248+4>>2];c[d+380+8>>2]=c[b+248+8>>2];c[d+380+12>>2]=c[b+248+12>>2]}if(!(c[d+192>>2]|0))return;if(h&1){if((c[d+216>>2]&-2|0)!=4)c[d+216>>2]=2}else{h=c[b+232>>2]|0;if((h|0)==(c[b+236>>2]|0)?(l=(h|0)!=0?h<<1:1,(h|0)<(l|0)):0){if(!l)j=0;else{c[2703]=(c[2703]|0)+1;h=XE((l<<2|3)+16|0)|0;if(!h)j=0;else{c[(h+4+15&-16)+-4>>2]=h;j=h+4+15&-16}h=c[b+232>>2]|0}if((h|0)>0){k=0;do{c[j+(k<<2)>>2]=c[(c[b+240>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(h|0))}k=c[b+240>>2]|0;if(k){if(a[b+244>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[k+-4>>2]|0);h=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=j;c[b+236>>2]=l}c[(c[b+240>>2]|0)+(h<<2)>>2]=d;c[b+232>>2]=h+1}nc[c[(c[b>>2]|0)+36>>2]&127](b,d,e,f);return}function Vp(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0;m=i;i=i+16|0;iE(12542);e=c[b+232>>2]|0;if((e|0)>0){l=(a[12294]|0)==0;k=0;do{j=c[(c[b+240>>2]|0)+(k<<2)>>2]|0;a:do if(j){f=c[j+216>>2]|0;b:do switch(f|0){case 4:case 2:{if((f|0)==4)break a;else h=f;break}default:{q=+g[j+312>>2];p=+g[j+316>>2];o=+g[j+320>>2];n=+g[j+472>>2];if(q*q+p*p+o*o<n*n?(q=+g[j+328>>2],p=+g[j+332>>2],o=+g[j+336>>2],n=+g[j+476>>2],q*q+p*p+o*o<n*n):0){g[j+220>>2]=+g[j+220>>2]+d;h=f;break b}g[j+220>>2]=0.0;if((f&-2|0)==4)h=f;else{c[j+216>>2]=0;h=0}}}while(0);f=h&-2;do if(l){if((f|0)!=2?!(+g[j+220>>2]>2.0):0)break;if(c[j+204>>2]&3){if((f|0)==4)break a;c[j+216>>2]=2;break a}if((h|0)==1){if((f|0)==4)break a;c[j+216>>2]=3;break a}else{if((h|0)!=2)break a;e=(c[j+260>>2]|0)+2|0;c[j+328>>2]=0;c[j+328+4>>2]=0;c[j+328+8>>2]=0;c[j+328+12>>2]=0;c[j+260>>2]=e;c[j+312>>2]=0;c[j+312+4>>2]=0;c[j+312+8>>2]=0;c[j+312+12>>2]=0;e=c[b+232>>2]|0;break a}}while(0);if((f|0)!=4)c[j+216>>2]=1}while(0);k=k+1|0}while((k|0)<(e|0))}e=c[2700]|0;f=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=f;if(f){i=m;return}do if(c[e+4>>2]|0){vb(m|0,0)|0;f=c[2702]|0;g[e+8>>2]=+(((c[m+4>>2]|0)-(c[f+4>>2]|0)+(((c[m>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(!(c[e+16>>2]|0)){e=c[2700]|0;break}else{i=m;return}}while(0);c[2700]=c[e+20>>2];i=m;return}function Wp(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=c[b+212>>2]|0;if((f|0)==(c[b+216>>2]|0)?(i=(f|0)!=0?f<<1:1,(f|0)<(i|0)):0){if(!i)g=0;else{c[2703]=(c[2703]|0)+1;f=XE((i<<2|3)+16|0)|0;if(!f)g=0;else{c[(f+4+15&-16)+-4>>2]=f;g=f+4+15&-16}f=c[b+212>>2]|0}if((f|0)>0){h=0;do{c[g+(h<<2)>>2]=c[(c[b+220>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}h=c[b+220>>2]|0;if(h){if(a[b+224>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0);f=c[b+212>>2]|0}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=g;c[b+216>>2]=i}c[(c[b+220>>2]|0)+(f<<2)>>2]=d;c[b+212>>2]=f+1;if(!e)return;wp(c[d+28>>2]|0,d);wp(c[d+32>>2]|0,d);return}function Xp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;f=c[a+212>>2]|0;a:do if((f|0)>0){g=c[a+220>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0))break a}if((d|0)<(f|0)){c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+220>>2]|0)+(f+-1<<2)>>2]=b;c[a+212>>2]=f+-1}}while(0);a=c[b+28>>2]|0;d=c[a+488>>2]|0;b:do if((d|0)>0){g=c[a+496>>2]|0;e=0;while(1){f=g+(e<<2)|0;if((c[f>>2]|0)==(b|0))break;e=e+1|0;if((e|0)>=(d|0))break b}if((e|0)<(d|0)){c[f>>2]=c[g+(d+-1<<2)>>2];c[(c[a+496>>2]|0)+(d+-1<<2)>>2]=b;c[a+488>>2]=d+-1;d=d+-1|0}}while(0);c[a+256>>2]=(d|0)>0&1;a=c[b+32>>2]|0;d=c[a+488>>2]|0;if((d|0)<=0){e=d;e=(e|0)>0;e=e&1;d=a+256|0;c[d>>2]=e;return}g=c[a+496>>2]|0;e=0;while(1){f=g+(e<<2)|0;if((c[f>>2]|0)==(b|0))break;e=e+1|0;if((e|0)>=(d|0)){h=19;break}}if((h|0)==19){e=(d|0)>0;e=e&1;d=a+256|0;c[d>>2]=e;return}if((e|0)>=(d|0)){e=d;e=(e|0)>0;e=e&1;d=a+256|0;c[d>>2]=e;return}c[f>>2]=c[g+(d+-1<<2)>>2];c[(c[a+496>>2]|0)+(d+-1<<2)>>2]=b;c[a+488>>2]=d+-1;e=d+-1|0;e=(e|0)>0;e=e&1;d=a+256|0;c[d>>2]=e;return}function Yp(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+280>>2]|0;if((e|0)==(c[b+284>>2]|0)?(h=(e|0)!=0?e<<1:1,(e|0)<(h|0)):0){if(!h)f=0;else{c[2703]=(c[2703]|0)+1;e=XE((h<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+4+15&-16)+-4>>2]=e;f=e+4+15&-16}e=c[b+280>>2]|0}if((e|0)>0){g=0;do{c[f+(g<<2)>>2]=c[(c[b+288>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=c[b+288>>2]|0;if(g){if(a[b+292>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[g+-4>>2]|0);e=c[b+280>>2]|0}c[b+288>>2]=0}a[b+292>>0]=1;c[b+288>>2]=f;c[b+284>>2]=h}c[(c[b+288>>2]|0)+(e<<2)>>2]=d;c[b+280>>2]=e+1;return}function Zp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;f=c[a+280>>2]|0;if((f|0)<=0)return;g=c[a+288>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0)){h=7;break}}if((h|0)==7)return;if((d|0)>=(f|0))return;c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+288>>2]|0)+(f+-1<<2)>>2]=b;c[a+280>>2]=f+-1;return}function _p(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function $p(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+68>>2]&127](a,b);return}function aq(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function bq(a,b){a=a|0;b=b|0;Fb[c[(c[a>>2]|0)+68>>2]&127](a,b);return}function cq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;v=i;i=i+16|0;iE(12564);k=c[b+212>>2]|0;j=c[b+180>>2]|0;if((j|0)<(k|0)){if((c[b+184>>2]|0)<(k|0)){if(!k){e=j;h=0}else{c[2703]=(c[2703]|0)+1;f=XE((k<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}e=c[b+180>>2]|0;h=f}if((e|0)>0){f=0;do{c[h+(f<<2)>>2]=c[(c[b+188>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}f=c[b+188>>2]|0;if(f){if(a[b+192>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[b+188>>2]=0}a[b+192>>0]=1;c[b+188>>2]=h;c[b+184>>2]=k;e=b+188|0}else e=b+188|0;f=j;do{c[(c[e>>2]|0)+(f<<2)>>2]=0;f=f+1|0}while((f|0)!=(k|0))}c[b+180>>2]=k;e=0;while(1){if((e|0)>=(Hb[c[(c[b>>2]|0)+104>>2]&127](b)|0))break;c[(c[b+188>>2]|0)+(e<<2)>>2]=c[(c[b+220>>2]|0)+(e<<2)>>2];e=e+1|0}e=c[b+180>>2]|0;if((e|0)>1)mq(b+176|0,0,e+-1|0);if(!(Hb[c[(c[b>>2]|0)+104>>2]&127](b)|0))e=0;else e=c[b+188>>2]|0;k=c[b+196>>2]|0;o=c[b+180>>2]|0;p=Hb[c[(c[b>>2]|0)+20>>2]&127](b)|0;c[k+4>>2]=d;c[k+12>>2]=e;c[k+16>>2]=o;c[k+20>>2]=p;e=c[k+32>>2]|0;if((e|0)<0){if((c[k+36>>2]|0)<0){f=c[k+40>>2]|0;if(f){if(a[k+44>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[k+40>>2]=0}a[k+44>>0]=1;c[k+40>>2]=0;c[k+36>>2]=0}do{c[(c[k+40>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[k+32>>2]=0;e=c[k+52>>2]|0;if((e|0)<0){if((c[k+56>>2]|0)<0){f=c[k+60>>2]|0;if(f){if(a[k+64>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[k+60>>2]=0}a[k+64>>0]=1;c[k+60>>2]=0;c[k+56>>2]=0}do{c[(c[k+60>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[k+52>>2]=0;e=c[k+72>>2]|0;if((e|0)<0){if((c[k+76>>2]|0)<0){f=c[k+80>>2]|0;if(f){if(a[k+84>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[k+80>>2]=0}a[k+84>>0]=1;c[k+80>>2]=0;c[k+76>>2]=0}do{c[(c[k+80>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[k+72>>2]=0;u=c[b+200>>2]|0;f=c[(c[u>>2]|0)+8>>2]|0;r=c[b+8>>2]|0;t=c[b+24>>2]|0;t=Hb[c[(c[t>>2]|0)+36>>2]&127](t)|0;jc[f&127](u,r,t);t=c[b+204>>2]|0;r=c[b+24>>2]|0;u=c[b+196>>2]|0;iE(14326);f=c[t+28>>2]|0;if((f|0)<0){if((c[t+32>>2]|0)<0){e=c[t+36>>2]|0;if(e){if(a[t+40>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[t+36>>2]=0}a[t+40>>0]=1;c[t+36>>2]=0;c[t+32>>2]=0}do{c[(c[t+36>>2]|0)+(f<<2)>>2]=0;f=f+1|0}while((f|0)!=0)}c[t+28>>2]=0;f=c[t+8>>2]|0;if((f|0)>0){e=c[t+16>>2]|0;l=0;do{m=e+(l<<3)|0;h=c[m>>2]|0;if((h|0)==(l|0))h=l;else{j=m;do{k=e+(h<<3)|0;c[j>>2]=c[k>>2];k=c[k>>2]|0;j=e+(k<<3)|0;h=c[j>>2]|0}while((k|0)!=(h|0));h=k}c[m>>2]=h;l=l+1|0}while((l|0)!=(f|0));if((f|0)>1){sw(t+4|0,0,f+-1|0);f=c[t+8>>2]|0}if((f|0)>0){o=c[t+16>>2]|0;h=o;l=0;while(1){n=c[o+(l<<3)>>2]|0;q=l;while(1){q=q+1|0;if((q|0)>=(f|0)){p=0;break}if((c[o+(q<<3)>>2]|0)!=(n|0)){p=1;break}}if((l|0)<(q|0)){e=c[b+16>>2]|0;m=1;j=l;do{k=c[e+(c[o+(j<<3)+4>>2]<<2)>>2]|0;if((c[k+208>>2]|0)==(n|0)){k=c[k+216>>2]|0;m=(k|0)!=4&(m&(k|0)!=1)}j=j+1|0}while((j|0)!=(q|0));if(m)while(1){k=c[e+(c[o+(l<<3)+4>>2]<<2)>>2]|0;if((c[k+208>>2]|0)==(n|0)?(c[k+216>>2]&-2|0)!=4:0)c[k+216>>2]=2;l=l+1|0;if((l|0)>=(q|0))break;else h=o}else{m=o;while(1){k=c[e+(c[m+(l<<3)+4>>2]<<2)>>2]|0;if((c[k+208>>2]|0)==(n|0)?(c[k+216>>2]|0)==2:0){c[k+216>>2]=3;g[k+220>>2]=0.0}l=l+1|0;if((l|0)>=(q|0))break;else m=h}}}if(p)l=q;else break}}}n=Hb[c[(c[r>>2]|0)+36>>2]&127](r)|0;if((n|0)>0){l=0;do{m=_b[c[(c[r>>2]|0)+40>>2]&31](r,l)|0;k=c[m+740>>2]|0;h=c[m+744>>2]|0;if((k|0)!=0?(c[k+216>>2]|0)!=2:0)j=89;else j=87;if(((j|0)==87?(j=0,(h|0)!=0):0)?(c[h+216>>2]|0)!=2:0)j=89;if((j|0)==89){j=c[k+204>>2]|0;if(((j&2|0)!=0?((j&4|0)==0?(c[k+216>>2]|0)!=2:0):0)?(c[h+204>>2]&3|0)==0:0){if((c[h+216>>2]&-2|0)!=4)c[h+216>>2]=1;g[h+220>>2]=0.0}p=c[h+204>>2]|0;if((p&2|0)!=0?((p&4|0)==0?(c[h+216>>2]|0)!=2:0)&(j&3|0)==0:0){if((c[k+216>>2]&-2|0)!=4)c[k+216>>2]=1;g[k+220>>2]=0.0}if((a[t+64>>0]|0)!=0?Qb[c[(c[r>>2]|0)+28>>2]&63](r,k,h)|0:0){h=c[t+28>>2]|0;if((h|0)==(c[t+32>>2]|0)?(s=(h|0)!=0?h<<1:1,(h|0)<(s|0)):0){if(!s)f=0;else{c[2703]=(c[2703]|0)+1;h=XE((s<<2|3)+16|0)|0;if(!h)f=0;else{c[(h+4+15&-16)+-4>>2]=h;f=h+4+15&-16}h=c[t+28>>2]|0}if((h|0)>0){j=0;do{c[f+(j<<2)>>2]=c[(c[t+36>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[t+36>>2]|0;if(j){if(a[t+40>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0);h=c[t+28>>2]|0}c[t+36>>2]=0}a[t+40>>0]=1;c[t+36>>2]=f;c[t+32>>2]=s}c[(c[t+36>>2]|0)+(h<<2)>>2]=m;c[t+28>>2]=h+1}}l=l+1|0}while((l|0)<(n|0))}e=c[2700]|0;p=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=p;do if(!p){if(c[e+4>>2]|0){vb(v|0,0)|0;p=c[2702]|0;g[e+8>>2]=+(((c[v+4>>2]|0)-(c[p+4>>2]|0)+(((c[v>>2]|0)-(c[p>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(c[e+16>>2]|0)break;e=c[2700]|0}c[2700]=c[e+20>>2]}while(0);s=c[t+8>>2]|0;iE(14354);if(a[t+64>>0]|0){p=c[t+28>>2]|0;if((p|0)>1)Zt(t+24|0,0,p+-1|0);if((s|0)>0){e=1;k=0;r=0;while(1){h=c[t+16>>2]|0;o=c[h+(k<<3)>>2]|0;a:do if((k|0)<(s|0)){f=c[t+48>>2]|0;j=c[t+52>>2]|0;l=k;q=1;while(1){h=c[(c[b+16>>2]|0)+(c[h+(l<<3)+4>>2]<<2)>>2]|0;do if((f|0)==(j|0)){n=(j|0)!=0?j<<1:1;if((j|0)>=(n|0)){k=j;break}if(!n){k=j;m=0}else{c[2703]=(c[2703]|0)+1;k=XE((n<<2|3)+16|0)|0;if(!k)m=0;else{c[(k+4+15&-16)+-4>>2]=k;m=k+4+15&-16}k=c[t+48>>2]|0}if((k|0)>0){j=0;do{c[m+(j<<2)>>2]=c[(c[t+56>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(k|0))}j=c[t+56>>2]|0;if(j){if(a[t+60>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0);k=c[t+48>>2]|0}c[t+56>>2]=0}a[t+60>>0]=1;c[t+56>>2]=m;c[t+52>>2]=n;j=n}else k=f;while(0);c[(c[t+56>>2]|0)+(k<<2)>>2]=h;f=k+1|0;c[t+48>>2]=f;m=c[h+216>>2]|0;m=q&((m|0)==2|(m|0)==5);l=l+1|0;if((l|0)>=(s|0))break a;h=c[t+16>>2]|0;if((c[h+(l<<3)>>2]|0)!=(o|0))break;else q=m}}else{l=k;m=1}while(0);if((r|0)<(p|0)){n=c[t+36>>2]|0;k=n+(r<<2)|0;h=c[k>>2]|0;j=c[(c[h+740>>2]|0)+208>>2]|0;if((j|0)<=-1)j=c[(c[h+744>>2]|0)+208>>2]|0;if((j|0)==(o|0)){f=r;do{f=f+1|0;if((f|0)>=(p|0))break;h=c[n+(f<<2)>>2]|0;j=c[(c[h+740>>2]|0)+208>>2]|0;if((j|0)<=-1)j=c[(c[h+744>>2]|0)+208>>2]|0}while((o|0)==(j|0));e=f;j=f-r|0}else{j=0;k=0}}else{j=0;k=0}if(!m)Rb[c[(c[u>>2]|0)+8>>2]&7](u,c[t+56>>2]|0,c[t+48>>2]|0,k,j,o);r=(j|0)==0?r:e;h=c[t+48>>2]|0;if((h|0)<0){if((c[t+52>>2]|0)<0){f=c[t+56>>2]|0;if(f){if(a[t+60>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[t+56>>2]=0}a[t+60>>0]=1;c[t+56>>2]=0;c[t+52>>2]=0}do{c[(c[t+56>>2]|0)+(h<<2)>>2]=0;h=h+1|0}while((h|0)!=0)}c[t+48>>2]=0;if((l|0)>=(s|0))break;else k=l}}}else{o=Hb[c[(c[r>>2]|0)+44>>2]&127](r)|0;p=Hb[c[(c[r>>2]|0)+36>>2]&127](r)|0;Rb[c[(c[u>>2]|0)+8>>2]&7](u,c[b+16>>2]|0,c[b+8>>2]|0,o,p,-1)}e=c[2700]|0;p=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=p;do if(!p){if(c[e+4>>2]|0){vb(v|0,0)|0;p=c[2702]|0;g[e+8>>2]=+(((c[v+4>>2]|0)-(c[p+4>>2]|0)+(((c[v>>2]|0)-(c[p>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(c[e+16>>2]|0)break;e=c[2700]|0}c[2700]=c[e+20>>2]}while(0);nq(c[b+196>>2]|0);e=c[b+200>>2]|0;jc[c[(c[e>>2]|0)+16>>2]&127](e,d,c[b+72>>2]|0);e=c[2700]|0;p=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=p;if(p){i=v;return}do if(c[e+4>>2]|0){vb(v|0,0)|0;p=c[2702]|0;g[e+8>>2]=+(((c[v+4>>2]|0)-(c[p+4>>2]|0)+(((c[v>>2]|0)-(c[p>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(!(c[e+16>>2]|0)){e=c[2700]|0;break}else{i=v;return}}while(0);c[2700]=c[e+20>>2];i=v;return}function dq(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+16|0;iE(12581);m=c[b+204>>2]|0;jc[c[(c[m>>2]|0)+8>>2]&127](m,b,c[b+24>>2]|0);m=c[b+308>>2]|0;if((m|0)>0){l=c[b+316>>2]|0;k=0;do{e=c[l+(k<<2)>>2]|0;d=c[e+740>>2]|0;e=c[e+744>>2]|0;if(((d|0)!=0?((e|0)!=0?(c[d+204>>2]&3|0)==0:0):0)?(c[e+204>>2]&3|0)==0:0){f=c[d+208>>2]|0;e=c[e+208>>2]|0;j=c[(c[b+204>>2]|0)+16>>2]|0;d=c[j+(f<<3)>>2]|0;if((d|0)!=(f|0)){h=j+(f<<3)|0;do{f=j+(d<<3)|0;c[h>>2]=c[f>>2];f=c[f>>2]|0;h=j+(f<<3)|0;d=c[h>>2]|0}while((f|0)!=(d|0))}d=c[j+(e<<3)>>2]|0;if((d|0)!=(e|0)){h=j+(e<<3)|0;do{e=j+(d<<3)|0;c[h>>2]=c[e>>2];e=c[e>>2]|0;h=j+(e<<3)|0;d=c[h>>2]|0}while((e|0)!=(d|0))}if((f|0)!=(e|0)){c[j+(f<<3)>>2]=e;h=j+(e<<3)+4|0;c[h>>2]=(c[h>>2]|0)+(c[j+(f<<3)+4>>2]|0)}}k=k+1|0}while((k|0)!=(m|0))}l=c[b+212>>2]|0;if((l|0)>0){k=c[b+220>>2]|0;m=0;do{d=c[k+(m<<2)>>2]|0;if(((a[d+20>>0]|0)!=0?(o=c[d+28>>2]|0,(c[o+204>>2]&3|0)==0):0)?(n=c[d+32>>2]|0,(c[n+204>>2]&3|0)==0):0){f=c[o+208>>2]|0;e=c[n+208>>2]|0;j=c[(c[b+204>>2]|0)+16>>2]|0;d=c[j+(f<<3)>>2]|0;if((d|0)!=(f|0)){h=j+(f<<3)|0;do{f=j+(d<<3)|0;c[h>>2]=c[f>>2];f=c[f>>2]|0;h=j+(f<<3)|0;d=c[h>>2]|0}while((f|0)!=(d|0))}d=c[j+(e<<3)>>2]|0;if((d|0)!=(e|0)){h=j+(e<<3)|0;do{e=j+(d<<3)|0;c[h>>2]=c[e>>2];e=c[e>>2]|0;h=j+(e<<3)|0;d=c[h>>2]|0}while((e|0)!=(d|0))}if((f|0)!=(e|0)){c[j+(f<<3)>>2]=e;h=j+(e<<3)+4|0;c[h>>2]=(c[h>>2]|0)+(c[j+(f<<3)+4>>2]|0)}}m=m+1|0}while((m|0)!=(l|0))}d=c[b+204>>2]|0;Fb[c[(c[d>>2]|0)+12>>2]&127](d,b);d=c[2700]|0;o=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=o;if(o){i=p;return}do if(c[d+4>>2]|0){vb(p|0,0)|0;o=c[2702]|0;g[d+8>>2]=+(((c[p+4>>2]|0)-(c[o+4>>2]|0)+(((c[p>>2]|0)-(c[o>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[2700]|0;break}else{i=p;return}}while(0);c[2700]=c[d+20>>2];i=p;return}function eq(d,e){d=d|0;e=+e;var f=0,h=0.0,j=0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0,t=0.0,u=0;s=i;i=i+352|0;iE(12608);a:do if((c[d+232>>2]|0)>0){o=s+184+48|0;n=0;while(1){m=c[(c[d+240>>2]|0)+(n<<2)>>2]|0;g[m+244>>2]=1.0;b:do switch(c[m+216>>2]|0){case 2:case 5:break;default:if(!(c[m+204>>2]&3)){Ap(m+4|0,+g[m+312>>2],+g[m+316>>2],+g[m+320>>2],m+328|0,e,s+184|0);h=+g[o>>2]-+g[m+52>>2];l=+g[s+184+52>>2]-+g[m+56>>2];k=+g[s+184+56>>2]-+g[m+60>>2];if((a[d+44>>0]|0)!=0?(t=+g[m+252>>2],t*t!=0.0?t*t<h*h+l*l+k*k:0):0){iE(12628);if((c[(c[m+192>>2]|0)+4>>2]|0)<20){c[800]=(c[800]|0)+1;j=c[d+68>>2]|0;j=Hb[c[(c[j>>2]|0)+36>>2]&127](j)|0;f=c[d+24>>2]|0;g[s+248+4>>2]=1.0;b[s+248+8>>1]=1;b[s+248+10>>1]=-1;c[s+248>>2]=2932;c[s+248+12>>2]=c[m+52>>2];c[s+248+12+4>>2]=c[m+52+4>>2];c[s+248+12+8>>2]=c[m+52+8>>2];c[s+248+12+12>>2]=c[m+52+12>>2];c[s+248+28>>2]=c[o>>2];c[s+248+28+4>>2]=c[o+4>>2];c[s+248+28+8>>2]=c[o+8>>2];c[s+248+28+12>>2]=c[o+12>>2];c[s+248+76>>2]=0;c[s+248>>2]=3232;c[s+248+80>>2]=m;c[s+248+88>>2]=j;c[s+248+92>>2]=f;f=c[m+248>>2]|0;c[s+96+8>>2]=0;c[s+96+12>>2]=1065353216;c[s+96+16>>2]=1065353216;c[s+96+20>>2]=1065353216;g[s+96+24>>2]=0.0;c[s+96>>2]=6904;c[s+96+4>>2]=8;c[s+96+28>>2]=f;c[s+96+44>>2]=f;c[s+248+84>>2]=c[d+56>>2];f=c[m+188>>2]|0;b[s+248+8>>1]=b[f+4>>1]|0;b[s+248+10>>1]=b[f+6>>1]|0;c[s+16+48>>2]=c[o>>2];c[s+16+48+4>>2]=c[o+4>>2];c[s+16+48+8>>2]=c[o+8>>2];c[s+16+48+12>>2]=c[o+12>>2];c[s+16>>2]=c[m+4>>2];c[s+16+4>>2]=c[m+4+4>>2];c[s+16+8>>2]=c[m+4+8>>2];c[s+16+12>>2]=c[m+4+12>>2];c[s+16+16>>2]=c[m+20>>2];c[s+16+16+4>>2]=c[m+20+4>>2];c[s+16+16+8>>2]=c[m+20+8>>2];c[s+16+16+12>>2]=c[m+20+12>>2];c[s+16+32>>2]=c[m+36>>2];c[s+16+32+4>>2]=c[m+36+4>>2];c[s+16+32+8>>2]=c[m+36+8>>2];c[s+16+32+12>>2]=c[m+36+12>>2];gv(d,s+96|0,m+4|0,s+16|0,s+248|0,0.0);h=+g[s+248+4>>2];if(h<1.0){g[m+244>>2]=h;Ap(m+4|0,+g[m+312>>2],+g[m+316>>2],+g[m+320>>2],m+328|0,h*e,s+184|0);g[m+244>>2]=0.0;up(m,s+184|0);j=4}else j=0;if(!j)p=11}else p=11;if((p|0)==11){p=0;j=0}f=c[2700]|0;u=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=u;do if(!u){if(c[f+4>>2]|0){vb(s+248|0,0)|0;u=c[2702]|0;g[f+8>>2]=+(((c[s+248+4>>2]|0)-(c[u+4>>2]|0)+(((c[s+248>>2]|0)-(c[u>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[2700]|0}c[2700]=c[f+20>>2]}while(0);if(j)break b}up(m,s+184|0)}}while(0);n=n+1|0;if((n|0)>=(c[d+232>>2]|0))break a}}while(0);do if(a[d+275>>0]|0){iE(12648);f=c[d+308>>2]|0;if((f|0)>0){m=0;do{p=c[(c[d+316>>2]|0)+(m<<2)>>2]|0;n=c[p+740>>2]|0;n=(c[n+236>>2]&2|0)==0?0:n;o=c[p+744>>2]|0;o=(c[o+236>>2]&2|0)==0?0:o;j=c[p+748>>2]|0;if((j|0)>0){if(!n){f=0;do{h=+g[57]*+g[o+228>>2];if(h>0.0?(q=+g[p+4+(f*184|0)+120>>2],q!=0.0):0){t=h*(q*+g[p+4+(f*184|0)+64>>2]);k=h*(q*+g[p+4+(f*184|0)+68>>2]);h=h*(q*+g[p+4+(f*184|0)+72>>2]);g[s+168>>2]=-t;g[s+168+4>>2]=-k;g[s+168+8>>2]=-h;g[s+168+12>>2]=0.0;l=+g[p+4+(f*184|0)+52>>2]-+g[n+56>>2];e=+g[p+4+(f*184|0)+56>>2]-+g[n+60>>2];g[s+152>>2]=+g[p+4+(f*184|0)+48>>2]-+g[n+52>>2];g[s+152+4>>2]=l;g[s+152+8>>2]=e;g[s+152+12>>2]=0.0;e=+g[p+4+(f*184|0)+36>>2]-+g[o+56>>2];l=+g[p+4+(f*184|0)+40>>2]-+g[o+60>>2];g[s+80>>2]=+g[p+4+(f*184|0)+32>>2]-+g[o+52>>2];g[s+80+4>>2]=e;g[s+80+8>>2]=l;g[s+80+12>>2]=0.0;g[s>>2]=t;g[s+4>>2]=k;g[s+8>>2]=h;g[s+12>>2]=0.0;Ro(o,s,s+80|0);j=c[p+748>>2]|0}f=f+1|0}while((f|0)<(j|0))}else{f=0;do{h=+g[n+228>>2]*+g[o+228>>2];if(h>0.0?(r=+g[p+4+(f*184|0)+120>>2],r!=0.0):0){t=h*(r*+g[p+4+(f*184|0)+64>>2]);k=h*(r*+g[p+4+(f*184|0)+68>>2]);h=h*(r*+g[p+4+(f*184|0)+72>>2]);g[s+168>>2]=-t;g[s+168+4>>2]=-k;g[s+168+8>>2]=-h;g[s+168+12>>2]=0.0;l=+g[p+4+(f*184|0)+52>>2]-+g[n+56>>2];e=+g[p+4+(f*184|0)+56>>2]-+g[n+60>>2];g[s+152>>2]=+g[p+4+(f*184|0)+48>>2]-+g[n+52>>2];g[s+152+4>>2]=l;g[s+152+8>>2]=e;g[s+152+12>>2]=0.0;e=+g[p+4+(f*184|0)+36>>2]-+g[o+56>>2];l=+g[p+4+(f*184|0)+40>>2]-+g[o+60>>2];g[s+80>>2]=+g[p+4+(f*184|0)+32>>2]-+g[o+52>>2];g[s+80+4>>2]=e;g[s+80+8>>2]=l;g[s+80+12>>2]=0.0;Ro(n,s+168|0,s+152|0);g[s>>2]=t;g[s+4>>2]=k;g[s+8>>2]=h;g[s+12>>2]=0.0;Ro(o,s,s+80|0);j=c[p+748>>2]|0}f=f+1|0}while((f|0)<(j|0))}f=c[d+308>>2]|0}m=m+1|0}while((m|0)<(f|0))}f=c[2700]|0;j=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=j;if(!j){if(c[f+4>>2]|0){vb(s+248|0,0)|0;j=c[2702]|0;g[f+8>>2]=+(((c[s+248+4>>2]|0)-(c[j+4>>2]|0)+(((c[s+248>>2]|0)-(c[j>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[2700]|0}c[2700]=c[f+20>>2]}}while(0);f=c[2700]|0;j=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=j;if(j){i=s;return}do if(c[f+4>>2]|0){vb(s+248|0,0)|0;j=c[2702]|0;g[f+8>>2]=+(((c[s+248+4>>2]|0)-(c[j+4>>2]|0)+(((c[s+248>>2]|0)-(c[j>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(!(c[f+16>>2]|0)){f=c[2700]|0;break}else{i=s;return}}while(0);c[2700]=c[f+20>>2];i=s;return}function fq(b,d){b=b|0;d=+d;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0;s=i;i=i+16|0;iE(12686);e=c[b+232>>2]|0;if((e|0)>0){r=0;do{q=c[(c[b+240>>2]|0)+(r<<2)>>2]|0;if(!(c[q+204>>2]&3)){o=+g[q+444>>2];f=+P(+(1.0-o),+d);j=f*+g[q+312>>2];g[q+312>>2]=j;h=f*+g[q+316>>2];g[q+316>>2]=h;f=f*+g[q+320>>2];g[q+320>>2]=f;p=+g[q+448>>2];m=+P(+(1.0-p),+d);k=m*+g[q+328>>2];g[q+328>>2]=k;l=m*+g[q+332>>2];g[q+332>>2]=l;m=m*+g[q+336>>2];g[q+336>>2]=m;do if(a[q+452>>0]|0){if(m*m+(k*k+l*l)<+g[q+464>>2]?j*j+h*h+f*f<+g[q+460>>2]:0){t=+g[q+456>>2];g[q+328>>2]=k*t;g[q+332>>2]=t*l;g[q+336>>2]=t*m;g[q+312>>2]=t*j;g[q+316>>2]=t*h;g[q+320>>2]=t*f;j=t*j;h=t*h;f=t*f;n=k*t;l=t*l;m=t*m}else n=k;k=+O(+(j*j+h*h+f*f));do if(k<o)if(k>.004999999888241291){j=j-j*(1.0/k)*.004999999888241291;g[q+312>>2]=j;h=h-h*(1.0/k)*.004999999888241291;g[q+316>>2]=h;f=f-f*(1.0/k)*.004999999888241291;g[q+320>>2]=f;break}else{c[q+312>>2]=0;c[q+312+4>>2]=0;c[q+312+8>>2]=0;c[q+312+12>>2]=0;j=0.0;h=0.0;f=0.0;break}while(0);k=+O(+(n*n+l*l+m*m));if(k<p)if(k>.004999999888241291){g[q+328>>2]=n-n*(1.0/k)*.004999999888241291;g[q+332>>2]=l-l*(1.0/k)*.004999999888241291;g[q+336>>2]=m-m*(1.0/k)*.004999999888241291;break}else{c[q+328>>2]=0;c[q+328+4>>2]=0;c[q+328+8>>2]=0;c[q+328+12>>2]=0;break}}while(0);Ap(q+4|0,j,h,f,q+328|0,d,q+68|0);e=c[b+232>>2]|0}r=r+1|0}while((r|0)<(e|0))}e=c[2700]|0;r=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=r;if(r){i=s;return}do if(c[e+4>>2]|0){vb(s|0,0)|0;r=c[2702]|0;g[e+8>>2]=+(((c[s+4>>2]|0)-(c[r+4>>2]|0)+(((c[s>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(!(c[e+16>>2]|0)){e=c[2700]|0;break}else{i=s;return}}while(0);c[2700]=c[e+20>>2];i=s;return}function gq(b,d){b=b|0;d=d|0;var e=0;if((a[b+273>>0]|0)!=0?(e=c[b+200>>2]|0,(e|0)!=0):0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}a[b+273>>0]=0;c[b+200>>2]=d;c[(c[b+196>>2]|0)+8>>2]=d;return}function hq(a){a=a|0;return c[a+200>>2]|0}function iq(a){a=a|0;return c[a+212>>2]|0}function jq(a,b){a=a|0;b=b|0;return c[(c[a+220>>2]|0)+(b<<2)>>2]|0}function kq(a,b){a=a|0;b=b|0;return c[(c[a+220>>2]|0)+(b<<2)>>2]|0}function lq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;Db[c[(c[b>>2]|0)+32>>2]&255](b);d=Qb[c[(c[b>>2]|0)+16>>2]&63](b,104,1)|0;e=c[d+8>>2]|0;f=e;g=f+104|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));c[e+88>>2]=c[a+248>>2];c[e+92>>2]=c[a+252>>2];c[e+96>>2]=c[a+256>>2];c[e+100>>2]=c[a+260>>2];c[e>>2]=c[a+92>>2];c[e+4>>2]=c[a+96>>2];c[e+8>>2]=c[a+100>>2];c[e+12>>2]=c[a+104>>2];c[e+16>>2]=c[a+108>>2];c[e+20>>2]=c[a+116>>2];c[e+24>>2]=c[a+120>>2];c[e+28>>2]=c[a+124>>2];c[e+32>>2]=c[a+128>>2];c[e+36>>2]=c[a+132>>2];c[e+40>>2]=c[a+140>>2];c[e+44>>2]=c[a+144>>2];c[e+48>>2]=c[a+148>>2];c[e+52>>2]=c[a+152>>2];c[e+56>>2]=c[a+168>>2];c[e+60>>2]=c[a+172>>2];c[e+64>>2]=c[a+112>>2];c[e+68>>2]=c[a+156>>2];c[e+72>>2]=c[a+160>>2];c[e+76>>2]=c[a+164>>2];c[e+80>>2]=c[a+136>>2];Bb[c[(c[b>>2]|0)+20>>2]&31](b,d,12712,1145853764,e);d=c[a+8>>2]|0;if((d|0)>0){f=0;do{e=c[(c[a+16>>2]|0)+(f<<2)>>2]|0;if(c[e+236>>2]&2){g=Hb[c[(c[e>>2]|0)+16>>2]&127](e)|0;g=Qb[c[(c[b>>2]|0)+16>>2]&63](b,g,1)|0;d=Qb[c[(c[e>>2]|0)+20>>2]&63](e,c[g+8>>2]|0,b)|0;Bb[c[(c[b>>2]|0)+20>>2]&31](b,g,d,1497645650,e);d=c[a+8>>2]|0}f=f+1|0}while((f|0)<(d|0))}if((c[a+212>>2]|0)<=0){kv(a,b);d=c[b>>2]|0;d=d+36|0;d=c[d>>2]|0;Db[d&255](b);return}d=0;do{e=c[(c[a+220>>2]|0)+(d<<2)>>2]|0;g=Hb[c[(c[e>>2]|0)+36>>2]&127](e)|0;g=Qb[c[(c[b>>2]|0)+16>>2]&63](b,g,1)|0;f=Qb[c[(c[e>>2]|0)+40>>2]&63](e,c[g+8>>2]|0,b)|0;Bb[c[(c[b>>2]|0)+20>>2]&31](b,g,f,1397641027,e);d=d+1|0}while((d|0)<(c[a+212>>2]|0));kv(a,b);d=c[b>>2]|0;d=d+36|0;d=c[d>>2]|0;Db[d&255](b);return}function mq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;while(1){l=c[a+12>>2]|0;k=c[l+(((b+d|0)/2|0)<<2)>>2]|0;e=b;f=d;while(1){j=c[(c[k+28>>2]|0)+208>>2]|0;if((j|0)>-1)while(1){h=c[l+(e<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((g|0)<(j|0))e=e+1|0;else break}else{i=c[(c[k+32>>2]|0)+208>>2]|0;while(1){g=c[l+(e<<2)>>2]|0;h=c[(c[g+28>>2]|0)+208>>2]|0;if((h|0)<=-1)h=c[(c[g+32>>2]|0)+208>>2]|0;if((h|0)<(i|0))e=e+1|0;else break}}if((j|0)>-1)while(1){h=c[l+(f<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((j|0)<(g|0))f=f+-1|0;else break}else{i=c[(c[k+32>>2]|0)+208>>2]|0;while(1){h=c[l+(f<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((i|0)<(g|0))f=f+-1|0;else break}}if((e|0)<=(f|0)){i=l+(e<<2)|0;j=c[i>>2]|0;c[i>>2]=c[l+(f<<2)>>2];c[(c[a+12>>2]|0)+(f<<2)>>2]=j;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;l=c[a+12>>2]|0}if((f|0)>(b|0))mq(a,b,f);if((e|0)<(d|0))b=e;else break}return}function nq(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;e=c[b+32>>2]|0;if(!e)g=0;else g=c[b+40>>2]|0;d=c[b+52>>2]|0;if(!d)h=0;else h=c[b+60>>2]|0;f=c[b+72>>2]|0;if(!f)i=0;else i=c[b+80>>2]|0;j=c[b+8>>2]|0;+ac[c[(c[j>>2]|0)+12>>2]&3](j,g,e,h,d,i,f,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);d=c[b+32>>2]|0;if((d|0)<0){if((c[b+36>>2]|0)<0){e=c[b+40>>2]|0;if(e){if(a[b+44>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+36>>2]=0}do{c[(c[b+40>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}c[b+32>>2]=0;d=c[b+52>>2]|0;if((d|0)<0){if((c[b+56>>2]|0)<0){e=c[b+60>>2]|0;if(e){if(a[b+64>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+56>>2]=0}do{c[(c[b+60>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}c[b+52>>2]=0;d=c[b+72>>2]|0;if((d|0)>=0){c[b+72>>2]=0;return}if((c[b+76>>2]|0)<0){e=c[b+80>>2]|0;if(e){if(a[b+84>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=0;c[b+76>>2]=0}do{c[(c[b+80>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0);c[b+72>>2]=0;return}function oq(b){b=b|0;var d=0;c[b>>2]=3212;d=c[b+80>>2]|0;if(d){if(a[b+84>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=0;c[b+72>>2]=0;c[b+76>>2]=0;d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;d=c[b+40>>2]|0;if(!d){a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;d=b+36|0;c[d>>2]=0;return}if(a[b+44>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+40>>2]=0;a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;d=b+36|0;c[d>>2]=0;return}function pq(a){a=a|0;oq(a);YE(a);return}function qq(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((h|0)<0){h=c[b+8>>2]|0;+ac[c[(c[h>>2]|0)+12>>2]&3](h,d,e,f,g,c[b+12>>2]|0,c[b+16>>2]|0,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);return}o=c[b+16>>2]|0;a:do if((o|0)>0){l=c[b+12>>2]|0;k=0;while(1){m=l+(k<<2)|0;i=c[m>>2]|0;j=c[(c[i+28>>2]|0)+208>>2]|0;if((j|0)<=-1)j=c[(c[i+32>>2]|0)+208>>2]|0;if((j|0)==(h|0))break a;k=k+1|0;if((k|0)>=(o|0)){m=0;break}}}else{k=0;m=0}while(0);if((k|0)<(o|0)){n=c[b+12>>2]|0;j=0;do{l=c[n+(k<<2)>>2]|0;i=c[(c[l+28>>2]|0)+208>>2]|0;if((i|0)<=-1)i=c[(c[l+32>>2]|0)+208>>2]|0;j=((i|0)==(h|0)&1)+j|0;k=k+1|0}while((k|0)!=(o|0));h=j}else h=0;i=c[b+4>>2]|0;if((c[i+72>>2]|0)<2){o=c[b+8>>2]|0;+ac[c[(c[o>>2]|0)+12>>2]&3](o,d,e,f,g,m,h,i,c[b+20>>2]|0,c[b+24>>2]|0);return}if((e|0)>0){j=c[b+32>>2]|0;k=c[b+36>>2]|0;i=0;do{n=d+(i<<2)|0;if((j|0)==(k|0)){o=(k|0)!=0?k<<1:1;if((k|0)<(o|0)){if(!o)j=0;else{c[2703]=(c[2703]|0)+1;k=XE((o<<2|3)+16|0)|0;if(!k)j=0;else{c[(k+4+15&-16)+-4>>2]=k;j=k+4+15&-16}k=c[b+32>>2]|0}if((k|0)>0){l=0;do{c[j+(l<<2)>>2]=c[(c[b+40>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(k|0))}l=c[b+40>>2]|0;if(l){if(a[b+44>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[l+-4>>2]|0);k=c[b+32>>2]|0}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=j;c[b+36>>2]=o;j=k;k=o}else j=k}c[(c[b+40>>2]|0)+(j<<2)>>2]=c[n>>2];j=j+1|0;c[b+32>>2]=j;i=i+1|0}while((i|0)!=(e|0))}if((g|0)>0){j=c[b+52>>2]|0;k=c[b+56>>2]|0;l=0;do{o=f+(l<<2)|0;if((j|0)==(k|0)){n=(k|0)!=0?k<<1:1;if((k|0)<(n|0)){if(!n)j=0;else{c[2703]=(c[2703]|0)+1;k=XE((n<<2|3)+16|0)|0;if(!k)j=0;else{c[(k+4+15&-16)+-4>>2]=k;j=k+4+15&-16}k=c[b+52>>2]|0}if((k|0)>0){i=0;do{c[j+(i<<2)>>2]=c[(c[b+60>>2]|0)+(i<<2)>>2];i=i+1|0}while((i|0)!=(k|0))}i=c[b+60>>2]|0;if(i){if(a[b+64>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[i+-4>>2]|0);k=c[b+52>>2]|0}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=j;c[b+56>>2]=n;j=k;k=n}else j=k}c[(c[b+60>>2]|0)+(j<<2)>>2]=c[o>>2];j=j+1|0;c[b+52>>2]=j;l=l+1|0}while((l|0)!=(g|0))}if((h|0)>0){i=c[b+72>>2]|0;j=c[b+76>>2]|0;o=0;do{l=m+(o<<2)|0;if((i|0)==(j|0)){n=(j|0)!=0?j<<1:1;if((j|0)<(n|0)){if(!n){i=j;j=0}else{c[2703]=(c[2703]|0)+1;i=XE((n<<2|3)+16|0)|0;if(!i)j=0;else{c[(i+4+15&-16)+-4>>2]=i;j=i+4+15&-16}i=c[b+72>>2]|0}if((i|0)>0){k=0;do{c[j+(k<<2)>>2]=c[(c[b+80>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(i|0))}k=c[b+80>>2]|0;if(k){if(a[b+84>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[k+-4>>2]|0);i=c[b+72>>2]|0}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=j;c[b+76>>2]=n;j=n}else i=j}c[(c[b+80>>2]|0)+(i<<2)>>2]=c[l>>2];i=i+1|0;c[b+72>>2]=i;o=o+1|0}while((o|0)!=(h|0))}else i=c[b+72>>2]|0;if(((c[b+52>>2]|0)+i|0)<=(c[(c[b+4>>2]|0)+72>>2]|0))return;nq(b);return}function rq(a){a=a|0;YE(a);return}function sq(a,d){a=a|0;d=d|0;var e=0,f=0;e=c[d>>2]|0;f=c[a+80>>2]|0;if((e|0)==(f|0)){e=0;return e|0}if(!((b[a+10>>1]&b[d+4>>1])<<16>>16)){e=0;return e|0}if(!((b[d+6>>1]&b[a+8>>1])<<16>>16)){e=0;return e|0}d=c[a+92>>2]|0;e=Qb[c[(c[d>>2]|0)+28>>2]&63](d,f,e)|0;return e|0}function tq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;e=c[b>>2]|0;if((e|0)==(c[a+80>>2]|0)){f=1.0;return +f}if(c[e+204>>2]&4){f=1.0;return +f}if((+g[a+28>>2]-+g[a+12>>2])*+g[b+8>>2]+(+g[a+32>>2]-+g[a+16>>2])*+g[b+12>>2]+(+g[a+36>>2]-+g[a+20>>2])*+g[b+16>>2]>=-+g[a+84>>2]){f=1.0;return +f}c[a+4>>2]=c[b+40>>2];c[a+76>>2]=e;if(d){c[a+44>>2]=c[b+8>>2];c[a+44+4>>2]=c[b+8+4>>2];c[a+44+8>>2]=c[b+8+8>>2];c[a+44+12>>2]=c[b+8+12>>2]}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=k*+g[e+20>>2]+j*+g[e+24>>2]+i*+g[e+28>>2];f=k*+g[e+36>>2]+j*+g[e+40>>2]+i*+g[e+44>>2];g[a+44>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+48>>2]=h;g[a+52>>2]=f;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+60+4>>2]=c[b+24+4>>2];c[a+60+8>>2]=c[b+24+8>>2];c[a+60+12>>2]=c[b+24+12>>2];f=+g[b+40>>2];return +f}function uq(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function vq(a){a=a|0;return c[a+72>>2]|0}function wq(a){a=a|0;return 2}function xq(a,b){a=a|0;b=b|0;return}function yq(a,b){a=a|0;b=+b;var d=0,e=0,f=0;e=i;i=i+16|0;iE(12439);if((c[a+280>>2]|0)>0){d=0;do{f=c[(c[a+288>>2]|0)+(d<<2)>>2]|0;lc[c[(c[f>>2]|0)+8>>2]&7](f,a,b);d=d+1|0}while((d|0)<(c[a+280>>2]|0))}d=c[2700]|0;a=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=a;if(a){i=e;return}do if(c[d+4>>2]|0){vb(e|0,0)|0;a=c[2702]|0;g[d+8>>2]=+(((c[e+4>>2]|0)-(c[a+4>>2]|0)+(((c[e>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[2700]|0;break}else{i=e;return}}while(0);c[2700]=c[d+20>>2];i=e;return}function zq(b,d,e,f,h,i){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;c[b+4>>2]=6;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;c[b+32>>2]=e;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=3256;c[b+48>>2]=c[f>>2];c[b+48+4>>2]=c[f+4>>2];c[b+48+8>>2]=c[f+8>>2];c[b+48+12>>2]=c[f+12>>2];c[b+64>>2]=c[f+16>>2];c[b+64+4>>2]=c[f+16+4>>2];c[b+64+8>>2]=c[f+16+8>>2];c[b+64+12>>2]=c[f+16+12>>2];c[b+80>>2]=c[f+32>>2];c[b+80+4>>2]=c[f+32+4>>2];c[b+80+8>>2]=c[f+32+8>>2];c[b+80+12>>2]=c[f+32+12>>2];c[b+96>>2]=c[f+48>>2];c[b+96+4>>2]=c[f+48+4>>2];c[b+96+8>>2]=c[f+48+8>>2];c[b+96+12>>2]=c[f+48+12>>2];c[b+112>>2]=c[h>>2];c[b+112+4>>2]=c[h+4>>2];c[b+112+8>>2]=c[h+8>>2];c[b+112+12>>2]=c[h+12>>2];c[b+128>>2]=c[h+16>>2];c[b+128+4>>2]=c[h+16+4>>2];c[b+128+8>>2]=c[h+16+8>>2];c[b+128+12>>2]=c[h+16+12>>2];c[b+144>>2]=c[h+32>>2];c[b+144+4>>2]=c[h+32+4>>2];c[b+144+8>>2]=c[h+32+8>>2];c[b+144+12>>2]=c[h+32+12>>2];c[b+160>>2]=c[h+48>>2];c[b+160+4>>2]=c[h+48+4>>2];c[b+160+8>>2]=c[h+48+8>>2];c[b+160+12>>2]=c[h+48+12>>2];h=b+680|0;f=h+48|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(f|0));c[b+740>>2]=0;c[b+740+4>>2]=0;c[b+740+8>>2]=0;c[b+740+12>>2]=0;c[b+756>>2]=1045220557;c[b+760>>2]=1045220557;c[b+764>>2]=1045220557;c[b+768>>2]=0;c[b+768+4>>2]=0;c[b+768+8>>2]=0;c[b+768+12>>2]=0;c[b+768+16>>2]=0;g[b+728>>2]=.699999988079071;g[b+732>>2]=1.0;g[b+736>>2]=.5;a[b+788>>0]=0;g[b+792>>2]=0.0;g[b+808>>2]=0.0;a[b+789>>0]=0;g[b+796>>2]=0.0;g[b+812>>2]=0.0;a[b+790>>0]=0;g[b+800>>2]=0.0;g[b+816>>2]=0.0;g[b+928>>2]=0.0;g[b+876>>2]=0.0;g[b+880>>2]=.10000000149011612;g[b+884>>2]=300.0;g[b+868>>2]=1.0;g[b+872>>2]=-1.0;g[b+896>>2]=0.0;g[b+900>>2]=.20000000298023224;g[b+904>>2]=0.0;g[b+908>>2]=0.0;g[b+888>>2]=1.0;g[b+892>>2]=.5;c[b+924>>2]=0;g[b+916>>2]=0.0;a[b+912>>0]=0;g[b+992>>2]=0.0;g[b+940>>2]=0.0;g[b+944>>2]=.10000000149011612;g[b+948>>2]=300.0;g[b+932>>2]=1.0;g[b+936>>2]=-1.0;g[b+960>>2]=0.0;g[b+964>>2]=.20000000298023224;g[b+968>>2]=0.0;g[b+972>>2]=0.0;g[b+952>>2]=1.0;g[b+956>>2]=.5;c[b+988>>2]=0;g[b+980>>2]=0.0;a[b+976>>0]=0;g[b+1056>>2]=0.0;g[b+1004>>2]=0.0;g[b+1008>>2]=.10000000149011612;g[b+1012>>2]=300.0;g[b+996>>2]=1.0;g[b+1e3>>2]=-1.0;g[b+1024>>2]=0.0;g[b+1028>>2]=.20000000298023224;g[b+1032>>2]=0.0;g[b+1036>>2]=0.0;g[b+1016>>2]=1.0;g[b+1020>>2]=.5;c[b+1052>>2]=0;g[b+1044>>2]=0.0;a[b+1040>>0]=0;a[b+1300>>0]=i&1;a[b+1301>>0]=1;c[b+1304>>2]=0;a[b+1308>>0]=0;Bq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);return}function Aq(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;er();c[b+4>>2]=6;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=3468;c[b+32>>2]=d;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=3256;c[b+112>>2]=c[e>>2];c[b+112+4>>2]=c[e+4>>2];c[b+112+8>>2]=c[e+8>>2];c[b+112+12>>2]=c[e+12>>2];c[b+128>>2]=c[e+16>>2];c[b+128+4>>2]=c[e+16+4>>2];c[b+128+8>>2]=c[e+16+8>>2];c[b+128+12>>2]=c[e+16+12>>2];c[b+144>>2]=c[e+32>>2];c[b+144+4>>2]=c[e+32+4>>2];c[b+144+8>>2]=c[e+32+8>>2];c[b+144+12>>2]=c[e+32+12>>2];c[b+160>>2]=c[e+48>>2];c[b+160+4>>2]=c[e+48+4>>2];c[b+160+8>>2]=c[e+48+8>>2];c[b+160+12>>2]=c[e+48+12>>2];e=b+680|0;h=e+48|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));c[b+740>>2]=0;c[b+740+4>>2]=0;c[b+740+8>>2]=0;c[b+740+12>>2]=0;c[b+756>>2]=1045220557;c[b+760>>2]=1045220557;c[b+764>>2]=1045220557;c[b+768>>2]=0;c[b+768+4>>2]=0;c[b+768+8>>2]=0;c[b+768+12>>2]=0;c[b+768+16>>2]=0;g[b+728>>2]=.699999988079071;g[b+732>>2]=1.0;g[b+736>>2]=.5;a[b+788>>0]=0;g[b+792>>2]=0.0;g[b+808>>2]=0.0;a[b+789>>0]=0;g[b+796>>2]=0.0;g[b+812>>2]=0.0;a[b+790>>0]=0;g[b+800>>2]=0.0;g[b+816>>2]=0.0;g[b+928>>2]=0.0;g[b+876>>2]=0.0;g[b+880>>2]=.10000000149011612;g[b+884>>2]=300.0;g[b+868>>2]=1.0;g[b+872>>2]=-1.0;g[b+896>>2]=0.0;g[b+900>>2]=.20000000298023224;g[b+904>>2]=0.0;g[b+908>>2]=0.0;g[b+888>>2]=1.0;g[b+892>>2]=.5;c[b+924>>2]=0;g[b+916>>2]=0.0;a[b+912>>0]=0;g[b+992>>2]=0.0;g[b+940>>2]=0.0;g[b+944>>2]=.10000000149011612;g[b+948>>2]=300.0;g[b+932>>2]=1.0;g[b+936>>2]=-1.0;g[b+960>>2]=0.0;g[b+964>>2]=.20000000298023224;g[b+968>>2]=0.0;g[b+972>>2]=0.0;g[b+952>>2]=1.0;g[b+956>>2]=.5;c[b+988>>2]=0;g[b+980>>2]=0.0;a[b+976>>0]=0;g[b+1056>>2]=0.0;g[b+1004>>2]=0.0;g[b+1008>>2]=.10000000149011612;g[b+1012>>2]=300.0;g[b+996>>2]=1.0;g[b+1e3>>2]=-1.0;g[b+1024>>2]=0.0;g[b+1028>>2]=.20000000298023224;g[b+1032>>2]=0.0;g[b+1036>>2]=0.0;g[b+1016>>2]=1.0;g[b+1020>>2]=.5;c[b+1052>>2]=0;g[b+1044>>2]=0.0;a[b+1040>>0]=0;a[b+1300>>0]=f&1;a[b+1301>>0]=1;c[b+1304>>2]=0;a[b+1308>>0]=0;w=+g[b+112>>2];C=+g[d+4>>2];v=+g[b+128>>2];B=+g[d+8>>2];u=+g[b+144>>2];A=+g[d+12>>2];t=+g[b+116>>2];s=+g[b+132>>2];r=+g[b+148>>2];q=+g[b+120>>2];o=+g[b+136>>2];m=+g[b+152>>2];z=+g[d+20>>2];y=+g[d+24>>2];x=+g[d+28>>2];p=+g[d+36>>2];n=+g[d+40>>2];l=+g[d+44>>2];E=+g[b+160>>2];D=+g[b+164>>2];i=+g[b+168>>2];k=+g[d+52>>2]+(C*E+B*D+A*i);j=z*E+y*D+x*i+ +g[d+56>>2];i=p*E+n*D+l*i+ +g[d+60>>2];g[b+48>>2]=w*C+v*B+u*A;g[b+52>>2]=C*t+B*s+A*r;g[b+56>>2]=C*q+B*o+A*m;g[b+60>>2]=0.0;g[b+64>>2]=w*z+v*y+u*x;g[b+68>>2]=t*z+s*y+r*x;g[b+72>>2]=q*z+o*y+m*x;g[b+76>>2]=0.0;g[b+80>>2]=w*p+v*n+u*l;g[b+84>>2]=t*p+s*n+r*l;g[b+88>>2]=q*p+o*n+m*l;g[b+92>>2]=0.0;g[b+96>>2]=k;g[b+100>>2]=j;g[b+104>>2]=i;g[b+108>>2]=0.0;Bq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);return}
function Zr(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,l=0.0,m=0.0,n=0,o=0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0,J=0.0,K=0.0,L=0.0,M=0.0,P=0.0,Q=0,R=0,S=0,T=0.0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0.0,ia=0.0;ga=i;i=i+80|0;if((e|0)<=0){i=ga;return}da=0;do{X=c[d+(da<<2)>>2]|0;Z=c[X+740>>2]|0;_=c[X+744>>2]|0;aa=Yr(b,Z,+g[f+12>>2])|0;ba=Yr(b,_,+g[f+12>>2])|0;$=c[b+16>>2]|0;if(!(((((+g[$+(aa*244|0)+128>>2]==0.0?+g[$+(aa*244|0)+132>>2]==0.0:0)?+g[$+(aa*244|0)+136>>2]==0.0:0)?+g[$+(ba*244|0)+128>>2]==0.0:0)?+g[$+(ba*244|0)+132>>2]==0.0:0)?+g[$+(ba*244|0)+136>>2]==0.0:0))fa=9;if((fa|0)==9?(fa=0,Y=c[X+748>>2]|0,(Y|0)>0):0){j=Y;ea=0;h=1;do{V=X+4+(ea*184|0)|0;G=X+4+(ea*184|0)+80|0;if(+g[G>>2]<=+g[X+756>>2]){W=c[b+28>>2]|0;if((W|0)==(c[b+32>>2]|0)?(ca=(W|0)!=0?W<<1:1,(W|0)<(ca|0)):0){if(!ca){n=W;o=0}else{c[2703]=(c[2703]|0)+1;j=XE((ca*152|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}n=c[b+28>>2]|0;o=j}if((n|0)>0){j=0;do{uF(o+(j*152|0)|0,(c[b+36>>2]|0)+(j*152|0)|0,152)|0;j=j+1|0}while((j|0)!=(n|0))}j=c[b+36>>2]|0;if(j){if(a[b+40>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=o;c[b+32>>2]=ca;j=c[b+28>>2]|0}else j=W;c[b+28>>2]=j+1;U=c[b+36>>2]|0;H=(c[Z+236>>2]&2|0)==0?0:Z;I=(c[_+236>>2]&2|0)==0?0:_;c[U+(W*152|0)+144>>2]=aa;c[U+(W*152|0)+148>>2]=ba;c[U+(W*152|0)+132>>2]=V;u=+g[X+4+(ea*184|0)+48>>2]-+g[Z+52>>2];y=+g[X+4+(ea*184|0)+52>>2]-+g[Z+56>>2];t=+g[X+4+(ea*184|0)+56>>2]-+g[Z+60>>2];g[ga+64>>2]=u;g[ga+64+4>>2]=y;g[ga+64+8>>2]=t;g[ga+64+12>>2]=0.0;E=+g[X+4+(ea*184|0)+32>>2]-+g[_+52>>2];F=+g[X+4+(ea*184|0)+36>>2]-+g[_+56>>2];z=+g[X+4+(ea*184|0)+40>>2]-+g[_+60>>2];g[ga+48>>2]=E;g[ga+48+4>>2]=F;g[ga+48+8>>2]=z;g[ga+48+12>>2]=0.0;if(!(c[$+(aa*244|0)+240>>2]|0)){s=0;q=0;n=0}else{T=+g[$+(aa*244|0)+192>>2]+ +g[$+(aa*244|0)+224>>2];v=+g[$+(aa*244|0)+196>>2]+ +g[$+(aa*244|0)+228>>2];p=+g[$+(aa*244|0)+200>>2]+ +g[$+(aa*244|0)+232>>2];s=(g[k>>2]=+g[$+(aa*244|0)+176>>2]+ +g[$+(aa*244|0)+208>>2]+(v*t-p*y),c[k>>2]|0);q=(g[k>>2]=+g[$+(aa*244|0)+180>>2]+ +g[$+(aa*244|0)+212>>2]+(p*u-T*t),c[k>>2]|0);n=(g[k>>2]=+g[$+(aa*244|0)+184>>2]+ +g[$+(aa*244|0)+216>>2]+(T*y-v*u),c[k>>2]|0)}if(!(c[$+(ba*244|0)+240>>2]|0)){r=0;o=0;j=0}else{T=+g[$+(ba*244|0)+192>>2]+ +g[$+(ba*244|0)+224>>2];v=+g[$+(ba*244|0)+196>>2]+ +g[$+(ba*244|0)+228>>2];p=+g[$+(ba*244|0)+200>>2]+ +g[$+(ba*244|0)+232>>2];r=(g[k>>2]=+g[$+(ba*244|0)+176>>2]+ +g[$+(ba*244|0)+208>>2]+(v*z-p*F),c[k>>2]|0);o=(g[k>>2]=+g[$+(ba*244|0)+180>>2]+ +g[$+(ba*244|0)+212>>2]+(p*E-T*z),c[k>>2]|0);j=(g[k>>2]=+g[$+(ba*244|0)+184>>2]+ +g[$+(ba*244|0)+216>>2]+(T*F-v*E),c[k>>2]|0)}T=(c[k>>2]=s,+g[k>>2]);T=T-(c[k>>2]=r,+g[k>>2]);P=(c[k>>2]=q,+g[k>>2]);P=P-(c[k>>2]=o,+g[k>>2]);M=(c[k>>2]=n,+g[k>>2]);M=M-(c[k>>2]=j,+g[k>>2]);S=X+4+(ea*184|0)+64|0;J=+g[S>>2];R=X+4+(ea*184|0)+68|0;K=+g[R>>2];Q=X+4+(ea*184|0)+72|0;L=+g[Q>>2];j=c[b+16>>2]|0;o=c[j+(aa*244|0)+240>>2]|0;n=c[j+(ba*244|0)+240>>2]|0;if(o){q=(g[k>>2]=((y*L-t*K)*+g[o+264>>2]+(t*J-L*u)*+g[o+268>>2]+(K*u-y*J)*+g[o+272>>2])*+g[o+544>>2],c[k>>2]|0);s=(g[k>>2]=((y*L-t*K)*+g[o+280>>2]+(t*J-L*u)*+g[o+284>>2]+(K*u-y*J)*+g[o+288>>2])*+g[o+548>>2],c[k>>2]|0);r=(g[k>>2]=((y*L-t*K)*+g[o+296>>2]+(t*J-L*u)*+g[o+300>>2]+(K*u-y*J)*+g[o+304>>2])*+g[o+552>>2],c[k>>2]|0)}else{q=0;s=0;r=0}c[U+(W*152|0)+64>>2]=q;c[U+(W*152|0)+68>>2]=s;c[U+(W*152|0)+72>>2]=r;g[U+(W*152|0)+76>>2]=0.0;m=+g[Q>>2];x=+g[R>>2];p=+g[S>>2];w=(c[k>>2]=s,+g[k>>2]);l=(c[k>>2]=r,+g[k>>2]);B=(c[k>>2]=q,+g[k>>2]);if(n){s=(g[k>>2]=(+g[n+264>>2]*-(F*m-z*x)+ +g[n+268>>2]*-(z*p-m*E)+ +g[n+272>>2]*-(x*E-F*p))*+g[n+544>>2],c[k>>2]|0);r=(g[k>>2]=(+g[n+280>>2]*-(F*m-z*x)+ +g[n+284>>2]*-(z*p-m*E)+ +g[n+288>>2]*-(x*E-F*p))*+g[n+548>>2],c[k>>2]|0);q=(g[k>>2]=(+g[n+296>>2]*-(F*m-z*x)+ +g[n+300>>2]*-(z*p-m*E)+ +g[n+304>>2]*-(x*E-F*p))*+g[n+552>>2],c[k>>2]|0)}else{s=0;r=0;q=0}c[U+(W*152|0)+80>>2]=s;c[U+(W*152|0)+84>>2]=r;c[U+(W*152|0)+88>>2]=q;g[U+(W*152|0)+92>>2]=0.0;A=(c[k>>2]=s,+g[k>>2]);C=(c[k>>2]=r,+g[k>>2]);if(o)B=+g[o+344>>2]+((w*t-l*y)*+g[S>>2]+(l*u-t*B)*+g[R>>2]+(y*B-w*u)*+g[Q>>2]);else B=0.0;if(n){v=-(c[k>>2]=q,+g[k>>2]);v=+g[n+344>>2]+((z*-C-F*v)*+g[S>>2]+(E*v-z*-A)*+g[R>>2]+(F*-A-E*-C)*+g[Q>>2])}else v=0.0;g[U+(W*152|0)+108>>2]=1.0/(B+v);if(o){c[U+(W*152|0)+16>>2]=c[S>>2];c[U+(W*152|0)+16+4>>2]=c[S+4>>2];c[U+(W*152|0)+16+8>>2]=c[S+8>>2];c[U+(W*152|0)+16+12>>2]=c[S+12>>2];g[U+(W*152|0)>>2]=y*L-t*K;g[U+(W*152|0)+4>>2]=t*J-L*u;g[U+(W*152|0)+8>>2]=K*u-y*J;g[U+(W*152|0)+12>>2]=0.0}else{c[U+(W*152|0)>>2]=0;c[U+(W*152|0)+4>>2]=0;c[U+(W*152|0)+8>>2]=0;c[U+(W*152|0)+12>>2]=0;c[U+(W*152|0)+16>>2]=0;c[U+(W*152|0)+20>>2]=0;c[U+(W*152|0)+24>>2]=0;c[U+(W*152|0)+28>>2]=0}if(n){w=-+g[R>>2];v=-+g[Q>>2];g[U+(W*152|0)+48>>2]=-+g[S>>2];g[U+(W*152|0)+52>>2]=w;g[U+(W*152|0)+56>>2]=v;g[U+(W*152|0)+60>>2]=0.0;g[U+(W*152|0)+32>>2]=-(F*m-z*x);g[U+(W*152|0)+36>>2]=-(z*p-m*E);g[U+(W*152|0)+40>>2]=-(x*E-F*p);g[U+(W*152|0)+44>>2]=0.0}else{c[U+(W*152|0)+32>>2]=0;c[U+(W*152|0)+32+4>>2]=0;c[U+(W*152|0)+32+8>>2]=0;c[U+(W*152|0)+32+12>>2]=0;c[U+(W*152|0)+32+16>>2]=0;c[U+(W*152|0)+32+20>>2]=0;c[U+(W*152|0)+32+24>>2]=0;c[U+(W*152|0)+32+28>>2]=0}D=+g[G>>2]+ +g[f+56>>2];if(o){p=+g[o+332>>2];B=+g[o+336>>2];v=+g[o+328>>2];A=p*t-B*y+ +g[o+312>>2];B=+g[o+316>>2]+(B*u-t*v);p=y*v-p*u+ +g[o+320>>2]}else{A=0.0;B=0.0;p=0.0}if(n){v=+g[n+332>>2];u=+g[n+336>>2];y=+g[n+328>>2];t=v*z-u*F+ +g[n+312>>2];u=+g[n+316>>2]+(u*E-z*y);v=F*y-v*E+ +g[n+320>>2]}else{t=0.0;u=0.0;v=0.0}C=+g[S>>2]*(A-t)+(B-u)*+g[R>>2]+(p-v)*+g[Q>>2];c[U+(W*152|0)+104>>2]=c[X+4+(ea*184|0)+84>>2];C=C*+g[X+4+(ea*184|0)+92>>2];C=!(C>=-0.0)?-C:0.0;do if(!(c[f+64>>2]&4))g[U+(W*152|0)+100>>2]=0.0;else{t=+g[X+4+(ea*184|0)+120>>2]*+g[f+60>>2];g[U+(W*152|0)+100>>2]=t;do if(o){if(!(c[j+(aa*244|0)+240>>2]|0))break;z=t*(+g[U+(W*152|0)+20>>2]*+g[j+(aa*244|0)+132>>2]*+g[o+352>>2])*+g[j+(aa*244|0)+116>>2];y=t*(+g[U+(W*152|0)+24>>2]*+g[j+(aa*244|0)+136>>2]*+g[o+356>>2])*+g[j+(aa*244|0)+120>>2];g[j+(aa*244|0)+64>>2]=+g[j+(aa*244|0)+112>>2]*(t*(+g[U+(W*152|0)+16>>2]*+g[j+(aa*244|0)+128>>2]*+g[o+348>>2]))+ +g[j+(aa*244|0)+64>>2];g[j+(aa*244|0)+68>>2]=z+ +g[j+(aa*244|0)+68>>2];g[j+(aa*244|0)+72>>2]=y+ +g[j+(aa*244|0)+72>>2];y=t*+g[j+(aa*244|0)+100>>2]*+g[U+(W*152|0)+68>>2];z=t*+g[j+(aa*244|0)+104>>2]*+g[U+(W*152|0)+72>>2];g[j+(aa*244|0)+80>>2]=t*+g[j+(aa*244|0)+96>>2]*+g[U+(W*152|0)+64>>2]+ +g[j+(aa*244|0)+80>>2];g[j+(aa*244|0)+84>>2]=y+ +g[j+(aa*244|0)+84>>2];g[j+(aa*244|0)+88>>2]=z+ +g[j+(aa*244|0)+88>>2]}while(0);if(!n)break;p=+g[U+(W*152|0)+100>>2];if(!(c[j+(ba*244|0)+240>>2]|0))break;z=+g[U+(W*152|0)+88>>2];y=+g[U+(W*152|0)+84>>2];v=+g[U+(W*152|0)+80>>2];t=p*(+g[U+(W*152|0)+52>>2]*+g[j+(ba*244|0)+132>>2]*+g[n+352>>2])*+g[j+(ba*244|0)+116>>2];u=p*(+g[U+(W*152|0)+56>>2]*+g[j+(ba*244|0)+136>>2]*+g[n+356>>2])*+g[j+(ba*244|0)+120>>2];g[j+(ba*244|0)+64>>2]=+g[j+(ba*244|0)+112>>2]*(p*(+g[U+(W*152|0)+48>>2]*+g[j+(ba*244|0)+128>>2]*+g[n+348>>2]))+ +g[j+(ba*244|0)+64>>2];g[j+(ba*244|0)+68>>2]=t+ +g[j+(ba*244|0)+68>>2];g[j+(ba*244|0)+72>>2]=u+ +g[j+(ba*244|0)+72>>2];y=y*(+g[j+(ba*244|0)+100>>2]*-p);z=z*(+g[j+(ba*244|0)+104>>2]*-p);g[j+(ba*244|0)+80>>2]=+g[j+(ba*244|0)+80>>2]-v*(+g[j+(ba*244|0)+96>>2]*-p);g[j+(ba*244|0)+84>>2]=+g[j+(ba*244|0)+84>>2]-y;g[j+(ba*244|0)+88>>2]=+g[j+(ba*244|0)+88>>2]-z}while(0);g[U+(W*152|0)+96>>2]=0.0;if(!(c[j+(aa*244|0)+240>>2]|0)){v=0.0;u=0.0;t=0.0;l=0.0;x=0.0;y=0.0}else{v=+g[j+(aa*244|0)+208>>2];u=+g[j+(aa*244|0)+212>>2];t=+g[j+(aa*244|0)+216>>2];l=+g[j+(aa*244|0)+224>>2];x=+g[j+(aa*244|0)+228>>2];y=+g[j+(aa*244|0)+232>>2]}if(!(c[j+(ba*244|0)+240>>2]|0)){p=0.0;m=0.0;w=0.0;z=0.0;A=0.0;B=0.0}else{p=+g[j+(ba*244|0)+208>>2];m=+g[j+(ba*244|0)+212>>2];w=+g[j+(ba*244|0)+216>>2];z=+g[j+(ba*244|0)+224>>2];A=+g[j+(ba*244|0)+228>>2];B=+g[j+(ba*244|0)+232>>2]}t=C-((v+ +g[j+(aa*244|0)+176>>2])*+g[U+(W*152|0)+16>>2]+(u+ +g[j+(aa*244|0)+180>>2])*+g[U+(W*152|0)+20>>2]+(t+ +g[j+(aa*244|0)+184>>2])*+g[U+(W*152|0)+24>>2]+((l+ +g[j+(aa*244|0)+192>>2])*+g[U+(W*152|0)>>2]+(x+ +g[j+(aa*244|0)+196>>2])*+g[U+(W*152|0)+4>>2]+(y+ +g[j+(aa*244|0)+200>>2])*+g[U+(W*152|0)+8>>2])+((p+ +g[j+(ba*244|0)+176>>2])*+g[U+(W*152|0)+48>>2]+(m+ +g[j+(ba*244|0)+180>>2])*+g[U+(W*152|0)+52>>2]+(w+ +g[j+(ba*244|0)+184>>2])*+g[U+(W*152|0)+56>>2]+((z+ +g[j+(ba*244|0)+192>>2])*+g[U+(W*152|0)+32>>2]+(A+ +g[j+(ba*244|0)+196>>2])*+g[U+(W*152|0)+36>>2]+(B+ +g[j+(ba*244|0)+200>>2])*+g[U+(W*152|0)+40>>2])));s=(c[f+44>>2]|0)==0;p=+g[f+12>>2];if(D>0.0){m=0.0;t=t-D/p}else m=-(D*+g[(s|D>+g[f+48>>2]?f+32|0:f+36|0)>>2])/p;p=+g[U+(W*152|0)+108>>2];m=m*p;p=t*p;if(s|D>+g[f+48>>2]){g[U+(W*152|0)+112>>2]=m+p;g[U+(W*152|0)+128>>2]=0.0}else{g[U+(W*152|0)+112>>2]=p;g[U+(W*152|0)+128>>2]=m}g[U+(W*152|0)+116>>2]=0.0;g[U+(W*152|0)+120>>2]=0.0;g[U+(W*152|0)+124>>2]=1.0e10;c[U+(W*152|0)+140>>2]=c[b+68>>2];if(!H){r=0;n=0;j=0}else{r=c[H+328>>2]|0;n=c[H+332>>2]|0;j=c[H+336>>2]|0}if(!I){s=0;q=0;o=0}else{s=c[I+328>>2]|0;q=c[I+332>>2]|0;o=c[I+336>>2]|0}u=(c[k>>2]=s,+g[k>>2]);u=u-(c[k>>2]=r,+g[k>>2]);m=(c[k>>2]=q,+g[k>>2]);m=m-(c[k>>2]=n,+g[k>>2]);t=(c[k>>2]=o,+g[k>>2]);t=t-(c[k>>2]=j,+g[k>>2]);g[ga+32>>2]=u;g[ga+32+4>>2]=m;g[ga+32+8>>2]=t;g[ga+32+12>>2]=0.0;do if((h|0)>0?+g[X+4+(ea*184|0)+88>>2]>0.0:0){h=h+-1|0;p=+O(+(u*u+m*m+t*t));if(p>+g[f+80>>2]){g[ga+32>>2]=u*(1.0/p);g[ga+32+4>>2]=m*(1.0/p);g[ga+32+8>>2]=t*(1.0/p);if(!(c[Z+180>>2]&2)){l=u*(1.0/p);m=m*(1.0/p);p=t*(1.0/p)}else{E=+g[Z+4>>2];C=+g[Z+20>>2];w=+g[Z+36>>2];D=+g[Z+8>>2];B=+g[Z+24>>2];v=+g[Z+40>>2];l=+g[Z+12>>2];A=+g[Z+28>>2];z=+g[Z+44>>2];x=(E*(u*(1.0/p))+C*(m*(1.0/p))+t*(1.0/p)*w)*+g[Z+164>>2];y=(u*(1.0/p)*D+m*(1.0/p)*B+t*(1.0/p)*v)*+g[Z+168>>2];p=(u*(1.0/p)*l+m*(1.0/p)*A+t*(1.0/p)*z)*+g[Z+172>>2];g[ga+32>>2]=E*x+D*y+l*p;g[ga+32+4>>2]=C*x+B*y+A*p;g[ga+32+8>>2]=w*x+v*y+z*p;g[ga+32+12>>2]=0.0;l=E*x+D*y+l*p;m=C*x+B*y+A*p;p=w*x+v*y+z*p}if(c[_+180>>2]&2){D=+g[_+4>>2];A=+g[_+20>>2];t=+g[_+36>>2];C=+g[_+8>>2];w=+g[_+24>>2];v=+g[_+40>>2];B=+g[_+12>>2];x=+g[_+28>>2];z=+g[_+44>>2];u=(D*l+A*m+t*p)*+g[_+164>>2];y=(l*C+m*w+p*v)*+g[_+168>>2];p=(l*B+m*x+p*z)*+g[_+172>>2];g[ga+32>>2]=D*u+C*y+B*p;g[ga+32+4>>2]=A*u+w*y+x*p;g[ga+32+8>>2]=t*u+v*y+z*p;g[ga+32+12>>2]=0.0;l=D*u+C*y+B*p;m=A*u+w*y+x*p;p=t*u+v*y+z*p}if(!(+O(+(l*l+m*m+p*p))>.001))break;Xr(b,ga+32|0,aa,ba,W,V);break}Xr(b,S,aa,ba,W,V);p=+g[Q>>2];if(+N(+p)>.7071067690849304){m=+g[R>>2];z=1.0/+O(+(p*p+m*m));g[ga+16>>2]=0.0;g[ga+16+4>>2]=-(z*p);g[ga+16+8>>2]=z*m;g[ga>>2]=(p*p+m*m)*z;y=+g[S>>2];g[ga+4>>2]=-(y*(z*m));w=y*-(z*p);t=0.0;u=-(z*p);v=z*m;l=(p*p+m*m)*z;m=-(y*(z*m))}else{l=+g[S>>2];z=+g[R>>2];m=1.0/+O(+(l*l+z*z));g[ga+16>>2]=-(z*m);g[ga+16+4>>2]=m*l;g[ga+16+8>>2]=0.0;g[ga>>2]=-(p*(m*l));g[ga+4>>2]=p*-(z*m);w=(l*l+z*z)*m;t=-(z*m);u=m*l;v=0.0;l=-(p*(m*l));m=p*-(z*m)}g[ga+8>>2]=w;r=(c[Z+180>>2]&2|0)==0;if(!r){ha=+g[Z+4>>2];D=+g[Z+20>>2];A=+g[Z+36>>2];F=+g[Z+8>>2];C=+g[Z+24>>2];p=+g[Z+40>>2];E=+g[Z+12>>2];B=+g[Z+28>>2];z=+g[Z+44>>2];x=(ha*t+D*u+A*v)*+g[Z+164>>2];y=(t*F+u*C+v*p)*+g[Z+168>>2];v=(t*E+u*B+v*z)*+g[Z+172>>2];g[ga+16>>2]=ha*x+F*y+E*v;g[ga+16+4>>2]=D*x+C*y+B*v;g[ga+16+8>>2]=A*x+p*y+z*v;g[ga+16+12>>2]=0.0;t=ha*x+F*y+E*v;u=D*x+C*y+B*v;v=A*x+p*y+z*v}s=(c[_+180>>2]&2|0)==0;if(!s){ha=+g[_+4>>2];p=+g[_+20>>2];B=+g[_+36>>2];z=+g[_+8>>2];x=+g[_+24>>2];D=+g[_+40>>2];y=+g[_+12>>2];A=+g[_+28>>2];F=+g[_+44>>2];C=(ha*t+p*u+B*v)*+g[_+164>>2];E=(t*z+u*x+v*D)*+g[_+168>>2];v=(t*y+u*A+v*F)*+g[_+172>>2];g[ga+16>>2]=ha*C+z*E+y*v;g[ga+16+4>>2]=p*C+x*E+A*v;g[ga+16+8>>2]=B*C+D*E+F*v;g[ga+16+12>>2]=0.0;t=ha*C+z*E+y*v;u=p*C+x*E+A*v;v=B*C+D*E+F*v}if(r)p=w;else{ia=+g[Z+4>>2];y=+g[Z+20>>2];B=+g[Z+36>>2];ha=+g[Z+8>>2];x=+g[Z+24>>2];D=+g[Z+40>>2];z=+g[Z+12>>2];A=+g[Z+28>>2];F=+g[Z+44>>2];C=(ia*l+y*m+B*w)*+g[Z+164>>2];E=(l*ha+m*x+w*D)*+g[Z+168>>2];p=(l*z+m*A+w*F)*+g[Z+172>>2];g[ga>>2]=ia*C+ha*E+z*p;g[ga+4>>2]=y*C+x*E+A*p;g[ga+8>>2]=B*C+D*E+F*p;g[ga+12>>2]=0.0;l=ia*C+ha*E+z*p;m=y*C+x*E+A*p;p=B*C+D*E+F*p}if(!s){ha=+g[_+4>>2];x=+g[_+20>>2];B=+g[_+36>>2];z=+g[_+8>>2];w=+g[_+24>>2];D=+g[_+40>>2];y=+g[_+12>>2];A=+g[_+28>>2];F=+g[_+44>>2];C=(ha*l+x*m+B*p)*+g[_+164>>2];E=(l*z+m*w+p*D)*+g[_+168>>2];p=(l*y+m*A+p*F)*+g[_+172>>2];g[ga>>2]=ha*C+z*E+y*p;g[ga+4>>2]=x*C+w*E+A*p;g[ga+8>>2]=B*C+D*E+F*p;g[ga+12>>2]=0.0;l=ha*C+z*E+y*p;m=x*C+w*E+A*p;p=B*C+D*E+F*p}if(+O(+(t*t+u*u+v*v))>.001)Xr(b,ga+16|0,aa,ba,W,V);if(!(+O(+(l*l+m*m+p*p))>.001))break;Xr(b,ga,aa,ba,W,V)}while(0);do if(!(c[f+64>>2]&32))fa=94;else{if(!(a[X+4+(ea*184|0)+116>>0]|0)){fa=94;break}Wr(b,X+4+(ea*184|0)+152|0,aa,ba,W,V,ga+64|0,ga+48|0,1.0,+g[X+4+(ea*184|0)+132>>2],+g[X+4+(ea*184|0)+140>>2]);if(!(c[f+64>>2]&16))break;Wr(b,X+4+(ea*184|0)+168|0,aa,ba,W,V,ga+64|0,ga+48|0,1.0,+g[X+4+(ea*184|0)+136>>2],+g[X+4+(ea*184|0)+144>>2])}while(0);do if((fa|0)==94){fa=0;o=X+4+(ea*184|0)+152|0;v=+g[S>>2];m=+g[R>>2];w=+g[Q>>2];u=T-(J*T+P*K+M*L)*v;t=P-(J*T+P*K+M*L)*m;p=M-(J*T+P*K+M*L)*w;g[X+4+(ea*184|0)+152>>2]=u;s=X+4+(ea*184|0)+156|0;g[s>>2]=t;q=X+4+(ea*184|0)+160|0;g[q>>2]=p;g[X+4+(ea*184|0)+164>>2]=0.0;if((c[f+64>>2]&64|0)==0?u*u+t*t+p*p>1.1920928955078125e-07:0){P=1.0/+O(+(u*u+t*t+p*p));g[o>>2]=u*P;g[s>>2]=P*t;g[q>>2]=P*p;Vr(Z,o);Vr(_,o);Wr(b,o,aa,ba,W,V,ga+64|0,ga+48|0,1.0,0.0,0.0);if(!(c[f+64>>2]&16))break;G=X+4+(ea*184|0)+168|0;K=+g[s>>2];D=+g[Q>>2];C=+g[q>>2];E=+g[R>>2];L=+g[S>>2];F=+g[o>>2];g[X+4+(ea*184|0)+168>>2]=K*D-C*E;g[X+4+(ea*184|0)+180>>2]=0.0;P=1.0/+O(+((K*D-C*E)*(K*D-C*E)+(C*L-D*F)*(C*L-D*F)+(E*F-K*L)*(E*F-K*L)));g[G>>2]=(K*D-C*E)*P;g[X+4+(ea*184|0)+172>>2]=(C*L-D*F)*P;g[X+4+(ea*184|0)+176>>2]=(E*F-K*L)*P;Vr(Z,G);Vr(_,G);Wr(b,G,aa,ba,W,V,ga+64|0,ga+48|0,1.0,0.0,0.0);break}r=X+4+(ea*184|0)+168|0;if(+N(+w)>.7071067690849304){P=1.0/+O(+(w*w+m*m));g[o>>2]=0.0;g[s>>2]=-(P*w);g[q>>2]=P*m;l=v*-(P*w);p=(w*w+m*m)*P;m=-(v*(P*m))}else{P=1.0/+O(+(v*v+m*m));g[o>>2]=-(m*P);g[s>>2]=P*v;g[q>>2]=0.0;l=(v*v+m*m)*P;p=-(w*(P*v));m=w*-(m*P)}g[r>>2]=p;g[X+4+(ea*184|0)+172>>2]=m;g[X+4+(ea*184|0)+176>>2]=l;Vr(Z,o);Vr(_,o);Wr(b,o,aa,ba,W,V,ga+64|0,ga+48|0,1.0,0.0,0.0);j=c[f+64>>2]|0;if(j&16){Vr(Z,r);Vr(_,r);Wr(b,r,aa,ba,W,V,ga+64|0,ga+48|0,1.0,0.0,0.0);j=c[f+64>>2]|0}if((j&80|0)!=80)break;a[X+4+(ea*184|0)+116>>0]=1}while(0);s=c[b+16>>2]|0;n=c[s+(aa*244|0)+240>>2]|0;j=c[s+(ba*244|0)+240>>2]|0;q=c[U+(W*152|0)+140>>2]|0;r=c[b+76>>2]|0;o=c[f+64>>2]|0;do if(!(o&4))g[r+(q*152|0)+100>>2]=0.0;else{m=+g[X+4+(ea*184|0)+124>>2]*+g[f+60>>2];g[r+(q*152|0)+100>>2]=m;if(n){K=+g[n+344>>2];P=m*(K*+g[r+(q*152|0)+20>>2]*+g[n+352>>2])*+g[s+(aa*244|0)+116>>2];L=m*(K*+g[r+(q*152|0)+24>>2]*+g[n+356>>2])*+g[s+(aa*244|0)+120>>2];g[s+(aa*244|0)+64>>2]=+g[s+(aa*244|0)+112>>2]*(m*(K*+g[r+(q*152|0)+16>>2]*+g[n+348>>2]))+ +g[s+(aa*244|0)+64>>2];g[s+(aa*244|0)+68>>2]=P+ +g[s+(aa*244|0)+68>>2];g[s+(aa*244|0)+72>>2]=L+ +g[s+(aa*244|0)+72>>2];L=m*+g[s+(aa*244|0)+100>>2]*+g[r+(q*152|0)+68>>2];P=m*+g[s+(aa*244|0)+104>>2]*+g[r+(q*152|0)+72>>2];g[s+(aa*244|0)+80>>2]=m*+g[s+(aa*244|0)+96>>2]*+g[r+(q*152|0)+64>>2]+ +g[s+(aa*244|0)+80>>2];g[s+(aa*244|0)+84>>2]=L+ +g[s+(aa*244|0)+84>>2];g[s+(aa*244|0)+88>>2]=P+ +g[s+(aa*244|0)+88>>2]}if(!j)break;m=+g[j+344>>2];l=+g[r+(q*152|0)+100>>2];if(!(c[s+(ba*244|0)+240>>2]|0))break;P=+g[r+(q*152|0)+88>>2];L=+g[r+(q*152|0)+84>>2];K=+g[r+(q*152|0)+80>>2];E=l*(m*+g[r+(q*152|0)+52>>2]*+g[j+352>>2])*+g[s+(ba*244|0)+116>>2];F=l*(m*+g[r+(q*152|0)+56>>2]*+g[j+356>>2])*+g[s+(ba*244|0)+120>>2];g[s+(ba*244|0)+64>>2]=+g[s+(ba*244|0)+112>>2]*(l*(m*+g[r+(q*152|0)+48>>2]*+g[j+348>>2]))+ +g[s+(ba*244|0)+64>>2];g[s+(ba*244|0)+68>>2]=E+ +g[s+(ba*244|0)+68>>2];g[s+(ba*244|0)+72>>2]=F+ +g[s+(ba*244|0)+72>>2];L=L*(+g[s+(ba*244|0)+100>>2]*-l);P=P*(+g[s+(ba*244|0)+104>>2]*-l);g[s+(ba*244|0)+80>>2]=+g[s+(ba*244|0)+80>>2]-K*(+g[s+(ba*244|0)+96>>2]*-l);g[s+(ba*244|0)+84>>2]=+g[s+(ba*244|0)+84>>2]-L;g[s+(ba*244|0)+88>>2]=+g[s+(ba*244|0)+88>>2]-P}while(0);do if(o&16){if(!(o&4)){g[r+((q+1|0)*152|0)+100>>2]=0.0;break}l=+g[X+4+(ea*184|0)+128>>2]*+g[f+60>>2];g[r+((q+1|0)*152|0)+100>>2]=l;do if(n){m=+g[n+344>>2];if(!(c[s+(aa*244|0)+240>>2]|0))break;P=l*(m*+g[r+((q+1|0)*152|0)+20>>2])*+g[s+(aa*244|0)+116>>2];L=l*(m*+g[r+((q+1|0)*152|0)+24>>2])*+g[s+(aa*244|0)+120>>2];g[s+(aa*244|0)+64>>2]=+g[s+(aa*244|0)+112>>2]*(l*(m*+g[r+((q+1|0)*152|0)+16>>2]))+ +g[s+(aa*244|0)+64>>2];g[s+(aa*244|0)+68>>2]=P+ +g[s+(aa*244|0)+68>>2];g[s+(aa*244|0)+72>>2]=L+ +g[s+(aa*244|0)+72>>2];L=l*+g[s+(aa*244|0)+100>>2]*+g[r+((q+1|0)*152|0)+68>>2];P=l*+g[s+(aa*244|0)+104>>2]*+g[r+((q+1|0)*152|0)+72>>2];g[s+(aa*244|0)+80>>2]=l*+g[s+(aa*244|0)+96>>2]*+g[r+((q+1|0)*152|0)+64>>2]+ +g[s+(aa*244|0)+80>>2];g[s+(aa*244|0)+84>>2]=L+ +g[s+(aa*244|0)+84>>2];g[s+(aa*244|0)+88>>2]=P+ +g[s+(aa*244|0)+88>>2]}while(0);if(!j)break;l=+g[j+344>>2];m=+g[r+((q+1|0)*152|0)+100>>2];if(!(c[s+(ba*244|0)+240>>2]|0))break;P=+g[r+((q+1|0)*152|0)+88>>2];L=+g[r+((q+1|0)*152|0)+84>>2];K=+g[r+((q+1|0)*152|0)+80>>2];E=m*(l*+g[r+((q+1|0)*152|0)+52>>2])*+g[s+(ba*244|0)+116>>2];F=m*(l*+g[r+((q+1|0)*152|0)+56>>2])*+g[s+(ba*244|0)+120>>2];g[s+(ba*244|0)+64>>2]=+g[s+(ba*244|0)+112>>2]*(m*(l*+g[r+((q+1|0)*152|0)+48>>2]))+ +g[s+(ba*244|0)+64>>2];g[s+(ba*244|0)+68>>2]=E+ +g[s+(ba*244|0)+68>>2];g[s+(ba*244|0)+72>>2]=F+ +g[s+(ba*244|0)+72>>2];L=L*(+g[s+(ba*244|0)+100>>2]*-m);P=P*(+g[s+(ba*244|0)+104>>2]*-m);g[s+(ba*244|0)+80>>2]=+g[s+(ba*244|0)+80>>2]-K*(+g[s+(ba*244|0)+96>>2]*-m);g[s+(ba*244|0)+84>>2]=+g[s+(ba*244|0)+84>>2]-L;g[s+(ba*244|0)+88>>2]=+g[s+(ba*244|0)+88>>2]-P}while(0);j=c[X+748>>2]|0}ea=ea+1|0}while((ea|0)<(j|0))}da=da+1|0}while((da|0)!=(e|0));i=ga;return}function _r(b,d,e,f,h,j,l,m,n){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0.0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0;X=i;i=i+304|0;c[b+188>>2]=-1;iE(13289);c[b+184>>2]=0;if((e|0)>0){n=0;do{c[(c[d+(n<<2)>>2]|0)+212>>2]=-1;n=n+1|0}while((n|0)!=(e|0))}n=c[b+12>>2]|0;if((n|0)<(e+1|0)){if((e+1|0)!=0?(c[2703]=(c[2703]|0)+1,q=XE(((e+1|0)*244|3)+16|0)|0,(q|0)!=0):0){c[(q+4+15&-16)+-4>>2]=q;p=q+4+15&-16}else p=0;n=c[b+8>>2]|0;if((n|0)>0){q=0;do{M=p+(q*244|0)|0;S=c[b+16>>2]|0;H=S+(q*244|0)|0;c[M>>2]=c[H>>2];c[M+4>>2]=c[H+4>>2];c[M+8>>2]=c[H+8>>2];c[M+12>>2]=c[H+12>>2];M=p+(q*244|0)+16|0;H=S+(q*244|0)+16|0;c[M>>2]=c[H>>2];c[M+4>>2]=c[H+4>>2];c[M+8>>2]=c[H+8>>2];c[M+12>>2]=c[H+12>>2];M=p+(q*244|0)+32|0;H=S+(q*244|0)+32|0;c[M>>2]=c[H>>2];c[M+4>>2]=c[H+4>>2];c[M+8>>2]=c[H+8>>2];c[M+12>>2]=c[H+12>>2];M=p+(q*244|0)+48|0;H=S+(q*244|0)+48|0;c[M>>2]=c[H>>2];c[M+4>>2]=c[H+4>>2];c[M+8>>2]=c[H+8>>2];c[M+12>>2]=c[H+12>>2];uF(p+(q*244|0)+64|0,S+(q*244|0)+64|0,180)|0;q=q+1|0}while((q|0)!=(n|0))}n=c[b+16>>2]|0;if(n){if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=p;c[b+12>>2]=e+1;n=e+1|0;p=b+8|0}else p=b+8|0;qF(X|0,0,244)|0;q=c[p>>2]|0;if((q|0)<0){if((n|0)<0){n=c[b+16>>2]|0;if(n){if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+12>>2]=0}n=q;do{S=c[b+16>>2]|0;M=S+(n*244|0)|0;c[M>>2]=c[X>>2];c[M+4>>2]=c[X+4>>2];c[M+8>>2]=c[X+8>>2];c[M+12>>2]=c[X+12>>2];M=S+(n*244|0)+16|0;c[M>>2]=c[X+16>>2];c[M+4>>2]=c[X+16+4>>2];c[M+8>>2]=c[X+16+8>>2];c[M+12>>2]=c[X+16+12>>2];M=S+(n*244|0)+32|0;c[M>>2]=c[X+32>>2];c[M+4>>2]=c[X+32+4>>2];c[M+8>>2]=c[X+32+8>>2];c[M+12>>2]=c[X+32+12>>2];M=S+(n*244|0)+48|0;c[M>>2]=c[X+48>>2];c[M+4>>2]=c[X+48+4>>2];c[M+8>>2]=c[X+48+8>>2];c[M+12>>2]=c[X+48+12>>2];uF(S+(n*244|0)+64|0,X+64|0,180)|0;n=n+1|0}while((n|0)!=0)}c[p>>2]=0;if((e|0)>0){s=0;do{u=d+(s<<2)|0;t=Yr(b,c[u>>2]|0,+g[m+12>>2])|0;u=c[u>>2]|0;if((!((u|0)==0?1:(c[u+236>>2]&2|0)==0)?+g[u+344>>2]!=0.0:0)?(o=c[b+16>>2]|0,(c[u+504>>2]&2|0)!=0):0){v=+g[m+76>>2];Z=1.0/+g[u+396>>2];D=1.0/+g[u+400>>2];r=1.0/+g[u+404>>2];da=+g[u+4>>2];ca=+g[u+8>>2];ba=+g[u+12>>2];aa=+g[u+20>>2];$=+g[u+24>>2];_=+g[u+28>>2];Y=+g[u+36>>2];y=+g[u+40>>2];x=+g[u+44>>2];z=+g[u+328>>2];A=+g[u+332>>2];w=+g[u+336>>2];C=(Z*da*da+D*ca*ca+r*ba*ba)*z+(Z*da*aa+D*ca*$+r*ba*_)*A+(Z*da*Y+D*ca*y+r*ba*x)*w;B=(Z*aa*da+D*$*ca+r*_*ba)*z+(Z*aa*aa+D*$*$+r*_*_)*A+(Z*aa*Y+D*$*y+r*_*x)*w;x=(Z*Y*da+D*y*ca+r*x*ba)*z+(Z*Y*aa+D*y*$+r*x*_)*A+(Z*Y*Y+D*y*y+r*x*x)*w;r=(A*x-w*B)*(A*x-w*B)+(w*C-z*x)*(w*C-z*x)+(z*B-A*C)*(z*B-A*C);if(r>v*v){r=1.0/+O(+r)*v;y=(A*x-w*B)*r;v=r*(w*C-z*x);r=r*(z*B-A*C)}else{y=A*x-w*B;v=w*C-z*x;r=z*B-A*C}A=+g[m+12>>2];B=(y*+g[u+268>>2]+v*+g[u+284>>2]+r*+g[u+300>>2])*A;D=A*(y*+g[u+272>>2]+v*+g[u+288>>2]+r*+g[u+304>>2]);g[o+(t*244|0)+224>>2]=+g[o+(t*244|0)+224>>2]-(y*+g[u+264>>2]+v*+g[u+280>>2]+r*+g[u+296>>2])*A;g[o+(t*244|0)+228>>2]=+g[o+(t*244|0)+228>>2]-B;g[o+(t*244|0)+232>>2]=+g[o+(t*244|0)+232>>2]-D}s=s+1|0}while((s|0)!=(e|0))}if((l|0)>0){q=0;do{S=c[j+(q<<2)>>2]|0;Db[c[(c[S>>2]|0)+8>>2]&255](S);g[S+36>>2]=0.0;q=q+1|0}while((q|0)<(l|0))}p=c[b+168>>2]|0;if((p|0)<(l|0)?(c[b+172>>2]|0)<(l|0):0){if(!l)q=0;else{c[2703]=(c[2703]|0)+1;p=XE((l<<3|3)+16|0)|0;if(!p)n=0;else{c[(p+4+15&-16)+-4>>2]=p;n=p+4+15&-16}p=c[b+168>>2]|0;q=n}if((p|0)>0){n=0;do{H=(c[b+176>>2]|0)+(n<<3)|0;M=c[H+4>>2]|0;S=q+(n<<3)|0;c[S>>2]=c[H>>2];c[S+4>>2]=M;n=n+1|0}while((n|0)!=(p|0))}n=c[b+176>>2]|0;if(n){if(a[b+180>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}c[b+176>>2]=0}a[b+180>>0]=1;c[b+176>>2]=q;c[b+172>>2]=l}c[b+168>>2]=l;if((l|0)>0){u=0;n=0;do{s=c[b+176>>2]|0;t=s+(u<<3)|0;o=j+(u<<2)|0;q=c[o>>2]|0;p=c[q+44>>2]|0;if(p){q=p+64|0;do{c[p>>2]=0;p=p+4|0}while((p|0)<(q|0));q=c[o>>2]|0}if(!(a[q+20>>0]|0)){c[t>>2]=0;c[s+(u<<3)+4>>2]=0;q=0}else{Fb[c[(c[q>>2]|0)+16>>2]&127](q,t);q=c[t>>2]|0}n=q+n|0;u=u+1|0}while((u|0)<(l|0))}else n=0;q=c[b+48>>2]|0;if((q|0)<(n|0)?(c[b+52>>2]|0)<(n|0):0){if(!n)p=0;else{c[2703]=(c[2703]|0)+1;q=XE((n*152|3)+16|0)|0;if(!q)p=0;else{c[(q+4+15&-16)+-4>>2]=q;p=q+4+15&-16}q=c[b+48>>2]|0}if((q|0)>0){o=0;do{uF(p+(o*152|0)|0,(c[b+56>>2]|0)+(o*152|0)|0,152)|0;o=o+1|0}while((o|0)!=(q|0))}q=c[b+56>>2]|0;if(q){if(a[b+60>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[q+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=p;c[b+52>>2]=n}c[b+48>>2]=n;if((l|0)>0){n=c[b+176>>2]|0;U=0;V=0;while(1){T=n+(V<<3)|0;if(!(c[T>>2]|0))q=0;else{J=c[b+56>>2]|0;M=j+(V<<2)|0;K=c[M>>2]|0;S=c[K+28>>2]|0;R=c[K+32>>2]|0;P=Yr(b,S,+g[m+12>>2])|0;Q=Yr(b,R,+g[m+12>>2])|0;L=c[b+16>>2]|0;u=c[K+24>>2]|0;u=(u|0)>0?u:c[m+20>>2]|0;if((u|0)>(c[b+184>>2]|0))c[b+184>>2]=u;if((c[T>>2]|0)>0){t=0;do{H=t+U|0;qF(J+(H*152|0)|0,0,152)|0;g[J+(H*152|0)+120>>2]=-3402823466385288598117041.0e14;g[J+(H*152|0)+124>>2]=3402823466385288598117041.0e14;g[J+(H*152|0)+100>>2]=0.0;g[J+(H*152|0)+96>>2]=0.0;c[J+(H*152|0)+144>>2]=P;c[J+(H*152|0)+148>>2]=Q;c[J+(H*152|0)+136>>2]=u;t=t+1|0}while((t|0)<(c[T>>2]|0))}c[L+(P*244|0)+64>>2]=0;c[L+(P*244|0)+64+4>>2]=0;c[L+(P*244|0)+64+8>>2]=0;c[L+(P*244|0)+64+12>>2]=0;c[L+(P*244|0)+64+16>>2]=0;c[L+(P*244|0)+64+20>>2]=0;c[L+(P*244|0)+64+24>>2]=0;c[L+(P*244|0)+64+28>>2]=0;c[L+(P*244|0)+144>>2]=0;c[L+(P*244|0)+144+4>>2]=0;c[L+(P*244|0)+144+8>>2]=0;c[L+(P*244|0)+144+12>>2]=0;c[L+(P*244|0)+144+16>>2]=0;c[L+(P*244|0)+144+20>>2]=0;c[L+(P*244|0)+144+24>>2]=0;c[L+(P*244|0)+144+28>>2]=0;c[L+(Q*244|0)+64>>2]=0;c[L+(Q*244|0)+64+4>>2]=0;c[L+(Q*244|0)+64+8>>2]=0;c[L+(Q*244|0)+64+12>>2]=0;c[L+(Q*244|0)+64+16>>2]=0;c[L+(Q*244|0)+64+20>>2]=0;c[L+(Q*244|0)+64+24>>2]=0;c[L+(Q*244|0)+64+28>>2]=0;c[L+(Q*244|0)+144>>2]=0;c[L+(Q*244|0)+144+4>>2]=0;c[L+(Q*244|0)+144+8>>2]=0;c[L+(Q*244|0)+144+12>>2]=0;c[L+(Q*244|0)+144+16>>2]=0;c[L+(Q*244|0)+144+20>>2]=0;c[L+(Q*244|0)+144+24>>2]=0;c[L+(Q*244|0)+144+28>>2]=0;g[X+248>>2]=1.0/+g[m+12>>2];c[X+248+4>>2]=c[m+32>>2];c[X+248+8>>2]=J+(U*152|0)+16;c[X+248+12>>2]=J+(U*152|0);c[X+248+16>>2]=J+(U*152|0)+48;c[X+248+20>>2]=J+(U*152|0)+32;c[X+248+24>>2]=38;c[X+248+28>>2]=J+(U*152|0)+112;H=J+(U*152|0)+116|0;c[H>>2]=c[m+40>>2];c[X+248+52>>2]=c[m+4>>2];c[X+248+32>>2]=H;c[X+248+36>>2]=J+(U*152|0)+120;c[X+248+40>>2]=J+(U*152|0)+124;c[X+248+48>>2]=c[m+20>>2];H=c[M>>2]|0;Fb[c[(c[H>>2]|0)+20>>2]&127](H,X+248|0);if((c[T>>2]|0)>0){I=0;do{H=I+U|0;v=+g[(c[M>>2]|0)+16>>2];if(+g[J+(H*152|0)+124>>2]>=v)g[J+(H*152|0)+124>>2]=v;if(+g[J+(H*152|0)+120>>2]<=-v)g[J+(H*152|0)+120>>2]=-v;c[J+(H*152|0)+132>>2]=K;G=c[K+28>>2]|0;Z=+g[J+(H*152|0)>>2];_=+g[J+(H*152|0)+4>>2];D=+g[J+(H*152|0)+8>>2];da=(Z*+g[G+280>>2]+_*+g[G+284>>2]+D*+g[G+288>>2])*+g[G+548>>2];B=(Z*+g[G+296>>2]+_*+g[G+300>>2]+D*+g[G+304>>2])*+g[G+552>>2];g[J+(H*152|0)+64>>2]=(+g[G+264>>2]*Z+ +g[G+268>>2]*_+ +g[G+272>>2]*D)*+g[G+544>>2];g[J+(H*152|0)+68>>2]=da;g[J+(H*152|0)+72>>2]=B;g[J+(H*152|0)+76>>2]=0.0;G=c[K+32>>2]|0;B=+g[J+(H*152|0)+32>>2];da=+g[J+(H*152|0)+36>>2];D=+g[J+(H*152|0)+40>>2];_=(B*+g[G+280>>2]+da*+g[G+284>>2]+D*+g[G+288>>2])*+g[G+548>>2];Z=(B*+g[G+296>>2]+da*+g[G+300>>2]+D*+g[G+304>>2])*+g[G+552>>2];g[J+(H*152|0)+80>>2]=(+g[G+264>>2]*B+ +g[G+268>>2]*da+ +g[G+272>>2]*D)*+g[G+544>>2];g[J+(H*152|0)+84>>2]=_;g[J+(H*152|0)+88>>2]=Z;g[J+(H*152|0)+92>>2]=0.0;Z=+g[S+344>>2];_=+g[J+(H*152|0)+16>>2];B=+g[J+(H*152|0)+20>>2];A=+g[J+(H*152|0)+24>>2];z=+g[J+(H*152|0)>>2];y=+g[J+(H*152|0)+4>>2];x=+g[J+(H*152|0)+8>>2];Y=+g[R+344>>2];w=+g[J+(H*152|0)+48>>2];v=+g[J+(H*152|0)+52>>2];C=+g[J+(H*152|0)+56>>2];r=+g[J+(H*152|0)+32>>2];D=_*(Z*_)+B*(Z*B)+A*(Z*A)+(z*(+g[S+264>>2]*z+ +g[S+268>>2]*y+ +g[S+272>>2]*x)+y*(z*+g[S+280>>2]+y*+g[S+284>>2]+x*+g[S+288>>2])+x*(z*+g[S+296>>2]+y*+g[S+300>>2]+x*+g[S+304>>2]))+(w*(Y*w)+v*(Y*v)+C*(Y*C))+(r*(+g[R+264>>2]*r+ +g[R+268>>2]*da+ +g[R+272>>2]*D)+da*(r*+g[R+280>>2]+da*+g[R+284>>2]+D*+g[R+288>>2])+D*(r*+g[R+296>>2]+da*+g[R+300>>2]+D*+g[R+304>>2]));G=+N(+D)>1.1920928955078125e-07;D=G?1.0/D:0.0;g[J+(H*152|0)+108>>2]=D;if(!(c[L+(P*244|0)+240>>2]|0)){u=0;e=0;t=0;q=0;p=0;o=0}else{u=c[L+(P*244|0)+208>>2]|0;e=c[L+(P*244|0)+212>>2]|0;t=c[L+(P*244|0)+216>>2]|0;q=c[L+(P*244|0)+224>>2]|0;p=c[L+(P*244|0)+228>>2]|0;o=c[L+(P*244|0)+232>>2]|0}if(!(c[L+(Q*244|0)+240>>2]|0)){d=0;s=0;n=0;E=0;F=0;G=0}else{d=c[L+(Q*244|0)+208>>2]|0;s=c[L+(Q*244|0)+212>>2]|0;n=c[L+(Q*244|0)+216>>2]|0;E=c[L+(Q*244|0)+224>>2]|0;F=c[L+(Q*244|0)+228>>2]|0;G=c[L+(Q*244|0)+232>>2]|0}Y=(c[k>>2]=u,+g[k>>2])+ +g[S+312>>2];da=(c[k>>2]=e,+g[k>>2])+ +g[S+316>>2];da=Y*+g[J+(H*152|0)+16>>2]+da*B+((c[k>>2]=t,+g[k>>2])+ +g[S+320>>2])*A;B=(c[k>>2]=q,+g[k>>2])+ +g[S+328>>2];A=(c[k>>2]=p,+g[k>>2])+ +g[S+332>>2];y=da+(B*z+A*y+((c[k>>2]=o,+g[k>>2])+ +g[S+336>>2])*x);A=(c[k>>2]=d,+g[k>>2])+ +g[R+312>>2];z=(c[k>>2]=s,+g[k>>2])+ +g[R+316>>2];z=A*w+z*v+((c[k>>2]=n,+g[k>>2])+ +g[R+320>>2])*C;A=(c[k>>2]=E,+g[k>>2])+ +g[R+328>>2];B=(c[k>>2]=F,+g[k>>2])+ +g[R+332>>2];g[J+(H*152|0)+112>>2]=+g[J+(H*152|0)+112>>2]*D+D*(0.0-+g[X+248+52>>2]*(y+(z+(A*r+B*+g[J+(H*152|0)+36>>2]+((c[k>>2]=G,+g[k>>2])+ +g[R+336>>2])*+g[J+(H*152|0)+40>>2]))));g[J+(H*152|0)+100>>2]=0.0;I=I+1|0}while((I|0)<(c[T>>2]|0))}n=c[b+176>>2]|0;q=c[n+(V<<3)>>2]|0}V=V+1|0;if((V|0)>=(l|0))break;else U=q+U|0}}nc[c[(c[b>>2]|0)+28>>2]&127](b,f,h,m);u=c[b+48>>2]|0;e=c[b+28>>2]|0;H=c[b+68>>2]|0;p=c[b+128>>2]|0;if((p|0)<(u|0)?(c[b+132>>2]|0)<(u|0):0){if(!u)o=0;else{c[2703]=(c[2703]|0)+1;p=XE((u<<2|3)+16|0)|0;if(!p)q=0;else{c[(p+4+15&-16)+-4>>2]=p;q=p+4+15&-16}p=c[b+128>>2]|0;o=q}q=c[b+136>>2]|0;if((p|0)<=0)if(!q)q=b+140|0;else W=99;else{n=0;do{c[o+(n<<2)>>2]=c[q+(n<<2)>>2];n=n+1|0}while((n|0)!=(p|0));W=99}if((W|0)==99){if(a[b+140>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[q+-4>>2]|0)}c[b+136>>2]=0;q=b+140|0}a[q>>0]=1;c[b+136>>2]=o;c[b+132>>2]=u}c[b+128>>2]=u;if(!(c[m+64>>2]&16)){p=c[b+108>>2]|0;if((p|0)<(e|0)?(c[b+112>>2]|0)<(e|0):0){if(!e)o=0;else{c[2703]=(c[2703]|0)+1;p=XE((e<<2|3)+16|0)|0;if(!p)o=0;else{c[(p+4+15&-16)+-4>>2]=p;o=p+4+15&-16}p=c[b+108>>2]|0}n=c[b+116>>2]|0;if((p|0)<=0)if(!n)p=b+120|0;else W=129;else{q=0;do{c[o+(q<<2)>>2]=c[n+(q<<2)>>2];q=q+1|0}while((q|0)!=(p|0));W=129}if((W|0)==129){if(a[b+120>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}c[b+116>>2]=0;p=b+120|0}a[p>>0]=1;c[b+116>>2]=o;c[b+112>>2]=e}c[b+108>>2]=e}else{p=c[b+108>>2]|0;if((p|0)<(e<<1|0)?(c[b+112>>2]|0)<(e<<1|0):0){if(!e)o=0;else{c[2703]=(c[2703]|0)+1;p=XE((e<<3|3)+16|0)|0;if(!p)o=0;else{c[(p+4+15&-16)+-4>>2]=p;o=p+4+15&-16}p=c[b+108>>2]|0}n=c[b+116>>2]|0;if((p|0)<=0)if(!n)p=b+120|0;else W=114;else{q=0;do{c[o+(q<<2)>>2]=c[n+(q<<2)>>2];q=q+1|0}while((q|0)!=(p|0));W=114}if((W|0)==114){if(a[b+120>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}c[b+116>>2]=0;p=b+120|0}a[p>>0]=1;c[b+116>>2]=o;c[b+112>>2]=e<<1}c[b+108>>2]=e<<1}p=c[b+148>>2]|0;if((p|0)<(H|0)?(c[b+152>>2]|0)<(H|0):0){if(!H)o=0;else{c[2703]=(c[2703]|0)+1;p=XE((H<<2|3)+16|0)|0;if(!p)o=0;else{c[(p+4+15&-16)+-4>>2]=p;o=p+4+15&-16}p=c[b+148>>2]|0}n=c[b+156>>2]|0;if((p|0)<=0)if(!n)p=b+160|0;else W=144;else{q=0;do{c[o+(q<<2)>>2]=c[n+(q<<2)>>2];q=q+1|0}while((q|0)!=(p|0));W=144}if((W|0)==144){if(a[b+160>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}c[b+156>>2]=0;p=b+160|0}a[p>>0]=1;c[b+156>>2]=o;c[b+152>>2]=H}c[b+148>>2]=H;if((u|0)>0){p=c[b+136>>2]|0;o=0;do{c[p+(o<<2)>>2]=o;o=o+1|0}while((o|0)!=(u|0))}if((e|0)>0){p=c[b+116>>2]|0;o=0;do{c[p+(o<<2)>>2]=o;o=o+1|0}while((o|0)!=(e|0))}if((H|0)>0){o=c[b+156>>2]|0;p=0;do{c[o+(p<<2)>>2]=p;p=p+1|0}while((p|0)!=(H|0))}o=c[2700]|0;S=(c[o+16>>2]|0)+-1|0;c[o+16>>2]=S;if(S){i=X;return 0.0}do if(c[o+4>>2]|0){vb(X+248|0,0)|0;S=c[2702]|0;g[o+8>>2]=+(((c[X+248+4>>2]|0)-(c[S+4>>2]|0)+(((c[X+248>>2]|0)-(c[S>>2]|0)|0)*1e6|0)-(c[o+12>>2]|0)|0)>>>0)/1.0e3+ +g[o+8>>2];if(!(c[o+16>>2]|0)){o=c[2700]|0;break}else{i=X;return 0.0}}while(0);c[2700]=c[o+20>>2];i=X;return 0.0}function $r(b,d,e,f,h,i,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0;f=c[b+48>>2]|0;q=c[b+28>>2]|0;r=c[b+68>>2]|0;if(c[l+64>>2]&1){if((f|0)>0){h=c[b+136>>2]|0;i=c[b+192>>2]|0;p=0;do{m=h+(p<<2)|0;e=c[m>>2]|0;p=p+1|0;i=(_(i,1664525)|0)+1013904223|0;if(p>>>0<65537){o=i>>>16^i;if(p>>>0<257)if(p>>>0<17){o=(o>>>8^o)>>>4^(o>>>8^o);if(p>>>0<5)if(p>>>0<3)o=(o>>>2^o)>>>1^(o>>>2^o);else o=o>>>2^o}else o=o>>>8^o}else o=i;o=h+(((o>>>0)%(p>>>0)|0)<<2)|0;c[m>>2]=c[o>>2];c[o>>2]=e}while((p|0)!=(f|0));c[b+192>>2]=i}if((c[l+20>>2]|0)>(d|0)){if((q|0)>0){e=c[b+116>>2]|0;h=c[b+192>>2]|0;m=0;do{i=e+(m<<2)|0;f=c[i>>2]|0;m=m+1|0;h=(_(h,1664525)|0)+1013904223|0;if(m>>>0<65537){o=h>>>16^h;if(m>>>0<257)if(m>>>0<17){o=(o>>>8^o)>>>4^(o>>>8^o);if(m>>>0<5)if(m>>>0<3)o=(o>>>2^o)>>>1^(o>>>2^o);else o=o>>>2^o}else o=o>>>8^o}else o=h;p=e+(((o>>>0)%(m>>>0)|0)<<2)|0;c[i>>2]=c[p>>2];c[p>>2]=f}while((m|0)!=(q|0));c[b+192>>2]=h}if((r|0)>0){e=c[b+156>>2]|0;h=c[b+192>>2]|0;m=0;do{i=e+(m<<2)|0;f=c[i>>2]|0;m=m+1|0;h=(_(h,1664525)|0)+1013904223|0;if(m>>>0<65537){o=h>>>16^h;if(m>>>0<257)if(m>>>0<17){o=(o>>>8^o)>>>4^(o>>>8^o);if(m>>>0<5)if(m>>>0<3)o=(o>>>2^o)>>>1^(o>>>2^o);else o=o>>>2^o}else o=o>>>8^o}else o=h;q=e+(((o>>>0)%(m>>>0)|0)<<2)|0;c[i>>2]=c[q>>2];c[q>>2]=f}while((m|0)!=(r|0));c[b+192>>2]=h}}}f=c[b+48>>2]|0;if(!(c[l+64>>2]&256)){if((f|0)>0){m=0;do{h=c[(c[b+136>>2]|0)+(m<<2)>>2]|0;i=c[b+56>>2]|0;if((c[i+(h*152|0)+136>>2]|0)>(d|0)){f=c[b+16>>2]|0;Rr(f+((c[i+(h*152|0)+144>>2]|0)*244|0)|0,f+((c[i+(h*152|0)+148>>2]|0)*244|0)|0,i+(h*152|0)|0);f=c[b+48>>2]|0}m=m+1|0}while((m|0)<(f|0))}if((c[l+20>>2]|0)<=(d|0))return 0.0;if((k|0)>0){i=0;do{h=j+(i<<2)|0;f=c[h>>2]|0;if(a[f+20>>0]|0){q=Yr(b,c[f+28>>2]|0,+g[l+12>>2])|0;d=Yr(b,c[(c[h>>2]|0)+32>>2]|0,+g[l+12>>2])|0;r=c[b+16>>2]|0;p=c[h>>2]|0;ic[c[(c[p>>2]|0)+24>>2]&15](p,r+(q*244|0)|0,r+(d*244|0)|0,+g[l+12>>2])}i=i+1|0}while((i|0)!=(k|0))}m=c[b+28>>2]|0;if((m|0)>0){i=0;do{d=c[(c[b+116>>2]|0)+(i<<2)>>2]|0;r=c[b+36>>2]|0;q=c[b+16>>2]|0;Sr(q+((c[r+(d*152|0)+144>>2]|0)*244|0)|0,q+((c[r+(d*152|0)+148>>2]|0)*244|0)|0,r+(d*152|0)|0);i=i+1|0}while((i|0)!=(m|0))}h=c[b+68>>2]|0;if((h|0)>0){f=0;do{i=c[(c[b+156>>2]|0)+(f<<2)>>2]|0;m=c[b+76>>2]|0;n=+g[(c[b+36>>2]|0)+((c[m+(i*152|0)+140>>2]|0)*152|0)+100>>2];if(n>0.0){n=n*+g[m+(i*152|0)+104>>2];g[m+(i*152|0)+120>>2]=-n;g[m+(i*152|0)+124>>2]=n;d=c[b+16>>2]|0;Rr(d+((c[m+(i*152|0)+144>>2]|0)*244|0)|0,d+((c[m+(i*152|0)+148>>2]|0)*244|0)|0,m+(i*152|0)|0)}f=f+1|0}while((f|0)!=(h|0))}i=c[b+88>>2]|0;if((i|0)<=0)return 0.0;h=0;do{m=c[b+96>>2]|0;n=+g[(c[b+36>>2]|0)+((c[m+(h*152|0)+140>>2]|0)*152|0)+100>>2];if(n>0.0){u=+g[m+(h*152|0)+104>>2];n=n*u>u?u:n*u;g[m+(h*152|0)+120>>2]=-n;g[m+(h*152|0)+124>>2]=n;d=c[b+16>>2]|0;Rr(d+((c[m+(h*152|0)+144>>2]|0)*244|0)|0,d+((c[m+(h*152|0)+148>>2]|0)*244|0)|0,m+(h*152|0)|0)}h=h+1|0}while((h|0)!=(i|0));return 0.0}if((f|0)>0){o=0;do{h=c[(c[b+136>>2]|0)+(o<<2)>>2]|0;i=c[b+56>>2]|0;if((c[i+(h*152|0)+136>>2]|0)>(d|0)){f=c[b+16>>2]|0;Rr(f+((c[i+(h*152|0)+144>>2]|0)*244|0)|0,f+((c[i+(h*152|0)+148>>2]|0)*244|0)|0,i+(h*152|0)|0);f=c[b+48>>2]|0}o=o+1|0}while((o|0)<(f|0))}if((c[l+20>>2]|0)<=(d|0))return 0.0;if((k|0)>0){i=0;do{h=j+(i<<2)|0;f=c[h>>2]|0;if(a[f+20>>0]|0){q=Yr(b,c[f+28>>2]|0,+g[l+12>>2])|0;d=Yr(b,c[(c[h>>2]|0)+32>>2]|0,+g[l+12>>2])|0;r=c[b+16>>2]|0;p=c[h>>2]|0;ic[c[(c[p>>2]|0)+24>>2]&15](p,r+(q*244|0)|0,r+(d*244|0)|0,+g[l+12>>2])}i=i+1|0}while((i|0)!=(k|0))}f=c[l+64>>2]|0;o=c[b+28>>2]|0;if(f&512){if((o|0)<=0)return 0.0;m=0;do{e=c[(c[b+116>>2]|0)+(m<<2)>>2]|0;h=c[b+36>>2]|0;i=c[b+16>>2]|0;Sr(i+((c[h+(e*152|0)+144>>2]|0)*244|0)|0,i+((c[h+(e*152|0)+148>>2]|0)*244|0)|0,h+(e*152|0)|0);n=+g[h+(e*152|0)+100>>2];e=_(m,(f>>>4&1)+1|0)|0;h=c[(c[b+156>>2]|0)+(e<<2)>>2]|0;i=c[b+76>>2]|0;if(n>0.0){u=n*+g[i+(h*152|0)+104>>2];g[i+(h*152|0)+120>>2]=-u;g[i+(h*152|0)+124>>2]=u;d=c[b+16>>2]|0;Rr(d+((c[i+(h*152|0)+144>>2]|0)*244|0)|0,d+((c[i+(h*152|0)+148>>2]|0)*244|0)|0,i+(h*152|0)|0)}if((c[l+64>>2]&16|0)!=0?(s=c[(c[b+156>>2]|0)+(e+1<<2)>>2]|0,t=c[b+76>>2]|0,n>0.0):0){n=n*+g[t+(s*152|0)+104>>2];g[t+(s*152|0)+120>>2]=-n;g[t+(s*152|0)+124>>2]=n;d=c[b+16>>2]|0;Rr(d+((c[t+(s*152|0)+144>>2]|0)*244|0)|0,d+((c[t+(s*152|0)+148>>2]|0)*244|0)|0,t+(s*152|0)|0)}m=m+1|0}while((m|0)!=(o|0));return 0.0}if((o|0)>0){m=0;do{d=c[(c[b+116>>2]|0)+(m<<2)>>2]|0;r=c[b+36>>2]|0;q=c[b+16>>2]|0;Sr(q+((c[r+(d*152|0)+144>>2]|0)*244|0)|0,q+((c[r+(d*152|0)+148>>2]|0)*244|0)|0,r+(d*152|0)|0);m=m+1|0}while((m|0)!=(o|0))}h=c[b+68>>2]|0;if((h|0)>0){f=0;do{i=c[(c[b+156>>2]|0)+(f<<2)>>2]|0;m=c[b+76>>2]|0;n=+g[(c[b+36>>2]|0)+((c[m+(i*152|0)+140>>2]|0)*152|0)+100>>2];if(n>0.0){n=n*+g[m+(i*152|0)+104>>2];g[m+(i*152|0)+120>>2]=-n;g[m+(i*152|0)+124>>2]=n;d=c[b+16>>2]|0;Rr(d+((c[m+(i*152|0)+144>>2]|0)*244|0)|0,d+((c[m+(i*152|0)+148>>2]|0)*244|0)|0,m+(i*152|0)|0)}f=f+1|0}while((f|0)!=(h|0))}i=c[b+88>>2]|0;if((i|0)<=0)return 0.0;h=0;do{m=c[b+96>>2]|0;n=+g[(c[b+36>>2]|0)+((c[m+(h*152|0)+140>>2]|0)*152|0)+100>>2];if(n>0.0){u=+g[m+(h*152|0)+104>>2];n=n*u>u?u:n*u;g[m+(h*152|0)+120>>2]=-n;g[m+(h*152|0)+124>>2]=n;d=c[b+16>>2]|0;Rr(d+((c[m+(h*152|0)+144>>2]|0)*244|0)|0,d+((c[m+(h*152|0)+148>>2]|0)*244|0)|0,m+(h*152|0)|0)}h=h+1|0}while((h|0)!=(i|0));return 0.0}function as(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;if(!(c[i+44>>2]|0))return;j=c[i+20>>2]|0;if(!(c[i+64>>2]&256)){if((j|0)<=0)return;b=0;do{g=c[a+28>>2]|0;if((g|0)>0){j=0;do{e=c[(c[a+116>>2]|0)+(j<<2)>>2]|0;d=c[a+36>>2]|0;h=c[a+16>>2]|0;Tr(h+((c[d+(e*152|0)+144>>2]|0)*244|0)|0,h+((c[d+(e*152|0)+148>>2]|0)*244|0)|0,d+(e*152|0)|0);j=j+1|0}while((j|0)!=(g|0));j=c[i+20>>2]|0}b=b+1|0}while((b|0)<(j|0));return}else{if((j|0)<=0)return;b=0;do{g=c[a+28>>2]|0;if((g|0)>0){j=0;do{e=c[(c[a+116>>2]|0)+(j<<2)>>2]|0;d=c[a+36>>2]|0;h=c[a+16>>2]|0;Tr(h+((c[d+(e*152|0)+144>>2]|0)*244|0)|0,h+((c[d+(e*152|0)+148>>2]|0)*244|0)|0,d+(e*152|0)|0);j=j+1|0}while((j|0)!=(g|0));j=c[i+20>>2]|0}b=b+1|0}while((b|0)<(j|0));return}}function bs(a,b,d,e,f,h,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0;o=i;i=i+16|0;iE(13318);Yb[c[(c[a>>2]|0)+32>>2]&1](a,b,d,e,f,h,j,k,l);n=c[a+184>>2]|0;m=c[k+20>>2]|0;m=(n|0)>(m|0)?n:m;if((m|0)>0){n=0;do{+ac[c[(c[a>>2]|0)+40>>2]&3](a,n,b,d,e,f,h,j,k,l);n=n+1|0}while((n|0)<(m|0))}m=c[2700]|0;f=(c[m+16>>2]|0)+-1|0;c[m+16>>2]=f;if(f){i=o;return 0.0}do if(c[m+4>>2]|0){vb(o|0,0)|0;f=c[2702]|0;g[m+8>>2]=+(((c[o+4>>2]|0)-(c[f+4>>2]|0)+(((c[o>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[m+12>>2]|0)|0)>>>0)/1.0e3+ +g[m+8>>2];if(!(c[m+16>>2]|0)){m=c[2700]|0;break}else{i=o;return 0.0}}while(0);c[2700]=c[m+20>>2];i=o;return 0.0}function cs(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0;r=i;i=i+80|0;d=c[b+28>>2]|0;e=c[f+64>>2]|0;if((e&4|0)!=0&(d|0)>0){l=c[b+36>>2]|0;j=c[b+76>>2]|0;if(!(e&16)){e=0;do{h=c[l+(e*152|0)+132>>2]|0;c[h+120>>2]=c[l+(e*152|0)+100>>2];c[h+124>>2]=c[j+((c[l+(e*152|0)+140>>2]|0)*152|0)+100>>2];e=e+1|0}while((e|0)!=(d|0))}else{e=0;do{h=c[l+(e*152|0)+132>>2]|0;c[h+120>>2]=c[l+(e*152|0)+100>>2];m=c[l+(e*152|0)+140>>2]|0;c[h+124>>2]=c[j+(m*152|0)+100>>2];c[h+128>>2]=c[j+((m+1|0)*152|0)+100>>2];e=e+1|0}while((e|0)!=(d|0))}}d=c[b+48>>2]|0;if((d|0)>0){m=0;do{h=c[b+56>>2]|0;j=c[h+(m*152|0)+132>>2]|0;l=c[j+44>>2]|0;e=h+(m*152|0)+100|0;if(l){n=+g[e>>2];s=c[j+28>>2]|0;o=1.0/+g[f+12>>2];p=n*+g[h+(m*152|0)+20>>2]*+g[s+352>>2]*o;q=n*+g[h+(m*152|0)+24>>2]*+g[s+356>>2]*o;g[l>>2]=+g[h+(m*152|0)+16>>2]*n*+g[s+348>>2]*o+ +g[l>>2];g[l+4>>2]=p+ +g[l+4>>2];g[l+8>>2]=q+ +g[l+8>>2];q=+g[e>>2];s=c[j+32>>2]|0;p=1.0/+g[f+12>>2];o=q*+g[h+(m*152|0)+52>>2]*+g[s+352>>2]*p;n=q*+g[h+(m*152|0)+56>>2]*+g[s+356>>2]*p;g[l+32>>2]=+g[h+(m*152|0)+48>>2]*q*+g[s+348>>2]*p+ +g[l+32>>2];g[l+36>>2]=o+ +g[l+36>>2];g[l+40>>2]=n+ +g[l+40>>2];s=c[j+28>>2]|0;n=+g[e>>2];o=1.0/+g[f+12>>2];p=+g[h+(m*152|0)+4>>2]*+g[s+548>>2]*n*o;q=n*(+g[h+(m*152|0)+8>>2]*+g[s+552>>2])*o;g[l+16>>2]=+g[h+(m*152|0)>>2]*+g[s+544>>2]*n*o+ +g[l+16>>2];g[l+20>>2]=p+ +g[l+20>>2];g[l+24>>2]=q+ +g[l+24>>2];s=c[j+32>>2]|0;q=+g[e>>2];p=1.0/+g[f+12>>2];o=+g[h+(m*152|0)+36>>2]*+g[s+548>>2]*q*p;n=q*(+g[h+(m*152|0)+40>>2]*+g[s+552>>2])*p;g[l+48>>2]=+g[h+(m*152|0)+32>>2]*+g[s+544>>2]*q*p+ +g[l+48>>2];g[l+52>>2]=o+ +g[l+52>>2];g[l+56>>2]=n+ +g[l+56>>2]}e=c[e>>2]|0;c[j+36>>2]=e;n=+N(+(c[k>>2]=e,+g[k>>2]));if(n>=+g[j+16>>2])a[j+20>>0]=0;m=m+1|0}while((m|0)!=(d|0))}d=c[b+8>>2]|0;if((d|0)>0){j=0;do{m=c[b+16>>2]|0;l=m+(j*244|0)|0;e=c[m+(j*244|0)+240>>2]|0;if(e){if(!(c[f+44>>2]|0)){l=m+(j*244|0)+176|0;q=+g[m+(j*244|0)+64>>2]+ +g[l>>2];g[l>>2]=q;l=m+(j*244|0)+180|0;p=+g[m+(j*244|0)+68>>2]+ +g[l>>2];g[l>>2]=p;l=m+(j*244|0)+184|0;n=+g[m+(j*244|0)+72>>2]+ +g[l>>2];g[l>>2]=n;l=m+(j*244|0)+192|0;g[l>>2]=+g[m+(j*244|0)+80>>2]+ +g[l>>2];l=m+(j*244|0)+196|0;g[l>>2]=+g[m+(j*244|0)+84>>2]+ +g[l>>2];l=m+(j*244|0)+200|0;g[l>>2]=+g[m+(j*244|0)+88>>2]+ +g[l>>2];l=m}else{n=+g[f+12>>2];o=+g[f+52>>2];d=m+(j*244|0)+176|0;g[d>>2]=+g[m+(j*244|0)+64>>2]+ +g[d>>2];d=m+(j*244|0)+180|0;g[d>>2]=+g[m+(j*244|0)+68>>2]+ +g[d>>2];d=m+(j*244|0)+184|0;g[d>>2]=+g[m+(j*244|0)+72>>2]+ +g[d>>2];d=m+(j*244|0)+192|0;g[d>>2]=+g[m+(j*244|0)+80>>2]+ +g[d>>2];d=m+(j*244|0)+196|0;g[d>>2]=+g[m+(j*244|0)+84>>2]+ +g[d>>2];d=m+(j*244|0)+200|0;g[d>>2]=+g[m+(j*244|0)+88>>2]+ +g[d>>2];p=+g[m+(j*244|0)+144>>2];q=+g[m+(j*244|0)+148>>2];if(!((((!(p!=0.0|q!=0.0)?!(+g[m+(j*244|0)+152>>2]!=0.0):0)?!(+g[m+(j*244|0)+160>>2]!=0.0):0)?!(+g[m+(j*244|0)+164>>2]!=0.0):0)?!(+g[m+(j*244|0)+168>>2]!=0.0):0)){u=+g[m+(j*244|0)+164>>2]*o;t=+g[m+(j*244|0)+168>>2]*o;g[r>>2]=+g[m+(j*244|0)+160>>2]*o;g[r+4>>2]=u;g[r+8>>2]=t;g[r+12>>2]=0.0;Ap(l,p,q,+g[m+(j*244|0)+152>>2],r,n,r+16|0);c[l>>2]=c[r+16>>2];c[l+4>>2]=c[r+16+4>>2];c[l+8>>2]=c[r+16+8>>2];c[l+12>>2]=c[r+16+12>>2];e=m+(j*244|0)+16|0;c[e>>2]=c[r+16+16>>2];c[e+4>>2]=c[r+16+16+4>>2];c[e+8>>2]=c[r+16+16+8>>2];c[e+12>>2]=c[r+16+16+12>>2];e=m+(j*244|0)+32|0;c[e>>2]=c[r+16+32>>2];c[e+4>>2]=c[r+16+32+4>>2];c[e+8>>2]=c[r+16+32+8>>2];c[e+12>>2]=c[r+16+32+12>>2];e=m+(j*244|0)+48|0;c[e>>2]=c[r+16+48>>2];c[e+4>>2]=c[r+16+48+4>>2];c[e+8>>2]=c[r+16+48+8>>2];c[e+12>>2]=c[r+16+48+12>>2];e=c[b+16>>2]|0;m=e;e=c[e+(j*244|0)+240>>2]|0}l=m;q=+g[m+(j*244|0)+176>>2];p=+g[m+(j*244|0)+180>>2];n=+g[m+(j*244|0)+184>>2]}q=q+ +g[l+(j*244|0)+208>>2];o=p+ +g[l+(j*244|0)+212>>2];p=n+ +g[l+(j*244|0)+216>>2];d=e+260|0;c[d>>2]=(c[d>>2]|0)+1;g[e+312>>2]=q;g[e+316>>2]=o;g[e+320>>2]=p;g[e+324>>2]=0.0;e=c[b+16>>2]|0;d=c[e+(j*244|0)+240>>2]|0;p=+g[e+(j*244|0)+192>>2]+ +g[e+(j*244|0)+224>>2];o=+g[e+(j*244|0)+196>>2]+ +g[e+(j*244|0)+228>>2];n=+g[e+(j*244|0)+200>>2]+ +g[e+(j*244|0)+232>>2];c[d+260>>2]=(c[d+260>>2]|0)+1;g[d+328>>2]=p;g[d+332>>2]=o;g[d+336>>2]=n;g[d+340>>2]=0.0;if(c[f+44>>2]|0){e=c[b+16>>2]|0;d=c[e+(j*244|0)+240>>2]|0;h=e+(j*244|0)|0;c[d+260>>2]=(c[d+260>>2]|0)+1;c[d+4>>2]=c[h>>2];c[d+4+4>>2]=c[h+4>>2];c[d+4+8>>2]=c[h+8>>2];c[d+4+12>>2]=c[h+12>>2];h=e+(j*244|0)+16|0;c[d+20>>2]=c[h>>2];c[d+20+4>>2]=c[h+4>>2];c[d+20+8>>2]=c[h+8>>2];c[d+20+12>>2]=c[h+12>>2];h=e+(j*244|0)+32|0;c[d+36>>2]=c[h>>2];c[d+36+4>>2]=c[h+4>>2];c[d+36+8>>2]=c[h+8>>2];c[d+36+12>>2]=c[h+12>>2];e=e+(j*244|0)+48|0;c[d+52>>2]=c[e>>2];c[d+52+4>>2]=c[e+4>>2];c[d+52+8>>2]=c[e+8>>2];c[d+52+12>>2]=c[e+12>>2]}c[(c[(c[b+16>>2]|0)+(j*244|0)+240>>2]|0)+212>>2]=-1;d=c[b+8>>2]|0}j=j+1|0}while((j|0)<(d|0))}if((c[b+28>>2]|0)<0?(c[b+32>>2]|0)<0:0){d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+32>>2]=0}c[b+28>>2]=0;if((c[b+48>>2]|0)<0?(c[b+52>>2]|0)<0:0){d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+52>>2]=0}c[b+48>>2]=0;if((c[b+68>>2]|0)<0?(c[b+72>>2]|0)<0:0){d=c[b+76>>2]|0;if(d){if(a[b+80>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+72>>2]=0}c[b+68>>2]=0;if((c[b+88>>2]|0)<0?(c[b+92>>2]|0)<0:0){d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+92>>2]=0}c[b+88>>2]=0;if((c[b+8>>2]|0)>=0){c[b+8>>2]=0;i=r;return 0.0}if((c[b+12>>2]|0)>=0){c[b+8>>2]=0;i=r;return 0.0}d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+12>>2]=0;c[b+8>>2]=0;i=r;return 0.0}function ds(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0;n=i;i=i+16|0;iE(13352);+cc[c[(c[a>>2]|0)+44>>2]&3](a,b,d,e,f,h,j,k,l);+cc[c[(c[a>>2]|0)+48>>2]&3](a,b,d,e,f,h,j,k,l);+gc[c[(c[a>>2]|0)+36>>2]&1](a,b,d,k);m=c[2700]|0;a=(c[m+16>>2]|0)+-1|0;c[m+16>>2]=a;if(a){i=n;return 0.0}do if(c[m+4>>2]|0){vb(n|0,0)|0;a=c[2702]|0;g[m+8>>2]=+(((c[n+4>>2]|0)-(c[a+4>>2]|0)+(((c[n>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[m+12>>2]|0)|0)>>>0)/1.0e3+ +g[m+8>>2];if(!(c[m+16>>2]|0)){m=c[2700]|0;break}else{i=n;return 0.0}}while(0);c[2700]=c[m+20>>2];i=n;return 0.0}function es(a){a=a|0;c[a+192>>2]=0;return}function fs(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;i=c[b+4>>2]|0;if((i|0)==(c[b+8>>2]|0)?(h=(i|0)!=0?i<<1:1,(i|0)<(h|0)):0){if(!h){f=i;g=0}else{c[2703]=(c[2703]|0)+1;e=XE((h*244|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[b+4>>2]|0;g=e}if((f|0)>0){e=0;do{k=g+(e*244|0)|0;j=c[b+12>>2]|0;l=j+(e*244|0)|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=g+(e*244|0)+16|0;l=j+(e*244|0)+16|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=g+(e*244|0)+32|0;l=j+(e*244|0)+32|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=g+(e*244|0)+48|0;l=j+(e*244|0)+48|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];uF(g+(e*244|0)+64|0,j+(e*244|0)+64|0,180)|0;e=e+1|0}while((e|0)!=(f|0))}e=c[b+12>>2]|0;if(e){if(a[b+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=g;c[b+8>>2]=h;e=c[b+4>>2]|0}else e=i;c[b+4>>2]=e+1;e=c[b+12>>2]|0;c[e+(i*244|0)>>2]=c[d>>2];c[e+(i*244|0)+4>>2]=c[d+4>>2];c[e+(i*244|0)+8>>2]=c[d+8>>2];c[e+(i*244|0)+12>>2]=c[d+12>>2];c[e+(i*244|0)+16>>2]=c[d+16>>2];c[e+(i*244|0)+16+4>>2]=c[d+16+4>>2];c[e+(i*244|0)+16+8>>2]=c[d+16+8>>2];c[e+(i*244|0)+16+12>>2]=c[d+16+12>>2];c[e+(i*244|0)+32>>2]=c[d+32>>2];c[e+(i*244|0)+32+4>>2]=c[d+32+4>>2];c[e+(i*244|0)+32+8>>2]=c[d+32+8>>2];c[e+(i*244|0)+32+12>>2]=c[d+32+12>>2];c[e+(i*244|0)+48>>2]=c[d+48>>2];c[e+(i*244|0)+48+4>>2]=c[d+48+4>>2];c[e+(i*244|0)+48+8>>2]=c[d+48+8>>2];c[e+(i*244|0)+48+12>>2]=c[d+48+12>>2];uF(e+(i*244|0)+64|0,d+64|0,180)|0;return (c[b+12>>2]|0)+(i*244|0)|0}function gs(a,b,c){a=a|0;b=b|0;c=c|0;return}function hs(a,b,c){a=a|0;b=b|0;c=c|0;return}function is(a){a=a|0;return 1}function js(b){b=b|0;var d=0;c[b>>2]=4316;d=c[b+144>>2]|0;if(d){if(a[b+148>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+144>>2]=0}a[b+148>>0]=1;c[b+144>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;d=c[b+76>>2]|0;if(d){if(a[b+80>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;return}if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;return}function ks(a){a=a|0;js(a);YE(a);return}function ls(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;h=i;i=i+64|0;a[d+84>>0]=0;c[h>>2]=c[b+4>>2];c[h+4>>2]=c[b+4+4>>2];c[h+8>>2]=c[b+4+8>>2];c[h+12>>2]=c[b+4+12>>2];c[h+16>>2]=c[b+20>>2];c[h+16+4>>2]=c[b+20+4>>2];c[h+16+8>>2]=c[b+20+8>>2];c[h+16+12>>2]=c[b+20+12>>2];c[h+32>>2]=c[b+36>>2];c[h+32+4>>2]=c[b+36+4>>2];c[h+32+8>>2]=c[b+36+8>>2];c[h+32+12>>2]=c[b+36+12>>2];c[h+48>>2]=c[b+52>>2];c[h+48+4>>2]=c[b+52+4>>2];c[h+48+8>>2]=c[b+52+8>>2];c[h+48+12>>2]=c[b+52+12>>2];if(e?(f=c[b+480>>2]|0,(f|0)!=0):0)Fb[c[(c[f>>2]|0)+8>>2]&127](f,h);w=+g[d+156>>2];u=+g[h>>2];v=+g[d+160>>2];t=+g[h+4>>2];o=+g[d+164>>2];s=+g[h+8>>2];r=+g[h+16>>2];q=+g[h+20>>2];p=+g[h+24>>2];n=+g[h+32>>2];l=+g[h+36>>2];j=+g[h+40>>2];m=w*r+v*q+o*p+ +g[h+52>>2];k=w*n+v*l+o*j+ +g[h+56>>2];g[d+36>>2]=w*u+v*t+o*s+ +g[h+48>>2];g[d+40>>2]=m;g[d+44>>2]=k;g[d+48>>2]=0.0;k=+g[d+172>>2];m=+g[d+176>>2];o=+g[d+180>>2];g[d+52>>2]=u*k+t*m+s*o;g[d+56>>2]=k*r+m*q+o*p;g[d+60>>2]=k*n+m*l+o*j;g[d+64>>2]=0.0;o=+g[d+188>>2];m=+g[d+192>>2];k=+g[d+196>>2];g[d+68>>2]=u*o+t*m+s*k;g[d+72>>2]=o*r+m*q+k*p;g[d+76>>2]=o*n+m*l+k*j;g[d+80>>2]=0.0;i=h;return}function ms(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;ls(a,b+(c*284|0)|0,d);m=+g[b+(c*284|0)+52>>2];h=+g[b+(c*284|0)+56>>2];q=+g[b+(c*284|0)+60>>2];G=+g[b+(c*284|0)+76>>2];x=+g[b+(c*284|0)+72>>2];z=+g[b+(c*284|0)+68>>2];w=1.0/+O(+((x*-m-z*-h)*(x*-m-z*-h)+((G*-h-x*-q)*(G*-h-x*-q)+(z*-q-G*-m)*(z*-q-G*-m))));v=(G*-h-x*-q)*w;u=w*(z*-q-G*-m);w=w*(x*-m-z*-h);e=+g[b+(c*284|0)+232>>2]*.5;k=+R(+e)/+O(+(m*m+h*h+q*q));e=+Q(+e);l=2.0/(e*e+(k*-q*(k*-q)+(k*-m*(k*-m)+k*-h*(k*-h))));E=1.0-(k*-h*(k*-h*l)+k*-q*(k*-q*l));D=k*-m*(k*-h*l)-e*(k*-q*l);F=k*-m*(k*-q*l)+e*(k*-h*l);B=k*-m*(k*-h*l)+e*(k*-q*l);A=1.0-(k*-m*(k*-m*l)+k*-q*(k*-q*l));C=k*-h*(k*-q*l)-e*(k*-m*l);j=k*-m*(k*-q*l)-e*(k*-h*l);e=k*-h*(k*-q*l)+e*(k*-m*l);l=1.0-(k*-m*(k*-m*l)+k*-h*(k*-h*l));k=+g[b+(c*284|0)+236>>2]*-.5;y=+R(+k)/+O(+(G*G+(x*x+z*z)));k=+Q(+k);r=2.0/(k*k+(G*y*(G*y)+(z*y*(z*y)+x*y*(x*y))));n=1.0-(x*y*(x*y*r)+G*y*(G*y*r));i=z*y*(x*y*r)-k*(G*y*r);t=z*y*(G*y*r)+k*(x*y*r);o=z*y*(x*y*r)+k*(G*y*r);f=1.0-(z*y*(z*y*r)+G*y*(G*y*r));s=x*y*(G*y*r)-k*(z*y*r);p=z*y*(G*y*r)-k*(x*y*r);k=x*y*(G*y*r)+k*(z*y*r);r=1.0-(z*y*(z*y*r)+x*y*(x*y*r));y=+g[b+(c*284|0)+68>>2];x=+g[b+(c*284|0)+72>>2];z=+g[b+(c*284|0)+76>>2];g[b+(c*284|0)+92>>2]=z*(E*t+D*s+F*r)+(y*(F*p+(D*o+E*n))+x*(F*k+(E*i+D*f)));g[b+(c*284|0)+96>>2]=w*(E*t+D*s+F*r)+(v*(F*p+(D*o+E*n))+u*(F*k+(E*i+D*f)));g[b+(c*284|0)+100>>2]=(E*t+D*s+F*r)*-q+((F*p+(D*o+E*n))*-m+(F*k+(E*i+D*f))*-h);g[b+(c*284|0)+104>>2]=0.0;g[b+(c*284|0)+108>>2]=z*(B*t+A*s+C*r)+(y*(C*p+(A*o+B*n))+x*(C*k+(B*i+A*f)));g[b+(c*284|0)+112>>2]=w*(B*t+A*s+C*r)+(v*(C*p+(A*o+B*n))+u*(C*k+(B*i+A*f)));g[b+(c*284|0)+116>>2]=(B*t+A*s+C*r)*-q+((C*p+(A*o+B*n))*-m+(C*k+(B*i+A*f))*-h);g[b+(c*284|0)+120>>2]=0.0;g[b+(c*284|0)+124>>2]=z*(j*t+e*s+l*r)+(y*(l*p+(e*o+j*n))+x*(l*k+(j*i+e*f)));g[b+(c*284|0)+128>>2]=w*(j*t+e*s+l*r)+(v*(l*p+(e*o+j*n))+u*(l*k+(j*i+e*f)));g[b+(c*284|0)+132>>2]=(j*t+e*s+l*r)*-q+((l*p+(e*o+j*n))*-m+(l*k+(j*i+e*f))*-h);g[b+(c*284|0)+136>>2]=0.0;h=+g[b+(c*284|0)+32>>2];f=h*+g[b+(c*284|0)+56>>2]+ +g[b+(c*284|0)+40>>2];e=h*+g[b+(c*284|0)+60>>2]+ +g[b+(c*284|0)+44>>2];g[b+(c*284|0)+140>>2]=+g[b+(c*284|0)+52>>2]*h+ +g[b+(c*284|0)+36>>2];g[b+(c*284|0)+144>>2]=f;g[b+(c*284|0)+148>>2]=e;g[b+(c*284|0)+152>>2]=0.0;return}function ns(b,d){b=b|0;d=+d;var e=0,f=0,h=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0.0,G=0.0;D=i;i=i+96|0;e=c[b+136>>2]|0;if((e|0)>0){f=0;do{ms(c[b+116>>2]|0,c[b+144>>2]|0,f,0);f=f+1|0;e=c[b+136>>2]|0}while((f|0)<(e|0));C=b+116|0}else C=b+116|0;f=c[C>>2]|0;s=+g[f+312>>2];u=+g[f+316>>2];h=+g[f+320>>2];h=+O(+(s*s+u*u+h*h))*3.5999999046325684;g[b+112>>2]=h;z=c[b+128>>2]|0;if(+g[f+4+(z<<2)>>2]*+g[f+312>>2]+ +g[f+20+(z<<2)>>2]*+g[f+316>>2]+ +g[f+36+(z<<2)>>2]*+g[f+320>>2]<0.0)g[b+112>>2]=-h;a:do if((e|0)>0){B=0;do{A=c[b+144>>2]|0;e=A+(B*284|0)|0;ls(f,e,0);j=A+(B*284|0)+204|0;k=A+(B*284|0)+212|0;q=+g[j>>2]+ +g[k>>2];f=A+(B*284|0)+52|0;v=A+(B*284|0)+56|0;w=A+(B*284|0)+60|0;E=A+(B*284|0)+36|0;x=A+(B*284|0)+16|0;s=q*+g[v>>2]+ +g[A+(B*284|0)+40>>2];u=q*+g[w>>2]+ +g[A+(B*284|0)+44>>2];g[A+(B*284|0)+16>>2]=+g[f>>2]*q+ +g[E>>2];y=A+(B*284|0)+20|0;g[y>>2]=s;z=A+(B*284|0)+24|0;g[z>>2]=u;g[A+(B*284|0)+28>>2]=0.0;g[D+32+32>>2]=-1.0;l=c[b+100>>2]|0;E=Lb[c[(c[l>>2]|0)+8>>2]&31](l,E,x,D+32|0)|0;l=A+(B*284|0)+88|0;c[l>>2]=0;do if(E){q=q*+g[D+32+32>>2];c[e>>2]=c[D+32+16>>2];c[e+4>>2]=c[D+32+16+4>>2];c[e+8>>2]=c[D+32+16+8>>2];c[e+12>>2]=c[D+32+16+12>>2];a[A+(B*284|0)+84>>0]=1;if((a[464]|0)==0?(Wa(464)|0)!=0:0){c[D+72>>2]=0;c[D+72+4>>2]=0;c[D+72+8>>2]=0;c[D+72+12>>2]=0;tp(4364,0.0,0,0,D+72|0);_a(464)}c[1142]=c[1142]|1;g[1177]=0.0;p=+g[1187]*0.0;o=+g[1188]*0.0;g[1182]=+g[1186]*0.0;g[1183]=p;g[1184]=o;g[1185]=0.0;c[1190]=0;c[1191]=0;c[1192]=0;c[1193]=0;o=+g[1179]*0.0;p=+g[1180]*0.0;g[1231]=+g[1178]*0.0;g[1232]=o;g[1233]=p;g[1234]=0.0;c[l>>2]=4364;q=q-+g[k>>2];l=A+(B*284|0)+32|0;g[l>>2]=q;p=+g[j>>2];o=+g[A+(B*284|0)+208>>2]*.009999999776482582;if(q<p-o){g[l>>2]=p-o;q=p-o}if(q>p+o)g[l>>2]=p+o;c[x>>2]=c[D+32>>2];c[x+4>>2]=c[D+32+4>>2];c[x+8>>2]=c[D+32+8>>2];c[x+12>>2]=c[D+32+12>>2];s=+g[e>>2];t=+g[A+(B*284|0)+4>>2];u=+g[A+(B*284|0)+8>>2];r=s*+g[f>>2]+t*+g[v>>2]+u*+g[w>>2];l=c[C>>2]|0;h=+g[x>>2]-+g[l+52>>2];m=+g[y>>2]-+g[l+56>>2];n=+g[z>>2]-+g[l+60>>2];q=+g[l+332>>2];p=+g[l+336>>2];o=+g[l+328>>2];if(!(r>=-.10000000149011612)){g[A+(B*284|0)+272>>2]=-1.0/r*(s*(q*n-m*p+ +g[l+312>>2])+t*(h*p-n*o+ +g[l+316>>2])+u*(m*o-h*q+ +g[l+320>>2]));g[A+(B*284|0)+268>>2]=-1.0/r;break}else{g[A+(B*284|0)+272>>2]=0.0;g[A+(B*284|0)+268>>2]=10.0;break}}else{c[A+(B*284|0)+32>>2]=c[j>>2];g[A+(B*284|0)+272>>2]=0.0;s=-+g[v>>2];u=-+g[w>>2];g[e>>2]=-+g[f>>2];g[A+(B*284|0)+4>>2]=s;g[A+(B*284|0)+8>>2]=u;g[A+(B*284|0)+12>>2]=0.0;g[A+(B*284|0)+268>>2]=1.0}while(0);B=B+1|0;l=c[b+136>>2]|0;f=c[C>>2]|0}while((B|0)<(l|0));h=1.0/+g[f+344>>2];if((l|0)>0){j=c[b+144>>2]|0;k=0;do{if(a[j+(k*284|0)+84>>0]|0){u=+g[j+(k*284|0)+272>>2];u=h*(+g[j+(k*284|0)+216>>2]*(+g[j+(k*284|0)+204>>2]-+g[j+(k*284|0)+32>>2])*+g[j+(k*284|0)+268>>2]-u*+g[(u<0.0?j+(k*284|0)+220|0:j+(k*284|0)+224|0)>>2]);e=j+(k*284|0)+276|0;g[e>>2]=u;if(u<0.0)g[e>>2]=0.0}else g[j+(k*284|0)+276>>2]=0.0;k=k+1|0}while((k|0)!=(l|0));e=f;f=0;while(1){r=+g[j+(f*284|0)+276>>2];u=+g[j+(f*284|0)+248>>2];r=r>u?u:r;u=r*+g[j+(f*284|0)+4>>2]*d;s=r*+g[j+(f*284|0)+8>>2]*d;g[D+16>>2]=+g[j+(f*284|0)>>2]*r*d;g[D+16+4>>2]=u;g[D+16+8>>2]=s;g[D+16+12>>2]=0.0;s=+g[j+(f*284|0)+20>>2]-+g[e+56>>2];u=+g[j+(f*284|0)+24>>2]-+g[e+60>>2];g[D>>2]=+g[j+(f*284|0)+16>>2]-+g[e+52>>2];g[D+4>>2]=s;g[D+8>>2]=u;g[D+12>>2]=0.0;Ro(e,D+16|0,D);f=f+1|0;if((f|0)>=(c[b+136>>2]|0))break a;j=c[b+144>>2]|0;e=c[C>>2]|0}}}while(0);Cb[c[(c[b>>2]|0)+20>>2]&31](b,d);f=c[b+136>>2]|0;if((f|0)<=0){i=D;return}e=c[b+144>>2]|0;l=c[C>>2]|0;k=0;do{o=+g[e+(k*284|0)+36>>2]-+g[l+52>>2];q=+g[e+(k*284|0)+40>>2]-+g[l+56>>2];p=+g[e+(k*284|0)+44>>2]-+g[l+60>>2];h=+g[l+332>>2];m=+g[l+336>>2];n=+g[l+328>>2];if(!(a[e+(k*284|0)+84>>0]|0)){j=e+(k*284|0)+240|0;h=+g[j>>2];z=e+(k*284|0)+236|0;g[z>>2]=h+ +g[z>>2]}else{j=c[b+128>>2]|0;G=+g[l+4+(j<<2)>>2];t=+g[l+20+(j<<2)>>2];s=+g[l+36+(j<<2)>>2];F=+g[e+(k*284|0)>>2];r=+g[e+(k*284|0)+4>>2];u=+g[e+(k*284|0)+8>>2];h=((q*n-o*h+ +g[l+320>>2])*(s-u*(G*F+t*r+s*u))+((h*p-q*m+ +g[l+312>>2])*(G-F*(G*F+t*r+s*u))+(o*m-p*n+ +g[l+316>>2])*(t-r*(G*F+t*r+s*u))))*d/+g[e+(k*284|0)+212>>2];j=e+(k*284|0)+240|0;g[j>>2]=h;z=e+(k*284|0)+236|0;g[z>>2]=h+ +g[z>>2]}g[j>>2]=h*.9900000095367432;k=k+1|0}while((k|0)!=(f|0));i=D;return}function os(b,d){b=b|0;d=+d;var e=0,f=0.0,h=0,j=0,k=0,l=0.0,m=0.0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0;s=i;i=i+160|0;p=c[b+136>>2]|0;if(!p){i=s;return}n=c[b+8>>2]|0;if((n|0)<(p|0)){if((c[b+12>>2]|0)<(p|0)){c[2703]=(c[2703]|0)+1;e=XE((p<<4|3)+16|0)|0;if(!e)h=0;else{c[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}k=c[b+8>>2]|0;if((k|0)>0){j=0;do{e=h+(j<<4)|0;o=(c[b+16>>2]|0)+(j<<4)|0;c[e>>2]=c[o>>2];c[e+4>>2]=c[o+4>>2];c[e+8>>2]=c[o+8>>2];c[e+12>>2]=c[o+12>>2];j=j+1|0}while((j|0)!=(k|0))}j=c[b+16>>2]|0;if(j){if(a[b+20>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=h;c[b+12>>2]=p;k=b+16|0}else k=b+16|0;e=n;do{h=(c[k>>2]|0)+(e<<4)|0;c[h>>2]=c[s+96>>2];c[h+4>>2]=c[s+96+4>>2];c[h+8>>2]=c[s+96+8>>2];c[h+12>>2]=c[s+96+12>>2];e=e+1|0}while((e|0)!=(p|0))}c[b+8>>2]=p;n=c[b+28>>2]|0;if((n|0)<(p|0)){if((c[b+32>>2]|0)<(p|0)){c[2703]=(c[2703]|0)+1;e=XE((p<<4|3)+16|0)|0;if(!e)h=0;else{c[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}k=c[b+28>>2]|0;if((k|0)>0){j=0;do{e=h+(j<<4)|0;o=(c[b+36>>2]|0)+(j<<4)|0;c[e>>2]=c[o>>2];c[e+4>>2]=c[o+4>>2];c[e+8>>2]=c[o+8>>2];c[e+12>>2]=c[o+12>>2];j=j+1|0}while((j|0)!=(k|0))}e=c[b+36>>2]|0;if(e){if(a[b+40>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=h;c[b+32>>2]=p;k=b+36|0}else k=b+36|0;e=n;do{h=(c[k>>2]|0)+(e<<4)|0;c[h>>2]=c[s+80>>2];c[h+4>>2]=c[s+80+4>>2];c[h+8>>2]=c[s+80+8>>2];c[h+12>>2]=c[s+80+12>>2];e=e+1|0}while((e|0)!=(p|0))}c[b+28>>2]=p;n=c[b+48>>2]|0;if((p|0)>(n|0)){do if((c[b+52>>2]|0)<(p|0)){c[2703]=(c[2703]|0)+1;e=XE((p<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}k=c[b+48>>2]|0;j=c[b+56>>2]|0;if((k|0)<=0){if(!j){a[b+60>>0]=1;c[b+56>>2]=e;c[b+52>>2]=p;break}}else{h=0;do{c[e+(h<<2)>>2]=c[j+(h<<2)>>2];h=h+1|0}while((h|0)!=(k|0))}if(a[b+60>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0)}a[b+60>>0]=1;c[b+56>>2]=e;c[b+52>>2]=p}else e=c[b+56>>2]|0;while(0);qF(e+(n<<2)|0,0,p-n<<2|0)|0}c[b+48>>2]=p;n=c[b+68>>2]|0;if((p|0)>(n|0)){do if((c[b+72>>2]|0)<(p|0)){c[2703]=(c[2703]|0)+1;e=XE((p<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}k=c[b+68>>2]|0;j=c[b+76>>2]|0;if((k|0)<=0){if(!j){a[b+80>>0]=1;c[b+76>>2]=e;c[b+72>>2]=p;break}}else{h=0;do{c[e+(h<<2)>>2]=c[j+(h<<2)>>2];h=h+1|0}while((h|0)!=(k|0))}if(a[b+80>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[j+-4>>2]|0)}a[b+80>>0]=1;c[b+76>>2]=e;c[b+72>>2]=p}else e=c[b+76>>2]|0;while(0);qF(e+(n<<2)|0,0,p-n<<2|0)|0}c[b+68>>2]=p;e=c[b+136>>2]|0;if((e|0)<=0){i=s;return}h=c[b+76>>2]|0;j=c[b+56>>2]|0;k=0;do{g[h+(k<<2)>>2]=0.0;g[j+(k<<2)>>2]=0.0;k=k+1|0}while((k|0)!=(e|0));o=0;do{n=c[b+144>>2]|0;j=c[n+(o*284|0)+88>>2]|0;if(j){k=n+(o*284|0)+92|0;c[s+112>>2]=c[k>>2];c[s+112+4>>2]=c[k+4>>2];c[s+112+8>>2]=c[k+8>>2];c[s+112+12>>2]=c[k+12>>2];k=n+(o*284|0)+108|0;c[s+112+16>>2]=c[k>>2];c[s+112+16+4>>2]=c[k+4>>2];c[s+112+16+8>>2]=c[k+8>>2];c[s+112+16+12>>2]=c[k+12>>2];k=n+(o*284|0)+124|0;c[s+112+32>>2]=c[k>>2];c[s+112+32+4>>2]=c[k+4>>2];c[s+112+32+8>>2]=c[k+8>>2];c[s+112+32+12>>2]=c[k+12>>2];k=c[b+36>>2]|0;x=c[b+120>>2]|0;h=c[s+112+16+(x<<2)>>2]|0;y=c[s+112+32+(x<<2)>>2]|0;c[k+(o<<4)>>2]=c[s+112+(x<<2)>>2];c[k+(o<<4)+4>>2]=h;c[k+(o<<4)+8>>2]=y;g[k+(o<<4)+12>>2]=0.0;k=c[b+36>>2]|0;y=k+(o<<4)|0;z=+g[y>>2];h=n+(o*284|0)|0;f=+g[h>>2];x=k+(o<<4)+4|0;w=+g[x>>2];p=n+(o*284|0)+4|0;l=+g[p>>2];k=k+(o<<4)+8|0;t=+g[k>>2];e=n+(o*284|0)+8|0;v=+g[e>>2];m=z-f*(z*f+w*l+t*v);u=w-l*(z*f+w*l+t*v);v=t-v*(z*f+w*l+t*v);t=1.0/+O(+(m*m+u*u+v*v));g[y>>2]=m*t;g[x>>2]=u*t;g[k>>2]=v*t;k=c[b+16>>2]|0;l=+g[p>>2];w=+g[e>>2];f=+g[h>>2];g[k+(o<<4)>>2]=l*(v*t)-w*(u*t);g[k+(o<<4)+4>>2]=w*(m*t)-v*t*f;g[k+(o<<4)+8>>2]=u*t*f-l*(m*t);g[k+(o<<4)+12>>2]=0.0;k=c[b+16>>2]|0;h=k+(o<<4)|0;t=+g[h>>2];e=k+(o<<4)+4|0;m=+g[e>>2];k=k+(o<<4)+8|0;l=+g[k>>2];f=1.0/+O(+(t*t+m*m+l*l));g[h>>2]=t*f;g[e>>2]=m*f;g[k>>2]=l*f;k=c[b+116>>2]|0;e=c[b+36>>2]|0;f=+g[e+(o<<4)>>2];l=+g[e+(o<<4)+4>>2];m=+g[e+(o<<4)+8>>2];if(f*f+l*l+m*m>1.100000023841858)f=0.0;else{C=+g[n+(o*284|0)+16>>2];G=C-+g[k+52>>2];E=+g[n+(o*284|0)+20>>2];I=E-+g[k+56>>2];J=+g[n+(o*284|0)+24>>2];L=J-+g[k+60>>2];C=C-+g[j+52>>2];E=E-+g[j+56>>2];J=J-+g[j+60>>2];F=+g[k+332>>2];M=+g[k+336>>2];H=+g[k+328>>2];B=+g[j+332>>2];K=+g[j+336>>2];D=+g[j+328>>2];A=(m*I-l*L)*+g[k+4>>2]+(f*L-m*G)*+g[k+20>>2]+(l*G-f*I)*+g[k+36>>2];z=(m*I-l*L)*+g[k+8>>2]+(f*L-m*G)*+g[k+24>>2]+(l*G-f*I)*+g[k+40>>2];w=(m*I-l*L)*+g[k+12>>2]+(f*L-m*G)*+g[k+28>>2]+(l*G-f*I)*+g[k+44>>2];t=(E*-m-J*-l)*+g[j+4>>2]+(J*-f-C*-m)*+g[j+20>>2]+(C*-l-E*-f)*+g[j+36>>2];v=(E*-m-J*-l)*+g[j+8>>2]+(J*-f-C*-m)*+g[j+24>>2]+(C*-l-E*-f)*+g[j+40>>2];u=(E*-m-J*-l)*+g[j+12>>2]+(J*-f-C*-m)*+g[j+28>>2]+(C*-l-E*-f)*+g[j+44>>2];f=(f*(L*F-I*M+ +g[k+312>>2]-(J*B-E*K+ +g[j+312>>2]))+l*(+g[k+316>>2]+(G*M-L*H)-(+g[j+316>>2]+(C*K-J*D)))+m*(I*H-G*F+ +g[k+320>>2]-(E*D-C*B+ +g[j+320>>2])))*-.20000000298023224*(1.0/(+g[j+344>>2]+(+g[k+344>>2]+(A*(A*+g[k+396>>2])+z*(z*+g[k+400>>2])+w*(w*+g[k+404>>2])))+(t*(t*+g[j+396>>2])+v*(v*+g[j+400>>2])+u*(u*+g[j+404>>2]))))}g[(c[b+76>>2]|0)+(o<<2)>>2]=f;e=c[b+136>>2]|0}o=o+1|0}while((o|0)<(e|0));if((e|0)<=0){i=s;return}o=c[b+144>>2]|0;p=0;j=0;while(1){k=c[o+(j*284|0)+88>>2]|0;if(k){f=+g[o+(j*284|0)+252>>2];if(f!=0.0){k=o;m=f*d}else{L=+g[o+(j*284|0)+256>>2];L=L==0.0?0.0:L;n=c[b+116>>2]|0;h=c[b+16>>2]|0;B=+g[o+(j*284|0)+16>>2];C=+g[o+(j*284|0)+20>>2];u=+g[o+(j*284|0)+24>>2];v=+g[h+(j<<4)>>2];f=+g[h+(j<<4)+4>>2];m=+g[h+(j<<4)+8>>2];P=B-+g[n+52>>2];Q=C-+g[n+56>>2];M=u-+g[n+60>>2];z=+g[n+264>>2]*(Q*m-M*f)+ +g[n+280>>2]*(M*v-P*m)+(P*f-Q*v)*+g[n+296>>2];R=(Q*m-M*f)*+g[n+268>>2]+(M*v-P*m)*+g[n+284>>2]+(P*f-Q*v)*+g[n+300>>2];N=(Q*m-M*f)*+g[n+272>>2]+(M*v-P*m)*+g[n+288>>2]+(P*f-Q*v)*+g[n+304>>2];I=B-+g[k+52>>2];E=C-+g[k+56>>2];G=u-+g[k+60>>2];K=(f*I-v*E)*+g[k+296>>2]+(+g[k+264>>2]*(m*E-f*G)+ +g[k+280>>2]*(v*G-m*I));w=(m*E-f*G)*+g[k+268>>2]+(v*G-m*I)*+g[k+284>>2]+(f*I-v*E)*+g[k+300>>2];t=(m*E-f*G)*+g[k+272>>2]+(v*G-m*I)*+g[k+288>>2]+(f*I-v*E)*+g[k+304>>2];B=B-+g[n+52>>2];C=C-+g[n+56>>2];u=u-+g[n+60>>2];D=+g[n+332>>2];H=+g[n+336>>2];A=+g[n+328>>2];J=+g[k+332>>2];l=+g[k+336>>2];F=+g[k+328>>2];m=-(1.0/(+g[n+344>>2]+(m*(Q*z-P*R)+(v*(M*R-Q*N)+f*(P*N-M*z)))+(+g[k+344>>2]+(m*(E*K-I*w)+(v*(G*w-E*t)+f*(I*t-G*K)))))*((u*D-C*H+ +g[n+312>>2]-(G*J-E*l+ +g[k+312>>2]))*v+(+g[n+316>>2]+(B*H-u*A)-(+g[k+316>>2]+(I*l-G*F)))*f+(C*A-B*D+ +g[n+320>>2]-(E*F-I*J+ +g[k+320>>2]))*m));m=L<m?L:m;k=c[b+144>>2]|0;m=m<-L?-L:m}e=c[b+56>>2]|0;h=e+(j<<2)|0;g[h>>2]=0.0;n=k+(j*284|0)+280|0;g[n>>2]=1.0;f=+g[o+(j*284|0)+276>>2]*d*+g[o+(j*284|0)+228>>2];g[h>>2]=m;l=m*.5;m=+g[(c[b+76>>2]|0)+(j<<2)>>2];if(l*l+m*m>f*f){L=f/+O(+(l*l+m*m));g[n>>2]=L*+g[n>>2];o=k;k=1}else{o=k;k=p}}else{e=c[b+56>>2]|0;g[e+(j<<2)>>2]=0.0;g[o+(j*284|0)+280>>2]=1.0;k=p}j=j+1|0;n=c[b+136>>2]|0;if((j|0)>=(n|0))break;else p=k}if(k){if((n|0)<=0){i=s;return}k=c[b+76>>2]|0;h=0;do{j=k+(h<<2)|0;if(+g[j>>2]!=0.0?(r=o+(h*284|0)+280|0,q=+g[r>>2],q<1.0):0){p=e+(h<<2)|0;g[p>>2]=q*+g[p>>2];g[j>>2]=+g[r>>2]*+g[j>>2]}h=h+1|0}while((h|0)!=(n|0))}if((n|0)<=0){i=s;return}p=o;k=e;e=0;while(1){n=c[b+116>>2]|0;j=p+(e*284|0)+16|0;m=+g[j>>2]-+g[n+52>>2];o=p+(e*284|0)+20|0;d=+g[o>>2]-+g[n+56>>2];h=p+(e*284|0)+24|0;l=+g[h>>2]-+g[n+60>>2];g[s+64>>2]=m;g[s+64+4>>2]=d;g[s+64+8>>2]=l;g[s+64+12>>2]=0.0;f=+g[k+(e<<2)>>2];if(f!=0.0){r=c[b+16>>2]|0;J=f*+g[r+(e<<4)+4>>2];L=f*+g[r+(e<<4)+8>>2];g[s+48>>2]=f*+g[r+(e<<4)>>2];g[s+48+4>>2]=J;g[s+48+8>>2]=L;g[s+48+12>>2]=0.0;Ro(n,s+48|0,s+64|0)}f=+g[(c[b+76>>2]|0)+(e<<2)>>2];if(f!=0.0){r=c[(c[b+144>>2]|0)+(e*284|0)+88>>2]|0;J=+g[o>>2]-+g[r+56>>2];I=+g[h>>2]-+g[r+60>>2];g[s+32>>2]=+g[j>>2]-+g[r+52>>2];g[s+32+4>>2]=J;g[s+32+8>>2]=I;g[s+32+12>>2]=0.0;o=c[b+36>>2]|0;I=+g[o+(e<<4)>>2]*f;J=f*+g[o+(e<<4)+4>>2];L=f*+g[o+(e<<4)+8>>2];g[s+16>>2]=I;g[s+16+4>>2]=J;g[s+16+8>>2]=L;g[s+16+12>>2]=0.0;o=c[b+116>>2]|0;n=c[b+124>>2]|0;B=+g[o+4+(n<<2)>>2];D=+g[o+20+(n<<2)>>2];E=+g[o+36+(n<<2)>>2];F=(B*m+D*d+E*l)*(1.0-+g[p+(e*284|0)+244>>2]);g[s+64>>2]=m-B*F;g[s+64+4>>2]=d-D*F;g[s+64+8>>2]=l-E*F;Ro(o,s+16|0,s+64|0);g[s>>2]=-I;g[s+4>>2]=-J;g[s+8>>2]=-L;g[s+12>>2]=0.0;Ro(r,s,s+32|0)}e=e+1|0;if((e|0)>=(c[b+136>>2]|0))break;p=c[b+144>>2]|0;k=c[b+56>>2]|0}i=s;return}function ps(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0,m=0;f=i;i=i+48|0;if((c[b+136>>2]|0)<=0){i=f;return}e=0;do{m=c[b+144>>2]|0;c[f+32>>2]=(a[m+(e*284|0)+84>>0]|0)==0?1065353216:0;c[f+32+4>>2]=0;c[f+32+8>>2]=1065353216;g[f+32+12>>2]=0.0;l=m+(e*284|0)+140|0;c[f+16>>2]=c[l>>2];c[f+16+4>>2]=c[l+4>>2];c[f+16+8>>2]=c[l+8>>2];c[f+16+12>>2]=c[l+12>>2];l=c[b+120>>2]|0;h=c[(c[d>>2]|0)+8>>2]|0;k=+g[m+(e*284|0)+108+(l<<2)>>2]+ +g[f+16+4>>2];j=+g[m+(e*284|0)+124+(l<<2)>>2]+ +g[f+16+8>>2];g[f>>2]=+g[m+(e*284|0)+92+(l<<2)>>2]+ +g[f+16>>2];g[f+4>>2]=k;g[f+8>>2]=j;g[f+12>>2]=0.0;nc[h&127](d,f+16|0,f,f+32|0);nc[c[(c[d>>2]|0)+8>>2]&127](d,f+16|0,(c[b+144>>2]|0)+(e*284|0)+16|0,f+32|0);e=e+1|0}while((e|0)<(c[b+136>>2]|0));i=f;return}function qs(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0;h=i;i=i+96|0;g[h+4>>2]=1.0;c[h+8>>2]=0;b[h+12>>1]=1;b[h+14>>1]=-1;c[h+16>>2]=0;c[h>>2]=2772;c[h+20>>2]=c[d>>2];c[h+20+4>>2]=c[d+4>>2];c[h+20+8>>2]=c[d+8>>2];c[h+20+12>>2]=c[d+12>>2];c[h+36>>2]=c[e>>2];c[h+36+4>>2]=c[e+4>>2];c[h+36+8>>2]=c[e+8>>2];c[h+36+12>>2]=c[e+12>>2];a=c[a+4>>2]|0;nc[c[(c[a>>2]|0)+32>>2]&127](a,d,e,h);d=c[h+8>>2]|0;if(!d){d=0;i=h;return d|0}if(!(c[d+236>>2]&2)){d=0;i=h;return d|0}if(c[d+204>>2]&4){d=0;i=h;return d|0}c[f>>2]=c[h+68>>2];c[f+4>>2]=c[h+68+4>>2];c[f+8>>2]=c[h+68+8>>2];c[f+12>>2]=c[h+68+12>>2];c[f+16>>2]=c[h+52>>2];c[f+16+4>>2]=c[h+52+4>>2];c[f+16+8>>2]=c[h+52+8>>2];c[f+16+12>>2]=c[h+52+12>>2];m=+g[f+16>>2];l=+g[f+20>>2];k=+g[f+24>>2];j=1.0/+O(+(m*m+l*l+k*k));g[f+16>>2]=m*j;g[f+20>>2]=l*j;g[f+24>>2]=k*j;c[f+32>>2]=c[h+4>>2];i=h;return d|0}function rs(a){a=a|0;YE(a);return}function ss(a,b,d){a=a|0;b=b|0;d=+d;Cb[c[(c[a>>2]|0)+16>>2]&31](a,d);return}function ts(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+120>>2]=b;c[a+124>>2]=d;c[a+128>>2]=e;return}function us(b){b=b|0;var d=0;c[b>>2]=4988;d=c[b+140>>2]|0;if(d){if(a[b+144>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;return}function vs(b){b=b|0;var d=0;c[b>>2]=4988;d=c[b+140>>2]|0;if(d){if(a[b+144>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;c[2704]=(c[2704]|0)+1;YE(c[b+-4>>2]|0);return}function ws(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0,k=0.0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0;u=i;i=i+96|0;p=c[b+12>>2]|0;nc[c[(c[p>>2]|0)+8>>2]&127](p,(c[b+8>>2]|0)+4|0,u+16|0,u);p=c[d+68>>2]|0;Bb[c[(c[p>>2]|0)+16>>2]&31](p,c[(c[b+8>>2]|0)+188>>2]|0,u+16|0,u,c[d+24>>2]|0);p=c[d+24>>2]|0;nc[c[(c[p>>2]|0)+32>>2]&127](p,c[(c[b+8>>2]|0)+284>>2]|0,d+28|0,p);p=c[b+8>>2]|0;c[b+92>>2]=c[p+52>>2];c[b+92+4>>2]=c[p+52+4>>2];c[b+92+8>>2]=c[p+52+8>>2];c[b+92+12>>2]=c[p+52+12>>2];p=c[p+284>>2]|0;if((Hb[c[(c[p>>2]|0)+36>>2]&127](p)|0)>0){s=0;h=0.0;d=0;do{e=c[b+132>>2]|0;if((e|0)<0){if((c[b+136>>2]|0)<0){f=c[b+140>>2]|0;if(f){if(a[b+144>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+136>>2]=0}do{c[(c[b+140>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[b+132>>2]=0;f=c[(c[b+8>>2]|0)+284>>2]|0;f=c[(Hb[c[(c[f>>2]|0)+28>>2]&127](f)|0)+12>>2]|0;p=c[c[f+(s<<4)>>2]>>2]|0;e=c[c[f+(s<<4)+4>>2]>>2]|0;if(!((p|0)!=0?(c[p+204>>2]&4|0)!=0:0))t=13;do if((t|0)==13){t=0;if((e|0)!=0?(c[e+204>>2]&4|0)!=0:0)break;e=c[f+(s<<4)+8>>2]|0;if(e)Fb[c[(c[e>>2]|0)+16>>2]&127](e,b+128|0);q=c[b+132>>2]|0;if((q|0)>0){o=c[b+140>>2]|0;p=c[b+8>>2]|0;r=0;do{m=c[o+(r<<2)>>2]|0;n=(c[m+740>>2]|0)==(p|0)?-1.0:1.0;f=c[m+748>>2]|0;if((f|0)>0){l=0;do{k=+g[m+4+(l*184|0)+80>>2];if(k<0.0){j=m+4+(l*184|0)+64|0;if(k<h){e=m+4+(l*184|0)+68|0;v=n*+g[e>>2];d=m+4+(l*184|0)+72|0;h=n*+g[d>>2];g[b+152>>2]=n*+g[j>>2];g[b+156>>2]=v;g[b+160>>2]=h;g[b+164>>2]=0.0;f=c[m+748>>2]|0;h=k}else{e=m+4+(l*184|0)+68|0;d=m+4+(l*184|0)+72|0}w=k*(n*+g[e>>2])*.20000000298023224;v=k*(n*+g[d>>2])*.20000000298023224;g[b+92>>2]=k*(n*+g[j>>2])*.20000000298023224+ +g[b+92>>2];g[b+96>>2]=w+ +g[b+96>>2];g[b+100>>2]=v+ +g[b+100>>2];d=1}l=l+1|0}while((l|0)<(f|0))}r=r+1|0}while((r|0)!=(q|0))}}while(0);s=s+1|0;p=c[(c[b+8>>2]|0)+284>>2]|0}while((s|0)<(Hb[c[(c[p>>2]|0)+36>>2]&127](p)|0))}else d=0;p=c[b+8>>2]|0;c[u+32>>2]=c[p+4>>2];c[u+32+4>>2]=c[p+4+4>>2];c[u+32+8>>2]=c[p+4+8>>2];c[u+32+12>>2]=c[p+4+12>>2];l=u+32+16|0;c[l>>2]=c[p+20>>2];c[l+4>>2]=c[p+20+4>>2];c[l+8>>2]=c[p+20+8>>2];c[l+12>>2]=c[p+20+12>>2];m=u+32+32|0;c[m>>2]=c[p+36>>2];c[m+4>>2]=c[p+36+4>>2];c[m+8>>2]=c[p+36+8>>2];c[m+12>>2]=c[p+36+12>>2];o=u+32+48|0;c[o>>2]=c[b+92>>2];c[o+4>>2]=c[b+92+4>>2];c[o+8>>2]=c[b+92+8>>2];c[o+12>>2]=c[b+92+12>>2];c[p+260>>2]=(c[p+260>>2]|0)+1;c[p+4>>2]=c[u+32>>2];c[p+4+4>>2]=c[u+32+4>>2];c[p+4+8>>2]=c[u+32+8>>2];c[p+4+12>>2]=c[u+32+12>>2];c[p+20>>2]=c[l>>2];c[p+20+4>>2]=c[l+4>>2];c[p+20+8>>2]=c[l+8>>2];c[p+20+12>>2]=c[l+12>>2];c[p+36>>2]=c[m>>2];c[p+36+4>>2]=c[m+4>>2];c[p+36+8>>2]=c[m+8>>2];c[p+36+12>>2]=c[m+12>>2];c[p+52>>2]=c[o>>2];c[p+52+4>>2]=c[o+4>>2];c[p+52+8>>2]=c[o+8>>2];c[p+52+12>>2]=c[o+12>>2];i=u;return d|0}function xs(d,e,f,h,j){d=d|0;e=e|0;f=+f;h=+h;j=+j;var k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;q=i;i=i+240|0;h=+g[d+96>>2]+h;p=+g[d+100>>2]+j;g[d+112>>2]=+g[d+92>>2]+f;g[d+116>>2]=h;g[d+120>>2]=p;g[d+124>>2]=0.0;c[q+168>>2]=1065353216;c[q+168+4>>2]=0;c[q+168+4+4>>2]=0;c[q+168+4+8>>2]=0;c[q+168+4+12>>2]=0;c[q+168+20>>2]=1065353216;c[q+168+24>>2]=0;c[q+168+24+4>>2]=0;c[q+168+24+8>>2]=0;c[q+168+24+12>>2]=0;c[q+168+40>>2]=1065353216;k=q+168+44|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[q+104>>2]=1065353216;c[q+104+4>>2]=0;c[q+104+4+4>>2]=0;c[q+104+4+8>>2]=0;c[q+104+4+12>>2]=0;c[q+104+20>>2]=1065353216;c[q+104+24>>2]=0;c[q+104+24+4>>2]=0;c[q+104+24+8>>2]=0;c[q+104+24+12>>2]=0;c[q+104+40>>2]=1065353216;k=q+104+44|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;p=1.0;k=10;while(1){if((k|0)<=0){k=14;break};k=k+-1|0;c[q+168+48>>2]=c[d+92>>2];c[q+168+48+4>>2]=c[d+92+4>>2];c[q+168+48+8>>2]=c[d+92+8>>2];c[q+168+48+12>>2]=c[d+92+12>>2];c[q+104+48>>2]=c[d+112>>2];c[q+104+48+4>>2]=c[d+112+4>>2];c[q+104+48+8>>2]=c[d+112+8>>2];c[q+104+48+12>>2]=c[d+112+12>>2];j=+g[d+92>>2]-+g[d+112>>2];h=+g[d+96>>2]-+g[d+116>>2];f=+g[d+100>>2]-+g[d+120>>2];r=c[d+8>>2]|0;g[q+4>>2]=1.0;c[q+76>>2]=0;c[q+12>>2]=0;c[q+12+4>>2]=0;c[q+12+8>>2]=0;c[q+12+12>>2]=0;c[q+12+16>>2]=0;c[q+12+20>>2]=0;c[q+12+24>>2]=0;c[q+12+28>>2]=0;c[q>>2]=5100;c[q+80>>2]=r;g[q+84>>2]=j;g[q+88>>2]=h;g[q+92>>2]=f;g[q+96>>2]=0.0;g[q+100>>2]=0.0;r=c[r+188>>2]|0;b[q+8>>1]=b[r+4>>1]|0;b[q+10>>1]=b[r+6>>1]|0;r=c[d+12>>2]|0;f=+Tb[c[(c[r>>2]|0)+48>>2]&15](r);r=c[d+12>>2]|0;Cb[c[(c[r>>2]|0)+44>>2]&31](r,f+ +g[d+56>>2]);if(!(a[d+170>>0]|0))gv(e,c[d+12>>2]|0,q+168|0,q+104|0,q,+g[e+56>>2]);else _s(c[d+8>>2]|0,c[d+12>>2]|0,q+168|0,q+104|0,q,+g[e+56>>2]);r=c[d+12>>2]|0;Cb[c[(c[r>>2]|0)+44>>2]&31](r,f);f=+g[q+4>>2];p=p-f;if(f<1.0){j=+g[d+112>>2];m=+g[d+92>>2];f=+g[d+116>>2];n=+g[d+96>>2];l=+g[d+120>>2];o=+g[d+100>>2];h=+O(+((j-m)*(j-m)+(f-n)*(f-n)+(l-o)*(l-o)));if(h>1.1920928955078125e-07){v=+g[q+44>>2];t=+g[q+48>>2];x=+g[q+52>>2];w=((j-m)*(1.0/h)*v+(f-n)*(1.0/h)*t+(l-o)*(1.0/h)*x)*2.0;u=(j-m)*(1.0/h)-v*w;s=(f-n)*(1.0/h)-t*w;w=(l-o)*(1.0/h)-x*w;l=1.0/+O(+(w*w+(u*u+s*s)));c[d+112>>2]=c[d+92>>2];c[d+112+4>>2]=c[d+92+4>>2];c[d+112+8>>2]=c[d+92+8>>2];c[d+112+12>>2]=c[d+92+12>>2];j=h*(l*u-v*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+112>>2];g[d+112>>2]=j;f=h*(l*s-t*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+116>>2];g[d+116>>2]=f;l=h*(l*w-x*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+120>>2];g[d+120>>2]=l;h=f}else h=f;f=j-m;h=h-n;j=l-o;if(!(f*f+h*h+j*j>1.1920928955078125e-07)){k=12;break}o=1.0/+O(+(f*f+h*h+j*j));if(f*o*+g[d+76>>2]+h*o*+g[d+80>>2]+j*o*+g[d+84>>2]<=0.0){k=12;break}}else{c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2]}if(!(p>.009999999776482582)){k=14;break}}if((k|0)==12){i=q;return}else if((k|0)==14){i=q;return}}function ys(b,d){b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;a[b+171>>0]=1;c[b+60>>2]=c[d>>2];c[b+60+4>>2]=c[d+4>>2];c[b+60+8>>2]=c[d+8>>2];c[b+60+12>>2]=c[d+12>>2];e=+g[b+60>>2];f=+g[b+64>>2];i=+g[b+68>>2];h=1.0/+O(+(e*e+f*f+i*i));if(+O(+(i*h*(i*h)+(e*h*(e*h)+f*h*(f*h))))<1.1920928955078125e-07){j=0.0;f=0.0;e=0.0;d=0}else{j=e*h;f=f*h;e=i*h;d=c[b+72>>2]|0}g[b+76>>2]=j;g[b+80>>2]=f;g[b+84>>2]=e;c[b+88>>2]=d;return}function zs(b,d,e){b=b|0;d=d|0;e=+e;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;a[b+171>>0]=0;c[b+60>>2]=c[d>>2];c[b+60+4>>2]=c[d+4>>2];c[b+60+8>>2]=c[d+8>>2];c[b+60+12>>2]=c[d+12>>2];f=+g[b+60>>2];h=+g[b+64>>2];j=+g[b+68>>2];i=1.0/+O(+(f*f+h*h+j*j));if(+O(+(j*i*(j*i)+(f*i*(f*i)+h*i*(h*i))))<1.1920928955078125e-07){k=0.0;h=0.0;f=0.0;d=0}else{k=f*i;h=h*i;f=j*i;d=c[b+72>>2]|0}g[b+76>>2]=k;g[b+80>>2]=h;g[b+84>>2]=f;c[b+88>>2]=d;g[b+172>>2]=+g[b+172>>2]+e;return}function As(b,d){b=b|0;d=d|0;var e=0,f=0,h=0;g[b+16>>2]=0.0;g[b+20>>2]=0.0;a[b+168>>0]=0;a[b+169>>0]=0;g[b+172>>2]=0.0;c[b+60>>2]=0;c[b+60+4>>2]=0;c[b+60+8>>2]=0;c[b+60+12>>2]=0;b=c[(c[b+8>>2]|0)+284>>2]|0;if((c[(Hb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+4>>2]|0)<=0)return;do{f=c[b>>2]|0;h=c[f+12>>2]|0;f=c[c[(Hb[c[f+28>>2]&127](b)|0)+12>>2]>>2]|0;e=c[(c[(Hb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+12>>2]|0)+4>>2]|0;Lb[h&31](b,f,e,c[d+24>>2]|0)|0}while((c[(Hb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+4>>2]|0)>0);return}function Bs(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+32|0;c[d+16>>2]=0;c[d+16+4>>2]=0;c[d+16+8>>2]=0;c[d+16+12>>2]=0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=c[a+8>>2]|0;c[b+260>>2]=(c[b+260>>2]|0)+1;c[b+4>>2]=1065353216;c[b+8>>2]=c[d+16>>2];c[b+8+4>>2]=c[d+16+4>>2];c[b+8+8>>2]=c[d+16+8>>2];c[b+20>>2]=0;c[b+24>>2]=1065353216;c[b+28>>2]=0;c[b+28+4>>2]=0;c[b+28+8>>2]=0;c[b+28+12>>2]=0;c[b+44>>2]=1065353216;c[b+48>>2]=0;c[b+52>>2]=c[d>>2];c[b+52+4>>2]=c[d+4>>2];c[b+52+8>>2]=c[d+8>>2];c[b+52+12>>2]=c[d+12>>2];i=d;return}function Cs(b,d){b=b|0;d=d|0;a[b+148>>0]=0;if((((ws(b,d)|0?(a[b+148>>0]=1,ws(b,d)|0):0)?(a[b+148>>0]=1,ws(b,d)|0):0)?(a[b+148>>0]=1,ws(b,d)|0):0)?(a[b+148>>0]=1,ws(b,d)|0):0)a[b+148>>0]=1;d=(c[b+8>>2]|0)+52|0;c[b+92>>2]=c[d>>2];c[b+92+4>>2]=c[d+4>>2];c[b+92+8>>2]=c[d+8>>2];c[b+92+12>>2]=c[d+12>>2];vF(b+112|0,d|0,16)|0;return}
function oE(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0,s=0.0,t=0,u=0.0,v=0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;G=i;i=i+256|0;if((e|0)<1){f=c[b+12>>2]|0;if(f){if(a[b+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;f=c[b+32>>2]|0;if(f){if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;f=c[b+52>>2]|0;if(f){if(a[b+56>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;i=G;return}c[G+40+32>>2]=0;c[G+40+36>>2]=0;c[G+40+40>>2]=0;c[G+40+44>>2]=256;c[G+40+48>>2]=0;c[G+40+52>>2]=0;c[G+40+56>>2]=0;c[G+40+60>>2]=256;c[G+40+64>>2]=0;c[G+40+68>>2]=0;c[G+40+72>>2]=0;c[G+40+76>>2]=256;a[G+40+96>>0]=1;D=G+40+92|0;c[D>>2]=0;c[G+40+84>>2]=0;c[G+40+88>>2]=0;y=1900671690;v=-246811958;l=0;h=-246811958;x=-246811958;f=1900671690;B=1900671690;t=d;while(1){j=+g[t>>2];q=+g[t+4>>2];p=+g[t+8>>2];C=j<(c[k>>2]=f,+g[k>>2]);r=(g[k>>2]=j,c[k>>2]|0);f=C?r:f;C=q<(c[k>>2]=y,+g[k>>2]);n=(g[k>>2]=q,c[k>>2]|0);y=C?n:y;C=p<(c[k>>2]=B,+g[k>>2]);m=(g[k>>2]=p,c[k>>2]|0);B=C?m:B;h=(c[k>>2]=h,+g[k>>2])<j?r:h;v=(c[k>>2]=v,+g[k>>2])<q?n:v;x=(c[k>>2]=x,+g[k>>2])<p?m:x;l=l+1|0;if((l|0)==(e|0))break;else t=t+16|0}A=(c[k>>2]=h,+g[k>>2]);z=(c[k>>2]=f,+g[k>>2]);w=(c[k>>2]=v,+g[k>>2]);u=(c[k>>2]=y,+g[k>>2]);s=(c[k>>2]=x,+g[k>>2]);q=(c[k>>2]=B,+g[k>>2]);v=A-z<w-u?(w-u<s-q?2:1):A-z<s-q?2:0;c[G+40+112>>2]=v;r=A-z<w-u?(A-z<s-q?0:2):w-u<s-q?1:2;r=(r|0)==(v|0)?((v+1|0)>>>0)%3|0:r;c[G+40+104>>2]=r;c[G+40+108>>2]=(v^3)-r;if((((v^3)-r+1|0)%3|0|0)==(v|0)){o=(w-u)*9.788566967472434e-05;p=(s-q)*9.788566967472434e-05;j=(A-z)*9.788566967472434e-05}else{o=-((w-u)*9.788566967472434e-05);p=-((s-q)*9.788566967472434e-05);j=-((A-z)*9.788566967472434e-05)}g[G+40>>2]=j;g[G+40+4>>2]=o;g[G+40+8>>2]=p;g[G+40+12>>2]=0.0;j=j!=0.0?1.0/j:j;o=o!=0.0?1.0/o:o;p=p!=0.0?1.0/p:p;g[G+40+16>>2]=(z+A)*.5;g[G+40+20>>2]=(u+w)*.5;g[G+40+24>>2]=(q+s)*.5;g[G+40+28>>2]=0.0;t=G+232+16|0;a[t>>0]=1;B=G+232+12|0;c[B>>2]=0;C=G+232+4|0;c[C>>2]=0;c[G+232+8>>2]=0;if((e|0)>0){c[2703]=(c[2703]|0)+1;m=XE((e<<4|3)+16|0)|0;if(!m)h=0;else{c[(m+4+15&-16)+-4>>2]=m;h=m+4+15&-16}m=c[C>>2]|0;l=c[B>>2]|0;if((m|0)<=0){if(l)F=26}else{n=0;do{v=h+(n<<4)|0;r=l+(n<<4)|0;c[v>>2]=c[r>>2];c[v+4>>2]=c[r+4>>2];c[v+8>>2]=c[r+8>>2];c[v+12>>2]=c[r+12>>2];n=n+1|0}while((n|0)!=(m|0));F=26}if((F|0)==26){if(a[t>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[l+-4>>2]|0)}c[B>>2]=0}a[t>>0]=1;c[B>>2]=h;c[G+232+8>>2]=e;c[h>>2]=c[G+216>>2];c[h+4>>2]=c[G+216+4>>2];c[h+8>>2]=c[G+216+8>>2];c[h+12>>2]=c[G+216+12>>2];if((e|0)==1)c[C>>2]=1;else{m=1;do{v=(c[B>>2]|0)+(m<<4)|0;c[v>>2]=c[G+216>>2];c[v+4>>2]=c[G+216+4>>2];c[v+8>>2]=c[G+216+8>>2];c[v+12>>2]=c[G+216+12>>2];m=m+1|0}while((m|0)!=(e|0));c[C>>2]=e}n=G+200+(c[G+40+108>>2]<<2)|0;v=c[B>>2]|0;m=G+200+(c[G+40+112>>2]<<2)|0;l=G+200+(c[G+40+104>>2]<<2)|0;u=+g[G+40+16>>2];s=+g[G+40+20>>2];q=+g[G+40+24>>2];y=0;r=d;while(1){h=c[r>>2]|0;c[G+200>>2]=h;x=c[r+4>>2]|0;c[G+200+4>>2]=x;w=(c[k>>2]=h,+g[k>>2])-u;A=o*((c[k>>2]=x,+g[k>>2])-s);z=p*(+g[r+8>>2]-q);g[G+200>>2]=j*w;g[G+200+4>>2]=A;g[G+200+8>>2]=z;g[G+200+12>>2]=0.0;c[v+(y<<4)>>2]=~~+g[n>>2];c[v+(y<<4)+4>>2]=~~+g[m>>2];c[v+(y<<4)+8>>2]=~~+g[l>>2];c[v+(y<<4)+12>>2]=y;y=y+1|0;if((y|0)==(e|0))break;else r=r+16|0}if((e|0)>1)pE(G+232|0,0,e+-1|0)}else c[C>>2]=e;c[G+40+36>>2]=c[G+40+32>>2];c[G+40+40>>2]=0;c[G+40+44>>2]=e;h=c[G+40+84>>2]|0;if((h|0)<(e|0)){if((c[G+40+88>>2]|0)<(e|0)){if(!e){m=h;n=0}else{c[2703]=(c[2703]|0)+1;f=XE((e<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}m=c[G+40+84>>2]|0;n=f}if((m|0)>0){l=0;do{c[n+(l<<2)>>2]=c[(c[D>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(m|0))}f=c[D>>2]|0;if(f){if(a[G+40+96>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[f+-4>>2]|0)}c[D>>2]=0}a[G+40+96>>0]=1;c[D>>2]=n;c[G+40+88>>2]=e}do{c[(c[D>>2]|0)+(h<<2)>>2]=0;h=h+1|0}while((h|0)!=(e|0))}c[G+40+84>>2]=e;if((e|0)>0){v=0;do{h=c[G+40+40>>2]|0;if(!h){h=c[G+40+36>>2]|0;if(!h){c[2703]=(c[2703]|0)+1;h=XE(31)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}l=c[G+40+44>>2]|0;c[h+4>>2]=l;m=h+8|0;c[m>>2]=0;c[2703]=(c[2703]|0)+1;l=XE((l*112|3)+16|0)|0;if(!l)l=0;else{c[(l+4+15&-16)+-4>>2]=l;l=l+4+15&-16}c[h>>2]=l;c[m>>2]=c[G+40+32>>2];c[G+40+32>>2]=h}else c[G+40+36>>2]=c[h+8>>2];n=c[h+4>>2]|0;h=c[h>>2]|0;if((n|0)>0){m=0;l=h;do{m=m+1|0;r=l;l=l+112|0;c[r>>2]=(m|0)<(n|0)?l:0}while((m|0)!=(n|0))}}c[G+40+40>>2]=c[h>>2];r=h+104|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[r>>2]=-1;c[h+8>>2]=0;y=h+88|0;n=(c[B>>2]|0)+(v<<4)|0;c[y>>2]=c[n>>2];c[y+4>>2]=c[n+4>>2];c[y+8>>2]=c[n+8>>2];c[y+12>>2]=c[n+12>>2];c[r>>2]=-1;c[(c[D>>2]|0)+(v<<2)>>2]=h;v=v+1|0}while((v|0)!=(e|0))}h=c[B>>2]|0;if(h){if(a[t>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[B>>2]=0}a[t>>0]=1;c[B>>2]=0;c[C>>2]=0;c[G+232+8>>2]=0;c[G+40+52>>2]=c[G+40+48>>2];c[G+40+56>>2]=0;c[G+40+60>>2]=e*6;c[G+40+116>>2]=0;c[G+40+120>>2]=0;c[G+40+100>>2]=-3;c[G+184>>2]=0;c[G+184+4>>2]=0;c[G+184+8>>2]=0;c[G+184+12>>2]=0;lE(G+40|0,0,e,G+184|0);c[G+40+124>>2]=c[G+184>>2];h=c[B>>2]|0;if(h){if(a[t>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[B>>2]=0}f=c[b+4>>2]|0;if((f|0)<0){if((c[b+8>>2]|0)<0){h=c[b+12>>2]|0;if(h){if(a[b+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=0;c[b+8>>2]=0}do{v=(c[b+12>>2]|0)+(f<<4)|0;c[v>>2]=c[G+168>>2];c[v+4>>2]=c[G+168+4>>2];c[v+8>>2]=c[G+168+8>>2];c[v+12>>2]=c[G+168+12>>2];f=f+1|0}while((f|0)!=0)}c[b+4>>2]=0;c[G+24>>2]=0;c[G+24+4>>2]=0;c[G+24+8>>2]=0;f=c[b+24>>2]|0;if((f|0)<0){if((c[b+28>>2]|0)<0){h=c[b+32>>2]|0;if(h){if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+28>>2]=0}do{v=(c[b+32>>2]|0)+(f*12|0)|0;c[v>>2]=c[G+24>>2];c[v+4>>2]=c[G+24+4>>2];c[v+8>>2]=c[G+24+8>>2];f=f+1|0}while((f|0)!=0)}c[b+24>>2]=0;f=c[b+44>>2]|0;if((f|0)<0){h=c[b+52>>2]|0;do if((c[b+48>>2]|0)<0){if(!h){a[b+56>>0]=1;c[b+52>>2]=0;c[b+48>>2]=0;h=0;break}if(a[b+56>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[h+-4>>2]|0)}a[b+56>>0]=1;c[b+52>>2]=0;c[b+48>>2]=0;h=0}while(0);qF(h+(f<<2)|0,0,_(f,-4)|0)|0}c[b+44>>2]=0;f=c[G+40+124>>2]|0;if((c[f+104>>2]|0)<0){c[f+104>>2]=0;c[2703]=(c[2703]|0)+1;t=XE(23)|0;c[(t+4+15&-16)+-4>>2]=t;c[(t+4+15&-16)>>2]=f;t=t+4+15&-16;B=1;e=0;h=1;while(1){if((c[f+100>>2]|0)>-1){g[G+232+(c[G+40+108>>2]<<2)>>2]=+(c[f+88>>2]|0);g[G+232+(c[G+40+112>>2]<<2)>>2]=+(c[f+92>>2]|0);j=+(c[f+96>>2]|0)}else{v=f+24|0;y=f+32|0;j=+qE(c[v>>2]|0,c[v+4>>2]|0,c[y>>2]|0,c[y+4>>2]|0);y=f+72|0;v=f+80|0;r=c[v>>2]|0;v=c[v+4>>2]|0;j=j/+qE(c[y>>2]|0,c[y+4>>2]|0,r,v);g[G+232+(c[G+40+108>>2]<<2)>>2]=j;n=f+40|0;x=f+48|0;j=+qE(c[n>>2]|0,c[n+4>>2]|0,c[x>>2]|0,c[x+4>>2]|0);j=j/+qE(c[y>>2]|0,c[y+4>>2]|0,r,v);g[G+232+(c[G+40+112>>2]<<2)>>2]=j;x=f+56|0;n=f+64|0;j=+qE(c[x>>2]|0,c[x+4>>2]|0,c[n>>2]|0,c[n+4>>2]|0);j=j/+qE(c[y>>2]|0,c[y+4>>2]|0,r,v)}g[G+232+(c[G+40+104>>2]<<2)>>2]=j;s=+g[G+232>>2]*+g[G+40>>2]+ +g[G+40+16>>2];p=+g[G+232+4>>2]*+g[G+40+4>>2]+ +g[G+40+20>>2];q=+g[G+232+8>>2]*+g[G+40+8>>2]+ +g[G+40+24>>2];l=c[b+4>>2]|0;if((l|0)==(c[b+8>>2]|0)?(E=(l|0)!=0?l<<1:1,(l|0)<(E|0)):0){if(!E)m=0;else{c[2703]=(c[2703]|0)+1;l=XE((E<<4|3)+16|0)|0;if(!l)m=0;else{c[(l+4+15&-16)+-4>>2]=l;m=l+4+15&-16}l=c[b+4>>2]|0}if((l|0)>0){n=0;do{v=m+(n<<4)|0;r=(c[b+12>>2]|0)+(n<<4)|0;c[v>>2]=c[r>>2];c[v+4>>2]=c[r+4>>2];c[v+8>>2]=c[r+8>>2];c[v+12>>2]=c[r+12>>2];n=n+1|0}while((n|0)!=(l|0))}l=c[b+12>>2]|0;if(l){if(a[b+16>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[l+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=m;c[b+8>>2]=E;l=c[b+4>>2]|0}D=c[b+12>>2]|0;g[D+(l<<4)>>2]=s;g[D+(l<<4)+4>>2]=p;g[D+(l<<4)+8>>2]=q;g[D+(l<<4)+12>>2]=0.0;c[b+4>>2]=(c[b+4>>2]|0)+1;D=c[f+8>>2]|0;if(!D){n=t;l=B}else{C=D;m=-1;y=-1;while(1){x=C+20|0;l=c[x>>2]|0;if((l|0)<0){d=c[b+24>>2]|0;c[G+12>>2]=0;c[G+12+4>>2]=0;c[G+12+8>>2]=0;do if((d|0)==(c[b+28>>2]|0)){f=(d|0)!=0?d<<1:1;if((d|0)>=(f|0)){n=d;break}if(!f){l=d;r=0}else{c[2703]=(c[2703]|0)+1;n=XE((f*12|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}l=c[b+24>>2]|0;r=n}if((l|0)>0){n=0;do{v=r+(n*12|0)|0;H=(c[b+32>>2]|0)+(n*12|0)|0;c[v>>2]=c[H>>2];c[v+4>>2]=c[H+4>>2];c[v+8>>2]=c[H+8>>2];n=n+1|0}while((n|0)!=(l|0))}n=c[b+32>>2]|0;if(n){if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=r;c[b+28>>2]=f;n=c[b+24>>2]|0}else n=d;while(0);n=(c[b+32>>2]|0)+(n*12|0)|0;c[n>>2]=c[G+12>>2];c[n+4>>2]=c[G+12+4>>2];c[n+8>>2]=c[G+12+8>>2];n=(c[b+24>>2]|0)+1|0;c[b+24>>2]=n;c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;do if((n|0)==(c[b+28>>2]|0)){v=(n|0)!=0?n<<1:1;if((n|0)>=(v|0))break;if(!v)l=0;else{c[2703]=(c[2703]|0)+1;n=XE((v*12|3)+16|0)|0;if(!n)l=0;else{c[(n+4+15&-16)+-4>>2]=n;l=n+4+15&-16}n=c[b+24>>2]|0}if((n|0)>0){f=0;do{r=l+(f*12|0)|0;H=(c[b+32>>2]|0)+(f*12|0)|0;c[r>>2]=c[H>>2];c[r+4>>2]=c[H+4>>2];c[r+8>>2]=c[H+8>>2];f=f+1|0}while((f|0)!=(n|0))}n=c[b+32>>2]|0;if(n){if(a[b+36>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=l;c[b+28>>2]=v;n=c[b+24>>2]|0}while(0);f=(c[b+32>>2]|0)+(n*12|0)|0;c[f>>2]=c[G>>2];c[f+4>>2]=c[G+4>>2];c[f+8>>2]=c[G+8>>2];c[b+24>>2]=(c[b+24>>2]|0)+1;f=c[b+32>>2]|0;c[x>>2]=d;c[(c[C+8>>2]|0)+20>>2]=d+1;c[f+(d*12|0)+4>>2]=1;c[f+((d+1|0)*12|0)+4>>2]=-1;v=c[C+12>>2]|0;n=c[v+104>>2]|0;if((n|0)<0){c[v+104>>2]=h;do if((h|0)==(B|0)){l=(B|0)!=0?B<<1:1;if((B|0)>=(l|0)){n=t;l=B;break}do if(!l)n=0;else{c[2703]=(c[2703]|0)+1;n=XE((l<<2|3)+16|0)|0;if(!n){n=0;break}c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}while(0);if((B|0)<=0){if(!t)break}else{r=0;do{c[n+(r<<2)>>2]=c[t+(r<<2)>>2];r=r+1|0}while((r|0)!=(B|0))}c[2704]=(c[2704]|0)+1;YE(c[t+-4>>2]|0)}else{n=t;l=B}while(0);c[n+(h<<2)>>2]=v;t=n;n=h;h=h+1|0}else l=B;c[f+(d*12|0)+8>>2]=n;c[f+((d+1|0)*12|0)+8>>2]=e;r=c[x>>2]|0;n=t}else{r=l;n=t;l=B}if((y|0)>-1)c[(c[b+32>>2]|0)+(r*12|0)>>2]=y-r;else m=r;C=c[C>>2]|0;if((C|0)==(D|0))break;else{t=n;B=l;y=r}}c[(c[b+32>>2]|0)+(m*12|0)>>2]=r-m}d=e+1|0;if((d|0)>=(h|0))break;f=c[n+(d<<2)>>2]|0;t=n;B=l;e=d}if((e|0)>-1){y=0;do{v=c[(c[n+(y<<2)>>2]|0)+8>>2]|0;if(v){x=v;do{t=x+20|0;h=c[t>>2]|0;if((h|0)>-1){f=c[b+44>>2]|0;do if((f|0)==(c[b+48>>2]|0)){r=(f|0)!=0?f<<1:1;if((f|0)>=(r|0))break;if(!r){h=f;f=0}else{c[2703]=(c[2703]|0)+1;h=XE((r<<2|3)+16|0)|0;if(!h)f=0;else{c[(h+4+15&-16)+-4>>2]=h;f=h+4+15&-16}h=c[b+44>>2]|0}m=c[b+52>>2]|0;if((h|0)<=0){if(m)F=174}else{l=0;do{c[f+(l<<2)>>2]=c[m+(l<<2)>>2];l=l+1|0}while((l|0)!=(h|0));F=174}if((F|0)==174){F=0;if(a[b+56>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[m+-4>>2]|0)}c[b+52>>2]=0;h=c[b+44>>2]|0}a[b+56>>0]=1;c[b+52>>2]=f;c[b+48>>2]=r;f=h;h=c[t>>2]|0}while(0);c[(c[b+52>>2]|0)+(f<<2)>>2]=h;c[b+44>>2]=(c[b+44>>2]|0)+1;h=x;do{c[h+20>>2]=-1;h=c[(c[h+8>>2]|0)+4>>2]|0}while((h|0)!=(x|0))}x=c[x>>2]|0}while((x|0)!=(v|0))}y=y+1|0}while((y|0)<(d|0))}if(n){c[2704]=(c[2704]|0)+1;YE(c[n+-4>>2]|0)}}rE(G+40|0);i=G;return}function pE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+16|0;h=c[a+12>>2]|0;j=c[h+(((d+b|0)/2|0)<<4)>>2]|0;k=c[h+(((d+b|0)/2|0)<<4)+4>>2]|0;l=c[h+(((d+b|0)/2|0)<<4)+8>>2]|0;e=b;f=d;while(1){g=e;while(1){e=c[h+(g<<4)+4>>2]|0;if((e|0)>=(k|0)){if((e|0)!=(k|0))break;e=c[h+(g<<4)>>2]|0;if((e|0)>=(j|0)){if((e|0)!=(j|0))break;if((c[h+(g<<4)+8>>2]|0)>=(l|0))break}}g=g+1|0}while(1){e=c[h+(f<<4)+4>>2]|0;if((k|0)>=(e|0)){if((k|0)!=(e|0))break;e=c[h+(f<<4)>>2]|0;if((j|0)>=(e|0)){if((j|0)!=(e|0))break;if((l|0)>=(c[h+(f<<4)+8>>2]|0))break}}f=f+-1|0}if((g|0)>(f|0))e=g;else{e=h+(g<<4)|0;c[m>>2]=c[e>>2];c[m+4>>2]=c[e+4>>2];c[m+8>>2]=c[e+8>>2];c[m+12>>2]=c[e+12>>2];h=h+(f<<4)|0;c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];e=(c[a+12>>2]|0)+(f<<4)|0;c[e>>2]=c[m>>2];c[e+4>>2]=c[m+4>>2];c[e+8>>2]=c[m+8>>2];c[e+12>>2]=c[m+12>>2];e=g+1|0;f=f+-1|0}if((e|0)>(f|0))break;h=c[a+12>>2]|0}if((f|0)>(b|0))pE(a,b,f);if((e|0)>=(d|0)){i=m;return}pE(a,e,d);i=m;return}function qE(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0,g=0;if((d|0)>-1|(d|0)==-1&c>>>0>4294967295){e=(+(c>>>0)+4294967296.0*+(d>>>0))*18446744073709551616.0+(+(a>>>0)+4294967296.0*+(b>>>0));return +e}else{g=pF(0,0,a|0,b|0)|0;f=C;a=sF((a|0)==0&(b|0)==0&1|0,0,~c|0,~d|0)|0;e=-+qE(g,f,a,C);return +e}return 0.0}function rE(b){b=b|0;var d=0,e=0;d=c[b+92>>2]|0;if(d){if(a[b+96>>0]|0){c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0)}c[b+92>>2]=0}a[b+96>>0]=1;c[b+92>>2]=0;c[b+84>>2]=0;c[b+88>>2]=0;d=c[b+64>>2]|0;if(d)do{c[b+64>>2]=c[d+8>>2];e=c[d>>2]|0;if(e){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);d=c[b+64>>2]|0}while((d|0)!=0);d=c[b+48>>2]|0;if(d)do{c[b+48>>2]=c[d+8>>2];e=c[d>>2]|0;if(e){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);d=c[b+48>>2]|0}while((d|0)!=0);d=c[b+32>>2]|0;if(!d)return;do{c[b+32>>2]=c[d+8>>2];e=c[d>>2]|0;if(e){c[2704]=(c[2704]|0)+1;YE(c[e+-4>>2]|0)}c[2704]=(c[2704]|0)+1;YE(c[d+-4>>2]|0);d=c[b+32>>2]|0}while((d|0)!=0);return}function sE(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;g=i;i=i+16|0;c[g>>2]=d;eF(11520,b,g)|0;b=(a[11595]|0)==10;do if((c[2899]|0)<0){if(!b?(e=c[2885]|0,e>>>0<(c[2884]|0)>>>0):0){c[2885]=e+1;a[e>>0]=10;break}dF(11520,10)|0}else{if(!b?(f=c[2885]|0,f>>>0<(c[2884]|0)>>>0):0){c[2885]=f+1;a[f>>0]=10;break}dF(11520,10)|0}while(0);Va()}function tE(a){a=a|0;return}function uE(a){a=a|0;YE(a);return}function vE(a){a=a|0;return 20290}function wE(a){a=a|0;var b=0;b=i;i=i+16|0;kc[a&3]();sE(20305,b)}function xE(a){a=a|0;return}function yE(a){a=a|0;return}function zE(a){a=a|0;return}function AE(a){a=a|0;YE(a);return}function BE(a){a=a|0;YE(a);return}function CE(a){a=a|0;YE(a);return}function DE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;g=i;i=i+64|0;if((a|0)!=(b|0))if((b|0)!=0?(f=IE(b,2456)|0,(f|0)!=0):0){b=g;e=b+56|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(e|0));c[g>>2]=f;c[g+8>>2]=a;c[g+12>>2]=-1;c[g+48>>2]=1;nc[c[(c[f>>2]|0)+28>>2]&127](f,g,c[d>>2]|0,1);if((c[g+24>>2]|0)==1){c[d>>2]=c[g+16>>2];b=1}else b=0}else b=0;else b=1;i=g;return b|0}function EE(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;do if((b|0)==(c[d+8>>2]|0)){b=c[d+16>>2]|0;if(!b){c[d+16>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;break}if((b|0)!=(e|0)){c[d+36>>2]=(c[d+36>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;break}if((c[d+24>>2]|0)==2)c[d+24>>2]=f}while(0);return}function FE(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;do if((b|0)==(c[d+8>>2]|0)){b=c[d+16>>2]|0;if(!b){c[d+16>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;break}if((b|0)!=(e|0)){c[d+36>>2]=(c[d+36>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;break}if((c[d+24>>2]|0)==2)c[d+24>>2]=f}else{b=c[b+8>>2]|0;nc[c[(c[b>>2]|0)+28>>2]&127](b,d,e,f)}while(0);return}function GE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=c[a+4>>2]|0;if(!(f&1))g=f>>8;else g=c[(c[d>>2]|0)+(f>>8)>>2]|0;a=c[a>>2]|0;nc[c[(c[a>>2]|0)+28>>2]&127](a,b,d+g|0,(f&2|0)!=0?e:2);return}function HE(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;a:do if((b|0)==(c[d+8>>2]|0)){g=c[d+16>>2]|0;if(!g){c[d+16>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;break}if((g|0)!=(e|0)){c[d+36>>2]=(c[d+36>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;break}if((c[d+24>>2]|0)==2)c[d+24>>2]=f}else{g=c[b+12>>2]|0;GE(b+16|0,d,e,f);if((g|0)>1){h=b+24|0;do{GE(h,d,e,f);if(a[d+54>>0]|0)break a;h=h+8|0}while(h>>>0<(b+16+(g<<3)|0)>>>0)}}while(0);return}function IE(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0;j=i;i=i+64|0;h=c[d>>2]|0;g=d+(c[h+-8>>2]|0)|0;h=c[h+-4>>2]|0;c[j>>2]=e;c[j+4>>2]=d;c[j+8>>2]=2440;d=j+12|0;f=d+40|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));b[j+12+40>>1]=0;a[j+12+42>>0]=0;a:do if((h|0)==(e|0)){c[j+48>>2]=1;Rb[c[(c[e>>2]|0)+20>>2]&7](e,j,g,g,1,0);d=(c[j+24>>2]|0)==1?g:0}else{Bb[c[(c[h>>2]|0)+24>>2]&31](h,j,g,1,0);switch(c[j+36>>2]|0){case 0:{d=((c[j+40>>2]|0)==1?(c[j+28>>2]|0)==1:0)&(c[j+32>>2]|0)==1?c[j+20>>2]|0:0;break a}case 1:break;default:{d=0;break a}}if((c[j+24>>2]|0)!=1?!(((c[j+40>>2]|0)==0?(c[j+28>>2]|0)==1:0)&(c[j+32>>2]|0)==1):0){d=0;break}d=c[j+16>>2]|0}while(0);i=j;return d|0}function JE(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;a[b+53>>0]=1;do if((c[b+4>>2]|0)==(e|0)){a[b+52>>0]=1;e=c[b+16>>2]|0;if(!e){c[b+16>>2]=d;c[b+24>>2]=f;c[b+36>>2]=1;if(!((f|0)==1?(c[b+48>>2]|0)==1:0))break;a[b+54>>0]=1;break}if((e|0)!=(d|0)){c[b+36>>2]=(c[b+36>>2]|0)+1;a[b+54>>0]=1;break}e=c[b+24>>2]|0;if((e|0)==2){c[b+24>>2]=f;e=f}if((e|0)==1?(c[b+48>>2]|0)==1:0)a[b+54>>0]=1}while(0);return}function KE(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;a:do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(c[d+28>>2]|0)!=1:0)c[d+28>>2]=f}else{if((b|0)!=(c[d>>2]|0)){j=c[b+12>>2]|0;ME(b+16|0,d,e,f,g);if((j|0)<=1)break;i=c[b+8>>2]|0;if((i&2|0)==0?(c[d+36>>2]|0)!=1:0){if(!(i&1)){i=b+24|0;while(1){if(a[d+54>>0]|0)break a;if((c[d+36>>2]|0)==1)break a;ME(i,d,e,f,g);i=i+8|0;if(i>>>0>=(b+16+(j<<3)|0)>>>0)break a}}i=b+24|0;while(1){if(a[d+54>>0]|0)break a;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==1:0)break a;ME(i,d,e,f,g);i=i+8|0;if(i>>>0>=(b+16+(j<<3)|0)>>>0)break a}}i=b+24|0;while(1){if(a[d+54>>0]|0)break a;ME(i,d,e,f,g);i=i+8|0;if(i>>>0>=(b+16+(j<<3)|0)>>>0)break a}}if((c[d+16>>2]|0)!=(e|0)?(c[d+20>>2]|0)!=(e|0):0){c[d+32>>2]=f;if((c[d+44>>2]|0)==4)break;j=c[b+12>>2]|0;b:do if((j|0)>0){i=0;h=0;f=b+16|0;c:do{a[d+52>>0]=0;a[d+53>>0]=0;LE(f,d,e,e,1,g);if(a[d+54>>0]|0)break;do if(a[d+53>>0]|0){if(!(a[d+52>>0]|0))if(!(c[b+8>>2]&1)){h=1;break c}else{h=1;break}if((c[d+24>>2]|0)==1){i=25;break b}if(!(c[b+8>>2]&2)){i=25;break b}else{i=1;h=1}}while(0);f=f+8|0}while(f>>>0<(b+16+(j<<3)|0)>>>0);if(i)i=24;else i=21}else{h=0;i=21}while(0);if((i|0)==21){c[d+20>>2]=e;c[d+40>>2]=(c[d+40>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(h)i=25;else i=26}else i=24}if((i|0)==24)if(h)i=25;else i=26;if((i|0)==25){c[d+44>>2]=3;break}else if((i|0)==26){c[d+44>>2]=4;break}}if((f|0)==1)c[d+32>>2]=1}while(0);return}function LE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;h=c[a+4>>2]|0;if(!(h&1))i=h>>8;else i=c[(c[e>>2]|0)+(h>>8)>>2]|0;a=c[a>>2]|0;Rb[c[(c[a>>2]|0)+20>>2]&7](a,b,d,e+i|0,(h&2|0)!=0?f:2,g);return}function ME(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=c[a+4>>2]|0;if(!(g&1))h=g>>8;else h=c[(c[d>>2]|0)+(g>>8)>>2]|0;a=c[a>>2]|0;Bb[c[(c[a>>2]|0)+24>>2]&31](a,b,d+h|0,(g&2|0)!=0?e:2,f);return}function NE(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;a:do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(c[d+28>>2]|0)!=1:0)c[d+28>>2]=f}else{if((b|0)!=(c[d>>2]|0)){b=c[b+8>>2]|0;Bb[c[(c[b>>2]|0)+24>>2]&31](b,d,e,f,g);break}if((c[d+16>>2]|0)!=(e|0)?(c[d+20>>2]|0)!=(e|0):0){c[d+32>>2]=f;if((c[d+44>>2]|0)==4)break;a[d+52>>0]=0;a[d+53>>0]=0;f=c[b+8>>2]|0;Rb[c[(c[f>>2]|0)+20>>2]&7](f,d,e,e,1,g);if(a[d+53>>0]|0){if(!(a[d+52>>0]|0)){f=1;h=13}}else{f=0;h=13}do if((h|0)==13){c[d+20>>2]=e;c[d+40>>2]=(c[d+40>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(f)break}else h=16;if((h|0)==16?f:0)break;c[d+44>>2]=4;break a}while(0);c[d+44>>2]=3;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function OE(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(c[d+28>>2]|0)!=1:0)c[d+28>>2]=f}else if((b|0)==(c[d>>2]|0)){if((c[d+16>>2]|0)!=(e|0)?(c[d+20>>2]|0)!=(e|0):0){c[d+32>>2]=f;c[d+20>>2]=e;c[d+40>>2]=(c[d+40>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0)a[d+54>>0]=1;c[d+44>>2]=4;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function PE(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0;if((b|0)==(c[d+8>>2]|0))JE(d,e,f,g);else{i=a[d+52>>0]|0;j=a[d+53>>0]|0;k=c[b+12>>2]|0;a[d+52>>0]=0;a[d+53>>0]=0;LE(b+16|0,d,e,f,g,h);a:do if((k|0)>1){l=b+24|0;do{if(a[d+54>>0]|0)break a;if(!(a[d+52>>0]|0)){if((a[d+53>>0]|0)!=0?(c[b+8>>2]&1|0)==0:0)break a}else{if((c[d+24>>2]|0)==1)break a;if(!(c[b+8>>2]&2))break a}a[d+52>>0]=0;a[d+53>>0]=0;LE(l,d,e,f,g,h);l=l+8|0}while(l>>>0<(b+16+(k<<3)|0)>>>0)}while(0);a[d+52>>0]=i;a[d+53>>0]=j}return}function QE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;if((a|0)==(c[b+8>>2]|0))JE(b,d,e,f);else{a=c[a+8>>2]|0;Rb[c[(c[a>>2]|0)+20>>2]&7](a,b,d,e,f,g)}return}function RE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;if((a|0)==(c[b+8>>2]|0))JE(b,d,e,f);return}function SE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e>>2]=c[d>>2];a=Qb[c[(c[a>>2]|0)+16>>2]&63](a,b,e)|0;if(a)c[d>>2]=c[e>>2];i=e;return a&1|0}function TE(a){a=a|0;if(!a)a=0;else a=(IE(a,2488)|0)!=0;return a&1|0}function UE(){var a=0,b=0,d=0,e=0;e=i;i=i+48|0;if(mb(10972,3)|0)sE(20241,e);a=jb(c[2742]|0)|0;if((a|0)!=0?(d=c[a>>2]|0,(d|0)!=0):0){a=c[d+48>>2]|0;b=c[d+48+4>>2]|0;if(!((a&-256|0)==1126902528&(b|0)==1129074247)){c[e+32>>2]=20584;sE(20534,e+32|0)}if((a|0)==1126902529&(b|0)==1129074247)a=c[d+44>>2]|0;else a=d+80|0;c[e+44>>2]=a;b=c[d>>2]|0;a=c[b+4>>2]|0;if(DE(2424,b,e+44|0)|0){b=c[e+44>>2]|0;b=Hb[c[(c[b>>2]|0)+8>>2]&127](b)|0;c[e+8>>2]=20584;c[e+8+4>>2]=a;c[e+8+8>>2]=b;sE(20448,e+8|0)}else{c[e+24>>2]=20584;c[e+24+4>>2]=a;sE(20493,e+24|0)}}sE(20572,e+40|0)}function VE(){var a=0;a=i;i=i+16|0;if(!(Ua(10968,215)|0)){i=a;return}else sE(20345,a)}function WE(a){a=a|0;var b=0;b=i;i=i+16|0;YE(a);if(!(qb(c[2742]|0,0)|0)){i=b;return}else sE(20395,b)}function XE(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;do if(a>>>0<245){m=a>>>0<11?16:a+11&-8;i=c[2755]|0;if(i>>>(m>>>3)&3){d=(i>>>(m>>>3)&1^1)+(m>>>3)<<1;b=c[11060+(d+2<<2)>>2]|0;e=c[b+8>>2]|0;do if((11060+(d<<2)|0)==(e|0))c[2755]=i&~(1<<(i>>>(m>>>3)&1^1)+(m>>>3));else{if(e>>>0>=(c[2759]|0)>>>0?(c[e+12>>2]|0)==(b|0):0){c[e+12>>2]=11060+(d<<2);c[11060+(d+2<<2)>>2]=e;break}Va()}while(0);w=(i>>>(m>>>3)&1^1)+(m>>>3)<<3;c[b+4>>2]=w|3;c[b+(w|4)>>2]=c[b+(w|4)>>2]|1;b=b+8|0;break}h=c[2757]|0;if(m>>>0>h>>>0){if(i>>>(m>>>3)){f=i>>>(m>>>3)<<(m>>>3)&(2<<(m>>>3)|0-(2<<(m>>>3)));g=((f&0-f)+-1|0)>>>(((f&0-f)+-1|0)>>>12&16);b=g>>>(g>>>5&8)>>>(g>>>(g>>>5&8)>>>2&4);b=(g>>>5&8|((f&0-f)+-1|0)>>>12&16|g>>>(g>>>5&8)>>>2&4|b>>>1&2|b>>>(b>>>1&2)>>>1&1)+(b>>>(b>>>1&2)>>>(b>>>(b>>>1&2)>>>1&1))|0;g=c[11060+((b<<1)+2<<2)>>2]|0;f=c[g+8>>2]|0;do if((11060+(b<<1<<2)|0)==(f|0)){c[2755]=i&~(1<<b);j=h}else{if(f>>>0>=(c[2759]|0)>>>0?(c[f+12>>2]|0)==(g|0):0){c[f+12>>2]=11060+(b<<1<<2);c[11060+((b<<1)+2<<2)>>2]=f;j=c[2757]|0;break}Va()}while(0);c[g+4>>2]=m|3;c[g+(m|4)>>2]=(b<<3)-m|1;c[g+(b<<3)>>2]=(b<<3)-m;if(j){d=c[2760]|0;f=j>>>3;e=c[2755]|0;if(e&1<<f){e=c[11060+((f<<1)+2<<2)>>2]|0;if(e>>>0<(c[2759]|0)>>>0)Va();else{l=11060+((f<<1)+2<<2)|0;k=e}}else{c[2755]=e|1<<f;l=11060+((f<<1)+2<<2)|0;k=11060+(f<<1<<2)|0}c[l>>2]=d;c[k+12>>2]=d;c[d+8>>2]=k;c[d+12>>2]=11060+(f<<1<<2)}c[2757]=(b<<3)-m;c[2760]=g+m;b=g+8|0;break}h=c[2756]|0;if(h){i=((h&0-h)+-1|0)>>>(((h&0-h)+-1|0)>>>12&16);a=i>>>(i>>>5&8)>>>(i>>>(i>>>5&8)>>>2&4);a=c[11324+((i>>>5&8|((h&0-h)+-1|0)>>>12&16|i>>>(i>>>5&8)>>>2&4|a>>>1&2|a>>>(a>>>1&2)>>>1&1)+(a>>>(a>>>1&2)>>>(a>>>(a>>>1&2)>>>1&1))<<2)>>2]|0;i=(c[a+4>>2]&-8)-m|0;e=a;while(1){f=c[e+16>>2]|0;if(!f){f=c[e+20>>2]|0;if(!f)break}e=(c[f+4>>2]&-8)-m|0;w=e>>>0<i>>>0;i=w?e:i;e=f;a=w?f:a}h=c[2759]|0;if(a>>>0>=h>>>0?(n=a+m|0,a>>>0<n>>>0):0){g=c[a+24>>2]|0;f=c[a+12>>2]|0;do if((f|0)==(a|0)){e=a+20|0;f=c[e>>2]|0;if(!f){e=a+16|0;f=c[e>>2]|0;if(!f){p=0;break}}while(1){d=f+20|0;b=c[d>>2]|0;if(b){f=b;e=d;continue}d=f+16|0;b=c[d>>2]|0;if(!b)break;else{f=b;e=d}}if(e>>>0<h>>>0)Va();else{c[e>>2]=0;p=f;break}}else{e=c[a+8>>2]|0;if((e>>>0>=h>>>0?(c[e+12>>2]|0)==(a|0):0)?(c[f+8>>2]|0)==(a|0):0){c[e+12>>2]=f;c[f+8>>2]=e;p=f;break}Va()}while(0);do if(g){f=c[a+28>>2]|0;if((a|0)==(c[11324+(f<<2)>>2]|0)){c[11324+(f<<2)>>2]=p;if(!p){c[2756]=c[2756]&~(1<<f);break}}else{if(g>>>0<(c[2759]|0)>>>0)Va();if((c[g+16>>2]|0)==(a|0))c[g+16>>2]=p;else c[g+20>>2]=p;if(!p)break}e=c[2759]|0;if(p>>>0<e>>>0)Va();c[p+24>>2]=g;f=c[a+16>>2]|0;do if(f)if(f>>>0<e>>>0)Va();else{c[p+16>>2]=f;c[f+24>>2]=p;break}while(0);e=c[a+20>>2]|0;if(e)if(e>>>0<(c[2759]|0)>>>0)Va();else{c[p+20>>2]=e;c[e+24>>2]=p;break}}while(0);if(i>>>0<16){w=i+m|0;c[a+4>>2]=w|3;w=a+(w+4)|0;c[w>>2]=c[w>>2]|1}else{c[a+4>>2]=m|3;c[a+(m|4)>>2]=i|1;c[a+(i+m)>>2]=i;f=c[2757]|0;if(f){d=c[2760]|0;e=c[2755]|0;if(e&1<<(f>>>3)){e=c[11060+((f>>>3<<1)+2<<2)>>2]|0;if(e>>>0<(c[2759]|0)>>>0)Va();else{o=11060+((f>>>3<<1)+2<<2)|0;q=e}}else{c[2755]=e|1<<(f>>>3);o=11060+((f>>>3<<1)+2<<2)|0;q=11060+(f>>>3<<1<<2)|0}c[o>>2]=d;c[q+12>>2]=d;c[d+8>>2]=q;c[d+12>>2]=11060+(f>>>3<<1<<2)}c[2757]=i;c[2760]=n}b=a+8|0;break}Va()}else{q=m;J=154}}else{q=m;J=154}}else if(a>>>0<=4294967231){q=a+11&-8;l=c[2756]|0;if(l){if((a+11|0)>>>8)if(q>>>0>16777215)k=31;else{k=(a+11|0)>>>8<<((((a+11|0)>>>8)+1048320|0)>>>16&8);k=14-((k+520192|0)>>>16&4|(((a+11|0)>>>8)+1048320|0)>>>16&8|((k<<((k+520192|0)>>>16&4))+245760|0)>>>16&2)+(k<<((k+520192|0)>>>16&4)<<(((k<<((k+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;k=q>>>(k+7|0)&1|k<<1}else k=0;h=c[11324+(k<<2)>>2]|0;a:do if(!h){g=0-q|0;f=0;h=0;J=86}else{g=0-q|0;f=0;i=q<<((k|0)==31?0:25-(k>>>1)|0);d=h;h=0;while(1){e=c[d+4>>2]&-8;if((e-q|0)>>>0<g>>>0)if((e|0)==(q|0)){g=e-q|0;a=d;h=d;J=90;break a}else{g=e-q|0;h=d}p=c[d+20>>2]|0;d=c[d+16+(i>>>31<<2)>>2]|0;f=(p|0)==0|(p|0)==(d|0)?f:p;if(!d){J=86;break}else i=i<<1}}while(0);if((J|0)==86){if((f|0)==0&(h|0)==0){h=2<<k;if(!(l&(h|0-h))){J=154;break}p=(l&(h|0-h)&0-(l&(h|0-h)))+-1|0;h=p>>>(p>>>12&16)>>>(p>>>(p>>>12&16)>>>5&8);f=h>>>(h>>>2&4)>>>(h>>>(h>>>2&4)>>>1&2);f=c[11324+((p>>>(p>>>12&16)>>>5&8|p>>>12&16|h>>>2&4|h>>>(h>>>2&4)>>>1&2|f>>>1&1)+(f>>>(f>>>1&1))<<2)>>2]|0;h=0}if(!f){o=g;p=h}else{a=f;J=90}}if((J|0)==90)while(1){J=0;p=(c[a+4>>2]&-8)-q|0;f=p>>>0<g>>>0;g=f?p:g;h=f?a:h;f=c[a+16>>2]|0;if(f){a=f;J=90;continue}a=c[a+20>>2]|0;if(!a){o=g;p=h;break}else J=90}if((p|0)!=0?o>>>0<((c[2757]|0)-q|0)>>>0:0){h=c[2759]|0;if(p>>>0>=h>>>0?(w=p+q|0,p>>>0<w>>>0):0){b=c[p+24>>2]|0;f=c[p+12>>2]|0;do if((f|0)==(p|0)){e=p+20|0;f=c[e>>2]|0;if(!f){e=p+16|0;f=c[e>>2]|0;if(!f){m=0;break}}while(1){g=f+20|0;d=c[g>>2]|0;if(d){f=d;e=g;continue}g=f+16|0;d=c[g>>2]|0;if(!d)break;else{f=d;e=g}}if(e>>>0<h>>>0)Va();else{c[e>>2]=0;m=f;break}}else{e=c[p+8>>2]|0;if((e>>>0>=h>>>0?(c[e+12>>2]|0)==(p|0):0)?(c[f+8>>2]|0)==(p|0):0){c[e+12>>2]=f;c[f+8>>2]=e;m=f;break}Va()}while(0);do if(b){f=c[p+28>>2]|0;if((p|0)==(c[11324+(f<<2)>>2]|0)){c[11324+(f<<2)>>2]=m;if(!m){c[2756]=c[2756]&~(1<<f);break}}else{if(b>>>0<(c[2759]|0)>>>0)Va();if((c[b+16>>2]|0)==(p|0))c[b+16>>2]=m;else c[b+20>>2]=m;if(!m)break}e=c[2759]|0;if(m>>>0<e>>>0)Va();c[m+24>>2]=b;f=c[p+16>>2]|0;do if(f)if(f>>>0<e>>>0)Va();else{c[m+16>>2]=f;c[f+24>>2]=m;break}while(0);f=c[p+20>>2]|0;if(f)if(f>>>0<(c[2759]|0)>>>0)Va();else{c[m+20>>2]=f;c[f+24>>2]=m;break}}while(0);b:do if(o>>>0>=16){c[p+4>>2]=q|3;c[p+(q|4)>>2]=o|1;c[p+(o+q)>>2]=o;f=o>>>3;if(o>>>0<256){e=c[2755]|0;if(e&1<<f){e=c[11060+((f<<1)+2<<2)>>2]|0;if(e>>>0<(c[2759]|0)>>>0)Va();else{s=11060+((f<<1)+2<<2)|0;t=e}}else{c[2755]=e|1<<f;s=11060+((f<<1)+2<<2)|0;t=11060+(f<<1<<2)|0}c[s>>2]=w;c[t+12>>2]=w;c[p+(q+8)>>2]=t;c[p+(q+12)>>2]=11060+(f<<1<<2);break}e=o>>>8;if(e)if(o>>>0>16777215)b=31;else{b=e<<((e+1048320|0)>>>16&8)<<(((e<<((e+1048320|0)>>>16&8))+520192|0)>>>16&4);b=14-(((e<<((e+1048320|0)>>>16&8))+520192|0)>>>16&4|(e+1048320|0)>>>16&8|(b+245760|0)>>>16&2)+(b<<((b+245760|0)>>>16&2)>>>15)|0;b=o>>>(b+7|0)&1|b<<1}else b=0;f=11324+(b<<2)|0;c[p+(q+28)>>2]=b;c[p+(q+20)>>2]=0;c[p+(q+16)>>2]=0;e=c[2756]|0;d=1<<b;if(!(e&d)){c[2756]=e|d;c[f>>2]=w;c[p+(q+24)>>2]=f;c[p+(q+12)>>2]=w;c[p+(q+8)>>2]=w;break}e=c[f>>2]|0;c:do if((c[e+4>>2]&-8|0)!=(o|0)){b=o<<((b|0)==31?0:25-(b>>>1)|0);while(1){d=e+16+(b>>>31<<2)|0;f=c[d>>2]|0;if(!f)break;if((c[f+4>>2]&-8|0)==(o|0)){v=f;break c}else{b=b<<1;e=f}}if(d>>>0<(c[2759]|0)>>>0)Va();else{c[d>>2]=w;c[p+(q+24)>>2]=e;c[p+(q+12)>>2]=w;c[p+(q+8)>>2]=w;break b}}else v=e;while(0);e=v+8|0;d=c[e>>2]|0;u=c[2759]|0;if(d>>>0>=u>>>0&v>>>0>=u>>>0){c[d+12>>2]=w;c[e>>2]=w;c[p+(q+8)>>2]=d;c[p+(q+12)>>2]=v;c[p+(q+24)>>2]=0;break}else Va()}else{w=o+q|0;c[p+4>>2]=w|3;w=p+(w+4)|0;c[w>>2]=c[w>>2]|1}while(0);b=p+8|0;break}Va()}else J=154}else J=154}else{q=-1;J=154}while(0);d:do if((J|0)==154){g=c[2757]|0;if(g>>>0>=q>>>0){b=g-q|0;d=c[2760]|0;if(b>>>0>15){c[2760]=d+q;c[2757]=b;c[d+(q+4)>>2]=b|1;c[d+g>>2]=b;c[d+4>>2]=q|3}else{c[2757]=0;c[2760]=0;c[d+4>>2]=g|3;c[d+(g+4)>>2]=c[d+(g+4)>>2]|1}b=d+8|0;break}g=c[2758]|0;if(g>>>0>q>>>0){w=g-q|0;c[2758]=w;b=c[2761]|0;c[2761]=b+q;c[b+(q+4)>>2]=w|1;c[b+4>>2]=q|3;b=b+8|0;break}do if(!(c[2873]|0)){g=ib(30)|0;if(!(g+-1&g)){c[2875]=g;c[2874]=g;c[2876]=-1;c[2877]=-1;c[2878]=0;c[2866]=0;c[2873]=(ub(0)|0)&-16^1431655768;break}else Va()}while(0);l=q+48|0;f=c[2875]|0;b=q+47|0;d=f+b&0-f;if(d>>>0>q>>>0){h=c[2865]|0;if((h|0)!=0?(w=c[2863]|0,(w+d|0)>>>0<=w>>>0|(w+d|0)>>>0>h>>>0):0){b=0;break}e:do if(!(c[2866]&4)){g=c[2761]|0;f:do if(g){e=11468;while(1){h=c[e>>2]|0;if(h>>>0<=g>>>0?(r=e+4|0,(h+(c[r>>2]|0)|0)>>>0>g>>>0):0)break;h=c[e+8>>2]|0;if(!h){J=174;break f}else e=h}f=f+b-(c[2758]|0)&0-f;if(f>>>0<2147483647){h=cb(f|0)|0;w=(h|0)==((c[e>>2]|0)+(c[r>>2]|0)|0);g=w?f:0;if(w){if((h|0)!=(-1|0)){t=h;p=g;J=194;break e}}else J=184}else g=0}else J=174;while(0);do if((J|0)==174){e=cb(0)|0;if((e|0)!=(-1|0)){g=c[2874]|0;if(!(g+-1&e))f=d;else f=d-e+(g+-1+e&0-g)|0;h=c[2863]|0;g=h+f|0;if(f>>>0>q>>>0&f>>>0<2147483647){w=c[2865]|0;if((w|0)!=0?g>>>0<=h>>>0|g>>>0>w>>>0:0){g=0;break}h=cb(f|0)|0;g=(h|0)==(e|0)?f:0;if((h|0)==(e|0)){t=e;p=g;J=194;break e}else J=184}else g=0}else g=0}while(0);g:do if((J|0)==184){e=0-f|0;do if(l>>>0>f>>>0&(f>>>0<2147483647&(h|0)!=(-1|0))?(u=c[2875]|0,u=b-f+u&0-u,u>>>0<2147483647):0)if((cb(u|0)|0)==(-1|0)){cb(e|0)|0;break g}else{f=u+f|0;break}while(0);if((h|0)!=(-1|0)){t=h;p=f;J=194;break e}}while(0);c[2866]=c[2866]|4;J=191}else{g=0;J=191}while(0);if((((J|0)==191?d>>>0<2147483647:0)?(x=cb(d|0)|0,y=cb(0)|0,x>>>0<y>>>0&((x|0)!=(-1|0)&(y|0)!=(-1|0))):0)?(z=(y-x|0)>>>0>(q+40|0)>>>0,z):0){t=x;p=z?y-x|0:g;J=194}if((J|0)==194){f=(c[2863]|0)+p|0;c[2863]=f;if(f>>>0>(c[2864]|0)>>>0)c[2864]=f;a=c[2761]|0;h:do if(a){b=11468;while(1){g=c[b>>2]|0;f=b+4|0;e=c[f>>2]|0;if((t|0)==(g+e|0)){J=204;break}d=c[b+8>>2]|0;if(!d)break;else b=d}if(((J|0)==204?(c[b+12>>2]&8|0)==0:0)?a>>>0<t>>>0&a>>>0>=g>>>0:0){c[f>>2]=e+p;w=(c[2758]|0)+p|0;v=(a+8&7|0)==0?0:0-(a+8)&7;c[2761]=a+v;c[2758]=w-v;c[a+(v+4)>>2]=w-v|1;c[a+(w+4)>>2]=40;c[2762]=c[2877];break}g=c[2759]|0;if(t>>>0<g>>>0){c[2759]=t;g=t}e=t+p|0;f=11468;while(1){if((c[f>>2]|0)==(e|0)){J=212;break}f=c[f+8>>2]|0;if(!f){f=11468;break}}if((J|0)==212)if(!(c[f+12>>2]&8)){c[f>>2]=t;n=f+4|0;c[n>>2]=(c[n>>2]|0)+p;n=t+8|0;n=(n&7|0)==0?0:0-n&7;k=t+(p+8)|0;k=(k&7|0)==0?0:0-k&7;f=t+(k+p)|0;m=n+q|0;o=t+m|0;l=f-(t+n)-q|0;c[t+(n+4)>>2]=q|3;i:do if((f|0)!=(a|0)){if((f|0)==(c[2760]|0)){w=(c[2757]|0)+l|0;c[2757]=w;c[2760]=o;c[t+(m+4)>>2]=w|1;c[t+(w+m)>>2]=w;break}i=p+4|0;j=c[t+(i+k)>>2]|0;if((j&3|0)==1){j:do if(j>>>0>=256){a=c[t+((k|24)+p)>>2]|0;e=c[t+(p+12+k)>>2]|0;k:do if((e|0)==(f|0)){d=t+(i+(k|16))|0;e=c[d>>2]|0;if(!e){d=t+((k|16)+p)|0;e=c[d>>2]|0;if(!e){F=0;break}}while(1){b=e+20|0;h=c[b>>2]|0;if(h){e=h;d=b;continue}h=e+16|0;b=c[h>>2]|0;if(!b)break;else{e=b;d=h}}if(d>>>0<g>>>0)Va();else{c[d>>2]=0;F=e;break}}else{d=c[t+((k|8)+p)>>2]|0;do if(d>>>0>=g>>>0){if((c[d+12>>2]|0)!=(f|0))break;if((c[e+8>>2]|0)!=(f|0))break;c[d+12>>2]=e;c[e+8>>2]=d;F=e;break k}while(0);Va()}while(0);if(!a)break;g=c[t+(p+28+k)>>2]|0;do if((f|0)!=(c[11324+(g<<2)>>2]|0)){if(a>>>0<(c[2759]|0)>>>0)Va();if((c[a+16>>2]|0)==(f|0))c[a+16>>2]=F;else c[a+20>>2]=F;if(!F)break j}else{c[11324+(g<<2)>>2]=F;if(F)break;c[2756]=c[2756]&~(1<<g);break j}while(0);f=c[2759]|0;if(F>>>0<f>>>0)Va();c[F+24>>2]=a;g=c[t+((k|16)+p)>>2]|0;do if(g)if(g>>>0<f>>>0)Va();else{c[F+16>>2]=g;c[g+24>>2]=F;break}while(0);f=c[t+(i+(k|16))>>2]|0;if(!f)break;if(f>>>0<(c[2759]|0)>>>0)Va();else{c[F+20>>2]=f;c[f+24>>2]=F;break}}else{e=c[t+((k|8)+p)>>2]|0;d=c[t+(p+12+k)>>2]|0;do if((e|0)!=(11060+(j>>>3<<1<<2)|0)){if(e>>>0>=g>>>0?(c[e+12>>2]|0)==(f|0):0)break;Va()}while(0);if((d|0)==(e|0)){c[2755]=c[2755]&~(1<<(j>>>3));break}do if((d|0)==(11060+(j>>>3<<1<<2)|0))D=d+8|0;else{if(d>>>0>=g>>>0?(c[d+8>>2]|0)==(f|0):0){D=d+8|0;break}Va()}while(0);c[e+12>>2]=d;c[D>>2]=e}while(0);f=t+((j&-8|k)+p)|0;h=(j&-8)+l|0}else h=l;f=f+4|0;c[f>>2]=c[f>>2]&-2;c[t+(m+4)>>2]=h|1;c[t+(h+m)>>2]=h;f=h>>>3;if(h>>>0<256){e=c[2755]|0;do if(!(e&1<<f)){c[2755]=e|1<<f;G=11060+((f<<1)+2<<2)|0;H=11060+(f<<1<<2)|0}else{e=c[11060+((f<<1)+2<<2)>>2]|0;if(e>>>0>=(c[2759]|0)>>>0){G=11060+((f<<1)+2<<2)|0;H=e;break}Va()}while(0);c[G>>2]=o;c[H+12>>2]=o;c[t+(m+8)>>2]=H;c[t+(m+12)>>2]=11060+(f<<1<<2);break}e=h>>>8;do if(!e)b=0;else{if(h>>>0>16777215){b=31;break}b=e<<((e+1048320|0)>>>16&8)<<(((e<<((e+1048320|0)>>>16&8))+520192|0)>>>16&4);b=14-(((e<<((e+1048320|0)>>>16&8))+520192|0)>>>16&4|(e+1048320|0)>>>16&8|(b+245760|0)>>>16&2)+(b<<((b+245760|0)>>>16&2)>>>15)|0;b=h>>>(b+7|0)&1|b<<1}while(0);f=11324+(b<<2)|0;c[t+(m+28)>>2]=b;c[t+(m+20)>>2]=0;c[t+(m+16)>>2]=0;e=c[2756]|0;d=1<<b;if(!(e&d)){c[2756]=e|d;c[f>>2]=o;c[t+(m+24)>>2]=f;c[t+(m+12)>>2]=o;c[t+(m+8)>>2]=o;break}e=c[f>>2]|0;l:do if((c[e+4>>2]&-8|0)!=(h|0)){b=h<<((b|0)==31?0:25-(b>>>1)|0);while(1){d=e+16+(b>>>31<<2)|0;f=c[d>>2]|0;if(!f)break;if((c[f+4>>2]&-8|0)==(h|0)){I=f;break l}else{b=b<<1;e=f}}if(d>>>0<(c[2759]|0)>>>0)Va();else{c[d>>2]=o;c[t+(m+24)>>2]=e;c[t+(m+12)>>2]=o;c[t+(m+8)>>2]=o;break i}}else I=e;while(0);e=I+8|0;d=c[e>>2]|0;w=c[2759]|0;if(d>>>0>=w>>>0&I>>>0>=w>>>0){c[d+12>>2]=o;c[e>>2]=o;c[t+(m+8)>>2]=d;c[t+(m+12)>>2]=I;c[t+(m+24)>>2]=0;break}else Va()}else{w=(c[2758]|0)+l|0;c[2758]=w;c[2761]=o;c[t+(m+4)>>2]=w|1}while(0);b=t+(n|8)|0;break d}else f=11468;while(1){d=c[f>>2]|0;if(d>>>0<=a>>>0?(A=c[f+4>>2]|0,(d+A|0)>>>0>a>>>0):0)break;f=c[f+8>>2]|0}h=d+(A+-47+((d+(A+-39)&7|0)==0?0:0-(d+(A+-39))&7))|0;h=h>>>0<(a+16|0)>>>0?a:h;w=t+8|0;w=(w&7|0)==0?0:0-w&7;v=p+-40-w|0;c[2761]=t+w;c[2758]=v;c[t+(w+4)>>2]=v|1;c[t+(p+-36)>>2]=40;c[2762]=c[2877];c[h+4>>2]=27;c[h+8>>2]=c[2867];c[h+8+4>>2]=c[2868];c[h+8+8>>2]=c[2869];c[h+8+12>>2]=c[2870];c[2867]=t;c[2868]=p;c[2870]=0;c[2869]=h+8;c[h+28>>2]=7;if((h+32|0)>>>0<(d+A|0)>>>0){e=h+28|0;do{w=e;e=e+4|0;c[e>>2]=7}while((w+8|0)>>>0<(d+A|0)>>>0)}if((h|0)!=(a|0)){c[h+4>>2]=c[h+4>>2]&-2;c[a+4>>2]=h-a|1;c[h>>2]=h-a;if((h-a|0)>>>0<256){e=c[2755]|0;if(e&1<<((h-a|0)>>>3)){e=c[11060+(((h-a|0)>>>3<<1)+2<<2)>>2]|0;if(e>>>0<(c[2759]|0)>>>0)Va();else{B=11060+(((h-a|0)>>>3<<1)+2<<2)|0;C=e}}else{c[2755]=e|1<<((h-a|0)>>>3);B=11060+(((h-a|0)>>>3<<1)+2<<2)|0;C=11060+((h-a|0)>>>3<<1<<2)|0}c[B>>2]=a;c[C+12>>2]=a;c[a+8>>2]=C;c[a+12>>2]=11060+((h-a|0)>>>3<<1<<2);break}if((h-a|0)>>>8)if((h-a|0)>>>0>16777215)f=31;else{f=(h-a|0)>>>8<<((((h-a|0)>>>8)+1048320|0)>>>16&8);f=14-((f+520192|0)>>>16&4|(((h-a|0)>>>8)+1048320|0)>>>16&8|((f<<((f+520192|0)>>>16&4))+245760|0)>>>16&2)+(f<<((f+520192|0)>>>16&4)<<(((f<<((f+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;f=(h-a|0)>>>(f+7|0)&1|f<<1}else f=0;e=11324+(f<<2)|0;c[a+28>>2]=f;c[a+20>>2]=0;c[a+16>>2]=0;d=c[2756]|0;b=1<<f;if(!(d&b)){c[2756]=d|b;c[e>>2]=a;c[a+24>>2]=e;c[a+12>>2]=a;c[a+8>>2]=a;break}e=c[e>>2]|0;m:do if((c[e+4>>2]&-8|0)!=(h-a|0)){f=h-a<<((f|0)==31?0:25-(f>>>1)|0);while(1){b=e+16+(f>>>31<<2)|0;d=c[b>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(h-a|0)){E=d;break m}else{f=f<<1;e=d}}if(b>>>0<(c[2759]|0)>>>0)Va();else{c[b>>2]=a;c[a+24>>2]=e;c[a+12>>2]=a;c[a+8>>2]=a;break h}}else E=e;while(0);d=E+8|0;b=c[d>>2]|0;w=c[2759]|0;if(b>>>0>=w>>>0&E>>>0>=w>>>0){c[b+12>>2]=a;c[d>>2]=a;c[a+8>>2]=b;c[a+12>>2]=E;c[a+24>>2]=0;break}else Va()}}else{w=c[2759]|0;if((w|0)==0|t>>>0<w>>>0)c[2759]=t;c[2867]=t;c[2868]=p;c[2870]=0;c[2764]=c[2873];c[2763]=-1;d=0;do{w=d<<1;c[11060+(w+3<<2)>>2]=11060+(w<<2);c[11060+(w+2<<2)>>2]=11060+(w<<2);d=d+1|0}while((d|0)!=32);w=t+8|0;w=(w&7|0)==0?0:0-w&7;v=p+-40-w|0;c[2761]=t+w;c[2758]=v;c[t+(w+4)>>2]=v|1;c[t+(p+-36)>>2]=40;c[2762]=c[2877]}while(0);b=c[2758]|0;if(b>>>0>q>>>0){w=b-q|0;c[2758]=w;b=c[2761]|0;c[2761]=b+q;c[b+(q+4)>>2]=w|1;c[b+4>>2]=q|3;b=b+8|0;break}}if(!(c[2744]|0))b=11516;else b=c[(lb()|0)+60>>2]|0;c[b>>2]=12;b=0}else b=0}while(0);return b|0}function YE(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;a:do if(a){i=c[2759]|0;b:do if((a+-8|0)>>>0>=i>>>0?(q=c[a+-4>>2]|0,(q&3|0)!=1):0){p=a+((q&-8)+-8)|0;do if(!(q&1)){k=c[a+-8>>2]|0;if(!(q&3))break a;l=a+(-8-k)|0;m=k+(q&-8)|0;if(l>>>0<i>>>0)break b;if((l|0)==(c[2760]|0)){f=c[a+((q&-8)+-4)>>2]|0;if((f&3|0)!=3){u=l;g=m;break}c[2757]=m;c[a+((q&-8)+-4)>>2]=f&-2;c[a+(-8-k+4)>>2]=m|1;c[p>>2]=m;break a}if(k>>>0<256){f=c[a+(-8-k+8)>>2]|0;e=c[a+(-8-k+12)>>2]|0;do if((f|0)!=(11060+(k>>>3<<1<<2)|0)){if(f>>>0>=i>>>0?(c[f+12>>2]|0)==(l|0):0)break;Va()}while(0);if((e|0)==(f|0)){c[2755]=c[2755]&~(1<<(k>>>3));u=l;g=m;break}do if((e|0)==(11060+(k>>>3<<1<<2)|0))d=e+8|0;else{if(e>>>0>=i>>>0?(c[e+8>>2]|0)==(l|0):0){d=e+8|0;break}Va()}while(0);c[f+12>>2]=e;c[d>>2]=f;u=l;g=m;break}b=c[a+(-8-k+24)>>2]|0;f=c[a+(-8-k+12)>>2]|0;do if((f|0)==(l|0)){f=c[a+(-8-k+20)>>2]|0;if(!f){f=c[a+(-8-k+16)>>2]|0;if(!f){j=0;break}else h=a+(-8-k+16)|0}else h=a+(-8-k+20)|0;while(1){e=f+20|0;d=c[e>>2]|0;if(d){f=d;h=e;continue}e=f+16|0;d=c[e>>2]|0;if(!d)break;else{f=d;h=e}}if(h>>>0<i>>>0)Va();else{c[h>>2]=0;j=f;break}}else{e=c[a+(-8-k+8)>>2]|0;if((e>>>0>=i>>>0?(c[e+12>>2]|0)==(l|0):0)?(c[f+8>>2]|0)==(l|0):0){c[e+12>>2]=f;c[f+8>>2]=e;j=f;break}Va()}while(0);if(b){f=c[a+(-8-k+28)>>2]|0;if((l|0)==(c[11324+(f<<2)>>2]|0)){c[11324+(f<<2)>>2]=j;if(!j){c[2756]=c[2756]&~(1<<f);u=l;g=m;break}}else{if(b>>>0<(c[2759]|0)>>>0)Va();if((c[b+16>>2]|0)==(l|0))c[b+16>>2]=j;else c[b+20>>2]=j;if(!j){u=l;g=m;break}}e=c[2759]|0;if(j>>>0<e>>>0)Va();c[j+24>>2]=b;f=c[a+(-8-k+16)>>2]|0;do if(f)if(f>>>0<e>>>0)Va();else{c[j+16>>2]=f;c[f+24>>2]=j;break}while(0);f=c[a+(-8-k+20)>>2]|0;if(f)if(f>>>0<(c[2759]|0)>>>0)Va();else{c[j+20>>2]=f;c[f+24>>2]=j;u=l;g=m;break}else{u=l;g=m}}else{u=l;g=m}}else{u=a+-8|0;g=q&-8}while(0);if(u>>>0<p>>>0?(o=c[a+((q&-8)+-4)>>2]|0,(o&1|0)!=0):0){if(!(o&2)){if((p|0)==(c[2761]|0)){l=(c[2758]|0)+g|0;c[2758]=l;c[2761]=u;c[u+4>>2]=l|1;if((u|0)!=(c[2760]|0))break a;c[2760]=0;c[2757]=0;break a}if((p|0)==(c[2760]|0)){l=(c[2757]|0)+g|0;c[2757]=l;c[2760]=u;c[u+4>>2]=l|1;c[u+l>>2]=l;break a}g=(o&-8)+g|0;do if(o>>>0>=256){h=c[a+((q&-8)+16)>>2]|0;f=c[a+(q&-8|4)>>2]|0;do if((f|0)==(p|0)){f=c[a+((q&-8)+12)>>2]|0;if(!f){f=c[a+((q&-8)+8)>>2]|0;if(!f){r=0;break}else b=a+((q&-8)+8)|0}else b=a+((q&-8)+12)|0;while(1){e=f+20|0;d=c[e>>2]|0;if(d){f=d;b=e;continue}e=f+16|0;d=c[e>>2]|0;if(!d)break;else{f=d;b=e}}if(b>>>0<(c[2759]|0)>>>0)Va();else{c[b>>2]=0;r=f;break}}else{e=c[a+(q&-8)>>2]|0;if((e>>>0>=(c[2759]|0)>>>0?(c[e+12>>2]|0)==(p|0):0)?(c[f+8>>2]|0)==(p|0):0){c[e+12>>2]=f;c[f+8>>2]=e;r=f;break}Va()}while(0);if(h){f=c[a+((q&-8)+20)>>2]|0;if((p|0)==(c[11324+(f<<2)>>2]|0)){c[11324+(f<<2)>>2]=r;if(!r){c[2756]=c[2756]&~(1<<f);break}}else{if(h>>>0<(c[2759]|0)>>>0)Va();if((c[h+16>>2]|0)==(p|0))c[h+16>>2]=r;else c[h+20>>2]=r;if(!r)break}e=c[2759]|0;if(r>>>0<e>>>0)Va();c[r+24>>2]=h;f=c[a+((q&-8)+8)>>2]|0;do if(f)if(f>>>0<e>>>0)Va();else{c[r+16>>2]=f;c[f+24>>2]=r;break}while(0);d=c[a+((q&-8)+12)>>2]|0;if(d)if(d>>>0<(c[2759]|0)>>>0)Va();else{c[r+20>>2]=d;c[d+24>>2]=r;break}}}else{e=c[a+(q&-8)>>2]|0;f=c[a+(q&-8|4)>>2]|0;do if((e|0)!=(11060+(o>>>3<<1<<2)|0)){if(e>>>0>=(c[2759]|0)>>>0?(c[e+12>>2]|0)==(p|0):0)break;Va()}while(0);if((f|0)==(e|0)){c[2755]=c[2755]&~(1<<(o>>>3));break}do if((f|0)==(11060+(o>>>3<<1<<2)|0))n=f+8|0;else{if(f>>>0>=(c[2759]|0)>>>0?(c[f+8>>2]|0)==(p|0):0){n=f+8|0;break}Va()}while(0);c[e+12>>2]=f;c[n>>2]=e}while(0);c[u+4>>2]=g|1;c[u+g>>2]=g;if((u|0)==(c[2760]|0)){c[2757]=g;break a}}else{c[a+((q&-8)+-4)>>2]=o&-2;c[u+4>>2]=g|1;c[u+g>>2]=g}e=g>>>3;if(g>>>0<256){d=c[2755]|0;if(d&1<<e){d=c[11060+((e<<1)+2<<2)>>2]|0;if(d>>>0<(c[2759]|0)>>>0)Va();else{s=11060+((e<<1)+2<<2)|0;t=d}}else{c[2755]=d|1<<e;s=11060+((e<<1)+2<<2)|0;t=11060+(e<<1<<2)|0}c[s>>2]=u;c[t+12>>2]=u;c[u+8>>2]=t;c[u+12>>2]=11060+(e<<1<<2);break a}b=g>>>8;if(b)if(g>>>0>16777215)f=31;else{f=b<<((b+1048320|0)>>>16&8)<<(((b<<((b+1048320|0)>>>16&8))+520192|0)>>>16&4);f=14-(((b<<((b+1048320|0)>>>16&8))+520192|0)>>>16&4|(b+1048320|0)>>>16&8|(f+245760|0)>>>16&2)+(f<<((f+245760|0)>>>16&2)>>>15)|0;f=g>>>(f+7|0)&1|f<<1}else f=0;d=11324+(f<<2)|0;c[u+28>>2]=f;c[u+20>>2]=0;c[u+16>>2]=0;b=c[2756]|0;e=1<<f;c:do if(b&e){d=c[d>>2]|0;d:do if((c[d+4>>2]&-8|0)!=(g|0)){f=g<<((f|0)==31?0:25-(f>>>1)|0);while(1){b=d+16+(f>>>31<<2)|0;e=c[b>>2]|0;if(!e)break;if((c[e+4>>2]&-8|0)==(g|0)){v=e;break d}else{f=f<<1;d=e}}if(b>>>0<(c[2759]|0)>>>0)Va();else{c[b>>2]=u;c[u+24>>2]=d;c[u+12>>2]=u;c[u+8>>2]=u;break c}}else v=d;while(0);b=v+8|0;d=c[b>>2]|0;l=c[2759]|0;if(d>>>0>=l>>>0&v>>>0>=l>>>0){c[d+12>>2]=u;c[b>>2]=u;c[u+8>>2]=d;c[u+12>>2]=v;c[u+24>>2]=0;break}else Va()}else{c[2756]=b|e;c[d>>2]=u;c[u+24>>2]=d;c[u+12>>2]=u;c[u+8>>2]=u}while(0);l=(c[2763]|0)+-1|0;c[2763]=l;if(!l)b=11476;else break a;while(1){b=c[b>>2]|0;if(!b)break;else b=b+8|0}c[2763]=-1;break a}}while(0);Va()}while(0);return}function ZE(a,b){a=+a;b=b|0;var d=0,e=0,f=0;h[k>>3]=a;d=c[k>>2]|0;e=c[k+4>>2]|0;f=tF(d|0,e|0,52)|0;switch(f&2047|0){case 0:{if(a!=0.0){a=+ZE(a*18446744073709551616.0,b);d=(c[b>>2]|0)+-64|0}else d=0;c[b>>2]=d;break}case 2047:break;default:{c[b>>2]=(f&2047)+-1022;c[k>>2]=d;c[k+4>>2]=e&-2146435073|1071644672;a=+h[k>>3]}}return +a}function _E(a,b){a=+a;b=+b;var d=0,e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0;m=(g[k>>2]=a,c[k>>2]|0);i=(g[k>>2]=b,c[k>>2]|0);a:do if((i<<1|0)!=0?!((i&2147483647)>>>0>2139095040|(m>>>23&255|0)==255):0){if(m<<1>>>0<=i<<1>>>0)return +((m<<1|0)==(i<<1|0)?a*0.0:a);if(!(m>>>23&255)){if((m<<9|0)>-1){e=0;d=m<<9;do{e=e+-1|0;d=d<<1}while((d|0)>-1)}else e=0;d=e;f=m<<1-e}else{d=m>>>23&255;f=m&8388607|8388608}if(!(i>>>23&255)){if((i<<9|0)>-1){e=0;h=i<<9;do{e=e+-1|0;h=h<<1}while((h|0)>-1)}else e=0;j=e;l=i<<1-e}else{j=i>>>23&255;l=i&8388607|8388608}h=f-l|0;b:do if((d|0)>(j|0)){i=(h|0)>-1;e=h;while(1){if(i){if((f|0)==(l|0))break}else e=f;f=e<<1;d=d+-1|0;h=f-l|0;if((d|0)>(j|0)){i=(h|0)>-1;e=h}else{e=h;h=(h|0)>-1;break b}}b=a*0.0;break a}else{e=h;h=(h|0)>-1}while(0);if(h){if((f|0)==(l|0)){b=a*0.0;break}}else e=f;if(e>>>0<8388608)do{e=e<<1;d=d+-1|0}while(e>>>0<8388608);if((d|0)>0)d=e+-8388608|d<<23;else d=e>>>(1-d|0);b=(c[k>>2]=d|m&-2147483648,+g[k>>2])}else n=3;while(0);if((n|0)==3)b=a*b/(a*b);return +b}function $E(b){b=b|0;var c=0,e=0;c=0;while(1){if((d[20593+c>>0]|0)==(b|0)){e=2;break}c=c+1|0;if((c|0)==87){c=87;b=20681;e=5;break}}if((e|0)==2)if(!c)c=20681;else{b=20681;e=5}if((e|0)==5)while(1){do{e=b;b=b+1|0}while((a[e>>0]|0)!=0);c=c+-1|0;if(!c){c=b;break}else e=5}return c|0}function aF(a){a=a|0;var b=0,d=0;d=i;i=i+16|0;c[d>>2]=c[a+60>>2];a=sb(6,d|0)|0;if(a>>>0>4294963200){if(!(c[2744]|0))b=11516;else b=c[(lb()|0)+60>>2]|0;c[b>>2]=0-a;a=-1}i=d;return a|0}function bF(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;i=i+32|0;c[f>>2]=c[a+60>>2];c[f+4>>2]=0;c[f+8>>2]=b;c[f+12>>2]=f+20;c[f+16>>2]=d;a=xb(140,f|0)|0;if(a>>>0<=4294963200)if((a|0)<0)e=7;else b=c[f+20>>2]|0;else{if(!(c[2744]|0))b=11516;else b=c[(lb()|0)+60>>2]|0;c[b>>2]=0-a;e=7}if((e|0)==7){c[f+20>>2]=-1;b=-1}i=f;return b|0}function cF(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+48|0;g=c[a+28>>2]|0;c[k+32>>2]=g;g=(c[a+20>>2]|0)-g|0;c[k+32+4>>2]=g;c[k+32+8>>2]=b;c[k+32+12>>2]=d;j=k+32|0;f=2;g=g+d|0;while(1){if(!(c[2744]|0)){c[k+16>>2]=c[a+60>>2];c[k+16+4>>2]=j;c[k+16+8>>2]=f;b=zb(146,k+16|0)|0;if(b>>>0>4294963200){if(!(c[2744]|0))e=11516;else e=c[(lb()|0)+60>>2]|0;c[e>>2]=0-b;b=-1}}else{tb(216,a|0);c[k>>2]=c[a+60>>2];c[k+4>>2]=j;c[k+8>>2]=f;b=zb(146,k|0)|0;if(b>>>0>4294963200){if(!(c[2744]|0))e=11516;else e=c[(lb()|0)+60>>2]|0;c[e>>2]=0-b;b=-1}Sa(0)}if((g|0)==(b|0)){b=13;break}if((b|0)<0){b=15;break}g=g-b|0;e=c[j+4>>2]|0;if(b>>>0<=e>>>0)if((f|0)==2){c[a+28>>2]=(c[a+28>>2]|0)+b;h=e;e=j;f=2}else{h=e;e=j}else{h=c[a+44>>2]|0;c[a+28>>2]=h;c[a+20>>2]=h;h=c[j+12>>2]|0;b=b-e|0;e=j+8|0;f=f+-1|0}c[e>>2]=(c[e>>2]|0)+b;c[e+4>>2]=h-b;j=e}if((b|0)==13){b=c[a+44>>2]|0;c[a+16>>2]=b+(c[a+48>>2]|0);c[a+28>>2]=b;c[a+20>>2]=b}else if((b|0)==15){c[a+16>>2]=0;c[a+28>>2]=0;c[a+20>>2]=0;c[a>>2]=c[a>>2]|32;if((f|0)==2)d=0;else d=d-(c[j+4>>2]|0)|0}i=k;return d|0}function dF(b,e){b=b|0;e=e|0;var f=0,g=0,h=0;h=i;i=i+16|0;a[h>>0]=e;f=c[b+16>>2]|0;if(!f)if(!(gF(b)|0)){f=c[b+16>>2]|0;g=4}else f=-1;else g=4;do if((g|0)==4){g=c[b+20>>2]|0;if(g>>>0<f>>>0?(e&255|0)!=(a[b+75>>0]|0):0){c[b+20>>2]=g+1;a[g>>0]=e;f=e&255;break}if((Qb[c[b+36>>2]&63](b,h,1)|0)==1)f=d[h>>0]|0;else f=-1}while(0);i=h;return f|0}function eF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;h=i;i=i+224|0;f=h+96|0;g=f+40|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));c[h+80>>2]=c[e>>2];if((kF(0,d,h+80|0,h,h+96|0)|0)<0)f=-1;else{g=c[b>>2]|0;if((a[b+74>>0]|0)<1)c[b>>2]=g&-33;if(!(c[b+48>>2]|0)){e=c[b+44>>2]|0;c[b+44>>2]=h+136;c[b+28>>2]=h+136;c[b+20>>2]=h+136;c[b+48>>2]=80;c[b+16>>2]=h+136+80;f=kF(b,d,h+80|0,h,h+96|0)|0;if(e){Qb[c[b+36>>2]&63](b,0,0)|0;f=(c[b+20>>2]|0)==0?-1:f;c[b+44>>2]=e;c[b+48>>2]=0;c[b+16>>2]=0;c[b+28>>2]=0;c[b+20>>2]=0}}else f=kF(b,d,h+80|0,h,h+96|0)|0;e=c[b>>2]|0;c[b>>2]=e|g&32;f=(e&32|0)==0?f:-1}i=h;return f|0}function fF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=c[e+16>>2]|0;if(!f)if(!(gF(e)|0)){f=c[e+16>>2]|0;g=4}else f=0;else g=4;a:do if((g|0)==4){h=c[e+20>>2]|0;if((f-h|0)>>>0<d>>>0){f=Qb[c[e+36>>2]&63](e,b,d)|0;break}b:do if((a[e+75>>0]|0)>-1){f=d;while(1){if(!f){g=h;f=0;break b}g=f+-1|0;if((a[b+g>>0]|0)==10)break;else f=g}if((Qb[c[e+36>>2]&63](e,b,f)|0)>>>0<f>>>0)break a;d=d-f|0;b=b+f|0;g=c[e+20>>2]|0}else{g=h;f=0}while(0);uF(g|0,b|0,d|0)|0;c[e+20>>2]=(c[e+20>>2]|0)+d;f=f+d|0}while(0);return f|0}function gF(b){b=b|0;var d=0;d=a[b+74>>0]|0;a[b+74>>0]=d+255|d;d=c[b>>2]|0;if(!(d&8)){c[b+8>>2]=0;c[b+4>>2]=0;d=c[b+44>>2]|0;c[b+28>>2]=d;c[b+20>>2]=d;c[b+16>>2]=d+(c[b+48>>2]|0);d=0}else{c[b>>2]=d|32;d=-1}return d|0}function hF(b,d){b=b|0;d=d|0;do if(!b)b=1;else{if(d>>>0<128){a[b>>0]=d;b=1;break}if(d>>>0<2048){a[b>>0]=d>>>6|192;a[b+1>>0]=d&63|128;b=2;break}if(d>>>0<55296|(d&-8192|0)==57344){a[b>>0]=d>>>12|224;a[b+1>>0]=d>>>6&63|128;a[b+2>>0]=d&63|128;b=3;break}if((d+-65536|0)>>>0<1048576){a[b>>0]=d>>>18|240;a[b+1>>0]=d>>>12&63|128;a[b+2>>0]=d>>>6&63|128;a[b+3>>0]=d&63|128;b=4;break}if(!(c[2744]|0))b=11516;else b=c[(lb()|0)+60>>2]|0;c[b>>2]=84;b=-1}while(0);return b|0}function iF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;a:do if((e|0)!=0&(b&3|0)!=0){f=e;while(1){if((a[b>>0]|0)==(d&255)<<24>>24)break a;b=b+1|0;e=f+-1|0;if((e|0)!=0&(b&3|0)!=0)f=e;else{f=e;e=(e|0)!=0;g=5;break}}}else{f=e;e=(e|0)!=0;g=5}while(0);b:do if((g|0)==5)if(e){if((a[b>>0]|0)!=(d&255)<<24>>24){e=_(d&255,16843009)|0;c:do if(f>>>0>3)while(1){h=c[b>>2]^e;if((h&-2139062144^-2139062144)&h+-16843009)break;b=b+4|0;f=f+-4|0;if(f>>>0<=3){g=11;break c}}else g=11;while(0);if((g|0)==11)if(!f){f=0;break}while(1){if((a[b>>0]|0)==(d&255)<<24>>24)break b;b=b+1|0;f=f+-1|0;if(!f){f=0;break}}}}else f=0;while(0);return ((f|0)!=0?b:0)|0}function jF(a){a=a|0;return}function kF(e,f,g,j,l){e=e|0;f=f|0;g=g|0;j=j|0;l=l|0;var m=0,n=0,o=0,p=0.0,q=0,r=0,s=0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;O=i;i=i+624|0;L=O+536+40|0;N=O+576+12|0;M=O+588+9|0;m=0;n=0;s=0;a:while(1){do if((m|0)>-1){if((n|0)<=(2147483647-m|0)){m=n+m|0;break}if(!(c[2744]|0))m=11516;else m=c[(lb()|0)+60>>2]|0;c[m>>2]=75;m=-1}while(0);n=a[f>>0]|0;if(!(n<<24>>24)){K=249;break}else o=f;b:while(1){switch(n<<24>>24){case 37:{n=o;K=11;break b}case 0:{n=o;break b}default:{}}I=o+1|0;n=a[I>>0]|0;o=I}c:do if((K|0)==11)while(1){K=0;if((a[n+1>>0]|0)!=37)break c;o=o+1|0;n=n+2|0;if((a[n>>0]|0)==37)K=11;else break}while(0);D=o-f|0;if((e|0)!=0?(c[e>>2]&32|0)==0:0)fF(f,D,e)|0;if((o|0)!=(f|0)){f=n;n=D;continue}q=n+1|0;o=a[q>>0]|0;if(((o<<24>>24)+-48|0)>>>0<10){I=(a[n+2>>0]|0)==36;q=I?n+3|0:q;n=a[q>>0]|0;B=I?(o<<24>>24)+-48|0:-1;s=I?1:s}else{n=o;B=-1}o=n<<24>>24;d:do if((o&-32|0)==32){r=0;do{if(!(1<<o+-32&75913))break d;r=1<<(n<<24>>24)+-32|r;q=q+1|0;n=a[q>>0]|0;o=n<<24>>24}while((o&-32|0)==32)}else r=0;while(0);do if(n<<24>>24==42){n=q+1|0;o=(a[n>>0]|0)+-48|0;if(o>>>0<10?(a[q+2>>0]|0)==36:0){c[l+(o<<2)>>2]=10;s=1;o=q+3|0;q=c[j+((a[n>>0]|0)+-48<<3)>>2]|0}else{if(s){m=-1;break a}if(!e){o=n;z=r;s=0;J=0;break}s=(c[g>>2]|0)+(4-1)&~(4-1);q=c[s>>2]|0;c[g>>2]=s+4;s=0;o=n}if((q|0)<0){z=r|8192;J=0-q|0}else{z=r;J=q}}else{o=(n<<24>>24)+-48|0;if(o>>>0<10){n=q;q=0;do{q=(q*10|0)+o|0;n=n+1|0;o=(a[n>>0]|0)+-48|0}while(o>>>0<10);if((q|0)<0){m=-1;break a}else{o=n;z=r;J=q}}else{o=q;z=r;J=0}}while(0);e:do if((a[o>>0]|0)==46){n=o+1|0;r=a[n>>0]|0;if(r<<24>>24!=42){if(((r<<24>>24)+-48|0)>>>0<10){o=n;q=0;r=(r<<24>>24)+-48|0}else{o=n;v=0;break}while(1){q=(q*10|0)+r|0;o=o+1|0;r=(a[o>>0]|0)+-48|0;if(r>>>0>=10){v=q;break e}}}n=o+2|0;q=(a[n>>0]|0)+-48|0;if(q>>>0<10?(a[o+3>>0]|0)==36:0){c[l+(q<<2)>>2]=10;o=o+4|0;v=c[j+((a[n>>0]|0)+-48<<3)>>2]|0;break}if(s){m=-1;break a}if(e){o=(c[g>>2]|0)+(4-1)&~(4-1);v=c[o>>2]|0;c[g>>2]=o+4;o=n}else{o=n;v=0}}else v=-1;while(0);x=0;while(1){r=(a[o>>0]|0)+-65|0;if(r>>>0>57){m=-1;break a}I=o+1|0;r=a[22493+(x*58|0)+r>>0]|0;if(((r&255)+-1|0)>>>0<8){o=I;x=r&255}else break}if(!(r<<24>>24)){m=-1;break}q=(B|0)>-1;do if(r<<24>>24==19)if(q){m=-1;break a}else K=54;else{if(q){c[l+(B<<2)>>2]=r&255;H=j+(B<<3)|0;K=c[H+4>>2]|0;c[O>>2]=c[H>>2];c[O+4>>2]=K;K=54;break}if(!e){m=0;break a}lF(O,r&255,g)}while(0);if((K|0)==54?(K=0,(e|0)==0):0){f=I;n=D;continue}w=a[o>>0]|0;w=(x|0)!=0&(w&15|0)==3?w&-33:w;y=z&-65537;H=(z&8192|0)==0?z:y;f:do switch(w|0){case 110:switch(x|0){case 0:{c[c[O>>2]>>2]=m;f=I;n=D;continue a}case 1:{c[c[O>>2]>>2]=m;f=I;n=D;continue a}case 2:{f=c[O>>2]|0;c[f>>2]=m;c[f+4>>2]=((m|0)<0)<<31>>31;f=I;n=D;continue a}case 3:{b[c[O>>2]>>1]=m;f=I;n=D;continue a}case 4:{a[c[O>>2]>>0]=m;f=I;n=D;continue a}case 6:{c[c[O>>2]>>2]=m;f=I;n=D;continue a}case 7:{f=c[O>>2]|0;c[f>>2]=m;c[f+4>>2]=((m|0)<0)<<31>>31;f=I;n=D;continue a}default:{f=I;n=D;continue a}}case 112:{u=H|8;q=v>>>0>8?v:8;x=120;K=66;break}case 88:case 120:{u=H;q=v;x=w;K=66;break}case 111:{o=c[O>>2]|0;n=c[O+4>>2]|0;if((o|0)==0&(n|0)==0)f=L;else{f=L;do{f=f+-1|0;a[f>>0]=o&7|48;o=tF(o|0,n|0,3)|0;n=C}while(!((o|0)==0&(n|0)==0))}if(!(H&8)){u=H;r=0;n=22973;K=79}else{r=L-f+1|0;u=H;v=(v|0)<(r|0)?r:v;r=0;n=22973;K=79}break}case 105:case 100:{o=c[O>>2]|0;n=c[O+4>>2]|0;if((n|0)<0){o=pF(0,0,o|0,n|0)|0;n=C;c[O>>2]=o;c[O+4>>2]=n;r=1;q=22973;K=78;break f}if(!(H&2048)){r=H&1;q=(H&1|0)==0?22973:22975;K=78}else{r=1;q=22974;K=78}break}case 117:{o=c[O>>2]|0;n=c[O+4>>2]|0;r=0;q=22973;K=78;break}case 99:{a[O+536+39>>0]=c[O>>2];f=O+536+39|0;u=1;x=0;w=22973;q=L;break}case 109:{if(!(c[2744]|0))n=11516;else n=c[(lb()|0)+60>>2]|0;r=$E(c[n>>2]|0)|0;K=86;break}case 115:{r=c[O>>2]|0;r=(r|0)!=0?r:22983;K=86;break}case 67:{c[O+8>>2]=c[O>>2];c[O+8+4>>2]=0;c[O>>2]=O+8;n=O+8|0;r=-1;K=91;break}case 83:if(!v){nF(e,32,J,0,H);o=0;K=102;break f}else{n=c[O>>2]|0;r=v;K=91;break f}case 65:case 71:case 70:case 69:case 97:case 103:case 102:case 101:{p=+h[O>>3];c[O+16>>2]=0;h[k>>3]=p;if((c[k+4>>2]|0)>=0)if(!(H&2048)){F=H&1;G=(H&1|0)==0?22991:22996}else{F=1;G=22993}else{p=-p;F=1;G=22990}h[k>>3]=p;E=c[k+4>>2]&2146435072;do if(E>>>0<2146435072|(E|0)==2146435072&0<0){p=+ZE(p,O+16|0)*2.0;if(p!=0.0)c[O+16>>2]=(c[O+16>>2]|0)+-1;if((w|32|0)==97){y=(w&32|0)==0?G:G+9|0;z=F|2;q=12-v|0;do if(!(v>>>0>11|(q|0)==0)){t=8.0;do{q=q+-1|0;t=t*16.0}while((q|0)!=0);if((a[y>>0]|0)==45){p=-(t+(-p-t));break}else{p=p+t-t;break}}while(0);q=c[O+16>>2]|0;r=(q|0)<0?0-q|0:q;r=mF(r,((r|0)<0)<<31>>31,O+576+12|0)|0;if((r|0)==(O+576+12|0)){a[O+576+11>>0]=48;r=O+576+11|0}a[r+-1>>0]=(q>>31&2)+43;x=r+-2|0;a[x>>0]=w+15;r=(v|0)<1;o=O+588|0;do{G=~~p;u=o+1|0;a[o>>0]=d[22957+G>>0]|w&32;p=(p-+(G|0))*16.0;do if((u-(O+588)|0)==1){if((H&8|0)==0&(r&p==0.0)){o=u;break}a[u>>0]=46;o=o+2|0}else o=u;while(0)}while(p!=0.0);q=((v|0)!=0?(-2-(O+588)+o|0)<(v|0):0)?N+2+v-x|0:N-(O+588)-x+o|0;nF(e,32,J,q+z|0,H);if(!(c[e>>2]&32))fF(y,z,e)|0;nF(e,48,J,q+z|0,H^65536);if(!(c[e>>2]&32))fF(O+588|0,o-(O+588)|0,e)|0;nF(e,48,q-(o-(O+588)+(N-x))|0,0,0);if(!(c[e>>2]&32))fF(x,N-x|0,e)|0;nF(e,32,J,q+z|0,H^8192);n=(q+z|0)<(J|0)?J:q+z|0;break}o=(v|0)<0?6:v;if(p!=0.0){q=(c[O+16>>2]|0)+-28|0;c[O+16>>2]=q;p=p*268435456.0}else q=c[O+16>>2]|0;E=(q|0)<0?O+24|0:O+24+288|0;u=E;do{D=~~p>>>0;c[u>>2]=D;u=u+4|0;p=(p-+(D>>>0))*1.0e9}while(p!=0.0);q=c[O+16>>2]|0;if((q|0)>0){r=E;do{x=(q|0)>29?29:q;q=u+-4|0;do if(q>>>0>=r>>>0){n=0;do{B=rF(c[q>>2]|0,0,x|0)|0;B=sF(B|0,C|0,n|0,0)|0;D=C;A=EF(B|0,D|0,1e9,0)|0;c[q>>2]=A;n=DF(B|0,D|0,1e9,0)|0;q=q+-4|0}while(q>>>0>=r>>>0);if(!n)break;r=r+-4|0;c[r>>2]=n}while(0);while(1){if(u>>>0<=r>>>0)break;q=u+-4|0;if(!(c[q>>2]|0))u=q;else break}q=(c[O+16>>2]|0)-x|0;c[O+16>>2]=q}while((q|0)>0)}else r=E;if((q|0)<0)do{x=0-q|0;x=(x|0)>9?9:x;do if(r>>>0<u>>>0){n=0;q=r;do{D=c[q>>2]|0;c[q>>2]=(D>>>x)+n;n=_(D&(1<<x)+-1,1e9>>>x)|0;q=q+4|0}while(q>>>0<u>>>0);r=(c[r>>2]|0)==0?r+4|0:r;if(!n)break;c[u>>2]=n;u=u+4|0}else r=(c[r>>2]|0)==0?r+4|0:r;while(0);q=(w|32|0)==102?E:r;u=(u-q>>2|0)>(((o+25|0)/9|0)+1|0)?q+(((o+25|0)/9|0)+1<<2)|0:u;q=(c[O+16>>2]|0)+x|0;c[O+16>>2]=q}while((q|0)<0);do if(r>>>0<u>>>0){q=(E-r>>2)*9|0;v=c[r>>2]|0;if(v>>>0<10)break;else n=10;do{n=n*10|0;q=q+1|0}while(v>>>0>=n>>>0)}else q=0;while(0);f=o-((w|32|0)!=102?q:0)+(((o|0)!=0&(w|32|0)==103)<<31>>31)|0;if((f|0)<(((u-E>>2)*9|0)+-9|0)){n=E+(((f+9216|0)/9|0)+-1023<<2)|0;if((((f+9216|0)%9|0)+1|0)<9){v=10;x=((f+9216|0)%9|0)+1|0;do{v=v*10|0;x=x+1|0}while((x|0)!=9)}else v=10;x=c[n>>2]|0;z=(x>>>0)%(v>>>0)|0;if(!((z|0)==0?(E+(((f+9216|0)/9|0)+-1022<<2)|0)==(u|0):0))K=167;do if((K|0)==167){K=0;p=(((x>>>0)/(v>>>0)|0)&1|0)==0?9007199254740992.0:9007199254740994.0;y=(v|0)/2|0;do if(z>>>0<y>>>0)t=.5;else{if((z|0)==(y|0)?(E+(((f+9216|0)/9|0)+-1022<<2)|0)==(u|0):0){t=1.0;break}t=1.5}while(0);do if(F){if((a[G>>0]|0)!=45)break;p=-p;t=-t}while(0);c[n>>2]=x-z;if(!(p+t!=p))break;D=x-z+v|0;c[n>>2]=D;if(D>>>0>999999999){q=n;while(1){n=q+-4|0;c[q>>2]=0;if(n>>>0<r>>>0){r=r+-4|0;c[r>>2]=0}D=(c[n>>2]|0)+1|0;c[n>>2]=D;if(D>>>0>999999999)q=n;else break}}q=(E-r>>2)*9|0;x=c[r>>2]|0;if(x>>>0<10)break;else v=10;do{v=v*10|0;q=q+1|0}while(x>>>0>=v>>>0)}while(0);B=n+4|0;D=r;u=u>>>0>B>>>0?B:u}else D=r;f=0-q|0;while(1){if(u>>>0<=D>>>0){A=0;break}r=u+-4|0;if(!(c[r>>2]|0))u=r;else{A=1;break}}do if((w|32|0)==103){if((((o|0)!=0^1)+o|0)>(q|0)&(q|0)>-5){w=w+-1|0;o=((o|0)!=0^1)+o+-1-q|0}else{w=w+-2|0;o=((o|0)!=0^1)+o+-1|0}if(H&8){y=H&8;break}do if(A){x=c[u+-4>>2]|0;if(!x){r=9;break}if(!((x>>>0)%10|0)){y=10;r=0}else{r=0;break}do{y=y*10|0;r=r+1|0}while(((x>>>0)%(y>>>0)|0|0)==0)}else r=9;while(0);v=((u-E>>2)*9|0)+-9|0;if((w|32|0)==102){y=v-r|0;y=(y|0)<0?0:y;o=(o|0)<(y|0)?o:y;y=0;break}else{y=v+q-r|0;y=(y|0)<0?0:y;o=(o|0)<(y|0)?o:y;y=0;break}}else y=H&8;while(0);n=o|y;z=(w|32|0)==102;if(z){v=(q|0)>0?q:0;f=0}else{x=(q|0)<0?f:q;x=mF(x,((x|0)<0)<<31>>31,O+576+12|0)|0;if((N-x|0)<2)do{x=x+-1|0;a[x>>0]=48}while((N-x|0)<2);a[x+-1>>0]=(q>>31&2)+43;f=x+-2|0;a[f>>0]=w;v=N-f|0}B=F+1+o+((n|0)!=0&1)+v|0;nF(e,32,J,B,H);if(!(c[e>>2]&32))fF(G,F,e)|0;nF(e,48,J,B,H^65536);do if(z){v=D>>>0>E>>>0?E:D;q=v;do{r=mF(c[q>>2]|0,0,M)|0;do if((q|0)==(v|0)){if((r|0)!=(M|0))break;a[O+588+8>>0]=48;r=O+588+8|0}else{if(r>>>0<=(O+588|0)>>>0)break;do{r=r+-1|0;a[r>>0]=48}while(r>>>0>(O+588|0)>>>0)}while(0);if(!(c[e>>2]&32))fF(r,M-r|0,e)|0;q=q+4|0}while(q>>>0<=E>>>0);do if(n){if(c[e>>2]&32)break;fF(23025,1,e)|0}while(0);if((o|0)>0&q>>>0<u>>>0){n=o;r=q;while(1){q=mF(c[r>>2]|0,0,M)|0;if(q>>>0>(O+588|0)>>>0)do{q=q+-1|0;a[q>>0]=48}while(q>>>0>(O+588|0)>>>0);if(!(c[e>>2]&32))fF(q,(n|0)>9?9:n,e)|0;r=r+4|0;o=n+-9|0;if(!((n|0)>9&r>>>0<u>>>0))break;else n=o}}nF(e,48,o+9|0,9,0)}else{w=A?u:D+4|0;if((o|0)>-1){x=(y|0)==0;y=D;do{r=mF(c[y>>2]|0,0,M)|0;if((r|0)==(M|0)){a[O+588+8>>0]=48;r=O+588+8|0}do if((y|0)==(D|0)){u=r+1|0;if(!(c[e>>2]&32))fF(r,1,e)|0;if(x&(o|0)<1){r=u;break}if(c[e>>2]&32){r=u;break}fF(23025,1,e)|0;r=u}else{if(r>>>0<=(O+588|0)>>>0)break;do{r=r+-1|0;a[r>>0]=48}while(r>>>0>(O+588|0)>>>0)}while(0);u=M-r|0;if(!(c[e>>2]&32))fF(r,(o|0)>(u|0)?u:o,e)|0;o=o-u|0;y=y+4|0}while(y>>>0<w>>>0&(o|0)>-1)}nF(e,48,o+18|0,18,0);if(c[e>>2]&32)break;fF(f,N-f|0,e)|0}while(0);nF(e,32,J,B,H^8192);n=(B|0)<(J|0)?J:B}else{q=p!=p|0.0!=0.0;r=q?0:F;nF(e,32,J,r+3|0,y);o=c[e>>2]|0;if(!(o&32)){fF(G,r,e)|0;o=c[e>>2]|0}if(!(o&32))fF(q?((w&32|0)!=0?23017:23021):(w&32|0)!=0?23009:23013,3,e)|0;nF(e,32,J,r+3|0,H^8192);n=(r+3|0)<(J|0)?J:r+3|0}while(0);f=I;continue a}default:{y=H;u=v;x=0;w=22973;q=L}}while(0);g:do if((K|0)==66){o=c[O>>2]|0;n=c[O+4>>2]|0;r=x&32;if(!((o|0)==0&(n|0)==0)){f=L;do{f=f+-1|0;a[f>>0]=d[22957+(o&15)>>0]|r;o=tF(o|0,n|0,4)|0;n=C}while(!((o|0)==0&(n|0)==0));if((u&8|0)==0|(c[O>>2]|0)==0&(c[O+4>>2]|0)==0){v=q;r=0;n=22973;K=79}else{v=q;r=2;n=22973+(x>>4)|0;K=79}}else{f=L;v=q;r=0;n=22973;K=79}}else if((K|0)==78){f=mF(o,n,L)|0;u=H;n=q;K=79}else if((K|0)==86){K=0;q=iF(r,0,v)|0;f=r;u=(q|0)==0?v:q-r|0;x=0;w=22973;q=(q|0)==0?r+v|0:q}else if((K|0)==91){K=0;f=0;o=0;u=n;while(1){q=c[u>>2]|0;if(!q)break;o=hF(O+528|0,q)|0;if((o|0)<0|o>>>0>(r-f|0)>>>0)break;f=o+f|0;if(r>>>0>f>>>0)u=u+4|0;else break}if((o|0)<0){m=-1;break a}nF(e,32,J,f,H);if(!f){o=0;K=102}else{q=0;while(1){o=c[n>>2]|0;if(!o){o=f;K=102;break g}o=hF(O+528|0,o)|0;q=o+q|0;if((q|0)>(f|0)){o=f;K=102;break g}if(!(c[e>>2]&32))fF(O+528|0,o,e)|0;if(q>>>0>=f>>>0){o=f;K=102;break}else n=n+4|0}}}while(0);if((K|0)==102){K=0;nF(e,32,J,o,H^8192);f=I;n=(J|0)>(o|0)?J:o;continue}if((K|0)==79){K=0;q=(v|0)>-1?u&-65537:u;o=(c[O>>2]|0)!=0|(c[O+4>>2]|0)!=0;if((v|0)!=0|o){u=(o&1^1)+(L-f)|0;y=q;u=(v|0)>(u|0)?v:u;x=r;w=n;q=L}else{f=L;y=q;u=0;x=r;w=n;q=L}}o=q-f|0;q=(u|0)<(o|0)?o:u;r=x+q|0;n=(J|0)<(r|0)?r:J;nF(e,32,n,r,y);if(!(c[e>>2]&32))fF(w,x,e)|0;nF(e,48,n,r,y^65536);nF(e,48,q,o,0);if(!(c[e>>2]&32))fF(f,o,e)|0;nF(e,32,n,r,y^8192);f=I}h:do if((K|0)==249)if(!e)if(!s)m=0;else{m=1;while(1){f=c[l+(m<<2)>>2]|0;if(!f){f=0;break}lF(j+(m<<3)|0,f,g);m=m+1|0;if((m|0)>=10){m=1;break h}}while(1){m=m+1|0;if(f){m=-1;break h}if((m|0)>=10){m=1;break h}f=c[l+(m<<2)>>2]|0}}while(0);i=O;return m|0}function lF(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0.0;a:do if(b>>>0<=20)do switch(b|0){case 9:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=b;break a}case 10:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=b;c[a+4>>2]=((b|0)<0)<<31>>31;break a}case 11:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=b;c[a+4>>2]=0;break a}case 12:{f=(c[d>>2]|0)+(8-1)&~(8-1);e=c[f>>2]|0;b=c[f+4>>2]|0;c[d>>2]=f+8;c[a>>2]=e;c[a+4>>2]=b;break a}case 13:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=(b&65535)<<16>>16;c[a+4>>2]=(((b&65535)<<16>>16|0)<0)<<31>>31;break a}case 14:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=b&65535;c[a+4>>2]=0;break a}case 15:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=(b&255)<<24>>24;c[a+4>>2]=(((b&255)<<24>>24|0)<0)<<31>>31;break a}case 16:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=b&255;c[a+4>>2]=0;break a}case 17:{b=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[b>>3];c[d>>2]=b+8;h[a>>3]=g;break a}case 18:{b=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[b>>3];c[d>>2]=b+8;h[a>>3]=g;break a}default:break a}while(0);while(0);return}function mF(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if(c>>>0>0|(c|0)==0&b>>>0>4294967295)while(1){e=EF(b|0,c|0,10,0)|0;d=d+-1|0;a[d>>0]=e|48;e=b;b=DF(b|0,c|0,10,0)|0;if(!(c>>>0>9|(c|0)==9&e>>>0>4294967295))break;else c=C}if(b)while(1){d=d+-1|0;a[d>>0]=(b>>>0)%10|0|48;if(b>>>0<10)break;else b=(b>>>0)/10|0}return d|0}function nF(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;h=i;i=i+256|0;do if((d|0)>(e|0)&(f&73728|0)==0){qF(h|0,b|0,((d-e|0)>>>0>256?256:d-e|0)|0)|0;b=c[a>>2]|0;if((d-e|0)>>>0>255){g=d-e|0;f=b;b=(b&32|0)==0;do{if(b){fF(h,256,a)|0;f=c[a>>2]|0}g=g+-256|0;b=(f&32|0)==0}while(g>>>0>255);if(b)b=d-e&255;else break}else if(!(b&32))b=d-e|0;else break;fF(h,b,a)|0}while(0);i=h;return}function oF(){}function pF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;b=b-d-(c>>>0>a>>>0|0)>>>0;return (C=b,a-c>>>0|0)|0}function qF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=b+e|0;if((e|0)>=20){d=d&255;g=b&3;h=d|d<<8|d<<16|d<<24;if(g){g=b+4-g|0;while((b|0)<(g|0)){a[b>>0]=d;b=b+1|0}}while((b|0)<(f&~3|0)){c[b>>2]=h;b=b+4|0}}while((b|0)<(f|0)){a[b>>0]=d;b=b+1|0}return b-e|0}function rF(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b<<c|(a&(1<<c)-1<<32-c)>>>32-c;return a<<c}C=a<<c-32;return 0}function sF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return (C=b+d+(a+c>>>0>>>0<a>>>0|0)>>>0,a+c>>>0|0)|0}function tF(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b>>>c;return a>>>c|(b&(1<<c)-1)<<32-c}C=0;return b>>>c-32|0}function uF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;if((e|0)>=4096)return fb(b|0,d|0,e|0)|0;f=b|0;if((b&3)==(d&3)){while(b&3){if(!e)return f|0;a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}while((e|0)>=4){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0;e=e-4|0}}while((e|0)>0){a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}return f|0}function vF(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if((c|0)<(b|0)&(b|0)<(c+d|0)){e=b;c=c+d|0;b=b+d|0;while((d|0)>0){b=b-1|0;c=c-1|0;d=d-1|0;a[b>>0]=a[c>>0]|0}b=e}else uF(b,c,d)|0;return b|0}function wF(a){a=a|0;return (a&255)<<24|(a>>8&255)<<16|(a>>16&255)<<8|a>>>24|0}function xF(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b>>c;return a>>>c|(b&(1<<c)-1)<<32-c}C=(b|0)<0?-1:0;return b>>c-32|0}function yF(b){b=b|0;var c=0;c=a[m+(b&255)>>0]|0;if((c|0)<8)return c|0;c=a[m+(b>>8&255)>>0]|0;if((c|0)<8)return c+8|0;c=a[m+(b>>16&255)>>0]|0;if((c|0)<8)return c+16|0;return (a[m+(b>>>24)>>0]|0)+24|0}function zF(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=_(b&65535,a&65535)|0;e=(c>>>16)+(_(b&65535,a>>>16)|0)|0;d=_(b>>>16,a&65535)|0;return (C=(e>>>16)+(_(b>>>16,a>>>16)|0)+(((e&65535)+d|0)>>>16)|0,e+d<<16|c&65535|0)|0}function AF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;g=b>>31|((b|0)<0?-1:0)<<1;e=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;h=d>>31|((d|0)<0?-1:0)<<1;f=((d|0)<0?-1:0)>>31|((d|0)<0?-1:0)<<1;b=pF(g^a,e^b,g,e)|0;a=C;return pF((FF(b,a,pF(h^c,f^d,h,f)|0,C,0)|0)^(h^g),C^(f^e),h^g,f^e)|0}function BF(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;i=i+16|0;h=b>>31|((b|0)<0?-1:0)<<1;g=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;k=e>>31|((e|0)<0?-1:0)<<1;j=((e|0)<0?-1:0)>>31|((e|0)<0?-1:0)<<1;b=pF(h^a,g^b,h,g)|0;a=C;FF(b,a,pF(k^d,j^e,k,j)|0,C,f|0)|0;a=pF(c[f>>2]^h,c[f+4>>2]^g,h,g)|0;b=C;i=f;return (C=b,a)|0}function CF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=zF(a,c)|0;f=C;return (C=(_(b,c)|0)+(_(d,a)|0)+f|f&0,e|0|0)|0}function DF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return FF(a,b,c,d,0)|0}function EF(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;FF(a,b,d,e,f|0)|0;i=f;return (C=c[f+4>>2]|0,c[f>>2]|0)|0}function FF(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;if(!b)if(!e){if(f){c[f>>2]=(a>>>0)%(d>>>0);c[f+4>>2]=0}m=0;d=(a>>>0)/(d>>>0)>>>0;return (C=m,d)|0}else{if(!f){m=0;d=0;return (C=m,d)|0}c[f>>2]=a|0;c[f+4>>2]=b&0;m=0;d=0;return (C=m,d)|0}do if(d){if(e){h=(aa(e|0)|0)-(aa(b|0)|0)|0;if(h>>>0<=31){j=h+1|0;i=a>>>((h+1|0)>>>0)&h-31>>31|b<<31-h;m=b>>>((h+1|0)>>>0)&h-31>>31;g=0;h=a<<31-h;break}if(!f){m=0;d=0;return (C=m,d)|0}c[f>>2]=a|0;c[f+4>>2]=b|b&0;m=0;d=0;return (C=m,d)|0}if(d-1&d){h=(aa(d|0)|0)+33-(aa(b|0)|0)|0;j=h;i=32-h-1>>31&b>>>((h-32|0)>>>0)|(b<<32-h|a>>>(h>>>0))&h-32>>31;m=h-32>>31&b>>>(h>>>0);g=a<<64-h&32-h>>31;h=(b<<64-h|a>>>((h-32|0)>>>0))&32-h>>31|a<<32-h&h-33>>31;break}if(f){c[f>>2]=d-1&a;c[f+4>>2]=0}if((d|0)==1){m=b|b&0;d=a|0|0;return (C=m,d)|0}else{d=yF(d|0)|0;m=b>>>(d>>>0)|0;d=b<<32-d|a>>>(d>>>0)|0;return (C=m,d)|0}}else{if(!e){if(f){c[f>>2]=(b>>>0)%(d>>>0);c[f+4>>2]=0}m=0;d=(b>>>0)/(d>>>0)>>>0;return (C=m,d)|0}if(!a){if(f){c[f>>2]=0;c[f+4>>2]=(b>>>0)%(e>>>0)}m=0;d=(b>>>0)/(e>>>0)>>>0;return (C=m,d)|0}if(!(e-1&e)){if(f){c[f>>2]=a|0;c[f+4>>2]=e-1&b|b&0}m=0;d=b>>>((yF(e|0)|0)>>>0);return (C=m,d)|0}h=(aa(e|0)|0)-(aa(b|0)|0)|0;if(h>>>0<=30){j=h+1|0;i=b<<31-h|a>>>((h+1|0)>>>0);m=b>>>((h+1|0)>>>0);g=0;h=a<<31-h;break}if(!f){m=0;d=0;return (C=m,d)|0}c[f>>2]=a|0;c[f+4>>2]=b|b&0;m=0;d=0;return (C=m,d)|0}while(0);if(!j){j=h;b=m;h=0;a=0}else{k=sF(d|0|0,e|e&0|0,-1,-1)|0;l=C;b=m;a=0;do{p=h;h=g>>>31|h<<1;g=a|g<<1;p=i<<1|p>>>31|0;o=i>>>31|b<<1|0;pF(k,l,p,o)|0;m=C;n=m>>31|((m|0)<0?-1:0)<<1;a=n&1;i=pF(p,o,n&(d|0),(((m|0)<0?-1:0)>>31|((m|0)<0?-1:0)<<1)&(e|e&0))|0;b=C;j=j-1|0}while((j|0)!=0);j=h;h=0}if(f){c[f>>2]=i;c[f+4>>2]=b}m=(g|0)>>>31|j<<1|(0<<1|g>>>31)&0|h;d=(g<<1|0>>>31)&-2|a;return (C=m,d)|0}function GF(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;Bb[a&31](b|0,c|0,d|0,e|0,f|0)}function HF(a,b,c){a=a|0;b=b|0;c=+c;Cb[a&31](b|0,+c)}function IF(a,b){a=a|0;b=b|0;Db[a&255](b|0)}function JF(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;Eb[a&0](b|0,c|0,d|0,+e,f|0,g|0)}function KF(a,b,c){a=a|0;b=b|0;c=c|0;Fb[a&127](b|0,c|0)}function LF(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Gb[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0,k|0)|0}function MF(a,b){a=a|0;b=b|0;return Hb[a&127](b|0)|0}function NF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;Ib[a&7](b|0,c|0,+d,e|0)}function OF(a,b,c,d,e,f,g){a=a|0;b=b|0;c=+c;d=+d;e=e|0;f=f|0;g=g|0;Jb[a&0](b|0,+c,+d,e|0,f|0,g|0)}function PF(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;Kb[a&0](b|0,+c,d|0,e|0)}function QF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Lb[a&31](b|0,c|0,d|0,e|0)|0}function RF(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;Mb[a&15](b|0,+c,d|0)}function SF(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return +Nb[a&1](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0)}function TF(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;i=+i;j=j|0;k=k|0;l=+l;Ob[a&0](b|0,c|0,d|0,e|0,+f,+g,+h,+i,j|0,k|0,+l)}function UF(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return +Pb[a&15](b|0,c|0,d|0,e|0,f|0)}function VF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Qb[a&63](b|0,c|0,d|0)|0}function WF(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Rb[a&7](b|0,c|0,d|0,e|0,f|0,g|0)}function XF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return Sb[a&7](b|0,c|0,+d)|0}function YF(a,b){a=a|0;b=b|0;return +Tb[a&15](b|0)}function ZF(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return Ub[a&3](b|0,c|0,d|0,e|0,f|0,g|0)|0}function _F(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;return +Vb[a&3](b|0,c|0,d|0,+e,f|0,g|0)}function $F(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;Wb[a&0](b|0,c|0,+d,e|0,f|0)}function aG(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;Xb[a&1](b|0,c|0,d|0,e|0,f|0,g|0,h|0)}function bG(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;Yb[a&1](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0)}function cG(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;Zb[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0,k|0)}function dG(a,b,c){a=a|0;b=b|0;c=c|0;return _b[a&31](b|0,c|0)|0}function eG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return +$b[a&15](b|0,c|0,d|0)}function fG(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return +ac[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0,k|0)}function gG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;bc[a&1](b|0,c|0,d|0,e|0,+f)}function hG(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return +cc[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0)}function iG(a,b,c){a=a|0;b=b|0;c=+c;return +dc[a&1](b|0,+c)}function jG(a,b,c,d,e,f,g,h,i,j,k,l,m){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;i=+i;j=+j;k=k|0;l=+l;m=m|0;ec[a&0](b|0,c|0,d|0,e|0,+f,+g,+h,+i,+j,k|0,+l,m|0)}function kG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;return +fc[a&3](b|0,c|0,+d,e|0,f|0)}function lG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return +gc[a&1](b|0,c|0,d|0,e|0)}function mG(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return hc[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0)|0}function nG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;ic[a&15](b|0,c|0,d|0,+e)}function oG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;jc[a&127](b|0,c|0,d|0)}function pG(a){a=a|0;kc[a&3]()}function qG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;lc[a&7](b|0,c|0,+d)}function rG(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=+e;return mc[a&1](b|0,+c,d|0,+e)|0}function sG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;nc[a&127](b|0,c|0,d|0,e|0)}function tG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ba(0)}function uG(a,b){a=a|0;b=+b;ba(1)}function vG(a){a=a|0;ba(2)}function wG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;ba(3)}function xG(a,b){a=a|0;b=b|0;ba(4)}function yG(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;ba(5);return 0}function zG(a){a=a|0;ba(6);return 0}function AG(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;ba(7)}function BG(a,b,c,d,e,f){a=a|0;b=+b;c=+c;d=d|0;e=e|0;f=f|0;ba(8)}function CG(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;ba(9)}function DG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ba(10);return 0}function EG(a,b,c){a=a|0;b=+b;c=c|0;ba(11)}function FG(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;ba(12);return 0.0}function GG(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=+f;g=+g;h=+h;i=i|0;j=j|0;k=+k;ba(13)}function HG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ba(14);return 0.0}function IG(a,b,c){a=a|0;b=b|0;c=c|0;ba(15);return 0}function JG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;ba(16)}function KG(a,b,c){a=a|0;b=b|0;c=+c;ba(17);return 0}function LG(a){a=a|0;ba(18);return 0.0}function MG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;ba(19);return 0}function NG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;ba(20);return 0.0}function OG(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;ba(21)}function PG(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;ba(22)}function QG(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;ba(23)}function RG(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;ba(24)}function SG(a,b){a=a|0;b=b|0;ba(25);return 0}function TG(a,b,c){a=a|0;b=b|0;c=c|0;ba(26);return 0.0}function UG(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;ba(27);return 0.0}function VG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;ba(28)}function WG(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;ba(29);return 0.0}function XG(a,b){a=a|0;b=+b;ba(30);return 0.0}function YG(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=+f;g=+g;h=+h;i=+i;j=j|0;k=+k;l=l|0;ba(31)}function ZG(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;ba(32);return 0.0}function _G(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ba(33);return 0.0}function $G(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;ba(34);return 0}function aH(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;ba(35)}function bH(a,b,c){a=a|0;b=b|0;c=c|0;ba(36)}function cH(){ba(37)}function dH(){yb()}function eH(a,b,c){a=a|0;b=b|0;c=+c;ba(38)}function fH(a,b,c,d){a=a|0;b=+b;c=c|0;d=+d;ba(39);return 0}function gH(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ba(40)}
function Bq(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;C=+g[b+48>>2];k=+g[d>>2];D=+g[b+64>>2];j=+g[d+4>>2];E=+g[b+80>>2];l=+g[d+8>>2];s=+g[b+52>>2];r=+g[b+68>>2];q=+g[b+84>>2];w=+g[b+56>>2];y=+g[b+72>>2];z=+g[b+88>>2];v=+g[d+16>>2];u=+g[d+20>>2];t=+g[d+24>>2];x=+g[d+32>>2];F=+g[d+36>>2];G=+g[d+40>>2];h=+g[b+96>>2];f=+g[b+100>>2];B=+g[b+104>>2];A=+g[d+48>>2]+(k*h+j*f+l*B);i=v*h+u*f+t*B+ +g[d+52>>2];B=x*h+F*f+G*B+ +g[d+56>>2];g[b+1064>>2]=C*k+D*j+E*l;g[b+1068>>2]=k*s+j*r+l*q;g[b+1072>>2]=k*w+j*y+l*z;g[b+1076>>2]=0.0;g[b+1080>>2]=C*v+D*u+E*t;g[b+1084>>2]=s*v+r*u+q*t;g[b+1088>>2]=w*v+y*u+z*t;g[b+1092>>2]=0.0;g[b+1096>>2]=C*x+D*F+E*G;g[b+1100>>2]=s*x+r*F+q*G;g[b+1104>>2]=w*x+y*F+z*G;g[b+1108>>2]=0.0;g[b+1112>>2]=A;g[b+1116>>2]=i;g[b+1120>>2]=B;g[b+1124>>2]=0.0;B=+g[b+112>>2];i=+g[e>>2];A=+g[b+128>>2];G=+g[e+4>>2];z=+g[b+144>>2];F=+g[e+8>>2];y=+g[b+116>>2];x=+g[b+132>>2];w=+g[b+148>>2];q=+g[b+120>>2];r=+g[b+136>>2];s=+g[b+152>>2];E=+g[e+16>>2];D=+g[e+20>>2];C=+g[e+24>>2];t=+g[e+32>>2];u=+g[e+36>>2];v=+g[e+40>>2];l=+g[b+160>>2];j=+g[b+164>>2];k=+g[b+168>>2];f=+g[e+48>>2]+(i*l+G*j+F*k);h=E*l+D*j+C*k+ +g[e+52>>2];k=t*l+u*j+v*k+ +g[e+56>>2];g[b+1128>>2]=B*i+A*G+z*F;g[b+1132>>2]=i*y+G*x+F*w;g[b+1136>>2]=i*q+G*r+F*s;g[b+1140>>2]=0.0;g[b+1144>>2]=B*E+A*D+z*C;g[b+1148>>2]=y*E+x*D+w*C;g[b+1152>>2]=q*E+r*D+s*C;g[b+1156>>2]=0.0;g[b+1160>>2]=B*t+A*u+z*v;g[b+1164>>2]=y*t+x*u+w*v;g[b+1168>>2]=q*t+r*u+s*v;g[b+1172>>2]=0.0;g[b+1176>>2]=f;g[b+1180>>2]=h;g[b+1184>>2]=k;g[b+1188>>2]=0.0;f=f-+g[b+1112>>2];h=h-+g[b+1116>>2];k=k-+g[b+1120>>2];w=+g[b+1084>>2];x=+g[b+1104>>2];y=+g[b+1088>>2];z=+g[b+1100>>2];A=+g[b+1096>>2];B=+g[b+1080>>2];C=+g[b+1064>>2];D=+g[b+1068>>2];E=+g[b+1072>>2];F=1.0/((w*x-y*z)*C+D*(y*A-x*B)+(z*B-w*A)*E);G=(z*B-w*A)*F;i=(w*x-y*z)*F*f+F*(z*E-x*D)*h+F*(y*D-w*E)*k;j=f*((y*A-x*B)*F)+h*(F*(x*C-A*E))+F*(B*E-y*C)*k;k=f*G+F*(A*D-z*C)*h+F*(w*C-B*D)*k;g[b+1256>>2]=i;g[b+1260>>2]=j;g[b+1264>>2]=k;g[b+1268>>2]=0.0;g[b+840>>2]=i;h=+g[b+680>>2];f=+g[b+696>>2];do if(!(h>f)){if(h>i){c[b+856>>2]=2;g[b+824>>2]=i-h;break}if(f<i){c[b+856>>2]=1;g[b+824>>2]=i-f;break}else{c[b+856>>2]=0;g[b+824>>2]=0.0;break}}else{c[b+856>>2]=0;g[b+824>>2]=0.0}while(0);g[b+844>>2]=j;h=+g[b+684>>2];f=+g[b+700>>2];do if(!(h>f)){if(h>j){c[b+860>>2]=2;g[b+828>>2]=j-h;break}if(f<j){c[b+860>>2]=1;g[b+828>>2]=j-f;break}else{c[b+860>>2]=0;g[b+828>>2]=0.0;break}}else{c[b+860>>2]=0;g[b+828>>2]=0.0}while(0);g[b+848>>2]=k;f=+g[b+688>>2];h=+g[b+704>>2];do if(!(f>h)){if(f>k){c[b+864>>2]=2;g[b+832>>2]=k-f;break}if(h<k){c[b+864>>2]=1;g[b+832>>2]=k-h;break}else{c[b+864>>2]=0;g[b+832>>2]=0.0;break}}else{c[b+864>>2]=0;g[b+832>>2]=0.0}while(0);k=+g[b+1128>>2];j=+g[b+1144>>2];i=+g[b+1160>>2];f=+g[b+1132>>2];l=+g[b+1148>>2];m=+g[b+1164>>2];n=(w*x-y*z)*F*f+F*(z*E-x*D)*l+F*(y*D-w*E)*m;p=(y*A-x*B)*F*f+F*(x*C-A*E)*l+F*(B*E-y*C)*m;o=k*G+F*(A*D-z*C)*j+F*(w*C-B*D)*i;h=G*+g[b+1136>>2]+F*(A*D-z*C)*+g[b+1152>>2]+F*(w*C-B*D)*(q*t+r*u+s*v);do if(o<1.0)if(o>-1.0){g[b+1192>>2]=+W(+-(G*f+F*(A*D-z*C)*l+F*(w*C-B*D)*m),+h);v=o<-1.0?-1.0:o;g[b+1196>>2]=+U(+(v>1.0?1.0:v));g[b+1200>>2]=+W(+-(k*((y*A-x*B)*F)+j*(F*(x*C-A*E))+F*(B*E-y*C)*i),+(k*((w*x-y*z)*F)+j*(F*(z*E-x*D))+F*(y*D-w*E)*i));break}else{g[b+1192>>2]=-+W(+n,+p);g[b+1196>>2]=-1.5707963705062866;g[b+1200>>2]=0.0;break}else{g[b+1192>>2]=+W(+n,+p);g[b+1196>>2]=1.5707963705062866;g[b+1200>>2]=0.0}while(0);g[b+1236>>2]=0.0;t=x*(k*x-i*E)-y*(j*E-k*y);u=E*(j*E-k*y)-x*(i*y-j*x);v=y*(i*y-j*x)-E*(k*x-i*E);g[b+1220>>2]=0.0;w=j*(j*E-k*y)-i*(k*x-i*E);z=i*(i*y-j*x)-k*(j*E-k*y);A=k*(k*x-i*E)-j*(i*y-j*x);g[b+1252>>2]=0.0;B=1.0/+O(+(t*t+u*u+v*v));g[b+1208>>2]=t*B;g[b+1212>>2]=u*B;g[b+1216>>2]=v*B;B=1.0/+O(+((i*y-j*x)*(i*y-j*x)+(k*x-i*E)*(k*x-i*E)+(j*E-k*y)*(j*E-k*y)));g[b+1224>>2]=(i*y-j*x)*B;g[b+1228>>2]=(k*x-i*E)*B;g[b+1232>>2]=(j*E-k*y)*B;B=1.0/+O(+(w*w+z*z+A*A));g[b+1240>>2]=w*B;g[b+1244>>2]=z*B;g[b+1248>>2]=A*B;if(!(a[b+1301>>0]|0))return;A=+g[(c[b+28>>2]|0)+344>>2];B=+g[(c[b+32>>2]|0)+344>>2];a[b+1280>>0]=(A<1.1920928955078125e-07|B<1.1920928955078125e-07)&1;B=A+B>0.0?B/(A+B):.5;g[b+1272>>2]=B;g[b+1276>>2]=1.0-B;return}function Cq(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=+h;j=+j;k=+k;l=+l;m=+m;var n=0,o=0.0;n=i;i=i+128|0;c[n+80>>2]=c[a+4>>2];c[n+80+4>>2]=c[a+20>>2];c[n+80+8>>2]=c[a+36>>2];g[n+80+12>>2]=0.0;c[n+80+16>>2]=c[a+8>>2];c[n+80+20>>2]=c[a+24>>2];c[n+80+24>>2]=c[a+40>>2];g[n+80+28>>2]=0.0;c[n+80+32>>2]=c[a+12>>2];c[n+80+36>>2]=c[a+28>>2];c[n+80+40>>2]=c[a+44>>2];g[n+80+44>>2]=0.0;c[n+32>>2]=c[b+4>>2];c[n+32+4>>2]=c[b+20>>2];c[n+32+8>>2]=c[b+36>>2];g[n+32+12>>2]=0.0;c[n+32+16>>2]=c[b+8>>2];c[n+32+20>>2]=c[b+24>>2];c[n+32+24>>2]=c[b+40>>2];g[n+32+28>>2]=0.0;c[n+32+32>>2]=c[b+12>>2];c[n+32+36>>2]=c[b+28>>2];c[n+32+40>>2]=c[b+44>>2];g[n+32+44>>2]=0.0;o=h-+g[a+56>>2];h=j-+g[a+60>>2];g[n+16>>2]=f-+g[a+52>>2];g[n+16+4>>2]=o;g[n+16+8>>2]=h;g[n+16+12>>2]=0.0;h=l-+g[b+56>>2];f=m-+g[b+60>>2];g[n>>2]=k-+g[b+52>>2];g[n+4>>2]=h;g[n+8>>2]=f;g[n+12>>2]=0.0;Lq(d,n+80|0,n+32|0,n+16|0,n,e,a+396|0,+g[a+344>>2],b+396|0,+g[b+344>>2]);i=n;return}function Dq(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0;k=i;i=i+16|0;if(!(a[b+1308>>0]|0)){i=k;return}g[b+928>>2]=0.0;g[b+992>>2]=0.0;g[b+1056>>2]=0.0;c[b+712>>2]=0;c[b+712+4>>2]=0;c[b+712+8>>2]=0;c[b+712+12>>2]=0;Bq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);Db[c[(c[b>>2]|0)+44>>2]&255](b);e=+g[b+1284>>2];f=+g[b+1288>>2];h=+g[b+1292>>2];if(+g[b+696>>2]>=+g[b+680>>2]){l=(a[b+1300>>0]|0)==0;d=c[(l?b+1160|0:b+1096|0)>>2]|0;j=c[(l?b+1144|0:b+1080|0)>>2]|0;c[k>>2]=c[(l?b+1128|0:b+1064|0)>>2];c[k+4>>2]=j;c[k+8>>2]=d;g[k+12>>2]=0.0;Cq(c[b+28>>2]|0,c[b+32>>2]|0,b+176|0,k,e,f,h,e,f,h)}if(+g[b+700>>2]>=+g[b+684>>2]){l=(a[b+1300>>0]|0)==0;d=c[(l?b+1164|0:b+1100|0)>>2]|0;j=c[(l?b+1148|0:b+1084|0)>>2]|0;c[k>>2]=c[(l?b+1132|0:b+1068|0)>>2];c[k+4>>2]=j;c[k+8>>2]=d;g[k+12>>2]=0.0;Cq(c[b+28>>2]|0,c[b+32>>2]|0,b+260|0,k,e,f,h,e,f,h)}if(+g[b+704>>2]>=+g[b+688>>2]){l=(a[b+1300>>0]|0)==0;d=c[(l?b+1168|0:b+1104|0)>>2]|0;j=c[(l?b+1152|0:b+1088|0)>>2]|0;c[k>>2]=c[(l?b+1136|0:b+1072|0)>>2];c[k+4>>2]=j;c[k+8>>2]=d;g[k+12>>2]=0.0;Cq(c[b+28>>2]|0,c[b+32>>2]|0,b+344|0,k,e,f,h,e,f,h)}j=0;do{h=+g[b+868+(j<<6)>>2];f=+g[b+868+(j<<6)+4>>2];e=+Mq(+g[b+1192+(j<<2)>>2],h,f);g[b+868+(j<<6)+52>>2]=e;do if(!(h>f)){if(h>e){c[b+868+(j<<6)+56>>2]=1;d=b+868+(j<<6)+48|0;g[d>>2]=e-h;if(e-h>3.1415927410125732){g[d>>2]=e-h+-6.2831854820251465;d=19;break}if(!(e-h<-3.1415927410125732)){d=19;break}g[d>>2]=e-h+6.2831854820251465;d=19;break}d=b+868+(j<<6)+56|0;if(!(f<e)){c[d>>2]=0;d=18;break}c[d>>2]=2;d=b+868+(j<<6)+48|0;g[d>>2]=e-f;if(e-f>3.1415927410125732){g[d>>2]=e-f+-6.2831854820251465;d=19;break}if(e-f<-3.1415927410125732){g[d>>2]=e-f+6.2831854820251465;d=19}else d=19}else{c[b+868+(j<<6)+56>>2]=0;d=18}while(0);if((d|0)==18?(d=0,(a[b+868+(j<<6)+44>>0]|0)!=0):0)d=19;if((d|0)==19){K=b+1208+(j<<4)|0;c[k>>2]=c[K>>2];c[k+4>>2]=c[K+4>>2];c[k+8>>2]=c[K+8>>2];c[k+12>>2]=c[K+12>>2];K=b+428+(j*84|0)|0;l=c[b+28>>2]|0;J=+g[l+4>>2];I=+g[l+20>>2];H=+g[l+36>>2];F=+g[l+8>>2];E=+g[l+24>>2];D=+g[l+40>>2];B=+g[l+12>>2];A=+g[l+28>>2];z=+g[l+44>>2];d=c[b+32>>2]|0;x=+g[d+4>>2];w=+g[d+20>>2];v=+g[d+36>>2];t=+g[d+8>>2];s=+g[d+24>>2];r=+g[d+40>>2];p=+g[d+12>>2];n=+g[d+28>>2];h=+g[d+44>>2];c[K>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;o=+g[k>>2];m=+g[k+4>>2];f=+g[k+8>>2];g[b+428+(j*84|0)+16>>2]=J*o+I*m+H*f;g[b+428+(j*84|0)+20>>2]=F*o+E*m+D*f;g[b+428+(j*84|0)+24>>2]=B*o+A*m+z*f;g[b+428+(j*84|0)+28>>2]=0.0;g[b+428+(j*84|0)+32>>2]=x*-o+w*-m+v*-f;g[b+428+(j*84|0)+36>>2]=t*-o+s*-m+r*-f;g[b+428+(j*84|0)+40>>2]=p*-o+n*-m+h*-f;g[b+428+(j*84|0)+44>>2]=0.0;G=(J*o+I*m+H*f)*+g[l+396>>2];C=(F*o+E*m+D*f)*+g[l+400>>2];y=(B*o+A*m+z*f)*+g[l+404>>2];g[b+428+(j*84|0)+48>>2]=G;g[b+428+(j*84|0)+52>>2]=C;g[b+428+(j*84|0)+56>>2]=y;g[b+428+(j*84|0)+60>>2]=0.0;u=(x*-o+w*-m+v*-f)*+g[d+396>>2];q=(t*-o+s*-m+r*-f)*+g[d+400>>2];e=(p*-o+n*-m+h*-f)*+g[d+404>>2];g[b+428+(j*84|0)+64>>2]=u;g[b+428+(j*84|0)+68>>2]=q;g[b+428+(j*84|0)+72>>2]=e;g[b+428+(j*84|0)+76>>2]=0.0;g[b+428+(j*84|0)+80>>2]=(J*o+I*m+H*f)*G+(F*o+E*m+D*f)*C+(B*o+A*m+z*f)*y+((x*-o+w*-m+v*-f)*u+(t*-o+s*-m+r*-f)*q+(p*-o+n*-m+h*-f)*e)}j=j+1|0}while((j|0)!=3);i=k;return}function Eq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0;if(a[b+1308>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}Bq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);c[d>>2]=0;c[d+4>>2]=6;if((c[b+856>>2]|0)==0?(a[b+788>>0]|0)==0:0){e=0;f=6}else{c[d>>2]=1;c[d+4>>2]=5;e=1;f=5}if(!((c[b+860>>2]|0)==0?(a[b+789>>0]|0)==0:0)){e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f}if((c[b+864>>2]|0)==0?(a[b+790>>0]|0)==0:0)l=0;else{e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f;l=0}do{i=+g[b+868+(l<<6)>>2];j=+g[b+868+(l<<6)+4>>2];k=+Mq(+g[b+1192+(l<<2)>>2],i,j);g[b+868+(l<<6)+52>>2]=k;do if(!(i>j)){if(i>k){c[b+868+(l<<6)+56>>2]=1;h=b+868+(l<<6)+48|0;g[h>>2]=k-i;if(k-i>3.1415927410125732){g[h>>2]=k-i+-6.2831854820251465;h=21;break}if(!(k-i<-3.1415927410125732)){h=21;break}g[h>>2]=k-i+6.2831854820251465;h=21;break}h=b+868+(l<<6)+56|0;if(!(j<k)){c[h>>2]=0;h=20;break}c[h>>2]=2;h=b+868+(l<<6)+48|0;g[h>>2]=k-j;if(k-j>3.1415927410125732){g[h>>2]=k-j+-6.2831854820251465;h=21;break}if(k-j<-3.1415927410125732){g[h>>2]=k-j+6.2831854820251465;h=21}else h=21}else{c[b+868+(l<<6)+56>>2]=0;h=20}while(0);if((h|0)==20){h=0;if(a[b+868+(l<<6)+44>>0]|0)h=21}if((h|0)==21){e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f}l=l+1|0}while((l|0)!=3);return}function Fq(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;l=i;i=i+16|0;j=c[b+28>>2]|0;k=c[b+32>>2]|0;if(!(a[b+1301>>0]|0)){h=0;e=Gq(b,d,0,j+4|0,k+4|0,j+312|0,k+312|0,j+328|0,k+328|0)|0;do{f=b+868+(h<<6)|0;if(!((c[b+868+(h<<6)+56>>2]|0)==0?(a[b+868+(h<<6)+44>>0]|0)==0:0)){g=b+1208+(h<<4)|0;c[l>>2]=c[g>>2];c[l+4>>2]=c[g+4>>2];c[l+8>>2]=c[g+8>>2];c[l+12>>2]=c[g+12>>2];g=c[b+1304>>2]>>(h*3|0)+9;if(!(g&1))c[b+868+(h<<6)+28>>2]=c[c[d+32>>2]>>2];if(!(g&2))c[b+868+(h<<6)+36>>2]=c[c[d+32>>2]>>2];if(!(g&4))c[b+868+(h<<6)+32>>2]=c[d+4>>2];e=(Hq(b,f,j+4|0,k+4|0,j+312|0,k+312|0,j+328|0,k+328|0,d,e,l,1,0)|0)+e|0}h=h+1|0}while((h|0)!=3);i=l;return}else{h=0;e=0;do{f=b+868+(h<<6)|0;if(!((c[b+868+(h<<6)+56>>2]|0)==0?(a[b+868+(h<<6)+44>>0]|0)==0:0)){g=b+1208+(h<<4)|0;c[l>>2]=c[g>>2];c[l+4>>2]=c[g+4>>2];c[l+8>>2]=c[g+8>>2];c[l+12>>2]=c[g+12>>2];g=c[b+1304>>2]>>(h*3|0)+9;if(!(g&1))c[b+868+(h<<6)+28>>2]=c[c[d+32>>2]>>2];if(!(g&2))c[b+868+(h<<6)+36>>2]=c[c[d+32>>2]>>2];if(!(g&4))c[b+868+(h<<6)+32>>2]=c[d+4>>2];e=(Hq(b,f,j+4|0,k+4|0,j+312|0,k+312|0,j+328|0,k+328|0,d,e,l,1,0)|0)+e|0}h=h+1|0}while((h|0)!=3);Gq(b,d,e,j+4|0,k+4|0,j+312|0,k+312|0,j+328|0,k+328|0)|0;i=l;return}}function Gq(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0;q=i;i=i+80|0;g[q+16+60>>2]=0.0;g[q+16+8>>2]=0.0;g[q+16+12>>2]=.10000000149011612;g[q+16+16>>2]=300.0;g[q+16>>2]=1.0;g[q+16+4>>2]=-1.0;g[q+16+28>>2]=0.0;g[q+16+32>>2]=.20000000298023224;g[q+16+36>>2]=0.0;g[q+16+40>>2]=0.0;g[q+16+20>>2]=1.0;g[q+16+24>>2]=.5;c[q+16+56>>2]=0;g[q+16+48>>2]=0.0;a[q+16+44>>0]=0;p=0;do{n=c[b+856+(p<<2)>>2]|0;o=a[b+788+p>>0]|0;do if(!((n|0)==0&o<<24>>24==0)){g[q+16+40>>2]=0.0;c[q+16+56>>2]=n;c[q+16+52>>2]=c[b+840+(p<<2)>>2];c[q+16+48>>2]=c[b+824+(p<<2)>>2];c[q+16+20>>2]=c[b+732>>2];a[q+16+44>>0]=o;c[q+16+4>>2]=c[b+696+(p<<2)>>2];c[q+16+24>>2]=c[b+728>>2];c[q+16>>2]=c[b+680+(p<<2)>>2];g[q+16+16>>2]=0.0;c[q+16+12>>2]=c[b+808+(p<<2)>>2];c[q+16+8>>2]=c[b+792+(p<<2)>>2];c[q>>2]=c[b+1064+(p<<2)>>2];c[q+4>>2]=c[b+1080+(p<<2)>>2];c[q+8>>2]=c[b+1096+(p<<2)>>2];g[q+12>>2]=0.0;n=c[b+1304>>2]>>p*3;if(!(n&1))o=c[d+32>>2]|0;else o=b+740+(p<<2)|0;c[q+16+28>>2]=c[o>>2];if(!(n&2))o=c[d+32>>2]|0;else o=b+772+(p<<2)|0;c[q+16+36>>2]=c[o>>2];c[q+16+32>>2]=c[((n&4|0)==0?d+4|0:b+756+(p<<2)|0)>>2];if(!(a[b+1301>>0]|0)){e=(Hq(b,q+16|0,f,h,j,k,l,m,d,e,q,0,0)|0)+e|0;break}o=p+1|0;if(!(c[b+868+(((o|0)==3?0:o)<<6)+56>>2]|0))n=1;else n=(c[b+868+(((p+2|0)%3|0)<<6)+56>>2]|0)==0&1;e=(Hq(b,q+16|0,f,h,j,k,l,m,d,e,q,0,n)|0)+e|0}while(0);p=p+1|0}while((p|0)!=3);i=q;return e|0}function Hq(b,d,e,f,h,i,j,k,l,m,n,o,p){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;A=_(c[l+24>>2]|0,m)|0;m=a[d+44>>0]|0;z=c[d+56>>2]|0;if(!(m<<24>>24!=0|(z|0)!=0)){n=0;return n|0}C=c[((o|0)!=0?l+12|0:l+8|0)>>2]|0;B=c[((o|0)!=0?l+20|0:l+16|0)>>2]|0;c[C+(A<<2)>>2]=c[n>>2];c[C+(A+1<<2)>>2]=c[n+4>>2];c[C+(A+2<<2)>>2]=c[n+8>>2];g[B+(A<<2)>>2]=-+g[n>>2];g[B+(A+1<<2)>>2]=-+g[n+4>>2];g[B+(A+2<<2)>>2]=-+g[n+8>>2];do if(!o){v=+g[b+1176>>2];if(!(a[b+1301>>0]|0)){t=v-+g[e+48>>2];x=+g[b+1180>>2]-+g[e+52>>2];q=+g[b+1184>>2]-+g[e+56>>2];r=+g[n+8>>2];u=+g[n+4>>2];s=+g[n>>2];p=c[l+12>>2]|0;g[p+(A<<2)>>2]=x*r-q*u;g[p+(A+1<<2)>>2]=q*s-t*r;g[p+(A+2<<2)>>2]=t*u-x*s;s=+g[b+1176>>2]-+g[f+48>>2];x=+g[b+1180>>2]-+g[f+52>>2];u=+g[b+1184>>2]-+g[f+56>>2];t=+g[n+8>>2];r=+g[n+4>>2];q=+g[n>>2];p=c[l+20>>2]|0;g[p+(A<<2)>>2]=-(x*t-u*r);g[p+(A+1<<2)>>2]=-(u*q-s*t);g[p+(A+2<<2)>>2]=-(s*r-x*q);break}I=v-+g[f+48>>2];G=+g[b+1180>>2]-+g[f+52>>2];E=+g[b+1184>>2]-+g[f+56>>2];H=+g[n>>2];F=+g[n+4>>2];D=+g[n+8>>2];K=+g[b+1112>>2]-+g[e+48>>2];r=+g[b+1116>>2]-+g[e+52>>2];v=+g[b+1120>>2]-+g[e+56>>2];q=+g[d+52>>2]-+g[d+48>>2];J=H*(H*K+F*r+D*v)+H*q-H*(I*H+G*F+E*D);s=F*(H*K+F*r+D*v)+F*q-F*(I*H+G*F+E*D);q=D*(H*K+F*r+D*v)+D*q-D*(I*H+G*F+E*D);x=+g[b+1272>>2];w=+g[b+1276>>2];t=D*(r-F*(H*K+F*r+D*v)+x*s)-F*(v-D*(H*K+F*r+D*v)+x*q);u=H*(v-D*(H*K+F*r+D*v)+x*q)-D*(K-H*(H*K+F*r+D*v)+x*J);v=F*(K-H*(H*K+F*r+D*v)+x*J)-H*(r-F*(H*K+F*r+D*v)+x*s);r=D*(G-F*(I*H+G*F+E*D)-w*s)-F*(E-D*(I*H+G*F+E*D)-w*q);q=H*(E-D*(I*H+G*F+E*D)-w*q)-D*(I-H*(I*H+G*F+E*D)-w*J);s=F*(I-H*(I*H+G*F+E*D)-w*J)-H*(G-F*(I*H+G*F+E*D)-w*s);if(!((p|0)!=0|(a[b+1280>>0]|0)==0)){r=w*r;q=w*q;s=w*s;t=x*t;u=x*u;v=x*v}p=c[l+12>>2]|0;g[p+(A<<2)>>2]=t;g[p+(A+1<<2)>>2]=u;g[p+(A+2<<2)>>2]=v;p=c[l+20>>2]|0;g[p+(A<<2)>>2]=-r;g[p+(A+1<<2)>>2]=-q;g[p+(A+2<<2)>>2]=-s}while(0);if((z|0)!=0?+g[d>>2]==+g[d+4>>2]:0){m=c[l+28>>2]|0;g[m+(A<<2)>>2]=0.0;v=0.0;e=l+28|0}else y=11;do if((y|0)==11){f=c[l+28>>2]|0;g[f+(A<<2)>>2]=0.0;if(!(m<<24>>24)){if(z){m=f;v=0.0;e=l+28|0;break}else m=1;return m|0}c[(c[l+32>>2]|0)+(A<<2)>>2]=c[d+28>>2];if(z){m=f;v=+g[f+(A<<2)>>2];e=l+28|0;break}v=+g[d+8>>2];t=(o|0)!=0?v:-v;q=+g[d+52>>2];r=+g[d>>2];s=+g[d+4>>2];u=+g[l>>2]*+g[d+32>>2];do if(!(r>s))if(!(r==s)){if(t/u<0.0)if(q>=r?r-t/u>q:0){q=(r-q)/(t/u);break}else{q=q<r?0.0:1.0;break}if(t/u>0.0)if(q<=s?s-t/u<q:0){q=(s-q)/(t/u);break}else{q=q>s?0.0:1.0;break}else q=0.0}else q=0.0;else q=1.0;while(0);g[f+(A<<2)>>2]=q*v+ +g[f+(A<<2)>>2];g[(c[l+36>>2]|0)+(A<<2)>>2]=-+g[d+12>>2];c[(c[l+40>>2]|0)+(A<<2)>>2]=c[d+12>>2];n=1;return n|0}while(0);w=+g[l>>2]*+g[d+32>>2]*+g[d+48>>2];g[m+(A<<2)>>2]=v+((o|0)!=0?-w:w);c[(c[l+32>>2]|0)+(A<<2)>>2]=c[d+36>>2];if(+g[d>>2]==+g[d+4>>2]){g[(c[l+36>>2]|0)+(A<<2)>>2]=-3402823466385288598117041.0e14;g[(c[l+40>>2]|0)+(A<<2)>>2]=3402823466385288598117041.0e14;n=1;return n|0}y=c[l+40>>2]|0;g[(c[l+36>>2]|0)+(A<<2)>>2]=(z|0)==1?0.0:-3402823466385288598117041.0e14;g[y+(A<<2)>>2]=(z|0)==1?3402823466385288598117041.0e14:0.0;u=+g[d+40>>2];if(!(u>0.0)){n=1;return n|0}if(o){J=+g[n>>2];w=+g[n+4>>2];q=+g[n+8>>2];q=+g[j>>2]*J+ +g[j+4>>2]*w+ +g[j+8>>2]*q-(J*+g[k>>2]+w*+g[k+4>>2]+q*+g[k+8>>2])}else{J=+g[n>>2];w=+g[n+4>>2];q=+g[n+8>>2];q=+g[h>>2]*J+ +g[h+4>>2]*w+ +g[h+8>>2]*q-(J*+g[i>>2]+w*+g[i+4>>2]+q*+g[i+8>>2])}if((z|0)==1){if(!(q<0.0)){n=1;return n|0}q=-(q*u);m=(c[e>>2]|0)+(A<<2)|0;if(!(+g[m>>2]<q)){n=1;return n|0}g[m>>2]=q;n=1;return n|0}else{if(!(q>0.0)){n=1;return n|0}q=-(q*u);m=(c[e>>2]|0)+(A<<2)|0;if(!(+g[m>>2]>q)){n=1;return n|0}g[m>>2]=q;n=1;return n|0}return 0}function Iq(a){a=a|0;var b=0.0,d=0.0,e=0.0;d=+g[(c[a+28>>2]|0)+344>>2];e=+g[(c[a+32>>2]|0)+344>>2];e=e==0.0?1.0:d/(d+e);d=e*+g[a+1116>>2]+(1.0-e)*+g[a+1180>>2];b=e*+g[a+1120>>2]+(1.0-e)*+g[a+1184>>2];g[a+1284>>2]=+g[a+1112>>2]*e+(1.0-e)*+g[a+1176>>2];g[a+1288>>2]=d;g[a+1292>>2]=b;g[a+1296>>2]=0.0;return}function Jq(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;if(e>>>0<3)switch(b|0){case 2:{g[a+756+(e<<2)>>2]=d;c[a+1304>>2]=c[a+1304>>2]|4<<e*3;return}case 4:{g[a+772+(e<<2)>>2]=d;c[a+1304>>2]=c[a+1304>>2]|2<<e*3;return}case 3:{g[a+740+(e<<2)>>2]=d;c[a+1304>>2]=c[a+1304>>2]|1<<e*3;return}default:return}if((e+-3|0)>>>0>=3)return;switch(b|0){case 2:{g[a+868+(e+-3<<6)+32>>2]=d;c[a+1304>>2]=c[a+1304>>2]|4<<e*3;return}case 4:{g[a+868+(e+-3<<6)+36>>2]=d;c[a+1304>>2]=c[a+1304>>2]|2<<e*3;return}case 3:{g[a+868+(e+-3<<6)+28>>2]=d;c[a+1304>>2]=c[a+1304>>2]|1<<e*3;return}default:return}}function Kq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;a:do if(c>>>0>=3)if((c+-3|0)>>>0<3)switch(b|0){case 2:{d=+g[a+868+(c+-3<<6)+32>>2];break a}case 4:{d=+g[a+868+(c+-3<<6)+36>>2];break a}case 3:{d=+g[a+868+(c+-3<<6)+28>>2];break a}default:{d=0.0;break a}}else d=0.0;else switch(b|0){case 2:{d=+g[a+756+(c<<2)>>2];break a}case 4:{d=+g[a+772+(c<<2)>>2];break a}case 3:{d=+g[a+740+(c<<2)>>2];break a}default:{d=0.0;break a}}while(0);return +d}function Lq(a,b,d,e,f,h,i,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=+j;k=k|0;l=+l;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;c[a>>2]=c[h>>2];c[a+4>>2]=c[h+4>>2];c[a+8>>2]=c[h+8>>2];c[a+12>>2]=c[h+12>>2];s=+g[e+4>>2];v=+g[a+8>>2];w=+g[e+8>>2];p=+g[a+4>>2];m=+g[a>>2];r=+g[e>>2];u=(s*v-w*p)*+g[b>>2]+ +g[b+4>>2]*(w*m-v*r)+(p*r-s*m)*+g[b+8>>2];t=(s*v-w*p)*+g[b+16>>2]+(w*m-v*r)*+g[b+20>>2]+(p*r-s*m)*+g[b+24>>2];s=(s*v-w*p)*+g[b+32>>2]+(w*m-v*r)*+g[b+36>>2]+(p*r-s*m)*+g[b+40>>2];g[a+16>>2]=u;g[a+20>>2]=t;g[a+24>>2]=s;g[a+28>>2]=0.0;r=+g[f+4>>2];w=+g[f+8>>2];n=+g[f>>2];q=+g[d>>2]*(r*-v-w*-p)+ +g[d+4>>2]*(w*-m-n*-v)+(n*-p-r*-m)*+g[d+8>>2];o=(r*-v-w*-p)*+g[d+16>>2]+(w*-m-n*-v)*+g[d+20>>2]+(n*-p-r*-m)*+g[d+24>>2];m=(r*-v-w*-p)*+g[d+32>>2]+(w*-m-n*-v)*+g[d+36>>2]+(n*-p-r*-m)*+g[d+40>>2];g[a+32>>2]=q;g[a+36>>2]=o;g[a+40>>2]=m;g[a+44>>2]=0.0;u=+g[i>>2]*u;t=+g[i+4>>2]*t;s=+g[i+8>>2]*s;g[a+48>>2]=u;g[a+52>>2]=t;g[a+56>>2]=s;g[a+60>>2]=0.0;r=+g[k>>2]*q;p=+g[k+4>>2]*o;n=+g[k+8>>2]*m;g[a+64>>2]=r;g[a+68>>2]=p;g[a+72>>2]=n;g[a+76>>2]=0.0;g[a+80>>2]=u*+g[a+16>>2]+t*+g[a+20>>2]+s*+g[a+24>>2]+j+l+(r*q+p*o+n*m);return}function Mq(a,b,c){a=+a;b=+b;c=+c;var d=0.0,e=0.0,f=0;if(b>=c){d=a;return +d}if(a<b){d=+_E(b-a,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;e=+N(+d);d=+_E(c-a,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;f=e<+N(+d);d=f?a:a+6.2831854820251465;return +d}if(!(a>c)){d=a;return +d}d=+_E(a-c,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;e=+N(+d);d=+_E(a-b,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;f=+N(+d)<e;d=f?a+-6.2831854820251465:a;return +d}function Nq(a){a=a|0;return}function Oq(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return}function Pq(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return}function Qq(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function Rq(a){a=a|0;return 252}function Sq(a,b,e){a=a|0;b=b|0;e=e|0;fr(a,b,e)|0;c[b+52>>2]=c[a+48>>2];c[b+56>>2]=c[a+52>>2];c[b+60>>2]=c[a+56>>2];c[b+64>>2]=c[a+60>>2];c[b+68>>2]=c[a+64>>2];c[b+72>>2]=c[a+68>>2];c[b+76>>2]=c[a+72>>2];c[b+80>>2]=c[a+76>>2];c[b+84>>2]=c[a+80>>2];c[b+88>>2]=c[a+84>>2];c[b+92>>2]=c[a+88>>2];c[b+96>>2]=c[a+92>>2];c[b+100>>2]=c[a+96>>2];c[b+104>>2]=c[a+100>>2];c[b+108>>2]=c[a+104>>2];c[b+112>>2]=c[a+108>>2];c[b+116>>2]=c[a+112>>2];c[b+120>>2]=c[a+116>>2];c[b+124>>2]=c[a+120>>2];c[b+128>>2]=c[a+124>>2];c[b+132>>2]=c[a+128>>2];c[b+136>>2]=c[a+132>>2];c[b+140>>2]=c[a+136>>2];c[b+144>>2]=c[a+140>>2];c[b+148>>2]=c[a+144>>2];c[b+152>>2]=c[a+148>>2];c[b+156>>2]=c[a+152>>2];c[b+160>>2]=c[a+156>>2];c[b+164>>2]=c[a+160>>2];c[b+168>>2]=c[a+164>>2];c[b+172>>2]=c[a+168>>2];c[b+176>>2]=c[a+172>>2];c[b+228>>2]=c[a+868>>2];c[b+212>>2]=c[a+872>>2];c[b+196>>2]=c[a+680>>2];c[b+180>>2]=c[a+696>>2];c[b+232>>2]=c[a+932>>2];c[b+216>>2]=c[a+936>>2];c[b+200>>2]=c[a+684>>2];c[b+184>>2]=c[a+700>>2];c[b+236>>2]=c[a+996>>2];c[b+220>>2]=c[a+1e3>>2];c[b+204>>2]=c[a+688>>2];c[b+188>>2]=c[a+704>>2];c[b+244>>2]=d[a+1300>>0];c[b+248>>2]=d[a+1301>>0];return 12930}function Tq(b,d){b=b|0;d=d|0;var e=0.0,f=0.0;if(a[b+1309>>0]|0){e=(+g[b+1256>>2]-+g[b+1316>>2])*+g[b+1340>>2];g[b+792>>2]=e*(+g[d>>2]*+g[b+1364>>2]/+(c[d+48>>2]|0));e=+N(+e);g[b+808>>2]=e/+g[d>>2]}if(a[b+1310>>0]|0){e=(+g[b+1260>>2]-+g[b+1320>>2])*+g[b+1344>>2];g[b+796>>2]=e*(+g[d>>2]*+g[b+1368>>2]/+(c[d+48>>2]|0));e=+N(+e);g[b+812>>2]=e/+g[d>>2]}if(a[b+1311>>0]|0){e=(+g[b+1264>>2]-+g[b+1324>>2])*+g[b+1348>>2];g[b+800>>2]=e*(+g[d>>2]*+g[b+1372>>2]/+(c[d+48>>2]|0));e=+N(+e);g[b+816>>2]=e/+g[d>>2]}if(a[b+1312>>0]|0){f=-((+g[b+1192>>2]-+g[b+1328>>2])*+g[b+1352>>2]);e=+g[d>>2];g[b+876>>2]=e*+g[b+1376>>2]/+(c[d+48>>2]|0)*f;g[b+880>>2]=+N(+f)/e}if(a[b+1313>>0]|0){f=-((+g[b+1196>>2]-+g[b+1332>>2])*+g[b+1356>>2]);e=+g[d>>2];g[b+940>>2]=e*+g[b+1380>>2]/+(c[d+48>>2]|0)*f;g[b+944>>2]=+N(+f)/e}if(!(a[b+1314>>0]|0)){Fq(b,d);return}f=-((+g[b+1200>>2]-+g[b+1336>>2])*+g[b+1360>>2]);e=+g[d>>2];g[b+1004>>2]=e*+g[b+1384>>2]/+(c[d+48>>2]|0)*f;g[b+1008>>2]=+N(+f)/e;Fq(b,d);return}function Uq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;u=+g[b>>2];t=+g[b+4>>2];s=+g[b+8>>2];r=1.0/+O(+(u*u+t*t+s*s));y=+g[d>>2];x=+g[d+4>>2];w=+g[d+8>>2];v=1.0/+O(+(y*y+x*x+w*w));B=s*r*(x*v)-t*r*(w*v);A=u*r*(w*v)-s*r*(y*v);z=t*r*(y*v)-u*r*(x*v);b=c[a+28>>2]|0;e=+g[b+4>>2];h=+g[b+20>>2];j=+g[b+36>>2];f=+g[b+8>>2];i=+g[b+24>>2];k=+g[b+40>>2];l=+g[b+12>>2];n=+g[b+28>>2];p=+g[b+44>>2];m=-+g[b+52>>2];o=-+g[b+56>>2];q=-+g[b+60>>2];g[a+48>>2]=e*B+A*h+z*j;g[a+52>>2]=y*v*e+x*v*h+w*v*j;g[a+56>>2]=u*r*e+t*r*h+s*r*j;g[a+60>>2]=0.0;g[a+64>>2]=B*f+A*i+z*k;g[a+68>>2]=y*v*f+x*v*i+w*v*k;g[a+72>>2]=u*r*f+t*r*i+s*r*k;g[a+76>>2]=0.0;g[a+80>>2]=B*l+A*n+z*p;g[a+84>>2]=y*v*l+x*v*n+w*v*p;g[a+88>>2]=u*r*l+t*r*n+s*r*p;g[a+92>>2]=0.0;g[a+96>>2]=e*0.0+h*0.0+j*0.0+(e*m+h*o+j*q);g[a+100>>2]=f*0.0+i*0.0+k*0.0+(f*m+i*o+k*q);g[a+104>>2]=l*0.0+n*0.0+p*0.0+(l*m+n*o+p*q);g[a+108>>2]=0.0;b=c[a+32>>2]|0;q=+g[b+4>>2];p=+g[b+20>>2];o=+g[b+36>>2];n=+g[b+8>>2];m=+g[b+24>>2];l=+g[b+40>>2];k=+g[b+12>>2];i=+g[b+28>>2];f=+g[b+44>>2];j=-+g[b+52>>2];h=-+g[b+56>>2];e=-+g[b+60>>2];g[a+112>>2]=B*q+A*p+z*o;g[a+116>>2]=y*v*q+x*v*p+w*v*o;g[a+120>>2]=u*r*q+t*r*p+s*r*o;g[a+124>>2]=0.0;g[a+128>>2]=B*n+A*m+z*l;g[a+132>>2]=y*v*n+x*v*m+w*v*l;g[a+136>>2]=u*r*n+t*r*m+s*r*l;g[a+140>>2]=0.0;g[a+144>>2]=B*k+A*i+z*f;g[a+148>>2]=y*v*k+x*v*i+w*v*f;g[a+152>>2]=u*r*k+t*r*i+s*r*f;g[a+156>>2]=0.0;g[a+160>>2]=q*0.0+p*0.0+o*0.0+(q*j+p*h+o*e);g[a+164>>2]=n*0.0+m*0.0+l*0.0+(n*j+m*h+l*e);g[a+168>>2]=k*0.0+i*0.0+f*0.0+(k*j+i*h+f*e);g[a+172>>2]=0.0;Bq(a,(c[a+28>>2]|0)+4|0,(c[a+32>>2]|0)+4|0);return}function Vq(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function Wq(a){a=a|0;return 348}function Xq(a,b,e){a=a|0;b=b|0;e=e|0;Sq(a,b,e)|0;c[b+276>>2]=c[a+1316>>2];c[b+324>>2]=c[a+1364>>2];c[b+252>>2]=d[a+1309>>0];c[b+300>>2]=c[a+1340>>2];c[b+280>>2]=c[a+1320>>2];c[b+328>>2]=c[a+1368>>2];c[b+256>>2]=d[a+1310>>0];c[b+304>>2]=c[a+1344>>2];c[b+284>>2]=c[a+1324>>2];c[b+332>>2]=c[a+1372>>2];c[b+260>>2]=d[a+1311>>0];c[b+308>>2]=c[a+1348>>2];c[b+288>>2]=c[a+1328>>2];c[b+336>>2]=c[a+1376>>2];c[b+264>>2]=d[a+1312>>0];c[b+312>>2]=c[a+1352>>2];c[b+292>>2]=c[a+1332>>2];c[b+340>>2]=c[a+1380>>2];c[b+268>>2]=d[a+1313>>0];c[b+316>>2]=c[a+1356>>2];c[b+296>>2]=c[a+1336>>2];c[b+344>>2]=c[a+1384>>2];c[b+272>>2]=d[a+1314>>0];c[b+320>>2]=c[a+1360>>2];return 12990}function Yq(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;d=i;i=i+144|0;g[a+36>>2]=0.0;c[d+128>>2]=0;c[d+128+4>>2]=0;c[d+128+8>>2]=0;c[d+128+12>>2]=0;b=0;do{e=d+128+(b<<2)|0;g[e>>2]=1.0;A=c[a+28>>2]|0;I=c[A+4>>2]|0;c[d+80>>2]=I;F=c[A+20>>2]|0;c[d+80+4>>2]=F;C=c[A+36>>2]|0;c[d+80+8>>2]=C;g[d+80+12>>2]=0.0;H=c[A+8>>2]|0;c[d+80+16>>2]=H;E=c[A+24>>2]|0;c[d+80+20>>2]=E;B=c[A+40>>2]|0;c[d+80+24>>2]=B;g[d+80+28>>2]=0.0;G=c[A+12>>2]|0;c[d+80+32>>2]=G;D=c[A+28>>2]|0;c[d+80+36>>2]=D;z=c[A+44>>2]|0;c[d+80+40>>2]=z;g[d+80+44>>2]=0.0;f=c[a+32>>2]|0;y=c[f+4>>2]|0;c[d+32>>2]=y;v=c[f+20>>2]|0;c[d+32+4>>2]=v;s=c[f+36>>2]|0;c[d+32+8>>2]=s;g[d+32+12>>2]=0.0;x=c[f+8>>2]|0;c[d+32+16>>2]=x;u=c[f+24>>2]|0;c[d+32+20>>2]=u;r=c[f+40>>2]|0;c[d+32+24>>2]=r;g[d+32+28>>2]=0.0;w=c[f+12>>2]|0;c[d+32+32>>2]=w;t=c[f+28>>2]|0;c[d+32+36>>2]=t;h=c[f+44>>2]|0;c[d+32+40>>2]=h;g[d+32+44>>2]=0.0;p=+g[a+300>>2];m=p*(c[k>>2]=I,+g[k>>2]);j=+g[a+304>>2];m=m+j*(c[k>>2]=H,+g[k>>2]);l=+g[a+308>>2];m=m+l*(c[k>>2]=G,+g[k>>2]);q=p*(c[k>>2]=F,+g[k>>2]);q=q+j*(c[k>>2]=E,+g[k>>2]);q=q+l*(c[k>>2]=D,+g[k>>2]);p=p*(c[k>>2]=C,+g[k>>2]);j=p+j*(c[k>>2]=B,+g[k>>2]);p=+g[A+52>>2];o=+g[A+56>>2];n=+g[A+60>>2];n=j+l*(c[k>>2]=z,+g[k>>2])+n-n;g[d+16>>2]=m+p-p;g[d+16+4>>2]=q+o-o;g[d+16+8>>2]=n;g[d+16+12>>2]=0.0;n=+g[a+316>>2];o=n*(c[k>>2]=y,+g[k>>2]);q=+g[a+320>>2];o=o+q*(c[k>>2]=x,+g[k>>2]);p=+g[a+324>>2];o=o+p*(c[k>>2]=w,+g[k>>2]);m=n*(c[k>>2]=v,+g[k>>2]);m=m+q*(c[k>>2]=u,+g[k>>2]);m=m+p*(c[k>>2]=t,+g[k>>2]);n=n*(c[k>>2]=s,+g[k>>2]);q=n+q*(c[k>>2]=r,+g[k>>2]);n=+g[f+52>>2];l=+g[f+56>>2];j=+g[f+60>>2];j=q+p*(c[k>>2]=h,+g[k>>2])+j-j;g[d>>2]=o+n-n;g[d+4>>2]=m+l-l;g[d+8>>2]=j;g[d+12>>2]=0.0;h=c[a+28>>2]|0;f=c[a+32>>2]|0;Lq(a+48+(b*84|0)|0,d+80|0,d+32|0,d+16|0,d,d+128|0,h+396|0,+g[h+344>>2],f+396|0,+g[f+344>>2]);g[e>>2]=0.0;b=b+1|0}while((b|0)!=3);i=d;return}function Zq(b,d){b=b|0;d=d|0;b=(a[b+344>>0]|0)==0?3:0;c[d>>2]=b;c[d+4>>2]=b;return}function _q(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0.0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;j=c[a+28>>2]|0;k=c[a+32>>2]|0;e=c[b+8>>2]|0;g[e>>2]=1.0;h=c[b+24>>2]|0;g[e+(h+1<<2)>>2]=1.0;g[e+((h<<1)+2<<2)>>2]=1.0;l=+g[a+300>>2];q=+g[a+304>>2];d=+g[a+308>>2];o=+g[j+4>>2]*l+ +g[j+8>>2]*q+ +g[j+12>>2]*d;m=l*+g[j+20>>2]+q*+g[j+24>>2]+d*+g[j+28>>2];d=l*+g[j+36>>2]+q*+g[j+40>>2]+d*+g[j+44>>2];e=c[b+12>>2]|0;c[e>>2]=0;g[e+4>>2]=d;g[e+8>>2]=-m;g[e+12>>2]=0.0;g[e+(h<<2)>>2]=-d;c[e+(h+1<<2)>>2]=0;g[e+(h+2<<2)>>2]=o;g[e+(h+3<<2)>>2]=0.0;g[e+(h<<1<<2)>>2]=m;g[e+((h<<1|1)<<2)>>2]=-o;c[e+((h<<1)+2<<2)>>2]=0;g[e+((h<<1)+3<<2)>>2]=0.0;e=c[b+16>>2]|0;g[e>>2]=-1.0;g[e+(h+1<<2)>>2]=-1.0;g[e+((h<<1)+2<<2)>>2]=-1.0;q=+g[a+316>>2];l=+g[a+320>>2];f=+g[a+324>>2];p=+g[k+4>>2]*q+ +g[k+8>>2]*l+ +g[k+12>>2]*f;n=q*+g[k+20>>2]+l*+g[k+24>>2]+f*+g[k+28>>2];f=q*+g[k+36>>2]+l*+g[k+40>>2]+f*+g[k+44>>2];h=c[b+20>>2]|0;e=c[b+24>>2]|0;c[h>>2]=0;g[h+4>>2]=-f;g[h+8>>2]=n;g[h+12>>2]=0.0;g[h+(e<<2)>>2]=f;c[h+(e+1<<2)>>2]=0;g[h+(e+2<<2)>>2]=-p;g[h+(e+3<<2)>>2]=0.0;g[h+(e<<1<<2)>>2]=-n;g[h+((e<<1|1)<<2)>>2]=p;c[h+((e<<1)+2<<2)>>2]=0;g[h+((e<<1)+3<<2)>>2]=0.0;h=c[a+332>>2]|0;l=+g[((h&1|0)==0?b+4|0:a+336|0)>>2]*+g[b>>2];i=c[b+28>>2]|0;g[i>>2]=l*(p+ +g[k+52>>2]-o-+g[j+52>>2]);g[i+(e<<2)>>2]=l*(n+ +g[k+56>>2]-m-+g[j+56>>2]);g[i+(e<<1<<2)>>2]=l*(f+ +g[k+60>>2]-d-+g[j+60>>2]);if(h&2){h=c[b+32>>2]|0;c[h>>2]=c[a+340>>2];c[h+(e<<2)>>2]=c[a+340>>2];c[h+(e<<1<<2)>>2]=c[a+340>>2]}f=+g[a+356>>2];if(f>0.0){g[c[b+36>>2]>>2]=-f;g[c[b+40>>2]>>2]=f;d=+g[a+356>>2]}else d=f;if(d>0.0){g[(c[b+36>>2]|0)+(e<<2)>>2]=-f;g[(c[b+40>>2]|0)+(e<<2)>>2]=f;d=+g[a+356>>2]}if(!(d>0.0)){a=a+352|0;a=c[a>>2]|0;e=b+52|0;c[e>>2]=a;return}g[(c[b+36>>2]|0)+(e<<1<<2)>>2]=-f;g[(c[b+40>>2]|0)+(e<<1<<2)>>2]=f;a=a+352|0;a=c[a>>2]|0;e=b+52|0;c[e>>2]=a;return}function $q(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;if((e|0)!=-1)return;switch(b|0){case 2:case 1:{g[a+336>>2]=d;c[a+332>>2]=c[a+332>>2]|1;return}case 4:case 3:{g[a+340>>2]=d;c[a+332>>2]=c[a+332>>2]|2;return}default:return}}function ar(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;a:do if((c|0)==-1)switch(b|0){case 2:case 1:{d=+g[a+336>>2];break a}case 4:case 3:{d=+g[a+340>>2];break a}default:{d=3402823466385288598117041.0e14;break a}}else d=3402823466385288598117041.0e14;while(0);return +d}function br(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function cr(a){a=a|0;return 84}function dr(a,b,d){a=a|0;b=b|0;d=d|0;fr(a,b,d)|0;c[b+52>>2]=c[a+300>>2];c[b+56>>2]=c[a+304>>2];c[b+60>>2]=c[a+308>>2];c[b+64>>2]=c[a+312>>2];c[b+68>>2]=c[a+316>>2];c[b+72>>2]=c[a+320>>2];c[b+76>>2]=c[a+324>>2];c[b+80>>2]=c[a+328>>2];return 13050}function er(){var b=0,d=0.0,e=0.0;b=i;i=i+16|0;if((a[352]|0)==0?(Wa(352)|0)!=0:0){c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;tp(3468,0.0,0,0,b);_a(352)}c[918]=c[918]|1;g[953]=0.0;d=+g[963]*0.0;e=+g[964]*0.0;g[958]=+g[962]*0.0;g[959]=d;g[960]=e;g[961]=0.0;c[966]=0;c[967]=0;c[968]=0;c[969]=0;e=+g[955]*0.0;d=+g[956]*0.0;g[1007]=+g[954]*0.0;g[1008]=e;g[1009]=d;g[1010]=0.0;i=b;return}function fr(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0;c[b>>2]=_b[c[(c[e>>2]|0)+28>>2]&31](e,c[a+28>>2]|0)|0;c[b+4>>2]=_b[c[(c[e>>2]|0)+28>>2]&31](e,c[a+32>>2]|0)|0;f=_b[c[(c[e>>2]|0)+40>>2]&31](e,a)|0;g=_b[c[(c[e>>2]|0)+28>>2]&31](e,f)|0;c[b+8>>2]=g;if(g)Fb[c[(c[e>>2]|0)+48>>2]&127](e,f);c[b+12>>2]=c[a+4>>2];c[b+24>>2]=d[a+21>>0];c[b+40>>2]=c[a+24>>2];c[b+44>>2]=c[a+16>>2];c[b+48>>2]=d[a+20>>0];c[b+20>>2]=c[a+12>>2];c[b+16>>2]=c[a+8>>2];c[b+28>>2]=c[a+36>>2];c[b+32>>2]=c[a+40>>2];c[b+36>>2]=0;f=c[a+28>>2]|0;if((c[f+488>>2]|0)>0){e=0;do{if((c[(c[f+496>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;f=c[a+28>>2]|0}e=e+1|0}while((e|0)<(c[f+488>>2]|0))}f=c[a+32>>2]|0;if((c[f+488>>2]|0)>0)e=0;else return 13083;do{if((c[(c[f+496>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;f=c[a+32>>2]|0}e=e+1|0}while((e|0)<(c[f+488>>2]|0));return 13083}function gr(a){a=a|0;return 52}function hr(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function ir(a){a=a|0;return}function jr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0;if((a[b+180>>0]|0)==0?(a[b+48>>0]|0)!=0:0){w=+g[b+116>>2];f=+g[e>>2];x=+g[b+132>>2];C=+g[e+4>>2];y=+g[b+148>>2];D=+g[e+8>>2];l=+g[b+120>>2];n=+g[b+136>>2];p=+g[b+152>>2];q=+g[b+124>>2];s=+g[b+140>>2];t=+g[b+156>>2];j=+g[e+16>>2];m=+g[e+20>>2];o=+g[e+24>>2];r=+g[e+32>>2];z=+g[e+36>>2];A=+g[e+40>>2];h=+g[b+164>>2];i=+g[b+168>>2];v=+g[b+172>>2];u=+g[e+48>>2]+(f*h+C*i+D*v);B=j*h+m*i+o*v+ +g[e+52>>2];v=r*h+z*i+A*v+ +g[e+56>>2];g[b+824>>2]=w*f+x*C+y*D;g[b+828>>2]=f*l+C*n+D*p;g[b+832>>2]=f*q+C*s+D*t;g[b+836>>2]=0.0;g[b+840>>2]=w*j+x*m+y*o;g[b+844>>2]=l*j+n*m+p*o;g[b+848>>2]=q*j+s*m+t*o;g[b+852>>2]=0.0;g[b+856>>2]=w*r+x*z+y*A;g[b+860>>2]=l*r+n*z+p*A;g[b+864>>2]=q*r+s*z+t*A;g[b+868>>2]=0.0;g[b+872>>2]=u;g[b+876>>2]=B;g[b+880>>2]=v;g[b+884>>2]=0.0;v=+g[b+52>>2];B=+g[d>>2];u=+g[b+68>>2];A=+g[d+4>>2];t=+g[b+84>>2];z=+g[d+8>>2];s=+g[b+56>>2];r=+g[b+72>>2];q=+g[b+88>>2];p=+g[b+60>>2];n=+g[b+76>>2];l=+g[b+92>>2];y=+g[d+16>>2];x=+g[d+20>>2];w=+g[d+24>>2];o=+g[d+32>>2];m=+g[d+36>>2];j=+g[d+40>>2];D=+g[b+100>>2];C=+g[b+104>>2];f=+g[b+108>>2];i=+g[d+48>>2]+(B*D+A*C+z*f);h=y*D+x*C+w*f+ +g[d+52>>2];f=o*D+m*C+j*f+ +g[d+56>>2];g[b+888>>2]=v*B+u*A+t*z;g[b+892>>2]=B*s+A*r+z*q;g[b+896>>2]=B*p+A*n+z*l;g[b+900>>2]=0.0;g[b+904>>2]=v*y+u*x+t*w;g[b+908>>2]=s*y+r*x+q*w;g[b+912>>2]=p*y+n*x+l*w;g[b+916>>2]=0.0;g[b+920>>2]=v*o+u*m+t*j;g[b+924>>2]=s*o+r*m+q*j;g[b+928>>2]=p*o+n*m+l*j;g[b+932>>2]=0.0;g[b+936>>2]=i;g[b+940>>2]=h;g[b+944>>2]=f;g[b+948>>2]=0.0;e=b+856|0;d=b+840|0}else{j=+g[b+52>>2];C=+g[d>>2];l=+g[b+68>>2];q=+g[d+4>>2];m=+g[b+84>>2];D=+g[d+8>>2];y=+g[b+56>>2];w=+g[b+72>>2];u=+g[b+88>>2];t=+g[b+60>>2];r=+g[b+76>>2];f=+g[b+92>>2];z=+g[d+16>>2];x=+g[d+20>>2];v=+g[d+24>>2];s=+g[d+32>>2];n=+g[d+36>>2];o=+g[d+40>>2];B=+g[b+100>>2];A=+g[b+104>>2];i=+g[b+108>>2];h=+g[d+48>>2]+(C*B+q*A+D*i);p=z*B+x*A+v*i+ +g[d+52>>2];i=s*B+n*A+o*i+ +g[d+56>>2];g[b+824>>2]=j*C+l*q+m*D;g[b+828>>2]=C*y+q*w+D*u;g[b+832>>2]=C*t+q*r+D*f;g[b+836>>2]=0.0;g[b+840>>2]=j*z+l*x+m*v;g[b+844>>2]=y*z+w*x+u*v;g[b+848>>2]=t*z+r*x+f*v;g[b+852>>2]=0.0;g[b+856>>2]=j*s+l*n+m*o;g[b+860>>2]=y*s+w*n+u*o;g[b+864>>2]=t*s+r*n+f*o;g[b+868>>2]=0.0;g[b+872>>2]=h;g[b+876>>2]=p;g[b+880>>2]=i;g[b+884>>2]=0.0;i=+g[b+116>>2];p=+g[e>>2];h=+g[b+132>>2];o=+g[e+4>>2];f=+g[b+148>>2];n=+g[e+8>>2];r=+g[b+120>>2];s=+g[b+136>>2];t=+g[b+152>>2];u=+g[b+124>>2];w=+g[b+140>>2];y=+g[b+156>>2];m=+g[e+16>>2];l=+g[e+20>>2];j=+g[e+24>>2];v=+g[e+32>>2];x=+g[e+36>>2];z=+g[e+40>>2];D=+g[b+164>>2];q=+g[b+168>>2];C=+g[b+172>>2];A=+g[e+48>>2]+(p*D+o*q+n*C);B=m*D+l*q+j*C+ +g[e+52>>2];C=v*D+x*q+z*C+ +g[e+56>>2];g[b+888>>2]=i*p+h*o+f*n;g[b+892>>2]=p*r+o*s+n*t;g[b+896>>2]=p*u+o*w+n*y;g[b+900>>2]=0.0;g[b+904>>2]=i*m+h*l+f*j;g[b+908>>2]=r*m+s*l+t*j;g[b+912>>2]=u*m+w*l+y*j;g[b+916>>2]=0.0;g[b+920>>2]=i*v+h*x+f*z;g[b+924>>2]=r*v+s*x+t*z;g[b+928>>2]=u*v+w*x+y*z;g[b+932>>2]=0.0;g[b+936>>2]=A;g[b+940>>2]=B;g[b+944>>2]=C;g[b+948>>2]=0.0;e=b+856|0;d=b+840|0}c[b+968>>2]=c[b+872>>2];c[b+968+4>>2]=c[b+872+4>>2];c[b+968+8>>2]=c[b+872+8>>2];c[b+968+12>>2]=c[b+872+12>>2];c[b+984>>2]=c[b+936>>2];c[b+984+4>>2]=c[b+936+4>>2];c[b+984+8>>2]=c[b+936+8>>2];c[b+984+12>>2]=c[b+936+12>>2];E=c[b+824>>2]|0;d=c[d>>2]|0;e=c[e>>2]|0;c[b+952>>2]=E;c[b+956>>2]=d;c[b+960>>2]=e;g[b+964>>2]=0.0;f=(c[k>>2]=E,+g[k>>2]);h=(c[k>>2]=d,+g[k>>2]);i=(c[k>>2]=e,+g[k>>2]);if((a[b+180>>0]|0)==0?(a[b+48>>0]|0)==0:0){t=+g[b+968>>2];z=t-+g[b+984>>2];u=+g[b+972>>2];B=u-+g[b+988>>2];v=+g[b+976>>2];C=v-+g[b+992>>2];g[b+1016>>2]=z;g[b+1020>>2]=B;g[b+1024>>2]=C;g[b+1028>>2]=0.0;A=f*z;w=h*B;w=A+w;A=i*C;A=w+A;w=f*A;x=h*A;y=i*A;w=t+w;x=u+x;y=v+y;e=b+1e3|0;g[e>>2]=w;e=b+1004|0;g[e>>2]=x;e=b+1008|0;g[e>>2]=y;e=b+1012|0;g[e>>2]=0.0;e=b+1032|0;g[e>>2]=A;e=b+828|0;d=b+844|0;E=b+860|0;A=+g[e>>2];y=+g[d>>2];x=+g[E>>2];A=A*z;y=y*B;y=A+y;x=x*C;x=y+x;E=b+1036|0;g[E>>2]=x;E=b+832|0;d=b+848|0;e=b+864|0;x=+g[E>>2];y=+g[d>>2];A=+g[e>>2];z=x*z;B=y*B;B=z+B;C=A*C;C=B+C;e=b+1040|0;g[e>>2]=C;return}t=+g[b+968>>2];z=+g[b+984>>2]-t;u=+g[b+972>>2];B=+g[b+988>>2]-u;v=+g[b+976>>2];C=+g[b+992>>2]-v;g[b+1016>>2]=z;g[b+1020>>2]=B;g[b+1024>>2]=C;g[b+1028>>2]=0.0;A=f*z;w=h*B;w=A+w;A=i*C;A=w+A;w=f*A;x=h*A;y=i*A;w=t+w;x=u+x;y=v+y;e=b+1e3|0;g[e>>2]=w;e=b+1004|0;g[e>>2]=x;e=b+1008|0;g[e>>2]=y;e=b+1012|0;g[e>>2]=0.0;e=b+1032|0;g[e>>2]=A;e=b+828|0;d=b+844|0;E=b+860|0;A=+g[e>>2];y=+g[d>>2];x=+g[E>>2];A=A*z;y=y*B;y=A+y;x=x*C;x=y+x;E=b+1036|0;g[E>>2]=x;E=b+832|0;d=b+848|0;e=b+864|0;x=+g[E>>2];y=+g[d>>2];A=+g[e>>2];z=x*z;B=y*B;B=z+B;C=A*C;C=B+C;e=b+1040|0;g[e>>2]=C;return}function kr(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0,l=0.0,m=0.0;if(a[b+48>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}c[d>>2]=4;c[d+4>>2]=2;jr(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);g[b+1088>>2]=0.0;a[b+297>>0]=0;f=+g[b+192>>2];h=+g[b+196>>2];do if(f<=h){m=+g[b+892>>2];l=+g[b+908>>2];i=+g[b+924>>2];i=+Mq(+W(+(+g[b+832>>2]*m+ +g[b+848>>2]*l+ +g[b+864>>2]*i),+(+g[b+828>>2]*m+ +g[b+844>>2]*l+ +g[b+860>>2]*i)),f,h);g[b+1084>>2]=i;if(i<f){g[b+1088>>2]=i-f;a[b+297>>0]=1;j=1;break}if(i>h){g[b+1088>>2]=i-h;a[b+297>>0]=1;j=1}else j=0}else j=0;while(0);a[b+296>>0]=0;e=c[b+1032>>2]|0;c[b+1080>>2]=e;i=+g[b+184>>2];h=+g[b+188>>2];f=(c[k>>2]=e,+g[k>>2]);do if(i<=h){if(f>h){g[b+1032>>2]=f-h;a[b+296>>0]=1;e=14;break}if(f<i){g[b+1032>>2]=f-i;a[b+296>>0]=1;e=14}else e=13}else e=13;while(0);if((e|0)==13?(g[b+1032>>2]=0.0,(a[b+1096>>0]|0)!=0):0)e=14;if((e|0)==14){c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+-1}if(j<<24>>24==0?(a[b+1112>>0]|0)==0:0)return;c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+-1;return}function lr(b,d){b=b|0;d=d|0;var e=0.0,f=0,h=0.0,j=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0,G=0,H=0.0,I=0.0,J=0,K=0,L=0,M=0,P=0,Q=0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0,Y=0,Z=0,$=0.0,aa=0,ba=0,ca=0,da=0.0,ea=0.0;ca=i;i=i+16|0;aa=c[b+28>>2]|0;ba=c[b+32>>2]|0;U=+g[aa+344>>2];V=+g[ba+344>>2];Q=c[d+24>>2]|0;$=(a[b+180>>0]|0)!=0?1.0:-1.0;R=+g[b+936>>2]-+g[b+872>>2];T=+g[b+940>>2]-+g[b+876>>2];S=+g[b+944>>2]-+g[b+880>>2];W=U+V>0.0?V/(U+V):.5;L=c[b+824>>2]|0;K=c[b+840>>2]|0;J=c[b+856>>2]|0;G=c[b+888>>2]|0;F=c[b+904>>2]|0;y=c[b+920>>2]|0;M=(a[b+49>>0]|0)==0;if(M){x=c[b+828>>2]|0;z=c[b+844>>2]|0;A=c[b+860>>2]|0;c[ca+8>>2]=z;c[ca+4>>2]=A;w=c[b+832>>2]|0;B=c[b+848>>2]|0;X=c[b+864>>2]|0;c[ca>>2]=w;m=(c[k>>2]=w,+g[k>>2]);v=(c[k>>2]=B,+g[k>>2]);C=X;H=(c[k>>2]=X,+g[k>>2]);X=L;Y=K;Z=J}else{s=W*(c[k>>2]=L,+g[k>>2]);l=W*(c[k>>2]=K,+g[k>>2]);v=W*(c[k>>2]=J,+g[k>>2]);e=(1.0-W)*(c[k>>2]=G,+g[k>>2]);h=(1.0-W)*(c[k>>2]=F,+g[k>>2]);v=v+(1.0-W)*(c[k>>2]=y,+g[k>>2]);t=1.0/+O(+((s+e)*(s+e)+(l+h)*(l+h)+v*v));u=(g[k>>2]=(s+e)*t,c[k>>2]|0);j=(g[k>>2]=(l+h)*t,c[k>>2]|0);f=(g[k>>2]=v*t,c[k>>2]|0);if(+N(+(v*t))>.7071067690849304){H=1.0/+O(+(v*t*(v*t)+(l+h)*t*((l+h)*t)));g[ca+8>>2]=-(v*t*H);g[ca+4>>2]=(l+h)*t*H;n=(s+e)*t*-(v*t*H);m=(v*t*(v*t)+(l+h)*t*((l+h)*t))*H;v=-((s+e)*t*((l+h)*t*H));x=0}else{n=(s+e)*t*((s+e)*t)+(l+h)*t*((l+h)*t);H=1.0/+O(+n);x=(g[k>>2]=-((l+h)*t*H),c[k>>2]|0);g[ca+8>>2]=(s+e)*t*H;c[ca+4>>2]=0;n=n*H;m=-(v*t*((s+e)*t*H));v=v*t*-((l+h)*t*H)}w=(g[k>>2]=m,c[k>>2]|0);g[ca>>2]=m;B=(g[k>>2]=v,c[k>>2]|0);z=c[ca+8>>2]|0;A=c[ca+4>>2]|0;C=(g[k>>2]=n,c[k>>2]|0);H=n;X=u;Y=j;Z=f}f=c[d+12>>2]|0;c[f>>2]=x;c[f+4>>2]=z;c[f+8>>2]=A;c[f+(Q<<2)>>2]=w;c[f+(Q+1<<2)>>2]=B;c[f+(Q+2<<2)>>2]=C;o=(c[k>>2]=x,+g[k>>2]);u=c[d+20>>2]|0;g[u>>2]=-o;p=+g[ca+8>>2];g[u+4>>2]=-p;q=+g[ca+4>>2];g[u+8>>2]=-q;g[u+(Q<<2)>>2]=-m;g[u+(Q+1<<2)>>2]=-v;g[u+(Q+2<<2)>>2]=-H;w=c[b+300>>2]|0;t=+g[b+280>>2];if(!(w&128))t=t*+g[d+4>>2];I=t*+g[d>>2];t=(c[k>>2]=K,+g[k>>2]);s=(c[k>>2]=y,+g[k>>2]);h=(c[k>>2]=J,+g[k>>2]);E=(c[k>>2]=F,+g[k>>2]);D=(c[k>>2]=G,+g[k>>2]);e=(c[k>>2]=L,+g[k>>2]);P=c[d+28>>2]|0;g[P>>2]=I*((t*s-h*E)*o+(h*D-e*s)*p+(e*E-t*D)*q);g[P+(Q<<2)>>2]=I*((t*s-h*E)*m+(h*D-e*s)*v+(e*E-t*D)*H);if(w&64){P=c[d+32>>2]|0;c[P>>2]=c[b+292>>2];c[P+(Q<<2)>>2]=c[b+292>>2]}l=+g[aa+52>>2];n=+g[aa+56>>2];h=+g[aa+60>>2];e=+g[ba+52>>2];s=+g[ba+56>>2];t=+g[ba+60>>2];if(M){j=(g[k>>2]=s-n,c[k>>2]|0);g[f+(Q<<1<<2)>>2]=W*((s-n)*q-(t-h)*p);g[f+((Q<<1|1)<<2)>>2]=W*((t-h)*o-(e-l)*q);g[f+((Q<<1)+2<<2)>>2]=W*((e-l)*p-(s-n)*o);P=(g[k>>2]=e-l,c[k>>2]|0);y=(g[k>>2]=t-h,c[k>>2]|0);g[u+(Q<<1<<2)>>2]=(1.0-W)*((s-n)*q-(t-h)*p);g[u+((Q<<1|1)<<2)>>2]=(1.0-W)*((t-h)*o-(e-l)*q);g[u+((Q<<1)+2<<2)>>2]=(1.0-W)*((e-l)*p-(s-n)*o);D=(s-n)*H-(t-h)*v;t=(t-h)*m-(e-l)*H;h=(e-l)*v-(s-n)*m;g[f+(Q*3<<2)>>2]=W*D;g[f+((Q*3|0)+1<<2)>>2]=W*t;g[f+((Q*3|0)+2<<2)>>2]=W*h;g[u+(Q*3<<2)>>2]=(1.0-W)*D;g[u+((Q*3|0)+1<<2)>>2]=(1.0-W)*t;g[u+((Q*3|0)+2<<2)>>2]=(1.0-W)*h;F=c[d+8>>2]|0;c[F+(Q<<1<<2)>>2]=x;c[F+((Q<<1|1)<<2)>>2]=z;c[F+((Q<<1)+2<<2)>>2]=A;K=c[ca>>2]|0;c[F+(Q*3<<2)>>2]=K;c[F+((Q*3|0)+1<<2)>>2]=B;c[F+((Q*3|0)+2<<2)>>2]=C;L=c[d+16>>2]|0;g[L+(Q<<1<<2)>>2]=-o;h=(c[k>>2]=z,+g[k>>2]);g[L+((Q<<1|1)<<2)>>2]=-h;l=(c[k>>2]=A,+g[k>>2]);g[L+((Q<<1)+2<<2)>>2]=-l;s=(c[k>>2]=K,+g[k>>2]);g[L+(Q*3<<2)>>2]=-s;e=(c[k>>2]=B,+g[k>>2]);g[L+((Q*3|0)+1<<2)>>2]=-e;t=(c[k>>2]=C,+g[k>>2]);g[L+((Q*3|0)+2<<2)>>2]=-t;K=0;J=0;G=0;C=0;B=0;u=0;f=P}else{ea=+g[b+936>>2]-e;da=+g[b+940>>2]-s;I=+g[b+944>>2]-t;o=(c[k>>2]=X,+g[k>>2]);p=(c[k>>2]=Y,+g[k>>2]);m=(c[k>>2]=Z,+g[k>>2]);s=+g[b+872>>2]-l;H=+g[b+876>>2]-n;v=+g[b+880>>2]-h;h=+g[b+1080>>2]-+g[b+1032>>2];n=o*(o*s+p*H+m*v)+o*h-o*(o*ea+p*da+m*I);q=p*(o*s+p*H+m*v)+p*h-p*(o*ea+p*da+m*I);h=m*(o*s+p*H+m*v)+m*h-m*(o*ea+p*da+m*I);D=s-o*(o*s+p*H+m*v)+W*n;r=H-p*(o*s+p*H+m*v)+W*q;E=v-m*(o*s+p*H+m*v)+W*h;G=(g[k>>2]=D,c[k>>2]|0);K=(g[k>>2]=r,c[k>>2]|0);J=(g[k>>2]=E,c[k>>2]|0);n=ea-o*(o*ea+p*da+m*I)-(1.0-W)*n;q=da-p*(o*ea+p*da+m*I)-(1.0-W)*q;h=I-m*(o*ea+p*da+m*I)-(1.0-W)*h;u=(g[k>>2]=n,c[k>>2]|0);C=(g[k>>2]=q,c[k>>2]|0);B=(g[k>>2]=h,c[k>>2]|0);e=W*(ea-o*(o*ea+p*da+m*I))+(1.0-W)*(s-o*(o*s+p*H+m*v));t=W*(da-p*(o*ea+p*da+m*I))+(1.0-W)*(H-p*(o*s+p*H+m*v));v=W*(I-m*(o*ea+p*da+m*I))+(1.0-W)*(v-m*(o*s+p*H+m*v));g[ca+8>>2]=t;g[ca+4>>2]=v;if(e*e+t*t+v*v>1.1920928955078125e-07){H=1.0/+O(+(e*e+t*t+v*v));A=(g[k>>2]=e*H,c[k>>2]|0);g[ca+8>>2]=H*t;g[ca+4>>2]=H*v;s=H*v;t=H*t;v=e*H}else{A=c[b+828>>2]|0;P=c[b+844>>2]|0;M=c[b+860>>2]|0;c[ca+8>>2]=P;c[ca+4>>2]=M;s=(c[k>>2]=M,+g[k>>2]);t=(c[k>>2]=P,+g[k>>2]);v=(c[k>>2]=A,+g[k>>2])}H=p*s-m*t;I=m*v-o*s;m=o*t-p*v;g[ca>>2]=H;g[f+(Q<<1<<2)>>2]=r*s-E*t;g[f+((Q<<1|1)<<2)>>2]=E*v-D*s;g[f+((Q<<1)+2<<2)>>2]=D*t-r*v;P=c[d+20>>2]|0;g[P+(Q<<1<<2)>>2]=-(q*s-h*t);g[P+((Q<<1|1)<<2)>>2]=-(h*v-n*s);g[P+((Q<<1)+2<<2)>>2]=-(n*t-q*v);if(U<1.1920928955078125e-07|V<1.1920928955078125e-07?(a[b+297>>0]|0)!=0:0){l=(1.0-W)*(q*m-h*I);h=(1.0-W)*(h*H-n*m);e=(1.0-W)*(n*I-q*H);s=W*(r*m-E*I);t=W*(D*I-r*H);v=W*(E*H-D*m)}else{l=q*m-h*I;h=h*H-n*m;e=n*I-q*H;s=r*m-E*I;t=D*I-r*H;v=E*H-D*m}F=c[d+12>>2]|0;g[F+(Q*3<<2)>>2]=s;g[F+((Q*3|0)+1<<2)>>2]=v;g[F+((Q*3|0)+2<<2)>>2]=t;F=c[d+20>>2]|0;g[F+(Q*3<<2)>>2]=-l;g[F+((Q*3|0)+1<<2)>>2]=-h;g[F+((Q*3|0)+2<<2)>>2]=-e;F=c[d+8>>2]|0;c[F+(Q<<1<<2)>>2]=A;c[F+((Q<<1|1)<<2)>>2]=c[ca+8>>2];c[F+((Q<<1)+2<<2)>>2]=c[ca+4>>2];g[F+(Q*3<<2)>>2]=H;g[F+((Q*3|0)+1<<2)>>2]=I;g[F+((Q*3|0)+2<<2)>>2]=m;L=c[d+16>>2]|0;o=(c[k>>2]=A,+g[k>>2]);g[L+(Q<<1<<2)>>2]=-o;h=+g[ca+8>>2];g[L+((Q<<1|1)<<2)>>2]=-h;l=+g[ca+4>>2];g[L+((Q<<1)+2<<2)>>2]=-l;g[L+(Q*3<<2)>>2]=-H;g[L+((Q*3|0)+1<<2)>>2]=-I;g[L+((Q*3|0)+2<<2)>>2]=-m;s=H;e=I;t=m;j=0;f=0;y=0}M=c[b+300>>2]|0;v=+g[b+264>>2];if(!(M&32))v=v*+g[d+4>>2];H=v*+g[d>>2];P=c[d+28>>2]|0;g[P+(Q<<1<<2)>>2]=H*(R*o+T*h+S*l);g[P+(Q*3<<2)>>2]=H*(R*s+T*e+S*t);if(M&16){w=c[d+32>>2]|0;c[w+(Q<<1<<2)>>2]=c[b+276>>2];c[w+(Q*3<<2)>>2]=c[b+276>>2]}if(!(a[b+296>>0]|0)){z=0;p=0.0}else{p=$*+g[b+1032>>2];z=p>0.0?2:1}x=a[b+1096>>0]|0;w=(z|0)!=0;if(x&255|z){A=c[d+24>>2]<<2;c[F+(A<<2)>>2]=X;c[F+((A|1)<<2)>>2]=Y;c[F+((A|2)<<2)>>2]=Z;m=(c[k>>2]=X,+g[k>>2]);g[L+(A<<2)>>2]=-m;n=(c[k>>2]=Y,+g[k>>2]);g[L+((A|1)<<2)>>2]=-n;o=(c[k>>2]=Z,+g[k>>2]);g[L+((A|2)<<2)>>2]=-o;if(a[b+49>>0]|0){if(!(U<1.1920928955078125e-07|V<1.1920928955078125e-07)){H=(c[k>>2]=K,+g[k>>2]);U=(c[k>>2]=J,+g[k>>2]);D=(c[k>>2]=G,+g[k>>2]);W=(c[k>>2]=C,+g[k>>2]);T=(c[k>>2]=B,+g[k>>2]);V=(c[k>>2]=u,+g[k>>2]);Q=c[d+12>>2]|0;g[Q+(A<<2)>>2]=o*H-n*U;g[Q+((A|1)<<2)>>2]=m*U-o*D;g[Q+((A|2)<<2)>>2]=n*D-m*H;Q=c[d+20>>2]|0;g[Q+(A<<2)>>2]=-(o*W-n*T);g[Q+((A|1)<<2)>>2]=-(m*T-o*V);g[Q+((A|2)<<2)>>2]=-(n*V-m*W)}}else{V=(c[k>>2]=j,+g[k>>2]);H=(c[k>>2]=y,+g[k>>2]);T=(c[k>>2]=f,+g[k>>2]);Q=c[d+12>>2]|0;g[Q+(A<<2)>>2]=W*(o*V-n*H);g[Q+((A|1)<<2)>>2]=W*(m*H-o*T);g[Q+((A|2)<<2)>>2]=W*(n*T-m*V);Q=c[d+20>>2]|0;g[Q+(A<<2)>>2]=(1.0-W)*(o*V-n*H);g[Q+((A|1)<<2)>>2]=(1.0-W)*(m*H-o*T);g[Q+((A|2)<<2)>>2]=(1.0-W)*(n*T-m*V)}f=+g[b+184>>2]==+g[b+188>>2];g[P+(A<<2)>>2]=0.0;u=(c[d+36>>2]|0)+(A<<2)|0;g[u>>2]=0.0;j=(c[d+40>>2]|0)+(A<<2)|0;g[j>>2]=0.0;l=+g[((M&512|0)==0?d+4|0:b+232|0)>>2];if(!(x<<24>>24==0|w&f)){if(M&1)c[(c[d+32>>2]|0)+(A<<2)>>2]=c[b+212>>2];h=+g[b+1100>>2];t=+g[b+1080>>2];e=+g[b+184>>2];s=+g[b+188>>2];v=l*+g[d>>2];do if(!(e>s))if(!(e==s)){if(h/v<0.0)if(t>=e?e-h/v>t:0){q=(e-t)/(h/v);break}else{q=t<e?0.0:1.0;break}if(h/v>0.0)if(t<=s?s-h/v<t:0){q=(s-t)/(h/v);break}else{q=t>s?0.0:1.0;break}else q=0.0}else q=0.0;else q=1.0;while(0);g[P+(A<<2)>>2]=+g[P+(A<<2)>>2]-$*q*h;g[u>>2]=+g[u>>2]-+g[b+1104>>2]*+g[d>>2];g[j>>2]=+g[b+1104>>2]*+g[d>>2]+ +g[j>>2]}if(w){g[P+(A<<2)>>2]=+g[P+(A<<2)>>2]+p*(l*+g[d>>2]);if(M&256)c[(c[d+32>>2]|0)+(A<<2)>>2]=c[b+244>>2];do if(!f)if((z|0)==1){g[u>>2]=-3402823466385288598117041.0e14;g[j>>2]=0.0;break}else{g[u>>2]=0.0;g[j>>2]=3402823466385288598117041.0e14;break}else{g[u>>2]=-3402823466385288598117041.0e14;g[j>>2]=3402823466385288598117041.0e14}while(0);W=1.0-+g[b+240>>2];e=+N(+W);do if(!(W!=W|0.0!=0.0|W==0.0)){h=$*(m*+g[aa+312>>2]+n*+g[aa+316>>2]+o*+g[aa+320>>2]-(m*+g[ba+312>>2]+n*+g[ba+316>>2]+o*+g[ba+320>>2]));if((z|0)==1){if(!(h<0.0))break;if(!(+g[P+(A<<2)>>2]<-(e*h)))break;g[P+(A<<2)>>2]=-(e*h);break}else{if(!(h>0.0))break;if(!(+g[P+(A<<2)>>2]>-(e*h)))break;g[P+(A<<2)>>2]=-(e*h);break}}while(0);g[P+(A<<2)>>2]=+g[b+232>>2]*+g[P+(A<<2)>>2];j=5}else j=5}else j=4;if(!(a[b+297>>0]|0)){x=0;t=0.0}else{t=+g[b+1088>>2];x=t>0.0?1:2}f=a[b+1112>>0]|0;u=(x|0)!=0;if(!(f&255|x)){i=ca;return}w=_(c[d+24>>2]|0,j)|0;Q=c[d+12>>2]|0;c[Q+(w<<2)>>2]=X;c[Q+(w+1<<2)>>2]=Y;c[Q+(w+2<<2)>>2]=Z;v=(c[k>>2]=X,+g[k>>2]);Q=c[d+20>>2]|0;g[Q+(w<<2)>>2]=-v;s=(c[k>>2]=Y,+g[k>>2]);g[Q+(w+1<<2)>>2]=-s;r=(c[k>>2]=Z,+g[k>>2]);g[Q+(w+2<<2)>>2]=-r;o=+g[b+192>>2];p=+g[b+196>>2];q=+g[((M&2048|0)==0?d+4|0:b+248|0)>>2];if(!(f<<24>>24==0|u&o==p)){if(!(M&4)){e=p;l=o}else{c[(c[d+32>>2]|0)+(w<<2)>>2]=c[b+228>>2];e=+g[b+196>>2];l=+g[b+192>>2]}h=+g[b+1084>>2];n=+g[b+1116>>2];m=q*+g[d>>2];do if(!(l>e))if(!(l==e)){if(n/m<0.0)if(h>=l?l-n/m>h:0){h=(l-h)/(n/m);break}else{h=h<l?0.0:1.0;break}if(n/m>0.0)if(h<=e?e-n/m<h:0){h=(e-h)/(n/m);break}else{h=h>e?0.0:1.0;break}else h=0.0}else h=0.0;else h=1.0;while(0);g[P+(w<<2)>>2]=h*n;g[(c[d+36>>2]|0)+(w<<2)>>2]=-(+g[b+1120>>2]*+g[d>>2]);g[(c[d+40>>2]|0)+(w<<2)>>2]=+g[b+1120>>2]*+g[d>>2]}if(!u){i=ca;return}g[P+(w<<2)>>2]=+g[P+(w<<2)>>2]+t*(q*+g[d>>2]);if(M&1024)c[(c[d+32>>2]|0)+(w<<2)>>2]=c[b+260>>2];do if(!(o==p)){j=(c[d+36>>2]|0)+(w<<2)|0;f=c[d+40>>2]|0;if((x|0)==1){g[j>>2]=0.0;g[f+(w<<2)>>2]=3402823466385288598117041.0e14;break}else{g[j>>2]=-3402823466385288598117041.0e14;g[f+(w<<2)>>2]=0.0;break}}else{g[(c[d+36>>2]|0)+(w<<2)>>2]=-3402823466385288598117041.0e14;g[(c[d+40>>2]|0)+(w<<2)>>2]=3402823466385288598117041.0e14}while(0);W=1.0-+g[b+256>>2];h=+N(+W);do if(!(W!=W|0.0!=0.0|W==0.0)){M=c[b+28>>2]|0;Q=c[b+32>>2]|0;e=v*+g[M+328>>2]+s*+g[M+332>>2]+r*+g[M+336>>2]-(v*+g[Q+328>>2]+s*+g[Q+332>>2]+r*+g[Q+336>>2]);if((x|0)==1){if(!(e<0.0))break;if(!(+g[P+(w<<2)>>2]<-(h*e)))break;g[P+(w<<2)>>2]=-(h*e);break}else{if(!(e>0.0))break;if(!(+g[P+(w<<2)>>2]>-(h*e)))break;g[P+(w<<2)>>2]=-(h*e);break}}while(0);g[P+(w<<2)>>2]=+g[b+248>>2]*+g[P+(w<<2)>>2];i=ca;return}function mr(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;switch(b|0){case 2:{if((e|0)<1){g[a+232>>2]=d;c[a+300>>2]=c[a+300>>2]|512;return}if((e|0)<3){g[a+264>>2]=d;c[a+300>>2]=c[a+300>>2]|32;return}if((e|0)==3){g[a+248>>2]=d;c[a+300>>2]=c[a+300>>2]|2048;return}if((e|0)>=6)return;g[a+280>>2]=d;c[a+300>>2]=c[a+300>>2]|128;return}case 3:{if((e|0)<1){g[a+212>>2]=d;c[a+300>>2]=c[a+300>>2]|1;return}if((e|0)!=3)return;g[a+228>>2]=d;c[a+300>>2]=c[a+300>>2]|4;return}case 4:{if((e|0)<1){g[a+244>>2]=d;c[a+300>>2]=c[a+300>>2]|256;return}if((e|0)<3){g[a+276>>2]=d;c[a+300>>2]=c[a+300>>2]|16;return}if((e|0)==3){g[a+260>>2]=d;c[a+300>>2]=c[a+300>>2]|1024;return}if((e|0)>=6)return;g[a+292>>2]=d;c[a+300>>2]=c[a+300>>2]|64;return}default:return}}function nr(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;a:do switch(b|0){case 2:{if((c|0)<1){d=+g[a+232>>2];break a}if((c|0)<3){d=+g[a+264>>2];break a}if((c|0)==3){d=+g[a+248>>2];break a}if((c|0)<6)d=+g[a+280>>2];else d=3402823466385288598117041.0e14;break}case 3:{if((c|0)<1){d=+g[a+212>>2];break a}if((c|0)==3)d=+g[a+228>>2];else d=3402823466385288598117041.0e14;break}case 4:{if((c|0)<1){d=+g[a+244>>2];break a}if((c|0)<3){d=+g[a+276>>2];break a}if((c|0)==3){d=+g[a+260>>2];break a}if((c|0)<6)d=+g[a+292>>2];else d=3402823466385288598117041.0e14;break}default:d=3402823466385288598117041.0e14}while(0);return +d}function or(a){a=a|0;if(!a)return;c[2704]=(c[2704]|0)+1;YE(c[a+-4>>2]|0);return}function pr(a){a=a|0;return 204}function qr(a,b,e){a=a|0;b=b|0;e=e|0;fr(a,b,e)|0;c[b+52>>2]=c[a+52>>2];c[b+56>>2]=c[a+56>>2];c[b+60>>2]=c[a+60>>2];c[b+64>>2]=c[a+64>>2];c[b+68>>2]=c[a+68>>2];c[b+72>>2]=c[a+72>>2];c[b+76>>2]=c[a+76>>2];c[b+80>>2]=c[a+80>>2];c[b+84>>2]=c[a+84>>2];c[b+88>>2]=c[a+88>>2];c[b+92>>2]=c[a+92>>2];c[b+96>>2]=c[a+96>>2];c[b+100>>2]=c[a+100>>2];c[b+104>>2]=c[a+104>>2];c[b+108>>2]=c[a+108>>2];c[b+112>>2]=c[a+112>>2];c[b+116>>2]=c[a+116>>2];c[b+120>>2]=c[a+120>>2];c[b+124>>2]=c[a+124>>2];c[b+128>>2]=c[a+128>>2];c[b+132>>2]=c[a+132>>2];c[b+136>>2]=c[a+136>>2];c[b+140>>2]=c[a+140>>2];c[b+144>>2]=c[a+144>>2];c[b+148>>2]=c[a+148>>2];c[b+152>>2]=c[a+152>>2];c[b+156>>2]=c[a+156>>2];c[b+160>>2]=c[a+160>>2];c[b+164>>2]=c[a+164>>2];c[b+168>>2]=c[a+168>>2];c[b+172>>2]=c[a+172>>2];c[b+176>>2]=c[a+176>>2];c[b+180>>2]=c[a+188>>2];c[b+184>>2]=c[a+184>>2];c[b+188>>2]=c[a+196>>2];c[b+192>>2]=c[a+192>>2];c[b+196>>2]=d[a+180>>0];c[b+200>>2]=d[a+49>>0];return 13131}function rr(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0,j=0;if(a[b+527>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}c[d>>2]=3;c[d+4>>2]=3;j=c[b+28>>2]|0;i=c[b+32>>2]|0;sr(b,j+4|0,i+4|0,j+264|0,i+264|0);if(((a[b+526>>0]|0)!=0?(e=c[d>>2]|0,c[d>>2]=e+1,f=c[d+4>>2]|0,c[d+4>>2]=f+-1,h=+g[b+456>>2],+g[b+444>>2]<h):0)?+g[b+448>>2]<h:0){c[d>>2]=e+2;c[d+4>>2]=f+-2}if(!(a[b+525>>0]|0))return;c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+-1;return}function sr(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,P=0.0,S=0,U=0.0,V=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0,qa=0.0,ra=0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0,xa=0.0;ra=i;i=i+144|0;g[b+504>>2]=0.0;g[b+500>>2]=0.0;a[b+525>>0]=0;a[b+526>>0]=0;if((a[b+552>>0]|0)!=0?(a[b+527>>0]|0)==0:0){xa=+g[b+556>>2];va=+g[b+560>>2];ha=+g[b+564>>2];ua=+g[b+568>>2];Y=xa*(2.0/(xa*xa+va*va+ha*ha+ua*ua));wa=va*(2.0/(xa*xa+va*va+ha*ha+ua*ua));ta=ha*(2.0/(xa*xa+va*va+ha*ha+ua*ua));Z=+g[b+300>>2];u=+g[d>>2];_=+g[b+316>>2];v=+g[d+4>>2];$=+g[b+332>>2];K=+g[d+8>>2];ba=+g[b+304>>2];da=+g[b+320>>2];fa=+g[b+336>>2];U=+g[b+308>>2];V=+g[b+324>>2];X=+g[b+340>>2];L=+g[d+16>>2];M=+g[d+20>>2];P=+g[d+24>>2];ca=+g[d+32>>2];ea=+g[d+36>>2];ga=+g[d+40>>2];G=+g[b+348>>2];H=+g[b+352>>2];na=+g[b+356>>2];C=+g[b+364>>2];sa=+g[e>>2];B=+g[b+380>>2];qa=+g[e+4>>2];A=+g[b+396>>2];m=+g[e+8>>2];z=+g[b+368>>2];y=+g[b+384>>2];I=+g[b+400>>2];F=+g[b+372>>2];E=+g[b+388>>2];D=+g[b+404>>2];pa=+g[e+16>>2];oa=+g[e+20>>2];l=+g[e+24>>2];ia=+g[e+32>>2];J=+g[e+36>>2];x=+g[e+40>>2];w=+g[b+412>>2];ja=+g[b+416>>2];j=+g[b+420>>2];n=(1.0-(va*wa+ha*ta))*(C*sa+B*qa+A*m)+(xa*wa+ua*ta)*(sa*z+qa*y+m*I)+(xa*ta-ua*wa)*(sa*F+qa*E+m*D);la=(xa*wa-ua*ta)*(C*sa+B*qa+A*m)+(1.0-(xa*Y+ha*ta))*(sa*z+qa*y+m*I)+(va*ta+ua*Y)*(sa*F+qa*E+m*D);ka=(xa*ta+ua*wa)*(C*sa+B*qa+A*m)+(va*ta-ua*Y)*(sa*z+qa*y+m*I)+(1.0-(xa*Y+va*wa))*(sa*F+qa*E+m*D);ma=(xa*ta-ua*wa)*(F*pa+E*oa+D*l)+((1.0-(va*wa+ha*ta))*(C*pa+B*oa+A*l)+(xa*wa+ua*ta)*(z*pa+y*oa+I*l));t=(va*ta+ua*Y)*(F*pa+E*oa+D*l)+((xa*wa-ua*ta)*(C*pa+B*oa+A*l)+(1.0-(xa*Y+ha*ta))*(z*pa+y*oa+I*l));o=(1.0-(xa*Y+va*wa))*(F*pa+E*oa+D*l)+((xa*ta+ua*wa)*(C*pa+B*oa+A*l)+(va*ta-ua*Y)*(z*pa+y*oa+I*l));aa=(xa*ta-ua*wa)*(F*ia+E*J+D*x)+((1.0-(va*wa+ha*ta))*(C*ia+B*J+A*x)+(xa*wa+ua*ta)*(z*ia+y*J+I*x));ha=(va*ta+ua*Y)*(F*ia+E*J+D*x)+((xa*wa-ua*ta)*(C*ia+B*J+A*x)+(1.0-(xa*Y+ha*ta))*(z*ia+y*J+I*x));Y=(1.0-(xa*Y+va*wa))*(F*ia+E*J+D*x)+((xa*ta+ua*wa)*(C*ia+B*J+A*x)+(va*ta-ua*Y)*(z*ia+y*J+I*x));ua=-(+g[d+48>>2]+(u*G+v*H+K*na));ta=-(L*G+M*H+P*na+ +g[d+52>>2]);na=-(ca*G+ea*H+ga*na+ +g[d+56>>2]);H=(Z*u+_*v+$*K)*ua+(Z*L+_*M+$*P)*ta+(Z*ca+_*ea+$*ga)*na;G=(u*ba+v*da+K*fa)*ua+(ba*L+da*M+fa*P)*ta+(ba*ca+da*ea+fa*ga)*na;na=(u*U+v*V+K*X)*ua+(U*L+V*M+X*P)*ta+(U*ca+V*ea+X*ga)*na;m=na*ka+(H*n+G*la)+((C*sa+B*qa+A*m)*0.0+(sa*z+qa*y+m*I)*0.0+(sa*F+qa*E+m*D)*0.0+(+g[e+48>>2]+(sa*w+qa*ja+m*j)));l=na*o+(H*ma+G*t)+((F*pa+E*oa+D*l)*0.0+((C*pa+B*oa+A*l)*0.0+(z*pa+y*oa+I*l)*0.0)+(pa*w+oa*ja+l*j+ +g[e+52>>2]));j=na*Y+(H*aa+G*ha)+((F*ia+E*J+D*x)*0.0+((C*ia+B*J+A*x)*0.0+(z*ia+y*J+I*x)*0.0)+(ia*w+J*ja+x*j+ +g[e+56>>2]));g[ra+80>>2]=(u*U+v*V+K*X)*ka+((Z*u+_*v+$*K)*n+(u*ba+v*da+K*fa)*la);g[ra+80+4>>2]=(U*L+V*M+X*P)*ka+((Z*L+_*M+$*P)*n+(ba*L+da*M+fa*P)*la);g[ra+80+8>>2]=(U*ca+V*ea+X*ga)*ka+((Z*ca+_*ea+$*ga)*n+(ba*ca+da*ea+fa*ga)*la);g[ra+80+12>>2]=0.0;g[ra+80+16>>2]=(u*U+v*V+K*X)*o+((Z*u+_*v+$*K)*ma+(u*ba+v*da+K*fa)*t);g[ra+80+20>>2]=(U*L+V*M+X*P)*o+((Z*L+_*M+$*P)*ma+(ba*L+da*M+fa*P)*t);g[ra+80+24>>2]=(U*ca+V*ea+X*ga)*o+((Z*ca+_*ea+$*ga)*ma+(ba*ca+da*ea+fa*ga)*t);g[ra+80+28>>2]=0.0;g[ra+80+32>>2]=(u*U+v*V+K*X)*Y+((Z*u+_*v+$*K)*aa+(u*ba+v*da+K*fa)*ha);g[ra+80+36>>2]=(U*L+V*M+X*P)*Y+((Z*L+_*M+$*P)*aa+(ba*L+da*M+fa*P)*ha);g[ra+80+40>>2]=(U*ca+V*ea+X*ga)*Y+((Z*ca+_*ea+$*ga)*aa+(ba*ca+da*ea+fa*ga)*ha);g[ra+80+44>>2]=0.0;g[ra+80+48>>2]=m;g[ra+80+52>>2]=l;g[ra+80+56>>2]=j;g[ra+80+60>>2]=0.0;Oo(ra+80|0,ra+64|0);j=+g[ra+64>>2];l=+g[ra+64+4>>2];m=+g[ra+64+8>>2];if(!(+N(+(j*j+l*l+m*m))<1.1920928955078125e-07)?(g[b+472>>2]=0.0,ha=1.0/+O(+(j*j+l*l+m*m)),g[b+460>>2]=j*ha,g[b+464>>2]=l*ha,g[b+468>>2]=m*ha,ha=+g[ra+64+12>>2],ha=ha<-1.0?-1.0:ha,ha=+T(+(ha>1.0?1.0:ha))*2.0,g[b+504>>2]=ha,!(+N(+ha)<1.1920928955078125e-07)):0)a[b+526>>0]=1;i=ra;return}Oo(d,ra+48|0);Oo(b+300|0,ra+32|0);_=+g[ra+48+12>>2];$=+g[ra+32>>2];aa=+g[ra+48>>2];ba=+g[ra+32+12>>2];ca=+g[ra+48+4>>2];da=+g[ra+32+8>>2];ea=+g[ra+48+8>>2];fa=+g[ra+32+4>>2];Oo(e,ra+16|0);Oo(b+364|0,ra);ga=+g[ra+16+12>>2];ha=+g[ra>>2];ia=+g[ra+16>>2];ja=+g[ra+12>>2];ka=+g[ra+16+4>>2];la=+g[ra+8>>2];ma=+g[ra+16+8>>2];na=+g[ra+4>>2];oa=-(ga*ha+ia*ja+ka*la-ma*na);pa=-(ha*ma+(ja*ka+ga*na)-ia*la);qa=-(ga*la+ja*ma+ia*na-ha*ka);j=(_*ba-$*aa-ca*fa-da*ea)*oa+(_*$+aa*ba+ca*da-ea*fa)*(ga*ja-ha*ia-ka*na-la*ma)+(_*da+ba*ea+aa*fa-$*ca)*pa-($*ea+(ba*ca+_*fa)-aa*da)*qa;v=(_*$+aa*ba+ca*da-ea*fa)*qa+(($*ea+(ba*ca+_*fa)-aa*da)*(ga*ja-ha*ia-ka*na-la*ma)+(_*ba-$*aa-ca*fa-da*ea)*pa)-(_*da+ba*ea+aa*fa-$*ca)*oa;w=($*ea+(ba*ca+_*fa)-aa*da)*oa+((_*da+ba*ea+aa*fa-$*ca)*(ga*ja-ha*ia-ka*na-la*ma)+(_*ba-$*aa-ca*fa-da*ea)*qa)-(_*$+aa*ba+ca*da-ea*fa)*pa;x=(_*ba-$*aa-ca*fa-da*ea)*(ga*ja-ha*ia-ka*na-la*ma)-(_*$+aa*ba+ca*da-ea*fa)*oa-($*ea+(ba*ca+_*fa)-aa*da)*pa-(_*da+ba*ea+aa*fa-$*ca)*qa;l=-j-v*0.0-w*0.0;n=(w+x*0.0-j*0.0)*-w+(x*(x+v*0.0-w*0.0)+l*-j)-(x*0.0+j*0.0-v)*-v;m=(x*0.0+j*0.0-v)*-j+(x*(w+x*0.0-j*0.0)+l*-v)-(x+v*0.0-w*0.0)*-w;l=(x+v*0.0-w*0.0)*-v+(x*(x*0.0+j*0.0-v)+l*-w)-(w+x*0.0-j*0.0)*-j;o=1.0/+O(+(l*l+(n*n+m*m)));if(o*l*0.0+(o*m*0.0+o*n)<-.9999998807907104)if(+N(0.0)>.7071067690849304){t=r;p=0;q=2143289344;s=0}else{t=1.0;p=-2147483648;q=0;s=0}else{Z=+O(+((o*l*0.0+(o*m*0.0+o*n)+1.0)*2.0));p=(g[k>>2]=(o*l*0.0-o*m*0.0)*(1.0/Z),c[k>>2]|0);q=(g[k>>2]=(o*m-o*n*0.0)*(1.0/Z),c[k>>2]|0);t=(o*n*0.0-o*l)*(1.0/Z);s=(g[k>>2]=Z*.5,c[k>>2]|0)}n=(c[k>>2]=p,+g[k>>2]);z=(c[k>>2]=q,+g[k>>2]);u=(c[k>>2]=s,+g[k>>2]);y=1.0/+O(+(u*u+(z*z+(t*t+n*n))));o=t*y;X=w*-o+(j*(u*y)+x*-(n*y))-v*-(z*y);Y=j*-(z*y)+(x*-o+v*(u*y))-w*-(n*y);Z=v*-(n*y)+(w*(u*y)+x*-(z*y))-j*-o;U=x*(u*y)-j*-(n*y)-v*-o-w*-(z*y);V=1.0/+O(+(U*U+(Z*Z+(X*X+Y*Y))));v=+g[b+444>>2];t=+g[b+456>>2];s=(g[k>>2]=v,c[k>>2]|0);if(v>=t?(A=+g[b+448>>2],A>=t):0){u=u*y<-1.0?-1.0:u*y;u=+T(+(u>1.0?1.0:u))*2.0;if(u>1.1920928955078125e-07){t=1.0/+O(+(z*y*(z*y)+(n*y*(n*y)+o*o)));if(+N(+(o*t))>1.1920928955078125e-07){l=+O(+((z*y*t*(z*y*t)/(o*t*(o*t))+1.0)/(1.0/(A*A)+z*y*t*(z*y*t)/(o*t*(o*t))/(v*v))));s=(g[k>>2]=l,c[k>>2]|0);l=n*y*t;m=o*t;n=z*y*t}else{l=n*y*t;m=o*t;n=z*y*t}}else{s=0;l=0.0;m=0.0;n=0.0}o=(c[k>>2]=s,+g[k>>2]);j=+g[b+428>>2];if(u>o*j){a[b+526>>0]=1;g[b+528>>2]=u<o&j<.9999998807907104?(u-o*j)/(o-o*j):1.0;g[b+504>>2]=u-o*j;if(+N(+m)>1.1920928955078125e-07){P=+N(+(m*(-n/m*(A/v))));P=n<-0.0?P:-P;n=1.0/+O(+(m*m+l*l+P*P));l=l*n;m=m*n;n=-(P*n)}M=-l;L=-m;K=-n;u=(ha*ma+(ja*ka+ga*na)-ia*la)*K+(ga*ja-ha*ia-ka*na-la*ma)*M-(ga*la+ja*ma+ia*na-ha*ka)*L;P=(ga*ja-ha*ia-ka*na-la*ma)*L+(ga*la+ja*ma+ia*na-ha*ka)*M-(ga*ha+ia*ja+ka*la-ma*na)*K;v=(ga*ja-ha*ia-ka*na-la*ma)*K+(ga*ha+ia*ja+ka*la-ma*na)*L-(ha*ma+(ja*ka+ga*na)-ia*la)*M;K=-((ga*ha+ia*ja+ka*la-ma*na)*M)-(ha*ma+(ja*ka+ga*na)-ia*la)*L-(ga*la+ja*ma+ia*na-ha*ka)*K;L=P*qa+((ga*ja-ha*ia-ka*na-la*ma)*u+K*oa)-v*pa;M=v*oa+((ga*ja-ha*ia-ka*na-la*ma)*P+K*pa)-u*qa;P=u*pa+((ga*ja-ha*ia-ka*na-la*ma)*v+K*qa)-P*oa;g[b+460>>2]=L;g[b+464>>2]=M;g[b+468>>2]=P;g[b+472>>2]=0.0;c[b+536>>2]=0;c[b+536+4>>2]=0;c[b+536+8>>2]=0;c[b+536+12>>2]=0;g[b+492>>2]=1.0/(L*(+g[f>>2]*L+ +g[f+16>>2]*M+ +g[f+32>>2]*P)+M*(L*+g[f+4>>2]+M*+g[f+20>>2]+P*+g[f+36>>2])+P*(L*+g[f+8>>2]+M*+g[f+24>>2]+P*+g[f+40>>2])+(L*(L*+g[h>>2]+M*+g[h+16>>2]+P*+g[h+32>>2])+M*(L*+g[h+4>>2]+M*+g[h+20>>2]+P*+g[h+36>>2])+P*(L*+g[h+8>>2]+M*+g[h+24>>2]+P*+g[h+40>>2])))}}else S=20;a:do if((S|0)==20){D=+g[b+300>>2];E=+g[b+316>>2];F=+g[b+332>>2];G=+g[d>>2];H=+g[d+4>>2];I=+g[d+8>>2];J=+g[d+16>>2];K=+g[d+20>>2];L=+g[d+24>>2];M=+g[d+32>>2];P=+g[d+36>>2];x=+g[d+40>>2];m=+g[b+304>>2];n=+g[b+320>>2];o=+g[b+336>>2];t=+g[b+308>>2];u=+g[b+324>>2];v=+g[b+340>>2];y=+g[b+364>>2];l=+g[b+380>>2];A=+g[b+396>>2];C=y*+g[e>>2]+l*+g[e+4>>2]+A*+g[e+8>>2];B=y*+g[e+16>>2]+l*+g[e+20>>2]+A*+g[e+24>>2];A=y*+g[e+32>>2]+l*+g[e+36>>2]+A*+g[e+40>>2];l=(D*G+E*H+F*I)*C+(D*J+E*K+F*L)*B+(D*M+E*P+F*x)*A;y=(G*m+H*n+I*o)*C+(J*m+K*n+L*o)*B+(M*m+P*n+x*o)*A;z=(G*t+H*u+I*v)*C+(J*t+K*u+L*v)*B+(M*t+P*u+x*v)*A;w=+g[b+444>>2];j=+g[b+456>>2];do if(w<j){w=+g[b+448>>2];if(w<j){if(+N(+y)<1.1920928955078125e-07?+N(+z)<1.1920928955078125e-07:0)break a;a[b+526>>0]=1;g[b+460>>2]=-((D*M+E*P+F*x)*B-(D*J+E*K+F*L)*A);g[b+464>>2]=-((D*G+E*H+F*I)*A-(D*M+E*P+F*x)*C);g[b+468>>2]=-((D*J+E*K+F*L)*C-(D*G+E*H+F*I)*B);g[b+472>>2]=0.0;break a}if(+N(+l)<1.1920928955078125e-07?+N(+z)<1.1920928955078125e-07:0){j=l;break}a[b+526>>0]=1;if(w>=j){y=+W(+z,+l);if(y>w){j=+Q(+w);y=0.0;z=+R(+w);break}if(y<-w){j=+Q(+w);y=0.0;z=-+R(+w)}else{j=l;y=0.0}}else j=l}else{if(+N(+l)<1.1920928955078125e-07?+N(+y)<1.1920928955078125e-07:0){j=l;break}a[b+526>>0]=1;if(w>=j){z=+W(+y,+l);if(z>w){j=+Q(+w);y=+R(+w);z=0.0;break}if(z<-w){j=+Q(+w);y=-+R(+w);z=0.0}else{j=l;z=0.0}}else j=l}while(0);l=(G*t+H*u+I*v)*z+((G*m+H*n+I*o)*y+(D*G+E*H+F*I)*j);L=(J*t+K*u+L*v)*z+((J*m+K*n+L*o)*y+(D*J+E*K+F*L)*j);K=(M*t+P*u+x*v)*z+((M*m+P*n+x*o)*y+(D*M+E*P+F*x)*j);M=1.0/+O(+(K*K+(l*l+L*L)));g[b+472>>2]=0.0;P=+O(+((B*(M*K)-A*(M*L))*(B*(M*K)-A*(M*L))+(A*(M*l)-C*(M*K))*(A*(M*l)-C*(M*K))+(C*(M*L)-B*(M*l))*(C*(M*L)-B*(M*l))));g[b+504>>2]=P;g[b+460>>2]=-((B*(M*K)-A*(M*L))*(1.0/P));g[b+464>>2]=-((A*(M*l)-C*(M*K))*(1.0/P));g[b+468>>2]=-((C*(M*L)-B*(M*l))*(1.0/P))}while(0);t=+g[b+452>>2];if(!(t>=0.0)){g[b+512>>2]=0.0;i=ra;return}m=V*U<-1.0?-1.0:V*U;m=+T(+(m>1.0?1.0:m))*2.0;if(m>3.1415927410125732){o=V*U>1.0?-1.0:-(V*U);n=-(V*X);o=+T(+(o>1.0?1.0:o))*2.0;j=-(V*Y);l=-(V*Z)}else{n=V*X;o=m;j=V*Y;l=V*Z}g[b+512>>2]=o;if(o>1.1920928955078125e-07){Z=1.0/+O(+(l*l+(j*j+n*n)));n=n*Z;j=j*Z;l=l*Z}m=+g[b+428>>2];if(o>t*m){a[b+525>>0]=1;Z=o-t*m;g[b+532>>2]=o<t&m<.9999998807907104?Z/(t-t*m):1.0;g[b+508>>2]=Z;Z=-n;Y=-j;V=-l;P=(ha*ma+(ja*ka+ga*na)-ia*la)*V+(ga*ja-ha*ia-ka*na-la*ma)*Z-(ga*la+ja*ma+ia*na-ha*ka)*Y;X=(ga*ja-ha*ia-ka*na-la*ma)*Y+(ga*la+ja*ma+ia*na-ha*ka)*Z-(ga*ha+ia*ja+ka*la-ma*na)*V;U=(ga*ja-ha*ia-ka*na-la*ma)*V+(ga*ha+ia*ja+ka*la-ma*na)*Y-(ha*ma+(ja*ka+ga*na)-ia*la)*Z;V=-((ga*ha+ia*ja+ka*la-ma*na)*Z)-(ha*ma+(ja*ka+ga*na)-ia*la)*Y-(ga*la+ja*ma+ia*na-ha*ka)*V;Y=X*qa+((ga*ja-ha*ia-ka*na-la*ma)*P+V*oa)-U*pa;Z=U*oa+((ga*ja-ha*ia-ka*na-la*ma)*X+V*pa)-P*qa;ha=P*pa+((ga*ja-ha*ia-ka*na-la*ma)*U+V*qa)-X*oa;g[b+476>>2]=Y;g[b+480>>2]=Z;g[b+484>>2]=ha;g[b+488>>2]=0.0;g[b+496>>2]=1.0/(Y*(+g[f>>2]*Y+ +g[f+16>>2]*Z+ +g[f+32>>2]*ha)+Z*(Y*+g[f+4>>2]+Z*+g[f+20>>2]+ha*+g[f+36>>2])+ha*(Y*+g[f+8>>2]+Z*+g[f+24>>2]+ha*+g[f+40>>2])+(Y*(Y*+g[h>>2]+Z*+g[h+16>>2]+ha*+g[h+32>>2])+Z*(Y*+g[h+4>>2]+Z*+g[h+20>>2]+ha*+g[h+36>>2])+ha*(Y*+g[h+8>>2]+Z*+g[h+24>>2]+ha*+g[h+40>>2])))}if(!(a[b+526>>0]|0)){i=ra;return}V=-n;ha=-j;Y=-l;U=($*ea+(ba*ca+_*fa)-aa*da)*Y+(_*ba-$*aa-ca*fa-da*ea)*V-(_*da+ba*ea+aa*fa-$*ca)*ha;ga=(_*ba-$*aa-ca*fa-da*ea)*ha+(_*da+ba*ea+aa*fa-$*ca)*V-(_*$+aa*ba+ca*da-ea*fa)*Y;X=(_*ba-$*aa-ca*fa-da*ea)*Y+(_*$+aa*ba+ca*da-ea*fa)*ha-($*ea+(ba*ca+_*fa)-aa*da)*V;Y=-((_*$+aa*ba+ca*da-ea*fa)*V)-($*ea+(ba*ca+_*fa)-aa*da)*ha-(_*da+ba*ea+aa*fa-$*ca)*Y;ha=-(_*$+aa*ba+ca*da-ea*fa);V=-($*ea+(ba*ca+_*fa)-aa*da);Z=-(_*da+ba*ea+aa*fa-$*ca);g[b+536>>2]=ga*Z+((_*ba-$*aa-ca*fa-da*ea)*U+Y*ha)-X*V;g[b+540>>2]=X*ha+((_*ba-$*aa-ca*fa-da*ea)*ga+Y*V)-U*Z;g[b+544>>2]=U*V+((_*ba-$*aa-ca*fa-da*ea)*X+Y*Z)-ga*ha;g[b+548>>2]=0.0;i=ra;return}function tr(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;q=c[b+28>>2]|0;h=c[b+32>>2]|0;sr(b,q+4|0,h+4|0,q+264|0,h+264|0);r=c[d+8>>2]|0;g[r>>2]=1.0;o=c[d+24>>2]|0;g[r+(o+1<<2)>>2]=1.0;g[r+((o<<1)+2<<2)>>2]=1.0;n=+g[b+348>>2];u=+g[b+352>>2];k=+g[b+356>>2];s=+g[q+4>>2]*n+ +g[q+8>>2]*u+ +g[q+12>>2]*k;m=n*+g[q+20>>2]+u*+g[q+24>>2]+k*+g[q+28>>2];k=n*+g[q+36>>2]+u*+g[q+40>>2]+k*+g[q+44>>2];r=c[d+12>>2]|0;c[r>>2]=0;g[r+4>>2]=k;g[r+8>>2]=-m;g[r+12>>2]=0.0;g[r+(o<<2)>>2]=-k;c[r+(o+1<<2)>>2]=0;g[r+(o+2<<2)>>2]=s;g[r+(o+3<<2)>>2]=0.0;g[r+(o<<1<<2)>>2]=m;g[r+((o<<1|1)<<2)>>2]=-s;c[r+((o<<1)+2<<2)>>2]=0;g[r+((o<<1)+3<<2)>>2]=0.0;r=c[d+16>>2]|0;g[r>>2]=-1.0;g[r+(o+1<<2)>>2]=-1.0;g[r+((o<<1)+2<<2)>>2]=-1.0;u=+g[b+412>>2];n=+g[b+416>>2];j=+g[b+420>>2];t=+g[h+4>>2]*u+ +g[h+8>>2]*n+ +g[h+12>>2]*j;l=u*+g[h+20>>2]+n*+g[h+24>>2]+j*+g[h+28>>2];j=u*+g[h+36>>2]+n*+g[h+40>>2]+j*+g[h+44>>2];o=c[d+20>>2]|0;r=c[d+24>>2]|0;c[o>>2]=0;g[o+4>>2]=-j;g[o+8>>2]=l;g[o+12>>2]=0.0;g[o+(r<<2)>>2]=j;c[o+(r+1<<2)>>2]=0;g[o+(r+2<<2)>>2]=-t;g[o+(r+3<<2)>>2]=0.0;g[o+(r<<1<<2)>>2]=-l;g[o+((r<<1|1)<<2)>>2]=t;c[o+((r<<1)+2<<2)>>2]=0;g[o+((r<<1)+3<<2)>>2]=0.0;p=c[b+592>>2]|0;n=+g[((p&2|0)==0?d+4|0:b+600|0)>>2]*+g[d>>2];i=c[d+28>>2]|0;e=c[d+36>>2]|0;f=c[d+40>>2]|0;g[i>>2]=n*(t+ +g[h+52>>2]-s-+g[q+52>>2]);g[e>>2]=-3402823466385288598117041.0e14;g[f>>2]=3402823466385288598117041.0e14;if(!(p&1)){g[i+(r<<2)>>2]=n*(l+ +g[h+56>>2]-m-+g[q+56>>2]);g[e+(r<<2)>>2]=-3402823466385288598117041.0e14;g[f+(r<<2)>>2]=3402823466385288598117041.0e14;g[i+(r<<1<<2)>>2]=n*(j+ +g[h+60>>2]-k-+g[q+60>>2]);g[e+(r<<1<<2)>>2]=-3402823466385288598117041.0e14;g[f+(r<<1<<2)>>2]=3402823466385288598117041.0e14}else{v=c[d+32>>2]|0;c[v>>2]=c[b+596>>2];g[i+(r<<2)>>2]=n*(l+ +g[h+56>>2]-m-+g[q+56>>2]);g[e+(r<<2)>>2]=-3402823466385288598117041.0e14;g[f+(r<<2)>>2]=3402823466385288598117041.0e14;c[v+(r<<2)>>2]=c[b+596>>2];g[i+(r<<1<<2)>>2]=n*(j+ +g[h+60>>2]-k-+g[q+60>>2]);g[e+(r<<1<<2)>>2]=-3402823466385288598117041.0e14;g[f+(r<<1<<2)>>2]=3402823466385288598117041.0e14;c[v+(r<<1<<2)>>2]=c[b+596>>2]}do if(!(a[b+526>>0]|0))h=r*3|0;else{h=c[d+12>>2]|0;j=+g[b+456>>2];if(+g[b+444>>2]<j?+g[b+448>>2]<j:0){z=+g[q+4>>2];y=+g[q+8>>2];x=+g[q+12>>2];D=+g[b+304>>2];C=+g[b+320>>2];B=+g[b+336>>2];u=+g[b+308>>2];t=+g[b+324>>2];s=+g[b+340>>2];w=+g[q+20>>2];n=+g[q+24>>2];m=+g[q+28>>2];l=+g[q+36>>2];k=+g[q+40>>2];j=+g[q+44>>2];g[h+(r*3<<2)>>2]=z*D+y*C+x*B;g[h+((r*3|0)+1<<2)>>2]=D*w+C*n+B*m;g[h+((r*3|0)+2<<2)>>2]=D*l+C*k+B*j;g[h+(r<<2<<2)>>2]=z*u+y*t+x*s;g[h+((r<<2|1)<<2)>>2]=u*w+t*n+s*m;g[h+((r<<2|2)<<2)>>2]=u*l+t*k+s*j;g[o+(r*3<<2)>>2]=-(z*D+y*C+x*B);g[o+((r*3|0)+1<<2)>>2]=-(D*w+C*n+B*m);g[o+((r*3|0)+2<<2)>>2]=-(D*l+C*k+B*j);g[o+(r<<2<<2)>>2]=-(z*u+y*t+x*s);g[o+((r<<2|1)<<2)>>2]=-(u*w+t*n+s*m);g[o+((r<<2|2)<<2)>>2]=-(u*l+t*k+s*j);A=+g[d>>2]*+g[b+436>>2];i=c[d+28>>2]|0;g[i+(r*3<<2)>>2]=A*((z*D+y*C+x*B)*+g[b+460>>2]+(D*w+C*n+B*m)*+g[b+464>>2]+(D*l+C*k+B*j)*+g[b+468>>2]);g[i+(r<<2<<2)>>2]=A*((z*u+y*t+x*s)*+g[b+460>>2]+(u*w+t*n+s*m)*+g[b+464>>2]+(u*l+t*k+s*j)*+g[b+468>>2]);e=c[d+36>>2]|0;g[e+(r*3<<2)>>2]=-3402823466385288598117041.0e14;f=c[d+40>>2]|0;g[f+(r*3<<2)>>2]=3402823466385288598117041.0e14;g[e+(r<<2<<2)>>2]=-3402823466385288598117041.0e14;g[f+(r<<2<<2)>>2]=3402823466385288598117041.0e14;h=(c[d+24>>2]|0)+(r<<2)|0;break}x=+g[b+436>>2];n=x*(+g[b+460>>2]*x);w=x*(x*+g[b+464>>2]);x=x*(x*+g[b+468>>2]);g[h+(r*3<<2)>>2]=n;g[h+((r*3|0)+1<<2)>>2]=w;g[h+((r*3|0)+2<<2)>>2]=x;g[o+(r*3<<2)>>2]=-n;g[o+((r*3|0)+1<<2)>>2]=-w;g[o+((r*3|0)+2<<2)>>2]=-x;g[i+(r*3<<2)>>2]=+g[d>>2]*+g[b+432>>2]*+g[b+504>>2];if(p&4)c[(c[d+32>>2]|0)+(r*3<<2)>>2]=c[b+604>>2];g[e+(r*3<<2)>>2]=0.0;g[f+(r*3<<2)>>2]=3402823466385288598117041.0e14;h=r<<2}while(0);if(!(a[b+525>>0]|0))return;x=+g[b+436>>2];n=x*(+g[b+476>>2]*x);w=x*(x*+g[b+480>>2]);x=x*(x*+g[b+484>>2]);q=c[d+12>>2]|0;o=c[d+20>>2]|0;g[q+(h<<2)>>2]=n;r=h+1|0;g[q+(r<<2)>>2]=w;p=h+2|0;g[q+(p<<2)>>2]=x;g[o+(h<<2)>>2]=-n;g[o+(r<<2)>>2]=-w;g[o+(p<<2)>>2]=-x;g[i+(h<<2)>>2]=+g[d>>2]*+g[b+432>>2]*+g[b+508>>2];if(c[b+592>>2]&4)c[(c[d+32>>2]|0)+(h<<2)>>2]=c[b+604>>2];if(!(+g[b+452>>2]>0.0)){g[e+(h<<2)>>2]=-3402823466385288598117041.0e14;g[f+(h<<2)>>2]=3402823466385288598117041.0e14;return}f=e+(h<<2)|0;e=c[d+40>>2]|0;if(+g[b+508>>2]>0.0){g[f>>2]=0.0;g[e+(h<<2)>>2]=3402823466385288598117041.0e14;return}else{g[f>>2]=-3402823466385288598117041.0e14;g[e+(h<<2)>>2]=0.0;return}}function ur(b){b=b|0;var d=0,e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0.0,z=0;x=i;i=i+176|0;if(!(a[b+527>>0]|0)){i=x;return}g[b+36>>2]=0.0;g[b+520>>2]=0.0;g[b+516>>2]=0.0;c[b+576>>2]=0;c[b+576+4>>2]=0;c[b+576+8>>2]=0;c[b+576+12>>2]=0;if(!(a[b+524>>0]|0)){d=c[b+28>>2]|0;m=+g[b+348>>2];n=+g[b+352>>2];t=+g[b+356>>2];v=m*+g[d+20>>2]+n*+g[d+24>>2]+t*+g[d+28>>2]+ +g[d+56>>2];e=c[b+32>>2]|0;o=+g[b+412>>2];p=+g[b+416>>2];s=+g[b+420>>2];h=+g[e+52>>2];q=+g[e+56>>2];w=o*+g[e+20>>2]+p*+g[e+24>>2]+s*+g[e+28>>2]+q;u=o*+g[e+36>>2]+p*+g[e+40>>2]+s*+g[e+44>>2]+ +g[e+60>>2];r=m*+g[d+4>>2]+n*+g[d+8>>2]+t*+g[d+12>>2]+ +g[d+52>>2];t=m*+g[d+36>>2]+n*+g[d+40>>2]+t*+g[d+44>>2]+ +g[d+60>>2];s=o*+g[e+4>>2]+p*+g[e+8>>2]+s*+g[e+12>>2]+h;if((s-r)*(s-r)+(w-v)*(w-v)+(u-t)*(u-t)>1.1920928955078125e-07){l=1.0/+O(+((s-r)*(s-r)+(w-v)*(w-v)+(u-t)*(u-t)));g[x+128>>2]=(s-r)*l;g[x+128+4>>2]=(w-v)*l;g[x+128+8>>2]=(u-t)*l;c[x+128+12>>2]=0;k=(u-t)*l;f=(w-v)*l;l=(s-r)*l}else{c[x+128>>2]=1065353216;c[x+128+4>>2]=0;c[x+128+8>>2]=0;g[x+128+12>>2]=0.0;k=0.0;f=0.0;l=1.0}if(+N(+k)>.7071067690849304){y=k*k+f*f;p=1.0/+O(+y);o=-(p*k);f=p*f;j=f;m=l*o;n=0.0;p=y*p;f=-(l*f)}else{n=l*l+f*f;m=1.0/+O(+n);f=-(f*m);p=m*l;j=0.0;m=n*m;n=f;o=p;p=-(k*p);f=k*f}g[x+128+16>>2]=n;g[x+128+20>>2]=o;g[x+128+24>>2]=j;g[x+128+32>>2]=p;g[x+128+36>>2]=f;g[x+128+40>>2]=m;f=q;d=0;while(1){z=c[b+28>>2]|0;c[x+80>>2]=c[z+4>>2];c[x+80+4>>2]=c[z+20>>2];c[x+80+8>>2]=c[z+36>>2];g[x+80+12>>2]=0.0;c[x+80+16>>2]=c[z+8>>2];c[x+80+20>>2]=c[z+24>>2];c[x+80+24>>2]=c[z+40>>2];g[x+80+28>>2]=0.0;c[x+80+32>>2]=c[z+12>>2];c[x+80+36>>2]=c[z+28>>2];c[x+80+40>>2]=c[z+44>>2];g[x+80+44>>2]=0.0;c[x+32>>2]=c[e+4>>2];c[x+32+4>>2]=c[e+20>>2];c[x+32+8>>2]=c[e+36>>2];g[x+32+12>>2]=0.0;c[x+32+16>>2]=c[e+8>>2];c[x+32+20>>2]=c[e+24>>2];c[x+32+24>>2]=c[e+40>>2];g[x+32+28>>2]=0.0;c[x+32+32>>2]=c[e+12>>2];c[x+32+36>>2]=c[e+28>>2];c[x+32+40>>2]=c[e+44>>2];g[x+32+44>>2]=0.0;p=v-+g[z+56>>2];q=t-+g[z+60>>2];g[x+16>>2]=r-+g[z+52>>2];g[x+16+4>>2]=p;g[x+16+8>>2]=q;g[x+16+12>>2]=0.0;q=u-+g[e+60>>2];g[x>>2]=s-h;g[x+4>>2]=w-f;g[x+8>>2]=q;g[x+12>>2]=0.0;z=c[b+28>>2]|0;e=c[b+32>>2]|0;Lq(b+48+(d*84|0)|0,x+80|0,x+32|0,x+16|0,x,x+128+(d<<4)|0,z+396|0,+g[z+344>>2],e+396|0,+g[e+344>>2]);d=d+1|0;if((d|0)==3)break;e=c[b+32>>2]|0;h=+g[e+52>>2];f=+g[e+56>>2]}d=b+32|0}else d=b+32|0;e=c[b+28>>2]|0;d=c[d>>2]|0;sr(b,e+4|0,d+4|0,e+264|0,d+264|0);i=x;return}
function vr(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0,L=0,M=0,N=0,P=0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0;P=i;i=i+448|0;if(!(a[b+527>>0]|0)){i=P;return}L=c[b+28>>2]|0;m=+g[b+348>>2];w=+g[b+352>>2];o=+g[b+356>>2];B=+g[L+52>>2];x=m*+g[L+4>>2]+w*+g[L+8>>2]+o*+g[L+12>>2]+B;A=+g[L+56>>2];q=m*+g[L+20>>2]+w*+g[L+24>>2]+o*+g[L+28>>2]+A;z=+g[L+60>>2];o=m*+g[L+36>>2]+w*+g[L+40>>2]+o*+g[L+44>>2]+z;L=c[b+32>>2]|0;w=+g[b+412>>2];m=+g[b+416>>2];p=+g[b+420>>2];y=+g[L+52>>2];n=w*+g[L+4>>2]+m*+g[L+8>>2]+p*+g[L+12>>2]+y;j=+g[L+56>>2];D=w*+g[L+20>>2]+m*+g[L+24>>2]+p*+g[L+28>>2]+j;k=+g[L+60>>2];p=w*+g[L+36>>2]+m*+g[L+40>>2]+p*+g[L+44>>2]+k;if(!(a[b+524>>0]|0)){l=+g[d+192>>2]+ +g[d+80>>2];w=+g[d+196>>2]+ +g[d+84>>2];G=+g[d+200>>2]+ +g[d+88>>2];m=+g[e+192>>2]+ +g[e+80>>2];F=+g[e+196>>2]+ +g[e+84>>2];H=+g[e+200>>2]+ +g[e+88>>2];E=+g[d+176>>2]+ +g[d+64>>2]+((o-z)*w-(q-A)*G)-(+g[e+176>>2]+ +g[e+64>>2]+((p-k)*F-(D-j)*H));H=+g[d+180>>2]+ +g[d+68>>2]+((x-B)*G-(o-z)*l)-(+g[e+180>>2]+ +g[e+68>>2]+((n-y)*H-(p-k)*m));F=+g[d+184>>2]+ +g[d+72>>2]+((q-A)*l-(x-B)*w)-(+g[e+184>>2]+ +g[e+72>>2]+((D-j)*m-(n-y)*F));h=(c[d+240>>2]|0)==0;t=0;do{m=1.0/+g[b+48+(t*84|0)+80>>2];u=b+48+(t*84|0)|0;w=+g[u>>2];r=b+48+(t*84|0)+4|0;l=+g[r>>2];s=b+48+(t*84|0)+8|0;G=+g[s>>2];G=m*(((x-n)*w+(q-D)*l+(o-p)*G)*-.30000001192092896/f)-m*(E*w+H*l+F*G);g[b+36>>2]=+g[b+36>>2]+G;l=+g[s>>2];w=+g[r>>2];m=+g[u>>2];v=c[b+28>>2]|0;C=+g[v+344>>2];if(!h){S=((q-A)*l-(o-z)*w)*+g[v+296>>2]+((o-z)*m-(x-B)*l)*+g[v+300>>2]+((x-B)*w-(q-A)*m)*+g[v+304>>2];Q=((q-A)*l-(o-z)*w)*+g[v+280>>2]+((o-z)*m-(x-B)*l)*+g[v+284>>2]+((x-B)*w-(q-A)*m)*+g[v+288>>2];R=((q-A)*l-(o-z)*w)*+g[v+264>>2]+((o-z)*m-(x-B)*l)*+g[v+268>>2]+((x-B)*w-(q-A)*m)*+g[v+272>>2];U=G*(w*C)*+g[d+116>>2];T=G*(l*C)*+g[d+120>>2];g[d+64>>2]=G*(m*C)*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=U+ +g[d+68>>2];g[d+72>>2]=T+ +g[d+72>>2];Q=Q*(G*+g[d+100>>2]);C=S*(G*+g[d+104>>2]);g[d+80>>2]=R*(G*+g[d+96>>2])+ +g[d+80>>2];g[d+84>>2]=Q+ +g[d+84>>2];g[d+88>>2]=C+ +g[d+88>>2]}v=c[b+32>>2]|0;C=+g[v+344>>2];if(c[e+240>>2]|0){R=((D-j)*l-(p-k)*w)*+g[v+296>>2]+((p-k)*m-(n-y)*l)*+g[v+300>>2]+((n-y)*w-(D-j)*m)*+g[v+304>>2];S=((D-j)*l-(p-k)*w)*+g[v+280>>2]+((p-k)*m-(n-y)*l)*+g[v+284>>2]+((n-y)*w-(D-j)*m)*+g[v+288>>2];Q=((D-j)*l-(p-k)*w)*+g[v+264>>2]+((p-k)*m-(n-y)*l)*+g[v+268>>2]+((n-y)*w-(D-j)*m)*+g[v+272>>2];w=C*+g[r>>2]*-G*+g[e+116>>2];l=C*+g[s>>2]*-G*+g[e+120>>2];g[e+64>>2]=+g[e+112>>2]*(C*+g[u>>2]*-G)+ +g[e+64>>2];g[e+68>>2]=w+ +g[e+68>>2];g[e+72>>2]=l+ +g[e+72>>2];l=S*(+g[e+100>>2]*-G);C=R*(+g[e+104>>2]*-G);g[e+80>>2]=Q*(+g[e+96>>2]*-G)+ +g[e+80>>2];g[e+84>>2]=l+ +g[e+84>>2];g[e+88>>2]=C+ +g[e+88>>2]}t=t+1|0}while((t|0)!=3)}do if(!(a[b+552>>0]|0)){q=+g[b+440>>2];if(!(q>1.1920928955078125e-07)){t=e+192|0;h=d+192|0;v=e+200|0;s=d+200|0;L=e+88|0;I=d+88|0;M=e+80|0;J=d+80|0;u=e+196|0;r=d+196|0;N=e+84|0;K=d+84|0;break}p=+g[e+192>>2]+ +g[e+80>>2]-(+g[d+192>>2]+ +g[d+80>>2]);o=+g[e+196>>2]+ +g[e+84>>2]-(+g[d+196>>2]+ +g[d+84>>2]);m=+g[e+200>>2]+ +g[e+88>>2]-(+g[d+200>>2]+ +g[d+88>>2]);if(p*p+o*o+m*m>1.1920928955078125e-07){C=1.0/+O(+(p*p+o*o+m*m));h=c[b+28>>2]|0;l=+g[h+264>>2];k=+g[h+280>>2];j=+g[h+296>>2];w=+g[h+268>>2];x=+g[h+284>>2];y=+g[h+300>>2];z=+g[h+272>>2];A=+g[h+288>>2];B=+g[h+304>>2];h=c[b+32>>2]|0;q=q*(1.0/(p*C*(p*C*l+o*C*k+m*C*j)+o*C*(p*C*w+o*C*x+m*C*y)+m*C*(p*C*z+o*C*A+m*C*B)+(p*C*(p*C*+g[h+264>>2]+o*C*+g[h+280>>2]+m*C*+g[h+296>>2])+o*C*(p*C*+g[h+268>>2]+o*C*+g[h+284>>2]+m*C*+g[h+300>>2])+m*C*(p*C*+g[h+272>>2]+o*C*+g[h+288>