# react-element-to-jsx-string

[![Version][version-svg]][package-url] [![Build Status][travis-svg]][travis-url] [![License][license-image]][license-url] [![Downloads][downloads-image]][downloads-url]

[travis-svg]: https://img.shields.io/travis/algolia/react-element-to-jsx-string/master.svg?style=flat-square
[travis-url]: https://travis-ci.org/algolia/react-element-to-jsx-string
[license-image]: http://img.shields.io/badge/license-MIT-green.svg?style=flat-square
[license-url]: LICENSE
[downloads-image]: https://img.shields.io/npm/dm/react-element-to-jsx-string.svg?style=flat-square
[downloads-url]: http://npm-stat.com/charts.html?package=react-element-to-jsx-string
[version-svg]: https://img.shields.io/npm/v/react-element-to-jsx-string.svg?style=flat-square
[package-url]: https://npmjs.org/package/react-element-to-jsx-string

Turn a ReactElement into the corresponding JSX string.

Useful for unit testing and any other need you may think of.

Features:
- supports nesting and deep nesting like `<div a={{b: {c: {d: <div />}}}} />`
- props: supports string, number, function (inlined as `prop={function noRefCheck() {}}`), object, ReactElement (inlined), regex, booleans (with or without [shorthand syntax](https://facebook.github.io/react/docs/jsx-in-depth.html#boolean-attributes)), ...
- order props alphabetically
- sort object keys in a deterministic order (`o={{a: 1, b:2}} === o={{b:2, a:1}}`)
- handle `ref` and `key` attributes, they are always on top of props
- React's documentation indent style for JSX

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**  *generated with [DocToc](https://github.com/thlorenz/doctoc)*

- [react-element-to-jsx-string](#react-element-to-jsx-string)
  - [Setup](#setup)
  - [Usage](#usage)
  - [Test](#test)
  - [Build](#build)
  - [Thanks](#thanks)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Setup

```sh
npm install react-element-to-jsx-string --save[-dev]
```

## Usage

```js
import React from 'react';
import reactElementToJSXString from 'react-element-to-jsx-string';

console.log(reactElementToJSXString(<div a="1" b="2">Hello, world!</div>));
// <div
//   a="1"
//   b="2"
// >
//   Hello, world!
// </div>
```

## API

### reactElementToJSXString(ReactElement[, options])

**options.displayName: function(ReactElement)**

  Provide a different algorithm in charge of finding the right display name (name of the underlying Class) for your element.

  Just return the name you want for the provided ReactElement, as a string.

**options.filterProps: array, default []**

  Provide an array of props to filter for every component. For example ['key'] will suppress the key="" prop from being added.

**options.showDefaultProps: boolean, default true**

  If true, default props shown.

  If false, default props are omitted unless they differ from from the default value.

**options.showFunctions: boolean, default false**

  If true, functions bodies are shown.

  If false, functions bodies are replaced with `function noRefCheck() {}`.

**options.tabStop: number, default 2**

  Provide a different number of columns for indentation.

**options.useBooleanShorthandSyntax: boolean, default true**

  If true, Boolean prop values will be omitted for [shorthand syntax](https://facebook.github.io/react/docs/jsx-in-depth.html#boolean-attributes).

  If false, Boolean prop values will be explicitly output like `prop={true}` and `prop={false}`

## Test

```sh
npm test
npm run test:watch
```

## Build

```sh
npm run build
npm run build:watch
```

## Release

Decide if this is a `patch`, `minor` or `major` release, look at http://semver.org/

```sh
npm install mversion json -g
mversion PatchOrMinorOrMajor && \
git commit -am `json -f package.json version` && \
git tag v`json -f package.json version` && \
git push && \
git push --tags && \
npm publish
```

## Thanks

[alexlande/react-to-jsx](https://github.com/alexlande/react-to-jsx/) was a good source of inspiration.

We built our own module because we had some needs like ordering props in alphabetical order.
