<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function usolve

Finds one solution of a linear equation system by backward substitution. Matrix must be an upper triangular matrix. Throws an error if there's no solution.

`U * x = b`


## Syntax

```js
math.usolve(U, b)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`U` | Matrix, Array | A N x N matrix or array (U)
`b` | Matrix, Array | A column vector with the b values

### Returns

Type | Description
---- | -----------
DenseMatrix &#124; Array | A column vector with the linear system solution (x)


## Examples

```js
const a = [[-2, 3], [2, 1]]
const b = [11, 9]
const x = usolve(a, b)  // [[8], [9]]
```


## See also

[usolveAll](usolveAll.md),
[lup](lup.md),
[slu](slu.md),
[usolve](usolve.md),
[lusolve](lusolve.md)
