# Expressions

Math.js contains a flexible and easy to use expression parser.
The parser supports all data types, functions and constants available in math.js.

Whilst the math.js library is aimed at JavaScript developers, the expression
parser is aimed at end users: mathematicians, engineers, students, pupils.
The syntax of the expression parser differs from JavaScript and the low-level
math.js library.

This section is divided in the following pages:

- [Parsing and evaluation](parsing.md) describes how to parse and
  evaluate expressions with math.js.
- [Syntax](syntax.md) describes how to write expressions.
- [Expression trees](expression_trees.md) explains how to parse an expression into an
  expression tree, and use this to analyse and manipulate the expression.
- [Algebra](algebra.md) describing symbolic computation in math.js.
- [Customization](customization.md) describes how to customize processing and
  evaluation of expressions.
- [Security](security.md) about security risks of executing arbitrary expressions.
