// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/base/component
//   ../../@material/base/foundation

declare module '@material/menu-surface' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/menu-surface/adapter';
    export * from '@material/menu-surface/component';
    export * from '@material/menu-surface/constants';
    export * from '@material/menu-surface/foundation';
    export * from '@material/menu-surface/types';
}

declare module '@material/menu-surface/adapter' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCMenuDimensions, MDCMenuDistance, MDCMenuPoint } from '@material/menu-surface/types';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCMenuSurfaceAdapter {
            addClass(className: string): void;
            removeClass(className: string): void;
            hasClass(className: string): boolean;
            hasAnchor(): boolean;
            isElementInContainer(el: Element): boolean;
            isFocused(): boolean;
            isRtl(): boolean;
            getInnerDimensions(): MDCMenuDimensions;
            getAnchorDimensions(): ClientRect | null;
            getWindowDimensions(): MDCMenuDimensions;
            getBodyDimensions(): MDCMenuDimensions;
            getWindowScroll(): MDCMenuPoint;
            setPosition(position: Partial<MDCMenuDistance>): void;
            setMaxHeight(height: string): void;
            setTransformOrigin(origin: string): void;
            /** Saves the element that was focused before the menu surface was opened. */
            saveFocus(): void;
            /** Restores focus to the element that was focused before the menu surface was opened. */
            restoreFocus(): void;
            /** Emits an event when the menu surface is closed. */
            notifyClose(): void;
            /** Emits an event when the menu surface is closing. */
            notifyClosing(): void;
            /** Emits an event when the menu surface is opened. */
            notifyOpen(): void;
    }
}

declare module '@material/menu-surface/component' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { Corner } from '@material/menu-surface/constants';
    import { MDCMenuSurfaceFoundation } from '@material/menu-surface/foundation';
    import { MDCMenuDistance } from '@material/menu-surface/types';
    export type MDCMenuSurfaceFactory = (el: Element, foundation?: MDCMenuSurfaceFoundation) => MDCMenuSurface;
    export class MDCMenuSurface extends MDCComponent<MDCMenuSurfaceFoundation> {
            static attachTo(root: Element): MDCMenuSurface;
            anchorElement: Element | null;
            initialSyncWithDOM(): void;
            destroy(): void;
            isOpen(): boolean;
            open(): void;
            close(skipRestoreFocus?: boolean): void;
            set quickOpen(quickOpen: boolean);
            /** Sets the foundation to use page offsets for an positioning when the menu is hoisted to the body. */
            setIsHoisted(isHoisted: boolean): void;
            /** Sets the element that the menu-surface is anchored to. */
            setMenuSurfaceAnchorElement(element: Element): void;
            /** Sets the menu-surface to position: fixed. */
            setFixedPosition(isFixed: boolean): void;
            /** Sets the absolute x/y position to position based on. Requires the menu to be hoisted. */
            setAbsolutePosition(x: number, y: number): void;
            /**
                * @param corner Default anchor corner alignment of top-left surface corner.
                */
            setAnchorCorner(corner: Corner): void;
            setAnchorMargin(margin: Partial<MDCMenuDistance>): void;
            getDefaultFoundation(): MDCMenuSurfaceFoundation;
    }
}

declare module '@material/menu-surface/constants' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    const cssClasses: {
            ANCHOR: string;
            ANIMATING_CLOSED: string;
            ANIMATING_OPEN: string;
            FIXED: string;
            IS_OPEN_BELOW: string;
            OPEN: string;
            ROOT: string;
    };
    const strings: {
            CLOSED_EVENT: string;
            CLOSING_EVENT: string;
            OPENED_EVENT: string;
            FOCUSABLE_ELEMENTS: string;
    };
    const numbers: {
            /** Total duration of menu-surface open animation. */
            TRANSITION_OPEN_DURATION: number;
            /** Total duration of menu-surface close animation. */
            TRANSITION_CLOSE_DURATION: number;
            /** Margin left to the edge of the viewport when menu-surface is at maximum possible height. Also used as a viewport margin. */
            MARGIN_TO_EDGE: number;
            /** Ratio of anchor width to menu-surface width for switching from corner positioning to center positioning. */
            ANCHOR_TO_MENU_SURFACE_WIDTH_RATIO: number;
    };
    /**
        * Enum for bits in the {@see Corner) bitmap.
        */
    enum CornerBit {
            BOTTOM = 1,
            CENTER = 2,
            RIGHT = 4,
            FLIP_RTL = 8
    }
    /**
        * Enum for representing an element corner for positioning the menu-surface.
        *
        * The START constants map to LEFT if element directionality is left
        * to right and RIGHT if the directionality is right to left.
        * Likewise END maps to RIGHT or LEFT depending on the directionality.
        */
    enum Corner {
            TOP_LEFT = 0,
            TOP_RIGHT = 4,
            BOTTOM_LEFT = 1,
            BOTTOM_RIGHT = 5,
            TOP_START = 8,
            TOP_END = 12,
            BOTTOM_START = 9,
            BOTTOM_END = 13
    }
    export { cssClasses, strings, numbers, CornerBit, Corner };
}

declare module '@material/menu-surface/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCMenuSurfaceAdapter } from '@material/menu-surface/adapter';
    import { Corner } from '@material/menu-surface/constants';
    import { MDCMenuDistance } from '@material/menu-surface/types';
    export class MDCMenuSurfaceFoundation extends MDCFoundation<MDCMenuSurfaceAdapter> {
            static get cssClasses(): {
                    ANCHOR: string;
                    ANIMATING_CLOSED: string;
                    ANIMATING_OPEN: string;
                    FIXED: string;
                    IS_OPEN_BELOW: string;
                    OPEN: string;
                    ROOT: string;
            };
            static get strings(): {
                    CLOSED_EVENT: string;
                    CLOSING_EVENT: string;
                    OPENED_EVENT: string;
                    FOCUSABLE_ELEMENTS: string;
            };
            static get numbers(): {
                    TRANSITION_OPEN_DURATION: number;
                    TRANSITION_CLOSE_DURATION: number;
                    MARGIN_TO_EDGE: number;
                    ANCHOR_TO_MENU_SURFACE_WIDTH_RATIO: number;
            };
            static get Corner(): typeof Corner;
            /**
                * @see {@link MDCMenuSurfaceAdapter} for typing information on parameters and return types.
                */
            static get defaultAdapter(): MDCMenuSurfaceAdapter;
            constructor(adapter?: Partial<MDCMenuSurfaceAdapter>);
            init(): void;
            destroy(): void;
            /**
                * @param corner Default anchor corner alignment of top-left menu surface corner.
                */
            setAnchorCorner(corner: Corner): void;
            /**
                * Flip menu corner horizontally.
                */
            flipCornerHorizontally(): void;
            /**
                * @param margin Set of margin values from anchor.
                */
            setAnchorMargin(margin: Partial<MDCMenuDistance>): void;
            /** Used to indicate if the menu-surface is hoisted to the body. */
            setIsHoisted(isHoisted: boolean): void;
            /** Used to set the menu-surface calculations based on a fixed position menu. */
            setFixedPosition(isFixedPosition: boolean): void;
            /** Sets the menu-surface position on the page. */
            setAbsolutePosition(x: number, y: number): void;
            setQuickOpen(quickOpen: boolean): void;
            isOpen(): boolean;
            /**
                * Open the menu surface.
                */
            open(): void;
            /**
                * Closes the menu surface.
                */
            close(skipRestoreFocus?: boolean): void;
            /** Handle clicks and close if not within menu-surface element. */
            handleBodyClick(evt: MouseEvent): void;
            /** Handle keys that close the surface. */
            handleKeydown(evt: KeyboardEvent): void;
    }
    export default MDCMenuSurfaceFoundation;
}

declare module '@material/menu-surface/types' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export interface MDCMenuDimensions {
        width: number;
        height: number;
    }
    export interface MDCMenuDistance {
        top: number;
        right: number;
        bottom: number;
        left: number;
    }
    export interface MDCMenuPoint {
        x: number;
        y: number;
    }
}

