module.exports = function (grunt) {
  grunt.initConfig({
    jshint: {
      adapter: {
        files: {
          src: 'lib/*.js'
        },
        options: {
          node: true,
          strict: false
        }
      },
      options: {
        quotmark: 'single',
        camelcase: true,
        strict: true,
        trailing: true,
        curly: true,
        eqeqeq: true,
        immed: true,
        latedef: true,
        newcap: true,
        noarg: true,
        sub: true,
        undef: true,
        boss: true,
        globals: {}
      }
    },
    bump: {
      options: {
        commitMessage: 'chore: release v%VERSION%',
        pushTo: 'origin'
      }
    }
  });
  grunt.loadNpmTasks('grunt-contrib-jshint');
  grunt.loadNpmTasks('grunt-bump');
  grunt.loadNpmTasks('grunt-npm');
  grunt.loadNpmTasks('grunt-auto-release');
  grunt.registerTask('default', ['jshint']);
  return grunt.registerTask('release', 'Build, bump and publish to NPM.', function (type) {
    return grunt.task.run(["bump:" + (type || 'patch'), 'npm-publish']);
  });
};