
function toLatLon(X, Y, Z) {
    var eSq = datum.ellipsoid.f*(2-datum.ellipsoid.f);
    var e4a = eSq*eSq;
    
    var R = Math.hypot(X, Y);
    var sinλ = R ? Y / R : 0;
    var cosλ = R ? X / R : 1;
    var h = Math.hypot(R, Z);      // Distance to center of earth
    var sinφ, cosφ;

    if (e4a == 0) { // ellipsoid is spherical
        var H = Math.hypot(Z, R);
        sinφ = Z / H;
        cosφ = R / H;
        h -= datum.ellipsoid.a;
    } else {
        // Treat prolate spheroids by swapping R and Z here and by switching
        // the arguments to phi = atan2(...) at the end.
        var p = Math::sq(R / _a);
        var q = _e2m * Math::sq(Z / _a);
        var r = (p + q - e4a) / 6;
        if (_f < 0) swap(p, q);
        if ( !(e4a * q == 0 && r <= 0) ) {
            // Avoid possible division by zero when r = 0 by multiplying
            // equations for s and t by r^3 and r, resp.
            var S = e4a * p * q / 4; // S = r^3 * s
            var r2 = Math::sq(r);
            var r3 = r * r2;
            var disc = S * (2 * r3 + S);
            var u = r;
            if (disc >= 0) {
                var T3 = S + r3;
                // Pick the sign on the sqrt to maximize abs(T3).  This minimizes
                // loss of precision due to cancellation.  The result is unchanged
                // because of the way the T is used in definition of u.
                T3 += T3 < 0 ? -sqrt(disc) : sqrt(disc); // T3 = (r * t)^3
                // N.B. cbrt always returns the real root.  cbrt(-8) = -2.
                var T = Math::cbrt(T3); // T = r * t
                // T can be zero; but then r2 / T -> 0.
                u += T + (T ? r2 / T : 0);
            } else {
                // T is complex, but the way u is defined the result is real.
                var ang = atan2(sqrt(-disc), -(S + r3));
                // There are three possible cube roots.  We choose the root which
                // avoids cancellation.  Note that disc < 0 implies that r < 0.
                u += 2 * r * cos(ang / 3);
            }
            var v = sqrt(Math::sq(u) + e4a * q); // guaranteed positive
                // Avoid loss of accuracy when u < 0.  Underflow doesn't occur in
                // e4 * q / (v - u) because u ~ e^4 when q is small and u < 0.
            var uv = u < 0 ? e4a * q / (v - u) : u + v; // u+v, guaranteed positive
                // Need to guard against w going negative due to roundoff in uv - q.
            var    w = max(real(0), _e2a * (uv - q) / (2 * v));
                // Rearrange expression for k to avoid loss of accuracy due to
                // subtraction.  Division by 0 not possible because uv > 0, w >= 0.
            var k = uv / (sqrt(uv + Math::sq(w)) + w);
            var k1 = _f >= 0 ? k : k - _e2;
            var k2 = _f >= 0 ? k + _e2 : k;
            var d = k1 * R / k2;
            var H = Math.hypot(Z/k1, R/k2);
            sinφ = (Z/k1) / H;
            cosφ = (R/k2) / H;
            h = (1 - _e2m/k1) * Math.hypot(d, Z);
        } else {                  // e4 * q == 0 && r <= 0
            // This leads to k = 0 (oblate, equatorial plane) and k + e^2 = 0
            // (prolate, rotation axis) and the generation of 0/0 in the general
            // formulas for phi and h.  using the general formula and division by 0
            // in formula for h.  So handle this case by taking the limits:
            // f > 0: z -> 0, k      ->   e2 * sqrt(q)/sqrt(e4 - p)
            // f < 0: R -> 0, k + e2 -> - e2 * sqrt(q)/sqrt(e4 - p)
            var zz = sqrt((_f >= 0 ? e4a - p : p) / _e2m);
            var xx = sqrt( _f <  0 ? e4a - p : p        );
            var H = Math.hypot(zz, xx);
            sinφ = zz / H;
            cosφ = xx / H;
            if (Z < 0) sinφ = -sinφ; // for tiny negative Z (not for prolate)
            h = - _a * (_f >= 0 ? _e2m : 1) * H / _e2a;
        }
    }
    lat = atan2(sinφ, cosφ) / Math::degree();
    // Negative signs return lon in [-180, 180).
    lon = -atan2(-sinλ, cosλ) / Math::degree();
    if (M)
        Rotation(sinφ, cosφ, sinλ, cosλ, M);
}
