(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('file-saver'), require('xlsx')) :
	typeof define === 'function' && define.amd ? define(['exports', 'file-saver', 'xlsx'], factory) :
	(global = global || self, factory(global.ExportExcel = {}, global.FileSaver, global.XLSX));
}(this, function (exports, FileSaver, XLSX) { 'use strict';

	FileSaver = FileSaver && FileSaver.hasOwnProperty('default') ? FileSaver['default'] : FileSaver;
	XLSX = XLSX && XLSX.hasOwnProperty('default') ? XLSX['default'] : XLSX;

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	(function (view) {

	  view.URL = view.URL || view.webkitURL;

	  if (view.Blob && view.URL) {
	    try {
	      new Blob();
	      return;
	    } catch (e) {}
	  } // Internally we use a BlobBuilder implementation to base Blob off of
	  // in order to support older browsers that only have BlobBuilder


	  var BlobBuilder = view.BlobBuilder || view.WebKitBlobBuilder || view.MozBlobBuilder || function (view) {
	    var get_class = function get_class(object) {
	      return Object.prototype.toString.call(object).match(/^\[object\s(.*)\]$/)[1];
	    },
	        FakeBlobBuilder = function BlobBuilder() {
	      this.data = [];
	    },
	        FakeBlob = function Blob(data, type, encoding) {
	      this.data = data;
	      this.size = data.length;
	      this.type = type;
	      this.encoding = encoding;
	    },
	        FBB_proto = FakeBlobBuilder.prototype,
	        FB_proto = FakeBlob.prototype,
	        FileReaderSync = view.FileReaderSync,
	        FileException = function FileException(type) {
	      this.code = this[this.name = type];
	    },
	        file_ex_codes = ('NOT_FOUND_ERR SECURITY_ERR ABORT_ERR NOT_READABLE_ERR ENCODING_ERR ' + 'NO_MODIFICATION_ALLOWED_ERR INVALID_STATE_ERR SYNTAX_ERR').split(' '),
	        file_ex_code = file_ex_codes.length,
	        real_URL = view.URL || view.webkitURL || view,
	        real_create_object_URL = real_URL.createObjectURL,
	        real_revoke_object_URL = real_URL.revokeObjectURL,
	        URL = real_URL,
	        btoa = view.btoa,
	        atob = view.atob,
	        ArrayBuffer = view.ArrayBuffer,
	        Uint8Array = view.Uint8Array;

	    FakeBlob.fake = FB_proto.fake = true;

	    while (file_ex_code--) {
	      FileException.prototype[file_ex_codes[file_ex_code]] = file_ex_code + 1;
	    }

	    if (!real_URL.createObjectURL) {
	      URL = view.URL = {};
	    }

	    URL.createObjectURL = function (blob) {
	      var type = blob.type,
	          data_URI_header;

	      if (type === null) {
	        type = 'application/octet-stream';
	      }

	      if (blob instanceof FakeBlob) {
	        data_URI_header = 'data:' + type;

	        if (blob.encoding === 'base64') {
	          return data_URI_header + ';base64,' + blob.data;
	        } else if (blob.encoding === 'URI') {
	          return data_URI_header + ',' + decodeURIComponent(blob.data);
	        }

	        if (btoa) {
	          return data_URI_header + ';base64,' + btoa(blob.data);
	        } else {
	          return data_URI_header + ',' + encodeURIComponent(blob.data);
	        }
	      } else if (real_create_object_URL) {
	        return real_create_object_URL.call(real_URL, blob);
	      }
	    };

	    URL.revokeObjectURL = function (object_URL) {
	      if (object_URL.substring(0, 5) !== 'data:' && real_revoke_object_URL) {
	        real_revoke_object_URL.call(real_URL, object_URL);
	      }
	    };

	    FBB_proto.append = function (data
	    /*, endings*/
	    ) {
	      var bb = this.data; // decode data to a binary string

	      if (Uint8Array && (data instanceof ArrayBuffer || data instanceof Uint8Array)) {
	        var str = '',
	            buf = new Uint8Array(data),
	            i = 0,
	            buf_len = buf.length;

	        for (; i < buf_len; i++) {
	          str += String.fromCharCode(buf[i]);
	        }

	        bb.push(str);
	      } else if (get_class(data) === 'Blob' || get_class(data) === 'File') {
	        if (FileReaderSync) {
	          var fr = new FileReaderSync();
	          bb.push(fr.readAsBinaryString(data));
	        } else {
	          // async FileReader won't work as BlobBuilder is sync
	          throw new FileException('NOT_READABLE_ERR');
	        }
	      } else if (data instanceof FakeBlob) {
	        if (data.encoding === 'base64' && atob) {
	          bb.push(atob(data.data));
	        } else if (data.encoding === 'URI') {
	          bb.push(decodeURIComponent(data.data));
	        } else if (data.encoding === 'raw') {
	          bb.push(data.data);
	        }
	      } else {
	        if (typeof data !== 'string') {
	          data += ''; // convert unsupported types to strings
	        } // decode UTF-16 to binary string


	        bb.push(unescape(encodeURIComponent(data)));
	      }
	    };

	    FBB_proto.getBlob = function (type) {
	      if (!arguments.length) {
	        type = null;
	      }

	      return new FakeBlob(this.data.join(''), type, 'raw');
	    };

	    FBB_proto.toString = function () {
	      return '[object BlobBuilder]';
	    };

	    FB_proto.slice = function (start, end, type) {
	      var args = arguments.length;

	      if (args < 3) {
	        type = null;
	      }

	      return new FakeBlob(this.data.slice(start, args > 1 ? end : this.data.length), type, this.encoding);
	    };

	    FB_proto.toString = function () {
	      return '[object Blob]';
	    };

	    FB_proto.close = function () {
	      this.size = this.data.length = 0;
	    };

	    return FakeBlobBuilder;
	  }(view);

	  view.Blob = function Blob(blobParts, options) {
	    var type = options ? options.type || '' : '';
	    var builder = new BlobBuilder();

	    if (blobParts) {
	      for (var i = 0, len = blobParts.length; i < len; i++) {
	        builder.append(blobParts[i]);
	      }
	    }

	    return builder.getBlob(type);
	  };
	})(typeof self !== 'undefined' && self || typeof window !== 'undefined' && window || commonjsGlobal.content || commonjsGlobal);

	/* eslint-disable */
	var RANGE_KEY = '!ref'; // sheet范围key，没有内容的sheet没有!ref属性

	var IMPORT_ERR_MSG = '导入失败，请检查文件！';
	var basedate = new Date(1899, 11, 30, 0, 0, 0); // 2209161600000

	var dnthresh = basedate.getTime() + (new Date().getTimezoneOffset() - basedate.getTimezoneOffset()) * 60000;

	function datenum(v, date1904) {
	  var epoch = v.getTime();
	  if (date1904) epoch -= 1462 * 24 * 60 * 60 * 1000;
	  return (epoch - dnthresh) / (24 * 60 * 60 * 1000);
	} // 解析excel的日期时间


	function parseDate(dateCode) {
	  var _XLSX$SSF$parse_date_ = XLSX.SSF.parse_date_code(dateCode),
	      y = _XLSX$SSF$parse_date_.y,
	      m = _XLSX$SSF$parse_date_.m,
	      d = _XLSX$SSF$parse_date_.d,
	      H = _XLSX$SSF$parse_date_.H,
	      M = _XLSX$SSF$parse_date_.M,
	      S = _XLSX$SSF$parse_date_.S;

	  return new Date("".concat(y, "/").concat(m, "/").concat(d, " ").concat(H, ":").concat(M, ":").concat(S)).getTime();
	}
	/**
	 * 将传进来的二维数组处理成xlsx需要的数据格式
	 * @param data [[], ..., []]
	 * @return {{}}
	 */


	function sheet_from_array_of_arrays(data) {
	  var worksheet = {}; // s: 开始的行数，列数
	  // e: 结束的行数，列数

	  var range = {
	    s: {
	      c: 0,
	      r: 0
	    },
	    e: {
	      c: 0,
	      r: data.length
	    }
	  };

	  for (var R = 0; R !== data.length; ++R) {
	    for (var C = 0; C !== data[R].length; ++C) {
	      // 结束取最大值
	      if (range.e.c < C) range.e.c = C;
	      var cell = {
	        v: data[R][C]
	      };
	      if (cell.v === null || cell.v === undefined) continue; // 单元格地址B5由对象表示{c:1, r:4}

	      var cell_ref = XLSX.utils.encode_cell({
	        c: C,
	        r: R
	      }); // 格式化 number, boolean, Date

	      if (typeof cell.v === 'number') cell.t = 'n';else if (typeof cell.v === 'boolean') cell.t = 'b';else if (cell.v instanceof Date) {
	        cell.t = 'n';
	        cell.z = XLSX.SSF._table[14];
	        cell.v = datenum(cell.v);
	      } else cell.t = 's';
	      worksheet[cell_ref] = cell;
	    }
	  } // 设置填充区域


	  worksheet[RANGE_KEY] = XLSX.utils.encode_range(range);
	  return worksheet;
	}
	/**
	 * 创建工作表对象
	 * @return {Workbook}
	 * @constructor
	 */


	function Workbook() {
	  if (!(this instanceof Workbook)) return new Workbook();
	  this.SheetNames = [];
	  this.Sheets = {};
	}
	/**
	 * 将字符串转字符流
	 * @param str 需要转换的字符串
	 * @return {ArrayBuffer}
	 */


	function s2ab(str) {
	  var buf = new ArrayBuffer(str.length);
	  var view = new Uint8Array(buf);

	  for (var i = 0; i !== str.length; ++i) {
	    view[i] = str.charCodeAt(i) & 0xff;
	  }

	  return buf;
	}
	/**
	 * 将json转换为字符串
	 * @param columns Array excel表头数组，数据格式为[{label: '', props: ''}] 与element-ui table传入的数据格式一致
	 * @param data Array excel内容数组，数据格式字段名称需要跟props一致 与element-ui table传入的数据格式一致
	 * @param fileName String 文件名 default download
	 * @param header String 导出的表头名
	 * @param merges Array 导出的表头合并的单元格, 数据格式['A1', 'E1']， 表示合并从A1到E1的单元格
	 * @param callback Function 成功后的回调
	 */


	function exportExcel(_ref) {
	  var _ref$columns = _ref.columns,
	      columns = _ref$columns === void 0 ? [] : _ref$columns,
	      _ref$data = _ref.data,
	      data = _ref$data === void 0 ? [] : _ref$data,
	      _ref$fileName = _ref.fileName,
	      fileName = _ref$fileName === void 0 ? 'download' : _ref$fileName,
	      _ref$header = _ref.header,
	      header = _ref$header === void 0 ? null : _ref$header,
	      _ref$merges = _ref.merges,
	      merges = _ref$merges === void 0 ? [] : _ref$merges;
	  var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {};
	  // 处理数据格式
	  var head = columns.map(function (e) {
	    return e.label;
	  });
	  var data2D = data.map(function (row) {
	    return columns.map(function (col) {
	      return row[col.prop];
	    });
	  });
	  data2D.unshift(head);

	  if (header) {
	    data2D.unshift([header]);
	  }

	  var worksheetName = 'Sheet';
	  var workbook = new Workbook(),
	      worksheet = sheet_from_array_of_arrays(data2D);
	  if (typeof merges[0] === 'string' && merges.length === 2) merges = [merges]; // just one # ['A1', 'C1'] = > [['A1', 'C1']]

	  merges = merges.map(function (i) {
	    return i instanceof Array ? {
	      s: i[0],
	      e: i[1]
	    } : i;
	  }); // be sort :) # ['A1', 'C1'] => { s: 'A1', e: 'C3' }

	  worksheet['!merges'] = merges;
	  workbook.SheetNames.push(worksheetName);
	  workbook.Sheets[worksheetName] = worksheet;
	  var workbookOut = XLSX.write(workbook, {
	    bookType: 'xlsx',
	    bookSST: false,
	    type: 'binary'
	  });
	  FileSaver.saveAs(new Blob([s2ab(workbookOut)], {
	    type: 'application/octet-stream'
	  }), fileName + '.xlsx');
	  callback();
	}
	/**
	 * 兼容模拟点击 兼容Firefox 47.0.2 and 62.0.2.
	 * @param node dom节点
	 */

	function click(node) {
	  try {
	    node.dispatchEvent(new MouseEvent('click'));
	  } catch (e) {
	    var evt = document.createEvent('MouseEvents');
	    evt.initMouseEvent('click', true, true, window, 0, 0, 0, 80, 20, false, false, false, false, 0, null);
	    node.dispatchEvent(evt);
	  }
	}
	/**
	 * 将xlsx文件转为json对象，json对象格式为：{columns: [{label: '', props: ''}], data: [数据格式字段名称需要跟props一致 与element-ui table传入的数据格式一致]}
	 * @param callback Function 返回数据为多个sheet的数据，数据格式为[{columns:[...],data:[[...],...]}, ...]
	 * @param ignore Array 需要忽略的单元格范围 eg: ['A1', 'K1']，默认不忽略
	 */


	function importExcel() {
	  var ignore = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
	  var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {};
	  var inputId = 'import-excel-input'; // 支持的导入的数据类型

	  var supportFileType = ['application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'];
	  var input = document.getElementById(inputId);

	  if (!input || input.type !== 'file') {
	    input = document.createElement('input');
	    input.id = inputId;
	    input.type = 'file';
	    input.accept = supportFileType.join(',');
	    input.style.display = 'none';
	    document.getElementsByTagName('body')[0].append(input);
	  }

	  input.onchange = function (e) {
	    if (e.target.files && e.target.files.length) {
	      // 判断文件类型
	      var file = e.target.files[0]; // 重置上传文本框值

	      input.value = '';
	      parseExcel(file, ignore, callback);
	    }
	  };

	  setTimeout(function () {
	    click(input);
	  });
	}
	function parseExcel(file) {
	  var ignore = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
	  var callback = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : function () {};

	  if (!checkExcelFile(file.name)) {
	    alert('文件类型必须是.xlsx,xls中的一种');
	    return;
	  } // 支持Safari6.0以上，Opera12.02以上，IE10以上，chrome7以上


	  var reader = new FileReader();

	  reader.onload = function (e) {
	    var sheetTable = null;

	    try {
	      sheetTable = _parseExcel(e.target.result);
	    } catch (err) {
	      alert(IMPORT_ERR_MSG);
	    } // callback在try外执行，否则callback报的错也会被catch


	    if (sheetTable !== null) {
	      callback(sheetTable);
	    }
	  };

	  reader.onerror = function () {
	    alert(IMPORT_ERR_MSG);
	  }; // 读取文件的 ArrayBuffer 数据对象 ArrayBuffer 对象用来表示通用的、固定长度的原始二进制数据缓冲区


	  reader.readAsArrayBuffer(file);
	  /**
	   * 根据文件名判断是否为excel文件
	   * @param filename 文件名
	   * @return {boolean} true: 为excel文件 false: 不为excel文件
	   */

	  function checkExcelFile(filename) {
	    if (!filename) return false;
	    var suffix = filename.substr(filename.lastIndexOf('.'));
	    return '.xls' === suffix || '.xlsx' === suffix;
	  }
	  /**
	   * 将ArrayBuffer 数据对象处理为字符串 http://javascript.ruanyifeng.com/stdlib/arraybuffer.html
	   * @param data ArrayBuffer 数据
	   */


	  var fixdata = function fixdata(data) {
	    var str = '';
	    var l = 0;
	    var w = 10240;

	    for (; l < data.byteLength / w; ++l) {
	      str += String.fromCharCode.apply(null, new Uint8Array(data.slice(l * w, l * w + w)));
	    }

	    str += String.fromCharCode.apply(null, new Uint8Array(data.slice(l * w)));
	    return str;
	  };
	  /**
	   * 获取头部项
	   * @param sheet worksheet数据
	   * @return {Array}
	   */


	  var getHeaderRow = function getHeaderRow(sheet) {
	    var headers = [];
	    var range = XLSX.utils.decode_range(sheet[RANGE_KEY]);
	    var C;
	    var R = range.s.r;

	    for (C = range.s.c; C <= range.e.c; ++C) {
	      var cell = sheet[XLSX.utils.encode_cell({
	        c: C,
	        r: R
	      })];

	      if (cell && cell.t) {
	        headers.push(XLSX.utils.format_cell(cell));
	      }
	    }

	    return headers;
	  }; // 解析excel 生成数组数据


	  function _parseExcel(data) {
	    var fixedData = fixdata(data); // btoa是binary to ascii 将binary的数据用ascii码表示

	    var workbook = XLSX.read(btoa(fixedData), {
	      type: 'base64'
	    }); // 读取多个sheet表

	    var sheetTable = [];
	    var sheetList = workbook.Sheets;

	    if (sheetList) {
	      Object.keys(sheetList).forEach(function (key) {
	        var worksheet = sheetList[key];

	        if (RANGE_KEY in worksheet) {
	          if (ignore && ignore.length) {
	            var wsRefArr = worksheet[RANGE_KEY].split(':');
	            var startCellRowNum = ignore[0].replace(/[a-zA-Z]+/, '') || 0;
	            var startCellRowStr = ignore[0].replace(/[0-9]+/, '') || 'A';
	            var endCellRowNum = ignore[1].replace(/[a-zA-Z]+/, '') || 0;
	            var maxNum = startCellRowNum > endCellRowNum ? startCellRowNum : endCellRowNum;
	            worksheet[RANGE_KEY] = "".concat(startCellRowStr).concat(+maxNum + 1, ":").concat(wsRefArr[1]);
	          } // 将时间格式处理为字符串 todo 读取excel中date格式的时候，有时候t值会是'n', 而不是'd'，
	          // 通过判断cell中的t值为'n'的时候，判断'v'值是否跟'w'值是否相同来判断cell中的数值类型为date


	          Object.keys(worksheet).forEach(function (key) {
	            if (worksheet[key].t === 'd' || worksheet[key].t === 'n' && String(worksheet[key].v) !== worksheet[key].w) {
	              worksheet[key].v = parseDate(worksheet[key].v);
	            }
	          });
	          var columns = getHeaderRow(worksheet) || [];

	          var _data = XLSX.utils.sheet_to_json(worksheet) || {};

	          sheetTable.push({
	            columns: columns,
	            data: _data
	          });
	        }
	      });
	    }

	    return sheetTable;
	  }
	}

	exports.exportExcel = exportExcel;
	exports.importExcel = importExcel;
	exports.parseExcel = parseExcel;

	Object.defineProperty(exports, '__esModule', { value: true });

}));
