/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
import '../iron-dropdown.js';

import './grow-height-animation.js';
import '@polymer/neon-animation/animations/fade-in-animation.js';
import '@polymer/neon-animation/animations/fade-out-animation.js';
import {Polymer} from '@polymer/polymer/lib/legacy/polymer-fn.js';
import {html} from '@polymer/polymer/lib/utils/html-tag.js';
Polymer({
  _template: html`
    <style>
      :host {
        display: inline-block;
        margin: 1em;
      }
    </style>
    <div on-tap="open">
      <slot name="dropdown-trigger"></slot>
    </div>
    <iron-dropdown id="dropdown" vertical-align="[[verticalAlign]]" horizontal-align="[[horizontalAlign]]" disabled="[[disabled]]" scroll-action="[[scrollAction]]" open-animation-config="[[openAnimationConfig]]" close-animation-config="[[closeAnimationConfig]]">
      <slot name="dropdown-content" slot="dropdown-content"></slot>
    </iron-dropdown>
`,

  is: 'x-select',

  properties: {
    verticalAlign: String,
    horizontalAlign: String,
    disabled: Boolean,
    scrollAction: String,
    openAnimationConfig: {
      type: Array,
      value: function() {
        return [
          {name: 'fade-in-animation', timing: {delay: 150, duration: 50}},
          {name: 'expand-animation', timing: {delay: 150, duration: 200}}
        ];
      }
    },

    closeAnimationConfig: {
      type: Array,
      value: function() {
        return [{name: 'fade-out-animation', timing: {duration: 200}}];
      }
    }
  },

  open: function() {
    this.$.dropdown.open();
  }
});
