# fullPage.js
![preview](https://raw.github.com/alvarotrigo/fullPage.js/master/examples/imgs/intro.png)
![compatibility](https://raw.github.com/alvarotrigo/fullPage.js/master/examples/imgs/compatible.gif?v=2)

<p align="center">
  <a href="https://github.com/alvarotrigo/fullPage.js">English</a> |
  <a href="https://github.com/alvarotrigo/fullPage.js/tree/master/lang/spanish#fullpagejs">Español</a> |
  <a href="https://github.com/alvarotrigo/fullPage.js/tree/master/lang/russian#fullpagejs">Pусский</a> |
  <span>中文</span> |
  <a href="https://github.com/alvarotrigo/fullPage.js/tree/master/lang/korean#fullpagejs">한국어</a>
</p>

---

![fullPage.js version](http://img.shields.io/badge/fullPage.js-v2.9.7-brightgreen.svg)
[![License](http://img.shields.io/badge/License-MIT-blue.svg)](http://opensource.org/licenses/MIT)
[![PayPal Donate](https://img.shields.io/badge/donate-PayPal.me-ff69b4.svg)](https://www.paypal.me/alvarotrigo/9.95)
[![jsDelivr Hits](https://data.jsdelivr.com/v1/package/npm/fullpage.js/badge?style=rounded)](https://www.jsdelivr.com/package/npm/fullpage.js)
&nbsp;&nbsp; **|**&nbsp;&nbsp; *7Kb gziped* &nbsp;&nbsp;**|**&nbsp;&nbsp; *Created by [@imac2](https://twitter.com/imac2)*

- [现场演示](http://alvarotrigo.com/fullPage/)
- [Wordpress 的主题](http://alvarotrigo.com/fullPage/utils/wordpress.html)
- [fullpage.js扩展](http://alvarotrigo.com/fullPage/extensions/)
- [常见问题](https://github.com/alvarotrigo/fullPage.js/wiki/FAQ---Frequently-Answered-Questions)

---

通过调用本库可轻易创建全屏滚动网站（也称为单页网站）。
本库可创建全屏滚动网站，同时也可在网站中添加横向滚动条。

请我喝杯咖啡
[![赞赏](https://www.paypalobjects.com/en_US/GB/i/btn/btn_donateCC_LG.gif)](https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=BEK5JQCQMED4J&lc=GB&item_name=fullPage%2ejs&currency_code=USD&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted)

根据要求，可提供模块定制和紧急更改服务，价格合理。。
<a href="http://alvarotrigo.com/#contact-page"> 联系我</a>.

- [介绍](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E4%BB%8B%E7%BB%8D)
- [兼容性](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E5%85%BC%E5%AE%B9%E6%80%A7)
- [用法](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E7%94%A8%E6%B3%95)
  - [创建链接到段落或幻灯片](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E5%88%9B%E5%BB%BA%E9%93%BE%E6%8E%A5%E5%88%B0%E6%AE%B5%E8%90%BD%E6%88%96%E5%B9%BB%E7%81%AF%E7%89%87)
  - [创建更小或更大的段落](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E5%88%9B%E5%BB%BA%E6%9B%B4%E5%B0%8F%E6%88%96%E6%9B%B4%E5%A4%A7%E7%9A%84%E6%AE%B5%E8%90%BD)
  - [fullpage.js添加的状态类](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E7%94%B1fullpagejs%E6%B7%BB%E5%8A%A0%E7%9A%84%E7%8A%B6%E6%80%81%E7%B1%BB)
  - [快速加载](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E5%BB%B6%E8%BF%9F%E5%8A%A0%E8%BD%BD)
  - [自动播放内嵌媒体](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E8%87%AA%E5%8A%A8%E6%92%AD%E6%94%BE%E6%9A%82%E5%81%9C%E5%B5%8C%E5%85%A5%E5%BC%8F%E5%AA%92%E4%BD%93)
  - [使用扩展](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E4%BD%BF%E7%94%A8%E6%89%A9%E5%B1%95)
- [选项](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E9%80%89%E9%A1%B9)
- [方法](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E6%96%B9%E6%B3%95)
- [回调](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#callbacks)
- [报告问题](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E6%8A%A5%E5%91%8A%E9%97%AE%E9%A2%98)
- [完善fullpage.js](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E8%B4%A1%E7%8C%AE%E7%BB%99fullpagejs)
- [变更日志](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E6%9B%B4%E6%96%B0%E6%97%A5%E5%BF%97)
- [创建任务](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E6%9E%84%E5%BB%BA%E4%BB%BB%E5%8A%A1)
- [资源](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E5%8F%82%E8%80%83%E8%B5%84%E6%BA%90)
- [谁在使用fullpage.js](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E8%B0%81%E5%9C%A8%E4%BD%BF%E7%94%A8-fullpagejs)
- [赞赏](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E6%8D%90%E7%8C%AE)
- [许可证](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E8%AE%B8%E5%8F%AF%E8%AF%81)

## 介绍
不仅限于提需求，也欢迎提出编码风格改进的建议。
集思广益，让这个库更加强大，让写代码更轻松！

## 兼容性
fullPage.js在所有的现代浏览器，以及一些旧版浏览器，如Internet Explorer 8，9，Opera 12等都能兼容。
可兼容支持CSS3的浏览器与非支持CSS3的浏览器，适用于旧版浏览器。 同时，手机、平板电脑和触摸屏电脑还提供触屏支持。

[![Browserstack](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/browserstack2.png)](http://www.browserstack.com/)

特别感谢[Browserstack](http://www.browserstack.com/) 支持fullpage.js。

## 用法
正如示例文件所示，需要引用：
 - [jQuery库](http://jquery.com/). (最低1.6.0)
 - JavaScript 文件`jquery.fullPage.js` (或其缩小版本 `jquery.fullPage.min.js`)
 - css 文件`jquery.fullPage.css`

 **或者**，当调用`css3:false`, 时，如果想调用jQuery库中(`linear` and `swing` )或fullPage.js (`easeInOutCubic`)中默认包含的其他缓和效果控件，可添加[jQuery UI库](http://jqueryui.com/) 。

### 使用bower或npm进行安装
**或者**，如果您愿意，可以使用bower或npm安装fullPage.js：

终端：
```shell
// 使用bower
bower install fullpage.js

// 使用npm
npm install fullpage.js
```

### 包含文件：
```html
<link rel="stylesheet" type="text/css" href="jquery.fullPage.css" />

<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>

<!-- 以下行是可选的。 只有在使用选项css3:false，并且您希望使用其他缓动效果，而非“linear”、“swing”或“easeInOutCubic”时才有必要。 -->
<script src="vendors/jquery.easings.min.js"></script>


<!-- 以下行仅在使用选项scrollOverflow:true的情况下是必需的 -->
<script type="text/javascript" src="vendors/scrolloverflow.min.js"></script>

<script type="text/javascript" src="jquery.fullPage.js"></script>
```

### 可选用CDN：
如果您倾向使用CDN载入所需文件，fullPage.js在CDNJS：
https://cdnjs.com/libraries/fullPage.js

### 要求HTML结构
HTML文件中的首行HTML代码必须使用[HTML DOCTYPE 声明](http://www.corelangs.com/html/introduction/doctype.html)，否则可能会遇到代码段高度问题。HTML 5 doctype中的示例： `<!DOCTYPE html>`.

每个代码段定义为包含`section`类的元素。
第一个代码段作为主页，是默认激活代码。
代码段应进行封装（即`<div id="fullpage">` ）。 封装不能是`body`元素。

```html
<div id="fullpage">
	<div class="section">Some section</div>
	<div class="section">Some section</div>
	<div class="section">Some section</div>
	<div class="section">Some section</div>
</div>
```
如果你想定义一个与众不同的起始页面，而不是原始第一段或第一个滑动页，只需将`active`类添加到你想首先载入的段或滑动页。
```html
<div class="section active">Some section</div>
```
为在代码段中创建横向滑块，每个滑动页将默认定义为包含`slide`类的元素：

```html
<div class="section">
	<div class="slide"> 幻灯片 1 </div>
	<div class="slide"> 幻灯片 2 </div>
	<div class="slide"> 幻灯片 3 </div>
	<div class="slide"> 幻灯片 4 </div>
</div>
````
可以在[`demoPage.html`文件](https://github.com/alvarotrigo/fullPage.js/tree/master/examples/demoPage.html)看到完整的HTML结构的例子

### 初始化
你所需要做的就是在`$(document).ready`函数中调用fullPage.js：

```javascript
$(document).ready(function() {
	$('#fullpage').fullpage();
});
```

所有选项设置的更复杂的初始化如下所示：
```javascript
$(document).ready(function() {
	$('#fullpage').fullpage({
		//导航
		menu: '#menu',
		lockAnchors: false,
		anchors:['firstPage', 'secondPage'],
		navigation: false,
		navigationPosition: 'right',
		navigationTooltips: ['firstSlide', 'secondSlide'],
		showActiveTooltip: false,
		slidesNavigation: false,
		slidesNavPosition: 'bottom',

		//滚动
		css3: true,
		scrollingSpeed: 700,
		autoScrolling: true,
		fitToSection: true,
		fitToSectionDelay: 1000,
		scrollBar: false,
		easing: 'easeInOutCubic',
		easingcss3: 'ease',
		loopBottom: false,
		loopTop: false,
		loopHorizontal: true,
		continuousVertical: false,
		continuousHorizontal: false,
		scrollHorizontally: false,
		interlockedSlides: false,
		dragAndMove: false,
		offsetSections: false,
		resetSliders: false,
		fadingEffect: false,
		normalScrollElements: '#element1, .element2',
		scrollOverflow: false,
		scrollOverflowReset: false,
		scrollOverflowOptions: null,
		touchSensitivity: 15,
		normalScrollElementTouchThreshold: 5,
		bigSectionsDestination: null,

		//可访问
		keyboardScrolling: true,
		animateAnchor: true,
		recordHistory: true,

		//设计
		controlArrows: true,
		verticalCentered: true,
		sectionsColor : ['#ccc', '#fff'],
		paddingTop: '3em',
		paddingBottom: '10px',
		fixedElements: '#header, .footer',
		responsiveWidth: 0,
		responsiveHeight: 0,
		responsiveSlides: false,
		parallax: false,
		parallaxOptions: {type: 'reveal', percentage: 62, property: 'translate'},

		//自定义选择器
		sectionSelector: '.section',
		slideSelector: '.slide',

		lazyLoading: true,

		//事件
		onLeave: function(index, nextIndex, direction){},
		afterLoad: function(anchorLink, index){},
		afterRender: function(){},
		afterResize: function(){},
		afterResponsive: function(isResponsive){},
		afterSlideLoad: function(anchorLink, index, slideAnchor, slideIndex){},
		onSlideLeave: function(anchorLink, index, slideIndex, direction, nextSlideIndex){}
	});
});
```

### 创建链接到段落或幻灯片
如果你在段落中使用fullPage.js和锚链接（在每个部分使用`anchors`选项或属性`data-anchor`），那么你将能够在一个段落里使用锚链接直接导航到某个幻灯片。

这是一个锚链接的例子：
http://alvarotrigo.com/fullPage/#secondPage/2 （在你手动访问该段落/幻灯片就会看到的URL）
请注意，URL的最后部分以`＃secondPage / 2`结尾。

以下初始化：

```javascript
$(document).ready(function() {
	$('#fullpage').fullpage({
		anchors:['firstPage', 'secondPage', 'thirdPage']
	});
});
```

URL`#secondPage/2` 结尾处的锚分别定义了目标段落和幻灯片。 在前面的URL中，目标段落将是使用锚点 `secondPage` 定义的段落，幻灯片将会是第2张幻灯片，因为我们使用索引 `2` 。 （一个段落的第一个幻灯片有索引0，在技术上这是一个段落）。

如果我们在HTML标记中使用属性`data-anchor`，就可以使用自定义锚点来代替它的索引：

```html
<div class="section">
	<div class="slide" data-anchor="slide1"> 幻灯片 1 </div>
	<div class="slide" data-anchor="slide2"> 幻灯片 2 </div>
	<div class="slide" data-anchor="slide3"> 幻灯片 3 </div>
	<div class="slide" data-anchor="slide4"> 幻灯片 4 </div>
</div>
```
在最后一种情况中，我们使用的URL将是`#secondPage/slide3`，这相当于之前的 `#secondPage/2`。

请注意，如果没有提供`anchors`数组，则也可以使用`data-anchor`属性以同样的方式定义节锚点。

**注意！**`data-anchor`标记的值不能与站点上的任何ID元素（或IE的NAME元素）相同。

### 创建更小或更大的段落
[演示](http://codepen.io/alvarotrigo/pen/BKjRYm) fullPage.js提供了一种方法来删除段落和幻灯片的全高限制。 可以创建高度小于或大于视口的段落。 这是页脚的理想方式。
需明白所有段落使用此功能并没有意义，这一点很重要。 如果网站的初始加载中有多个段落，则fullPage.js将不会滚动以查看下一个段落，因为它已经在视口中。

创建更小的段落，只需在要应用的段落中使用`fp-auto-height` 类即可，则可以调用您的段落/幻灯片中定义的高度。

```html
<div class="section">整个视口</div>
<div class="section fp-auto-height">自动高度</div>
```

#### 响应自动高度段落
[演示](https://codepen.io/alvarotrigo/pen/WZmMgZ) 响应自动高度可以通过使用`fp-auto-height-responsive`类来调用。 这种方式段落将全屏，直到响应模式终止。 根据定义调整大小，可能是大于或小于视口。

### 由fullpage.js添加的状态类
Fullpage.js在不同的元素中添加多个类来保存网站状态的记录：

- `active` 添加当前可见部分并滑动。
- `active` 被添加到当前菜单元素（如果使用`menu`选项）。
- `fp-viewing-SECTION-SLIDE`形式的类被添加到网站的 `body` 元素中。(例如： [`fp-viewing-secondPage-0`](http://alvarotrigo.com/fullPage/#secondPage)) `SECTION`和`SLIDE`部分将成为当前部分和幻灯片的锚（或索引，如果没有提供锚）。
- 当进入响应模式时，`fp-responsive`添加到`body`元素`
- 当启用fullpage.js时，`fp-enabled`添加到`html`元素。 （并在销毁时被移除）。
- 当fullPage.js被销毁时，`fp-destroyed`被添加到fullpage.js容器中。

### 延迟加载
[演示](http://codepen.io/alvarotrigo/pen/eNLBXo) fullPage.js提供了一种延迟加载图像、视频和音频元素的方式，这样它们不会减慢网站的加载速度，也不会浪费数据传输。
当使用延迟加载时，所有这些元素只有在进入视口时才会加载。
要启用延迟加载，您只需将`src`属性更改为`data-src`，如下所示：

```
<img data-src="image.png">
<video>
	<source data-src="video.webm" type="video/webm" />
	<source data-src="video.mp4" type="video/mp4" />
</video>
 ```

如果您已经使用另一个使用`data-src`的延迟加载解决方案，则可以通过设置 `lazyLoading: false`选项来禁用fullPage.js延迟加载。

### 自动播放/暂停嵌入式媒体

**注意**：根据操作系统和浏览器的不同，自动播放功能可能无法在某些移动设备上使用（即[iOS的Safari](https://webkit.org/blog/6784/new-video-policies-for-ios/) 版本 < 10.0）。

#### 播放部分/幻灯片载入：
对于视频或音频使用属性 `autoplay`，或者对于youtube iframe使用参数`autoplay=1`将使得在加载页面时播放媒体元素。
在段落/幻灯片载入使用而不是属性`data-autoplay`播放。 例如：

```html
<audio data-autoplay>
	<source src="http://metakoncept.hr/horse.ogg" type="audio/ogg">
</audio>
```

#### 暂停
嵌入式HTML5`<video>`/`<audio>`和Youtube iframe在离开某个段落或幻灯片时自动暂停。 可以通过使用属性`data-keepplaying`来禁用。 例如：
```html
<audio data-keepplaying>
	<source src="http://metakoncept.hr/horse.ogg" type="audio/ogg">
</audio>
```

### 使用扩展
fullpage.js [提供了一组扩展](http://alvarotrigo.com/fullPage/extensions/)您可以使用它来增强其默认功能。 所有这些都被列为 [fullpage.js 选项](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E9%80%89%E9%A1%B9).

扩展需要使用在[`dist` 文件夹](https://github.com/alvarotrigo/fullPage.js/tree/master/dist/)中的缩小文件 [`jquery.fullpage.extensions.min.js`](https://github.com/alvarotrigo/fullPage.js/tree/master/dist/jquery.fullpage.extensions.min.js)，而不是通常的fullPage.js文件 (`jquery.fullpage.js` 或 `jquery.fullpage.min.js`)。

一旦你需要扩展文件，你需要在fullPage之前添加它。 例如，如果我想要使用Continuos Horizontal扩展，我将包含扩展文件，然后包含fullPage文件的扩展版本。

```html
<script type="text/javascript" src="fullpage.continuousHorizontal.min.js"></script>
<script type="text/javascript" src="fullpage/jquery.fullpage.extensions.min.js"></script>
```

每个扩展都需要激活密钥和许可证密钥。[在这里看到更多细节](https://github.com/alvarotrigo/fullPage.js/blob/master/lang/chinese/how-to-activate-fullpage-extension.md).

然后你就可以按照[选项](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E9%80%89%E9%A1%B9)的说明使用和配置它们。

## 选项

- `controlArrows`：（默认为 `true`）确定是否将幻灯片的控制箭头向右或向左移动。

- `verticalCentered`：（默认为`true`）在段落内部垂直居中。 当设置为`true`时，您的代码将被库包装。可考虑使用委托或在`afterRender`回调中加载其他脚本。

- `scrollingSpeed`：（默认`700`）滚动转换的速度（以毫秒为单位）。

- `sectionsColor`：（默认`none`）为每个部分定义CSS`background-color`属性。
例：
```javascript
$('#fullpage').fullpage({
	sectionsColor: ['#f2f2f2', '#4BBFC3', '#7BAABE', 'whitesmoke', '#000'],
});
```

- `anchors`：（默认`[]`）定义要在每个部分的URL上显示的锚链接（#example）。 锚点的值应该是独一无二的。 数组中的锚的位置将限定锚被应用于哪些部分。 （第二部分的第二个位置等等）。 通过浏览器也可以使用锚点向前和向后导航。 该选项还允许用户为特定的部分或幻灯片添加书签。 **注意！**锚点不能与站点上的任何ID元素（或IE的NAME元素）具有相同的值。
现在可以通过使用属性`data-anchor`直接在HTML结构中定义锚点，如此处所述。

- `lockAnchors`：（默认为`false`）确定URL中的锚是否在库中完全有效。 您仍然可以在函数和回调内部使用锚，但是它们在滚动网站时不起任何作用。 如果你想在URL中使用锚点来将fullPage.js和其他插件结合起来，那就很有用。

**重要**理解 `anchors`选项数组中的值通过在标记中的位置直接关联到具有`.section` 类的元素是有帮助的。

- `easing`:(默认`easeInOutCubic`）定义用于垂直和水平滚动的过渡效果。
它需要文件`vendors / jquery.easings.min.js`或[jQuery UI](http://jqueryui.com/)来使用[它的转换](http://api.jqueryui.com/easings/)。 其他库可以用来代替。

- `easingcss3`: （默认`ease`）定义在使用`css3：true`的情况下使用的过渡效果。 你可以使用[预定义的](http://www.w3schools.com/cssref/css3_pr_transition-timing-function.asp)（比如`linear`，`ease-out` ...）或者使用`立方bezier`功能创建你自己的。 你可能想使用[Matthew Lein CSS缓动动画工具](http://matthewlein.com/ceaser/)。

- `loopTop`:（默认为`false`）定义在第一节中向上滚动是否滚动到最后一个。

- `loopBottom`: （默认为`false`）定义滚动到最后一节是否应该滚动到第一个。

- `loopHorizontal`:（默认为`true`）定义水平滑块是否在到达上一张或上一张幻灯片后循环。

- `css3`: （默认`true`）。 定义是否使用JavaScript或CSS3变换在部分和幻灯片中滚动。 有助于通过支持CSS3的浏览器加速平板电脑和移动设备的移动。 如果此选项设置为`true，并且浏览器不支持CSS3，则将使用jQuery后备。

- `autoScrolling`: （默认为`true`）定义是使用“自动”滚动还是“正常”滚动。 它同时也影响了平板电脑和移动电话中浏览器/设备窗口部分适配的方式。

- `fitToSection`: （默认为`true`）确定是否节放入视口中。 当设置为`true时，当前活动节将始终填充整个视口。 否则，用户可以自由地停留在一个节的中间（何时）

- `fitToSectionDelay`: （默认1000）。 如果`fitToSection`设置为true，则延迟
以毫秒为单位进行拟合。

- `scrollBar`: （默认`false`）确定是否使用站点的滚动条。 在使用滚动条的情况下，`autoScrolling`功能仍将按预期工作。 用户也可以使用滚动条自由滚动网站，当滚动完成时，fullPage.js将适配屏幕上的部分。

- `paddingTop`: （默认`0`）用数值和度量（paddingTop：'10px'，paddingTop：'10em'...）定义每个部分的顶部填充。

- `paddingBottom`: （默认为`0`）用数值和度量（paddingBottom：'10px'，paddingBottom：'10em'...）定义每个部分的底部填充。 使用固定页脚的情况下会有用。

- `fixedElements`: （默认`null`）定义当使用`css3`选项保持固定时，哪些元素将从插件的滚动结构中移除。 它需要一个字符串与这些元素的jQuery选择器。 （例如：`fixedElements：'＃element1，.element2'`）

- `normalScrollElements`: （默认`null`）如果你想在滚动某些元素时避免自动滚动，这是你需要使用的选项。 （地图，滚动div等有用）它需要一个字符串与这些元素的jQuery选择器。 （例如：`normalScrollElements：'＃element1，.element2'`）。 此选项不应该应用于任何节/幻灯片元素本身。

- `normalScrollElementTouchThreshold` : （默认`5`）定义html节点树的跳数阈值Fullpage将测试`normalScrollElements是否匹配，以允许在触摸设备上的div的滚动功能。 （例如：`normalScrollElementTouchThreshold：3`）

- `bigSectionsDestination`: （默认`null`）定义如何滚动到比视口大的部分。 默认情况下，如果您来自目的地上方的部分，fullPage.js将滚动到顶部，如果您来自目的地之下的部分，则会滚动到底部。 可能的值是`top`，`bottom`，`null`。

- `keyboardScrolling`: （默认为`true`）定义是否可以使用键盘浏览内容。

- `touchSensitivity`: （默认`5`）定义浏览器窗口宽度/高度的百分比，以及滑动到下一个节/幻灯片必须测量的距离

- `continuousVertical`:（默认为`false`）定义是否在最后一个区段向下滚动，或是否应该向下滚动到第一个区段，或如果在第一个区段向上滚动时是否应该滚动到最后一个区段。 不兼容`loopTop`，`loopBottom`或站点中存在的任何滚动条（`scrollBar：true`或`autoScrolling：false`）。

- `continuousHorizontal`: （默认`false`）[fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 定义在最后一张幻灯片中向右滑动是否应该向右滑动到第一张幻灯片，或者如果在第一张幻灯片中向左滚动是否应向左滑动到最后一张。 不兼容`loopHorizontal`。 需要fullpage.js> = 2.8.3。

- `scrollHorizontally`:（默认`false`）[fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 定义是否使用鼠标滚轮或触控板在滑块内水平滑动。 讲故事的理想选择。 需要fullpage.js> = 2.8.3。

- `interlockedSlides`: （默认`false`）[fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 确定移动一个水平滑块是否会强制滑块在其他段落中的滑动方向相同。 可能的值是`true`，`false或带有互锁部分的数组。 例如`[1,3,5]`从1开始。需要fullpage.js> = 2.8.3。

- `dragAndMove`: （默认`false`）[fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 启用或禁用鼠标或手指拖动和滑动部分和幻灯片。 需要fullpage.js> = 2.8.9。 可能的值是：
  - `true`: 启用该功能。
  - `false`: 禁用该功能。
  - `vertical`: 只能在垂直情况下启用该功能。
  - `horizontal`: 只能在水平情况下启用该功能。
  - `fingersonly`: 仅启用触摸设备的功能。
  - `mouseonly`: 仅启用桌面设备的功能（鼠标和触控板）。

- `offsetSections`: （默认`false`）[fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 提供基于百分比使用非全屏幕部分的方法。 通过显示下一部分或上一部分的内容，向访问者显示网站中的更多内容的理想选择。 需要fullPage.js> = 2.8.8
要定义每个部分的百分比，必须使用属性`data-percentage`。 可以通过在属性`data-centered`中使用布尔值来确定视口中该部分的居中（如果未指定，则默认为`true`）。 例如：
``` html
    <div class="section" data-percentage="80" data-centered="true">
```

- `resetSliders`: （默认`false`）。 [fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 定义是否在离开节后重置每个滑块。 需要fullpage.js> = 2.8.3。

- `fadingEffect`: （默认`false`）。 [fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 定义是否使用淡入淡出效果，而不是默认的滚动效果。 可能的值是`true`，`false`，`sections`，`slideides`。 因此，可以垂直或水平地应用，或者同时应用于两者。 需要fullpage.js> = 2.8.6。

- `animateAnchor`: （默认`true`）定义给定锚点（＃）的站点的负载是否会随着动画滚动到其目的地或直接加载给定部分。

- `recordHistory`: （默认为`true`）定义是否将网站的状态推送到浏览器的历史记录。 设置为`true`时，网站的每个部分/幻灯片将作为新页面，浏览器的后退和前进按钮将滚动部分/幻灯片以达到网站的上一个或下一个状态。 当设置为`false`时，URL将保持更改，但不会影响浏览器的历史记录。 使用`autoScrolling：false`时，该选项会自动关闭。

- `menu`: （默认`false`）选择器可以用来指定菜单链接到部分。 这样，节的滚动将使用`active类激活菜单中的相应元素。
这将不会生成菜单，而只是将`active类添加到给定菜单中的元素，并带有相应的锚链接。
为了将菜单的元素与各个部分相链接，将需要一个HTML 5数据标签（`data-menuanchor`）来使用这些部分中使用的锚链接。 例：
```html
<ul id="myMenu">
	<li data-menuanchor="firstPage" class="active"><a href="#firstPage">第一节</a></li>
	<li data-menuanchor="secondPage"><a href="#secondPage">第二节</a></li>
	<li data-menuanchor="thirdPage"><a href="#thirdPage">第三节</a></li>
	<li data-menuanchor="fourthPage"><a href="#fourthPage">第四节</a></li>
</ul>
```
```javascript
$('#fullpage').fullpage({
	anchors: ['firstPage', 'secondPage', 'thirdPage', 'fourthPage', 'lastPage'],
	menu: '#myMenu'
});
```

**注意：** 菜单元素应放置在整页包装外，以避免使用`css3：true`时出现问题。 否则它会被插件本身附加到`body`。

- `navigation`: （默认`false`）如果设置为`true`，则会显示一个由小圆圈组成的导航栏。

- `navigationPosition`: （默认`none`）可以设置为`left`或`right`，并定义导航栏显示的位置（如果使用的话）。

- `navigationTooltips`: （默认为[]）定义要使用导航圈的工具提示。 例如：`navigationTooltips：['firstSlide'，'secondSlide']`。 如果您愿意，也可以在每个部分中使用属性`data-tooltip`来定义它们。

- `showActiveTooltip`: （默认为`false`）显示垂直导航中主动查看节的持久工具提示。

- `slidesNavigation`: （默认为`false`）如果设置为`true`，则会显示一个导航栏，该导航栏由站点上每个横向滑块的小圆圈组成。

- `slidesNavPosition`: （默认`bottom`）定义滑块的横向导航栏的位置。 值为`top`和`bottom`。 您可能需要修改CSS样式以确定从顶部或底部以及任何其他样式（如颜色）的距离。

- `scrollOverflow`: （默认为`false`）（与IE 8不兼容）定义在内容大于它的高度的情况下是否为节/幻灯片创建滚动。 当设置为`true`时，您的内容将被插件包装。 考虑使用委托或在`afterRender`回调中加载其他脚本。
如果设置为`true`，则需要库[`scrolloverflow.min.js`](https://github.com/alvarotrigo/fullPage.js/tree/master/vendors/scrolloverflow.min.js)。 这个文件必须在fullPage.js插件之前而非jQuery加载。
例如：

```html
<script type="text/javascript" src="vendors/scrolloverflow.min.js"></script>
<script type="text/javascript" src="jquery.fullPage.js"></script>
```

为了防止fullpage.js在某些节或幻灯片中创建滚动条，请使用`fp-noscroll`类。 例如： `<div class="section fp-noscroll">`

在section元素中使用`fp-auto-height-responsive`时，您也可以防止scrolloverflow应用于响应模式。

- `scrollOverflowReset`:（默认`false`）[fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 如果设置为`true`，当离开另一个垂直节时，使用滚动条向上滚动节/幻灯片的内容。 这样，即使从下面的节滚动，节/幻灯片也会始终显示其内容的开始。

- `scrollOverflowOptions`: 当使用scrollOverflow：true时，fullpage.js将使用[iScroll.js库文件](https://github.com/cubiq/iscroll/)的分叉和修改版本。 您可以通过为要使用的iScroll.js选项提供fullpage.js来自定义滚动行为。 查看[它的文档](http://iscrolljs.com/)了解更多信息。

- `sectionSelector`: （默认`.section`）定义用于插件部分的jQuery选择器。 有时可能需要更改，以避免与使用与fullpage.js相同的选择器的其他插件的问题。

- `slideSelector`: （默认`.slide`）定义用于插件幻灯片的jQuery选择器。 有时可能需要更改，以避免与使用与fullpage.js相同的选择器的其他插件的问题。

- `responsiveWidth`: （默认`0`）一个正常的滚动（`autoScrolling：false`）将在定义的宽度下以像素为单位使用。 如果用户希望将自己的响应式CSS用于身体标记，则会将`fp-responsive`类添加到身体标记中。 例如，如果设置为900，则每当浏览器的宽度小于900时，插件将像正常站点一样滚动。

- `responsiveHeight`: （默认`0`）一个正常的滚动（`autoScrolling：false`）将在定义的高度下以像素为单位使用。 如果用户希望将自己的响应式CSS用于身体标记，则会将`fp-responsive`类添加到身体标记中。 例如，如果设置为900，则每当浏览器的高度小于900时，插件将像正常站点一样滚动。

- `responsiveSlides`: （默认`false`）[fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 设置为`true`时，在响应模式被触发时，幻灯片将变成垂直节。 （通过使用上面详述的`responsiveWidth`或`responsiveHeight`选项）。 需要fullpage.js> = 2.8.5。

- `parallax`: （默认`false`）[fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 定义是否在节/幻灯片上使用视差背景效果。 [详细了解如何应用视差选项](https://github.com/alvarotrigo/fullPage.js/blob/master/lang/chinese/parallax-extension.md).

- `parallaxOptions`: （默认：`{type：'reveal'，percent：62，property：'translate'}`）。 允许在使用选项parallax:true时配置视差背景效果的参数。 [详细了解如何应用视差选项](https://github.com/alvarotrigo/fullPage.js/blob/master/lang/chinese/parallax-extension.md).

- `lazyLoading`: （默认`true`）延迟加载默认是激活的，这意味着它会延迟加载包含属性`data-src`的任何媒体元素，详见[Lazy Loading docs](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E5%BB%B6%E8%BF%9F%E5%8A%A0%E8%BD%BD)。 如果你想使用任何其他的后加载库，你可以禁用这个fullpage.js功能。

## 方法
你可以在[这里](http://alvarotrigo.com/fullPage/examples/methods.html)看到它们

### moveSectionUp()
[示例](http://codepen.io/alvarotrigo/pen/GJXNMN) 向上滚动一节：
```javascript
$.fn.fullpage.moveSectionUp();
```
---
### moveSectionDown()
[示例](http://codepen.io/alvarotrigo/pen/jPvVZx) 向下滚动一节：
```javascript
$.fn.fullpage.moveSectionDown();
```
---
### moveTo(第节, 幻灯片)
[示例](http://codepen.io/alvarotrigo/pen/doqOmY) 将页面滚动到给定节并滑动。 第一张幻灯片，默认情况下，将有索引0。
```javascript
/*滚动到锚链接`firstSlide`和第二张幻灯片的部分 */
$.fn.fullpage.moveTo('firstSlide', 2);

```

```javascript
//滚动到网站的第三节
$.fn.fullpage.moveTo(3, 0);

//这是一样的
$.fn.fullpage.moveTo(3);
```
---
### silentMoveTo(第节, 幻灯片)
[示例](http://codepen.io/alvarotrigo/pen/doqOeY) 与[`moveTo`](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#moveto%E7%AC%AC%E8%8A%82-%E5%B9%BB%E7%81%AF%E7%89%87)完全相同，但是在这种情况下，它将执行没有动画的滚动。 直接跳到目的地。
```javascript
/*滚动到锚链接`firstSlide`和第二张幻灯片的部分 */
$.fn.fullpage.silentMoveTo('firstSlide', 2);
```
---
### moveSlideRight()
[示例](http://codepen.io/alvarotrigo/pen/Wvgoyz) 将当前节的水平滑块滚动到下一张幻灯片：
```javascript
$.fn.fullpage.moveSlideRight();
```
---
### moveSlideLeft()
[示例](http://codepen.io/alvarotrigo/pen/gpdLjW) 将当前节的水平滑块滚动到上一张幻灯片:
```javascript
$.fn.fullpage.moveSlideLeft();
```
---
### setAutoScrolling(boolean)
[示例](http://codepen.io/alvarotrigo/pen/rVZWrR) 实时设置滚动配置。
定义页面滚动行为的方式。 如果设置为`true`，则将使用"自动"滚动，否则将使用站点的"手动"或"正常"滚动。

```javascript
$.fn.fullpage.setAutoScrolling(false);
```
---
### setFitToSection(boolean)
[示例](http://codepen.io/alvarotrigo/pen/GJXNYm) 设置选项`fitToSection`的值，确定是否适合屏幕中的部分。


```JavaScript
$.fn.fullpage.setFitToSection(false);
```
---
### fitToSection()
[示例](http://codepen.io/alvarotrigo/pen/JWWagj) 滚动到最近的适合视口的活动节。

```javascript
$.fn.fullpage.fitToSection();
```
---
### setLockAnchors(boolean)
[示例](http://codepen.io/alvarotrigo/pen/yNxVRQ) 设置选项`lockAnchors`的值，确定锚是否在URL中有效。

```javascript
$.fn.fullpage.setLockAnchors(false);
```
---
### setAllowScrolling(boolean, [directions])
[示例](http://codepen.io/alvarotrigo/pen/EjeNdq) 添加或删除通过使用鼠标滚轮/触控板或触摸手势（默认处于活动状态）滚动节/幻灯片的可能性。 注意这不会禁用键盘滚动。 您将需要使用`setKeyboardScrolling`。

- `directions`：（可选参数）允许的值：`all`，`up`，`down`，`left`，`right`或者它们的组合，用`down，right`等逗号分隔。 它定义了滚动将被启用或禁用的方向。

```javascript

//禁用滚动
$.fn.fullpage.setAllowScrolling(false);

//禁用向下滚动
$.fn.fullpage.setAllowScrolling(false, 'down');

//禁用向下和向右滚动
$.fn.fullpage.setAllowScrolling(false, 'down, right');
```
---
### setKeyboardScrolling(boolean, [directions])
[示例](http://codepen.io/alvarotrigo/pen/GJXNwm) 添加或删除通过使用键盘（默认情况下处于活动状态）滚动节的可能性。

- `directions`: （可选参数）允许的值：`all`，`up`，`down`，`left`，`right`或者它们的组合，用`down，right`等逗号分隔。 它定义了滚动将被启用或禁用的方向。

```javascript
//禁用所有键盘滚动
$.fn.fullpage.setKeyboardScrolling(false);

//禁用键盘向下滚动
$.fn.fullpage.setKeyboardScrolling(false, 'down');

//禁用键盘向下和向右滚动
$.fn.fullpage.setKeyboardScrolling(false, 'down, right');
```
---
### setRecordHistory(boolean)
[示例](http://codepen.io/alvarotrigo/pen/rVZWQb) 定义是否在URL中记录每个散列更改的历史记录。

```javascript
$.fn.fullpage.setRecordHistory(false);
```
---
### setScrollingSpeed(milliseconds)
[示例](http://codepen.io/alvarotrigo/pen/NqLbeY) 定义以毫秒为单位的滚动速度。

```javascript
$.fn.fullpage.setScrollingSpeed(700);
```
---
### destroy(type)
[示例](http://codepen.io/alvarotrigo/pen/bdxBzv) 销毁插件事件以及可选的HTML标记和样式。使用AJAX加载内容时的理想选择。

- `type`: （可选参数）可以为空或`all`。 如果`all`被传递，fullpage.js使用的HTML标记和样式将被删除。 这样，原始的HTML标记，即任何插件修改之前使用的标记都将被保留。

```javascript
//销毁由fullPage.js创建的所有Javascript事件（URL中的卷动，hashchange）
$.fn.fullpage.destroy();

//销毁所有的JavaScript事件，以及在原始HTML标记中由fullPage.js所做的任何修改。
$.fn.fullpage.destroy('all');
```
---
### reBuild()
更新DOM结构以适应新的窗口大小或其内容。
  非常适合与AJAX调用或站点的DOM结构中的外部更改结合使用，特别是在使用`scrollOverflow：true`时。

```javascript
$.fn.fullpage.reBuild();
```
---
### setResponsive(boolean)
[示例](http://codepen.io/alvarotrigo/pen/WxOyLA) 设置页面的响应模式。 当设置为`true时，自动滚动将被关闭，结果与`responsiveWidth`或`responsiveHeight`选项被触发时的结果完全相同。
```javascript
$.fn.fullpage.setResponsive(true);
```
---
### responsiveSlides.toSections()
[fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 需要fullpage.js> = 2.8.5。将水平幻灯片变成垂直节。

```javascript
$.fn.fullpage.responsiveSlides.toSections();
```
---
### responsiveSlides.toSlides()
[fullpage.js的扩展](http://alvarotrigo.com/fullPage/extensions/)。 需要fullpage.js> = 2.8.5。将原始幻灯片（现转换为垂直节）重新转换为水平幻灯片。

```javascript
$.fn.fullpage.responsiveSlides.toSlides();
```

## Callbacks
[示例](http://codepen.io/alvarotrigo/pen/XbPNQv) 你可以在[这里](http://alvarotrigo.com/fullPage/examples/callbacks.html)看到他们。

### afterLoad (`anchorLink`, `index`)
滚动结束之后，一旦加载了节，就会触发回调。参数：

- `anchorLink`：该部分对应的anchorLink。
- `index：该部分的索引。 从1开始。

如果在插件中没有定义anchorLink，那么`index`参数将是唯一使用的参数。

例如：

```javascript
$('#fullpage').fullpage({
	anchors: ['firstPage', 'secondPage', 'thirdPage', 'fourthPage', 'lastPage'],

	afterLoad: function(anchorLink, index){
		var loadedSection = $(this);

		//使用 index
		if(index == 3){
			alert("第3节停止加载");
		}

		//使用 anchorLink
		if(anchorLink == 'secondSlide'){
			alert("第2节停止加载");
		}
	}
});
```
---
### onLeave (`index`, `nextIndex`, `direction`)
一旦用户离开某个节，过渡到新节，就会触发此回调。
返回“false”将在移动发生之前取消移动。

参数：

- `index`离开节的索引。 从1开始。
- `nextIndex`：目标节的索引。 从1开始。
- direction`：取决于滚动方向，取值为`up`或`down。

例如：

```javascript
$('#fullpage').fullpage({
	onLeave: function(index, nextIndex, direction){
		var leavingSection = $(this);

		//离开第二节后
		if(index == 2 && direction =='down'){
			alert("前往第3节！");
		}

		else if(index == 2 && direction == 'up'){
			alert("前往第1节！");
		}
	}
});
```

#### 触发之前取消滚动
您可以通过在`onLeave`回调函数上返回`false来取消滚动：

```javascript
$('#fullpage').fullpage({
	onLeave: function(index, nextIndex, direction){
		//如果目标是第三节，它将不会滚动
		if(nextIndex == 3){
			return false;
		}
	}
});
```

---
### afterRender()
这个回调在页面结构生成后立即被触发。 这是您要用来初始化其他插件的回调函数，或者触发任何需要文档准备就绪的代码（因为这个插件修改了DOM来创建结果的结构）。 请参阅[常见问题](https://github.com/alvarotrigo/fullPage.js/wiki/FAQ---Frequently-Answered-Questions)了解更多信息。

例如：

```javascript
$('#fullpage').fullpage({
	afterRender: function(){
		var pluginContainer = $(this);
		alert("DOM结构已完成");
	}
});
```
---
### afterResize()
调整浏览器窗口大小后，会触发此回调。 就在节被调整之后。

例如：

```javascript
$('#fullpage').fullpage({
	afterResize: function(){
		var pluginContainer = $(this);
		alert("节已重新调整大小");
	}
});
```
---
### afterResponsive(`isResponsive`)
在fullpage.js从正常模式变为响应模式或从响应模式变为正常模式之后，此回调将被触发。

参数：

- `isResponsive`：布尔值，用于确定是否进入响应模式（`true`）或返回正常模式（`false`）。

例如：

```javascript
$('#fullpage').fullpage({
	afterResponsive: function(isResponsive){
		alert("是否响应" + isResponsive);
	}
});
```
---
### afterSlideLoad (`anchorLink`, `index`, `slideAnchor`, `slideIndex`)
滚动结束后，加载一个节的幻灯片后触发回调。参数：

- `anchorLink`：该节对应的anchorLink。
- `index`：该节的索引。 从1开始。
- `slideAnchor`：与幻灯片对应的锚点（如果有的话）
- `slideIndex`：幻灯片的索引。 从1开始（默认幻灯片不计算为幻灯片，但作为一个节）

如果没有为幻灯片或幻灯片定义anchorLinks，那么`slideIndex`参数将是唯一使用的参数。例如：

```javascript
$('#fullpage').fullpage({
	anchors: ['firstPage', 'secondPage', 'thirdPage', 'fourthPage', 'lastPage'],

	afterSlideLoad: function( anchorLink, index, slideAnchor, slideIndex){
		var loadedSlide = $(this);

		//第二节的第一张幻灯片
		if(anchorLink == 'secondPage' && slideIndex == 1){
			alert("第一张幻灯片加载完毕");
		}

		//第二节的第二张幻灯片（假设#secondSlide是
        //为第二张幻灯片锚点
		if(index == 2 && slideIndex == 'secondSlide'){
			alert("第二张幻灯片加载完毕");
		}
	}
});
```


---
### onSlideLeave (`anchorLink`, `index`, `slideIndex`, `direction`, `nextSlideIndex`)
一旦用户离开幻灯片转到另一个幻灯片，就会触发此回调。返回`false`将在移动发生之前取消移动。

参数：

- `anchorLink`：该节对应的anchorLink。
- `index`：该节的索引。 从1开始。
- `slideIndex`：幻灯片的索引。 **从0开始。**
- `direction`：取决于滚动方向，取值为`right`或`left`。
- `nextSlideIndex`：目标幻灯片的索引。 **从0开始。**


例如：

```javascript
$('#fullpage').fullpage({
	onSlideLeave: function( anchorLink, index, slideIndex, direction, nextSlideIndex){
		var leavingSlide = $(this);

		//留下第二节的第一张幻灯片
		if(index == 2 && slideIndex == 0 && direction == 'right'){
			alert("离开第一张幻灯片！");
		}

		//将第二节的第三张幻灯片留在左边
		if(index == 2 && slideIndex == 2 && direction == 'left'){
			alert("前往第二张幻灯片！");
		}
	}
});
```

#### 在发生移动之前取消移动
您可以通过在`onSlideLeave`回调中返回`false`来取消移动。 [与使用`onLeave`取消动作一样](https://github.com/alvarotrigo/fullPage.js/tree/master/lang/chinese/#%E8%A7%A6%E5%8F%91%E4%B9%8B%E5%89%8D%E5%8F%96%E6%B6%88%E6%BB%9A%E5%8A%A8)。

# 报告问题
1.请在提问之前使用github问题搜索查找您的问题。
2.确保使用最新的fullpage.js版本。 不支持旧版本。
3.使用[Github问题论坛](https://github.com/alvarotrigo/fullPage.js/issues)来创建问题。
4.**需要单独复制该问题**使用[jsfiddle](http://jsfiddle.net/97tbk/418/)或[codepen](http://codepen.io/alvarotrigo / pen / NxyPPp)，如果可能的话。

# 贡献给fullpage.js
请参阅[贡献给fullpage.js](https://github.com/alvarotrigo/fullPage.js/wiki/Contributing-to-fullpage.js)

# 更新日志
要查看最近更改的列表，请参见[发行版部分](https://github.com/alvarotrigo/fullPage.js/releases).

# 构建任务
想要构建fullpage.js分发文件？ 请参阅[Build Tasks](https://github.com/alvarotrigo/fullPage.js/wiki/Build-tasks)

# 参考资源
- [Wordpress theme](http://alvarotrigo.com/fullPage/utils/wordpress.html)
- [Vue.js wrapper component](https://github.com/alvarotrigo/vue-fullpage.js)
- [CSS Easing Animation Tool - Matthew Lein](http://matthewlein.com/ceaser/) (用于定义`easingcss3的值)
- [fullPage.js jsDelivr CDN](http://www.jsdelivr.com/#!jquery.fullpage)
- [fullPage.js plugin for October CMS](http://octobercms.com/plugin/freestream-parallax)
- [fullPage.js wordpress plugin](https://wordpress.org/plugins/wp-fullpage/)
- [fullPage.js Angular2 directive](https://github.com/meiblorn/ng2-fullpage)
- [fullPage.js angular directive](https://github.com/hellsan631/angular-fullpage.js)
- [fullPage.js ember-cli addon](https://www.npmjs.com/package/ember-cli-fullpagejs)
- [fullPage.js Rails Ruby Gem](https://rubygems.org/gems/fullpagejs-rails)
- [Angular fullPage.js - Adaptation for Angular.js v1.x](https://github.com/mmautomatizacion/angular-fullpage.js)
- [Integrating fullPage.js with Wordpress (Tutorial)](http://premium.wpmudev.org/blog/build-apple-inspired-full-page-scrolling-pages-for-your-wordpress-site/)

## 谁在使用 fullPage.js
如果你想让你的页面在这里列出。 请使用网址<a href="mailto:alvaro@alvarotrigo.com">与我联系</a>。

[![Google](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/google.png)](http://www.yourprimer.com/)
[![BBC](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/bbc-2.png)](http://www.bbc.co.uk/news/resources/idt-d88680d1-26f2-4863-be95-83298fd01e02)
[![eBay](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/ebay.png)](http://pages.ebay.com/design/)
![Sony](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/sony.gif)
![Vodafone](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/vodafone.png)
![British Airways](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/british-airways-fullpage.gif)
![McDonalds](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/mcdonalds.png)
![EA](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/ea.png)
[![Vogue](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/vogue.png)](http://www.vogue.fr/chaumet-histoires-de-liens)
[![Mi](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/mi.png)](http://www.mi.com/shouhuan)
[![redd](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/sym.png)](http://www.sanyang.com.tw/service/Conception/)
[![Bugatti](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/bugatti.gif)](http://www.bugatti.com/veyron/veyron-164/)
[![eDarling](http://wallpapers-for-ipad.com/fullpage/imgs3/logos/edarling.png)](https://www.edarling.de/)

- http://www.bbc.co.uk/news/resources/idt-d88680d1-26f2-4863-be95-83298fd01e02
- http://pages.ebay.com/design/
- http://www.yourprimer.com/
- http://www.vogue.fr/chaumet-histoires-de-liens
- http://burntmovie.com/
- http://www.bugatti.com/veyron/veyron-164/
- http://www.newjumoconcept.com/
- http://www.shootinggalleryasia.com/
- http://medoff.ua/en/
- http://promo.prestigio.com/grace1/
- http://www.mi.com/shouhuan
- http://www.commoditiesdemystified.info/en/
- http://torchbrowser.com/
- http://thekorner.fr/
- http://www.restaurantwoods.nl/
- https://www.edarling.de/
- http://urban-walks.com/
- http://lingualeo.com/
- http://charlotteaimes.com/
- http://collection.madeofsundays.com
- http://thiswasmybest.com/
- http://www.boxreload.com/
- http://educationaboveall.org/
- http://camfindapp.com/
- http://rockercreative.com/
- http://usescribe.com/
- http://lucilecazanave.com/
- http://boxx.hk/
- http://bearonunicycle.com/
- http://rawmilk.dk/en/
- http://www.famavolat.com/
- http://www.carpetloverclub.com/
- http://www.sanyang.com.tw/service/Conception/
- http://www.batzaya.net/
- http://www.graphicid.dk/
- http://www.carlphot.com/
- http://medissix.com/
- http://trasmissione-energia.terna.it/
- http://www.thefoodmovie.com/
- http://www.villareginateodolinda.it
- http://www.kesstrio.com
- http://fossdistillery.is
- http://ded-morozz.kiev.ua/
- http://unabridgedsoftware.com/
- http://atlanticcorp.us/
- http://moysport.ru/
- http://themify.me/demo/#theme=fullpane
- http://dancingroad.com
- http://www.camanihome.com/
- https://life2film.com/en/

你可以找到另一个列表[这里](http://libscore.com/#$.fn.fullpage).

## 捐献
非常欢迎您的捐款:)

[![Donate](https://www.paypalobjects.com/en_US/GB/i/btn/btn_donateCC_LG.gif)](https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=BEK5JQCQMED4J&lc=GB&item_name=fullPage%2ejs&currency_code=USD&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted)


## 许可证

**JavaScript和CSS文件中的信用评论应保持不变**（即使在组合或缩小之后）

（MIT许可证）

Copyright (c) 2013 Alvaro Trigo &lt;alvaro@alvarotrigo.com&gt;

特此免费授予任何人获得许可
这个软件的副本和相关的文档文件（
`软件`），不受限制地处理本软件，包括
但不限于使用，复制，修改，合并，发布，
分发，再许可和/或出售软件的副本，并且
允许提供软件的人这样做，但须遵守
以下条件：

上述版权声明和本许可声明应为
包括在本软件的所有副本或主要部分。

本软件按`原样`提供，不提供任何形式的担保，
明示或暗示，包括但不限于保证
适销性，针对特定用途的适用性和不侵权。
在任何情况下，作者或版权所有者都不承担任何责任
索赔，损害赔偿或其他责任，无论是在合同行为中，
民事侵权行为或其他由此引起或与之有关的
软件或软件中的使用或其他交易。
