/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.Hash;
import org.web3j.crypto.RawTransaction;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.service.TxSignService;
import org.web3j.service.TxSignServiceImpl;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.exceptions.TxHashMismatchException;
import org.web3j.tx.response.TransactionReceiptProcessor;
import org.web3j.utils.Numeric;
import org.web3j.utils.TxHashVerifier;

public class RawTransactionManager
extends TransactionManager {
    private final Web3j web3j;
    private final TxSignService txSignService;
    private final long chainId;
    protected TxHashVerifier txHashVerifier = new TxHashVerifier();

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId) {
        super(web3j, credentials.getAddress());
        this.web3j = web3j;
        this.chainId = chainId;
        this.txSignService = new TxSignServiceImpl(credentials);
    }

    public RawTransactionManager(Web3j web3j, TxSignService txSignService, long chainId) {
        super(web3j, txSignService.getAddress());
        this.web3j = web3j;
        this.chainId = chainId;
        this.txSignService = txSignService;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(transactionReceiptProcessor, credentials.getAddress());
        this.web3j = web3j;
        this.chainId = chainId;
        this.txSignService = new TxSignServiceImpl(credentials);
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId, int attempts, long sleepDuration) {
        super(web3j, attempts, sleepDuration, credentials.getAddress());
        this.web3j = web3j;
        this.chainId = chainId;
        this.txSignService = new TxSignServiceImpl(credentials);
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials) {
        this(web3j, credentials, -1L);
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, int attempts, int sleepDuration) {
        this(web3j, credentials, -1L, attempts, sleepDuration);
    }

    protected BigInteger getNonce() throws IOException {
        EthGetTransactionCount ethGetTransactionCount = this.web3j.ethGetTransactionCount(this.getFromAddress(), DefaultBlockParameterName.PENDING).send();
        return ethGetTransactionCount.getTransactionCount();
    }

    public TxHashVerifier getTxHashVerifier() {
        return this.txHashVerifier;
    }

    public void setTxHashVerifier(TxHashVerifier txHashVerifier) {
        this.txHashVerifier = txHashVerifier;
    }

    @Override
    public EthSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, boolean constructor) throws IOException {
        BigInteger nonce = this.getNonce();
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value, (String)data);
        return this.signAndSend(rawTransaction);
    }

    @Override
    public EthSendTransaction sendEIP1559Transaction(long chainId, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, BigInteger value, boolean constructor) throws IOException {
        BigInteger nonce = this.getNonce();
        RawTransaction rawTransaction = RawTransaction.createTransaction((long)chainId, (BigInteger)nonce, (BigInteger)gasLimit, (String)to, (BigInteger)value, (String)data, (BigInteger)maxPriorityFeePerGas, (BigInteger)maxFeePerGas);
        return this.signAndSend(rawTransaction);
    }

    @Override
    public String sendCall(String to, String data, DefaultBlockParameter defaultBlockParameter) throws IOException {
        EthCall ethCall = this.web3j.ethCall(Transaction.createEthCallTransaction(this.getFromAddress(), to, data), defaultBlockParameter).send();
        RawTransactionManager.assertCallNotReverted(ethCall);
        return ethCall.getValue();
    }

    @Override
    public EthGetCode getCode(String contractAddress, DefaultBlockParameter defaultBlockParameter) throws IOException {
        return this.web3j.ethGetCode(contractAddress, defaultBlockParameter).send();
    }

    public String sign(RawTransaction rawTransaction) {
        byte[] signedMessage = this.txSignService.sign(rawTransaction, this.chainId);
        return Numeric.toHexString((byte[])signedMessage);
    }

    public EthSendTransaction signAndSend(RawTransaction rawTransaction) throws IOException {
        String txHashRemote;
        String txHashLocal;
        String hexValue = this.sign(rawTransaction);
        EthSendTransaction ethSendTransaction = this.web3j.ethSendRawTransaction(hexValue).send();
        if (ethSendTransaction != null && !ethSendTransaction.hasError() && !this.txHashVerifier.verify(txHashLocal = Hash.sha3((String)hexValue), txHashRemote = ethSendTransaction.getTransactionHash())) {
            throw new TxHashMismatchException(txHashLocal, txHashRemote);
        }
        return ethSendTransaction;
    }
}

