/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.reactivex.Flowable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.BatchRequest;
import org.web3j.protocol.core.BatchResponse;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.websocket.events.Notification;
import org.web3j.utils.Async;

public abstract class Service
implements Web3jService {
    protected final ObjectMapper objectMapper;

    public Service(boolean includeRawResponses) {
        this.objectMapper = ObjectMapperFactory.getObjectMapper(includeRawResponses);
    }

    protected abstract InputStream performIO(String var1) throws IOException;

    @Override
    public <T extends Response> T send(Request request, Class<T> responseType) throws IOException {
        String payload = this.objectMapper.writeValueAsString((Object)request);
        try (InputStream result = this.performIO(payload);){
            if (result != null) {
                Response response = (Response)this.objectMapper.readValue(result, responseType);
                return (T)response;
            }
            T t = null;
            return t;
        }
    }

    @Override
    public <T extends Response> CompletableFuture<T> sendAsync(Request jsonRpc20Request, Class<T> responseType) {
        return Async.run(() -> this.send(jsonRpc20Request, responseType));
    }

    @Override
    public BatchResponse sendBatch(BatchRequest batchRequest) throws IOException {
        if (batchRequest.getRequests().isEmpty()) {
            return new BatchResponse(Collections.emptyList(), Collections.emptyList());
        }
        String payload = this.objectMapper.writeValueAsString(batchRequest.getRequests());
        try (InputStream result = this.performIO(payload);){
            if (result != null) {
                ArrayNode nodes = (ArrayNode)this.objectMapper.readTree(result);
                ArrayList<Response> responses = new ArrayList<Response>(nodes.size());
                for (int i = 0; i < nodes.size(); ++i) {
                    Request<?, Response<?>> request = batchRequest.getRequests().get(i);
                    Response response = (Response)this.objectMapper.treeToValue((TreeNode)nodes.get(i), request.getResponseType());
                    responses.add(response);
                }
                BatchResponse batchResponse = new BatchResponse(batchRequest.getRequests(), responses);
                return batchResponse;
            }
            BatchResponse batchResponse = null;
            return batchResponse;
        }
    }

    @Override
    public CompletableFuture<BatchResponse> sendBatchAsync(BatchRequest batchRequest) {
        return Async.run(() -> this.sendBatch(batchRequest));
    }

    @Override
    public <T extends Notification<?>> Flowable<T> subscribe(Request request, String unsubscribeMethod, Class<T> responseType) {
        throw new UnsupportedOperationException(String.format("Service %s does not support subscriptions", this.getClass().getSimpleName()));
    }
}

