/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.web3j.abi.datatypes.AbiTypes;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.StructType;
import org.web3j.abi.datatypes.Type;

public class DynamicStruct
extends DynamicArray<Type>
implements StructType {
    private final List<Class<Type>> itemTypes = new ArrayList<Class<Type>>();

    public DynamicStruct(List<Type> values) {
        this(Type.class, values);
    }

    private DynamicStruct(Class<Type> type, List<Type> values) {
        super(type, values);
        for (Type value : values) {
            this.itemTypes.add(value.getClass());
        }
    }

    @Override
    public int bytes32PaddedLength() {
        return super.bytes32PaddedLength() + 32;
    }

    public DynamicStruct(Type ... values) {
        this(Arrays.asList(values));
    }

    @SafeVarargs
    public DynamicStruct(Class<Type> type, Type ... values) {
        this(type, Arrays.asList(values));
    }

    @Override
    public String getTypeAsString() {
        StringBuilder type = new StringBuilder("(");
        for (int i = 0; i < this.itemTypes.size(); ++i) {
            Class<Type> cls = this.itemTypes.get(i);
            if (StructType.class.isAssignableFrom(cls) || DynamicArray.class.isAssignableFrom(cls)) {
                type.append(((Type)this.getValue().get(i)).getTypeAsString());
            } else if (Array.class.isAssignableFrom(cls)) {
                type.append(((Type)this.getValue().get(i)).getTypeAsString());
            } else {
                type.append(AbiTypes.getTypeAString(cls));
            }
            if (i >= this.itemTypes.size() - 1) continue;
            type.append(",");
        }
        type.append(")");
        return type.toString();
    }
}

