/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.web3j.abi.DefaultFunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.spi.FunctionReturnDecoderProvider;

public abstract class FunctionReturnDecoder {
    private static final FunctionReturnDecoder decoder;

    public static List<Type> decode(String rawInput, List<TypeReference<Type>> outputParameters) {
        return decoder.decodeFunctionResult(rawInput, outputParameters);
    }

    public static <T extends Type> Type decodeIndexedValue(String rawInput, TypeReference<T> typeReference) {
        return decoder.decodeEventParameter(rawInput, typeReference);
    }

    protected abstract List<Type> decodeFunctionResult(String var1, List<TypeReference<Type>> var2);

    protected abstract <T extends Type> Type decodeEventParameter(String var1, TypeReference<T> var2);

    static {
        ServiceLoader<FunctionReturnDecoderProvider> loader = ServiceLoader.load(FunctionReturnDecoderProvider.class);
        Iterator<FunctionReturnDecoderProvider> iterator = loader.iterator();
        decoder = iterator.hasNext() ? (FunctionReturnDecoder)iterator.next().get() : new DefaultFunctionReturnDecoder();
    }
}

