<#-- $This file is distributed under the terms of the license in LICENSE$ -->
<#--This is an example of including multiple content types in the same template, 
    this combines the default templates for Fixed HTML, Class groups and Search Individuals in one template-->
<#include "menupage-checkForData.ftl">
<#--Fixed HTML portion-->
<#--Note that variableName is employed by both the fixed html and sparql query templates, this is used to store the
actual name of the variable that is used to store either the fixed html or sparql query results. If combining fixed html
and sparql query results in a custom template, the template can utilize the actual variable name e.g. "query results" instead of how
variableName is used below.-->
<#assign htmlExists = false/>

<#if variableName?has_content>
	<#assign htmlExists = true />
</#if>
<#if htmlExists>
	${.globals[variableName]}
<#else>
	${i18n().no_html_specified}  
</#if>

<#--Class grou section-->
<#if !noData>
    <section id="menupage-intro" role="region">
        <h2>${page.title}</h2>
    </section>
    
    <#include "menupage-browse.ftl">
    
    ${stylesheets.add('<link rel="stylesheet" href="${urls.base}/css/menupage/menupage.css" />')}
    
    <#include "menupage-scripts.ftl">
<#else>
    ${noDataNotification}
</#if>

<#--Search Individuals section-->
<#import "lib-list.ftl" as l>

<#include "individualList-checkForData.ftl">

${stylesheets.add('<link rel="stylesheet" href="${urls.base}/css/browseIndex.css" />')}

<section class="individualList">
    <h2>${title!} 
    </h2>
    <#if subtitle?has_content>
        <h4>${subtitle}</h4>
    </#if>
    
    <#if (!noData)>
        <#if errorMessage?has_content>
            <p>${errorMessage}</p>
        <#else>
            <#assign pagination>
                <#if (pages?has_content && pages?size > 1)>
                    ${i18n().pages}:
                    <ul class="pagination">
                        <#list pages as page>
                            <#if page.selected>
                                <li class="selectedNavPage">${page.text}</li>
                            <#else>
                                <#-- RY Ideally the urls would be generated by the controller; see search-pagedResults.ftl -->
                                <li><a href="${urls.base}/individuallist?${page.param}&vclassId=${vclassId?url}" title="${i18n().page_text}">${page.text}</a></li>
                            </#if>
                        </#list>
                    </ul>
                </#if>
            </#assign>
            
            ${pagination}
            
            <ul>
                <#list individuals as individual>
                    <li>       
                        <@shortView uri=individual.uri viewContext="index" />
                    </li>
                </#list>
            </ul>
            
            ${pagination}
        </#if>
    <#else>
        ${noDataNotification}
    </#if>
</section> <!-- .individualList -->