/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetFileDescriptor;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.io.File;
import java.io.IOException;
import org.videolan.libvlc.AWindow;
import org.videolan.libvlc.Media;
import org.videolan.libvlc.RendererItem;
import org.videolan.libvlc.VLCObject;
import org.videolan.libvlc.VideoHelper;
import org.videolan.libvlc.interfaces.AbstractVLCEvent;
import org.videolan.libvlc.interfaces.ILibVLC;
import org.videolan.libvlc.interfaces.IMedia;
import org.videolan.libvlc.interfaces.IVLCVout;
import org.videolan.libvlc.util.AndroidUtil;
import org.videolan.libvlc.util.DisplayManager;
import org.videolan.libvlc.util.VLCUtil;
import org.videolan.libvlc.util.VLCVideoLayout;

public class MediaPlayer
extends VLCObject<Event> {
    private Boolean mUseOrientationFromBounds = false;
    public static final int SURFACE_SCALES_COUNT = ScaleType.values().length;
    private IMedia mMedia = null;
    private RendererItem mRenderer = null;
    private AssetFileDescriptor mAfd = null;
    private boolean mPlaying = false;
    private boolean mPlayRequested = false;
    private boolean mListenAudioPlug = true;
    private int mVoutCount = 0;
    private String mAudioOutput = null;
    private String mAudioOutputDevice = null;
    private boolean mAudioPlugRegistered = false;
    private boolean mAudioDigitalOutputEnabled = false;
    private String mAudioPlugOutputDevice = "stereo";
    private boolean mCanDoPassthrough;
    private VideoHelper mVideoHelper = null;
    private final AWindow mWindow = new AWindow(new AWindow.SurfaceCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSurfacesCreated(AWindow vout) {
            boolean play = false;
            boolean enableVideo = false;
            MediaPlayer mediaPlayer = MediaPlayer.this;
            synchronized (mediaPlayer) {
                if (!MediaPlayer.this.mPlaying && MediaPlayer.this.mPlayRequested) {
                    play = true;
                } else if (MediaPlayer.this.mVoutCount == 0) {
                    enableVideo = true;
                }
            }
            if (play) {
                MediaPlayer.this.play();
            } else if (enableVideo) {
                MediaPlayer.this.setVideoTrackEnabled(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSurfacesDestroyed(AWindow vout) {
            boolean disableVideo = false;
            MediaPlayer mediaPlayer = MediaPlayer.this;
            synchronized (mediaPlayer) {
                if (MediaPlayer.this.mVoutCount > 0) {
                    disableVideo = true;
                }
            }
            if (disableVideo) {
                MediaPlayer.this.setVideoTrackEnabled(false);
            }
        }
    });
    private final BroadcastReceiver mAudioPlugReceiver = !AndroidUtil.isMarshMallowOrLater ? this.createAudioPlugReceiver() : null;
    private final AudioDeviceCallback mAudioDeviceCallback = AndroidUtil.isMarshMallowOrLater ? this.createAudioDeviceCallback() : null;
    Handler mHandlerMainThread = new Handler(Looper.getMainLooper());

    private static Title createTitleFromNative(long duration, String name, int flags) {
        return new Title(duration, name, flags);
    }

    private static Chapter createChapterFromNative(long timeOffset, long duration, String name) {
        return new Chapter(timeOffset, duration, name);
    }

    private synchronized void updateAudioOutputDevice(long encodingFlags, String defaultDevice) {
        String newDeviceId;
        this.mCanDoPassthrough = encodingFlags != 0L;
        String string = newDeviceId = this.mAudioDigitalOutputEnabled && this.mCanDoPassthrough ? "encoded:" + encodingFlags : defaultDevice;
        if (!newDeviceId.equals(this.mAudioPlugOutputDevice)) {
            this.mAudioPlugOutputDevice = newDeviceId;
            this.setAudioOutputDeviceInternal(this.mAudioPlugOutputDevice, false);
        }
    }

    private boolean isEncoded(int encoding) {
        switch (encoding) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    private long getEncodingFlags(int[] encodings) {
        if (encodings == null) {
            return 0L;
        }
        long encodingFlags = 0L;
        for (int encoding : encodings) {
            if (!this.isEncoded(encoding)) continue;
            encodingFlags |= (long)(1 << encoding);
        }
        return encodingFlags;
    }

    private BroadcastReceiver createAudioPlugReceiver() {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action == null) {
                    return;
                }
                if (action.equalsIgnoreCase("android.media.action.HDMI_AUDIO_PLUG")) {
                    boolean hasHdmi = intent.getIntExtra("android.media.extra.AUDIO_PLUG_STATE", 0) == 1;
                    long encodingFlags = !hasHdmi ? 0L : MediaPlayer.this.getEncodingFlags(intent.getIntArrayExtra("android.media.extra.ENCODINGS"));
                    MediaPlayer.this.updateAudioOutputDevice(encodingFlags, "stereo");
                }
            }
        };
    }

    private void registerAudioPlugV21(boolean register) {
        if (register) {
            IntentFilter intentFilter = new IntentFilter("android.media.action.HDMI_AUDIO_PLUG");
            Intent stickyIntent = this.mILibVLC.getAppContext().registerReceiver(this.mAudioPlugReceiver, intentFilter);
            if (stickyIntent != null) {
                this.mAudioPlugReceiver.onReceive(this.mILibVLC.getAppContext(), stickyIntent);
            }
        } else {
            this.mILibVLC.getAppContext().unregisterReceiver(this.mAudioPlugReceiver);
        }
    }

    @TargetApi(value=23)
    private AudioDeviceCallback createAudioDeviceCallback() {
        return new AudioDeviceCallback(){
            private SparseArray<Long> mEncodedDevices = new SparseArray();

            private void onAudioDevicesChanged() {
                long encodingFlags = 0L;
                for (int i = 0; i < this.mEncodedDevices.size(); ++i) {
                    encodingFlags |= ((Long)this.mEncodedDevices.valueAt(i)).longValue();
                }
                String defaultDevice = encodingFlags == 0L ? "stereo" : "pcm";
                MediaPlayer.this.updateAudioOutputDevice(encodingFlags, defaultDevice);
            }

            @RequiresApi(value=23)
            public void onAudioDevicesAdded(AudioDeviceInfo[] addedDevices) {
                for (AudioDeviceInfo info : addedDevices) {
                    long encodingFlags;
                    if (!info.isSink() || (encodingFlags = MediaPlayer.this.getEncodingFlags(info.getEncodings())) == 0L) continue;
                    this.mEncodedDevices.put(info.getId(), (Object)encodingFlags);
                }
                this.onAudioDevicesChanged();
            }

            @RequiresApi(value=23)
            public void onAudioDevicesRemoved(AudioDeviceInfo[] removedDevices) {
                for (AudioDeviceInfo info : removedDevices) {
                    if (!info.isSink()) continue;
                    this.mEncodedDevices.remove(info.getId());
                }
                this.onAudioDevicesChanged();
            }
        };
    }

    @TargetApi(value=23)
    private void registerAudioPlugV23(boolean register) {
        AudioManager am = (AudioManager)this.mILibVLC.getAppContext().getSystemService(AudioManager.class);
        if (register) {
            this.mAudioDeviceCallback.onAudioDevicesAdded(am.getDevices(2));
            am.registerAudioDeviceCallback(this.mAudioDeviceCallback, null);
        } else {
            am.unregisterAudioDeviceCallback(this.mAudioDeviceCallback);
        }
    }

    private void registerAudioPlug(boolean register) {
        if (register == this.mAudioPlugRegistered) {
            return;
        }
        if (this.mAudioDeviceCallback != null) {
            this.registerAudioPlugV23(register);
        } else if (this.mAudioPlugReceiver != null) {
            this.registerAudioPlugV21(register);
        }
        this.mAudioPlugRegistered = register;
    }

    public MediaPlayer(ILibVLC ILibVLC2) {
        super(ILibVLC2);
        this.nativeNewFromLibVlc(ILibVLC2, this.mWindow);
    }

    public MediaPlayer(@NonNull IMedia media) {
        super(media);
        if (media == null || media.isReleased()) {
            throw new IllegalArgumentException("Media is null or released");
        }
        this.mMedia = media;
        this.mMedia.retain();
        this.nativeNewFromMedia(this.mMedia, this.mWindow);
    }

    @NonNull
    public IVLCVout getVLCVout() {
        return this.mWindow;
    }

    public void attachViews(@NonNull VLCVideoLayout surfaceFrame, @Nullable DisplayManager dm, boolean subtitles, boolean textureView) {
        this.mVideoHelper = new VideoHelper(this, surfaceFrame, dm, subtitles, textureView);
        this.mVideoHelper.attachViews();
    }

    public void detachViews() {
        if (this.mVideoHelper != null) {
            this.mVideoHelper.release();
            this.mVideoHelper = null;
        }
    }

    public void updateVideoSurfaces() {
        if (this.mVideoHelper != null) {
            this.mVideoHelper.updateVideoSurfaces();
        }
    }

    public void setVideoScale(@NonNull ScaleType type) {
        if (this.mVideoHelper != null) {
            this.mVideoHelper.setVideoScale(type);
        }
    }

    @NonNull
    public ScaleType getVideoScale() {
        return this.mVideoHelper != null ? this.mVideoHelper.getVideoScale() : ScaleType.SURFACE_BEST_FIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMedia(@Nullable IMedia media) {
        if (media != null) {
            if (media.isReleased()) {
                throw new IllegalArgumentException("Media is released");
            }
            media.setDefaultMediaPlayerOptions();
        }
        this.nativeSetMedia(media);
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            if (this.mMedia != null) {
                this.mMedia.release();
            }
            if (media != null) {
                media.retain();
            }
            this.mMedia = media;
        }
    }

    public int setRenderer(@Nullable RendererItem item) {
        if (this.mRenderer != null) {
            this.mRenderer.release();
        }
        if (item != null) {
            item.retain();
        }
        this.mRenderer = item;
        return this.nativeSetRenderer(item);
    }

    public synchronized boolean hasMedia() {
        return this.mMedia != null;
    }

    @Nullable
    public synchronized IMedia getMedia() {
        if (this.mMedia != null) {
            this.mMedia.retain();
        }
        return this.mMedia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            if (!this.mPlaying) {
                if (this.mListenAudioPlug) {
                    this.registerAudioPlug(true);
                }
                this.mPlayRequested = true;
                if (this.mWindow.areSurfacesWaiting()) {
                    return;
                }
            }
            this.mPlaying = true;
        }
        this.nativePlay();
    }

    public void playAsset(@NonNull Context context, @NonNull String assetFilename) throws IOException {
        this.mAfd = context.getAssets().openFd(assetFilename);
        this.play(this.mAfd);
    }

    public void play(@NonNull AssetFileDescriptor afd) {
        Media media = new Media(this.mILibVLC, afd);
        this.play(media);
    }

    public void play(@NonNull String path) {
        Media media = new Media(this.mILibVLC, path);
        this.play(media);
    }

    public void play(@NonNull Uri uri) {
        Media media = new Media(this.mILibVLC, uri);
        this.play(media);
    }

    public void play(@NonNull IMedia media) {
        this.setMedia(media);
        media.release();
        this.play();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            this.mPlayRequested = false;
            this.mPlaying = false;
        }
        this.nativeStop();
        if (this.mAfd != null) {
            try {
                this.mAfd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setVideoTitleDisplay(int position, int timeout) {
        this.nativeSetVideoTitleDisplay(position, timeout);
    }

    public float getScale() {
        return this.nativeGetScale();
    }

    public void setScale(float scale) {
        this.mVideoHelper.setCustomScale(scale);
    }

    protected void setNativeScale(float scale) {
        this.nativeSetScale(scale);
    }

    public String getAspectRatio() {
        return this.nativeGetAspectRatio();
    }

    public void setAspectRatio(String aspect) {
        this.nativeSetAspectRatio(aspect);
    }

    private boolean isAudioDigitalOutputCapable() {
        return this.mAudioOutput == null || this.mAudioOutput.contains("audiotrack");
    }

    public boolean updateViewpoint(float yaw, float pitch, float roll, float fov, boolean absolute) {
        return this.nativeUpdateViewpoint(yaw, pitch, roll, fov, absolute);
    }

    public synchronized boolean setAudioOutput(String aout) {
        boolean ret;
        this.mAudioOutput = aout;
        this.mListenAudioPlug = this.isAudioDigitalOutputCapable();
        if (!this.mListenAudioPlug) {
            this.registerAudioPlug(false);
        }
        if (!(ret = this.nativeSetAudioOutput(aout))) {
            this.mAudioOutput = null;
            this.mListenAudioPlug = false;
        }
        if (this.mListenAudioPlug) {
            this.registerAudioPlug(true);
        }
        return ret;
    }

    public synchronized boolean setAudioDigitalOutputEnabled(boolean enabled) {
        if (enabled == this.mAudioDigitalOutputEnabled) {
            return true;
        }
        if (!this.mListenAudioPlug || !this.isAudioDigitalOutputCapable()) {
            return false;
        }
        this.registerAudioPlug(false);
        this.mAudioDigitalOutputEnabled = enabled;
        this.registerAudioPlug(true);
        return true;
    }

    public synchronized boolean forceAudioDigitalEncodings(int[] encodings) {
        if (!this.isAudioDigitalOutputCapable()) {
            return false;
        }
        if (encodings.length == 0) {
            this.setAudioOutputDeviceInternal(null, true);
        } else {
            String newDeviceId = "encoded:" + this.getEncodingFlags(encodings);
            if (!newDeviceId.equals(this.mAudioPlugOutputDevice)) {
                this.mAudioPlugOutputDevice = newDeviceId;
                this.setAudioOutputDeviceInternal(this.mAudioPlugOutputDevice, true);
            }
        }
        return true;
    }

    private synchronized boolean setAudioOutputDeviceInternal(String id2, boolean fromUser) {
        boolean ret;
        this.mAudioOutputDevice = id2;
        if (fromUser) {
            boolean bl = this.mListenAudioPlug = this.mAudioOutputDevice == null && this.isAudioDigitalOutputCapable();
            if (!this.mListenAudioPlug) {
                this.registerAudioPlug(false);
            }
        }
        if (!(ret = this.nativeSetAudioOutputDevice(id2))) {
            this.mAudioOutputDevice = null;
            this.mListenAudioPlug = false;
        }
        if (this.mListenAudioPlug) {
            this.registerAudioPlug(true);
        }
        return ret;
    }

    public void setUseOrientationFromBounds(Boolean mUseOrientationFromBounds) {
        this.mUseOrientationFromBounds = mUseOrientationFromBounds;
    }

    public Boolean useOrientationFromBounds() {
        return this.mUseOrientationFromBounds;
    }

    public boolean setAudioOutputDevice(String id2) {
        return this.setAudioOutputDeviceInternal(id2, true);
    }

    public Title[] getTitles() {
        return this.nativeGetTitles();
    }

    public Chapter[] getChapters(int title) {
        return this.nativeGetChapters(title);
    }

    public IMedia.Track[] getTracks(int type) {
        return this.nativeGetTracks(type, false);
    }

    public IMedia.Track getSelectedTrack(int type) {
        return this.nativeGetSelectedTrack(type);
    }

    public IMedia.Track[] getSelectedTracks(int type) {
        return this.nativeGetTracks(type, true);
    }

    public IMedia.Track getTrackFromID(String id2) {
        return this.nativeGetTrackFromID(id2);
    }

    public boolean selectTrack(String id2) {
        return this.nativeSelectTrack(id2);
    }

    public void selectTracks(int type, String ids) {
        this.nativeSelectTracks(type, ids);
    }

    public void unselectTrackType(int type) {
        this.nativeUnselectTrackType(type);
    }

    public void setVideoTrackEnabled(boolean enabled) {
        IMedia.Track[] tracks;
        if (!enabled) {
            this.unselectTrackType(1);
        } else if (!this.isReleased() && this.hasMedia() && this.getSelectedTrack(1) == null && (tracks = this.getTracks(1)) != null) {
            this.selectTrack(tracks[0].id);
        }
    }

    public long getAudioDelay() {
        return this.nativeGetAudioDelay();
    }

    public boolean setAudioDelay(long delay) {
        return this.nativeSetAudioDelay(delay);
    }

    public long getSpuDelay() {
        return this.nativeGetSpuDelay();
    }

    public boolean setSpuDelay(long delay) {
        return this.nativeSetSpuDelay(delay);
    }

    public boolean setEqualizer(Equalizer equalizer) {
        return this.nativeSetEqualizer(equalizer);
    }

    public boolean addSlave(int type, Uri uri, boolean select) {
        return this.nativeAddSlave(type, VLCUtil.encodeVLCUri(uri), select);
    }

    public boolean record(String directory, boolean enable) {
        return this.nativeRecord(directory, enable);
    }

    public boolean addSlave(int type, String path, boolean select) {
        return this.addSlave(type, Uri.fromFile((File)new File(path)), select);
    }

    public native void setRate(float var1);

    public native float getRate();

    public native boolean isPlaying();

    public native boolean isSeekable();

    public native void pause();

    public native int getPlayerState();

    public native int getVolume();

    public native int setVolume(int var1);

    public native long getTime();

    public long setTime(long time, boolean fast) {
        return this.nativeSetTime(time, fast);
    }

    public long setTime(long time) {
        return this.nativeSetTime(time, false);
    }

    public native float getPosition();

    public void setPosition(float pos, boolean fast) {
        this.nativeSetPosition(pos, fast);
    }

    public void setPosition(float pos) {
        this.nativeSetPosition(pos, false);
    }

    public int getTeletext() {
        return this.nativeGetTeletext();
    }

    public void setTeletext(int page) {
        this.nativeSetTeletext(page);
    }

    public boolean getTeletextTransparency() {
        return this.nativeGetTeletextTransparency();
    }

    public void setTeletextTransparency(boolean transparent) {
        this.nativeSetTeletextTransparency(transparent);
    }

    public native long getLength();

    public native int getTitle();

    public native void setTitle(int var1);

    public native int getChapter();

    public native int previousChapter();

    public native int nextChapter();

    public native void setChapter(int var1);

    public native void navigate(int var1);

    public synchronized void setEventListener(EventListener listener) {
        super.setEventListener(listener);
    }

    @Override
    protected synchronized Event onEventNative(int eventType, long arg1, long arg2, float argf1, @Nullable String args1) {
        switch (eventType) {
            case 256: 
            case 262: 
            case 265: 
            case 266: {
                this.mVoutCount = 0;
                this.notify();
            }
            case 258: 
            case 259: {
                return new Event(eventType, argf1);
            }
            case 260: 
            case 261: {
                return new Event(eventType);
            }
            case 267: {
                return new Event(eventType, arg1);
            }
            case 273: {
                return new Event(eventType, arg1);
            }
            case 268: {
                return new Event(eventType, argf1);
            }
            case 274: {
                this.mVoutCount = (int)arg1;
                this.notify();
                this.mHandlerMainThread.post(new Runnable(){

                    @Override
                    public void run() {
                        MediaPlayer.this.updateVideoSurfaces();
                    }
                });
                return new Event(eventType, arg1);
            }
            case 276: 
            case 277: 
            case 278: {
                return new Event(eventType, arg1, arg2);
            }
            case 269: 
            case 270: {
                return new Event(eventType, arg1);
            }
            case 286: {
                return new Event(eventType, arg1, args1);
            }
        }
        return null;
    }

    @Override
    protected void onReleaseNative() {
        this.detachViews();
        this.mWindow.detachViews();
        this.registerAudioPlug(false);
        if (this.mMedia != null) {
            this.mMedia.release();
        }
        if (this.mRenderer != null) {
            this.mRenderer.release();
        }
        this.mVoutCount = 0;
        this.nativeRelease();
    }

    public boolean canDoPassthrough() {
        return this.mCanDoPassthrough;
    }

    public native long nativeSetTime(long var1, boolean var3);

    public native void nativeSetPosition(float var1, boolean var2);

    private native void nativeNewFromLibVlc(ILibVLC var1, AWindow var2);

    private native void nativeNewFromMedia(IMedia var1, AWindow var2);

    private native void nativeRelease();

    private native void nativeSetMedia(IMedia var1);

    private native void nativePlay();

    private native void nativeStop();

    private native int nativeSetRenderer(RendererItem var1);

    private native void nativeSetVideoTitleDisplay(int var1, int var2);

    private native float nativeGetScale();

    private native void nativeSetScale(float var1);

    private native String nativeGetAspectRatio();

    private native void nativeSetAspectRatio(String var1);

    private native boolean nativeUpdateViewpoint(float var1, float var2, float var3, float var4, boolean var5);

    private native boolean nativeSetAudioOutput(String var1);

    private native boolean nativeSetAudioOutputDevice(String var1);

    private native Title[] nativeGetTitles();

    private native Chapter[] nativeGetChapters(int var1);

    private native IMedia.Track[] nativeGetTracks(int var1, boolean var2);

    private native IMedia.Track nativeGetSelectedTrack(int var1);

    private native IMedia.Track nativeGetTrackFromID(String var1);

    private native boolean nativeSelectTrack(String var1);

    private native void nativeSelectTracks(int var1, String var2);

    private native void nativeUnselectTrackType(int var1);

    private native long nativeGetAudioDelay();

    private native boolean nativeSetAudioDelay(long var1);

    private native long nativeGetSpuDelay();

    private native boolean nativeSetSpuDelay(long var1);

    private native boolean nativeAddSlave(int var1, String var2, boolean var3);

    private native boolean nativeRecord(String var1, boolean var2);

    private native boolean nativeSetEqualizer(Equalizer var1);

    private native int nativeGetTeletext();

    private native void nativeSetTeletext(int var1);

    private native boolean nativeGetTeletextTransparency();

    private native void nativeSetTeletextTransparency(boolean var1);

    public static class Title {
        public final long duration;
        public final String name;
        private final int flags;

        public Title(long duration, String name, int flags) {
            this.duration = duration;
            this.name = name;
            this.flags = flags;
        }

        public boolean isMenu() {
            return (this.flags & 1) != 0;
        }

        public boolean isInteractive() {
            return (this.flags & 2) != 0;
        }

        private static class Flags {
            public static final int MENU = 1;
            public static final int INTERACTIVE = 2;

            private Flags() {
            }
        }
    }

    public static class Chapter {
        public final long timeOffset;
        public final long duration;
        public final String name;

        private Chapter(long timeOffset, long duration, String name) {
            this.timeOffset = timeOffset;
            this.duration = duration;
            this.name = name;
        }
    }

    public static enum ScaleType {
        SURFACE_BEST_FIT(null),
        SURFACE_FIT_SCREEN(null),
        SURFACE_FILL(null),
        SURFACE_16_9(Float.valueOf(1.7777778f)),
        SURFACE_4_3(Float.valueOf(1.3333334f)),
        SURFACE_16_10(Float.valueOf(1.6f)),
        SURFACE_2_1(Float.valueOf(2.0f)),
        SURFACE_221_1(Float.valueOf(2.21f)),
        SURFACE_235_1(Float.valueOf(2.35f)),
        SURFACE_239_1(Float.valueOf(2.39f)),
        SURFACE_5_4(Float.valueOf(1.25f)),
        SURFACE_ORIGINAL(null);

        private final Float ratio;

        private ScaleType(Float ratio) {
            this.ratio = ratio;
        }

        public Float getRatio() {
            return this.ratio;
        }

        public static ScaleType[] getMainScaleTypes() {
            return new ScaleType[]{SURFACE_BEST_FIT, SURFACE_FIT_SCREEN, SURFACE_FILL, SURFACE_16_9, SURFACE_4_3, SURFACE_ORIGINAL};
        }
    }

    public static class Equalizer {
        private long mInstance;

        private Equalizer() {
            this.nativeNew();
        }

        private Equalizer(int index) {
            this.nativeNewFromPreset(index);
        }

        protected void finalize() throws Throwable {
            try {
                this.nativeRelease();
            }
            finally {
                super.finalize();
            }
        }

        public static Equalizer create() {
            return new Equalizer();
        }

        public static Equalizer createFromPreset(int index) {
            return new Equalizer(index);
        }

        public static int getPresetCount() {
            return Equalizer.nativeGetPresetCount();
        }

        public static String getPresetName(int index) {
            return Equalizer.nativeGetPresetName(index);
        }

        public static int getBandCount() {
            return Equalizer.nativeGetBandCount();
        }

        public static float getBandFrequency(int index) {
            return Equalizer.nativeGetBandFrequency(index);
        }

        public float getPreAmp() {
            return this.nativeGetPreAmp();
        }

        public boolean setPreAmp(float preamp) {
            return this.nativeSetPreAmp(preamp);
        }

        public float getAmp(int index) {
            return this.nativeGetAmp(index);
        }

        public boolean setAmp(int index, float amp) {
            return this.nativeSetAmp(index, amp);
        }

        private static native int nativeGetPresetCount();

        private static native String nativeGetPresetName(int var0);

        private static native int nativeGetBandCount();

        private static native float nativeGetBandFrequency(int var0);

        private native void nativeNew();

        private native void nativeNewFromPreset(int var1);

        private native void nativeRelease();

        private native float nativeGetPreAmp();

        private native boolean nativeSetPreAmp(float var1);

        private native float nativeGetAmp(int var1);

        private native boolean nativeSetAmp(int var1, float var2);
    }

    public static class Event
    extends AbstractVLCEvent {
        public static final int MediaChanged = 256;
        public static final int Opening = 258;
        public static final int Buffering = 259;
        public static final int Playing = 260;
        public static final int Paused = 261;
        public static final int Stopped = 262;
        public static final int EndReached = 265;
        public static final int EncounteredError = 266;
        public static final int TimeChanged = 267;
        public static final int PositionChanged = 268;
        public static final int SeekableChanged = 269;
        public static final int PausableChanged = 270;
        public static final int LengthChanged = 273;
        public static final int Vout = 274;
        public static final int ESAdded = 276;
        public static final int ESDeleted = 277;
        public static final int ESSelected = 278;
        public static final int RecordChanged = 286;

        protected Event(int type) {
            super(type);
        }

        protected Event(int type, long arg1) {
            super(type, arg1);
        }

        protected Event(int type, long arg1, long arg2) {
            super(type, arg1, arg2);
        }

        protected Event(int type, float argf) {
            super(type, argf);
        }

        protected Event(int type, long arg1, @Nullable String args1) {
            super(type, arg1, args1);
        }

        public long getTimeChanged() {
            return this.arg1;
        }

        public long getLengthChanged() {
            return this.arg1;
        }

        public float getPositionChanged() {
            return this.argf1;
        }

        public int getVoutCount() {
            return (int)this.arg1;
        }

        public int getEsChangedType() {
            return (int)this.arg1;
        }

        public int getEsChangedID() {
            return (int)this.arg2;
        }

        public boolean getPausable() {
            return this.arg1 != 0L;
        }

        public boolean getSeekable() {
            return this.arg1 != 0L;
        }

        public float getBuffering() {
            return this.argf1;
        }

        public boolean getRecording() {
            return this.arg1 != 0L;
        }

        @Nullable
        public String getRecordPath() {
            return this.args1;
        }
    }

    public static class Navigate {
        public static final int Activate = 0;
        public static final int Up = 1;
        public static final int Down = 2;
        public static final int Left = 3;
        public static final int Right = 4;
    }

    public static class Position {
        public static final int Disable = -1;
        public static final int Center = 0;
        public static final int Left = 1;
        public static final int Right = 2;
        public static final int Top = 3;
        public static final int TopLeft = 4;
        public static final int TopRight = 5;
        public static final int Bottom = 6;
        public static final int BottomLeft = 7;
        public static final int BottomRight = 8;
    }

    public static interface EventListener
    extends AbstractVLCEvent.Listener<Event> {
    }
}

