/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.os.Handler;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import org.videolan.libvlc.Media;
import org.videolan.libvlc.MediaDiscoverer;
import org.videolan.libvlc.VLCObject;
import org.videolan.libvlc.interfaces.ILibVLC;
import org.videolan.libvlc.interfaces.IMedia;
import org.videolan.libvlc.interfaces.IMediaList;

public class MediaList
extends VLCObject<IMediaList.Event>
implements IMediaList {
    private static final String TAG = "LibVLC/MediaList";
    private int mCount = 0;
    private final SparseArray<IMedia> mMediaArray = new SparseArray();
    private boolean mLocked = false;

    private void init() {
        this.lock();
        this.mCount = this.nativeGetCount();
        for (int i = 0; i < this.mCount; ++i) {
            this.mMediaArray.put(i, (Object)new Media(this, i));
        }
        this.unlock();
    }

    public MediaList(ILibVLC ILibVLC2) {
        super(ILibVLC2);
        this.nativeNewFromLibVlc(ILibVLC2);
        this.init();
    }

    protected MediaList(MediaDiscoverer md) {
        super(md);
        this.nativeNewFromMediaDiscoverer(md);
        this.init();
    }

    protected MediaList(IMedia m) {
        super(m);
        this.nativeNewFromMedia(m);
        this.init();
    }

    private synchronized IMedia insertMediaFromEvent(int index) {
        for (int i = this.mCount - 1; i >= index; --i) {
            this.mMediaArray.put(i + 1, (Object)((IMedia)this.mMediaArray.valueAt(i)));
        }
        ++this.mCount;
        Media media = new Media(this, index);
        this.mMediaArray.put(index, (Object)media);
        return media;
    }

    private synchronized IMedia removeMediaFromEvent(int index) {
        --this.mCount;
        IMedia media = (IMedia)this.mMediaArray.get(index);
        if (media != null) {
            media.release();
        }
        for (int i = index; i < this.mCount; ++i) {
            this.mMediaArray.put(i, (Object)((IMedia)this.mMediaArray.valueAt(i + 1)));
        }
        return media;
    }

    @Override
    public void setEventListener(IMediaList.EventListener listener, Handler handler) {
        super.setEventListener(listener, handler);
    }

    @Override
    protected synchronized IMediaList.Event onEventNative(int eventType, long arg1, long arg2, float argf1, @Nullable String args1) {
        if (this.mLocked) {
            throw new IllegalStateException("already locked from event callback");
        }
        this.mLocked = true;
        IMediaList.Event event = null;
        switch (eventType) {
            case 512: {
                int index = (int)arg1;
                if (index == -1) break;
                IMedia media = this.insertMediaFromEvent(index);
                event = new IMediaList.Event(eventType, media, true, index);
                break;
            }
            case 514: {
                int index = (int)arg1;
                if (index == -1) break;
                IMedia media = this.removeMediaFromEvent(index);
                event = new IMediaList.Event(eventType, media, false, index);
                break;
            }
            case 516: {
                event = new IMediaList.Event(eventType, null, false, -1);
            }
        }
        this.mLocked = false;
        return event;
    }

    @Override
    public synchronized int getCount() {
        return this.mCount;
    }

    @Override
    public synchronized IMedia getMediaAt(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new IndexOutOfBoundsException();
        }
        IMedia media = (IMedia)this.mMediaArray.get(index);
        media.retain();
        return media;
    }

    @Override
    public void onReleaseNative() {
        for (int i = 0; i < this.mMediaArray.size(); ++i) {
            IMedia media = (IMedia)this.mMediaArray.get(i);
            if (media == null) continue;
            media.release();
        }
        this.nativeRelease();
    }

    private synchronized void lock() {
        if (this.mLocked) {
            throw new IllegalStateException("already locked");
        }
        this.mLocked = true;
        this.nativeLock();
    }

    private synchronized void unlock() {
        if (!this.mLocked) {
            throw new IllegalStateException("not locked");
        }
        this.mLocked = false;
        this.nativeUnlock();
    }

    @Override
    public synchronized boolean isLocked() {
        return this.mLocked;
    }

    private native void nativeNewFromLibVlc(ILibVLC var1);

    private native void nativeNewFromMediaDiscoverer(MediaDiscoverer var1);

    private native void nativeNewFromMedia(IMedia var1);

    private native void nativeRelease();

    private native int nativeGetCount();

    private native void nativeLock();

    private native void nativeUnlock();
}

