/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import androidx.annotation.Nullable;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.MediaList;
import org.videolan.libvlc.VLCEvent;
import org.videolan.libvlc.VLCObject;

public class MediaDiscoverer
extends VLCObject<Event> {
    private static final String TAG = "LibVLC/MediaDiscoverer";
    private MediaList mMediaList = null;

    private static Description createDescriptionFromNative(String name, String longName, int category) {
        return new Description(name, longName, category);
    }

    public MediaDiscoverer(LibVLC libVLC, String name) {
        super(libVLC);
        this.nativeNew(libVLC, name);
    }

    public boolean start() {
        if (this.isReleased()) {
            throw new IllegalStateException("MediaDiscoverer is released");
        }
        return this.nativeStart();
    }

    public void stop() {
        if (this.isReleased()) {
            throw new IllegalStateException("MediaDiscoverer is released");
        }
        this.nativeStop();
    }

    public void setEventListener(EventListener listener) {
        super.setEventListener(listener);
    }

    @Override
    protected Event onEventNative(int eventType, long arg1, long arg2, float argf1, @Nullable String args1) {
        switch (eventType) {
            case 1280: 
            case 1281: {
                return new Event(eventType);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaList getMediaList() {
        MediaDiscoverer mediaDiscoverer = this;
        synchronized (mediaDiscoverer) {
            if (this.mMediaList != null) {
                this.mMediaList.retain();
                return this.mMediaList;
            }
        }
        MediaList mediaList = new MediaList(this);
        MediaDiscoverer mediaDiscoverer2 = this;
        synchronized (mediaDiscoverer2) {
            this.mMediaList = mediaList;
            this.mMediaList.retain();
            return this.mMediaList;
        }
    }

    @Override
    protected void onReleaseNative() {
        if (this.mMediaList != null) {
            this.mMediaList.release();
        }
        this.nativeRelease();
    }

    @Nullable
    public static Description[] list(LibVLC libVLC, int category) {
        return MediaDiscoverer.nativeList(libVLC, category);
    }

    private native void nativeNew(LibVLC var1, String var2);

    private native void nativeRelease();

    private native boolean nativeStart();

    private native void nativeStop();

    private static native Description[] nativeList(LibVLC var0, int var1);

    public static interface EventListener
    extends VLCEvent.Listener<Event> {
    }

    public static class Description {
        public final String name;
        public final String longName;
        public final int category;

        private Description(String name, String longName, int category) {
            this.name = name;
            this.longName = longName;
            this.category = category;
        }

        public static class Category {
            public static final int Devices = 0;
            public static final int Lan = 1;
            public static final int Podcasts = 2;
            public static final int LocalDirs = 3;
        }
    }

    public static class Event
    extends VLCEvent {
        public static final int Started = 1280;
        public static final int Ended = 1281;

        protected Event(int type) {
            super(type);
        }
    }
}

