/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.objectpool.util;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.vibur.objectpool.BasePool;
import org.vibur.objectpool.util.ArgumentValidation;
import org.vibur.objectpool.util.ThreadedPoolReducer;

public class SamplingPoolReducer
implements ThreadedPoolReducer {
    protected static final double MAX_REDUCTION_FRACTION = 0.2;
    protected int minRemainingCreated;
    private final BasePool pool;
    private final long sleepTimeout;
    private final TimeUnit unit;
    private final int samples;
    private final Thread reducerThread;
    private volatile boolean terminated = false;

    public SamplingPoolReducer(BasePool pool, long timeInterval, TimeUnit unit, int samples) {
        ArgumentValidation.forbidIllegalArgument(timeInterval <= 0L);
        ArgumentValidation.forbidIllegalArgument(samples <= 0);
        this.sleepTimeout = timeInterval / (long)samples;
        ArgumentValidation.forbidIllegalArgument(this.sleepTimeout == 0L);
        this.pool = Objects.requireNonNull(pool);
        this.unit = Objects.requireNonNull(unit);
        this.samples = samples;
        this.reducerThread = new Thread(new PoolReducerRunnable());
    }

    @Override
    public void start() {
        this.reducerThread.setName(this.toString());
        this.reducerThread.setDaemon(true);
        this.reducerThread.setPriority(8);
        this.reducerThread.start();
    }

    protected void samplePool() {
        int remainingCreated = this.pool.remainingCreated();
        this.minRemainingCreated = Math.min(this.minRemainingCreated, remainingCreated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reducePool() {
        int reduction = this.calculateReduction();
        int reduced = -1;
        Throwable thrown = null;
        try {
            reduced = this.pool.reduceCreated(reduction, false);
        }
        catch (Error | RuntimeException e) {
            thrown = e;
        }
        finally {
            this.afterReduce(reduction, reduced, thrown);
        }
    }

    protected int calculateReduction() {
        int createdTotal = this.pool.createdTotal();
        int maxReduction = (int)Math.ceil((double)createdTotal * 0.2);
        int reduction = Math.min(this.minRemainingCreated, maxReduction);
        int bottomThreshold = createdTotal - this.pool.initialSize();
        reduction = Math.min(reduction, bottomThreshold);
        return Math.max(reduction, 0);
    }

    protected void afterReduce(int reduction, int reduced, Throwable thrown) {
        if (thrown != null) {
            this.terminate();
        }
    }

    @Override
    public Thread.State getState() {
        return this.reducerThread.getState();
    }

    @Override
    public void terminate() {
        this.terminated = true;
        this.reducerThread.interrupt();
    }

    private class PoolReducerRunnable
    implements Runnable {
        private PoolReducerRunnable() {
        }

        @Override
        public void run() {
            int sample = 1;
            SamplingPoolReducer.this.minRemainingCreated = Integer.MAX_VALUE;
            while (!SamplingPoolReducer.this.terminated) {
                try {
                    SamplingPoolReducer.this.unit.sleep(SamplingPoolReducer.this.sleepTimeout);
                    SamplingPoolReducer.this.samplePool();
                    if (sample++ % SamplingPoolReducer.this.samples != 0) continue;
                    SamplingPoolReducer.this.reducePool();
                    sample = 1;
                    SamplingPoolReducer.this.minRemainingCreated = Integer.MAX_VALUE;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

