/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.objectpool;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.vibur.objectpool.AbstractValidatingPoolService;
import org.vibur.objectpool.ConcurrentLinkedPool;
import org.vibur.objectpool.Holder;
import org.vibur.objectpool.HolderValidatingPoolService;
import org.vibur.objectpool.PoolObjectFactory;

public class ConcurrentHolderLinkedPool<T>
extends AbstractValidatingPoolService<T>
implements HolderValidatingPoolService<T> {
    private final ConcurrentMap<Holder<T>, T> taken;
    private final AtomicInteger idGen = new AtomicInteger(0);
    private final boolean additionalInfo;

    public ConcurrentHolderLinkedPool(PoolObjectFactory<T> poolObjectFactory, int initialSize, int maxSize, boolean fair) {
        this(poolObjectFactory, initialSize, maxSize, fair, false);
    }

    public ConcurrentHolderLinkedPool(PoolObjectFactory<T> poolObjectFactory, int initialSize, int maxSize, boolean fair, boolean additionalInfo) {
        super(new ConcurrentLinkedPool<T>(poolObjectFactory, initialSize, maxSize, fair));
        this.taken = new ConcurrentHashMap<Holder<T>, T>(maxSize);
        this.additionalInfo = additionalInfo;
    }

    @Override
    public Holder<T> take() {
        Object object = this.nonValidatingPoolService.take();
        if (object == null) {
            return null;
        }
        return this.newHolder(object);
    }

    @Override
    public Holder<T> takeUninterruptibly() {
        Object object = this.nonValidatingPoolService.takeUninterruptibly();
        return this.newHolder(object);
    }

    @Override
    public Holder<T> tryTake(long timeout, TimeUnit unit) {
        Object object = this.nonValidatingPoolService.tryTake(timeout, unit);
        if (object == null) {
            return null;
        }
        return this.newHolder(object);
    }

    @Override
    public Holder<T> tryTake() {
        Object object = this.nonValidatingPoolService.tryTake();
        if (object == null) {
            return null;
        }
        return this.newHolder(object);
    }

    protected Holder<T> newHolder(T object) {
        ObjectHolder holder = !this.additionalInfo ? new ObjectHolder(this.idGen.getAndIncrement(), object) : new ObjectHolder(this.idGen.getAndIncrement(), object, new Throwable().getStackTrace(), System.currentTimeMillis());
        this.taken.put(holder, object);
        return holder;
    }

    @Override
    public boolean restore(Holder<T> holder) {
        return this.restore(holder, true);
    }

    @Override
    public boolean restore(Holder<T> holder, boolean valid) {
        if (!this.taken.remove(holder, holder.value())) {
            return false;
        }
        this.nonValidatingPoolService.restore(holder.value(), valid);
        return true;
    }

    @Override
    public List<Holder<T>> takenHolders() {
        return new ArrayList<Holder<T>>(this.taken.keySet());
    }

    private static class ObjectHolder<T>
    implements Holder<T> {
        private final int valueId;
        private final T value;
        private final StackTraceElement[] stackTrace;
        private long time;

        private ObjectHolder(int valueId, T value) {
            this(valueId, value, null, -1L);
        }

        private ObjectHolder(int valueId, T value, StackTraceElement[] stackTrace, long time) {
            this.valueId = valueId;
            this.value = value;
            this.stackTrace = stackTrace;
            this.time = time;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        public int hashCode() {
            return this.valueId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.valueId == ((ObjectHolder)obj).valueId;
        }
    }
}

