/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.objectpool.util;

import java.util.concurrent.TimeUnit;
import org.vibur.objectpool.BasePoolService;
import org.vibur.objectpool.util.ThreadedPoolReducer;

public class SamplingPoolReducer
implements ThreadedPoolReducer {
    private static final double MAX_REDUCTION_FRACTION = 0.2;
    private int minRemainingCreated;
    private final BasePoolService poolService;
    private final long timeInterval;
    private final long sleepTimeout;
    private final TimeUnit unit;
    private final int samples;
    private final Thread reducerThread;
    private volatile boolean terminated = false;

    public SamplingPoolReducer(BasePoolService poolService, long timeInterval, TimeUnit unit, int samples) {
        if (poolService == null || timeInterval <= 0L || unit == null || samples <= 0) {
            throw new IllegalArgumentException();
        }
        this.poolService = poolService;
        this.timeInterval = timeInterval;
        this.unit = unit;
        this.samples = samples;
        this.sleepTimeout = timeInterval / (long)this.samples;
        this.reducerThread = new Thread(new PoolReducerRunnable());
        this.reducerThread.setName(this.toString());
        this.reducerThread.setDaemon(true);
        this.reducerThread.setPriority(8);
    }

    @Override
    public void start() {
        this.reducerThread.start();
    }

    protected void samplePool() {
        int remainingCreated = this.poolService.remainingCreated();
        this.minRemainingCreated = Math.min(this.minRemainingCreated, remainingCreated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reducePool() {
        int reduction = this.calculateReduction();
        if (reduction > 0) {
            int reduced = -1;
            Throwable thrown = null;
            try {
                reduced = this.poolService.reduceCreated(reduction, false);
            }
            catch (RuntimeException e) {
                thrown = e;
            }
            catch (Error e) {
                thrown = e;
            }
            finally {
                try {
                    this.afterReduce(reduction, reduced, thrown);
                }
                catch (Throwable t) {
                    this.terminate();
                }
            }
        }
    }

    protected int calculateReduction() {
        int createdTotal = this.poolService.createdTotal();
        int maxReduction = (int)((double)createdTotal * 0.2);
        int reduction = Math.min(this.minRemainingCreated, maxReduction);
        int bottomThreshold = createdTotal - this.poolService.initialSize();
        reduction = Math.min(reduction, bottomThreshold);
        return Math.max(reduction, 0);
    }

    protected void afterReduce(int reduction, int reduced, Throwable thrown) {
    }

    @Override
    public Thread.State getState() {
        return this.reducerThread.getState();
    }

    @Override
    public void terminate() {
        this.terminated = true;
        this.reducerThread.interrupt();
    }

    private class PoolReducerRunnable
    implements Runnable {
        private PoolReducerRunnable() {
        }

        @Override
        public void run() {
            int sample = 1;
            SamplingPoolReducer.this.minRemainingCreated = Integer.MAX_VALUE;
            while (!SamplingPoolReducer.this.terminated) {
                try {
                    SamplingPoolReducer.this.unit.sleep(SamplingPoolReducer.this.sleepTimeout);
                    SamplingPoolReducer.this.samplePool();
                    if (sample++ % SamplingPoolReducer.this.samples != 0) continue;
                    SamplingPoolReducer.this.reducePool();
                    sample = 1;
                    SamplingPoolReducer.this.minRemainingCreated = Integer.MAX_VALUE;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

