/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.objectpool;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.vibur.objectpool.AbstractBasePoolService;
import org.vibur.objectpool.NonValidatingPoolService;
import org.vibur.objectpool.PoolObjectFactory;

public class ConcurrentLinkedPool<T>
extends AbstractBasePoolService
implements NonValidatingPoolService<T> {
    private final PoolObjectFactory<T> poolObjectFactory;
    private final Semaphore takeSemaphore;
    private final Queue<T> available;
    private final int initialSize;
    private final AtomicInteger maxSize;
    private final AtomicInteger createdTotal;
    private final AtomicBoolean terminated = new AtomicBoolean(false);

    public ConcurrentLinkedPool(PoolObjectFactory<T> poolObjectFactory, int initialSize, int maxSize, boolean fair) {
        if (initialSize < 0 || maxSize < 1 || maxSize < initialSize) {
            throw new IllegalArgumentException();
        }
        if (poolObjectFactory == null) {
            throw new NullPointerException();
        }
        this.poolObjectFactory = poolObjectFactory;
        this.takeSemaphore = new Semaphore(maxSize, fair);
        this.available = new ConcurrentLinkedQueue<T>();
        for (int i = 0; i < initialSize; ++i) {
            this.available.add(this.create());
        }
        this.initialSize = initialSize;
        this.maxSize = new AtomicInteger(maxSize);
        this.createdTotal = new AtomicInteger(initialSize);
    }

    private T create() {
        T object = this.poolObjectFactory.create();
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    @Override
    public T take() {
        try {
            this.takeSemaphore.acquire();
            return this.newObject();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public T takeUninterruptibly() {
        this.takeSemaphore.acquireUninterruptibly();
        return this.newObject();
    }

    @Override
    public T tryTake(long timeout, TimeUnit unit) {
        try {
            if (!this.takeSemaphore.tryAcquire(timeout, unit)) {
                return null;
            }
            return this.newObject();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public T tryTake() {
        if (!this.takeSemaphore.tryAcquire()) {
            return null;
        }
        return this.newObject();
    }

    protected T newObject() {
        if (this.isTerminated()) {
            this.takeSemaphore.release();
            return null;
        }
        T object = this.available.poll();
        object = this.readyToTake(object);
        return object;
    }

    @Override
    public void restore(T object) {
        this.restore(object, true);
    }

    @Override
    public void restore(T object, boolean valid) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.isTerminated()) {
            return;
        }
        if ((object = this.readyToRestore(object, valid)) != null) {
            this.available.add(object);
        }
        this.takeSemaphore.release();
    }

    private T readyToTake(T object) {
        try {
            if (object == null) {
                this.createdTotal.incrementAndGet();
                object = this.create();
            } else if (!this.poolObjectFactory.readyToTake(object)) {
                this.poolObjectFactory.destroy(object);
                object = this.create();
            }
            return object;
        }
        catch (RuntimeException e) {
            this.recoverInnerState(1);
            throw e;
        }
        catch (Error e) {
            this.recoverInnerState(1);
            throw e;
        }
    }

    private T readyToRestore(T object, boolean valid) {
        try {
            if (!valid || !this.poolObjectFactory.readyToRestore(object)) {
                this.poolObjectFactory.destroy(object);
                this.createdTotal.decrementAndGet();
                object = null;
            }
            return object;
        }
        catch (RuntimeException e) {
            this.recoverInnerState(1);
            throw e;
        }
        catch (Error e) {
            this.recoverInnerState(1);
            throw e;
        }
    }

    private void recoverInnerState(int permits) {
        this.createdTotal.addAndGet(-permits);
        this.takeSemaphore.release(permits);
    }

    @Override
    public int createdTotal() {
        return this.createdTotal.get();
    }

    @Override
    public int remainingCapacity() {
        return this.isTerminated() ? 0 : this.takeSemaphore.availablePermits();
    }

    @Override
    public int initialSize() {
        return this.initialSize;
    }

    @Override
    public int maxSize() {
        return this.maxSize.get();
    }

    @Override
    public int reduceCreated(int reduction, boolean ignoreInitialSize) {
        int cnt;
        if (reduction < 0) {
            throw new IllegalArgumentException();
        }
        for (cnt = 0; cnt < reduction; ++cnt) {
            int newTotal = this.createdTotal.decrementAndGet();
            if (!ignoreInitialSize && newTotal < this.initialSize) {
                this.createdTotal.incrementAndGet();
                break;
            }
            T object = this.available.poll();
            if (object == null) {
                this.createdTotal.incrementAndGet();
                break;
            }
            this.poolObjectFactory.destroy(object);
        }
        return cnt;
    }

    @Override
    public void terminate() {
        if (this.terminated.getAndSet(true)) {
            return;
        }
        this.takeSemaphore.release(this.takeSemaphore.getQueueLength() + 4096);
        this.drainCreated();
    }

    @Override
    public boolean isTerminated() {
        return this.terminated.get();
    }

    @Override
    public boolean isFair() {
        return this.takeSemaphore.isFair();
    }
}

