/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.parsers.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class IndefiniteLengthConverter {
    public static final int LENGTH_LONG = 128;
    private static final int TAG_MASK = 31;
    private static final int FORM_MASK = 32;
    private static final int CLASS_MASK = 192;
    private static final int LENGTH_MASK = 127;
    private final ArrayList<Object> indefiniteDataList = new ArrayList();
    private int unresolved = 0;
    private int totalLenBytesCount = 0;
    private byte[] curData;
    private byte[] newData;
    private int newDataIndex;
    private int curDataIndex;
    private int curDataSize;
    private int index;

    public static boolean isIndefinite(int lenByte) {
        return IndefiniteLengthConverter.isLongForm(lenByte) && (lenByte & 0x7F) == 0;
    }

    public static boolean isLongForm(int lenByte) {
        return (lenByte & 0x80) == 128;
    }

    public static byte[] convertStream(InputStream in, byte lengthByte, byte tag) throws IOException {
        int bytesReadLength = in.available();
        int offset = 2;
        byte[] indefiniteData = new byte[bytesReadLength + offset];
        indefiniteData[0] = tag;
        indefiniteData[1] = lengthByte;
        while (true) {
            byte[] bytes;
            int bytesReadCount;
            if (bytesReadLength != (bytesReadCount = in.read(indefiniteData, offset, bytesReadLength))) {
                indefiniteData = Arrays.copyOf(indefiniteData, offset + bytesReadCount);
                bytesReadLength = bytesReadCount;
            }
            if ((bytes = new IndefiniteLengthConverter().convertBytes(indefiniteData)) != null) {
                return bytes;
            }
            int nextByte = in.read();
            if (nextByte == -1) {
                throw new IOException("Error resolving indefinite length BER");
            }
            int available = in.available();
            indefiniteData = Arrays.copyOf(indefiniteData, offset + bytesReadLength + available + 1);
            indefiniteData[bytesReadLength + offset] = (byte)nextByte;
            offset += bytesReadLength + 1;
            bytesReadLength = available;
        }
    }

    public byte[] convertBytes(byte[] indefiniteData) throws IOException {
        this.index = 0;
        this.curDataIndex = 0;
        this.curData = indefiniteData;
        this.curDataSize = this.curData.length;
        int unusedBytes = 0;
        while (this.curDataIndex < this.curDataSize) {
            if (this.curDataIndex + 2 <= this.curDataSize) {
                this.parseTag();
                int length = this.parseLen();
                if (length >= 0) {
                    this.curDataIndex += length;
                    if (this.unresolved != 0) continue;
                    unusedBytes = this.curDataSize - this.curDataIndex;
                    this.curDataSize = this.curDataIndex;
                    break;
                }
                return null;
            }
            return null;
        }
        if (this.unresolved != 0) {
            return null;
        }
        this.curDataIndex = 0;
        this.newDataIndex = 0;
        this.index = 0;
        this.newData = new byte[this.curDataSize + this.totalLenBytesCount + unusedBytes];
        while (this.curDataIndex < this.curDataSize) {
            this.writeTag();
            this.writeLenAndVal();
        }
        System.arraycopy(indefiniteData, this.curDataSize, this.newData, this.curDataSize + this.totalLenBytesCount, unusedBytes);
        return this.newData;
    }

    private boolean isEndOfContents(int tag) {
        return (tag & 0x1F) == 0 && (tag & 0xC0) == 0 && (tag & 0x20) == 0;
    }

    private void parseTag() throws IOException {
        int i;
        if (this.curData[this.curDataIndex + 1] != 0 || !this.isEndOfContents(this.curData[this.curDataIndex])) {
            ++this.curDataIndex;
            return;
        }
        int encapsulatedLengthBytesCount = 0;
        Object item = null;
        for (i = this.indefiniteDataList.size() - 1; i >= 0 && !((item = this.indefiniteDataList.get(i)) instanceof Integer); --i) {
            encapsulatedLengthBytesCount += ((byte[])item).length - 3;
        }
        if (i < 0) {
            throw new IOException("End of contents doesn't have matching indefinite len tag");
        }
        byte[] sectLengthBytes = IndefiniteLengthConverter.getLenBytes(this.curDataIndex + encapsulatedLengthBytesCount - (Integer)item);
        this.indefiniteDataList.set(i, sectLengthBytes);
        --this.unresolved;
        this.totalLenBytesCount += sectLengthBytes.length - 3;
        ++this.curDataIndex;
    }

    private void writeTag() {
        if (this.curDataSize != this.curDataIndex) {
            byte tag = this.curData[this.curDataIndex++];
            if (this.curData[this.curDataIndex] != 0 || !this.isEndOfContents(tag)) {
                this.newData[this.newDataIndex++] = tag;
            } else {
                ++this.curDataIndex;
                this.writeTag();
            }
        }
    }

    private int parseLen() throws IOException {
        int len = 0;
        if (this.curDataSize != this.curDataIndex) {
            int lengthByte;
            if (IndefiniteLengthConverter.isIndefinite(lengthByte = this.curData[this.curDataIndex++] & 0xFF)) {
                this.indefiniteDataList.add(this.curDataIndex);
                ++this.unresolved;
                return len;
            }
            if (!IndefiniteLengthConverter.isLongForm(lengthByte)) {
                len = lengthByte & 0x7F;
            } else {
                if ((lengthByte &= 0x7F) > 4) {
                    throw new IOException("Data is too big");
                }
                if (this.curDataSize - this.curDataIndex < lengthByte + 1) {
                    return -1;
                }
                for (int i = 0; i < lengthByte; ++i) {
                    len = (len << 8) + (this.curData[this.curDataIndex++] & 0xFF);
                }
                if (len < 0) {
                    throw new IOException("Length bytes are invalid");
                }
            }
        }
        return len;
    }

    private void writeLenAndVal() throws IOException {
        if (this.curDataSize != this.curDataIndex) {
            int i;
            int lengthByte;
            if (IndefiniteLengthConverter.isIndefinite(lengthByte = this.curData[this.curDataIndex++] & 0xFF)) {
                byte[] lenBytes = (byte[])this.indefiniteDataList.get(this.index++);
                System.arraycopy(lenBytes, 0, this.newData, this.newDataIndex, lenBytes.length);
                this.newDataIndex += lenBytes.length;
                return;
            }
            int len = 0;
            if (!IndefiniteLengthConverter.isLongForm(lengthByte)) {
                len = lengthByte & 0x7F;
            } else {
                lengthByte &= 0x7F;
                for (i = 0; i < lengthByte; ++i) {
                    len = (len << 8) + (this.curData[this.curDataIndex++] & 0xFF);
                }
                if (len < 0) {
                    throw new IOException("Length bytes are invalid");
                }
            }
            this.writeLen(len);
            for (i = 0; i < len; ++i) {
                this.newData[this.newDataIndex++] = this.curData[this.curDataIndex++];
            }
        }
    }

    private void writeLen(int len) {
        byte[] lengthBytes = IndefiniteLengthConverter.getLenBytes(len);
        System.arraycopy(lengthBytes, 0, this.newData, this.newDataIndex, lengthBytes.length);
        this.newDataIndex += lengthBytes.length;
    }

    protected static byte[] getLenBytes(int len) {
        byte[] lengthBytes;
        int i = 0;
        if (len >= 0x1000000) {
            lengthBytes = new byte[5];
            lengthBytes[i++] = -124;
            lengthBytes[i++] = (byte)(len >> 24);
            lengthBytes[i++] = (byte)(len >> 16);
            lengthBytes[i++] = (byte)(len >> 8);
            lengthBytes[i] = (byte)len;
        } else if (len >= 65536) {
            lengthBytes = new byte[4];
            lengthBytes[i++] = -125;
            lengthBytes[i++] = (byte)(len >> 16);
            lengthBytes[i++] = (byte)(len >> 8);
            lengthBytes[i] = (byte)len;
        } else if (len >= 256) {
            lengthBytes = new byte[3];
            lengthBytes[i++] = -126;
            lengthBytes[i++] = (byte)(len >> 8);
            lengthBytes[i] = (byte)len;
        } else if (len >= 128) {
            lengthBytes = new byte[2];
            lengthBytes[i++] = -127;
            lengthBytes[i] = (byte)len;
        } else {
            lengthBytes = new byte[1];
            lengthBytes[i] = (byte)len;
        }
        return lengthBytes;
    }
}

