/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.xz.xz;

import java.io.InputStream;
import org.vafer.jdeb.shaded.xz.xz.ArrayCache;
import org.vafer.jdeb.shaded.xz.xz.BCJCoder;
import org.vafer.jdeb.shaded.xz.xz.FilterDecoder;
import org.vafer.jdeb.shaded.xz.xz.SimpleInputStream;
import org.vafer.jdeb.shaded.xz.xz.UnsupportedOptionsException;
import org.vafer.jdeb.shaded.xz.xz.simple.ARM;
import org.vafer.jdeb.shaded.xz.xz.simple.ARMThumb;
import org.vafer.jdeb.shaded.xz.xz.simple.IA64;
import org.vafer.jdeb.shaded.xz.xz.simple.PowerPC;
import org.vafer.jdeb.shaded.xz.xz.simple.SPARC;
import org.vafer.jdeb.shaded.xz.xz.simple.SimpleFilter;
import org.vafer.jdeb.shaded.xz.xz.simple.X86;

class BCJDecoder
extends BCJCoder
implements FilterDecoder {
    private final long filterID;
    private final int startOffset;

    BCJDecoder(long l, byte[] byArray) throws UnsupportedOptionsException {
        assert (BCJDecoder.isBCJFilterID(l));
        this.filterID = l;
        if (byArray.length == 0) {
            this.startOffset = 0;
        } else if (byArray.length == 4) {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                n |= (byArray[i] & 0xFF) << i * 8;
            }
            this.startOffset = n;
        } else {
            throw new UnsupportedOptionsException("Unsupported BCJ filter properties");
        }
    }

    public int getMemoryUsage() {
        return SimpleInputStream.getMemoryUsage();
    }

    public InputStream getInputStream(InputStream inputStream, ArrayCache arrayCache) {
        SimpleFilter simpleFilter = null;
        if (this.filterID == 4L) {
            simpleFilter = new X86(false, this.startOffset);
        } else if (this.filterID == 5L) {
            simpleFilter = new PowerPC(false, this.startOffset);
        } else if (this.filterID == 6L) {
            simpleFilter = new IA64(false, this.startOffset);
        } else if (this.filterID == 7L) {
            simpleFilter = new ARM(false, this.startOffset);
        } else if (this.filterID == 8L) {
            simpleFilter = new ARMThumb(false, this.startOffset);
        } else if (this.filterID == 9L) {
            simpleFilter = new SPARC(false, this.startOffset);
        } else assert (false);
        return new SimpleInputStream(inputStream, simpleFilter);
    }
}

