/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.IOException;
import java.io.InputStream;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarArchiveEntry;
import org.vafer.jdeb.shaded.commons.io.IOUtils;

class Producers {
    static final int ROOT_UID = 0;
    static final String ROOT_NAME = "root";

    private Producers() {
    }

    static TarArchiveEntry defaultFileEntryWithName(String fileName) {
        TarArchiveEntry entry = new TarArchiveEntry(fileName, true);
        entry.setUserId(0);
        entry.setUserName(ROOT_NAME);
        entry.setGroupId(0);
        entry.setGroupName(ROOT_NAME);
        entry.setMode(33188);
        return entry;
    }

    static TarArchiveEntry defaultDirEntryWithName(String dirName) {
        TarArchiveEntry entry = new TarArchiveEntry(dirName, true);
        entry.setUserId(0);
        entry.setUserName(ROOT_NAME);
        entry.setGroupId(0);
        entry.setGroupName(ROOT_NAME);
        entry.setMode(16877);
        return entry;
    }

    static void produceDirEntry(DataConsumer consumer, TarArchiveEntry dirEntry) throws IOException {
        consumer.onEachDir(dirEntry);
    }

    static void produceInputStreamWithEntry(DataConsumer consumer, InputStream inputStream, TarArchiveEntry entry) throws IOException {
        try {
            consumer.onEachFile(inputStream, entry);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }
}

