/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.boot;

import java.util.EventListener;
import org.atmosphere.cpr.SessionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SessionSupport.class})
public class AtmosphereAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(AtmosphereAutoConfiguration.class);

    @Configuration
    static class AtmosphereSessionSupportConfiguration
    implements InitializingBean {
        AtmosphereSessionSupportConfiguration() {
        }

        public void afterPropertiesSet() throws Exception {
            logger.debug("{} initialized", (Object)this.getClass().getName());
        }

        @Bean
        ServletListenerRegistrationBean<SessionSupport> atmosphereSessionSupport() {
            return new ServletListenerRegistrationBean((EventListener)new SessionSupport());
        }
    }
}

