/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.portlet;

import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.UICreateEvent;
import com.vaadin.server.UIProvider;
import com.vaadin.spring.internal.UIID;
import com.vaadin.ui.UI;
import com.vaadin.util.CurrentInstance;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.vaadin.spring.annotation.VaadinPortletUI;

public class SpringAwareUIProvider
extends UIProvider {
    private static final long serialVersionUID = -6195911893325385491L;
    private static final Logger logger = LoggerFactory.getLogger(SpringAwareUIProvider.class);
    private final Map<String, Class<? extends UI>> uiNameToUiClassMap = new ConcurrentHashMap<String, Class<? extends UI>>();
    private final ApplicationContext applicationContext;

    public SpringAwareUIProvider(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.detectUIs();
    }

    private void detectUIs() {
        String[] uiBeanNames;
        logger.info("Checking the application context for Vaadin UIs");
        for (String uiBeanName : uiBeanNames = this.applicationContext.getBeanNamesForAnnotation(VaadinPortletUI.class)) {
            Class beanType = this.applicationContext.getType(uiBeanName);
            if (!UI.class.isAssignableFrom(beanType)) continue;
            String uiClassName = beanType.getName();
            int endIndex = uiClassName.indexOf(36);
            if (endIndex > 0) {
                uiClassName = uiClassName.substring(0, endIndex);
            }
            logger.info("Found Vaadin UI [{}]", (Object)uiClassName);
            Class<? extends UI> existingBeanType = this.uiNameToUiClassMap.get(uiClassName);
            if (existingBeanType != null) {
                throw new IllegalStateException(String.format("[%s] is already mapped to the UI [%s]", existingBeanType.getCanonicalName(), uiClassName));
            }
            logger.debug("Mapping Vaadin UI [{}] to uiClassName [{}]", (Object)beanType.getCanonicalName(), (Object)uiClassName);
            Class uiClass = beanType;
            this.uiNameToUiClassMap.put(uiClassName, uiClass);
        }
    }

    public Class<? extends UI> getUIClass(UIClassSelectionEvent event) {
        String uiClassNameObj = event.getService().getDeploymentConfiguration().getApplicationOrSystemProperty("UI", null);
        if (uiClassNameObj instanceof String) {
            String uiClassName = uiClassNameObj.toString();
            return this.uiNameToUiClassMap.get(uiClassName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UI createInstance(UICreateEvent event) {
        Class<UIID> key = UIID.class;
        UIID identifier = new UIID(event);
        CurrentInstance.set(key, (Object)identifier);
        try {
            Class uiClass = event.getUIClass();
            logger.debug("Creating a new UI bean of class [{}] with identifier [{}]", (Object)uiClass.getCanonicalName(), (Object)identifier);
            UI uI = (UI)this.applicationContext.getBean(uiClass);
            return uI;
        }
        finally {
            CurrentInstance.set(key, null);
        }
    }
}

