/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.version.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.dbmaintainer.script.ExecutedScript;
import org.unitils.dbmaintainer.script.Script;
import org.unitils.dbmaintainer.util.BaseDatabaseAccessor;
import org.unitils.dbmaintainer.version.ExecutedScriptInfoSource;
import org.unitils.thirdparty.org.apache.commons.dbutils.DbUtils;
import org.unitils.util.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecutedScriptInfoSource
extends BaseDatabaseAccessor
implements ExecutedScriptInfoSource {
    private static Log logger = LogFactory.getLog(DefaultExecutedScriptInfoSource.class);
    public static final String PROPERTY_EXECUTED_SCRIPTS_TABLE_NAME = "dbMaintainer.executedScriptsTableName";
    public static final String PROPERTY_FILE_NAME_COLUMN_NAME = "dbMaintainer.fileNameColumnName";
    public static final String PROPERTY_FILE_NAME_COLUMN_SIZE = "dbMaintainer.fileNameColumnSize";
    public static final String PROPERTY_SCRIPT_VERSION_COLUMN_NAME = "dbMaintainer.versionColumnName";
    public static final String PROPERTY_SCRIPT_VERSION_COLUMN_SIZE = "dbMaintainer.versionColumnSize";
    public static final String PROPERTY_FILE_LAST_MODIFIED_AT_COLUMN_NAME = "dbMaintainer.fileLastModifiedAtColumnName";
    public static final String PROPERTY_CHECKSUM_COLUMN_NAME = "dbMaintainer.checksumColumnName";
    public static final String PROPERTY_CHECKSUM_COLUMN_SIZE = "dbMaintainer.checksumColumnSize";
    public static final String PROPERTY_EXECUTED_AT_COLUMN_NAME = "dbMaintainer.executedAtColumnName";
    public static final String PROPERTY_EXECUTED_AT_COLUMN_SIZE = "dbMaintainer.executedAtColumnSize";
    public static final String PROPERTY_SUCCEEDED_COLUMN_NAME = "dbMaintainer.succeededColumnName";
    public static final String PROPERTY_AUTO_CREATE_EXECUTED_SCRIPTS_TABLE = "dbMaintainer.autoCreateExecutedScriptsTable";
    public static final String PROPERTY_TIMESTAMP_FORMAT = "dbMaintainer.timestampFormat";
    protected Set<ExecutedScript> executedScripts;
    protected String executedScriptsTableName;
    protected String fileNameColumnName;
    protected int fileNameColumnSize;
    protected String versionColumnName;
    protected int versionColumnSize;
    protected String fileLastModifiedAtColumnName;
    protected String checksumColumnName;
    protected int checksumColumnSize;
    protected String executedAtColumnName;
    protected int executedAtColumnSize;
    protected String succeededColumnName;
    protected boolean autoCreateExecutedScriptsTable;
    protected DateFormat timestampFormat;

    @Override
    protected void doInit(Properties configuration) {
        this.executedScriptsTableName = this.defaultDbSupport.toCorrectCaseIdentifier(PropertyUtils.getString((String)PROPERTY_EXECUTED_SCRIPTS_TABLE_NAME, (Properties)configuration));
        this.fileNameColumnName = this.defaultDbSupport.toCorrectCaseIdentifier(PropertyUtils.getString((String)PROPERTY_FILE_NAME_COLUMN_NAME, (Properties)configuration));
        this.fileNameColumnSize = PropertyUtils.getInt((String)PROPERTY_FILE_NAME_COLUMN_SIZE, (Properties)configuration);
        this.versionColumnName = this.defaultDbSupport.toCorrectCaseIdentifier(PropertyUtils.getString((String)PROPERTY_SCRIPT_VERSION_COLUMN_NAME, (Properties)configuration));
        this.versionColumnSize = PropertyUtils.getInt((String)PROPERTY_SCRIPT_VERSION_COLUMN_SIZE, (Properties)configuration);
        this.fileLastModifiedAtColumnName = this.defaultDbSupport.toCorrectCaseIdentifier(PropertyUtils.getString((String)PROPERTY_FILE_LAST_MODIFIED_AT_COLUMN_NAME, (Properties)configuration));
        this.checksumColumnName = this.defaultDbSupport.toCorrectCaseIdentifier(PropertyUtils.getString((String)PROPERTY_CHECKSUM_COLUMN_NAME, (Properties)configuration));
        this.checksumColumnSize = PropertyUtils.getInt((String)PROPERTY_CHECKSUM_COLUMN_SIZE, (Properties)configuration);
        this.executedAtColumnName = this.defaultDbSupport.toCorrectCaseIdentifier(PropertyUtils.getString((String)PROPERTY_EXECUTED_AT_COLUMN_NAME, (Properties)configuration));
        this.executedAtColumnSize = PropertyUtils.getInt((String)PROPERTY_EXECUTED_AT_COLUMN_SIZE, (Properties)configuration);
        this.succeededColumnName = this.defaultDbSupport.toCorrectCaseIdentifier(PropertyUtils.getString((String)PROPERTY_SUCCEEDED_COLUMN_NAME, (Properties)configuration));
        this.autoCreateExecutedScriptsTable = PropertyUtils.getBoolean((String)PROPERTY_AUTO_CREATE_EXECUTED_SCRIPTS_TABLE, (Properties)configuration);
        this.timestampFormat = new SimpleDateFormat(PropertyUtils.getString((String)PROPERTY_TIMESTAMP_FORMAT, (Properties)configuration));
    }

    @Override
    public boolean isFromScratchUpdateRecommended() {
        return !this.isExecutedScriptsTableValid() && this.autoCreateExecutedScriptsTable;
    }

    @Override
    public Set<ExecutedScript> getExecutedScripts() {
        try {
            return this.doGetExecutedScripts();
        }
        catch (UnitilsException e) {
            if (this.checkExecutedScriptsTable()) {
                throw e;
            }
            return this.doGetExecutedScripts();
        }
    }

    protected Set<ExecutedScript> doGetExecutedScripts() {
        if (this.executedScripts == null) {
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            try {
                conn = this.sqlHandler.getDataSource().getConnection();
                st = conn.createStatement();
                rs = st.executeQuery("select " + this.fileNameColumnName + ", " + this.versionColumnName + ", " + this.fileLastModifiedAtColumnName + ", " + this.checksumColumnName + ", " + this.executedAtColumnName + ", " + this.succeededColumnName + " from " + this.defaultDbSupport.qualified(this.executedScriptsTableName));
                this.executedScripts = new HashSet<ExecutedScript>();
                while (rs.next()) {
                    String fileName = rs.getString(this.fileNameColumnName);
                    String checkSum = rs.getString(this.checksumColumnName);
                    Long fileLastModifiedAt = rs.getLong(this.fileLastModifiedAtColumnName);
                    Date executedAt = null;
                    try {
                        executedAt = this.timestampFormat.parse(rs.getString(this.executedAtColumnName));
                    }
                    catch (ParseException e) {
                        throw new UnitilsException("Error when parsing date " + executedAt + " using format " + this.timestampFormat, (Throwable)e);
                    }
                    Boolean succeeded = rs.getInt(this.succeededColumnName) == 1 ? Boolean.TRUE : Boolean.FALSE;
                    ExecutedScript executedScript = new ExecutedScript(new Script(fileName, fileLastModifiedAt, checkSum), executedAt, succeeded);
                    this.executedScripts.add(executedScript);
                }
            }
            catch (SQLException e) {
                try {
                    throw new UnitilsException("Error while retrieving database version", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly((Connection)conn, st, rs);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly((Connection)conn, (Statement)st, (ResultSet)rs);
        }
        return this.executedScripts;
    }

    @Override
    public void registerExecutedScript(ExecutedScript executedScript) {
        try {
            this.doRegisterExecutedScript(executedScript);
        }
        catch (UnitilsException e) {
            if (this.checkExecutedScriptsTable()) {
                throw e;
            }
            this.doRegisterExecutedScript(executedScript);
        }
    }

    protected void doRegisterExecutedScript(ExecutedScript executedScript) {
        if (this.getExecutedScripts().contains(executedScript)) {
            this.doUpdateExecutedScript(executedScript);
        } else {
            this.doSaveExecutedScript(executedScript);
        }
    }

    @Override
    public void updateExecutedScript(ExecutedScript executedScript) {
        try {
            this.doUpdateExecutedScript(executedScript);
        }
        catch (UnitilsException e) {
            if (this.checkExecutedScriptsTable()) {
                throw e;
            }
            this.doUpdateExecutedScript(executedScript);
        }
    }

    protected void doSaveExecutedScript(ExecutedScript executedScript) {
        this.executedScripts.add(executedScript);
        String executedAt = this.timestampFormat.format(executedScript.getExecutedAt());
        String insertSql = "insert into " + this.defaultDbSupport.qualified(this.executedScriptsTableName) + " (" + this.fileNameColumnName + ", " + this.versionColumnName + ", " + this.fileLastModifiedAtColumnName + ", " + this.checksumColumnName + ", " + this.executedAtColumnName + ", " + this.succeededColumnName + ") values ('" + executedScript.getScript().getFileName() + "', '" + executedScript.getScript().getVersion().getIndexesString() + "', " + executedScript.getScript().getFileLastModifiedAt() + ", '" + executedScript.getScript().getCheckSum() + "', '" + executedAt + "', " + (executedScript.isSucceeded() != false ? "1" : "0") + ")";
        this.sqlHandler.executeUpdateAndCommit(insertSql);
    }

    protected void doUpdateExecutedScript(ExecutedScript executedScript) {
        this.executedScripts.add(executedScript);
        String executedAt = this.timestampFormat.format(executedScript.getExecutedAt());
        String updateSql = "update " + this.defaultDbSupport.qualified(this.executedScriptsTableName) + " set " + this.checksumColumnName + " = '" + executedScript.getScript().getCheckSum() + "', " + this.fileLastModifiedAtColumnName + " = " + executedScript.getScript().getFileLastModifiedAt() + ", " + this.executedAtColumnName + " = '" + executedAt + "', " + this.succeededColumnName + " = " + (executedScript.isSucceeded() != false ? "1" : "0") + " where " + this.fileNameColumnName + " = '" + executedScript.getScript().getFileName() + "'";
        this.sqlHandler.executeUpdateAndCommit(updateSql);
    }

    @Override
    public void clearAllExecutedScripts() {
        try {
            this.doClearAllExecutedScripts();
        }
        catch (UnitilsException e) {
            if (this.checkExecutedScriptsTable()) {
                throw e;
            }
            this.doClearAllExecutedScripts();
        }
    }

    protected void doClearAllExecutedScripts() {
        this.executedScripts = new HashSet<ExecutedScript>();
        String deleteSql = "delete from " + this.defaultDbSupport.qualified(this.executedScriptsTableName);
        this.sqlHandler.executeUpdateAndCommit(deleteSql);
    }

    protected boolean checkExecutedScriptsTable() {
        if (this.isExecutedScriptsTableValid()) {
            return true;
        }
        if (this.autoCreateExecutedScriptsTable) {
            logger.warn((Object)("Executed scripts table " + this.defaultDbSupport.qualified(this.executedScriptsTableName) + " doesn't exist yet or is invalid. A new one is created automatically."));
            this.createExecutedScriptsTable();
            return false;
        }
        String message = "Executed scripts table " + this.defaultDbSupport.qualified(this.executedScriptsTableName) + " doesn't exist yet or is invalid.\n";
        message = message + "Please create it manually or let Unitils create it automatically by setting the dbMaintainer.autoCreateExecutedScriptsTable property to true.\n";
        message = message + "The table can be created manually by executing following statement:\n";
        message = message + this.getCreateExecutedScriptsTableStatement();
        throw new UnitilsException(message);
    }

    protected boolean isExecutedScriptsTableValid() {
        Set columnNames;
        Set tableNames = this.defaultDbSupport.getTableNames();
        return tableNames.contains(this.executedScriptsTableName) && (columnNames = this.defaultDbSupport.getColumnNames(this.executedScriptsTableName)).contains(this.fileNameColumnName) && columnNames.contains(this.versionColumnName) && columnNames.contains(this.fileLastModifiedAtColumnName) && columnNames.contains(this.checksumColumnName) && columnNames.contains(this.executedAtColumnName) && columnNames.contains(this.succeededColumnName);
    }

    protected void createExecutedScriptsTable() {
        try {
            this.defaultDbSupport.dropTable(this.executedScriptsTableName);
        }
        catch (UnitilsException unitilsException) {
            // empty catch block
        }
        this.sqlHandler.executeUpdateAndCommit(this.getCreateExecutedScriptsTableStatement());
    }

    protected String getCreateExecutedScriptsTableStatement() {
        String longDataType = this.defaultDbSupport.getLongDataType();
        return "create table " + this.defaultDbSupport.qualified(this.executedScriptsTableName) + " ( " + this.fileNameColumnName + " " + this.defaultDbSupport.getTextDataType(this.fileNameColumnSize) + ", " + this.versionColumnName + " " + this.defaultDbSupport.getTextDataType(this.versionColumnSize) + ", " + this.fileLastModifiedAtColumnName + " " + this.defaultDbSupport.getLongDataType() + ", " + this.checksumColumnName + " " + this.defaultDbSupport.getTextDataType(this.checksumColumnSize) + ", " + this.executedAtColumnName + " " + this.defaultDbSupport.getTextDataType(this.executedAtColumnSize) + ", " + this.succeededColumnName + " " + longDataType + " )";
    }
}

