/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.jtar;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class PermissionUtils {
    public static int permissions(File f) {
        if (f == null) {
            throw new NullPointerException("File is null.");
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("File " + f + " does not exist.");
        }
        return PermissionUtils.standardPermissions(f);
    }

    private static Set<StandardFilePermission> readStandardPermissions(File f) {
        HashSet<StandardFilePermission> permissions = new HashSet<StandardFilePermission>();
        if (f.canExecute()) {
            permissions.add(StandardFilePermission.EXECUTE);
        }
        if (f.canWrite()) {
            permissions.add(StandardFilePermission.WRITE);
        }
        if (f.canRead()) {
            permissions.add(StandardFilePermission.READ);
        }
        return permissions;
    }

    private static Integer standardPermissions(File f) {
        int number = 0;
        Set<StandardFilePermission> permissions = PermissionUtils.readStandardPermissions(f);
        for (StandardFilePermission permission : permissions) {
            number += permission.mode;
        }
        return number;
    }

    private static enum StandardFilePermission {
        EXECUTE(72),
        WRITE(144),
        READ(288);

        private int mode;

        private StandardFilePermission(int mode) {
            this.mode = mode;
        }
    }
}

