/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.resourcecontainer;

import org.json.JSONException;
import org.json.JSONObject;

public class Project {
    public final String slug;
    public final String name;
    public final int sort;
    public String icon = "";
    public String chunksUrl = "";
    public String description = "";
    public String languageSlug = "";

    public Project(String slug, String name, int sort) {
        this.slug = slug;
        this.name = name;
        this.sort = sort;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("slug", (Object)this.slug);
        json.put("name", (Object)this.name);
        json.put("sort", this.sort);
        json.put("desc", (Object)Project.deNull(this.description));
        json.put("icon", (Object)Project.deNull(this.icon));
        json.put("chunks_url", (Object)Project.deNull(this.chunksUrl));
        return json;
    }

    private static String deNull(String value) {
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static Project fromJSON(JSONObject json) throws JSONException {
        if (!json.has("slug")) {
            throw new JSONException("Missing project field: slug");
        }
        if (!json.has("name")) {
            throw new JSONException("Missing project field: name");
        }
        if (!json.has("sort")) {
            throw new JSONException("Missing project field: sort");
        }
        if (json == null) {
            throw new JSONException("Invalid json");
        }
        Project p = new Project(json.getString("slug"), json.getString("name"), json.getInt("sort"));
        if (json.has("icon")) {
            p.icon = Project.deNull(json.getString("icon"));
        }
        if (json.has("chunks_url")) {
            p.chunksUrl = Project.deNull(json.getString("chunks_url"));
        }
        if (json.has("desc")) {
            p.description = Project.deNull(json.getString("desc"));
        }
        return p;
    }
}

