/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.resourcecontainer;

import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class Language
implements Comparable {
    public final String slug;
    public final String name;
    public final String direction;

    public Language(String slug, String name, String direction) {
        this.slug = slug;
        this.name = name;
        this.direction = direction;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("slug", (Object)this.slug);
        json.put("name", (Object)this.name);
        json.put("direction", (Object)this.direction);
        return json;
    }

    public int compareTo(Object object) {
        String slug2;
        if (object instanceof String) {
            slug2 = (String)object;
        } else if (object instanceof Language) {
            slug2 = ((Language)object).slug;
        } else {
            if (object == null) {
                return 1;
            }
            Log.w((String)"Language", (String)("Unexpected comparable: " + object.toString()));
            return 1;
        }
        return this.slug.compareToIgnoreCase(slug2);
    }

    public static Language fromJSON(JSONObject json) throws JSONException {
        if (json == null) {
            throw new JSONException("Invalid json");
        }
        if (!json.has("slug")) {
            throw new JSONException("Missing language field: slug");
        }
        if (!json.has("name")) {
            throw new JSONException("Missing language field: name");
        }
        if (!json.has("direction")) {
            throw new JSONException("Missing language field: direction");
        }
        return new Language(json.getString("slug"), json.getString("name"), json.getString("direction"));
    }
}

