/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.resourcecontainer;

import com.esotericsoftware.yamlbeans.YamlWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;
import org.unfoldingword.resourcecontainer.FileUtil;
import org.unfoldingword.resourcecontainer.ResourceContainer;

public class ContainerTools {
    public static JSONObject inspect(File containerPath) throws Exception {
        ResourceContainer container;
        if (!containerPath.exists()) {
            throw new Exception("The resource container does not exist at " + containerPath.getAbsolutePath());
        }
        if (containerPath.isFile()) {
            String[] nameArray = containerPath.getName().split("\\.");
            String ext = nameArray[nameArray.length - 1];
            if (!ext.equals("tsrc")) {
                throw new Exception("Invalid resource container file extension");
            }
            nameArray[nameArray.length - 1] = "";
            File containerDir = new File(containerPath.getParentFile(), containerPath.getName() + ".inspect.tmp");
            container = ResourceContainer.open(containerPath, containerDir);
            FileUtil.deleteQuietly(containerDir);
        } else {
            container = ResourceContainer.load(containerPath);
        }
        return container.info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceContainer convertResource(String data, File directory, JSONObject props) throws Exception {
        if (!(props.has("language") && props.has("project") && props.has("resource") && props.getJSONObject("resource").has("type"))) {
            throw new Exception("Missing required parameters");
        }
        JSONObject project = props.getJSONObject("project");
        JSONObject language = props.getJSONObject("language");
        JSONObject resource = props.getJSONObject("resource");
        String mimeType = !project.getString("slug").equals("obs") && resource.getString("type").equals("book") ? "text/usfm" : "text/markdown";
        String chunkExt = mimeType.equals("text/usfm") ? "usfm" : "md";
        File containerArchive = new File(directory.getParentFile(), directory.getName() + "." + "tsrc");
        if (containerArchive.exists()) {
            throw new Exception("Resource container already exists");
        }
        try {
            JSONObject chapter;
            int c;
            JSONObject json;
            FileUtil.deleteQuietly(directory);
            directory.mkdirs();
            JSONObject packageData = new JSONObject();
            packageData.put("package_version", (Object)"0.1");
            packageData.put("modified_at", props.get("modified_at"));
            packageData.put("content_mime_type", (Object)mimeType);
            packageData.put("language", (Object)language);
            packageData.put("project", (Object)project);
            packageData.put("resource", (Object)resource);
            packageData.put("chunk_status", (Object)new JSONArray());
            FileUtil.writeStringToFile(new File(directory, "package.json"), packageData.toString(2).replace("\\", ""));
            FileUtil.writeStringToFile(new File(directory, "LICENSE.md"), resource.getJSONObject("status").getString("license"));
            File contentDir = new File(directory, "content");
            contentDir.mkdirs();
            HashMap config = new HashMap();
            ArrayList toc = new ArrayList();
            File frontDir = new File(contentDir, "front");
            frontDir.mkdirs();
            FileUtil.writeStringToFile(new File(frontDir, "title." + chunkExt), project.getString("name"));
            HashMap<String, Object> frontToc = new HashMap<String, Object>();
            frontToc.put("chapter", "title");
            frontToc.put("chunks", new String[]{"title"});
            toc.add(frontToc);
            if (resource.getString("type").equals("book")) {
                json = new JSONObject(data);
                config.put("content", new HashMap());
                if (project.getString("slug").equals("obs")) {
                    HashMap<String, Object> mediaConfig = new HashMap<String, Object>();
                    mediaConfig.put("mime_type", "image/jpg");
                    mediaConfig.put("size", 37620940);
                    mediaConfig.put("url", "https://api.unfoldingword.org/obs/jpg/1/en/obs-images-360px.zip");
                    config.put("media", mediaConfig);
                }
                for (c = 0; c < json.getJSONArray("chapters").length(); ++c) {
                    chapter = json.getJSONArray("chapters").getJSONObject(c);
                    HashMap chapterConfig = new HashMap();
                    HashMap<String, Object> chapterTOC = new HashMap<String, Object>();
                    chapterTOC.put("chapter", chapter.getString("number"));
                    chapterTOC.put("chunks", new ArrayList());
                    File chapterDir = new File(contentDir, chapter.getString("number"));
                    chapterDir.mkdirs();
                    if (chapter.has("title") && !chapter.getString("title").isEmpty()) {
                        ((List)chapterTOC.get("chunks")).add("title");
                        FileUtil.writeStringToFile(new File(chapterDir, "title." + chunkExt), chapter.getString("title"));
                    }
                    for (int f = 0; f < chapter.getJSONArray("frames").length(); ++f) {
                        Pattern versePattern;
                        Matcher match;
                        JSONObject frame = chapter.getJSONArray("frames").getJSONObject(f);
                        String frameSlug = frame.getString("id").split("-")[1].trim();
                        if (frameSlug.equals("00") && (match = (versePattern = Pattern.compile("/<verse\\s+number=\"(\\d+(-\\d+)?)\"\\s+style=\"v\"\\s*\\/>/")).matcher(frame.getString("text"))).matches()) {
                            String firstVerseRange = match.group(3);
                            frameSlug = firstVerseRange.split("-")[0];
                        }
                        ArrayList questions = new ArrayList();
                        ArrayList notes = new ArrayList();
                        ArrayList images = new ArrayList();
                        ArrayList<Object> words = new ArrayList<Object>();
                        if (props.has("tw_assignments")) {
                            try {
                                JSONArray slugs = props.getJSONObject("tw_assignments").getJSONObject(chapter.getString("number")).getJSONArray(frameSlug);
                                for (int s = 0; s < slugs.length(); ++s) {
                                    words.add(slugs.get(s));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (questions.size() > 0 || notes.size() > 0 || images.size() > 0 || words.size() > 0) {
                            chapterConfig.put(frameSlug, new HashMap());
                        }
                        if (questions.size() > 0) {
                            ((HashMap)chapterConfig.get(frameSlug)).put("questions", questions);
                        }
                        if (notes.size() > 0) {
                            ((HashMap)chapterConfig.get(frameSlug)).put("notes", notes);
                        }
                        if (images.size() > 0) {
                            ((HashMap)chapterConfig.get(frameSlug)).put("images", images);
                        }
                        if (words.size() > 0) {
                            ((HashMap)chapterConfig.get(frameSlug)).put("words", words);
                        }
                        ((List)chapterTOC.get("chunks")).add(frameSlug);
                        FileUtil.writeStringToFile(new File(chapterDir, frameSlug + "." + chunkExt), frame.getString("text"));
                    }
                    if (chapter.has("ref") && !chapter.getString("ref").isEmpty()) {
                        ((List)chapterTOC.get("chunks")).add("reference");
                        FileUtil.writeStringToFile(new File(chapterDir, "title." + chunkExt), chapter.getString("title"));
                    }
                    if (chapterConfig.size() > 0) {
                        ((Map)config.get("content")).put(chapter.getString("number"), chapterConfig);
                    }
                    toc.add(chapterTOC);
                }
            } else if (resource.getString("type").equals("help")) {
                json = new JSONArray(data);
                if (resource.getString("slug").equals("tn")) {
                    for (c = 0; c < json.length(); ++c) {
                        String[] slugs;
                        JSONObject chunk = json.getJSONObject(c);
                        if (!chunk.has("tn") || (slugs = chunk.getString("id").split("-")).length != 2) continue;
                        File chapterDir = new File(contentDir, slugs[0]);
                        chapterDir.mkdirs();
                        String body = "";
                        for (int n = 0; n < chunk.getJSONArray("tn").length(); ++n) {
                            JSONObject note = chunk.getJSONArray("tn").getJSONObject(n);
                            body = body + "\n\n#" + note.getString("ref") + "\n\n" + note.getString("text");
                        }
                        FileUtil.writeStringToFile(new File(chapterDir, slugs[1] + "." + chunkExt), body.trim());
                    }
                } else {
                    if (!resource.getString("slug").equals("tq")) throw new Exception("Unsupported resource " + resource.getString("slug"));
                    for (c = 0; c < json.length(); ++c) {
                        chapter = json.getJSONObject(c);
                        if (!chapter.has("cq")) continue;
                        File chapterDir = new File(contentDir, chapter.getString("id"));
                        chapterDir.mkdirs();
                        HashMap<String, String> normalizedChunks = new HashMap<String, String>();
                        for (int q = 0; q < chapter.getJSONArray("cq").length(); ++q) {
                            JSONObject question = chapter.getJSONArray("cq").getJSONObject(q);
                            String text = "\n\n#" + question.getString("q") + "\n\n" + question.getString("q");
                            for (int s = 0; s < question.getJSONArray("ref").length(); ++s) {
                                String[] slugs = question.getJSONArray("ref").getString(s).split("-");
                                if (slugs.length != 2) continue;
                                String old = (String)normalizedChunks.get(slugs[1]);
                                normalizedChunks.put(slugs[1], (old != null ? old : "") + text);
                            }
                        }
                        for (String key : normalizedChunks.keySet()) {
                            FileUtil.writeStringToFile(new File(chapterDir, key + "." + chunkExt), ((String)normalizedChunks.get(key)).trim());
                        }
                    }
                }
            } else if (resource.getString("type").equals("dict")) {
                json = new JSONArray(data);
                for (int w = 0; w < json.length(); ++w) {
                    int i;
                    JSONObject word = json.getJSONObject(w);
                    if (!word.has("id")) continue;
                    File wordDir = new File(contentDir, word.getString("id"));
                    wordDir.mkdirs();
                    String body = "#" + word.getString("term") + "\n\n" + word.getString("def");
                    FileUtil.writeStringToFile(new File(wordDir, "01." + chunkExt), body);
                    if (!ContainerTools.JSONHasLength(word, "aliases") && !ContainerTools.JSONHasLength(word, "cf") && !ContainerTools.JSONHasLength(word, "ex")) continue;
                    HashMap wordConfig = new HashMap();
                    if (ContainerTools.JSONHasLength(word, "cf")) {
                        wordConfig.put("see_also", new ArrayList());
                        for (i = 0; i < word.getJSONArray("cf").length(); ++i) {
                            ((List)wordConfig.get("see_also")).add(word.getJSONArray("cf").get(i));
                        }
                    }
                    if (ContainerTools.JSONHasLength(word, "aliases")) {
                        wordConfig.put("aliases", new ArrayList());
                        for (i = 0; i < word.getJSONArray("aliases").length(); ++i) {
                            ((List)wordConfig.get("aliases")).add(word.getJSONArray("aliases").get(i));
                        }
                    }
                    if (ContainerTools.JSONHasLength(word, "ex")) {
                        wordConfig.put("examples", new ArrayList());
                        for (i = 0; i < word.getJSONArray("ex").length(); ++i) {
                            ((List)wordConfig.get("examples")).add(word.getJSONArray("ex").get(i));
                        }
                    }
                    config.put(word.getString("id"), wordConfig);
                }
            } else {
                if (!resource.getString("type").equals("man")) throw new Exception("Unsupported resource container type " + resource.getString("type"));
                json = new JSONObject(data);
                for (int a = 0; a < json.getJSONArray("articles").length(); ++a) {
                    JSONObject article = json.getJSONArray("articles").getJSONObject(a);
                    HashMap articleConfig = new HashMap();
                    ArrayList<String> recommended = new ArrayList<String>();
                    ArrayList<String> dependencies = new ArrayList<String>();
                    String slug = article.getString("id").replaceAll("\\_", "-");
                    if (article.has("recommend") && !article.isNull("recommend")) {
                        for (int i = 0; i < article.getJSONArray("recommend").length(); ++i) {
                            recommended.add(article.getJSONArray("recommend").getString(i).replaceAll("\\_", "-"));
                        }
                    }
                    if (article.has("depend") && !article.isNull("depend")) {
                        for (int i = 0; i < article.getJSONArray("depend").length(); ++i) {
                            dependencies.add(article.getJSONArray("depend").getString(i).replaceAll("\\_", "-"));
                        }
                    }
                    File articleDir = new File(contentDir, slug);
                    articleDir.mkdirs();
                    FileUtil.writeStringToFile(new File(articleDir, "title." + chunkExt), article.getString("title"));
                    FileUtil.writeStringToFile(new File(articleDir, "sub-title." + chunkExt), article.getString("question"));
                    FileUtil.writeStringToFile(new File(articleDir, "01." + chunkExt), article.getString("text"));
                    if (recommended.size() <= 0 && dependencies.size() <= 0) continue;
                    articleConfig.put("recommended", recommended);
                    articleConfig.put("dependencies", dependencies);
                    config.put(slug, articleConfig);
                }
            }
            try (YamlWriter configWriter = null;){
                configWriter = new YamlWriter((Writer)new FileWriter(new File(contentDir, "config.yml")));
                configWriter.write(config);
            }
            try (YamlWriter tocWriter = null;){
                tocWriter = new YamlWriter((Writer)new FileWriter(new File(contentDir, "toc.yml")));
                tocWriter.write(toc);
                return ResourceContainer.load(directory);
            }
        }
        catch (Exception e) {
            FileUtil.deleteQuietly(directory);
            throw e;
        }
    }

    private static boolean JSONHasLength(JSONObject json, String key) {
        try {
            return json.has(key) && json.optJSONArray(key) != null && json.getJSONArray(key).length() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String makeSlug(String languageSlug, String projectSlug, String resourceSlug) {
        if (languageSlug == null || languageSlug.isEmpty() || projectSlug == null || projectSlug.isEmpty() || resourceSlug == null || resourceSlug.isEmpty()) {
            throw new InvalidParameterException("Invalid resource container slug parameters");
        }
        return languageSlug + "_" + projectSlug + "_" + resourceSlug;
    }

    public static String mimeToType(String mimeType) {
        return mimeType.split("\\+")[1];
    }

    public static String typeToMime(String resourceType) {
        return "application/tsrc+" + resourceType;
    }
}

